# `atuin search`

```
atuin search <query>
```

Поиск в Atuin также поддерживает wildcards со знаками `*` или `%`.
По умолчанию, должен быть указан префикс (т.е. все запросы автоматически дополняются wildcard -ами)


| Аргумент           | Описание                                                                                    |
|--------------------|---------------------------------------------------------------------------------------------|
| `--cwd/-c`         | Каталог, для которого отображается история (по умолчанию, все каталоги))                    |
| `--exclude-cwd`    | Исключить команды которые запускались в этом каталоге (по умолчанию none)                   |
| `--exit/-e`        | Фильтровать по exit code (по умолчанию none)                                                |
| `--exclude-exit`   | Исключить команды, которые завершились с указанным значением (по умолчанию none)            |
| `--before`         | Включить только команды, которые были запущены до указанного времени (по умолчанию none)    |
| `--after`          | Включить только команды, которые были запущены после указанного времени (по умолчанию none) |
| `--interactive/-i` | Открыть интерактивный поисковой графический интерфейс (по умолчанию false)                  |
| `--human/-h`       | Использовать читаемое формавтирование для времени и периодов времени (по умолчанию false)   |

## Примеры

```
# Начать интерактивный поиск с текстовым пользовательским интерфейсом
atuin search -i

# Начать интерактивный поиск с текстовым пользовательским интерфейсом и уже введённым запросом
atuin search -i atuin

# Искать по всем командам, начиная с cargo, которые успешно завершились
atuin search --exit 0 cargo

# Искать по всем командам которые завершились ошибками и были вызваны в текущей папке и были запущены до первого апреля 2021
atuin search --exclude-exit 0 --before 01/04/2021 --cwd .

# Искать по всем командам, начиная с cargo, которые успешно завершились и были запущены после трёх часо дня вчера
atuin search --exit 0 --after "yesterday 3pm" cargo
```
