/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public abstract class Vm {
    public abstract VmType type();

    public abstract VmConfig config();

    public abstract String classpath();

    public final String name() {
        return this.config().name();
    }

    public final Optional<String> home() {
        return this.config().home();
    }

    public abstract String executable();

    public final ImmutableList<String> args(Iterable<String> ... additionalArgs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.config().args());
        for (Iterable<String> args : additionalArgs) {
            builder.addAll(args);
        }
        builder.addAll(this.classpathArgs());
        builder.addAll(this.lastArgs());
        return builder.build();
    }

    public abstract ImmutableSet<String> trialArgs();

    protected abstract ImmutableList<String> classpathArgs();

    protected abstract ImmutableList<String> lastArgs();

    public abstract Predicate<String> vmPropertiesToRetain();

    public final String toString() {
        return this.name();
    }
}

