/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Method returns a definitely null value but is not annotated @Nullable", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ReturnMissingNullable
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<StatementTree> METHODS_THAT_NEVER_RETURN = Matchers.expressionStatement((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.anyMethod().anyClass().withNameMatching(Pattern.compile("throw.*Exception")), Matchers.staticMethod().onDescendantOfAny(new String[]{"org.junit.Assert", "junit.framework.Assert"}).named("fail"), Matchers.staticMethod().onClass("java.lang.System").named("exit")}));
    private static final Matcher<StatementTree> FAILS_IF_PASSED_FALSE = Matchers.expressionStatement((Matcher)Matchers.staticMethod().onClassAny(new String[]{"com.google.common.base.Preconditions", "com.google.common.base.Verify"}).namedAnyOf(new String[]{"checkArgument", "checkState", "verify"}));
    private static final Supplier<ImmutableSet<Symbol.MethodSymbol>> METHODS_KNOWN_TO_RETURN_NULL = VisitorState.memoize((Supplier & Serializable)state -> (ImmutableSet)Streams.concat((Stream[])new Stream[]{ReturnMissingNullable.streamElements(state, "java.util.Map").filter(m -> ReturnMissingNullable.hasName(m, "get") || ReturnMissingNullable.hasName(m, "put") || ReturnMissingNullable.hasName(m, "putIfAbsent") || ReturnMissingNullable.hasName(m, "remove") && ReturnMissingNullable.hasParams(m, 1) || ReturnMissingNullable.hasName(m, "replace") && ReturnMissingNullable.hasParams(m, 2)), ReturnMissingNullable.streamElements(state, "com.google.common.collect.BiMap").filter(m -> ReturnMissingNullable.hasName(m, "forcePut")), ReturnMissingNullable.streamElements(state, "com.google.common.collect.Table").filter(m -> ReturnMissingNullable.hasName(m, "get") || ReturnMissingNullable.hasName(m, "put") || ReturnMissingNullable.hasName(m, "remove")), ReturnMissingNullable.streamElements(state, "com.google.common.cache.Cache").filter(m -> ReturnMissingNullable.hasName(m, "getIfPresent")), ReturnMissingNullable.streamElements(state, "java.util.Queue").filter(m -> ReturnMissingNullable.hasName(m, "poll") || ReturnMissingNullable.hasName(m, "peek")), ReturnMissingNullable.streamElements(state, "java.util.Deque").filter(m -> ReturnMissingNullable.hasName(m, "pollFirst") || ReturnMissingNullable.hasName(m, "peekFirst") || ReturnMissingNullable.hasName(m, "pollLast") || ReturnMissingNullable.hasName(m, "peekLast")), ReturnMissingNullable.streamElements(state, "java.util.NavigableSet").filter(m -> ReturnMissingNullable.hasName(m, "lower") || ReturnMissingNullable.hasName(m, "floor") || ReturnMissingNullable.hasName(m, "ceiling") || ReturnMissingNullable.hasName(m, "higher") || ReturnMissingNullable.hasName(m, "pollFirst") || ReturnMissingNullable.hasName(m, "pollLast")), ReturnMissingNullable.streamElements(state, "java.util.NavigableMap").filter(m -> ReturnMissingNullable.hasName(m, "lowerEntry") || ReturnMissingNullable.hasName(m, "floorEntry") || ReturnMissingNullable.hasName(m, "ceilingEntry") || ReturnMissingNullable.hasName(m, "higherEntry") || ReturnMissingNullable.hasName(m, "lowerKey") || ReturnMissingNullable.hasName(m, "floorKey") || ReturnMissingNullable.hasName(m, "ceilingKey") || ReturnMissingNullable.hasName(m, "higherKey") || ReturnMissingNullable.hasName(m, "firstEntry") || ReturnMissingNullable.hasName(m, "lastEntry") || ReturnMissingNullable.hasName(m, "pollFirstEntry") || ReturnMissingNullable.hasName(m, "pollLastEntry")), ReturnMissingNullable.streamElements(state, "java.util.Spliterator").filter(m -> ReturnMissingNullable.hasName(m, "trySplit"))}).map(Symbol.MethodSymbol.class::cast).collect(ImmutableSet.toImmutableSet()));
    private final boolean beingConservative;

    @Inject
    ReturnMissingNullable(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState stateForCompilationUnit) {
        if (this.beingConservative && stateForCompilationUnit.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        final ImmutableSet.Builder definitelyNullVarsBuilder = ImmutableSet.builder();
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ ReturnMissingNullable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                this.doVisitVariable(tree);
                return (Void)super.visitVariable(tree, null);
            }

            void doVisitVariable(VariableTree tree) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
                if (!ASTHelpers.isConsideredFinal((Symbol)symbol)) {
                    return;
                }
                ExpressionTree initializer = tree.getInitializer();
                if (initializer == null) {
                    return;
                }
                if (initializer.getKind() != Tree.Kind.NULL_LITERAL) {
                    return;
                }
                definitelyNullVarsBuilder.add((Object)symbol);
            }
        }.scan(tree, null);
        final ImmutableSet definitelyNullVars = definitelyNullVarsBuilder.build();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, stateForCompilationUnit){
            final /* synthetic */ ReturnMissingNullable this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitBlock(BlockTree block, Void unused) {
                StatementTree statement;
                Iterator<? extends StatementTree> iterator = block.getStatements().iterator();
                while (!(!iterator.hasNext() || METHODS_THAT_NEVER_RETURN.matches((Tree)(statement = iterator.next()), stateForCompilationUnit) || FAILS_IF_PASSED_FALSE.matches((Tree)statement, stateForCompilationUnit) && ASTHelpers.constValue((Tree)((MethodInvocationTree)((ExpressionStatementTree)statement).getExpression()).getArguments().get(0)) == Boolean.FALSE)) {
                    this.scan(statement, null);
                }
                return null;
            }

            public Void visitMethod(MethodTree tree, Void unused) {
                this.doVisitMethod(tree);
                return (Void)super.visitMethod(tree, null);
            }

            void doVisitMethod(MethodTree tree) {
                if (this.this$0.beingConservative) {
                    return;
                }
                Symbol.MethodSymbol possibleOverride = ASTHelpers.getSymbol((MethodTree)tree);
                if (NullnessUtils.isAlreadyAnnotatedNullable(possibleOverride)) {
                    return;
                }
                if (tree.getBody() != null && tree.getBody().getStatements().size() == 1 && ((StatementTree)Iterables.getOnlyElement(tree.getBody().getStatements())).getKind() == Tree.Kind.THROW) {
                    return;
                }
                if (ASTHelpers.hasAnnotation((Tree)tree, (String)"com.google.errorprone.annotations.DoNotCall", (VisitorState)stateForCompilationUnit)) {
                    return;
                }
                for (Symbol.MethodSymbol methodKnownToReturnNull : (ImmutableSet)METHODS_KNOWN_TO_RETURN_NULL.get(stateForCompilationUnit)) {
                    SuggestedFix fix;
                    if (!stateForCompilationUnit.getElements().overrides(possibleOverride, methodKnownToReturnNull, possibleOverride.enclClass()) || (fix = NullnessUtils.fixByAddingNullableAnnotationToReturnType(stateForCompilationUnit.withPath(this.getCurrentPath()), tree)).isEmpty()) continue;
                    stateForCompilationUnit.reportMatch(this.this$0.buildDescription(tree).setMessage("Nearly all implementations of this method must return null, but it is not annotated @Nullable").addFix((Fix)fix).build());
                }
            }

            public Void visitReturn(ReturnTree tree, Void unused) {
                this.doVisitReturn(tree);
                return (Void)super.visitReturn(tree, null);
            }

            void doVisitReturn(ReturnTree returnTree) {
                SuggestedFix fix;
                VisitorState state = stateForCompilationUnit.withPath(this.getCurrentPath());
                ExpressionTree returnExpression = returnTree.getExpression();
                if (returnExpression == null) {
                    return;
                }
                MethodTree methodTree = ASTHelpers.findEnclosingMethod((VisitorState)state);
                if (methodTree == null) {
                    return;
                }
                Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)methodTree);
                java.util.List<? extends StatementTree> statements = methodTree.getBody().getStatements();
                if (this.this$0.beingConservative && statements.size() == 1 && Iterables.getOnlyElement(statements) == returnTree && returnExpression.getKind() == Tree.Kind.NULL_LITERAL && ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)method)) {
                    return;
                }
                Type returnType = method.getReturnType();
                if (this.this$0.beingConservative && NullnessUtils.isVoid(returnType, state)) {
                    return;
                }
                if (returnType.isPrimitive()) {
                    return;
                }
                if (this.this$0.beingConservative && returnType.getKind() == TypeKind.TYPEVAR) {
                    return;
                }
                if (NullnessUtils.isAlreadyAnnotatedNullable(method)) {
                    return;
                }
                ImmutableSet<Name> varsProvenNullByParentIf = NullnessUtils.varsProvenNullByParentIf(this.getCurrentPath());
                if (NullnessUtils.hasDefinitelyNullBranch(returnExpression, (Set<Symbol.VarSymbol>)definitelyNullVars, varsProvenNullByParentIf, stateForCompilationUnit) && !(fix = NullnessUtils.fixByAddingNullableAnnotationToReturnType(state.withPath(this.getCurrentPath()), methodTree)).isEmpty()) {
                    state.reportMatch(this.this$0.describeMatch(returnTree, (Fix)fix));
                }
            }
        }.scan((Tree)tree, null);
        return Description.NO_MATCH;
    }

    private static boolean hasName(Symbol symbol, String name) {
        return symbol.name.contentEquals(name);
    }

    private static boolean hasParams(Symbol method, int paramCount) {
        return ((List)((Symbol.MethodSymbol)method).getParameters()).size() == paramCount;
    }

    private static Stream<Symbol> streamElements(VisitorState state, String clazz) {
        Symbol symbol = state.getSymbolFromString(clazz);
        return symbol == null ? Stream.empty() : symbol.getEnclosedElements().stream();
    }
}

