/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Variables which are initialized and do not escape the current scope do not need to worry about concurrency. Using the non-concurrent type will reduce overhead and verbosity.")
public final class UnnecessaryAsync
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_SYNCHRONIZED_THING = Matchers.anyOf((Iterable)((Iterable)Stream.of("java.util.concurrent.atomic.AtomicBoolean", "java.util.concurrent.atomic.AtomicReference", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong", "java.util.concurrent.ConcurrentHashMap").map(x -> Matchers.constructor().forClass(x)).collect(ImmutableList.toImmutableList())));

    public Description matchVariable(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!symbol.getKind().equals((Object)ElementKind.LOCAL_VARIABLE) || !ASTHelpers.isConsideredFinal((Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        ExpressionTree initializer = tree.getInitializer();
        if (initializer == null || !NEW_SYNCHRONIZED_THING.matches((Tree)initializer, state)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean escapes = new AtomicBoolean(false);
        new TreePathScanner<Void, Void>(this){
            int lambdaDepth = 0;
            final /* synthetic */ UnnecessaryAsync this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                ++this.lambdaDepth;
                Void ret = (Void)super.visitMethod(tree, null);
                --this.lambdaDepth;
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
                ++this.lambdaDepth;
                Void ret = (Void)super.visitLambdaExpression(tree, null);
                --this.lambdaDepth;
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (!ASTHelpers.getSymbol((Tree)tree).equals(symbol)) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                if (this.lambdaDepth > 0) {
                    escapes.set(true);
                    return (Void)super.visitIdentifier(tree, null);
                }
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                if (this.isVariableDeclarationItself(parentTree) || parentTree instanceof MemberSelectTree) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                escapes.set(true);
                return (Void)super.visitIdentifier(tree, null);
            }

            private boolean isVariableDeclarationItself(Tree parentTree) {
                return parentTree instanceof VariableTree && ASTHelpers.getSymbol((Tree)parentTree).equals(symbol);
            }
        }.scan(state.getPath().getParentPath(), (Void)null);
        return escapes.get() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)this.attemptFix(tree, state));
    }

    private SuggestedFix attemptFix(VariableTree tree, final VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!symbol.type.toString().startsWith("java.util.concurrent.atomic")) {
            return SuggestedFix.emptyFix();
        }
        final AtomicBoolean fixable = new AtomicBoolean(true);
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        NewClassTree constructor = (NewClassTree)tree.getInitializer();
        fix.replace((Tree)tree, String.format("%s %s = %s;", UnnecessaryAsync.getPrimitiveType(symbol.type, state.getTypes()), symbol.getSimpleName(), constructor.getArguments().isEmpty() ? UnnecessaryAsync.getDefaultInitializer(symbol, state.getTypes()) : state.getSourceForNode((Tree)constructor.getArguments().get(0))));
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ UnnecessaryAsync this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (!ASTHelpers.getSymbol((Tree)tree).equals(symbol)) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                if (this.isVariableDeclarationItself(parentTree)) {
                    return (Void)super.visitIdentifier(tree, null);
                }
                if (parentTree instanceof MemberSelectTree) {
                    MethodInvocationTree grandparent = (MethodInvocationTree)this.getCurrentPath().getParentPath().getParentPath().getLeaf();
                    if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("set")) {
                        fix.replace((Tree)grandparent, String.format("%s = %s", state.getSourceForNode((Tree)tree), state.getSourceForNode((Tree)grandparent.getArguments().get(0))));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("get")) {
                        fix.replace((Tree)grandparent, state.getSourceForNode((Tree)tree));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("getAndIncrement")) {
                        fix.replace((Tree)grandparent, String.format("%s++", state.getSourceForNode((Tree)tree)));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("getAndDecrement")) {
                        fix.replace((Tree)grandparent, String.format("%s--", state.getSourceForNode((Tree)tree)));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("incrementAndGet")) {
                        fix.replace((Tree)grandparent, String.format("++%s", state.getSourceForNode((Tree)tree)));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("decrementAndGet")) {
                        fix.replace((Tree)grandparent, String.format("--%s", state.getSourceForNode((Tree)tree)));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("compareAndSet")) {
                        fix.replace((Tree)grandparent, String.format("%s = %s", state.getSourceForNode((Tree)tree), state.getSourceForNode((Tree)grandparent.getArguments().get(1))));
                    } else if (((MemberSelectTree)parentTree).getIdentifier().contentEquals("addAndGet")) {
                        fix.replace((Tree)grandparent, String.format("%s += %s", state.getSourceForNode((Tree)tree), state.getSourceForNode((Tree)grandparent.getArguments().get(0))));
                    } else {
                        fixable.set(false);
                    }
                } else {
                    fixable.set(false);
                }
                return (Void)super.visitIdentifier(tree, null);
            }

            private boolean isVariableDeclarationItself(Tree parentTree) {
                return parentTree instanceof VariableTree && ASTHelpers.getSymbol((Tree)parentTree).equals(symbol);
            }
        }.scan(state.getPath().getParentPath(), (Void)null);
        return fixable.get() ? fix.build() : SuggestedFix.emptyFix();
    }

    private static String getPrimitiveType(Type type, Types types) {
        String name;
        switch (name = types.erasure(type).toString()) {
            case "java.util.concurrent.atomic.AtomicBoolean": {
                return "boolean";
            }
            case "java.util.concurrent.atomic.AtomicReference": {
                return type.allparams().isEmpty() ? "Object" : ((Name)type.allparams().get((int)0).tsym.getSimpleName()).toString();
            }
            case "java.util.concurrent.atomic.AtomicInteger": {
                return "int";
            }
            case "java.util.concurrent.atomic.AtomicLong": {
                return "long";
            }
        }
        throw new AssertionError((Object)name);
    }

    private static String getDefaultInitializer(Symbol.VarSymbol symbol, Types types) {
        String name;
        switch (name = types.erasure(symbol.type).toString()) {
            case "java.util.concurrent.atomic.AtomicBoolean": {
                return "false";
            }
            case "java.util.concurrent.atomic.AtomicReference": {
                return "null";
            }
            case "java.util.concurrent.atomic.AtomicInteger": 
            case "java.util.concurrent.atomic.AtomicLong": {
                return "0";
            }
        }
        throw new AssertionError((Object)name);
    }
}

