/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This assignment is to a static field. Mutating static state from a constructor is highly error-prone.")
public final class StaticAssignmentInConstructor
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, final VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (!methodSymbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        new TreeScanner<Void, Void>(this){
            final /* synthetic */ StaticAssignmentInConstructor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                return null;
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                return null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void unused) {
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree assignmentTree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)assignmentTree.getVariable());
                if (symbol != null && ASTHelpers.isStatic((Symbol)symbol) && this.shouldEmitFinding(assignmentTree)) {
                    state.reportMatch(this.this$0.describeMatch(assignmentTree));
                }
                return (Void)super.visitAssignment(assignmentTree, null);
            }

            private boolean shouldEmitFinding(AssignmentTree assignmentTree) {
                if (!(assignmentTree.getExpression() instanceof IdentifierTree)) {
                    return true;
                }
                IdentifierTree identifierTree = (IdentifierTree)assignmentTree.getExpression();
                return !identifierTree.getName().contentEquals("this");
            }
        }.scan(tree.getBody(), null);
        return Description.NO_MATCH;
    }
}

