/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_InlineTrivialConstant_TrivialConstant;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Consider inlining this constant", severity=BugPattern.SeverityLevel.WARNING)
public class InlineTrivialConstant
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> EMPTY_STRING_VARIABLE_NAMES = ImmutableSet.of((Object)"EMPTY", (Object)"EMPTY_STR", (Object)"EMPTY_STRING");

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final HashMap fields = new HashMap();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(this, state){
            final /* synthetic */ InlineTrivialConstant this$0;
            {
                this.this$0 = this$0;
                super((BugChecker)this$0, state);
            }

            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
                InlineTrivialConstant.isTrivialConstant(tree, sym, this.state).ifPresent(r -> fields.put(sym, TrivialConstant.create(tree, r)));
                return (Void)super.visitVariable(tree, null);
            }
        }.scan(state.getPath(), null);
        final ListMultimap uses = MultimapBuilder.hashKeys().arrayListValues().build();
        new TreePathScanner<Void, Void>(this){
            final /* synthetic */ InlineTrivialConstant this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitIdentifier(tree, null);
            }

            private void handle(Tree tree) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree);
                if (sym == null) {
                    return;
                }
                if (fields.containsKey(sym)) {
                    uses.put((Object)sym, (Object)tree);
                }
            }
        }.scan(state.getPath(), (Void)null);
        for (Map.Entry e : fields.entrySet()) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            TrivialConstant value = (TrivialConstant)e.getValue();
            fix.delete((Tree)value.tree());
            uses.get((Object)((Symbol)e.getKey())).forEach(x -> fix.replace(x, value.replacement()));
            state.reportMatch(this.describeMatch(value.tree(), (Fix)fix.build()));
        }
        return Description.NO_MATCH;
    }

    private static Optional<String> isTrivialConstant(VariableTree tree, Symbol.VarSymbol sym, VisitorState state) {
        String value;
        if (!(sym.getKind().equals((Object)ElementKind.FIELD) && sym.getModifiers().contains((Object)Modifier.PRIVATE) && sym.isStatic() && sym.getModifiers().contains((Object)Modifier.FINAL))) {
            return Optional.empty();
        }
        if (!EMPTY_STRING_VARIABLE_NAMES.contains((Object)tree.getName().toString())) {
            return Optional.empty();
        }
        if (!ASTHelpers.isSameType((Type)sym.asType(), (Type)state.getSymtab().stringType, (VisitorState)state)) {
            return Optional.empty();
        }
        ExpressionTree initializer = tree.getInitializer();
        if (initializer.getKind().equals((Object)Tree.Kind.STRING_LITERAL) && Objects.equals(value = (String)((LiteralTree)initializer).getValue(), "")) {
            return Optional.of("\"\"");
        }
        return Optional.empty();
    }

    @AutoValue
    static abstract class TrivialConstant {
        TrivialConstant() {
        }

        abstract VariableTree tree();

        abstract String replacement();

        static TrivialConstant create(VariableTree tree, String replacement) {
            return new AutoValue_InlineTrivialConstant_TrivialConstant(tree, replacement);
        }
    }
}

