/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

public abstract class AbstractAsKeyOfSetOrMap
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> CONSTRUCTS_SET = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.Sets").named("newHashSet"), Matchers.constructor().forClass("java.util.HashSet")});
    private static final Matcher<ExpressionTree> CONSTRUCTS_MULTISET = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.HashMultiset").named("create").withNoParameters(), MethodMatchers.staticMethod().onClass("com.google.common.collect.LinkedHashMultiset").named("create")});
    private static final Matcher<ExpressionTree> CONSTRUCTS_MAP = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.Maps").named("newHashMap"), Matchers.constructor().forClass("java.util.HashMap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.Maps").named("newLinkedHashMap"), Matchers.constructor().forClass("java.util.LinkedHashMap"), Matchers.constructor().forClass("java.util.concurrent.ConcurrentHashMap"), MethodMatchers.staticMethod().onClass("com.google.common.collect.HashBiMap").named("create")});
    private static final Matcher<ExpressionTree> CONSTRUCTS_MULTIMAP = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("com.google.common.collect.HashMultimap").named("create"), MethodMatchers.staticMethod().onClass("com.google.common.collect.LinkedHashMultimap").named("create"), MethodMatchers.staticMethod().onClass("com.google.common.collect.ArrayListMultimap").named("create"), MethodMatchers.staticMethod().onClass("com.google.common.collect.LinkedListMultimap").named("create")});
    private static final Matcher<ExpressionTree> CONSTRUCTS_SET_OR_MAP = Matchers.anyOf((Matcher[])new Matcher[]{CONSTRUCTS_SET, CONSTRUCTS_MAP, CONSTRUCTS_MULTIMAP, CONSTRUCTS_MULTISET});

    protected abstract boolean isBadType(Type var1, VisitorState var2);

    private Description matchType(ExpressionTree tree, VisitorState state) {
        if (CONSTRUCTS_SET_OR_MAP.matches((Tree)tree, state)) {
            List<Type> argumentTypes = ASTHelpers.getResultType((ExpressionTree)tree).getTypeArguments();
            if (argumentTypes.isEmpty()) {
                return Description.NO_MATCH;
            }
            Type typeArg = (Type)argumentTypes.get(0);
            if (this.isBadType(typeArg, state)) {
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matchType(tree, state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchType(tree, state);
    }
}

