/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum SqlType {
    BIGDECIMAL(2){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, new BigDecimal(v));
        }
    }
    ,
    BOOLEAN(-7){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setBoolean(i, Boolean.parseBoolean(v));
        }
    }
    ,
    BYTE(-6){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setByte(i, Byte.parseByte(v));
        }
    }
    ,
    DATE(91){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setDate(i, Date.valueOf(v));
        }
    }
    ,
    DOUBLE(8){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setDouble(i, Double.parseDouble(v));
        }
    }
    ,
    FLOAT(7){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setFloat(i, Float.parseFloat(v));
        }
    }
    ,
    INT(4){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setInt(i, Integer.parseInt(v));
        }
    }
    ,
    LONG(-5){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setLong(i, Long.parseLong(v));
        }
    }
    ,
    SHORT(5){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setShort(i, Short.parseShort(v));
        }
    }
    ,
    SQLXML(2009){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            SQLXML xml = ps.getConnection().createSQLXML();
            xml.setString(v);
            ps.setSQLXML(i, xml);
        }
    }
    ,
    STRING(12){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setString(i, v);
        }
    }
    ,
    TIME(92){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setTime(i, Time.valueOf(v));
        }
    }
    ,
    TIMESTAMP(93){

        @Override
        void set(int i, String v, PreparedStatement ps) throws SQLException {
            ps.setTimestamp(i, Timestamp.valueOf(v));
        }
    };

    private final int type;

    private SqlType(int type) {
        this.type = type;
    }

    final void setNull(int index, PreparedStatement ps) throws SQLException {
        ps.setNull(index, this.type);
    }

    abstract void set(int var1, String var2, PreparedStatement var3) throws SQLException;
}

