/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.HofArgs;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.DeepEqual;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public class FnContainsSubsequence
extends StandardFunc {
    @Override
    public final Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public final boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        QueryBiFunction<Item, Item, Boolean> cmp;
        Value input = this.arg(0).value(qc);
        Value subsequence = this.arg(1).value(qc);
        FItem compare = this.toFunctionOrNull(this.arg(2), 2, qc);
        if (compare != null) {
            HofArgs args = new HofArgs(2);
            cmp = (item1, item2) -> this.test(compare, args.set(0, (Value)item1).set(1, (Value)item2), qc);
        } else {
            cmp = new DeepEqual(this.info, null, qc)::equal;
        }
        return this.test(input, subsequence, cmp);
    }

    boolean test(Value input, Value subsequence, QueryBiFunction<Item, Item, Boolean> cmp) throws QueryException {
        long is = input.size();
        long ss = subsequence.size();
        long ps = is - ss;
        if (is >= ss) {
            block0: for (long p = 0L; p <= ps; ++p) {
                for (long s = 0L; s <= ss; ++s) {
                    if (s == ss) {
                        return true;
                    }
                    if (!cmp.apply(input.itemAt(p + s), subsequence.itemAt(s)).booleanValue()) continue block0;
                }
            }
        }
        return false;
    }

    @Override
    protected final Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        Expr subsequence = this.arg(1);
        SeqType ist = input.seqType();
        SeqType sst = subsequence.seqType();
        if (sst.zero()) {
            return Bln.TRUE;
        }
        if (this.defined(2)) {
            this.arg(2, arg -> FnContainsSubsequence.refineFunc(arg, cc, ist.with(Occ.EXACTLY_ONE), sst.with(Occ.EXACTLY_ONE)));
        }
        return this;
    }
}

