/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.func.convert.ConvertFn;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class BinDecodeString
extends BinFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Bin value = this.toBinOrNull(this.arg(0), qc);
        String encoding = this.toEncodingOrNull(this.arg(1), QueryError.BIN_UE_X, qc);
        Long offset = this.toLongOrNull(this.arg(2), qc);
        Long size = this.toLongOrNull(this.arg(3), qc);
        if (value == null) {
            return Empty.VALUE;
        }
        byte[] bytes = value.binary(this.info);
        if (offset != null || size != null) {
            int bl = bytes.length;
            int[] bounds = this.bounds(offset, offset != null ? size : null, bl);
            int o = bounds[0];
            int tl = bounds[1];
            if (o > 0 || tl < bl) {
                bytes = Arrays.copyOfRange(bytes, o, o + tl);
            }
        }
        try {
            return Str.get(ConvertFn.toString(new ArrayInput(bytes), encoding, true));
        }
        catch (IOException ex) {
            throw QueryError.BIN_CE_X.get(this.info, ex);
        }
    }
}

