/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class RecordGet
extends Single {
    private final RecordType type;
    private final int index;

    public RecordGet(InputInfo info, Expr record, int index) {
        super(info, record, Types.ITEM_ZM);
        this.type = (RecordType)record.seqType().type;
        this.index = index;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprType.assign(this.type.fields().value(this.index).seqType());
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.toMap(this.expr, qc).valueAt(this.index - 1);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new RecordGet(this.info, this.expr.copy(cc, vm), this.index));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof RecordGet)) return false;
        RecordGet rg = (RecordGet)obj;
        if (this.index != rg.index) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "at", this.index), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token(Function._MAP_GET.definition().name.prefixId());
        qs.params(new Expr[]{this.expr, Str.get(this.type.fields().key(this.index))});
    }
}

