/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.util.ArrayList;
import org.basex.api.xmldb.BXCollection;
import org.basex.api.xmldb.BXResourceIterator;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.query.value.Value;
import org.basex.util.TokenBuilder;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public final class BXResourceSet
implements ResourceSet {
    private final ArrayList<Resource> list;
    private final BXCollection coll;

    BXResourceSet(Value result, BXCollection coll) {
        int rs = (int)result.size();
        this.list = new ArrayList(rs);
        for (int s = 0; s < rs; ++s) {
            this.list.add((Resource)new BXXMLResource(result.itemAt((long)s), coll));
        }
        this.coll = coll;
    }

    public Resource getResource(long index) throws XMLDBException {
        if (index >= 0L && index < (long)this.list.size()) {
            return this.list.get((int)index);
        }
        throw new XMLDBException(300);
    }

    public void addResource(Resource resource) {
        this.list.add(resource);
    }

    public void removeResource(long index) {
        this.list.remove((int)index);
    }

    public BXResourceIterator getIterator() {
        return new BXResourceIterator(this.list);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        TokenBuilder tb = new TokenBuilder().add(60).add("xmldb").add(62);
        for (Resource r : this.getIterator()) {
            tb.add(r.getContent().toString());
        }
        return new BXXMLResource(tb.add(60).add(47).add("xmldb").add(62).finish(), this.coll);
    }

    public long getSize() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }
}

