/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieList;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.map.TrieUpdate;
import org.basex.util.TokenBuilder;

final class TrieLeaf
extends TrieNode {
    final int hash;
    final Item key;
    final Value value;

    TrieLeaf(int hash, Item key, Value value) {
        super(1);
        this.hash = hash;
        this.key = key;
        this.value = value;
    }

    @Override
    TrieNode put(int hs, int lv, TrieUpdate update) throws QueryException {
        if (hs != this.hash) {
            return this.branch(hs, lv, this.hash, 1, update);
        }
        if (this.key.atomicEqual(update.key)) {
            if (this.value == update.value) {
                return this;
            }
            return new TrieLeaf(hs, this.key, update.value);
        }
        update.add();
        return new TrieList(hs, this.key, this.value, update.key, update.value);
    }

    @Override
    TrieNode remove(int hs, int lv, TrieUpdate update) throws QueryException {
        if (hs == this.hash && this.key.atomicEqual(update.key)) {
            update.remove(this.key);
            return null;
        }
        return this;
    }

    @Override
    Value get(int hs, Item ky, int lv) throws QueryException {
        return hs == this.hash && this.key.atomicEqual(ky) ? this.value : null;
    }

    @Override
    void add(TokenBuilder tb, String indent) {
        tb.add(indent).add("`-- ").add(this.key).add(" => ").add(this.value).add(10);
    }
}

