/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;

public final class ArrayMembers
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final XQArray array = this.toArray(this.arg(0), qc);
        return new Iter(){
            final Iterator<Value> values;
            {
                this.values = array.iterable().iterator();
            }

            @Override
            public XQMap next() {
                return this.values.hasNext() ? ArrayMembers.record(this.values.next()) : null;
            }

            @Override
            public Item get(long i) {
                return ArrayMembers.record(array.memberAt(i));
            }

            @Override
            public long size() {
                return array.structSize();
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        ValueBuilder vb = new ValueBuilder(qc, this.structSize());
        for (Value member : array.iterable()) {
            vb.add(ArrayMembers.record(member));
        }
        return vb.value(this);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr array = this.arg(0);
        Type type = array.seqType().type;
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            this.exprType.assign(cc.qc.shared.record(Str.VALUE, at.valueType()).seqType(), array.structSize());
        }
        return this;
    }

    private static XQMap record(Value value) {
        return XQMap.get(Str.VALUE, value);
    }
}

