/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class TypeCheck
extends Single {
    private boolean cardinality;

    public TypeCheck(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, seqType);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        SeqType st = this.seqType();
        Type type = st.type;
        if (type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            this.expr = this.expr.simplifyFor(CompileContext.Simplify.DATA, cc);
        }
        if ((Function.ZERO_OR_ONE.is(this.expr) || Function.EXACTLY_ONE.is(this.expr) || Function.ONE_OR_MORE.is(this.expr)) && st.occ.instanceOf(this.expr.seqType().occ)) {
            this.expr = cc.replaceWith(this.expr, this.expr.arg(0));
        }
        SeqType et = this.expr.seqType();
        SeqType nst = et.with(st.occ);
        this.cardinality = nst.instanceOf(st);
        if (!et.mayBeArray() || !type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            Occ nocc = et.occ.intersect(st.occ);
            if (nocc == null) {
                throw QueryError.typeError(this.expr, st, this.info);
            }
            if (this.cardinality) {
                st = nst;
            }
            this.exprType.assign(st, nocc, et.occ == st.occ ? this.expr.size() : -1L).data(type instanceof NodeType ? this.expr : null);
        }
        if ((expr = this.expr) instanceof TypeCheck) {
            TypeCheck tc = (TypeCheck)expr;
            if (st.instanceOf(et)) {
                return cc.replaceWith(this, new TypeCheck(this.info, tc.expr, st).optimize(cc));
            }
        }
        if (et.instanceOf(st)) {
            cc.info("remove % type check: %", st, this.expr);
            return this.expr;
        }
        Expr expr2 = this.expr;
        if (expr2 instanceof FuncItem) {
            FuncItem fi = (FuncItem)expr2;
            if (type instanceof FuncType) {
                FuncType ft = (FuncType)type;
                if (!st.occ.check(1L)) {
                    throw QueryError.typeError((Expr)fi, st, this.info);
                }
                return cc.replaceWith(this, fi.coerceTo(ft, cc.qc, cc, this.info));
            }
        }
        if (cc.values(true, this.expr)) {
            return cc.preEval(this);
        }
        Expr checked = this.expr.typeCheck(this, cc);
        if (checked != null) {
            cc.info("remove % type check: %", st, checked);
            return checked;
        }
        return this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.expr.value(qc);
        SeqType st = this.seqType();
        if (this.cardinality) {
            if (!st.occ.check(value.size())) {
                throw QueryError.typeError((Expr)value, st, this.info);
            }
            return value;
        }
        return qc.tcFunc != null ? value : st.coerce(value, null, qc, null, this.info);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return this.simplifyForCast(mode, cc);
    }

    public Expr check(Expr ex, CompileContext cc) throws QueryException {
        SeqType st = this.seqType();
        return ex.seqType().instanceOf(st) ? null : new TypeCheck(this.info, ex, st).optimize(cc);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        TypeCheck ex = this.copyType(new TypeCheck(this.info, this.expr.copy(cc, vm), this.seqType()));
        ex.cardinality = this.cardinality;
        return ex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TypeCheck)) return false;
        TypeCheck tc = (TypeCheck)obj;
        if (!this.seqType().eq(tc.seqType())) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "to", this.seqType()), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("(").token(this.expr).token("coerce").token("to").token(this.seqType()).token(')');
    }
}

