/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.trie;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.reduls.igo.trie.Allocator;
import net.reduls.igo.trie.AutoArray;
import net.reduls.igo.trie.KeyStream;
import net.reduls.igo.trie.Node;
import net.reduls.igo.trie.ShrinkTail;
import net.reduls.igo.util.FileMappedOutputStream;

public final class Builder {
    private final ArrayList<KeyStream> ksList;
    private final AutoArray<Integer> base = new AutoArray();
    private final AutoArray<Character> chck = new AutoArray();
    private final ArrayList<Integer> begs = new ArrayList();
    private final ArrayList<Short> lens = new ArrayList();
    private final StringBuilder tail = new StringBuilder();

    private Builder(List<String> list) {
        this.ksList = new ArrayList(list.size());
        Collections.sort(list);
        String string = null;
        for (String string2 : list) {
            if (string2.equals(string)) continue;
            string = string2;
            this.ksList.add(new KeyStream(string));
        }
    }

    public static Builder build(List<String> list) {
        Builder builder = new Builder(list);
        builder.buildImpl(new Allocator(), 0, builder.ksList.size(), 0);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string) throws IOException {
        int n;
        new ShrinkTail(this.tail, this.begs, this.lens).shrink();
        for (n = this.chck.size(); n > 0 && ((Character)this.chck.get(n - 1)).charValue() == '\u0001'; --n) {
        }
        int n2 = 12 + (n += 65535) * 6 + this.begs.size() * 6 + this.tail.length() * 2;
        FileMappedOutputStream fileMappedOutputStream = new FileMappedOutputStream(string, n2);
        try {
            fileMappedOutputStream.putInt(n);
            fileMappedOutputStream.putInt(this.begs.size());
            fileMappedOutputStream.putInt(this.tail.length());
            for (Integer number : this.begs) {
                fileMappedOutputStream.putInt(number);
            }
            for (int i = 0; i < n; ++i) {
                fileMappedOutputStream.putInt(this.base.get(i, Integer.MIN_VALUE));
            }
            for (Short s : this.lens) {
                fileMappedOutputStream.putShort(s);
            }
            for (int i = 0; i < n; ++i) {
                fileMappedOutputStream.putChar(this.chck.get(i, Character.valueOf('\u0001')).charValue());
            }
            fileMappedOutputStream.putString(this.tail.toString());
        }
        finally {
            fileMappedOutputStream.close();
        }
    }

    private void buildImpl(Allocator allocator, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n2 - n == 1) {
            this.insertTail(this.ksList.get(n), n3);
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Character> arrayList2 = new ArrayList<Character>();
        int n6 = 1;
        for (n5 = n; n5 < n2; ++n5) {
            n4 = this.ksList.get(n5).read();
            if (n6 == n4) continue;
            n6 = n4;
            arrayList2.add(Character.valueOf((char)n6));
            arrayList.add(n5);
        }
        arrayList.add(n2);
        n5 = allocator.xCheck(arrayList2);
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            this.buildImpl(allocator, (Integer)arrayList.get(n4), (Integer)arrayList.get(n4 + '\u0001'), this.setNode(((Character)arrayList2.get(n4)).charValue(), n3, n5));
        }
    }

    private int setNode(char c, int n, int n2) {
        int n3 = n2 + c;
        this.base.set(n, n2, Integer.MIN_VALUE);
        this.chck.set(n3, Character.valueOf(c), Character.valueOf('\u0001'));
        return n3;
    }

    private void insertTail(KeyStream keyStream, int n) {
        this.base.set(n, Node.Base.ID(this.begs.size()), Integer.MIN_VALUE);
        this.begs.add(this.tail.length());
        this.tail.append(keyStream.rest());
        this.lens.add((short)keyStream.rest().length());
    }
}

