/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.io.IOUrl;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.http.HTTPText;
import org.basex.util.http.MediaType;
import org.basex.util.http.Payload;

public final class Response {
    private final InputInfo info;
    private final MainOptions options;

    public Response(InputInfo info, MainOptions options) {
        this.info = info;
        this.options = options;
    }

    public Value getResponse(HttpResponse<InputStream> response, boolean body, String mtype) throws IOException, QueryException {
        int status = response.statusCode();
        FBuilder root = FElem.build(HTTPText.Q_HTTP_RESPONSE).declareNS();
        root.add(HTTPText.Q_STATUS, status).add(HTTPText.Q_MESSAGE, IOUrl.reason(status));
        for (Map.Entry<String, List<String>> entry : response.headers().map().entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            for (String value : entry.getValue()) {
                root.add(FElem.build(HTTPText.Q_HTTP_HEADER).add(HTTPText.Q_NAME, name).add(HTTPText.Q_VALUE, value));
            }
        }
        ItemList items = (ItemList)((Object)new ItemList().add((Item)null));
        try (InputStream is = response.body();){
            HttpHeaders headers = response.headers();
            MediaType type = mtype != null ? new MediaType(mtype) : headers.firstValue("Content-Type").map(MediaType::new).orElse(MediaType.TEXT_PLAIN);
            String encoding = headers.firstValue("Content-Encoding").orElse("");
            Payload payload = new Payload(is, body, this.info, this.options);
            root.add(payload.parse(type, encoding));
            if (body) {
                items.add(payload.value());
            }
        }
        return ((ItemList)items.set(0, root.finish())).value();
    }
}

