/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;

public final class FnDivideDecimals
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        BigDecimal value = this.checkType(this.arg(0), AtomType.DECIMAL, qc).dec(this.info);
        BigDecimal divisor = this.checkType(this.arg(1), AtomType.DECIMAL, qc).dec(this.info);
        Item precision = this.arg(2).atomItem(qc, this.info);
        if (divisor.signum() == 0) {
            throw QueryError.DIVZERO_X.get(this.info, value);
        }
        int scale = precision.isEmpty() ? 0 : (int)Math.max(-1048576L, Math.min(0x100000L, this.toLong(precision)));
        BigDecimal quotient = value.divide(divisor, scale, RoundingMode.DOWN);
        BigDecimal remainder = value.subtract(quotient.multiply(divisor));
        MapBuilder map = new MapBuilder();
        map.put("quotient", (Value)Dec.get(quotient));
        map.put("remainder", (Value)Dec.get(remainder));
        return map.map();
    }
}

