/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;

abstract class ProjectNode
extends DefaultMutableTreeNode {
    final ProjectView view;
    IOFile file;
    boolean error;

    ProjectNode(IOFile file, ProjectView view) {
        super(file == null ? null : file.name());
        this.file = file;
        this.view = view;
    }

    @Override
    public void setUserObject(Object uo) {
        IOFile renamed = this.view.rename(this, uo.toString());
        if (renamed != null) {
            this.file = renamed;
            this.refresh();
        }
    }

    abstract void expand();

    abstract void collapse();

    abstract void refresh();

    final TreePath path() {
        DefaultTreeModel model = (DefaultTreeModel)this.view.tree.getModel();
        return new TreePath(model.getPathToRoot(this));
    }

    final boolean root() {
        return this.getParent().getParent() == null;
    }
}

