/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.Parser;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.DropDB;
import org.basex.index.IndexType;
import org.basex.index.resource.ResourceType;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.Version;
import org.basex.util.ft.Language;
import org.basex.util.list.StringList;

public final class MetaData {
    public String name;
    public String original = "";
    public long inputsize;
    public long time;
    public int ndocs;
    public boolean textindex;
    public boolean attrindex;
    public boolean tokenindex;
    public boolean ftindex;
    public boolean updindex;
    public boolean autooptimize;
    public boolean createtext;
    public boolean createattr;
    public boolean createtoken;
    public boolean createft;
    public String textinclude;
    public String attrinclude;
    public String tokeninclude;
    public String ftinclude;
    public boolean stemming;
    public boolean casesens;
    public boolean diacritics;
    public String stopwords;
    public int maxcats;
    public int maxlen;
    public int splitsize;
    public Language language;
    public boolean uptodate = true;
    public boolean corrupt;
    public boolean dirty;
    public int size;
    public int lastid = -1;
    private final IOFile dir;
    private boolean oldindex;
    public String docOpts;

    public MetaData(MainOptions options) {
        this("", null, options);
    }

    public MetaData(String name, MainOptions options, StaticOptions sopts) {
        this(name, sopts.dbPath(name), options);
    }

    private MetaData(String name, IOFile dir, MainOptions options) {
        this.name = name;
        this.dir = dir;
        this.createtext = options.get(MainOptions.TEXTINDEX);
        this.createattr = options.get(MainOptions.ATTRINDEX);
        this.createtoken = options.get(MainOptions.TOKENINDEX);
        this.createft = options.get(MainOptions.FTINDEX);
        this.diacritics = options.get(MainOptions.DIACRITICS);
        this.stemming = options.get(MainOptions.STEMMING);
        this.casesens = options.get(MainOptions.CASESENS);
        this.updindex = options.get(MainOptions.UPDINDEX);
        this.autooptimize = options.get(MainOptions.AUTOOPTIMIZE);
        this.maxlen = options.get(MainOptions.MAXLEN);
        this.maxcats = options.get(MainOptions.MAXCATS);
        this.stopwords = options.get(MainOptions.STOPWORDS);
        this.language = Language.get(options);
        this.textinclude = options.get(MainOptions.TEXTINCLUDE);
        this.attrinclude = options.get(MainOptions.ATTRINCLUDE);
        this.tokeninclude = options.get(MainOptions.TOKENINCLUDE);
        this.ftinclude = options.get(MainOptions.FTINCLUDE);
        this.splitsize = options.get(MainOptions.SPLITSIZE);
    }

    public static String normPath(String path) {
        char ch;
        StringList list = new StringList();
        StringBuilder sb = new StringBuilder();
        int pl = path.length();
        for (int p = 0; p < pl; ++p) {
            char ch2 = path.charAt(p);
            if (ch2 == '\\' || ch2 == '/') {
                if (MetaData.addToPath(sb, list)) continue;
                return null;
            }
            if (Prop.WIN && ":*?\"<>\\|".indexOf(ch2) != -1) {
                return null;
            }
            sb.append(ch2);
        }
        if (!MetaData.addToPath(sb, list)) {
            return null;
        }
        sb.append(String.join((CharSequence)"/", (CharSequence[])list.finish()));
        if (!(pl <= 0 || sb.isEmpty() || (ch = path.charAt(pl - 1)) != '\\' && ch != '/')) {
            sb.append('/');
        }
        return sb.toString();
    }

    private static boolean addToPath(StringBuilder sb, StringList list) {
        if (!sb.isEmpty()) {
            String segment = sb.toString();
            if (Strings.endsWith(segment, '.')) {
                if (!segment.equals(".")) {
                    return false;
                }
            } else if (segment.equals("..")) {
                if (list.isEmpty()) {
                    return false;
                }
                list.remove(list.size() - 1);
            } else {
                list.add(segment);
            }
            sb.setLength(0);
        }
        return true;
    }

    private static long dbSize(IOFile file) {
        long s = 0L;
        if (file.isDir()) {
            for (IOFile f : file.children()) {
                s += MetaData.dbSize(f);
            }
        } else {
            s += file.length();
        }
        return s;
    }

    public static IOFile file(IOFile path, String name) {
        return new IOFile(path, name + ".basex");
    }

    public boolean oldindex() {
        return this.oldindex;
    }

    public long dbSize() {
        return this.dir != null ? MetaData.dbSize(this.dir) : 0L;
    }

    public long dbTime() {
        return this.dir != null ? this.dir.timeStamp() : 0L;
    }

    public IOFile dbFile(String filename) {
        return MetaData.file(this.dir, filename);
    }

    public IOFile dir(ResourceType type) {
        return this.dir == null ? null : type.dir(this.dir);
    }

    public IOFile file(String path, ResourceType type) {
        if (this.dir != null) {
            IOFile bin = this.dir(type);
            IOFile file = new IOFile(bin, path);
            return file.isDir() ? file : type.filePath(bin, path);
        }
        return null;
    }

    public IOFile updateFile() {
        return this.dbFile("upd");
    }

    public synchronized boolean drop(String pattern) {
        return this.dir != null && DropDB.drop(this.dir, pattern + ".basex");
    }

    public void read() throws IOException {
        try (DataInput di = new DataInput(this.dbFile("inf"));){
            this.read(di);
        }
    }

    public boolean index(IndexType type) {
        return switch (type) {
            case IndexType.TEXT -> this.textindex;
            case IndexType.ATTRIBUTE -> this.attrindex;
            case IndexType.TOKEN -> this.tokenindex;
            case IndexType.FULLTEXT -> this.ftindex;
            default -> throw Util.notExpected();
        };
    }

    public void index(IndexType type, boolean exists) {
        switch (type) {
            case TEXT: {
                this.textindex = exists;
                break;
            }
            case ATTRIBUTE: {
                this.attrindex = exists;
                break;
            }
            case TOKEN: {
                this.tokenindex = exists;
                break;
            }
            case FULLTEXT: {
                this.ftindex = exists;
                break;
            }
            default: {
                throw Util.notExpected();
            }
        }
    }

    public String names(IndexType type) {
        return switch (type) {
            case IndexType.TEXT -> this.textinclude;
            case IndexType.ATTRIBUTE -> this.attrinclude;
            case IndexType.TOKEN -> this.tokeninclude;
            case IndexType.FULLTEXT -> this.ftinclude;
            default -> throw Util.notExpected();
        };
    }

    public void names(IndexType type, MainOptions options) {
        switch (type) {
            case TEXT: {
                this.textinclude = options.get(MainOptions.TEXTINCLUDE);
                break;
            }
            case ATTRIBUTE: {
                this.attrinclude = options.get(MainOptions.ATTRINCLUDE);
                break;
            }
            case TOKEN: {
                this.tokeninclude = options.get(MainOptions.TOKENINCLUDE);
                break;
            }
            case FULLTEXT: {
                this.ftinclude = options.get(MainOptions.FTINCLUDE);
                break;
            }
            default: {
                throw Util.notExpected();
            }
        }
    }

    void read(DataInput in) throws IOException {
        String k;
        String storage = "";
        String istorage = "";
        while (!(k = Token.string(in.readToken())).isEmpty()) {
            String v = Token.string(in.readToken());
            switch (k) {
                case "STORAGE": {
                    storage = v;
                    break;
                }
                case "ISTORAGE": {
                    istorage = v;
                    break;
                }
                case "FNAME": {
                    this.original = v;
                    break;
                }
                case "FTSTOP": {
                    this.stopwords = v;
                    break;
                }
                case "FTLANG": {
                    this.language = Language.get(v);
                    break;
                }
                case "SIZE": {
                    this.size = Strings.toInt(v);
                    break;
                }
                case "NDOCS": {
                    this.ndocs = Strings.toInt(v);
                    break;
                }
                case "MAXLEN": {
                    this.maxlen = Strings.toInt(v);
                    break;
                }
                case "MAXCATS": {
                    this.maxcats = Strings.toInt(v);
                    break;
                }
                case "LASTID": {
                    this.lastid = Strings.toInt(v);
                    break;
                }
                case "TIME": {
                    this.time = Strings.toLong(v);
                    break;
                }
                case "FSIZE": {
                    this.inputsize = Strings.toLong(v);
                    break;
                }
                case "FTDC": {
                    this.diacritics = Strings.isTrue(v);
                    break;
                }
                case "UPDINDEX": {
                    this.updindex = Strings.isTrue(v);
                    break;
                }
                case "AUTOOPT": {
                    this.autooptimize = Strings.isTrue(v);
                    break;
                }
                case "TXTINDEX": {
                    this.textindex = Strings.isTrue(v);
                    break;
                }
                case "ATVINDEX": {
                    this.attrindex = Strings.isTrue(v);
                    break;
                }
                case "TOKINDEX": {
                    this.tokenindex = Strings.isTrue(v);
                    break;
                }
                case "FTXINDEX": {
                    this.ftindex = Strings.isTrue(v);
                    break;
                }
                case "TXTINC": {
                    this.textinclude = v;
                    break;
                }
                case "ATVINC": {
                    this.attrinclude = v;
                    break;
                }
                case "TOKINC": {
                    this.tokeninclude = v;
                    break;
                }
                case "FTXINC": {
                    this.ftinclude = v;
                    break;
                }
                case "SPLITS": {
                    this.splitsize = Strings.toInt(v);
                    break;
                }
                case "CRTTXT": {
                    this.createtext = Strings.isTrue(v);
                    break;
                }
                case "CRTATV": {
                    this.createattr = Strings.isTrue(v);
                    break;
                }
                case "CRTTOK": {
                    this.createtoken = Strings.isTrue(v);
                    break;
                }
                case "CRTFTX": {
                    this.createft = Strings.isTrue(v);
                    break;
                }
                case "FTSTEM": {
                    this.stemming = Strings.isTrue(v);
                    break;
                }
                case "FTCS": {
                    this.casesens = Strings.isTrue(v);
                    break;
                }
                case "UPTODATE": {
                    this.uptodate = Strings.isTrue(v);
                }
            }
        }
        if (!storage.equals("9.0.1") && new Version(storage).compareTo(new Version("9.0.1")) > 0) {
            throw new BuildException(Text.H_DB_FORMAT, storage);
        }
        this.oldindex = !istorage.equals("8.6") && new Version(istorage).compareTo(new Version("8.6")) > 0;
        this.corrupt = this.dbFile("upd").exists();
    }

    void write(DataOutput out) throws IOException {
        MetaData.writeInfo(out, "STORAGE", "9.0.1");
        MetaData.writeInfo(out, "FNAME", this.original);
        MetaData.writeInfo(out, "TIME", this.time);
        MetaData.writeInfo(out, "ISTORAGE", "8.6");
        MetaData.writeInfo(out, "FSIZE", this.inputsize);
        MetaData.writeInfo(out, "NDOCS", this.ndocs);
        MetaData.writeInfo(out, "SIZE", this.size);
        MetaData.writeInfo(out, "UPDINDEX", this.updindex);
        MetaData.writeInfo(out, "AUTOOPT", this.autooptimize);
        MetaData.writeInfo(out, "TXTINDEX", this.textindex);
        MetaData.writeInfo(out, "ATVINDEX", this.attrindex);
        MetaData.writeInfo(out, "TOKINDEX", this.tokenindex);
        MetaData.writeInfo(out, "FTXINDEX", this.ftindex);
        MetaData.writeInfo(out, "TXTINC", this.textinclude);
        MetaData.writeInfo(out, "ATVINC", this.attrinclude);
        MetaData.writeInfo(out, "TOKINC", this.tokeninclude);
        MetaData.writeInfo(out, "FTXINC", this.ftinclude);
        MetaData.writeInfo(out, "SPLITS", this.splitsize);
        MetaData.writeInfo(out, "CRTTXT", this.createtext);
        MetaData.writeInfo(out, "CRTATV", this.createattr);
        MetaData.writeInfo(out, "CRTTOK", this.createtoken);
        MetaData.writeInfo(out, "CRTFTX", this.createft);
        MetaData.writeInfo(out, "FTSTEM", this.stemming);
        MetaData.writeInfo(out, "FTCS", this.casesens);
        MetaData.writeInfo(out, "FTDC", this.diacritics);
        MetaData.writeInfo(out, "FTSTOP", this.stopwords);
        MetaData.writeInfo(out, "MAXLEN", this.maxlen);
        MetaData.writeInfo(out, "MAXCATS", this.maxcats);
        MetaData.writeInfo(out, "UPTODATE", this.uptodate);
        MetaData.writeInfo(out, "LASTID", this.lastid);
        if (this.language != null) {
            MetaData.writeInfo(out, "FTLANG", this.language.toString());
        }
        out.write(0);
    }

    public void update() {
        this.time = System.currentTimeMillis();
        this.uptodate = false;
        this.dirty = true;
        if (!this.updindex) {
            this.textindex = false;
            this.attrindex = false;
            this.tokenindex = false;
        }
        this.ftindex = false;
    }

    public void assign(Parser parser) {
        IO source = parser.source();
        this.original = source != null ? source.path() : "";
        this.inputsize = source != null ? source.length() : 0L;
        this.time = source != null ? source.timeStamp() : System.currentTimeMillis();
    }

    private static void writeInfo(DataOutput out, String name, boolean value) throws IOException {
        MetaData.writeInfo(out, name, value ? "1" : "0");
    }

    private static void writeInfo(DataOutput out, String name, long value) throws IOException {
        MetaData.writeInfo(out, name, Long.toString(value));
    }

    private static void writeInfo(DataOutput out, String name, String value) throws IOException {
        out.writeToken(Token.token(name));
        out.writeToken(Token.token(value));
    }
}

