/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.xquery.XQException;
import net.xqj.basic.BasicItem;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.XQItemBase;

public class StreamingCustomXQItem
extends XQItemBase
implements Cloneable {
    protected BasicItem basicItem;

    public static StreamingCustomXQItem newInstance(BasicItem basicItem) {
        return new StreamingCustomXQItem(basicItem);
    }

    private StreamingCustomXQItem(BasicItem basicItem) {
        this.setBasicItem(basicItem);
    }

    public void setBasicItem(BasicItem basicItem) {
        this.basicItem = basicItem;
    }

    @Override
    public void writeItem(OutputStream out, Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            InputStream in = this.basicItem.getInputStream();
            try {
                int read;
                byte[] buffer = new byte[51200];
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                buffer = null;
            }
            catch (IOException e) {
                throw new XQExceptionImpl("IOException occurred whilst writing item.", "XQJAXO04", e);
            }
        } else {
            throw new XQExceptionImpl("Writing this item to XQuery expression is unsupported", "XQJSC001");
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJAXO05", e);
        }
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            Reader reader = this.basicItem.getReader();
            try {
                int read;
                char[] buffer = new char[51200];
                while ((read = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, read);
                }
                buffer = null;
            }
            catch (IOException e) {
                throw new XQExceptionImpl("IOException occurred whilst writing item.", "XQJAXO04", e);
            }
        } else {
            throw new XQExceptionImpl("Writing this item to XQuery expression is unsupported", "XQJSC001");
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJAXO05", e);
        }
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("Unable to clone a StreamingCustomXQItem object.");
    }
}

