/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqitem;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.xquery.XQException;
import net.xqj.core.Text2XQuerySyntax;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitem.AbstractAtomicXQItem;

public class AtomicXQItem
extends AbstractAtomicXQItem
implements Cloneable {
    private static int instanceCounter = 0;
    private int instanceId = ++instanceCounter;
    private char[] value;
    private int offset;
    private int length;

    protected AtomicXQItem(char[] lexicalRepresentation) {
        this(lexicalRepresentation, 0, lexicalRepresentation.length);
    }

    protected AtomicXQItem(char[] lexicalRepresentation, int offset, int length) {
        this.value = lexicalRepresentation;
        this.offset = offset;
        this.length = length;
    }

    public void setTextValue(char[] buffer, int offset, int length) {
        this.setNodeUri(null);
        this.value = buffer;
        this.offset = offset;
        this.length = length;
    }

    static final AtomicXQItem newInstance(char[] lexicalRepresentation) {
        return new AtomicXQItem(lexicalRepresentation);
    }

    static final AtomicXQItem newInstance(char[] lexicalRepresentation, int offset, int length) {
        return new AtomicXQItem(lexicalRepresentation, offset, length);
    }

    @Override
    public void writeItem(Writer writer, Properties properties) throws XQException {
        if (!XQToolkit.isToWriteXQuery(properties)) {
            try {
                writer.write(this.value, this.offset, this.length);
            }
            catch (IOException e) {
                throw new XQExceptionImpl("IOException occurred whilst writing atomic item.", "XQJAXO04", e);
            }
        } else {
            Text2XQuerySyntax.writeItem(writer, this.value, this.offset, this.length, this.getItemType().getBaseType(), this.nodeUriString);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new XQExceptionImpl(e.getMessage(), "XQJAXO05", e);
        }
    }

    public String toString() {
        return "AtomicXQItem(" + this.xqItemType + ")-" + this.instanceId;
    }

    @Override
    public String createString() {
        return new String(this.value, this.offset, this.length);
    }

    @Override
    public Object clone() {
        AtomicXQItem newItem = (AtomicXQItem)super.clone();
        newItem.instanceId = ++instanceCounter;
        newItem.value = XQToolkit.copyOfRange(this.value, this.offset, this.offset + this.length);
        newItem.offset = 0;
        return newItem;
    }
}

