/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.codepoints;

import de.bottlecaps.markup.blitz.Errors;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UnicodeCategory {
    private static final int MAX_VALID_CODEPOINT = 1114109;
    public static final RangeSet ALPHABET;
    public static final RangeSet xmlChar;
    public static final RangeSet xmlNameStartChar;
    public static final RangeSet xmlNameChar;
    public static final String version = "16.0";
    public static final Map<String, RangeSet> codepointsByCode;

    public static RangeSet forCode(String unicodeCharClassName) {
        RangeSet unicodeCharClass = codepointsByCode.get(unicodeCharClassName);
        if (unicodeCharClass == null) {
            Errors.S10.thro(unicodeCharClassName);
        }
        return unicodeCharClass;
    }

    public static boolean isSurrogate(int codepoint) {
        return codepoint >= 55296 && codepoint <= 57343;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isXmlName(String name) {
        if (name.length() <= 0) return false;
        if (!xmlNameStartChar.containsCodepoint(name.codePointAt(0))) return false;
        if (!name.codePoints().allMatch(xmlNameChar::containsCodepoint)) return false;
        return true;
    }

    static {
        RangeSet unicodeRange = RangeSet.builder().add(0, 0x10FFFF).build();
        RangeSet nonCharacters = RangeSet.builder().add(55296, 57343).add(64976, 65007).add(65534, 65535).add(131070, 131071).add(196606, 196607).add(262142, 262143).add(327678, 327679).add(393214, 393215).add(458750, 458751).add(524286, 524287).add(589822, 589823).add(655358, 655359).add(720894, 720895).add(786430, 786431).add(851966, 851967).add(917502, 917503).add(983038, 983039).add(1048574, 1048575).add(1114110, 0x10FFFF).build();
        ALPHABET = unicodeRange.minus(nonCharacters);
        RangeSet chars = RangeSet.builder().add(1, 55295).add(57344, 65533).add(65536, 0x10FFFF).build();
        RangeSet restrictedChars = RangeSet.builder().add(1, 8).add(11, 12).add(14, 31).add(127, 132).add(134, 159).build();
        xmlChar = chars.minus(restrictedChars);
        xmlNameStartChar = RangeSet.builder().add(65, 90).add(95).add(97, 122).add(192, 214).add(216, 246).add(248, 767).add(880, 893).add(895, 8191).add(8204, 8205).add(8304, 8591).add(11264, 12271).add(12289, 55295).add(63744, 64975).add(65008, 65533).add(65536, 983039).build();
        xmlNameChar = RangeSet.builder().add(xmlNameStartChar).add(45).add(46).add(48, 57).add(183).add(768, 879).add(8255, 8256).build();
        codepointsByCode = new ConcurrentHashMap<String, RangeSet>();
        codepointsByCode.put("Cc", RangeSet.builder().add(0, 31).add(127, 159).build());
        codepointsByCode.put("Cf", RangeSet.builder().add(173).add(1536, 1541).add(1564).add(1757).add(1807).add(2192, 2193).add(2274).add(6158).add(8203, 8207).add(8234, 8238).add(8288, 8292).add(8294, 8303).add(65279).add(65529, 65531).add(69821).add(69837).add(78896, 78911).add(113824, 113827).add(119155, 119162).add(917505).add(917536, 917631).build());
        codepointsByCode.put("Co", RangeSet.builder().add(57344, 63743).add(983040, 1048573).add(0x100000, 1114109).build());
        codepointsByCode.put("Cs", RangeSet.builder().add(55296, 57343).build());
        codepointsByCode.put("Ll", RangeSet.builder().add(97, 122).add(181).add(223, 246).add(248, 255).add(257).add(259).add(261).add(263).add(265).add(267).add(269).add(271).add(273).add(275).add(277).add(279).add(281).add(283).add(285).add(287).add(289).add(291).add(293).add(295).add(297).add(299).add(301).add(303).add(305).add(307).add(309).add(311, 312).add(314).add(316).add(318).add(320).add(322).add(324).add(326).add(328, 329).add(331).add(333).add(335).add(337).add(339).add(341).add(343).add(345).add(347).add(349).add(351).add(353).add(355).add(357).add(359).add(361).add(363).add(365).add(367).add(369).add(371).add(373).add(375).add(378).add(380).add(382, 384).add(387).add(389).add(392).add(396, 397).add(402).add(405).add(409, 411).add(414).add(417).add(419).add(421).add(424).add(426, 427).add(429).add(432).add(436).add(438).add(441, 442).add(445, 447).add(454).add(457).add(460).add(462).add(464).add(466).add(468).add(470).add(472).add(474).add(476, 477).add(479).add(481).add(483).add(485).add(487).add(489).add(491).add(493).add(495, 496).add(499).add(501).add(505).add(507).add(509).add(511).add(513).add(515).add(517).add(519).add(521).add(523).add(525).add(527).add(529).add(531).add(533).add(535).add(537).add(539).add(541).add(543).add(545).add(547).add(549).add(551).add(553).add(555).add(557).add(559).add(561).add(563, 569).add(572).add(575, 576).add(578).add(583).add(585).add(587).add(589).add(591, 659).add(661, 687).add(881).add(883).add(887).add(891, 893).add(912).add(940, 974).add(976, 977).add(981, 983).add(985).add(987).add(989).add(991).add(993).add(995).add(997).add(999).add(1001).add(1003).add(1005).add(1007, 1011).add(1013).add(1016).add(1019, 1020).add(1072, 1119).add(1121).add(1123).add(1125).add(1127).add(1129).add(1131).add(1133).add(1135).add(1137).add(1139).add(1141).add(1143).add(1145).add(1147).add(1149).add(1151).add(1153).add(1163).add(1165).add(1167).add(1169).add(1171).add(1173).add(1175).add(1177).add(1179).add(1181).add(1183).add(1185).add(1187).add(1189).add(1191).add(1193).add(1195).add(1197).add(1199).add(1201).add(1203).add(1205).add(1207).add(1209).add(1211).add(1213).add(1215).add(1218).add(1220).add(1222).add(1224).add(1226).add(1228).add(1230, 1231).add(1233).add(1235).add(1237).add(1239).add(1241).add(1243).add(1245).add(1247).add(1249).add(1251).add(1253).add(1255).add(1257).add(1259).add(1261).add(1263).add(1265).add(1267).add(1269).add(1271).add(1273).add(1275).add(1277).add(1279).add(1281).add(1283).add(1285).add(1287).add(1289).add(1291).add(1293).add(1295).add(1297).add(1299).add(1301).add(1303).add(1305).add(1307).add(1309).add(1311).add(1313).add(1315).add(1317).add(1319).add(1321).add(1323).add(1325).add(1327).add(1376, 1416).add(4304, 4346).add(4349, 4351).add(5112, 5117).add(7296, 7304).add(7306).add(7424, 7467).add(7531, 7543).add(7545, 7578).add(7681).add(7683).add(7685).add(7687).add(7689).add(7691).add(7693).add(7695).add(7697).add(7699).add(7701).add(7703).add(7705).add(7707).add(7709).add(7711).add(7713).add(7715).add(7717).add(7719).add(7721).add(7723).add(7725).add(7727).add(7729).add(7731).add(7733).add(7735).add(7737).add(7739).add(7741).add(7743).add(7745).add(7747).add(7749).add(7751).add(7753).add(7755).add(7757).add(7759).add(7761).add(7763).add(7765).add(7767).add(7769).add(7771).add(7773).add(7775).add(7777).add(7779).add(7781).add(7783).add(7785).add(7787).add(7789).add(7791).add(7793).add(7795).add(7797).add(7799).add(7801).add(7803).add(7805).add(7807).add(7809).add(7811).add(7813).add(7815).add(7817).add(7819).add(7821).add(7823).add(7825).add(7827).add(7829, 7837).add(7839).add(7841).add(7843).add(7845).add(7847).add(7849).add(7851).add(7853).add(7855).add(7857).add(7859).add(7861).add(7863).add(7865).add(7867).add(7869).add(7871).add(7873).add(7875).add(7877).add(7879).add(7881).add(7883).add(7885).add(7887).add(7889).add(7891).add(7893).add(7895).add(7897).add(7899).add(7901).add(7903).add(7905).add(7907).add(7909).add(7911).add(7913).add(7915).add(7917).add(7919).add(7921).add(7923).add(7925).add(7927).add(7929).add(7931).add(7933).add(7935, 7943).add(7952, 7957).add(7968, 7975).add(7984, 7991).add(8000, 8005).add(8016, 8023).add(8032, 8039).add(8048, 8061).add(8064, 8071).add(8080, 8087).add(8096, 8103).add(8112, 8116).add(8118, 8119).add(8126).add(8130, 8132).add(8134, 8135).add(8144, 8147).add(8150, 8151).add(8160, 8167).add(8178, 8180).add(8182, 8183).add(8458).add(8462, 8463).add(8467).add(8495).add(8500).add(8505).add(8508, 8509).add(8518, 8521).add(8526).add(8580).add(11312, 11359).add(11361).add(11365, 11366).add(11368).add(11370).add(11372).add(11377).add(11379, 11380).add(11382, 11387).add(11393).add(11395).add(11397).add(11399).add(11401).add(11403).add(11405).add(11407).add(11409).add(11411).add(11413).add(11415).add(11417).add(11419).add(11421).add(11423).add(11425).add(11427).add(11429).add(11431).add(11433).add(11435).add(11437).add(11439).add(11441).add(11443).add(11445).add(11447).add(11449).add(11451).add(11453).add(11455).add(11457).add(11459).add(11461).add(11463).add(11465).add(11467).add(11469).add(11471).add(11473).add(11475).add(11477).add(11479).add(11481).add(11483).add(11485).add(11487).add(11489).add(11491, 11492).add(11500).add(11502).add(11507).add(11520, 11557).add(11559).add(11565).add(42561).add(42563).add(42565).add(42567).add(42569).add(42571).add(42573).add(42575).add(42577).add(42579).add(42581).add(42583).add(42585).add(42587).add(42589).add(42591).add(42593).add(42595).add(42597).add(42599).add(42601).add(42603).add(42605).add(42625).add(42627).add(42629).add(42631).add(42633).add(42635).add(42637).add(42639).add(42641).add(42643).add(42645).add(42647).add(42649).add(42651).add(42787).add(42789).add(42791).add(42793).add(42795).add(42797).add(42799, 42801).add(42803).add(42805).add(42807).add(42809).add(42811).add(42813).add(42815).add(42817).add(42819).add(42821).add(42823).add(42825).add(42827).add(42829).add(42831).add(42833).add(42835).add(42837).add(42839).add(42841).add(42843).add(42845).add(42847).add(42849).add(42851).add(42853).add(42855).add(42857).add(42859).add(42861).add(42863).add(42865, 42872).add(42874).add(42876).add(42879).add(42881).add(42883).add(42885).add(42887).add(42892).add(42894).add(42897).add(42899, 42901).add(42903).add(42905).add(42907).add(42909).add(42911).add(42913).add(42915).add(42917).add(42919).add(42921).add(42927).add(42933).add(42935).add(42937).add(42939).add(42941).add(42943).add(42945).add(42947).add(42952).add(42954).add(42957).add(42961).add(42963).add(42965).add(42967).add(42969).add(42971).add(42998).add(43002).add(43824, 43866).add(43872, 43880).add(43888, 43967).add(64256, 64262).add(64275, 64279).add(65345, 65370).add(66600, 66639).add(66776, 66811).add(66967, 66977).add(66979, 66993).add(66995, 67001).add(67003, 67004).add(68800, 68850).add(68976, 68997).add(71872, 71903).add(93792, 93823).add(119834, 119859).add(119886, 119892).add(119894, 119911).add(119938, 119963).add(119990, 119993).add(119995).add(119997, 120003).add(120005, 120015).add(120042, 120067).add(120094, 120119).add(120146, 120171).add(120198, 120223).add(120250, 120275).add(120302, 120327).add(120354, 120379).add(120406, 120431).add(120458, 120485).add(120514, 120538).add(120540, 120545).add(120572, 120596).add(120598, 120603).add(120630, 120654).add(120656, 120661).add(120688, 120712).add(120714, 120719).add(120746, 120770).add(120772, 120777).add(120779).add(122624, 122633).add(122635, 122654).add(122661, 122666).add(125218, 125251).build());
        codepointsByCode.put("Lm", RangeSet.builder().add(688, 705).add(710, 721).add(736, 740).add(748).add(750).add(884).add(890).add(1369).add(1600).add(1765, 1766).add(2036, 2037).add(2042).add(2074).add(2084).add(2088).add(2249).add(2417).add(3654).add(3782).add(4348).add(6103).add(6211).add(6823).add(7288, 7293).add(7468, 7530).add(7544).add(7579, 7615).add(8305).add(8319).add(8336, 8348).add(11388, 11389).add(11631).add(11823).add(12293).add(12337, 12341).add(12347).add(12445, 12446).add(12540, 12542).add(40981).add(42232, 42237).add(42508).add(42623).add(42652, 42653).add(42775, 42783).add(42864).add(42888).add(42994, 42996).add(43000, 43001).add(43471).add(43494).add(43632).add(43741).add(43763, 43764).add(43868, 43871).add(43881).add(65392).add(65438, 65439).add(67456, 67461).add(67463, 67504).add(67506, 67514).add(68942).add(68975).add(92992, 92995).add(93504, 93506).add(93547, 93548).add(94099, 94111).add(94176, 94177).add(94179).add(110576, 110579).add(110581, 110587).add(110589, 110590).add(122928, 122989).add(123191, 123197).add(124139).add(125259).build());
        codepointsByCode.put("Lo", RangeSet.builder().add(170).add(186).add(443).add(448, 451).add(660).add(1488, 1514).add(1519, 1522).add(1568, 1599).add(1601, 1610).add(1646, 1647).add(1649, 1747).add(1749).add(1774, 1775).add(1786, 1788).add(1791).add(1808).add(1810, 1839).add(1869, 1957).add(1969).add(1994, 2026).add(2048, 2069).add(2112, 2136).add(2144, 2154).add(2160, 2183).add(2185, 2190).add(2208, 2248).add(2308, 2361).add(2365).add(2384).add(2392, 2401).add(2418, 2432).add(2437, 2444).add(2447, 2448).add(2451, 2472).add(2474, 2480).add(2482).add(2486, 2489).add(2493).add(2510).add(2524, 2525).add(2527, 2529).add(2544, 2545).add(2556).add(2565, 2570).add(2575, 2576).add(2579, 2600).add(2602, 2608).add(2610, 2611).add(2613, 2614).add(2616, 2617).add(2649, 2652).add(2654).add(2674, 2676).add(2693, 2701).add(2703, 2705).add(2707, 2728).add(2730, 2736).add(2738, 2739).add(2741, 2745).add(2749).add(2768).add(2784, 2785).add(2809).add(2821, 2828).add(2831, 2832).add(2835, 2856).add(2858, 2864).add(2866, 2867).add(2869, 2873).add(2877).add(2908, 2909).add(2911, 2913).add(2929).add(2947).add(2949, 2954).add(2958, 2960).add(2962, 2965).add(2969, 2970).add(2972).add(2974, 2975).add(2979, 2980).add(2984, 2986).add(2990, 3001).add(3024).add(3077, 3084).add(3086, 3088).add(3090, 3112).add(3114, 3129).add(3133).add(3160, 3162).add(3165).add(3168, 3169).add(3200).add(3205, 3212).add(3214, 3216).add(3218, 3240).add(3242, 3251).add(3253, 3257).add(3261).add(3293, 3294).add(3296, 3297).add(3313, 3314).add(3332, 3340).add(3342, 3344).add(3346, 3386).add(3389).add(3406).add(3412, 3414).add(3423, 3425).add(3450, 3455).add(3461, 3478).add(3482, 3505).add(3507, 3515).add(3517).add(3520, 3526).add(3585, 3632).add(3634, 3635).add(3648, 3653).add(3713, 3714).add(3716).add(3718, 3722).add(3724, 3747).add(3749).add(3751, 3760).add(3762, 3763).add(3773).add(3776, 3780).add(3804, 3807).add(3840).add(3904, 3911).add(3913, 3948).add(3976, 3980).add(4096, 4138).add(4159).add(4176, 4181).add(4186, 4189).add(4193).add(4197, 4198).add(4206, 4208).add(4213, 4225).add(4238).add(4352, 4680).add(4682, 4685).add(4688, 4694).add(4696).add(4698, 4701).add(4704, 4744).add(4746, 4749).add(4752, 4784).add(4786, 4789).add(4792, 4798).add(4800).add(4802, 4805).add(4808, 4822).add(4824, 4880).add(4882, 4885).add(4888, 4954).add(4992, 5007).add(5121, 5740).add(5743, 5759).add(5761, 5786).add(5792, 5866).add(5873, 5880).add(5888, 5905).add(5919, 5937).add(5952, 5969).add(5984, 5996).add(5998, 6000).add(6016, 6067).add(6108).add(6176, 6210).add(6212, 6264).add(6272, 6276).add(6279, 6312).add(6314).add(6320, 6389).add(6400, 6430).add(6480, 6509).add(6512, 6516).add(6528, 6571).add(6576, 6601).add(6656, 6678).add(6688, 6740).add(6917, 6963).add(6981, 6988).add(7043, 7072).add(7086, 7087).add(7098, 7141).add(7168, 7203).add(7245, 7247).add(7258, 7287).add(7401, 7404).add(7406, 7411).add(7413, 7414).add(7418).add(8501, 8504).add(11568, 11623).add(11648, 11670).add(11680, 11686).add(11688, 11694).add(11696, 11702).add(11704, 11710).add(11712, 11718).add(11720, 11726).add(11728, 11734).add(11736, 11742).add(12294).add(12348).add(12353, 12438).add(12447).add(12449, 12538).add(12543).add(12549, 12591).add(12593, 12686).add(12704, 12735).add(12784, 12799).add(13312, 19903).add(19968, 40980).add(40982, 42124).add(42192, 42231).add(42240, 42507).add(42512, 42527).add(42538, 42539).add(42606).add(42656, 42725).add(42895).add(42999).add(43003, 43009).add(43011, 43013).add(43015, 43018).add(43020, 43042).add(43072, 43123).add(43138, 43187).add(43250, 43255).add(43259).add(43261, 43262).add(43274, 43301).add(43312, 43334).add(43360, 43388).add(43396, 43442).add(43488, 43492).add(43495, 43503).add(43514, 43518).add(43520, 43560).add(43584, 43586).add(43588, 43595).add(43616, 43631).add(43633, 43638).add(43642).add(43646, 43695).add(43697).add(43701, 43702).add(43705, 43709).add(43712).add(43714).add(43739, 43740).add(43744, 43754).add(43762).add(43777, 43782).add(43785, 43790).add(43793, 43798).add(43808, 43814).add(43816, 43822).add(43968, 44002).add(44032, 55203).add(55216, 55238).add(55243, 55291).add(63744, 64109).add(64112, 64217).add(64285).add(64287, 64296).add(64298, 64310).add(64312, 64316).add(64318).add(64320, 64321).add(64323, 64324).add(64326, 64433).add(64467, 64829).add(64848, 64911).add(64914, 64967).add(65008, 65019).add(65136, 65140).add(65142, 65276).add(65382, 65391).add(65393, 65437).add(65440, 65470).add(65474, 65479).add(65482, 65487).add(65490, 65495).add(65498, 65500).add(65536, 65547).add(65549, 65574).add(65576, 65594).add(65596, 65597).add(65599, 65613).add(65616, 65629).add(65664, 65786).add(66176, 66204).add(66208, 66256).add(66304, 66335).add(66349, 66368).add(66370, 66377).add(66384, 66421).add(66432, 66461).add(66464, 66499).add(66504, 66511).add(66640, 66717).add(66816, 66855).add(66864, 66915).add(67008, 67059).add(67072, 67382).add(67392, 67413).add(67424, 67431).add(67584, 67589).add(67592).add(67594, 67637).add(67639, 67640).add(67644).add(67647, 67669).add(67680, 67702).add(67712, 67742).add(67808, 67826).add(67828, 67829).add(67840, 67861).add(67872, 67897).add(67968, 68023).add(68030, 68031).add(68096).add(68112, 68115).add(68117, 68119).add(68121, 68149).add(68192, 68220).add(68224, 68252).add(68288, 68295).add(68297, 68324).add(68352, 68405).add(68416, 68437).add(68448, 68466).add(68480, 68497).add(68608, 68680).add(68864, 68899).add(68938, 68941).add(68943).add(69248, 69289).add(69296, 69297).add(69314, 69316).add(69376, 69404).add(69415).add(69424, 69445).add(69488, 69505).add(69552, 69572).add(69600, 69622).add(69635, 69687).add(69745, 69746).add(69749).add(69763, 69807).add(69840, 69864).add(69891, 69926).add(69956).add(69959).add(69968, 70002).add(70006).add(70019, 70066).add(70081, 70084).add(70106).add(70108).add(70144, 70161).add(70163, 70187).add(70207, 70208).add(70272, 70278).add(70280).add(70282, 70285).add(70287, 70301).add(70303, 70312).add(70320, 70366).add(70405, 70412).add(70415, 70416).add(70419, 70440).add(70442, 70448).add(70450, 70451).add(70453, 70457).add(70461).add(70480).add(70493, 70497).add(70528, 70537).add(70539).add(70542).add(70544, 70581).add(70583).add(70609).add(70611).add(70656, 70708).add(70727, 70730).add(70751, 70753).add(70784, 70831).add(70852, 70853).add(70855).add(71040, 71086).add(71128, 71131).add(71168, 71215).add(71236).add(71296, 71338).add(71352).add(71424, 71450).add(71488, 71494).add(71680, 71723).add(71935, 71942).add(71945).add(71948, 71955).add(71957, 71958).add(71960, 71983).add(71999).add(72001).add(72096, 72103).add(72106, 72144).add(72161).add(72163).add(72192).add(72203, 72242).add(72250).add(72272).add(72284, 72329).add(72349).add(72368, 72440).add(72640, 72672).add(72704, 72712).add(72714, 72750).add(72768).add(72818, 72847).add(72960, 72966).add(72968, 72969).add(72971, 73008).add(73030).add(73056, 73061).add(73063, 73064).add(73066, 73097).add(73112).add(73440, 73458).add(73474).add(73476, 73488).add(73490, 73523).add(73648).add(73728, 74649).add(74880, 75075).add(77712, 77808).add(77824, 78895).add(78913, 78918).add(78944, 82938).add(82944, 83526).add(90368, 90397).add(92160, 92728).add(92736, 92766).add(92784, 92862).add(92880, 92909).add(92928, 92975).add(93027, 93047).add(93053, 93071).add(93507, 93546).add(93952, 94026).add(94032).add(94208, 100343).add(100352, 101589).add(101631, 101640).add(110592, 110882).add(110898).add(110928, 110930).add(110933).add(110948, 110951).add(110960, 111355).add(113664, 113770).add(113776, 113788).add(113792, 113800).add(113808, 113817).add(122634).add(123136, 123180).add(123214).add(123536, 123565).add(123584, 123627).add(124112, 124138).add(124368, 124397).add(124400).add(124896, 124902).add(124904, 124907).add(124909, 124910).add(124912, 124926).add(124928, 125124).add(126464, 126467).add(126469, 126495).add(126497, 126498).add(126500).add(126503).add(126505, 126514).add(126516, 126519).add(126521).add(126523).add(126530).add(126535).add(126537).add(126539).add(126541, 126543).add(126545, 126546).add(126548).add(126551).add(126553).add(126555).add(126557).add(126559).add(126561, 126562).add(126564).add(126567, 126570).add(126572, 126578).add(126580, 126583).add(126585, 126588).add(126590).add(126592, 126601).add(126603, 126619).add(126625, 126627).add(126629, 126633).add(126635, 126651).add(131072, 173791).add(173824, 177977).add(177984, 178205).add(178208, 183969).add(183984, 191456).add(191472, 192093).add(194560, 195101).add(196608, 201546).add(201552, 205743).build());
        codepointsByCode.put("Lt", RangeSet.builder().add(453).add(456).add(459).add(498).add(8072, 8079).add(8088, 8095).add(8104, 8111).add(8124).add(8140).add(8188).build());
        codepointsByCode.put("Lu", RangeSet.builder().add(65, 90).add(192, 214).add(216, 222).add(256).add(258).add(260).add(262).add(264).add(266).add(268).add(270).add(272).add(274).add(276).add(278).add(280).add(282).add(284).add(286).add(288).add(290).add(292).add(294).add(296).add(298).add(300).add(302).add(304).add(306).add(308).add(310).add(313).add(315).add(317).add(319).add(321).add(323).add(325).add(327).add(330).add(332).add(334).add(336).add(338).add(340).add(342).add(344).add(346).add(348).add(350).add(352).add(354).add(356).add(358).add(360).add(362).add(364).add(366).add(368).add(370).add(372).add(374).add(376, 377).add(379).add(381).add(385, 386).add(388).add(390, 391).add(393, 395).add(398, 401).add(403, 404).add(406, 408).add(412, 413).add(415, 416).add(418).add(420).add(422, 423).add(425).add(428).add(430, 431).add(433, 435).add(437).add(439, 440).add(444).add(452).add(455).add(458).add(461).add(463).add(465).add(467).add(469).add(471).add(473).add(475).add(478).add(480).add(482).add(484).add(486).add(488).add(490).add(492).add(494).add(497).add(500).add(502, 504).add(506).add(508).add(510).add(512).add(514).add(516).add(518).add(520).add(522).add(524).add(526).add(528).add(530).add(532).add(534).add(536).add(538).add(540).add(542).add(544).add(546).add(548).add(550).add(552).add(554).add(556).add(558).add(560).add(562).add(570, 571).add(573, 574).add(577).add(579, 582).add(584).add(586).add(588).add(590).add(880).add(882).add(886).add(895).add(902).add(904, 906).add(908).add(910, 911).add(913, 929).add(931, 939).add(975).add(978, 980).add(984).add(986).add(988).add(990).add(992).add(994).add(996).add(998).add(1000).add(1002).add(1004).add(1006).add(1012).add(1015).add(1017, 1018).add(1021, 1071).add(1120).add(1122).add(1124).add(1126).add(1128).add(1130).add(1132).add(1134).add(1136).add(1138).add(1140).add(1142).add(1144).add(1146).add(1148).add(1150).add(1152).add(1162).add(1164).add(1166).add(1168).add(1170).add(1172).add(1174).add(1176).add(1178).add(1180).add(1182).add(1184).add(1186).add(1188).add(1190).add(1192).add(1194).add(1196).add(1198).add(1200).add(1202).add(1204).add(1206).add(1208).add(1210).add(1212).add(1214).add(1216, 1217).add(1219).add(1221).add(1223).add(1225).add(1227).add(1229).add(1232).add(1234).add(1236).add(1238).add(1240).add(1242).add(1244).add(1246).add(1248).add(1250).add(1252).add(1254).add(1256).add(1258).add(1260).add(1262).add(1264).add(1266).add(1268).add(1270).add(1272).add(1274).add(1276).add(1278).add(1280).add(1282).add(1284).add(1286).add(1288).add(1290).add(1292).add(1294).add(1296).add(1298).add(1300).add(1302).add(1304).add(1306).add(1308).add(1310).add(1312).add(1314).add(1316).add(1318).add(1320).add(1322).add(1324).add(1326).add(1329, 1366).add(4256, 4293).add(4295).add(4301).add(5024, 5109).add(7305).add(7312, 7354).add(7357, 7359).add(7680).add(7682).add(7684).add(7686).add(7688).add(7690).add(7692).add(7694).add(7696).add(7698).add(7700).add(7702).add(7704).add(7706).add(7708).add(7710).add(7712).add(7714).add(7716).add(7718).add(7720).add(7722).add(7724).add(7726).add(7728).add(7730).add(7732).add(7734).add(7736).add(7738).add(7740).add(7742).add(7744).add(7746).add(7748).add(7750).add(7752).add(7754).add(7756).add(7758).add(7760).add(7762).add(7764).add(7766).add(7768).add(7770).add(7772).add(7774).add(7776).add(7778).add(7780).add(7782).add(7784).add(7786).add(7788).add(7790).add(7792).add(7794).add(7796).add(7798).add(7800).add(7802).add(7804).add(7806).add(7808).add(7810).add(7812).add(7814).add(7816).add(7818).add(7820).add(7822).add(7824).add(7826).add(7828).add(7838).add(7840).add(7842).add(7844).add(7846).add(7848).add(7850).add(7852).add(7854).add(7856).add(7858).add(7860).add(7862).add(7864).add(7866).add(7868).add(7870).add(7872).add(7874).add(7876).add(7878).add(7880).add(7882).add(7884).add(7886).add(7888).add(7890).add(7892).add(7894).add(7896).add(7898).add(7900).add(7902).add(7904).add(7906).add(7908).add(7910).add(7912).add(7914).add(7916).add(7918).add(7920).add(7922).add(7924).add(7926).add(7928).add(7930).add(7932).add(7934).add(7944, 7951).add(7960, 7965).add(7976, 7983).add(7992, 7999).add(8008, 8013).add(8025).add(8027).add(8029).add(8031).add(8040, 8047).add(8120, 8123).add(8136, 8139).add(8152, 8155).add(8168, 8172).add(8184, 8187).add(8450).add(8455).add(8459, 8461).add(8464, 8466).add(8469).add(8473, 8477).add(8484).add(8486).add(8488).add(8490, 8493).add(8496, 8499).add(8510, 8511).add(8517).add(8579).add(11264, 11311).add(11360).add(11362, 11364).add(11367).add(11369).add(11371).add(11373, 11376).add(11378).add(11381).add(11390, 11392).add(11394).add(11396).add(11398).add(11400).add(11402).add(11404).add(11406).add(11408).add(11410).add(11412).add(11414).add(11416).add(11418).add(11420).add(11422).add(11424).add(11426).add(11428).add(11430).add(11432).add(11434).add(11436).add(11438).add(11440).add(11442).add(11444).add(11446).add(11448).add(11450).add(11452).add(11454).add(11456).add(11458).add(11460).add(11462).add(11464).add(11466).add(11468).add(11470).add(11472).add(11474).add(11476).add(11478).add(11480).add(11482).add(11484).add(11486).add(11488).add(11490).add(11499).add(11501).add(11506).add(42560).add(42562).add(42564).add(42566).add(42568).add(42570).add(42572).add(42574).add(42576).add(42578).add(42580).add(42582).add(42584).add(42586).add(42588).add(42590).add(42592).add(42594).add(42596).add(42598).add(42600).add(42602).add(42604).add(42624).add(42626).add(42628).add(42630).add(42632).add(42634).add(42636).add(42638).add(42640).add(42642).add(42644).add(42646).add(42648).add(42650).add(42786).add(42788).add(42790).add(42792).add(42794).add(42796).add(42798).add(42802).add(42804).add(42806).add(42808).add(42810).add(42812).add(42814).add(42816).add(42818).add(42820).add(42822).add(42824).add(42826).add(42828).add(42830).add(42832).add(42834).add(42836).add(42838).add(42840).add(42842).add(42844).add(42846).add(42848).add(42850).add(42852).add(42854).add(42856).add(42858).add(42860).add(42862).add(42873).add(42875).add(42877, 42878).add(42880).add(42882).add(42884).add(42886).add(42891).add(42893).add(42896).add(42898).add(42902).add(42904).add(42906).add(42908).add(42910).add(42912).add(42914).add(42916).add(42918).add(42920).add(42922, 42926).add(42928, 42932).add(42934).add(42936).add(42938).add(42940).add(42942).add(42944).add(42946).add(42948, 42951).add(42953).add(42955, 42956).add(42960).add(42966).add(42968).add(42970).add(42972).add(42997).add(65313, 65338).add(66560, 66599).add(66736, 66771).add(66928, 66938).add(66940, 66954).add(66956, 66962).add(66964, 66965).add(68736, 68786).add(68944, 68965).add(71840, 71871).add(93760, 93791).add(119808, 119833).add(119860, 119885).add(119912, 119937).add(119964).add(119966, 119967).add(119970).add(119973, 119974).add(119977, 119980).add(119982, 119989).add(120016, 120041).add(120068, 120069).add(120071, 120074).add(120077, 120084).add(120086, 120092).add(120120, 120121).add(120123, 120126).add(120128, 120132).add(120134).add(120138, 120144).add(120172, 120197).add(120224, 120249).add(120276, 120301).add(120328, 120353).add(120380, 120405).add(120432, 120457).add(120488, 120512).add(120546, 120570).add(120604, 120628).add(120662, 120686).add(120720, 120744).add(120778).add(125184, 125217).build());
        codepointsByCode.put("Mc", RangeSet.builder().add(2307).add(2363).add(2366, 2368).add(2377, 2380).add(2382, 2383).add(2434, 2435).add(2494, 2496).add(2503, 2504).add(2507, 2508).add(2519).add(2563).add(2622, 2624).add(2691).add(2750, 2752).add(2761).add(2763, 2764).add(2818, 2819).add(2878).add(2880).add(2887, 2888).add(2891, 2892).add(2903).add(3006, 3007).add(3009, 3010).add(3014, 3016).add(3018, 3020).add(3031).add(3073, 3075).add(3137, 3140).add(3202, 3203).add(3262).add(3264, 3268).add(3271, 3272).add(3274, 3275).add(3285, 3286).add(3315).add(3330, 3331).add(3390, 3392).add(3398, 3400).add(3402, 3404).add(3415).add(3458, 3459).add(3535, 3537).add(3544, 3551).add(3570, 3571).add(3902, 3903).add(3967).add(4139, 4140).add(4145).add(4152).add(4155, 4156).add(4182, 4183).add(4194, 4196).add(4199, 4205).add(4227, 4228).add(4231, 4236).add(4239).add(4250, 4252).add(5909).add(5940).add(6070).add(6078, 6085).add(6087, 6088).add(6435, 6438).add(6441, 6443).add(6448, 6449).add(6451, 6456).add(6681, 6682).add(6741).add(6743).add(6753).add(6755, 6756).add(6765, 6770).add(6916).add(6965).add(6971).add(6973, 6977).add(6979, 6980).add(7042).add(7073).add(7078, 7079).add(7082).add(7143).add(7146, 7148).add(7150).add(7154, 7155).add(7204, 7211).add(7220, 7221).add(7393).add(7415).add(12334, 12335).add(43043, 43044).add(43047).add(43136, 43137).add(43188, 43203).add(43346, 43347).add(43395).add(43444, 43445).add(43450, 43451).add(43454, 43456).add(43567, 43568).add(43571, 43572).add(43597).add(43643).add(43645).add(43755).add(43758, 43759).add(43765).add(44003, 44004).add(44006, 44007).add(44009, 44010).add(44012).add(69632).add(69634).add(69762).add(69808, 69810).add(69815, 69816).add(69932).add(69957, 69958).add(70018).add(70067, 70069).add(70079, 70080).add(70094).add(70188, 70190).add(70194, 70195).add(70197).add(70368, 70370).add(70402, 70403).add(70462, 70463).add(70465, 70468).add(70471, 70472).add(70475, 70477).add(70487).add(70498, 70499).add(70584, 70586).add(70594).add(70597).add(70599, 70602).add(70604, 70605).add(70607).add(70709, 70711).add(70720, 70721).add(70725).add(70832, 70834).add(70841).add(70843, 70846).add(70849).add(71087, 71089).add(71096, 71099).add(71102).add(71216, 71218).add(71227, 71228).add(71230).add(71340).add(71342, 71343).add(71350).add(71454).add(71456, 71457).add(71462).add(71724, 71726).add(71736).add(71984, 71989).add(71991, 71992).add(71997).add(72000).add(72002).add(72145, 72147).add(72156, 72159).add(72164).add(72249).add(72279, 72280).add(72343).add(72751).add(72766).add(72873).add(72881).add(72884).add(73098, 73102).add(73107, 73108).add(73110).add(73461, 73462).add(73475).add(73524, 73525).add(73534, 73535).add(73537).add(90410, 90412).add(94033, 94087).add(94192, 94193).add(119141, 119142).add(119149, 119154).build());
        codepointsByCode.put("Me", RangeSet.builder().add(1160, 1161).add(6846).add(8413, 8416).add(8418, 8420).add(42608, 42610).build());
        codepointsByCode.put("Mn", RangeSet.builder().add(768, 879).add(1155, 1159).add(1425, 1469).add(1471).add(1473, 1474).add(1476, 1477).add(1479).add(1552, 1562).add(1611, 1631).add(1648).add(1750, 1756).add(1759, 1764).add(1767, 1768).add(1770, 1773).add(1809).add(1840, 1866).add(1958, 1968).add(2027, 2035).add(2045).add(2070, 2073).add(2075, 2083).add(2085, 2087).add(2089, 2093).add(2137, 2139).add(2199, 2207).add(2250, 2273).add(2275, 2306).add(2362).add(2364).add(2369, 2376).add(2381).add(2385, 2391).add(2402, 2403).add(2433).add(2492).add(2497, 2500).add(2509).add(2530, 2531).add(2558).add(2561, 2562).add(2620).add(2625, 2626).add(2631, 2632).add(2635, 2637).add(2641).add(2672, 2673).add(2677).add(2689, 2690).add(2748).add(2753, 2757).add(2759, 2760).add(2765).add(2786, 2787).add(2810, 2815).add(2817).add(2876).add(2879).add(2881, 2884).add(2893).add(2901, 2902).add(2914, 2915).add(2946).add(3008).add(3021).add(3072).add(3076).add(3132).add(3134, 3136).add(3142, 3144).add(3146, 3149).add(3157, 3158).add(3170, 3171).add(3201).add(3260).add(3263).add(3270).add(3276, 3277).add(3298, 3299).add(3328, 3329).add(3387, 3388).add(3393, 3396).add(3405).add(3426, 3427).add(3457).add(3530).add(3538, 3540).add(3542).add(3633).add(3636, 3642).add(3655, 3662).add(3761).add(3764, 3772).add(3784, 3790).add(3864, 3865).add(3893).add(3895).add(3897).add(3953, 3966).add(3968, 3972).add(3974, 3975).add(3981, 3991).add(3993, 4028).add(4038).add(4141, 4144).add(4146, 4151).add(4153, 4154).add(4157, 4158).add(4184, 4185).add(4190, 4192).add(4209, 4212).add(4226).add(4229, 4230).add(4237).add(4253).add(4957, 4959).add(5906, 5908).add(5938, 5939).add(5970, 5971).add(6002, 6003).add(6068, 6069).add(6071, 6077).add(6086).add(6089, 6099).add(6109).add(6155, 6157).add(6159).add(6277, 6278).add(6313).add(6432, 6434).add(6439, 6440).add(6450).add(6457, 6459).add(6679, 6680).add(6683).add(6742).add(6744, 6750).add(6752).add(6754).add(6757, 6764).add(6771, 6780).add(6783).add(6832, 6845).add(6847, 6862).add(6912, 6915).add(6964).add(6966, 6970).add(6972).add(6978).add(7019, 7027).add(7040, 7041).add(7074, 7077).add(7080, 7081).add(7083, 7085).add(7142).add(7144, 7145).add(7149).add(7151, 7153).add(7212, 7219).add(7222, 7223).add(7376, 7378).add(7380, 7392).add(7394, 7400).add(7405).add(7412).add(7416, 7417).add(7616, 7679).add(8400, 8412).add(8417).add(8421, 8432).add(11503, 11505).add(11647).add(11744, 11775).add(12330, 12333).add(12441, 12442).add(42607).add(42612, 42621).add(42654, 42655).add(42736, 42737).add(43010).add(43014).add(43019).add(43045, 43046).add(43052).add(43204, 43205).add(43232, 43249).add(43263).add(43302, 43309).add(43335, 43345).add(43392, 43394).add(43443).add(43446, 43449).add(43452, 43453).add(43493).add(43561, 43566).add(43569, 43570).add(43573, 43574).add(43587).add(43596).add(43644).add(43696).add(43698, 43700).add(43703, 43704).add(43710, 43711).add(43713).add(43756, 43757).add(43766).add(44005).add(44008).add(44013).add(64286).add(65024, 65039).add(65056, 65071).add(66045).add(66272).add(66422, 66426).add(68097, 68099).add(68101, 68102).add(68108, 68111).add(68152, 68154).add(68159).add(68325, 68326).add(68900, 68903).add(68969, 68973).add(69291, 69292).add(69372, 69375).add(69446, 69456).add(69506, 69509).add(69633).add(69688, 69702).add(69744).add(69747, 69748).add(69759, 69761).add(69811, 69814).add(69817, 69818).add(69826).add(69888, 69890).add(69927, 69931).add(69933, 69940).add(70003).add(70016, 70017).add(70070, 70078).add(70089, 70092).add(70095).add(70191, 70193).add(70196).add(70198, 70199).add(70206).add(70209).add(70367).add(70371, 70378).add(70400, 70401).add(70459, 70460).add(70464).add(70502, 70508).add(70512, 70516).add(70587, 70592).add(70606).add(70608).add(70610).add(70625, 70626).add(70712, 70719).add(70722, 70724).add(70726).add(70750).add(70835, 70840).add(70842).add(70847, 70848).add(70850, 70851).add(71090, 71093).add(71100, 71101).add(71103, 71104).add(71132, 71133).add(71219, 71226).add(71229).add(71231, 71232).add(71339).add(71341).add(71344, 71349).add(71351).add(71453).add(71455).add(71458, 71461).add(71463, 71467).add(71727, 71735).add(71737, 71738).add(71995, 71996).add(71998).add(72003).add(72148, 72151).add(72154, 72155).add(72160).add(72193, 72202).add(72243, 72248).add(72251, 72254).add(72263).add(72273, 72278).add(72281, 72283).add(72330, 72342).add(72344, 72345).add(72752, 72758).add(72760, 72765).add(72767).add(72850, 72871).add(72874, 72880).add(72882, 72883).add(72885, 72886).add(73009, 73014).add(73018).add(73020, 73021).add(73023, 73029).add(73031).add(73104, 73105).add(73109).add(73111).add(73459, 73460).add(73472, 73473).add(73526, 73530).add(73536).add(73538).add(73562).add(78912).add(78919, 78933).add(90398, 90409).add(90413, 90415).add(92912, 92916).add(92976, 92982).add(94031).add(94095, 94098).add(94180).add(113821, 113822).add(118528, 118573).add(118576, 118598).add(119143, 119145).add(119163, 119170).add(119173, 119179).add(119210, 119213).add(119362, 119364).add(121344, 121398).add(121403, 121452).add(121461).add(121476).add(121499, 121503).add(121505, 121519).add(122880, 122886).add(122888, 122904).add(122907, 122913).add(122915, 122916).add(122918, 122922).add(123023).add(123184, 123190).add(123566).add(123628, 123631).add(124140, 124143).add(124398, 124399).add(125136, 125142).add(125252, 125258).add(917760, 917999).build());
        codepointsByCode.put("Nd", RangeSet.builder().add(48, 57).add(1632, 1641).add(1776, 1785).add(1984, 1993).add(2406, 2415).add(2534, 2543).add(2662, 2671).add(2790, 2799).add(2918, 2927).add(3046, 3055).add(3174, 3183).add(3302, 3311).add(3430, 3439).add(3558, 3567).add(3664, 3673).add(3792, 3801).add(3872, 3881).add(4160, 4169).add(4240, 4249).add(6112, 6121).add(6160, 6169).add(6470, 6479).add(6608, 6617).add(6784, 6793).add(6800, 6809).add(6992, 7001).add(7088, 7097).add(7232, 7241).add(7248, 7257).add(42528, 42537).add(43216, 43225).add(43264, 43273).add(43472, 43481).add(43504, 43513).add(43600, 43609).add(44016, 44025).add(65296, 65305).add(66720, 66729).add(68912, 68921).add(68928, 68937).add(69734, 69743).add(69872, 69881).add(69942, 69951).add(70096, 70105).add(70384, 70393).add(70736, 70745).add(70864, 70873).add(71248, 71257).add(71360, 71369).add(71376, 71395).add(71472, 71481).add(71904, 71913).add(72016, 72025).add(72688, 72697).add(72784, 72793).add(73040, 73049).add(73120, 73129).add(73552, 73561).add(90416, 90425).add(92768, 92777).add(92864, 92873).add(93008, 93017).add(93552, 93561).add(118000, 118009).add(120782, 120831).add(123200, 123209).add(123632, 123641).add(124144, 124153).add(124401, 124410).add(125264, 125273).add(130032, 130041).build());
        codepointsByCode.put("Nl", RangeSet.builder().add(5870, 5872).add(8544, 8578).add(8581, 8584).add(12295).add(12321, 12329).add(12344, 12346).add(42726, 42735).add(65856, 65908).add(66369).add(66378).add(66513, 66517).add(74752, 74862).build());
        codepointsByCode.put("No", RangeSet.builder().add(178, 179).add(185).add(188, 190).add(2548, 2553).add(2930, 2935).add(3056, 3058).add(3192, 3198).add(3416, 3422).add(3440, 3448).add(3882, 3891).add(4969, 4988).add(6128, 6137).add(6618).add(8304).add(8308, 8313).add(8320, 8329).add(8528, 8543).add(8585).add(9312, 9371).add(9450, 9471).add(10102, 10131).add(11517).add(12690, 12693).add(12832, 12841).add(12872, 12879).add(12881, 12895).add(12928, 12937).add(12977, 12991).add(43056, 43061).add(65799, 65843).add(65909, 65912).add(65930, 65931).add(66273, 66299).add(66336, 66339).add(67672, 67679).add(67705, 67711).add(67751, 67759).add(67835, 67839).add(67862, 67867).add(68028, 68029).add(68032, 68047).add(68050, 68095).add(68160, 68168).add(68221, 68222).add(68253, 68255).add(68331, 68335).add(68440, 68447).add(68472, 68479).add(68521, 68527).add(68858, 68863).add(69216, 69246).add(69405, 69414).add(69457, 69460).add(69573, 69579).add(69714, 69733).add(70113, 70132).add(71482, 71483).add(71914, 71922).add(72794, 72812).add(73664, 73684).add(93019, 93025).add(93824, 93846).add(119488, 119507).add(119520, 119539).add(119648, 119672).add(125127, 125135).add(126065, 126123).add(126125, 126127).add(126129, 126132).add(126209, 126253).add(126255, 126269).add(127232, 127244).build());
        codepointsByCode.put("Pc", RangeSet.builder().add(95).add(8255, 8256).add(8276).add(65075, 65076).add(65101, 65103).add(65343).build());
        codepointsByCode.put("Pd", RangeSet.builder().add(45).add(1418).add(1470).add(5120).add(6150).add(8208, 8213).add(11799).add(11802).add(11834, 11835).add(11840).add(11869).add(12316).add(12336).add(12448).add(65073, 65074).add(65112).add(65123).add(65293).add(68974).add(69293).build());
        codepointsByCode.put("Pe", RangeSet.builder().add(41).add(93).add(125).add(3899).add(3901).add(5788).add(8262).add(8318).add(8334).add(8969).add(8971).add(9002).add(10089).add(10091).add(10093).add(10095).add(10097).add(10099).add(10101).add(10182).add(10215).add(10217).add(10219).add(10221).add(10223).add(10628).add(10630).add(10632).add(10634).add(10636).add(10638).add(10640).add(10642).add(10644).add(10646).add(10648).add(10713).add(10715).add(10749).add(11811).add(11813).add(11815).add(11817).add(11862).add(11864).add(11866).add(11868).add(12297).add(12299).add(12301).add(12303).add(12305).add(12309).add(12311).add(12313).add(12315).add(12318, 12319).add(64830).add(65048).add(65078).add(65080).add(65082).add(65084).add(65086).add(65088).add(65090).add(65092).add(65096).add(65114).add(65116).add(65118).add(65289).add(65341).add(65373).add(65376).add(65379).build());
        codepointsByCode.put("Pf", RangeSet.builder().add(187).add(8217).add(8221).add(8250).add(11779).add(11781).add(11786).add(11789).add(11805).add(11809).build());
        codepointsByCode.put("Pi", RangeSet.builder().add(171).add(8216).add(8219, 8220).add(8223).add(8249).add(11778).add(11780).add(11785).add(11788).add(11804).add(11808).build());
        codepointsByCode.put("Po", RangeSet.builder().add(33, 35).add(37, 39).add(42).add(44).add(46, 47).add(58, 59).add(63, 64).add(92).add(161).add(167).add(182, 183).add(191).add(894).add(903).add(1370, 1375).add(1417).add(1472).add(1475).add(1478).add(1523, 1524).add(1545, 1546).add(1548, 1549).add(1563).add(1565, 1567).add(1642, 1645).add(1748).add(1792, 1805).add(2039, 2041).add(2096, 2110).add(2142).add(2404, 2405).add(2416).add(2557).add(2678).add(2800).add(3191).add(3204).add(3572).add(3663).add(3674, 3675).add(3844, 3858).add(3860).add(3973).add(4048, 4052).add(4057, 4058).add(4170, 4175).add(4347).add(4960, 4968).add(5742).add(5867, 5869).add(5941, 5942).add(6100, 6102).add(6104, 6106).add(6144, 6149).add(6151, 6154).add(6468, 6469).add(6686, 6687).add(6816, 6822).add(6824, 6829).add(6990, 6991).add(7002, 7008).add(7037, 7039).add(7164, 7167).add(7227, 7231).add(7294, 7295).add(7360, 7367).add(7379).add(8214, 8215).add(8224, 8231).add(8240, 8248).add(8251, 8254).add(8257, 8259).add(8263, 8273).add(8275).add(8277, 8286).add(11513, 11516).add(11518, 11519).add(11632).add(11776, 11777).add(11782, 11784).add(11787).add(11790, 11798).add(11800, 11801).add(11803).add(11806, 11807).add(11818, 11822).add(11824, 11833).add(11836, 11839).add(11841).add(11843, 11855).add(11858, 11860).add(12289, 12291).add(12349).add(12539).add(42238, 42239).add(42509, 42511).add(42611).add(42622).add(42738, 42743).add(43124, 43127).add(43214, 43215).add(43256, 43258).add(43260).add(43310, 43311).add(43359).add(43457, 43469).add(43486, 43487).add(43612, 43615).add(43742, 43743).add(43760, 43761).add(44011).add(65040, 65046).add(65049).add(65072).add(65093, 65094).add(65097, 65100).add(65104, 65106).add(65108, 65111).add(65119, 65121).add(65128).add(65130, 65131).add(65281, 65283).add(65285, 65287).add(65290).add(65292).add(65294, 65295).add(65306, 65307).add(65311, 65312).add(65340).add(65377).add(65380, 65381).add(65792, 65794).add(66463).add(66512).add(66927).add(67671).add(67871).add(67903).add(68176, 68184).add(68223).add(68336, 68342).add(68409, 68415).add(68505, 68508).add(69461, 69465).add(69510, 69513).add(69703, 69709).add(69819, 69820).add(69822, 69825).add(69952, 69955).add(70004, 70005).add(70085, 70088).add(70093).add(70107).add(70109, 70111).add(70200, 70205).add(70313).add(70612, 70613).add(70615, 70616).add(70731, 70735).add(70746, 70747).add(70749).add(70854).add(71105, 71127).add(71233, 71235).add(71264, 71276).add(71353).add(71484, 71486).add(71739).add(72004, 72006).add(72162).add(72255, 72262).add(72346, 72348).add(72350, 72354).add(72448, 72457).add(72673).add(72769, 72773).add(72816, 72817).add(73463, 73464).add(73539, 73551).add(73727).add(74864, 74868).add(77809, 77810).add(92782, 92783).add(92917).add(92983, 92987).add(92996).add(93549, 93551).add(93847, 93850).add(94178).add(113823).add(121479, 121483).add(124415).add(125278, 125279).build());
        codepointsByCode.put("Ps", RangeSet.builder().add(40).add(91).add(123).add(3898).add(3900).add(5787).add(8218).add(8222).add(8261).add(8317).add(8333).add(8968).add(8970).add(9001).add(10088).add(10090).add(10092).add(10094).add(10096).add(10098).add(10100).add(10181).add(10214).add(10216).add(10218).add(10220).add(10222).add(10627).add(10629).add(10631).add(10633).add(10635).add(10637).add(10639).add(10641).add(10643).add(10645).add(10647).add(10712).add(10714).add(10748).add(11810).add(11812).add(11814).add(11816).add(11842).add(11861).add(11863).add(11865).add(11867).add(12296).add(12298).add(12300).add(12302).add(12304).add(12308).add(12310).add(12312).add(12314).add(12317).add(64831).add(65047).add(65077).add(65079).add(65081).add(65083).add(65085).add(65087).add(65089).add(65091).add(65095).add(65113).add(65115).add(65117).add(65288).add(65339).add(65371).add(65375).add(65378).build());
        codepointsByCode.put("Sc", RangeSet.builder().add(36).add(162, 165).add(1423).add(1547).add(2046, 2047).add(2546, 2547).add(2555).add(2801).add(3065).add(3647).add(6107).add(8352, 8384).add(43064).add(65020).add(65129).add(65284).add(65504, 65505).add(65509, 65510).add(73693, 73696).add(123647).add(126128).build());
        codepointsByCode.put("Sk", RangeSet.builder().add(94).add(96).add(168).add(175).add(180).add(184).add(706, 709).add(722, 735).add(741, 747).add(749).add(751, 767).add(885).add(900, 901).add(2184).add(8125).add(8127, 8129).add(8141, 8143).add(8157, 8159).add(8173, 8175).add(8189, 8190).add(12443, 12444).add(42752, 42774).add(42784, 42785).add(42889, 42890).add(43867).add(43882, 43883).add(64434, 64450).add(65342).add(65344).add(65507).add(127995, 127999).build());
        codepointsByCode.put("Sm", RangeSet.builder().add(43).add(60, 62).add(124).add(126).add(172).add(177).add(215).add(247).add(1014).add(1542, 1544).add(8260).add(8274).add(8314, 8316).add(8330, 8332).add(8472).add(8512, 8516).add(8523).add(8592, 8596).add(8602, 8603).add(8608).add(8611).add(8614).add(8622).add(8654, 8655).add(8658).add(8660).add(8692, 8959).add(8992, 8993).add(9084).add(9115, 9139).add(9180, 9185).add(9655).add(9665).add(9720, 9727).add(9839).add(10176, 10180).add(10183, 10213).add(10224, 10239).add(10496, 10626).add(10649, 10711).add(10716, 10747).add(10750, 11007).add(11056, 11076).add(11079, 11084).add(64297).add(65122).add(65124, 65126).add(65291).add(65308, 65310).add(65372).add(65374).add(65506).add(65513, 65516).add(69006, 69007).add(120513).add(120539).add(120571).add(120597).add(120629).add(120655).add(120687).add(120713).add(120745).add(120771).add(126704, 126705).build());
        codepointsByCode.put("So", RangeSet.builder().add(166).add(169).add(174).add(176).add(1154).add(1421, 1422).add(1550, 1551).add(1758).add(1769).add(1789, 1790).add(2038).add(2554).add(2928).add(3059, 3064).add(3066).add(3199).add(3407).add(3449).add(3841, 3843).add(3859).add(3861, 3863).add(3866, 3871).add(3892).add(3894).add(3896).add(4030, 4037).add(4039, 4044).add(4046, 4047).add(4053, 4056).add(4254, 4255).add(5008, 5017).add(5741).add(6464).add(6622, 6655).add(7009, 7018).add(7028, 7036).add(8448, 8449).add(8451, 8454).add(8456, 8457).add(8468).add(8470, 8471).add(8478, 8483).add(8485).add(8487).add(8489).add(8494).add(8506, 8507).add(8522).add(8524, 8525).add(8527).add(8586, 8587).add(8597, 8601).add(8604, 8607).add(8609, 8610).add(8612, 8613).add(8615, 8621).add(8623, 8653).add(8656, 8657).add(8659).add(8661, 8691).add(8960, 8967).add(8972, 8991).add(8994, 9000).add(9003, 9083).add(9085, 9114).add(9140, 9179).add(9186, 9257).add(9280, 9290).add(9372, 9449).add(9472, 9654).add(9656, 9664).add(9666, 9719).add(9728, 9838).add(9840, 10087).add(10132, 10175).add(10240, 10495).add(11008, 11055).add(11077, 11078).add(11085, 11123).add(11126, 11157).add(11159, 11263).add(11493, 11498).add(11856, 11857).add(11904, 11929).add(11931, 12019).add(12032, 12245).add(12272, 12287).add(12292).add(12306, 12307).add(12320).add(12342, 12343).add(12350, 12351).add(12688, 12689).add(12694, 12703).add(12736, 12773).add(12783).add(12800, 12830).add(12842, 12871).add(12880).add(12896, 12927).add(12938, 12976).add(12992, 13311).add(19904, 19967).add(42128, 42182).add(43048, 43051).add(43062, 43063).add(43065).add(43639, 43641).add(64832, 64847).add(64975).add(65021, 65023).add(65508).add(65512).add(65517, 65518).add(65532, 65533).add(65847, 65855).add(65913, 65929).add(65932, 65934).add(65936, 65948).add(65952).add(66000, 66044).add(67703, 67704).add(68296).add(71487).add(73685, 73692).add(73697, 73713).add(92988, 92991).add(92997).add(113820).add(117760, 117999).add(118016, 118451).add(118608, 118723).add(118784, 119029).add(119040, 119078).add(119081, 119140).add(119146, 119148).add(119171, 119172).add(119180, 119209).add(119214, 119274).add(119296, 119361).add(119365).add(119552, 119638).add(120832, 121343).add(121399, 121402).add(121453, 121460).add(121462, 121475).add(121477, 121478).add(123215).add(126124).add(126254).add(126976, 127019).add(127024, 127123).add(127136, 127150).add(127153, 127167).add(127169, 127183).add(127185, 127221).add(127245, 127405).add(127462, 127490).add(127504, 127547).add(127552, 127560).add(127568, 127569).add(127584, 127589).add(127744, 127994).add(128000, 128727).add(128732, 128748).add(128752, 128764).add(128768, 128886).add(128891, 128985).add(128992, 129003).add(129008).add(129024, 129035).add(129040, 129095).add(129104, 129113).add(129120, 129159).add(129168, 129197).add(129200, 129211).add(129216, 129217).add(129280, 129619).add(129632, 129645).add(129648, 129660).add(129664, 129673).add(129679, 129734).add(129742, 129756).add(129759, 129769).add(129776, 129784).add(129792, 129938).add(129940, 130031).build());
        codepointsByCode.put("Zl", RangeSet.builder().add(8232).build());
        codepointsByCode.put("Zp", RangeSet.builder().add(8233).build());
        codepointsByCode.put("Zs", RangeSet.builder().add(32).add(160).add(5760).add(8192, 8202).add(8239).add(8287).add(12288).build());
        RangeSet.Builder allOfTheAbove = RangeSet.builder();
        codepointsByCode.values().forEach(allOfTheAbove::add);
        codepointsByCode.put("Cn", RangeSet.builder().add(0, 1114109).build().minus(allOfTheAbove.build()));
        codepointsByCode.keySet().stream().map(name -> name.substring(0, 1)).distinct().forEach(name -> {
            RangeSet.Builder category = RangeSet.builder();
            codepointsByCode.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith((String)name)).forEach(e -> category.add((RangeSet)e.getValue()));
            codepointsByCode.put((String)name, category.build());
        });
        codepointsByCode.put("LC", RangeSet.builder().add(codepointsByCode.get("Ll")).add(codepointsByCode.get("Lt")).add(codepointsByCode.get("Lu")).build());
    }
}

