/*
 * Do not edit: automatically generated by the urboot project using
 * https://github.com/stefanrueger/urboot/blob/main/src/mkurbootlist.pl
 *
 * urbootlist.c
 *
 * List of template urboot bootloaders
 *
 * Published under GNU General Public License, version 3 (GPL-3.0)
 * Meta-author Stefan Rueger <stefan.rueger@urclocks.com>
 *
 * v 1.22
 * 26.05.2025
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdint.h>
#include <string.h>

#include "avrdude.h"
#include <libavrdude.h>
#include "urbootlist.h"
#include "urclock_private.h"

static const char *mcus[166] = {
  "m169", "m169a", "m169p", "m169pa", "m329", "m329a", "m329p", "m329pa",
  "m3290", "m3290a", "m3290p", "m3290pa", "m649", "m649a", "m649p", "m6490",
  "m6490a", "m6490p", "m48", "m48a", "m48p", "m48pa", "m48pb", "m88",
  "m88a", "m88p", "m88pa", "m88pb", "m168", "m168a", "m168p", "m168pa",
  "m168pb", "m328", "m328p", "m328pb", "m406", "m165", "m165a", "m165p",
  "m165pa", "m325", "m325a", "m325p", "m325pa", "m3250", "m3250a", "m3250p",
  "m3250pa", "m645", "m645a", "m645p", "m6450", "m6450a", "m6450p", "m8515",
  "m8535", "m164a", "m164p", "m164pa", "m324a", "m324p", "m324pa", "m324pb",
  "m644", "m644a", "m644p", "m644pa", "m644rfr2", "m1284", "m1284p", "m1284rfr2",
  "m2564rfr2", "m163", "m162", "m161", "m8", "m8a", "m8hva", "m8u2",
  "m16", "m16a", "m16hva", "m16hvb", "m16hvbrevb", "m16m1", "m16u2", "m16u4",
  "m32", "m32a", "m32c1", "m32hvb", "m32hvbrevb", "m32m1", "m32u2", "m32u4",
  "m64", "m64a", "m64c1", "m64hve2", "m64m1", "m64rfr2", "m640", "m128",
  "m128a", "m128rfa1", "m128rfr2", "m1280", "m1281", "m256rfr2", "m2560", "m2561",
  "t48", "t88", "t828", "t87", "t167", "t25", "t45", "t85",
  "t24", "t24a", "t44", "t44a", "t84", "t84a", "t1634", "t13",
  "t13a", "t43u", "t2313", "t2313a", "t4313", "t261", "t261a", "t441",
  "t461", "t461a", "t841", "t861", "t861a", "c32", "c64", "c128",
  "pwm1", "pwm2", "pwm2b", "pwm3", "pwm3b", "pwm81", "pwm161", "pwm216",
  "pwm316", "usb82", "usb162", "usb646", "usb647", "usb1286", "usb1287", "a5505",
  "a6612c", "a6613c", "a6614q", "a6616c", "a6617c", "a664251",
};

static const char *iotypes[31] = {
  "autobaud_uart0", "autobaud_uart0_alt1", "autobaud_uart1", "autobaud_uart2",
  "lin_uart0",
  "u1x8_uart0", "u1x8_uart0_alt1", "u1x8_uart1", "u1x8_uart2", "u1x8_uart3",
  "u1x12_uart0", "u1x12_uart0_alt1", "u1x12_uart1", "u1x12_uart2", "u1x12_uart3",
  "u2x8_uart0", "u2x8_uart0_alt1", "u2x8_uart1", "u2x8_uart2", "u2x8_uart3",
  "u2x12_uart0", "u2x12_uart0_alt1", "u2x12_uart1", "u2x12_uart2", "u2x12_uart3",
  "swio10", "swio11", "swio12", "swio13", "swio14", "swio15",
};

static const char *bltypes[3] = {
  "noled", "lednop", "dual",
};

static const char *configs[14] = {
  "min", "pr", "pr_u4", "pr_ee", "pr_ee_u4", "pr_ce", "pr_ce_u4", "pr_ee_ce", "pr_ee_ce_u4",
  "hw", "ee_hw", "ce_hw", "ee_ce_hw", "ee_ce_u4_hw",
};

enum {
  U_MIN, U_PR, U_PR_U4, U_PR_EE, U_PR_EE_U4, U_PR_CE, U_PR_CE_U4, U_PR_EE_CE, U_PR_EE_CE_U4,
  U_HW, U_EE_HW, U_CE_HW, U_EE_CE_HW, U_EE_CE_U4_HW,
};


typedef struct {
  uint16_t word;
  uint32_t hcode;
} Ul_huffcode;

// Huffman code table for compression of bootloader templates
static Ul_huffcode hcodes[1995] = {
#define ulhc(n, code) (((n)<<27) | (code))
  {0x0000, ulhc( 4, 000000013)}, // 1011
  {0xe080, ulhc( 6, 000000031)}, // 011001
  {0x9508, ulhc( 6, 000000071)}, // 111001
  {0xcffc, ulhc( 7, 000000003)}, // 0000011
  {0x2c55, ulhc( 7, 000000005)}, // 0000101
  {0x1345, ulhc( 7, 000000014)}, // 0001100
  {0x01f9, ulhc( 7, 000000017)}, // 0001111
  {0xcffe, ulhc( 7, 000000027)}, // 0010111
  {0x0060, ulhc( 7, 000000030)}, // 0011000
  {0x95a8, ulhc( 7, 000000036)}, // 0011110
  {0xe088, ulhc( 7, 000000052)}, // 0101010
  {0xe0b1, ulhc( 7, 000000057)}, // 0101111
  {0x13a7, ulhc( 7, 000000061)}, // 0110001
  {0xf7e1, ulhc( 7, 000000070)}, // 0111000
  {0x50c1, ulhc( 7, 000000075)}, // 0111101
  {0xe083, ulhc( 7, 000000077)}, // 0111111
  {0xf019, ulhc( 7, 000000105)}, // 1000101
  {0x2411, ulhc( 7, 000000111)}, // 1001001
  {0x938d, ulhc( 7, 000000140)}, // 1100000
  {0x2fc8, ulhc( 7, 000000142)}, // 1100010
  {0xe0a0, ulhc( 7, 000000161)}, // 1110001
  {0x2c00, ulhc( 8, 000000001)}, // 00000001
  {0x2c11, ulhc( 8, 000000002)}, // 00000010
  {0x2ccc, ulhc( 8, 000000003)}, // 00000011
  {0xbdf2, ulhc( 8, 000000024)}, // 00010100
  {0x9390, ulhc( 8, 000000027)}, // 00010111
  {0x6091, ulhc( 8, 000000051)}, // 00101001
  {0x915d, ulhc( 8, 000000052)}, // 00101010
  {0xe090, ulhc( 8, 000000053)}, // 00101011
  {0xff90, ulhc( 8, 000000054)}, // 00101100
  {0x938c, ulhc( 8, 000000063)}, // 00110011
  {0x9630, ulhc( 8, 000000064)}, // 00110100
  {0x0f7a, ulhc( 8, 000000066)}, // 00110110
  {0xbde1, ulhc( 8, 000000102)}, // 01000010
  {0x0004, ulhc( 8, 000000105)}, // 01000101
  {0xd001, ulhc( 8, 000000112)}, // 01001010
  {0xe181, ulhc( 8, 000000113)}, // 01001011
  {0xe280, ulhc( 8, 000000121)}, // 01010001
  {0x9711, ulhc( 8, 000000127)}, // 01010111
  {0xf429, ulhc( 8, 000000130)}, // 01011000
  {0x3082, ulhc( 8, 000000151)}, // 01101001
  {0xf411, ulhc( 8, 000000154)}, // 01101100
  {0x01fb, ulhc( 8, 000000155)}, // 01101101
  {0x9185, ulhc( 8, 000000156)}, // 01101110
  {0xd007, ulhc( 8, 000000164)}, // 01110100
  {0x019f, ulhc( 8, 000000170)}, // 01111000
  {0xe198, ulhc( 8, 000000201)}, // 10000001
  {0xb617, ulhc( 8, 000000205)}, // 10000101
  {0xbf87, ulhc( 8, 000000206)}, // 10000110
  {0xdff5, ulhc( 8, 000000215)}, // 10001101
  {0xb624, ulhc( 8, 000000217)}, // 10001111
  {0xbe14, ulhc( 8, 000000220)}, // 10010000
  {0x2fe8, ulhc( 8, 000000224)}, // 10010100
  {0x2ff8, ulhc( 8, 000000225)}, // 10010101
  {0x3280, ulhc( 8, 000000226)}, // 10010110
  {0x900d, ulhc( 8, 000000227)}, // 10010111
  {0x901d, ulhc( 8, 000000230)}, // 10011000
  {0x95e8, ulhc( 8, 000000231)}, // 10011001
  {0x9632, ulhc( 8, 000000232)}, // 10011010
  {0xe085, ulhc( 8, 000000233)}, // 10011011
  {0xf441, ulhc( 8, 000000234)}, // 10011100
  {0xfc10, ulhc( 8, 000000235)}, // 10011101
  {0x01dc, ulhc( 8, 000000237)}, // 10011111
  {0xe081, ulhc( 8, 000000241)}, // 10100001
  {0x2c66, ulhc( 8, 000000246)}, // 10100110
  {0x9408, ulhc( 8, 000000247)}, // 10100111
  {0x952a, ulhc( 8, 000000250)}, // 10101000
  {0xcffa, ulhc( 8, 000000310)}, // 11001000
  {0x9180, ulhc( 8, 000000317)}, // 11001111
  {0x9631, ulhc( 8, 000000323)}, // 11010011
  {0xcfff, ulhc( 8, 000000355)}, // 11101101
  {0x9380, ulhc( 8, 000000366)}, // 11110110
  {0xcffd, ulhc( 8, 000000372)}, // 11111010
  {0xe08e, ulhc( 8, 000000377)}, // 11111111
  {0xfd84, ulhc( 9, 000000012)}, // 000001010
  {0xcfe7, ulhc( 9, 000000020)}, // 000010000
  {0x2c77, ulhc( 9, 000000030)}, // 000011000
  {0x2c88, ulhc( 9, 000000031)}, // 000011001
  {0x2c99, ulhc( 9, 000000032)}, // 000011010
  {0x2f8e, ulhc( 9, 000000033)}, // 000011011
  {0x2f8f, ulhc( 9, 000000034)}, // 000011100
  {0x3c80, ulhc( 9, 000000035)}, // 000011101
  {0x5001, ulhc( 9, 000000036)}, // 000011110
  {0x7f80, ulhc( 9, 000000037)}, // 000011111
  {0x9730, ulhc( 9, 000000040)}, // 000100000
  {0xe004, ulhc( 9, 000000041)}, // 000100001
  {0xe086, ulhc( 9, 000000042)}, // 000100010
  {0xe580, ulhc( 9, 000000043)}, // 000100011
  {0xf7d9, ulhc( 9, 000000044)}, // 000100100
  {0xfc21, ulhc( 9, 000000045)}, // 000100101
  {0xfe23, ulhc( 9, 000000046)}, // 000100110
  {0x0006, ulhc( 9, 000000064)}, // 000110100
  {0x0007, ulhc( 9, 000000065)}, // 000110101
  {0xbbee, ulhc( 9, 000000067)}, // 000110111
  {0xcfe1, ulhc( 9, 000000072)}, // 000111010
  {0xe470, ulhc( 9, 000000105)}, // 001000101
  {0xff95, ulhc( 9, 000000106)}, // 001000110
  {0x13e7, ulhc( 9, 000000107)}, // 001000111
  {0x3f6f, ulhc( 9, 000000110)}, // 001001000
  {0xcfc8, ulhc( 9, 000000114)}, // 001001100
  {0xd00b, ulhc( 9, 000000116)}, // 001001110
  {0xd021, ulhc( 9, 000000153)}, // 001101011
  {0x9190, ulhc( 9, 000000157)}, // 001101111
  {0xe0b2, ulhc( 9, 000000161)}, // 001110001
  {0x07f8, ulhc( 9, 000000164)}, // 001110100
  {0x30e0, ulhc( 9, 000000165)}, // 001110101
  {0x58e0, ulhc( 9, 000000166)}, // 001110110
  {0x09f1, ulhc( 9, 000000167)}, // 001110111
  {0x99f9, ulhc( 9, 000000206)}, // 010000110
  {0x9af8, ulhc( 9, 000000207)}, // 010000111
  {0x9af9, ulhc( 9, 000000210)}, // 010001000
  {0x9afa, ulhc( 9, 000000211)}, // 010001001
  {0xb580, ulhc( 9, 000000214)}, // 010001100
  {0x000b, ulhc( 9, 000000221)}, // 010010001
  {0xdff2, ulhc( 9, 000000223)}, // 010010011
  {0x78e0, ulhc( 9, 000000231)}, // 010011001
  {0x0009, ulhc( 9, 000000235)}, // 010011101
  {0xec8f, ulhc( 9, 000000236)}, // 010011110
  {0xbd80, ulhc( 9, 000000263)}, // 010110011
  {0x00c0, ulhc( 9, 000000265)}, // 010110101
  {0xcfe2, ulhc( 9, 000000270)}, // 010111000
  {0xcff1, ulhc( 9, 000000272)}, // 010111010
  {0x0200, ulhc( 9, 000000302)}, // 011000010
  {0x00c6, ulhc( 9, 000000320)}, // 011010000
  {0x3083, ulhc( 9, 000000321)}, // 011010001
  {0xf008, ulhc( 9, 000000353)}, // 011101011
  {0xcfe0, ulhc( 9, 000000355)}, // 011101101
  {0x000d, ulhc( 9, 000000356)}, // 011101110
  {0xbf8d, ulhc( 9, 000000401)}, // 100000001
  {0xbf9e, ulhc( 9, 000000404)}, // 100000100
  {0xf7a9, ulhc( 9, 000000411)}, // 100001001
  {0xf7c1, ulhc( 9, 000000416)}, // 100001110
  {0x35c1, ulhc( 9, 000000420)}, // 100010000
  {0x09b1, ulhc( 9, 000000474)}, // 100111100
  {0xcff0, ulhc( 9, 000000500)}, // 101000000
  {0x9488, ulhc( 9, 000000522)}, // 101010010
  {0x9580, ulhc( 9, 000000523)}, // 101010011
  {0x9586, ulhc( 9, 000000524)}, // 101010100
  {0x9587, ulhc( 9, 000000525)}, // 101010101
  {0x959a, ulhc( 9, 000000526)}, // 101010110
  {0xd000, ulhc( 9, 000000527)}, // 101010111
  {0xd004, ulhc( 9, 000000530)}, // 101011000
  {0xe029, ulhc( 9, 000000531)}, // 101011001
  {0xe02a, ulhc( 9, 000000532)}, // 101011010
  {0xf410, ulhc( 9, 000000533)}, // 101011011
  {0xf7b9, ulhc( 9, 000000534)}, // 101011100
  {0x3582, ulhc( 9, 000000537)}, // 101011111
  {0xc016, ulhc( 9, 000000606)}, // 110000110
  {0xea80, ulhc( 9, 000000614)}, // 110001100
  {0xf461, ulhc( 9, 000000615)}, // 110001101
  {0xc00a, ulhc( 9, 000000617)}, // 110001111
  {0x13da, ulhc( 9, 000000633)}, // 110011011
  {0xc002, ulhc( 9, 000000634)}, // 110011100
  {0xcff7, ulhc( 9, 000000635)}, // 110011101
  {0xd00d, ulhc( 9, 000000642)}, // 110100010
  {0xe870, ulhc( 9, 000000644)}, // 110100100
  {0x11c1, ulhc( 9, 000000650)}, // 110101000
  {0x2fd8, ulhc( 9, 000000651)}, // 110101001
  {0x30c1, ulhc( 9, 000000652)}, // 110101010
  {0x30c3, ulhc( 9, 000000653)}, // 110101011
  {0x50d1, ulhc( 9, 000000654)}, // 110101100
  {0x7f8d, ulhc( 9, 000000655)}, // 110101101
  {0x918d, ulhc( 9, 000000656)}, // 110101110
  {0xe091, ulhc( 9, 000000664)}, // 110110100
  {0xe0e0, ulhc( 9, 000000671)}, // 110111001
  {0x50f1, ulhc( 9, 000000703)}, // 111000011
  {0xcffb, ulhc( 9, 000000722)}, // 111010010
  {0xf7f1, ulhc( 9, 000000724)}, // 111010100
  {0x30f0, ulhc( 9, 000000730)}, // 111011000
  {0xff87, ulhc( 9, 000000734)}, // 111011100
  {0xef8f, ulhc( 9, 000000735)}, // 111011101
  {0x3f5f, ulhc( 9, 000000736)}, // 111011110
  {0x6092, ulhc( 9, 000000737)}, // 111011111
  {0xc004, ulhc( 9, 000000740)}, // 111100000
  {0xf009, ulhc( 9, 000000741)}, // 111100001
  {0xff91, ulhc( 9, 000000742)}, // 111100010
  {0xe0f0, ulhc( 9, 000000745)}, // 111100101
  {0x9145, ulhc( 9, 000000747)}, // 111100111
  {0xfe21, ulhc( 9, 000000763)}, // 111110011
  {0xcff4, ulhc( 9, 000000770)}, // 111111000
  {0x2345, ulhc( 9, 000000771)}, // 111111001
  {0x6094, ulhc( 9, 000000772)}, // 111111010
  {0xff92, ulhc( 9, 000000773)}, // 111111011
  {0x0064, ulhc(10, 000000001)}, // 0000000001
  {0xd046, ulhc(10, 000000002)}, // 0000000010
  {0x0082, ulhc(10, 000000020)}, // 0000010000
  {0xd030, ulhc(10, 000000027)}, // 0000010111
  {0x0072, ulhc(10, 000000044)}, // 0000100100
  {0xbf8b, ulhc(10, 000000045)}, // 0000100101
  {0x0075, ulhc(10, 000000046)}, // 0000100110
  {0x9918, ulhc(10, 000000116)}, // 0001001110
  {0xd049, ulhc(10, 000000127)}, // 0001010111
  {0x0073, ulhc(10, 000000132)}, // 0001011010
  {0x0076, ulhc(10, 000000154)}, // 0001101100
  {0x99e1, ulhc(10, 000000155)}, // 0001101101
  {0x9ae0, ulhc(10, 000000160)}, // 0001110000
  {0x9ae1, ulhc(10, 000000161)}, // 0001110001
  {0x9ae2, ulhc(10, 000000162)}, // 0001110010
  {0xb38d, ulhc(10, 000000163)}, // 0001110011
  {0xbb8d, ulhc(10, 000000166)}, // 0001110110
  {0x0074, ulhc(10, 000000202)}, // 0010000010
  {0x0057, ulhc(10, 000000205)}, // 0010000101
  {0xbf9b, ulhc(10, 000000207)}, // 0010000111
  {0xd04b, ulhc(10, 000000211)}, // 0010001001
  {0xd040, ulhc(10, 000000223)}, // 0010010011
  {0xd031, ulhc(10, 000000227)}, // 0010010111
  {0xc013, ulhc(10, 000000233)}, // 0010011011
  {0x0056, ulhc(10, 000000236)}, // 0010011110
  {0xd03f, ulhc(10, 000000237)}, // 0010011111
  {0xd043, ulhc(10, 000000240)}, // 0010100000
  {0x005a, ulhc(10, 000000265)}, // 0010110101
  {0xe188, ulhc(10, 000000267)}, // 0010110111
  {0x54a0, ulhc(10, 000000310)}, // 0011001000
  {0x0049, ulhc(10, 000000312)}, // 0011001010
  {0x9980, ulhc(10, 000000313)}, // 0011001011
  {0xcfef, ulhc(10, 000000324)}, // 0011010100
  {0xe8e0, ulhc(10, 000000340)}, // 0011100000
  {0xcfd9, ulhc(10, 000000347)}, // 0011100111
  {0xd03a, ulhc(10, 000000370)}, // 0011111000
  {0xd041, ulhc(10, 000000372)}, // 0011111010
  {0xcfee, ulhc(10, 000000373)}, // 0011111011
  {0x004c, ulhc(10, 000000375)}, // 0011111101
  {0xd052, ulhc(10, 000000376)}, // 0011111110
  {0xcfdd, ulhc(10, 000000400)}, // 0100000000
  {0xdfe0, ulhc(10, 000000404)}, // 0100000100
  {0xf4b9, ulhc(10, 000000435)}, // 0100011101
  {0xf778, ulhc(10, 000000436)}, // 0100011110
  {0xc010, ulhc(10, 000000437)}, // 0100011111
  {0xece0, ulhc(10, 000000441)}, // 0100100001
  {0x30a0, ulhc(10, 000000444)}, // 0100100100
  {0x50b1, ulhc(10, 000000445)}, // 0100100101
  {0xd038, ulhc(10, 000000461)}, // 0100110001
  {0xd005, ulhc(10, 000000465)}, // 0100110101
  {0xe094, ulhc(10, 000000466)}, // 0100110110
  {0x9948, ulhc(10, 000000502)}, // 0101000010
  {0x0071, ulhc(10, 000000503)}, // 0101000011
  {0xd047, ulhc(10, 000000513)}, // 0101001011
  {0xd04e, ulhc(10, 000000514)}, // 0101001100
  {0xc011, ulhc(10, 000000516)}, // 0101001110
  {0xe38f, ulhc(10, 000000517)}, // 0101001111
  {0xf4e9, ulhc(10, 000000531)}, // 0101011001
  {0x83b0, ulhc(10, 000000533)}, // 0101011011
  {0xd02f, ulhc(10, 000000544)}, // 0101100100
  {0x004d, ulhc(10, 000000554)}, // 0101101100
  {0xe58f, ulhc(10, 000000555)}, // 0101101101
  {0xd04c, ulhc(10, 000000567)}, // 0101110111
  {0xb985, ulhc(10, 000000601)}, // 0110000001
  {0xb984, ulhc(10, 000000603)}, // 0110000011
  {0xdfee, ulhc(10, 000000607)}, // 0110000111
  {0x34a0, ulhc(10, 000000652)}, // 0110101010
  {0x004b, ulhc(10, 000000653)}, // 0110101011
  {0xd033, ulhc(10, 000000655)}, // 0110101101
  {0x95ba, ulhc(10, 000000676)}, // 0110111110
  {0xbf6b, ulhc(10, 000000714)}, // 0111001100
  {0xdfe7, ulhc(10, 000000725)}, // 0111010101
  {0xd042, ulhc(10, 000000731)}, // 0111011001
  {0xd02e, ulhc(10, 000000744)}, // 0111100100
  {0xd02b, ulhc(10, 000000747)}, // 0111100111
  {0xd00c, ulhc(10, 000000761)}, // 0111110001
  {0xf578, ulhc(10, 000000766)}, // 0111110110
  {0x4fff, ulhc(10, 000000767)}, // 0111110111
  {0xf4a1, ulhc(10, 000001000)}, // 1000000000
  {0xcff3, ulhc(10, 000001014)}, // 1000001100
  {0xd03e, ulhc(10, 000001021)}, // 1000010001
  {0x0180, ulhc(10, 000001042)}, // 1000100010
  {0x3984, ulhc(10, 000001060)}, // 1000110000
  {0xd03d, ulhc(10, 000001062)}, // 1000110010
  {0x0068, ulhc(10, 000001063)}, // 1000110011
  {0xd045, ulhc(10, 000001071)}, // 1000111001
  {0x0f7e, ulhc(10, 000001073)}, // 1000111011
  {0xd01d, ulhc(10, 000001105)}, // 1001000101
  {0xb814, ulhc(10, 000001172)}, // 1001111010
  {0xb815, ulhc(10, 000001173)}, // 1001111011
  {0xd034, ulhc(10, 000001210)}, // 1010001000
  {0xdfec, ulhc(10, 000001215)}, // 1010001101
  {0xb58d, ulhc(10, 000001216)}, // 1010001110
  {0xb58e, ulhc(10, 000001217)}, // 1010001111
  {0xbc1c, ulhc(10, 000001220)}, // 1010010000
  {0xbd8c, ulhc(10, 000001221)}, // 1010010001
  {0xbd8e, ulhc(10, 000001222)}, // 1010010010
  {0x2f7a, ulhc(10, 000001224)}, // 1010010100
  {0x70e0, ulhc(10, 000001225)}, // 1010010101
  {0xd048, ulhc(10, 000001274)}, // 1010111100
  {0xdff0, ulhc(10, 000001275)}, // 1010111101
  {0x83b4, ulhc(10, 000001445)}, // 1100100101
  {0xc00c, ulhc(10, 000001450)}, // 1100101000
  {0xf4d9, ulhc(10, 000001451)}, // 1100101001
  {0xbd91, ulhc(10, 000001452)}, // 1100101010
  {0xbbff, ulhc(10, 000001455)}, // 1100101101
  {0xd017, ulhc(10, 000001456)}, // 1100101110
  {0xcfc2, ulhc(10, 000001464)}, // 1100110100
  {0x7ce0, ulhc(10, 000001506)}, // 1101000110
  {0xcfe3, ulhc(10, 000001537)}, // 1101011111
  {0x83b1, ulhc(10, 000001541)}, // 1101100001
  {0xe1b8, ulhc(10, 000001542)}, // 1101100010
  {0xcfd6, ulhc(10, 000001543)}, // 1101100011
  {0x00ce, ulhc(10, 000001544)}, // 1101100100
  {0x00c8, ulhc(10, 000001567)}, // 1101110111
  {0xf459, ulhc(10, 000001571)}, // 1101111001
  {0xd035, ulhc(10, 000001573)}, // 1101111011
  {0x3581, ulhc(10, 000001577)}, // 1101111111
  {0xf421, ulhc(10, 000001600)}, // 1110000000
  {0xf7e0, ulhc(10, 000001601)}, // 1110000001
  {0xbd81, ulhc(10, 000001605)}, // 1110000101
  {0xdfe9, ulhc(10, 000001640)}, // 1110100000
  {0x9165, ulhc(10, 000001642)}, // 1110100010
  {0xd00a, ulhc(10, 000001646)}, // 1110100110
  {0x000a, ulhc(10, 000001652)}, // 1110101010
  {0xc000, ulhc(10, 000001662)}, // 1110110010
  {0x58a0, ulhc(10, 000001711)}, // 1111001001
  {0xcfe6, ulhc(10, 000001714)}, // 1111001100
  {0xdff6, ulhc(10, 000001722)}, // 1111010010
  {0xdff3, ulhc(10, 000001723)}, // 1111010011
  {0x0101, ulhc(10, 000001724)}, // 1111010100
  {0xdfeb, ulhc(10, 000001726)}, // 1111010110
  {0xf469, ulhc(10, 000001734)}, // 1111011100
  {0xd03c, ulhc(10, 000001736)}, // 1111011110
  {0xdff7, ulhc(10, 000001737)}, // 1111011111
  {0xc00e, ulhc(10, 000001756)}, // 1111101110
  {0xf439, ulhc(10, 000001757)}, // 1111101111
  {0x38a0, ulhc(10, 000001771)}, // 1111111001
  {0xec8e, ulhc(10, 000001773)}, // 1111111011
  {0xd082, ulhc(11, 000000001)}, // 00000000001
  {0xf7b1, ulhc(11, 000000006)}, // 00000000110
  {0xf7c9, ulhc(11, 000000007)}, // 00000000111
  {0xd07f, ulhc(11, 000000043)}, // 00000100011
  {0x9891, ulhc(11, 000000044)}, // 00000100100
  {0x9a89, ulhc(11, 000000045)}, // 00000100101
  {0x9a91, ulhc(11, 000000046)}, // 00000100110
  {0xc03f, ulhc(11, 000000055)}, // 00000101101
  {0x3060, ulhc(11, 000000107)}, // 00001000111
  {0x9829, ulhc(11, 000000236)}, // 00010011110
  {0x9a21, ulhc(11, 000000237)}, // 00010011111
  {0x9a29, ulhc(11, 000000250)}, // 00010101000
  {0x994c, ulhc(11, 000000254)}, // 00010101100
  {0xd079, ulhc(11, 000000260)}, // 00010110000
  {0x0400, ulhc(11, 000000261)}, // 00010110001
  {0x995c, ulhc(11, 000000262)}, // 00010110010
  {0xdfe3, ulhc(11, 000000266)}, // 00010110110
  {0xf711, ulhc(11, 000000356)}, // 00011101110
  {0x00d2, ulhc(11, 000000357)}, // 00011101111
  {0xc040, ulhc(11, 000000400)}, // 00100000000
  {0xcfca, ulhc(11, 000000402)}, // 00100000010
  {0xd063, ulhc(11, 000000403)}, // 00100000011
  {0x99b0, ulhc(11, 000000410)}, // 00100001000
  {0x003a, ulhc(11, 000000421)}, // 00100010001
  {0xcfdc, ulhc(11, 000000444)}, // 00100100100
  {0xd084, ulhc(11, 000000450)}, // 00100101000
  {0xc042, ulhc(11, 000000451)}, // 00100101001
  {0x003b, ulhc(11, 000000453)}, // 00100101011
  {0xd01e, ulhc(11, 000000454)}, // 00100101100
  {0x001b, ulhc(11, 000000504)}, // 00101000100
  {0x9b5d, ulhc(11, 000000505)}, // 00101000101
  {0x9b5f, ulhc(11, 000000506)}, // 00101000110
  {0xb18c, ulhc(11, 000000507)}, // 00101000111
  {0xb98a, ulhc(11, 000000550)}, // 00101101000
  {0xb98c, ulhc(11, 000000551)}, // 00101101001
  {0x00af, ulhc(11, 000000622)}, // 00110010010
  {0x00cc, ulhc(11, 000000623)}, // 00110010011
  {0x9859, ulhc(11, 000000653)}, // 00110101011
  {0x9a51, ulhc(11, 000000670)}, // 00110111000
  {0x9a59, ulhc(11, 000000671)}, // 00110111001
  {0xcfc7, ulhc(11, 000000672)}, // 00110111010
  {0x0046, ulhc(11, 000000702)}, // 00111000010
  {0xf7c8, ulhc(11, 000000710)}, // 00111001000
  {0xcfd7, ulhc(11, 000000713)}, // 00111001011
  {0x00d6, ulhc(11, 000000770)}, // 00111111000
  {0x4067, ulhc(11, 000000771)}, // 00111111001
  {0xd07d, ulhc(11, 000000776)}, // 00111111110
  {0xd077, ulhc(11, 000000777)}, // 00111111111
  {0x9690, ulhc(11, 000001003)}, // 01000000011
  {0xe7af, ulhc(11, 000001004)}, // 01000000100
  {0xefbf, ulhc(11, 000001005)}, // 01000000101
  {0xe183, ulhc(11, 000001006)}, // 01000000110
  {0xe092, ulhc(11, 000001012)}, // 01000001010
  {0x003e, ulhc(11, 000001013)}, // 01000001011
  {0xe190, ulhc(11, 000001014)}, // 01000001100
  {0x00b6, ulhc(11, 000001064)}, // 01000110100
  {0x00a6, ulhc(11, 000001066)}, // 01000110110
  {0x0140, ulhc(11, 000001067)}, // 01000110111
  {0x00ac, ulhc(11, 000001071)}, // 01000111001
  {0xece8, ulhc(11, 000001101)}, // 01001000001
  {0xdfe5, ulhc(11, 000001141)}, // 01001100001
  {0xd014, ulhc(11, 000001151)}, // 01001101001
  {0x00a1, ulhc(11, 000001156)}, // 01001101110
  {0xc03e, ulhc(11, 000001157)}, // 01001101111
  {0xd06b, ulhc(11, 000001161)}, // 01001110001
  {0x00b1, ulhc(11, 000001162)}, // 01001110010
  {0x00a5, ulhc(11, 000001200)}, // 01010000000
  {0xcfc5, ulhc(11, 000001201)}, // 01010000001
  {0x00a7, ulhc(11, 000001202)}, // 01010000010
  {0xc041, ulhc(11, 000001203)}, // 01010000011
  {0x9147, ulhc(11, 000001221)}, // 01010010001
  {0x00a0, ulhc(11, 000001224)}, // 01010010100
  {0xd055, ulhc(11, 000001225)}, // 01010010101
  {0x00ae, ulhc(11, 000001233)}, // 01010011011
  {0x00b4, ulhc(11, 000001261)}, // 01010110001
  {0x00b3, ulhc(11, 000001264)}, // 01010110100
  {0xd018, ulhc(11, 000001312)}, // 01011001010
  {0xd07b, ulhc(11, 000001313)}, // 01011001011
  {0xd072, ulhc(11, 000001320)}, // 01011010000
  {0x994a, ulhc(11, 000001321)}, // 01011010001
  {0xd070, ulhc(11, 000001322)}, // 01011010010
  {0x00a8, ulhc(11, 000001334)}, // 01011011100
  {0xd025, ulhc(11, 000001336)}, // 01011011110
  {0x00ad, ulhc(11, 000001337)}, // 01011011111
  {0xd06e, ulhc(11, 000001344)}, // 01011100100
  {0x009e, ulhc(11, 000001354)}, // 01011101100
  {0xd067, ulhc(11, 000001355)}, // 01011101101
  {0xd012, ulhc(11, 000001400)}, // 01100000000
  {0xd053, ulhc(11, 000001401)}, // 01100000001
  {0xd009, ulhc(11, 000001405)}, // 01100000101
  {0x00a4, ulhc(11, 000001415)}, // 01100001101
  {0xd06a, ulhc(11, 000001521)}, // 01101010001
  {0xd059, ulhc(11, 000001522)}, // 01101010010
  {0xd064, ulhc(11, 000001523)}, // 01101010011
  {0xd06c, ulhc(11, 000001530)}, // 01101011000
  {0x00aa, ulhc(11, 000001534)}, // 01101011100
  {0x00a2, ulhc(11, 000001536)}, // 01101011110
  {0x00a9, ulhc(11, 000001570)}, // 01101111000
  {0xc00f, ulhc(11, 000001573)}, // 01101111011
  {0x004a, ulhc(11, 000001576)}, // 01101111110
  {0x9a5b, ulhc(11, 000001620)}, // 01110010000
  {0x0097, ulhc(11, 000001621)}, // 01110010001
  {0x0098, ulhc(11, 000001623)}, // 01110010011
  {0x009f, ulhc(11, 000001624)}, // 01110010100
  {0x00a3, ulhc(11, 000001626)}, // 01110010110
  {0x008f, ulhc(11, 000001627)}, // 01110010111
  {0x2f7e, ulhc(11, 000001632)}, // 01110011010
  {0xd069, ulhc(11, 000001633)}, // 01110011011
  {0x00b0, ulhc(11, 000001634)}, // 01110011100
  {0x00c1, ulhc(11, 000001635)}, // 01110011101
  {0xf4c8, ulhc(11, 000001636)}, // 01110011110
  {0xd05a, ulhc(11, 000001637)}, // 01110011111
  {0xd065, ulhc(11, 000001651)}, // 01110101001
  {0x009d, ulhc(11, 000001660)}, // 01110110000
  {0xd00f, ulhc(11, 000001675)}, // 01110111101
  {0xd057, ulhc(11, 000001677)}, // 01110111111
  {0xd062, ulhc(11, 000001712)}, // 01111001010
  {0xd01b, ulhc(11, 000001714)}, // 01111001100
  {0x00d0, ulhc(11, 000001740)}, // 01111100000
  {0x00b5, ulhc(11, 000001746)}, // 01111100110
  {0xd044, ulhc(11, 000001751)}, // 01111101001
  {0x00ab, ulhc(11, 000001752)}, // 01111101010
  {0x00c4, ulhc(11, 000002002)}, // 10000000010
  {0x008e, ulhc(11, 000002032)}, // 10000011010
  {0xd06d, ulhc(11, 000002034)}, // 10000011100
  {0x0094, ulhc(11, 000002035)}, // 10000011101
  {0xc014, ulhc(11, 000002037)}, // 10000011111
  {0xf7f9, ulhc(11, 000002040)}, // 10000100000
  {0x0768, ulhc(11, 000002074)}, // 10000111100
  {0x9187, ulhc(11, 000002075)}, // 10000111101
  {0xb76b, ulhc(11, 000002076)}, // 10000111110
  {0x005e, ulhc(11, 000002106)}, // 10001000110
  {0x0092, ulhc(11, 000002110)}, // 10001001000
  {0x9a53, ulhc(11, 000002111)}, // 10001001001
  {0xe087, ulhc(11, 000002113)}, // 10001001011
  {0x0099, ulhc(11, 000002114)}, // 10001001100
  {0x0084, ulhc(11, 000002115)}, // 10001001101
  {0x008c, ulhc(11, 000002117)}, // 10001001111
  {0xcfc6, ulhc(11, 000002143)}, // 10001100011
  {0xd022, ulhc(11, 000002160)}, // 10001110000
  {0x0091, ulhc(11, 000002161)}, // 10001110001
  {0x0065, ulhc(11, 000002164)}, // 10001110100
  {0x00c9, ulhc(11, 000002165)}, // 10001110101
  {0x008a, ulhc(11, 000002214)}, // 10010001100
  {0x009a, ulhc(11, 000002215)}, // 10010001101
  {0x004f, ulhc(11, 000002217)}, // 10010001111
  {0x0081, ulhc(11, 000002405)}, // 10100000101
  {0xd061, ulhc(11, 000002406)}, // 10100000110
  {0x0054, ulhc(11, 000002422)}, // 10100010010
  {0xd039, ulhc(11, 000002423)}, // 10100010011
  {0xd056, ulhc(11, 000002424)}, // 10100010100
  {0x0083, ulhc(11, 000002425)}, // 10100010101
  {0x0085, ulhc(11, 000002426)}, // 10100010110
  {0x9732, ulhc(11, 000002446)}, // 10100100110
  {0x008d, ulhc(11, 000002447)}, // 10100100111
  {0x0087, ulhc(11, 000002454)}, // 10100101100
  {0xd05b, ulhc(11, 000002456)}, // 10100101110
  {0x005f, ulhc(11, 000002457)}, // 10100101111
  {0xd05e, ulhc(11, 000002564)}, // 10101110100
  {0xe089, ulhc(11, 000002567)}, // 10101110111
  {0x00b2, ulhc(11, 000003020)}, // 11000010000
  {0x9960, ulhc(11, 000003021)}, // 11000010001
  {0xd024, ulhc(11, 000003022)}, // 11000010010
  {0xd060, ulhc(11, 000003024)}, // 11000010100
  {0x0066, ulhc(11, 000003025)}, // 11000010101
  {0xd05d, ulhc(11, 000003034)}, // 11000011100
  {0xd032, ulhc(11, 000003035)}, // 11000011101
  {0x0088, ulhc(11, 000003072)}, // 11000111010
  {0xf3f0, ulhc(11, 000003073)}, // 11000111011
  {0x0051, ulhc(11, 000003114)}, // 11001001100
  {0x006f, ulhc(11, 000003115)}, // 11001001101
  {0xd058, ulhc(11, 000003116)}, // 11001001110
  {0x006c, ulhc(11, 000003126)}, // 11001010110
  {0x007e, ulhc(11, 000003130)}, // 11001011000
  {0x006e, ulhc(11, 000003136)}, // 11001011110
  {0x0089, ulhc(11, 000003137)}, // 11001011111
  {0x0078, ulhc(11, 000003140)}, // 11001100000
  {0x007c, ulhc(11, 000003141)}, // 11001100001
  {0x0095, ulhc(11, 000003142)}, // 11001100010
  {0xd01c, ulhc(11, 000003143)}, // 11001100011
  {0x0061, ulhc(11, 000003144)}, // 11001100100
  {0x008b, ulhc(11, 000003145)}, // 11001100101
  {0x009c, ulhc(11, 000003146)}, // 11001100110
  {0x009b, ulhc(11, 000003201)}, // 11010000001
  {0xd023, ulhc(11, 000003202)}, // 11010000010
  {0xd02c, ulhc(11, 000003203)}, // 11010000011
  {0x007f, ulhc(11, 000003205)}, // 11010000101
  {0xdfea, ulhc(11, 000003206)}, // 11010000110
  {0x0059, ulhc(11, 000003217)}, // 11010001111
  {0xd05f, ulhc(11, 000003224)}, // 11010010100
  {0xd027, ulhc(11, 000003225)}, // 11010010101
  {0x007d, ulhc(11, 000003226)}, // 11010010110
  {0xd010, ulhc(11, 000003227)}, // 11010010111
  {0xdff8, ulhc(11, 000003275)}, // 11010111101
  {0xf4d1, ulhc(11, 000003300)}, // 11011000000
  {0x0093, ulhc(11, 000003301)}, // 11011000001
  {0x0070, ulhc(11, 000003312)}, // 11011001010
  {0xd068, ulhc(11, 000003313)}, // 11011001011
  {0xcfe5, ulhc(11, 000003316)}, // 11011001110
  {0x0077, ulhc(11, 000003324)}, // 11011010100
  {0x0063, ulhc(11, 000003330)}, // 11011011000
  {0x01fa, ulhc(11, 000003332)}, // 11011011010
  {0x0062, ulhc(11, 000003333)}, // 11011011011
  {0xcfed, ulhc(11, 000003336)}, // 11011011110
  {0xcfea, ulhc(11, 000003340)}, // 11011100000
  {0x0096, ulhc(11, 000003342)}, // 11011100010
  {0x006d, ulhc(11, 000003343)}, // 11011100011
  {0xf540, ulhc(11, 000003350)}, // 11011101000
  {0x0090, ulhc(11, 000003351)}, // 11011101001
  {0xf701, ulhc(11, 000003352)}, // 11011101010
  {0x007a, ulhc(11, 000003354)}, // 11011101100
  {0xd04f, ulhc(11, 000003360)}, // 11011110000
  {0xd050, ulhc(11, 000003361)}, // 11011110001
  {0x0058, ulhc(11, 000003364)}, // 11011110100
  {0xd020, ulhc(11, 000003370)}, // 11011111000
  {0xd054, ulhc(11, 000003372)}, // 11011111010
  {0xd066, ulhc(11, 000003373)}, // 11011111011
  {0x007b, ulhc(11, 000003374)}, // 11011111100
  {0x004e, ulhc(11, 000003406)}, // 11100000110
  {0x0050, ulhc(11, 000003407)}, // 11100000111
  {0xd029, ulhc(11, 000003410)}, // 11100001000
  {0xd05c, ulhc(11, 000003411)}, // 11100001001
  {0xb78b, ulhc(11, 000003507)}, // 11101000111
  {0xdff4, ulhc(11, 000003526)}, // 11101010110
  {0x005b, ulhc(11, 000003530)}, // 11101011000
  {0xd03b, ulhc(11, 000003532)}, // 11101011010
  {0x54e0, ulhc(11, 000003533)}, // 11101011011
  {0x0080, ulhc(11, 000003536)}, // 11101011110
  {0x0100, ulhc(11, 000003546)}, // 11101100110
  {0x0053, ulhc(11, 000003547)}, // 11101100111
  {0xd051, ulhc(11, 000003614)}, // 11110001100
  {0x006b, ulhc(11, 000003615)}, // 11110001101
  {0x0067, ulhc(11, 000003617)}, // 11110001111
  {0xd04a, ulhc(11, 000003620)}, // 11110010000
  {0xd02d, ulhc(11, 000003632)}, // 11110011010
  {0x0055, ulhc(11, 000003633)}, // 11110011011
  {0x006a, ulhc(11, 000003640)}, // 11110100000
  {0x0069, ulhc(11, 000003641)}, // 11110100001
  {0x0079, ulhc(11, 000003643)}, // 11110100011
  {0x005d, ulhc(11, 000003656)}, // 11110101110
  {0x0048, ulhc(11, 000003657)}, // 11110101111
  {0x0052, ulhc(11, 000003673)}, // 11110111011
  {0xc012, ulhc(11, 000003700)}, // 11111000000
  {0xd036, ulhc(11, 000003701)}, // 11111000001
  {0x0047, ulhc(11, 000003703)}, // 11111000011
  {0x0086, ulhc(11, 000003704)}, // 11111000100
  {0x005c, ulhc(11, 000003707)}, // 11111000111
  {0xd026, ulhc(11, 000003710)}, // 11111001000
  {0x83b5, ulhc(11, 000003712)}, // 11111001010
  {0xd037, ulhc(11, 000003730)}, // 11111011000
  {0xd04d, ulhc(11, 000003733)}, // 11111011011
  {0xd02a, ulhc(11, 000003765)}, // 11111110101
  {0x4177, ulhc(12, 000000001)}, // 000000000001
  {0x0036, ulhc(12, 000000104)}, // 000001000100
  {0xe0b0, ulhc(12, 000000117)}, // 000001001111
  {0x0033, ulhc(12, 000000211)}, // 000010001001
  {0xe270, ulhc(12, 000000212)}, // 000010001010
  {0xf4b8, ulhc(12, 000000213)}, // 000010001011
  {0xc00b, ulhc(12, 000000234)}, // 000010011100
  {0x002d, ulhc(12, 000000236)}, // 000010011110
  {0x4006, ulhc(12, 000000237)}, // 000010011111
  {0xd08f, ulhc(12, 000000522)}, // 000101010010
  {0xd095, ulhc(12, 000000523)}, // 000101010011
  {0xf4b1, ulhc(12, 000000525)}, // 000101010101
  {0xf780, ulhc(12, 000000526)}, // 000101010110
  {0xc049, ulhc(12, 000000532)}, // 000101011010
  {0xc04c, ulhc(12, 000000533)}, // 000101011011
  {0xb81a, ulhc(12, 000000547)}, // 000101100111
  {0x00da, ulhc(12, 000001015)}, // 001000001101
  {0x2802, ulhc(12, 000001016)}, // 001000001110
  {0x98c1, ulhc(12, 000001017)}, // 001000001111
  {0x9ab9, ulhc(12, 000001022)}, // 001000010010
  {0x9ac1, ulhc(12, 000001023)}, // 001000010011
  {0x0032, ulhc(12, 000001030)}, // 001000011000
  {0x0028, ulhc(12, 000001031)}, // 001000011001
  {0xdfe8, ulhc(12, 000001032)}, // 001000011010
  {0xe7c8, ulhc(12, 000001033)}, // 001000011011
  {0x0025, ulhc(12, 000001041)}, // 001000100001
  {0xd098, ulhc(12, 000001112)}, // 001001001010
  {0x4137, ulhc(12, 000001113)}, // 001001001011
  {0xe4e0, ulhc(12, 000001132)}, // 001001011010
  {0xc015, ulhc(12, 000001133)}, // 001001011011
  {0x00e7, ulhc(12, 000001151)}, // 001001101001
  {0x4176, ulhc(12, 000001152)}, // 001001101010
  {0xc0f5, ulhc(12, 000001205)}, // 001010000101
  {0x0042, ulhc(12, 000001330)}, // 001011011000
  {0x00d9, ulhc(12, 000001331)}, // 001011011001
  {0xe7fd, ulhc(12, 000001333)}, // 001011011011
  {0x00f2, ulhc(12, 000001524)}, // 001101010100
  {0x00f5, ulhc(12, 000001566)}, // 001101110110
  {0x00eb, ulhc(12, 000001567)}, // 001101110111
  {0x0020, ulhc(12, 000001606)}, // 001110000110
  {0xe1fd, ulhc(12, 000001622)}, // 001110010010
  {0x00d7, ulhc(12, 000001630)}, // 001110011000
  {0x95f3, ulhc(12, 000001631)}, // 001110011001
  {0xf709, ulhc(12, 000001632)}, // 001110011010
  {0x0022, ulhc(12, 000001633)}, // 001110011011
  {0xbb97, ulhc(12, 000001744)}, // 001111100100
  {0xd08c, ulhc(12, 000001746)}, // 001111100110
  {0x01c0, ulhc(12, 000001747)}, // 001111100111
  {0x4061, ulhc(12, 000002005)}, // 010000000101
  {0x00e8, ulhc(12, 000002034)}, // 010000011100
  {0x00e9, ulhc(12, 000002036)}, // 010000011110
  {0xd019, ulhc(12, 000002153)}, // 010001101011
  {0x0044, ulhc(12, 000002160)}, // 010001110000
  {0xefce, ulhc(12, 000002200)}, // 010010000000
  {0x002e, ulhc(12, 000002301)}, // 010011000001
  {0x0038, ulhc(12, 000002320)}, // 010011010000
  {0xf011, ulhc(12, 000002321)}, // 010011010001
  {0xd006, ulhc(12, 000002341)}, // 010011100001
  {0xd094, ulhc(12, 000002346)}, // 010011100110
  {0x01cf, ulhc(12, 000002370)}, // 010011111000
  {0x1181, ulhc(12, 000002371)}, // 010011111001
  {0x2b89, ulhc(12, 000002372)}, // 010011111010
  {0x5f8f, ulhc(12, 000002373)}, // 010011111011
  {0x9593, ulhc(12, 000002374)}, // 010011111100
  {0xc009, ulhc(12, 000002375)}, // 010011111101
  {0xf419, ulhc(12, 000002376)}, // 010011111110
  {0xf6b9, ulhc(12, 000002377)}, // 010011111111
  {0xe0d1, ulhc(12, 000002441)}, // 010100100001
  {0xd093, ulhc(12, 000002444)}, // 010100100100
  {0xd092, ulhc(12, 000002445)}, // 010100100101
  {0xe3fe, ulhc(12, 000002446)}, // 010100100110
  {0x003d, ulhc(12, 000002464)}, // 010100110100
  {0xd016, ulhc(12, 000002541)}, // 010101100001
  {0xd08b, ulhc(12, 000002647)}, // 010110100111
  {0xd078, ulhc(12, 000002673)}, // 010110111011
  {0x00f4, ulhc(12, 000002712)}, // 010111001010
  {0x00f3, ulhc(12, 000002714)}, // 010111001100
  {0xf568, ulhc(12, 000002715)}, // 010111001101
  {0xf7d0, ulhc(12, 000002716)}, // 010111001110
  {0x001f, ulhc(12, 000003010)}, // 011000001000
  {0xd08a, ulhc(12, 000003031)}, // 011000011001
  {0x0017, ulhc(12, 000003241)}, // 011010100001
  {0x0031, ulhc(12, 000003263)}, // 011010110011
  {0xf7f8, ulhc(12, 000003277)}, // 011010111111
  {0x9167, ulhc(12, 000003362)}, // 011011110010
  {0xf770, ulhc(12, 000003363)}, // 011011110011
  {0xf588, ulhc(12, 000003364)}, // 011011110100
  {0xf490, ulhc(12, 000003376)}, // 011011111110
  {0xb98b, ulhc(12, 000003444)}, // 011100100100
  {0xcfda, ulhc(12, 000003452)}, // 011100101010
  {0xd085, ulhc(12, 000003543)}, // 011101100011
  {0xe6a0, ulhc(12, 000003570)}, // 011101111000
  {0x003c, ulhc(12, 000003571)}, // 011101111001
  {0xed98, ulhc(12, 000003575)}, // 011101111101
  {0x00d5, ulhc(12, 000003626)}, // 011110010110
  {0xcfc4, ulhc(12, 000003627)}, // 011110010111
  {0xd083, ulhc(12, 000003702)}, // 011111000010
  {0x00cf, ulhc(12, 000003703)}, // 011111000011
  {0xf499, ulhc(12, 000003710)}, // 011111001000
  {0xdfef, ulhc(12, 000003712)}, // 011111001010
  {0x0008, ulhc(12, 000003720)}, // 011111010000
  {0xd028, ulhc(12, 000003726)}, // 011111010110
  {0x9871, ulhc(12, 000004050)}, // 100000101000
  {0x9a69, ulhc(12, 000004051)}, // 100000101001
  {0x0001, ulhc(12, 000004053)}, // 100000101011
  {0x0045, ulhc(12, 000004054)}, // 100000101100
  {0x00d3, ulhc(12, 000004055)}, // 100000101101
  {0xefcc, ulhc(12, 000004056)}, // 100000101110
  {0x0037, ulhc(12, 000004066)}, // 100000110110
  {0xd087, ulhc(12, 000004067)}, // 100000110111
  {0x0035, ulhc(12, 000004074)}, // 100000111100
  {0x00cd, ulhc(12, 000004102)}, // 100001000010
  {0xcfc9, ulhc(12, 000004103)}, // 100001000011
  {0xc03d, ulhc(12, 000004216)}, // 100010001110
  {0xcfec, ulhc(12, 000004217)}, // 100010001111
  {0xd091, ulhc(12, 000004235)}, // 100010011101
  {0x0991, ulhc(12, 000004421)}, // 100100010001
  {0x0041, ulhc(12, 000004422)}, // 100100010010
  {0x00d4, ulhc(12, 000004423)}, // 100100010011
  {0x0040, ulhc(12, 000004435)}, // 100100011101
  {0x9721, ulhc(12, 000005010)}, // 101000001000
  {0xd01f, ulhc(12, 000005011)}, // 101000001001
  {0x97b0, ulhc(12, 000005057)}, // 101000101111
  {0xe098, ulhc(12, 000005060)}, // 101000110000
  {0xf4a9, ulhc(12, 000005061)}, // 101000110001
  {0xf788, ulhc(12, 000005062)}, // 101000110010
  {0xe184, ulhc(12, 000005133)}, // 101001011011
  {0xe28c, ulhc(12, 000005352)}, // 101011101010
  {0xd090, ulhc(12, 000006046)}, // 110000100110
  {0x000f, ulhc(12, 000006055)}, // 110000101101
  {0xd089, ulhc(12, 000006075)}, // 110000111101
  {0xd015, ulhc(12, 000006077)}, // 110000111111
  {0x003f, ulhc(12, 000006161)}, // 110001110001
  {0x9a71, ulhc(12, 000006163)}, // 110001110011
  {0xe082, ulhc(12, 000006220)}, // 110010010000
  {0xf570, ulhc(12, 000006221)}, // 110010010001
  {0x4026, ulhc(12, 000006237)}, // 110010011111
  {0x0026, ulhc(12, 000006257)}, // 110010101111
  {0x9b77, ulhc(12, 000006316)}, // 110011001110
  {0xb18f, ulhc(12, 000006317)}, // 110011001111
  {0xb98f, ulhc(12, 000006324)}, // 110011010100
  {0xba18, ulhc(12, 000006325)}, // 110011010101
  {0xbb88, ulhc(12, 000006326)}, // 110011010110
  {0xd08e, ulhc(12, 000006327)}, // 110011010111
  {0xe1fe, ulhc(12, 000006400)}, // 110100000000
  {0x00d1, ulhc(12, 000006416)}, // 110100001110
  {0x0043, ulhc(12, 000006417)}, // 110100001111
  {0xd076, ulhc(12, 000006630)}, // 110110011000
  {0x00cb, ulhc(12, 000006633)}, // 110110011011
  {0xeffd, ulhc(12, 000006636)}, // 110110011110
  {0xe0b4, ulhc(12, 000006637)}, // 110110011111
  {0xe0bd, ulhc(12, 000006652)}, // 110110101010
  {0xd088, ulhc(12, 000006654)}, // 110110101100
  {0xd07e, ulhc(12, 000006655)}, // 110110101101
  {0x00bf, ulhc(12, 000006656)}, // 110110101110
  {0xd07a, ulhc(12, 000006662)}, // 110110110010
  {0xdfe2, ulhc(12, 000006670)}, // 110110111000
  {0xd07c, ulhc(12, 000006671)}, // 110110111001
  {0xb989, ulhc(12, 000006672)}, // 110110111010
  {0xe0b3, ulhc(12, 000006673)}, // 110110111011
  {0xe3b8, ulhc(12, 000006676)}, // 110110111110
  {0xeeb7, ulhc(12, 000006677)}, // 110110111111
  {0x002c, ulhc(12, 000006702)}, // 110111000010
  {0xd081, ulhc(12, 000006726)}, // 110111010110
  {0x00b7, ulhc(12, 000006727)}, // 110111010111
  {0xe7cc, ulhc(12, 000006732)}, // 110111011010
  {0x00b8, ulhc(12, 000006762)}, // 110111110010
  {0x00ba, ulhc(12, 000006763)}, // 110111110011
  {0x00bc, ulhc(12, 000006773)}, // 110111111011
  {0xd01a, ulhc(12, 000007012)}, // 111000001010
  {0xe3fd, ulhc(12, 000007205)}, // 111010000101
  {0x002a, ulhc(12, 000007207)}, // 111010000111
  {0xba17, ulhc(12, 000007214)}, // 111010001100
  {0x00b9, ulhc(12, 000007215)}, // 111010001101
  {0xb81d, ulhc(12, 000007234)}, // 111010011100
  {0xb98d, ulhc(12, 000007235)}, // 111010011101
  {0x01fc, ulhc(12, 000007237)}, // 111010011111
  {0xcfe8, ulhc(12, 000007256)}, // 111010101110
  {0x00c7, ulhc(12, 000007262)}, // 111010110010
  {0x00bd, ulhc(12, 000007270)}, // 111010111000
  {0x4066, ulhc(12, 000007271)}, // 111010111001
  {0x4027, ulhc(12, 000007273)}, // 111010111011
  {0xd086, ulhc(12, 000007277)}, // 111010111111
  {0x00c5, ulhc(12, 000007442)}, // 111100100010
  {0x00be, ulhc(12, 000007505)}, // 111101000101
  {0x00bb, ulhc(12, 000007524)}, // 111101010100
  {0x00c2, ulhc(12, 000007525)}, // 111101010101
  {0xd06f, ulhc(12, 000007527)}, // 111101010111
  {0x5ce0, ulhc(12, 000007564)}, // 111101110100
  {0x00ca, ulhc(12, 000007565)}, // 111101110101
  {0xd071, ulhc(12, 000007605)}, // 111110000101
  {0x00c3, ulhc(12, 000007612)}, // 111110001010
  {0xd074, ulhc(12, 000007614)}, // 111110001100
  {0xd075, ulhc(12, 000007615)}, // 111110001101
  {0x985b, ulhc(12, 000007623)}, // 111110010011
  {0xd073, ulhc(12, 000007627)}, // 111110010111
  {0xeb90, ulhc(12, 000007662)}, // 111110110010
  {0xd080, ulhc(12, 000007665)}, // 111110110101
  {0xe78f, ulhc(12, 000007742)}, // 111111100010
  {0x0039, ulhc(12, 000007750)}, // 111111101000
  {0xcfe4, ulhc(12, 000007751)}, // 111111101001
  {0xd0a0, ulhc(13, 000000000)}, // 0000000000000
  {0x017c, ulhc(13, 000000212)}, // 0000010001010
  {0xc13d, ulhc(13, 000000213)}, // 0000010001011
  {0x002b, ulhc(13, 000000261)}, // 0000010110001
  {0xcfc1, ulhc(13, 000000262)}, // 0000010110010
  {0xe084, ulhc(13, 000000263)}, // 0000010110011
  {0xee87, ulhc(13, 000000420)}, // 0000100010000
  {0x002f, ulhc(13, 000000472)}, // 0000100111010
  {0xd0b4, ulhc(13, 000001250)}, // 0001010101000
  {0x017e, ulhc(13, 000001251)}, // 0001010101001
  {0xd09f, ulhc(13, 000001256)}, // 0001010101110
  {0x2202, ulhc(13, 000001315)}, // 0001011001101
  {0xc0b2, ulhc(13, 000001334)}, // 0001011011100
  {0x01fe, ulhc(13, 000001336)}, // 0001011011110
  {0xbf96, ulhc(13, 000002005)}, // 0010000000101
  {0xefcd, ulhc(13, 000002006)}, // 0010000000110
  {0xb981, ulhc(13, 000002007)}, // 0010000000111
  {0x4157, ulhc(13, 000002031)}, // 0010000011001
  {0x0178, ulhc(13, 000002100)}, // 0010001000000
  {0x4004, ulhc(13, 000002250)}, // 0010010101000
  {0xd0ab, ulhc(13, 000002320)}, // 0010011010000
  {0xc0a7, ulhc(13, 000002326)}, // 0010011010110
  {0xc1f5, ulhc(13, 000002327)}, // 0010011010111
  {0x00f0, ulhc(13, 000002414)}, // 0010100001100
  {0x001c, ulhc(13, 000002415)}, // 0010100001101
  {0x9a11, ulhc(13, 000002417)}, // 0010100001111
  {0x00ed, ulhc(13, 000002665)}, // 0010110110101
  {0xe388, ulhc(13, 000003253)}, // 0011010101011
  {0x9900, ulhc(13, 000003417)}, // 0011100001111
  {0x4046, ulhc(13, 000003712)}, // 0011111001010
  {0x31a0, ulhc(13, 000004034)}, // 0100000011100
  {0x0021, ulhc(13, 000004035)}, // 0100000011101
  {0x017a, ulhc(13, 000004064)}, // 0100000110100
  {0x9942, ulhc(13, 000004066)}, // 0100000110110
  {0x0002, ulhc(13, 000004067)}, // 0100000110111
  {0xd0aa, ulhc(13, 000004072)}, // 0100000111010
  {0xc1f9, ulhc(13, 000004324)}, // 0100011010100
  {0xc03c, ulhc(13, 000004403)}, // 0100100000011
  {0xcfdb, ulhc(13, 000004700)}, // 0100111000000
  {0x001e, ulhc(13, 000004716)}, // 0100111001110
  {0xd0a6, ulhc(13, 000004717)}, // 0100111001111
  {0xe7fe, ulhc(13, 000005100)}, // 0101001000000
  {0x00ec, ulhc(13, 000005153)}, // 0101001101011
  {0xd011, ulhc(13, 000005300)}, // 0101011000000
  {0xcfcc, ulhc(13, 000005324)}, // 0101011010100
  {0x4170, ulhc(13, 000005565)}, // 0101101110101
  {0x00fe, ulhc(13, 000005636)}, // 0101110011110
  {0x1b03, ulhc(13, 000006023)}, // 0110000010011
  {0xc149, ulhc(13, 000006060)}, // 0110000110000
  {0xc022, ulhc(13, 000006501)}, // 0110101000001
  {0x9908, ulhc(13, 000006564)}, // 0110101110100
  {0x7fe0, ulhc(13, 000006565)}, // 0110101110101
  {0x9770, ulhc(13, 000006566)}, // 0110101110110
  {0xd09e, ulhc(13, 000006567)}, // 0110101110111
  {0xe170, ulhc(13, 000006574)}, // 0110101111100
  {0x1b02, ulhc(13, 000006753)}, // 0110111101011
  {0xc0ef, ulhc(13, 000006777)}, // 0110111111111
  {0xc028, ulhc(13, 000007112)}, // 0111001001010
  {0xd0a8, ulhc(13, 000007127)}, // 0111001010111
  {0x9a28, ulhc(13, 000007464)}, // 0111100110100
  {0xe882, ulhc(13, 000007465)}, // 0111100110101
  {0xbb87, ulhc(13, 000007623)}, // 0111110010011
  {0xf550, ulhc(13, 000007627)}, // 0111110010111
  {0xcfcf, ulhc(13, 000007634)}, // 0111110011100
  {0xcfd0, ulhc(13, 000007642)}, // 0111110100010
  {0xd09b, ulhc(13, 000010014)}, // 1000000001100
  {0xc043, ulhc(13, 000010136)}, // 1000001011110
  {0x0011, ulhc(13, 000010172)}, // 1000001111010
  {0x00e4, ulhc(13, 000010376)}, // 1000011111110
  {0xd09c, ulhc(13, 000010452)}, // 1000100101010
  {0x00e5, ulhc(13, 000010612)}, // 1000110001010
  {0xd099, ulhc(13, 000011040)}, // 1001000100000
  {0x0029, ulhc(13, 000011071)}, // 1001000111001
  {0x0024, ulhc(13, 000012034)}, // 1010000011100
  {0xc018, ulhc(13, 000012037)}, // 1010000011111
  {0x00f6, ulhc(13, 000012147)}, // 1010001100111
  {0x2402, ulhc(13, 000012265)}, // 1010010110101
  {0x00f1, ulhc(13, 000012726)}, // 1010111010110
  {0x4171, ulhc(13, 000012727)}, // 1010111010111
  {0x4007, ulhc(13, 000012732)}, // 1010111011010
  {0x00e3, ulhc(13, 000014116)}, // 1100001001110
  {0xeffb, ulhc(13, 000014117)}, // 1100001001111
  {0xf4d0, ulhc(13, 000014131)}, // 1100001011001
  {0x0130, ulhc(13, 000014134)}, // 1100001011100
  {0xd09d, ulhc(13, 000014135)}, // 1100001011101
  {0x00e6, ulhc(13, 000014170)}, // 1100001111000
  {0x0136, ulhc(13, 000014171)}, // 1100001111001
  {0x0201, ulhc(13, 000014174)}, // 1100001111100
  {0xf538, ulhc(13, 000014344)}, // 1100011100100
  {0x4136, ulhc(13, 000014445)}, // 1100100100101
  {0x00e2, ulhc(13, 000014475)}, // 1100100111101
  {0xd013, ulhc(13, 000014535)}, // 1100101011101
  {0x4047, ulhc(13, 000014545)}, // 1100101100101
  {0xdfed, ulhc(13, 000015003)}, // 1101000000011
  {0xcfc3, ulhc(13, 000015020)}, // 1101000010000
  {0x238e, ulhc(13, 000015021)}, // 1101000010001
  {0xb994, ulhc(13, 000015023)}, // 1101000010011
  {0xcfde, ulhc(13, 000015070)}, // 1101000111000
  {0x00e1, ulhc(13, 000015072)}, // 1101000111010
  {0xdff1, ulhc(13, 000015073)}, // 1101000111011
  {0x0003, ulhc(13, 000015360)}, // 1101011110000
  {0x0030, ulhc(13, 000015362)}, // 1101011110010
  {0x7ee0, ulhc(13, 000015462)}, // 1101100110010
  {0x00dc, ulhc(13, 000015463)}, // 1101100110011
  {0xb81b, ulhc(13, 000015526)}, // 1101101010110
  {0xcfcb, ulhc(13, 000015536)}, // 1101101011110
  {0xe380, ulhc(13, 000015546)}, // 1101101100110
  {0x00df, ulhc(13, 000015724)}, // 1101111010100
  {0x00e0, ulhc(13, 000015725)}, // 1101111010101
  {0x00de, ulhc(13, 000015727)}, // 1101111010111
  {0xd097, ulhc(13, 000016026)}, // 1110000010110
  {0xffff, ulhc(13, 000016027)}, // 1110000010111
  {0xe0fe, ulhc(13, 000016475)}, // 1110100111101
  {0x00dd, ulhc(13, 000016537)}, // 1110101011111
  {0x9010, ulhc(13, 000016546)}, // 1110101100110
  {0x00d8, ulhc(13, 000016575)}, // 1110101111101
  {0xc01f, ulhc(13, 000017070)}, // 1111000111000
  {0xf528, ulhc(13, 000017255)}, // 1111010101101
  {0x00ea, ulhc(13, 000017426)}, // 1111100010110
  {0xd096, ulhc(13, 000017427)}, // 1111100010111
  {0x0034, ulhc(13, 000017445)}, // 1111100100101
  {0xe18f, ulhc(13, 000017454)}, // 1111100101100
  {0xd08d, ulhc(13, 000017546)}, // 1111101100110
  {0xd09a, ulhc(13, 000017547)}, // 1111101100111
  {0x4060, ulhc(13, 000017550)}, // 1111101101000
  {0xc00d, ulhc(13, 000017700)}, // 1111111000000
  {0xf4e1, ulhc(13, 000017701)}, // 1111111000001
  {0x00db, ulhc(13, 000017707)}, // 1111111000111
  {0xe0f1, ulhc(14, 000000470)}, // 00000100111000
  {0xe3e0, ulhc(14, 000000471)}, // 00000100111001
  {0xf580, ulhc(14, 000000472)}, // 00000100111010
  {0xf598, ulhc(14, 000000473)}, // 00000100111011
  {0x9811, ulhc(14, 000000541)}, // 00000101100001
  {0x9a09, ulhc(14, 000001042)}, // 00001000100010
  {0x4116, ulhc(14, 000001060)}, // 00001000110000
  {0x9210, ulhc(14, 000001061)}, // 00001000110001
  {0x9670, ulhc(14, 000001062)}, // 00001000110010
  {0xba1a, ulhc(14, 000001063)}, // 00001000110011
  {0xba1b, ulhc(14, 000001064)}, // 00001000110100
  {0xbb8a, ulhc(14, 000001065)}, // 00001000110101
  {0xbb8b, ulhc(14, 000001066)}, // 00001000110110
  {0xf719, ulhc(14, 000001067)}, // 00001000110111
  {0x016c, ulhc(14, 000002673)}, // 00010110111011
  {0x01a0, ulhc(14, 000002676)}, // 00010110111110
  {0x9853, ulhc(14, 000004060)}, // 00100000110000
  {0x9a4b, ulhc(14, 000004061)}, // 00100000110001
  {0x40e7, ulhc(14, 000004202)}, // 00100010000010
  {0xc0ca, ulhc(14, 000004643)}, // 00100110100011
  {0xc143, ulhc(14, 000005020)}, // 00101000010000
  {0x4156, ulhc(14, 000005023)}, // 00101000010011
  {0xcfd4, ulhc(14, 000005034)}, // 00101000011100
  {0x1908, ulhc(14, 000005035)}, // 00101000011101
  {0x9b60, ulhc(14, 000007034)}, // 00111000011100
  {0xc036, ulhc(14, 000007035)}, // 00111000011101
  {0x0016, ulhc(14, 000007115)}, // 00111001001101
  {0x0f3a, ulhc(14, 000007116)}, // 00111001001110
  {0x133a, ulhc(14, 000007117)}, // 00111001001111
  {0x2f38, ulhc(14, 000007120)}, // 00111001010000
  {0xc02a, ulhc(14, 000007121)}, // 00111001010001
  {0xe0d3, ulhc(14, 000007122)}, // 00111001010010
  {0xe0f6, ulhc(14, 000007123)}, // 00111001010011
  {0xc0fd, ulhc(14, 000007627)}, // 00111110010111
  {0x1303, ulhc(14, 000010020)}, // 01000000010000
  {0x1503, ulhc(14, 000010021)}, // 01000000010001
  {0xc0df, ulhc(14, 000010074)}, // 01000000111100
  {0xc01a, ulhc(14, 000010152)}, // 01000001101010
  {0xed80, ulhc(14, 000010166)}, // 01000001110110
  {0x013a, ulhc(14, 000010177)}, // 01000001111111
  {0x013c, ulhc(14, 000010653)}, // 01000110101011
  {0x4000, ulhc(14, 000010704)}, // 01000111000100
  {0x0168, ulhc(14, 000010706)}, // 01000111000110
  {0x9819, ulhc(14, 000010707)}, // 01000111000111
  {0x9a19, ulhc(14, 000011004)}, // 01001000000100
  {0x0176, ulhc(14, 000011403)}, // 01001100000011
  {0xd0b0, ulhc(14, 000012235)}, // 01010010011101
  {0x016a, ulhc(14, 000012237)}, // 01010010011111
  {0xc017, ulhc(14, 000012324)}, // 01010011010100
  {0xcfbf, ulhc(14, 000012325)}, // 01010011010101
  {0xc031, ulhc(14, 000012652)}, // 01010110101010
  {0xc0db, ulhc(14, 000012653)}, // 01010110101011
  {0xe7c9, ulhc(14, 000012654)}, // 01010110101100
  {0x1907, ulhc(14, 000012656)}, // 01010110101110
  {0xd0af, ulhc(14, 000012657)}, // 01010110101111
  {0xc035, ulhc(14, 000013351)}, // 01011011101001
  {0xd0b9, ulhc(14, 000013456)}, // 01011100101110
  {0xc03b, ulhc(14, 000013476)}, // 01011100111110
  {0xc0ae, ulhc(14, 000014044)}, // 01100000100100
  {0xc034, ulhc(14, 000015201)}, // 01101010000001
  {0x016e, ulhc(14, 000015373)}, // 01101011111011
  {0x1404, ulhc(14, 000015724)}, // 01101111010100
  {0x83b6, ulhc(14, 000015725)}, // 01101111010101
  {0xb980, ulhc(14, 000015774)}, // 01101111111100
  {0xcfd8, ulhc(14, 000016227)}, // 01110010010111
  {0x013e, ulhc(14, 000016255)}, // 01110010101101
  {0x9790, ulhc(14, 000016502)}, // 01110101000010
  {0xc139, ulhc(14, 000016503)}, // 01110101000011
  {0xf560, ulhc(14, 000016504)}, // 01110101000100
  {0xd0ae, ulhc(14, 000016761)}, // 01110111110001
  {0xf4d8, ulhc(14, 000016762)}, // 01110111110010
  {0x994f, ulhc(14, 000017154)}, // 01111001101100
  {0xc0ed, ulhc(14, 000017444)}, // 01111100100100
  {0xe093, ulhc(14, 000017445)}, // 01111100100101
  {0xfd83, ulhc(14, 000017454)}, // 01111100101100
  {0xd0b2, ulhc(14, 000017534)}, // 01111101011100
  {0x00f8, ulhc(14, 000017537)}, // 01111101011111
  {0x99ca, ulhc(14, 000020033)}, // 10000000011011
  {0xc0aa, ulhc(14, 000020034)}, // 10000000011100
  {0xc0c7, ulhc(14, 000020035)}, // 10000000011101
  {0xd0b1, ulhc(14, 000020036)}, // 10000000011110
  {0xeffc, ulhc(14, 000020037)}, // 10000000011111
  {0x0174, ulhc(14, 000020252)}, // 10000010101010
  {0xd0a1, ulhc(14, 000020253)}, // 10000010101011
  {0x9a50, ulhc(14, 000020773)}, // 10000111111011
  {0xd0a4, ulhc(14, 000021120)}, // 10001001010000
  {0xe0bf, ulhc(14, 000021121)}, // 10001001010001
  {0xfd94, ulhc(14, 000021122)}, // 10001001010010
  {0xff80, ulhc(14, 000021123)}, // 10001001010011
  {0xc0ce, ulhc(14, 000021420)}, // 10001100010000
  {0xd0b3, ulhc(14, 000021421)}, // 10001100010001
  {0xe980, ulhc(14, 000021423)}, // 10001100010011
  {0xc032, ulhc(14, 000022102)}, // 10010001000010
  {0x0172, ulhc(14, 000024073)}, // 10100000111011
  {0x2502, ulhc(14, 000024074)}, // 10100000111100
  {0xcfcd, ulhc(14, 000024270)}, // 10100010111000
  {0xd0b8, ulhc(14, 000024272)}, // 10100010111010
  {0x0160, ulhc(14, 000025660)}, // 10101110110000
  {0x9b80, ulhc(14, 000025667)}, // 10101110110111
  {0x0170, ulhc(14, 000030275)}, // 11000010111101
  {0x1903, ulhc(14, 000030276)}, // 11000010111110
  {0xede0, ulhc(14, 000030372)}, // 11000011111010
  {0x9914, ulhc(14, 000030700)}, // 11000111000000
  {0xc075, ulhc(14, 000030703)}, // 11000111000011
  {0xcfdf, ulhc(14, 000030713)}, // 11000111001011
  {0xc0b4, ulhc(14, 000031110)}, // 11001001001000
  {0x1403, ulhc(14, 000031114)}, // 11001001001100
  {0xd0b6, ulhc(14, 000031115)}, // 11001001001101
  {0xc0ee, ulhc(14, 000031270)}, // 11001010111000
  {0xcfeb, ulhc(14, 000031271)}, // 11001010111001
  {0x9b15, ulhc(14, 000031311)}, // 11001011001001
  {0x9b17, ulhc(14, 000031314)}, // 11001011001100
  {0xb183, ulhc(14, 000031315)}, // 11001011001101
  {0xb983, ulhc(14, 000031316)}, // 11001011001110
  {0xc045, ulhc(14, 000032044)}, // 11010000100100
  {0x9919, ulhc(14, 000032163)}, // 11010001110011
  {0xd0ad, ulhc(14, 000032746)}, // 11010111100110
  {0x00ef, ulhc(14, 000033150)}, // 11011001101000
  {0xc033, ulhc(14, 000033276)}, // 11011010111110
  {0x9b48, ulhc(14, 000033316)}, // 11011011001110
  {0x1b04, ulhc(14, 000033414)}, // 11011100001100
  {0xd0a2, ulhc(14, 000033554)}, // 11011101101100
  {0x0280, ulhc(14, 000033555)}, // 11011101101101
  {0xd0a9, ulhc(14, 000033556)}, // 11011101101110
  {0xeb8f, ulhc(14, 000033557)}, // 11011101101111
  {0xc0f1, ulhc(14, 000033654)}, // 11011110101100
  {0xcfd2, ulhc(14, 000033750)}, // 11011111101000
  {0x01f8, ulhc(14, 000033751)}, // 11011111101001
  {0xd0a3, ulhc(14, 000034047)}, // 11100000100111
  {0x0027, ulhc(14, 000035020)}, // 11101000010000
  {0xb9b9, ulhc(14, 000035021)}, // 11101000010001
  {0xdfe1, ulhc(14, 000035022)}, // 11101000010010
  {0xd0a7, ulhc(14, 000035030)}, // 11101000011000
  {0xb982, ulhc(14, 000035032)}, // 11101000011010
  {0xc12f, ulhc(14, 000035033)}, // 11101000011011
  {0xcfd3, ulhc(14, 000035170)}, // 11101001111000
  {0xf518, ulhc(14, 000035275)}, // 11101010111101
  {0xc0dd, ulhc(14, 000035316)}, // 11101011001110
  {0x00ee, ulhc(14, 000035317)}, // 11101011001111
  {0x1904, ulhc(14, 000035350)}, // 11101011101000
  {0x1c04, ulhc(14, 000035351)}, // 11101011101001
  {0xd0a5, ulhc(14, 000035352)}, // 11101011101010
  {0xdfde, ulhc(14, 000035353)}, // 11101011101011
  {0xd0b5, ulhc(14, 000036162)}, // 11110001110010
  {0x83b2, ulhc(14, 000036163)}, // 11110001110011
  {0xc0c9, ulhc(14, 000036164)}, // 11110001110100
  {0xcfd5, ulhc(14, 000036166)}, // 11110001110110
  {0xd0b7, ulhc(14, 000036167)}, // 11110001110111
  {0xe08d, ulhc(14, 000036214)}, // 11110010001100
  {0x1905, ulhc(14, 000036216)}, // 11110010001110
  {0x00fc, ulhc(14, 000036217)}, // 11110010001111
  {0x1906, ulhc(14, 000036421)}, // 11110100010001
  {0xcfc0, ulhc(14, 000036422)}, // 11110100010010
  {0x9b4a, ulhc(14, 000036423)}, // 11110100010011
  {0xc0eb, ulhc(14, 000036530)}, // 11110101011000
  {0x1c03, ulhc(14, 000037021)}, // 11111000010001
  {0xc0d2, ulhc(14, 000037022)}, // 11111000010010
  {0x00fa, ulhc(14, 000037110)}, // 11111001001000
  {0xe780, ulhc(14, 000037111)}, // 11111001001001
  {0x0300, ulhc(14, 000037605)}, // 11111110000101
  {0xc0f9, ulhc(14, 000037606)}, // 11111110000110
  {0xd0ac, ulhc(14, 000037607)}, // 11111110000111
  {0xcfd1, ulhc(14, 000037615)}, // 11111110001101
  {0x01aa, ulhc(15, 000000004)}, // 000000000000100
  {0xc0ad, ulhc(15, 000000005)}, // 000000000000101
  {0x0e06, ulhc(15, 000000007)}, // 000000000000111
  {0xc08a, ulhc(15, 000001300)}, // 000001011000000
  {0xc0bd, ulhc(15, 000001301)}, // 000001011000001
  {0x4086, ulhc(15, 000002107)}, // 000010001000111
  {0xcf98, ulhc(15, 000002354)}, // 000010011101100
  {0xcf9e, ulhc(15, 000002355)}, // 000010011101101
  {0x000c, ulhc(15, 000002357)}, // 000010011101111
  {0xcf97, ulhc(15, 000005274)}, // 000101010111100
  {0xd0d0, ulhc(15, 000005275)}, // 000101010111101
  {0x011a, ulhc(15, 000005463)}, // 000101100110011
  {0x0166, ulhc(15, 000005564)}, // 000101101110100
  {0xc0f3, ulhc(15, 000005565)}, // 000101101110101
  {0xe7c7, ulhc(15, 000005576)}, // 000101101111110
  {0x010e, ulhc(15, 000005577)}, // 000101101111111
  {0x0114, ulhc(15, 000010020)}, // 001000000010000
  {0x1f03, ulhc(15, 000010021)}, // 001000000010001
  {0xc09d, ulhc(15, 000010022)}, // 001000000010010
  {0xe9e0, ulhc(15, 000010023)}, // 001000000010011
  {0x0e1c, ulhc(15, 000010407)}, // 001000100000111
  {0x40e1, ulhc(15, 000011244)}, // 001001010100100
  {0x41f6, ulhc(15, 000011245)}, // 001001010100101
  {0x997f, ulhc(15, 000011246)}, // 001001010100110
  {0xc1b8, ulhc(15, 000011247)}, // 001001010100111
  {0xeec4, ulhc(15, 000011250)}, // 001001010101000
  {0x1405, ulhc(15, 000012042)}, // 001010000100010
  {0x4001, ulhc(15, 000012043)}, // 001010000100011
  {0xc108, ulhc(15, 000012044)}, // 001010000100100
  {0x0113, ulhc(15, 000013320)}, // 001011011010000
  {0x1e04, ulhc(15, 000013321)}, // 001011011010001
  {0xcf91, ulhc(15, 000013322)}, // 001011011010010
  {0xd0c5, ulhc(15, 000013323)}, // 001011011010011
  {0x0142, ulhc(15, 000015252)}, // 001101010101010
  {0x1e03, ulhc(15, 000015253)}, // 001101010101011
  {0xcf9d, ulhc(15, 000016230)}, // 001110010011000
  {0xc0c6, ulhc(15, 000016231)}, // 001110010011001
  {0xcfb7, ulhc(15, 000016250)}, // 001110010101000
  {0x1f04, ulhc(15, 000017455)}, // 001111100101101
  {0x0162, ulhc(15, 000020044)}, // 010000000100100
  {0x01f0, ulhc(15, 000020045)}, // 010000000100101
  {0x014c, ulhc(15, 000020172)}, // 010000001111010
  {0x01f2, ulhc(15, 000020173)}, // 010000001111011
  {0x01f4, ulhc(15, 000020174)}, // 010000001111100
  {0xc079, ulhc(15, 000020175)}, // 010000001111101
  {0xcfb6, ulhc(15, 000020176)}, // 010000001111110
  {0xe3c9, ulhc(15, 000020177)}, // 010000001111111
  {0x0023, ulhc(15, 000020327)}, // 010000011010111
  {0x1106, ulhc(15, 000020356)}, // 010000011101110
  {0xc024, ulhc(15, 000020357)}, // 010000011101111
  {0xc0dc, ulhc(15, 000020370)}, // 010000011111000
  {0xcfa4, ulhc(15, 000020371)}, // 010000011111001
  {0x015c, ulhc(15, 000021525)}, // 010001101010101
  {0xc0b8, ulhc(15, 000021612)}, // 010001110001010
  {0xcfb9, ulhc(15, 000021613)}, // 010001110001011
  {0x01a2, ulhc(15, 000022013)}, // 010010000001011
  {0x1e02, ulhc(15, 000023000)}, // 010011000000000
  {0x1f05, ulhc(15, 000023001)}, // 010011000000001
  {0xc0a6, ulhc(15, 000023002)}, // 010011000000010
  {0xc101, ulhc(15, 000023003)}, // 010011000000011
  {0xc17d, ulhc(15, 000023004)}, // 010011000000100
  {0x01ea, ulhc(15, 000023005)}, // 010011000000101
  {0xcfb4, ulhc(15, 000023404)}, // 010011100000100
  {0xefcb, ulhc(15, 000023405)}, // 010011100000101
  {0x010d, ulhc(15, 000023407)}, // 010011100000111
  {0x019c, ulhc(15, 000024406)}, // 010100100000110
  {0x01a8, ulhc(15, 000024407)}, // 010100100000111
  {0xff84, ulhc(15, 000024470)}, // 010100100111000
  {0x2801, ulhc(15, 000024474)}, // 010100100111100
  {0x0110, ulhc(15, 000025405)}, // 010101100000101
  {0x01ae, ulhc(15, 000025406)}, // 010101100000110
  {0xc0d4, ulhc(15, 000025407)}, // 010101100000111
  {0xcfaf, ulhc(15, 000025532)}, // 010101101011010
  {0x0106, ulhc(15, 000025533)}, // 010101101011011
  {0x0111, ulhc(15, 000026460)}, // 010110100110000
  {0xc1ad, ulhc(15, 000026461)}, // 010110100110001
  {0xcfb2, ulhc(15, 000026462)}, // 010110100110010
  {0x00f9, ulhc(15, 000027130)}, // 010111001011000
  {0x0105, ulhc(15, 000027131)}, // 010111001011001
  {0x0120, ulhc(15, 000027132)}, // 010111001011010
  {0x01ac, ulhc(15, 000027133)}, // 010111001011011
  {0x1f06, ulhc(15, 000027137)}, // 010111001011111
  {0xc0b5, ulhc(15, 000027176)}, // 010111001111110
  {0xc0c5, ulhc(15, 000027177)}, // 010111001111111
  {0x0108, ulhc(15, 000030113)}, // 011000001001011
  {0x40a6, ulhc(15, 000030304)}, // 011000011000100
  {0x98d9, ulhc(15, 000030305)}, // 011000011000101
  {0x9ad1, ulhc(15, 000030306)}, // 011000011000110
  {0x9ad9, ulhc(15, 000030307)}, // 011000011000111
  {0xcf84, ulhc(15, 000032400)}, // 011010100000000
  {0xcf9a, ulhc(15, 000032620)}, // 011010110010000
  {0xefc8, ulhc(15, 000032621)}, // 011010110010001
  {0x0104, ulhc(15, 000032627)}, // 011010110010111
  {0x0109, ulhc(15, 000032764)}, // 011010111110100
  {0xe7fb, ulhc(15, 000032765)}, // 011010111110101
  {0xc0d1, ulhc(15, 000033772)}, // 011011111111010
  {0x40e6, ulhc(15, 000034531)}, // 011100101011001
  {0xf481, ulhc(15, 000035200)}, // 011101010000000
  {0xf7c0, ulhc(15, 000035201)}, // 011101010000001
  {0x000e, ulhc(15, 000035203)}, // 011101010000011
  {0x0138, ulhc(15, 000035212)}, // 011101010001010
  {0x1003, ulhc(15, 000035213)}, // 011101010001011
  {0x1004, ulhc(15, 000035214)}, // 011101010001100
  {0xc11f, ulhc(15, 000035215)}, // 011101010001101
  {0xf4f1, ulhc(15, 000035216)}, // 011101010001110
  {0xf7d8, ulhc(15, 000035217)}, // 011101010001111
  {0x01be, ulhc(15, 000035741)}, // 011101111100001
  {0xc030, ulhc(15, 000035746)}, // 011101111100110
  {0xc087, ulhc(15, 000035747)}, // 011101111100111
  {0x985e, ulhc(15, 000036332)}, // 011110011011010
  {0x9a56, ulhc(15, 000036333)}, // 011110011011011
  {0x9a5e, ulhc(15, 000036334)}, // 011110011011100
  {0xcf99, ulhc(15, 000036337)}, // 011110011011111
  {0xcfb3, ulhc(15, 000037132)}, // 011111001011010
  {0x0112, ulhc(15, 000037133)}, // 011111001011011
  {0x019e, ulhc(15, 000037164)}, // 011111001110100
  {0x01ec, ulhc(15, 000037165)}, // 011111001110101
  {0xb625, ulhc(15, 000037166)}, // 011111001110110
  {0xbd9f, ulhc(15, 000037167)}, // 011111001110111
  {0xbe15, ulhc(15, 000037170)}, // 011111001111000
  {0xbf80, ulhc(15, 000037171)}, // 011111001111001
  {0xcfb1, ulhc(15, 000037172)}, // 011111001111010
  {0xd0ba, ulhc(15, 000037173)}, // 011111001111011
  {0xd0c4, ulhc(15, 000037174)}, // 011111001111100
  {0xe680, ulhc(15, 000037175)}, // 011111001111101
  {0x9a2e, ulhc(15, 000037217)}, // 011111010001111
  {0x9a58, ulhc(15, 000037272)}, // 011111010111010
  {0x9bc7, ulhc(15, 000037273)}, // 011111010111011
  {0xb786, ulhc(15, 000037274)}, // 011111010111100
  {0xbf86, ulhc(15, 000037275)}, // 011111010111101
  {0xe0fd, ulhc(15, 000040064)}, // 100000000110100
  {0x010a, ulhc(15, 000040065)}, // 100000000110101
  {0xc0b9, ulhc(15, 000040520)}, // 100000101010000
  {0x01a6, ulhc(15, 000040575)}, // 100000101111101
  {0xed8f, ulhc(15, 000040576)}, // 100000101111110
  {0x01a4, ulhc(15, 000040754)}, // 100000111101100
  {0xc048, ulhc(15, 000040755)}, // 100000111101101
  {0xc04b, ulhc(15, 000040756)}, // 100000111101110
  {0xf548, ulhc(15, 000040757)}, // 100000111101111
  {0x2803, ulhc(15, 000041774)}, // 100001111111100
  {0xc03a, ulhc(15, 000041775)}, // 100001111111101
  {0xe8b8, ulhc(15, 000041776)}, // 100001111111110
  {0x00f7, ulhc(15, 000042254)}, // 100010010101100
  {0x0134, ulhc(15, 000042255)}, // 100010010101101
  {0xc0a5, ulhc(15, 000042256)}, // 100010010101110
  {0xc0b3, ulhc(15, 000042257)}, // 100010010101111
  {0xc103, ulhc(15, 000042340)}, // 100010011100000
  {0xe0bc, ulhc(15, 000042341)}, // 100010011100001
  {0xe48f, ulhc(15, 000042342)}, // 100010011100010
  {0xeab9, ulhc(15, 000042343)}, // 100010011100011
  {0x010c, ulhc(15, 000043045)}, // 100011000100101
  {0x83b3, ulhc(15, 000043054)}, // 100011000101100
  {0x9b4c, ulhc(15, 000043055)}, // 100011000101101
  {0x015e, ulhc(15, 000043056)}, // 100011000101110
  {0x01ee, ulhc(15, 000044207)}, // 100100010000111
  {0x9a48, ulhc(15, 000044340)}, // 100100011100000
  {0xb819, ulhc(15, 000044341)}, // 100100011100001
  {0xb81e, ulhc(15, 000044342)}, // 100100011100010
  {0x1105, ulhc(15, 000050172)}, // 101000001111010
  {0xcfb5, ulhc(15, 000050173)}, // 101000001111011
  {0xe3cc, ulhc(15, 000050562)}, // 101000101110010
  {0x1304, ulhc(15, 000050563)}, // 101000101110011
  {0x1504, ulhc(15, 000050566)}, // 101000101110110
  {0xc0d5, ulhc(15, 000050567)}, // 101000101110111
  {0x982b, ulhc(15, 000051320)}, // 101001011010000
  {0x9a23, ulhc(15, 000051321)}, // 101001011010001
  {0x9a2b, ulhc(15, 000051322)}, // 101001011010010
  {0xcf9b, ulhc(15, 000051323)}, // 101001011010011
  {0x40a7, ulhc(15, 000053542)}, // 101011101100010
  {0x4130, ulhc(15, 000053543)}, // 101011101100011
  {0x4131, ulhc(15, 000053544)}, // 101011101100100
  {0xc0fc, ulhc(15, 000053545)}, // 101011101100101
  {0xc0b1, ulhc(15, 000060540)}, // 110000101100000
  {0x2504, ulhc(15, 000060541)}, // 110000101100001
  {0xc09f, ulhc(15, 000060576)}, // 110000101111110
  {0xc0e9, ulhc(15, 000060577)}, // 110000101111111
  {0xe3fb, ulhc(15, 000060766)}, // 110000111110110
  {0xc0e7, ulhc(15, 000060767)}, // 110000111110111
  {0xcfb0, ulhc(15, 000061602)}, // 110001110000010
  {0xe3c8, ulhc(15, 000061603)}, // 110001110000011
  {0x0107, ulhc(15, 000061625)}, // 110001110010101
  {0x0164, ulhc(15, 000062222)}, // 110010010010010
  {0xcfb8, ulhc(15, 000062223)}, // 110010010010011
  {0xd0c1, ulhc(15, 000062234)}, // 110010010011100
  {0x4151, ulhc(15, 000062621)}, // 110010110010001
  {0xc0ea, ulhc(15, 000062636)}, // 110010110011110
  {0x010b, ulhc(15, 000064011)}, // 110100000001001
  {0x015a, ulhc(15, 000064012)}, // 110100000001010
  {0x0010, ulhc(15, 000064013)}, // 110100000001011
  {0xcfba, ulhc(15, 000064344)}, // 110100011100100
  {0xd0c2, ulhc(15, 000065704)}, // 110101111000100
  {0x4117, ulhc(15, 000065716)}, // 110101111001110
  {0xd0c3, ulhc(15, 000065717)}, // 110101111001111
  {0x01f6, ulhc(15, 000066326)}, // 110110011010110
  {0x4021, ulhc(15, 000066327)}, // 110110011010111
  {0xc1b4, ulhc(15, 000066534)}, // 110110101011100
  {0xcfbe, ulhc(15, 000066535)}, // 110110101011101
  {0x0102, ulhc(15, 000066577)}, // 110110101111111
  {0xcfbc, ulhc(15, 000066636)}, // 110110110011110
  {0xcff2, ulhc(15, 000066637)}, // 110110110011111
  {0xc0af, ulhc(15, 000067032)}, // 110111000011010
  {0xf4f0, ulhc(15, 000067033)}, // 110111000011011
  {0xcfbb, ulhc(15, 000067533)}, // 110111101011011
  {0x99b4, ulhc(15, 000067724)}, // 110111111010100
  {0x99cb, ulhc(15, 000067725)}, // 110111111010101
  {0xc0b7, ulhc(15, 000067726)}, // 110111111010110
  {0x0018, ulhc(15, 000072047)}, // 111010000100111
  {0xcfe9, ulhc(15, 000072062)}, // 111010000110010
  {0xd0c0, ulhc(15, 000072362)}, // 111010011110010
  {0xcf9c, ulhc(15, 000072570)}, // 111010101111000
  {0x0103, ulhc(15, 000072760)}, // 111010111110000
  {0xcfbd, ulhc(15, 000072761)}, // 111010111110001
  {0xcfce, ulhc(15, 000072762)}, // 111010111110010
  {0x1502, ulhc(15, 000074353)}, // 111100011101011
  {0xc021, ulhc(15, 000075262)}, // 111101010110010
  {0x0e14, ulhc(15, 000076046)}, // 111110000100110
  {0x2503, ulhc(15, 000076264)}, // 111110010110100
  {0x001d, ulhc(15, 000076265)}, // 111110010110101
  {0x0240, ulhc(15, 000076266)}, // 111110010110110
  {0xe9e8, ulhc(15, 000076267)}, // 111110010110111
  {0xe7cb, ulhc(15, 000076645)}, // 111110110100101
  {0x0119, ulhc(16, 000000015)}, // 0000000000001101
  {0x41d7, ulhc(16, 000004214)}, // 0000100010001100
  {0xc102, ulhc(16, 000004215)}, // 0000100010001101
  {0x0218, ulhc(16, 000004735)}, // 0000100111011101
  {0xc037, ulhc(16, 000012574)}, // 0001010101111100
  {0xcfa5, ulhc(16, 000012575)}, // 0001010101111101
  {0xcfab, ulhc(16, 000012576)}, // 0001010101111110
  {0xcfad, ulhc(16, 000012577)}, // 0001010101111111
  {0xcf7e, ulhc(16, 000021014)}, // 0010001000001100
  {0x0186, ulhc(16, 000021015)}, // 0010001000001101
  {0x0188, ulhc(16, 000022522)}, // 0010010101010010
  {0x110a, ulhc(16, 000022523)}, // 0010010101010011
  {0x1b05, ulhc(16, 000022524)}, // 0010010101010100
  {0x2203, ulhc(16, 000022525)}, // 0010010101010101
  {0xc01e, ulhc(16, 000022526)}, // 0010010101010110
  {0xc0de, ulhc(16, 000022527)}, // 0010010101010111
  {0xcf73, ulhc(16, 000022530)}, // 0010010101011000
  {0xd0be, ulhc(16, 000022531)}, // 0010010101011001
  {0x011e, ulhc(16, 000024113)}, // 0010100001001011
  {0x01e4, ulhc(16, 000032520)}, // 0011010101010000
  {0x1305, ulhc(16, 000032521)}, // 0011010101010001
  {0x1704, ulhc(16, 000032522)}, // 0011010101010010
  {0xcf79, ulhc(16, 000032523)}, // 0011010101010011
  {0x0015, ulhc(16, 000034522)}, // 0011100101010010
  {0x011b, ulhc(16, 000034523)}, // 0011100101010011
  {0x0122, ulhc(16, 000034524)}, // 0011100101010100
  {0x0905, ulhc(16, 000034525)}, // 0011100101010101
  {0x1c05, ulhc(16, 000034526)}, // 0011100101010110
  {0xc1b7, ulhc(16, 000034527)}, // 0011100101010111
  {0xcf88, ulhc(16, 000034530)}, // 0011100101011000
  {0xcf89, ulhc(16, 000034531)}, // 0011100101011001
  {0xe28f, ulhc(16, 000034532)}, // 0011100101011010
  {0x021c, ulhc(16, 000040114)}, // 0100000001001100
  {0x022e, ulhc(16, 000040115)}, // 0100000001001101
  {0x1909, ulhc(16, 000040116)}, // 0100000001001110
  {0xc12e, ulhc(16, 000040117)}, // 0100000001001111
  {0xcf87, ulhc(16, 000040654)}, // 0100000110101100
  {0x1c06, ulhc(16, 000040655)}, // 0100000110101101
  {0xc08e, ulhc(16, 000040764)}, // 0100000111110100
  {0xc171, ulhc(16, 000040765)}, // 0100000111110101
  {0xcf7d, ulhc(16, 000040766)}, // 0100000111110110
  {0xcf83, ulhc(16, 000040767)}, // 0100000111110111
  {0xcf8e, ulhc(16, 000040770)}, // 0100000111111000
  {0xcfa7, ulhc(16, 000040771)}, // 0100000111111001
  {0x0230, ulhc(16, 000044025)}, // 0100100000010101
  {0xcf7c, ulhc(16, 000047014)}, // 0100111000001100
  {0x41f0, ulhc(16, 000047015)}, // 0100111000001101
  {0xc02f, ulhc(16, 000051010)}, // 0101001000001000
  {0xc131, ulhc(16, 000051011)}, // 0101001000001001
  {0x0216, ulhc(16, 000051163)}, // 0101001001110011
  {0xc044, ulhc(16, 000051172)}, // 0101001001111010
  {0xcfa1, ulhc(16, 000051173)}, // 0101001001111011
  {0xcfa2, ulhc(16, 000053010)}, // 0101011000001000
  {0xe7c0, ulhc(16, 000053011)}, // 0101011000001001
  {0x0f04, ulhc(16, 000055146)}, // 0101101001100110
  {0x1104, ulhc(16, 000055147)}, // 0101101001100111
  {0x1302, ulhc(16, 000055150)}, // 0101101001101000
  {0xc089, ulhc(16, 000055151)}, // 0101101001101001
  {0xc09b, ulhc(16, 000055152)}, // 0101101001101010
  {0xcfa6, ulhc(16, 000055153)}, // 0101101001101011
  {0x0126, ulhc(16, 000056275)}, // 0101110010111101
  {0x022c, ulhc(16, 000060224)}, // 0110000010010100
  {0xb9b0, ulhc(16, 000060225)}, // 0110000010010101
  {0xcfae, ulhc(16, 000065002)}, // 0110101000000010
  {0x0146, ulhc(16, 000065003)}, // 0110101000000011
  {0x0184, ulhc(16, 000065444)}, // 0110101100100100
  {0x018a, ulhc(16, 000065445)}, // 0110101100100101
  {0x01e2, ulhc(16, 000065446)}, // 0110101100100110
  {0x0e10, ulhc(16, 000065447)}, // 0110101100100111
  {0xc0d9, ulhc(16, 000065450)}, // 0110101100101000
  {0xcf93, ulhc(16, 000065451)}, // 0110101100101001
  {0xcfaa, ulhc(16, 000065452)}, // 0110101100101010
  {0x00fd, ulhc(16, 000067766)}, // 0110111111110110
  {0x012a, ulhc(16, 000067767)}, // 0110111111110111
  {0x01b8, ulhc(16, 000071130)}, // 0111001001011000
  {0x01e0, ulhc(16, 000071131)}, // 0111001001011001
  {0x1902, ulhc(16, 000071132)}, // 0111001001011010
  {0x1f08, ulhc(16, 000071133)}, // 0111001001011011
  {0xcf78, ulhc(16, 000071260)}, // 0111001010110000
  {0xcf9f, ulhc(16, 000071261)}, // 0111001010110001
  {0x021a, ulhc(16, 000072405)}, // 0111010100000101
  {0x0605, ulhc(16, 000073040)}, // 0111011000100000
  {0x0606, ulhc(16, 000073041)}, // 0111011000100001
  {0x0906, ulhc(16, 000073042)}, // 0111011000100010
  {0x2201, ulhc(16, 000073043)}, // 0111011000100011
  {0xc1a9, ulhc(16, 000073044)}, // 0111011000100100
  {0xd0d2, ulhc(16, 000073045)}, // 0111011000100101
  {0x0131, ulhc(16, 000074672)}, // 0111100110111010
  {0x01d6, ulhc(16, 000074673)}, // 0111100110111011
  {0xd0c6, ulhc(16, 000074674)}, // 0111100110111100
  {0xd0cd, ulhc(16, 000074675)}, // 0111100110111101
  {0x0132, ulhc(16, 000076374)}, // 0111110011111100
  {0x0182, ulhc(16, 000076375)}, // 0111110011111101
  {0x0192, ulhc(16, 000076376)}, // 0111110011111110
  {0x01d4, ulhc(16, 000076377)}, // 0111110011111111
  {0x01e6, ulhc(16, 000076430)}, // 0111110100011000
  {0xcf96, ulhc(16, 000076431)}, // 0111110100011001
  {0xe1fb, ulhc(16, 000076432)}, // 0111110100011010
  {0x01b2, ulhc(16, 000101242)}, // 1000001010100010
  {0x01de, ulhc(16, 000101243)}, // 1000001010100011
  {0x0238, ulhc(16, 000101244)}, // 1000001010100100
  {0x0e20, ulhc(16, 000101245)}, // 1000001010100101
  {0x1806, ulhc(16, 000101246)}, // 1000001010100110
  {0xc0e4, ulhc(16, 000101247)}, // 1000001010100111
  {0xe68f, ulhc(16, 000101370)}, // 1000001011111000
  {0xeec0, ulhc(16, 000101371)}, // 1000001011111001
  {0x0128, ulhc(16, 000101377)}, // 1000001011111111
  {0x018e, ulhc(16, 000103740)}, // 1000011111100000
  {0x01e8, ulhc(16, 000103741)}, // 1000011111100001
  {0x32a0, ulhc(16, 000103742)}, // 1000011111100010
  {0xc11d, ulhc(16, 000103743)}, // 1000011111100011
  {0xcf80, ulhc(16, 000103744)}, // 1000011111100100
  {0xd0cc, ulhc(16, 000103745)}, // 1000011111100101
  {0x00fb, ulhc(16, 000103777)}, // 1000011111111111
  {0x012e, ulhc(16, 000104710)}, // 1000100111001000
  {0x0148, ulhc(16, 000104711)}, // 1000100111001001
  {0x1006, ulhc(16, 000104712)}, // 1000100111001010
  {0x1206, ulhc(16, 000104713)}, // 1000100111001011
  {0x1406, ulhc(16, 000104714)}, // 1000100111001100
  {0x1f07, ulhc(16, 000104715)}, // 1000100111001101
  {0xc0bf, ulhc(16, 000104716)}, // 1000100111001110
  {0xc0c2, ulhc(16, 000104717)}, // 1000100111001111
  {0xc12b, ulhc(16, 000106110)}, // 1000110001001000
  {0x01b4, ulhc(16, 000106136)}, // 1000110001011110
  {0xbf8c, ulhc(16, 000106137)}, // 1000110001011111
  {0xcf94, ulhc(16, 000110414)}, // 1001000100001100
  {0x1108, ulhc(16, 000110707)}, // 1001000111000111
  {0x41b6, ulhc(16, 000120350)}, // 1010000011101000
  {0xcfa3, ulhc(16, 000120351)}, // 1010000011101001
  {0xcfa9, ulhc(16, 000120352)}, // 1010000011101010
  {0xd0ce, ulhc(16, 000120353)}, // 1010000011101011
  {0x0150, ulhc(16, 000121460)}, // 1010001100110000
  {0x1805, ulhc(16, 000121461)}, // 1010001100110001
  {0x1b01, ulhc(16, 000121462)}, // 1010001100110010
  {0xcf82, ulhc(16, 000121463)}, // 1010001100110011
  {0xd0bf, ulhc(16, 000121464)}, // 1010001100110100
  {0x0196, ulhc(16, 000127314)}, // 1010111011001100
  {0x1205, ulhc(16, 000127315)}, // 1010111011001101
  {0x1c02, ulhc(16, 000127316)}, // 1010111011001110
  {0xc0c3, ulhc(16, 000127317)}, // 1010111011001111
  {0xc0e3, ulhc(16, 000127330)}, // 1010111011011000
  {0xc0f8, ulhc(16, 000127331)}, // 1010111011011001
  {0xe7ce, ulhc(16, 000127332)}, // 1010111011011010
  {0x1703, ulhc(16, 000141304)}, // 1100001011000100
  {0xc0a2, ulhc(16, 000141305)}, // 1100001011000101
  {0xc0e5, ulhc(16, 000141306)}, // 1100001011000110
  {0xcf77, ulhc(16, 000141307)}, // 1100001011000111
  {0xf520, ulhc(16, 000141360)}, // 1100001011110000
  {0x0116, ulhc(16, 000143410)}, // 1100011100001000
  {0x014e, ulhc(16, 000143411)}, // 1100011100001001
  {0x01b6, ulhc(16, 000143412)}, // 1100011100001010
  {0x01bc, ulhc(16, 000143413)}, // 1100011100001011
  {0xc039, ulhc(16, 000143450)}, // 1100011100101000
  {0x01d8, ulhc(16, 000144472)}, // 1100100100111010
  {0x1107, ulhc(16, 000144473)}, // 1100100100111011
  {0xc0f0, ulhc(16, 000144474)}, // 1100100100111100
  {0xcf75, ulhc(16, 000144475)}, // 1100100100111101
  {0xcf81, ulhc(16, 000144476)}, // 1100100100111110
  {0xcf86, ulhc(16, 000144477)}, // 1100100100111111
  {0xcfa0, ulhc(16, 000144740)}, // 1100100111100000
  {0xd0bc, ulhc(16, 000144741)}, // 1100100111100001
  {0x41f1, ulhc(16, 000145441)}, // 1100101100100001
  {0xc0f2, ulhc(16, 000145476)}, // 1100101100111110
  {0xcf85, ulhc(16, 000145477)}, // 1100101100111111
  {0xcfa8, ulhc(16, 000150020)}, // 1101000000010000
  {0xc038, ulhc(16, 000150224)}, // 1101000010010100
  {0xc0d3, ulhc(16, 000150225)}, // 1101000010010101
  {0xdfe4, ulhc(16, 000150226)}, // 1101000010010110
  {0x0154, ulhc(16, 000150713)}, // 1101000111001011
  {0x0158, ulhc(16, 000153612)}, // 1101011110001010
  {0x2403, ulhc(16, 000153613)}, // 1101011110001011
  {0xd0bb, ulhc(16, 000153614)}, // 1101011110001100
  {0xd0cb, ulhc(16, 000153615)}, // 1101011110001101
  {0xe7cd, ulhc(16, 000153616)}, // 1101011110001110
  {0x014a, ulhc(16, 000154644)}, // 1101100110100100
  {0x1402, ulhc(16, 000154645)}, // 1101100110100101
  {0xd0cf, ulhc(16, 000154646)}, // 1101100110100110
  {0x0194, ulhc(16, 000155274)}, // 1101101010111100
  {0x01ba, ulhc(16, 000155275)}, // 1101101010111101
  {0x0f03, ulhc(16, 000155276)}, // 1101101010111110
  {0x41f7, ulhc(16, 000155277)}, // 1101101010111111
  {0xcf7a, ulhc(16, 000155374)}, // 1101101011111100
  {0x012c, ulhc(16, 000156070)}, // 1101110000111000
  {0x0e18, ulhc(16, 000156071)}, // 1101110000111001
  {0x940c, ulhc(16, 000156072)}, // 1101110000111010
  {0xeffe, ulhc(16, 000156073)}, // 1101110000111011
  {0x0152, ulhc(16, 000156077)}, // 1101110000111111
  {0x0156, ulhc(16, 000157264)}, // 1101111010110100
  {0x41b7, ulhc(16, 000157265)}, // 1101111010110101
  {0x0e05, ulhc(16, 000157656)}, // 1101111110101110
  {0x1a0c, ulhc(16, 000157657)}, // 1101111110101111
  {0x98c3, ulhc(16, 000160200)}, // 1110000010000000
  {0x98da, ulhc(16, 000160201)}, // 1110000010000001
  {0x99b2, ulhc(16, 000160202)}, // 1110000010000010
  {0x9abb, ulhc(16, 000160203)}, // 1110000010000011
  {0x9ac3, ulhc(16, 000160204)}, // 1110000010000100
  {0x9ad2, ulhc(16, 000160205)}, // 1110000010000101
  {0x9ada, ulhc(16, 000160206)}, // 1110000010000110
  {0x9bb2, ulhc(16, 000160207)}, // 1110000010000111
  {0xc092, ulhc(16, 000164146)}, // 1110100001100110
  {0xc0a9, ulhc(16, 000164147)}, // 1110100001100111
  {0x0115, ulhc(16, 000164747)}, // 1110100111100111
  {0xc135, ulhc(16, 000165362)}, // 1110101011110010
  {0x00ff, ulhc(16, 000165746)}, // 1110101111100110
  {0x1005, ulhc(16, 000165747)}, // 1110101111100111
  {0x010f, ulhc(16, 000170725)}, // 1111000111010101
  {0x40e0, ulhc(16, 000171064)}, // 1111001000110100
  {0x011c, ulhc(16, 000172102)}, // 1111010001000010
  {0x2401, ulhc(16, 000172103)}, // 1111010001000011
  {0xc0ab, ulhc(16, 000172546)}, // 1111010101100110
  {0xb811, ulhc(16, 000172547)}, // 1111010101100111
  {0xb812, ulhc(16, 000174100)}, // 1111100001000000
  {0xe484, ulhc(16, 000174101)}, // 1111100001000001
  {0xc0b6, ulhc(16, 000174117)}, // 1111100001001111
  {0xc0da, ulhc(16, 000175510)}, // 1111101101001000
  {0x01b0, ulhc(16, 000175511)}, // 1111101101001001
  {0x4114, ulhc(16, 000175514)}, // 1111101101001100
  {0xcf8f, ulhc(16, 000175515)}, // 1111101101001101
  {0x0198, ulhc(16, 000177062)}, // 1111111000110010
  {0x019a, ulhc(16, 000177063)}, // 1111111000110011
  {0x0124, ulhc(17, 000011671)}, // 00001001110111001
  {0x01ca, ulhc(17, 000026300)}, // 00010110011000000
  {0x0248, ulhc(17, 000026301)}, // 00010110011000001
  {0xc12a, ulhc(17, 000026302)}, // 00010110011000010
  {0xc188, ulhc(17, 000026303)}, // 00010110011000011
  {0xce86, ulhc(17, 000026304)}, // 00010110011000100
  {0xced6, ulhc(17, 000026305)}, // 00010110011000101
  {0xcee7, ulhc(17, 000026306)}, // 00010110011000110
  {0xcf57, ulhc(17, 000026307)}, // 00010110011000111
  {0xcf69, ulhc(17, 000026310)}, // 00010110011001000
  {0xcf6a, ulhc(17, 000026311)}, // 00010110011001001
  {0xeec8, ulhc(17, 000026312)}, // 00010110011001010
  {0x01c8, ulhc(17, 000045264)}, // 00100101010110100
  {0x0204, ulhc(17, 000045265)}, // 00100101010110101
  {0x1804, ulhc(17, 000045266)}, // 00100101010110110
  {0xbd86, ulhc(17, 000045267)}, // 00100101010110111
  {0xce8f, ulhc(17, 000045270)}, // 00100101010111000
  {0xce99, ulhc(17, 000045271)}, // 00100101010111001
  {0xced8, ulhc(17, 000045272)}, // 00100101010111010
  {0xcf6e, ulhc(17, 000045273)}, // 00100101010111011
  {0xcf8d, ulhc(17, 000045274)}, // 00100101010111100
  {0xd0de, ulhc(17, 000045275)}, // 00100101010111101
  {0x0242, ulhc(17, 000071266)}, // 00111001010110110
  {0x040b, ulhc(17, 000071267)}, // 00111001010110111
  {0x060b, ulhc(17, 000071270)}, // 00111001010111000
  {0x090b, ulhc(17, 000071271)}, // 00111001010111001
  {0x0e0b, ulhc(17, 000071272)}, // 00111001010111010
  {0x1f09, ulhc(17, 000071273)}, // 00111001010111011
  {0x991c, ulhc(17, 000071274)}, // 00111001010111100
  {0x9b1c, ulhc(17, 000071275)}, // 00111001010111101
  {0xc0d6, ulhc(17, 000071276)}, // 00111001010111110
  {0xc129, ulhc(17, 000071277)}, // 00111001010111111
  {0xced7, ulhc(17, 000076260)}, // 00111110010110000
  {0xcf58, ulhc(17, 000076261)}, // 00111110010110001
  {0xcf65, ulhc(17, 000076262)}, // 00111110010110010
  {0x0232, ulhc(17, 000101764)}, // 01000001111110100
  {0x9962, ulhc(17, 000101765)}, // 01000001111110101
  {0x9b19, ulhc(17, 000101766)}, // 01000001111110110
  {0x9b62, ulhc(17, 000101767)}, // 01000001111110111
  {0xc177, ulhc(17, 000106520)}, // 01000110101010000
  {0xcf56, ulhc(17, 000106521)}, // 01000110101010001
  {0xcf6f, ulhc(17, 000106522)}, // 01000110101010010
  {0xc086, ulhc(17, 000122024)}, // 01010010000010100
  {0xc091, ulhc(17, 000122025)}, // 01010010000010101
  {0xc115, ulhc(17, 000122026)}, // 01010010000010110
  {0xce85, ulhc(17, 000122027)}, // 01010010000010111
  {0xce96, ulhc(17, 000122344)}, // 01010010011100100
  {0xcf5d, ulhc(17, 000122345)}, // 01010010011100101
  {0x01c6, ulhc(17, 000132330)}, // 01011010011011000
  {0x01d2, ulhc(17, 000132331)}, // 01011010011011001
  {0x1204, ulhc(17, 000132332)}, // 01011010011011010
  {0x4080, ulhc(17, 000132333)}, // 01011010011011011
  {0xc095, ulhc(17, 000132334)}, // 01011010011011100
  {0xce7a, ulhc(17, 000132335)}, // 01011010011011101
  {0xcecc, ulhc(17, 000132336)}, // 01011010011011110
  {0xcf5c, ulhc(17, 000132337)}, // 01011010011011111
  {0xcf70, ulhc(17, 000133500)}, // 01011011101000000
  {0xcf71, ulhc(17, 000133501)}, // 01011011101000001
  {0x0214, ulhc(17, 000153126)}, // 01101011001010110
  {0xc11b, ulhc(17, 000153127)}, // 01101011001010111
  {0xce77, ulhc(17, 000153130)}, // 01101011001011000
  {0xce84, ulhc(17, 000153131)}, // 01101011001011001
  {0xcf4c, ulhc(17, 000153132)}, // 01101011001011010
  {0xcf64, ulhc(17, 000153133)}, // 01101011001011011
  {0xcf8a, ulhc(17, 000165010)}, // 01110101000001000
  {0x0d05, ulhc(17, 000165011)}, // 01110101000001001
  {0x0d06, ulhc(17, 000166114)}, // 01110110001001100
  {0x0e07, ulhc(17, 000166115)}, // 01110110001001101
  {0x110b, ulhc(17, 000166116)}, // 01110110001001110
  {0x1505, ulhc(17, 000166117)}, // 01110110001001111
  {0xc07f, ulhc(17, 000166120)}, // 01110110001010000
  {0xc094, ulhc(17, 000166121)}, // 01110110001010001
  {0xc0a8, ulhc(17, 000166122)}, // 01110110001010010
  {0xc0ba, ulhc(17, 000166123)}, // 01110110001010011
  {0xc0f4, ulhc(17, 000166124)}, // 01110110001010100
  {0xc17c, ulhc(17, 000166125)}, // 01110110001010101
  {0xc1ae, ulhc(17, 000166126)}, // 01110110001010110
  {0xc1b5, ulhc(17, 000166127)}, // 01110110001010111
  {0xcee6, ulhc(17, 000166130)}, // 01110110001011000
  {0xcee8, ulhc(17, 000166131)}, // 01110110001011001
  {0xcf76, ulhc(17, 000166132)}, // 01110110001011010
  {0x0226, ulhc(17, 000175066)}, // 01111101000110110
  {0x024a, ulhc(17, 000175067)}, // 01111101000110111
  {0xce91, ulhc(17, 000175070)}, // 01111101000111000
  {0xcee2, ulhc(17, 000175071)}, // 01111101000111001
  {0xcf5e, ulhc(17, 000175072)}, // 01111101000111010
  {0xe7ca, ulhc(17, 000175073)}, // 01111101000111011
  {0x01ce, ulhc(17, 000202775)}, // 10000010111111101
  {0x1002, ulhc(17, 000207714)}, // 10000111111001100
  {0x4087, ulhc(17, 000207715)}, // 10000111111001101
  {0x9b5c, ulhc(17, 000207716)}, // 10000111111001110
  {0xcf92, ulhc(17, 000207717)}, // 10000111111001111
  {0xe7e3, ulhc(17, 000207720)}, // 10000111111010000
  {0xf498, ulhc(17, 000207721)}, // 10000111111010001
  {0x0220, ulhc(17, 000214223)}, // 10001100010010011
  {0x1109, ulhc(17, 000221032)}, // 10010001000011010
  {0xc09a, ulhc(17, 000221033)}, // 10010001000011011
  {0xcf7b, ulhc(17, 000221614)}, // 10010001110001100
  {0x0117, ulhc(17, 000243152)}, // 10100011001101010
  {0x4084, ulhc(17, 000243153)}, // 10100011001101011
  {0xc109, ulhc(17, 000243154)}, // 10100011001101100
  {0xcf59, ulhc(17, 000243155)}, // 10100011001101101
  {0xe3c7, ulhc(17, 000243156)}, // 10100011001101110
  {0x01da, ulhc(17, 000256667)}, // 10101110110110111
  {0x0222, ulhc(17, 000302742)}, // 11000010111100010
  {0x1c08, ulhc(17, 000302743)}, // 11000010111100011
  {0xc0e0, ulhc(17, 000302744)}, // 11000010111100100
  {0xc164, ulhc(17, 000302745)}, // 11000010111100101
  {0xc1b3, ulhc(17, 000302746)}, // 11000010111100110
  {0xcee3, ulhc(17, 000302747)}, // 11000010111100111
  {0xcf8c, ulhc(17, 000307122)}, // 11000111001010010
  {0xc16d, ulhc(17, 000307123)}, // 11000111001010011
  {0xcee4, ulhc(17, 000311704)}, // 11001001111000100
  {0xcf5b, ulhc(17, 000311705)}, // 11001001111000101
  {0xcf60, ulhc(17, 000311706)}, // 11001001111000110
  {0xd0c7, ulhc(17, 000311707)}, // 11001001111000111
  {0xd0c8, ulhc(17, 000311710)}, // 11001001111001000
  {0x021e, ulhc(17, 000320043)}, // 11010000000100011
  {0x9b00, ulhc(17, 000320456)}, // 11010000100101110
  {0x9b42, ulhc(17, 000320457)}, // 11010000100101111
  {0xc027, ulhc(17, 000321624)}, // 11010001110010100
  {0xcf66, ulhc(17, 000321625)}, // 11010001110010101
  {0xd0ca, ulhc(17, 000327436)}, // 11010111100011110
  {0x0118, ulhc(17, 000327437)}, // 11010111100011111
  {0x0144, ulhc(17, 000331516)}, // 11011001101001110
  {0x1207, ulhc(17, 000331517)}, // 11011001101001111
  {0x40c7, ulhc(17, 000331520)}, // 11011001101010000
  {0xc0f7, ulhc(17, 000331521)}, // 11011001101010001
  {0xcf68, ulhc(17, 000331522)}, // 11011001101010010
  {0xf4e8, ulhc(17, 000331523)}, // 11011001101010011
  {0x022a, ulhc(17, 000332773)}, // 11011010111111011
  {0x1007, ulhc(17, 000334170)}, // 11011100001111000
  {0x1407, ulhc(17, 000334171)}, // 11011100001111001
  {0xc085, ulhc(17, 000334172)}, // 11011100001111010
  {0xc1b2, ulhc(17, 000334173)}, // 11011100001111011
  {0xf480, ulhc(17, 000334174)}, // 11011100001111100
  {0x018c, ulhc(17, 000340420)}, // 11100000100010000
  {0x0224, ulhc(17, 000340421)}, // 11100000100010001
  {0x0f9a, ulhc(17, 000340422)}, // 11100000100010010
  {0x1306, ulhc(17, 000340423)}, // 11100000100010011
  {0x139a, ulhc(17, 000340424)}, // 11100000100010100
  {0x1603, ulhc(17, 000340425)}, // 11100000100010101
  {0x2f98, ulhc(17, 000340426)}, // 11100000100010110
  {0x4020, ulhc(17, 000340427)}, // 11100000100010111
  {0x40c6, ulhc(17, 000340430)}, // 11100000100011000
  {0xb586, ulhc(17, 000340431)}, // 11100000100011001
  {0xb596, ulhc(17, 000340432)}, // 11100000100011010
  {0xbd85, ulhc(17, 000340433)}, // 11100000100011011
  {0xc0c8, ulhc(17, 000340434)}, // 11100000100011100
  {0xcf95, ulhc(17, 000340435)}, // 11100000100011101
  {0xd0c9, ulhc(17, 000340436)}, // 11100000100011110
  {0xd0d1, ulhc(17, 000340437)}, // 11100000100011111
  {0xe0f2, ulhc(17, 000340440)}, // 11100000100100000
  {0x1008, ulhc(17, 000351715)}, // 11101001111001101
  {0x1408, ulhc(17, 000352746)}, // 11101010111100110
  {0x1807, ulhc(17, 000352747)}, // 11101010111100111
  {0x1808, ulhc(17, 000361650)}, // 11110001110101000
  {0x011d, ulhc(17, 000361651)}, // 11110001110101001
  {0x0190, ulhc(17, 000362152)}, // 11110010001101010
  {0x0234, ulhc(17, 000362153)}, // 11110010001101011
  {0x023a, ulhc(17, 000362154)}, // 11110010001101100
  {0x1208, ulhc(17, 000362155)}, // 11110010001101101
  {0xc0b0, ulhc(17, 000362156)}, // 11110010001101110
  {0xcf90, ulhc(17, 000362157)}, // 11110010001101111
  {0x023c, ulhc(17, 000370204)}, // 11111000010000100
  {0x2501, ulhc(17, 000370205)}, // 11111000010000101
  {0xcf72, ulhc(17, 000370206)}, // 11111000010000110
  {0xcf7f, ulhc(17, 000370207)}, // 11111000010000111
  {0xcfac, ulhc(17, 000370234)}, // 11111000010011100
  {0x0228, ulhc(17, 000373234)}, // 11111011010011100
  {0x0236, ulhc(17, 000373235)}, // 11111011010011101
  {0x023e, ulhc(17, 000373236)}, // 11111011010011110
  {0x1a08, ulhc(17, 000373237)}, // 11111011010011111
  {0x9868, ulhc(17, 000376040)}, // 11111110000100000
  {0x9982, ulhc(17, 000376041)}, // 11111110000100001
  {0x9a60, ulhc(17, 000376042)}, // 11111110000100010
  {0x9a68, ulhc(17, 000376043)}, // 11111110000100011
  {0x9b08, ulhc(17, 000376044)}, // 11111110000100100
  {0x9b82, ulhc(17, 000376045)}, // 11111110000100101
  {0xc0d7, ulhc(17, 000376046)}, // 11111110000100110
  {0xc1b9, ulhc(17, 000376047)}, // 11111110000100111
  {0x024c, ulhc(18, 000000060)}, // 000000000000110000
  {0xce80, ulhc(18, 000000061)}, // 000000000000110001
  {0xce8e, ulhc(18, 000000062)}, // 000000000000110010
  {0xcea1, ulhc(18, 000000063)}, // 000000000000110011
  {0xcedf, ulhc(18, 000023560)}, // 000010011101110000
  {0xcef2, ulhc(18, 000023561)}, // 000010011101110001
  {0x0202, ulhc(18, 000054627)}, // 000101100110010111
  {0x110c, ulhc(18, 000112574)}, // 001001010101111100
  {0x1705, ulhc(18, 000112575)}, // 001001010101111101
  {0xc097, ulhc(18, 000112576)}, // 001001010101111110
  {0xc113, ulhc(18, 000112577)}, // 001001010101111111
  {0xc119, ulhc(18, 000115040)}, // 001001101000100000
  {0xc120, ulhc(18, 000115041)}, // 001001101000100001
  {0xc178, ulhc(18, 000115042)}, // 001001101000100010
  {0xc1b6, ulhc(18, 000115043)}, // 001001101000100011
  {0xce97, ulhc(18, 000115044)}, // 001001101000100100
  {0xcecd, ulhc(18, 000115045)}, // 001001101000100101
  {0xced0, ulhc(18, 000115046)}, // 001001101000100110
  {0xcee9, ulhc(18, 000115047)}, // 001001101000100111
  {0xcf52, ulhc(18, 000115050)}, // 001001101000101000
  {0xcf55, ulhc(18, 000115051)}, // 001001101000101001
  {0xf530, ulhc(18, 000115052)}, // 001001101000101010
  {0x01c4, ulhc(18, 000174547)}, // 001111100101100111
  {0x4081, ulhc(18, 000215246)}, // 010001101010100110
  {0xc16f, ulhc(18, 000215247)}, // 010001101010100111
  {0xce98, ulhc(18, 000220120)}, // 010010000001010000
  {0xcee5, ulhc(18, 000220121)}, // 010010000001010001
  {0xcf63, ulhc(18, 000220122)}, // 010010000001010010
  {0x1702, ulhc(18, 000267204)}, // 010110111010000100
  {0xc0a3, ulhc(18, 000267205)}, // 010110111010000101
  {0xc123, ulhc(18, 000267206)}, // 010110111010000110
  {0xce81, ulhc(18, 000267207)}, // 010110111010000111
  {0xce95, ulhc(18, 000267210)}, // 010110111010001000
  {0xceca, ulhc(18, 000267211)}, // 010110111010001001
  {0xcf61, ulhc(18, 000267212)}, // 010110111010001010
  {0xcf62, ulhc(18, 000267213)}, // 010110111010001011
  {0xd0da, ulhc(18, 000267214)}, // 010110111010001100
  {0xe3ca, ulhc(18, 000267215)}, // 010110111010001101
  {0x011f, ulhc(18, 000354266)}, // 011101100010110110
  {0x020a, ulhc(18, 000354267)}, // 011101100010110111
  {0x0250, ulhc(18, 000354270)}, // 011101100010111000
  {0x1e01, ulhc(18, 000354271)}, // 011101100010111001
  {0x4065, ulhc(18, 000354272)}, // 011101100010111010
  {0x40a1, ulhc(18, 000354273)}, // 011101100010111011
  {0x41b0, ulhc(18, 000354274)}, // 011101100010111100
  {0x41b1, ulhc(18, 000354275)}, // 011101100010111101
  {0xc01c, ulhc(18, 000354276)}, // 011101100010111110
  {0xc125, ulhc(18, 000354277)}, // 011101100010111111
  {0xc1b0, ulhc(18, 000357400)}, // 011101111100000000
  {0xce8c, ulhc(18, 000357401)}, // 011101111100000001
  {0xce92, ulhc(18, 000357402)}, // 011101111100000010
  {0xce9e, ulhc(18, 000357403)}, // 011101111100000011
  {0xcea0, ulhc(18, 000357404)}, // 011101111100000100
  {0xced4, ulhc(18, 000357405)}, // 011101111100000101
  {0xcf4e, ulhc(18, 000357406)}, // 011101111100000110
  {0xe7fc, ulhc(18, 000357407)}, // 011101111100000111
  {0xbd82, ulhc(18, 000405771)}, // 100000101111111001
  {0xc099, ulhc(18, 000417644)}, // 100001111110100100
  {0xce8d, ulhc(18, 000417645)}, // 100001111110100101
  {0xcf5a, ulhc(18, 000417646)}, // 100001111110100110
  {0xcf5f, ulhc(18, 000417647)}, // 100001111110100111
  {0xcf6b, ulhc(18, 000417650)}, // 100001111110101000
  {0xcf74, ulhc(18, 000417651)}, // 100001111110101001
  {0xd0dd, ulhc(18, 000417652)}, // 100001111110101010
  {0xd0df, ulhc(18, 000417653)}, // 100001111110101011
  {0xc020, ulhc(18, 000443433)}, // 100100011100011011
  {0xc0e6, ulhc(18, 000506336)}, // 101000110011011110
  {0xce9a, ulhc(18, 000506337)}, // 101000110011011111
  {0xcee0, ulhc(18, 000535554)}, // 101011101101101100
  {0xcf8b, ulhc(18, 000535555)}, // 101011101101101101
  {0x0208, ulhc(18, 000623622)}, // 110010011110010010
  {0x4194, ulhc(18, 000623623)}, // 110010011110010011
  {0x4197, ulhc(18, 000623624)}, // 110010011110010100
  {0xc019, ulhc(18, 000623625)}, // 110010011110010101
  {0xc01d, ulhc(18, 000623626)}, // 110010011110010110
  {0xc11c, ulhc(18, 000623627)}, // 110010011110010111
  {0xce83, ulhc(18, 000623630)}, // 110010011110011000
  {0xce9c, ulhc(18, 000623631)}, // 110010011110011001
  {0xce9d, ulhc(18, 000623632)}, // 110010011110011010
  {0xcecb, ulhc(18, 000623633)}, // 110010011110011011
  {0xced9, ulhc(18, 000623634)}, // 110010011110011100
  {0xcf54, ulhc(18, 000623635)}, // 110010011110011101
  {0xd0d3, ulhc(18, 000623636)}, // 110010011110011110
  {0xf4a0, ulhc(18, 000623637)}, // 110010011110011111
  {0x0127, ulhc(18, 000663250)}, // 110110011010101000
  {0x01cc, ulhc(18, 000663251)}, // 110110011010101001
  {0x4196, ulhc(18, 000663252)}, // 110110011010101010
  {0xce82, ulhc(18, 000663253)}, // 110110011010101011
  {0xce8a, ulhc(18, 000663254)}, // 110110011010101100
  {0xcee1, ulhc(18, 000663255)}, // 110110011010101101
  {0xcf67, ulhc(18, 000663256)}, // 110110011010101110
  {0xcff6, ulhc(18, 000663257)}, // 110110011010101111
  {0xdffa, ulhc(18, 000665764)}, // 110110101111110100
  {0xeae0, ulhc(18, 000665765)}, // 110110101111110101
  {0x001a, ulhc(18, 000670373)}, // 110111000011111011
  {0x01d0, ulhc(18, 000701102)}, // 111000001001000010
  {0x040a, ulhc(18, 000701103)}, // 111000001001000011
  {0x0604, ulhc(18, 000701104)}, // 111000001001000100
  {0x0607, ulhc(18, 000701105)}, // 111000001001000101
  {0x060a, ulhc(18, 000701106)}, // 111000001001000110
  {0x0907, ulhc(18, 000701107)}, // 111000001001000111
  {0x090a, ulhc(18, 000701110)}, // 111000001001001000
  {0x0e04, ulhc(18, 000701111)}, // 111000001001001001
  {0x0e0a, ulhc(18, 000701112)}, // 111000001001001010
  {0x0f02, ulhc(18, 000701113)}, // 111000001001001011
  {0x1307, ulhc(18, 000701114)}, // 111000001001001100
  {0x1308, ulhc(18, 000701115)}, // 111000001001001101
  {0x1f02, ulhc(18, 000701116)}, // 111000001001001110
  {0x2505, ulhc(18, 000701117)}, // 111000001001001111
  {0xc082, ulhc(18, 000701120)}, // 111000001001010000
  {0xc093, ulhc(18, 000701121)}, // 111000001001010001
  {0xc0e2, ulhc(18, 000701122)}, // 111000001001010010
  {0xc127, ulhc(18, 000701123)}, // 111000001001010011
  {0xc12d, ulhc(18, 000701124)}, // 111000001001010100
  {0xc133, ulhc(18, 000701125)}, // 111000001001010101
  {0xc141, ulhc(18, 000701126)}, // 111000001001010110
  {0xce78, ulhc(18, 000701127)}, // 111000001001010111
  {0xce87, ulhc(18, 000701130)}, // 111000001001011000
  {0xce93, ulhc(18, 000701131)}, // 111000001001011001
  {0xcece, ulhc(18, 000701132)}, // 111000001001011010
  {0xcf6c, ulhc(18, 000701133)}, // 111000001001011011
  {0xcf6d, ulhc(18, 000701134)}, // 111000001001011100
  {0xe9fd, ulhc(18, 000701135)}, // 111000001001011101
  {0xe9fe, ulhc(18, 000701136)}, // 111000001001011110
  {0x01c2, ulhc(18, 000750400)}, // 111101000100000000
  {0x0246, ulhc(18, 000750401)}, // 111101000100000001
  {0x024e, ulhc(18, 000750402)}, // 111101000100000010
  {0x1501, ulhc(18, 000750403)}, // 111101000100000011
  {0x41d6, ulhc(18, 000750404)}, // 111101000100000100
  {0xce79, ulhc(18, 000750405)}, // 111101000100000101
  {0xce7c, ulhc(18, 000750406)}, // 111101000100000110
  {0xce88, ulhc(18, 000750407)}, // 111101000100000111
  {0xd0bd, ulhc(18, 000760472)}, // 111110000100111010
  {0x1e05, ulhc(18, 000760473)}, // 111110000100111011
  {0x99cc, ulhc(18, 000774300)}, // 111111100011000000
  {0x9bca, ulhc(18, 000774301)}, // 111111100011000001
  {0x9bcc, ulhc(18, 000774302)}, // 111111100011000010
  {0xc130, ulhc(18, 000774303)}, // 111111100011000011
  {0xce75, ulhc(18, 000774304)}, // 111111100011000100
  {0xce94, ulhc(18, 000774305)}, // 111111100011000101
  {0xd0d4, ulhc(18, 000774306)}, // 111111100011000110
  {0xe3cb, ulhc(18, 000774307)}, // 111111100011000111
  {0xefc0, ulhc(19, 000131454)}, // 0001011001100101100
  {0x0019, ulhc(19, 000131455)}, // 0001011001100101101
  {0x0125, ulhc(19, 000232126)}, // 0010011010001010110
  {0x0210, ulhc(19, 000232127)}, // 0010011010001010111
  {0x0244, ulhc(19, 000232130)}, // 0010011010001011000
  {0x0258, ulhc(19, 000232131)}, // 0010011010001011001
  {0x0260, ulhc(19, 000232132)}, // 0010011010001011010
  {0x0264, ulhc(19, 000232133)}, // 0010011010001011011
  {0x0f05, ulhc(19, 000232134)}, // 0010011010001011100
  {0xc112, ulhc(19, 000232135)}, // 0010011010001011101
  {0xce6f, ulhc(19, 000232136)}, // 0010011010001011110
  {0xce76, ulhc(19, 000232137)}, // 0010011010001011111
  {0xcec5, ulhc(19, 000241120)}, // 0010100001001010000
  {0xced5, ulhc(19, 000241121)}, // 0010100001001010001
  {0xcf4d, ulhc(19, 000241122)}, // 0010100001001010010
  {0xd0d9, ulhc(19, 000241123)}, // 0010100001001010011
  {0xdfe6, ulhc(19, 000241124)}, // 0010100001001010100
  {0x025a, ulhc(19, 000440247)}, // 0100100000010100111
  {0x1009, ulhc(19, 000556434)}, // 0101101110100011100
  {0x1209, ulhc(19, 000556435)}, // 0101101110100011101
  {0x1409, ulhc(19, 000556436)}, // 0101101110100011110
  {0xc117, ulhc(19, 000556437)}, // 0101101110100011111
  {0xce73, ulhc(19, 000562740)}, // 0101110010111100000
  {0xce7d, ulhc(19, 000562741)}, // 0101110010111100001
  {0xce90, ulhc(19, 000562742)}, // 0101110010111100010
  {0xcec0, ulhc(19, 000562743)}, // 0101110010111100011
  {0xcecf, ulhc(19, 000562744)}, // 0101110010111100100
  {0xced3, ulhc(19, 000562745)}, // 0101110010111100101
  {0xcf50, ulhc(19, 000562746)}, // 0101110010111100110
  {0xe3cd, ulhc(19, 000562747)}, // 0101110010111100111
  {0xe6e0, ulhc(19, 001013760)}, // 1000001011111110000
  {0x0123, ulhc(19, 001013761)}, // 1000001011111110001
  {0x1602, ulhc(19, 001037530)}, // 1000011111101011000
  {0x41d1, ulhc(19, 001037531)}, // 1000011111101011001
  {0x9959, ulhc(19, 001037532)}, // 1000011111101011010
  {0x9b59, ulhc(19, 001037533)}, // 1000011111101011011
  {0x9b7f, ulhc(19, 001037534)}, // 1000011111101011100
  {0xbdb1, ulhc(19, 001037535)}, // 1000011111101011101
  {0xc0c1, ulhc(19, 001037536)}, // 1000011111101011110
  {0xce72, ulhc(19, 001037537)}, // 1000011111101011111
  {0xce9f, ulhc(19, 001037760)}, // 1000011111111110000
  {0xceea, ulhc(19, 001037761)}, // 1000011111111110001
  {0xcef3, ulhc(19, 001037762)}, // 1000011111111110010
  {0xcf4b, ulhc(19, 001037763)}, // 1000011111111110011
  {0xe88f, ulhc(19, 001037764)}, // 1000011111111110100
  {0x0121, ulhc(19, 001454400)}, // 1100101100100000000
  {0x0206, ulhc(19, 001454401)}, // 1100101100100000001
  {0x020c, ulhc(19, 001454402)}, // 1100101100100000010
  {0xc11a, ulhc(19, 001454403)}, // 1100101100100000011
  {0xce7b, ulhc(19, 001454404)}, // 1100101100100000100
  {0xce7e, ulhc(19, 001454405)}, // 1100101100100000101
  {0xce8b, ulhc(19, 001454406)}, // 1100101100100000110
  {0xcec1, ulhc(19, 001454407)}, // 1100101100100000111
  {0xcec3, ulhc(19, 001500210)}, // 1101000000010001000
  {0xced2, ulhc(19, 001500211)}, // 1101000000010001001
  {0xceda, ulhc(19, 001500212)}, // 1101000000010001010
  {0xcedc, ulhc(19, 001500213)}, // 1101000000010001011
  {0xcede, ulhc(19, 001560764)}, // 1101110000111110100
  {0x020e, ulhc(19, 001560765)}, // 1101110000111110101
  {0x0212, ulhc(19, 001602276)}, // 1110000010010111110
  {0x0252, ulhc(19, 001602277)}, // 1110000010010111111
  {0x0262, ulhc(19, 001602300)}, // 1110000010011000000
  {0x0408, ulhc(19, 001602301)}, // 1110000010011000001
  {0x0409, ulhc(19, 001602302)}, // 1110000010011000010
  {0x040d, ulhc(19, 001602303)}, // 1110000010011000011
  {0x0608, ulhc(19, 001602304)}, // 1110000010011000100
  {0x0609, ulhc(19, 001602305)}, // 1110000010011000101
  {0x060d, ulhc(19, 001602306)}, // 1110000010011000110
  {0x0904, ulhc(19, 001602307)}, // 1110000010011000111
  {0x0908, ulhc(19, 001602310)}, // 1110000010011001000
  {0x0909, ulhc(19, 001602311)}, // 1110000010011001001
  {0x090d, ulhc(19, 001602312)}, // 1110000010011001010
  {0x0d04, ulhc(19, 001602313)}, // 1110000010011001011
  {0x0d07, ulhc(19, 001602314)}, // 1110000010011001100
  {0x0e08, ulhc(19, 001602315)}, // 1110000010011001101
  {0x0e09, ulhc(19, 001602316)}, // 1110000010011001110
  {0x0e0d, ulhc(19, 001602317)}, // 1110000010011001111
  {0x110d, ulhc(19, 001602320)}, // 1110000010011010000
  {0x1309, ulhc(19, 001602321)}, // 1110000010011010001
  {0x1604, ulhc(19, 001602322)}, // 1110000010011010010
  {0x1809, ulhc(19, 001602323)}, // 1110000010011010011
  {0x1c0a, ulhc(19, 001602324)}, // 1110000010011010100
  {0x4024, ulhc(19, 001602325)}, // 1110000010011010101
  {0x4025, ulhc(19, 001602326)}, // 1110000010011010110
  {0x4064, ulhc(19, 001602327)}, // 1110000010011010111
  {0xc025, ulhc(19, 001602330)}, // 1110000010011011000
  {0xc07a, ulhc(19, 001602331)}, // 1110000010011011001
  {0xc07d, ulhc(19, 001602332)}, // 1110000010011011010
  {0xc088, ulhc(19, 001602333)}, // 1110000010011011011
  {0xc08d, ulhc(19, 001602334)}, // 1110000010011011100
  {0xc08f, ulhc(19, 001602335)}, // 1110000010011011101
  {0xc09c, ulhc(19, 001602336)}, // 1110000010011011110
  {0xc0cd, ulhc(19, 001602337)}, // 1110000010011011111
  {0xc0cf, ulhc(19, 001641140)}, // 1110100001001100000
  {0xc0e8, ulhc(19, 001641141)}, // 1110100001001100001
  {0xc116, ulhc(19, 001641142)}, // 1110100001001100010
  {0xc15e, ulhc(19, 001641143)}, // 1110100001001100011
  {0xc182, ulhc(19, 001641144)}, // 1110100001001100100
  {0xce89, ulhc(19, 001641145)}, // 1110100001001100101
  {0xce9b, ulhc(19, 001641146)}, // 1110100001001100110
  {0xcebf, ulhc(19, 001641147)}, // 1110100001001100111
  {0xcedb, ulhc(19, 001641150)}, // 1110100001001101000
  {0xcedd, ulhc(19, 001641151)}, // 1110100001001101001
  {0xcf53, ulhc(19, 001641152)}, // 1110100001001101010
  {0xeee0, ulhc(19, 001641153)}, // 1110100001001101011
  {0xefc6, ulhc(19, 001641154)}, // 1110100001001101100
  {0x0129, ulhc(20, 000502252)}, // 00101000010010101010
  {0x0268, ulhc(20, 000502253)}, // 00101000010010101011
  {0x9b14, ulhc(20, 000502254)}, // 00101000010010101100
  {0xce6d, ulhc(20, 000502255)}, // 00101000010010101101
  {0xce71, ulhc(20, 000502256)}, // 00101000010010101110
  {0xcea3, ulhc(20, 000502257)}, // 00101000010010101111
  {0xceb6, ulhc(20, 000762630)}, // 00111110010110011000
  {0xcec6, ulhc(20, 000762631)}, // 00111110010110011001
  {0xcec7, ulhc(20, 000762632)}, // 00111110010110011010
  {0xcec9, ulhc(20, 000762633)}, // 00111110010110011011
  {0xcf51, ulhc(20, 001100514)}, // 01001000000101001100
  {0xf558, ulhc(20, 001100515)}, // 01001000000101001101
  {0x012b, ulhc(20, 002077752)}, // 10000111111111101010
  {0x026a, ulhc(20, 002077753)}, // 10000111111111101011
  {0xce70, ulhc(20, 002077754)}, // 10000111111111101100
  {0xce74, ulhc(20, 002077755)}, // 10000111111111101101
  {0xcea2, ulhc(20, 002077756)}, // 10000111111111101110
  {0xced1, ulhc(20, 002077757)}, // 10000111111111101111
  {0xd0dc, ulhc(20, 002142220)}, // 10001100010010010000
  {0xff83, ulhc(20, 002142221)}, // 10001100010010010001
  {0x0256, ulhc(20, 003502332)}, // 11101000010011011010
  {0x040c, ulhc(20, 003502333)}, // 11101000010011011011
  {0x060c, ulhc(20, 003502334)}, // 11101000010011011100
  {0x090c, ulhc(20, 003502335)}, // 11101000010011011101
  {0x0e0c, ulhc(20, 003502336)}, // 11101000010011011110
  {0x4045, ulhc(20, 003502337)}, // 11101000010011011111
  {0xce7f, ulhc(20, 003517140)}, // 11101001111001100000
  {0xceb8, ulhc(20, 003517141)}, // 11101001111001100001
  {0xcebd, ulhc(20, 003517142)}, // 11101001111001100010
  {0xcebe, ulhc(20, 003517143)}, // 11101001111001100011
  {0xceee, ulhc(20, 003517144)}, // 11101001111001100100
  {0xcef1, ulhc(20, 003517145)}, // 11101001111001100101
  {0xcff5, ulhc(20, 003517146)}, // 11101001111001100110
  {0xdff9, ulhc(20, 003517147)}, // 11101001111001100111
  {0x0254, ulhc(21, 004304444)}, // 100011000100100100100
  {0x026c, ulhc(21, 004304445)}, // 100011000100100100101
  {0xc06a, ulhc(21, 004304446)}, // 100011000100100100110
  {0xcea4, ulhc(21, 004304447)}, // 100011000100100100111
  {0xcea5, ulhc(21, 004304450)}, // 100011000100100101000
  {0xceba, ulhc(21, 004304451)}, // 100011000100100101001
  {0xcebc, ulhc(21, 004304452)}, // 100011000100100101010
  {0xcec2, ulhc(21, 004304453)}, // 100011000100100101011
  {0xcec8, ulhc(21, 004304454)}, // 100011000100100101100
  {0xceeb, ulhc(21, 004304455)}, // 100011000100100101101
  {0xceec, ulhc(21, 004304456)}, // 100011000100100101110
  {0xceed, ulhc(21, 004304457)}, // 100011000100100101111
  {0xcef4, ulhc(21, 004434320)}, // 100100011100011010000
  {0xcef6, ulhc(21, 004434321)}, // 100100011100011010001
  {0xcef7, ulhc(21, 004434322)}, // 100100011100011010010
  {0x025e, ulhc(22, 011070646)}, // 1001000111000110100110
  {0x0266, ulhc(22, 011070647)}, // 1001000111000110100111
  {0x1103, ulhc(22, 011070650)}, // 1001000111000110101000
  {0xc0a0, ulhc(22, 011070651)}, // 1001000111000110101001
  {0xceb9, ulhc(22, 011070652)}, // 1001000111000110101010
  {0xcebb, ulhc(22, 011070653)}, // 1001000111000110101011
  {0xceef, ulhc(22, 011070654)}, // 1001000111000110101100
  {0xcef0, ulhc(22, 011070655)}, // 1001000111000110101101
  {0xcef5, ulhc(22, 011070656)}, // 1001000111000110101110
  {0xcf4f, ulhc(22, 011070657)}, // 1001000111000110101111
};


// Bootloader templates

/*
 * m169_autobaud_uart0_noled_pr      m169a_autobaud_uart0_noled        m169a_autobaud_uart0_noled_pr
 * m169p_autobaud_uart0_noled        m169p_autobaud_uart0_noled_pr     m169pa_autobaud_uart0_noled
 * m169pa_autobaud_uart0_noled_pr    m165_autobaud_uart0_noled         m165_autobaud_uart0_noled_pr
 * m165a_autobaud_uart0_noled        m165a_autobaud_uart0_noled_pr     m165p_autobaud_uart0_noled
 * m165p_autobaud_uart0_noled_pr     m165pa_autobaud_uart0_noled       m165pa_autobaud_uart0_noled_pr
 */
static const uint64_t ur_m169_autobaud_uart0_noled[] = {
  0xc4b777777759bb37, 0xdddddddd55f85f9b, 0xeea41b4de0fab68c, 0x0bcd875e35f67eee, 0x416caef2776c7b21,
  0xfa1e7fba9827c602, 0x74088153e123d7fd, 0xaa935f3873017488, 0xc90e1b46f6a8e15f, 0xfc19a4f51ebf9df2,
  0x05bdd35ad52e38e9, 0x173b1a446678e62c, 0x2b21ab71cb1823af, 0xe73859bf0312b5ec, 0x16f378392b01deb5,
  0x5fcdba96ae5297ce, 0x9d10267c502169dc, 0x612e65f36d38c6f1, 0xc81a3f8d163ce1bb, 0x70cf4c2b93f75663,
  0x3a4a5b2c944e32c9, 0xae3e792bf734332c, 0x0000000007110249,
};

/*
 * m169a_autobaud_uart0_noled_pr_u4  m169p_autobaud_uart0_noled_pr_u4  m169pa_autobaud_uart0_noled_pr_u4
 * m165_autobaud_uart0_noled_pr_u4   m165a_autobaud_uart0_noled_pr_u4  m165p_autobaud_uart0_noled_pr_u4
 * m165pa_autobaud_uart0_noled_pr_u4
 */
static const uint64_t ur_m169_autobaud_uart0_noled_pr_u4[] = {
  0x6eeeeeed1222e59b, 0xbbbbbaabf0bedb89, 0xf4bc7cc982fdb1fb, 0x1c00f26eeedc4e1f, 0x93bbc962732193aa,
  0xfcc13e30120b6577, 0x9f09751fe78167f6, 0xc3980ba443a0440a, 0x37b5470afd549af9, 0xd47e80ef9610f0da,
  0x7bed68e3a7f0682f, 0xfa3d61cc580b2ca6, 0x1ffb30475e8f9dab, 0xe07967b63eccf2a0, 0xc2cdf81895af60e3,
  0x7807d4180ef5af39, 0x75539794d8ce16f3, 0xd2c2e718de33a205, 0xe6d892455bd8aaa2, 0xe2e4d5c1e6c25ccb,
  0xeacc7903f2868b1b, 0xde1ef79430a9cfd4, 0x327f81fc65f989ff, 0x1e8bfc0fdfb0cd0f, 0x4e32c970cf4c2f8d,
  0x734332c3a4a5b3e0, 0x186bea8880a792bf, 0x0000000000000001,
};

/*
 * m169_autobaud_uart0_noled_pr_ee_u4 m169a_autobaud_uart0_noled_pr_ee
 * m169a_autobaud_uart0_noled_pr_ee_u4 m169p_autobaud_uart0_noled_pr_ee
 * m169p_autobaud_uart0_noled_pr_ee_u4 m169pa_autobaud_uart0_noled_pr_ee
 * m169pa_autobaud_uart0_noled_pr_ee_u4 m165_autobaud_uart0_noled_pr_ee
 * m165_autobaud_uart0_noled_pr_ee_u4 m165a_autobaud_uart0_noled_pr_ee
 * m165a_autobaud_uart0_noled_pr_ee_u4 m165p_autobaud_uart0_noled_pr_ee
 * m165p_autobaud_uart0_noled_pr_ee_u4 m165pa_autobaud_uart0_noled_pr_ee
 * m165pa_autobaud_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m169_autobaud_uart0_noled_pr_ee[] = {
  0x96eeeeeed1222a20, 0xbbbbbbaab8bf8d38, 0xb3f60cf1d91fd34b, 0x5c9083236b778f8d, 0xe8f62d51c635040f,
  0x04f8c0482d95de4e, 0x4a577f9e059fd9d3, 0xc05d221d022054f8, 0xaa3857eaa4d7ce1c, 0x49aad68e7186d1bd,
  0xf06cc1a63ea3cae4, 0xd68450ef8afbaf51, 0x4d7d185962291669, 0xcead2f38ae359348, 0x0ebce9bb6f68f059,
  0x8a39e461c6c6ab5d, 0xadc37b2d97317090, 0x600544a9a546c11f, 0xaf39c2cdf81895af, 0x16f37807d4180ef5,
  0xa20575539794d8ce, 0xaaa2d2c2e718de33, 0x5ccbe6d892455bd8, 0x8b1be2e4d5c1e6c2, 0xcfd4eacc7903f286,
  0x89ffde1ef79430a9, 0xcd0f327f81fc65f9, 0x2f8d1e8bfc0fdfb0, 0xb3e04e32c970cf4c, 0x92bf734332c3a4a5,
  0x00009a9c9a0880a7,
};

/*
 * m169_autobaud_uart0_noled_pr_ce_u4 m169a_autobaud_uart0_noled_pr_ce
 * m169a_autobaud_uart0_noled_pr_ce_u4 m169p_autobaud_uart0_noled_pr_ce
 * m169p_autobaud_uart0_noled_pr_ce_u4 m169pa_autobaud_uart0_noled_pr_ce
 * m169pa_autobaud_uart0_noled_pr_ce_u4 m165_autobaud_uart0_noled_pr_ce
 * m165_autobaud_uart0_noled_pr_ce_u4 m165a_autobaud_uart0_noled_pr_ce
 * m165a_autobaud_uart0_noled_pr_ce_u4 m165p_autobaud_uart0_noled_pr_ce
 * m165p_autobaud_uart0_noled_pr_ce_u4 m165pa_autobaud_uart0_noled_pr_ce
 * m165pa_autobaud_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m169_autobaud_uart0_noled_pr_ce[] = {
  0x2ddddddda2447705, 0xeeeeeeaaf49fc5f1, 0x44d85a331a0ba106, 0x6967ef1deeeed08c, 0xbc9ddb0db2bc8a4c,
  0x95a609f180905b2b, 0xa9f09143ff3c0b3f, 0x9c3980ba443a0440, 0xa37b5470afd549af, 0x953b7f2e2fae490d,
  0xd8488bee24b1e78c, 0x3fcc41fa8f84bf10, 0xb9633f5933c5dc6e, 0x8e9fc1eb3d4727a7, 0x7ac398b0147ce923,
  0xf6678ebd1f3b57f4, 0x3cb5b87d99e5403f, 0x66fc0c4ad7b071f0, 0x03ea0c077ad79ce1, 0xa9cbca6c670b79bc,
  0x61738c6f19d102ba, 0xd89218edec555169, 0xe4d5c1e6c25ccbe6, 0xcc7903f2868b1be2, 0x1ef79430a9cfd4ea,
  0x7f81fc65f989ffde, 0x8bfc0fdfb0cd0f32, 0x32c970cf4c2f8d1e, 0x4332c3a4a5b3e04e, 0xabcdb880a792bf73,
  0x000000000000011b,
};

/*
 * m169a_autobaud_uart0_noled_pr_ee_ce m169p_autobaud_uart0_noled_pr_ee_ce
 * m169pa_autobaud_uart0_noled_pr_ee_ce m165_autobaud_uart0_noled_pr_ee_ce
 * m165a_autobaud_uart0_noled_pr_ee_ce m165p_autobaud_uart0_noled_pr_ee_ce
 * m165pa_autobaud_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m169_autobaud_uart0_noled_pr_ee_ce[] = {
  0x12dddddddd4458e2, 0xeeeeeeeaaf1a0a67, 0x6d71b4537624760d, 0x4b42cb2ab4dd85ea, 0xe94e1ec1b8eb74ee,
  0x04f8c0482d95de4e, 0x905aff3c0b3e3373, 0x80ba443a0440a9f0, 0x5470afd549af9c39, 0x877fd51bf90da37b,
  0x5da1f7e78c953bc0, 0xacac7be6139dc6e3, 0x06b5fd4795f5129d, 0x814c5613fd47c1b3, 0xc2cb1148b34eb422,
  0xeaedd388ea426be8, 0xebce9bb6f68f059c, 0x473c8c38d8d578d8, 0x386f65b2e62e1211, 0x16744a9a546c1132,
  0xf39c2cdf81895af6, 0x6f37807d4180ef5a, 0x20575539794d8ce1, 0xaa2d2c2e718de33a, 0x997cdb12431dbd8a,
  0xa2c79c5c9ab8d84b, 0x5c9fbab31e40fca1, 0x64a271964b867a61, 0x5fb9a19961d252d9, 0x00566d3ebc4053c9,
};

/*
 * m169a_autobaud_uart0_noled_pr_ee_ce_u4 m169p_autobaud_uart0_noled_pr_ee_ce_u4
 * m169pa_autobaud_uart0_noled_pr_ee_ce_u4 m165_autobaud_uart0_noled_pr_ee_ce_u4
 * m165a_autobaud_uart0_noled_pr_ee_ce_u4 m165p_autobaud_uart0_noled_pr_ee_ce_u4
 * m165pa_autobaud_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_autobaud_uart0_noled_pr_ee_ce_u4[] = {
  0x2ddddddda2435f41, 0x7777775573c14671, 0x6ec48f4eb23a1bb7, 0x6277d3c3f006ead0, 0x3bb45fddb62ae264,
  0xcc13e30120b65779, 0x094edffd8aecfd6f, 0x980ba443a0440a9f, 0xb5470afd549af9c3, 0x06e2faa390f0da37,
  0xfb892c79e50b8387, 0x7ea3e12fc4361222, 0xbe678bb8dce8fa92, 0xa8f2bea253b5b9b7, 0xc27fa8f83660d6bf,
  0x291669d68450298a, 0x711d484d7d185962, 0x76ded1e0b39d5dba, 0x871b1aaf1b1d79d3, 0xb65cc5c24228e791,
  0x534a8d8226470dec, 0x9bf0312b5ec2ce89, 0x0fa8301deb5e7385, 0xa72f29b19c2de6f0, 0x85ce31bc67440aea,
  0x624863b7b15545a5, 0xdf0dc79b09732f9b, 0xa75666fe0eee3458, 0xfef0f7bca1854e7e, 0x7993fc0fe32fcc4f,
  0x68f45fe07efd8668, 0x0271964b867a617c, 0xfb9a19961d252d9f, 0x08221b906e8b3c95,
};

/*
 * m169a_autobaud_uart0_noled_hw     m169p_autobaud_uart0_noled_hw     m169pa_autobaud_uart0_noled_hw
 * m165_autobaud_uart0_noled_hw      m165a_autobaud_uart0_noled_hw     m165p_autobaud_uart0_noled_hw
 * m165pa_autobaud_uart0_noled_hw
 */
static const uint64_t ur_m169_autobaud_uart0_noled_hw[] = {
  0x25bbbbbbbacdc49f, 0xeeeeeeeaafc2eebe, 0x20da569425f9b006, 0xb4133f4a64f77775, 0x0b657793bb98921a,
  0x38f3e7acc13e3012, 0xa0440a9f094beffc, 0x549af9c3980ba443, 0x4870da37b5470afd, 0xf06693d47e78ef96,
  0x16f74c37c9e8e3a7, 0x5cecf691e33398b0, 0x2b289dc72c608ebc, 0xe73859bf0312b5ec, 0xde6f00fa8301deb5,
  0x40aeaa72f29b19c2, 0x545a585ce31bc674, 0x997cdb1248ab7b15, 0x615c9f9fd86ed84b, 0xd964a271964b867a,
  0xc95fb9a19961d252, 0x00000db2d5bbb053,
};

/*
 * m169a_autobaud_uart0_noled_ee_hw  m169p_autobaud_uart0_noled_ee_hw  m169pa_autobaud_uart0_noled_ee_hw
 * m165_autobaud_uart0_noled_ee_hw   m165a_autobaud_uart0_noled_ee_hw  m165p_autobaud_uart0_noled_ee_hw
 * m165pa_autobaud_uart0_noled_ee_hw
 */
static const uint64_t ur_m169_autobaud_uart0_noled_ee_hw[] = {
  0x96eeeeeed121be4a, 0xbbbbbbaab8bf8d38, 0x1b67ec19e3bd23fb, 0x1eb9210646d6ef1f, 0x793ba528eb6abe08,
  0x674c13e30120b657, 0x54f84a577fd0a67f, 0xce1cc05d221d0220, 0xd1bdaa3857eaa4d7, 0xcae449aad68e7186,
  0xaf51f06cc1a63ea3, 0x1669d68450ef8afb, 0x93484d7d18596229, 0xf059cead2f38ae35, 0xab5d0ebce9bb6f68,
  0x70908a39e461c6c6, 0xc11fadc37b2d9731, 0x95af600544a9a546, 0x0ef5af39c2cdf818, 0xd8ce16f37807d418,
  0xde33a20575539794, 0x5bd8aaa2d2c2e718, 0xe6c25ccbe6d89245, 0x9430a9cfd4176371, 0xfc65f989ffde1ef7,
  0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc, 0xc3a4a5b3e04e32c9, 0x24e8a792bf734332, 0x00000000000b13df,
};

/*
 * m169a_autobaud_uart0_noled_ce_hw  m169p_autobaud_uart0_noled_ce_hw  m169pa_autobaud_uart0_noled_ce_hw
 * m165_autobaud_uart0_noled_ce_hw   m165a_autobaud_uart0_noled_ce_hw  m165p_autobaud_uart0_noled_ce_hw
 * m165pa_autobaud_uart0_noled_ce_hw
 */
static const uint64_t ur_m169_autobaud_uart0_noled_ce_hw[] = {
  0x96eeeeeed1218375, 0x777777557a4fe2f8, 0x1889b0b4663b4177, 0xc4d2cfde3bdddda1, 0x6caef27760580ad6,
  0x4cfe569827c60241, 0x0440a9f09143ffa1, 0x49af9c3980ba443a, 0x490da37b5470afd5, 0xcf285c1c7f2e2fae,
  0x7e21b09117dc4963, 0xe370c7c66ff51f09, 0x3d3dcb19fac99e2e, 0x491c74fe0f59ea39, 0xbfa3d61cc580a3e7,
  0x01ffb33c75e8f9da, 0x8f81e5adc3eccf2a, 0xe70b37e06256bd83, 0xcde01f50603bd6bc, 0x15d54e5e5363385b,
  0x8b4b0b9c6378ce88, 0x5f36c490c76f62aa, 0x7ea0bb1b8f3612e6, 0x4ffef0f7bca1854e, 0x687993fc0fe32fcc,
  0x7c68f45fe07efd86, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x0006e8dc60e5453c,
};

/*
 * m169_autobaud_uart0_noled_ee_ce_u4_hw m169a_autobaud_uart0_noled_ee_ce_hw
 * m169a_autobaud_uart0_noled_ee_ce_u4_hw m169p_autobaud_uart0_noled_ee_ce_hw
 * m169p_autobaud_uart0_noled_ee_ce_u4_hw m169pa_autobaud_uart0_noled_ee_ce_hw
 * m169pa_autobaud_uart0_noled_ee_ce_u4_hw m165_autobaud_uart0_noled_ee_ce_hw
 * m165_autobaud_uart0_noled_ee_ce_u4_hw m165a_autobaud_uart0_noled_ee_ce_hw
 * m165a_autobaud_uart0_noled_ee_ce_u4_hw m165p_autobaud_uart0_noled_ee_ce_hw
 * m165p_autobaud_uart0_noled_ee_ce_u4_hw m165pa_autobaud_uart0_noled_ee_ce_hw
 * m165pa_autobaud_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_autobaud_uart0_noled_ee_ce_hw[] = {
  0x5bbbbbbb44864c7f, 0xeeeeeeaae7828ce2, 0xdd891e9d6474376e, 0xc4efa787e00dd5a0, 0x93bbd7773b6abcc8,
  0xfcc13e30120b6577, 0x3e129dbffa14cfd6, 0x8730174887408815, 0x6f6a8e15faa935f3, 0x0e0dc5f54721e1b4,
  0x45f71258f3ca1707, 0x91fd47c25f886c24, 0xb7be678bb8dc4a8b, 0xbfa8f2bea253b5b9, 0x8ac27fa8f83660d6,
  0x62291669d6845029, 0xba711d484d7d1859, 0xd376ded1e0b39d5d, 0x91871b1aaf1b1d79, 0xecb65cc5c24228e7,
  0x89534a8d8226470d, 0x859bf0312b5ec2ce, 0xf00fa8301deb5e73, 0xeaa72f29b19c2de6, 0xa585ce31bc67440a,
  0x9b624863b7b15545, 0x505d8dc79b09732f, 0xff787bde50c2a73f, 0x3cc9fe07f197e627, 0x347a2ff03f7ec334,
  0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf, 0x0009521b90a29e4a,
};

/*
 * m169a_autobaud_uart0_lednop       m169p_autobaud_uart0_lednop       m169pa_autobaud_uart0_lednop
 * m165_autobaud_uart0_lednop        m165a_autobaud_uart0_lednop       m165p_autobaud_uart0_lednop
 * m165pa_autobaud_uart0_lednop
 */
static const uint64_t ur_m169_autobaud_uart0_lednop[] = {
  0x44b777777759bb37, 0xfdddddddd55f85c6, 0x520da3afad3c4ef8, 0xd36200db69177777, 0x20b657793bb63d90,
  0xfd0f3f224c13e301, 0x3a0440a9f09695fe, 0xd549af9c3980ba44, 0x64870da37b5470af, 0x7f06693d47278ef9,
  0x80b7ba61f3a48e3a, 0x8b9d9af91c829cc5, 0x0ac1f7b8e58c11d7, 0x404e166fc0c4ad7b, 0xe6c8a0c077ad79e0,
  0x9bd4a7253a005bcd, 0xba718de33a2077ca, 0x6e722adec555169a, 0xf3fb0ddb09732f9b, 0x4e32c970cf4c2b93,
  0x34332c3a4a5b2c94, 0x662fd7ae3e792bf7, 0x000000000000000d,
};

/*
 * m169_autobaud_uart0_lednop_pr_u4  m169a_autobaud_uart0_lednop_pr    m169a_autobaud_uart0_lednop_pr_u4
 * m169p_autobaud_uart0_lednop_pr    m169p_autobaud_uart0_lednop_pr_u4 m169pa_autobaud_uart0_lednop_pr
 * m169pa_autobaud_uart0_lednop_pr_u4 m165_autobaud_uart0_lednop_pr
 * m165_autobaud_uart0_lednop_pr_u4  m165a_autobaud_uart0_lednop_pr    m165a_autobaud_uart0_lednop_pr_u4
 * m165p_autobaud_uart0_lednop_pr    m165p_autobaud_uart0_lednop_pr_u4 m165pa_autobaud_uart0_lednop_pr
 * m165pa_autobaud_uart0_lednop_pr_u4
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_pr[] = {
  0xb77777768911259b, 0xdddddd55f85cb8c4, 0xedbf4a9171debd3d, 0xff1fe2f7776e270f, 0x4eecbbb120ce05c2,
  0x7304f8c0482d95de, 0x7c25dd7f9e059f8f, 0x0e602e910e81102a, 0xded51c2bf5526be7, 0x51ed63be5843c368,
  0xc907e38e9fc1a0bf, 0x4690ce62c0596537, 0xff6608ebd1f3b2cf, 0x0f2cf6d059a45403, 0x59bf0312b5ec82b4,
  0x8301deb5e7810138, 0x9c94e8016f379b22, 0x378ce881df2a6f52, 0xab7b15545a6ae9c6, 0x1e6c25ccbe6db9c8,
  0x3f2868b1be2e4d5c, 0x430a9cfd4eacc790, 0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0,
  0x3a4a5b3e04e32c97, 0x880a792bf734332c, 0x000000001186080b,
};

/*
 * m169a_autobaud_uart0_lednop_pr_ee m169p_autobaud_uart0_lednop_pr_ee m169pa_autobaud_uart0_lednop_pr_ee
 * m165_autobaud_uart0_lednop_pr_ee  m165a_autobaud_uart0_lednop_pr_ee m165p_autobaud_uart0_lednop_pr_ee
 * m165pa_autobaud_uart0_lednop_pr_ee
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_pr_ee[] = {
  0xddddddd0f5a22044, 0x7777755717fa0b12, 0x34cfda9bfa7a6277, 0xb210646d6ef1f1b6, 0x829395c1086d16a2,
  0x3e30120b657793ba, 0xd37fe78167c6b4c1, 0x1748874088153e12, 0x8e15faa935f38730, 0x6ab5a39c61b46f6a,
  0x1b30698fa8f2b32a, 0x422877c561efd47c, 0xbe8c2cb1148b34eb, 0x56973d571ac9a426, 0xaf3a6ed1923268e7,
  0x82791bdab1aad743, 0x70decb65cc5c2422, 0x021f667951b047eb, 0x04e166fc0c4ad7b0, 0x6c8a0c077ad79e04,
  0xbd4a7253a005bcde, 0xa718de33a2077ca9, 0xe722adec555169ab, 0x357079b09732f9b6, 0xf207e50d1674f8b9,
  0x7f2861539fa9d598, 0x43cc9fe2e7197e62, 0xd30ae4fc73dffc13, 0x296cf8138cb25c33, 0x29e4afdcd0ccb0e9,
  0x0000001353ba7a20,
};

/*
 * m169a_autobaud_uart0_lednop_pr_ee_u4 m169p_autobaud_uart0_lednop_pr_ee_u4
 * m169pa_autobaud_uart0_lednop_pr_ee_u4 m165_autobaud_uart0_lednop_pr_ee_u4
 * m165a_autobaud_uart0_lednop_pr_ee_u4 m165p_autobaud_uart0_lednop_pr_ee_u4
 * m165pa_autobaud_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_pr_ee_u4[] = {
  0x96eeeeeed1222582, 0xbbbbbbaab8bfb4b8, 0x537656da9b45d23f, 0x2f0a83236b74bdfa, 0xd3b410e5d96aa0b4,
  0x09f180905b2bbc9d, 0x9656ff3c0b3fa6e6, 0x80ba443a0440a9f0, 0x5470afd549af9c39, 0xf355ad1af90da37b,
  0x83660f22fa8f2b09, 0xb422877c57227a8f, 0x6be8c2cb1148b34e, 0xd5a5e5f2e2899a42, 0x5eba9bb08a8f9e39,
  0x8afe8f596355ae87, 0xc37b2e1c8c5c2422, 0x0312b5ec5c0fbfad, 0xdeb5e781013859bf, 0xe8016f379b228301,
  0xe881df2a6f529c94, 0x15545a6ae9c6378c, 0x25ccbe6db9c8ab7b, 0x68b1be2e4d5c1e6c, 0x9cfd4eacc7903f28,
  0x989ffde1ef79430a, 0x0cd0f327f81fc65f, 0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4, 0x792bf734332c3a4a,
  0x00001353922f880a,
};

/*
 * m169_autobaud_uart0_lednop_pr_ce_u4 m169a_autobaud_uart0_lednop_pr_ce
 * m169a_autobaud_uart0_lednop_pr_ce_u4 m169p_autobaud_uart0_lednop_pr_ce
 * m169p_autobaud_uart0_lednop_pr_ce_u4 m169pa_autobaud_uart0_lednop_pr_ce
 * m169pa_autobaud_uart0_lednop_pr_ce_u4 m165_autobaud_uart0_lednop_pr_ce
 * m165_autobaud_uart0_lednop_pr_ce_u4 m165a_autobaud_uart0_lednop_pr_ce
 * m165a_autobaud_uart0_lednop_pr_ce_u4 m165p_autobaud_uart0_lednop_pr_ce
 * m165p_autobaud_uart0_lednop_pr_ce_u4 m165pa_autobaud_uart0_lednop_pr_ce
 * m165pa_autobaud_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_pr_ce[] = {
  0x96eeeeeed1222044, 0x777777557a4fc338, 0x1c5e6c58fb23ad17, 0xeb8d3537bbbb4231, 0xf277505272e9c10d,
  0xba9827c602416cae, 0xa7c25813fcf02cfd, 0x70e602e910e81102, 0x8ded51c2bf5526be, 0xa9dd4ab8beb92436,
  0xc2445f71258f3c64, 0x6fc00fd47c25f886, 0x9633f5933c5dc6e5, 0xe9fc1eb3d47e927b, 0x43398b0153111638,
  0x99e3af47cecb3d1a, 0x2d6e416691500ffd, 0xbf0312b5ec82b40f, 0x01deb5e781013859, 0x94e8016f379b2283,
  0x8ce881df2a6f529c, 0x7b15545a6ae9c637, 0xd84b997cdb73863b, 0x50d1637c5c9ab83c, 0x1539fa9d598f207e,
  0xbf313ffbc3def286, 0xf619a1e64ff03f8c, 0xe985f1a3d17f81fb, 0x94b67c09c6592e19, 0x14f257ee68665874,
  0x00000011bad59510,
};

/*
 * m169a_autobaud_uart0_lednop_pr_ee_ce m169p_autobaud_uart0_lednop_pr_ee_ce
 * m169pa_autobaud_uart0_lednop_pr_ee_ce m165_autobaud_uart0_lednop_pr_ee_ce
 * m165a_autobaud_uart0_lednop_pr_ee_ce m165p_autobaud_uart0_lednop_pr_ee_ce
 * m165pa_autobaud_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_pr_ee_ce[] = {
  0x12dddddddd4477d6, 0xeeeeeeeaaf1a0583, 0x6e99ae36968cf51d, 0xbb080b2ab4dd85ea, 0x75eb4e2295f6848c,
  0x827c602416caef27, 0x4ac7ffcf02cf8689, 0xc05d221d022054f8, 0xaa3857eaa4d7ce1c, 0xb3bfea8dfc86d1bd,
  0x293f5ff3c64a9def, 0x6b2b1ef984e771b8, 0xc1ad7f51e57dd4a7, 0xa05315edff51f06c, 0x30b2c4522cd3ad08,
  0x3abb71ea3a909afa, 0x1d79d3768c919347, 0x282791bdab1aaf1b, 0x470decb65cc5c242, 0x8598fb33ca8d8226,
  0x20270b37e06256bd, 0xf36450603bd6bcf0, 0x4dea53929d002de6, 0x5d38c6f19d103be5, 0x6e70c76f62aa8b4d,
  0x8b93571b09732f9b, 0x5663c81f943458f3, 0x32c970cf4c2b93f7, 0x332c3a4a5b2c944e, 0xec7f880a792bf734,
  0x0000000000000566,
};

/*
 * m169a_autobaud_uart0_lednop_pr_ee_ce_u4 m169p_autobaud_uart0_lednop_pr_ee_ce_u4
 * m169pa_autobaud_uart0_lednop_pr_ee_ce_u4 m165_autobaud_uart0_lednop_pr_ee_ce_u4
 * m165a_autobaud_uart0_lednop_pr_ee_ce_u4 m165p_autobaud_uart0_lednop_pr_ee_ce_u4
 * m165pa_autobaud_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_pr_ee_ce_u4[] = {
  0x2ddddddda2436d3a, 0x7777775573c1c9d1, 0x6ed1989134ba52b7, 0xec4f91c3f006ead0, 0x776e76cd8f6c98cc,
  0x9827c602416caef2, 0x09620ffb15d9f43e, 0x980ba443a0440a9f, 0xb5470afd549af9c3, 0x6ae2faa390f0da37,
  0xfb892c79e50b8389, 0xfea3e12fc4361222, 0x7ccf1771b8089300, 0x51e57dd4a76b736f, 0xedff51f06cc1ad7f,
  0x522cd3ad08a05315, 0xea3a909afa30b2c4, 0x768c9193473abb71, 0xbdab1aaf1b1d79d3, 0xb65cc5c242282791,
  0x33ca8d8226470dec, 0x37e06256bd8598fb, 0x603bd6bcf020270b, 0x929d002de6f36450, 0xf19d103be54dea53,
  0x6f62aa8b4d5d38c6, 0x9b09732f9b6e70c7, 0xfe0eee3458df0dc7, 0xbca1854e7ea75666, 0x0fe32fcc4ffef0f7,
  0xe07efd86687993fc, 0x4b867a617c68f45f, 0x961d252d9f027196, 0xa56e8b3c95fb9a19, 0x0000000000082265,
};

/*
 * m169a_autobaud_uart0_lednop_hw    m169p_autobaud_uart0_lednop_hw    m169pa_autobaud_uart0_lednop_hw
 * m165_autobaud_uart0_lednop_hw     m165a_autobaud_uart0_lednop_hw    m165p_autobaud_uart0_lednop_hw
 * m165pa_autobaud_uart0_lednop_hw
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_hw[] = {
  0x44b777777759bb37, 0xfdddddddd55f85c6, 0x520da3afad3c4ef8, 0xd36200db69177777, 0x20b657793bb63d90,
  0xc38f3f224c13e301, 0x1d022054f84b4aff, 0xeaa4d7ce1cc05d22, 0xb24386d1bdaa3857, 0x3f83349ea393c77c,
  0xc05bdd30f9d2471d, 0xc5cecd7c8e414e62, 0x8560fbdc72c608eb, 0x20270b37e06256bd, 0xf36450603bd6bcf0,
  0x4dea53929d002de6, 0x5d38c6f19d103be5, 0xb739156f62aa8b4d, 0xf9fd86ed84b997cd, 0x271964b867a615c9,
  0x9a19961d252d964a, 0xb65afafb053c95fb, 0x0000000000000001,
};

/*
 * m169a_autobaud_uart0_lednop_ee_hw m169p_autobaud_uart0_lednop_ee_hw m169pa_autobaud_uart0_lednop_ee_hw
 * m165_autobaud_uart0_lednop_ee_hw  m165a_autobaud_uart0_lednop_ee_hw m165p_autobaud_uart0_lednop_ee_hw
 * m165pa_autobaud_uart0_lednop_ee_hw
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_ee_hw[] = {
  0x96eeeeeed121af43, 0xbbbbbbaab8bfd058, 0x1b634cfda9bdfa7b, 0x6a2b210646d6ef1f, 0xf2775a77dadd94d1,
  0xd69827c602416cae, 0xa9f0969bffa14cf8, 0x9c3980ba443a0440, 0xa37b5470afd549af, 0x95995355ad1ce30d,
  0x7ea3e0d9834c7d47, 0x59a75a1143be2b0f, 0x4d2135f4616588a4, 0x93473ab4b9eab8d6, 0x56ba1d79d3768c91,
  0xe1211413c8ded58d, 0x823f5b86f65b2e62, 0x56bd8010fb33ca8d, 0xbcf020270b37e062, 0x2de6f36450603bd6,
  0x3be54dea53929d00, 0x8b4d5d38c6f19d10, 0x97cdb739156f62aa, 0x9fa82ec6e3cd84b9, 0x13ffbc3def286153,
  0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61, 0x67c09c6592e19e98, 0x257ee6866587494b, 0x00000b13c02b514f,
};

/*
 * m169a_autobaud_uart0_lednop_ce_hw m169p_autobaud_uart0_lednop_ce_hw m169pa_autobaud_uart0_lednop_ce_hw
 * m165_autobaud_uart0_lednop_ce_hw  m165a_autobaud_uart0_lednop_ce_hw m165p_autobaud_uart0_lednop_ce_hw
 * m165pa_autobaud_uart0_lednop_ce_hw
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_ce_hw[] = {
  0x2ddddddda2431768, 0xeeeeeeaaf49f8671, 0xc47179b163f6c8ee, 0x67ae34d4deeeed08, 0x657793ba6e8ed68f,
  0x67edd4c13e30120b, 0x22054f84b027fd0a, 0x4d7ce1cc05d221d0, 0x486d1bdaa3857eaa, 0xf285c1ca95717d72,
  0xe21b09117dc4963c, 0x8dcff81a3f51f097, 0x24f72c67eb2678bb, 0x2c71d3f83d67a8fd, 0x7a3486731602a622,
  0x1ffb33c75e8f9d96, 0x681e5adc82cd22a0, 0x70b37e06256bd905, 0x450603bd6bcf0202, 0xa53929d002de6f36,
  0x8c6f19d103be54de, 0x0c76f62aa8b4d5d3, 0xdc79b09732f9b6e7, 0xbde50c2a73f505d8, 0xe07f197e627ff787,
  0xff03f7ec3343cc9f, 0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0xdc21fa29e4afdcd0, 0x0000000000006e8d,
};

/*
 * m169_autobaud_uart0_lednop_ee_ce_u4_hw m169a_autobaud_uart0_lednop_ee_ce_hw
 * m169a_autobaud_uart0_lednop_ee_ce_u4_hw m169p_autobaud_uart0_lednop_ee_ce_hw
 * m169p_autobaud_uart0_lednop_ee_ce_u4_hw m169pa_autobaud_uart0_lednop_ee_ce_hw
 * m169pa_autobaud_uart0_lednop_ee_ce_u4_hw m165_autobaud_uart0_lednop_ee_ce_hw
 * m165_autobaud_uart0_lednop_ee_ce_u4_hw m165a_autobaud_uart0_lednop_ee_ce_hw
 * m165a_autobaud_uart0_lednop_ee_ce_u4_hw m165p_autobaud_uart0_lednop_ee_ce_hw
 * m165p_autobaud_uart0_lednop_ee_ce_u4_hw m165pa_autobaud_uart0_lednop_ee_ce_hw
 * m165pa_autobaud_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_autobaud_uart0_lednop_ee_ce_hw[] = {
  0x2ddddddda243173e, 0x7777775573c1c9d1, 0x6ed1989134ba52b7, 0xec4f91c3f006ead0, 0xc9ddcfb403a89ecc,
  0xfa609f180905b2bb, 0x4f84b107fd0a67d0, 0xe1cc05d221d02205, 0x1bdaa3857eaa4d7c, 0xc4b5717d51c8786d,
  0x117dc4963cf285c1, 0x9cbf51f097e21b09, 0x6def99e2ee372929, 0xafea3cafba94ed6e, 0x62bdbfea3e0d9835,
  0x588a459a75a1140a, 0x6e3d4752135f4616, 0x3a6ed1923268e757, 0xf237b56355e363af, 0xbd96cb98b8484504,
  0x1f667951b044c8e1, 0xe166fc0c4ad7b0b3, 0x8a0c077ad79e0404, 0x4a7253a005bcde6c, 0x18de33a2077ca9bd,
  0x18edec555169aba7, 0xb8f3612e65f36dce, 0x7bca1854e7ea0bb1, 0xc0fe32fcc4ffef0f, 0xfe07efd86687993f,
  0x64b867a617c68f45, 0x9961d252d9f02719, 0x4cb4b453c95fb9a1, 0x000000000000012a,
};

/*
 * m169_autobaud_uart0_dual_pr       m169_autobaud_uart0_dual_pr_u4    m169a_autobaud_uart0_dual
 * m169a_autobaud_uart0_dual_pr      m169a_autobaud_uart0_dual_pr_u4   m169p_autobaud_uart0_dual
 * m169p_autobaud_uart0_dual_pr      m169p_autobaud_uart0_dual_pr_u4   m169pa_autobaud_uart0_dual
 * m169pa_autobaud_uart0_dual_pr     m169pa_autobaud_uart0_dual_pr_u4  m165_autobaud_uart0_dual
 * m165_autobaud_uart0_dual_pr       m165_autobaud_uart0_dual_pr_u4    m165a_autobaud_uart0_dual
 * m165a_autobaud_uart0_dual_pr      m165a_autobaud_uart0_dual_pr_u4   m165p_autobaud_uart0_dual
 * m165p_autobaud_uart0_dual_pr      m165p_autobaud_uart0_dual_pr_u4   m165pa_autobaud_uart0_dual
 * m165pa_autobaud_uart0_dual_pr     m165pa_autobaud_uart0_dual_pr_u4
 */
static const uint64_t ur_m169_autobaud_uart0_dual[] = {
  0x5bbbbbbb4486dd9e, 0xeeeeeedf8d4fed1b, 0xa71d6414ccf59f6e, 0xd3924c765bbbab8f, 0x20770fcabdd17ae2,
  0x827c602416caef24, 0x75b40c8949485249, 0x2e20614306d23037, 0xd6ebf32addcee9f1, 0x51d82ec3021c2574,
  0x14239227f0670e6f, 0x0f8510c4aff3f7c1, 0xabbbddf371fe0037, 0xba2a10cb434a4432, 0x5b774bff4073c269,
  0xfdcd7982c3795e42, 0x8874088153e127f3, 0x5faa935f38730174, 0xf9626a1b46f6a8e1, 0x74fe0c43fa8f914e,
  0x1602a83cd38bdf1c, 0x5e00ced6b23afe73, 0x21d21aa01ffb3047, 0xb8a92a93a07967b6, 0x0312b5ec9fc55f3b,
  0xdeb5e781013859bf, 0xe8016f379b228301, 0xe881df2a6f529c94, 0x15545a6ae9c6378c, 0x25ccbe6db9c8ab7b,
  0x3bb8d1637c371e6c, 0x861539fa9d599bf8, 0x8cbf313ffbc3def2, 0xfbf619a1e64ff03f, 0x19e985f1a3d17f81,
  0x7494b67c09c6592e, 0xba2cf257ee686658, 0x000000002e0a838d,
};

/*
 * m169a_autobaud_uart0_dual_pr_ee   m169p_autobaud_uart0_dual_pr_ee   m169pa_autobaud_uart0_dual_pr_ee
 * m165_autobaud_uart0_dual_pr_ee    m165a_autobaud_uart0_dual_pr_ee   m165p_autobaud_uart0_dual_pr_ee
 * m165pa_autobaud_uart0_dual_pr_ee
 */
static const uint64_t ur_m169_autobaud_uart0_dual_pr_ee[] = {
  0xadddddddd41432db, 0x7777776fc3f75c4d, 0x5f05947d3ef5c2f7, 0xcd8eba9be9dbb619, 0x1c115658219d210e,
  0xc0482d95de49ba77, 0x32252520551304f8, 0x850c1b48c0ddd6d0, 0xccab773ba7c4b881, 0x6c3101c1aee643ef,
  0x227f061a26f51dfe, 0x0c4aff3f7c114239, 0x7cdc04480370f851, 0x65a181110caaeef7, 0xff4073c262eb1508,
  0x82c3795e425b7ff9, 0x02a7c244ebfdcd79, 0xbe70e602e910e811, 0x368ded51c2bf5526, 0x3cad7dcd56b47224,
  0x4af51f06cc1829ea, 0x22cd3ad08a1df15d, 0x2e6909afa30b2c45, 0x3dece75697329715, 0xaad743af512ed10a,
  0x2e1211408a8f9eb1, 0xb047eb70decbe966, 0x7715250084feb151, 0xe06256bd93f8abe7, 0x3bd6bcf020270b37,
  0x9d002de6f3645060, 0x9d103be54dea5392, 0x62aa8b4d5d38c6f1, 0x84b997cdb739156f, 0x3bb8d165abc6e3cd,
  0x861539fa9d599bf8, 0x07cd0f327f8138d2, 0x8cb25c33d30ae4fc, 0xd0ccb0e9296cf813, 0xa42b537459e4afdc,
  0x0000000000000052,
};

/*
 * m169a_autobaud_uart0_dual_pr_ee_u4 m169p_autobaud_uart0_dual_pr_ee_u4
 * m169pa_autobaud_uart0_dual_pr_ee_u4 m165_autobaud_uart0_dual_pr_ee_u4
 * m165a_autobaud_uart0_dual_pr_ee_u4 m165p_autobaud_uart0_dual_pr_ee_u4
 * m165pa_autobaud_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m169_autobaud_uart0_dual_pr_ee_u4[] = {
  0x36b7777776890c86, 0xbbbbbbbb7e1fbdfb, 0xa520adb178d5b5df, 0x0b201a2f537d3b74, 0x25dddd8dd9683cc5,
  0x13e30120b6577936, 0xb68191292909c7cc, 0xc40c2860da4606ee, 0x107e655bb9dd3e25, 0x3868d869a383fc9b,
  0x08e489fc1d8fcdea, 0xe144312bfcfdf045, 0xddeef9b949400dc3, 0x2a10cb40a5a21955, 0xf76bfe80e784df3a,
  0x35e60b0de579096d, 0x4088153e12eafff7, 0xa935f38730174887, 0xd2a1b46f6a8e15fa, 0x4f51e571ee6ab5a3,
  0xc57227a8f83660fe, 0xb1148b34eb422877, 0x5c20b9a426be8c2c, 0x08a8fa439d5a5f4a, 0xbb1aad743af6b13b,
  0xf18b8484515fd1d4, 0x2ae07dfd6e1bd971, 0xb5ec9fc55f3bb8a9, 0xe781013859bf0312, 0x5bcde5ba8301deb5,
  0xf7ca9bd4a7253a00, 0x74408ea2810b4e02, 0x84b997cdb4e31bc6, 0x07771a2c6f86e3cd, 0x50c2a73f53ab337f,
  0xf197e627ff787bde, 0x3f7ec3343cc9fe07, 0xc33d30be347a2ff0, 0x0e9296cf8138cb25, 0x37459e4afdcd0ccb,
  0x00000000014a9205,
};

/*
 * m169a_autobaud_uart0_dual_pr_ce   m169p_autobaud_uart0_dual_pr_ce   m169pa_autobaud_uart0_dual_pr_ce
 * m165_autobaud_uart0_dual_pr_ce    m165a_autobaud_uart0_dual_pr_ce   m165p_autobaud_uart0_dual_pr_ce
 * m165pa_autobaud_uart0_dual_pr_ce
 */
static const uint64_t ur_m169_autobaud_uart0_dual_pr_ce[] = {
  0x5bbbbbba1eb432db, 0x7777776fc361009b, 0xb15cea2f2d5b9337, 0xaeec2c9f7bbba539, 0x322ee3822ac69e33,
  0x609f180905b2bbc9, 0x75b40c894948f5aa, 0x2e20614306d23037, 0xad6ff32addcee9f1, 0x1f76b609b6709db9,
  0x847244fe0cc7e6f5, 0xf0a21895fe7ef822, 0xeef77cdc672006e1, 0x150865a05d510caa, 0x70b5ff4073c264ad,
  0xcd7982c3795e425b, 0xe81102a7c25b3bfd, 0x5526be70e602e910, 0xa804368ded51c2bf, 0x1e7942e0e3a5b8be,
  0x4bf10d8488bee24b, 0xbb8dcc40d77fa8f8, 0x1bf3dcb19f52e678, 0x7c8e3a7f0752fd47, 0xd6475fce62c05050,
  0x03ff6678ebc019da, 0x9d03cb5b843a4354, 0x64fe2af9ddc54954, 0x0809c2cdf81895af, 0xbcd914180ef5af3c,
  0x537a94e4a7400b79, 0x574e31bc67440ef9, 0xdb9c31dbd8aaa2d3, 0xa7c371e6c25ccbe6, 0x4eaccdfc1ddc68b3,
  0xcbf313f9430a9cfd, 0xffe09a1e64ff1738, 0x92e19e985727e39e, 0x6587494b67c09c65, 0xbb1ba2cf257ee686,
  0x0000000000015af6,
};

/*
 * m169a_autobaud_uart0_dual_pr_ce_u4 m169p_autobaud_uart0_dual_pr_ce_u4
 * m169pa_autobaud_uart0_dual_pr_ce_u4 m165_autobaud_uart0_dual_pr_ce_u4
 * m165a_autobaud_uart0_dual_pr_ce_u4 m165p_autobaud_uart0_dual_pr_ce_u4
 * m165pa_autobaud_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m169_autobaud_uart0_dual_pr_ce_u4[] = {
  0xdaddddddda2432db, 0x77777776fc361d6c, 0x765bf762fb2b535f, 0x4a3f738b56eeed89, 0xb82ee3822ac07c67,
  0x609f180905b2bbc9, 0xbada0644a4a42e0a, 0x971030a18369181b, 0x60d1f9956ee774f8, 0xa3f4fec2c7ce1ff2,
  0x508e489fc1f57cde, 0x3e144312bfcfdf04, 0x5ddeef9b895000dc, 0xe2a10cb412b22195, 0x6e707fe80e784cbe,
  0xb9af30586f2bc84b, 0x1d022054f84b2b7f, 0xeaa4d7ce1cc05d22, 0xd57c86d1bdaa3857, 0x63cf285c1c28b717,
  0x097e21b09117dc49, 0x1771b9881aeff51f, 0xf70e7b9633c38ccf, 0xef71c74fe0c38fa8, 0x13c8ded1cc580b10,
  0xfee39633c75e45bb, 0xfc55f3bb8a928e84, 0x13859bf0312b5ec9, 0xb228301deb5e7810, 0xf529c94e8016f379,
  0x9c6378ce881df2a6, 0x3863b7b15545a6ae, 0x86e3cd84b997cdb7, 0xab337f07771a2c6f, 0x787bde50c2a73f53,
  0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0x5af659b7459e4afd,
  0x0000000000000001,
};

/*
 * m169a_autobaud_uart0_dual_pr_ee_ce m169p_autobaud_uart0_dual_pr_ee_ce
 * m169pa_autobaud_uart0_dual_pr_ee_ce m165_autobaud_uart0_dual_pr_ee_ce
 * m165a_autobaud_uart0_dual_pr_ee_ce m165p_autobaud_uart0_dual_pr_ee_ce
 * m165pa_autobaud_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m169_autobaud_uart0_dual_pr_ee_ce[] = {
  0x1b5bbbbbbba86f97, 0xeeeeeeeedf98ec7e, 0x27dda083e44fdebd, 0x7d7aefa16ccf7539, 0xcf046752c8a75609,
  0x30120b657792af9d, 0x32252520e49cc13e, 0x850c1b48c0ddd6d0, 0xccab773ba7c4b881, 0xd833e1c3ace6643f,
  0x13f83fd79bd47986, 0x6257f9fbe08a11c9, 0xe6e79c801b87c288, 0x2d04b488655777bb, 0xfa039e134728a843,
  0x161bcaf212db8a4f, 0x153e12d35fee6bcc, 0xf387301748874088, 0xb46f6a8e15faa935, 0x0706b1dff546e4e1,
  0xe372f0f96bf3ca17, 0xc94ed6564dd309ce, 0xf06cc1af9ea3cadf, 0xad08a05315c06f51, 0x9afa30b2c4522cd3,
  0xef673abb71943a90, 0xaf1b1d7a89768851, 0xe1211408a8f9eb1a, 0x8226470decbe9662, 0xb8a9296627f58a8d,
  0x0312b5ec9fc55f3b, 0xdeb5e781013859bf, 0xe8016f379b228301, 0xe881df2a6f529c94, 0x15545a6ae9c6378c,
  0x4b997cdb73863b7b, 0xeee3458f386e3cd8, 0xf4c2b93f75666fe0, 0x4a5b3e04e32c970c, 0x16792bf734332c3a,
  0x00000001888738dd,
};

/*
 * m169a_autobaud_uart0_dual_pr_ee_ce_u4 m169p_autobaud_uart0_dual_pr_ee_ce_u4
 * m169pa_autobaud_uart0_dual_pr_ee_ce_u4 m165_autobaud_uart0_dual_pr_ee_ce_u4
 * m165a_autobaud_uart0_dual_pr_ee_ce_u4 m165p_autobaud_uart0_dual_pr_ee_ce_u4
 * m165pa_autobaud_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_autobaud_uart0_dual_pr_ee_ce_u4[] = {
  0xbbbbbbb456ddb69f, 0xbbbbb7e15babd9b5, 0xf60987c705af05bb, 0xfa6d8b74abeabfea, 0xce8438dfc3793c89,
  0x792cf9dd202f9e5c, 0xf5cc13e30120b657, 0x1bbada0644a4a458, 0xf8971030a1836918, 0x4dcdffccb4b7e774,
  0x51d9cb61d1f38292, 0x2847244fe0d90e6f, 0x1f0a21895fe7ef82, 0xbbbddf372e4a006e, 0x8a8432d04db4432a,
  0xfd67ff4073c26b1f, 0xfc330586f2bc84b6, 0x81102a7c258ddff8, 0x526be70e602e910e, 0x4f4368ded51c2bf5,
  0x942f3b19bb8bea8d, 0x10d8488bee24b1e7, 0x9aa0f20ffa8f84bf, 0x76b737374cf1771b, 0x660d7cf51e56fe4a,
  0x450298ae037a8f83, 0xd185962291669d68, 0x39d5db8ca1d484d7, 0xd8ebd44bb4428f7b, 0x08a04547cf58d578,
  0x32386f65f4b31709, 0x494b313fac546c11, 0x95af64fe2af9ddc5, 0xaf3c0809c2cdf818, 0x0b79bcd914180ef5,
  0x0ef9537a94e4a740, 0xa2d3574e31bc6744, 0xcbe6db9c31dbd8aa, 0x1be2e4d5c1e6c25c, 0x9d599bf83f6ec68b,
  0xfbc3def2861539fa, 0xe64ff03f8cbf313f, 0xa3d17f81fbf619a1, 0x09c6592e19e985f1, 0xee6866587494b67c,
  0xd5b9705f2374f257, 0x000000000000000f,
};

/*
 * m169a_autobaud_uart0_dual_hw      m169p_autobaud_uart0_dual_hw      m169pa_autobaud_uart0_dual_hw
 * m165_autobaud_uart0_dual_hw       m165a_autobaud_uart0_dual_hw      m165p_autobaud_uart0_dual_hw
 * m165pa_autobaud_uart0_dual_hw
 */
static const uint64_t ur_m169_autobaud_uart0_dual_hw[] = {
  0xb7777776890c5aa4, 0xddddddbf1a9fda36, 0x4e3ac82999eb3edd, 0x272498ecb777571f, 0x24207761f4da6d82,
  0x49827c602416caef, 0x3775b40c89494852, 0xf12e20614306d230, 0x74d6ebf32addcee9, 0x6f51d82ec3021c25,
  0xc114239227f0670e, 0x370f8510c4aff3f7, 0x32abbbddf371fe00, 0x69ba2a10cb434a44, 0x425b774bff4073c2,
  0xe7ffa91982c3795e, 0xe910e81102a7c24f, 0xc2bf5526be70e602, 0x9df2c4d4368ded51, 0x38e9fc1887f51f22,
  0xe62c055079a717be, 0x8ebc019dad6475fc, 0x6c43a435403ff660, 0x777152552740f2cf, 0x7e06256bd93f8abe,
  0x03bd6bcf020270b3, 0x29d002de6f364506, 0x19d103be54dea539, 0xf62aa8b4d5d38c6f, 0xd84b997cdb739156,
  0x861539fa82ec6e3c, 0x8cbf313ffbc3def2, 0xfbf619a1e64ff03f, 0x19e985f1a3d17f81, 0x7494b67c09c6592e,
  0x1d14f257ee686658, 0x0000000003d1b907,
};

/*
 * m169a_autobaud_uart0_dual_ee_hw   m169p_autobaud_uart0_dual_ee_hw   m169pa_autobaud_uart0_dual_ee_hw
 * m165_autobaud_uart0_dual_ee_hw    m165a_autobaud_uart0_dual_ee_hw   m165p_autobaud_uart0_dual_ee_hw
 * m165pa_autobaud_uart0_dual_ee_hw
 */
static const uint64_t ur_m169_autobaud_uart0_dual_ee_hw[] = {
  0x36b7777776890c86, 0xddddddddbf0fdd71, 0x657c1651f4fbd70b, 0x3b363aea6fa76ed8, 0xd3bbbb1bb3798a84,
  0x27c602416caef24d, 0xb68191292902a898, 0xc40c2860da4606ee, 0x1f7e655bb9dd3e25, 0xeff361880e0d7732,
  0x11c913f830d137a8, 0xc2886257f9fbe08a, 0x77bbe6e022401b87, 0xa8432d0c08886557, 0xffcffa039e131758,
  0x48cc161bcaf212db, 0x81102a7c244ebffd, 0x526be70e602e910e, 0x224368ded51c2bf5, 0x9ea3cad7dcd56b47,
  0x15d4af51f06cc182, 0xc4522cd3ad08a1df, 0x7152e6909afa30b2, 0x10a3dece75697329, 0xeb1aad743af512ed,
  0x9662e1211408a8f9, 0x151b047eb70decbe, 0xbe77715250084feb, 0xb37e06256bd93f8a, 0x0603bd6bcf020270,
  0x3929d002de6f3645, 0x6f19d103be54dea5, 0x56f62aa8b4d5d38c, 0x3cd84b997cdb7391, 0xf2861539fa82ec6e,
  0x3f8cbf313ffbc3de, 0x81fbf619a1e64ff0, 0x2e19e985f1a3d17f, 0x587494b67c09c659, 0x2b5514f257ee6866,
  0x000000000000b072,
};

/*
 * m169a_autobaud_uart0_dual_ce_hw   m169p_autobaud_uart0_dual_ce_hw   m169pa_autobaud_uart0_dual_ce_hw
 * m165_autobaud_uart0_dual_ce_hw    m165a_autobaud_uart0_dual_ce_hw   m165p_autobaud_uart0_dual_ce_hw
 * m165pa_autobaud_uart0_dual_ce_hw
 */
static const uint64_t ur_m169_autobaud_uart0_dual_ce_hw[] = {
  0xaddddddda243359b, 0xbbbbbbb7e1b0804d, 0xd8ae751796adc99b, 0xaf76164fbdddd29c, 0x24c8bb8786614d6b,
  0xa9827c602416caef, 0xddd6d032252523d6, 0xc4b881850c1b48c0, 0xe6b5bfccab773ba7, 0xd47ddad826d9c276,
  0x8a11c913f8331f9b, 0x87c2886257f9fbe0, 0xabbbddf3719c801b, 0xb454219681754432, 0x6dc2d7fd01cf0992,
  0xfea4660b0de57909, 0x874088153e12d9df, 0xfaa935f387301748, 0xf54021b46f6a8e15, 0x58f3ca17071d2dc5,
  0xc25f886c2445f712, 0xe2ee371fe620fd47, 0x1c6fcf72c67d4b99, 0x41f238e9fc1d4bf5, 0x6b591d7f398b0141,
  0x500ffd99e3af0067, 0x52740f2d6e10e90d, 0xbd93f8abe7771525, 0xf020270b37e06256, 0xe6f36450603bd6bc,
  0xe54dea53929d002d, 0x4d5d38c6f19d103b, 0x9b6e70c76f62aa8b, 0x505d8dc79b09732f, 0xff787bde50c2a73f,
  0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf, 0x0017a372eca29e4a,
};

/*
 * m169a_autobaud_uart0_dual_ee_ce_hw m169p_autobaud_uart0_dual_ee_ce_hw
 * m169pa_autobaud_uart0_dual_ee_ce_hw m165_autobaud_uart0_dual_ee_ce_hw
 * m165a_autobaud_uart0_dual_ee_ce_hw m165p_autobaud_uart0_dual_ee_ce_hw
 * m165pa_autobaud_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m169_autobaud_uart0_dual_ee_ce_hw[] = {
  0xdadddddddd437089, 0x77777776fcc763f0, 0x3eed041f227ef5ef, 0xebd77d0b667ba9c9, 0x75e4f595b5b4b04b,
  0x8c0482d95de4abe7, 0x0c8949483927304f, 0x614306d2303775b4, 0xf32addcee9f12e20, 0xb60cf870eb39990f,
  0x44fe0ff5e6f51e61, 0x1895fe7ef8228472, 0xf9b9e72006e1f0a2, 0xcb412d221955ddee, 0xfe80e784d1ca2a10,
  0x0586f2bc84b6e293, 0x0a9f0969afff5233, 0xf9c3980ba443a044, 0xda37b5470afd549a, 0x838358effaa37270,
  0xdc6e400149f9e50b, 0xf929dacac9ba6139, 0x3e0d9835f3d4795b, 0x75a1140a62b80dea, 0x135f4616588a459a,
  0x3dece7576e328752, 0x55e363af512ed10a, 0x5c242281151f3d63, 0xb044c8e1bd97d2cc, 0x7715252cc4feb151,
  0xe06256bd93f8abe7, 0x3bd6bcf020270b37, 0x9d002de6f3645060, 0x9d103be54dea5392, 0x62aa8b4d5d38c6f1,
  0x09732f9b6e70c76f, 0x4c2b93f3fb0dc79b, 0xa5b3e04e32c970cf, 0xa792bf734332c3a4, 0x00000004d7e1e728,
};

/*
 * m169a_autobaud_uart0_dual_ee_ce_u4_hw m169p_autobaud_uart0_dual_ee_ce_u4_hw
 * m169pa_autobaud_uart0_dual_ee_ce_u4_hw m165_autobaud_uart0_dual_ee_ce_u4_hw
 * m165a_autobaud_uart0_dual_ee_ce_u4_hw m165p_autobaud_uart0_dual_ee_ce_u4_hw
 * m165pa_autobaud_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_autobaud_uart0_dual_ee_ce_u4_hw[] = {
  0x6eeeeeed1468b202, 0xeeeeedf856eaf66d, 0xfabd8261f69c16ee, 0x227e9b62dd2afaaf, 0xe918ef0727f0de4f,
  0x0b657792cf9ddfd6, 0x4a458f5cc13e3012, 0x369181bbada0644a, 0x12774f8971030a18, 0xe705249b9bff9976,
  0xb21cdea3b396c3a3, 0xcfdf04508e489fc1, 0x9400dc3e144312bf, 0x688655777bbe6e5c, 0x84d63f150865a09b,
  0x79096dfacffe80e7, 0x377fb3d0e60b0de5, 0xba443a0440a9f096, 0x70afd549af9c3980, 0x2faa353d0da37b54,
  0x2c79e37c307066ee, 0xe12fc4361222fb89, 0x8bb8dc524e6ffea3, 0xb7f253b5b9b9ba67, 0xd47c1b306be7a8f2,
  0x34eb422814c5701b, 0xa426be8c2cb1148b, 0x147bd9ceaedc650e, 0xc6abc6c75ea25da2, 0x98b84845022a3e7a,
  0xa3608991c37b2fa5, 0xceee2a4a5989fd62, 0x6fc0c4ad7b27f157, 0xc077ad79e0404e16, 0x253a005bcde6c8a0,
  0xe33a2077ca9bd4a7, 0xdec555169aba718d, 0x3612e65f36dce18e, 0xa1854e7ea0bb1b8f, 0xe32fcc4ffef0f7bc,
  0x7efd86687993fc0f, 0x867a617c68f45fe0, 0x1d252d9f0271964b, 0x617d3c95fb9a1996, 0x000000002134f9e8,
};

/*
 * m169_u1x8_uart0_noled_pr          m169a_u1x8_uart0_noled            m169a_u1x8_uart0_noled_pr
 * m169p_u1x8_uart0_noled            m169p_u1x8_uart0_noled_pr         m169pa_u1x8_uart0_noled
 * m169pa_u1x8_uart0_noled_pr        m165_u1x8_uart0_noled             m165_u1x8_uart0_noled_pr
 * m165a_u1x8_uart0_noled            m165a_u1x8_uart0_noled_pr         m165p_u1x8_uart0_noled
 * m165p_u1x8_uart0_noled_pr         m165pa_u1x8_uart0_noled           m165pa_u1x8_uart0_noled_pr
 */
static const uint64_t ur_m169_u1x8_uart0_noled[] = {
  0x5bbbbbaeed66ef3a, 0xeeeeeeaaec385ee2, 0x656cfddf87f7d2ee, 0x38fd697e6eee9101, 0x5de4ee82f4133164,
  0xf829304f8c0482d9, 0x016f605f27fbf43c, 0x077cb087b9cdfda2, 0x471d3f83417ea3f4, 0x0e62c0596533df6b,
  0x823af47ced5fd1eb, 0x3db1f6679500ffd9, 0xc0c4ad7b071f03cb, 0xa0c077ad79ce166f, 0xbca6c670b79bc03e,
  0x38c6f19d102baa9c, 0x922adec555169617, 0xce1bb612e65f36c4, 0x75663c81a3f8d163, 0xe32c970cf4c2b93f,
  0x4332c3a4a5b2c944, 0x400e5ae3e792bf73, 0x000000000000003e,
};

/*
 * m169a_u1x8_uart0_noled_pr_u4      m169p_u1x8_uart0_noled_pr_u4      m169pa_u1x8_uart0_noled_pr_u4
 * m165_u1x8_uart0_noled_pr_u4       m165a_u1x8_uart0_noled_pr_u4      m165p_u1x8_uart0_noled_pr_u4
 * m165pa_u1x8_uart0_noled_pr_u4
 */
static const uint64_t ur_m169_u1x8_uart0_noled_pr_u4[] = {
  0xdddddd7751222743, 0x7777755761c2f712, 0x5b3f77e1f19a4cf7, 0x3f5a5f9bbba44059, 0xc9dda8bc96c7ac1e,
  0x52609f180905b2bb, 0x6f605f27f9e059f0, 0x7cb087b9cdfda201, 0x1d3f83417ea3f407, 0x62c0596533df6b47,
  0x3af47ced5fd1eb0e, 0xb1f6679500ffd982, 0xc4ad7b071f03cb3d, 0xc077ad79ce166fc0, 0xa6c670b79bc03ea0,
  0xc6f19d102baa9cbc, 0x2adec55516961738, 0x0f3612e65f36c492, 0x1f943458df1726ae, 0xa1854e7ea75663c8,
  0xe32fcc4ffef0f7bc, 0x7efd86687993fc0f, 0x867a617c68f45fe0, 0x1d252d9f0271964b, 0xc4053c95fb9a1996,
  0x0000000003e4f2d2,
};

/*
 * m169_u1x8_uart0_noled_pr_ee_u4    m169a_u1x8_uart0_noled_pr_ee      m169a_u1x8_uart0_noled_pr_ee_u4
 * m169p_u1x8_uart0_noled_pr_ee      m169p_u1x8_uart0_noled_pr_ee_u4   m169pa_u1x8_uart0_noled_pr_ee
 * m169pa_u1x8_uart0_noled_pr_ee_u4  m165_u1x8_uart0_noled_pr_ee       m165_u1x8_uart0_noled_pr_ee_u4
 * m165a_u1x8_uart0_noled_pr_ee      m165a_u1x8_uart0_noled_pr_ee_u4   m165p_u1x8_uart0_noled_pr_ee
 * m165p_u1x8_uart0_noled_pr_ee_u4   m165pa_u1x8_uart0_noled_pr_ee     m165pa_u1x8_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m169_u1x8_uart0_noled_pr_ee[] = {
  0xbbbbbaeea24458e2, 0xeeeeeaaeb9041225, 0x853d31b70cf5a5ee, 0x31382f85eeeeff17, 0x4e1ec694eb033363,
  0xf8c0482d95de4ee9, 0xd2ff9e059f297304, 0x3739bfb4402dec09, 0xd4795c89355ad1ce, 0x5f75ea3e0d9834c7,
  0x4522cd3ad08a1df1, 0xc6b26909afa30b2c, 0xed1e0b39d5a5e715, 0xd8d56ba1d79d376d, 0xe62e1211473c8c38,
  0xa8d823f5b86f65b2, 0x0312b5ec00a89534, 0x8301deb5e73859bf, 0xf29b19c2de6f00fa, 0xe31bc67440aeaa72,
  0x48ab7b15545a585c, 0xb83cd84b997cdb12, 0x207e50d1637c5c9a, 0xf2861539fa9d598f, 0x3f8cbf313ffbc3de,
  0x81fbf619a1e64ff0, 0x2e19e985f1a3d17f, 0x587494b67c09c659, 0x391014f257ee6866, 0x000000000009d715,
};

/*
 * m169_u1x8_uart0_noled_pr_ce_u4    m169a_u1x8_uart0_noled_pr_ce      m169a_u1x8_uart0_noled_pr_ce_u4
 * m169p_u1x8_uart0_noled_pr_ce      m169p_u1x8_uart0_noled_pr_ce_u4   m169pa_u1x8_uart0_noled_pr_ce
 * m169pa_u1x8_uart0_noled_pr_ce_u4  m165_u1x8_uart0_noled_pr_ce       m165_u1x8_uart0_noled_pr_ce_u4
 * m165a_u1x8_uart0_noled_pr_ce      m165a_u1x8_uart0_noled_pr_ce_u4   m165p_u1x8_uart0_noled_pr_ce
 * m165p_u1x8_uart0_noled_pr_ce_u4   m165pa_u1x8_uart0_noled_pr_ce     m165pa_u1x8_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m169_u1x8_uart0_noled_pr_ce[] = {
  0x777775dd4488ba31, 0xddddd55f85ec9c4b, 0x5385ec44ade833dd, 0x1850dbdddd36922b, 0x2776c4d86080052d,
  0xe9827c602416caef, 0xf604517fcf02cffc, 0x7d724b9cdfda2016, 0x258f3c64a9dbf971, 0x7c25f886c2445f71,
  0x9e2ee371fe620fd4, 0xea393d3dcb19fac9, 0xa3e7491c74fe0f59, 0xf9dabfa3d61cc580, 0xcf2a01ffb33c75e8,
  0xbd838f81e5adc3ec, 0xd6bce70b37e06256, 0x385bcde01f50603b, 0xce8815d54e5e5363, 0x62aa8b4b0b9c6378,
  0x12e65f36c490c76f, 0x3458df1726ae0f36, 0x4e7ea75663c81f94, 0xcc4ffef0f7bca185, 0x86687993fc0fe32f,
  0x617c68f45fe07efd, 0x2d9f0271964b867a, 0x3c95fb9a19961d25, 0x00000375d32d4405,
};

/*
 * m169a_u1x8_uart0_noled_pr_ee_ce   m169p_u1x8_uart0_noled_pr_ee_ce   m169pa_u1x8_uart0_noled_pr_ee_ce
 * m165_u1x8_uart0_noled_pr_ee_ce    m165a_u1x8_uart0_noled_pr_ee_ce   m165p_u1x8_uart0_noled_pr_ee_ce
 * m165pa_u1x8_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m169_u1x8_uart0_noled_pr_ee_ce[] = {
  0xbbbbaeed414477d6, 0xdddd55ee0541625b, 0x33f6a6fe9e989ddd, 0x0910e0fbbe96a18d, 0xd38ae0fda68b5159,
  0x180905b2bbc9dd7a, 0xbff3c0b3e35a609f, 0xe737f68805bd8169, 0x2a77810effaa37f2, 0x3b8dceb3643fcf19,
  0xea253b5958f7cc27, 0x8f83660d6bfa8f2b, 0x9d68450298ac27fa, 0x84d7d18596229166, 0x1e0b39d5dba711d4,
  0xaaf1b1d79d376ded, 0x5c24228e791871b1, 0xd8226470decb65cc, 0x12b5ec2ce89534a8, 0x01deb5e73859bf03,
  0x9b19c2de6f00fa83, 0x1bc67440aeaa72f2, 0x3b7b15545a585ce3, 0x79b09732f9b62486, 0xe50d165abcb93570,
  0x61539fa9d598f207, 0x7cd0f327f8138d28, 0xcb25c33d30ae4fc0, 0x0ccb0e9296cf8138, 0xf3a7a2029e4afdcd,
  0x0000000000000013,
};

/*
 * m169a_u1x8_uart0_noled_pr_ee_ce_u4 m169p_u1x8_uart0_noled_pr_ee_ce_u4
 * m169pa_u1x8_uart0_noled_pr_ee_ce_u4 m165_u1x8_uart0_noled_pr_ee_ce_u4
 * m165a_u1x8_uart0_noled_pr_ee_ce_u4 m165p_u1x8_uart0_noled_pr_ee_ce_u4
 * m165pa_u1x8_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u1x8_uart0_noled_pr_ee_ce_u4[] = {
  0x777775dd44867f3e, 0xbbbbaabc68299c4b, 0x6b8da29bbd837bbb, 0x5a165955a6ec2f53, 0x8d545eccdd6fa772,
  0x9f180905b2bbc9dd, 0x16bfec5767c66e60, 0x7b9cdfda2016f604, 0x85c1c383717d51c8, 0x1b09117dc4963cf2,
  0x747d493f51f097e2, 0xdadcdbdf33c5dc6e, 0x306b5fd4795f5129, 0x2814c5613fd47c1b, 0x8c2cb1148b34eb42,
  0xceaedd388ea426be, 0x8ebce9bb6f68f059, 0x1473c8c38d8d578d, 0x2386f65b2e62e121, 0x616744a9a546c113,
  0xaf39c2cdf81895af, 0x16f37807d4180ef5, 0xa20575539794d8ce, 0xaaa2d2c2e718de33, 0xb997cdb12431dbd8,
  0x771a2c6f86e3cd84, 0xc2a73f53ab337f07, 0x97e627ff787bde50, 0x7ec3343cc9fe07f1, 0x3d30be347a2ff03f,
  0x9296cf8138cb25c3, 0x459e4afdcd0ccb0e, 0x000000027e0fc137,
};

/*
 * m169a_u1x8_uart0_noled_hw         m169p_u1x8_uart0_noled_hw         m169pa_u1x8_uart0_noled_hw
 * m168pb_u1x8_uart0_noled_hw        m165_u1x8_uart0_noled_hw          m165a_u1x8_uart0_noled_hw
 * m165p_u1x8_uart0_noled_hw         m165pa_u1x8_uart0_noled_hw
 */
static const uint64_t ur_m169_u1x8_uart0_noled_hw[] = {
  0x5bbbbbaeed66e614, 0xeeeeeeaaec385ee2, 0x656cfddf87f7d2ee, 0xf8fd697e6eee9101, 0x95de4ee8dbc77af4,
  0xcf829304f8c0482d, 0x100b7b02f93ff0e3, 0xa03be5843dce6fed, 0x5a38e9fc1a0bf51f, 0x58731602cb299efb,
  0xcc11d7a3e76afe8f, 0x59ed8fb33ca807fe, 0x7e06256bd838f81e, 0xf50603bd6bce70b3, 0xe5e5363385bcde01,
  0xb9c6378ce8815d54, 0x249156f62aa8b4b0, 0x3fb0ddb09732f9b6, 0xe32c970cf4c2b93f, 0x4332c3a4a5b2c944,
  0xe2039760a792bf73, 0x0000000000000008,
};

/*
 * m169a_u1x8_uart0_noled_ee_hw      m169p_u1x8_uart0_noled_ee_hw      m169pa_u1x8_uart0_noled_ee_hw
 * m168pb_u1x8_uart0_noled_ee_hw     m165_u1x8_uart0_noled_ee_hw       m165a_u1x8_uart0_noled_ee_hw
 * m165p_u1x8_uart0_noled_ee_hw      m165pa_u1x8_uart0_noled_ee_hw     pwm216_u1x8_uart0_noled_ee_hw
 * pwm316_u1x8_uart0_noled_ee_hw
 */
static const uint64_t ur_m169_u1x8_uart0_noled_ee_hw[] = {
  0x777775dd44862d7b, 0xddddd55d7208244b, 0x5e14f4c6dec33ddd, 0x8cc4e0be17bbbbfc, 0x7751d94ad7640ccd,
  0x9827c602416caef2, 0xd813a5ffa14cf94b, 0xa39c6e737f68805b, 0x698fa8f2b9126ab5, 0x3be2beebd47c1b30,
  0x16588a459a75a114, 0xce2b8d64d2135f46, 0x6edbda3c1673ab4b, 0x1871b1aad743af3a, 0xcb65cc5c24228e79,
  0x2a6951b047eb70de, 0xb37e06256bd80151, 0x01f50603bd6bce70, 0x54e5e5363385bcde, 0xb0b9c6378ce8815d,
  0xb6249156f62aa8b4, 0x05d8dc79b09732f9, 0xf787bde50c2a73f5, 0xcc9fe07f197e627f, 0x47a2ff03f7ec3343,
  0x138cb25c33d30be3, 0xdcd0ccb0e9296cf8, 0x002dfe343a29e4af,
};

/*
 * m169a_u1x8_uart0_noled_ce_hw      m169p_u1x8_uart0_noled_ce_hw      m169pa_u1x8_uart0_noled_ce_hw
 * m168pb_u1x8_uart0_noled_ce_hw     m165_u1x8_uart0_noled_ce_hw       m165a_u1x8_uart0_noled_ce_hw
 * m165p_u1x8_uart0_noled_ce_hw      m165pa_u1x8_uart0_noled_ce_hw
 */
static const uint64_t ur_m169_u1x8_uart0_noled_ce_hw[] = {
  0x96eeeeebbb59bb37, 0xbbbbbbbaabb0e0c8, 0x234175f5a789df1f, 0x6c401b6d22eeeee8, 0x16caef2776c7b21a,
  0x71e7e449827c6024, 0xf68805bd81695ff8, 0x380a1dff5e92e737, 0xc6e393f9df9e3250, 0x79ee580b8ce6139d,
  0xc71d3f83c67ea388, 0x478cce62c05def05, 0x1cb19e3af173b3da, 0x7e06256bd83aa277, 0xf50603bd6bce70b3,
  0xe5e5363385bcde01, 0xb9c6378ce8815d54, 0x490c76f62aa8b4b0, 0x7f61bb612e65f36c, 0xc6592e19e985727e,
  0x866587494b659289, 0x853ebec14f257ee6, 0x0000000000000018,
};

/*
 * m169_u1x8_uart0_noled_ee_ce_u4_hw m169a_u1x8_uart0_noled_ee_ce_hw   m169a_u1x8_uart0_noled_ee_ce_u4_hw
 * m169p_u1x8_uart0_noled_ee_ce_hw   m169p_u1x8_uart0_noled_ee_ce_u4_hw
 * m169pa_u1x8_uart0_noled_ee_ce_hw  m169pa_u1x8_uart0_noled_ee_ce_u4_hw
 * m168pb_u1x8_uart0_noled_ee_ce_hw  m168pb_u1x8_uart0_noled_ee_ce_u4_hw
 * m165_u1x8_uart0_noled_ee_ce_hw    m165_u1x8_uart0_noled_ee_ce_u4_hw m165a_u1x8_uart0_noled_ee_ce_hw
 * m165a_u1x8_uart0_noled_ee_ce_u4_hw m165p_u1x8_uart0_noled_ee_ce_hw
 * m165p_u1x8_uart0_noled_ee_ce_u4_hw m165pa_u1x8_uart0_noled_ee_ce_hw
 * m165pa_u1x8_uart0_noled_ee_ce_u4_hw pwm216_u1x8_uart0_noled_ee_ce_hw
 * pwm216_u1x8_uart0_noled_ee_ce_u4_hw pwm316_u1x8_uart0_noled_ee_ce_hw
 * pwm316_u1x8_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u1x8_uart0_noled_ee_ce_hw[] = {
  0x777775dd448624d6, 0xbbbbaabc68299c4b, 0x6b8da29bbd837bbb, 0x5a165955a6ec2f53, 0xbbf6baef53efa772,
  0xc13e30120b657793, 0x8105affa14cf8cdc, 0x721ee737f68805bd, 0x3ca17070e0dc5f54, 0xf886c2445f71258f,
  0x8dc4a8b91fd47c25, 0x253b5b9b7be678bb, 0x83660d6bfa8f2bea, 0x68450298ac27fa8f, 0xd7d185962291669d,
  0x0b39d5dba711d484, 0xf1b1d79d376ded1e, 0x24228e791871b1aa, 0x226470decb65cc5c, 0xb5ec2ce89534a8d8,
  0xdeb5e73859bf0312, 0x19c2de6f00fa8301, 0xc67440aeaa72f29b, 0x7b15545a585ce31b, 0xb09732f9b624863b,
  0x0c2a73f505d8dc79, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c,
  0x2a29e4afdcd0ccb0, 0x0000000000a021f8,
};

/*
 * m169_u1x8_uart0_lednop_pr         m169a_u1x8_uart0_lednop           m169a_u1x8_uart0_lednop_pr
 * m169p_u1x8_uart0_lednop           m169p_u1x8_uart0_lednop_pr        m169pa_u1x8_uart0_lednop
 * m169pa_u1x8_uart0_lednop_pr       m165_u1x8_uart0_lednop            m165_u1x8_uart0_lednop_pr
 * m165a_u1x8_uart0_lednop           m165a_u1x8_uart0_lednop_pr        m165p_u1x8_uart0_lednop
 * m165p_u1x8_uart0_lednop_pr        m165pa_u1x8_uart0_lednop          m165pa_u1x8_uart0_lednop_pr
 */
static const uint64_t ur_m169_u1x8_uart0_lednop[] = {
  0xb777775ddacdc49f, 0xeeeeeeaaec38f244, 0xb2e6fc1cd075d7ee, 0xad0bdbf6ddddcd60, 0x7793bb9892150d68,
  0xebe4c13e30120b65, 0x05bd81263fefd0f3, 0x1df2c90ee737f688, 0x1c74fe0cd27a8e4f, 0x398b016f74c3e749,
  0x23af173b35f23905, 0x5af61583ef71cb18, 0xf3c0809c2cdf8189, 0xb79bcd914180ef5a, 0xef9537a94e4a7400,
  0x2d3574e31bc67440, 0x5f36dce455bd8aaa, 0xf8d163ce1bb612e6, 0xc2b93f75663c81a3, 0xb2c944e32c970cf4,
  0x92bf734332c3a4a5, 0x000007c8739ae3e7,
};

/*
 * m169a_u1x8_uart0_lednop_pr_u4     m169p_u1x8_uart0_lednop_pr_u4     m169pa_u1x8_uart0_lednop_pr_u4
 * m165_u1x8_uart0_lednop_pr_u4      m165a_u1x8_uart0_lednop_pr_u4     m165p_u1x8_uart0_lednop_pr_u4
 * m165pa_u1x8_uart0_lednop_pr_u4
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_pr_u4[] = {
  0xdddddd77512233c3, 0x7777755761c1af12, 0x2f7b3dfb0dbd8037, 0x5d7f89dddd2202ca, 0x3ba47e5dbd38e3e9,
  0x4c13e30120b65779, 0xec0a6eff3c0b3e80, 0x9610f739bfb4402d, 0xa7f0682fd47b58ef, 0xb016594df241f8e3,
  0xf47cecb3d1a43398, 0x16691500ffd9823a, 0xad7b20ad03cb3db4, 0x79e0404e166fc0c4, 0x5bcde6c8a0c077ad,
  0x77ca9bd4a7253a00, 0x169aba718de33a20, 0x2f9b6e722adec555, 0x6f8b9357079b0973, 0x53ab31e40fca1a2c,
  0xff787bde50c2a73f, 0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf,
  0x01f276e422029e4a,
};

/*
 * m169_u1x8_uart0_lednop_pr_ee_u4   m169a_u1x8_uart0_lednop_pr_ee     m169a_u1x8_uart0_lednop_pr_ee_u4
 * m169p_u1x8_uart0_lednop_pr_ee     m169p_u1x8_uart0_lednop_pr_ee_u4  m169pa_u1x8_uart0_lednop_pr_ee
 * m169pa_u1x8_uart0_lednop_pr_ee_u4 m165_u1x8_uart0_lednop_pr_ee      m165_u1x8_uart0_lednop_pr_ee_u4
 * m165a_u1x8_uart0_lednop_pr_ee     m165a_u1x8_uart0_lednop_pr_ee_u4  m165p_u1x8_uart0_lednop_pr_ee
 * m165p_u1x8_uart0_lednop_pr_ee_u4  m165pa_u1x8_uart0_lednop_pr_ee    m165pa_u1x8_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_pr_ee[] = {
  0xbbbbbaeea24477d6, 0xddddd55d72056e25, 0x8261550e85ebd7dd, 0x8f382f85eeeeff16, 0x5a71189fb47ef17d,
  0xe30120b657793baf, 0xebfe78167d4f4c13, 0xdce6fed100b7b022, 0x51e56654d56b4738, 0xc3dfa8f83660d31f,
  0x291669d68450ef8a, 0x3593484d7d185962, 0x2464d1cead2e7aae, 0x6355ae875e74dda3, 0x98b8484504f237b5,
  0xa3608fd6e1bd96cb, 0x1895af60043eccf2, 0xf5af3c0809c2cdf8, 0x400b79bcd914180e, 0x440ef9537a94e4a7,
  0xaaa2d3574e31bc67, 0x2e65f36dce455bd8, 0x458df1726ae0f361, 0xe7ea75663c81f943, 0xc4ffef0f7bca1854,
  0x6687993fc0fe32fc, 0x17c68f45fe07efd8, 0xd9f0271964b867a6, 0xc95fb9a19961d252, 0x0000275c9c5c4053,
};

/*
 * m169_u1x8_uart0_lednop_pr_ce_u4   m169a_u1x8_uart0_lednop_pr_ce     m169a_u1x8_uart0_lednop_pr_ce_u4
 * m169p_u1x8_uart0_lednop_pr_ce     m169p_u1x8_uart0_lednop_pr_ce_u4  m169pa_u1x8_uart0_lednop_pr_ce
 * m169pa_u1x8_uart0_lednop_pr_ce_u4 m165_u1x8_uart0_lednop_pr_ce      m165_u1x8_uart0_lednop_pr_ce_u4
 * m165a_u1x8_uart0_lednop_pr_ce     m165a_u1x8_uart0_lednop_pr_ce_u4  m165p_u1x8_uart0_lednop_pr_ce
 * m165p_u1x8_uart0_lednop_pr_ce_u4  m165pa_u1x8_uart0_lednop_pr_ce    m165pa_u1x8_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_pr_ce[] = {
  0x777775dd4488a493, 0xeeeeeaafc2e4844b, 0xc9b532666ef4fdee, 0x8412a1eeee9b4916, 0x27743720a68a768d,
  0x39827c602416caef, 0xf60495bfcf02cf9c, 0x7d724b9cdfda2016, 0x4b1e78c953ba9571, 0xf84bf10d8488bee2,
  0x78bb8dcadf801fa8, 0xa8fd24f72c67eb26, 0xa6222c71d3f83d67, 0x9d967a3486731602, 0x22a01ffb33c75e8f,
  0xd905681e5adc82cd, 0x020270b37e06256b, 0x6f36450603bd6bcf, 0x54dea53929d002de, 0xd5d38c6f19d103be,
  0xb6e70c76f62aa8b4, 0xb9357079b09732f9, 0xb31e40fca1a2c6f8, 0x87bde50c2a73f53a, 0x9fe07f197e627ff7,
  0xa2ff03f7ec3343cc, 0x8cb25c33d30be347, 0xd0ccb0e9296cf813, 0xafbc162029e4afdc, 0x000000000000001b,
};

/*
 * m169a_u1x8_uart0_lednop_pr_ee_ce  m169p_u1x8_uart0_lednop_pr_ee_ce  m169pa_u1x8_uart0_lednop_pr_ee_ce
 * m165_u1x8_uart0_lednop_pr_ee_ce   m165a_u1x8_uart0_lednop_pr_ee_ce  m165p_u1x8_uart0_lednop_pr_ee_ce
 * m165pa_u1x8_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_pr_ee_ce[] = {
  0xbbbbaeed41445541, 0xdddd55ee0564625b, 0x28d35a3c8ef25ddd, 0x9c88707ddf4b50e8, 0x4932271ce5c647c1,
  0x180905b2bbc9dd01, 0x5fe78167fabe609f, 0xce6fed100b7b028e, 0x54ef7d9dff546fe5, 0x771b9722495f9e32,
  0xdd4a76b2b1ef984e, 0x1f06cc1ad7f51e57, 0x3ad08a05315edff5, 0x09afa30b2c4522cd, 0x193473abb71ea3a9,
  0xaaf1b1d79d3768c9, 0x5c242282791bdab1, 0xd8226470decb65cc, 0x256bd8598fb33ca8, 0x6bcf020270b37e06,
  0x02de6f36450603bd, 0x03be54dea53929d0, 0xa8b4d5d38c6f19d1, 0x32f9b6e70c76f62a, 0x5abcb9357079b097,
  0xa9d598f207e50d16, 0x27f8138d2861539f, 0x3d30ae4fc07cd0f3, 0x9296cf8138cb25c3, 0x029e4afdcd0ccb0e,
  0x0000000009f8bb22,
};

/*
 * m169a_u1x8_uart0_lednop_pr_ee_ce_u4 m169p_u1x8_uart0_lednop_pr_ee_ce_u4
 * m169pa_u1x8_uart0_lednop_pr_ee_ce_u4 m165_u1x8_uart0_lednop_pr_ee_ce_u4
 * m165a_u1x8_uart0_lednop_pr_ee_ce_u4 m165p_u1x8_uart0_lednop_pr_ee_ce_u4
 * m165pa_u1x8_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_pr_ee_ce_u4[] = {
  0x777775dd44864c7f, 0xbbbbaabc68160c4b, 0x74cd71b4bd477bbb, 0xd8405955a6ec2f53, 0xf5ddce29d55e2465,
  0x4f8c0482d95de4ee, 0xb1fffb15d9f0d130, 0x3dce6fed100b7b02, 0x42e0e25ab8bea8e4, 0x0d8488bee24b1e79,
  0x0224c03fa8f84bf1, 0xdadcdbdf33c5dc6e, 0x306b5fd4795f7529, 0x2814c57b7fd47c1b, 0x8c2cb1148b34eb42,
  0xceaedc7a8ea426be, 0xc75e74dda32464d1, 0x8a09e46f6ac6abc6, 0x91c37b2d97317090, 0x61663eccf2a36089,
  0x0809c2cdf81895af, 0xbcd914180ef5af3c, 0x537a94e4a7400b79, 0x574e31bc67440ef9, 0xdb9c31dbd8aaa2d3,
  0x37c371e6c25ccbe6, 0xa9d599bf83bb8d16, 0xffbc3def2861539f, 0x1e64ff03f8cbf313, 0x1a3d17f81fbf619a,
  0xc09c6592e19e985f, 0x7ee6866587494b67, 0x009f896d1ba2cf25,
};

/*
 * m169a_u1x8_uart0_lednop_hw        m169p_u1x8_uart0_lednop_hw        m169pa_u1x8_uart0_lednop_hw
 * m168pb_u1x8_uart0_lednop_hw       m165_u1x8_uart0_lednop_hw         m165a_u1x8_uart0_lednop_hw
 * m165p_u1x8_uart0_lednop_hw        m165pa_u1x8_uart0_lednop_hw
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_hw[] = {
  0x5bbbbbaeed66fcc5, 0xeeeeeeaaec3835e2, 0x6517bd9efdb76dee, 0xf4aebfc4eeee9101, 0x2bbc9dda86a6f70a,
  0x9f402609f180905b, 0x2016f605377fe1c7, 0xac77cb087b9cdfda, 0xfc71d3f83417ea3d, 0x19cc580b2ca6f920,
  0xc11d7a3e7659e8d2, 0x9eda0b348a807fec, 0xe06256bd905681e5, 0x3bd6bcf020270b37, 0x9d002de6f3645060,
  0x9d103be54dea5392, 0x62aa8b4d5d38c6f1, 0x84b997cdb739156f, 0x67a615c9f9fd86ed, 0x252d964a271964b8,
  0x053c95fb9a19961d, 0x000000004710e2fb,
};

/*
 * m169a_u1x8_uart0_lednop_ee_hw     m169p_u1x8_uart0_lednop_ee_hw     m169pa_u1x8_uart0_lednop_ee_hw
 * m168pb_u1x8_uart0_lednop_ee_hw    m165_u1x8_uart0_lednop_ee_hw      m165a_u1x8_uart0_lednop_ee_hw
 * m165p_u1x8_uart0_lednop_ee_hw     m165pa_u1x8_uart0_lednop_ee_hw    pwm216_u1x8_uart0_lednop_ee_hw
 * pwm316_u1x8_uart0_lednop_ee_hw
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_ee_hw[] = {
  0xbbbbbaeea2435562, 0xddddd55d72056e25, 0x2d04c2aa1ed0bddd, 0xfb1e705f0bddddfe, 0xee99169db618fde2,
  0x304f8c0482d95de4, 0xb022ebff4299f53d, 0x4738dce6fed100b7, 0xd31f51e56654d56b, 0xef8ac3dfa8f83660,
  0x5962291669d68450, 0x7aae3593484d7d18, 0xdda32464d1cead2e, 0x37b56355ae875e74, 0x96cb98b8484504f2,
  0xccf2a3608fd6e1bd, 0xcdf81895af60043e, 0x180ef5af3c0809c2, 0xe4a7400b79bcd914, 0xbc67440ef9537a94,
  0x5bd8aaa2d3574e31, 0xf3612e65f36dce45, 0xca1854e7ea0bb1b8, 0xfe32fcc4ffef0f7b, 0x07efd86687993fc0,
  0xb867a617c68f45fe, 0x61d252d9f0271964, 0xeb7453c95fb9a199, 0x0000000000005be7,
};

/*
 * m169a_u1x8_uart0_lednop_ce_hw     m169p_u1x8_uart0_lednop_ce_hw     m169pa_u1x8_uart0_lednop_ce_hw
 * m168pb_u1x8_uart0_lednop_ce_hw    m165_u1x8_uart0_lednop_ce_hw      m165a_u1x8_uart0_lednop_ce_hw
 * m165p_u1x8_uart0_lednop_ce_hw     m165pa_u1x8_uart0_lednop_ce_hw
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_ce_hw[] = {
  0x96eeeeebbb59bb37, 0xddddddd55d872b48, 0x82341da1377ef8fd, 0xa6c401b6f8feeeee, 0x416caef2776c7b21,
  0x0e3cfc069827c602, 0xfda2016f6041efff, 0x0e64877fd7a4b9cd, 0x71b8e4fe77e78c94, 0x2e7b9602e33984e7,
  0xf1c74fe0f19fa8f8, 0xa3905398b0177b10, 0x8e58cf1d78b9d838, 0xfc0c4ad7b074a0fb, 0x077ad79e0404e166,
  0x94e8016f3796ea0c, 0x2d380bdf2a6f529c, 0x18de33a204746304, 0xec376c25ccbe6da7, 0xcb25c33d30ae4fcf,
  0xccb0e9296cb25138, 0xa7d7d829e4afdcd0, 0x0000000000000310,
};

/*
 * m169_u1x8_uart0_lednop_ee_ce_u4_hw m169a_u1x8_uart0_lednop_ee_ce_hw
 * m169a_u1x8_uart0_lednop_ee_ce_u4_hw m169p_u1x8_uart0_lednop_ee_ce_hw
 * m169p_u1x8_uart0_lednop_ee_ce_u4_hw m169pa_u1x8_uart0_lednop_ee_ce_hw
 * m169pa_u1x8_uart0_lednop_ee_ce_u4_hw m168pb_u1x8_uart0_lednop_ee_ce_hw
 * m168pb_u1x8_uart0_lednop_ee_ce_u4_hw m165_u1x8_uart0_lednop_ee_ce_hw
 * m165_u1x8_uart0_lednop_ee_ce_u4_hw m165a_u1x8_uart0_lednop_ee_ce_hw
 * m165a_u1x8_uart0_lednop_ee_ce_u4_hw m165p_u1x8_uart0_lednop_ee_ce_hw
 * m165p_u1x8_uart0_lednop_ee_ce_u4_hw m165pa_u1x8_uart0_lednop_ee_ce_hw
 * m165pa_u1x8_uart0_lednop_ee_ce_u4_hw pwm216_u1x8_uart0_lednop_ee_ce_hw
 * pwm216_u1x8_uart0_lednop_ee_ce_u4_hw pwm316_u1x8_uart0_lednop_ee_ce_hw
 * pwm316_u1x8_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u1x8_uart0_lednop_ee_ce_hw[] = {
  0x777775dd4486a4d6, 0xbbbbaabc68160c4b, 0x74cd71b4bd477bbb, 0xd8405955a6ec2f53, 0xdd39d9f7a55e2465,
  0x609f180905b2bbc9, 0xc0ac7ffe8533e1a2, 0x390f739bfb4402de, 0x9e50b83896ae2faa, 0xfc4361222fb892c7,
  0xc6e5253397ea3e12, 0x529dadcdbdf33c5d, 0xc1b306b5fd4795f7, 0xb422814c57b7fd47, 0x6be8c2cb1148b34e,
  0x4d1ceaedc7a8ea42, 0xbc6c75e74dda3246, 0x0908a09e46f6ac6a, 0x08991c37b2d97317, 0x5af61663eccf2a36,
  0xf3c0809c2cdf8189, 0xb79bcd914180ef5a, 0xef9537a94e4a7400, 0x2d3574e31bc67440, 0xbe6db9c31dbd8aaa,
  0xfd4176371e6c25cc, 0x9ffde1ef79430a9c, 0xd0f327f81fc65f98, 0xf8d1e8bfc0fdfb0c, 0x3e04e32c970cf4c2,
  0x2bf734332c3a4a5b, 0x0000140496d28a79,
};

/*
 * m169a_u1x8_uart0_dual             m169p_u1x8_uart0_dual             m169pa_u1x8_uart0_dual
 * m165_u1x8_uart0_dual              m165a_u1x8_uart0_dual             m165p_u1x8_uart0_dual
 * m165pa_u1x8_uart0_dual
 */
static const uint64_t ur_m169_u1x8_uart0_dual[] = {
  0xb777777c4ea22a20, 0xddddddbf36da3336, 0xd7d123c95a76d86d, 0x14e0dd13b777717b, 0xe4ad0ee1ec5ab635,
  0x67304f8c0482d95d, 0x06eeb6819129291d, 0x3e25c40c2860da46, 0x599c9fe6571eb9dd, 0x6f51dfcd82fb3814,
  0xe08a11c913f8332a, 0x1b87c2886257f9fb, 0x1955ddeef9b91c80, 0x35ad150865a11922, 0x212db98fffa039e1,
  0xd7fd2024c161bcaf, 0xdce6fed100b7b023, 0xa43f51c453be5abf, 0xc39931e9238e9fc1, 0x66be46f68e62c05f,
  0xfbdc72c608ebc8b7, 0x7f157ceee2a4a560, 0x04e166fc0c4ad7b2, 0x96ea0c077ad79e04, 0x6f529c94e8016f37,
  0x3a8a042d380bdf2a, 0x5f36d38c6f19d102, 0xfb1726ae0f3612e6, 0x32c970cf4c2b93f3, 0x4332c3a4a5b3e04e,
  0xbe38b880a792bf73, 0x0000000000000065,
};

/*
 * m169_u1x8_uart0_dual_pr_u4        m169a_u1x8_uart0_dual_pr          m169a_u1x8_uart0_dual_pr_u4
 * m169p_u1x8_uart0_dual_pr          m169p_u1x8_uart0_dual_pr_u4       m169pa_u1x8_uart0_dual_pr
 * m169pa_u1x8_uart0_dual_pr_u4      m165_u1x8_uart0_dual_pr           m165_u1x8_uart0_dual_pr_u4
 * m165a_u1x8_uart0_dual_pr          m165a_u1x8_uart0_dual_pr_u4       m165p_u1x8_uart0_dual_pr
 * m165p_u1x8_uart0_dual_pr_u4       m165pa_u1x8_uart0_dual_pr         m165pa_u1x8_uart0_dual_pr_u4
 */
static const uint64_t ur_m169_u1x8_uart0_dual_pr[] = {
  0x77777c4d1218022f, 0xddddbf36db4e36b7, 0x2941b848eabedddd, 0xa01513b777469b45, 0x6eec983f2350ce20,
  0x9f180905b2bbc906, 0x6d032252523ace60, 0x881850c1b48c0ddd, 0xc3fccab773ba7c4b, 0x7fddb04ac7074b31,
  0x08e489fc1c069bd4, 0xe144312bfcfdf045, 0xddeef9b9d3e00dc3, 0x150865a098a21955, 0xb98fffa039e13465,
  0xe6bcc161bcaf212d, 0x7f68805bd811ebfe, 0xa8f914ef9626ae73, 0x38bdf1c74fe0c43f, 0x23afe731602a83cd,
  0xffb30475e00ced6b, 0x07967b621d21aa01, 0xfc55f3bb8a92a93a, 0x13859bf0312b5ec9, 0xb228301deb5e7810,
  0xf529c94e8016f379, 0x9c6378ce881df2a6, 0x9c8ab7b15545a6ae, 0xc371e6c25ccbe6db, 0xd599bf83bb8d1637,
  0xbc3def2861539fa9, 0x64ff03f8cbf313ff, 0x3d17f81fbf619a1e, 0x9c6592e19e985f1a, 0xe6866587494b67c0,
  0x24f5969ba2cf257e, 0x0000000000000005,
};

/*
 * m169_u1x8_uart0_dual_pr_ee_u4     m169a_u1x8_uart0_dual_pr_ee       m169a_u1x8_uart0_dual_pr_ee_u4
 * m169p_u1x8_uart0_dual_pr_ee       m169p_u1x8_uart0_dual_pr_ee_u4    m169pa_u1x8_uart0_dual_pr_ee
 * m169pa_u1x8_uart0_dual_pr_ee_u4   m165_u1x8_uart0_dual_pr_ee        m165_u1x8_uart0_dual_pr_ee_u4
 * m165a_u1x8_uart0_dual_pr_ee       m165a_u1x8_uart0_dual_pr_ee_u4    m165p_u1x8_uart0_dual_pr_ee
 * m165p_u1x8_uart0_dual_pr_ee_u4    m165pa_u1x8_uart0_dual_pr_ee      m165pa_u1x8_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m169_u1x8_uart0_dual_pr_ee[] = {
  0x6eeeeef89a2432db, 0xbbbbbb7e614eb66d, 0x2dfbb17d95a9afbb, 0x716aa86d1776c4bb, 0x7045580f8ce947ee,
  0x0120b657793705dc, 0xc8949485c14c13e3, 0x14306d2303775b40, 0x32addcee9f12e206, 0xd858f9c3fe4c1a3f,
  0x13f83eaf9bd47e9f, 0x6257f9fbe08a11c9, 0xf3712a001b87c288, 0x9682564432abbbdd, 0xfd01cf0997dc5421,
  0x0b0de579096dce0f, 0x05bd81656ff735e6, 0xab5a3912e737f688, 0x660c14f51e56bee6, 0x450ef8aea57a8f83,
  0xd185962291669d68, 0x4b994b8a973484d7, 0xa89768851ef673ab, 0x4547cf58d56ba1d7, 0x6f65f4b3170908a0,
  0x427f58a8d823f5b8, 0xc9fc55f3bb8a9280, 0x1013859bf0312b5e, 0x79b228301deb5e78, 0xa6f529c94e8016f3,
  0xae9c6378ce881df2, 0xdb9c8ab7b15545a6, 0x37c371e6c25ccbe6, 0xa9d599bf83bb8d16, 0xffbc3def2861539f,
  0x1e64ff03f8cbf313, 0x1a3d17f81fbf619a, 0xc09c6592e19e985f, 0x7ee6866587494b67, 0x0005642cdba2cf25,
};

/*
 * m169_u1x8_uart0_dual_pr_ce_u4     m169a_u1x8_uart0_dual_pr_ce       m169a_u1x8_uart0_dual_pr_ce_u4
 * m169p_u1x8_uart0_dual_pr_ce       m169p_u1x8_uart0_dual_pr_ce_u4    m169pa_u1x8_uart0_dual_pr_ce
 * m169pa_u1x8_uart0_dual_pr_ce_u4   m165_u1x8_uart0_dual_pr_ce        m165_u1x8_uart0_dual_pr_ce_u4
 * m165a_u1x8_uart0_dual_pr_ce       m165a_u1x8_uart0_dual_pr_ce_u4    m165p_u1x8_uart0_dual_pr_ce
 * m165p_u1x8_uart0_dual_pr_ce_u4    m165pa_u1x8_uart0_dual_pr_ce      m165pa_u1x8_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m169_u1x8_uart0_dual_pr_ce[] = {
  0xeeeeef89a2435202, 0x77776fc6a79f66d6, 0xebb8d43db6abf777, 0xfbf7b2b777519b33, 0xce43ada6cdf9af45,
  0x30120b657793d39d, 0x19129290aebcc13e, 0xc2860da4606eeb68, 0xe655bb9dd3e25c40, 0x5b04b4700b5318ff,
  0x489fc1c569bd4727, 0x4312bfcfdf04508e, 0xef9b930c00dc3e14, 0x0cb417da21955dde, 0xffe80e784c1ee2a1,
  0x30586f2bc84b6fa6, 0x402dec08a5ffb9af, 0x96e2faa01739bfb4, 0xfb892c79e50b838e, 0xfea3e12fc4361222,
  0x4b99e2ee370527eb, 0x4bf51c6fcf72c67d, 0x014141f238e9fc1d, 0x00676b591d7f398b, 0xe90d500ffd99e3af,
  0x152552740f2d6e10, 0x6256bd93f8abe777, 0xd6bcf020270b37e0, 0x002de6f36450603b, 0x103be54dea53929d,
  0xaa8b4d5d38c6f19d, 0x732f9b6e70c76f62, 0xee3458df0dc79b09, 0x854e7ea75666fe0e, 0x2fcc4ffef0f7bca1,
  0xfd86687993fc0fe3, 0x7a617c68f45fe07e, 0x252d9f0271964b86, 0x8b3c95fb9a19961d, 0x000000069247d76e,
};

/*
 * m169a_u1x8_uart0_dual_pr_ee_ce    m169p_u1x8_uart0_dual_pr_ee_ce    m169pa_u1x8_uart0_dual_pr_ee_ce
 * m165_u1x8_uart0_dual_pr_ee_ce     m165a_u1x8_uart0_dual_pr_ee_ce    m165p_u1x8_uart0_dual_pr_ee_ce
 * m165pa_u1x8_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m169_u1x8_uart0_dual_pr_ee_ce[] = {
  0xbbbbbbe275050c86, 0xeeeeedf836f261b5, 0x55710b157ee44eee, 0x4dd6990123ba82b6, 0xbbb1bb3eafcc507c,
  0x602416caef25d93b, 0x32252523b8f9827c, 0x850c1b48c0ddd6d0, 0xccab773ba7c4b881, 0xf61000e02926fd7f,
  0x44fe0e76e6f51eb7, 0x1895fe7ef8228472, 0xf9b8a91006e1f0a2, 0xcb437da21955ddee, 0xfe80e784cc162a10,
  0x0b0de579096dd36f, 0x0b7b02a1fff735e6, 0xfea8dc9dce6fed10, 0x83fe7942e0e0d63b, 0x9374c273b8dcca86,
  0xe7a8f2b7f253b595, 0xc5701bd47c1b306b, 0xb1148b34eb422814, 0xdc650ea426be8c2c, 0xa25da2147bd9ceae,
  0x2a3e7ac6abc6c75e, 0x7b2fa598b8484502, 0x89fd62a3608991c3, 0x27f157ceee2a4a59, 0x404e166fc0c4ad7b,
  0xe6c8a0c077ad79e0, 0x9bd4a7253a005bcd, 0xba718de33a2077ca, 0xdce18edec555169a, 0xaf1b8f3612e65f36,
  0x75666fe0eee34596, 0xfe04e34a1854e7ea, 0x4c2b93f01f343cc9, 0xa5b3e04e32c970cf, 0x6792bf734332c3a4,
  0x0000002000e7cdd1,
};

/*
 * m169a_u1x8_uart0_dual_pr_ee_ce_u4 m169p_u1x8_uart0_dual_pr_ee_ce_u4 m169pa_u1x8_uart0_dual_pr_ee_ce_u4
 * m165_u1x8_uart0_dual_pr_ee_ce_u4  m165a_u1x8_uart0_dual_pr_ee_ce_u4 m165p_u1x8_uart0_dual_pr_ee_ce_u4
 * m165pa_u1x8_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u1x8_uart0_dual_pr_ee_ce_u4[] = {
  0xbbbbe268adbb2906, 0xeeedf98ec7e1b5bb, 0x7c89fd7bd2bdeeee, 0x2d99eea724fbb410, 0x0548c6c12faf5df4,
  0xef255f3b8af9016f, 0xc939827c602416ca, 0x81bbada0644a4a41, 0x4f8971030a183691, 0xce6643fccb4b7e77,
  0xbd47986d833e1c3a, 0x08a11c913f83fd79, 0xb87c2886257f9fbe, 0x55777bbe6e79c801, 0x728a8432d04b4886,
  0x2db8a4ffa039e134, 0xfe3f0cc161bcaf21, 0x9bfb4402dec0b4d7, 0xec66ee2faa353d73, 0x222fb892c79e50bc,
  0xc83fea3e12fc4361, 0xdcdd33c5dc6e6a83, 0xf3d4795bf929dadc, 0x62b80dea3e0d9835, 0x588a459a75a1140a,
  0x6e328752135f4616, 0x512ed10a3dece757, 0x151f3d6355e363af, 0xbd97d2cc5c242281, 0xc4feb151b044c8e1,
  0x93f8abe77715252c, 0x20270b37e06256bd, 0xf36450603bd6bcf0, 0x4dea53929d002de6, 0x5d38c6f19d103be5,
  0x6e70c76f62aa8b4d, 0x9357079b09732f9b, 0x6fe0fdbb1a2c6f8b, 0x7bca1854e7ea7566, 0xc0fe32fcc4ffef0f,
  0xfe07efd86687993f, 0x64b867a617c68f45, 0x9961d252d9f02719, 0x67bc8dd3c95fb9a1, 0x000000000001001f,
};

/*
 * m169a_u1x8_uart0_dual_hw          m169p_u1x8_uart0_dual_hw          m169pa_u1x8_uart0_dual_hw
 * m165_u1x8_uart0_dual_hw           m165a_u1x8_uart0_dual_hw          m165p_u1x8_uart0_dual_hw
 * m165pa_u1x8_uart0_dual_hw
 */
static const uint64_t ur_m169_u1x8_uart0_dual_hw[] = {
  0xdddddf1344867a31, 0x77776fcdb6d38dad, 0x4a506e123aafb777, 0x280544edddd1a6d1, 0x066ee44fc3ed07c8,
  0x609f180905b2bbc9, 0xdd6d032252523ace, 0x4b881850c1b48c0d, 0x31c3fccab773ba7c, 0xd47fddb04ac7074b,
  0x4508e489fc1c069b, 0xc3e144312bfcfdf0, 0x55ddeef9b9d3e00d, 0x65150865a098a219, 0x2db98fffa039e134,
  0xffd48cc161bcaf21, 0xe6fed100b7b023d7, 0x7f51f229df2c4d5c, 0x9a717be38e9fc188, 0xd6475fce62c05507,
  0x03ff6608ebc019da, 0x740f2cf6c43a4354, 0x93f8abe777152552, 0x20270b37e06256bd, 0xf36450603bd6bcf0,
  0x4dea53929d002de6, 0x5d38c6f19d103be5, 0xb739156f62aa8b4d, 0x2ec6e3cd84b997cd, 0xbc3def2861539fa8,
  0x64ff03f8cbf313ff, 0x3d17f81fbf619a1e, 0x9c6592e19e985f1a, 0xe6866587494b67c0, 0x31baeb2d514f257e,
};

/*
 * m169a_u1x8_uart0_dual_ee_hw       m169p_u1x8_uart0_dual_ee_hw       m169pa_u1x8_uart0_dual_ee_hw
 * m165_u1x8_uart0_dual_ee_hw        m165a_u1x8_uart0_dual_ee_hw       m165p_u1x8_uart0_dual_ee_hw
 * m165pa_u1x8_uart0_dual_ee_hw
 */
static const uint64_t ur_m169_u1x8_uart0_dual_ee_hw[] = {
  0xeeeeef89a243573e, 0xbbbbb7e614eb66d6, 0xdfbb17d95a9afbbb, 0x16aa86d1776c4bb2, 0x5c5f766eb2947ee7,
  0x80905b2bbc9b82ee, 0x644a4a42e0a609f1, 0x0a18369181bbada0, 0x9956ee774f897103, 0xec2c7ce1ff260d1f,
  0x89fc1f57cdea3f4f, 0x312bfcfdf04508e4, 0xf9b895000dc3e144, 0xcb412b221955ddee, 0xfe80e784cbee2a10,
  0x0586f2bc84b6e707, 0x05bd81656fff5233, 0xab5a3912e737f688, 0x660c14f51e56bee6, 0x450ef8aea57a8f83,
  0xd185962291669d68, 0x4b994b8a973484d7, 0xa89768851ef673ab, 0x4547cf58d56ba1d7, 0x6f65f4b3170908a0,
  0x427f58a8d823f5b8, 0xc9fc55f3bb8a9280, 0x1013859bf0312b5e, 0x79b228301deb5e78, 0xa6f529c94e8016f3,
  0xae9c6378ce881df2, 0xdb9c8ab7b15545a6, 0x176371e6c25ccbe6, 0xde1ef79430a9cfd4, 0x327f81fc65f989ff,
  0x1e8bfc0fdfb0cd0f, 0x4e32c970cf4c2f8d, 0x734332c3a4a5b3e0, 0x0015da2ce8a792bf,
};

/*
 * m169a_u1x8_uart0_dual_ce_hw       m169p_u1x8_uart0_dual_ce_hw       m169pa_u1x8_uart0_dual_ce_hw
 * m165_u1x8_uart0_dual_ce_hw        m165a_u1x8_uart0_dual_ce_hw       m165p_u1x8_uart0_dual_ce_hw
 * m165pa_u1x8_uart0_dual_ce_hw
 */
static const uint64_t ur_m169_u1x8_uart0_dual_ce_hw[] = {
  0xdddddf13448664d6, 0xeeeedf8d4f3ecdad, 0xd771a87b6d57eeee, 0xf7ef656eeea33667, 0xceeccd8f0f65928b,
  0x9f180905b2bbc9e9, 0xb40c894948575e60, 0x20614306d2303775, 0x7ff32addcee9f12e, 0x93ad825a3805a98c,
  0x47244fe0e2b4dea3, 0x0a21895fe7ef8228, 0xef77cdc986006e1f, 0x50865a0bed10caae, 0xd37ff4073c260f71,
  0x91982c3795e425b7, 0xb4402dec08a5fffa, 0x8e96e2faa01739bf, 0x22fb892c79e50b83, 0x107ea3e12fc43612,
  0x3ea5ccf1771b8ff3, 0x0ea5fa8e37e7b963, 0xc580a0a0f91c74fe, 0xd78033b5ac8ebf9c, 0x087486a807feccf1,
  0xbb8a92a93a0796b7, 0xf0312b5ec9fc55f3, 0x1deb5e781013859b, 0x4e8016f379b22830, 0xce881df2a6f529c9,
  0xb15545a6ae9c6378, 0x84b997cdb73863b7, 0x61539fa82ec6e3cd, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8,
  0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0xd14f257ee6866587, 0x0000000004dd63eb,
};

/*
 * m169a_u1x8_uart0_dual_ee_ce_hw    m169p_u1x8_uart0_dual_ee_ce_hw    m169pa_u1x8_uart0_dual_ee_ce_hw
 * m165_u1x8_uart0_dual_ee_ce_hw     m165a_u1x8_uart0_dual_ee_ce_hw    m165p_u1x8_uart0_dual_ee_ce_hw
 * m165pa_u1x8_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m169_u1x8_uart0_dual_ee_ce_hw[] = {
  0xeeeef89d41436f02, 0xbbbb7e0dbc986d6e, 0x5c42c55fb913bbbb, 0x75a64048eea0ad95, 0x3f87cd7d166c1f13,
  0xc0482d95de4bb277, 0x644a4a4771f304f8, 0x0a18369181bbada0, 0x9956ee774f897103, 0xec2001c0524dfaff,
  0x89fc1cedcdea3d6f, 0x312bfcfdf04508e4, 0xf37152200dc3e144, 0x9686fb4432abbbdd, 0xfd01cf09982c5421,
  0x161bcaf212dba6df, 0x2dec0a87fffd48cc, 0xfaa3727739bfb440, 0x87f9e50b838358ef, 0x26e984e771b9d66c,
  0xcf51e56fe4a76b2b, 0x8ae037a8f83660d7, 0x62291669d6845029, 0xb8ca1d484d7d1859, 0x44bb4428f7b39d5d,
  0x547cf58d578d8ebd, 0xf65f4b3170908a04, 0x13fac546c1132386, 0x4fe2af9ddc5494b3, 0x809c2cdf81895af6,
  0xcd914180ef5af3c0, 0x37a94e4a7400b79b, 0x74e31bc67440ef95, 0xb9c31dbd8aaa2d35, 0x76371e6c25ccbe6d,
  0x09c69430a9cfd4d8, 0x5727e03e687993fc, 0x67c09c6592e19e98, 0x257ee6866587494b, 0x000001d7539f514f,
};

/*
 * m169a_u1x8_uart0_dual_ee_ce_u4_hw m169p_u1x8_uart0_dual_ee_ce_u4_hw m169pa_u1x8_uart0_dual_ee_ce_u4_hw
 * m165_u1x8_uart0_dual_ee_ce_u4_hw  m165a_u1x8_uart0_dual_ee_ce_u4_hw m165p_u1x8_uart0_dual_ee_ce_u4_hw
 * m165pa_u1x8_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u1x8_uart0_dual_ee_ce_u4_hw[] = {
  0x77777c4d1468a0ae, 0xddddbf31d8fc36b7, 0x4107c89fbd7bdddd, 0xdf42d99eea724fbb, 0xfeb7a1f5ec12faf5,
  0x16caef255f3bbebe, 0x4a41c939827c6024, 0x369181bbada0644a, 0x12774f8971030a18, 0xc38759ccc87f9976,
  0x7faf37a8f30db067, 0xf3f7c114239227f0, 0x3900370f8510c4af, 0x6910caaeef77cdcf, 0x3c268e5150865a09,
  0x95e425b7149ff407, 0x2d35fecf43982c37, 0x4f5ce6fed100b7b0, 0xdf0c1c19bb8bea8d, 0x0d8488bee24b1e78,
  0x14939bffa8f84bf1, 0xed6e6e6e99e2ee37, 0xcc1af9ea3cadfc94, 0x8a05315c06f51f06, 0xa30b2c4522cd3ad0,
  0x73abb71943a909af, 0xb1d7a89768851ef6, 0x11408a8f9eb1aaf1, 0x6470decbe9662e12, 0x9296627f58a8d822,
  0x2b5ec9fc55f3bb8a, 0x5e781013859bf031, 0x16f379b228301deb, 0x1df2a6f529c94e80, 0x45a6ae9c6378ce88,
  0x97cdb73863b7b155, 0x9fa82ec6e3cd84b9, 0x13ffbc3def286153, 0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61,
  0x67c09c6592e19e98, 0x257ee6866587494b, 0x0003aea73c985f4f,
};

/*
 * m169_u1x12_uart0_noled_pr         m169a_u1x12_uart0_noled           m169a_u1x12_uart0_noled_pr
 * m169p_u1x12_uart0_noled           m169p_u1x12_uart0_noled_pr        m169pa_u1x12_uart0_noled
 * m169pa_u1x12_uart0_noled_pr       m165_u1x12_uart0_noled            m165_u1x12_uart0_noled_pr
 * m165a_u1x12_uart0_noled           m165a_u1x12_uart0_noled_pr        m165p_u1x12_uart0_noled
 * m165p_u1x12_uart0_noled_pr        m165pa_u1x12_uart0_noled          m165pa_u1x12_uart0_noled_pr
 */
static const uint64_t ur_m169_u1x12_uart0_noled[] = {
  0x776d0d783acdfebe, 0xddd55f67367c4b77, 0xbfc48716f1fddddd, 0xa114cdddd910889b, 0x3bbe3f0a2e24878b,
  0x4c13e30120b65779, 0xf093dffefd0f3f92, 0x68dd27fb6a7f76e9, 0x4f51f9e3be5921c3, 0x30df27a38e9fc19a,
  0xda478cce62c05bdd, 0x771cb1823af173b3, 0x66fc0c4ad7b0aca2, 0x03ea0c077ad79ce1, 0xa9cbca6c670b79bc,
  0x61738c6f19d102ba, 0x6c4922adec555169, 0x163ce1bb612e65f3, 0x93f75663c81a3f8d, 0x944e32c970cf4c2b,
  0xf734332c3a4a5b2c, 0x07c8749dae3e792b,
};

/*
 * m169a_u1x12_uart0_noled_pr_u4     m169p_u1x12_uart0_noled_pr_u4     m169pa_u1x12_uart0_noled_pr_u4
 * m165_u1x12_uart0_noled_pr_u4      m165a_u1x12_uart0_noled_pr_u4     m165p_u1x12_uart0_noled_pr_u4
 * m165pa_u1x12_uart0_noled_pr_u4
 */
static const uint64_t ur_m169_u1x12_uart0_noled_pr_u4[] = {
  0x76d0d7834488da91, 0xeeaafb395a44b777, 0x22a99b6f46deeeee, 0xb07dddd0b28e3a11, 0xd17a763b976c478f,
  0x3e30120b657793ba, 0x97cff3c0b3f38cc1, 0xe93fdb53fbb74f84, 0x8fd01df2c21e1b46, 0x7dad1c74fe0d05fa,
  0x47ac398b016594cf, 0xff6608ebd1f3b57f, 0x0f2cf6c7d99e5403, 0x59bf0312b5ec1c7c, 0x00fa8301deb5e738,
  0xaa72f29b19c2de6f, 0x585ce31bc67440ae, 0xdb1248ab7b15545a, 0x5c9ab83cd84b997c, 0x598f207e50d1637c,
  0xc3def2861539fa9d, 0x4ff03f8cbf313ffb, 0xd17f81fbf619a1e6, 0xc6592e19e985f1a3, 0x6866587494b67c09,
  0x9319391014f257ee, 0x000000000000000f,
};

/*
 * m169_u1x12_uart0_noled_pr_ee_u4   m169a_u1x12_uart0_noled_pr_ee     m169a_u1x12_uart0_noled_pr_ee_u4
 * m169p_u1x12_uart0_noled_pr_ee     m169p_u1x12_uart0_noled_pr_ee_u4  m169pa_u1x12_uart0_noled_pr_ee
 * m169pa_u1x12_uart0_noled_pr_ee_u4 m165_u1x12_uart0_noled_pr_ee      m165_u1x12_uart0_noled_pr_ee_u4
 * m165a_u1x12_uart0_noled_pr_ee     m165a_u1x12_uart0_noled_pr_ee_u4  m165p_u1x12_uart0_noled_pr_ee
 * m165p_u1x12_uart0_noled_pr_ee_u4  m165pa_u1x12_uart0_noled_pr_ee    m165pa_u1x12_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m169_u1x12_uart0_noled_pr_ee[] = {
  0xbb686bc1a2447768, 0x77557cd636225bbb, 0x4d9711a7b42f7777, 0xd4cd0775228d75a1, 0x7df4e711bb0660bf,
  0x0482d95de4eebb25, 0xf9e059f60b304f8c, 0xdb53fbb74f848e1f, 0xab5a39c61b46e93f, 0xb30698fa8f2b9126,
  0x1143be2beebd47c1, 0xf4616588a459a75a, 0xb4bce2b8d64d2135, 0xf3a6edbda3c1673a, 0xe791871b1aad743a,
  0x0decb65cc5c24228, 0x1512a6951b047eb7, 0xe70b37e06256bd80, 0xcde01f50603bd6bc, 0x15d54e5e5363385b,
  0x8b4b0b9c6378ce88, 0x2f9b6249156f62aa, 0x6f8b9357079b0973, 0x53ab31e40fca1a2c, 0xff787bde50c2a73f,
  0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf, 0x013afa38a2029e4a,
};

/*
 * m169_u1x12_uart0_noled_pr_ce_u4   m169a_u1x12_uart0_noled_pr_ce     m169a_u1x12_uart0_noled_pr_ce_u4
 * m169p_u1x12_uart0_noled_pr_ce     m169p_u1x12_uart0_noled_pr_ce_u4  m169pa_u1x12_uart0_noled_pr_ce
 * m169pa_u1x12_uart0_noled_pr_ce_u4 m165_u1x12_uart0_noled_pr_ce      m165_u1x12_uart0_noled_pr_ce_u4
 * m165a_u1x12_uart0_noled_pr_ce     m165a_u1x12_uart0_noled_pr_ce_u4  m165p_u1x12_uart0_noled_pr_ce
 * m165p_u1x12_uart0_noled_pr_ce_u4  m165pa_u1x12_uart0_noled_pr_ce    m165pa_u1x12_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m169_u1x12_uart0_noled_pr_ce[] = {
  0x76d0d78344889202, 0xeeaae8778544b777, 0xd8f198bf4ddeeeee, 0xa0b8eeeef89791e9, 0x7599b62b22829905,
  0x827c602416caef27, 0x24e4ffcf02cfc879, 0x3749feda9fddba7c, 0x53b7f2e2fae490da, 0x8488bee24b1e78c9,
  0xfcc41fa8f84bf10d, 0x9633f5933c5dc6e3, 0xe9fc1eb3d4727a7b, 0xac398b0147ce9238, 0x6678ebd1f3b57f47,
  0xcb5b87d99e5403ff, 0x6fc0c4ad7b071f03, 0x3ea0c077ad79ce16, 0x9cbca6c670b79bc0, 0x1738c6f19d102baa,
  0x89218edec5551696, 0x4d5c1e6c25ccbe6d, 0xc7903f2868b1be2e, 0xef79430a9cfd4eac, 0xf81fc65f989ffde1,
  0xbfc0fdfb0cd0f327, 0x2c970cf4c2f8d1e8, 0x332c3a4a5b3e04e3, 0x9072880a792bf734, 0x00000000000006eb,
};

/*
 * m169a_u1x12_uart0_noled_pr_ee_ce  m169p_u1x12_uart0_noled_pr_ee_ce  m169pa_u1x12_uart0_noled_pr_ee_ce
 * m165_u1x12_uart0_noled_pr_ee_ce   m165a_u1x12_uart0_noled_pr_ee_ce  m165p_u1x12_uart0_noled_pr_ee_ce
 * m165pa_u1x12_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m169_u1x12_uart0_noled_pr_ee_ce[] = {
  0xb686bc1d41447705, 0x557eb0551625bbbb, 0xc90a67be47777777, 0x1ddfba4cf317aed2, 0x23b498695a295b3c,
  0x20b657793bb61b65, 0x78167c9d4c13e301, 0xd4feedd3e128adfe, 0xea8dfc86d1ba4ff6, 0x0ff3c64a9de043bf,
  0x3df309cee373acd9, 0xfea3cafa894ed656, 0x2b09fea3e0d9835a, 0x88a459a75a1140a6, 0xe9c4752135f46165,
  0x4ddb7b4782ce7576, 0x461c6c6abc6c75e7, 0xb2d973170908a39e, 0x254d2a3608991c37, 0x166fc0c4ad7b0b3a,
  0xc03ea0c077ad79ce, 0xaa9cbca6c670b79b, 0x961738c6f19d102b, 0x6d89218edec55516, 0x2e4d5c1e6c25ccbe,
  0x663c81f9434596af, 0x04e34a1854e7ea75, 0x2b93f01f343cc9fe, 0xb3e04e32c970cf4c, 0x92bf734332c3a4a5,
  0x0000027e631880a7,
};

/*
 * m169a_u1x12_uart0_noled_pr_ee_ce_u4 m169p_u1x12_uart0_noled_pr_ee_ce_u4
 * m169pa_u1x12_uart0_noled_pr_ee_ce_u4 m165_u1x12_uart0_noled_pr_ee_ce_u4
 * m165a_u1x12_uart0_noled_pr_ee_ce_u4 m165p_u1x12_uart0_noled_pr_ee_ce_u4
 * m165pa_u1x12_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u1x12_uart0_noled_pr_ee_ce_u4[] = {
  0x76d0d78344863375, 0xdd55de4392c4b777, 0x269619ea33dddddd, 0x58e3e3fbb63c9031, 0x2ad1bab9d1c7a750,
  0x8c0482d95de4ee96, 0xfff62bb3fbb5304f, 0xfeda9fddba7c2463, 0xe2faa390f0da3749, 0x892c79e50b838706,
  0xa3e12fc4361222fb, 0x678bb8dce8fa927e, 0xf2bea253b5b9b7be, 0x7fa8f83660d6bfa8, 0x1669d68450298ac2,
  0x1d484d7d18596229, 0xded1e0b39d5dba71, 0x1b1aaf1b1d79d376, 0x5cc5c24228e79187, 0x4a8d8226470decb6,
  0xf0312b5ec2ce8953, 0xa8301deb5e73859b, 0x2f29b19c2de6f00f, 0xce31bc67440aeaa7, 0x4863b7b15545a585,
  0x0dc79b09732f9b62, 0x5666fe0eee3458df, 0xf0f7bca1854e7ea7, 0x93fc0fe32fcc4ffe, 0xf45fe07efd866879,
  0x71964b867a617c68, 0x9a19961d252d9f02, 0xf9ec4f6e8b3c95fb, 0x0000000000000009,
};

/*
 * m169a_u1x12_uart0_noled_hw        m169p_u1x12_uart0_noled_hw        m169pa_u1x12_uart0_noled_hw
 * m168pb_u1x12_uart0_noled_hw       m165_u1x12_uart0_noled_hw         m165a_u1x12_uart0_noled_hw
 * m165p_u1x12_uart0_noled_hw        m165pa_u1x12_uart0_noled_hw
 */
static const uint64_t ur_m169_u1x12_uart0_noled_hw[] = {
  0xdddb435e0eb3753a, 0xbbbaabece56912dd, 0xd089154cd267bbbb, 0x3c7d83eeee859471, 0x793ba5c6c9ea9b62,
  0x38cc13e30120b657, 0x74f8497cffc38f3f, 0xe1b46e93fdb53fbb, 0xd05fa8fd01df2c21, 0x594cf7dad1c74fe0,
  0x3b57f47ac398b016, 0xe5403ff6608ebd1f, 0xc1c7c0f2cf6c7d99, 0x5e73859bf0312b5e, 0x2de6f00fa8301deb,
  0x440aeaa72f29b19c, 0x5545a585ce31bc67, 0xb997cdb1248ab7b1, 0xa615c9f9fd86ed84, 0x2d964a271964b867,
  0x3c95fb9a19961d25, 0x00000008e200bb05,
};

/*
 * m169a_u1x12_uart0_noled_ee_hw     m169p_u1x12_uart0_noled_ee_hw     m169pa_u1x12_uart0_noled_ee_hw
 * m168pb_u1x12_uart0_noled_ee_hw    m165_u1x12_uart0_noled_ee_hw      m165a_u1x12_uart0_noled_ee_hw
 * m165p_u1x12_uart0_noled_ee_hw     m165pa_u1x12_uart0_noled_ee_hw    pwm216_u1x12_uart0_noled_ee_hw
 * pwm316_u1x12_uart0_noled_ee_hw
 */
static const uint64_t ur_m169_u1x12_uart0_noled_ee_hw[] = {
  0xbb686bc1a243280b, 0x77557cd636225bbb, 0x429b2e3a34f77777, 0x7fa99a0eea451aeb, 0x939eb6b4e3760cc1,
  0x3e30120b657793bb, 0x8e1ffd0a67d82cc1, 0xe93fdb53fbb74f84, 0x9126ab5a39c61b46, 0x47c1b30698fa8f2b,
  0xa75a1143be2beebd, 0x2135f4616588a459, 0x673ab4bce2b8d64d, 0x743af3a6edbda3c1, 0x4228e791871b1aad,
  0x7eb70decb65cc5c2, 0xbd801512a6951b04, 0xd6bce70b37e06256, 0x385bcde01f50603b, 0xce8815d54e5e5363,
  0x62aa8b4b0b9c6378, 0x09732f9b6249156f, 0xc2a73f505d8dc79b, 0x97e627ff787bde50, 0x7ec3343cc9fe07f1,
  0x3d30be347a2ff03f, 0x9296cf8138cb25c3, 0xa29e4afdcd0ccb0e, 0x0000000002dfcaac,
};

/*
 * m169a_u1x12_uart0_noled_ce_hw     m169p_u1x12_uart0_noled_ce_hw     m169pa_u1x12_uart0_noled_ce_hw
 * m168pb_u1x12_uart0_noled_ce_hw    m165_u1x12_uart0_noled_ce_hw      m165a_u1x12_uart0_noled_ce_hw
 * m165p_u1x12_uart0_noled_ce_hw     m165pa_u1x12_uart0_noled_ce_hw
 */
static const uint64_t ur_m169_u1x12_uart0_noled_ce_hw[] = {
  0xbbb686bc1d66ef3a, 0xeeeaafb39e2e25bb, 0xfebc864f6a1eeeee, 0xdb26635f7776e270, 0xaef277417a09ac80,
  0x7dfc9827c602416c, 0x76e9f09195ff871e, 0xd24368dd27fb6a7f, 0xf3c64a071313bfeb, 0x9cc273b8dca95fbb,
  0xcfd4710f3dcb0171, 0x16e189f8e3a7f078, 0xb9da4151e33398b0, 0x1d3a7b8e58cf1d78, 0xe73859bf0312b5ec,
  0x5bcde5ba8301deb5, 0x6f55d54e5e536338, 0xf19d102e6cc6085a, 0xbb612e65f36d38c6, 0x2e19e985727e7f61,
  0x87494b659289c659, 0xaec14f257ee68665, 0x00000000000c4283,
};

/*
 * m169_u1x12_uart0_noled_ee_ce_u4_hw m169a_u1x12_uart0_noled_ee_ce_hw
 * m169a_u1x12_uart0_noled_ee_ce_u4_hw m169p_u1x12_uart0_noled_ee_ce_hw
 * m169p_u1x12_uart0_noled_ee_ce_u4_hw m169pa_u1x12_uart0_noled_ee_ce_hw
 * m169pa_u1x12_uart0_noled_ee_ce_u4_hw m168pb_u1x12_uart0_noled_ee_ce_hw
 * m168pb_u1x12_uart0_noled_ee_ce_u4_hw m165_u1x12_uart0_noled_ee_ce_hw
 * m165_u1x12_uart0_noled_ee_ce_u4_hw m165a_u1x12_uart0_noled_ee_ce_hw
 * m165a_u1x12_uart0_noled_ee_ce_u4_hw m165p_u1x12_uart0_noled_ee_ce_hw
 * m165p_u1x12_uart0_noled_ee_ce_u4_hw m165pa_u1x12_uart0_noled_ee_ce_hw
 * m165pa_u1x12_uart0_noled_ee_ce_u4_hw pwm216_u1x12_uart0_noled_ee_ce_hw
 * pwm216_u1x12_uart0_noled_ee_ce_u4_hw pwm316_u1x12_uart0_noled_ee_ce_hw
 * pwm316_u1x12_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u1x12_uart0_noled_ee_ce_hw[] = {
  0x76d0d78344864aa4, 0xdd55de4392c4b777, 0x269619ea33dddddd, 0x58e3e3fbb63c9031, 0x9962fb9f71c7a750,
  0xf180905b2bbc9dd4, 0x8fffd0a67f76a609, 0x27fb6a7f76e9f091, 0x1b8bea8e43c368dd, 0xee24b1e7942e0e1c,
  0xfa8f84bf10d8488b, 0x7ccf1771b8951723, 0x51e57d44a76b736f, 0x84ff51f06cc1ad7f, 0x522cd3ad08a05315,
  0xe23a909afa30b2c4, 0xedbda3c1673abb74, 0x0e36355e363af3a6, 0x6cb98b848451cf23, 0xa6951b044c8e1bd9,
  0x37e06256bd859d12, 0x1f50603bd6bce70b, 0x4e5e5363385bcde0, 0x0b9c6378ce8815d5, 0xc490c76f62aa8b4b,
  0xbb1b8f3612e65f36, 0xf0f7bca1854e7ea0, 0x93fc0fe32fcc4ffe, 0xf45fe07efd866879, 0x71964b867a617c68,
  0x9a19961d252d9f02, 0x280bd89f453c95fb,
};

/*
 * m169_u1x12_uart0_lednop_pr        m169a_u1x12_uart0_lednop          m169a_u1x12_uart0_lednop_pr
 * m169p_u1x12_uart0_lednop          m169p_u1x12_uart0_lednop_pr       m169pa_u1x12_uart0_lednop
 * m169pa_u1x12_uart0_lednop_pr      m165_u1x12_uart0_lednop           m165_u1x12_uart0_lednop_pr
 * m165a_u1x12_uart0_lednop          m165a_u1x12_uart0_lednop_pr       m165p_u1x12_uart0_lednop
 * m165p_u1x12_uart0_lednop_pr       m165pa_u1x12_uart0_lednop         m165pa_u1x12_uart0_lednop_pr
 */
static const uint64_t ur_m169_u1x12_uart0_lednop[] = {
  0xbbb686bc1d66ef3a, 0xeeeaafb385ee25bb, 0xcfddf87f7d2eeeee, 0xeb4bf37776442226, 0x277417a0998b21c7,
  0x49827c602416caef, 0x3e12f93fdfa1e7c1, 0x6d1ba4ff6d4feedd, 0x49ea393c77cb2438, 0xd30f9d2471d3f833,
  0xd7c8e414e62c05bd, 0xbdc72c608ebc5cec, 0xb37e06256bd8560f, 0x0603bd6bcf020270, 0x3929d002de6f3645,
  0x6f19d103be54dea5, 0x56f62aa8b4d5d38c, 0x6ed84b997cdb7391, 0x98f2068fe3458f38, 0xb25c33d30ae4fdd5,
  0xcb0e9296cb25138c, 0x396b8f9e4afdcd0c, 0x000000000000f900,
};

/*
 * m169a_u1x12_uart0_lednop_pr_u4    m169p_u1x12_uart0_lednop_pr_u4    m169pa_u1x12_uart0_lednop_pr_u4
 * m165_u1x12_uart0_lednop_pr_u4     m165a_u1x12_uart0_lednop_pr_u4    m165p_u1x12_uart0_lednop_pr_u4
 * m165pa_u1x12_uart0_lednop_pr_u4
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_pr_u4[] = {
  0xbb686bc1a2447f82, 0xeeaafb38ebe25bbb, 0x425f85c76a1eeeee, 0x4c9eeee859471d69, 0x5c62454dc1b267e9,
  0x9f180905b2bbc9dd, 0xa5f7f9e059f3d660, 0xe93fdb53fbb74f84, 0x8f6b1df2c21e1b46, 0x483f1c74fe0d05fa,
  0x3486731602cb29be, 0xfb30475e8f9d967a, 0x7967b682cd22a01f, 0xcdf81895af6415a0, 0x180ef5af3c0809c2,
  0xe4a7400b79bcd914, 0xbc67440ef9537a94, 0x5bd8aaa2d3574e31, 0xf3612e65f36dce45, 0xf943458df1726ae0,
  0x1854e7ea75663c81, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe, 0x67a617c68f45fe07, 0xd252d9f0271964b8,
  0x4053c95fb9a19961, 0x000000007c983c9c,
};

/*
 * m169_u1x12_uart0_lednop_pr_ee_u4  m169a_u1x12_uart0_lednop_pr_ee    m169a_u1x12_uart0_lednop_pr_ee_u4
 * m169p_u1x12_uart0_lednop_pr_ee    m169p_u1x12_uart0_lednop_pr_ee_u4 m169pa_u1x12_uart0_lednop_pr_ee
 * m169pa_u1x12_uart0_lednop_pr_ee_u4 m165_u1x12_uart0_lednop_pr_ee
 * m165_u1x12_uart0_lednop_pr_ee_u4  m165a_u1x12_uart0_lednop_pr_ee    m165a_u1x12_uart0_lednop_pr_ee_u4
 * m165p_u1x12_uart0_lednop_pr_ee    m165p_u1x12_uart0_lednop_pr_ee_u4 m165pa_u1x12_uart0_lednop_pr_ee
 * m165pa_u1x12_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_pr_ee[] = {
  0xbb686bc1a2447705, 0xeeaaf9ad8be25bbb, 0x5a331a0ba106eeee, 0xf53341dd48a35cd8, 0x65791498d2cfde3b,
  0x0120b657793bb61b, 0xfe78167f2b4c13e3, 0xf6d4feedd3e12287, 0xaad68e7186d1ba4f, 0x6cc1a63ea3cacca9,
  0x08a1df1587bf51f0, 0xfa30b2c4522cd3ad, 0x5a5cf55c6b26909a, 0xbce9bb4648c9a39d, 0x09e46f6ac6ab5d0e,
  0xc37b2d973170908a, 0x087d99e546c11fad, 0x13859bf0312b5ec0, 0xb228301deb5e7810, 0xf529c94e8016f379,
  0x9c6378ce881df2a6, 0x9c8ab7b15545a6ae, 0xd5c1e6c25ccbe6db, 0x7903f2868b1be2e4, 0xf79430a9cfd4eacc,
  0x81fc65f989ffde1e, 0xfc0fdfb0cd0f327f, 0xc970cf4c2f8d1e8b, 0x32c3a4a5b3e04e32, 0xcdb880a792bf7343,
  0x0000000000004ebb,
};

/*
 * m169_u1x12_uart0_lednop_pr_ce_u4  m169a_u1x12_uart0_lednop_pr_ce    m169a_u1x12_uart0_lednop_pr_ce_u4
 * m169p_u1x12_uart0_lednop_pr_ce    m169p_u1x12_uart0_lednop_pr_ce_u4 m169pa_u1x12_uart0_lednop_pr_ce
 * m169pa_u1x12_uart0_lednop_pr_ce_u4 m165_u1x12_uart0_lednop_pr_ce
 * m165_u1x12_uart0_lednop_pr_ce_u4  m165a_u1x12_uart0_lednop_pr_ce    m165a_u1x12_uart0_lednop_pr_ce_u4
 * m165p_u1x12_uart0_lednop_pr_ce    m165p_u1x12_uart0_lednop_pr_ce_u4 m165pa_u1x12_uart0_lednop_pr_ce
 * m165pa_u1x12_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_pr_ce[] = {
  0xbb686bc1a24458e2, 0x7755743b41225bbb, 0xe98db867ad2f7777, 0xc663bbbbe25e4c29, 0xd29c3d8d29d60666,
  0x09f180905b2bbc9d, 0x93a5ff3c0b3e52e6, 0xdd27fb6a7f76e9f0, 0x9dd4ab8beb924368, 0x2445f71258f3c64a,
  0xfc00fd47c25f886c, 0x633f5933c5dc6e56, 0x9fc1eb3d47e927b9, 0x3398b0153111638e, 0x9e3af47cecb3d1a4,
  0xd6e416691500ffd9, 0xf0312b5ec82b40f2, 0x1deb5e781013859b, 0x4e8016f379b22830, 0xce881df2a6f529c9,
  0xb15545a6ae9c6378, 0x84b997cdb73863b7, 0x0d1637c5c9ab83cd, 0x539fa9d598f207e5, 0xf313ffbc3def2861,
  0x619a1e64ff03f8cb, 0x985f1a3d17f81fbf, 0x4b67c09c6592e19e, 0x4f257ee686658749, 0x000000dd71539101,
};

/*
 * m169a_u1x12_uart0_lednop_pr_ee_ce m169p_u1x12_uart0_lednop_pr_ee_ce m169pa_u1x12_uart0_lednop_pr_ee_ce
 * m165_u1x12_uart0_lednop_pr_ee_ce  m165a_u1x12_uart0_lednop_pr_ee_ce m165p_u1x12_uart0_lednop_pr_ee_ce
 * m165pa_u1x12_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_pr_ee_ce[] = {
  0xdb435e0ea0a22044, 0xaabf58223f12dddd, 0xec82c1de9dbbbbbb, 0x0eefdd26798d457a, 0x8c8843312b8cdd9e,
  0x905b2bbc9dd4149c, 0x78167e87e609f180, 0xd4feedd3e12383fe, 0xea8dfc86d1ba4ff6, 0x2bf3c64a9defb3bf,
  0x3df309cee372e449, 0xfea3cafba94ed656, 0x2bdbfea3e0d9835a, 0x88a459a75a1140a6, 0xe3d4752135f46165,
  0xa6ed1923268e7576, 0x237b56355e363af3, 0xd96cb98b8484504f, 0xf667951b044c8e1b, 0x166fc0c4ad7b0b31,
  0xa0c077ad79e0404e, 0xa7253a005bcde6c8, 0x8de33a2077ca9bd4, 0x8edec555169aba71, 0x0f3612e65f36dce1,
  0xfca1a2cb579726ae, 0x0c2a73f53ab31e40, 0x0f9a1e64ff0271a5, 0x1964b867a615c9f8, 0xa19961d252d9f027,
  0x7e610c4053c95fb9, 0x0000000000000002,
};

/*
 * m169a_u1x12_uart0_lednop_pr_ee_ce_u4 m169p_u1x12_uart0_lednop_pr_ee_ce_u4
 * m169pa_u1x12_uart0_lednop_pr_ee_ce_u4 m165_u1x12_uart0_lednop_pr_ee_ce_u4
 * m165a_u1x12_uart0_lednop_pr_ee_ce_u4 m165p_u1x12_uart0_lednop_pr_ee_ce_u4
 * m165pa_u1x12_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_pr_ee_ce_u4[] = {
  0xbb686bc1a243304a, 0xeeaaef212ee25bbb, 0x531342f7276eeeee, 0x8c71f1fddb1e4872, 0xd47dd9201b82246c,
  0x602416caef2776c5, 0x7fd8aecfe9a9827c, 0xfdb53fbb74f84bfe, 0xc5f54721e1b46e93, 0x1258f3ca170712d5,
  0x47c25f886c2445f7, 0x9e2ee370112601fd, 0xcafba94ed6e6def9, 0xfea3e0d9835afea3, 0x59a75a1140a62bdb,
  0x752135f4616588a4, 0x1923268e7576e3d4, 0x56355e363af3a6ed, 0xb98b8484504f237b, 0x951b044c8e1bd96c,
  0xc0c4ad7b0b31f667, 0x77ad79e0404e166f, 0x3a005bcde6c8a0c0, 0x3a2077ca9bd4a725, 0xc555169aba718de3,
  0x12e65f36dce18ede, 0x1ddc68b1be1b8f36, 0x430a9cfd4eaccdfc, 0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f,
  0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97, 0xdd16792bf734332c, 0x0000000009f929ac,
};

/*
 * m169a_u1x12_uart0_lednop_hw       m169p_u1x12_uart0_lednop_hw       m169pa_u1x12_uart0_lednop_hw
 * m168pb_u1x12_uart0_lednop_hw      m165_u1x12_uart0_lednop_hw        m165a_u1x12_uart0_lednop_hw
 * m165p_u1x12_uart0_lednop_hw       m165pa_u1x12_uart0_lednop_hw
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_hw[] = {
  0x776d0d783acdc49f, 0xddd55f671d7c4b77, 0xad284bf3600ddddd, 0xfd2993dddd0b28e3, 0xde4eee62486ad04c,
  0x9eb304f8c0482d95, 0xba7c252fbff0e3cf, 0xf0da3749feda9fdd, 0x682fd47b58ef9610, 0x594df241f8e3a7f0,
  0xecb3d1a43398b016, 0x1500ffd9823af47c, 0x20ad03cb3db41669, 0x404e166fc0c4ad7b, 0xe6c8a0c077ad79e0,
  0x9bd4a7253a005bcd, 0xba718de33a2077ca, 0x6e722adec555169a, 0xf3fb0ddb09732f9b, 0x4e32c970cf4c2b93,
  0x34332c3a4a5b2c94, 0x08e2b7760a792bf7,
};

/*
 * m169a_u1x12_uart0_lednop_ee_hw    m169p_u1x12_uart0_lednop_ee_hw    m169pa_u1x12_uart0_lednop_ee_hw
 * m168pb_u1x12_uart0_lednop_ee_hw   m165_u1x12_uart0_lednop_ee_hw     m165a_u1x12_uart0_lednop_ee_hw
 * m165p_u1x12_uart0_lednop_ee_hw    m165pa_u1x12_uart0_lednop_ee_hw   pwm216_u1x12_uart0_lednop_ee_hw
 * pwm316_u1x12_uart0_lednop_ee_hw
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_ee_hw[] = {
  0xddb435e0d1218375, 0x77557cd6c5f12ddd, 0xb0b4663b41777777, 0x77ea6683ba9146b9, 0xc0b015ad89a59fbc,
  0x4f8c0482d95de4ee, 0x2287ff4299fcad30, 0xba4ff6d4feedd3e1, 0xcca9aad68e7186d1, 0x51f06cc1a63ea3ca,
  0xd3ad08a1df1587bf, 0x909afa30b2c4522c, 0xa39d5a5cf55c6b26, 0x5d0ebce9bb4648c9, 0x908a09e46f6ac6ab,
  0x1fadc37b2d973170, 0x5ec0087d99e546c1, 0x781013859bf0312b, 0xf379b228301deb5e, 0xf2a6f529c94e8016,
  0xa6ae9c6378ce881d, 0xe6db9c8ab7b15545, 0xd4176371e6c25ccb, 0xffde1ef79430a9cf, 0x0f327f81fc65f989,
  0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3, 0x0000b7cc1ca8a792,
};

/*
 * m169a_u1x12_uart0_lednop_ce_hw    m169p_u1x12_uart0_lednop_ce_hw    m169pa_u1x12_uart0_lednop_ce_hw
 * m168pb_u1x12_uart0_lednop_ce_hw   m165_u1x12_uart0_lednop_ce_hw     m165a_u1x12_uart0_lednop_ce_hw
 * m165p_u1x12_uart0_lednop_ce_hw    m165pa_u1x12_uart0_lednop_ce_hw
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_ce_hw[] = {
  0xeeeda1af0759bb37, 0xdddd55f672b4896e, 0x1fda1377ef8fdddd, 0x401b6f8feeeedc4e, 0xcaef2776c7b21a6c,
  0xcfc069827c602416, 0xddba7c241efff0e3, 0xf490da3749feda9f, 0xfcf19281c884effa, 0x67309cee370a2b93,
  0x33f51ebfcf72c05c, 0x02dad52e38e9fc1e, 0xc5cec3ed1d127316, 0xc1d29adc72c678eb, 0x1013859bf0312b5e,
  0x02de6f301deb5e78, 0x7c05a9c914b579d0, 0x9d1032fe63042d2a, 0x612e65f36d38c6f1, 0x19e985727e7f61bb,
  0x494b659289c6592e, 0xc14f257ee6866587, 0x0000000018853ebe,
};

/*
 * m169_u1x12_uart0_lednop_ee_ce_u4_hw m169a_u1x12_uart0_lednop_ee_ce_hw
 * m169a_u1x12_uart0_lednop_ee_ce_u4_hw m169p_u1x12_uart0_lednop_ee_ce_hw
 * m169p_u1x12_uart0_lednop_ee_ce_u4_hw m169pa_u1x12_uart0_lednop_ee_ce_hw
 * m169pa_u1x12_uart0_lednop_ee_ce_u4_hw m168pb_u1x12_uart0_lednop_ee_ce_hw
 * m168pb_u1x12_uart0_lednop_ee_ce_u4_hw m165_u1x12_uart0_lednop_ee_ce_hw
 * m165_u1x12_uart0_lednop_ee_ce_u4_hw m165a_u1x12_uart0_lednop_ee_ce_hw
 * m165a_u1x12_uart0_lednop_ee_ce_u4_hw m165p_u1x12_uart0_lednop_ee_ce_hw
 * m165p_u1x12_uart0_lednop_ee_ce_u4_hw m165pa_u1x12_uart0_lednop_ee_ce_hw
 * m165pa_u1x12_uart0_lednop_ee_ce_u4_hw pwm216_u1x12_uart0_lednop_ee_ce_hw
 * pwm216_u1x12_uart0_lednop_ee_ce_u4_hw pwm316_u1x12_uart0_lednop_ee_ce_hw
 * pwm316_u1x12_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u1x12_uart0_lednop_ee_ce_hw[] = {
  0x76d0d783448607e1, 0xdd55de425dc4b777, 0xa62685ee4edddddd, 0x18e3e3fbb63c90e4, 0x87bf7a3af70448d9,
  0xf180905b2bbc9dd0, 0xff3fe8533fa6a609, 0x49feda9fddba7c25, 0x6ae2faa390f0da37, 0xfb892c79e50b8389,
  0x7ea3e12fc4361222, 0xdf33c5dc6e525339, 0xd4795f7529dadcdb, 0x7b7fd47c1b306b5f, 0x148b34eb422814c5,
  0x7a8ea426be8c2cb1, 0xdda32464d1ceaedc, 0x6f6ac6abc6c75e74, 0x2d973170908a09e4, 0xccf2a3608991c37b,
  0xcdf81895af61663e, 0x180ef5af3c0809c2, 0xe4a7400b79bcd914, 0xbc67440ef9537a94, 0xdbd8aaa2d3574e31,
  0xe6c25ccbe6db9c31, 0x9430a9cfd4176371, 0xfc65f989ffde1ef7, 0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc,
  0xc3a4a5b3e04e32c9, 0x35a8a792bf734332, 0x00000000000280a5,
};

/*
 * m169a_u1x12_uart0_dual            m169p_u1x12_uart0_dual            m169pa_u1x12_uart0_dual
 * m165_u1x12_uart0_dual             m165a_u1x12_uart0_dual            m165p_u1x12_uart0_dual
 * m165pa_u1x12_uart0_dual
 */
static const uint64_t ur_m169_u1x12_uart0_dual[] = {
  0x77774c9f37d44511, 0xeeeeedf90044e36b, 0x06dc1e9c02b5b16e, 0xec8a7191dddd3f61, 0x92c83b95f33ed2c4,
  0x1cc13e30120b6577, 0x1bbada0644a4a432, 0xf8971030a1836918, 0xe6f9df995c7ae774, 0x7a8ebef60514e0e4,
  0x08a11c913f838f73, 0xb87c2886257f9fbe, 0x955ddeef9b870401, 0x6f7150865a03e221, 0x12dbc06ffa039e13,
  0xffd2024c161bcaf2, 0xfeda9fddba7c2413, 0x14ef96aff0da3749, 0x48e3a7f0690fd471, 0xa398b017f0e64c7a,
  0x823af22dd9af91bd, 0xb8a929583ef71cb1, 0x0312b5ec9fc55f3b, 0xdeb5e781013859bf, 0x3a005bcde5ba8301,
  0x4e02f7ca9bd4a725, 0x1bc674408ea2810b, 0x83cd84b997cdb4e3, 0xd30ae4fcfec5c9ab, 0x296cf8138cb25c33,
  0x29e4afdcd0ccb0e9, 0x0000000196fdba20,
};

/*
 * m169_u1x12_uart0_dual_pr_u4       m169a_u1x12_uart0_dual_pr         m169a_u1x12_uart0_dual_pr_u4
 * m169p_u1x12_uart0_dual_pr         m169p_u1x12_uart0_dual_pr_u4      m169pa_u1x12_uart0_dual_pr
 * m169pa_u1x12_uart0_dual_pr_u4     m165_u1x12_uart0_dual_pr          m165_u1x12_uart0_dual_pr_u4
 * m165a_u1x12_uart0_dual_pr         m165a_u1x12_uart0_dual_pr_u4      m165p_u1x12_uart0_dual_pr
 * m165p_u1x12_uart0_dual_pr_u4      m165pa_u1x12_uart0_dual_pr        m165pa_u1x12_uart0_dual_pr_u4
 */
static const uint64_t ur_m169_u1x12_uart0_dual_pr[] = {
  0xdd327cde890c365a, 0xbbb7e400028daddd, 0x58a75c1dfb5bbbbb, 0x828c8eeeebd734af, 0xb89bbeb9629b41ec,
  0xc602416caef24ddb, 0x40c8949486439827, 0x0614306d2303775b, 0xff32addcee9f12e2, 0x2b6c1d29c0e1cc52,
  0x39227f0752a6f51d, 0x510c4aff3f7c1142, 0x7bbe6e58f80370f8, 0x4219687c88865577, 0x01bfe80e784c3e45,
  0xaf30586f2bc84b6f, 0x3fbb74f84827ffb9, 0x9626a1b46e93fdb5, 0x4fe0c43fa8f914ef, 0x602a83cd38bdf1c7,
  0xe00ced6b23afe731, 0x1d21aa01ffb30475, 0x8a92a93a07967b62, 0x312b5ec9fc55f3bb, 0xeb5e781013859bf0,
  0x8016f379b228301d, 0x881df2a6f529c94e, 0x5545a6ae9c6378ce, 0x5ccbe6db9c8ab7b1, 0xbb8d1637c371e6c2,
  0x61539fa9d599bf83, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1,
  0xa2cf257ee6866587, 0x0000000524c202db,
};

/*
 * m169_u1x12_uart0_dual_pr_ee_u4    m169a_u1x12_uart0_dual_pr_ee      m169a_u1x12_uart0_dual_pr_ee_u4
 * m169p_u1x12_uart0_dual_pr_ee      m169p_u1x12_uart0_dual_pr_ee_u4   m169pa_u1x12_uart0_dual_pr_ee
 * m169pa_u1x12_uart0_dual_pr_ee_u4  m165_u1x12_uart0_dual_pr_ee       m165_u1x12_uart0_dual_pr_ee_u4
 * m165a_u1x12_uart0_dual_pr_ee      m165a_u1x12_uart0_dual_pr_ee_u4   m165p_u1x12_uart0_dual_pr_ee
 * m165p_u1x12_uart0_dual_pr_ee_u4   m165pa_u1x12_uart0_dual_pr_ee     m165pa_u1x12_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m169_u1x12_uart0_dual_pr_ee[] = {
  0xddd327cde890cf68, 0xbbbb7e2d1738dadd, 0x179579cedae3bbbb, 0xcfb3134bbaccda75, 0xf53af70dd889ea3e,
  0x20b6577928eddcd1, 0x29291c3fcc13e301, 0x60da4606eeb68191, 0x5bb9dd3e25c40c28, 0x7fc380689b4d7e65,
  0xf83a1f9bd47b1fd8, 0x57f9fbe08a11c913, 0x72e4401b87c28862, 0x83a54432abbbddf3, 0x01cf098a2c542196,
  0x1bcaf212dbf57ffd, 0x3e12df7fee6bcc16, 0x6d1ba4ff6d4feedd, 0x795afb9aad68e448, 0x95ea3e0d983053d4,
  0x459a75a1143be2ba, 0x5cd2135f4616588a, 0x7bd9cead2e652e2a, 0x55ae875ea25da214, 0x5c242281151f3d63,
  0x608fd6e1bd97d2cc, 0xee2a4a0109fd62a3, 0xc0c4ad7b27f157ce, 0x77ad79e0404e166f, 0x3a005bcde6c8a0c0,
  0x3a2077ca9bd4a725, 0xc555169aba718de3, 0x09732f9b6e722ade, 0x0eee3458df0dc79b, 0xa1854e7ea75666fe,
  0xe32fcc4ffef0f7bc, 0x7efd86687993fc0f, 0x867a617c68f45fe0, 0x1d252d9f0271964b, 0x6e8b3c95fb9a1996,
  0x0000000000564e9e,
};

/*
 * m169_u1x12_uart0_dual_pr_ce_u4    m169a_u1x12_uart0_dual_pr_ce      m169a_u1x12_uart0_dual_pr_ce_u4
 * m169p_u1x12_uart0_dual_pr_ce      m169p_u1x12_uart0_dual_pr_ce_u4   m169pa_u1x12_uart0_dual_pr_ce
 * m169pa_u1x12_uart0_dual_pr_ce_u4  m165_u1x12_uart0_dual_pr_ce       m165_u1x12_uart0_dual_pr_ce_u4
 * m165a_u1x12_uart0_dual_pr_ce      m165a_u1x12_uart0_dual_pr_ce_u4   m165p_u1x12_uart0_dual_pr_ce
 * m165p_u1x12_uart0_dual_pr_ce_u4   m165pa_u1x12_uart0_dual_pr_ce     m165pa_u1x12_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m169_u1x12_uart0_dual_pr_ce[] = {
  0x774c9f37a2431f02, 0xbbb7e3d3dfb36b77, 0x5cb12bed403bbbbb, 0x179cedddd89c6eac, 0x5188b36842614ad5,
  0x80905b2bbc98e2ee, 0xc894948185e609f1, 0x14306d2303775b40, 0x32addcee9f12e206, 0xb00b47031f9866ff,
  0x89fc18d69bd474b5, 0x312bfcfdf04508e4, 0xf9b8cf800dc3e144, 0xcb40a2a21955ddee, 0xfe80e784c63e2a10,
  0x0586f2bc84b6f15b, 0xb74f84982ffb9af3, 0x021b46e93fdb53fb, 0x3ca17071d2dc5f54, 0xf886c2445f71258f,
  0xc6e0a4fd7fd47c25, 0xf9ee58cfa9733c5d, 0x471d3f83a97ea38d, 0x23afe7316028283e, 0xffb33c75e00ced6b,
  0x81e5adc21d21aa01, 0x7f157ceee2a4aa4e, 0x04e166fc0c4ad7b2, 0x6c8a0c077ad79e04, 0xbd4a7253a005bcde,
  0xa718de33a2077ca9, 0xce18edec555169ab, 0xe1b8f3612e65f36d, 0xeaccdfc1ddc68b1b, 0xde1ef79430a9cfd4,
  0x327f81fc65f989ff, 0x1e8bfc0fdfb0cd0f, 0x4e32c970cf4c2f8d, 0x734332c3a4a5b3e0, 0x6925594dd16792bf,
};

/*
 * m169a_u1x12_uart0_dual_pr_ee_ce   m169p_u1x12_uart0_dual_pr_ee_ce   m169pa_u1x12_uart0_dual_pr_ee_ce
 * m165_u1x12_uart0_dual_pr_ee_ce    m165a_u1x12_uart0_dual_pr_ee_ce   m165p_u1x12_uart0_dual_pr_ee_ce
 * m165pa_u1x12_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m169_u1x12_uart0_dual_pr_ee_ce[] = {
  0x7774c9f37d43573e, 0xeeeedf85c49b36b7, 0xd9beec75f47e6eee, 0xaaf2b7707747b1ce, 0xbeec2bdeb2bdc03e,
  0x20b657792d39dcb8, 0x29290e9d4c13e301, 0x60da4606eeb68191, 0x5bb9dd3e25c40c28, 0x290e1faf31adfe65,
  0xf076b737a8f00360, 0xaff3f7c114239227, 0xceeb00370f8510c4, 0x1a6d10caaeef77cd, 0x073c26c09150865a,
  0x6f2bc84b6f3b7ff4, 0xf0974fffb9af3058, 0x68dd27fb6a7f76e9, 0x0e0d63bfea8dc9c3, 0xc6e5e1f2d7e7942e,
  0x929dacac9ba6139d, 0xe0d9835f3d4795bf, 0x5a1140a62b80dea3, 0x35f4616588a459a7, 0xdece7576e3287521,
  0x5e363af512ed10a3, 0xc242281151f3d635, 0x044c8e1bd97d2cc5, 0x715252cc4feb151b, 0x06256bd93f8abe77,
  0xbd6bcf020270b37e, 0xd002de6f36450603, 0xd103be54dea53929, 0x2aa8b4d5d38c6f19, 0x9732f9b6e70c76f6,
  0xddc68b1e70dc79b0, 0xe985727eeaccdfc1, 0x94b67c09c6592e19, 0x2cf257ee68665874, 0x0000001304b1fdba,
};

/*
 * m169a_u1x12_uart0_dual_pr_ee_ce_u4 m169p_u1x12_uart0_dual_pr_ee_ce_u4
 * m169pa_u1x12_uart0_dual_pr_ee_ce_u4 m165_u1x12_uart0_dual_pr_ee_ce_u4
 * m165a_u1x12_uart0_dual_pr_ee_ce_u4 m165p_u1x12_uart0_dual_pr_ee_ce_u4
 * m165pa_u1x12_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u1x12_uart0_dual_pr_ee_ce_u4[] = {
  0xd327cde8adbba812, 0xdbf2c9df5cdadddd, 0x35eaf7ab8bdddddd, 0xbadd2d59f6d3dee1, 0xfda3337609932829,
  0xfda7707d7e0e5dd9, 0x304f8c0482d95de4, 0x75b40c894948f3d7, 0x2e20614306d23037, 0x495f99696fcee9f1,
  0xecf9b0eb338321cd, 0x239227f066b737a8, 0x8510c4aff3f7c114, 0xef77cdcea700370f, 0x50865a016910caae,
  0xfafff4073c263831, 0xc330586f2bc84b6f, 0xfeedd3e127f9ff8f, 0x1a9e86d1ba4ff6d4, 0xcf285e76337717d5,
  0x7e21b09117dc4963, 0x373541e41ff51f09, 0x94ed6e6e6e99e2ee, 0x06cc1af9ea3cadfc, 0xd08a05315c06f51f,
  0xafa30b2c4522cd3a, 0xf673abb71943a909, 0xf1b1d7a89768851e, 0x1211408a8f9eb1aa, 0x226470decbe9662e,
  0x8a9296627f58a8d8, 0x312b5ec9fc55f3bb, 0xeb5e781013859bf0, 0x8016f379b228301d, 0x881df2a6f529c94e,
  0x5545a6ae9c6378ce, 0xb997cdb73863b7b1, 0x1637c5c9ab83cd84, 0xf53ab337f07edd8d, 0x7ff787bde50c2a73,
  0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c, 0x00800cb4be46e9e4,
};

/*
 * m169a_u1x12_uart0_dual_hw         m169p_u1x12_uart0_dual_hw         m169pa_u1x12_uart0_dual_hw
 * m165_u1x12_uart0_dual_hw          m165a_u1x12_uart0_dual_hw         m165p_u1x12_uart0_dual_hw
 * m165pa_u1x12_uart0_dual_hw
 */
static const uint64_t ur_m169_u1x12_uart0_dual_hw[] = {
  0xee993e6f44861a4e, 0xdddbf2000146d6ee, 0xac53ae0efdaddddd, 0x4146477775eb9a57, 0xdbb935dc2f7dc0f6,
  0x27c602416caef24d, 0x5b40c89494864398, 0xe20614306d230377, 0x52ff32addcee9f12, 0x1d2b6c1d29c0e1cc,
  0x4239227f0752a6f5, 0xf8510c4aff3f7c11, 0x777bbe6e58f80370, 0x454219687c888655, 0x6f01bfe80e784c3e,
  0xf52330586f2bc84b, 0x6a7f76e9f0904fff, 0xdf2c4d4368dd27fb, 0x8e9fc1887f51f229, 0x62c055079a717be3,
  0xebc019dad6475fce, 0xc43a435403ff6608, 0x77152552740f2cf6, 0xe06256bd93f8abe7, 0x3bd6bcf020270b37,
  0x9d002de6f3645060, 0x9d103be54dea5392, 0x62aa8b4d5d38c6f1, 0x84b997cdb739156f, 0x61539fa82ec6e3cd,
  0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0xd14f257ee6866587,
  0x0000000031ba8405,
};

/*
 * m169a_u1x12_uart0_dual_ee_hw      m169p_u1x12_uart0_dual_ee_hw      m169pa_u1x12_uart0_dual_ee_hw
 * m165_u1x12_uart0_dual_ee_hw       m165a_u1x12_uart0_dual_ee_hw      m165p_u1x12_uart0_dual_ee_hw
 * m165pa_u1x12_uart0_dual_ee_hw
 */
static const uint64_t ur_m169_u1x12_uart0_dual_ee_hw[] = {
  0x774c9f37a2435202, 0xeeedf8b45ce36b77, 0x5e55e73b6b8eeeee, 0x3ecc4d2eeb3369d4, 0x0eb69be6ba27a8fb,
  0x482d95de4a3b7739, 0x4a4a470ff304f8c0, 0x18369181bbada064, 0x56ee774f8971030a, 0x1ff0e01a26d35f99,
  0xfe0e87e6f51ec7f6, 0x95fe7ef822847244, 0xdcb91006e1f0a218, 0xa0e9510caaeef77c, 0x4073c2628b150865,
  0x86f2bc84b6fd5fff, 0x9f096fbfff523305, 0x368dd27fb6a7f76e, 0x3cad7dcd56b47224, 0x4af51f06cc1829ea,
  0x22cd3ad08a1df15d, 0x2e6909afa30b2c45, 0x3dece75697329715, 0xaad743af512ed10a, 0x2e1211408a8f9eb1,
  0xb047eb70decbe966, 0x7715250084feb151, 0xe06256bd93f8abe7, 0x3bd6bcf020270b37, 0x9d002de6f3645060,
  0x9d103be54dea5392, 0x62aa8b4d5d38c6f1, 0x84b997cdb739156f, 0x61539fa82ec6e3cd, 0xcbf313ffbc3def28,
  0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0x514f257ee6866587, 0x0000000000aed74f,
};

/*
 * m169a_u1x12_uart0_dual_ce_hw      m169p_u1x12_uart0_dual_ce_hw      m169pa_u1x12_uart0_dual_ce_hw
 * m165_u1x12_uart0_dual_ce_hw       m165a_u1x12_uart0_dual_ce_hw      m165p_u1x12_uart0_dual_ce_hw
 * m165pa_u1x12_uart0_dual_ce_hw
 */
static const uint64_t ur_m169_u1x12_uart0_dual_ce_hw[] = {
  0xee993e6f448618be, 0x776fc7a7bf66d6ee, 0xb96257da80777777, 0x2f39dbbbb138dd58, 0xbbbaf6705af055aa,
  0x7c602416caef2638, 0xd032252520617982, 0x81850c1b48c0ddd6, 0xbfccab773ba7c4b8, 0x2d6c02d1c0c7e619,
  0x39227f0635a6f51d, 0x510c4aff3f7c1142, 0x7bbe6e33e00370f8, 0x8432d028a8865577, 0x56ffa039e1318f8a,
  0x8cc161bcaf212dbc, 0xfddba7c24c17ffd4, 0xaa010da3749feda9, 0xc79e50b838e96e2f, 0x12fc4361222fb892,
  0x1771b8ff3107ea3e, 0xe37e7b9633ea5ccf, 0x0f91c74fe0ea5fa8, 0x5ac8ebf9cc580a0a, 0x807feccf1d78033b,
  0x93a0796b7087486a, 0xec9fc55f3bb8a92a, 0x81013859bf0312b5, 0x379b228301deb5e7, 0x2a6f529c94e8016f,
  0x6ae9c6378ce881df, 0xdb73863b7b15545a, 0x82ec6e3cd84b997c, 0xfbc3def2861539fa, 0xe64ff03f8cbf313f,
  0xa3d17f81fbf619a1, 0x09c6592e19e985f1, 0xee6866587494b67c, 0x0026eb565514f257,
};

/*
 * m169a_u1x12_uart0_dual_ee_ce_hw   m169p_u1x12_uart0_dual_ee_ce_hw   m169pa_u1x12_uart0_dual_ee_ce_hw
 * m165_u1x12_uart0_dual_ee_ce_hw    m165a_u1x12_uart0_dual_ee_ce_hw   m165p_u1x12_uart0_dual_ee_ce_hw
 * m165pa_u1x12_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m169_u1x12_uart0_dual_ee_ce_hw[] = {
  0x74c9f37d4143359b, 0xeedf85c49b36b777, 0xbeec75f47e6eeeee, 0xf2b7707747b1ced9, 0x330a6b5d7dc03eaa,
  0x20b657792d39dc3c, 0x29290e9d4c13e301, 0x60da4606eeb68191, 0x5bb9dd3e25c40c28, 0x290e1faf31adfe65,
  0xf076b737a8f00360, 0xaff3f7c114239227, 0xceeb00370f8510c4, 0x1a6d10caaeef77cd, 0x073c26c09150865a,
  0x6f2bc84b6f3b7ff4, 0xe12e9ffff5233058, 0xd1ba4ff6d4feedd3, 0x1c1ac77fd51b9386, 0x8dceb3643fcf285c,
  0x253b5959374c273b, 0xc1b306be7a8f2b7f, 0xb422814c5701bd47, 0x6be8c2cb1148b34e, 0xbd9ceaedc650ea42,
  0xbc6c75ea25da2147, 0x84845022a3e7ac6a, 0x08991c37b2fa598b, 0xe2a4a5989fd62a36, 0x0c4ad7b27f157cee,
  0x7ad79e0404e166fc, 0xa005bcde6c8a0c07, 0xa2077ca9bd4a7253, 0x555169aba718de33, 0x2e65f36dce18edec,
  0x4e7ea6c3b1b8f361, 0x43cc9fe04e34a185, 0x970cf4c2b93f01f3, 0x2c3a4a5b3e04e32c, 0xb1fe8a792bf73433,
  0x0000000000001d75,
};

/*
 * m169a_u1x12_uart0_dual_ee_ce_u4_hw m169p_u1x12_uart0_dual_ee_ce_u4_hw
 * m169pa_u1x12_uart0_dual_ee_ce_u4_hw m165_u1x12_uart0_dual_ee_ce_u4_hw
 * m165a_u1x12_uart0_dual_ee_ce_u4_hw m165p_u1x12_uart0_dual_ee_ce_u4_hw
 * m165pa_u1x12_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u1x12_uart0_dual_ee_ce_u4_hw[] = {
  0x74c9f37a28d1880b, 0x76fcb277d736b777, 0xdc26bed5ef777777, 0x05375ba5ab3eda7b, 0x5b669d666ec13265,
  0x95de4fda77093fd3, 0x8f3d7304f8c0482d, 0x2303775b40c89494, 0xee9f12e20614306d, 0x06439a92bf32ec24,
  0x6e6f51d9f361d667, 0xef822847244fe0cd, 0x006e1f0a21895fe7, 0x21955ddeef9b9d4e, 0x4c7062a10cb402d2,
  0x9096dff5ffe80e78, 0xe7fb3d0e60b0de57, 0x3fdb53fbb74f849f, 0xdc5f546a7a1b46e9, 0x1258f3c6f860e0cd,
  0x47c25f886c2445f7, 0xcf1771b8a49cdffd, 0xe56fe4a76b737374, 0x37a8f83660d7cf51, 0x1669d68450298ae0,
  0x1d484d7d18596229, 0x4428f7b39d5db8ca, 0xf58d578d8ebd44bb, 0x4b3170908a04547c, 0xc546c1132386f65f,
  0xaf9ddc5494b313fa, 0x2cdf81895af64fe2, 0x4180ef5af3c0809c, 0x4e4a7400b79bcd91, 0x1bc67440ef9537a9,
  0x1dbd8aaa2d3574e3, 0x1e6c25ccbe6db9c3, 0x79430a9cfd417637, 0x1fc65f989ffde1ef, 0xc0fdfb0cd0f327f8,
  0x970cf4c2f8d1e8bf, 0x2c3a4a5b3e04e32c, 0x85c2fa792bf73433, 0x00000000003aea2c,
};

/*
 * m169_u2x8_uart0_noled_pr          m169a_u2x8_uart0_noled            m169a_u2x8_uart0_noled_pr
 * m169p_u2x8_uart0_noled            m169p_u2x8_uart0_noled_pr         m169pa_u2x8_uart0_noled
 * m169pa_u2x8_uart0_noled_pr        m165_u2x8_uart0_noled             m165_u2x8_uart0_noled_pr
 * m165a_u2x8_uart0_noled            m165a_u2x8_uart0_noled_pr         m165p_u2x8_uart0_noled
 * m165p_u2x8_uart0_noled_pr         m165pa_u2x8_uart0_noled           m165pa_u2x8_uart0_noled_pr
 */
static const uint64_t ur_m169_u2x8_uart0_noled[] = {
  0xbbbbbb687acdfebe, 0xeeeeeaafb39b3e25, 0x4ddfe2438b78feee, 0xc5d08a66eeec8844, 0xbc9ddf1f85171243,
  0xc92609f180905b2b, 0x74f849efff7e879f, 0x0e1b46f6a8e526fb, 0x0cd27a8fcf1df2c9, 0xdee986f93d1c74fe,
  0x9d9ed23c66731602, 0x6513b8e58c11d78b, 0xe70b37e06256bd85, 0xcde01f50603bd6bc, 0x15d54e5e5363385b,
  0x8b4b0b9c6378ce88, 0x2f9b6249156f62aa, 0xfc68b1e70ddb0973, 0x615c9fbab31e40d1, 0xd964a271964b867a,
  0xc95fb9a19961d252, 0x00003e43a4ed71f3,
};

/*
 * m169a_u2x8_uart0_noled_pr_u4      m169p_u2x8_uart0_noled_pr_u4      m169pa_u2x8_uart0_noled_pr_u4
 * m165_u2x8_uart0_noled_pr_u4       m165a_u2x8_uart0_noled_pr_u4      m165p_u2x8_uart0_noled_pr_u4
 * m165pa_u2x8_uart0_noled_pr_u4
 */
static const uint64_t ur_m169_u2x8_uart0_noled_pr_u4[] = {
  0xbbbbb6874488da91, 0x7777557d9cad225b, 0x089154cdb7a36f77, 0xc7d83eeee859471d, 0xdd68bd3b1dcbb623,
  0x609f180905b2bbc9, 0xc24be7f9e059f9c6, 0xda37b5472937dba7, 0x2fd47e80ef9610f0, 0xa67bed68e3a7f068,
  0xabfa3d61cc580b2c, 0xa01ffb30475e8f9d, 0xe3e07967b63eccf2, 0x39c2cdf81895af60, 0xf37807d4180ef5af,
  0x0575539794d8ce16, 0xa2d2c2e718de33a2, 0xcbe6d892455bd8aa, 0x1be2e4d5c1e6c25c, 0xd4eacc7903f2868b,
  0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3,
  0x007c98c9c880a792,
};

/*
 * m169_u2x8_uart0_noled_pr_ee_u4    m169a_u2x8_uart0_noled_pr_ee      m169a_u2x8_uart0_noled_pr_ee_u4
 * m169p_u2x8_uart0_noled_pr_ee      m169p_u2x8_uart0_noled_pr_ee_u4   m169pa_u2x8_uart0_noled_pr_ee
 * m169pa_u2x8_uart0_noled_pr_ee_u4  m165_u2x8_uart0_noled_pr_ee       m165_u2x8_uart0_noled_pr_ee_u4
 * m165a_u2x8_uart0_noled_pr_ee      m165a_u2x8_uart0_noled_pr_ee_u4   m165p_u2x8_uart0_noled_pr_ee
 * m165p_u2x8_uart0_noled_pr_ee_u4   m165pa_u2x8_uart0_noled_pr_ee     m165pa_u2x8_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m169_u2x8_uart0_noled_pr_ee[] = {
  0xdddddb43a2447768, 0xbbbbaabe6b1b112d, 0xd0a6cb88d3da17bb, 0x5fea6683ba9146ba, 0x92befa7388dd8330,
  0xc602416caef2775d, 0x0ffcf02cfb059827, 0xb5472937dba7c247, 0x89355ad1ce30da37, 0x3e0d9834c7d4795c,
  0x3ad08a1df15f75ea, 0x09afa30b2c4522cd, 0x39d5a5e715c6b269, 0xa1d79d376ded1e0b, 0x11473c8c38d8d56b,
  0xf5b86f65b2e62e12, 0xec00a89534a8d823, 0xb5e73859bf0312b5, 0xc2de6f00fa8301de, 0x7440aeaa72f29b19,
  0x15545a585ce31bc6, 0x4b997cdb1248ab7b, 0xd1637c5c9ab83cd8, 0x39fa9d598f207e50, 0x313ffbc3def28615,
  0x19a1e64ff03f8cbf, 0x85f1a3d17f81fbf6, 0xb67c09c6592e19e9, 0xf257ee6866587494, 0x000009d7d1c51014,
};

/*
 * m169_u2x8_uart0_noled_pr_ce_u4    m169a_u2x8_uart0_noled_pr_ce      m169a_u2x8_uart0_noled_pr_ce_u4
 * m169p_u2x8_uart0_noled_pr_ce      m169p_u2x8_uart0_noled_pr_ce_u4   m169pa_u2x8_uart0_noled_pr_ce
 * m169pa_u2x8_uart0_noled_pr_ce_u4  m165_u2x8_uart0_noled_pr_ce       m165_u2x8_uart0_noled_pr_ce_u4
 * m165a_u2x8_uart0_noled_pr_ce      m165a_u2x8_uart0_noled_pr_ce_u4   m165p_u2x8_uart0_noled_pr_ce
 * m165p_u2x8_uart0_noled_pr_ce_u4   m165pa_u2x8_uart0_noled_pr_ce     m165pa_u2x8_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m169_u2x8_uart0_noled_pr_ce[] = {
  0xbbbbb68744889202, 0x777755743bc2a25b, 0xf4ec78cc5fa6ef77, 0x82d05c77777c4bc8, 0x93baccdb1591414c,
  0x3cc13e30120b6577, 0x3e12727fe78167e4, 0x86d1bdaa3949bedd, 0xc64a9dbf9717d724, 0x886c2445f71258f3,
  0x371fe620fd47c25f, 0xd3dcb19fac99e2ee, 0x91c74fe0f59ea393, 0xfa3d61cc580a3e74, 0x1ffb33c75e8f9dab,
  0xf81e5adc3eccf2a0, 0x70b37e06256bd838, 0xde01f50603bd6bce, 0x5d54e5e5363385bc, 0xb4b0b9c6378ce881,
  0xf36c490c76f62aa8, 0xf1726ae0f3612e65, 0x75663c81f943458d, 0xef0f7bca1854e7ea, 0x993fc0fe32fcc4ff,
  0x8f45fe07efd86687, 0x271964b867a617c6, 0xb9a19961d252d9f0, 0x375c83944053c95f,
};

/*
 * m169a_u2x8_uart0_noled_pr_ee_ce   m169p_u2x8_uart0_noled_pr_ee_ce   m169pa_u2x8_uart0_noled_pr_ee_ce
 * m165_u2x8_uart0_noled_pr_ee_ce    m165a_u2x8_uart0_noled_pr_ee_ce   m165p_u2x8_uart0_noled_pr_ee_ce
 * m165pa_u2x8_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m169_u2x8_uart0_noled_pr_ee_ce[] = {
  0xddddb43d41447705, 0xbbaabf582a8b12dd, 0x69648533df23bbbb, 0x9e0eefdd26798bd7, 0xb291da4c34ad14ad,
  0x80905b2bbc9ddb0d, 0xff3c0b3e4ea609f1, 0x51ca4df6e9f09456, 0x1dff546fe4368ded, 0x66c87f9e3254ef02,
  0xb2b1ef984e771b9d, 0x1ad7f51e57d44a76, 0x0531584ff51f06cc, 0x0b2c4522cd3ad08a, 0xabb74e23a909afa3,
  0xaf3a6edbda3c1673, 0x1cf230e36355e363, 0xe1bd96cb98b84845, 0x59d12a6951b044c8, 0xce70b37e06256bd8,
  0xbcde01f50603bd6b, 0x815d54e5e5363385, 0xa8b4b0b9c6378ce8, 0x65f36c490c76f62a, 0xb579726ae0f3612e,
  0x53ab31e40fca1a2c, 0x4ff0271a50c2a73f, 0x7a615c9f80f9a1e6, 0x252d9f0271964b86, 0x053c95fb9a19961d,
  0x0000000013f318c4,
};

/*
 * m169a_u2x8_uart0_noled_pr_ee_ce_u4 m169p_u2x8_uart0_noled_pr_ee_ce_u4
 * m169pa_u2x8_uart0_noled_pr_ee_ce_u4 m165_u2x8_uart0_noled_pr_ee_ce_u4
 * m165a_u2x8_uart0_noled_pr_ee_ce_u4 m165p_u2x8_uart0_noled_pr_ee_ce_u4
 * m165pa_u2x8_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u2x8_uart0_noled_pr_ee_ce_u4[] = {
  0xbbbbb68744863375, 0xeeeeaaef21c9625b, 0x18934b0cf519eeee, 0xa82c71f1fddb1e48, 0x4b1568dd5ce8e3d3,
  0x27c602416caef277, 0x31fffb15d9fdda98, 0xbdaa3949bedd3e12, 0x383717d51c8786d1, 0x17dc4963cf285c1c,
  0x93f51f097e21b091, 0xbdf33c5dc6e747d4, 0xfd4795f5129dadcd, 0x5613fd47c1b306b5, 0x1148b34eb422814c,
  0xd388ea426be8c2cb, 0x9bb6f68f059ceaed, 0x8c38d8d578d8ebce, 0x65b2e62e1211473c, 0x4a9a546c1132386f,
  0x2cdf81895af61674, 0x807d4180ef5af39c, 0x5539794d8ce16f37, 0x2c2e718de33a2057, 0xdb12431dbd8aaa2d,
  0xc6f86e3cd84b997c, 0xf53ab337f07771a2, 0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33,
  0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c, 0x004fcf627b7459e4,
};

/*
 * m169a_u2x8_uart0_noled_hw         m169p_u2x8_uart0_noled_hw         m169pa_u2x8_uart0_noled_hw
 * m168pb_u2x8_uart0_noled_hw        m165_u2x8_uart0_noled_hw          m165a_u2x8_uart0_noled_hw
 * m165p_u2x8_uart0_noled_hw         m165pa_u2x8_uart0_noled_hw
 */
static const uint64_t ur_m169_u2x8_uart0_noled_hw[] = {
  0x6eeeeeda1eb3753a, 0xdddddd55f672b489, 0x38e8448aa66933dd, 0xb11e3ec1f77742ca, 0x2bbc9dd2e364f54d,
  0x9f9c6609f180905b, 0x7dba7c24be7fe1c7, 0x610f0da37b547293, 0x7f0682fd47e80ef9, 0x80b2ca67bed68e3a,
  0xe8f9dabfa3d61cc5, 0xeccf2a01ffb30475, 0x5af60e3e07967b63, 0xef5af39c2cdf8189, 0x8ce16f37807d4180,
  0xe33a20575539794d, 0xbd8aaa2d2c2e718d, 0x6c25ccbe6d892455, 0xc33d30ae4fcfec37, 0xe9296cb25138cb25,
  0xd829e4afdcd0ccb0, 0x0000000000471005,
};

/*
 * m169a_u2x8_uart0_noled_ee_hw      m169p_u2x8_uart0_noled_ee_hw      m169pa_u2x8_uart0_noled_ee_hw
 * m168pb_u2x8_uart0_noled_ee_hw     m165_u2x8_uart0_noled_ee_hw       m165a_u2x8_uart0_noled_ee_hw
 * m165p_u2x8_uart0_noled_ee_hw      m165pa_u2x8_uart0_noled_ee_hw     pwm216_u2x8_uart0_noled_ee_hw
 * pwm316_u2x8_uart0_noled_ee_hw
 */
static const uint64_t ur_m169_u2x8_uart0_noled_ee_hw[] = {
  0xdddddb43a243280b, 0xbbbbaabe6b1b112d, 0x75a14d971d1a7bbb, 0x60bfd4cd0775228d, 0xddc9cf5b5a71bb06,
  0x609f180905b2bbc9, 0xc2470ffe8533ec16, 0xda37b5472937dba7, 0x795c89355ad1ce30, 0x75ea3e0d9834c7d4,
  0x22cd3ad08a1df15f, 0xb26909afa30b2c45, 0x1e0b39d5a5e715c6, 0xd56ba1d79d376ded, 0x2e1211473c8c38d8,
  0xd823f5b86f65b2e6, 0x12b5ec00a89534a8, 0x01deb5e73859bf03, 0x9b19c2de6f00fa83, 0x1bc67440aeaa72f2,
  0xab7b15545a585ce3, 0x3cd84b997cdb1248, 0xf2861539fa82ec6e, 0x3f8cbf313ffbc3de, 0x81fbf619a1e64ff0,
  0x2e19e985f1a3d17f, 0x587494b67c09c659, 0x556514f257ee6866, 0x00000000000016fe,
};

/*
 * m169a_u2x8_uart0_noled_ce_hw      m169p_u2x8_uart0_noled_ce_hw      m169pa_u2x8_uart0_noled_ce_hw
 * m168pb_u2x8_uart0_noled_ce_hw     m165_u2x8_uart0_noled_ce_hw       m165a_u2x8_uart0_noled_ce_hw
 * m165p_u2x8_uart0_noled_ce_hw      m165pa_u2x8_uart0_noled_ce_hw
 */
static const uint64_t ur_m169_u2x8_uart0_noled_ce_hw[] = {
  0xddddddb43d66ef3a, 0x77777557d9cf1712, 0x387f5e4327b50f77, 0x406d9331afbbbb71, 0xb657793ba0bd04d6,
  0x8f3efe4c13e30120, 0x26fb74f848caffc3, 0xff5e921b46f6a8e5, 0xfddf9e325038989d, 0x0b8ce6139dc6e54a,
  0x83c67ea38879ee58, 0xc580b70c4fc71d3f, 0xebc5ced20a8f199c, 0xaf60e9d3dc72c678, 0xf5af39c2cdf81895,
  0x19c2de6f2dd4180e, 0x42d37aaeaa72f29b, 0xc6378ce881736630, 0xfb0ddb09732f9b69, 0x32c970cf4c2b93f3,
  0x332c3a4a5b2c944e, 0x141d760a792bf734, 0x0000000000000062,
};

/*
 * m169_u2x8_uart0_noled_ee_ce_u4_hw m169a_u2x8_uart0_noled_ee_ce_hw   m169a_u2x8_uart0_noled_ee_ce_u4_hw
 * m169p_u2x8_uart0_noled_ee_ce_hw   m169p_u2x8_uart0_noled_ee_ce_u4_hw
 * m169pa_u2x8_uart0_noled_ee_ce_hw  m169pa_u2x8_uart0_noled_ee_ce_u4_hw
 * m168pb_u2x8_uart0_noled_ee_ce_hw  m168pb_u2x8_uart0_noled_ee_ce_u4_hw
 * m165_u2x8_uart0_noled_ee_ce_hw    m165_u2x8_uart0_noled_ee_ce_u4_hw m165a_u2x8_uart0_noled_ee_ce_hw
 * m165a_u2x8_uart0_noled_ee_ce_u4_hw m165p_u2x8_uart0_noled_ee_ce_hw
 * m165p_u2x8_uart0_noled_ee_ce_u4_hw m165pa_u2x8_uart0_noled_ee_ce_hw
 * m165pa_u2x8_uart0_noled_ee_ce_u4_hw pwm216_u2x8_uart0_noled_ee_ce_hw
 * pwm216_u2x8_uart0_noled_ee_ce_u4_hw pwm316_u2x8_uart0_noled_ee_ce_hw
 * pwm316_u2x8_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u2x8_uart0_noled_ee_ce_hw[] = {
  0xbbbbb68744864aa4, 0xeeeeaaef21c9625b, 0x18934b0cf519eeee, 0xa82c71f1fddb1e48, 0xea4cb17dcfb8e3d3,
  0x04f8c0482d95de4e, 0x48c7ffe8533fbb53, 0x46f6a8e526fb74f8, 0x70e0dc5f54721e1b, 0x445f71258f3ca170,
  0xb91fd47c25f886c2, 0x9b7be678bb8dc4a8, 0x6bfa8f2bea253b5b, 0x98ac27fa8f83660d, 0x962291669d684502,
  0xdba711d484d7d185, 0x9d376ded1e0b39d5, 0x791871b1aaf1b1d7, 0xdecb65cc5c24228e, 0xe89534a8d8226470,
  0x3859bf0312b5ec2c, 0x6f00fa8301deb5e7, 0xaeaa72f29b19c2de, 0x5a585ce31bc67440, 0xf9b624863b7b1554,
  0xf505d8dc79b09732, 0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b,
  0xafdcd0ccb0e9296c, 0x0001405ec4fa29e4,
};

/*
 * m169_u2x8_uart0_lednop_pr         m169a_u2x8_uart0_lednop           m169a_u2x8_uart0_lednop_pr
 * m169p_u2x8_uart0_lednop           m169p_u2x8_uart0_lednop_pr        m169pa_u2x8_uart0_lednop
 * m169pa_u2x8_uart0_lednop_pr       m165_u2x8_uart0_lednop            m165_u2x8_uart0_lednop_pr
 * m165a_u2x8_uart0_lednop           m165a_u2x8_uart0_lednop_pr        m165p_u2x8_uart0_lednop
 * m165p_u2x8_uart0_lednop_pr        m165pa_u2x8_uart0_lednop          m165pa_u2x8_uart0_lednop_pr
 */
static const uint64_t ur_m169_u2x8_uart0_lednop[] = {
  0xddddddb43d66ef3a, 0x77777557d9c2f712, 0x1367eefc3fbe9777, 0xe3f5a5f9bbbb2211, 0x7793ba0bd04cc590,
  0xe0a4c13e30120b65, 0x6e9f097c9fefd0f3, 0x21c368ded51ca4df, 0xc19a4f51c9e3be59, 0x2dee987ce9238e9f,
  0xe766be4720a73160, 0xb07dee39630475e2, 0x13859bf0312b5ec2, 0xb228301deb5e7810, 0xf529c94e8016f379,
  0x9c6378ce881df2a6, 0x9c8ab7b15545a6ae, 0x79c376c25ccbe6db, 0xeeacc790347f1a2c, 0x9c6592e19e985727,
  0x6866587494b65928, 0xc801cb5c7cf257ee, 0x0000000000000007,
};

/*
 * m169a_u2x8_uart0_lednop_pr_u4     m169p_u2x8_uart0_lednop_pr_u4     m169pa_u2x8_uart0_lednop_pr_u4
 * m165_u2x8_uart0_lednop_pr_u4      m165a_u2x8_uart0_lednop_pr_u4     m165p_u2x8_uart0_lednop_pr_u4
 * m165pa_u2x8_uart0_lednop_pr_u4
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_pr_u4[] = {
  0xdddddb43a2447f82, 0x7777557d9c75f12d, 0xb4a12fc2e3b50f77, 0xf4a64f77742ca38e, 0xeeae3122a6e0d933,
  0x304f8c0482d95de4, 0xc252fbfcf02cf9eb, 0xda37b5472937dba7, 0x2fd47b58ef9610f0, 0x4df241f8e3a7f068,
  0xb3d1a43398b01659, 0x00ffd9823af47cec, 0xad03cb3db4166915, 0x4e166fc0c4ad7b20, 0xc8a0c077ad79e040,
  0xd4a7253a005bcde6, 0x718de33a2077ca9b, 0x722adec555169aba, 0x57079b09732f9b6e, 0xe40fca1a2c6f8b93,
  0xde50c2a73f53ab31, 0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f, 0xcb0e9296cf8138cb,
  0xe4e2029e4afdcd0c, 0x000000000003e4c1,
};

/*
 * m169_u2x8_uart0_lednop_pr_ee_u4   m169a_u2x8_uart0_lednop_pr_ee     m169a_u2x8_uart0_lednop_pr_ee_u4
 * m169p_u2x8_uart0_lednop_pr_ee     m169p_u2x8_uart0_lednop_pr_ee_u4  m169pa_u2x8_uart0_lednop_pr_ee
 * m169pa_u2x8_uart0_lednop_pr_ee_u4 m165_u2x8_uart0_lednop_pr_ee      m165_u2x8_uart0_lednop_pr_ee_u4
 * m165a_u2x8_uart0_lednop_pr_ee     m165a_u2x8_uart0_lednop_pr_ee_u4  m165p_u2x8_uart0_lednop_pr_ee
 * m165p_u2x8_uart0_lednop_pr_ee_u4  m165pa_u2x8_uart0_lednop_pr_ee    m165pa_u2x8_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_pr_ee[] = {
  0xdddddb43a2447705, 0x7777557cd6c5f12d, 0x6c2d198d05d08377, 0x1dfa99a0eea451ae, 0x0db2bc8a4c6967ef,
  0xf180905b2bbc9ddb, 0x43ff3c0b3f95a609, 0xed51ca4df6e9f091, 0x654d56b4738c368d, 0x8f83660d31f51e56,
  0x9d68450ef8ac3dfa, 0x84d7d18596229166, 0x1cead2e7aae35934, 0xe875e74dda32464d, 0x84504f237b56355a,
  0xfd6e1bd96cb98b84, 0xf60043eccf2a3608, 0xc0809c2cdf81895a, 0x9bcd914180ef5af3, 0x9537a94e4a7400b7,
  0x3574e31bc67440ef, 0x36dce455bd8aaa2d, 0x1726ae0f3612e65f, 0x5663c81f943458df, 0xf0f7bca1854e7ea7,
  0x93fc0fe32fcc4ffe, 0xf45fe07efd866879, 0x71964b867a617c68, 0x9a19961d252d9f02, 0x75de6dc4053c95fb,
  0x0000000000000002,
};

/*
 * m169_u2x8_uart0_lednop_pr_ce_u4   m169a_u2x8_uart0_lednop_pr_ce     m169a_u2x8_uart0_lednop_pr_ce_u4
 * m169p_u2x8_uart0_lednop_pr_ce     m169p_u2x8_uart0_lednop_pr_ce_u4  m169pa_u2x8_uart0_lednop_pr_ce
 * m169pa_u2x8_uart0_lednop_pr_ce_u4 m165_u2x8_uart0_lednop_pr_ce      m165_u2x8_uart0_lednop_pr_ce_u4
 * m165a_u2x8_uart0_lednop_pr_ce     m165a_u2x8_uart0_lednop_pr_ce_u4  m165p_u2x8_uart0_lednop_pr_ce
 * m165p_u2x8_uart0_lednop_pr_ce_u4  m165pa_u2x8_uart0_lednop_pr_ce    m165pa_u2x8_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_pr_ce[] = {
  0xdddddb43a24458e2, 0xbbbbaaba1da0912d, 0x14f4c6dc33d697bb, 0x336331ddddf12f26, 0x4ee94e1ec694eb03,
  0x7304f8c0482d95de, 0xf849d2ff9e059f29, 0x1b46f6a8e526fb74, 0x3254eea55c5f5c92, 0x4361222fb892c79e,
  0x72b7e007ea3e12fc, 0x3dcb19fac99e2ee3, 0x1c74fe0f59ea3f49, 0x8d219cc580a9888b, 0xfeccf1d7a3e7659e,
  0x0796b720b348a807, 0x2cdf81895af6415a, 0x4180ef5af3c0809c, 0x4e4a7400b79bcd91, 0x1bc67440ef9537a9,
  0x1dbd8aaa2d3574e3, 0x1e6c25ccbe6db9c3, 0x3f2868b1be2e4d5c, 0x430a9cfd4eacc790, 0xc65f989ffde1ef79,
  0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97, 0x880a792bf734332c, 0x0000000006eb8a9c,
};

/*
 * m169a_u2x8_uart0_lednop_pr_ee_ce  m169p_u2x8_uart0_lednop_pr_ee_ce  m169pa_u2x8_uart0_lednop_pr_ee_ce
 * m165_u2x8_uart0_lednop_pr_ee_ce   m165a_u2x8_uart0_lednop_pr_ee_ce  m165p_u2x8_uart0_lednop_pr_ee_ce
 * m165pa_u2x8_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_pr_ee_ce[] = {
  0xeeeeda1ea0a22044, 0xddd55fac111f896e, 0xbd764160ef4edddd, 0xcf0777ee933cc6a2, 0x4e4644219895c66e,
  0xc0482d95de4eea0a, 0xff3c0b3f43f304f8, 0x51ca4df6e9f091c1, 0x9dff546fe4368ded, 0x22495f9e3254ef7d,
  0xb2b1ef984e771b97, 0x1ad7f51e57dd4a76, 0x05315edff51f06cc, 0x0b2c4522cd3ad08a, 0xabb71ea3a909afa3,
  0xd79d3768c9193473, 0x82791bdab1aaf1b1, 0x70decb65cc5c2422, 0x598fb33ca8d82264, 0x0270b37e06256bd8,
  0x36450603bd6bcf02, 0xdea53929d002de6f, 0xd38c6f19d103be54, 0xe70c76f62aa8b4d5, 0x357079b09732f9b6,
  0xf207e50d165abcb9, 0x8d2861539fa9d598, 0x4fc07cd0f327f813, 0x8138cb25c33d30ae, 0xfdcd0ccb0e9296cf,
  0x0013f30862029e4a,
};

/*
 * m169a_u2x8_uart0_lednop_pr_ee_ce_u4 m169p_u2x8_uart0_lednop_pr_ee_ce_u4
 * m169pa_u2x8_uart0_lednop_pr_ee_ce_u4 m165_u2x8_uart0_lednop_pr_ee_ce_u4
 * m165a_u2x8_uart0_lednop_pr_ee_ce_u4 m165p_u2x8_uart0_lednop_pr_ee_ce_u4
 * m165pa_u2x8_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_pr_ee_ce_u4[] = {
  0xdddddb43a243304a, 0x777755779097712d, 0x392989a17b93b777, 0x364638f8feed8f24, 0x62ea3eec900dc112,
  0x3e30120b657793bb, 0xff3fec5767f4d4c1, 0x7b5472937dba7c25, 0x96ae2faa390f0da3, 0x2fb892c79e50b838,
  0x0fea3e12fc436122, 0xf7ccf1771b808930, 0xf51e57dd4a76b736, 0x5edff51f06cc1ad7, 0x4522cd3ad08a0531,
  0x1ea3a909afa30b2c, 0x3768c9193473abb7, 0x1bdab1aaf1b1d79d, 0xcb65cc5c24228279, 0xb33ca8d8226470de,
  0xb37e06256bd8598f, 0x0603bd6bcf020270, 0x3929d002de6f3645, 0x6f19d103be54dea5, 0x76f62aa8b4d5d38c,
  0x79b09732f9b6e70c, 0x6fe0eee3458df0dc, 0x7bca1854e7ea7566, 0xc0fe32fcc4ffef0f, 0xfe07efd86687993f,
  0x64b867a617c68f45, 0x9961d252d9f02719, 0x4d66e8b3c95fb9a1, 0x0000000000004fc9,
};

/*
 * m169a_u2x8_uart0_lednop_hw        m169p_u2x8_uart0_lednop_hw        m169pa_u2x8_uart0_lednop_hw
 * m168pb_u2x8_uart0_lednop_hw       m165_u2x8_uart0_lednop_hw         m165a_u2x8_uart0_lednop_hw
 * m165p_u2x8_uart0_lednop_hw        m165pa_u2x8_uart0_lednop_hw
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_hw[] = {
  0xbbbbbb687acdc49f, 0xeeeeeaafb38ebe25, 0x71d69425f9b006ee, 0x267e94c9eeee8594, 0xcaef277731243568,
  0xe7cf59827c602416, 0xbedd3e1297dff871, 0xb08786d1bdaa3949, 0x3f83417ea3dac77c, 0x80b2ca6f920fc71d,
  0xa3e7659e8d219cc5, 0xb348a807fecc11d7, 0x6bd905681e59eda0, 0xcf020270b37e0625, 0xde6f36450603bd6b,
  0xbe54dea53929d002, 0xb4d5d38c6f19d103, 0x7cdb739156f62aa8, 0x5c9f9fd86ed84b99, 0x64a271964b867a61,
  0x5fb9a19961d252d9, 0x00004715bbb053c9,
};

/*
 * m169a_u2x8_uart0_lednop_ee_hw     m169p_u2x8_uart0_lednop_ee_hw     m169pa_u2x8_uart0_lednop_ee_hw
 * m168pb_u2x8_uart0_lednop_ee_hw    m165_u2x8_uart0_lednop_ee_hw      m165a_u2x8_uart0_lednop_ee_hw
 * m165p_u2x8_uart0_lednop_ee_hw     m165pa_u2x8_uart0_lednop_ee_hw    pwm216_u2x8_uart0_lednop_ee_hw
 * pwm316_u2x8_uart0_lednop_ee_hw
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_ee_hw[] = {
  0xeeeeeda1d1218375, 0xbbbbaabe6b62f896, 0x5cd85a331da0bbbb, 0xde3bf53341dd48a3, 0x7760580ad6c4d2cf,
  0x9827c602416caef2, 0xf09143ffa14cfe56, 0x368ded51ca4df6e9, 0x1e56654d56b4738c, 0x3dfa8f83660d31f5,
  0x91669d68450ef8ac, 0x593484d7d1859622, 0x464d1cead2e7aae3, 0x355ae875e74dda32, 0x8b8484504f237b56,
  0x3608fd6e1bd96cb9, 0x895af60043eccf2a, 0x5af3c0809c2cdf81, 0x00b79bcd914180ef, 0x40ef9537a94e4a74,
  0xaa2d3574e31bc674, 0xe65f36dce455bd8a, 0x4e7ea0bb1b8f3612, 0xcc4ffef0f7bca185, 0x86687993fc0fe32f,
  0x617c68f45fe07efd, 0x2d9f0271964b867a, 0x3c95fb9a19961d25, 0x00000005be60e545,
};

/*
 * m169a_u2x8_uart0_lednop_ce_hw     m169p_u2x8_uart0_lednop_ce_hw     m169pa_u2x8_uart0_lednop_ce_hw
 * m168pb_u2x8_uart0_lednop_ce_hw    m165_u2x8_uart0_lednop_ce_hw      m165a_u2x8_uart0_lednop_ce_hw
 * m165p_u2x8_uart0_lednop_ce_hw     m165pa_u2x8_uart0_lednop_ce_hw
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_ce_hw[] = {
  0xb777776d0f59bb37, 0xeeeeeeaafb395a44, 0x270fed09bbf7c7ee, 0x36200db7c7f7776e, 0x0b657793bb63d90d,
  0x71e7e034c13e3012, 0x49bedd3e120f7ff8, 0x7fd7a486d1bdaa39, 0x5c9fe78c940e4427, 0x02e33984e771b851,
  0xe0f19fa8f5fe7b96, 0x98b016d6a971c74f, 0xc75e2e761f68e893, 0x5af60e94d6e39633, 0xf3c0809c2cdf8189,
  0xce8016f37980ef5a, 0x6953e02d4e48a5ab, 0x378ce88197f31821, 0x0ddb09732f9b69c6, 0xc970cf4c2b93f3fb,
  0x2c3a4a5b2c944e32, 0xf5f60a792bf73433, 0x000000000000c429,
};

/*
 * m169_u2x8_uart0_lednop_ee_ce_u4_hw m169a_u2x8_uart0_lednop_ee_ce_hw
 * m169a_u2x8_uart0_lednop_ee_ce_u4_hw m169p_u2x8_uart0_lednop_ee_ce_hw
 * m169p_u2x8_uart0_lednop_ee_ce_u4_hw m169pa_u2x8_uart0_lednop_ee_ce_hw
 * m169pa_u2x8_uart0_lednop_ee_ce_u4_hw m168pb_u2x8_uart0_lednop_ee_ce_hw
 * m168pb_u2x8_uart0_lednop_ee_ce_u4_hw m165_u2x8_uart0_lednop_ee_ce_hw
 * m165_u2x8_uart0_lednop_ee_ce_u4_hw m165a_u2x8_uart0_lednop_ee_ce_hw
 * m165a_u2x8_uart0_lednop_ee_ce_u4_hw m165p_u2x8_uart0_lednop_ee_ce_hw
 * m165p_u2x8_uart0_lednop_ee_ce_u4_hw m165pa_u2x8_uart0_lednop_ee_ce_hw
 * m165pa_u2x8_uart0_lednop_ee_ce_u4_hw pwm216_u2x8_uart0_lednop_ee_ce_hw
 * pwm216_u2x8_uart0_lednop_ee_ce_u4_hw pwm316_u2x8_uart0_lednop_ee_ce_hw
 * pwm316_u2x8_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u2x8_uart0_lednop_ee_ce_hw[] = {
  0xbbbbb687448607e1, 0xeeeeaaef212ee25b, 0x72531342f7276eee, 0x6c8c71f1fddb1e48, 0xe843dfbd1d7b8224,
  0x04f8c0482d95de4e, 0x12ff9ff4299fd353, 0xd1bdaa3949bedd3e, 0x1c4b5717d51c8786, 0x9117dc4963cf285c,
  0x99cbf51f097e21b0, 0xe6def99e2ee37292, 0x5afea3cafba94ed6, 0xa62bdbfea3e0d983, 0x6588a459a75a1140,
  0x76e3d4752135f461, 0xf3a6ed1923268e75, 0x4f237b56355e363a, 0x1bd96cb98b848450, 0x31f667951b044c8e,
  0x4e166fc0c4ad7b0b, 0xc8a0c077ad79e040, 0xd4a7253a005bcde6, 0x718de33a2077ca9b, 0xe18edec555169aba,
  0x1b8f3612e65f36dc, 0xf7bca1854e7ea0bb, 0xfc0fe32fcc4ffef0, 0x5fe07efd86687993, 0x964b867a617c68f4,
  0x19961d252d9f0271, 0x0529ad453c95fb9a, 0x0000000000000014,
};

/*
 * m169a_u2x8_uart0_dual             m169p_u2x8_uart0_dual             m169pa_u2x8_uart0_dual
 * m165_u2x8_uart0_dual              m165a_u2x8_uart0_dual             m165p_u2x8_uart0_dual
 * m165pa_u2x8_uart0_dual
 */
static const uint64_t ur_m169_u2x8_uart0_dual[] = {
  0xd6eeeee993d44511, 0xdddddddbf20089c6, 0xc20db83d38056b62, 0x89d914e323bbba7e, 0xef2590772be67da5,
  0x6439827c602416ca, 0x303775b40c894948, 0xe9f12e20614306d2, 0xc9cdf3bf32b8f5ce, 0xe6f51d7dec0a29c1,
  0x7c114239227f071e, 0x0370f8510c4aff3f, 0x432abbbddf370e08, 0x26dee2a10cb407c4, 0xe425b780dff4073c,
  0x27ffa404982c3795, 0xf6a8e526fb74f848, 0x8e229df2d5fe1b46, 0x8f491c74fe0d21fa, 0x37b4731602fe1cc9,
  0x9630475e45bb35f2, 0xe77715252b07dee3, 0x37e06256bd93f8ab, 0x603bd6bcf020270b, 0xe4a7400b79bcb750,
  0x2169c05ef9537a94, 0x9c6378ce8811d450, 0x357079b09732f9b6, 0x867a615c9f9fd8b9, 0x1d252d9f0271964b,
  0x44053c95fb9a1996, 0x000000000032dfb7,
};

/*
 * m169_u2x8_uart0_dual_pr_u4        m169a_u2x8_uart0_dual_pr          m169a_u2x8_uart0_dual_pr_u4
 * m169p_u2x8_uart0_dual_pr          m169p_u2x8_uart0_dual_pr_u4       m169pa_u2x8_uart0_dual_pr
 * m169pa_u2x8_uart0_dual_pr_u4      m165_u2x8_uart0_dual_pr           m165_u2x8_uart0_dual_pr_u4
 * m165a_u2x8_uart0_dual_pr          m165a_u2x8_uart0_dual_pr_u4       m165p_u2x8_uart0_dual_pr
 * m165p_u2x8_uart0_dual_pr_u4       m165pa_u2x8_uart0_dual_pr         m165pa_u2x8_uart0_dual_pr_u4
 */
static const uint64_t ur_m169_u2x8_uart0_dual_pr[] = {
  0xbbbba64e890c365a, 0x77776fc800051b5b, 0x5eb14eb83bf6b777, 0xd905191dddd7ae69, 0xb771377d72c53683,
  0x4f8c0482d95de49b, 0xb6819129290c8730, 0xc40c2860da4606ee, 0xa5fe655bb9dd3e25, 0x3a56d83a5381c398,
  0x847244fe0ea54dea, 0xf0a21895fe7ef822, 0xeef77cdcb1f006e1, 0x8a8432d0f9110caa, 0xde037fd01cf0987c,
  0x735e60b0de579096, 0xca4df6e9f0904fff, 0x9df2c4d4368ded51, 0x38e9fc1887f51f22, 0xe62c055079a717be,
  0x8ebc019dad6475fc, 0x6c43a435403ff660, 0x777152552740f2cf, 0x7e06256bd93f8abe, 0x03bd6bcf020270b3,
  0x29d002de6f364506, 0x19d103be54dea539, 0xf62aa8b4d5d38c6f, 0xd84b997cdb739156, 0xf07771a2c6f86e3c,
  0xe50c2a73f53ab337, 0x7f197e627ff787bd, 0x03f7ec3343cc9fe0, 0x5c33d30be347a2ff, 0xb0e9296cf8138cb2,
  0x5b7459e4afdcd0cc, 0x0000000000a49840,
};

/*
 * m169_u2x8_uart0_dual_pr_ee_u4     m169a_u2x8_uart0_dual_pr_ee       m169a_u2x8_uart0_dual_pr_ee_u4
 * m169p_u2x8_uart0_dual_pr_ee       m169p_u2x8_uart0_dual_pr_ee_u4    m169pa_u2x8_uart0_dual_pr_ee
 * m169pa_u2x8_uart0_dual_pr_ee_u4   m165_u2x8_uart0_dual_pr_ee        m165_u2x8_uart0_dual_pr_ee_u4
 * m165a_u2x8_uart0_dual_pr_ee       m165a_u2x8_uart0_dual_pr_ee_u4    m165p_u2x8_uart0_dual_pr_ee
 * m165p_u2x8_uart0_dual_pr_ee_u4    m165pa_u2x8_uart0_dual_pr_ee      m165pa_u2x8_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m169_u2x8_uart0_dual_pr_ee[] = {
  0xbbbbba64e890cf68, 0x777776fc5a2e71b5, 0xea2f2af39db5c777, 0x7d9f6626977599b4, 0xa3ea75ee1bb113d4,
  0x02416caef251dbb9, 0x225252387f9827c6, 0x50c1b48c0ddd6d03, 0xcab773ba7c4b8818, 0xb0ff8700d1369afc,
  0x27f0743f37a8f63f, 0xc4aff3f7c1142392, 0xe6e5c880370f8510, 0x2d074a88655777bb, 0xfa039e131458a843,
  0x2c3795e425b7eaff, 0xba7c25beffdcd798, 0x890da37b5472937d, 0x7a8f2b5f7355ad1c, 0x5752bd47c1b3060a,
  0x1148b34eb422877c, 0xc54b9a426be8c2cb, 0x428f7b39d5a5cca5, 0xac6ab5d0ebd44bb4, 0x598b84845022a3e7,
  0x546c11fadc37b2fa, 0xf9ddc54940213fac, 0xcdf81895af64fe2a, 0x180ef5af3c0809c2, 0xe4a7400b79bcd914,
  0xbc67440ef9537a94, 0x5bd8aaa2d3574e31, 0xf3612e65f36dce45, 0xdfc1ddc68b1be1b8, 0xf79430a9cfd4eacc,
  0x81fc65f989ffde1e, 0xfc0fdfb0cd0f327f, 0xc970cf4c2f8d1e8b, 0x32c3a4a5b3e04e32, 0xd3cdd16792bf7343,
  0x0000000000000ac9,
};

/*
 * m169_u2x8_uart0_dual_pr_ce_u4     m169a_u2x8_uart0_dual_pr_ce       m169a_u2x8_uart0_dual_pr_ce_u4
 * m169p_u2x8_uart0_dual_pr_ce       m169p_u2x8_uart0_dual_pr_ce_u4    m169pa_u2x8_uart0_dual_pr_ce
 * m169pa_u2x8_uart0_dual_pr_ce_u4   m165_u2x8_uart0_dual_pr_ce        m165_u2x8_uart0_dual_pr_ce_u4
 * m165a_u2x8_uart0_dual_pr_ce       m165a_u2x8_uart0_dual_pr_ce_u4    m165p_u2x8_uart0_dual_pr_ce
 * m165p_u2x8_uart0_dual_pr_ce_u4    m165pa_u2x8_uart0_dual_pr_ce      m165pa_u2x8_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m169_u2x8_uart0_dual_pr_ce[] = {
  0xeeeee993a2431f02, 0x77776fc7a7bf66d6, 0x58b96257da807777, 0xaa2f39dbbbb138dd, 0xdca31166d084c295,
  0xe30120b6577931c5, 0x81912929030bcc13, 0x0c2860da4606eeb6, 0xfe655bb9dd3e25c4, 0x6b60168e063f30cd,
  0xc913f831ad37a8e9, 0x886257f9fbe08a11, 0xddf3719f001b87c2, 0x219681454432abbb, 0xb7fd01cf098c7c54,
  0xe60b0de579096de2, 0xdf6e9f09305ff735, 0xea804368ded51ca4, 0xb1e7942e0e3a5b8b, 0x84bf10d8488bee24,
  0x8bb8dc149faffa8f, 0x71bf3dcb19f52e67, 0x07c8e3a7f0752fd4, 0xad6475fce62c0505, 0x403ff6678ebc019d,
  0x49d03cb5b843a435, 0xf64fe2af9ddc5495, 0xc0809c2cdf81895a, 0x9bcd914180ef5af3, 0x9537a94e4a7400b7,
  0x3574e31bc67440ef, 0x6db9c31dbd8aaa2d, 0x637c371e6c25ccbe, 0xfa9d599bf83bb8d1, 0x3ffbc3def2861539,
  0xa1e64ff03f8cbf31, 0xf1a3d17f81fbf619, 0x7c09c6592e19e985, 0x57ee6866587494b6, 0x000d24ab29ba2cf2,
};

/*
 * m169a_u2x8_uart0_dual_pr_ee_ce    m169p_u2x8_uart0_dual_pr_ee_ce    m169pa_u2x8_uart0_dual_pr_ee_ce
 * m165_u2x8_uart0_dual_pr_ee_ce     m165a_u2x8_uart0_dual_pr_ee_ce    m165p_u2x8_uart0_dual_pr_ee_ce
 * m165pa_u2x8_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m169_u2x8_uart0_dual_pr_ee_ce[] = {
  0x6eeeee993d43573e, 0xddddddbf0b89366d, 0x9db37dd8ebe8fcdd, 0x7d55e56ee0ee8f63, 0x717dd857bd657b80,
  0x02416caef25a73b9, 0x2252521d3a9827c6, 0x50c1b48c0ddd6d03, 0xcab773ba7c4b8818, 0xc0521c3f5e635bfc,
  0x4fe0ed6e6f51e006, 0x895fe7ef82284724, 0x9b9dd6006e1f0a21, 0xb434da21955ddeef, 0xe80e784d8122a10c,
  0xb0de579096de76ff, 0xd3e12e9fff735e60, 0x386d1bdaa3949bed, 0x85c1c1ac77fd51b9, 0x73b8dcbc3e5afcf2,
  0xb7f253b5959374c2, 0xd47c1b306be7a8f2, 0x34eb422814c5701b, 0xa426be8c2cb1148b, 0x147bd9ceaedc650e,
  0xc6abc6c75ea25da2, 0x98b84845022a3e7a, 0xa3608991c37b2fa5, 0xceee2a4a5989fd62, 0x6fc0c4ad7b27f157,
  0xc077ad79e0404e16, 0x253a005bcde6c8a0, 0xe33a2077ca9bd4a7, 0xdec555169aba718d, 0x3612e65f36dce18e,
  0xf83bb8d163ce1b8f, 0xc33d30ae4fdd599b, 0x0e9296cf8138cb25, 0xb7459e4afdcd0ccb, 0x000000000260963f,
};

/*
 * m169a_u2x8_uart0_dual_pr_ee_ce_u4 m169p_u2x8_uart0_dual_pr_ee_ce_u4 m169pa_u2x8_uart0_dual_pr_ee_ce_u4
 * m165_u2x8_uart0_dual_pr_ee_ce_u4  m165a_u2x8_uart0_dual_pr_ee_ce_u4 m165p_u2x8_uart0_dual_pr_ee_ce_u4
 * m165pa_u2x8_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u2x8_uart0_dual_pr_ee_ce_u4[] = {
  0xbbba64e8adbba812, 0xbbb7e593beb9b5bb, 0xc26bd5ef5717bbbb, 0x5375ba5ab3eda7bd, 0xb3fb4666ec132650,
  0xc9fb4ee0fafc1cbb, 0xae609f180905b2bb, 0x6eeb6819129291e7, 0xe25c40c2860da460, 0x9a92bf32d2df9dd3,
  0x51d9f361d6670643, 0x2847244fe0cd6e6f, 0x1f0a21895fe7ef82, 0x5ddeef9b9d4e006e, 0x62a10cb402d22195,
  0xdff5ffe80e784c70, 0x1f8660b0de579096, 0x2937dba7c24ff3ff, 0xfaa353d0da37b547, 0x2c79e50bcec66ee2,
  0xe12fc4361222fb89, 0x5dc6e6a83c83fea3, 0xbf929dadcdcdd33c, 0xa3e0d9835f3d4795, 0xa75a1140a62b80de,
  0x2135f4616588a459, 0xa3dece7576e32875, 0x355e363af512ed10, 0xc5c242281151f3d6, 0x1b044c8e1bd97d2c,
  0x77715252cc4feb15, 0x7e06256bd93f8abe, 0x03bd6bcf020270b3, 0x29d002de6f364506, 0x19d103be54dea539,
  0xf62aa8b4d5d38c6f, 0xb09732f9b6e70c76, 0xb1a2c6f8b9357079, 0x4e7ea75666fe0fdb, 0xcc4ffef0f7bca185,
  0x86687993fc0fe32f, 0x617c68f45fe07efd, 0x2d9f0271964b867a, 0x3c95fb9a19961d25, 0x000010019697c8dd,
};

/*
 * m169a_u2x8_uart0_dual_hw          m169p_u2x8_uart0_dual_hw          m169pa_u2x8_uart0_dual_hw
 * m165_u2x8_uart0_dual_hw           m165a_u2x8_uart0_dual_hw          m165p_u2x8_uart0_dual_hw
 * m165pa_u2x8_uart0_dual_hw
 */
static const uint64_t ur_m169_u2x8_uart0_dual_hw[] = {
  0xddddd32744861a4e, 0xbbbbb7e400028dad, 0xaf58a75c1dfb5bbb, 0xec828c8eeeebd734, 0x9bb7726bb85efb81,
  0x304f8c0482d95de4, 0xeeb6819129290c87, 0x25c40c2860da4606, 0x98a5fe655bb9dd3e, 0xea3a56d83a5381c3,
  0x22847244fe0ea54d, 0xe1f0a21895fe7ef8, 0xaaeef77cdcb1f006, 0x7c8a8432d0f9110c, 0x96de037fd01cf098,
  0xffea4660b0de5790, 0xa3949bedd3e1209f, 0x453be589a86d1bda, 0x7c71d3f8310fea3e, 0xf9cc580aa0f34e2f,
  0xc11d78033b5ac8eb, 0x9ed887486a807fec, 0x7ceee2a4aa4e81e5, 0x66fc0c4ad7b27f15, 0x0c077ad79e0404e1,
  0x7253a005bcde6c8a, 0xde33a2077ca9bd4a, 0xadec555169aba718, 0x79b09732f9b6e722, 0xe50c2a73f505d8dc,
  0x7f197e627ff787bd, 0x03f7ec3343cc9fe0, 0x5c33d30be347a2ff, 0xb0e9296cf8138cb2, 0x80ba29e4afdcd0cc,
  0x0000000000063750,
};

/*
 * m169a_u2x8_uart0_dual_ee_hw       m169p_u2x8_uart0_dual_ee_hw       m169pa_u2x8_uart0_dual_ee_hw
 * m165_u2x8_uart0_dual_ee_hw        m165a_u2x8_uart0_dual_ee_hw       m165p_u2x8_uart0_dual_ee_hw
 * m165pa_u2x8_uart0_dual_ee_hw
 */
static const uint64_t ur_m169_u2x8_uart0_dual_ee_hw[] = {
  0xeeeee993a2435202, 0xdddddbf168b9c6d6, 0xa8bcabce76d71ddd, 0xf67d989a5dd666d3, 0x721d6d37cd744f51,
  0x80905b2bbc9476ee, 0xc894948e1fe609f1, 0x14306d2303775b40, 0x32addcee9f12e206, 0xec3fe1c0344da6bf,
  0x89fc1d0fcdea3d8f, 0x312bfcfdf04508e4, 0xf9b972200dc3e144, 0xcb41d2a21955ddee, 0xfe80e784c5162a10,
  0x0b0de579096dfabf, 0xdd3e12df7ffea466, 0x4486d1bdaa3949be, 0x3d4795afb9aad68e, 0x2ba95ea3e0d98305,
  0x88a459a75a1143be, 0xe2a5cd2135f46165, 0x2147bd9cead2e652, 0xd6355ae875ea25da, 0x2cc5c242281151f3,
  0x2a3608fd6e1bd97d, 0x7ceee2a4a0109fd6, 0x66fc0c4ad7b27f15, 0x0c077ad79e0404e1, 0x7253a005bcde6c8a,
  0xde33a2077ca9bd4a, 0xadec555169aba718, 0x79b09732f9b6e722, 0xe50c2a73f505d8dc, 0x7f197e627ff787bd,
  0x03f7ec3343cc9fe0, 0x5c33d30be347a2ff, 0xb0e9296cf8138cb2, 0xe9ea29e4afdcd0cc, 0x00000000000015da,
};

/*
 * m169a_u2x8_uart0_dual_ce_hw       m169p_u2x8_uart0_dual_ce_hw       m169pa_u2x8_uart0_dual_ce_hw
 * m165_u2x8_uart0_dual_ce_hw        m165a_u2x8_uart0_dual_ce_hw       m165p_u2x8_uart0_dual_ce_hw
 * m165pa_u2x8_uart0_dual_ce_hw
 */
static const uint64_t ur_m169_u2x8_uart0_dual_ce_hw[] = {
  0xddddd327448618be, 0xeeeedf8f4f7ecdad, 0xb172c4afb500eeee, 0x545e73b7776271ba, 0x717775ece0b5e0ab,
  0x04f8c0482d95de4c, 0xada0644a4a40c2f3, 0x71030a18369181bb, 0x337f9956ee774f89, 0x3a5ad805a3818fcc,
  0x847244fe0c6b4dea, 0xf0a21895fe7ef822, 0xeef77cdc67c006e1, 0x150865a051510caa, 0x78adff4073c2631f,
  0xa91982c3795e425b, 0x526fb74f84982fff, 0xc5f54021b46f6a8e, 0x1258f3ca17071d2d, 0x47c25f886c2445f7,
  0x99e2ee371fe620fd, 0xf51c6fcf72c67d4b, 0x4141f238e9fc1d4b, 0x676b591d7f398b01, 0x0d500ffd99e3af00,
  0x2552740f2d6e10e9, 0x56bd93f8abe77715, 0xbcf020270b37e062, 0x2de6f36450603bd6, 0x3be54dea53929d00,
  0x8b4d5d38c6f19d10, 0x2f9b6e70c76f62aa, 0x3f505d8dc79b0973, 0x27ff787bde50c2a7, 0x343cc9fe07f197e6,
  0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30, 0x4afdcd0ccb0e9296, 0x000004dd6acaa29e,
};

/*
 * m169a_u2x8_uart0_dual_ee_ce_hw    m169p_u2x8_uart0_dual_ee_ce_hw    m169pa_u2x8_uart0_dual_ee_ce_hw
 * m165_u2x8_uart0_dual_ee_ce_hw     m165a_u2x8_uart0_dual_ee_ce_hw    m165p_u2x8_uart0_dual_ee_ce_hw
 * m165pa_u2x8_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m169_u2x8_uart0_dual_ee_ce_hw[] = {
  0xeeee993d4143359b, 0xddddbf0b89366d6e, 0xb37dd8ebe8fcdddd, 0x55e56ee0ee8f639d, 0x786614d6bafb807d,
  0x02416caef25a73b8, 0x2252521d3a9827c6, 0x50c1b48c0ddd6d03, 0xcab773ba7c4b8818, 0xc0521c3f5e635bfc,
  0x4fe0ed6e6f51e006, 0x895fe7ef82284724, 0x9b9dd6006e1f0a21, 0xb434da21955ddeef, 0xe80e784d8122a10c,
  0xb0de579096de76ff, 0xa7c25d3fffea4660, 0x70da37b5472937db, 0x0b838358effaa372, 0xe771b9d66c87f9e5,
  0x6fe4a76b2b26e984, 0xa8f83660d7cf51e5, 0x69d68450298ae037, 0x484d7d1859622916, 0x28f7b39d5db8ca1d,
  0x8d578d8ebd44bb44, 0x3170908a04547cf5, 0x46c1132386f65f4b, 0x9ddc5494b313fac5, 0xdf81895af64fe2af,
  0x80ef5af3c0809c2c, 0x4a7400b79bcd9141, 0xc67440ef9537a94e, 0xbd8aaa2d3574e31b, 0x6c25ccbe6db9c31d,
  0x30a9cfd4d876371e, 0x3e687993fc09c694, 0x6592e19e985727e0, 0x866587494b67c09c, 0xaeb63fd14f257ee6,
  0x0000000000000003,
};

/*
 * m169a_u2x8_uart0_dual_ee_ce_u4_hw m169p_u2x8_uart0_dual_ee_ce_u4_hw m169pa_u2x8_uart0_dual_ee_ce_u4_hw
 * m165_u2x8_uart0_dual_ee_ce_u4_hw  m165a_u2x8_uart0_dual_ee_ce_u4_hw m165p_u2x8_uart0_dual_ee_ce_u4_hw
 * m165pa_u2x8_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u2x8_uart0_dual_ee_ce_u4_hw[] = {
  0xeeee993a28d1880b, 0xeeedf964efae6d6e, 0xf7b84d7dabdeeeee, 0xca0a6eb74b567db4, 0xa6b6cd3accdd8264,
  0x5b2bbc9fb4ee127f, 0x291e7ae609f18090, 0xda4606eeb6819129, 0x49dd3e25c40c2860, 0xce0c8735257e65d8,
  0x9adcdea3b3e6c3ac, 0xcfdf04508e489fc1, 0x9c00dc3e144312bf, 0xa4432abbbddf373a, 0xf098e0c542196805,
  0xaf212dbfebffd01c, 0x3fcff67a1cc161bc, 0xded51ca4df6e9f09, 0x19bb8bea8d4f4368, 0xbee24b1e78df0c1c,
  0xffa8f84bf10d8488, 0x6e99e2ee3714939b, 0xea3cadfc94ed6e6e, 0x5c06f51f06cc1af9, 0x4522cd3ad08a0531,
  0x1943a909afa30b2c, 0x9768851ef673abb7, 0x8f9eb1aaf1b1d7a8, 0xcbe9662e1211408a, 0x7f58a8d8226470de,
  0xfc55f3bb8a929662, 0x13859bf0312b5ec9, 0xb228301deb5e7810, 0xf529c94e8016f379, 0x9c6378ce881df2a6,
  0x3863b7b15545a6ae, 0xc6e3cd84b997cdb7, 0x3def2861539fa82e, 0xff03f8cbf313ffbc, 0x17f81fbf619a1e64,
  0x6592e19e985f1a3d, 0x866587494b67c09c, 0x4590b85f4f257ee6, 0x000000000000075d,
};

/*
 * m169_u2x12_uart0_noled_pr         m169a_u2x12_uart0_noled           m169a_u2x12_uart0_noled_pr
 * m169p_u2x12_uart0_noled           m169p_u2x12_uart0_noled_pr        m169pa_u2x12_uart0_noled
 * m169pa_u2x12_uart0_noled_pr       m165_u2x12_uart0_noled            m165_u2x12_uart0_noled_pr
 * m165a_u2x12_uart0_noled           m165a_u2x12_uart0_noled_pr        m165p_u2x12_uart0_noled
 * m165p_u2x12_uart0_noled_pr        m165pa_u2x12_uart0_noled          m165pa_u2x12_uart0_noled_pr
 */
static const uint64_t ur_m169_u2x12_uart0_noled[] = {
  0x776d0d783acdfc4f, 0xddd55ce0b4244b77, 0x8a64d0e6b11ddddd, 0xe2f56dddd3c19ee4, 0x77617ad1e3d041af,
  0x9827c602416caef2, 0xe12887fdfa1e7e6e, 0x51ca4fe6d4faadd3, 0x9e3be5921c368ded, 0x7a38e9fc19a4f51f,
  0xcce62c05bdd30df2, 0x1823af173b3da478, 0xc4ad7b0aca2771cb, 0xc077ad79ce166fc0, 0xa6c670b79bc03ea0,
  0xc6f19d102baa9cbc, 0x2adec55516961738, 0x1bb612e65f36c492, 0x663c81a3f8d163ce, 0x2c970cf4c2b93f75,
  0x32c3a4a5b2c944e3, 0xa9dae3e792bf7343, 0x0000000000001f20,
};

/*
 * m169a_u2x12_uart0_noled_pr_u4     m169p_u2x12_uart0_noled_pr_u4     m169pa_u2x12_uart0_noled_pr_u4
 * m165_u2x12_uart0_noled_pr_u4      m165a_u2x12_uart0_noled_pr_u4     m165p_u2x12_uart0_noled_pr_u4
 * m165pa_u2x12_uart0_noled_pr_u4
 */
static const uint64_t ur_m169_u2x12_uart0_noled_pr_u4[] = {
  0x76d0d7834488a8ae, 0xbaab9c178fc4b777, 0xe4d5a00d2e3bbbbb, 0xf07dddd888913e2d, 0xa69638d931223188,
  0x13e30120b657793b, 0x4814ff3c0b3fa54c, 0x7293f9b53eab74f8, 0x0ef9610f0da37b54, 0x8e3a7f0682fd47e8,
  0x1cc580b2ca67bed6, 0x0475e8f9dabfa3d6, 0x7b63eccf2a01ffb3, 0x81895af60e3e0796, 0x4180ef5af39c2cdf,
  0x794d8ce16f37807d, 0x718de33a20575539, 0x2455bd8aaa2d2c2e, 0x5c1e6c25ccbe6d89, 0x903f2868b1be2e4d,
  0x79430a9cfd4eacc7, 0x1fc65f989ffde1ef, 0xc0fdfb0cd0f327f8, 0x970cf4c2f8d1e8bf, 0x2c3a4a5b3e04e32c,
  0x4e880a792bf73433, 0x00000000000f938d,
};

/*
 * m169_u2x12_uart0_noled_pr_ee_u4   m169a_u2x12_uart0_noled_pr_ee     m169a_u2x12_uart0_noled_pr_ee_u4
 * m169p_u2x12_uart0_noled_pr_ee     m169p_u2x12_uart0_noled_pr_ee_u4  m169pa_u2x12_uart0_noled_pr_ee
 * m169pa_u2x12_uart0_noled_pr_ee_u4 m165_u2x12_uart0_noled_pr_ee      m165_u2x12_uart0_noled_pr_ee_u4
 * m165a_u2x12_uart0_noled_pr_ee     m165a_u2x12_uart0_noled_pr_ee_u4  m165p_u2x12_uart0_noled_pr_ee
 * m165p_u2x12_uart0_noled_pr_ee_u4  m165pa_u2x12_uart0_noled_pr_ee    m165pa_u2x12_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m169_u2x12_uart0_noled_pr_ee[] = {
  0xbb686bc1a2446f43, 0xeeaaf2200ce25bbb, 0x90f1ef5f682eeeee, 0x984c3fbaf23af640, 0xed533d950ccddb53,
  0x0120b657793bad3b, 0xfe78167f024c13e3, 0xe6d4faadd3e12297, 0x738c368ded51ca4f, 0x31f51e57224d56b4,
  0x7c57dd7a8f83660d, 0xcb1148b34eb42287, 0xc571ac9a426be8c2, 0xdb7b4782ce756979, 0x0e36355ae875e74d,
  0x6cb98b848451cf23, 0x4d2a3608fd6e1bd9, 0x6fc0c4ad7b002a25, 0x3ea0c077ad79ce16, 0x9cbca6c670b79bc0,
  0x1738c6f19d102baa, 0xc4922adec5551696, 0x26ae0f3612e65f36, 0x63c81f943458df17, 0xf7bca1854e7ea756,
  0xfc0fe32fcc4ffef0, 0x5fe07efd86687993, 0x964b867a617c68f4, 0x19961d252d9f0271, 0xf6bdc4053c95fb9a,
  0x0000000000000275,
};

/*
 * m169_u2x12_uart0_noled_pr_ce_u4   m169a_u2x12_uart0_noled_pr_ce     m169a_u2x12_uart0_noled_pr_ce_u4
 * m169p_u2x12_uart0_noled_pr_ce     m169p_u2x12_uart0_noled_pr_ce_u4  m169pa_u2x12_uart0_noled_pr_ce
 * m169pa_u2x12_uart0_noled_pr_ce_u4 m165_u2x12_uart0_noled_pr_ce      m165_u2x12_uart0_noled_pr_ce_u4
 * m165a_u2x12_uart0_noled_pr_ce     m165a_u2x12_uart0_noled_pr_ce_u4  m165p_u2x12_uart0_noled_pr_ce
 * m165p_u2x12_uart0_noled_pr_ce_u4  m165pa_u2x12_uart0_noled_pr_ce    m165pa_u2x12_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m169_u2x12_uart0_noled_pr_ce[] = {
  0x76d0d78344889768, 0xeeaaf064b444b777, 0x3bdb67ef619eeeee, 0x78fdddd3265ed4de, 0x3747688f8f62b6c8,
  0x9f180905b2bbc9dd, 0x7ceff3c0b3e5d660, 0x527f36a7d56e9f09, 0xc5f5c921b46f6a8e, 0xc4963cf192a76fe5,
  0x51f097e21b09117d, 0x2678bb8dc7f9883f, 0x67a8e4f4f72c67eb, 0x028f9d2471d3f83d, 0xa3e76afe8f587316,
  0xb33ca807feccf1d7, 0x5af60e3e0796b70f, 0xef5af39c2cdf8189, 0x8ce16f37807d4180, 0xe33a20575539794d,
  0xbd8aaa2d2c2e718d, 0xd84b997cdb12431d, 0x50d1637c5c9ab83c, 0x1539fa9d598f207e, 0xbf313ffbc3def286,
  0xf619a1e64ff03f8c, 0xe985f1a3d17f81fb, 0x94b67c09c6592e19, 0x14f257ee68665874, 0x0000000dd77e0510,
};

/*
 * m169a_u2x12_uart0_noled_pr_ee_ce  m169p_u2x12_uart0_noled_pr_ee_ce  m169pa_u2x12_uart0_noled_pr_ee_ce
 * m165_u2x12_uart0_noled_pr_ee_ce   m165a_u2x12_uart0_noled_pr_ee_ce  m165p_u2x12_uart0_noled_pr_ee_ce
 * m165pa_u2x12_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m169_u2x12_uart0_noled_pr_ee_ce[] = {
  0xb686bc1d41447032, 0xeaaf088d1625bbbb, 0x5a09c97560eeeeee, 0x82917746d82f0828, 0xec9c9cbe99a5c5ed,
  0x2416caef2775b11c, 0xcf02cfa5a9827c60, 0xda9f55ba7c2435bf, 0xfc86d1bdaa3949fc, 0xc64a9de043bfea8d,
  0x09cee373acd90ff3, 0xcafa894ed6563df3, 0xfea3e0d9835afea3, 0x59a75a1140a62b09, 0x752135f4616588a4,
  0x7b4782ce7576e9c4, 0x6c6abc6c75e74ddb, 0x73170908a39e461c, 0x2a3608991c37b2d9, 0xc0c4ad7b0b3a254d,
  0xa0c077ad79ce166f, 0xbca6c670b79bc03e, 0x38c6f19d102baa9c, 0x218edec555169617, 0x5c1e6c25ccbe6d89,
  0x81f9434596af2e4d, 0x4a1854e7ea75663c, 0xf01f343cc9fe04e3, 0x4e32c970cf4c2b93, 0x734332c3a4a5b3e0,
  0x009f864880a792bf,
};

/*
 * m169a_u2x12_uart0_noled_pr_ee_ce_u4 m169p_u2x12_uart0_noled_pr_ee_ce_u4
 * m169pa_u2x12_uart0_noled_pr_ee_ce_u4 m165_u2x12_uart0_noled_pr_ee_ce_u4
 * m165a_u2x12_uart0_noled_pr_ee_ce_u4 m165p_u2x12_uart0_noled_pr_ee_ce_u4
 * m165pa_u2x12_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u2x12_uart0_noled_pr_ee_ce_u4[] = {
  0x76d0d7834486cc7f, 0xbaabae43a744b777, 0x7e98d3d89dbbbbbb, 0xa912c47771da09e4, 0x55e52947e0dc71a8,
  0x0120b657793ba9f7, 0xfd8aecfa6dcc13e3, 0x36a7d56e9f090cdf, 0x21e1b46f6a8e527f, 0xca17070e0dc5f547,
  0x886c2445f71258f3, 0xb9d1f524fd47c25f, 0xa76b736f7ccf1771, 0x6cc1ad7f51e57d44, 0x08a0531584ff51f0,
  0xfa30b2c4522cd3ad, 0x673abb74e23a909a, 0x363af3a6edbda3c1, 0x8451cf230e36355e, 0x4c8e1bd96cb98b84,
  0xbd859d12a6951b04, 0xd6bce70b37e06256, 0x385bcde01f50603b, 0xce8815d54e5e5363, 0x62aa8b4b0b9c6378,
  0x12e65f36c490c76f, 0x1ddc68b1be1b8f36, 0x430a9cfd4eaccdfc, 0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f,
  0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97, 0xdd16792bf734332c, 0x0000000013f3cfc2,
};

/*
 * m169a_u2x12_uart0_noled_hw        m169p_u2x12_uart0_noled_hw        m169pa_u2x12_uart0_noled_hw
 * m168pb_u2x12_uart0_noled_hw       m165_u2x12_uart0_noled_hw         m165a_u2x12_uart0_noled_hw
 * m165p_u2x12_uart0_noled_hw        m165pa_u2x12_uart0_noled_hw
 */
static const uint64_t ur_m169_u2x12_uart0_noled_hw[] = {
  0x776d0d783acdfebe, 0xbbaab9c178fc4b77, 0x8b79356d1b7bbbbb, 0x623c1f777622244f, 0xef2777c7e15a480c,
  0xf4a9827c602416ca, 0x6e9f09029ff871e7, 0x6f6a8e527f36a7d5, 0xa8fd01df2c21e1b4, 0xf7dad1c74fe0d05f,
  0xf47ac398b016594c, 0x3ff6608ebd1f3b57, 0xc0f2cf6c7d99e540, 0x859bf0312b5ec1c7, 0xf00fa8301deb5e73,
  0xeaa72f29b19c2de6, 0xa585ce31bc67440a, 0xcdb1248ab7b15545, 0xc9f9fd86ed84b997, 0x4a271964b867a615,
  0xfb9a19961d252d96, 0x008e2d38fb053c95,
};

/*
 * m169a_u2x12_uart0_noled_ee_hw     m169p_u2x12_uart0_noled_ee_hw     m169pa_u2x12_uart0_noled_ee_hw
 * m168pb_u2x12_uart0_noled_ee_hw    m165_u2x12_uart0_noled_ee_hw      m165a_u2x12_uart0_noled_ee_hw
 * m165p_u2x12_uart0_noled_ee_hw     m165pa_u2x12_uart0_noled_ee_hw    pwm216_u2x12_uart0_noled_ee_hw
 * pwm316_u2x12_uart0_noled_ee_hw
 */
static const uint64_t ur_m169_u2x12_uart0_noled_ee_hw[] = {
  0xbb686bc1a2433a31, 0xeeaaf2200ce25bbb, 0x8121e3f5ebeeeeee, 0xa730987f75e475ec, 0xd89b0da02a199bb6,
  0x4f8c0482d95de4ee, 0x2297ff4299fc0930, 0xca4fe6d4faadd3e1, 0x56b4738c368ded51, 0x660d31f51e57224d,
  0x22877c57dd7a8f83, 0xe8c2cb1148b34eb4, 0x6979c571ac9a426b, 0xe74ddb7b4782ce75, 0xcf230e36355ae875,
  0x1bd96cb98b848451, 0x2a254d2a3608fd6e, 0xce166fc0c4ad7b00, 0x9bc03ea0c077ad79, 0x2baa9cbca6c670b7,
  0x16961738c6f19d10, 0x5f36c4922adec555, 0x7ea0bb1b8f3612e6, 0x4ffef0f7bca1854e, 0x687993fc0fe32fcc,
  0x7c68f45fe07efd86, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x00000b7cc713453c,
};

/*
 * m169a_u2x12_uart0_noled_ce_hw     m169p_u2x12_uart0_noled_ce_hw     m169pa_u2x12_uart0_noled_ce_hw
 * m168pb_u2x12_uart0_noled_ce_hw    m165_u2x12_uart0_noled_ce_hw      m165a_u2x12_uart0_noled_ce_hw
 * m165p_u2x12_uart0_noled_ce_hw     m165pa_u2x12_uart0_noled_ce_hw
 */
static const uint64_t ur_m169_u2x12_uart0_noled_ce_hw[] = {
  0xeeeda1af0759bb37, 0xbbbaab9c16b4896e, 0x99b426efdf1fbbbb, 0x401b6f8feeee8da2, 0xcaef2776c7b21a6c,
  0xcfc069827c602416, 0x55ba7c241efff0e3, 0xd1bdaa3949fcda9f, 0x940e3de77fd7a486, 0xe771b8beca2fe78c,
  0xdafa7b9602e33984, 0xf6a38e9fc1e33f51, 0xd22333c731602f48, 0x5b8e58cf1d78b9d8, 0x66fc0c4ad7b0750d,
  0xe0e4ac077ad79ce1, 0xea5ab94a5f385bcd, 0x33cc6085a7717f36, 0x2f9b69c6378ce881, 0x2b93f3fb0ddb0973,
  0x2c944e32c970cf4c, 0x2bf734332c3a4a5b, 0x0000c429f5f60a79,
};

/*
 * m169_u2x12_uart0_noled_ee_ce_u4_hw m169a_u2x12_uart0_noled_ee_ce_hw
 * m169a_u2x12_uart0_noled_ee_ce_u4_hw m169p_u2x12_uart0_noled_ee_ce_hw
 * m169p_u2x12_uart0_noled_ee_ce_u4_hw m169pa_u2x12_uart0_noled_ee_ce_hw
 * m169pa_u2x12_uart0_noled_ee_ce_u4_hw m168pb_u2x12_uart0_noled_ee_ce_hw
 * m168pb_u2x12_uart0_noled_ee_ce_u4_hw m165_u2x12_uart0_noled_ee_ce_hw
 * m165_u2x12_uart0_noled_ee_ce_u4_hw m165a_u2x12_uart0_noled_ee_ce_hw
 * m165a_u2x12_uart0_noled_ee_ce_u4_hw m165p_u2x12_uart0_noled_ee_ce_hw
 * m165p_u2x12_uart0_noled_ee_ce_u4_hw m165pa_u2x12_uart0_noled_ee_ce_hw
 * m165pa_u2x12_uart0_noled_ee_ce_u4_hw pwm216_u2x12_uart0_noled_ee_ce_hw
 * pwm216_u2x12_uart0_noled_ee_ce_u4_hw pwm316_u2x12_uart0_noled_ee_ce_hw
 * pwm316_u2x12_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u2x12_uart0_noled_ee_ce_hw[] = {
  0xeda1af06890c1107, 0x75575c874e896eee, 0xfd31a7b13b777777, 0x522588eee3b413c8, 0x9157eefdc1b8e351,
  0xc602416caef27753, 0x37ff4299f4db9827, 0x9fcda9f55ba7c243, 0x51c8786d1bdaa394, 0x3cf285c1c383717d,
  0x97e21b09117dc496, 0xee3712a2e47f51f0, 0xa894ed6e6def99e2, 0x3e0d9835afea3caf, 0x75a1140a62b09fea,
  0x135f4616588a459a, 0x782ce7576e9c4752, 0xabc6c75e74ddb7b4, 0x70908a39e461c6c6, 0x608991c37b2d9731,
  0x4ad7b0b3a254d2a3, 0x077ad79ce166fc0c, 0x6c670b79bc03ea0c, 0x6f19d102baa9cbca, 0xedec55516961738c,
  0xe6c25ccbe6d89218, 0x9430a9cfd4176371, 0xfc65f989ffde1ef7, 0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc,
  0xc3a4a5b3e04e32c9, 0xf868a792bf734332, 0x0000000000050179,
};

/*
 * m169_u2x12_uart0_lednop_pr        m169a_u2x12_uart0_lednop          m169a_u2x12_uart0_lednop_pr
 * m169p_u2x12_uart0_lednop          m169p_u2x12_uart0_lednop_pr       m169pa_u2x12_uart0_lednop
 * m169pa_u2x12_uart0_lednop_pr      m165_u2x12_uart0_lednop           m165_u2x12_uart0_lednop_pr
 * m165a_u2x12_uart0_lednop          m165a_u2x12_uart0_lednop_pr       m165p_u2x12_uart0_lednop
 * m165p_u2x12_uart0_lednop_pr       m165pa_u2x12_uart0_lednop         m165pa_u2x12_uart0_lednop_pr
 */
static const uint64_t ur_m169_u2x12_uart0_lednop[] = {
  0x776d0d783acdfc4f, 0xbbaab9c14c9c4b77, 0xdac1d4cd623bbbbb, 0xbf8be6fbbba7833d, 0xc9dd85eb478f4106,
  0x3e609f180905b2bb, 0x9f09201fefd0f3e1, 0x6a8e527f36a7d56e, 0xe4f1df2c90e1b46f, 0xf3d1c74fe0cd27a8,
  0x20a731602dee986f, 0xb1823af173b07147, 0x312b5ec2b141f71c, 0xeb5e781013859bf0, 0xa005bcde5ba8301d,
  0xe02f7ca9bd4a7253, 0xbc674408ea2810b4, 0x6ed84b997cdb4e31, 0x98f2068fe3458f38, 0xb25c33d30ae4fdd5,
  0xcb0e9296cb25138c, 0xa76b8f9e4afdcd0c, 0x0000000000007c82,
};

/*
 * m169a_u2x12_uart0_lednop_pr_u4    m169p_u2x12_uart0_lednop_pr_u4    m169pa_u2x12_uart0_lednop_pr_u4
 * m165_u2x12_uart0_lednop_pr_u4     m165a_u2x12_uart0_lednop_pr_u4    m165p_u2x12_uart0_lednop_pr_u4
 * m165pa_u2x12_uart0_lednop_pr_u4
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_pr_u4[] = {
  0xbb686bc1a2446d4e, 0xdd55ce0be9625bbb, 0x8b60fe3f731ddddd, 0xe6fbbbb1112278ff, 0x626e09208cc6d933,
  0x3e30120b657793ba, 0x201fe78167c27cc1, 0x527f36a7d56e9f09, 0xdf2c21e1b46f6a8e, 0xc74fe0d05fa8f6b1,
  0x31602cb29be483f1, 0x75e8f9d967a34867, 0x682cd22a01ffb304, 0x895af6415a07967b, 0x5af3c0809c2cdf81,
  0x00b79bcd914180ef, 0x40ef9537a94e4a74, 0xaa2d3574e31bc674, 0xe65f36dce455bd8a, 0x58df1726ae0f3612,
  0x7ea75663c81f9434, 0x4ffef0f7bca1854e, 0x687993fc0fe32fcc, 0x7c68f45fe07efd86, 0x9f0271964b867a61,
  0x95fb9a19961d252d, 0x0007c9883544053c,
};

/*
 * m169_u2x12_uart0_lednop_pr_ee_u4  m169a_u2x12_uart0_lednop_pr_ee    m169a_u2x12_uart0_lednop_pr_ee_u4
 * m169p_u2x12_uart0_lednop_pr_ee    m169p_u2x12_uart0_lednop_pr_ee_u4 m169pa_u2x12_uart0_lednop_pr_ee
 * m169pa_u2x12_uart0_lednop_pr_ee_u4 m165_u2x12_uart0_lednop_pr_ee
 * m165_u2x12_uart0_lednop_pr_ee_u4  m165a_u2x12_uart0_lednop_pr_ee    m165a_u2x12_uart0_lednop_pr_ee_u4
 * m165p_u2x12_uart0_lednop_pr_ee    m165p_u2x12_uart0_lednop_pr_ee_u4 m165pa_u2x12_uart0_lednop_pr_ee
 * m165pa_u2x12_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_pr_ee[] = {
  0xbb686bc1a2447032, 0xeeaaf2207ee25bbb, 0x9005f5176c8eeeee, 0x30987f75e475e0cd, 0xce5829ca85b4bb27,
  0x02416caef2775b11, 0xfcf02cfefb9827c6, 0xcda9f55ba7c24a7b, 0xe7186d1bdaa3949f, 0x63ea3cacca9aad68,
  0xf1587bf51f06cc1a, 0x2c4522cd3ad08a1d, 0x55c6b26909afa30b, 0xb4648c9a39d5a5cf, 0xf6ac6ab5d0ebce9b,
  0xd973170908a09e46, 0x9e546c11fadc37b2, 0xbf0312b5ec0087d9, 0x01deb5e781013859, 0x94e8016f379b2283,
  0x8ce881df2a6f529c, 0x7b15545a6ae9c637, 0x6c25ccbe6db9c8ab, 0x2868b1be2e4d5c1e, 0x0a9cfd4eacc7903f,
  0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c, 0x0a792bf734332c3a,
  0x00000004ebdd5b88,
};

/*
 * m169_u2x12_uart0_lednop_pr_ce_u4  m169a_u2x12_uart0_lednop_pr_ce    m169a_u2x12_uart0_lednop_pr_ce_u4
 * m169p_u2x12_uart0_lednop_pr_ce    m169p_u2x12_uart0_lednop_pr_ce_u4 m169pa_u2x12_uart0_lednop_pr_ce
 * m169pa_u2x12_uart0_lednop_pr_ce_u4 m165_u2x12_uart0_lednop_pr_ce
 * m165_u2x12_uart0_lednop_pr_ce_u4  m165a_u2x12_uart0_lednop_pr_ce    m165a_u2x12_uart0_lednop_pr_ce_u4
 * m165p_u2x12_uart0_lednop_pr_ce    m165p_u2x12_uart0_lednop_pr_ce_u4 m165pa_u2x12_uart0_lednop_pr_ce
 * m165pa_u2x12_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_pr_ce[] = {
  0xbb686bc1a2447768, 0x7755783236225bbb, 0x4d9711a7b42f7777, 0x60bf7774c997b5a1, 0xbb257df4e711bb06,
  0x4f8c0482d95de4ee, 0x8e1ff9e059f60b30, 0x293f9b53eab74f84, 0xe2fae490da37b547, 0xc4963cf192a7752a,
  0x51f097e21b09117d, 0x4cf1771b95bf003f, 0xcf51fa49ee58cfd6, 0x054c4458e3a7f07a, 0x1f3b2cf4690ce62c,
  0x9a45403ff6678ebd, 0xd7b20ad03cb5b905, 0x9e0404e166fc0c4a, 0xbcde6c8a0c077ad7, 0x7ca9bd4a7253a005,
  0x69aba718de33a207, 0xf36dce18edec5551, 0xf1726ae0f3612e65, 0x75663c81f943458d, 0xef0f7bca1854e7ea,
  0x993fc0fe32fcc4ff, 0x8f45fe07efd86687, 0x271964b867a617c6, 0xb9a19961d252d9f0, 0x375f47144053c95f,
};

/*
 * m169a_u2x12_uart0_lednop_pr_ee_ce m169p_u2x12_uart0_lednop_pr_ee_ce m169pa_u2x12_uart0_lednop_pr_ee_ce
 * m165_u2x12_uart0_lednop_pr_ee_ce  m165a_u2x12_uart0_lednop_pr_ee_ce m165p_u2x12_uart0_lednop_pr_ee_ce
 * m165pa_u2x12_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_pr_ee_ce[] = {
  0xdb435e0ea0a22a20, 0x75578445c712dddd, 0x015b977b1c777777, 0x82917746d82f68a1, 0xa8171abc8989866d,
  0x2416caef27747b16, 0x9e059fe9f9827c60, 0x6a7d56e9f09757ff, 0xf21b46f6a8e527f3, 0x192a77beceffaa37,
  0x273b8dcb9124afcf, 0x2beea53b5958f7cc, 0xfa8f83660d6bfa8f, 0x669d68450298af6f, 0xd484d7d185962291,
  0x648c9a39d5db8f51, 0x58d578d8ebce9bb4, 0xe62e1211413c8ded, 0x546c1132386f65b2, 0x0312b5ec2cc7d99e,
  0xdeb5e781013859bf, 0xe8016f379b228301, 0xe881df2a6f529c94, 0x15545a6ae9c6378c, 0x4b997cdb73863b7b,
  0x8b2d5e5c9ab83cd8, 0xcfd4eacc7903f286, 0x7993fc09c69430a9, 0xe19e985727e03e68, 0x87494b67c09c6592,
  0x71014f257ee68665, 0x000000000013f1eb,
};

/*
 * m169a_u2x12_uart0_lednop_pr_ee_ce_u4 m169p_u2x12_uart0_lednop_pr_ee_ce_u4
 * m169pa_u2x12_uart0_lednop_pr_ee_ce_u4 m165_u2x12_uart0_lednop_pr_ee_ce_u4
 * m165a_u2x12_uart0_lednop_pr_ee_ce_u4 m165p_u2x12_uart0_lednop_pr_ee_ce_u4
 * m165pa_u2x12_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_pr_ee_ce_u4[] = {
  0xddb435e0d1219f68, 0xeeaaeb9012312ddd, 0xef234176c4eeeeee, 0xfa44b11ddc768274, 0xf44f69c164777048,
  0x180905b2bbc9dd2a, 0x1ff62bb3eff2609f, 0xfe6d4faadd3e120d, 0x8e43c368ded51ca4, 0xe7942e0e25ab8bea,
  0xbf10d8488bee24b1, 0xc6e0224c03fa8f84, 0x529dadcdbdf33c5d, 0xc1b306b5fd4795f7, 0xb422814c57b7fd47,
  0x6be8c2cb1148b34e, 0x4d1ceaedc7a8ea42, 0xbc6c75e74dda3246, 0x0908a09e46f6ac6a, 0x08991c37b2d97317,
  0x5af61663eccf2a36, 0xf3c0809c2cdf8189, 0xb79bcd914180ef5a, 0xef9537a94e4a7400, 0x2d3574e31bc67440,
  0xbe6db9c31dbd8aaa, 0xd1637c371e6c25cc, 0x39fa9d599bf83bb8, 0x313ffbc3def28615, 0x19a1e64ff03f8cbf,
  0x85f1a3d17f81fbf6, 0xb67c09c6592e19e9, 0xf257ee6866587494, 0x000027e5c41dba2c,
};

/*
 * m169a_u2x12_uart0_lednop_hw       m169p_u2x12_uart0_lednop_hw       m169pa_u2x12_uart0_lednop_hw
 * m168pb_u2x12_uart0_lednop_hw      m165_u2x12_uart0_lednop_hw        m165a_u2x12_uart0_lednop_hw
 * m165p_u2x12_uart0_lednop_hw       m165pa_u2x12_uart0_lednop_hw
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_hw[] = {
  0xbbb686bc1d66ef3a, 0xddd55ce0be9625bb, 0x3fe2d83ed43ddddd, 0x4cf9beeeec44489e, 0xe4ee82f4135901b6,
  0x9f304f8c0482d95d, 0xa7c24807fe1c79f0, 0xdaa3949fcda9f55b, 0x3dac77cb08786d1b, 0x20fc71d3f83417ea,
  0xd219cc580b2ca6f9, 0xecc11d7a3e7659e8, 0xe59eda0b348a807f, 0x37e06256bd905681, 0x603bd6bcf020270b,
  0x929d002de6f36450, 0xf19d103be54dea53, 0x6f62aa8b4d5d38c6, 0xed84b997cdb73915, 0xb867a615c9f9fd86,
  0x1d252d964a271964, 0xbb053c95fb9a1996, 0x000000000004710e,
};

/*
 * m169a_u2x12_uart0_lednop_ee_hw    m169p_u2x12_uart0_lednop_ee_hw    m169pa_u2x12_uart0_lednop_ee_hw
 * m168pb_u2x12_uart0_lednop_ee_hw   m165_u2x12_uart0_lednop_ee_hw     m165a_u2x12_uart0_lednop_ee_hw
 * m165p_u2x12_uart0_lednop_ee_hw    m165pa_u2x12_uart0_lednop_ee_hw   pwm216_u2x12_uart0_lednop_ee_hw
 * pwm316_u2x12_uart0_lednop_ee_hw
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_ee_hw[] = {
  0xbb686bc1a2432493, 0xeeaaf2207ee25bbb, 0x9b200bf6a2eeeeee, 0x4e6130feebc8ebc1, 0x0dc82b4ed50b6976,
  0x9f180905b2bbc9dd, 0x4a7bfe8533fbee60, 0x949fcda9f55ba7c2, 0xad68e7186d1bdaa3, 0xcc1a63ea3cacca9a,
  0x8a1df1587bf51f06, 0xa30b2c4522cd3ad0, 0xa5cf55c6b26909af, 0xce9bb4648c9a39d5, 0x9e46f6ac6ab5d0eb,
  0x37b2d973170908a0, 0x87d99e546c11fadc, 0x3859bf0312b5ec00, 0x228301deb5e78101, 0x529c94e8016f379b,
  0xc6378ce881df2a6f, 0xc8ab7b15545a6ae9, 0x371e6c25ccbe6db9, 0xef79430a9cfd4176, 0xf81fc65f989ffde1,
  0xbfc0fdfb0cd0f327, 0x2c970cf4c2f8d1e8, 0x332c3a4a5b3e04e3, 0x7cc1128a792bf734, 0x000000000000000b,
};

/*
 * m169a_u2x12_uart0_lednop_ce_hw    m169p_u2x12_uart0_lednop_ce_hw    m169pa_u2x12_uart0_lednop_ce_hw
 * m168pb_u2x12_uart0_lednop_ce_hw   m165_u2x12_uart0_lednop_ce_hw     m165a_u2x12_uart0_lednop_ce_hw
 * m165p_u2x12_uart0_lednop_ce_hw    m165pa_u2x12_uart0_lednop_ce_hw
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_ce_hw[] = {
  0xbb686bc1a243280b, 0x7755783236225bbb, 0x429b2e3a34f77777, 0x0cc17eeee9932f6b, 0x93bb939eb6b4e376,
  0x2cc13e30120b6577, 0x4f848e1ffd0a67d8, 0xb547293f9b53eab7, 0x952ae2fae490da37, 0x22fb892c79e50b83,
  0x347ea3e12fc43612, 0xcfd64cf1771b9ff0, 0xf07acf51fa49ee58, 0xe62c054c4458e3a7, 0x8ebd1f3b2cf4690c,
  0xb9059a45403ff667, 0x0c4ad7b20ad03cb5, 0x7ad79e0404e166fc, 0xa005bcde6c8a0c07, 0xa2077ca9bd4a7253,
  0x555169aba718de33, 0x2e65f36dce18edec, 0x54e7ea0bb1b8f361, 0xfcc4ffef0f7bca18, 0xd86687993fc0fe32,
  0xa617c68f45fe07ef, 0x52d9f0271964b867, 0x53c95fb9a19961d2, 0x0000000eb3795594,
};

/*
 * m169_u2x12_uart0_lednop_ee_ce_u4_hw m169a_u2x12_uart0_lednop_ee_ce_hw
 * m169a_u2x12_uart0_lednop_ee_ce_u4_hw m169p_u2x12_uart0_lednop_ee_ce_hw
 * m169p_u2x12_uart0_lednop_ee_ce_u4_hw m169pa_u2x12_uart0_lednop_ee_ce_hw
 * m169pa_u2x12_uart0_lednop_ee_ce_u4_hw m168pb_u2x12_uart0_lednop_ee_ce_hw
 * m168pb_u2x12_uart0_lednop_ee_ce_u4_hw m165_u2x12_uart0_lednop_ee_ce_hw
 * m165_u2x12_uart0_lednop_ee_ce_u4_hw m165a_u2x12_uart0_lednop_ee_ce_hw
 * m165a_u2x12_uart0_lednop_ee_ce_u4_hw m165p_u2x12_uart0_lednop_ee_ce_hw
 * m165p_u2x12_uart0_lednop_ee_ce_u4_hw m165pa_u2x12_uart0_lednop_ee_ce_hw
 * m165pa_u2x12_uart0_lednop_ee_ce_u4_hw pwm216_u2x12_uart0_lednop_ee_ce_hw
 * pwm216_u2x12_uart0_lednop_ee_ce_u4_hw pwm316_u2x12_uart0_lednop_ee_ce_hw
 * pwm316_u2x12_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u2x12_uart0_lednop_ee_ce_hw[] = {
  0x76d0d78344867f3e, 0xbaabae4048c4b777, 0xbc8d05db13bbbbbb, 0xe912c47771da09d3, 0xaa8bf5d6d1ddc123,
  0xe30120b657793bb1, 0x347fd0a67dfe4c13, 0x93f9b53eab74f848, 0xaa390f0da37b5472, 0xc79e50b83896ae2f,
  0x12fc4361222fb892, 0x5dc6e5253397ea3e, 0xf7529dadcdbdf33c, 0x47c1b306b5fd4795, 0x4eb422814c57b7fd,
  0x426be8c2cb1148b3, 0x464d1ceaedc7a8ea, 0x6abc6c75e74dda32, 0x170908a09e46f6ac, 0x3608991c37b2d973,
  0x895af61663eccf2a, 0x5af3c0809c2cdf81, 0x00b79bcd914180ef, 0x40ef9537a94e4a74, 0xaa2d3574e31bc674,
  0xccbe6db9c31dbd8a, 0x9cfd4176371e6c25, 0x989ffde1ef79430a, 0x0cd0f327f81fc65f, 0xc2f8d1e8bfc0fdfb,
  0x5b3e04e32c970cf4, 0x792bf734332c3a4a, 0x0000005015c41e8a,
};

/*
 * m169a_u2x12_uart0_dual            m169p_u2x12_uart0_dual            m169pa_u2x12_uart0_dual
 * m165_u2x12_uart0_dual             m165a_u2x12_uart0_dual            m165p_u2x12_uart0_dual
 * m165pa_u2x12_uart0_dual
 */
static const uint64_t ur_m169_u2x12_uart0_dual[] = {
  0x77774c9f37d44511, 0xdddddbf2a1c4e36b, 0x1db83d38056b62dd, 0xb229c6477775a5d9, 0x92b6ee57ccfb4b13,
  0xe609f180905b2bbc, 0xddd6d03225252190, 0xc4b881850c1b48c0, 0x3487fccae3d73ba7, 0xd4728bb072670f9d,
  0x22847244fe0dfc9b, 0xe1f0a21895fe7ef8, 0x55777bbe6e1c1006, 0x6fc54219683de886, 0x96de037fd01cf098,
  0xfe901260b0de5790, 0xe6d4faadd3e1209f, 0xabfc368ded51ca4f, 0xf83487ea3dc33be5, 0x17f0e65ae4d471d3,
  0x16ec27d1a0b398b0, 0xac349b8e58c11d79, 0xf64fe2af9ddc5494, 0xc0809c2cdf81895a, 0x8016f37980ef5af3,
  0x53e02d4e48a5abce, 0xc67440cbfc502169, 0xcd84b997cdb4e31b, 0x0ae4fcfec5c9ab83, 0x6cf8138cb25c33d3,
  0xe4afdcd0ccb0e929, 0x00000196fdba2029,
};

/*
 * m169_u2x12_uart0_dual_pr_u4       m169a_u2x12_uart0_dual_pr         m169a_u2x12_uart0_dual_pr_u4
 * m169p_u2x12_uart0_dual_pr         m169p_u2x12_uart0_dual_pr_u4      m169pa_u2x12_uart0_dual_pr
 * m169pa_u2x12_uart0_dual_pr_u4     m165_u2x12_uart0_dual_pr          m165_u2x12_uart0_dual_pr_u4
 * m165a_u2x12_uart0_dual_pr         m165a_u2x12_uart0_dual_pr_u4      m165p_u2x12_uart0_dual_pr
 * m165p_u2x12_uart0_dual_pr_u4      m165pa_u2x12_uart0_dual_pr        m165pa_u2x12_uart0_dual_pr_u4
 */
static const uint64_t ur_m169_u2x12_uart0_dual_pr[] = {
  0xdd327cde890c0668, 0x776fca86828daddd, 0x33b2477a93377777, 0x3da05eeee841f4ec, 0xe07d6089f7c7f57c,
  0x180905b2bbc9866e, 0x03225252292a609f, 0x1850c1b48c0ddd6d, 0xfccab773ba7c4b88, 0x4bb0386702973305,
  0xe489fc1fee9bd477, 0x44312bfcfdf04508, 0xf77cdcff800dc3e1, 0x8432d05f110caaee, 0xa57fd01cf099ef8a,
  0x5e60b0de579096de, 0x3eab74f84bbaff73, 0x0da37b547293f9b5, 0x21fd47c8a77cb135, 0x1e69c5ef8e3a7f06,
  0x6b591d7f398b0154, 0x500ffd9823af0067, 0x49d03cb3db10e90d, 0xf64fe2af9ddc5495, 0xc0809c2cdf81895a,
  0x9bcd914180ef5af3, 0x9537a94e4a7400b7, 0x3574e31bc67440ef, 0x36dce455bd8aaa2d, 0xb1be1b8f3612e65f,
  0xfd4eaccdfc1ddc68, 0x9ffde1ef79430a9c, 0xd0f327f81fc65f98, 0xf8d1e8bfc0fdfb0c, 0x3e04e32c970cf4c2,
  0x2bf734332c3a4a5b, 0x002926a9acdd1679,
};

/*
 * m169a_u2x12_uart0_dual_pr_ee      m169p_u2x12_uart0_dual_pr_ee      m169pa_u2x12_uart0_dual_pr_ee
 * m165_u2x12_uart0_dual_pr_ee       m165a_u2x12_uart0_dual_pr_ee      m165p_u2x12_uart0_dual_pr_ee
 * m165pa_u2x12_uart0_dual_pr_ee
 */
static const uint64_t ur_m169_u2x12_uart0_dual_pr_ee[] = {
  0x74c9f370f5a1a5fb, 0xddbf19051f36b777, 0x0eb843dd9bdddddd, 0xb05ff4f74dd00aad, 0x75c892ac4d744feb,
  0xb657793939dd2c8d, 0x2911f74c13e30120, 0xda4606eeb6819129, 0xb9dd3e25c40c2860, 0x83869a99fe7e655b,
  0x1f4fcdea3ffcd806, 0xfcfdf04508e489fc, 0x49400dc3e144312b, 0xe1a21955ddeef9b8, 0xe784ce4e2a10cb40,
  0xe579096de87ffe80, 0x0969bff735e60b0d, 0x8e527f36a7d56e9f, 0x6ab5a39121b46f6a, 0x3660c14f51e56bee,
  0x8450ef8aea57a8f8, 0x7d185962291669d6, 0xb4b994b8a973484d, 0x7a89768851ef673a, 0x04547cf58d56ba1d,
  0x86f65f4b3170908a, 0x0427f58a8d823f5b, 0xec9fc55f3bb8a928, 0x81013859bf0312b5, 0x379b228301deb5e7,
  0x2a6f529c94e8016f, 0x6ae9c6378ce881df, 0x6db9c8ab7b15545a, 0x3a7c371e6c25ccbe, 0xd4eaccdfc1ddc68b,
  0x8cbf313f9430a9cf, 0xeffe09a1e64ff173, 0x592e19e985727e39, 0x66587494b67c09c6, 0x98c5ba2cf257ee68,
  0x00000000000000ac,
};

/*
 * m169a_u2x12_uart0_dual_pr_ee_u4   m169p_u2x12_uart0_dual_pr_ee_u4   m169pa_u2x12_uart0_dual_pr_ee_u4
 * m165_u2x12_uart0_dual_pr_ee_u4    m165a_u2x12_uart0_dual_pr_ee_u4   m165p_u2x12_uart0_dual_pr_ee_u4
 * m165pa_u2x12_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m169_u2x12_uart0_dual_pr_ee_u4[] = {
  0x7774c9f37a2432db, 0xddddbf19075b36b7, 0xfdd8becad4d7dddd, 0xb502ffa7bb625d96, 0x22ac07c674a3f738,
  0x905b2bbc9b82ee38, 0x4a4a42e0a609f180, 0x18369181bbada064, 0x56ee774f8971030a, 0x2c7ce1ff260d1f99,
  0xfc1f57cdea3f4fec, 0x2bfcfdf04508e489, 0xb895000dc3e14431, 0x412b221955ddeef9, 0x80e784cbee2a10cb,
  0x86f2bc84b6e707fe, 0x4f84b2b7fb9af305, 0xb547293f9b53eab7, 0xf7355ad1e950da37, 0x7c1b307f27a8f2b8,
  0xeb422877c5663fd4, 0x26be8c2cb1148b34, 0x3ab4b84f5c20b9a4, 0x75ed62761f11f487, 0x51d023a976355ae8,
  0x6e1bd971f18b8484, 0x5f3bb8a92ae04ffd, 0x59bf0312b5ec9fc5, 0x8301deb5e7810138, 0x9c94e8016f379b22,
  0x378ce881df2a6f52, 0xab7b15545a6ae9c6, 0x1e6c25ccbe6db9c8, 0x9bf83bb8d1637c37, 0xdef2861539fa9d59,
  0xf03f8cbf313ffbc3, 0x7f81fbf619a1e64f, 0x592e19e985f1a3d1, 0x66587494b67c09c6, 0x42cdba2cf257ee68,
  0x0000000000000056,
};

/*
 * m169_u2x12_uart0_dual_pr_ce_u4    m169a_u2x12_uart0_dual_pr_ce      m169a_u2x12_uart0_dual_pr_ce_u4
 * m169p_u2x12_uart0_dual_pr_ce      m169p_u2x12_uart0_dual_pr_ce_u4   m169pa_u2x12_uart0_dual_pr_ce
 * m169pa_u2x12_uart0_dual_pr_ce_u4  m165_u2x12_uart0_dual_pr_ce       m165_u2x12_uart0_dual_pr_ce_u4
 * m165a_u2x12_uart0_dual_pr_ce      m165a_u2x12_uart0_dual_pr_ce_u4   m165p_u2x12_uart0_dual_pr_ce
 * m165p_u2x12_uart0_dual_pr_ce_u4   m165pa_u2x12_uart0_dual_pr_ce     m165pa_u2x12_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m169_u2x12_uart0_dual_pr_ce[] = {
  0xbba64f9bd121a5fb, 0xdddbf14dd179b5bb, 0xaf4fbfb5a16ddddd, 0xeb410f7774c894a2, 0x74b235d70f8ab2ab,
  0x8c0482d95de4c1b7, 0x0644a4a43b77304f, 0x30a18369181bbada, 0xf9956ee774f89710, 0x5b031f380cdcdbb5,
  0x489fc193a9bd470b, 0x4312bfcfdf04508e, 0xef9b9d6600dc3e14, 0x0cb41c9a21955dde, 0xbfe80e784d01a2a1,
  0x30586f2bc84b6e35, 0xab74f84b027fb9af, 0xa37b547293f9b53e, 0xb838e96e2faa010d, 0x61222fb892c79e50,
  0x527ebfea3e12fc43, 0x2c67d4b99e2ee370, 0x9fc1d4bf51c6fcf7, 0xf398b014141f238e, 0x9e3af00676b591d7,
  0xd6e10e90d500ffd9, 0xbe777152552740f2, 0xb37e06256bd93f8a, 0x0603bd6bcf020270, 0x3929d002de6f3645,
  0x6f19d103be54dea5, 0x76f62aa8b4d5d38c, 0x79b09732f9b6e70c, 0x6fe0eee3458df0dc, 0x7bca1854e7ea7566,
  0xc0fe32fcc4ffef0f, 0xfe07efd86687993f, 0x64b867a617c68f45, 0x9961d252d9f02719, 0x9a06e8b3c95fb9a1,
  0x0000000000001a48,
};

/*
 * m169a_u2x12_uart0_dual_pr_ee_ce   m169p_u2x12_uart0_dual_pr_ee_ce   m169pa_u2x12_uart0_dual_pr_ee_ce
 * m165_u2x12_uart0_dual_pr_ee_ce    m165a_u2x12_uart0_dual_pr_ee_ce   m165p_u2x12_uart0_dual_pr_ee_ce
 * m165pa_u2x12_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m169_u2x12_uart0_dual_pr_ee_ce[] = {
  0x7774c9f37d435202, 0xddddbf3c783e36b7, 0x435deeb7b7d7dddd, 0x038bd1deeabe0868, 0x6d1717e6be44fb84,
  0x5b2bbc9014ee721d, 0x520c7ae609f18090, 0xb48c0ddd6d032252, 0x73ba7c4b881850c1, 0x9c0d6e6986fccab7,
  0xd6fcdea38a4d87eb, 0xcfdf04508e489fc1, 0x0000dc3e144312bf, 0x64432abbbddf3700, 0xf09a574542196845,
  0xaf212dbdadffd01c, 0x563ffee6bcc161bc, 0x949fcda9f55ba7c2, 0xfd51b9386d1bdaa3, 0x5afcf285c1c1ac77,
  0x9374c273b8dcbc3e, 0xe7a8f2b7f253b595, 0xc5701bd47c1b306b, 0xb1148b34eb422814, 0xdc650ea426be8c2c,
  0xa25da2147bd9ceae, 0x2a3e7ac6abc6c75e, 0x7b2fa598b8484502, 0x89fd62a3608991c3, 0x27f157ceee2a4a59,
  0x404e166fc0c4ad7b, 0xe6c8a0c077ad79e0, 0x9bd4a7253a005bcd, 0xba718de33a2077ca, 0xdce18edec555169a,
  0xce1b8f3612e65f36, 0xdd599bf83bb8d163, 0x38cb25c33d30ae4f, 0xcd0ccb0e9296cf81, 0x6083cbb7459e4afd,
  0x0000000000000002,
};

/*
 * m169a_u2x12_uart0_dual_pr_ee_ce_u4 m169p_u2x12_uart0_dual_pr_ee_ce_u4
 * m169pa_u2x12_uart0_dual_pr_ee_ce_u4 m165_u2x12_uart0_dual_pr_ee_ce_u4
 * m165a_u2x12_uart0_dual_pr_ee_ce_u4 m165p_u2x12_uart0_dual_pr_ee_ce_u4
 * m165pa_u2x12_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_u2x12_uart0_dual_pr_ee_ce_u4[] = {
  0xa64f9bd15b77ac4f, 0xedf9855821b5bbbb, 0xae3793d721eeeeee, 0xa56eb3edfb19cc89, 0xa0d5d7bccd937514,
  0x498ee9a75571f5b4, 0x609f180905b2bbc9, 0xeb681912929196d2, 0x5c40c2860da4606e, 0x9cbf32d2df9dd3e2,
  0xfacf60c8670a4a99, 0x47244fe0e61a6f51, 0x0a21895fe7ef8228, 0xdeef9b8b82006e1f, 0x42196818fa21955d,
  0x5bffa039e13757c5, 0x1982c3795e425b73, 0xd56e9f09620ffc7e, 0xb46f6a8e527f36a7, 0x9d8cddc5f546a7a1,
  0x2445f71258f3ca17, 0x7907fd47c25f886c, 0x9b9ba678bb8dcd50, 0xbe7a8f2b7f253b5b, 0x4c5701bd47c1b306,
  0xcb1148b34eb42281, 0xedc650ea426be8c2, 0xea25da2147bd9cea, 0x22a3e7ac6abc6c75, 0x37b2fa598b848450,
  0x989fd62a3608991c, 0xb27f157ceee2a4a5, 0x0404e166fc0c4ad7, 0xde6c8a0c077ad79e, 0xa9bd4a7253a005bc,
  0xaba718de33a2077c, 0x6dce18edec555169, 0x726ae0f3612e65f3, 0xcdfc1fb763458df1, 0xef79430a9cfd4eac,
  0xf81fc65f989ffde1, 0xbfc0fdfb0cd0f327, 0x2c970cf4c2f8d1e8, 0x332c3a4a5b3e04e3, 0x64e791ba792bf734,
  0x0000000000002000,
};

/*
 * m169a_u2x12_uart0_dual_hw         m169p_u2x12_uart0_dual_hw         m169pa_u2x12_uart0_dual_hw
 * m165_u2x12_uart0_dual_hw          m165a_u2x12_uart0_dual_hw         m165p_u2x12_uart0_dual_hw
 * m165pa_u2x12_uart0_dual_hw
 */
static const uint64_t ur_m169_u2x12_uart0_dual_hw[] = {
  0xee993e6f4486d0e3, 0xbbb7e5434146d6ee, 0x19d923bd499bbbbb, 0x1ed02f777420fa76, 0x9bbab8da0ee44abe,
  0x27c602416caef261, 0x5b40c894948a4a98, 0xe20614306d230377, 0xc17f32addcee9f12, 0x1dd2ec0e19c0a5cc,
  0x4239227f07fba6f5, 0xf8510c4aff3f7c11, 0xbbbddf373fe00370, 0xe2a10cb417c4432a, 0xb7a95ff4073c267b,
  0xfa91982c3795e425, 0xda9f55ba7c25dd7f, 0x9a86d1bdaa3949fc, 0x8310fea3e453be58, 0xaa0f34e2f7c71d3f,
  0x33b5ac8ebf9cc580, 0x86a807fecc11d780, 0x4aa4e81e59ed8874, 0xad7b27f157ceee2a, 0x79e0404e166fc0c4,
  0x5bcde6c8a0c077ad, 0x77ca9bd4a7253a00, 0x169aba718de33a20, 0x2f9b6e722adec555, 0x3f505d8dc79b0973,
  0x27ff787bde50c2a7, 0x343cc9fe07f197e6, 0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30, 0x4afdcd0ccb0e9296,
  0x0000637554d6a29e,
};

/*
 * m169a_u2x12_uart0_dual_ee_hw      m169p_u2x12_uart0_dual_ee_hw      m169pa_u2x12_uart0_dual_ee_hw
 * m165_u2x12_uart0_dual_ee_hw       m165a_u2x12_uart0_dual_ee_hw      m165p_u2x12_uart0_dual_ee_hw
 * m165pa_u2x12_uart0_dual_ee_hw
 */
static const uint64_t ur_m169_u2x12_uart0_dual_ee_hw[] = {
  0x774c9f37a2431f02, 0xdddbf19051f36b77, 0xd0eb843dd9bddddd, 0xbb05ff4f74dd00aa, 0x88b37a6144d744fe,
  0x905b2bbc9c9cee51, 0x949488fba609f180, 0x306d2303775b40c8, 0xaddcee9f12e20614, 0x0341c34d4cff3f32,
  0xfe0fa7e6f51ffe6c, 0x95fe7ef822847244, 0xdc24a006e1f0a218, 0xa070d10caaeef77c, 0x4073c26727150865,
  0x86f2bc84b6f43fff, 0x9f0969bfff523305, 0x6a8e527f36a7d56e, 0xee6ab5a39121b46f, 0xf83660c14f51e56b,
  0xd68450ef8aea57a8, 0x4d7d185962291669, 0x3ab4b994b8a97348, 0x1d7a89768851ef67, 0x8a04547cf58d56ba,
  0x5b86f65f4b317090, 0x280427f58a8d823f, 0xb5ec9fc55f3bb8a9, 0xe781013859bf0312, 0x6f379b228301deb5,
  0xdf2a6f529c94e801, 0x5a6ae9c6378ce881, 0xbe6db9c8ab7b1554, 0xfd4176371e6c25cc, 0x9ffde1ef79430a9c,
  0xd0f327f81fc65f98, 0xf8d1e8bfc0fdfb0c, 0x3e04e32c970cf4c2, 0x2bf734332c3a4a5b, 0x000002bb58c68a79,
};

/*
 * m169a_u2x12_uart0_dual_ce_hw      m169p_u2x12_uart0_dual_ce_hw      m169pa_u2x12_uart0_dual_ce_hw
 * m165_u2x12_uart0_dual_ce_hw       m165a_u2x12_uart0_dual_ce_hw      m165p_u2x12_uart0_dual_ce_hw
 * m165pa_u2x12_uart0_dual_ce_hw
 */
static const uint64_t ur_m169_u2x12_uart0_dual_ce_hw[] = {
  0x774c9f37a2435032, 0xbbb7e29ba2f36b77, 0x5e9f7f6b42dbbbbb, 0xd6821eeee9912945, 0xddd57b68fef76557,
  0x3e30120b65779306, 0x6819129290eddcc1, 0x40c2860da4606eeb, 0xd7e655bb9dd3e25c, 0x2d6c0c7ce033736e,
  0x39227f064ea6f51c, 0x510c4aff3f7c1142, 0x7bbe6e75980370f8, 0x8432d07268865577, 0xd6ffa039e134068a,
  0x8cc161bcaf212db8, 0xf55ba7c25813ffd4, 0x6d1bdaa3949fcda9, 0x85c1c74b717d5008, 0x1b09117dc4963cf2,
  0xc7f9883f51f097e2, 0xdcb19f52e678bb8d, 0x3a7f0752fd471bf3, 0x5fce62c050507c8e, 0x6678ebc019dad647,
  0xcb5b843a435403ff, 0x2af9ddc549549d03, 0xc2cdf81895af64fe, 0x14180ef5af3c0809, 0x94e4a7400b79bcd9,
  0x31bc67440ef9537a, 0x31dbd8aaa2d3574e, 0x71e6c25ccbe6db9c, 0xf79430a9cfd41763, 0x81fc65f989ffde1e,
  0xfc0fdfb0cd0f327f, 0xc970cf4c2f8d1e8b, 0x32c3a4a5b3e04e32, 0xaa6828a792bf7343, 0x000000000000009b,
};

/*
 * m169a_u2x12_uart0_dual_ee_ce_hw   m169p_u2x12_uart0_dual_ee_ce_hw   m169pa_u2x12_uart0_dual_ee_ce_hw
 * m165_u2x12_uart0_dual_ee_ce_hw    m165a_u2x12_uart0_dual_ee_ce_hw   m165p_u2x12_uart0_dual_ee_ce_hw
 * m165pa_u2x12_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m169_u2x12_uart0_dual_ee_ce_hw[] = {
  0x774c9f37d41432db, 0xdddbf3c783e36b77, 0x35deeb7b7d7ddddd, 0x38bd1deeabe08684, 0x1156699d644fb840,
  0x482d95de480a771c, 0x2929063d7304f8c0, 0x60da4606eeb68191, 0x5bb9dd3e25c40c28, 0xf5ce06b734c37e65,
  0xe0eb7e6f51c526c3, 0x5fe7ef822847244f, 0x8000006e1f0a2189, 0x22b221955ddeef9b, 0x0e784d2ba2a10cb4,
  0xde579096ded6ffe8, 0xc2563fffea4660b0, 0xa3949fcda9f55ba7, 0x77fd51b9386d1bda, 0x3643fcf285c1c1ac,
  0x959374c273b8dceb, 0x6be7a8f2b7f253b5, 0x14c5701bd47c1b30, 0x2cb1148b34eb4228, 0xaedc650ea426be8c,
  0x5ea25da2147bd9ce, 0x022a3e7ac6abc6c7, 0xc37b2fa598b84845, 0x5989fd62a3608991, 0x7b27f157ceee2a4a,
  0xe0404e166fc0c4ad, 0xcde6c8a0c077ad79, 0xca9bd4a7253a005b, 0x9aba718de33a2077, 0x36dce18edec55516,
  0x6c3b1b8f3612e65f, 0xfe04e34a1854e7ea, 0x4c2b93f01f343cc9, 0xa5b3e04e32c970cf, 0xa792bf734332c3a4,
  0x00000001d751e5e8,
};

/*
 * m169a_u2x12_uart0_dual_ee_ce_u4_hw m169p_u2x12_uart0_dual_ee_ce_u4_hw
 * m169pa_u2x12_uart0_dual_ee_ce_u4_hw m165_u2x12_uart0_dual_ee_ce_u4_hw
 * m165a_u2x12_uart0_dual_ee_ce_u4_hw m165p_u2x12_uart0_dual_ee_ce_u4_hw
 * m165pa_u2x12_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_u2x12_uart0_dual_ee_ce_u4_hw[] = {
  0x74c9f37a28d08f43, 0xddbf30ab0436b777, 0xc89ae3b793dddddd, 0x514a56eb3edfb19c, 0x6ada9c7d7bccd937,
  0x657792931dde27ed, 0x232da4c13e30120b, 0x48c0ddd6d0322525, 0x3ba7c4b881850c1b, 0xc292a6672fccbb09,
  0x869bd47eb3d83219, 0xfbe08a11c913f839, 0x801b87c2886257f9, 0x88655777bbe6e2e0, 0x4dd5f150865a063e,
  0x9096dcd6ffe80e78, 0x07fb3d0e60b0de57, 0x3f9b53eab74f84b1, 0xa353d0da37b54729, 0x9e37c307066ee2fa,
  0xfc4361222fb892c7, 0x8dc524e6ffea3e12, 0x253b5b9b9ba678bb, 0xc1b306be7a8f2b7f, 0xb422814c5701bd47,
  0x6be8c2cb1148b34e, 0xbd9ceaedc650ea42, 0xbc6c75ea25da2147, 0x84845022a3e7ac6a, 0x08991c37b2fa598b,
  0xe2a4a5989fd62a36, 0x0c4ad7b27f157cee, 0x7ad79e0404e166fc, 0xa005bcde6c8a0c07, 0xa2077ca9bd4a7253,
  0x555169aba718de33, 0x2e65f36dce18edec, 0x54e7ea0bb1b8f361, 0xfcc4ffef0f7bca18, 0xd86687993fc0fe32,
  0xa617c68f45fe07ef, 0x52d9f0271964b867, 0xd3c95fb9a19961d2, 0x000001d759642e17,
};

/*
 * m169a_swio10_noled                m169p_swio10_noled                m169pa_swio10_noled
 * m165_swio10_noled                 m165a_swio10_noled                m165p_swio10_noled
 * m165pa_swio10_noled
 */
static const uint64_t ur_m169_swio10_noled[] = {
  0x511377777759bb37, 0x44f5bbb557228322, 0xc4ef8fdd0e28e318, 0x105fd0ef413afad3, 0x869b1006db48bbb1,
  0x0905b2bbc9ddb1ec, 0xf7e879f912609f18, 0x4c4ef9626a5074af, 0x248e3a7f0621fd47, 0x4f1cc580b7ba6ea3,
  0xb1823af173b0df46, 0x5e5caad4ac26b71c, 0x52a8d7738ce6283b, 0xb395daa5beace751, 0x10d2a97debe910e6,
  0xf16bae7b55a22bcb, 0x20eea6c529e1a779, 0x1696d138c6f19d10, 0x5f36c8122adec555, 0x5727e7f61bb612e6,
  0x59289c6592e19e98, 0x57ee6866587494b6, 0x00002a4faf5c7cf2,
};

/*
 * m169_swio10_noled_pr_u4           m169a_swio10_noled_pr             m169a_swio10_noled_pr_u4
 * m169p_swio10_noled_pr             m169p_swio10_noled_pr_u4          m169pa_swio10_noled_pr
 * m169pa_swio10_noled_pr_u4         m165_swio10_noled_pr              m165_swio10_noled_pr_u4
 * m165a_swio10_noled_pr             m165a_swio10_noled_pr_u4          m165p_swio10_noled_pr
 * m165p_swio10_noled_pr_u4          m165pa_swio10_noled_pr            m165pa_swio10_noled_pr_u4
 */
static const uint64_t ur_m169_swio10_noled_pr[] = {
  0x8f7777768911259b, 0x1776aae450b8c4a3, 0x7af4f54c0e26c13c, 0x9ade17b6fd2a45c7, 0x0bfc7f8bdd8e3d05,
  0x793bb2eec4833817, 0x3dcc13e30120b657, 0x22ca0f75fe78167e, 0xf064f7a8f371df2c, 0x0b2ca632a718e3a7,
  0x8f9d9ef476b1cc58, 0xd67aa01ffb30475e, 0xab555aa07967b770, 0x5dce3398a0ed7972, 0x6a96fab39d454aa3,
  0xa5f7afa4439ace57, 0xb9ed5688af2c434a, 0x9b14a7869de7c5ae, 0x44e31bc6744083ba, 0x2048ab7b15545a5b,
  0x9ab83cd84b997cdb, 0x8f207e50d1637c5c, 0xdef2861539fa9d59, 0xf03f8cbf313ffbc3, 0x7f81fbf619a1e64f,
  0x592e19e985f1a3d1, 0x66587494b67c09c6, 0x10171014f257ee68, 0x0000000000001f26,
};

/*
 * m169a_swio10_noled_pr_ee          m169p_swio10_noled_pr_ee          m169pa_swio10_noled_pr_ee
 * m165_swio10_noled_pr_ee           m165a_swio10_noled_pr_ee          m165p_swio10_noled_pr_ee
 * m165pa_swio10_noled_pr_ee
 */
static const uint64_t ur_m169_swio10_noled_pr_ee[] = {
  0x7dddddd0f5a22044, 0xdddaabf0bd05890d, 0xa7a6274b88ce6e64, 0xd0daf4a34cfda9bf, 0x2d4564041b410d7a,
  0x277505272b8210da, 0x69827c602416caef, 0x7283a6ffcf02cf8d, 0x51e5670e6ab5a38f, 0xcbafa8f83660cf5f,
  0x291669d68450ef8a, 0x3593484d7d185962, 0x48e2139d5a5ff72e, 0xc6ab5d0ebce9bb69, 0x98b84845098a3116,
  0xa3608fd6e1bd96cb, 0x5e5caad40226abfa, 0x52a8d7738ce6283b, 0xb395daa5beace751, 0x10d2a97debe910e6,
  0xf16bae7b55a22bcb, 0x20eea6c529e1a779, 0x1696d138c6f19d10, 0x5f36c8122adec555, 0x9f1726ae0f3612e6,
  0x3ab31e40fca1a2ce, 0x2fcc4fe50c2a73f5, 0xff82687993fc5ce3, 0x4b867a615c9f8e7b, 0x961d252d9f027196,
  0x4f44053c95fb9a19, 0x0000000000004ebf,
};

/*
 * m169a_swio10_noled_pr_ee_u4       m169p_swio10_noled_pr_ee_u4       m169pa_swio10_noled_pr_ee_u4
 * m165_swio10_noled_pr_ee_u4        m165a_swio10_noled_pr_ee_u4       m165p_swio10_noled_pr_ee_u4
 * m165pa_swio10_noled_pr_ee_u4
 */
static const uint64_t ur_m169_swio10_noled_pr_ee_u4[] = {
  0x426eeeeed1222582, 0xda776aafc2ed2e25, 0xd1748fe933e3fe24, 0xf229835cdd95b6a6, 0x82d0bc2841b41508,
  0xf2774ed0439765aa, 0x9b9827c602416cae, 0x7528395bfcf02cfe, 0x7a8f2b4ad355ad1f, 0xafe77a8f83660e5f,
  0x2291669d68450ef8, 0xc5133484d7d18596, 0x5118f873ab4bc065, 0xc6ab5d0ebd753760, 0x3170908a322a3e82,
  0xb826beb70decb872, 0xc673141daf2e556a, 0xdf5673a8a9546bb9, 0xf5f4887359caed52, 0xaad115e5886954be,
  0x94f0d3bcf8b5d73d, 0x6378ce8810775362, 0x156f62aa8b4b689c, 0x079b09732f9b6409, 0x0fca1a2c6f8b9357,
  0x50c2a73f53ab31e4, 0xf197e627ff787bde, 0x3f7ec3343cc9fe07, 0xc33d30be347a2ff0, 0x0e9296cf8138cb25,
  0xe2029e4afdcd0ccb, 0x00000000009d748b,
};

/*
 * m169_swio10_noled_pr_ce_u4        m169a_swio10_noled_pr_ce          m169a_swio10_noled_pr_ce_u4
 * m169p_swio10_noled_pr_ce          m169p_swio10_noled_pr_ce_u4       m169pa_swio10_noled_pr_ce
 * m169pa_swio10_noled_pr_ce_u4      m165_swio10_noled_pr_ce           m165_swio10_noled_pr_ce_u4
 * m165a_swio10_noled_pr_ce          m165a_swio10_noled_pr_ce_u4       m165p_swio10_noled_pr_ce
 * m165p_swio10_noled_pr_ce_u4       m165pa_swio10_noled_pr_ce         m165pa_swio10_noled_pr_ce_u4
 */
static const uint64_t ur_m169_swio10_noled_pr_ce[] = {
  0xf26eeeeed1222044, 0xfc776aaf0890ce24, 0xf6475a2e8c1aec1e, 0x9b3fd7d698bcd8b1, 0x70437ae34d4deebc,
  0x5b2bbc9dd4149cba, 0x0b3f6ea609f18090, 0x8beb224a0e04ff3c, 0x1258f3c64a9de56b, 0x47c25f886c2445f7,
  0x678bb8dc4a8b91fd, 0xfa8f924f72c67eb2, 0xbdd0291c74fe0f05, 0xf9d9ef476b1cc580, 0x67aa01ffb33c75e8,
  0xad556a81e5add70d, 0x7738ce6283b5e5ca, 0xaa5beace75152a8d, 0x97debe910e6b395d, 0xe7b55a22bcb10d2a,
  0x6c529e1a779f16ba, 0x138c6f19d1020eea, 0x0218edec5551696d, 0xd5c1e6c25ccbe6d9, 0x7903f2868b1be2e4,
  0xf79430a9cfd4eacc, 0x81fc65f989ffde1e, 0xfc0fdfb0cd0f327f, 0xc970cf4c2f8d1e8b, 0x32c3a4a5b3e04e32,
  0xaca880a792bf7343, 0x000000000000375e,
};

/*
 * m169a_swio10_noled_pr_ee_ce       m169p_swio10_noled_pr_ee_ce       m169pa_swio10_noled_pr_ee_ce
 * m165_swio10_noled_pr_ee_ce        m165a_swio10_noled_pr_ee_ce       m165p_swio10_noled_pr_ee_ce
 * m165pa_swio10_noled_pr_ee_ce
 */
static const uint64_t ur_m169_swio10_noled_pr_ee_ce[] = {
  0xb31ddddddd4477d6, 0xc45ddaabd85160c4, 0x5a33d477a4863b18, 0x1f1f5a353a66b8da, 0xa1232ec20832d5b3,
  0xbbc9dd7ad388a57d, 0xe1a2609f180905b2, 0x9c3941b1fff3c0b3, 0xf192a7763e77fd51, 0xc273b8dc24aca8fc,
  0xe56e9653b5958f7c, 0x3fa8f83660d00f51, 0x1669d68450298ae4, 0x1d484d7d18596229, 0xd291c4273abb77ee,
  0x5b1aaf1b1d79d376, 0x2e62e121142628c4, 0xf546c1132386f65b, 0x76bcb955a9664d57, 0xa2a551aee719cc50,
  0xcd672bb54b7d59ce, 0x9621a552fbd7d221, 0xf3e2d75cf6ab4457, 0x2041dd4d8a53c34e, 0xaa2d2da2718de33a,
  0x997cdb20431dbd8a, 0xa2c79c5c9ab8d84b, 0x5c9fbab31e40fca1, 0x64a271964b867a61, 0x5fb9a19961d252d9,
  0x0029a763fc4053c9,
};

/*
 * m169a_swio10_noled_pr_ee_ce_u4    m169p_swio10_noled_pr_ee_ce_u4    m169pa_swio10_noled_pr_ee_ce_u4
 * m165_swio10_noled_pr_ee_ce_u4     m165a_swio10_noled_pr_ee_ce_u4    m165p_swio10_noled_pr_ee_ce_u4
 * m165pa_swio10_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio10_noled_pr_ee_ce_u4[] = {
  0x90dddddda2436d3a, 0x62eed55fd4f27448, 0x2e94add86656c17e, 0x430a800d8466244d, 0xc667627c88596cf2,
  0x7793bb73b66c7b64, 0xa1f4c13e30120b65, 0x6ea507107fd8aecf, 0xca17073105c5f547, 0x886c2445f71258f3,
  0x73a9cb82fd47c25f, 0x4ed6e6def99e2ee3, 0xd983403d4795ba59, 0x1140a62b90fea3e0, 0xf4616588a459a75a,
  0x9ceaeddfb8752135, 0x6c75e74ddb4a4710, 0x845098a3116c6abc, 0x4c8e1bd96cb98b84, 0x56a599355fd51b04,
  0xbb9c673141daf2e5, 0xd52df5673a8a9546, 0x4bef5f4887359cae, 0x73daad115e588695, 0x36294f0d3bcf8b5d,
  0x89c6378ce8810775, 0x810c76f62aa8b4b6, 0xe1b8f3612e65f36c, 0xeaccdfc1ddc68b1b, 0xde1ef79430a9cfd4,
  0x327f81fc65f989ff, 0x1e8bfc0fdfb0cd0f, 0x4e32c970cf4c2f8d, 0x734332c3a4a5b3e0, 0x4fccb4add16792bf,
};

/*
 * m169a_swio10_noled_hw             m169p_swio10_noled_hw             m169pa_swio10_noled_hw
 * m165_swio10_noled_hw              m165a_swio10_noled_hw             m165p_swio10_noled_hw
 * m165pa_swio10_noled_hw
 */
static const uint64_t ur_m169_swio10_noled_hw[] = {
  0x511377777759bb37, 0x44f5bbb557228322, 0xc4ef8fdd0e28e318, 0x105fd0ef413afad3, 0x869b1006db48bbb1,
  0x0905b2bbc9ddb1ec, 0xfe1c79f912609f18, 0xa6277cb135283a57, 0x92471d3f8310fea3, 0x278e62c05bdd3751,
  0x58c11d78b9d86fa3, 0xaf2e556a56135b8e, 0xa9546bb9c673141d, 0x59caed52df5673a8, 0x886954bef5f48873,
  0xf8b5d73daad115e5, 0x1077536294f0d3bc, 0x8b4b689c6378ce88, 0x2f9b6409156f62aa, 0x2b93f3fb0ddb0973,
  0x2c944e32c970cf4c, 0x2bf734332c3a4a5b, 0x000011c5f5f60a79,
};

/*
 * m169a_swio10_noled_ee_hw          m169p_swio10_noled_ee_hw          m169pa_swio10_noled_ee_hw
 * m165_swio10_noled_ee_hw           m165a_swio10_noled_ee_hw          m165p_swio10_noled_ee_hw
 * m165pa_swio10_noled_ee_hw
 */
static const uint64_t ur_m169_swio10_noled_ee_hw[] = {
  0x6beeeeeed121af43, 0x26eed55f85e82c48, 0x9bdfa7ba5c467373, 0xd7ad0daf4a34cfda, 0x29a2d4564041b410,
  0xd95de4eeb4efb5bb, 0x99f1ad304f8c0482, 0xad1c7b941d37ff42, 0x067afa8f2b387355, 0x877c565d7d47c1b3,
  0xc2cb1148b34eb422, 0xffb971ac9a426be8, 0x4ddb4a47109cead2, 0x5188b6355ae875e7, 0xecb65cc5c242284c,
  0x355fd51b047eb70d, 0x3141daf2e556a011, 0x673a8a9546bb9c67, 0x4887359caed52df5, 0x115e5886954bef5f,
  0x0d3bcf8b5d73daad, 0x8ce881077536294f, 0xf62aa8b4b689c637, 0xb09732f9b6409156, 0x0c2a73f505d8dc79,
  0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0x6a29e4afdcd0ccb0,
  0x000000000016f805,
};

/*
 * m169a_swio10_noled_ce_hw          m169p_swio10_noled_ce_hw          m169pa_swio10_noled_ce_hw
 * m165_swio10_noled_ce_hw           m165a_swio10_noled_ce_hw          m165p_swio10_noled_ce_hw
 * m165pa_swio10_noled_ce_hw
 */
static const uint64_t ur_m169_swio10_noled_ce_hw[] = {
  0xe4dddddda2431768, 0xf8eed55e11219c49, 0xc7ed91dd1835d83d, 0xf26cff5f5a62f362, 0xb5a3d9eb8d3537ba,
  0x0482d95de4ee9ba3, 0xff4299fb75304f8c, 0xcad717d644941c09, 0x17dc4963cf285c1c, 0x6ff51f097e21b091,
  0xfac99e2ee373f5cd, 0x3c17ea3e493dcb19, 0x1602f740a471d3f8, 0xd7a3e767bd1dac73, 0x5c359ea807feccf1,
  0x972ab555aa0796b7, 0xaa35dce3398a0ed7, 0xe576a96fab39d454, 0x34aa5f7afa4439ac, 0x5aeb9ed5688af2c4,
  0x3ba9b14a7869de7c, 0xa5b44e31bc674408, 0x9b640863b7b15545, 0x505d8dc79b09732f, 0xff787bde50c2a73f,
  0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf, 0x00eb37c21fa29e4a,
};

/*
 * m169_swio10_noled_ee_ce_u4_hw     m169a_swio10_noled_ee_ce_hw       m169a_swio10_noled_ee_ce_u4_hw
 * m169p_swio10_noled_ee_ce_hw       m169p_swio10_noled_ee_ce_u4_hw    m169pa_swio10_noled_ee_ce_hw
 * m169pa_swio10_noled_ee_ce_u4_hw   m165_swio10_noled_ee_ce_hw        m165_swio10_noled_ee_ce_u4_hw
 * m165a_swio10_noled_ee_ce_hw       m165a_swio10_noled_ee_ce_u4_hw    m165p_swio10_noled_ee_ce_hw
 * m165p_swio10_noled_ee_ce_u4_hw    m165pa_swio10_noled_ee_ce_hw      m165pa_swio10_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio10_noled_ee_ce_hw[] = {
  0x90dddddda243173e, 0x62eed55fd4f27448, 0x2e94add86656c17e, 0x430a800d8466244d, 0xf667627c88596cf2,
  0x95de4eee7da01d44, 0x3e87d304f8c0482d, 0xa3b75283883fe853, 0x79e50b839882e2fa, 0x2fc4361222fb892c,
  0xc6e6a83c83fea3e1, 0xb29dadcdbdf33c5d, 0xc1b306807a8f2b74, 0xb422814c5721fd47, 0x6be8c2cb1148b34e,
  0x2139d5dbbf70ea42, 0x78d8ebce9bb6948e, 0x0908a1314622d8d5, 0x08991c37b2d97317, 0xcaad4b326abfaa36,
  0x8d7738ce6283b5e5, 0x5daa5beace75152a, 0x2a97debe910e6b39, 0xbae7b55a22bcb10d, 0xea6c529e1a779f16,
  0x6d138c6f19d1020e, 0xd90218edec555169, 0x176371e6c25ccbe6, 0xde1ef79430a9cfd4, 0x327f81fc65f989ff,
  0x1e8bfc0fdfb0cd0f, 0x4e32c970cf4c2f8d, 0x734332c3a4a5b3e0, 0x0140596968a792bf,
};

/*
 * m169a_swio10_lednop               m169p_swio10_lednop               m169pa_swio10_lednop
 * m165_swio10_lednop                m165a_swio10_lednop               m165p_swio10_lednop
 * m165pa_swio10_lednop
 */
static const uint64_t ur_m169_swio10_lednop[] = {
  0x444ddddddd66ef3a, 0x3d6eed55c8a78b89, 0x3da87ba871224611, 0x4417f43bd05af219, 0x135901b64cc6beec,
  0x0482d95de4ee82f4, 0xfbf43cfbf9304f8c, 0xfc877cb135282657, 0xf7c71d3f8310fea3, 0xe80e62c05bdd31ea,
  0x2c608ebc5ced6b23, 0xd7972ab52b39edc7, 0x54aa35dce3398a0e, 0x04e576a96fab39d4, 0xab574bfa4439ae04,
  0x6b9ed5688af2c434, 0xa58594d8b3a03cfd, 0x63fc502169ab9d5e, 0x5f36d38c6f19d103, 0x5727e7f61bb612e6,
  0x59289c6592e19e98, 0x57ee6866587494b6, 0x00001520eb5c7cf2,
};

/*
 * m169_swio10_lednop_pr_u4          m169a_swio10_lednop_pr            m169a_swio10_lednop_pr_u4
 * m169p_swio10_lednop_pr            m169p_swio10_lednop_pr_u4         m169pa_swio10_lednop_pr
 * m169pa_swio10_lednop_pr_u4        m165_swio10_lednop_pr             m165_swio10_lednop_pr_u4
 * m165a_swio10_lednop_pr            m165a_swio10_lednop_pr_u4         m165p_swio10_lednop_pr
 * m165p_swio10_lednop_pr_u4         m165pa_swio10_lednop_pr           m165pa_swio10_lednop_pr_u4
 */
static const uint64_t ur_m169_swio10_lednop_pr[] = {
  0x8f77777689110cc5, 0x0bbb55722998c4a3, 0x6f70add590e3609e, 0x59ade165c76dd08a, 0x4d4c17f1fdd8e3d0,
  0x7793bb06c371fb37, 0xe034c13e30120b65, 0x8459410f7fe78167, 0xfe0c9ef51e713be5, 0x02cb298c79eb1c74,
  0x47cedf22383e7316, 0xbe81500ffd9823af, 0x556b02b40f2cf6f7, 0x6bb9c673141daf2e, 0xed52df5673a8a954,
  0x97f488735c0809ca, 0xaad115e5886956ae, 0xb5f3a03c72b5d73d, 0xde33a20421520b94, 0xadec55516920a718,
  0xf3612e65f36cbb22, 0xf943458df1726ae0, 0x1854e7ea75663c81, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe,
  0x67a617c68f45fe07, 0xd252d9f0271964b8, 0x4053c95fb9a19961, 0x000000007c9bf544,
};

/*
 * m169a_swio10_lednop_pr_ee         m169p_swio10_lednop_pr_ee         m169pa_swio10_lednop_pr_ee
 * m165_swio10_lednop_pr_ee          m165a_swio10_lednop_pr_ee         m165p_swio10_lednop_pr_ee
 * m165pa_swio10_lednop_pr_ee
 */
static const uint64_t ur_m169_swio10_lednop_pr_ee[] = {
  0x7dddddd0f5a232a8, 0xdddaabf0bd91890d, 0x3bc977c7edbe6e64, 0x86d7a5a0a34d68f2, 0x91f06620da086bd6,
  0x774eb46a89ccf971, 0x9827c602416caef2, 0x506397f9e059feaf, 0x3caca1cd56b471ee, 0x05f51f06cc19ebea,
  0x22cd3ad08a1df15b, 0xb26909afa30b2c45, 0x1af873ab4bfce5c6, 0xaad743af3a6ec13d, 0x5c24228c9118dfb1,
  0xb047eb70decb65cc, 0x5caad402b86b3d51, 0xa8d7738ce6283b5e, 0x95daa5beace75152, 0x5d2fe910e6b81013,
  0x7b55a22bcb10d2ad, 0x296be74078e56bae, 0x31bc67440842a417, 0x455bd8aaa2d2414e, 0xc1e6c25ccbe6d976,
  0x1f943459d3e2e4d5, 0xa1854e7ea75663c8, 0x327f8b9c65f989fc, 0x2b93f1cf7ff04d0f, 0xb3e04e32c970cf4c,
  0x92bf734332c3a4a5, 0x000004ebaec880a7,
};

/*
 * m169a_swio10_lednop_pr_ee_u4      m169p_swio10_lednop_pr_ee_u4      m169pa_swio10_lednop_pr_ee_u4
 * m165_swio10_lednop_pr_ee_u4       m165a_swio10_lednop_pr_ee_u4      m165p_swio10_lednop_pr_ee_u4
 * m165pa_swio10_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_swio10_lednop_pr_ee_u4[] = {
  0xa84dddddda244511, 0x9b4eed55f85debc4, 0xd71efd3d1b6c47c4, 0x1e45306bb4b37764, 0xac884082083682a1,
  0xef27755f33e83658, 0xc729827c602416ca, 0xf752836ebfcf02cf, 0xf7a8f2b90f355ad1, 0x8ace1fa8f83660e5,
  0x62291669d68450ef, 0x5c5133484d7d1859, 0x4011a6273ab4b945, 0xac6ab5d0ebd75376, 0x918b848450f7a3b5,
  0xab8b87f5b86f65c3, 0x9c673141daf2e556, 0x2df5673a8a9546bb, 0x488735c0809caed5, 0x115e5886956ae97f,
  0x3a03c72b5d73daad, 0x3a20421520b94b5f, 0xc55516920a718de3, 0x12e65f36cbb22ade, 0x3458df1726ae0f36,
  0x4e7ea75663c81f94, 0xcc4ffef0f7bca185, 0x86687993fc0fe32f, 0x617c68f45fe07efd, 0x2d9f0271964b867a,
  0x3c95fb9a19961d25, 0x0000009d7085c405,
};

/*
 * m169_swio10_lednop_pr_ce_u4       m169a_swio10_lednop_pr_ce         m169a_swio10_lednop_pr_ce_u4
 * m169p_swio10_lednop_pr_ce         m169p_swio10_lednop_pr_ce_u4      m169pa_swio10_lednop_pr_ce
 * m169pa_swio10_lednop_pr_ce_u4     m165_swio10_lednop_pr_ce          m165_swio10_lednop_pr_ce_u4
 * m165a_swio10_lednop_pr_ce         m165a_swio10_lednop_pr_ce_u4      m165p_swio10_lednop_pr_ce
 * m165p_swio10_lednop_pr_ce_u4      m165pa_swio10_lednop_pr_ce        m165pa_swio10_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_swio10_lednop_pr_ce[] = {
  0xf26eeeeed12232a8, 0xfc776aaf08942e24, 0x697571eedb75ec1e, 0x67fafad219e2f7a6, 0xb3ea8b41568dd793,
  0xb2bbc9dd3ad1a848, 0xb3f15a609f180905, 0xbeb224a0efbff3c0, 0x258f3c64a9ddbab8, 0x7c25f886c2445f71,
  0x78bb8dca4a672fd4, 0xa8e0a4f72c67eb26, 0x3da011c74fe0f05f, 0x76f911c1f398b014, 0x0a807feccf1d7a3e,
  0xd605681e5addbdf4, 0x738ce6283b5e5caa, 0xa5beace75152a8d7, 0xe910e6b8101395da, 0xa22bcb10d2ad5d2f,
  0xe74078e56bae7b55, 0x67440842a417296b, 0xd8aaa2d2414e31bc, 0x84b997cdb2ec31db, 0x0d1637c5c9ab83cd,
  0x539fa9d598f207e5, 0xf313ffbc3def2861, 0x619a1e64ff03f8cb, 0x985f1a3d17f81fbf, 0x4b67c09c6592e19e,
  0x4f257ee686658749, 0x00000006eb967101,
};

/*
 * m169a_swio10_lednop_pr_ee_ce      m169p_swio10_lednop_pr_ee_ce      m169pa_swio10_lednop_pr_ee_ce
 * m165_swio10_lednop_pr_ee_ce       m165a_swio10_lednop_pr_ee_ce      m165p_swio10_lednop_pr_ee_ce
 * m165pa_swio10_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_swio10_lednop_pr_ee_ce[] = {
  0xb31ddddddd445541, 0xc45ddaabd85238c4, 0xbe4ed323a8259318, 0x1f1f5a3535834cde, 0xc8ce0db45832d5b3,
  0x7793ba0292634e39, 0xcedcc13e30120b65, 0x70e50776bfcf02cf, 0xc64a9deed1dff546, 0x139dc6e747d493f3,
  0x2b2eb29dacac7be6, 0xfd47c1b306807a8f, 0xb34eb422814c5652, 0xea426be8c2cb1148, 0x9e8d7c39d5dbbe70,
  0xb1aaf1b1d79d3760, 0xcc5c24228c9118df, 0xa8d8226470decb65, 0xaf2e556a59dc359e, 0xa9546bb9c673141d,
  0x09caed52df5673a8, 0x56ae97f488735c08, 0xd73daad115e58869, 0x0b94b5f3a03c72b5, 0xa718de33a2042152,
  0x7618edec55516920, 0xe4d5c6c25ccbe6d9, 0x98f207e50d163ce2, 0xb25c33d30ae4fdd5, 0xcb0e9296cb25138c,
  0x8522029e4afdcd0c, 0x0000000000014d33,
};

/*
 * m169a_swio10_lednop_pr_ee_ce_u4   m169p_swio10_lednop_pr_ee_ce_u4   m169pa_swio10_lednop_pr_ee_ce_u4
 * m165_swio10_lednop_pr_ee_ce_u4    m165a_swio10_lednop_pr_ee_ce_u4   m165p_swio10_lednop_pr_ee_ce_u4
 * m165pa_swio10_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio10_lednop_pr_ee_ce_u4[] = {
  0x21bbbbbb44864541, 0xc5ddaabfa9c0b891, 0x9d69dba34f1782fc, 0x8615001b19391998, 0xc5383774e0b2d9e4,
  0x7793ba8049b9c587, 0xfebcc13e30120b65, 0x6ea506007fd8aecf, 0xca17072005c5f547, 0x886c2445f71258f3,
  0xe05919ebfd47c25f, 0x9dadcdbdf33c5dc6, 0xb306807a8f2b2eb2, 0x22814c5652fd47c1, 0xe8c2cb1148b34eb4,
  0x39d5dbbe70ea426b, 0xb1d79d37609e8d7c, 0x228c9118dfb1aaf1, 0x6470decb65cc5c24, 0x6a59dc359ea8d822,
  0xb9c673141daf2e55, 0x52df5673a8a9546b, 0xf488735c0809caed, 0xd115e5886956ae97, 0xf3a03c72b5d73daa,
  0x33a20421520b94b5, 0xec55516920a718de, 0xc25ccbe6d97618ed, 0x83bb8d1637c371e6, 0x2861539fa9d599bf,
  0xf8cbf313ffbc3def, 0x1fbf619a1e64ff03, 0xe19e985f1a3d17f8, 0x87494b67c09c6592, 0x1ba2cf257ee68665,
  0x00000000009f96e4,
};

/*
 * m169a_swio10_lednop_hw            m169p_swio10_lednop_hw            m169pa_swio10_lednop_hw
 * m165_swio10_lednop_hw             m165a_swio10_lednop_hw            m165p_swio10_lednop_hw
 * m165pa_swio10_lednop_hw
 */
static const uint64_t ur_m169_swio10_lednop_hw[] = {
  0x444ddddddd66ef3a, 0x3d6eed55c8a78b89, 0x3da87ba871224611, 0x4417f43bd05af219, 0x135901b64cc6beec,
  0x0482d95de4ee82f4, 0xff0e3cfbf9304f8c, 0xfe43be589a94132b, 0x7be38e9fc1887f51, 0xf40731602dee98f5,
  0x9630475e2e76b591, 0x6bcb955a959cf6e3, 0x2a551aee719cc507, 0x0272bb54b7d59cea, 0x55aba5fd221cd702,
  0xb5cf6ab44579621a, 0x52c2ca6c59d01e7e, 0xb1fe2810b4d5ceaf, 0x2f9b69c6378ce881, 0x2b93f3fb0ddb0973,
  0x2c944e32c970cf4c, 0x2bf734332c3a4a5b, 0x000008e21d760a79,
};

/*
 * m169a_swio10_lednop_ee_hw         m169p_swio10_lednop_ee_hw         m169pa_swio10_lednop_ee_hw
 * m165_swio10_lednop_ee_hw          m165a_swio10_lednop_ee_hw         m165p_swio10_lednop_ee_hw
 * m165pa_swio10_lednop_ee_hw
 */
static const uint64_t ur_m169_swio10_lednop_ee_hw[] = {
  0x6beeeeeed121b032, 0x26eed55f85ec8c48, 0x8df23bbe3f6df373, 0xbd686d7a5a0a34d6, 0x97191f06620da086,
  0x95de4eeb6239da9c, 0x3fd5f304f8c0482d, 0xa38f72831cbfe853, 0xcf5f51e5650e6ab5, 0xef8ad82fa8f83660,
  0x5962291669d68450, 0xe72e3593484d7d18, 0x7609e8d7c39d5a5f, 0xc6fd8d56ba1d79d3, 0x5b2e62e121146488,
  0x59ea8d823f5b86f6, 0x41daf2e556a015c3, 0x3a8a9546bb9c6731, 0xc0809caed52df567, 0x86956ae97f488735,
  0x2b5d73daad115e58, 0x1520b94b5f3a03c7, 0x920a718de33a2042, 0x36cbb22adec55516, 0xa0bb1b8f3612e65f,
  0xfef0f7bca1854e7e, 0x7993fc0fe32fcc4f, 0x68f45fe07efd8668, 0x0271964b867a617c, 0xfb9a19961d252d9f,
  0x0005be6b05453c95,
};

/*
 * m169a_swio10_lednop_ce_hw         m169p_swio10_lednop_ce_hw         m169pa_swio10_lednop_ce_hw
 * m165_swio10_lednop_ce_hw          m165a_swio10_lednop_ce_hw         m165p_swio10_lednop_ce_hw
 * m165pa_swio10_lednop_ce_hw
 */
static const uint64_t ur_m169_swio10_lednop_ce_hw[] = {
  0xf26eeeeed121b768, 0xfc776aaf08942e24, 0x4f4d2eeedb75ec1e, 0x26cff5f5a433c5ef, 0xed9c551682ad1baf,
  0x2416caef2775d92b, 0xfa14cfc569827c60, 0xbab8beb224a0efbf, 0xbee24b1e7942e0e5, 0x5fa8f84bf10d8488,
  0xd64cf1771b9787cb, 0xe0bf51c149ee58cf, 0x60287b40238e9fc1, 0xf47cedf22383e731, 0x7be81500ffd99e3a,
  0xb955ac0ad03cb5bb, 0x51aee719cc5076bc, 0x2bb54b7d59cea2a5, 0xba5fd221cd702027, 0xf6ab44579621a55a,
  0x52d7ce80f1cad75c, 0x6378ce881085482e, 0x63b7b15545a4829c, 0xc79b09732f9b65d8, 0xde50c2a73f505d8d,
  0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f, 0xcb0e9296cf8138cb, 0xccc5a29e4afdcd0c,
  0x000000000000759b,
};

/*
 * m169_swio10_lednop_ee_ce_u4_hw    m169a_swio10_lednop_ee_ce_hw      m169a_swio10_lednop_ee_ce_u4_hw
 * m169p_swio10_lednop_ee_ce_hw      m169p_swio10_lednop_ee_ce_u4_hw   m169pa_swio10_lednop_ee_ce_hw
 * m169pa_swio10_lednop_ee_ce_u4_hw  m165_swio10_lednop_ee_ce_hw       m165_swio10_lednop_ee_ce_u4_hw
 * m165a_swio10_lednop_ee_ce_hw      m165a_swio10_lednop_ee_ce_u4_hw   m165p_swio10_lednop_ee_ce_hw
 * m165p_swio10_lednop_ee_ce_u4_hw   m165pa_swio10_lednop_ee_ce_hw     m165pa_swio10_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio10_lednop_ee_ce_hw[] = {
  0x90dddddda2431bc1, 0x62eed55fd4e05c48, 0x4eb4edd1a78bc17e, 0x430a800d8c9c8ccc, 0xb29c1bba70596cf2,
  0xcaef277475d35f7b, 0x9ffd79827c602416, 0x51dba941801ff429, 0x3cf285c1c801717d, 0x97e21b09117dc496,
  0x71b8148f9cbf51f0, 0xaca76b736f7ccf17, 0xf06cc1a01ea3cacb, 0xad08a0531594bf51, 0x9afa30b2c4522cd3,
  0x5f0e7576ef9c3a90, 0xbc6c75e74dd827a3, 0x0908a3244637ec6a, 0x08991c37b2d97317, 0x955a96770d67aa36,
  0x1aee719cc5076bcb, 0xbb54b7d59cea2a55, 0xa5fd221cd7020272, 0x6ab44579621a55ab, 0x2d7ce80f1cad75cf,
  0x378ce881085482e5, 0x3b7b15545a4829c6, 0x79b09732f9b65d86, 0xe50c2a73f505d8dc, 0x7f197e627ff787bd,
  0x03f7ec3343cc9fe0, 0x5c33d30be347a2ff, 0xb0e9296cf8138cb2, 0xb90a29e4afdcd0cc, 0x0000000000005015,
};

/*
 * m169_swio10_dual_pr               m169_swio10_dual_pr_u4            m169a_swio10_dual
 * m169a_swio10_dual_pr              m169a_swio10_dual_pr_u4           m169p_swio10_dual
 * m169p_swio10_dual_pr              m169p_swio10_dual_pr_u4           m169pa_swio10_dual
 * m169pa_swio10_dual_pr             m169pa_swio10_dual_pr_u4          m165_swio10_dual
 * m165_swio10_dual_pr               m165_swio10_dual_pr_u4            m165a_swio10_dual
 * m165a_swio10_dual_pr              m165a_swio10_dual_pr_u4           m165p_swio10_dual
 * m165p_swio10_dual_pr              m165p_swio10_dual_pr_u4           m165pa_swio10_dual
 * m165pa_swio10_dual_pr             m165pa_swio10_dual_pr_u4
 */
static const uint64_t ur_m169_swio10_dual[] = {
  0xa34bbbbbbb4486f9, 0x697e276fc75e738d, 0x9da9f7bb06d60d0b, 0x291fc5f4cfed1d62, 0xe7f0c6a08761b74d,
  0xde4ad0ee9b4721dc, 0xc03304f8c0482d95, 0xc0ddd6d032252520, 0xa7c4b881850c1b48, 0x28b3393fccab773b,
  0x54dea3bf9b05f670, 0xf7c114239227f066, 0x80370f8510c4aff3, 0x88655777bbe6e56f, 0x84d6b45421968464,
  0xbc84b6e5d7fe80e7, 0x6a57fb9af30586f2, 0x7d47910ef961f250, 0x6fdc65471d3f8311, 0xe28def398b01541e,
  0x07fecc11d78033b4, 0x181e59edad783ea8, 0x9fc55f3bb8a92dfe, 0xe3398a0ed7972ab5, 0x6fab39d454aa35dc,
  0x4439ae0404e576a9, 0x8af2c434ab574bfa, 0xd01e395aeb9ed568, 0xd10210a905ca5af9, 0x2aa8b490538c6f19,
  0x9732f9b65d9156f6, 0xeee3458df0dc79b0, 0x1854e7ea75666fe0, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe,
  0x67a617c68f45fe07, 0xd252d9f0271964b8, 0xe8b3c95fb9a19961, 0x00000000a49ad3e6,
};

/*
 * m169a_swio10_dual_pr_ee           m169p_swio10_dual_pr_ee           m169pa_swio10_dual_pr_ee
 * m165_swio10_dual_pr_ee            m165a_swio10_dual_pr_ee           m165p_swio10_dual_pr_ee
 * m165pa_swio10_dual_pr_ee
 */
static const uint64_t ur_m169_swio10_dual_pr_ee[] = {
  0xd3b7777775050c86, 0x47c4edf8d4f261b4, 0xf722775261d68166, 0x3d646682ab8858ab, 0x41f1375a266f5da7,
  0x9ceeeec6ecfabf31, 0x09f180905b2bbc9e, 0x5b40c894948ee3e6, 0xe20614306d230377, 0xc7ff32addcee9f12,
  0x393ad825a3805a98, 0x847244fe0e2b4dea, 0xf0a21895fe7ef822, 0xddeef9b8a91006e1, 0x2a10cb417da21955,
  0xd36ffe80e784c1ee, 0x35e60b0de579096d, 0x5ad1945941a1fff7, 0x306657a8f2bdf735, 0x2877c576ebd47c1b,
  0x8c2cb1148b34eb42, 0xb9435c54b9a426be, 0x12ed1ed1e9473ab4, 0x08d31b1aad743af5, 0xecbe9662e1211420,
  0x32b5951b047eb70d, 0x3f8abe777152500a, 0xc673141daf2e556b, 0xdf5673a8a9546bb9, 0x88735c0809caed52,
  0x15e5886956ae97f4, 0xa03c72b5d73daad1, 0xa20421520b94b5f3, 0x55516920a718de33, 0x2e65f36cbb22adec,
  0xee34596af1b8f361, 0x854e7ea75666fe0e, 0xf343cc9fe04e34a1, 0x2c970cf4c2b93f01, 0x332c3a4a5b3e04e3,
  0x0e7cdd16792bf734, 0x0000000000000159,
};

/*
 * m169a_swio10_dual_pr_ee_u4        m169p_swio10_dual_pr_ee_u4        m169pa_swio10_dual_pr_ee_u4
 * m165_swio10_dual_pr_ee_u4         m165a_swio10_dual_pr_ee_u4        m165p_swio10_dual_pr_ee_u4
 * m165pa_swio10_dual_pr_ee_u4
 */
static const uint64_t ur_m169_swio10_dual_pr_ee_u4[] = {
  0xb7777768adbbbb90, 0xc4edf8d4f261b4d3, 0x5a7b5261d6816647, 0x6682ab8858abf227, 0x375a266f5da73d64,
  0xa912bcaf7fd6c1f1, 0x0482d95de4f4e771, 0x44a4a4771f304f8c, 0xa18369181bbada06, 0xb4b7e774f8971030,
  0x0968e016a631ffcc, 0x3f838ad37a8e4eb6, 0x257f9fbe08a11c91, 0x6e2a4401b87c2886, 0xd05f688655777bbe,
  0xa039e1307b8a8432, 0xc3795e425b74dbff, 0x5941a1fffc7e1982, 0xa8f2bdf7355ad194, 0x76ebd47c1b306657,
  0x148b34eb422877c5, 0x54b9a426be8c2cb1, 0xd1e9473ab4b9435c, 0x1aad743af512ed1e, 0x62e121142008d31b,
  0x1b047eb70decbe96, 0x777152500a32b595, 0x1daf2e556b3f8abe, 0xa8a9546bb9c67314, 0x0809caed52df5673,
  0x6956ae97f488735c, 0xb5d73daad115e588, 0x520b94b5f3a03c72, 0x20a718de33a20421, 0x6cbb22adec555169,
  0x726ae0f3612e65f3, 0xcdfc1fb763458df1, 0xef79430a9cfd4eac, 0xf81fc65f989ffde1, 0xbfc0fdfb0cd0f327,
  0x2c970cf4c2f8d1e8, 0x332c3a4a5b3e04e3, 0x96ff91ba792bf734, 0x0000000000002b25,
};

/*
 * m169a_swio10_dual_pr_ce           m169p_swio10_dual_pr_ce           m169pa_swio10_dual_pr_ce
 * m165_swio10_dual_pr_ce            m165a_swio10_dual_pr_ce           m165p_swio10_dual_pr_ce
 * m165pa_swio10_dual_pr_ce
 */
static const uint64_t ur_m169_swio10_dual_pr_ce[] = {
  0xdd6eeeee87ad0c86, 0x1f13b7e78f4d7368, 0xdc3edd3ac0291ddc, 0x374bb7ac806e7162, 0xc5d9bae255fba6e8,
  0x4c4bbbbb1bb2fafc, 0x9827c602416caef2, 0xdd6d032252520ebe, 0x4b881850c1b48c0d, 0x6eaffccab773ba7c,
  0xa8fb3b611c8e0706, 0x8a11c913f8395d37, 0x87c2886257f9fbe0, 0x5777bbe6e341c01b, 0xf8a8432d00f68865,
  0xb7b1fffa039e1304, 0xdcd7982c3795e425, 0x0dc5f531f28235bf, 0xf71258f3ca17070e, 0xfd47c25f886c2445,
  0x2e678bb8dcb9124a, 0x87ea3f513dcb19f5, 0x05a95dd471d3f83b, 0x00ced38a37bce62c, 0xe0faa01ffb33c75e,
  0xa92dfe181e5adcb5, 0x972ab59fc55f3bb8, 0xaa35dce3398a0ed7, 0xe576a96fab39d454, 0x574bfa4439ae0404,
  0x9ed5688af2c434ab, 0xca5af9d01e395aeb, 0x8c6f19d10210a905, 0x0c76f62aa8b49053, 0xb8f3612e65f36cbb,
  0x66fe0eee3459d3e1, 0x89fca1854e7ea756, 0x4d0f327f8b9c65f9, 0xcf4c2b93f1cf7ff0, 0xa4a5b3e04e32c970,
  0xd16792bf734332c3, 0x000000000d24408d,
};

/*
 * m169a_swio10_dual_pr_ce_u4        m169p_swio10_dual_pr_ce_u4        m169pa_swio10_dual_pr_ce_u4
 * m165_swio10_dual_pr_ce_u4         m165a_swio10_dual_pr_ce_u4        m165p_swio10_dual_pr_ce_u4
 * m165pa_swio10_dual_pr_ce_u4
 */
static const uint64_t ur_m169_swio10_dual_pr_ce_u4[] = {
  0x4647777776890c86, 0xa7789dbf3c7d579b, 0x96d77ee80a2951c7, 0xe4ea661b9d6f7ed3, 0x798a1640258b74c8,
  0xf25a2bbbbb1bb2d0, 0xeb9827c602416cae, 0x0ddd6d0322525219, 0x7c4b881850c1b48c, 0x373456fccab773ba,
  0x9bd47cadb0df670d, 0xf04508e489fc1943, 0x0dc3e144312bfcfd, 0x1955ddeef9b94940, 0x69c62a10cb4027a2,
  0x425b74b5ff4073c2, 0xebfdcd7982c3795e, 0x39a6ee2faf752836, 0x222fb892c79e50b8, 0x9257ea3e12fc4361,
  0xcf0e333c5dc6e5c8, 0x8359fea3cbe9ee58, 0x62c058f7a5471d3f, 0x3af22ddb244637ce, 0x2a4a3a8cb71cb19e,
  0xe5caad67f157ceee, 0x2a8d7738ce6283b5, 0x395daa5beace7515, 0xd5d2fe910e6b8101, 0xe7b55a22bcb10d2a,
  0x7296be74078e56ba, 0xe31bc67440842a41, 0xc31dbd8aaa2d2414, 0x6e3cd84b997cdb2e, 0xb337f07771a2c6f8,
  0x87bde50c2a73f53a, 0x9fe07f197e627ff7, 0xa2ff03f7ec3343cc, 0x8cb25c33d30be347, 0xd0ccb0e9296cf813,
  0x4920537459e4afdc, 0x0000000000000003,
};

/*
 * m169a_swio10_dual_pr_ee_ce        m169p_swio10_dual_pr_ee_ce        m169pa_swio10_dual_pr_ee_ce
 * m165_swio10_dual_pr_ee_ce         m165a_swio10_dual_pr_ee_ce        m165p_swio10_dual_pr_ee_ce
 * m165pa_swio10_dual_pr_ee_ce
 */
static const uint64_t ur_m169_swio10_dual_pr_ee_ce[] = {
  0xd4e2ddddddd432db, 0x7ade276fc622d3c6, 0x0efd5f753ecb5586, 0x95f1ba39dee30f90, 0x6d0672b8a9be4b38,
  0xe771c11560f0ccea, 0x4f8c0482d95de4e4, 0xb40c8949484f2f30, 0x20614306d2303775, 0xf3f32addcee9f12e,
  0xffe6c0341c34d4cf, 0x47244fe0fa7e6f51, 0x0a21895fe7ef8228, 0xbddf3715d7006e1f, 0x4219681c34432abb,
  0x1f7fd01cf099c9c5, 0xbcc161bcaf212dba, 0xaa32972829b7fee6, 0x7f3ca1707136ceff, 0x0cc273b8dc683822,
  0x51e5650e53b59591, 0xd82fa8f83660cf5f, 0x291669d68450298a, 0x871d484d7d185962, 0x76ee9182873abb74,
  0x916c6abc6c75ed62, 0xe3e3170908a26e47, 0x525c6319191c37b2, 0x2e556b3f8abe7771, 0x546bb9c673141daf,
  0xcaed52df5673a8a9, 0xae97f488735c0809, 0x3daad115e5886956, 0x94b5f3a03c72b5d7, 0x18de33a20421520b,
  0x18edec55516920a7, 0x71e6c25ccbe6d976, 0x337f07771a2c79c3, 0x64b867a615c9fbab, 0x9961d252d9f02719,
  0xa4e6e8b3c95fb9a1, 0x0000000000004c13,
};

/*
 * m169a_swio10_dual_pr_ee_ce_u4     m169p_swio10_dual_pr_ee_ce_u4     m169pa_swio10_dual_pr_ee_ce_u4
 * m165_swio10_dual_pr_ee_ce_u4      m165a_swio10_dual_pr_ee_ce_u4     m165p_swio10_dual_pr_ee_ce_u4
 * m165pa_swio10_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio10_dual_pr_ee_ce_u4[] = {
  0xdddddda2b6ee022f, 0x4edf998b90cdacfb, 0xacad0b5ce08673bc, 0x8beaf7f57f71dd9b, 0xe1bb89d9f762f38a,
  0x7cc5b0009645188c, 0x7792d89ddfda3e3d, 0xb82cc13e30120b65, 0x81bbada0644a4a46, 0x4f8971030a183691,
  0x0e6e5afccb4b7e77, 0xbd47c6ed87609c2f, 0x08a11c913f836bb9, 0xb87c2886257f9fbe, 0xaaeef77cdc88c401,
  0xf7150865a11c910c, 0xb6f723ff4073c26d, 0xf8fc330586f2bc84, 0xe2faa33832826b7f, 0x892c79e50bcecd6e,
  0xa3e12fc4361222fb, 0x3c5dc6e44629c7fe, 0x2bcad29dadcdcdd3, 0xbd47c1b307dd7a8f, 0xb34eb422814c572b,
  0xea426be8c2cb1148, 0xf68f4a39d5db8a18, 0xb1aaf1b1d7a89768, 0x662e121142008d31, 0xa8d8226470decbe9,
  0xf3bb8a92967195ac, 0xa0ed7972ab59fc55, 0x9d454aa35dce3398, 0xe0404e576a96fab3, 0x434ab574bfa4439a,
  0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021, 0x36cbb0c76f62aa8b, 0x1726ae0f3612e65f,
  0xccdfc1fb763458df, 0x1ef79430a9cfd4ea, 0x7f81fc65f989ffde, 0x8bfc0fdfb0cd0f32, 0x32c970cf4c2f8d1e,
  0x4332c3a4a5b3e04e, 0x6b2d791ba792bf73, 0x0000000000000400,
};

/*
 * m169a_swio10_dual_hw              m169p_swio10_dual_hw              m169pa_swio10_dual_hw
 * m165_swio10_dual_hw               m165a_swio10_dual_hw              m165p_swio10_dual_hw
 * m165pa_swio10_dual_hw
 */
static const uint64_t ur_m169_swio10_dual_hw[] = {
  0x97777776890d7f41, 0xfc4edf8ebce71b46, 0x53ef760dac1a16d2, 0x3f8be99fda3ac53b, 0x578d410ec36e9a52,
  0xbc95a1ddee3337bf, 0x806609f180905b2b, 0x81bbada0644a4a41, 0x4f8971030a183691, 0x5166727f9956ee77,
  0xa9bd477f360bece0, 0xef822847244fe0cc, 0x006e1f0a21895fe7, 0x10caaeef77cdcadf, 0x09ad68a8432d08c9,
  0x79096dcbaffd01cf, 0xa95ffea4660b0de5, 0xf51e443be587c941, 0xbf71951c74fe0c45, 0x8a37bce62c055079,
  0x1ffb30475e00ced3, 0x607967b6b5e0faa0, 0x7f157ceee2a4b7f8, 0x8ce6283b5e5caad6, 0xbeace75152a8d773,
  0x10e6b8101395daa5, 0x2bcb10d2ad5d2fe9, 0x4078e56bae7b55a2, 0x440842a417296be7, 0xaaa2d2414e31bc67,
  0x5ccbe6d976455bd8, 0xa9cfd4176371e6c2, 0xf989ffde1ef79430, 0xb0cd0f327f81fc65, 0x4c2f8d1e8bfc0fdf,
  0xa5b3e04e32c970cf, 0xa792bf734332c3a4, 0x0000000c6eab4fa8,
};

/*
 * m169a_swio10_dual_ee_hw           m169p_swio10_dual_ee_hw           m169pa_swio10_dual_ee_hw
 * m165_swio10_dual_ee_hw            m165a_swio10_dual_ee_hw           m165p_swio10_dual_ee_hw
 * m165pa_swio10_dual_ee_hw
 */
static const uint64_t ur_m169_swio10_dual_ee_hw[] = {
  0x3b7777743d686f97, 0x7c4edf8d4f261b4d, 0x722775261d681664, 0xd646682ab8858abf, 0x1f1375a266f5da73,
  0x7a73b9e08ceb54e8, 0x9827c602416caef2, 0xdd6d032252523b8f, 0x4b881850c1b48c0d, 0x631ffccab773ba7c,
  0xa8e4eb60968e016a, 0x8a11c913f838ad37, 0x87c2886257f9fbe0, 0x5777bbe6e2a4401b, 0xb8a8432d05f68865,
  0xb74dbffa039e1307, 0xfa91982c3795e425, 0xaad68ca2ca0d0fff, 0xd98332bd4795efb9, 0x1143be2bb75ea3e0,
  0xf4616588a459a75a, 0xa5ca1ae2a5cd2135, 0xa89768f68f4a39d5, 0x004698d8d56ba1d7, 0x6f65f4b3170908a1,
  0x5195aca8d823f5b8, 0x59fc55f3bb8a9280, 0xce3398a0ed7972ab, 0x96fab39d454aa35d, 0xa4439ae0404e576a,
  0x88af2c434ab574bf, 0x9d01e395aeb9ed56, 0x9d10210a905ca5af, 0x62aa8b490538c6f1, 0x09732f9b65d9156f,
  0x1539fa97ab8dc79b, 0xfe2e7197e627f286, 0x4fc73dffc1343cc9, 0x8138cb25c33d30ae, 0xfdcd0ccb0e9296cf,
  0x0002bb473ea29e4a,
};

/*
 * m169a_swio10_dual_ce_hw           m169p_swio10_dual_ce_hw           m169pa_swio10_dual_ce_hw
 * m165_swio10_dual_ce_hw            m165a_swio10_dual_ce_hw           m165p_swio10_dual_ce_hw
 * m165pa_swio10_dual_ce_hw
 */
static const uint64_t ur_m169_swio10_dual_ce_hw[] = {
  0x375bbbbbb4486f97, 0x07c4edf9e3d35cda, 0xb70fb74eb00a4777, 0x0dd2edeb201b9c58, 0x4eb66eb8957ee9ba,
  0xef24c4bb9e08ceb5, 0xebe9827c602416ca, 0xc0ddd6d032252520, 0xa7c4b881850c1b48, 0x7066eaffccab773b,
  0xd37a8fb3b611c8e0, 0xbe08a11c913f8395, 0x01b87c2886257f9f, 0x8655777bbe6e341c, 0x304f8a8432d00f68,
  0x425b7b1fffa039e1, 0xb7ffa91982c3795e, 0xe1c1b8bea63e5046, 0x88bee24b1e7942e0, 0x723fa8f84bf10d84,
  0x3ea5ccf1771b8951, 0x0770fd47ea27b963, 0xc580b52bba8e3a7f, 0xebc019da7146f79c, 0x96bc1f5403ff6678,
  0x771525bfc303cb5b, 0xdaf2e556b3f8abe7, 0x8a9546bb9c673141, 0x809caed52df5673a, 0x956ae97f488735c0,
  0x5d73daad115e5886, 0x20b94b5f3a03c72b, 0x0a718de33a204215, 0x97618edec5551692, 0x76371e6c25ccbe6d,
  0xe1ef79430a9cfd41, 0x27f81fc65f989ffd, 0xe8bfc0fdfb0cd0f3, 0xe32c970cf4c2f8d1, 0x34332c3a4a5b3e04,
  0x026ea8128a792bf7,
};

/*
 * m169a_swio10_dual_ee_ce_hw        m169p_swio10_dual_ee_ce_hw        m169pa_swio10_dual_ee_ce_hw
 * m165_swio10_dual_ee_ce_hw         m165a_swio10_dual_ee_ce_hw        m165p_swio10_dual_ee_ce_hw
 * m165pa_swio10_dual_ee_ce_hw
 */
static const uint64_t ur_m169_swio10_dual_ee_ce_hw[] = {
  0x1ceddddddd431f02, 0xc5e276fc6233686d, 0xd5c5eeefdf5d9da6, 0x263d68d43f2d07bb, 0x7e3fa10a9be4a739,
  0xddca31166f4c29f5, 0x3e30120b657792cc, 0xd032252520f9f4c1, 0x81850c1b48c0ddd6, 0xbfccab773ba7c4b8,
  0xa6b60ff0e188266b, 0x1c913f83ff937a8f, 0x2886257f9fbe08a1, 0xf77cdc76ec01b87c, 0x0865a0c1510caaee,
  0x83ff4073c2690f15, 0x330586f2bc84b6fd, 0x51e04941b5bfff52, 0xf9e50b8396b677fd, 0xd309cee3719cba3f,
  0x4795e5694ed6564d, 0x95dea3e0d983eebd, 0xa459a75a1140a62b, 0x0c752135f4616588, 0xb47b47a51ceaedc5,
  0x98d8d578d8ebd44b, 0xf4b3170908a10046, 0xd6546c1132386f65, 0x2af9ddc5494b38ca, 0xcc5076bcb955acfe,
  0x59cea2a551aee719, 0xcd7020272bb54b7d, 0x9621a55aba5fd221, 0xf1cad75cf6ab4457, 0x1085482e52d7ce80,
  0x45a4829c6378ce88, 0x2f9b65d863b7b155, 0x93f3fb0dc79b0973, 0xe04e32c970cf4c2b, 0xbf734332c3a4a5b3,
  0x000089a64928a792,
};

/*
 * m169a_swio10_dual_ee_ce_u4_hw     m169p_swio10_dual_ee_ce_u4_hw     m169pa_swio10_dual_ee_ce_u4_hw
 * m165_swio10_dual_ee_ce_u4_hw      m165a_swio10_dual_ee_ce_u4_hw     m165p_swio10_dual_ee_ce_u4_hw
 * m165pa_swio10_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio10_dual_ee_ce_u4_hw[] = {
  0xbdddddda28d1ac4f, 0xc4edf998b90cdacf, 0xeecdd0b5ce08673b, 0x9c545f57bfabfb8d, 0xc4670ddc4ecfbb17,
  0x4eaae3f68354b228, 0x120b657792d89dd3, 0x4a4a46b82cc13e30, 0x18369181bbada064, 0x7612774f8971030a,
  0xec1385e1cdcb5f99, 0xf06d7737a8f8ddb0, 0xaff3f7c114239227, 0x911880370f8510c4, 0x239221955ddeef9b,
  0x0e784dbee2a10cb4, 0xde579096dee47fe8, 0xa09adffb3d0e60b0, 0xc1c35bb8bea8ce0c, 0x488bee24b1e78df0,
  0x70fffa8f84bf10d8, 0x9b9ba678bb8dc5c1, 0xbaf51e5795a53b5b, 0x98ae577a8f83660f, 0x962291669d684502,
  0xb71431d484d7d185, 0x512ed1ed1e9473ab, 0x011a636355e363af, 0xbd97d2cc5c242284, 0xe32b5951b044c8e1,
  0xb3f8abe77715252c, 0x9c673141daf2e556, 0x2df5673a8a9546bb, 0x488735c0809caed5, 0x115e5886956ae97f,
  0x3a03c72b5d73daad, 0x3a20421520b94b5f, 0xc55516920a718de3, 0x25ccbe6d97618ede, 0x0a9cfd4176371e6c,
  0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c, 0xfa792bf734332c3a,
  0x0000000eba8d1b82,
};

/*
 * m169_swio12_noled                 m169a_swio11_noled                m169a_swio12_noled
 * m169p_swio11_noled                m169p_swio12_noled                m169pa_swio11_noled
 * m169pa_swio12_noled               m165_swio11_noled                 m165_swio12_noled
 * m165a_swio11_noled                m165a_swio12_noled                m165p_swio11_noled
 * m165p_swio12_noled                m165pa_swio11_noled               m165pa_swio12_noled
 */
static const uint64_t ur_m169_swio11_noled[] = {
  0x82ffbbbbbacdc49f, 0x6eed55c8a50912d4, 0x80374d06e246113d, 0x5fd0ee38f522f89d, 0x5a099fa5f17bba90,
  0x05b2bbc9ddcc490d, 0xd0f3f1ee609f1809, 0x9df2dd04a0f75fef, 0x1c74fe0ebffa8e98, 0x398b016f74c800f9,
  0x823af173b7488c9e, 0xb955a95821f71cb1, 0x51aee719cc5076bc, 0xbb54b7d5d9cea2a5, 0x95b1bd7d221cd672,
  0xad73daad115e5886, 0x9d4e02ca54fa779f, 0x23cbc5021696173a, 0x65f36d38c6f19d10, 0x85727e7f61bb612e,
  0x659289c6592e19e9, 0x257ee6866587494b, 0x000001525bb5c7cf,
};

/*
 * m169_swio11_noled_pr_u4           m169_swio12_noled_pr              m169_swio12_noled_pr_u4
 * m169a_swio11_noled_pr             m169a_swio11_noled_pr_u4          m169a_swio12_noled_pr
 * m169a_swio12_noled_pr_u4          m169p_swio11_noled_pr             m169p_swio11_noled_pr_u4
 * m169p_swio12_noled_pr             m169p_swio12_noled_pr_u4          m169pa_swio11_noled_pr
 * m169pa_swio11_noled_pr_u4         m169pa_swio12_noled_pr            m169pa_swio12_noled_pr_u4
 * m165_swio11_noled_pr              m165_swio11_noled_pr_u4           m165_swio12_noled_pr
 * m165_swio12_noled_pr_u4           m165a_swio11_noled_pr             m165a_swio11_noled_pr_u4
 * m165a_swio12_noled_pr             m165a_swio12_noled_pr_u4          m165p_swio11_noled_pr
 * m165p_swio11_noled_pr_u4          m165p_swio12_noled_pr             m165p_swio12_noled_pr_u4
 * m165pa_swio11_noled_pr            m165pa_swio11_noled_pr_u4         m165pa_swio12_noled_pr
 * m165pa_swio12_noled_pr_u4
 */
static const uint64_t ur_m169_swio11_noled_pr[] = {
  0xd05bbbbb4488af02, 0xddaab914a8712b89, 0xb27afd8d05b04f05, 0xd60e21b63367bd3d, 0x17e635a6edc4e82c,
  0xf277638c0bc5eccc, 0x8f9827c602416cae, 0xf7283b7ffcf02cf9, 0xc1935ea382877cb6, 0x5965307b40238e9f,
  0x7cec98a3114e62c0, 0x279500ffd9823af4, 0x56a844c0f2cf6ed6, 0xbb9c673141daf2e5, 0x52df57673a8a9546,
  0xc6f5f4887359caed, 0xcf6ab44579621a56, 0xd8a53c34ef3e2d75, 0x2718de33a2041dd4, 0x10c55bd8aaa2d2da,
  0xab83cd84b997cdb6, 0xf207e50d1637c5c9, 0xef2861539fa9d598, 0x03f8cbf313ffbc3d, 0xf81fbf619a1e64ff,
  0x92e19e985f1a3d17, 0x6587494b67c09c65, 0xe0b1014f257ee686, 0x000000000001f26a,
};

/*
 * m169_swio12_noled_pr_ee           m169a_swio11_noled_pr_ee          m169a_swio12_noled_pr_ee
 * m169p_swio11_noled_pr_ee          m169p_swio12_noled_pr_ee          m169pa_swio11_noled_pr_ee
 * m169pa_swio12_noled_pr_ee         m165_swio11_noled_pr_ee           m165_swio12_noled_pr_ee
 * m165a_swio11_noled_pr_ee          m165a_swio12_noled_pr_ee          m165p_swio11_noled_pr_ee
 * m165p_swio12_noled_pr_ee          m165pa_swio11_noled_pr_ee         m165pa_swio12_noled_pr_ee
 */
static const uint64_t ur_m169_swio11_noled_pr_ee[] = {
  0xb4ddddd0f5a22582, 0xbb557e1708225c7e, 0x699ed43267cdcc9b, 0x0da1942e19e14627, 0xd9136041b4171fad,
  0x774ed0434665a88f, 0x9827c602416caef2, 0x283b3bfcf02cf9c1, 0x1e565d66ab5a331f, 0xa5fa8f83660fa8f5,
  0x91669d68450ef8ac, 0x593484d7d1859622, 0x8fe439d5a5dc9ae3, 0x6ab5d0ebce9bb1ea, 0x8b84845110a3deec,
  0x3608fd6e1bd96cb9, 0xf2e556a01741cf2a, 0x9546bb9c673141da, 0xcaed52df57673a8a, 0x1a56c6f5f4887359,
  0x2d75cf6ab4457962, 0x1dd4d8a53c34ef3e, 0xd2da2718de33a204, 0xcdb610c55bd8aaa2, 0xc5c9ab83cd84b997,
  0xacc7903f2868b3a7, 0xf313f9430a9cfd4e, 0xe09a1e64ff1738cb, 0xe19e985727e39eff, 0x87494b67c09c6592,
  0x51014f257ee68665, 0x000000000009d781,
};

/*
 * m169_swio12_noled_pr_ee_u4        m169a_swio11_noled_pr_ee_u4       m169a_swio12_noled_pr_ee_u4
 * m169p_swio11_noled_pr_ee_u4       m169p_swio12_noled_pr_ee_u4       m169pa_swio11_noled_pr_ee_u4
 * m169pa_swio12_noled_pr_ee_u4      m165_swio11_noled_pr_ee_u4        m165_swio12_noled_pr_ee_u4
 * m165a_swio11_noled_pr_ee_u4       m165a_swio12_noled_pr_ee_u4       m165p_swio11_noled_pr_ee_u4
 * m165p_swio12_noled_pr_ee_u4       m165pa_swio11_noled_pr_ee_u4      m165pa_swio12_noled_pr_ee_u4
 */
static const uint64_t ur_m169_swio11_noled_pr_ee_u4[] = {
  0x6f26eeeed1222a20, 0x3bb557e171a7122f, 0xfa69776dbaff126d, 0x14ce3e7ec19e3b23, 0x3d724041b4117b79,
  0x3ba3d8b54718d410, 0x4c13e30120b65779, 0x94195dfe78167f67, 0x8f2bf9d355ad1edf, 0xe97d47c1b30738fa,
  0x48b34eb422877c56, 0x899a426be8c2cb11, 0x1ad739d5a5d7dae2, 0x56ba1d7aea6ed2f9, 0x70908a07c47d258d,
  0xe83eb70decb87231, 0x73141daf2e556ab8, 0x7673a8a9546bb9c6, 0x4887359caed52df5, 0x44579621a56c6f5f,
  0xc34ef3e2d75cf6ab, 0xe33a2041dd4d8a53, 0xbd8aaa2d2da2718d, 0xd84b997cdb610c55, 0x50d1637c5c9ab83c,
  0x1539fa9d598f207e, 0xbf313ffbc3def286, 0xf619a1e64ff03f8c, 0xe985f1a3d17f81fb, 0x94b67c09c6592e19,
  0x14f257ee68665874, 0x0000000275d34110,
};

/*
 * m169_swio11_noled_pr_ce_u4        m169_swio12_noled_pr_ce           m169_swio12_noled_pr_ce_u4
 * m169a_swio11_noled_pr_ce          m169a_swio11_noled_pr_ce_u4       m169a_swio12_noled_pr_ce
 * m169a_swio12_noled_pr_ce_u4       m169p_swio11_noled_pr_ce          m169p_swio11_noled_pr_ce_u4
 * m169p_swio12_noled_pr_ce          m169p_swio12_noled_pr_ce_u4       m169pa_swio11_noled_pr_ce
 * m169pa_swio11_noled_pr_ce_u4      m169pa_swio12_noled_pr_ce         m169pa_swio12_noled_pr_ce_u4
 * m165_swio11_noled_pr_ce           m165_swio11_noled_pr_ce_u4        m165_swio12_noled_pr_ce
 * m165_swio12_noled_pr_ce_u4        m165a_swio11_noled_pr_ce          m165a_swio11_noled_pr_ce_u4
 * m165a_swio12_noled_pr_ce          m165a_swio12_noled_pr_ce_u4       m165p_swio11_noled_pr_ce
 * m165p_swio11_noled_pr_ce_u4       m165p_swio12_noled_pr_ce          m165p_swio12_noled_pr_ce_u4
 * m165pa_swio11_noled_pr_ce         m165pa_swio11_noled_pr_ce_u4      m165pa_swio12_noled_pr_ce
 * m165pa_swio12_noled_pr_ce_u4
 */
static const uint64_t ur_m169_swio11_noled_pr_ce[] = {
  0x367eeeeed1222582, 0x3bb55784469712a1, 0xba47f499f1f60f7e, 0xfaf1ae6ecadb5368, 0xaa0b42f0adda1367,
  0xbbc9dd3b410e5d96, 0xfa6e609f180905b2, 0xbdd4a0e56ff3c0b3, 0x8f3c64a9dcaeb8be, 0x25f886c2445f7125,
  0xbb8dc643a4afd47c, 0xebe4f72c67eb2678, 0x97d1c74fe0d67fa8, 0x4c5188a731602edf, 0x807feccf1d7a3e76,
  0x08981e5add6b13ca, 0x8ce6283b5e5caad5, 0xeaece75152a8d773, 0xbe910e6b395daa5b, 0x5688af2c434ad8de,
  0xa7869de7c5aeb9ed, 0x1bc6744083ba9b14, 0x3b7b15545a5b44e3, 0xf3612e65f36d8426, 0xf943458df1726ae0,
  0x1854e7ea75663c81, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe, 0x67a617c68f45fe07, 0xd252d9f0271964b8,
  0x4053c95fb9a19961, 0x000000001bae917c,
};

/*
 * m169_swio12_noled_pr_ee_ce        m169a_swio11_noled_pr_ee_ce       m169a_swio12_noled_pr_ee_ce
 * m169p_swio11_noled_pr_ee_ce       m169p_swio12_noled_pr_ee_ce       m169pa_swio11_noled_pr_ee_ce
 * m169pa_swio12_noled_pr_ee_ce      m165_swio11_noled_pr_ee_ce        m165_swio12_noled_pr_ee_ce
 * m165a_swio11_noled_pr_ee_ce       m165a_swio12_noled_pr_ee_ce       m165p_swio11_noled_pr_ee_ce
 * m165p_swio12_noled_pr_ee_ce       m165pa_swio11_noled_pr_ee_ce      m165pa_swio12_noled_pr_ee_ce
 */
static const uint64_t ur_m169_swio11_noled_pr_ee_ce[] = {
  0x7f8fdddddd446f43, 0x5ddaabd853a744a1, 0x3bd89dab43d318c4, 0x1f5a63bf23f4c69a, 0xdc71a8b065ab42ff,
  0x2775a77da765b2a0, 0xb9827c602416caef, 0xca08cdff9e059f4d, 0x953b19b3bfea8cba, 0x3b8dc672e8ffe78c,
  0x21e53b5958f7cc27, 0x8f83660f4af51e57, 0x9d68450298ace1fa, 0x84d7d18596229166, 0x1fc873abb73931d4,
  0xaaf1b1d79d3763d5, 0x2e121144428f7bb1, 0x6c1132386f65b2e6, 0xe5caad4b3e839e54, 0x2a8d7738ce6283b5,
  0x95daa5beaece7515, 0x34ad8debe910e6b3, 0x5aeb9ed5688af2c4, 0x3ba9b14a7869de7c, 0xa5b44e31bc674408,
  0x36d84263b7b15545, 0xe71726ae3612e65f, 0xeeacc7903f2868b1, 0x9c6592e19e985727, 0x6866587494b65928,
  0x698bf71014f257ee, 0x000000000000000a,
};

/*
 * m169_swio12_noled_pr_ee_ce_u4     m169a_swio11_noled_pr_ee_ce_u4    m169a_swio12_noled_pr_ee_ce_u4
 * m169p_swio11_noled_pr_ee_ce_u4    m169p_swio12_noled_pr_ee_ce_u4    m169pa_swio11_noled_pr_ee_ce_u4
 * m169pa_swio12_noled_pr_ee_ce_u4   m165_swio11_noled_pr_ee_ce_u4     m165_swio12_noled_pr_ee_ce_u4
 * m165a_swio11_noled_pr_ee_ce_u4    m165a_swio12_noled_pr_ee_ce_u4    m165p_swio11_noled_pr_ee_ce_u4
 * m165p_swio12_noled_pr_ee_ce_u4    m165pa_swio11_noled_pr_ee_ce_u4   m165pa_swio12_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio11_noled_pr_ee_ce_u4[] = {
  0x30addddda243306a, 0xbbb557f53323125a, 0xaecb75a583305f98, 0x8540056d1dc1b5c7, 0x6e817c942cb67ad1,
  0x93bb55f930eb2108, 0x24c13e30120b6577, 0xe506b7ffec5767c5, 0x2e0e56fdc5f547a6, 0xd8488bee24b1e794,
  0x6ec2c9fa8f84bf10, 0x5b9b7be678bb8dc7, 0x0f4af51e5721e53b, 0x0298ace1fa8f8366, 0x85962291669d6845,
  0xabb73931d484d7d1, 0xd79d3763d51fc873, 0x44428f7bb1aaf1b1, 0x386f65b2e62e1211, 0x4b3e839e546c1132,
  0x38ce6283b5e5caad, 0xbeaece75152a8d77, 0xebe910e6b395daa5, 0xd5688af2c434ad8d, 0x4a7869de7c5aeb9e,
  0x31bc6744083ba9b1, 0x63b7b15545a5b44e, 0x8f3612e65f36d842, 0xcdfc1ddc68b1be1b, 0xef79430a9cfd4eac,
  0xf81fc65f989ffde1, 0xbfc0fdfb0cd0f327, 0x2c970cf4c2f8d1e8, 0x332c3a4a5b3e04e3, 0x1eaedd16792bf734,
  0x00000000000004fc,
};

/*
 * m169_swio12_noled_hw              m169a_swio11_noled_hw             m169a_swio12_noled_hw
 * m169p_swio11_noled_hw             m169p_swio12_noled_hw             m169pa_swio11_noled_hw
 * m169pa_swio12_noled_hw            m165_swio11_noled_hw              m165_swio12_noled_hw
 * m165a_swio11_noled_hw             m165a_swio12_noled_hw             m165p_swio11_noled_hw
 * m165p_swio12_noled_hw             m165pa_swio11_noled_hw            m165pa_swio12_noled_hw
 */
static const uint64_t ur_m169_swio11_noled_hw[] = {
  0x82ffbbbbbacdc49f, 0x6eed55c8a50912d4, 0x80374d06e246113d, 0x5fd0ee38f522f89d, 0x5a099fa5f17bba90,
  0x05b2bbc9ddcc490d, 0x38f3f1ee609f1809, 0x4ef96e82507baffc, 0x8e3a7f075ffd474c, 0x1cc580b7ba64007c,
  0xc11d78b9dba4464f, 0x5caad4ac10fb8e58, 0xa8d7738ce6283b5e, 0x5daa5beaece75152, 0x4ad8debe910e6b39,
  0xd6b9ed5688af2c43, 0x4ea701652a7d3bcf, 0x11e5e2810b4b0b9d, 0x32f9b69c6378ce88, 0xc2b93f3fb0ddb097,
  0xb2c944e32c970cf4, 0x92bf734332c3a4a5, 0x0000008e2b7760a7,
};

/*
 * m169_swio12_noled_ee_hw           m169a_swio11_noled_ee_hw          m169a_swio12_noled_ee_hw
 * m169p_swio11_noled_ee_hw          m169p_swio12_noled_ee_hw          m169pa_swio11_noled_ee_hw
 * m169pa_swio12_noled_ee_hw         m165_swio11_noled_ee_hw           m165_swio12_noled_ee_hw
 * m165a_swio11_noled_ee_hw          m165a_swio12_noled_ee_hw          m165p_swio11_noled_ee_hw
 * m165p_swio12_noled_ee_hw          m165pa_swio11_noled_ee_hw         m165pa_swio12_noled_ee_hw
 */
static const uint64_t ur_m169_swio11_noled_ee_hw[] = {
  0xf5a6eeeed121b705, 0xdddaabf0b84112e3, 0xa62776a1933e6e64, 0xfad0da1942e19e15, 0x08fd9136041b4171,
  0x95de4eed86d95a93, 0x9f383304f8c0482d, 0xd198f941d9dff429, 0x7d47a8f2b2eb355a, 0x77c5652fd47c1b30,
  0x2cb1148b34eb4228, 0xe4d71ac9a426be8c, 0xdd8f547f21cead2e, 0x1ef76355ae875e74, 0xcb65cc5c24228885,
  0x0e7951b047eb70de, 0x8a0ed7972ab500ba, 0x39d454aa35dce339, 0x439ace576a96fabb, 0x2bcb10d2b637afa4,
  0xa779f16bae7b55a2, 0x9d1020eea6c529e1, 0xc5551696d138c6f1, 0x25ccbe6db0862ade, 0x0a9cfd4176371e6c,
  0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c, 0x8a792bf734332c3a,
  0x000000000b7ff34e,
};

/*
 * m169_swio12_noled_ce_hw           m169a_swio11_noled_ce_hw          m169a_swio12_noled_ce_hw
 * m169p_swio11_noled_ce_hw          m169p_swio12_noled_ce_hw          m169pa_swio11_noled_ce_hw
 * m169pa_swio12_noled_ce_hw         m165_swio11_noled_ce_hw           m165_swio12_noled_ce_hw
 * m165a_swio11_noled_ce_hw          m165a_swio12_noled_ce_hw          m165p_swio11_noled_ce_hw
 * m165p_swio12_noled_ce_hw          m165pa_swio11_noled_ce_hw         m165pa_swio12_noled_ce_hw
 */
static const uint64_t ur_m169_swio11_noled_ce_hw[] = {
  0x367eeeeed12198e2, 0x3bb55784469712a1, 0xad177499f1f60f7e, 0xcff5e35cdd95b6a7, 0x3ad41685e15bb426,
  0x16caef2774a70f6d, 0x14cfe9b9827c6024, 0xb8bebdd4a0e56ffa, 0xe24b1e7942e0e4ae, 0xa8f84bf10d8488be,
  0x4cf1771b9d83787f, 0xff51d7c9ee58cfd6, 0x5dbf2fa38e9fc1ac, 0x7cec98a3114e62c0, 0x279500ffd99e3af4,
  0x55aa11303cb5bad6, 0xaee719cc5076bcb9, 0x54b7d5d9cea2a551, 0xb1bd7d221cd672bb, 0x73daad115e588695,
  0x36294f0d3bcf8b5d, 0x89c6378ce8810775, 0x084c76f62aa8b4b6, 0x6371e6c25ccbe6db, 0x1ef79430a9cfd417,
  0x7f81fc65f989ffde, 0x8bfc0fdfb0cd0f32, 0x32c970cf4c2f8d1e, 0x4332c3a4a5b3e04e, 0x66c9f868a792bf73,
  0x000000000000001d,
};

/*
 * m169_swio11_noled_ee_ce_u4_hw     m169_swio12_noled_ee_ce_hw        m169_swio12_noled_ee_ce_u4_hw
 * m169a_swio11_noled_ee_ce_hw       m169a_swio11_noled_ee_ce_u4_hw    m169a_swio12_noled_ee_ce_hw
 * m169a_swio12_noled_ee_ce_u4_hw    m169p_swio11_noled_ee_ce_hw       m169p_swio11_noled_ee_ce_u4_hw
 * m169p_swio12_noled_ee_ce_hw       m169p_swio12_noled_ee_ce_u4_hw    m169pa_swio11_noled_ee_ce_hw
 * m169pa_swio11_noled_ee_ce_u4_hw   m169pa_swio12_noled_ee_ce_hw      m169pa_swio12_noled_ee_ce_u4_hw
 * m165_swio11_noled_ee_ce_hw        m165_swio11_noled_ee_ce_u4_hw     m165_swio12_noled_ee_ce_hw
 * m165_swio12_noled_ee_ce_u4_hw     m165a_swio11_noled_ee_ce_hw       m165a_swio11_noled_ee_ce_u4_hw
 * m165a_swio12_noled_ee_ce_hw       m165a_swio12_noled_ee_ce_u4_hw    m165p_swio11_noled_ee_ce_hw
 * m165p_swio11_noled_ee_ce_u4_hw    m165p_swio12_noled_ee_ce_hw       m165p_swio12_noled_ee_ce_u4_hw
 * m165pa_swio11_noled_ee_ce_hw      m165pa_swio11_noled_ee_ce_u4_hw   m165pa_swio12_noled_ee_ce_hw
 * m165pa_swio12_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio11_noled_ee_ce_hw[] = {
  0x1856eeeed1219f68, 0x5ddaabfa9991892d, 0xd765bad2c1982fcc, 0xc2a002b68ee0dae3, 0x3740be4a165b3d68,
  0x5de4ee957a27e858, 0xf149304f8c0482d9, 0x3d372835bfff4299, 0x3ca17072b7ee2faa, 0xf886c2445f71258f,
  0xdc36ec291fd47c25, 0x53b5b9b7be678bb8, 0x3660f4af51e5721e, 0x8450298ace1fa8f8, 0x7d185962291669d6,
  0x873abb73931d484d, 0x1b1d79d3763d51fc, 0x21144428f7bb1aaf, 0x132386f65b2e62e1, 0xaad4b3e839e546c1,
  0xd7738ce6283b5e5c, 0xaa5beaece75152a8, 0xd8debe910e6b395d, 0xb9ed5688af2c434a, 0x9b14a7869de7c5ae,
  0x44e31bc6744083ba, 0x84263b7b15545a5b, 0xb1b8f3612e65f36d, 0x0f7bca1854e7ea0b, 0x3fc0fe32fcc4ffef,
  0x45fe07efd8668799, 0x1964b867a617c68f, 0xa19961d252d9f027, 0xa021eaf453c95fb9,
};

/*
 * m169_swio12_lednop                m169a_swio11_lednop               m169a_swio12_lednop
 * m169p_swio11_lednop               m169p_swio12_lednop               m169pa_swio11_lednop
 * m169pa_swio12_lednop              m165_swio11_lednop                m165_swio12_lednop
 * m165a_swio11_lednop               m165a_swio12_lednop               m165p_swio11_lednop
 * m165p_swio12_lednop               m165pa_swio11_lednop              m165pa_swio12_lednop
 */
static const uint64_t ur_m169_swio11_lednop[] = {
  0x905ff7777759bb37, 0xadddaab914ad225a, 0xbe3f770f8da0c227, 0x05fd0ee38f684ddf, 0x69b1006dbe3fbba9,
  0x905b2bbc9ddb1ec8, 0xfd0f3f01a609f180, 0x43be5ba09410f7fe, 0x638e9fc1d7ff51f2, 0x8731602dee9ba84c,
  0x30475e2e761151f4, 0x972ab52b305ee396, 0xaa35dce3398a0ed7, 0x576a96fabb39d454, 0xf4bfa4439ae0404e,
  0xf6ab44579621a572, 0x2ca6c59d01e7eb5c, 0xa2810b4d5ceaf52c, 0xdb4e31bc67440a2f, 0x9f9fd86ed84b997c,
  0xa271964b867a615c, 0xb9a19961d252d964, 0x00a93ebd71f3c95f,
};

/*
 * m169_swio11_lednop_pr_u4          m169_swio12_lednop_pr             m169_swio12_lednop_pr_u4
 * m169a_swio11_lednop_pr            m169a_swio11_lednop_pr_u4         m169a_swio12_lednop_pr
 * m169a_swio12_lednop_pr_u4         m169p_swio11_lednop_pr            m169p_swio11_lednop_pr_u4
 * m169p_swio12_lednop_pr            m169p_swio12_lednop_pr_u4         m169pa_swio11_lednop_pr
 * m169pa_swio11_lednop_pr_u4        m169pa_swio12_lednop_pr           m169pa_swio12_lednop_pr_u4
 * m165_swio11_lednop_pr             m165_swio11_lednop_pr_u4          m165_swio12_lednop_pr
 * m165_swio12_lednop_pr_u4          m165a_swio11_lednop_pr            m165a_swio11_lednop_pr_u4
 * m165a_swio12_lednop_pr            m165a_swio12_lednop_pr_u4         m165p_swio11_lednop_pr
 * m165p_swio11_lednop_pr_u4         m165p_swio12_lednop_pr            m165p_swio12_lednop_pr_u4
 * m165pa_swio11_lednop_pr           m165pa_swio11_lednop_pr_u4        m165pa_swio12_lednop_pr
 * m165pa_swio12_lednop_pr_u4
 */
static const uint64_t ur_m169_swio11_lednop_pr[] = {
  0xa0b777768911fc3b, 0xbb5572290be25713, 0x490dbf30fb609e0b, 0xac1c550c6d97bc2b, 0xeec7bafddb89d059,
  0x93bb704dd43329d8, 0xdcc13e30120b6577, 0xb9418f7fe78167d7, 0x0c9af51d003be5b7, 0x6594cfe7511c74fe,
  0xe76c9118df398b01, 0x48a807fecc11d7a3, 0x6b2ed40f2cf6e0ff, 0xb9c673141daf2e55, 0x2df57673a8a9546b,
  0x488735c0809caed5, 0x88af2c434ae5e97f, 0x9d01e395aeb9ed56, 0x9d10210a905ca5af, 0x62aa8b490538c6f1,
  0x09732f9b6c63156f, 0x1a2c6f8b9357079b, 0xa73f53ab31e40fca, 0xe627ff787bde50c2, 0xc3343cc9fe07f197,
  0x30be347a2ff03f7e, 0x96cf8138cb25c33d, 0x9e4afdcd0ccb0e92, 0x000007c99c87e202,
};

/*
 * m169_swio12_lednop_pr_ee          m169a_swio11_lednop_pr_ee         m169a_swio12_lednop_pr_ee
 * m169p_swio11_lednop_pr_ee         m169p_swio12_lednop_pr_ee         m169pa_swio11_lednop_pr_ee
 * m169pa_swio12_lednop_pr_ee        m165_swio11_lednop_pr_ee          m165_swio12_lednop_pr_ee
 * m165a_swio11_lednop_pr_ee         m165a_swio12_lednop_pr_ee         m165p_swio11_lednop_pr_ee
 * m165p_swio12_lednop_pr_ee         m165pa_swio11_lednop_pr_ee        m165pa_swio12_lednop_pr_ee
 */
static const uint64_t ur_m169_swio11_lednop_pr_ee[] = {
  0xd69bbbba1eb44511, 0xeed55f85da2c4b8f, 0xeac1dcc46df37326, 0xd0da181050b41392, 0x334b8bc41b4171fa,
  0x4eeabe67d938b17d, 0x5304f8c0482d95de, 0xe5046b7f9e059f4b, 0xa3cad82cd56b4663, 0xa9ef51f06cc1f51e,
  0x522cd3ad08a1df15, 0x6b26909afa30b2c4, 0x11cdc73ab4bba55c, 0x8d56ba1d79d37691, 0x3170908a17c47195,
  0x46c11fadc37b2d97, 0x5e5caad402b589e5, 0x52a8d7738ce6283b, 0x395daa5beaece751, 0xcbd2fe910e6b8101,
  0x73daad115e588695, 0xb94b5f3a03c72b5d, 0x718de33a20421520, 0xc62adec55516920a, 0xae0f3612e65f36d8,
  0x40fca1a2ce9f1726, 0xe50c2a73f53ab31e, 0x7993fc5ce32fcc4f, 0x615c9f8e7bff8268, 0x2d9f0271964b867a,
  0x3c95fb9a19961d25, 0x00000009d7324405,
};

/*
 * m169_swio12_lednop_pr_ee_u4       m169a_swio11_lednop_pr_ee_u4      m169a_swio12_lednop_pr_ee_u4
 * m169p_swio11_lednop_pr_ee_u4      m169p_swio12_lednop_pr_ee_u4      m169pa_swio11_lednop_pr_ee_u4
 * m169pa_swio12_lednop_pr_ee_u4     m165_swio11_lednop_pr_ee_u4       m165_swio12_lednop_pr_ee_u4
 * m165a_swio11_lednop_pr_ee_u4      m165a_swio12_lednop_pr_ee_u4      m165p_swio11_lednop_pr_ee_u4
 * m165p_swio12_lednop_pr_ee_u4      m165pa_swio11_lednop_pr_ee_u4     m165pa_swio12_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_swio11_lednop_pr_ee_u4[] = {
  0x6f26eeeed1222582, 0x3bb557e172b7122f, 0x5d23fb007a5f126d, 0xbc8a671fd412c9b4, 0x82d0bc5e20da08bd,
  0xf2774ed0439765aa, 0x5a9827c602416cae, 0xbf28235bfcf02cfa, 0xf51e5721e6ab5a3d, 0xaff77a8f83660e71,
  0x2291669d68450ef8, 0xc5133484d7d18596, 0x911a6273ab4bc065, 0xc6ab5d0ebd75376c, 0x3170908a20fa3b5a,
  0x7182feb70decb872, 0x8ce6283b5e5caad5, 0xeaece75152a8d773, 0x0e6b8101395daa5b, 0x5e588695cbd2fe91,
  0x74079fad73daad11, 0x3573abd4b0b29b16, 0xf19d1028be8a042d, 0xf3612e65f36d38c6, 0xf943458df1726ae0,
  0x1854e7ea75663c81, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe, 0x67a617c68f45fe07, 0xd252d9f0271964b8,
  0x4053c95fb9a19961, 0x0000000013ae917c,
};

/*
 * m169_swio11_lednop_pr_ce_u4       m169_swio12_lednop_pr_ce          m169_swio12_lednop_pr_ce_u4
 * m169a_swio11_lednop_pr_ce         m169a_swio11_lednop_pr_ce_u4      m169a_swio12_lednop_pr_ce
 * m169a_swio12_lednop_pr_ce_u4      m169p_swio11_lednop_pr_ce         m169p_swio11_lednop_pr_ce_u4
 * m169p_swio12_lednop_pr_ce         m169p_swio12_lednop_pr_ce_u4      m169pa_swio11_lednop_pr_ce
 * m169pa_swio11_lednop_pr_ce_u4     m169pa_swio12_lednop_pr_ce        m169pa_swio12_lednop_pr_ce_u4
 * m165_swio11_lednop_pr_ce          m165_swio11_lednop_pr_ce_u4       m165_swio12_lednop_pr_ce
 * m165_swio12_lednop_pr_ce_u4       m165a_swio11_lednop_pr_ce         m165a_swio11_lednop_pr_ce_u4
 * m165a_swio12_lednop_pr_ce         m165a_swio12_lednop_pr_ce_u4      m165p_swio11_lednop_pr_ce
 * m165p_swio11_lednop_pr_ce_u4      m165p_swio12_lednop_pr_ce         m165p_swio12_lednop_pr_ce_u4
 * m165pa_swio11_lednop_pr_ce        m165pa_swio11_lednop_pr_ce_u4     m165pa_swio12_lednop_pr_ce
 * m165pa_swio12_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_swio11_lednop_pr_ce[] = {
  0x26cfddddda244511, 0xc776aaf088f5e254, 0x8f7e9e8db622c1ef, 0xff5e35da59bbb26b, 0x62b2210209bb426c,
  0x2bbc9dd57ccfa0d9, 0x3f1ca609f180905b, 0xebdd4a0dbaff3c0b, 0x58f3c64a9de9bb8b, 0xc25f886c2445f712,
  0x8bb8dc24aca8fd47, 0x1e5f4f72c67eb267, 0xbd2a38e9fc1acff5, 0xd92231be731602c7, 0x500ffd99e3af47ce,
  0x976a0796b741fe91, 0xe3398a0ed7972ab5, 0xfabb39d454aa35dc, 0x439ae0404e576a96, 0x579621a572f4bfa4,
  0x80f1cad75cf6ab44, 0x881085482e52d7ce, 0x5545a4829c6378ce, 0x732f9b6c6263b7b1, 0x2c6f8b9357079b09,
  0x3f53ab31e40fca1a, 0x27ff787bde50c2a7, 0x343cc9fe07f197e6, 0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30,
  0x4afdcd0ccb0e9296, 0x00006eb842e2029e,
};

/*
 * m169_swio12_lednop_pr_ee_ce       m169a_swio11_lednop_pr_ee_ce      m169a_swio12_lednop_pr_ee_ce
 * m169p_swio11_lednop_pr_ee_ce      m169p_swio12_lednop_pr_ee_ce      m169pa_swio11_lednop_pr_ee_ce
 * m169pa_swio12_lednop_pr_ee_ce     m165_swio11_lednop_pr_ee_ce       m165_swio12_lednop_pr_ee_ce
 * m165a_swio11_lednop_pr_ee_ce      m165a_swio12_lednop_pr_ee_ce      m165p_swio11_lednop_pr_ee_ce
 * m165p_swio12_lednop_pr_ee_ce      m165pa_swio11_lednop_pr_ee_ce     m165pa_swio12_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_swio11_lednop_pr_ee_ce[] = {
  0x7f8fdddddd447032, 0x5ddaabd85048c4a1, 0x91db13ac829b18c4, 0x1f5a63be9de46829, 0xddc123f065ab42ff,
  0x2775b11ceb0c9c91, 0xc9827c602416caef, 0xb2821a3fcf02cfbf, 0x92a761a0effaa32e, 0xcee371a0e089fcf1,
  0x94b94ed6563df309, 0xa3e0d983d2bd4795, 0xa75a1140a62b287e, 0x2135f4616588a459, 0x47371ceaedce9475,
  0x6abc6c75e74dda44, 0x8b848450be238cac, 0x1b044c8e1bd96cb9, 0x7972ab52ced62795, 0x4aa35dce3398a0ed,
  0xe576a96fabb39d45, 0x2f4bfa4439ae0404, 0xcf6ab44579621a57, 0xe52d7ce80f1cad75, 0xc6378ce881085482,
  0x263b7b15545a4829, 0x3571b09732f9b6c6, 0x3c81f943458f38b9, 0x970cf4c2b93f7566, 0xc3a4a5b2c944e32c,
  0xf880a792bf734332, 0x0000000000534db8,
};

/*
 * m169_swio12_lednop_pr_ee_ce_u4    m169a_swio11_lednop_pr_ee_ce_u4   m169a_swio12_lednop_pr_ee_ce_u4
 * m169p_swio11_lednop_pr_ee_ce_u4   m169p_swio12_lednop_pr_ee_ce_u4   m169pa_swio11_lednop_pr_ee_ce_u4
 * m169pa_swio12_lednop_pr_ee_ce_u4  m165_swio11_lednop_pr_ee_ce_u4    m165_swio12_lednop_pr_ee_ce_u4
 * m165a_swio11_lednop_pr_ee_ce_u4   m165a_swio12_lednop_pr_ee_ce_u4   m165p_swio11_lednop_pr_ee_ce_u4
 * m165p_swio12_lednop_pr_ee_ce_u4   m165pa_swio11_lednop_pr_ee_ce_u4  m165pa_swio12_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio11_lednop_pr_ee_ce_u4[] = {
  0x615bbbbb44867a31, 0x776aafea6cce24b4, 0x6c36ed0b3760bf31, 0x0a800ad9914774cf, 0x946ea5d8596cf5a3,
  0x277513f0fbed03e2, 0x19827c602416caef, 0x94143effb15d9fec, 0xb83887d717d51e9b, 0x61222fb892c79e50,
  0xff1f77ea3e12fc43, 0xdcdbdf33c5dc6e70, 0x7a57a8f2b29729da, 0x14c5650fd47c1b30, 0x2cb1148b34eb4228,
  0x5db9d28ea426be8c, 0xbce9bb4888e6e39d, 0x17c471958d578d8e, 0xc37b2d973170908a, 0x59dac4f2a3608991,
  0xc673141daf2e556a, 0xf57673a8a9546bb9, 0x8735c0809caed52d, 0xaf2c434ae5e97f48, 0x01e395aeb9ed5688,
  0x10210a905ca5af9d, 0xaa8b490538c6f19d, 0xe65f36d8c4c76f62, 0xdc68b1be1b8f3612, 0x0a9cfd4eaccdfc1d,
  0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c, 0x16792bf734332c3a,
  0x00000009f91a9cdd,
};

/*
 * m169_swio12_lednop_hw             m169a_swio11_lednop_hw            m169a_swio12_lednop_hw
 * m169p_swio11_lednop_hw            m169p_swio12_lednop_hw            m169pa_swio11_lednop_hw
 * m169pa_swio12_lednop_hw           m165_swio11_lednop_hw             m165_swio12_lednop_hw
 * m165a_swio11_lednop_hw            m165a_swio12_lednop_hw            m165p_swio11_lednop_hw
 * m165p_swio12_lednop_hw            m165pa_swio11_lednop_hw           m165pa_swio12_lednop_hw
 */
static const uint64_t ur_m169_swio11_lednop_hw[] = {
  0x905ff7777759bb37, 0xadddaab914ad225a, 0xbe3f770f8da0c227, 0x05fd0ee38f684ddf, 0x69b1006dbe3fbba9,
  0x905b2bbc9ddb1ec8, 0xc38f3f01a609f180, 0x21df2dd04a087bff, 0x31c74fe0ebffa8f9, 0x4398b016f74dd426,
  0x1823af173b08a8fa, 0xcb955a95982f71cb, 0x551aee719cc5076b, 0x2bb54b7d5d9cea2a, 0x7a5fd221cd702027,
  0x7b55a22bcb10d2b9, 0x165362ce80f3f5ae, 0xd14085a6ae757a96, 0x6da718de33a20517, 0x4fcfec376c25ccbe,
  0x5138cb25c33d30ae, 0xdcd0ccb0e9296cb2, 0x004717d7d829e4af,
};

/*
 * m169_swio12_lednop_ee_hw          m169a_swio11_lednop_ee_hw         m169a_swio12_lednop_ee_hw
 * m169p_swio11_lednop_ee_hw         m169p_swio12_lednop_ee_hw         m169pa_swio11_lednop_ee_hw
 * m169pa_swio12_lednop_ee_hw        m165_swio11_lednop_ee_hw          m165_swio12_lednop_ee_hw
 * m165a_swio11_lednop_ee_hw         m165a_swio12_lednop_ee_hw         m165p_swio11_lednop_ee_hw
 * m165p_swio12_lednop_ee_hw         m165pa_swio11_lednop_ee_hw        m165pa_swio12_lednop_ee_hw
 */
static const uint64_t ur_m169_swio11_lednop_ee_hw[] = {
  0xfad377776890c044, 0xdddaabf0bb458971, 0xde4bbb988dbe6e64, 0x7eb4368604142d04, 0x7f4cd2e2f106d05c,
  0xcaef277505272d08, 0xcfa5a9827c602416, 0x68cc7ca08d6ffa14, 0x3ea3d4795b059aad, 0x3be2b53dea3e0d98,
  0x16588a459a75a114, 0x74ab8d64d2135f46, 0x6ed22239b8e75697, 0x8e32b1aad743af3a, 0x65b2e62e121142f8,
  0xb13ca8d823f5b86f, 0xc5076bcb955a8056, 0x9cea2a551aee719c, 0x7020272bb54b7d5d, 0x10d2b97a5fd221cd,
  0xe56bae7b55a22bcb, 0x42a417296be74078, 0xd2414e31bc674408, 0xe6db18c55bd8aaa2, 0xd4176371e6c25ccb,
  0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3,
  0x0000b7c6a728a792,
};

/*
 * m169_swio12_lednop_ce_hw          m169a_swio11_lednop_ce_hw         m169a_swio12_lednop_ce_hw
 * m169p_swio11_lednop_ce_hw         m169p_swio12_lednop_ce_hw         m169pa_swio11_lednop_ce_hw
 * m169pa_swio12_lednop_ce_hw        m165_swio11_lednop_ce_hw          m165_swio12_lednop_ce_hw
 * m165a_swio11_lednop_ce_hw         m165a_swio12_lednop_ce_hw         m165p_swio11_lednop_ce_hw
 * m165p_swio12_lednop_ce_hw         m165pa_swio11_lednop_ce_hw        m165pa_swio12_lednop_ce_hw
 */
static const uint64_t ur_m169_swio11_lednop_ce_hw[] = {
  0x367eeeeed121b7d6, 0x3bb5578447af12a1, 0xab8f746db1160f7e, 0xcff5e35da59bbb27, 0xfdab2210209bb426,
  0x0b657793baf5a716, 0x0a67e394c13e3012, 0xdc5f5eea506dd7fd, 0x71258f3ca170734d, 0xd47c25f886c2445f,
  0x2678bb8dc98667cf, 0xff51e5f4f72c67eb, 0x2c7bd2a38e9fc1ac, 0x7ced92231be73160, 0xe91500ffd99e3af4,
  0xab5976a0796b741f, 0x5dce3398a0ed7972, 0xa96fabb39d454aa3, 0xfa4439ae0404e576, 0xb44579621a572f4b,
  0x7ce80f1cad75cf6a, 0x8ce881085482e52d, 0x7b15545a4829c637, 0xb09732f9b6c6263b, 0x0c2a73f505d8dc79,
  0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0x2a29e4afdcd0ccb0,
  0x000000000759bef8,
};

/*
 * m169_swio11_lednop_ee_ce_u4_hw    m169_swio12_lednop_ee_ce_hw       m169_swio12_lednop_ee_ce_u4_hw
 * m169a_swio11_lednop_ee_ce_hw      m169a_swio11_lednop_ee_ce_u4_hw   m169a_swio12_lednop_ee_ce_hw
 * m169a_swio12_lednop_ee_ce_u4_hw   m169p_swio11_lednop_ee_ce_hw      m169p_swio11_lednop_ee_ce_u4_hw
 * m169p_swio12_lednop_ee_ce_hw      m169p_swio12_lednop_ee_ce_u4_hw   m169pa_swio11_lednop_ee_ce_hw
 * m169pa_swio11_lednop_ee_ce_u4_hw  m169pa_swio12_lednop_ee_ce_hw     m169pa_swio12_lednop_ee_ce_u4_hw
 * m165_swio11_lednop_ee_ce_hw       m165_swio11_lednop_ee_ce_u4_hw    m165_swio12_lednop_ee_ce_hw
 * m165_swio12_lednop_ee_ce_u4_hw    m165a_swio11_lednop_ee_ce_hw      m165a_swio11_lednop_ee_ce_u4_hw
 * m165a_swio12_lednop_ee_ce_hw      m165a_swio12_lednop_ee_ce_u4_hw   m165p_swio11_lednop_ee_ce_hw
 * m165p_swio11_lednop_ee_ce_u4_hw   m165p_swio12_lednop_ee_ce_hw      m165p_swio12_lednop_ee_ce_u4_hw
 * m165pa_swio11_lednop_ee_ce_hw     m165pa_swio11_lednop_ee_ce_u4_hw  m165pa_swio12_lednop_ee_ce_hw
 * m165pa_swio12_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio11_lednop_ee_ce_hw[] = {
  0x30addddda2435f41, 0xbbb557f53667125a, 0xb61b76859bb05f98, 0x8540056cc8a3ba67, 0x4a3752ec2cb67ad1,
  0xbbc9dda2feef6b89, 0xfb06609f180905b2, 0xf4dca0a1f7fd0a67, 0xf285c1c43eb8bea8, 0xe21b09117dc4963c,
  0x715d7185ff51f097, 0x4ed6e6def99e2ee3, 0xd983d2bd479594b9, 0x1140a62b287ea3e0, 0xf4616588a459a75a,
  0x1ceaedce94752135, 0x6c75e74dda444737, 0x8450be238cac6abc, 0x4c8e1bd96cb98b84, 0xab52ced627951b04,
  0x5dce3398a0ed7972, 0xa96fabb39d454aa3, 0xfa4439ae0404e576, 0xb44579621a572f4b, 0x7ce80f1cad75cf6a,
  0x8ce881085482e52d, 0x7b15545a4829c637, 0xb09732f9b6c6263b, 0x0c2a73f505d8dc79, 0x197e627ff787bde5,
  0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0xea29e4afdcd0ccb0, 0x0000000000a028d4,
};

/*
 * m169_swio11_dual_pr               m169_swio11_dual_pr_u4            m169_swio12_dual
 * m169_swio12_dual_pr               m169_swio12_dual_pr_u4            m169a_swio11_dual
 * m169a_swio11_dual_pr              m169a_swio11_dual_pr_u4           m169a_swio12_dual
 * m169a_swio12_dual_pr              m169a_swio12_dual_pr_u4           m169p_swio11_dual
 * m169p_swio11_dual_pr              m169p_swio11_dual_pr_u4           m169p_swio12_dual
 * m169p_swio12_dual_pr              m169p_swio12_dual_pr_u4           m169pa_swio11_dual
 * m169pa_swio11_dual_pr             m169pa_swio11_dual_pr_u4          m169pa_swio12_dual
 * m169pa_swio12_dual_pr             m169pa_swio12_dual_pr_u4          m165_swio11_dual
 * m165_swio11_dual_pr               m165_swio11_dual_pr_u4            m165_swio12_dual
 * m165_swio12_dual_pr               m165_swio12_dual_pr_u4            m165a_swio11_dual
 * m165a_swio11_dual_pr              m165a_swio11_dual_pr_u4           m165a_swio12_dual
 * m165a_swio12_dual_pr              m165a_swio12_dual_pr_u4           m165p_swio11_dual
 * m165p_swio11_dual_pr              m165p_swio11_dual_pr_u4           m165p_swio12_dual
 * m165p_swio12_dual_pr              m165p_swio12_dual_pr_u4           m165pa_swio11_dual
 * m165pa_swio11_dual_pr             m165pa_swio11_dual_pr_u4          m165pa_swio12_dual
 * m165pa_swio12_dual_pr             m165pa_swio12_dual_pr_u4
 */
static const uint64_t ur_m169_swio11_dual[] = {
  0x23fbbbbb4486c541, 0x13b7e3af4e46d2e3, 0x17ddb83d3a85b4bf, 0xe2ff23b295f14adb, 0x59f16a015bab8c8f,
  0xd0eeb047f0d57a8c, 0x04f8c0482d95de4a, 0xd6d0322525215233, 0xb881850c1b48c0dd, 0x393fccab773ba7c4,
  0xa3bf9b05f67028b3, 0x14239227f06654de, 0x0f8510c4aff3f7c1, 0x5777bbe6e35d8037, 0xb454219684648865,
  0xb6e52ffe80e784d6, 0xfb9af30586f2bc84, 0xdd1df2cb5e504a2f, 0x7b8e3a7f07bdfa8f, 0xc4e62c0550799c98,
  0x30475e00cec80234, 0xb3db7bc6faa01ffb, 0x5f3bb8a92be7503c, 0x8a0ed7972ab59fc5, 0x39d454aa35dce339,
  0xe0404e576a96fabb, 0x21a572f4bfa4439a, 0xcad75cf6ab445796, 0x85482e52d7ce80f1, 0xa4829c6378ce8810,
  0xcdb6318ab7b15545, 0x2c6f86e3cd84b997, 0x3f53ab337f07771a, 0x27ff787bde50c2a7, 0x343cc9fe07f197e6,
  0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30, 0x4afdcd0ccb0e9296, 0x000524c83937459e,
};

/*
 * m169_swio12_dual_pr_ee            m169a_swio11_dual_pr_ee           m169a_swio12_dual_pr_ee
 * m169p_swio11_dual_pr_ee           m169p_swio12_dual_pr_ee           m169pa_swio11_dual_pr_ee
 * m169pa_swio12_dual_pr_ee          m165_swio11_dual_pr_ee            m165_swio12_dual_pr_ee
 * m165a_swio11_dual_pr_ee           m165a_swio12_dual_pr_ee           m165p_swio11_dual_pr_ee
 * m165p_swio12_dual_pr_ee           m165pa_swio11_dual_pr_ee          m165pa_swio12_dual_pr_ee
 */
static const uint64_t ur_m169_swio11_dual_pr_ee[] = {
  0x33d6dddddd435032, 0xf13b7e35342136ac, 0x69edd39cafa05991, 0x9199daaef4d7dfbd, 0x87d73899bd7b0cf5,
  0xabdb47faf7dd8e17, 0x80905b2bbc9e9cee, 0xc8949485d16609f1, 0x14306d2303775b40, 0x32addcee9f12e206,
  0xd825a3805a98c7ff, 0x44fe0e2b4dea393a, 0x1895fe7ef8228472, 0xf9b9743006e1f0a2, 0xcb417da21955ddee,
  0xfe80e784c1ee2a10, 0x0586f2bc84b6fa6b, 0x7fba5042d7fb9af3, 0xf7ea3caedd4d56b4, 0xe2bd37ea3e0d9830,
  0x588a459a75a1143b, 0xae2a5cd2135f4616, 0x31e8cf539d5a5d82, 0x0d8d56ba1d7a8976, 0x4b3170908a34a471,
  0xaa8d823f5b86f65f, 0xbe777152500b2288, 0x141daf2e556b3f8a, 0x73a8a9546bb9c673, 0xc0809caed52df576,
  0x434ae5e97f488735, 0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021, 0x9b6c63156f62aa8b,
  0xb1e70dc79b09732f, 0x27eeaccdfc1ddc68, 0xc09c6592e19e9857, 0x7ee6866587494b67, 0x0190a22f9ba2cf25,
};

/*
 * m169_swio12_dual_pr_ee_u4         m169a_swio11_dual_pr_ee_u4        m169a_swio12_dual_pr_ee_u4
 * m169p_swio11_dual_pr_ee_u4        m169p_swio12_dual_pr_ee_u4        m169pa_swio11_dual_pr_ee_u4
 * m169pa_swio12_dual_pr_ee_u4       m165_swio11_dual_pr_ee_u4         m165_swio12_dual_pr_ee_u4
 * m165a_swio11_dual_pr_ee_u4        m165a_swio12_dual_pr_ee_u4        m165p_swio11_dual_pr_ee_u4
 * m165p_swio12_dual_pr_ee_u4        m165pa_swio11_dual_pr_ee_u4       m165pa_swio12_dual_pr_ee_u4
 */
static const uint64_t ur_m169_swio11_dual_pr_ee_u4[] = {
  0x5b777768adbba0ae, 0xedf8d4d084dab0cf, 0xf34e72be816647c4, 0xb55de9afbf6d3da3, 0x71337af619eb2333,
  0x6eaf61f5dc2f0fae, 0x95de4f4e777d7dfd, 0x42e8b304f8c0482d, 0x9181bbada0644a4a, 0x774f8971030a1836,
  0x016a631ffccb4b7e, 0xad37a8e4eb60968e, 0xfbe08a11c913f838, 0xc01b87c2886257f9, 0x88655777bbe6e5d0,
  0x1307b8a8432d05f6, 0xf212dbe9affa039e, 0x2d7fe3f0cc161bca, 0xedd4d56b47fba504, 0xa3e0d9830f7ea3ca,
  0xa75a1143be2bd37e, 0x2135f4616588a459, 0x39d5a5d82ae2a5cd, 0xa1d7a897631e8cf5, 0x08a34a4710d8d56b,
  0xf5b86f65f4b31709, 0x2500b2288aa8d823, 0xe556b3f8abe77715, 0x46bb9c673141daf2, 0xed52df57673a8a95,
  0x97f488735c0809ca, 0xd5688af2c434ae5e, 0x5af9d01e395aeb9e, 0x6f19d10210a905ca, 0x56f62aa8b490538c,
  0x79b09732f9b6c631, 0xdbb1a2c6f8b93570, 0x854e7ea75666fe0f, 0x2fcc4ffef0f7bca1, 0xfd86687993fc0fe3,
  0x7a617c68f45fe07e, 0x252d9f0271964b86, 0xdd3c95fb9a19961d, 0x0000002b27b13fc8,
};

/*
 * m169_swio12_dual_pr_ce            m169a_swio11_dual_pr_ce           m169a_swio12_dual_pr_ce
 * m169p_swio11_dual_pr_ce           m169p_swio12_dual_pr_ce           m169pa_swio11_dual_pr_ce
 * m169pa_swio12_dual_pr_ce          m165_swio11_dual_pr_ce            m165_swio12_dual_pr_ce
 * m165a_swio11_dual_pr_ce           m165a_swio12_dual_pr_ce           m165p_swio11_dual_pr_ce
 * m165p_swio12_dual_pr_ce           m165pa_swio11_dual_pr_ce          m165pa_swio12_dual_pr_ce
 */
static const uint64_t ur_m169_swio11_dual_pr_ce[] = {
  0x6edddddec121a5fb, 0x4edf9e3fbb368a70, 0xfb755f362477707c, 0xbb69c89f55fd77a0, 0x995dfbf7ba538374,
  0x5dd2c8d759b42acc, 0x3e30120b65779262, 0x6819129291118cc1, 0x40c2860da4606eeb, 0x7fe655bb9dd3e25c,
  0xd9db08e470383375, 0x8e489fc1cae9bd47, 0x144312bfcfdf0450, 0xdeef9b8a4800dc3e, 0xa10cb403da21955d,
  0x66ffe80e784c13e2, 0x5e60b0de579096dc, 0x8beafe4a09c1ff73, 0x24b1e7942e0e13ab, 0x8f84bf10d8488bee,
  0x9e2ee3719be951fa, 0x51c27cf72c67d4b9, 0x45dbf1c74fe0ed6f, 0x764011a627316029, 0xd500ffd99e3af006,
  0x57cea0796b73de37, 0x556b3f8abe777152, 0x6bb9c673141daf2e, 0xd52df57673a8a954, 0x7f488735c0809cae,
  0x5688af2c434ae5e9, 0xaf9d01e395aeb9ed, 0xf19d10210a905ca5, 0x6f62aa8b490538c6, 0x3612e65f36d8c4c7,
  0xe0eee34596af1b8f, 0x4a1854e7ea75666f, 0xf01f343cc9fe04e3, 0x4e32c970cf4c2b93, 0x734332c3a4a5b3e0,
  0x3491eb6dd16792bf,
};

/*
 * m169_swio12_dual_pr_ce_u4         m169a_swio11_dual_pr_ce_u4        m169a_swio12_dual_pr_ce_u4
 * m169p_swio11_dual_pr_ce_u4        m169p_swio12_dual_pr_ce_u4        m169pa_swio11_dual_pr_ce_u4
 * m169pa_swio12_dual_pr_ce_u4       m165_swio11_dual_pr_ce_u4         m165_swio12_dual_pr_ce_u4
 * m165a_swio11_dual_pr_ce_u4        m165a_swio12_dual_pr_ce_u4        m165p_swio11_dual_pr_ce_u4
 * m165p_swio12_dual_pr_ce_u4        m165pa_swio11_dual_pr_ce_u4       m165pa_swio12_dual_pr_ce_u4
 */
static const uint64_t ur_m169_swio11_dual_pr_ce_u4[] = {
  0x4e4eddddda2432db, 0xf13b7e78fb1736ac, 0x4d7dd6c4eca38f4e, 0xe4ea666eb4b1272d, 0x674a3f738abf76c4,
  0xc968aee3822ac07c, 0xfa609f180905b2bb, 0x3775b40c8949483a, 0xf12e20614306d230, 0xdcd15bf32addcee9,
  0x6f51f2b6c37d9c34, 0xc114239227f0650e, 0x370f8510c4aff3f7, 0x655777bbe6e25400, 0xa718a8432d009e88,
  0x12dbd8fffd01cf09, 0xdfee6bcc161bcaf2, 0x8a7ae2faedf9411a, 0x22fb892c79e50b83, 0x21fea3e12fc43612,
  0xf0e333c5dc6e759b, 0x193dea3cbe9ee58c, 0x1602edf5f238e9fc, 0xd7916ec3e231be73, 0xa4a3ab87b8e58cf1,
  0x5caad67f157ceee2, 0xa8d7738ce6283b5e, 0x5daa5beaece75152, 0xd2fe910e6b810139, 0xdaad115e588695cb,
  0xb29b1674079fad73, 0x63042d3573abd4b0, 0xda718de33a20517c, 0x37c371e6c25ccbe6, 0xa9d599bf83bb8d16,
  0xffbc3def2861539f, 0x1e64ff03f8cbf313, 0x1a3d17f81fbf619a, 0xc09c6592e19e985f, 0x7ee6866587494b67,
  0x000d242cdba2cf25,
};

/*
 * m169_swio12_dual_pr_ee_ce         m169a_swio11_dual_pr_ee_ce        m169a_swio12_dual_pr_ee_ce
 * m169p_swio11_dual_pr_ee_ce        m169p_swio12_dual_pr_ee_ce        m169pa_swio11_dual_pr_ee_ce
 * m169pa_swio12_dual_pr_ee_ce       m165_swio11_dual_pr_ee_ce         m165_swio12_dual_pr_ee_ce
 * m165a_swio11_dual_pr_ee_ce        m165a_swio12_dual_pr_ee_ce        m165p_swio11_dual_pr_ee_ce
 * m165p_swio12_dual_pr_ee_ce        m165pa_swio11_dual_pr_ee_ce       m165pa_swio12_dual_pr_ee_ce
 */
static const uint64_t ur_m169_swio11_dual_pr_ee_ce[] = {
  0xda57dbbbbba86f97, 0x6f13b7e3111f86d7, 0x7af7bb62f1aac33d, 0xf1ba4e56820f913f, 0xbebd77a9be4bf695,
  0xe78233a96453ab04, 0x180905b2bbc9c9ce, 0x19129290724e609f, 0xc2860da4606eeb68, 0xe655bb9dd3e25c40,
  0xcd80683869a99fe7, 0x489fc1f4fcdea3ff, 0x4312bfcfdf04508e, 0xdf373ce400dc3e14, 0x19681c34432abbbd,
  0x7fd01cf099c9c542, 0x60b0de579096dc52, 0x8ca1ca0e9aff735e, 0xe7942e0e69a3bfea, 0xcc273b8dc524e6ff,
  0x1e56c1653b595910, 0x4f7a8f83660fa8f5, 0x91669d68450298ad, 0x31d484d7d1859622, 0xb6fa397c73abb71c,
  0xcb1aaf1b1d7b589d, 0x7c62e121140288c7, 0x9718e4532386f65c, 0x955acfe2af9ddc54, 0x1aee719cc5076bcb,
  0xb54b7d5d9cea2a55, 0x5fd221cd7020272b, 0x55a22bcb10d2b97a, 0x6be74078e56bae7b, 0xbc67440842a41729,
  0xdbd8aaa2d2414e31, 0xcd84b997cdb63131, 0xfe0eee3458f386e3, 0x70cf4c2b93f75666, 0xc3a4a5b3e04e32c9,
  0x8dd16792bf734332, 0x0000000000098273,
};

/*
 * m169_swio12_dual_pr_ee_ce_u4      m169a_swio11_dual_pr_ee_ce_u4     m169a_swio12_dual_pr_ee_ce_u4
 * m169p_swio11_dual_pr_ee_ce_u4     m169p_swio12_dual_pr_ee_ce_u4     m169pa_swio11_dual_pr_ee_ce_u4
 * m169pa_swio12_dual_pr_ee_ce_u4    m165_swio11_dual_pr_ee_ce_u4      m165_swio12_dual_pr_ee_ce_u4
 * m165a_swio11_dual_pr_ee_ce_u4     m165a_swio12_dual_pr_ee_ce_u4     m165p_swio11_dual_pr_ee_ce_u4
 * m165p_swio12_dual_pr_ee_ce_u4     m165pa_swio11_dual_pr_ee_ce_u4    m165pa_swio12_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio11_dual_pr_ee_ce_u4[] = {
  0xbeeeeed15b770668, 0x6fccc5fc26d157d8, 0x6a6bd5784339de27, 0xe2faf7683acadada, 0x7138abec5e713ada,
  0x399a0e087877d737, 0x6c4eeab8fb000352, 0x609f180905b2bbc9, 0xd6d032252521966e, 0xb881850c1b48c0dd,
  0x2d7e65a5bf3ba7c4, 0xe376c3b04e178737, 0x8e489fc1b5dcdea3, 0x144312bfcfdf0450, 0xbddf37055000dc3e,
  0x4219684724432abb, 0x257fd01cf09b7dc5, 0x0cc161bcaf212dbd, 0xa8c9d4a0de1ffe3f, 0x1e7942f3bbc3b8be,
  0x4bf10d8488bee24b, 0xb8dc1545927fa8f8, 0xba53b5b9b9ba678b, 0xf06cc1edff51e572, 0xad08a05315efbf51,
  0x9afa30b2c4522cd3, 0x3d4e7576e60a3a90, 0xbc6c75ea25d8c7a3, 0x848451a523886c6a, 0x08991c37b2fa598b,
  0xc5494b3c8a22aa36, 0xbcb955acfe2af9dd, 0xa551aee719cc5076, 0x72bb54b7d5d9cea2, 0x97a5fd221cd70202,
  0xe7b55a22bcb10d2b, 0x7296be74078e56ba, 0xe31bc67440842a41, 0x131dbd8aaa2d2414, 0xb83cd84b997cdb63,
  0x07edd8d1637c5c9a, 0x50c2a73f53ab337f, 0xf197e627ff787bde, 0x3f7ec3343cc9fe07, 0xc33d30be347a2ff0,
  0x0e9296cf8138cb25, 0xe46e9e4afdcd0ccb, 0x0000000010013f05,
};

/*
 * m169_swio12_dual_hw               m169a_swio11_dual_hw              m169a_swio12_dual_hw
 * m169p_swio11_dual_hw              m169p_swio12_dual_hw              m169pa_swio11_dual_hw
 * m169pa_swio12_dual_hw             m165_swio11_dual_hw               m165_swio12_dual_hw
 * m165a_swio11_dual_hw              m165a_swio12_dual_hw              m165p_swio11_dual_hw
 * m165p_swio12_dual_hw              m165pa_swio11_dual_hw             m165pa_swio12_dual_hw
 */
static const uint64_t ur_m169_swio11_dual_hw[] = {
  0x8feeeeed12190907, 0x4edf8ebd391b4b8c, 0x5f76e0f4ea16d2fc, 0x8bfc8eca57c52b6c, 0x67c5a8056eae323f,
  0x2b43bad07eafbd7b, 0xcc13e30120b65779, 0x775b40c894948548, 0x12e20614306d2303, 0xcce4ff32addcee9f,
  0x7a8efe6c17d9c0a2, 0x04508e489fc19953, 0xdc3e144312bfcfdf, 0x955ddeef9b8d7600, 0x5ad150865a119221,
  0x12db94bffa039e13, 0x7ffd48cc161bcaf2, 0x7ee8ef965af28251, 0xc3dc71d3f83defd4, 0xa62731602a83cce4,
  0xd9823af006764011, 0xe59edbde37d500ff, 0x2af9ddc5495f3a81, 0xcc5076bcb955acfe, 0xd9cea2a551aee719,
  0xd7020272bb54b7d5, 0xb10d2b97a5fd221c, 0x8e56bae7b55a22bc, 0x842a417296be7407, 0x2d2414e31bc67440,
  0xbe6db18c55bd8aaa, 0xfd4176371e6c25cc, 0x9ffde1ef79430a9c, 0xd0f327f81fc65f98, 0xf8d1e8bfc0fdfb0c,
  0x3e04e32c970cf4c2, 0x2bf734332c3a4a5b, 0x0000c6ea41ca8a79,
};

/*
 * m169_swio12_dual_ee_hw            m169a_swio11_dual_ee_hw           m169a_swio12_dual_ee_hw
 * m169p_swio11_dual_ee_hw           m169p_swio12_dual_ee_hw           m169pa_swio11_dual_ee_hw
 * m169pa_swio12_dual_ee_hw          m165_swio11_dual_ee_hw            m165_swio12_dual_ee_hw
 * m165a_swio11_dual_ee_hw           m165a_swio12_dual_ee_hw           m165p_swio11_dual_ee_hw
 * m165p_swio12_dual_ee_hw           m165pa_swio11_dual_ee_hw          m165pa_swio12_dual_ee_hw
 */
static const uint64_t ur_m169_swio11_dual_ee_hw[] = {
  0xeb6eeee87ad0cf68, 0x9dbf1a9a109b5619, 0xf6e9ce57d02cc8f8, 0xcced577a6befdeb4, 0xeb9c4cdebd867ac8,
  0xcd1f53ad6ec70bc3, 0x30120b657793d39d, 0x19129290ba2cc13e, 0xc2860da4606eeb68, 0xe655bb9dd3e25c40,
  0x5b04b4700b5318ff, 0x489fc1c569bd4727, 0x4312bfcfdf04508e, 0xdf372e8600dc3e14, 0x19682fb4432abbbd,
  0x7fd01cf0983dc542, 0x60b0de579096df4d, 0x1fee9410b5ffea46, 0x3dfa8f2bb75355ad, 0xf8af4dfa8f83660c,
  0x962291669d68450e, 0xab8a973484d7d185, 0x8c7a33d4e7569760, 0x436355ae875ea25d, 0xd2cc5c24228d291c,
  0x2aa3608fd6e1bd97, 0xaf9ddc549402c8a2, 0xc5076bcb955acfe2, 0x9cea2a551aee719c, 0x7020272bb54b7d5d,
  0x10d2b97a5fd221cd, 0xe56bae7b55a22bcb, 0x42a417296be74078, 0xd2414e31bc674408, 0xe6db18c55bd8aaa2,
  0xa5eae371e6c25ccb, 0x65f989fca1854e7e, 0x7ff04d0f327f8b9c, 0xc970cf4c2b93f1cf, 0x32c3a4a5b3e04e32,
  0xd22fa8a792bf7343, 0x00000000000000ae,
};

/*
 * m169_swio12_dual_ce_hw            m169a_swio11_dual_ce_hw           m169a_swio12_dual_ce_hw
 * m169p_swio11_dual_ce_hw           m169p_swio12_dual_ce_hw           m169pa_swio11_dual_ce_hw
 * m169pa_swio12_dual_ce_hw          m165_swio11_dual_ce_hw            m165_swio12_dual_ce_hw
 * m165a_swio11_dual_ce_hw           m165a_swio12_dual_ce_hw           m165p_swio11_dual_ce_hw
 * m165p_swio12_dual_ce_hw           m165pa_swio11_dual_ce_hw          m165pa_swio12_dual_ce_hw
 */
static const uint64_t ur_m169_swio11_dual_ce_hw[] = {
  0xc1bb77776890cf68, 0xf13b7e78feecda29, 0x83edd57cd891ddc1, 0xd2eda7227d57f5de, 0x326577efdee94e0d,
  0x498977347d4eb5bb, 0x3304f8c0482d95de, 0xbbada0644a4a4446, 0x8971030a18369181, 0xcdd5ff9956ee774f,
  0xf51f676c2391c0e0, 0x114239227f072ba6, 0x70f8510c4aff3f7c, 0x55777bbe6e292003, 0x4f8a8432d00f6886,
  0x5b719bffa039e130, 0xffa91982c3795e42, 0x9d5c5f57f2504e0f, 0x5f71258f3ca17070, 0xafd47c25f886c244,
  0x52e678bb8dc643a4, 0xb5bd4709f3dcb19f, 0x80a5176fc71d3f83, 0xc019d90046989cc5, 0x78df5403ff6678eb,
  0xc5495f3a81e5adcf, 0xbcb955acfe2af9dd, 0xa551aee719cc5076, 0x72bb54b7d5d9cea2, 0x97a5fd221cd70202,
  0xe7b55a22bcb10d2b, 0x7296be74078e56ba, 0xe31bc67440842a41, 0x131dbd8aaa2d2414, 0x6e3cd84b997cdb63,
  0xdef2861539fa82ec, 0xf03f8cbf313ffbc3, 0x7f81fbf619a1e64f, 0x592e19e985f1a3d1, 0x66587494b67c09c6,
  0x757add14f257ee68, 0x0000000000000013,
};

/*
 * m169_swio12_dual_ee_ce_hw         m169a_swio11_dual_ee_ce_hw        m169a_swio12_dual_ee_ce_hw
 * m169p_swio11_dual_ee_ce_hw        m169p_swio12_dual_ee_ce_hw        m169pa_swio11_dual_ee_ce_hw
 * m169pa_swio12_dual_ee_ce_hw       m165_swio11_dual_ee_ce_hw         m165_swio12_dual_ee_ce_hw
 * m165a_swio11_dual_ee_ce_hw        m165a_swio12_dual_ee_ce_hw        m165p_swio11_dual_ee_ce_hw
 * m165p_swio12_dual_ee_ce_hw        m165pa_swio11_dual_ee_ce_hw       m165pa_swio12_dual_ee_ce_hw
 */
static const uint64_t ur_m169_swio11_dual_ee_ce_hw[] = {
  0x924cdddddd43359b, 0xf13b7e311b043693, 0xe4f7475d3eced362, 0x7accf8673226b8ed, 0x66c9b537c953924c,
  0x70f0cc29ad75ebde, 0x8c0482d95de4b337, 0x0c894948cb69304f, 0x614306d2303775b4, 0xf32addcee9f12e20,
  0xad83fc3862099aef, 0x244fe0ffe4dea3e9, 0x21895fe7ef822847, 0xef9b8b82006e1f0a, 0x0cb4182a21955dde,
  0xffe80e784d21e2a1, 0x60b0de579096dcd6, 0x1e56941c41ffea46, 0xcf285c1cc4077fd5, 0x984e771b9950d07f,
  0x3cae574a76b2b26e, 0xf7ea3e0d983dbfea, 0x459a75a1140a62bd, 0x4752135f4616588a, 0x18f467a9ceaedcc1,
  0x0d8d578d8ebd44bb, 0x4b3170908a34a471, 0x5546c1132386f65f, 0x5f3bb8a929679144, 0x8a0ed7972ab59fc5,
  0x39d454aa35dce339, 0xe0404e576a96fabb, 0x21a572f4bfa4439a, 0xcad75cf6ab445796, 0x85482e52d7ce80f1,
  0xa4829c6378ce8810, 0x9b6c6263b7b15545, 0xf3fb0dc79b09732f, 0x4e32c970cf4c2b93, 0x734332c3a4a5b3e0,
  0x0044d300a8a792bf,
};

/*
 * m169_swio12_dual_ee_ce_u4_hw      m169a_swio11_dual_ee_ce_u4_hw     m169a_swio12_dual_ee_ce_u4_hw
 * m169p_swio11_dual_ee_ce_u4_hw     m169p_swio12_dual_ee_ce_u4_hw     m169pa_swio11_dual_ee_ce_u4_hw
 * m169pa_swio12_dual_ee_ce_u4_hw    m165_swio11_dual_ee_ce_u4_hw      m165_swio12_dual_ee_ce_u4_hw
 * m165a_swio11_dual_ee_ce_u4_hw     m165a_swio12_dual_ee_ce_u4_hw     m165p_swio11_dual_ee_ce_u4_hw
 * m165p_swio12_dual_ee_ce_u4_hw     m165pa_swio11_dual_ee_ce_u4_hw    m165pa_swio12_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio11_dual_ee_ce_u4_hw[] = {
  0x17ddddda28d172df, 0xedf998bf84da2afb, 0xdd4d7aaf08673bc4, 0xadae2faf7683baca, 0x7377138abec5e713,
  0x0d5a1968e087877d, 0xd95de4b62776d6aa, 0x90cb37304f8c0482, 0xa4606eeb68191292, 0x9dd3e25c40c2860d,
  0xe1787372d7e65d84, 0x5dcdea3e376c3b04, 0xfdf04508e489fc1b, 0x000dc3e144312bfc, 0x4432abbbddf37055,
  0x09b7dc5421968472, 0xf212dbd257fd01cf, 0xc3ff67a1cc161bca, 0x787717d5193a941b, 0x7dc4963cf1be1839,
  0xff51f097e21b0911, 0x74cf1771b816467a, 0xa3cae574a76b7373, 0xdf7ea3e0d983dbfe, 0xa459a75a1140a62b,
  0x14752135f4616588, 0xb18f467a9ceaedcc, 0x10d8d578d8ebd44b, 0xf4b3170908a34a47, 0x45546c1132386f65,
  0x55f3bb8a92967914, 0x98a0ed7972ab59fc, 0xb39d454aa35dce33, 0xae0404e576a96fab, 0x621a572f4bfa4439,
  0x1cad75cf6ab44579, 0x085482e52d7ce80f, 0x5a4829c6378ce881, 0xf9b6c6263b7b1554, 0xf505d8dc79b09732,
  0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c,
  0x003aeac6680be9e4,
};

/*
 * m169a_swio13_noled                m169p_swio13_noled                m169pa_swio13_noled
 * m165_swio13_noled                 m165a_swio13_noled                m165p_swio13_noled
 * m165pa_swio13_noled
 */
static const uint64_t ur_m169_swio13_noled[] = {
  0x3ddbbbbbbacdfc4f, 0xf5bbb5572285ee25, 0xf4b8eea1c4891844, 0xe17f43bb89dd9fc1, 0xa3504db632b4dd9e,
  0x0482d95de4eec2f5, 0xf7e879f31f304f8c, 0x109df2dd24a0edff, 0xd78e3a7f07cf7a8f, 0x9a398b016f74da52,
  0x630475e2e76b868c, 0x7972ab52b2bfee39, 0x4aa35dce3398a0ed, 0xdaa5beaa6fb39d45, 0x5abdebe910e6b395,
  0x5cf6ab44579621a5, 0x5380b2953e9de7eb, 0xbf714085a585cea7, 0x7cdb4e31bc674408, 0x5c9f9fd86ed84b99,
  0x64a271964b867a61, 0x5fb9a19961d252d9, 0x0000548b8d71f3c9,
};

/*
 * m169_swio13_noled_pr_u4           m169a_swio13_noled_pr             m169a_swio13_noled_pr_u4
 * m169p_swio13_noled_pr             m169p_swio13_noled_pr_u4          m169pa_swio13_noled_pr
 * m169pa_swio13_noled_pr_u4         m165_swio13_noled_pr              m165_swio13_noled_pr_u4
 * m165a_swio13_noled_pr             m165a_swio13_noled_pr_u4          m165p_swio13_noled_pr
 * m165p_swio13_noled_pr_u4          m165pa_swio13_noled_pr            m165pa_swio13_noled_pr_u4
 */
static const uint64_t ur_m169_swio13_noled_pr[] = {
  0x27777776891190e3, 0x1776aae453c7c492, 0x3d537bab21c6c13c, 0xb358d0600266f259, 0xac7c2f1afba913a0,
  0xef277448b333761b, 0xdfc9827c602416ca, 0xa0fca0995fe78167, 0xfc1f41ea3cbe3be5, 0x05965347bd2a38e9,
  0x47ced10a3dece62c, 0x5269500ffd9823af, 0x556afadc0f2cf6c4, 0x6bb9c673141daf2e, 0xb7d54df673a8a954,
  0xbd7d221cd672bb54, 0xd5688af2c434ab57, 0x4a7869de7c5aeb9e, 0x31bc6744083ba9b1, 0x8ab7b15545a5b44e,
  0xe0f3612e65f36c64, 0x81f943458df1726a, 0xca1854e7ea75663c, 0xfe32fcc4ffef0f7b, 0x07efd86687993fc0,
  0xb867a617c68f45fe, 0x61d252d9f0271964, 0xb44053c95fb9a199, 0x00000000007c9aa6,
};

/*
 * m169a_swio13_noled_pr_ee          m169p_swio13_noled_pr_ee          m169pa_swio13_noled_pr_ee
 * m165_swio13_noled_pr_ee           m165a_swio13_noled_pr_ee          m165p_swio13_noled_pr_ee
 * m165pa_swio13_noled_pr_ee
 */
static const uint64_t ur_m169_swio13_noled_pr_ee[] = {
  0xfdddddd0f5a22a20, 0xdddaabf0bd45893a, 0x7be477c7edbe6e64, 0x86d1337aed2c90a6, 0xb452b620da09d7d6,
  0x7747b16a4771a8d2, 0x9827c602416caef2, 0x28315bfcf02cf93a, 0x8f2b297355ad1bf9, 0xa1fa8f83660c27fa,
  0x91669d68450ef8ac, 0x593484d7d1859622, 0x8f2439d5a5d2b2e3, 0x6ab5d0ebce9bb750, 0x170908a3e44707ec,
  0x6c11fadc37b2d973, 0xcb955a805d260b54, 0x551aee719cc5076b, 0xd52df5537d9cea2a, 0xd5ef5f4887359cae,
  0xe7b55a22bcb10d2a, 0x6c529e1a779f16ba, 0x138c6f19d1020eea, 0x1922adec5551696d, 0x9ab83cd84b997cdb,
  0x7903f2868b3a7c5c, 0x3f9430a9cfd4eacc, 0xa1e64ff1738cbf31, 0xe985727e39effe09, 0x94b67c09c6592e19,
  0x14f257ee68665874, 0x000000009d7c6310,
};

/*
 * m169a_swio13_noled_pr_ee_u4       m169p_swio13_noled_pr_ee_u4       m169pa_swio13_noled_pr_ee_u4
 * m165_swio13_noled_pr_ee_u4        m165a_swio13_noled_pr_ee_u4       m165p_swio13_noled_pr_ee_u4
 * m165pa_swio13_noled_pr_ee_u4
 */
static const uint64_t ur_m169_swio13_noled_pr_ee_u4[] = {
  0xc5eeeeeed12232a8, 0xb4eed55f85e85c4b, 0xd2eae3d1b6c47c49, 0xe4531d7c33c5ef4c, 0x8b41568106d05e2d,
  0xc9dd3ad1a848b3ea, 0x5a609f180905b2bb, 0x54a0efbff3c0b3f1, 0xea3cadd2cd56b466, 0x5c87f51f06cc1a01,
  0x4522cd3ad08a1df1, 0x8a266909afa30b2c, 0x8a37bce75697a94b, 0x8d56ba1d7aea6ed3, 0xc5c242285ae8ee1d,
  0xe3a4fadc37b2e1c8, 0x19cc5076bcb955aa, 0x37d9cea2a551aee7, 0x887359caed52df55, 0x2bcb10d2ad5ef5f4,
  0xa779f16bae7b55a2, 0x9d1020eea6c529e1, 0xc5551696d138c6f1, 0x84b997cdb1922ade, 0x0d1637c5c9ab83cd,
  0x539fa9d598f207e5, 0xf313ffbc3def2861, 0x619a1e64ff03f8cb, 0x985f1a3d17f81fbf, 0x4b67c09c6592e19e,
  0x4f257ee686658749, 0x00000004eb967101,
};

/*
 * m169_swio13_noled_pr_ce_u4        m169a_swio13_noled_pr_ce          m169a_swio13_noled_pr_ce_u4
 * m169p_swio13_noled_pr_ce          m169p_swio13_noled_pr_ce_u4       m169pa_swio13_noled_pr_ce
 * m169pa_swio13_noled_pr_ce_u4      m165_swio13_noled_pr_ce           m165_swio13_noled_pr_ce_u4
 * m165a_swio13_noled_pr_ce          m165a_swio13_noled_pr_ce_u4       m165p_swio13_noled_pr_ce
 * m165p_swio13_noled_pr_ce_u4       m165pa_swio13_noled_pr_ce         m165pa_swio13_noled_pr_ce_u4
 */
static const uint64_t ur_m169_swio13_noled_pr_ce[] = {
  0xbdeeeeeed1222a20, 0xf8eed55e11069c48, 0x8fe9a5ddb6ebd83d, 0x9febf8f9fb0678ec, 0x1a8207ae486e97bd,
  0xcaef27747b16a8e3, 0xcfece9827c602416, 0xf5dbf2832bbfcf02, 0x2c79e3254ef7ddc5, 0xe12fc4361222fb89,
  0xc5dc6e5c89257ea3, 0x479ba7b9633f5933, 0x9538c71d3f8327bd, 0x768851ef67316029, 0x4a807feccf1d7a3e,
  0xd5f5b81e5adc2293, 0x738ce6283b5e5caa, 0xaa9bece75152a8d7, 0xfa4439ace576a96f, 0xd115e5886956af7a,
  0xf0d3bcf8b5d73daa, 0x78ce881077536294, 0x6f62aa8b4b689c63, 0xcd84b997cdb190c7, 0xe50d1637c5c9ab83,
  0x61539fa9d598f207, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1,
  0x014f257ee6866587, 0x00000000375d3411,
};

/*
 * m169a_swio13_noled_pr_ee_ce       m169p_swio13_noled_pr_ee_ce       m169pa_swio13_noled_pr_ee_ce
 * m165_swio13_noled_pr_ee_ce        m165a_swio13_noled_pr_ee_ce       m165p_swio13_noled_pr_ee_ce
 * m165pa_swio13_noled_pr_ee_ce
 */
static const uint64_t ur_m169_swio13_noled_pr_ee_ce[] = {
  0x02fddddddd447705, 0x88bbb557b0a4bb89, 0xb89db93b504b2631, 0xfe3eb47a7c94c4d0, 0x5c11236460cb5605,
  0xde4eed86d94f5926, 0xd35304f8c0482d95, 0x52e507fe7f9e059f, 0xe3254effe1dff546, 0x09cee3732a1a0ff9,
  0x959c394ed6563df3, 0xbea3e0d9833d7d47, 0x59a75a1140a62b2e, 0x752135f4616588a4, 0xa847921ceaedc958,
  0xec6abc6c75e74ddb, 0x73170908a3e44707, 0xaa3608991c37b2d9, 0xb5e5caad4b3e9305, 0x152a8d7738ce6283,
  0x576a96faa9bece75, 0x956af7afa4439ace, 0x5d73daad115e5886, 0x7536294f0d3bcf8b, 0xb689c6378ce88107,
  0xdb190c76f62aa8b4, 0x9c5c9ab8d84b997c, 0xbab31e40fca1a2c7, 0x71964b867a615c9f, 0xa19961d252d964a2,
  0xa63cbc4053c95fb9, 0x0000000000000029,
};

/*
 * m169a_swio13_noled_pr_ee_ce_u4    m169p_swio13_noled_pr_ee_ce_u4    m169pa_swio13_noled_pr_ee_ce_u4
 * m165_swio13_noled_pr_ee_ce_u4     m165a_swio13_noled_pr_ee_ce_u4    m165p_swio13_noled_pr_ee_ce_u4
 * m165pa_swio13_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio13_noled_pr_ee_ce_u4[] = {
  0x09bbbbbb448692df, 0xc5ddaabfa9d89892, 0x3d7adba34f1782fc, 0x4c2a0006713ae0fd, 0xcdd333582165b3d0,
  0xde4eea8fa10abe26, 0x8dd304f8c0482d95, 0x9d282d77ff62bb3f, 0xa17071aeee2faa3d, 0x86c2445f71258f3c,
  0x2e0b87ffd47c25f8, 0xdadcdbdf33c5dc6e, 0x3067afa8f2b38729, 0x2814c565d7d47c1b, 0x8c2cb1148b34eb42,
  0x9d5db92b0ea426be, 0x8ebce9bb7508f243, 0x147c88e0fd8d578d, 0x2386f65b2e62e121, 0xa967d260b546c113,
  0xe719cc5076bcb955, 0x5537d9cea2a551ae, 0xf4887359caed52df, 0xa22bcb10d2ad5ef5, 0xe1a779f16bae7b55,
  0xf19d1020eea6c529, 0xdec5551696d138c6, 0x9b09732f9b63218e, 0xfe0eee3458df0dc7, 0xbca1854e7ea75666,
  0x0fe32fcc4ffef0f7, 0xe07efd86687993fc, 0x4b867a617c68f45f, 0x961d252d9f027196, 0x9c6e8b3c95fb9a19,
  0x0000000000027e0c,
};

/*
 * m169a_swio13_noled_hw             m169p_swio13_noled_hw             m169pa_swio13_noled_hw
 * m165_swio13_noled_hw              m165a_swio13_noled_hw             m165p_swio13_noled_hw
 * m165pa_swio13_noled_hw
 */
static const uint64_t ur_m169_swio13_noled_hw[] = {
  0x3ddbbbbbbacdfc4f, 0xf5bbb5572285ee25, 0xf4b8eea1c4891844, 0xe17f43bb89dd9fc1, 0xa3504db632b4dd9e,
  0x0482d95de4eec2f5, 0xfe1c79f31f304f8c, 0x884ef96e925076ff, 0x6bc71d3f83e7bd47, 0x4d1cc580b7ba6d29,
  0xb1823af173b5c346, 0xbcb955a9595ff71c, 0xa551aee719cc5076, 0xed52df5537d9cea2, 0xad5ef5f4887359ca,
  0xae7b55a22bcb10d2, 0xa9c0594a9f4ef3f5, 0x5fb8a042d2c2e753, 0xbe6da718de33a204, 0xae4fcfec376c25cc,
  0xb25138cb25c33d30, 0xafdcd0ccb0e9296c, 0x0000238971d829e4,
};

/*
 * m169a_swio13_noled_ee_hw          m169p_swio13_noled_ee_hw          m169pa_swio13_noled_ee_hw
 * m165_swio13_noled_ee_hw           m165a_swio13_noled_ee_hw          m165p_swio13_noled_ee_hw
 * m165pa_swio13_noled_ee_hw
 */
static const uint64_t ur_m169_swio13_noled_ee_hw[] = {
  0xd7eeeeeed1219541, 0x26eed55f85ea2c49, 0x0da67bbe3f6df373, 0x7d686d1337aed2c9, 0x8d2b452b620da09d,
  0x95de4ee80a499a73, 0x9f275304f8c0482d, 0x68dfc9418adff429, 0x613fd479594b9aad, 0x77c5650fd47c1b30,
  0x2cb1148b34eb4228, 0x95971ac9a426be8c, 0xddba847921cead2e, 0x383f6355ae875e74, 0x96cb98b848451f22,
  0x305aa3608fd6e1bd, 0x283b5e5caad402e9, 0xe75152a8d7738ce6, 0xace576a96faa9bec, 0x886956af7afa4439,
  0xf8b5d73daad115e5, 0x1077536294f0d3bc, 0x8b4b689c6378ce88, 0xcbe6d8c9156f62aa, 0xcfd4176371e6c25c,
  0x89ffde1ef79430a9, 0xcd0f327f81fc65f9, 0x2f8d1e8bfc0fdfb0, 0xb3e04e32c970cf4c, 0x92bf734332c3a4a5,
  0x000000b7ff24e8a7,
};

/*
 * m169a_swio13_noled_ce_hw          m169p_swio13_noled_ce_hw          m169pa_swio13_noled_ce_hw
 * m165_swio13_noled_ce_hw           m165a_swio13_noled_ce_hw          m165p_swio13_noled_ce_hw
 * m165pa_swio13_noled_ce_hw
 */
static const uint64_t ur_m169_swio13_noled_ce_hw[] = {
  0xbdeeeeeed121be4a, 0xf8eed55e11069c48, 0xde91fdddb6ebd83d, 0x7b3fd7f1f3f60cf1, 0xb55f040f5c90dd2f,
  0x905b2bbc9dd29475, 0xe8533fb3a609f180, 0xddc5f5dbf2832bbf, 0xf71258f3ca170737, 0xfd47c25f886c2445,
  0xb2678bb8dc35b986, 0x4f7a8f374f72c67e, 0xc0532a718e3a7f06, 0xf47ced10a3dece62, 0x45269500ffd99e3a,
  0xb955abeb703cb5b8, 0x51aee719cc5076bc, 0x52df5537d9cea2a5, 0x5ef5f4887359caed, 0x7b55a22bcb10d2ad,
  0xc529e1a779f16bae, 0x38c6f19d1020eea6, 0x218edec5551696d1, 0x8dc79b09732f9b63, 0x7bde50c2a73f505d,
  0xfe07f197e627ff78, 0x2ff03f7ec3343cc9, 0xcb25c33d30be347a, 0x0ccb0e9296cf8138, 0x9b7c93a29e4afdcd,
  0x0000000000000075,
};

/*
 * m169_swio13_noled_ee_ce_u4_hw     m169a_swio13_noled_ee_ce_hw       m169a_swio13_noled_ee_ce_u4_hw
 * m169p_swio13_noled_ee_ce_hw       m169p_swio13_noled_ee_ce_u4_hw    m169pa_swio13_noled_ee_ce_hw
 * m169pa_swio13_noled_ee_ce_u4_hw   m165_swio13_noled_ee_ce_hw        m165_swio13_noled_ee_ce_u4_hw
 * m165a_swio13_noled_ee_ce_hw       m165a_swio13_noled_ee_ce_u4_hw    m165p_swio13_noled_ee_ce_hw
 * m165p_swio13_noled_ee_ce_u4_hw    m165pa_swio13_noled_ee_ce_hw      m165pa_swio13_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio13_noled_ee_ce_hw[] = {
  0x04dddddda2436812, 0x62eed55fd4ec4c49, 0x9ebd6dd1a78bc17e, 0x26150003389d707e, 0xe6e999ac10b2d9e8,
  0xcaef27777ec2da9a, 0x9fc6e9827c602416, 0xa3d9d282d77ff429, 0xf3ca17071aeee2fa, 0x5f886c2445f71258,
  0x8dce41d5d7fd47c2, 0xe53b5b9b7be678bb, 0x83660cf5f51e5670, 0x68450298acbafa8f, 0xd7d185962291669d,
  0x4873abb72561d484, 0xf1b1d79d376ea11e, 0x24228f911c1fb1aa, 0x226470decb65cc5c, 0x2ab52cfa4c16a8d8,
  0x35dce3398a0ed797, 0x5beaa6fb39d454aa, 0xdebe910e6b395daa, 0x6ab44579621a55ab, 0xa53c34ef3e2d75cf,
  0x18de33a2041dd4d8, 0x31dbd8aaa2d2da27, 0xb8f3612e65f36c64, 0x7bca1854e7ea0bb1, 0xc0fe32fcc4ffef0f,
  0xfe07efd86687993f, 0x64b867a617c68f45, 0x9961d252d9f02719, 0x21939453c95fb9a1, 0x00000000000000a0,
};

/*
 * m169a_swio13_lednop               m169p_swio13_lednop               m169pa_swio13_lednop
 * m165_swio13_lednop                m165a_swio13_lednop               m165p_swio13_lednop
 * m165pa_swio13_lednop
 */
static const uint64_t ur_m169_swio13_lednop[] = {
  0xa7bb77777759bb37, 0x4f5bbb5572295a44, 0xbf7c7eefaff0b184, 0xf70bfa1ddc4ed09b, 0x21a6c401b6f8feec,
  0x02416caef2776c7b, 0xfbf43cfc069827c6, 0xc90ef96e925043df, 0x98c71d3f83e7bd47, 0xe90e62c05bdd3750,
  0x2c608ebc5cec22a3, 0xaf2e556a5660bdc7, 0xa9546bb9c673141d, 0xbb54b7d54df673a8, 0x25fd221cd7020272,
  0xdaad115e588695c9, 0x2d794e02e7407973, 0xf45021695844c2f5, 0x9b69c6378ce88145, 0x93f3fb0ddb09732f,
  0x944e32c970cf4c2b, 0xf734332c3a4a5b2c, 0x001527d7ae3e792b,
};

/*
 * m169_swio13_lednop_pr_u4          m169a_swio13_lednop_pr            m169a_swio13_lednop_pr_u4
 * m169p_swio13_lednop_pr            m169p_swio13_lednop_pr_u4         m169pa_swio13_lednop_pr
 * m169pa_swio13_lednop_pr_u4        m165_swio13_lednop_pr             m165_swio13_lednop_pr_u4
 * m165a_swio13_lednop_pr            m165a_swio13_lednop_pr_u4         m165p_swio13_lednop_pr
 * m165p_swio13_lednop_pr_u4         m165pa_swio13_lednop_pr           m165pa_swio13_lednop_pr_u4
 */
static const uint64_t ur_m169_swio13_lednop_pr[] = {
  0x277777768911d38b, 0x1776aae45017c492, 0x86ad1a6d7af6c13c, 0x59ac683e3e00f164, 0x4f4da9b11dd489d0,
  0x7793ba8cca734b29, 0xea54c13e30120b65, 0x41f94131ffe78167, 0xfc1f41ea3e9477cb, 0x0b2ca680c13e38e9,
  0x8f9d97c47191cc58, 0xee1aa01ffb30475e, 0xab5b87207967b637, 0x5dce3398a0ed7972, 0xbeaa6fb39d454aa3,
  0x10e6b8101395daa5, 0x8af2c434ae492fe9, 0xd01e395aeb9ed568, 0xd10210a905ca5af9, 0x2aa8b490538c6f19,
  0x9732f9b6815156f6, 0xa2c6f8b9357079b0, 0x73f53ab31e40fca1, 0x627ff787bde50c2a, 0x3343cc9fe07f197e,
  0x0be347a2ff03f7ec, 0x6cf8138cb25c33d3, 0xe4afdcd0ccb0e929, 0x00003e4ffaa22029,
};

/*
 * m169a_swio13_lednop_pr_ee         m169p_swio13_lednop_pr_ee         m169pa_swio13_lednop_pr_ee
 * m165_swio13_lednop_pr_ee          m165a_swio13_lednop_pr_ee         m165p_swio13_lednop_pr_ee
 * m165pa_swio13_lednop_pr_ee
 */
static const uint64_t ur_m169_swio13_lednop_pr_ee[] = {
  0x7eeeeeeea0a22044, 0x6eed55f85c8fc49d, 0x0ef4ed85f0073732, 0xa1b44cea2bd76416, 0x2b8cdd88368275f5,
  0x9dd4149c8c884331, 0xe609f180905b2bbc, 0x941383fe78167e87, 0x4795a9e9aad68dfc, 0x813d47c1b30613fd,
  0x48b34eb422877c57, 0xac9a426be8c2cb11, 0x460a1cead2f21d71, 0x355ae875e74ddbba, 0x8b8484513723c8b6,
  0x3608fd6e1bd96cb9, 0xf2e556a0108a4d2a, 0x9546bb9c673141da, 0xb54b7d54df673a8a, 0x5fd221cd7020272b,
  0xaad115e588695c92, 0xb5f3a03c72b5d73d, 0xde33a20421520b94, 0xadec55516920a718, 0xf3612e65f36d02a2,
  0xca1a2cb579726ae0, 0xc2a73f53ab31e40f, 0xf9a1e64ff0271a50, 0x964b867a615c9f80, 0x19961d252d9f0271,
  0xbe10c4053c95fb9a, 0x000000000000004e,
};

/*
 * m169a_swio13_lednop_pr_ee_u4      m169p_swio13_lednop_pr_ee_u4      m169pa_swio13_lednop_pr_ee_u4
 * m165_swio13_lednop_pr_ee_u4       m165a_swio13_lednop_pr_ee_u4      m165p_swio13_lednop_pr_ee_u4
 * m165pa_swio13_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_swio13_lednop_pr_ee_u4[] = {
  0xc5eeeeeed1222a20, 0xb4eed55f85c19c4b, 0xc8fe9a5d2e233c49, 0xe2de4531d7eb20a6, 0x6a081eb9bb106d05,
  0x2bbc9dd1ec5aa38c, 0x7e87e609f180905b, 0x8cca941383fe7816, 0x403d47959c39aad6, 0xbe2b727ea3e0d983,
  0x6588a459a75a1143, 0xed7144cd2135f461, 0xd97c47109cead2eb, 0x45b1aad743af5d4d, 0x1c8c5c242281be8c,
  0xb55c2cffadc37b2e, 0xdce3398a0ed7972a, 0xeaa6fb39d454aa35, 0x0e6b8101395daa5b, 0xaf2c434ae492fe91,
  0x3a03cfd6b9ed5688, 0x9ab9d5ea58594d8b, 0x78ce88139f450216, 0x79b09732f9b69c63, 0xfca1a2c6f8b93570,
  0x0c2a73f53ab31e40, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c,
  0x2029e4afdcd0ccb0, 0x0000000004eba682,
};

/*
 * m169a_swio13_lednop_pr_ce         m169p_swio13_lednop_pr_ce         m169pa_swio13_lednop_pr_ce
 * m165_swio13_lednop_pr_ce          m165a_swio13_lednop_pr_ce         m165p_swio13_lednop_pr_ce
 * m165pa_swio13_lednop_pr_ce
 */
static const uint64_t ur_m169_swio13_lednop_pr_ce[] = {
  0xbdddddd0f5a22044, 0x1ddaabc225058917, 0x9e989d803d2b07bf, 0xfebf8f8d33f6a6fe, 0x1b45a8ac86e97bd9,
  0x5de4eea0a4e57042, 0xf1ad304f8c0482d9, 0xbb7e5074dff9e059, 0x8f3c64a9deceb8be, 0x25f886c2445f7125,
  0xbb8dc4a8b91fd47c, 0xf38cf72c67eb2678, 0xcf58e3a7f064f7a8, 0x97c47191cc580a63, 0xa01ffb33c75e8f9d,
  0xe1c81e5adc37ee1a, 0x8ce6283b5e5caad6, 0x9bece75152a8d773, 0xae0404e576a96faa, 0xb10d2b924bfa4439,
  0x8e56bae7b55a22bc, 0x842a417296be7407, 0x2d2414e31bc67440, 0x7cdb40a31dbd8aaa, 0x7c5c9ab83cd84b99,
  0xeacc7903f2868b3a, 0xbf313f9430a9cfd4, 0xfe09a1e64ff1738c, 0x2e19e985727e39ef, 0x587494b67c09c659,
  0x3d1014f257ee6866, 0x000000000001bafd,
};

/*
 * m169a_swio13_lednop_pr_ce_u4      m169p_swio13_lednop_pr_ce_u4      m169pa_swio13_lednop_pr_ce_u4
 * m165_swio13_lednop_pr_ce_u4       m165a_swio13_lednop_pr_ce_u4      m165p_swio13_lednop_pr_ce_u4
 * m165pa_swio13_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_swio13_lednop_pr_ce_u4[] = {
  0x9beeeeeed1222044, 0x3eeed55e11219c4b, 0x6475a2efa5ad14cc, 0x83f85d098bcd8b1f, 0x10deb8d3537bbcdf,
  0xcaef277505272e9c, 0xcfdba9827c602416, 0xfa9eb283813fcf02, 0x963cf192a7795ae2, 0xf097e21b09117dc4,
  0xe2ee3712a2e47f51, 0x8f924f72c67e3399, 0xd0291c74fe0c43fa, 0xd9ef476b1cc580bd, 0x08bb8e58cf1d78b9,
  0x398a0ed7972ab51d, 0xfb39d454aa35dce3, 0x8101395daa5beaa6, 0x434ae492fe910e6b, 0x95aeb9ed5688af2c,
  0x0a905ca5af9d01e3, 0x490538c6f19d1021, 0x36d028c76f62aa8b, 0x1726ae0f3612e65f, 0x5663c81f943458df,
  0xf0f7bca1854e7ea7, 0x93fc0fe32fcc4ffe, 0xf45fe07efd866879, 0x71964b867a617c68, 0x9a19961d252d9f02,
  0xbaf56544053c95fb, 0x0000000000000001,
};

/*
 * m169a_swio13_lednop_pr_ee_ce      m169p_swio13_lednop_pr_ee_ce      m169pa_swio13_lednop_pr_ee_ce
 * m165_swio13_lednop_pr_ee_ce       m165a_swio13_lednop_pr_ee_ce      m165p_swio13_lednop_pr_ee_ce
 * m165pa_swio13_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_swio13_lednop_pr_ee_ce[] = {
  0x817eeeeeeea22044, 0xc45ddaabd8520dc4, 0x82c4ec0bd3630a18, 0xbfc7d68f4e5df250, 0x389c8ccd2c196ac0,
  0xbbc9dd4149c80504, 0xed6e609f180905b2, 0x2972829b7fe78167, 0xe3254ed36ceffaa3, 0x09cee3714939bff9,
  0x9594394ed6563df3, 0xbea3e0d9833d7d47, 0x59a75a1140a62b60, 0x752135f4616588a4, 0xba460a1ceaedd21c,
  0x6c6abc6c75e74ddb, 0x73170908a26e4791, 0x2a3608991c37b2d9, 0xdaf2e556a5988a4d, 0x8a9546bb9c673141,
  0x2bb54b7d54df673a, 0x925fd221cd702027, 0x3daad115e588695c, 0x94b5f3a03c72b5d7, 0x18de33a20421520b,
  0x18edec55516920a7, 0xd5c6c25ccbe6da05, 0xf207e50d163ce2e4, 0x5c33d30ae4fdd598, 0x0e9296cb25138cb2,
  0xe2029e4afdcd0ccb, 0x000000000014d3c6,
};

/*
 * m169a_swio13_lednop_pr_ee_ce_u4   m169p_swio13_lednop_pr_ee_ce_u4   m169pa_swio13_lednop_pr_ee_ce_u4
 * m165_swio13_lednop_pr_ee_ce_u4    m165a_swio13_lednop_pr_ee_ce_u4   m165p_swio13_lednop_pr_ee_ce_u4
 * m165pa_swio13_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio13_lednop_pr_ee_ce_u4[] = {
  0x09bbbbbb448650e3, 0xc5ddaabfa986e892, 0x1d015baf5cfd82fc, 0x4c2a000676262779, 0xdd914e8e2165b3d0,
  0x7793ba1607db29c2, 0x9adcc13e30120b65, 0xb3a504527fd8aecf, 0xca17070525c5f547, 0x886c2445f71258f3,
  0xc67afd6afd47c25f, 0x3b5b9b7be678bb8d, 0x660cf5f51e5650e5, 0x450298ad82fa8f83, 0xd185962291669d68,
  0x73abb74871d484d7, 0xb1d79d376ee91828, 0x2289b91e45b1aaf1, 0x6470decb65cc5c24, 0x5a96622934a8d822,
  0xee719cc5076bcb95, 0xf5537d9cea2a551a, 0x8735c0809caed52d, 0x579621a572497f48, 0x80f1cad75cf6ab44,
  0x881085482e52d7ce, 0x5545a4829c6378ce, 0x732f9b681463b7b1, 0xee3458df0dc79b09, 0x854e7ea75666fe0e,
  0x2fcc4ffef0f7bca1, 0xfd86687993fc0fe3, 0x7a617c68f45fe07e, 0x252d9f0271964b86, 0x8b3c95fb9a19961d,
  0x00000004fc07936e,
};

/*
 * m169a_swio13_lednop_hw            m169p_swio13_lednop_hw            m169pa_swio13_lednop_hw
 * m165_swio13_lednop_hw             m165a_swio13_lednop_hw            m165p_swio13_lednop_hw
 * m165pa_swio13_lednop_hw
 */
static const uint64_t ur_m169_swio13_lednop_hw[] = {
  0xa7bb77777759bb37, 0x4f5bbb5572295a44, 0xbf7c7eefaff0b184, 0xf70bfa1ddc4ed09b, 0x21a6c401b6f8feec,
  0x02416caef2776c7b, 0xff0e3cfc069827c6, 0xe4877cb7492821ef, 0x4c638e9fc1f3dea3, 0xf48731602dee9ba8,
  0x9630475e2e761151, 0xd7972ab52b305ee3, 0x54aa35dce3398a0e, 0x5daa5beaa6fb39d4, 0x92fe910e6b810139,
  0xed5688af2c434ae4, 0x96bca70173a03cb9, 0xfa2810b4ac22617a, 0xcdb4e31bc67440a2, 0xc9f9fd86ed84b997,
  0x4a271964b867a615, 0xfb9a19961d252d96, 0x0008e2fafb053c95,
};

/*
 * m169a_swio13_lednop_ee_hw         m169p_swio13_lednop_ee_hw         m169pa_swio13_lednop_ee_hw
 * m165_swio13_lednop_ee_hw          m165a_swio13_lednop_ee_hw         m165p_swio13_lednop_ee_hw
 * m165pa_swio13_lednop_ee_hw
 */
static const uint64_t ur_m169_swio13_lednop_ee_hw[] = {
  0xebf777776890c582, 0x93776aafc2e47e24, 0x43560eec2f8039b9, 0x5f5a1b44cea2bd76, 0xa312b8cdd8836827,
  0x657793ba76821e96, 0xcfd0fcc13e30120b, 0xb46fe4a09c1ffa14, 0x309fea3cad4f4d56, 0x3be2bc09ea3e0d98,
  0x16588a459a75a114, 0x90eb8d64d2135f46, 0x6eddd23050e75697, 0x1e45b1aad743af3a, 0xcb65cc5c242289b9,
  0x526951b047eb70de, 0x8a0ed7972ab50084, 0x39d454aa35dce339, 0x01395daa5beaa6fb, 0x4ae492fe910e6b81,
  0xaeb9ed5688af2c43, 0x905ca5af9d01e395, 0x0538c6f19d10210a, 0x6815156f62aa8b49, 0x5d8dc79b09732f9b,
  0x787bde50c2a73f50, 0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81,
  0x02df9a9ca29e4afd,
};

/*
 * m169a_swio13_lednop_ce_hw         m169p_swio13_lednop_ce_hw         m169pa_swio13_lednop_ce_hw
 * m165_swio13_lednop_ce_hw          m165a_swio13_lednop_ce_hw         m165p_swio13_lednop_ce_hw
 * m165pa_swio13_lednop_ce_hw
 */
static const uint64_t ur_m169_swio13_lednop_ce_hw[] = {
  0xbdeeeeeed121af43, 0xf8eed55e11282c48, 0x6f7e9eec01e9583d, 0xbd9febf8f8d33f6a, 0xb765345a8ac86e97,
  0x905b2bbc9dd69df6, 0xe8533e35a609f180, 0x75c5f5dbf283a6ff, 0xf71258f3ca170736, 0xfd47c25f886c2445,
  0x64cf1771b9cb4cdf, 0x9ef51e719ee58cfd, 0x014c79eb1c74fe0c, 0xd1f3b2f88e32398b, 0xfdc35403ff6678eb,
  0x955adc3903cb5b86, 0x1aee719cc5076bcb, 0x2df5537d9cea2a55, 0x488735c0809caed5, 0x44579621a572497f,
  0xce80f1cad75cf6ab, 0xce881085482e52d7, 0xb15545a4829c6378, 0x09732f9b681463b7, 0xc2a73f505d8dc79b,
  0x97e627ff787bde50, 0x7ec3343cc9fe07f1, 0x3d30be347a2ff03f, 0x9296cf8138cb25c3, 0xa29e4afdcd0ccb0e,
  0x000000003acd8056,
};

/*
 * m169_swio13_lednop_ee_ce_u4_hw    m169a_swio13_lednop_ee_ce_hw      m169a_swio13_lednop_ee_ce_u4_hw
 * m169p_swio13_lednop_ee_ce_hw      m169p_swio13_lednop_ee_ce_u4_hw   m169pa_swio13_lednop_ee_ce_hw
 * m169pa_swio13_lednop_ee_ce_u4_hw  m165_swio13_lednop_ee_ce_hw       m165_swio13_lednop_ee_ce_u4_hw
 * m165a_swio13_lednop_ee_ce_hw      m165a_swio13_lednop_ee_ce_u4_hw   m165p_swio13_lednop_ee_ce_hw
 * m165p_swio13_lednop_ee_ce_u4_hw   m165pa_swio13_lednop_ee_ce_hw     m165pa_swio13_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio13_lednop_ee_ce_hw[] = {
  0x04dddddda243704a, 0x62eed55fd4c37449, 0x8e80add7ae7ec17e, 0x261500033b1313bc, 0xeec8a74710b2d9e8,
  0x2bbc9dd75bae3b5d, 0x7cd6e609f180905b, 0x47b3a504527fd0a6, 0xf3ca17070525c5f5, 0x5f886c2445f71258,
  0xe373ce5d4efd47c2, 0x394ed6e6def99e2e, 0xe0d9833d7d479594, 0x5a1140a62b60bea3, 0x35f4616588a459a7,
  0x0a1ceaedd21c7521, 0xbc6c75e74ddbba46, 0x0908a26e47916c6a, 0x08991c37b2d97317, 0xe556a5988a4d2a36,
  0x46bb9c673141daf2, 0x4b7d54df673a8a95, 0xd221cd7020272bb5, 0xd115e588695c925f, 0xf3a03c72b5d73daa,
  0x33a20421520b94b5, 0xec55516920a718de, 0xc25ccbe6da0518ed, 0x30a9cfd4176371e6, 0x65f989ffde1ef794,
  0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970, 0xe8a792bf734332c3, 0x00000000028081e4,
};

/*
 * m169_swio13_dual_pr               m169_swio13_dual_pr_u4            m169a_swio13_dual
 * m169a_swio13_dual_pr              m169a_swio13_dual_pr_u4           m169p_swio13_dual
 * m169p_swio13_dual_pr              m169p_swio13_dual_pr_u4           m169pa_swio13_dual
 * m169pa_swio13_dual_pr             m169pa_swio13_dual_pr_u4          m165_swio13_dual
 * m165_swio13_dual_pr               m165_swio13_dual_pr_u4            m165a_swio13_dual
 * m165a_swio13_dual_pr              m165a_swio13_dual_pr_u4           m165p_swio13_dual
 * m165p_swio13_dual_pr              m165p_swio13_dual_pr_u4           m165pa_swio13_dual
 * m165pa_swio13_dual_pr             m165pa_swio13_dual_pr_u4
 */
static const uint64_t ur_m169_swio13_dual[] = {
  0xa7bbbbbb44869a4e, 0x7e276fc75e10cdaf, 0xb9f7ba8ce5dd0b69, 0x1fc5fc95264e2765, 0xe19628d4d8b77e99,
  0x2b43bb8fea3151f1, 0xcc13e30120b65779, 0x775b40c894948ba1, 0x12e20614306d2303, 0xcce4ff32addcee9f,
  0x7a8efe6c17d9c0a2, 0x04508e489fc19953, 0xdc3e144312bfcfdf, 0xcaaeef77cdc80000, 0xad68a8432d08c910,
  0x096dca1ffd01cf09, 0xeff735e60b0de579, 0x1f6f9df2cf7ca0fe, 0xd1ee38e9fc1c1ff5, 0xe21398b01541e64a,
  0xecc11d78033b6948, 0x7967b698c64a807f, 0xc55f3bb8a92e04a0, 0x398a0ed7972ab59f, 0xfb39d454aa35dce3,
  0x8101395daa5beaa6, 0x434ae492fe910e6b, 0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021,
  0x9b6815156f62aa8b, 0x58df0dc79b09732f, 0x7ea75666fe0eee34, 0x4ffef0f7bca1854e, 0x687993fc0fe32fcc,
  0x7c68f45fe07efd86, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x000a49ef056e8b3c,
};

/*
 * m169a_swio13_dual_pr_ee           m169p_swio13_dual_pr_ee           m169pa_swio13_dual_pr_ee
 * m165_swio13_dual_pr_ee            m165a_swio13_dual_pr_ee           m165p_swio13_dual_pr_ee
 * m165pa_swio13_dual_pr_ee
 */
static const uint64_t ur_m169_swio13_dual_pr_ee[] = {
  0x00addddddd43573e, 0xc8f89dbf1a99366d, 0x5f47e6ea729c502c, 0x4f59198f6d9beec7, 0xf700faabc99bd701,
  0xe772e2fbb0af7aca, 0x4f8c0482d95de4f4, 0xda0644a4a43a7530, 0x1030a18369181bba, 0x3ff9956ee774f897,
  0xc9d6c12d1c02d4c6, 0x239227f0715a6f51, 0x8510c4aff3f7c114, 0xef77cdceeb00370f, 0x50865a0bed10caae,
  0x3b7ff4073c260f71, 0xaf30586f2bc84b6f, 0xd68dc9ca0f4fffb9, 0x071efd4795e9b9aa, 0x877c57b3bd47c1b3,
  0xc2cb1148b34eb422, 0xa9e5c54b9a426be8, 0x9767f11f5073ab4b, 0x47f258d56ba1d7a8, 0x65f4b3170908a0f5,
  0xe6f6a8d823f5b86f, 0xfc55f3bb8a928043, 0x3398a0ed7972ab59, 0x6fb39d454aa35dce, 0xb8101395daa5beaa,
  0xc434ae492fe910e6, 0x395aeb9ed5688af2, 0x10a905ca5af9d01e, 0xb490538c6f19d102, 0xf9b6815156f62aa8,
  0x8b1e70dc79b09732, 0x727eeaccdfc1ddc6, 0x7c09c6592e19e985, 0x57ee6866587494b6, 0x003214b1fdba2cf2,
};

/*
 * m169a_swio13_dual_pr_ee_u4        m169p_swio13_dual_pr_ee_u4        m169pa_swio13_dual_pr_ee_u4
 * m165_swio13_dual_pr_ee_u4         m165a_swio13_dual_pr_ee_u4        m165p_swio13_dual_pr_ee_u4
 * m165pa_swio13_dual_pr_ee_u4
 */
static const uint64_t ur_m169_swio13_dual_pr_ee_u4[] = {
  0xb7777768adbb3202, 0xe276fc6a64d9b402, 0xa339a9ca7140b323, 0x663db66fbb1d71f9, 0xeaaf266f5c053d64,
  0x41f5d717d35bdc03, 0x05b2bbc9e9cee1a7, 0x494874ea609f1809, 0x06d2303775b40c89, 0x6fcee9f12e206143,
  0xd1c02d4c63ff9969, 0x0715a6f51c9d6c12, 0xff3f7c114239227f, 0xeeb00370f8510c4a, 0xbed10caaeef77cdc,
  0x73c260f7150865a0, 0xf2bc84b6f3b7ff40, 0x83d3fff8fc330586, 0xe57a6e6ab5a37272, 0xef51f06cc1c7bf51,
  0x2cd3ad08a1df15ec, 0xe6909afa30b2c452, 0xd41cead2ea797152, 0x5ae875ea25d9fc47, 0xc242283d51fc9635,
  0x08fd6e1bd97d2cc5, 0xe2a4a010f9bdaa36, 0x5e5caad67f157cee, 0x52a8d7738ce6283b, 0x76a96faa9bece751,
  0x4bfa4439ae0404e5, 0xb55a22bcb10d2b92, 0x96be74078e56bae7, 0x1bc67440842a4172, 0x55bd8aaa2d2414e3,
  0x1e6c25ccbe6da054, 0xf6ec68b1be2e4d5c, 0x61539fa9d599bf83, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8,
  0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0x374f257ee6866587, 0x00000002b225b4f2,
};

/*
 * m169a_swio13_dual_pr_ce           m169p_swio13_dual_pr_ce           m169pa_swio13_dual_pr_ce
 * m165_swio13_dual_pr_ce            m165a_swio13_dual_pr_ce           m165p_swio13_dual_pr_ce
 * m165pa_swio13_dual_pr_ce
 */
static const uint64_t ur_m169_swio13_dual_pr_ce[] = {
  0x95bbbbbbd82432db, 0x3e276fcf1f5c4da2, 0xae17bb3890523bb8, 0x6e9776182ca3e9f7, 0xe908766c75f74a50,
  0x4c4bb8e08ab2c10c, 0x9827c602416caef2, 0xeeb68191292902a8, 0x25c40c2860da4606, 0x3757fe655bb9dd3e,
  0xd47d9db08e470383, 0x4508e489fc1cae9b, 0xc3e144312bfcfdf0, 0xabbbddf37011200d, 0x7c542196807b4432,
  0x6dffe7fd01cf0982, 0xf735e60b0de57909, 0x5f717d6034a093af, 0xfb892c79e50b839d, 0xfea3e12fc4361222,
  0x9733c5dc6e759b21, 0x45f51e449ee58cfa, 0x017f71951c74fe0c, 0x8033b6948e21398b, 0x8c64a807feccf1d7,
  0xe2a4b81281e5adc9, 0x5e5caad67f157cee, 0x52a8d7738ce6283b, 0x76a96faa9bece751, 0x4bfa4439ae0404e5,
  0xb55a22bcb10d2b92, 0x96be74078e56bae7, 0x1bc67440842a4172, 0x1dbd8aaa2d2414e3, 0x3cd84b997cdb40a3,
  0xbf83bb8d165abc6e, 0x8d2861539fa9d599, 0x4fc07cd0f327f813, 0x8138cb25c33d30ae, 0xfdcd0ccb0e9296cf,
  0x00d242b537459e4a,
};

/*
 * m169a_swio13_dual_pr_ce_u4        m169p_swio13_dual_pr_ce_u4        m169pa_swio13_dual_pr_ce_u4
 * m165_swio13_dual_pr_ce_u4         m165a_swio13_dual_pr_ce_u4        m165p_swio13_dual_pr_ce_u4
 * m165pa_swio13_dual_pr_ce_u4
 */
static const uint64_t ur_m169_swio13_dual_pr_ce_u4[] = {
  0x817bbbbbb4486f97, 0x3bc4edf9e3f3ecda, 0x3deef75053d68e3d, 0x0bc9d4cca76f5d84, 0x2d4e900d57efdeec,
  0xef25a2bb9e08ce9c, 0x2319827c602416ca, 0xc0ddd6d032252522, 0xa7c4b881850c1b48, 0xd373456fccab773b,
  0x39bd47cadb0df670, 0xdf04508e489fc194, 0x00dc3e144312bfcf, 0x21955ddeef9b8c86, 0x269c62a10cb4027a,
  0xc84b6e337ff4073c, 0xe0ffb9af30586f2b, 0x073025c5f532a504, 0x2445f71258f3ca17, 0x8b91fd47c25f886c,
  0x19e1c6678bb8dc4a, 0xfc1935ea3ce33dcb, 0x398b014ca9ba38e9, 0x78ebc8b765ae8e32, 0xb8a928ead6dc72c6,
  0xd7972ab59fc55f3b, 0x54aa35dce3398a0e, 0x5daa5beaa6fb39d4, 0x92fe910e6b810139, 0xed5688af2c434ae4,
  0x594d8b3a03cfd6b9, 0x3182169ab9d5ea58, 0x6d38c6f19d10273e, 0x1be1b8f3612e65f3, 0xd4eaccdfc1ddc68b,
  0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3,
  0x003490216dd16792,
};

/*
 * m169a_swio13_dual_pr_ee_ce        m169p_swio13_dual_pr_ee_ce        m169pa_swio13_dual_pr_ee_ce
 * m165_swio13_dual_pr_ee_ce         m165a_swio13_dual_pr_ee_ce        m165p_swio13_dual_pr_ee_ce
 * m165pa_swio13_dual_pr_ee_ce
 */
static const uint64_t ur_m169_swio13_dual_pr_ee_ce[] = {
  0x5b2b77777750cf68, 0xeb789dbf1888ce1b, 0xda57bddcfb67d619, 0x2be37410f225c2c2, 0x7f9b4d9b537c9765,
  0x3b9a3ea74704dd9c, 0x7c602416caef2727, 0xa0644a4a411eb982, 0x030a18369181bbad, 0x9f9956ee774f8971,
  0xff3601a0e1a6a67f, 0x39227f07d3f37a8f, 0x510c4aff3f7c1142, 0xeef9b830b80370f8, 0x10cb40e1a21955dd,
  0xbbfe80e784ce4e2a, 0xe60b0de579096df1, 0x51b059419dbff735, 0xf9e50b8393b677fd, 0x66139dc6e0224c03,
  0x8f2b53d29dacac88, 0x027a8f83660c27fa, 0x91669d68450298af, 0x51d484d7d1859622, 0x63291ce273abb717,
  0x5ec6abc6c75ed627, 0x7c62e121144be46b, 0x4b8c47c32386f65c, 0xcaad67f157ceee2a, 0x8d7738ce6283b5e5,
  0x96faa9bece75152a, 0xa4439ae0404e576a, 0xa22bcb10d2b924bf, 0xe74078e56bae7b55, 0x67440842a417296b,
  0xd8aaa2d2414e31bc, 0x84b997cdb40a31db, 0x0eee3458f386e3cd, 0xcf4c2b93f75666fe, 0xa4a5b3e04e32c970,
  0xd16792bf734332c3, 0x000000002608a9cd,
};

/*
 * m169a_swio13_dual_pr_ee_ce_u4     m169p_swio13_dual_pr_ee_ce_u4     m169pa_swio13_dual_pr_ee_ce_u4
 * m165_swio13_dual_pr_ee_ce_u4      m165a_swio13_dual_pr_ee_ce_u4     m165p_swio13_dual_pr_ee_ce_u4
 * m165pa_swio13_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio13_dual_pr_ee_ce_u4[] = {
  0xeeeeeed15b77d8be, 0x276fccc54626d6fd, 0x9afbdda8f84339de, 0x6af2657bc89ada6f, 0x437713b7eec5e715,
  0x3ebeca9c7829649b, 0xbbc96c4eea0d599a, 0x7aa2609f180905b2, 0x606eeb6819129291, 0xd3e25c40c2860da4,
  0xc39b96bf32d2df9d, 0x6f51f1bb61d8270b, 0x822847244fe0daee, 0x6e1f0a21895fe7ef, 0x2abbbddf37138f00,
  0x7dc5421968472443, 0x2db9257fd01cf09b, 0xfe3f0cc161bcaf21, 0x717d51f57ca0cc37, 0xc4963cf285e7730d,
  0x51f097e21b09117d, 0x9e2ee37138fee3ff, 0x95efb94ed6e6e6e9, 0x5ea3e0d98332bd47, 0x59a75a1140a62bb7,
  0x752135f4616588a4, 0xfc47d41ceaedca78, 0x2c6abc6c75ea25d9, 0x598b8484507aa3f9, 0xaa3608991c37b2fa,
  0x7ceee2a4a598f9bd, 0x283b5e5caad67f15, 0xe75152a8d7738ce6, 0x04e576a96faa9bec, 0x2b924bfa4439ae04,
  0xbae7b55a22bcb10d, 0x417296be74078e56, 0x14e31bc67440842a, 0x40a31dbd8aaa2d24, 0x9ab83cd84b997cdb,
  0x7f07edd8d1637c5c, 0xde50c2a73f53ab33, 0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f,
  0xcb0e9296cf8138cb, 0x17e46e9e4afdcd0c, 0x0000000000100010,
};

/*
 * m169a_swio13_dual_hw              m169p_swio13_dual_hw              m169pa_swio13_dual_hw
 * m165_swio13_dual_hw               m165a_swio13_dual_hw              m165p_swio13_dual_hw
 * m165pa_swio13_dual_hw
 */
static const uint64_t ur_m169_swio13_dual_hw[] = {
  0x4f777776890d365a, 0xfc4edf8ebc219b5f, 0x73ef7519cbba16d2, 0x3f8bf92a4c9c4ecb, 0x7b2c51a9b16efd32,
  0x792b43bb227af7a5, 0xa1cc13e30120b657, 0x03775b40c894948b, 0x9f12e20614306d23, 0xa2cce4ff32addcee,
  0x537a8efe6c17d9c0, 0xdf04508e489fc199, 0x00dc3e144312bfcf, 0x10caaeef77cdc800, 0x09ad68a8432d08c9,
  0x79096dca1ffd01cf, 0xfddffea4660b0de5, 0xea3edf3be59ef941, 0x95a3dc71d3f8383f, 0x91c42731602a83cc,
  0xffd9823af00676d2, 0x40f2cf6d318c9500, 0x3f8abe7771525c09, 0xc673141daf2e556b, 0x4df673a8a9546bb9,
  0xd7020272bb54b7d5, 0x588695c925fd221c, 0xc72b5d73daad115e, 0x421520b94b5f3a03, 0x16920a718de33a20,
  0x5f36d02a2adec555, 0x7ea0bb1b8f3612e6, 0x4ffef0f7bca1854e, 0x687993fc0fe32fcc, 0x7c68f45fe07efd86,
  0x9f0271964b867a61, 0x95fb9a19961d252d, 0x00006375de0b453c,
};

/*
 * m169a_swio13_dual_ee_hw           m169p_swio13_dual_ee_hw           m169pa_swio13_dual_ee_hw
 * m165_swio13_dual_ee_hw            m165a_swio13_dual_ee_hw           m165p_swio13_dual_ee_hw
 * m165pa_swio13_dual_ee_hw
 */
static const uint64_t ur_m169_swio13_dual_ee_hw[] = {
  0x056eeeee87ad0c86, 0x47c4edf8d4c9b368, 0xfa3f375394e28166, 0x7ac8cc7b6cdf763a, 0xb807d55e4cdeb80a,
  0xe9ceeeec6ecde62f, 0x609f180905b2bbc9, 0x75b40c89494874ea, 0x2e20614306d23037, 0x8c7ff32addcee9f1,
  0xa393ad825a3805a9, 0x2847244fe0e2b4de, 0x1f0a21895fe7ef82, 0x5ddeef9b9dd6006e, 0xe2a10cb417da2195,
  0xde76ffe80e784c1e, 0xea4660b0de579096, 0xab5a3727283d3fff, 0xcc1c7bf51e57a6e6, 0x8a1df15ecef51f06,
  0xa30b2c4522cd3ad0, 0x2ea797152e6909af, 0xa25d9fc47d41cead, 0xd51fc96355ae875e, 0xbd97d2cc5c242283,
  0x0f9bdaa3608fd6e1, 0x67f157ceee2a4a01, 0x38ce6283b5e5caad, 0xa9bece75152a8d77, 0x9ae0404e576a96fa,
  0xcb10d2b924bfa443, 0x78e56bae7b55a22b, 0x0842a417296be740, 0xa2d2414e31bc6744, 0xcbe6da05455bd8aa,
  0x7ea5eae371e6c25c, 0x9c65f989fca1854e, 0xcf7ff04d0f327f8b, 0x32c970cf4c2b93f1, 0x4332c3a4a5b3e04e,
  0x5dab1fe8a792bf73, 0x0000000000000001,
};

/*
 * m169a_swio13_dual_ce_hw           m169p_swio13_dual_ce_hw           m169pa_swio13_dual_ce_hw
 * m165_swio13_dual_ce_hw            m165a_swio13_dual_ce_hw           m165p_swio13_dual_ce_hw
 * m165pa_swio13_dual_ce_hw
 */
static const uint64_t ur_m169_swio13_dual_ce_hw[] = {
  0x452b777776890c86, 0x707c4edf9e3eb89b, 0xef5c2f767120a477, 0xa0dd2eec305947d3, 0xe62a10ecd8ebee94,
  0xbbc9312eeeec6ecd, 0x0aa2609f180905b2, 0x181bbada0644a4a4, 0x74f8971030a18369, 0x0e0cdd5ff9956ee7,
  0xba6f51f676c2391c, 0xf7c114239227f072, 0x80370f8510c4aff3, 0x10caaeef77cdc044, 0x2609f150865a01ed,
  0xe425b7ff9ff4073c, 0x9d7ffa91982c3795, 0x1ceafb8beb01a504, 0x9117dc4963cf285c, 0x492bf51f097e21b0,
  0x67d4b99e2ee372e4, 0xf0622fa8f224f72c, 0xcc580bfb8ca8e3a7, 0x8ebc019db4a47109, 0x6e4c6325403ff667,
  0xe7771525c0940f2d, 0x41daf2e556b3f8ab, 0x3a8a9546bb9c6731, 0x272bb54b7d54df67, 0x5c925fd221cd7020,
  0xd73daad115e58869, 0x0b94b5f3a03c72b5, 0xa718de33a2042152, 0x0518edec55516920, 0x6371e6c25ccbe6da,
  0x1ef79430a9cfd417, 0x7f81fc65f989ffde, 0x8bfc0fdfb0cd0f32, 0x32c970cf4c2f8d1e, 0x4332c3a4a5b3e04e,
  0x9ba95aa8a792bf73, 0x0000000000000000,
};

/*
 * m169a_swio13_dual_ee_ce_hw        m169p_swio13_dual_ee_ce_hw        m169pa_swio13_dual_ee_ce_hw
 * m165_swio13_dual_ee_ce_hw         m165a_swio13_dual_ee_ce_hw        m165p_swio13_dual_ee_ce_hw
 * m165pa_swio13_dual_ee_ce_hw
 */
static const uint64_t ur_m169_swio13_dual_ee_ce_hw[] = {
  0x821eeeeeeea1a5fb, 0xc5e276fc623c7f36, 0xd721eed17d8b9da6, 0x63d62c57d769eaef, 0xfabe1f29be4a10d2,
  0xbba591aeba55857b, 0x7c602416caef2599, 0x40c8949483d9e982, 0x0614306d2303775b, 0xff32addcee9f12e2,
  0x9ad83fc3862099ae, 0x7244fe0ffe4dea3e, 0xa21895fe7ef82284, 0xeef9b8164006e1f0, 0x10cb4182a21955dd,
  0x0ffe80e784d21e2a, 0x660b0de579096def, 0xa395d2835bfffea4, 0xf3ca17072b7ceffa, 0xa6139dc6e747d493,
  0x8f2bdf729dacac9b, 0x6ebd47c1b306657a, 0x48b34eb422814c57, 0xf0ea426be8c2cb11, 0xb3f88fa839d5db94,
  0xf258d578d8ebd44b, 0xf4b3170908a0f547, 0x7b546c1132386f65, 0x2af9ddc5494b31f3, 0xcc5076bcb955acfe,
  0xd9cea2a551aee719, 0x0809caed52df5537, 0x1a572497f488735c, 0xad75cf6ab4457962, 0x5482e52d7ce80f1c,
  0x4829c6378ce88108, 0xb681463b7b15545a, 0x3fb0dc79b09732f9, 0xe32c970cf4c2b93f, 0x34332c3a4a5b3e04,
  0x22698e2e8a792bf7,
};

/*
 * m169a_swio13_dual_ee_ce_u4_hw     m169p_swio13_dual_ee_ce_u4_hw     m169pa_swio13_dual_ee_ce_u4_hw
 * m165_swio13_dual_ee_ce_u4_hw      m165a_swio13_dual_ee_ce_u4_hw     m165p_swio13_dual_ee_ce_u4_hw
 * m165pa_swio13_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio13_dual_ee_ce_u4_hw[] = {
  0xdeeeeeed14682541, 0xe276fccc54626d6f, 0xb69bbdda8f84339d, 0x9c55abc995ef2276, 0x926d0ddc4edfbb17,
  0x4e30cb5bb4f9e0a5, 0x0482d95de4b62775, 0x894948bd51304f8c, 0x4306d2303775b40c, 0x2ec24ee9f12e2061,
  0x1d8270bc39b96bf3, 0xfe0daee6f51f1bb6, 0x95fe7ef822847244, 0x7138f006e1f0a218, 0x84724432abbbddf3,
  0x01cf09b7dc542196, 0x1bcaf212db9257fd, 0x941986ff67a1cc16, 0x307261ae2faa3eaf, 0x1222fb892c79e37c,
  0xf1f77ea3e12fc436, 0xcdcdd33c5dc6e70f, 0x657a8f2bdf729dad, 0x4c576ebd47c1b306, 0xcb1148b34eb42281,
  0xdb94f0ea426be8c2, 0xd44bb3f88fa839d5, 0xf547f258d578d8eb, 0x6f65f4b3170908a0, 0x31f37b546c113238,
  0xacfe2af9ddc5494b, 0xe719cc5076bcb955, 0x5537d9cea2a551ae, 0x735c0809caed52df, 0x79621a572497f488,
  0x0f1cad75cf6ab445, 0x81085482e52d7ce8, 0x545a4829c6378ce8, 0x32f9b681463b7b15, 0x73f505d8dc79b097,
  0x627ff787bde50c2a, 0x3343cc9fe07f197e, 0x0be347a2ff03f7ec, 0x6cf8138cb25c33d3, 0xe4afdcd0ccb0e929,
  0x00003aeb346e0be9,
};

/*
 * m169a_swio14_noled                m169p_swio14_noled                m169pa_swio14_noled
 * m165_swio14_noled                 m165a_swio14_noled                m165p_swio14_noled
 * m165pa_swio14_noled
 */
static const uint64_t ur_m169_swio14_noled[] = {
  0x889bbbbbbacdc49f, 0x3d6eed55c8a50912, 0x9d80374d06e24611, 0x105fd0ee38f522f8, 0x0d5a099fa5f17bb1,
  0x0905b2bbc9ddcc49, 0xefd0f3f1ee609f18, 0x989df2dd04a0f75f, 0xf91c74fe0ebffa8e, 0x9e398b016f74c800,
  0xb1823af173b7488c, 0xbcb955a95821f71c, 0xa551aee719cc5076, 0x372bb54b7d59cea2, 0xd2b63f7f4887359d,
  0xf5ae7b55a22bcb10, 0x53a9c0594a9f4ef3, 0x047978a042d2c2e7, 0xccbe6da718de33a2, 0x30ae4fcfec376c25,
  0x6cb25138cb25c33d, 0xe4afdcd0ccb0e929, 0x0000002a4b76b8f9,
};

/*
 * m169_swio14_noled_pr_u4           m169a_swio14_noled_pr             m169a_swio14_noled_pr_u4
 * m169p_swio14_noled_pr             m169p_swio14_noled_pr_u4          m169pa_swio14_noled_pr
 * m169pa_swio14_noled_pr_u4         m165_swio14_noled_pr              m165_swio14_noled_pr_u4
 * m165a_swio14_noled_pr             m165a_swio14_noled_pr_u4          m165p_swio14_noled_pr
 * m165p_swio14_noled_pr_u4          m165pa_swio14_noled_pr            m165pa_swio14_noled_pr_u4
 */
static const uint64_t ur_m169_swio14_noled_pr[] = {
  0xc7bbbbbb4488af02, 0x0bbb55722950e251, 0x7b64f5fb1a0b609e, 0x59ac1c436c66cf7a, 0x982fcc6b4dd8e3d0,
  0x5de4eec718178bd9, 0xf31f304f8c0482d9, 0x6dee5076fff9e059, 0x3f8326bd47050ef9, 0x80b2ca60f680471d,
  0xe8f9d93146229cc5, 0xac4f2a01ffb30475, 0xcaad508981e59edd, 0x8d7738ce6283b5e5, 0x5daa5beace75152a,
  0xb1fbfa4439ace9b9, 0x73daad115e588695, 0x36294f0d3bcf8b5d, 0x89c6378ce8810775, 0x843156f62aa8b4b6,
  0x6ae0f3612e65f36d, 0x3c81f943458df172, 0x7bca1854e7ea7566, 0xc0fe32fcc4ffef0f, 0xfe07efd86687993f,
  0x64b867a617c68f45, 0x9961d252d9f02719, 0xb82c4053c95fb9a1, 0x0000000000007c9a,
};

/*
 * m169a_swio14_noled_pr_ee          m169p_swio14_noled_pr_ee          m169pa_swio14_noled_pr_ee
 * m165_swio14_noled_pr_ee           m165a_swio14_noled_pr_ee          m165p_swio14_noled_pr_ee
 * m165pa_swio14_noled_pr_ee
 */
static const uint64_t ur_m169_swio14_noled_pr_ee[] = {
  0x7dddddd0f5a22582, 0x6eed55f85c20890d, 0x9da67b50c99f3732, 0xb4368650b8678518, 0x3f644d8106d0435e,
  0xc9dd3b410d1996a2, 0x06609f180905b2bb, 0x7ca0eceff3c0b3e7, 0xd47959759aad68cc, 0xb297ea3e0d983ea3,
  0x8a459a75a1143be2, 0x8d64d2135f461658, 0xaa3f90e75697726b, 0xb1aad743af3a6ec7, 0xe62e121144428f7b,
  0xa8d823f5b86f65b2, 0x6bcb955a805d073c, 0x2a551aee719cc507, 0xd372bb54b7d59cea, 0x0d2b63f7f4887359,
  0x16bae7b55a22bcb1, 0x0eea6c529e1a779f, 0x696d138c6f19d102, 0xe6db0862adec5551, 0xe2e4d5c1e6c25ccb,
  0x5663c81f943459d3, 0xf989fca1854e7ea7, 0xf04d0f327f8b9c65, 0x70cf4c2b93f1cf7f, 0xc3a4a5b3e04e32c9,
  0xa880a792bf734332, 0x000000000004ebc0,
};

/*
 * m169a_swio14_noled_pr_ee_u4       m169p_swio14_noled_pr_ee_u4       m169pa_swio14_noled_pr_ee_u4
 * m165_swio14_noled_pr_ee_u4        m165a_swio14_noled_pr_ee_u4       m165p_swio14_noled_pr_ee_u4
 * m165pa_swio14_noled_pr_ee_u4
 */
static const uint64_t ur_m169_swio14_noled_pr_ee_u4[] = {
  0x426eeeeed1222a20, 0xda776aafc2e34e25, 0x47f4d2eedb75fe24, 0xf2299c7cfd833c76, 0x103d724041b41508,
  0x793ba3d8b54718d4, 0x674c13e30120b657, 0xdf94195dfe78167f, 0xfa8f2bf9d355ad1e, 0x56e97d47c1b30738,
  0x1148b34eb422877c, 0xe2899a426be8c2cb, 0xf91ad739d5a5d7da, 0x8d56ba1d7aea6ed2, 0x3170908a07c47d25,
  0xb8e83eb70decb872, 0xc673141daf2e556a, 0xdf5673a8a9546bb9, 0xd221cd674dcaed52, 0x688af2c434ad8fdf,
  0x7869de7c5aeb9ed5, 0xbc6744083ba9b14a, 0xb7b15545a5b44e31, 0x9b09732f9b6c218a, 0xca1a2c6f8b935707,
  0xc2a73f53ab31e40f, 0x97e627ff787bde50, 0x7ec3343cc9fe07f1, 0x3d30be347a2ff03f, 0x9296cf8138cb25c3,
  0x029e4afdcd0ccb0e, 0x000000004eba6822,
};

/*
 * m169_swio14_noled_pr_ce_u4        m169a_swio14_noled_pr_ce          m169a_swio14_noled_pr_ce_u4
 * m169p_swio14_noled_pr_ce          m169p_swio14_noled_pr_ce_u4       m169pa_swio14_noled_pr_ce
 * m169pa_swio14_noled_pr_ce_u4      m165_swio14_noled_pr_ce           m165_swio14_noled_pr_ce_u4
 * m165a_swio14_noled_pr_ce          m165a_swio14_noled_pr_ce_u4       m165p_swio14_noled_pr_ce
 * m165p_swio14_noled_pr_ce_u4       m165pa_swio14_noled_pr_ce         m165pa_swio14_noled_pr_ce_u4
 */
static const uint64_t ur_m169_swio14_noled_pr_ce[] = {
  0xf26eeeeed1222582, 0xfc776aaf088d2e24, 0xd1748fe933e3ec1e, 0xcff5e35cdd95b6a6, 0x2d541685e15baf26,
  0x657793ba76821cbb, 0x67f4dcc13e30120b, 0x7d7ba941cadfe781, 0x4b1e78c953b95d71, 0xf84bf10d8488bee2,
  0xf1771b8c87495fa8, 0x51d7c9ee58cfd64c, 0xbf2fa38e9fc1acff, 0xec98a3114e62c05d, 0x9500ffd99e3af47c,
  0xaa11303cb5bad627, 0xe719cc5076bcb955, 0x4b7d59cea2a551ae, 0x7f4887359d372bb5, 0x55a22bcb10d2b63f,
  0x29e1a779f16bae7b, 0xc6f19d1020eea6c5, 0x8edec5551696d138, 0x3cd84b997cdb6109, 0x7e50d1637c5c9ab8,
  0x861539fa9d598f20, 0x8cbf313ffbc3def2, 0xfbf619a1e64ff03f, 0x19e985f1a3d17f81, 0x7494b67c09c6592e,
  0x1014f257ee686658, 0x0000000006eba45f,
};

/*
 * m169a_swio14_noled_pr_ee_ce       m169p_swio14_noled_pr_ee_ce       m169pa_swio14_noled_pr_ee_ce
 * m165_swio14_noled_pr_ee_ce        m165a_swio14_noled_pr_ee_ce       m165p_swio14_noled_pr_ee_ce
 * m165pa_swio14_noled_pr_ee_ce
 */
static const uint64_t ur_m169_swio14_noled_pr_ee_ce[] = {
  0xb31ddddddd446f43, 0xc45ddaabd853a744, 0x9a3bd89dab43d318, 0x1f1f5a63bf23f4c6, 0x506e38d45832d5b3,
  0x7793bad3bed3b2d9, 0xa6dcc13e30120b65, 0x5d650466ffcf02cf, 0xc64a9d8cd9dff546, 0x139dc6e339747ff3,
  0x2b90f29dacac7be6, 0xfd47c1b307a57a8f, 0xb34eb422814c5670, 0xea426be8c2cb1148, 0xea8fe439d5db9c98,
  0xd8d578d8ebce9bb1, 0x73170908a22147bd, 0x2a3608991c37b2d9, 0xdaf2e556a59f41cf, 0x8a9546bb9c673141,
  0x74dcaed52df5673a, 0x434ad8fdfd221cd6, 0xc5aeb9ed5688af2c, 0x83ba9b14a7869de7, 0x5a5b44e31bc67440,
  0xf36d84263b7b1554, 0x1e71726ae3612e65, 0x7eeacc7903f2868b, 0x89c6592e19e98572, 0xe6866587494b6592,
  0xa698bf71014f257e,
};

/*
 * m169a_swio14_noled_pr_ee_ce_u4    m169p_swio14_noled_pr_ee_ce_u4    m169pa_swio14_noled_pr_ee_ce_u4
 * m165_swio14_noled_pr_ee_ce_u4     m165a_swio14_noled_pr_ee_ce_u4    m165p_swio14_noled_pr_ee_ce_u4
 * m165pa_swio14_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio14_noled_pr_ee_ce_u4[] = {
  0x90dddddda243306a, 0x62eed55fd4cc8c48, 0x1ebb2dd6960cc17e, 0x86150015b47706d7, 0x21ba05f250b2d9e4,
  0xde4eed57e4c3ac84, 0x149304f8c0482d95, 0x9b941adfffb15d9f, 0x50b8395bf717d51e, 0x4361222fb892c79e,
  0x1dbb0b27ea3e12fc, 0xed6e6def99e2ee37, 0x983d2bd4795c8794, 0x140a62b387ea3e0d, 0x4616588a459a75a1,
  0xceaedce4c752135f, 0xc75e74dd8f547f21, 0x45110a3deec6abc6, 0xc8e1bd96cb98b848, 0xb52cfa0e7951b044,
  0xdce3398a0ed7972a, 0xa96fab39d454aa35, 0xefe910e6b3a6e576, 0x6ab44579621a56c7, 0xa53c34ef3e2d75cf,
  0x18de33a2041dd4d8, 0x31dbd8aaa2d2da27, 0xc79b09732f9b6c21, 0x66fe0eee3458df0d, 0xf7bca1854e7ea756,
  0xfc0fe32fcc4ffef0, 0x5fe07efd86687993, 0x964b867a617c68f4, 0x19961d252d9f0271, 0x0f576e8b3c95fb9a,
  0x000000000000027e,
};

/*
 * m169a_swio14_noled_hw             m169p_swio14_noled_hw             m169pa_swio14_noled_hw
 * m165_swio14_noled_hw              m165a_swio14_noled_hw             m165p_swio14_noled_hw
 * m165pa_swio14_noled_hw
 */
static const uint64_t ur_m169_swio14_noled_hw[] = {
  0x889bbbbbbacdc49f, 0x3d6eed55c8a50912, 0x9d80374d06e24611, 0x105fd0ee38f522f8, 0x0d5a099fa5f17bb1,
  0x0905b2bbc9ddcc49, 0xfc38f3f1ee609f18, 0x4c4ef96e82507baf, 0x7c8e3a7f075ffd47, 0x4f1cc580b7ba6400,
  0x58c11d78b9dba446, 0x5e5caad4ac10fb8e, 0x52a8d7738ce6283b, 0x9b95daa5beace751, 0x695b1fbfa4439ace,
  0xfad73daad115e588, 0xa9d4e02ca54fa779, 0x023cbc5021696173, 0xe65f36d38c6f19d1, 0x985727e7f61bb612,
  0xb659289c6592e19e, 0xf257ee6866587494, 0x00000011c56eec14,
};

/*
 * m169a_swio14_noled_ee_hw          m169p_swio14_noled_ee_hw          m169pa_swio14_noled_ee_hw
 * m165_swio14_noled_ee_hw           m165a_swio14_noled_ee_hw          m165p_swio14_noled_ee_hw
 * m165pa_swio14_noled_ee_hw
 */
static const uint64_t ur_m169_swio14_noled_ee_hw[] = {
  0x6beeeeeed121b705, 0x93776aafc2e10448, 0x56989dda864cf9b9, 0x35eb4368650b8678, 0x4c23f644d8106d04,
  0xb657793bb61b656a, 0xa67ce0cc13e30120, 0x6b4663e507677fd0, 0xc1f51ea3cacbacd5, 0xa1df1594bf51f06c,
  0x30b2c4522cd3ad08, 0xbb935c6b26909afa, 0xd3763d51fc873ab4, 0x147bdd8d56ba1d79, 0x7b2d973170908a22,
  0xe839e546c11fadc3, 0xe6283b5e5caad402, 0xace75152a8d7738c, 0x439ace9b95daa5be, 0x15e588695b1fbfa4,
  0xd3bcf8b5d73daad1, 0xce881077536294f0, 0x62aa8b4b689c6378, 0x12e65f36d843156f, 0x854e7ea0bb1b8f36,
  0x2fcc4ffef0f7bca1, 0xfd86687993fc0fe3, 0x7a617c68f45fe07e, 0x252d9f0271964b86, 0x453c95fb9a19961d,
  0x0000000005bff9a7,
};

/*
 * m169a_swio14_noled_ce_hw          m169p_swio14_noled_ce_hw          m169pa_swio14_noled_ce_hw
 * m165_swio14_noled_ce_hw           m165a_swio14_noled_ce_hw          m165p_swio14_noled_ce_hw
 * m165pa_swio14_noled_ce_hw
 */
static const uint64_t ur_m169_swio14_noled_ce_hw[] = {
  0xf26eeeeed12198e2, 0xfc776aaf088d2e24, 0x4f5a2ee933e3ec1e, 0x4d9febc6b9bb2b6d, 0xda75a82d0bc2b75e,
  0x482d95de4ee94e1e, 0xf4299fd37304f8c0, 0x5d717d7ba941cadf, 0x7dc4963cf285c1c9, 0xff51f097e21b0911,
  0xac99e2ee373b06f0, 0x59fea3af93dcb19f, 0x80bb7e5f471d3f83, 0xe8f9d93146229cc5, 0xac4f2a01ffb33c75,
  0x72ab542260796b75, 0xa35dce3398a0ed79, 0x576a96fab39d454a, 0x6c7efe910e6b3a6e, 0x5cf6ab44579621a5,
  0x4d8a53c34ef3e2d7, 0xa2718de33a2041dd, 0xc2131dbd8aaa2d2d, 0xd8dc79b09732f9b6, 0x87bde50c2a73f505,
  0x9fe07f197e627ff7, 0xa2ff03f7ec3343cc, 0x8cb25c33d30be347, 0xd0ccb0e9296cf813, 0x59b27e1a29e4afdc,
  0x0000000000000007,
};

/*
 * m169_swio14_noled_ee_ce_u4_hw     m169a_swio14_noled_ee_ce_hw       m169a_swio14_noled_ee_ce_u4_hw
 * m169p_swio14_noled_ee_ce_hw       m169p_swio14_noled_ee_ce_u4_hw    m169pa_swio14_noled_ee_ce_hw
 * m169pa_swio14_noled_ee_ce_u4_hw   m165_swio14_noled_ee_ce_hw        m165_swio14_noled_ee_ce_u4_hw
 * m165a_swio14_noled_ee_ce_hw       m165a_swio14_noled_ee_ce_u4_hw    m165p_swio14_noled_ee_ce_hw
 * m165p_swio14_noled_ee_ce_u4_hw    m165pa_swio14_noled_ee_ce_hw      m165pa_swio14_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio14_noled_ee_ce_hw[] = {
  0x486eeeeed1219f68, 0x31776aafea664624, 0x8f5d96eb4b0660bf, 0x430a800ada3b836b, 0x60dd02f928596cf2,
  0x657793ba55e89fa1, 0x67c524c13e30120b, 0xa8f4dca0d6fffd0a, 0x3cf285c1cadfb8be, 0x97e21b09117dc496,
  0xe370dbb0a47f51f0, 0x794ed6e6def99e2e, 0xe0d983d2bd4795c8, 0x5a1140a62b387ea3, 0x35f4616588a459a7,
  0xf21ceaedce4c7521, 0xbc6c75e74dd8f547, 0x84845110a3deec6a, 0x044c8e1bd96cb98b, 0x72ab52cfa0e7951b,
  0xa35dce3398a0ed79, 0x576a96fab39d454a, 0x6c7efe910e6b3a6e, 0x5cf6ab44579621a5, 0x4d8a53c34ef3e2d7,
  0xa2718de33a2041dd, 0xc2131dbd8aaa2d2d, 0xd8dc79b09732f9b6, 0x87bde50c2a73f505, 0x9fe07f197e627ff7,
  0xa2ff03f7ec3343cc, 0x8cb25c33d30be347, 0xd0ccb0e9296cf813, 0x5010f57a29e4afdc,
};

/*
 * m169a_swio14_lednop               m169p_swio14_lednop               m169pa_swio14_lednop
 * m165_swio14_lednop                m165a_swio14_lednop               m165p_swio14_lednop
 * m165pa_swio14_lednop
 */
static const uint64_t ur_m169_swio14_lednop[] = {
  0x511377777759bb37, 0x27adddaab914ad22, 0xdfbe3f770f8da0c2, 0x1105fd0ee38f684d, 0xc869b1006dbe3fbb,
  0x80905b2bbc9ddb1e, 0xfefd0f3f01a609f1, 0xf243be5ba09410f7, 0x4c638e9fc1d7ff51, 0xf48731602dee9ba8,
  0x9630475e2e761151, 0xd7972ab52b305ee3, 0x54aa35dce3398a0e, 0xa6e576a96fab39d4, 0x2fb1e910e6b81013,
  0xcf6ab44579621a57, 0xc2ca6c59d01e7eb5, 0xfa2810b4d5ceaf52, 0xcdb4e31bc67440a2, 0xc9f9fd86ed84b997,
  0x4a271964b867a615, 0xfb9a19961d252d96, 0x000a93ebd71f3c95,
};

/*
 * m169_swio14_lednop_pr_u4          m169a_swio14_lednop_pr            m169a_swio14_lednop_pr_u4
 * m169p_swio14_lednop_pr            m169p_swio14_lednop_pr_u4         m169pa_swio14_lednop_pr
 * m169pa_swio14_lednop_pr_u4        m165_swio14_lednop_pr             m165_swio14_lednop_pr_u4
 * m165a_swio14_lednop_pr            m165a_swio14_lednop_pr_u4         m165p_swio14_lednop_pr
 * m165p_swio14_lednop_pr_u4         m165pa_swio14_lednop_pr           m165pa_swio14_lednop_pr_u4
 */
static const uint64_t ur_m169_swio14_lednop_pr[] = {
  0x8f7777768911fc3b, 0x1776aae45217c4a3, 0x56921b7e61f6c13c, 0xb35838aa18db2f78, 0xb1dd8f75fbb1c7a0,
  0xef2776e09ba86653, 0xafb9827c602416ca, 0x6f72831effcf02cf, 0xfc1935ea3a0077cb, 0x02cb299fcea238e9,
  0x47ced92231be7316, 0xfe91500ffd9823af, 0xaad65da81e59edc1, 0xd7738ce6283b5e5c, 0xdaa5beace75152a8,
  0xa4439ae0404e9b95, 0xd115e588695cbec7, 0xf3a03c72b5d73daa, 0x33a20421520b94b5, 0xec55516920a718de,
  0x612e65f36d8c62ad, 0x43458df1726ae0f3, 0x54e7ea75663c81f9, 0xfcc4ffef0f7bca18, 0xd86687993fc0fe32,
  0xa617c68f45fe07ef, 0x52d9f0271964b867, 0x53c95fb9a19961d2, 0x000000f93390fc40,
};

/*
 * m169a_swio14_lednop_pr_ee         m169p_swio14_lednop_pr_ee         m169pa_swio14_lednop_pr_ee
 * m165_swio14_lednop_pr_ee          m165a_swio14_lednop_pr_ee         m165p_swio14_lednop_pr_ee
 * m165pa_swio14_lednop_pr_ee
 */
static const uint64_t ur_m169_swio14_lednop_pr_ee[] = {
  0xafbbbbba1eb44511, 0x9bbb557e1768b121, 0x4bab077311b7cdcc, 0xeb4368604142d04e, 0xf4cd2e2f106d0435,
  0x793baaf99f64e2c5, 0x2d4c13e30120b657, 0x8f9411adfe78167d, 0x7a8f2b60b355ad19, 0x56a7bd47c1b307d4,
  0x1148b34eb422877c, 0x71ac9a426be8c2cb, 0x4447371cead2ee95, 0x56355ae875e74dda, 0x5cc5c242285f11c6,
  0x951b047eb70decb6, 0xed7972ab500ad627, 0x454aa35dce3398a0, 0x3a6e576a96fab39d, 0x72fb1e910e6b8101,
  0x5cf6ab44579621a5, 0x2e52d7ce80f1cad7, 0x9c6378ce88108548, 0x318ab7b15545a482, 0xab83cd84b997cdb6,
  0x903f2868b3a7c5c9, 0xf9430a9cfd4eacc7, 0x1e64ff1738cbf313, 0x985727e39effe09a, 0x4b67c09c6592e19e,
  0x4f257ee686658749, 0x0000000275cc9101,
};

/*
 * m169a_swio14_lednop_pr_ee_u4      m169p_swio14_lednop_pr_ee_u4      m169pa_swio14_lednop_pr_ee_u4
 * m165_swio14_lednop_pr_ee_u4       m165a_swio14_lednop_pr_ee_u4      m165p_swio14_lednop_pr_ee_u4
 * m165pa_swio14_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_swio14_lednop_pr_ee_u4[] = {
  0x426eeeeed1222582, 0xda776aafc2e56e25, 0x68ba47f600f4be24, 0x847914ce3fa82593, 0xaa82d0bc5e20da0a,
  0xaef2774ed0439765, 0xfa5a9827c602416c, 0x3dbf28235bfcf02c, 0x71f51e5721e6ab5a, 0xf8aff77a8f83660e,
  0x962291669d68450e, 0x65c5133484d7d185, 0x6c911a6273ab4bc0, 0x5ac6ab5d0ebd7537, 0x723170908a20fa3b,
  0xd57182feb70decb8, 0x738ce6283b5e5caa, 0xa5beace75152a8d7, 0x439ae0404e9b95da, 0x15e588695cbec7a4,
  0x674079fad73daad1, 0xd3573abd4b0b29b1, 0x6f19d1028be8a042, 0x0f3612e65f36d38c, 0x1f943458df1726ae,
  0xa1854e7ea75663c8, 0xe32fcc4ffef0f7bc, 0x7efd86687993fc0f, 0x867a617c68f45fe0, 0x1d252d9f0271964b,
  0xc4053c95fb9a1996, 0x00000000013ae917,
};

/*
 * m169_swio14_lednop_pr_ce_u4       m169a_swio14_lednop_pr_ce         m169a_swio14_lednop_pr_ce_u4
 * m169p_swio14_lednop_pr_ce         m169p_swio14_lednop_pr_ce_u4      m169pa_swio14_lednop_pr_ce
 * m169pa_swio14_lednop_pr_ce_u4     m165_swio14_lednop_pr_ce          m165_swio14_lednop_pr_ce_u4
 * m165a_swio14_lednop_pr_ce         m165a_swio14_lednop_pr_ce_u4      m165p_swio14_lednop_pr_ce
 * m165p_swio14_lednop_pr_ce_u4      m165pa_swio14_lednop_pr_ce        m165pa_swio14_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_swio14_lednop_pr_ce[] = {
  0x9e4dddddda244511, 0xdf8eed55e111ebc4, 0xd71efd3d1b6c4583, 0xd9febc6bb4b37764, 0xb2c56442041375e4,
  0xb657793baaf99f41, 0x167e394c13e30120, 0x17d7ba941b75fe78, 0x24b1e78c953bd377, 0x8f84bf10d8488bee,
  0xcf1771b8495951fa, 0xea3cbe9ee58cfd64, 0x8f7a5471d3f8359f, 0x9db244637ce62c05, 0x22a01ffb33c75e8f,
  0x6b2ed40f2d6e83fd, 0xb9c673141daf2e55, 0x52df5673a8a9546b, 0x21cd7020274dcaed, 0x8af2c434ae5f63d2,
  0xd01e395aeb9ed568, 0xd10210a905ca5af9, 0x2aa8b490538c6f19, 0x2e65f36d8c4c76f6, 0x458df1726ae0f361,
  0xe7ea75663c81f943, 0xc4ffef0f7bca1854, 0x6687993fc0fe32fc, 0x17c68f45fe07efd8, 0xd9f0271964b867a6,
  0xc95fb9a19961d252, 0x00000dd7085c4053,
};

/*
 * m169a_swio14_lednop_pr_ee_ce      m169p_swio14_lednop_pr_ee_ce      m169pa_swio14_lednop_pr_ee_ce
 * m165_swio14_lednop_pr_ee_ce       m165a_swio14_lednop_pr_ee_ce      m165p_swio14_lednop_pr_ee_ce
 * m165pa_swio14_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_swio14_lednop_pr_ee_ce[] = {
  0xb31ddddddd447032, 0xc45ddaabd85048c4, 0x2991db13ac829b18, 0x1f1f5a63be9de468, 0x48eee091f832d5b3,
  0x7793bad88e75864e, 0xdfe4c13e30120b65, 0x9759410d1fe78167, 0x78c953b0d077fd51, 0x84e771b8d07044fe,
  0xcaca5ca76b2b1ef9, 0x3f51f06cc1e95ea3, 0x2cd3ad08a0531594, 0x3a909afa30b2c452, 0x22239b8e7576e74a,
  0x56355e363af3a6ed, 0x5cc5c242285f11c6, 0xca8d8226470decb6, 0x76bcb955a9676b13, 0xa2a551aee719cc50,
  0x9d372bb54b7d59ce, 0xb97d8f488735c080, 0xae7b55a22bcb10d2, 0x17296be74078e56b, 0x4e31bc67440842a4,
  0x3131dbd8aaa2d241, 0xc9ab8d84b997cdb6, 0x31e40fca1a2c79c5, 0x64b867a615c9fbab, 0x961d252d964a2719,
  0xc7c4053c95fb9a19, 0x0000000000029a6d,
};

/*
 * m169a_swio14_lednop_pr_ee_ce_u4   m169p_swio14_lednop_pr_ee_ce_u4   m169pa_swio14_lednop_pr_ee_ce_u4
 * m165_swio14_lednop_pr_ee_ce_u4    m165a_swio14_lednop_pr_ee_ce_u4   m165p_swio14_lednop_pr_ee_ce_u4
 * m165pa_swio14_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio14_lednop_pr_ee_ce_u4[] = {
  0x21bbbbbb44867a31, 0xc5ddaabfa9b33891, 0x3db0dbb42cdd82fc, 0x0c2a002b66451dd3, 0x8a51ba976165b3c9,
  0xbc9dd44fc3efb40f, 0xb06609f180905b2b, 0x6e5050fbfec5767f, 0x42e0e21f5c5f547a, 0x0d8488bee24b1e79,
  0xc3fc7ddfa8f84bf1, 0x6b736f7ccf1771b9, 0xc1e95ea3caca5ca7, 0xa05315943f51f06c, 0x30b2c4522cd3ad08,
  0x7576e74a3a909afa, 0x3af3a6ed22239b8e, 0x285f11c656355e36, 0x470decb65cc5c242, 0xa9676b13ca8d8226,
  0xe719cc5076bcb955, 0x4b7d59cea2a551ae, 0x8735c0809d372bb5, 0x2bcb10d2b97d8f48, 0x4078e56bae7b55a2,
  0x440842a417296be7, 0xaaa2d2414e31bc67, 0xb997cdb63131dbd8, 0x771a2c6f86e3cd84, 0xc2a73f53ab337f07,
  0x97e627ff787bde50, 0x7ec3343cc9fe07f1, 0x3d30be347a2ff03f, 0x9296cf8138cb25c3, 0x459e4afdcd0ccb0e,
  0x000000027e46a737,
};

/*
 * m169a_swio14_lednop_hw            m169p_swio14_lednop_hw            m169pa_swio14_lednop_hw
 * m165_swio14_lednop_hw             m165a_swio14_lednop_hw            m165p_swio14_lednop_hw
 * m165pa_swio14_lednop_hw
 */
static const uint64_t ur_m169_swio14_lednop_hw[] = {
  0x511377777759bb37, 0x27adddaab914ad22, 0xdfbe3f770f8da0c2, 0x1105fd0ee38f684d, 0xc869b1006dbe3fbb,
  0x80905b2bbc9ddb1e, 0xffc38f3f01a609f1, 0xf921df2dd04a087b, 0x2631c74fe0ebffa8, 0xfa4398b016f74dd4,
  0xcb1823af173b08a8, 0x6bcb955a95982f71, 0x2a551aee719cc507, 0xd372bb54b7d59cea, 0x97d8f488735c0809,
  0xe7b55a22bcb10d2b, 0x6165362ce80f3f5a, 0x7d14085a6ae757a9, 0xe6da718de33a2051, 0xe4fcfec376c25ccb,
  0x25138cb25c33d30a, 0xfdcd0ccb0e9296cb, 0x0004717d7d829e4a,
};

/*
 * m169a_swio14_lednop_ee_hw         m169p_swio14_lednop_ee_hw         m169pa_swio14_lednop_ee_hw
 * m165_swio14_lednop_ee_hw          m165a_swio14_lednop_ee_hw         m165p_swio14_lednop_ee_hw
 * m165pa_swio14_lednop_ee_hw
 */
static const uint64_t ur_m169_swio14_lednop_ee_hw[] = {
  0x35f777776890c044, 0x93776aafc2ed1624, 0x13792eee6236f9b9, 0x0d7ad0da181050b4, 0x21fd334b8bc41b41,
  0x5b2bbc9dd4149cb4, 0x533e96a609f18090, 0xb5a331f28235bfe8, 0x60fa8f51e56c166a, 0x50ef8ad4f7a8f836,
  0x185962291669d684, 0x5dd2ae3593484d7d, 0xe9bb4888e6e39d5a, 0xe238cac6ab5d0ebc, 0xbd96cb98b848450b,
  0x5ac4f2a3608fd6e1, 0x73141daf2e556a01, 0x5673a8a9546bb9c6, 0x7020274dcaed52df, 0xc434ae5f63d221cd,
  0x395aeb9ed5688af2, 0x10a905ca5af9d01e, 0xb490538c6f19d102, 0xf9b6c63156f62aa8, 0xf505d8dc79b09732,
  0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c,
  0x00002df1a9ca29e4,
};

/*
 * m169a_swio14_lednop_ce_hw         m169p_swio14_lednop_ce_hw         m169pa_swio14_lednop_ce_hw
 * m165_swio14_lednop_ce_hw          m165a_swio14_lednop_ce_hw         m165p_swio14_lednop_ce_hw
 * m165pa_swio14_lednop_ce_hw
 */
static const uint64_t ur_m169_swio14_lednop_ce_hw[] = {
  0xf26eeeeed121b7d6, 0xfc776aaf088f5e24, 0x4f571ee8db622c1e, 0x4d9febc6bb4b3776, 0x2dfb56442041375e,
  0x2416caef2775eb4e, 0xfa14cfc729827c60, 0x9bb8bebdd4a0dbaf, 0xbee24b1e7942e0e6, 0x9fa8f84bf10d8488,
  0xd64cf1771b930ccf, 0x59fea3cbe9ee58cf, 0xc058f7a5471d3f83, 0xe8f9db244637ce62, 0x3fd22a01ffb33c75,
  0xe556b2ed40f2d6e8, 0x46bb9c673141daf2, 0xaed52df5673a8a95, 0x3d221cd7020274dc, 0x5688af2c434ae5f6,
  0xaf9d01e395aeb9ed, 0xf19d10210a905ca5, 0x6f62aa8b490538c6, 0x3612e65f36d8c4c7, 0xa1854e7ea0bb1b8f,
  0xe32fcc4ffef0f7bc, 0x7efd86687993fc0f, 0x867a617c68f45fe0, 0x1d252d9f0271964b, 0x05453c95fb9a1996,
  0x0000000000eb37df,
};

/*
 * m169_swio14_lednop_ee_ce_u4_hw    m169a_swio14_lednop_ee_ce_hw      m169a_swio14_lednop_ee_ce_u4_hw
 * m169p_swio14_lednop_ee_ce_hw      m169p_swio14_lednop_ee_ce_u4_hw   m169pa_swio14_lednop_ee_ce_hw
 * m169pa_swio14_lednop_ee_ce_u4_hw  m165_swio14_lednop_ee_ce_hw       m165_swio14_lednop_ee_ce_u4_hw
 * m165a_swio14_lednop_ee_ce_hw      m165a_swio14_lednop_ee_ce_u4_hw   m165p_swio14_lednop_ee_ce_hw
 * m165p_swio14_lednop_ee_ce_u4_hw   m165pa_swio14_lednop_ee_ce_hw     m165pa_swio14_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio14_lednop_ee_ce_hw[] = {
  0x90dddddda2435f41, 0x62eed55fd4d99c48, 0x9ed86dda166ec17e, 0x86150015b3228ee9, 0x2528dd4bb0b2d9e4,
  0xcaef27768bfbbdae, 0x9fec19827c602416, 0xa3d3728287dff429, 0xf3ca170710fae2fa, 0x5f886c2445f71258,
  0x8dc575c617fd47c2, 0xe53b5b9b7be678bb, 0x83660f4af51e5652, 0x68450298aca1fa8f, 0xd7d185962291669d,
  0xdc73abb73a51d484, 0xf1b1d79d3769111c, 0x121142f88e32b1aa, 0x1132386f65b2e62e, 0xcaad4b3b589e546c,
  0x8d7738ce6283b5e5, 0x5daa5beace75152a, 0x7a4439ae0404e9b9, 0xad115e588695cbec, 0x5f3a03c72b5d73da,
  0xe33a20421520b94b, 0xdec55516920a718d, 0x6c25ccbe6db1898e, 0x430a9cfd4176371e, 0xc65f989ffde1ef79,
  0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97, 0x3a8a792bf734332c, 0x0000000000280a35,
};

/*
 * m169_swio14_dual_pr               m169_swio14_dual_pr_u4            m169a_swio14_dual
 * m169a_swio14_dual_pr              m169a_swio14_dual_pr_u4           m169p_swio14_dual
 * m169p_swio14_dual_pr              m169p_swio14_dual_pr_u4           m169pa_swio14_dual
 * m169pa_swio14_dual_pr             m169pa_swio14_dual_pr_u4          m165_swio14_dual
 * m165_swio14_dual_pr               m165_swio14_dual_pr_u4            m165a_swio14_dual
 * m165a_swio14_dual_pr              m165a_swio14_dual_pr_u4           m165p_swio14_dual
 * m165p_swio14_dual_pr              m165p_swio14_dual_pr_u4           m165pa_swio14_dual
 * m165pa_swio14_dual_pr             m165pa_swio14_dual_pr_u4
 */
static const uint64_t ur_m169_swio14_dual[] = {
  0x4bbbbbbb4486c541, 0x7e276fc75e9c8da3, 0xb62fbb707a750b69, 0x1fc5fe47652be295, 0x18b3e2d402b74d29,
  0x95a1dd608fe1aaf5, 0x6609f180905b2bbc, 0xbbada0644a4a42a4, 0x8971030a18369181, 0x66727f9956ee774f,
  0xbd477f360bece051, 0x822847244fe0cca9, 0x6e1f0a21895fe7ef, 0xcaaeef77cdc6bb00, 0xad68a8432d08c910,
  0x096dca5ffd01cf09, 0x5ff735e60b0de579, 0x1fba3be596bca094, 0x30f71c74fe0f7bf5, 0x6989cc580aa0f339,
  0xf6608ebc019d9004, 0x7967b6f78df5403f, 0x8abe77715257cea0, 0x73141daf2e556b3f, 0x5673a8a9546bb9c6,
  0x7020274dcaed52df, 0xc434ae5f63d221cd, 0x395aeb9ed5688af2, 0x10a905ca5af9d01e, 0xb490538c6f19d102,
  0xf9b6c63156f62aa8, 0x458df0dc79b09732, 0xe7ea75666fe0eee3, 0xc4ffef0f7bca1854, 0x6687993fc0fe32fc,
  0x17c68f45fe07efd8, 0xd9f0271964b867a6, 0xc95fb9a19961d252, 0x0000a4990726e8b3,
};

/*
 * m169a_swio14_dual_pr_ee           m169p_swio14_dual_pr_ee           m169pa_swio14_dual_pr_ee
 * m165_swio14_dual_pr_ee            m165a_swio14_dual_pr_ee           m165p_swio14_dual_pr_ee
 * m165pa_swio14_dual_pr_ee
 */
static const uint64_t ur_m169_swio14_dual_pr_ee[] = {
  0x34eddddddd435032, 0x23e276fc6a68426d, 0x7ad3dba7395f40b3, 0xeb2333b55de9afbf, 0x2f0fae71337aed39,
  0xdd57b68ff5efbb1c, 0xe30120b657793d39, 0x819129290ba2cc13, 0x0c2860da4606eeb6, 0xfe655bb9dd3e25c4,
  0x75b04b4700b5318f, 0xe489fc1c569bd472, 0x44312bfcfdf04508, 0xddf372e8600dc3e1, 0x219682fb4432abbb,
  0xd7fd01cf0983dc54, 0xe60b0de579096df4, 0x68ff74a085aff735, 0x61efd4795dba9aad, 0x77c57a6fd47c1b30,
  0x2cb1148b34eb4228, 0x055c54b9a426be8c, 0xec63d19ea73ab4bb, 0xe21b1aad743af512, 0xbe9662e121146948,
  0x11551b047eb70dec, 0x157ceee2a4a01645, 0xe6283b5e5caad67f, 0xace75152a8d7738c, 0xe0404e9b95daa5be,
  0x88695cbec7a4439a, 0x72b5d73daad115e5, 0x21520b94b5f3a03c, 0x6920a718de33a204, 0xf36d8c62adec5551,
  0x163ce1b8f3612e65, 0xe4fdd599bf83bb8d, 0xf8138cb25c33d30a, 0xafdcd0ccb0e9296c, 0x00321445f37459e4,
};

/*
 * m169a_swio14_dual_pr_ee_u4        m169p_swio14_dual_pr_ee_u4        m169pa_swio14_dual_pr_ee_u4
 * m165_swio14_dual_pr_ee_u4         m165a_swio14_dual_pr_ee_u4        m165p_swio14_dual_pr_ee_u4
 * m165pa_swio14_dual_pr_ee_u4
 */
static const uint64_t ur_m169_swio14_dual_pr_ee_u4[] = {
  0xb7777768adbba0ae, 0x89dbf1a9a109b4d3, 0x47e69ce57d02cc8f, 0x676abbd35f7eda7b, 0x5ce266f5da73d646,
  0xfadd5ec3ebb85e1f, 0x5b2bbc9e9ceefafb, 0x9485d16609f18090, 0x6d2303775b40c894, 0xfcee9f12e2061430,
  0x1c02d4c63ff99696, 0x715a6f51c9d6c12d, 0xf3f7c114239227f0, 0xa180370f8510c4af, 0xed10caaeef77cdcb,
  0x3c260f7150865a0b, 0x95e425b7d35ff407, 0x085affc7e1982c37, 0x95dba9aad68ff74a, 0xfd47c1b3061efd47,
  0xb34eb422877c57a6, 0x9a426be8c2cb1148, 0xea73ab4bb055c54b, 0xd743af512ec63d19, 0x121146948e21b1aa,
  0x47eb70decbe9662e, 0x2a4a0164511551b0, 0xe5caad67f157ceee, 0x2a8d7738ce6283b5, 0xb95daa5beace7515,
  0xec7a4439ae0404e9, 0xdaad115e588695cb, 0x4b5f3a03c72b5d73, 0x8de33a20421520b9, 0x2adec55516920a71,
  0x0f3612e65f36d8c6, 0xfb763458df1726ae, 0x30a9cfd4eaccdfc1, 0x65f989ffde1ef794, 0xdfb0cd0f327f81fc,
  0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970, 0x1ba792bf734332c3, 0x0000000564f627f9,
};

/*
 * m169a_swio14_dual_pr_ce           m169p_swio14_dual_pr_ce           m169pa_swio14_dual_pr_ce
 * m165_swio14_dual_pr_ce            m165a_swio14_dual_pr_ce           m165p_swio14_dual_pr_ce
 * m165pa_swio14_dual_pr_ce
 */
static const uint64_t ur_m169_swio14_dual_pr_ce[] = {
  0xaddddddec121a5fb, 0xf89dbf3c7f766d1b, 0x41f6eabe6c48eee0, 0xe976d3913eabfaef, 0x9932bbf7ef74dd06,
  0xc4bba591aeb36855, 0x827c602416caef24, 0xd6d0322525222319, 0xb881850c1b48c0dd, 0xeaffccab773ba7c4,
  0x8fb3b611c8e07066, 0xa11c913f8395d37a, 0x7c2886257f9fbe08, 0xbbbddf37149001b8, 0xc542196807b4432a,
  0xb8cdffd01cf09827, 0xe6bcc161bcaf212d, 0x5717d5fc941383fe, 0xdc4963cf285c1c27, 0xf51f097e21b09117,
  0x733c5dc6e337d2a3, 0xdea384f9ee58cfa9, 0x528bb7e38e9fc1da, 0x0cec80234c4e62c0, 0x6faa01ffb33c75e0,
  0xa4af9d40f2d6e7bc, 0x5caad67f157ceee2, 0xa8d7738ce6283b5e, 0x95daa5beace75152, 0xc7a4439ae0404e9b,
  0xaad115e588695cbe, 0xb5f3a03c72b5d73d, 0xde33a20421520b94, 0xedec55516920a718, 0xe6c25ccbe6db1898,
  0xfc1ddc68b2d5e371, 0x69430a9cfd4eaccd, 0x7e03e687993fc09c, 0x09c6592e19e98572, 0xee6866587494b67c,
  0x06923d6dba2cf257,
};

/*
 * m169a_swio14_dual_pr_ce_u4        m169p_swio14_dual_pr_ce_u4        m169pa_swio14_dual_pr_ce_u4
 * m165_swio14_dual_pr_ce_u4         m165a_swio14_dual_pr_ce_u4        m165p_swio14_dual_pr_ce_u4
 * m165pa_swio14_dual_pr_ce_u4
 */
static const uint64_t ur_m169_swio14_dual_pr_ce_u4[] = {
  0x191dddddda2432db, 0x9de276fcf1f62e6d, 0x5a9afbad89d9471e, 0x91c9d4ccdd69624e, 0xf8ce947ee7157ee9,
  0x7792d15dc7045580, 0x75f4c13e30120b65, 0x606eeb6819129290, 0xd3e25c40c2860da4, 0x69b9a2b7e655bb9d,
  0x1cdea3e56d86fb38, 0xef822847244fe0ca, 0x006e1f0a21895fe7, 0x10caaeef77cdc4a8, 0x134e3150865a013d,
  0xe425b7b1fffa039e, 0x35bfdcd7982c3795, 0x0714f5c5f5dbf282, 0x2445f71258f3ca17, 0x3643fd47c25f886c,
  0x19e1c6678bb8dceb, 0xf8327bd4797d3dcb, 0xe62c05dbebe471d3, 0xe3af22dd87c4637c, 0xc54947570f71cb19,
  0xbcb955acfe2af9dd, 0xa551aee719cc5076, 0x372bb54b7d59cea2, 0x7d8f488735c0809d, 0x7b55a22bcb10d2b9,
  0x165362ce80f3f5ae, 0x8c6085a6ae757a96, 0xdb4e31bc67440a2f, 0xc6f86e3cd84b997c, 0xf53ab337f07771a2,
  0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c,
  0x0001a4859b7459e4,
};

/*
 * m169a_swio14_dual_pr_ee_ce        m169p_swio14_dual_pr_ee_ce        m169pa_swio14_dual_pr_ee_ce
 * m165_swio14_dual_pr_ee_ce         m165a_swio14_dual_pr_ee_ce        m165p_swio14_dual_pr_ee_ce
 * m165pa_swio14_dual_pr_ee_ce
 */
static const uint64_t ur_m169_swio14_dual_pr_ee_ce[] = {
  0xa9c5bbbbbba86f97, 0x7ade276fc6223f0d, 0x7ef5ef76c5e35586, 0x2be3749cad041f22, 0x097d7aef537c9671,
  0x9dcf046752c8a756, 0x3e30120b65779393, 0xd032252520e49cc1, 0x81850c1b48c0ddd6, 0xcfccab773ba7c4b8,
  0xff9b00d070d3533f, 0x1c913f83e9f9bd47, 0x2886257f9fbe08a1, 0x7bbe6e79c801b87c, 0x8432d03868865577,
  0xa4ffa039e133938a, 0xbcc161bcaf212db8, 0xd51943941d35fee6, 0xffcf285c1cd3477f, 0x21984e771b8a49cd,
  0xea3cad82ca76b2b2, 0x5a9ef51f06cc1f51, 0x4522cd3ad08a0531, 0x3863a909afa30b2c, 0x3b6df472f8e7576e,
  0x8f96355e363af6b1, 0xb8f8c5c242280511, 0xa92e31c8a6470dec, 0x972ab59fc55f3bb8, 0xaa35dce3398a0ed7,
  0xe576a96fab39d454, 0xb1e910e6b81013a6, 0x6ab44579621a572f, 0x2d7ce80f1cad75cf, 0x378ce881085482e5,
  0x3b7b15545a4829c6, 0x79b09732f9b6c626, 0xdfc1ddc68b1e70dc, 0x2e19e985727eeacc, 0x587494b67c09c659,
  0x71ba2cf257ee6866, 0x000000000001304e,
};

/*
 * m169a_swio14_dual_pr_ee_ce_u4     m169p_swio14_dual_pr_ee_ce_u4     m169pa_swio14_dual_pr_ee_ce_u4
 * m165_swio14_dual_pr_ee_ce_u4      m165a_swio14_dual_pr_ee_ce_u4     m165p_swio14_dual_pr_ee_ce_u4
 * m165pa_swio14_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio14_dual_pr_ee_ce_u4[] = {
  0xeeeeeed15b770668, 0x276fccc5fc26d67d, 0xda6a6bd5784339de, 0xdae2faf7683acada, 0x37713b3eec5e713a,
  0x52399a0e087877d7, 0xc96c4eeab8fb0003, 0x6e609f180905b2bb, 0xddd6d03225252196, 0xc4b881850c1b48c0,
  0x372d7e65a5bf3ba7, 0xa3e376c3b04e1787, 0x508e489fc1b5dcde, 0x3e144312bfcfdf04, 0xbbbddf37055000dc,
  0xc54219684724432a, 0xbd257fd01cf09b7d, 0x3f0cc161bcaf212d, 0xbea8c9d4a0de1ffe, 0x4b1e7942f3bbc3b8,
  0xf84bf10d8488bee2, 0x8bb8dc1545927fa8, 0x72ba53b5b9b9ba67, 0x51f06cc1edff51e5, 0xd3ad08a05315efbf,
  0x909afa30b2c4522c, 0xa33d4e7576e60a3a, 0x6abc6c75ea25d8c7, 0x8b848451a523886c, 0x3608991c37b2fa59,
  0xddc5494b3c8a22aa, 0x76bcb955acfe2af9, 0xa2a551aee719cc50, 0x9d372bb54b7d59ce, 0xb97d8f488735c080,
  0xae7b55a22bcb10d2, 0x17296be74078e56b, 0x4e31bc67440842a4, 0x3131dbd8aaa2d241, 0xab83cd84b997cdb6,
  0xf07edd8d1637c5c9, 0xe50c2a73f53ab337, 0x7f197e627ff787bd, 0x03f7ec3343cc9fe0, 0x5c33d30be347a2ff,
  0xb0e9296cf8138cb2, 0x5e46e9e4afdcd0cc, 0x00000000010013f0,
};

/*
 * m169a_swio14_dual_hw              m169p_swio14_dual_hw              m169pa_swio14_dual_hw
 * m165_swio14_dual_hw               m165a_swio14_dual_hw              m165p_swio14_dual_hw
 * m165pa_swio14_dual_hw
 */
static const uint64_t ur_m169_swio14_dual_hw[] = {
  0x2eeeeeed12190907, 0xf89dbf1d7a72368d, 0xd8beedc1e9d42da5, 0x7f17f91d94af8a56, 0xf6cf8b500add34a4,
  0xf2568775a0fd5f7a, 0x919827c602416cae, 0x06eeb6819129290a, 0x3e25c40c2860da46, 0x4599c9fe655bb9dd,
  0xa6f51dfcd82fb381, 0xbe08a11c913f8332, 0x01b87c2886257f9f, 0x432abbbddf371aec, 0x26b5a2a10cb42324,
  0xe425b7297ff4073c, 0xa2fffa91982c3795, 0xa8fdd1df2cb5e504, 0xc987b8e3a7f07bdf, 0x234c4e62c0550799,
  0xffb30475e00cec80, 0x03cb3db7bc6faa01, 0xfc55f3bb8a92be75, 0x3398a0ed7972ab59, 0xfab39d454aa35dce,
  0x6b81013a6e576a96, 0x9621a572fb1e910e, 0xf1cad75cf6ab4457, 0x1085482e52d7ce80, 0x45a4829c6378ce88,
  0x97cdb6318ab7b155, 0x9fa82ec6e3cd84b9, 0x13ffbc3def286153, 0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61,
  0x67c09c6592e19e98, 0x257ee6866587494b, 0x000018dd4839514f,
};

/*
 * m169a_swio14_dual_ee_hw           m169p_swio14_dual_ee_hw           m169pa_swio14_dual_ee_hw
 * m165_swio14_dual_ee_hw            m165a_swio14_dual_ee_hw           m165p_swio14_dual_ee_hw
 * m165pa_swio14_dual_ee_hw
 */
static const uint64_t ur_m169_swio14_dual_ee_hw[] = {
  0x76eeeee87ad0cf68, 0xf13b7e353421369a, 0x69edd39cafa05991, 0x9199daaef4d7dfbd, 0x87d73899bd769cf5,
  0x3b9a3ea75add8e17, 0x7c602416caef27a7, 0xd032252521745982, 0x81850c1b48c0ddd6, 0xffccab773ba7c4b8,
  0x4eb60968e016a631, 0x1c913f838ad37a8e, 0x2886257f9fbe08a1, 0x7bbe6e5d0c01b87c, 0x8432d05f68865577,
  0x9affa039e1307b8a, 0x8cc161bcaf212dbe, 0x5a3fdd28216bffd4, 0x187bf51e576ea6ab, 0x1df15e9bf51f06cc,
  0x0b2c4522cd3ad08a, 0xc157152e6909afa3, 0xbb18f467a9cead2e, 0x3886c6ab5d0ebd44, 0x2fa598b848451a52,
  0x445546c11fadc37b, 0xc55f3bb8a9280591, 0x398a0ed7972ab59f, 0xab39d454aa35dce3, 0xb81013a6e576a96f,
  0x621a572fb1e910e6, 0x1cad75cf6ab44579, 0x085482e52d7ce80f, 0x5a4829c6378ce881, 0x7cdb6318ab7b1554,
  0xd4bd5c6e3cd84b99, 0x8cbf313f9430a9cf, 0xeffe09a1e64ff173, 0x592e19e985727e39, 0x66587494b67c09c6,
  0xda45f514f257ee68, 0x0000000000000015,
};

/*
 * m169a_swio14_dual_ce_hw           m169p_swio14_dual_ce_hw           m169pa_swio14_dual_ce_hw
 * m165_swio14_dual_ce_hw            m165a_swio14_dual_ce_hw           m165p_swio14_dual_ce_hw
 * m165pa_swio14_dual_ce_hw
 */
static const uint64_t ur_m169_swio14_dual_ce_hw[] = {
  0x6eb777776890cf68, 0x83e276fcf1fdd9b4, 0xbd07dbaaf9b123bb, 0x1ba5db4e44faafeb, 0x7664caefdfbdd374,
  0xbc9312ee68fa9d6b, 0x8c6609f180905b2b, 0x03775b40c8949488, 0x9f12e20614306d23, 0xc19babff32addcee,
  0x4dea3eced8472381, 0xf822847244fe0e57, 0x06e1f0a21895fe7e, 0x0caaeef77cdc5240, 0x609f150865a01ed1,
  0x84b6e337ff4073c2, 0x1fff52330586f2bc, 0xe13ab8beafe4a09c, 0x88bee24b1e7942e0, 0x495fa8f84bf10d84,
  0x3ea5ccf1771b8c87, 0x076b7a8e13e7b963, 0x8b014a2edf8e3a7f, 0xd78033b2008d3139, 0x9ef1bea807feccf1,
  0xbb8a92be7503cb5b, 0xed7972ab59fc55f3, 0x454aa35dce3398a0, 0x3a6e576a96fab39d, 0x72fb1e910e6b8101,
  0x5cf6ab44579621a5, 0x2e52d7ce80f1cad7, 0x9c6378ce88108548, 0x6263b7b15545a482, 0x8dc79b09732f9b6c,
  0x7bde50c2a73f505d, 0xfe07f197e627ff78, 0x2ff03f7ec3343cc9, 0xcb25c33d30be347a, 0x0ccb0e9296cf8138,
  0x6eaf5ba29e4afdcd, 0x0000000000000002,
};

/*
 * m169a_swio14_dual_ee_ce_hw        m169p_swio14_dual_ee_ce_hw        m169pa_swio14_dual_ee_ce_hw
 * m165_swio14_dual_ee_ce_hw         m165a_swio14_dual_ee_ce_hw        m165p_swio14_dual_ee_ce_hw
 * m165pa_swio14_dual_ee_ce_hw
 */
static const uint64_t ur_m169_swio14_dual_ee_ce_hw[] = {
  0x1ceddddddd43359b, 0xc5e276fc6236086d, 0xdbc9ee8eba7d9da6, 0x98f599f0ce644d71, 0xbccd936a6f929ce4,
  0x6ee1e198535aebd7, 0x9f180905b2bbc966, 0x681912929196d260, 0x40c2860da4606eeb, 0xdfe655bb9dd3e25c,
  0xd35b07f870c41335, 0x8e489fc1ffc9bd47, 0x144312bfcfdf0450, 0xbddf37170400dc3e, 0x4219683054432abb,
  0xadffd01cf09a43c5, 0x8cc161bcaf212db9, 0xaa3cad283883ffd4, 0xff9e50b839880eff, 0xdd309cee3732a1a0,
  0xd4795cae94ed6564, 0x7befd47c1b307b7f, 0x148b34eb422814c5, 0x828ea426be8c2cb1, 0x7631e8cf539d5db9,
  0xe21b1aaf1b1d7a89, 0xbe9662e121146948, 0x88aa8d8226470dec, 0x8abe77715252cf22, 0x73141daf2e556b3f,
  0x5673a8a9546bb9c6, 0x7020274dcaed52df, 0xc434ae5f63d221cd, 0x395aeb9ed5688af2, 0x10a905ca5af9d01e,
  0xb490538c6f19d102, 0xf36d8c4c76f62aa8, 0x7e7f61b8f3612e65, 0x09c6592e19e98572, 0xee6866587494b67c,
  0x00089a601514f257,
};

/*
 * m169a_swio14_dual_ee_ce_u4_hw     m169p_swio14_dual_ee_ce_u4_hw     m169pa_swio14_dual_ee_ce_u4_hw
 * m165_swio14_dual_ee_ce_u4_hw      m165a_swio14_dual_ee_ce_u4_hw     m165p_swio14_dual_ee_ce_u4_hw
 * m165pa_swio14_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio14_dual_ee_ce_u4_hw[] = {
  0xbdddddda28d172df, 0xc4edf998bf84dacf, 0xcadd4d7aaf08673b, 0x13adae2faf7683ba, 0x7d737713b3eec5e7,
  0xaa0d5a1968e08787, 0x82d95de4b62776d6, 0x9290cb37304f8c04, 0x0da4606eeb681912, 0x849dd3e25c40c286,
  0x04e1787372d7e65d, 0x1b5dcdea3e376c3b, 0xfcfdf04508e489fc, 0x55000dc3e144312b, 0x724432abbbddf370,
  0xcf09b7dc54219684, 0xcaf212dbd257fd01, 0x1bc3ff67a1cc161b, 0x39787717d5193a94, 0x117dc4963cf1be18,
  0x7aff51f097e21b09, 0x7374cf1771b81646, 0xfea3cae574a76b73, 0x2bdf7ea3e0d983db, 0x88a459a75a1140a6,
  0xcc14752135f46165, 0x4bb18f467a9ceaed, 0x4710d8d578d8ebd4, 0x65f4b3170908a34a, 0x1445546c1132386f,
  0xfc55f3bb8a929679, 0x3398a0ed7972ab59, 0xfab39d454aa35dce, 0x6b81013a6e576a96, 0x9621a572fb1e910e,
  0xf1cad75cf6ab4457, 0x1085482e52d7ce80, 0x45a4829c6378ce88, 0x2f9b6c6263b7b155, 0x3f505d8dc79b0973,
  0x27ff787bde50c2a7, 0x343cc9fe07f197e6, 0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30, 0x4afdcd0ccb0e9296,
  0x0003aeac6680be9e,
};

/*
 * m169a_swio15_noled                m169p_swio15_noled                m169pa_swio15_noled
 * m165_swio15_noled                 m165a_swio15_noled                m165p_swio15_noled
 * m165pa_swio15_noled
 */
static const uint64_t ur_m169_swio15_noled[] = {
  0xd49bbbbbbacdfc4f, 0x7adddaab9142f712, 0xfa5c7750e2448c22, 0x20bfa1ddc4eecfe0, 0x68d4136d8cad3775,
  0x0120b657793bb0bd, 0xfdfa1e7cc7cc13e3, 0xc4277cb749283b7f, 0xb5e38e9fc1f3dea3, 0x268e62c05bdd3694,
  0x58c11d78b9dae1a3, 0x5e5caad4acaffb8e, 0x52a8d7738ce6283b, 0xb95daa5beaece751, 0xab57fbfa4439ace9,
  0x6b9ed5688af2c434, 0xea701652a7d3bcfd, 0x17ee2810b4b0b9d4, 0x2f9b69c6378ce881, 0x2b93f3fb0ddb0973,
  0x2c944e32c970cf4c, 0x2bf734332c3a4a5b, 0x00000a9171ae3e79,
};

/*
 * m169_swio15_noled_pr_u4           m169a_swio15_noled_pr             m169a_swio15_noled_pr_u4
 * m169p_swio15_noled_pr             m169p_swio15_noled_pr_u4          m169pa_swio15_noled_pr
 * m169pa_swio15_noled_pr_u4         m165_swio15_noled_pr              m165_swio15_noled_pr_u4
 * m165a_swio15_noled_pr             m165a_swio15_noled_pr_u4          m165p_swio15_noled_pr
 * m165p_swio15_noled_pr_u4          m165pa_swio15_noled_pr            m165pa_swio15_noled_pr_u4
 */
static const uint64_t ur_m169_swio15_noled_pr[] = {
  0x27777776891190e3, 0x1776aae453c7c4ae, 0x3d537bab21c6c13c, 0xb358d0600266f259, 0xac7c2f1afbb713a0,
  0xef277448b333761b, 0xdfc9827c602416ca, 0xa0fca0995fe78167, 0xfc1f41ea3cbe3be5, 0x05965347bd2a38e9,
  0x47ced10a3dece62c, 0x5269500ffd9823af, 0x556afadc0f2cf6c4, 0x6bb9c673141daf2e, 0xd52df57673a8a954,
  0xfdfd221cd674dcae, 0x6ab44579621a55ab, 0xa53c34ef3e2d75cf, 0x18de33a2041dd4d8, 0x455bd8aaa2d2da27,
  0x7079b09732f9b632, 0x40fca1a2c6f8b935, 0xe50c2a73f53ab31e, 0x7f197e627ff787bd, 0x03f7ec3343cc9fe0,
  0x5c33d30be347a2ff, 0xb0e9296cf8138cb2, 0x5a2029e4afdcd0cc, 0x00000000003e4d53,
};

/*
 * m169a_swio15_noled_pr_ee          m169p_swio15_noled_pr_ee          m169pa_swio15_noled_pr_ee
 * m165_swio15_noled_pr_ee           m165a_swio15_noled_pr_ee          m165p_swio15_noled_pr_ee
 * m165pa_swio15_noled_pr_ee
 */
static const uint64_t ur_m169_swio15_noled_pr_ee[] = {
  0xfdddddd0f5a22a20, 0xdddaabf0bd458971, 0x7be477c7edbe6e64, 0x86d1337aed2c90a6, 0xb452b620da0b8fd6,
  0x7747b16a4771a8d2, 0x9827c602416caef2, 0x28315bfcf02cf93a, 0x8f2b297355ad1bf9, 0xa1fa8f83660c27fa,
  0x91669d68450ef8ac, 0x593484d7d1859622, 0x8f2439d5a5d2b2e3, 0x6ab5d0ebce9bb750, 0x170908a3e44707ec,
  0x6c11fadc37b2d973, 0xcb955a805d260b54, 0x551aee719cc5076b, 0x2bb54b7d5d9cea2a, 0x6aff7f4887359d37,
  0x73daad115e588695, 0x36294f0d3bcf8b5d, 0x89c6378ce8810775, 0x8c9156f62aa8b4b6, 0x4d5c1e6c25ccbe6d,
  0x3c81f943459d3e2e, 0x9fca1854e7ea7566, 0xd0f327f8b9c65f98, 0xf4c2b93f1cf7ff04, 0x4a5b3e04e32c970c,
  0x0a792bf734332c3a, 0x000000004ebe3188,
};

/*
 * m169a_swio15_noled_pr_ee_u4       m169p_swio15_noled_pr_ee_u4       m169pa_swio15_noled_pr_ee_u4
 * m165_swio15_noled_pr_ee_u4        m165a_swio15_noled_pr_ee_u4       m165p_swio15_noled_pr_ee_u4
 * m165pa_swio15_noled_pr_ee_u4
 */
static const uint64_t ur_m169_swio15_noled_pr_ee_u4[] = {
  0xbdeeeeeed12232a8, 0xb4eed55f85e85c48, 0xd2eae3d1b6c47c49, 0xe4531d7c33c5ef4c, 0x8b41568106d045ed,
  0xc9dd3ad1a848b3ea, 0x5a609f180905b2bb, 0x54a0efbff3c0b3f1, 0xea3cadd2cd56b466, 0x5c87f51f06cc1a01,
  0x4522cd3ad08a1df1, 0x8a266909afa30b2c, 0x8a37bce75697a94b, 0x8d56ba1d7aea6ed3, 0xc5c242285ae8ee1d,
  0xe3a4fadc37b2e1c8, 0x19cc5076bcb955aa, 0xd5d9cea2a551aee7, 0x887359d372bb54b7, 0x15e5886956aff7f4,
  0xd3bcf8b5d73daad1, 0xce881077536294f0, 0x62aa8b4b689c6378, 0xc25ccbe6d8c9156f, 0x868b1be2e4d5c1e6,
  0xa9cfd4eacc7903f2, 0xf989ffde1ef79430, 0xb0cd0f327f81fc65, 0x4c2f8d1e8bfc0fdf, 0xa5b3e04e32c970cf,
  0xa792bf734332c3a4, 0x0000000275cb3880,
};

/*
 * m169_swio15_noled_pr_ce_u4        m169a_swio15_noled_pr_ce          m169a_swio15_noled_pr_ce_u4
 * m169p_swio15_noled_pr_ce          m169p_swio15_noled_pr_ce_u4       m169pa_swio15_noled_pr_ce
 * m169pa_swio15_noled_pr_ce_u4      m165_swio15_noled_pr_ce           m165_swio15_noled_pr_ce_u4
 * m165a_swio15_noled_pr_ce          m165a_swio15_noled_pr_ce_u4       m165p_swio15_noled_pr_ce
 * m165p_swio15_noled_pr_ce_u4       m165pa_swio15_noled_pr_ce         m165pa_swio15_noled_pr_ce_u4
 */
static const uint64_t ur_m169_swio15_noled_pr_ce[] = {
  0x426eeeeed1222a20, 0xfc776aaf08834e25, 0x47f4d2eedb75ec1e, 0xcff5fc7cfd833c76, 0xc6a081eb921bb426,
  0xb2bbc9dd1ec5aa38, 0xb3fb3a609f180905, 0x7d76fca0caeff3c0, 0x4b1e78c953bdf771, 0xf84bf10d8488bee2,
  0xf1771b9722495fa8, 0x51e6e9ee58cfd64c, 0x654e31c74fe0c9ef, 0x9da2147bd9cc580a, 0xd2a01ffb33c75e8f,
  0xb57d6e0796b708a4, 0xdce3398a0ed7972a, 0x96fabb39d454aa35, 0xfe910e6b3a6e576a, 0x5a22bcb10d2ad5fe,
  0x9e1a779f16bae7b5, 0x6f19d1020eea6c52, 0xedec5551696d138c, 0x79b09732f9b63218, 0xfca1a2c6f8b93570,
  0x0c2a73f53ab31e40, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c,
  0x2029e4afdcd0ccb0, 0x0000000006eba682,
};

/*
 * m169a_swio15_noled_pr_ee_ce       m169p_swio15_noled_pr_ee_ce       m169pa_swio15_noled_pr_ee_ce
 * m165_swio15_noled_pr_ee_ce        m165a_swio15_noled_pr_ee_ce       m165p_swio15_noled_pr_ee_ce
 * m165pa_swio15_noled_pr_ee_ce
 */
static const uint64_t ur_m169_swio15_noled_pr_ee_ce[] = {
  0x42fddddddd447705, 0x88bbb557b0a4bb89, 0xb89db93b504b2631, 0xfe3eb47a7c94c4d0, 0x5c11236460cb5685,
  0xde4eed86d94f5926, 0xd35304f8c0482d95, 0x52e507fe7f9e059f, 0xe3254effe1dff546, 0x09cee3732a1a0ff9,
  0x959c394ed6563df3, 0xbea3e0d9833d7d47, 0x59a75a1140a62b2e, 0x752135f4616588a4, 0xa847921ceaedc958,
  0xec6abc6c75e74ddb, 0x73170908a3e44707, 0xaa3608991c37b2d9, 0xb5e5caad4b3e9305, 0x152a8d7738ce6283,
  0x9b95daa5beaece75, 0x4ab57fbfa4439ace, 0xaeb9ed5688af2c43, 0xba9b14a7869de7c5, 0x5b44e31bc6744083,
  0x6d8c863b7b15545a, 0xce2e4d5c6c25ccbe, 0xdd598f207e50d163, 0x38cb25c33d30ae4f, 0xd0ccb0e9296cb251,
  0xd31e5e2029e4afdc, 0x0000000000000014,
};

/*
 * m169a_swio15_noled_pr_ee_ce_u4    m169p_swio15_noled_pr_ee_ce_u4    m169pa_swio15_noled_pr_ee_ce_u4
 * m165_swio15_noled_pr_ee_ce_u4     m165a_swio15_noled_pr_ee_ce_u4    m165p_swio15_noled_pr_ee_ce_u4
 * m165pa_swio15_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio15_noled_pr_ee_ce_u4[] = {
  0xd1bbbbbb448692df, 0xc5ddaabfa9d89892, 0x3d7adba34f1782fc, 0x8c2a0006713ae0fd, 0xcdd333582165b3d6,
  0xde4eea8fa10abe26, 0x8dd304f8c0482d95, 0x9d282d77ff62bb3f, 0xa17071aeee2faa3d, 0x86c2445f71258f3c,
  0x2e0b87ffd47c25f8, 0xdadcdbdf33c5dc6e, 0x3067afa8f2b38729, 0x2814c565d7d47c1b, 0x8c2cb1148b34eb42,
  0x9d5db92b0ea426be, 0x8ebce9bb7508f243, 0x147c88e0fd8d578d, 0x2386f65b2e62e121, 0xa967d260b546c113,
  0xe719cc5076bcb955, 0xb7d5d9cea2a551ae, 0xf4887359d372bb54, 0xd115e5886956aff7, 0xf0d3bcf8b5d73daa,
  0x78ce881077536294, 0x6f62aa8b4b689c63, 0xcd84b997cdb190c7, 0x7f07771a2c6f86e3, 0xde50c2a73f53ab33,
  0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f, 0xcb0e9296cf8138cb, 0x4e37459e4afdcd0c,
  0x0000000000013f06,
};

/*
 * m169a_swio15_noled_hw             m169p_swio15_noled_hw             m169pa_swio15_noled_hw
 * m165_swio15_noled_hw              m165a_swio15_noled_hw             m165p_swio15_noled_hw
 * m165pa_swio15_noled_hw
 */
static const uint64_t ur_m169_swio15_noled_hw[] = {
  0xd49bbbbbbacdfc4f, 0x7adddaab9142f712, 0xfa5c7750e2448c22, 0x20bfa1ddc4eecfe0, 0x68d4136d8cad3775,
  0x0120b657793bb0bd, 0xff871e7cc7cc13e3, 0xe213be5ba4941dbf, 0x5af1c74fe0f9ef51, 0x934731602dee9b4a,
  0x2c608ebc5ced70d1, 0xaf2e556a5657fdc7, 0xa9546bb9c673141d, 0xdcaed52df57673a8, 0x55abfdfd221cd674,
  0xb5cf6ab44579621a, 0x75380b2953e9de7e, 0x8bf714085a585cea, 0x97cdb4e31bc67440, 0x15c9f9fd86ed84b9,
  0x964a271964b867a6, 0x95fb9a19961d252d, 0x000004712e3b053c,
};

/*
 * m169a_swio15_noled_ee_hw          m169p_swio15_noled_ee_hw          m169pa_swio15_noled_ee_hw
 * m165_swio15_noled_ee_hw           m165a_swio15_noled_ee_hw          m165p_swio15_noled_ee_hw
 * m165pa_swio15_noled_ee_hw
 */
static const uint64_t ur_m169_swio15_noled_ee_hw[] = {
  0x8feeeeeed1219541, 0x26eed55f85ea2c4b, 0x0da67bbe3f6df373, 0xfd686d1337aed2c9, 0x8d2b452b620da0b8,
  0x95de4ee80a499a73, 0x9f275304f8c0482d, 0x68dfc9418adff429, 0x613fd479594b9aad, 0x77c5650fd47c1b30,
  0x2cb1148b34eb4228, 0x95971ac9a426be8c, 0xddba847921cead2e, 0x383f6355ae875e74, 0x96cb98b848451f22,
  0x305aa3608fd6e1bd, 0x283b5e5caad402e9, 0xe75152a8d7738ce6, 0xace9b95daa5beaec, 0xc434ab57fbfa4439,
  0x7c5aeb9ed5688af2, 0x083ba9b14a7869de, 0x45a5b44e31bc6744, 0x65f36c648ab7b155, 0xe7ea0bb1b8f3612e,
  0xc4ffef0f7bca1854, 0x6687993fc0fe32fc, 0x17c68f45fe07efd8, 0xd9f0271964b867a6, 0xc95fb9a19961d252,
  0x0000005bff927453,
};

/*
 * m169a_swio15_noled_ce_hw          m169p_swio15_noled_ce_hw          m169pa_swio15_noled_ce_hw
 * m165_swio15_noled_ce_hw           m165a_swio15_noled_ce_hw          m165p_swio15_noled_ce_hw
 * m165pa_swio15_noled_ce_hw
 */
static const uint64_t ur_m169_swio15_noled_ce_hw[] = {
  0x426eeeeed121be4a, 0xfc776aaf08834e25, 0xef48feeedb75ec1e, 0x4d9febf8f9fb0678, 0x6d57c103d7243768,
  0x2416caef2774a51d, 0xfa14cfece9827c60, 0xf7717d76fca0caef, 0x7dc4963cf285c1cd, 0xbf51f097e21b0911,
  0xac99e2ee370d6e61, 0x93dea3cdd3dcb19f, 0xb014ca9c638e9fc1, 0xbd1f3b4428f7b398, 0x1149a5403ff6678e,
  0x2e556afadc0f2d6e, 0x546bb9c673141daf, 0xaed52df57673a8a9, 0xabfdfd221cd674dc, 0xcf6ab44579621a55,
  0xd8a53c34ef3e2d75, 0x2718de33a2041dd4, 0x6431dbd8aaa2d2da, 0xb1b8f3612e65f36c, 0x0f7bca1854e7ea0b,
  0x3fc0fe32fcc4ffef, 0x45fe07efd8668799, 0x1964b867a617c68f, 0xa19961d252d9f027, 0xb36f927453c95fb9,
  0x000000000000000e,
};

/*
 * m169_swio15_noled_ee_ce_u4_hw     m169a_swio15_noled_ee_ce_hw       m169a_swio15_noled_ee_ce_u4_hw
 * m169p_swio15_noled_ee_ce_hw       m169p_swio15_noled_ee_ce_u4_hw    m169pa_swio15_noled_ee_ce_hw
 * m169pa_swio15_noled_ee_ce_u4_hw   m165_swio15_noled_ee_ce_hw        m165_swio15_noled_ee_ce_u4_hw
 * m165a_swio15_noled_ee_ce_hw       m165a_swio15_noled_ee_ce_u4_hw    m165p_swio15_noled_ee_ce_hw
 * m165p_swio15_noled_ee_ce_u4_hw    m165pa_swio15_noled_ee_ce_hw      m165pa_swio15_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio15_noled_ee_ce_hw[] = {
  0x68dddddda2436812, 0x62eed55fd4ec4c49, 0x9ebd6dd1a78bc17e, 0x46150003389d707e, 0xe6e999ac10b2d9eb,
  0xcaef27777ec2da9a, 0x9fc6e9827c602416, 0xa3d9d282d77ff429, 0xf3ca17071aeee2fa, 0x5f886c2445f71258,
  0x8dce41d5d7fd47c2, 0xe53b5b9b7be678bb, 0x83660cf5f51e5670, 0x68450298acbafa8f, 0xd7d185962291669d,
  0x4873abb72561d484, 0xf1b1d79d376ea11e, 0x24228f911c1fb1aa, 0x226470decb65cc5c, 0x2ab52cfa4c16a8d8,
  0x35dce3398a0ed797, 0x6a96fabb39d454aa, 0xfefe910e6b3a6e57, 0xb55a22bcb10d2ad5, 0x529e1a779f16bae7,
  0x8c6f19d1020eea6c, 0x18edec5551696d13, 0xdc79b09732f9b632, 0xbde50c2a73f505d8, 0xe07f197e627ff787,
  0xff03f7ec3343cc9f, 0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0x10c9ca29e4afdcd0, 0x0000000000000050,
};

/*
 * m169a_swio15_lednop               m169p_swio15_lednop               m169pa_swio15_lednop
 * m165_swio15_lednop                m165a_swio15_lednop               m165p_swio15_lednop
 * m165pa_swio15_lednop
 */
static const uint64_t ur_m169_swio15_lednop[] = {
  0x5a9377777759bb37, 0x27adddaab914ad22, 0xdfbe3f77d7f858c2, 0xa905fd0eee27684d, 0xc869b1006dbe3fbb,
  0x80905b2bbc9ddb1e, 0xfefd0f3f01a609f1, 0xf243be5ba49410f7, 0x2631c74fe0f9ef51, 0xfa4398b016f74dd4,
  0xcb1823af173b08a8, 0x6bcb955a95982f71, 0x2a551aee719cc507, 0x372bb54b7d5d9cea, 0x958f488735c0809d,
  0x3daad115e588695c, 0x52d794e02e740797, 0x5f45021695844c2f, 0xf9b69c6378ce8814, 0xb93f3fb0ddb09732,
  0xc944e32c970cf4c2, 0xbf734332c3a4a5b2, 0x0001527d7ae3e792,
};

/*
 * m169_swio15_lednop_pr_u4          m169a_swio15_lednop_pr            m169a_swio15_lednop_pr_u4
 * m169p_swio15_lednop_pr            m169p_swio15_lednop_pr_u4         m169pa_swio15_lednop_pr
 * m169pa_swio15_lednop_pr_u4        m165_swio15_lednop_pr             m165_swio15_lednop_pr_u4
 * m165a_swio15_lednop_pr            m165a_swio15_lednop_pr_u4         m165p_swio15_lednop_pr
 * m165p_swio15_lednop_pr_u4         m165pa_swio15_lednop_pr           m165pa_swio15_lednop_pr_u4
 */
static const uint64_t ur_m169_swio15_lednop_pr[] = {
  0x277777768911d38b, 0x1776aae45017c4ae, 0x86ad1a6d7af6c13c, 0x59ac683e3e00f164, 0x4f4da9b11ddb89d0,
  0x7793ba8cca734b29, 0xea54c13e30120b65, 0x41f94131ffe78167, 0xfc1f41ea3e9477cb, 0x0b2ca680c13e38e9,
  0x8f9d97c47191cc58, 0xee1aa01ffb30475e, 0xab5b87207967b637, 0x5dce3398a0ed7972, 0xa96fabb39d454aa3,
  0x10e6b81013a6e576, 0x22bcb10d2b92b1e9, 0x74078e56bae7b55a, 0x7440842a417296be, 0x8aaa2d2414e31bc6,
  0x25ccbe6da05455bd, 0x68b1be2e4d5c1e6c, 0x9cfd4eacc7903f28, 0x989ffde1ef79430a, 0x0cd0f327f81fc65f,
  0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4, 0x792bf734332c3a4a, 0x00000f93fea8880a,
};

/*
 * m169a_swio15_lednop_pr_ee         m169p_swio15_lednop_pr_ee         m169pa_swio15_lednop_pr_ee
 * m165_swio15_lednop_pr_ee          m165a_swio15_lednop_pr_ee         m165p_swio15_lednop_pr_ee
 * m165pa_swio15_lednop_pr_ee
 */
static const uint64_t ur_m169_swio15_lednop_pr_ee[] = {
  0xfeeeeeeea0a22044, 0x6eed55f85c8fc4b8, 0x0ef4ed85f0073732, 0xa1b44cea2bd76416, 0x2b8cdd883682e3f5,
  0x9dd4149c8c884331, 0xe609f180905b2bbc, 0x941383fe78167e87, 0x4795a9e9aad68dfc, 0x813d47c1b30613fd,
  0x48b34eb422877c57, 0xac9a426be8c2cb11, 0x460a1cead2f21d71, 0x355ae875e74ddbba, 0x8b8484513723c8b6,
  0x3608fd6e1bd96cb9, 0xf2e556a0108a4d2a, 0x9546bb9c673141da, 0xcaed52df57673a8a, 0x63d221cd7020274d,
  0x6ab44579621a5725, 0x2d7ce80f1cad75cf, 0x378ce881085482e5, 0xab7b15545a4829c6, 0x3cd84b997cdb40a8,
  0xf2868b2d5e5c9ab8, 0x30a9cfd4eacc7903, 0x3e687993fc09c694, 0x6592e19e985727e0, 0x866587494b67c09c,
  0xaf8431014f257ee6, 0x0000000000000013,
};

/*
 * m169a_swio15_lednop_pr_ee_u4      m169p_swio15_lednop_pr_ee_u4      m169pa_swio15_lednop_pr_ee_u4
 * m165_swio15_lednop_pr_ee_u4       m165a_swio15_lednop_pr_ee_u4      m165p_swio15_lednop_pr_ee_u4
 * m165pa_swio15_lednop_pr_ee_u4
 */
static const uint64_t ur_m169_swio15_lednop_pr_ee_u4[] = {
  0xbdeeeeeed1222a20, 0xb4eed55f85c19c48, 0xc8fe9a5d2e233c49, 0x5ede4531d7eb20a6, 0x6a081eb9bb106d04,
  0x2bbc9dd1ec5aa38c, 0x7e87e609f180905b, 0x8cca941383fe7816, 0x403d47959c39aad6, 0xbe2b727ea3e0d983,
  0x6588a459a75a1143, 0xed7144cd2135f461, 0xd97c47109cead2eb, 0x45b1aad743af5d4d, 0x1c8c5c242281be8c,
  0xb55c2cffadc37b2e, 0xdce3398a0ed7972a, 0x96fabb39d454aa35, 0x0e6b81013a6e576a, 0x2bcb10d2b92b1e91,
  0xce80f3f5ae7b55a2, 0xa6ae757a96165362, 0xde33a204e7d14085, 0x1e6c25ccbe6da718, 0x3f2868b1be2e4d5c,
  0x430a9cfd4eacc790, 0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97,
  0x880a792bf734332c, 0x00000000013ae9a0,
};

/*
 * m169a_swio15_lednop_pr_ce         m169p_swio15_lednop_pr_ce         m169pa_swio15_lednop_pr_ce
 * m165_swio15_lednop_pr_ce          m165a_swio15_lednop_pr_ce         m165p_swio15_lednop_pr_ce
 * m165pa_swio15_lednop_pr_ce
 */
static const uint64_t ur_m169_swio15_lednop_pr_ce[] = {
  0x4dddddd0f5a22044, 0x8eed55e11282c4a8, 0x4f4c4ec01e9583df, 0xff5fc7c699fb537f, 0x86d16a2b21bb426c,
  0x57793ba829395c10, 0x7c6b4c13e30120b6, 0xaedf941d37fe7816, 0x63cf192a77b3ae2f, 0x097e21b09117dc49,
  0x2ee3712a2e47f51f, 0x3ce33dcb19fac99e, 0xf3d638e9fc193dea, 0x65f11c6473160298, 0xa807feccf1d7a3e7,
  0xb8720796b70dfb86, 0xe3398a0ed7972ab5, 0xfabb39d454aa35dc, 0x6b81013a6e576a96, 0xcb10d2b92b1e910e,
  0x78e56bae7b55a22b, 0x0842a417296be740, 0xa2d2414e31bc6744, 0x97cdb40a31dbd8aa, 0xa7c5c9ab83cd84b9,
  0x4eacc7903f2868b3, 0xcbf313f9430a9cfd, 0xffe09a1e64ff1738, 0x92e19e985727e39e, 0x6587494b67c09c65,
  0xd3d1014f257ee686, 0x0000000000001baf,
};

/*
 * m169a_swio15_lednop_pr_ce_u4      m169p_swio15_lednop_pr_ce_u4      m169pa_swio15_lednop_pr_ce_u4
 * m165_swio15_lednop_pr_ce_u4       m165a_swio15_lednop_pr_ce_u4      m165p_swio15_lednop_pr_ce_u4
 * m165pa_swio15_lednop_pr_ce_u4
 */
static const uint64_t ur_m169_swio15_lednop_pr_ce_u4[] = {
  0x77eeeeeed1222044, 0x3eeed55e11219c4b, 0x6475a2efa5ad14cc, 0x83f85d098bcd8b1f, 0x10deb8d3537bbbbf,
  0xcaef277505272e9c, 0xcfdba9827c602416, 0xfa9eb283813fcf02, 0x963cf192a7795ae2, 0xf097e21b09117dc4,
  0xe2ee3712a2e47f51, 0x8f924f72c67e3399, 0xd0291c74fe0c43fa, 0xd9ef476b1cc580bd, 0x08bb8e58cf1d78b9,
  0x398a0ed7972ab51d, 0xbb39d454aa35dce3, 0x81013a6e576a96fa, 0x10d2b92b1e910e6b, 0xe56bae7b55a22bcb,
  0x42a417296be74078, 0xd2414e31bc674408, 0xcdb40a31dbd8aaa2, 0xc5c9ab83cd84b997, 0xd598f207e50d1637,
  0xbc3def2861539fa9, 0x64ff03f8cbf313ff, 0x3d17f81fbf619a1e, 0x9c6592e19e985f1a, 0xe6866587494b67c0,
  0x6ebd5951014f257e,
};

/*
 * m169a_swio15_lednop_pr_ee_ce      m169p_swio15_lednop_pr_ee_ce      m169pa_swio15_lednop_pr_ee_ce
 * m165_swio15_lednop_pr_ee_ce       m165a_swio15_lednop_pr_ee_ce      m165p_swio15_lednop_pr_ee_ce
 * m165pa_swio15_lednop_pr_ee_ce
 */
static const uint64_t ur_m169_swio15_lednop_pr_ee_ce[] = {
  0xa17eeeeeeea22044, 0xc45ddaabd8520dc4, 0x82c4ec0bd3630a18, 0xbfc7d68f4e5df250, 0x389c8ccd2c196ad0,
  0xbbc9dd4149c80504, 0xed6e609f180905b2, 0x2972829b7fe78167, 0xe3254ed36ceffaa3, 0x09cee3714939bff9,
  0x9594394ed6563df3, 0xbea3e0d9833d7d47, 0x59a75a1140a62b60, 0x752135f4616588a4, 0xba460a1ceaedd21c,
  0x6c6abc6c75e74ddb, 0x73170908a26e4791, 0x2a3608991c37b2d9, 0xdaf2e556a5988a4d, 0x8a9546bb9c673141,
  0x4dcaed52df57673a, 0x2563d221cd702027, 0xcf6ab44579621a57, 0xe52d7ce80f1cad75, 0xc6378ce881085482,
  0x463b7b15545a4829, 0x3571b09732f9b681, 0x3c81f943458f38b9, 0x970cf4c2b93f7566, 0xc3a4a5b2c944e32c,
  0xb880a792bf734332, 0x00000000000534f1,
};

/*
 * m169a_swio15_lednop_pr_ee_ce_u4   m169p_swio15_lednop_pr_ee_ce_u4   m169pa_swio15_lednop_pr_ee_ce_u4
 * m165_swio15_lednop_pr_ee_ce_u4    m165a_swio15_lednop_pr_ee_ce_u4   m165p_swio15_lednop_pr_ee_ce_u4
 * m165pa_swio15_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio15_lednop_pr_ee_ce_u4[] = {
  0xd1bbbbbb448650e3, 0xc5ddaabfa986e892, 0x1d015baf5cfd82fc, 0x8c2a000676262779, 0xdd914e8e2165b3d6,
  0x7793ba1607db29c2, 0x9adcc13e30120b65, 0xb3a504527fd8aecf, 0xca17070525c5f547, 0x886c2445f71258f3,
  0xc67afd6afd47c25f, 0x3b5b9b7be678bb8d, 0x660cf5f51e5650e5, 0x450298ad82fa8f83, 0xd185962291669d68,
  0x73abb74871d484d7, 0xb1d79d376ee91828, 0x2289b91e45b1aaf1, 0x6470decb65cc5c24, 0x5a96622934a8d822,
  0xee719cc5076bcb95, 0x4b7d5d9cea2a551a, 0x8735c0809d372bb5, 0x15e588695c958f48, 0xa03c72b5d73daad1,
  0xa20421520b94b5f3, 0x55516920a718de33, 0x5ccbe6da0518edec, 0xbb8d1637c371e6c2, 0x61539fa9d599bf83,
  0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0xa2cf257ee6866587,
  0x000000013f01e4db,
};

/*
 * m169a_swio15_lednop_hw            m169p_swio15_lednop_hw            m169pa_swio15_lednop_hw
 * m165_swio15_lednop_hw             m165a_swio15_lednop_hw            m165p_swio15_lednop_hw
 * m165pa_swio15_lednop_hw
 */
static const uint64_t ur_m169_swio15_lednop_hw[] = {
  0x5a9377777759bb37, 0x27adddaab914ad22, 0xdfbe3f77d7f858c2, 0xa905fd0eee27684d, 0xc869b1006dbe3fbb,
  0x80905b2bbc9ddb1e, 0xffc38f3f01a609f1, 0xf921df2dd24a087b, 0x1318e3a7f07cf7a8, 0x7d21cc580b7ba6ea,
  0xe58c11d78b9d8454, 0xb5e5caad4acc17b8, 0x152a8d7738ce6283, 0x9b95daa5beaece75, 0x4ac7a4439ae0404e,
  0x9ed5688af2c434ae, 0xa96bca70173a03cb, 0x2fa2810b4ac22617, 0x7cdb4e31bc67440a, 0x5c9f9fd86ed84b99,
  0x64a271964b867a61, 0x5fb9a19961d252d9, 0x00008e2fafb053c9,
};

/*
 * m169a_swio15_lednop_ee_hw         m169p_swio15_lednop_ee_hw         m169pa_swio15_lednop_ee_hw
 * m165_swio15_lednop_ee_hw          m165a_swio15_lednop_ee_hw         m165p_swio15_lednop_ee_hw
 * m165pa_swio15_lednop_ee_hw
 */
static const uint64_t ur_m169_swio15_lednop_ee_hw[] = {
  0xc7f777776890c582, 0x93776aafc2e47e25, 0x43560eec2f8039b9, 0x3f5a1b44cea2bd76, 0xa312b8cdd883682e,
  0x657793ba76821e96, 0xcfd0fcc13e30120b, 0xb46fe4a09c1ffa14, 0x309fea3cad4f4d56, 0x3be2bc09ea3e0d98,
  0x16588a459a75a114, 0x90eb8d64d2135f46, 0x6eddd23050e75697, 0x1e45b1aad743af3a, 0xcb65cc5c242289b9,
  0x526951b047eb70de, 0x8a0ed7972ab50084, 0x39d454aa35dce339, 0x013a6e576a96fabb, 0xd2b92b1e910e6b81,
  0x6bae7b55a22bcb10, 0xa417296be74078e5, 0x414e31bc67440842, 0xda05455bd8aaa2d2, 0x176371e6c25ccbe6,
  0xde1ef79430a9cfd4, 0x327f81fc65f989ff, 0x1e8bfc0fdfb0cd0f, 0x4e32c970cf4c2f8d, 0x734332c3a4a5b3e0,
  0x00b7e6a728a792bf,
};

/*
 * m169a_swio15_lednop_ce_hw         m169p_swio15_lednop_ce_hw         m169pa_swio15_lednop_ce_hw
 * m165_swio15_lednop_ce_hw          m165a_swio15_lednop_ce_hw         m165p_swio15_lednop_ce_hw
 * m165pa_swio15_lednop_ce_hw
 */
static const uint64_t ur_m169_swio15_lednop_ce_hw[] = {
  0x426eeeeed121af43, 0xfc776aaf08941625, 0x37bf4f7600f4ac1e, 0x26cff5fc7c699fb5, 0xadd94d16a2b21bb4,
  0x2416caef2775a77d, 0xfa14cf8d69827c60, 0x9d717d76fca0e9bf, 0x7dc4963cf285c1cd, 0xff51f097e21b0911,
  0x5933c5dc6e72d337, 0x27bd479c67b9633f, 0xc0531e7ac71d3f83, 0xf47cecbe238c8e62, 0xbf70d500ffd99e3a,
  0xe556b70e40f2d6e1, 0x46bb9c673141daf2, 0xed52df57673a8a95, 0xd221cd7020274dca, 0xb44579621a572563,
  0x7ce80f1cad75cf6a, 0x8ce881085482e52d, 0x7b15545a4829c637, 0xb09732f9b681463b, 0x0c2a73f505d8dc79,
  0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0x6a29e4afdcd0ccb0,
  0x0000000003acd805,
};

/*
 * m169_swio15_lednop_ee_ce_u4_hw    m169a_swio15_lednop_ee_ce_hw      m169a_swio15_lednop_ee_ce_u4_hw
 * m169p_swio15_lednop_ee_ce_hw      m169p_swio15_lednop_ee_ce_u4_hw   m169pa_swio15_lednop_ee_ce_hw
 * m169pa_swio15_lednop_ee_ce_u4_hw  m165_swio15_lednop_ee_ce_hw       m165_swio15_lednop_ee_ce_u4_hw
 * m165a_swio15_lednop_ee_ce_hw      m165a_swio15_lednop_ee_ce_u4_hw   m165p_swio15_lednop_ee_ce_hw
 * m165p_swio15_lednop_ee_ce_u4_hw   m165pa_swio15_lednop_ee_ce_hw     m165pa_swio15_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio15_lednop_ee_ce_hw[] = {
  0x68dddddda243704a, 0x62eed55fd4c37449, 0x8e80add7ae7ec17e, 0x461500033b1313bc, 0xeec8a74710b2d9eb,
  0x2bbc9dd75bae3b5d, 0x7cd6e609f180905b, 0x47b3a504527fd0a6, 0xf3ca17070525c5f5, 0x5f886c2445f71258,
  0xe373ce5d4efd47c2, 0x394ed6e6def99e2e, 0xe0d9833d7d479594, 0x5a1140a62b60bea3, 0x35f4616588a459a7,
  0x0a1ceaedd21c7521, 0xbc6c75e74ddbba46, 0x0908a26e47916c6a, 0x08991c37b2d97317, 0xe556a5988a4d2a36,
  0x46bb9c673141daf2, 0xed52df57673a8a95, 0xd221cd7020274dca, 0xb44579621a572563, 0x7ce80f1cad75cf6a,
  0x8ce881085482e52d, 0x7b15545a4829c637, 0xb09732f9b681463b, 0x0c2a73f505d8dc79, 0x197e627ff787bde5,
  0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0x3a29e4afdcd0ccb0, 0x0000000000a02079,
};

/*
 * m169_swio15_dual_pr               m169_swio15_dual_pr_u4            m169a_swio15_dual
 * m169a_swio15_dual_pr              m169a_swio15_dual_pr_u4           m169p_swio15_dual
 * m169p_swio15_dual_pr              m169p_swio15_dual_pr_u4           m169pa_swio15_dual
 * m169pa_swio15_dual_pr             m169pa_swio15_dual_pr_u4          m165_swio15_dual
 * m165_swio15_dual_pr               m165_swio15_dual_pr_u4            m165a_swio15_dual
 * m165a_swio15_dual_pr              m165a_swio15_dual_pr_u4           m165p_swio15_dual
 * m165p_swio15_dual_pr              m165p_swio15_dual_pr_u4           m165pa_swio15_dual
 * m165pa_swio15_dual_pr             m165pa_swio15_dual_pr_u4
 */
static const uint64_t ur_m169_swio15_dual[] = {
  0xc7bbbbbb44869a4e, 0x7e276fc75e10cda5, 0xb9f7ba8ce5dd0b69, 0x1fc5fc95264e2765, 0xe19628d4d8b75719,
  0x2b43bb8fea3151f1, 0xcc13e30120b65779, 0x775b40c894948ba1, 0x12e20614306d2303, 0xcce4ff32addcee9f,
  0x7a8efe6c17d9c0a2, 0x04508e489fc19953, 0xdc3e144312bfcfdf, 0xcaaeef77cdc80000, 0xad68a8432d08c910,
  0x096dca1ffd01cf09, 0xeff735e60b0de579, 0x1f6f9df2cf7ca0fe, 0xd1ee38e9fc1c1ff5, 0xe21398b01541e64a,
  0xecc11d78033b6948, 0x7967b698c64a807f, 0xc55f3bb8a92e04a0, 0x398a0ed7972ab59f, 0xbb39d454aa35dce3,
  0x81013a6e576a96fa, 0x10d2b92b1e910e6b, 0xe56bae7b55a22bcb, 0x42a417296be74078, 0xd2414e31bc674408,
  0xe6da05455bd8aaa2, 0x1637c371e6c25ccb, 0x9fa9d599bf83bb8d, 0x13ffbc3def286153, 0x9a1e64ff03f8cbf3,
  0x5f1a3d17f81fbf61, 0x67c09c6592e19e98, 0x257ee6866587494b, 0x0002927bc15ba2cf,
};

/*
 * m169a_swio15_dual_pr_ee           m169p_swio15_dual_pr_ee           m169pa_swio15_dual_pr_ee
 * m165_swio15_dual_pr_ee            m165a_swio15_dual_pr_ee           m165p_swio15_dual_pr_ee
 * m165pa_swio15_dual_pr_ee
 */
static const uint64_t ur_m169_swio15_dual_pr_ee[] = {
  0x586ddddddd43573e, 0xc8f89dbf1a99366d, 0x5f47e6ea729c502c, 0xcf59198f6d9beec7, 0xf700faabc99bd7b0,
  0xe772e2fbb0af7aca, 0x4f8c0482d95de4f4, 0xda0644a4a43a7530, 0x1030a18369181bba, 0x3ff9956ee774f897,
  0xc9d6c12d1c02d4c6, 0x239227f0715a6f51, 0x8510c4aff3f7c114, 0xef77cdceeb00370f, 0x50865a0bed10caae,
  0x3b7ff4073c260f71, 0xaf30586f2bc84b6f, 0xd68dc9ca0f4fffb9, 0x071efd4795e9b9aa, 0x877c57b3bd47c1b3,
  0xc2cb1148b34eb422, 0xa9e5c54b9a426be8, 0x9767f11f5073ab4b, 0x47f258d56ba1d7a8, 0x65f4b3170908a0f5,
  0xe6f6a8d823f5b86f, 0xfc55f3bb8a928043, 0x3398a0ed7972ab59, 0xabb39d454aa35dce, 0xb81013a6e576a96f,
  0xb10d2b92b1e910e6, 0x8e56bae7b55a22bc, 0x842a417296be7407, 0x2d2414e31bc67440, 0xbe6da05455bd8aaa,
  0xa2c79c371e6c25cc, 0x5c9fbab337f07771, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x000c852c7f6e8b3c,
};

/*
 * m169a_swio15_dual_pr_ee_u4        m169p_swio15_dual_pr_ee_u4        m169pa_swio15_dual_pr_ee_u4
 * m165_swio15_dual_pr_ee_u4         m165a_swio15_dual_pr_ee_u4        m165p_swio15_dual_pr_ee_u4
 * m165pa_swio15_dual_pr_ee_u4
 */
static const uint64_t ur_m169_swio15_dual_pr_ee_u4[] = {
  0xb7777768adbb3202, 0xe276fc6a64d9b561, 0xa339a9ca7140b323, 0x663db66fbb1d71f9, 0xeaaf266f5ec33d64,
  0x41f5d717d35bdc03, 0x05b2bbc9e9cee1a7, 0x494874ea609f1809, 0x06d2303775b40c89, 0x6fcee9f12e206143,
  0xd1c02d4c63ff9969, 0x0715a6f51c9d6c12, 0xff3f7c114239227f, 0xeeb00370f8510c4a, 0xbed10caaeef77cdc,
  0x73c260f7150865a0, 0xf2bc84b6f3b7ff40, 0x83d3fff8fc330586, 0xe57a6e6ab5a37272, 0xef51f06cc1c7bf51,
  0x2cd3ad08a1df15ec, 0xe6909afa30b2c452, 0xd41cead2ea797152, 0x5ae875ea25d9fc47, 0xc242283d51fc9635,
  0x08fd6e1bd97d2cc5, 0xe2a4a010f9bdaa36, 0x5e5caad67f157cee, 0x52a8d7738ce6283b, 0xb95daa5beaece751,
  0xac7a4439ae0404e9, 0xed5688af2c434ae4, 0xa5af9d01e395aeb9, 0xc6f19d10210a905c, 0x156f62aa8b490538,
  0x079b09732f9b6815, 0xfdbb1a2c6f8b9357, 0x1854e7ea75666fe0, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe,
  0x67a617c68f45fe07, 0xd252d9f0271964b8, 0x8dd3c95fb9a19961, 0x00000000ac896d3c,
};

/*
 * m169a_swio15_dual_pr_ce           m169p_swio15_dual_pr_ce           m169pa_swio15_dual_pr_ce
 * m165_swio15_dual_pr_ce            m165a_swio15_dual_pr_ce           m165p_swio15_dual_pr_ce
 * m165pa_swio15_dual_pr_ce
 */
static const uint64_t ur_m169_swio15_dual_pr_ce[] = {
  0x9dbbbbbbd82432db, 0x3e276fcf1f5c4da2, 0xae17bb3890523bb8, 0x6e9776182ca3e9f7, 0xe908766c75f74a70,
  0x4c4bb8e08ab2c10c, 0x9827c602416caef2, 0xeeb68191292902a8, 0x25c40c2860da4606, 0x3757fe655bb9dd3e,
  0xd47d9db08e470383, 0x4508e489fc1cae9b, 0xc3e144312bfcfdf0, 0xabbbddf37011200d, 0x7c542196807b4432,
  0x6dffe7fd01cf0982, 0xf735e60b0de57909, 0x5f717d6034a093af, 0xfb892c79e50b839d, 0xfea3e12fc4361222,
  0x9733c5dc6e759b21, 0x45f51e449ee58cfa, 0x017f71951c74fe0c, 0x8033b6948e21398b, 0x8c64a807feccf1d7,
  0xe2a4b81281e5adc9, 0x5e5caad67f157cee, 0x52a8d7738ce6283b, 0xb95daa5beaece751, 0xac7a4439ae0404e9,
  0xed5688af2c434ae4, 0xa5af9d01e395aeb9, 0xc6f19d10210a905c, 0xc76f62aa8b490538, 0x8f3612e65f36d028,
  0x6fe0eee34596af1b, 0xe34a1854e7ea7566, 0x93f01f343cc9fe04, 0xe04e32c970cf4c2b, 0xbf734332c3a4a5b3,
  0x003490ad4dd16792,
};

/*
 * m169a_swio15_dual_pr_ce_u4        m169p_swio15_dual_pr_ce_u4        m169pa_swio15_dual_pr_ce_u4
 * m165_swio15_dual_pr_ce_u4         m165a_swio15_dual_pr_ce_u4        m165p_swio15_dual_pr_ce_u4
 * m165pa_swio15_dual_pr_ce_u4
 */
static const uint64_t ur_m169_swio15_dual_pr_ce_u4[] = {
  0xb13bbbbbb4486f97, 0x3bc4edf9e3f3ecda, 0x3deef75053d68e3d, 0x89c9d4cca76f5d84, 0x2d4e900d57efdeed,
  0xef25a2bb9e08ce9c, 0x2319827c602416ca, 0xc0ddd6d032252522, 0xa7c4b881850c1b48, 0xd373456fccab773b,
  0x39bd47cadb0df670, 0xdf04508e489fc194, 0x00dc3e144312bfcf, 0x21955ddeef9b8c86, 0x269c62a10cb4027a,
  0xc84b6e337ff4073c, 0xe0ffb9af30586f2b, 0x073025c5f532a504, 0x2445f71258f3ca17, 0x8b91fd47c25f886c,
  0x19e1c6678bb8dc4a, 0xfc1935ea3ce33dcb, 0x398b014ca9ba38e9, 0x78ebc8b765ae8e32, 0xb8a928ead6dc72c6,
  0xd7972ab59fc55f3b, 0x54aa35dce3398a0e, 0x6e576a96fabb39d4, 0x2b1e910e6b81013a, 0x7b55a22bcb10d2b9,
  0x165362ce80f3f5ae, 0x8c6085a6ae757a96, 0xdb4e31bc674409cf, 0xc6f86e3cd84b997c, 0xf53ab337f07771a2,
  0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c,
  0x000d24085b7459e4,
};

/*
 * m169a_swio15_dual_pr_ee_ce        m169p_swio15_dual_pr_ee_ce        m169pa_swio15_dual_pr_ee_ce
 * m165_swio15_dual_pr_ee_ce         m165a_swio15_dual_pr_ee_ce        m165p_swio15_dual_pr_ee_ce
 * m165pa_swio15_dual_pr_ee_ce
 */
static const uint64_t ur_m169_swio15_dual_pr_ee_ce[] = {
  0x5f6b77777750cf68, 0xeb789dbf1888ce1b, 0xda57bddcfb67d619, 0x2be37410f225c2c2, 0x7f9b4d9b537c97ed,
  0x3b9a3ea74704dd9c, 0x7c602416caef2727, 0xa0644a4a411eb982, 0x030a18369181bbad, 0x9f9956ee774f8971,
  0xff3601a0e1a6a67f, 0x39227f07d3f37a8f, 0x510c4aff3f7c1142, 0xeef9b830b80370f8, 0x10cb40e1a21955dd,
  0xbbfe80e784ce4e2a, 0xe60b0de579096df1, 0x51b059419dbff735, 0xf9e50b8393b677fd, 0x66139dc6e0224c03,
  0x8f2b53d29dacac88, 0x027a8f83660c27fa, 0x91669d68450298af, 0x51d484d7d1859622, 0x63291ce273abb717,
  0x5ec6abc6c75ed627, 0x7c62e121144be46b, 0x4b8c47c32386f65c, 0xcaad67f157ceee2a, 0x8d7738ce6283b5e5,
  0xdaa5beaece75152a, 0xa4439ae0404e9b95, 0x688af2c434ae4ac7, 0xf9d01e395aeb9ed5, 0x19d10210a905ca5a,
  0xf62aa8b490538c6f, 0x612e65f36d028c76, 0x83bb8d163ce1b8f3, 0x33d30ae4fdd599bf, 0xe9296cf8138cb25c,
  0x7459e4afdcd0ccb0, 0x0000000009822a73,
};

/*
 * m169a_swio15_dual_pr_ee_ce_u4     m169p_swio15_dual_pr_ee_ce_u4     m169pa_swio15_dual_pr_ee_ce_u4
 * m165_swio15_dual_pr_ee_ce_u4      m165a_swio15_dual_pr_ee_ce_u4     m165p_swio15_dual_pr_ee_ce_u4
 * m165pa_swio15_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m169_swio15_dual_pr_ee_ce_u4[] = {
  0xeeeeeed15b77d8be, 0x276fccc54626d157, 0x9afbdda8f84339de, 0x6af2657bc89ada6f, 0x4377138abec5e715,
  0x3ebeca9c7829649b, 0xbbc96c4eea0d599a, 0x7aa2609f180905b2, 0x606eeb6819129291, 0xd3e25c40c2860da4,
  0xc39b96bf32d2df9d, 0x6f51f1bb61d8270b, 0x822847244fe0daee, 0x6e1f0a21895fe7ef, 0x2abbbddf37138f00,
  0x7dc5421968472443, 0x2db9257fd01cf09b, 0xfe3f0cc161bcaf21, 0x717d51f57ca0cc37, 0xc4963cf285e7730d,
  0x51f097e21b09117d, 0x9e2ee37138fee3ff, 0x95efb94ed6e6e6e9, 0x5ea3e0d98332bd47, 0x59a75a1140a62bb7,
  0x752135f4616588a4, 0xfc47d41ceaedca78, 0x2c6abc6c75ea25d9, 0x598b8484507aa3f9, 0xaa3608991c37b2fa,
  0x7ceee2a4a598f9bd, 0x283b5e5caad67f15, 0xe75152a8d7738ce6, 0x04e9b95daa5beaec, 0x4ae4ac7a4439ae04,
  0xaeb9ed5688af2c43, 0x905ca5af9d01e395, 0x0538c6f19d10210a, 0xd028c76f62aa8b49, 0x26ae0f3612e65f36,
  0xdfc1fb763458df17, 0xf79430a9cfd4eacc, 0x81fc65f989ffde1e, 0xfc0fdfb0cd0f327f, 0xc970cf4c2f8d1e8b,
  0x32c3a4a5b3e04e32, 0x05f91ba792bf7343, 0x0000000000040004,
};

/*
 * m169a_swio15_dual_hw              m169p_swio15_dual_hw              m169pa_swio15_dual_hw
 * m165_swio15_dual_hw               m165a_swio15_dual_hw              m165p_swio15_dual_hw
 * m165pa_swio15_dual_hw
 */
static const uint64_t ur_m169_swio15_dual_hw[] = {
  0x8f777776890d365a, 0xfc4edf8ebc219b4b, 0x73ef7519cbba16d2, 0x3f8bf92a4c9c4ecb, 0x7b2c51a9b16eae32,
  0x792b43bb227af7a5, 0xa1cc13e30120b657, 0x03775b40c894948b, 0x9f12e20614306d23, 0xa2cce4ff32addcee,
  0x537a8efe6c17d9c0, 0xdf04508e489fc199, 0x00dc3e144312bfcf, 0x10caaeef77cdc800, 0x09ad68a8432d08c9,
  0x79096dca1ffd01cf, 0xfddffea4660b0de5, 0xea3edf3be59ef941, 0x95a3dc71d3f8383f, 0x91c42731602a83cc,
  0xffd9823af00676d2, 0x40f2cf6d318c9500, 0x3f8abe7771525c09, 0xc673141daf2e556b, 0xf57673a8a9546bb9,
  0xd7020274dcaed52d, 0x9621a572563d221c, 0xf1cad75cf6ab4457, 0x1085482e52d7ce80, 0x45a4829c6378ce88,
  0x97cdb40a8ab7b155, 0x9fa82ec6e3cd84b9, 0x13ffbc3def286153, 0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61,
  0x67c09c6592e19e98, 0x257ee6866587494b, 0x000018dd7782d14f,
};

/*
 * m169a_swio15_dual_ee_hw           m169p_swio15_dual_ee_hw           m169pa_swio15_dual_ee_hw
 * m165_swio15_dual_ee_hw            m165a_swio15_dual_ee_hw           m165p_swio15_dual_ee_hw
 * m165pa_swio15_dual_ee_hw
 */
static const uint64_t ur_m169_swio15_dual_ee_hw[] = {
  0xc36eeeee87ad0c86, 0x47c4edf8d4c9b36a, 0xfa3f375394e28166, 0x7ac8cc7b6cdf763a, 0xb807d55e4cdebd86,
  0xe9ceeeec6ecde62f, 0x609f180905b2bbc9, 0x75b40c89494874ea, 0x2e20614306d23037, 0x8c7ff32addcee9f1,
  0xa393ad825a3805a9, 0x2847244fe0e2b4de, 0x1f0a21895fe7ef82, 0x5ddeef9b9dd6006e, 0xe2a10cb417da2195,
  0xde76ffe80e784c1e, 0xea4660b0de579096, 0xab5a3727283d3fff, 0xcc1c7bf51e57a6e6, 0x8a1df15ecef51f06,
  0xa30b2c4522cd3ad0, 0x2ea797152e6909af, 0xa25d9fc47d41cead, 0xd51fc96355ae875e, 0xbd97d2cc5c242283,
  0x0f9bdaa3608fd6e1, 0x67f157ceee2a4a01, 0x38ce6283b5e5caad, 0xbeaece75152a8d77, 0x9ae0404e9b95daa5,
  0xf2c434ae4ac7a443, 0x1e395aeb9ed5688a, 0x0210a905ca5af9d0, 0xa8b490538c6f19d1, 0x32f9b6815156f62a,
  0x9fa97ab8dc79b097, 0xe7197e627f286153, 0x73dffc1343cc9fe2, 0x8cb25c33d30ae4fc, 0xd0ccb0e9296cf813,
  0x576ac7fa29e4afdc,
};

/*
 * m169a_swio15_dual_ce_hw           m169p_swio15_dual_ce_hw           m169pa_swio15_dual_ce_hw
 * m165_swio15_dual_ce_hw            m165a_swio15_dual_ce_hw           m165p_swio15_dual_ce_hw
 * m165pa_swio15_dual_ce_hw
 */
static const uint64_t ur_m169_swio15_dual_ce_hw[] = {
  0x453b777776890c86, 0x707c4edf9e3eb89b, 0xef5c2f767120a477, 0xe0dd2eec305947d3, 0xe62a10ecd8ebee94,
  0xbbc9312eeeec6ecd, 0x0aa2609f180905b2, 0x181bbada0644a4a4, 0x74f8971030a18369, 0x0e0cdd5ff9956ee7,
  0xba6f51f676c2391c, 0xf7c114239227f072, 0x80370f8510c4aff3, 0x10caaeef77cdc044, 0x2609f150865a01ed,
  0xe425b7ff9ff4073c, 0x9d7ffa91982c3795, 0x1ceafb8beb01a504, 0x9117dc4963cf285c, 0x492bf51f097e21b0,
  0x67d4b99e2ee372e4, 0xf0622fa8f224f72c, 0xcc580bfb8ca8e3a7, 0x8ebc019db4a47109, 0x6e4c6325403ff667,
  0xe7771525c0940f2d, 0x41daf2e556b3f8ab, 0x3a8a9546bb9c6731, 0x274dcaed52df5767, 0x572563d221cd7020,
  0x75cf6ab44579621a, 0x82e52d7ce80f1cad, 0x29c6378ce8810854, 0x81463b7b15545a48, 0xd8dc79b09732f9b6,
  0x87bde50c2a73f505, 0x9fe07f197e627ff7, 0xa2ff03f7ec3343cc, 0x8cb25c33d30be347, 0xd0ccb0e9296cf813,
  0x26ea56aa29e4afdc,
};

/*
 * m169a_swio15_dual_ee_ce_hw        m169p_swio15_dual_ee_ce_hw        m169pa_swio15_dual_ee_ce_hw
 * m165_swio15_dual_ee_ce_hw         m165a_swio15_dual_ee_ce_hw        m165p_swio15_dual_ee_ce_hw
 * m165pa_swio15_dual_ee_ce_hw
 */
static const uint64_t ur_m169_swio15_dual_ee_ce_hw[] = {
  0x9396eeeeeea1a5fb, 0xc5e276fc623c7f36, 0xd721eed17d8b9da6, 0x63d62c57d769eaef, 0xfabe1f29be4a9c92,
  0xbba591aeba55857b, 0x7c602416caef2599, 0x40c8949483d9e982, 0x0614306d2303775b, 0xff32addcee9f12e2,
  0x9ad83fc3862099ae, 0x7244fe0ffe4dea3e, 0xa21895fe7ef82284, 0xeef9b8164006e1f0, 0x10cb4182a21955dd,
  0x0ffe80e784d21e2a, 0x660b0de579096def, 0xa395d2835bfffea4, 0xf3ca17072b7ceffa, 0xa6139dc6e747d493,
  0x8f2bdf729dacac9b, 0x6ebd47c1b306657a, 0x48b34eb422814c57, 0xf0ea426be8c2cb11, 0xb3f88fa839d5db94,
  0xf258d578d8ebd44b, 0xf4b3170908a0f547, 0x7b546c1132386f65, 0x2af9ddc5494b31f3, 0xcc5076bcb955acfe,
  0xd9cea2a551aee719, 0x0809d372bb54b7d5, 0x8695c958f488735c, 0x2b5d73daad115e58, 0x1520b94b5f3a03c7,
  0x920a718de33a2042, 0x6da0518edec55516, 0xcfec371e6c25ccbe, 0x38cb25c33d30ae4f, 0xcd0ccb0e9296cf81,
  0x089a638ba29e4afd,
};

/*
 * m169a_swio15_dual_ee_ce_u4_hw     m169p_swio15_dual_ee_ce_u4_hw     m169pa_swio15_dual_ee_ce_u4_hw
 * m165_swio15_dual_ee_ce_u4_hw      m165a_swio15_dual_ee_ce_u4_hw     m165p_swio15_dual_ee_ce_u4_hw
 * m165pa_swio15_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m169_swio15_dual_ee_ce_u4_hw[] = {
  0x7eeeeeed14682541, 0xe276fccc54626d15, 0xb69bbdda8f84339d, 0x9c55abc995ef2276, 0x926d0ddc4e2afb17,
  0x4e30cb5bb4f9e0a5, 0x0482d95de4b62775, 0x894948bd51304f8c, 0x4306d2303775b40c, 0x2ec24ee9f12e2061,
  0x1d8270bc39b96bf3, 0xfe0daee6f51f1bb6, 0x95fe7ef822847244, 0x7138f006e1f0a218, 0x84724432abbbddf3,
  0x01cf09b7dc542196, 0x1bcaf212db9257fd, 0x941986ff67a1cc16, 0x307261ae2faa3eaf, 0x1222fb892c79e37c,
  0xf1f77ea3e12fc436, 0xcdcdd33c5dc6e70f, 0x657a8f2bdf729dad, 0x4c576ebd47c1b306, 0xcb1148b34eb42281,
  0xdb94f0ea426be8c2, 0xd44bb3f88fa839d5, 0xf547f258d578d8eb, 0x6f65f4b3170908a0, 0x31f37b546c113238,
  0xacfe2af9ddc5494b, 0xe719cc5076bcb955, 0xb7d5d9cea2a551ae, 0x735c0809d372bb54, 0x5e588695c958f488,
  0x03c72b5d73daad11, 0x20421520b94b5f3a, 0x5516920a718de33a, 0xccbe6da0518edec5, 0x9cfd4176371e6c25,
  0x989ffde1ef79430a, 0x0cd0f327f81fc65f, 0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4, 0x792bf734332c3a4a,
  0x00000ebacd1b82fa,
};

/*
 * m329_autobaud_uart0_noled_pr      m329a_autobaud_uart0_noled        m329a_autobaud_uart0_noled_pr
 * m329p_autobaud_uart0_noled        m329p_autobaud_uart0_noled_pr     m329pa_autobaud_uart0_noled
 * m329pa_autobaud_uart0_noled_pr    m3290_autobaud_uart0_noled        m3290_autobaud_uart0_noled_pr
 * m3290a_autobaud_uart0_noled       m3290a_autobaud_uart0_noled_pr    m3290p_autobaud_uart0_noled
 * m3290p_autobaud_uart0_noled_pr    m3290pa_autobaud_uart0_noled      m3290pa_autobaud_uart0_noled_pr
 * m325_autobaud_uart0_noled         m325_autobaud_uart0_noled_pr      m325a_autobaud_uart0_noled
 * m325a_autobaud_uart0_noled_pr     m325p_autobaud_uart0_noled        m325p_autobaud_uart0_noled_pr
 * m325pa_autobaud_uart0_noled       m325pa_autobaud_uart0_noled_pr    m3250_autobaud_uart0_noled
 * m3250_autobaud_uart0_noled_pr     m3250a_autobaud_uart0_noled       m3250a_autobaud_uart0_noled_pr
 * m3250p_autobaud_uart0_noled       m3250p_autobaud_uart0_noled_pr    m3250pa_autobaud_uart0_noled
 * m3250pa_autobaud_uart0_noled_pr
 */
static const uint64_t ur_m329_autobaud_uart0_noled[] = {
  0xc4b777777759bb37, 0xdddddddd55f85f9b, 0xeea41b4de0fab68c, 0x0bcd875e35f67eee, 0x04316ef2776c7b21,
  0xe879feea609f1809, 0xd022054f848f5ff7, 0xaa4d7ce1cc05d221, 0x24386d1bdaa3857e, 0xf06693d47afe77cb,
  0x16f74d6b54b8e3a7, 0x5cec691199e398b0, 0xac86adc72c608ebc, 0x9ce166fc0c4ad7b0, 0x5bcde0e4ac077ad7,
  0x7f36ea5ab94a5f38, 0x744099f14085a771, 0x84b997cdb4e31bc6, 0x2068fe3458f386ed, 0xc33d30ae4fdd598f,
  0xe9296cb25138cb25, 0xb8f9e4afdcd0ccb0, 0x000000001c440926,
};

/*
 * m329a_autobaud_uart0_noled_pr_u4  m329p_autobaud_uart0_noled_pr_u4  m329pa_autobaud_uart0_noled_pr_u4
 * m3290_autobaud_uart0_noled_pr_u4  m3290a_autobaud_uart0_noled_pr_u4 m3290p_autobaud_uart0_noled_pr_u4
 * m3290pa_autobaud_uart0_noled_pr_u4 m325_autobaud_uart0_noled_pr_u4
 * m325a_autobaud_uart0_noled_pr_u4  m325p_autobaud_uart0_noled_pr_u4  m325pa_autobaud_uart0_noled_pr_u4
 * m3250_autobaud_uart0_noled_pr_u4  m3250a_autobaud_uart0_noled_pr_u4 m3250p_autobaud_uart0_noled_pr_u4
 * m3250pa_autobaud_uart0_noled_pr_u4
 */
static const uint64_t ur_m329_autobaud_uart0_noled_pr_u4[] = {
  0x6eeeeeed1222e59b, 0xbbbbbaabf0bedb89, 0xf4bc7cc982fdb1fb, 0x1c00f26eeedc4e1f, 0x93bbc962732193aa,
  0xf304f8c048218b77, 0x7c25d47f9e059fdb, 0x0e602e910e81102a, 0xded51c2bf5526be7, 0x51fa03be5843c368,
  0xefb5a38e9fc1a0bf, 0xe8f58731602cb299, 0x7fecc11d7a3e76af, 0x81e59ed8fb33ca80, 0x0b37e06256bd838f,
  0xe01f50603bd6bce7, 0xd54e5e5363385bcd, 0x4b0b9c6378ce8815, 0x9b6249156f62aa8b, 0x8b9357079b09732f,
  0xab31e40fca1a2c6f, 0x787bde50c2a73f53, 0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34,
  0xcd0ccb0e9296cf81, 0x61afaa22029e4afd, 0x0000000000000004,
};

/*
 * m329_autobaud_uart0_noled_pr_ee_u4 m329a_autobaud_uart0_noled_pr_ee
 * m329a_autobaud_uart0_noled_pr_ee_u4 m329p_autobaud_uart0_noled_pr_ee
 * m329p_autobaud_uart0_noled_pr_ee_u4 m329pa_autobaud_uart0_noled_pr_ee
 * m329pa_autobaud_uart0_noled_pr_ee_u4 m3290_autobaud_uart0_noled_pr_ee
 * m3290_autobaud_uart0_noled_pr_ee_u4 m3290a_autobaud_uart0_noled_pr_ee
 * m3290a_autobaud_uart0_noled_pr_ee_u4 m3290p_autobaud_uart0_noled_pr_ee
 * m3290p_autobaud_uart0_noled_pr_ee_u4 m3290pa_autobaud_uart0_noled_pr_ee
 * m3290pa_autobaud_uart0_noled_pr_ee_u4 m325_autobaud_uart0_noled_pr_ee
 * m325_autobaud_uart0_noled_pr_ee_u4 m325a_autobaud_uart0_noled_pr_ee
 * m325a_autobaud_uart0_noled_pr_ee_u4 m325p_autobaud_uart0_noled_pr_ee
 * m325p_autobaud_uart0_noled_pr_ee_u4 m325pa_autobaud_uart0_noled_pr_ee
 * m325pa_autobaud_uart0_noled_pr_ee_u4 m3250_autobaud_uart0_noled_pr_ee
 * m3250_autobaud_uart0_noled_pr_ee_u4 m3250a_autobaud_uart0_noled_pr_ee
 * m3250a_autobaud_uart0_noled_pr_ee_u4 m3250p_autobaud_uart0_noled_pr_ee
 * m3250p_autobaud_uart0_noled_pr_ee_u4 m3250pa_autobaud_uart0_noled_pr_ee
 * m3250pa_autobaud_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m329_autobaud_uart0_noled_pr_ee[] = {
  0x96eeeeeed1222a20, 0xbbbbbbaab8bf8d38, 0xb3f60cf1d91fd34b, 0x5c9083236b778f8d, 0xe8f62d51c635040f,
  0x13e30120862dde4e, 0x295dfe78167f674c, 0x01748874088153e1, 0xa8e15faa935f3873, 0x26ab5a39c61b46f6,
  0xc1b30698fa8f2b91, 0x5a1143be2beebd47, 0x35f4616588a459a7, 0x3ab4bce2b8d64d21, 0x3af3a6edbda3c167,
  0x28e791871b1aad74, 0xb70decb65cc5c242, 0x801512a6951b047e, 0xbce70b37e06256bd, 0x5bcde01f50603bd6,
  0x8815d54e5e536338, 0xaa8b4b0b9c6378ce, 0x732f9b6249156f62, 0x2c6f8b9357079b09, 0x3f53ab31e40fca1a,
  0x27ff787bde50c2a7, 0x343cc9fe07f197e6, 0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30, 0x4afdcd0ccb0e9296,
  0x00026a726822029e,
};

/*
 * m329_autobaud_uart0_noled_pr_ce_u4 m329a_autobaud_uart0_noled_pr_ce
 * m329a_autobaud_uart0_noled_pr_ce_u4 m329p_autobaud_uart0_noled_pr_ce
 * m329p_autobaud_uart0_noled_pr_ce_u4 m329pa_autobaud_uart0_noled_pr_ce
 * m329pa_autobaud_uart0_noled_pr_ce_u4 m3290_autobaud_uart0_noled_pr_ce
 * m3290_autobaud_uart0_noled_pr_ce_u4 m3290a_autobaud_uart0_noled_pr_ce
 * m3290a_autobaud_uart0_noled_pr_ce_u4 m3290p_autobaud_uart0_noled_pr_ce
 * m3290p_autobaud_uart0_noled_pr_ce_u4 m3290pa_autobaud_uart0_noled_pr_ce
 * m3290pa_autobaud_uart0_noled_pr_ce_u4 m325_autobaud_uart0_noled_pr_ce
 * m325_autobaud_uart0_noled_pr_ce_u4 m325a_autobaud_uart0_noled_pr_ce
 * m325a_autobaud_uart0_noled_pr_ce_u4 m325p_autobaud_uart0_noled_pr_ce
 * m325p_autobaud_uart0_noled_pr_ce_u4 m325pa_autobaud_uart0_noled_pr_ce
 * m325pa_autobaud_uart0_noled_pr_ce_u4 m3250_autobaud_uart0_noled_pr_ce
 * m3250_autobaud_uart0_noled_pr_ce_u4 m3250a_autobaud_uart0_noled_pr_ce
 * m3250a_autobaud_uart0_noled_pr_ce_u4 m3250p_autobaud_uart0_noled_pr_ce
 * m3250p_autobaud_uart0_noled_pr_ce_u4 m3250pa_autobaud_uart0_noled_pr_ce
 * m3250pa_autobaud_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m329_autobaud_uart0_noled_pr_ce[] = {
  0x2ddddddda2447705, 0xeeeeeeaaf49fc5f1, 0x44d85a331a0ba106, 0x6967ef1deeeed08c, 0xbc9ddb0db2bc8a4c,
  0x569827c602410c5b, 0xa7c2450ffcf02cfe, 0x70e602e910e81102, 0x8ded51c2bf5526be, 0x54edfcb8beb92436,
  0xc2445f71258f3c02, 0xfe620fd47c25f886, 0xcb19fac99e2ee371, 0x74fe0f59ea393d3d, 0xd61cc580a3e7491c,
  0xb33c75e8f9dabfa3, 0xe5adc3eccf2a01ff, 0x37e06256bd838f81, 0x1f50603bd6bce70b, 0x4e5e5363385bcde0,
  0x0b9c6378ce8815d5, 0xc490c76f62aa8b4b, 0x26ae0f3612e65f36, 0x63c81f943458df17, 0xf7bca1854e7ea756,
  0xfc0fe32fcc4ffef0, 0x5fe07efd86687993, 0x964b867a617c68f4, 0x19961d252d9f0271, 0x5e6dc4053c95fb9a,
  0x00000000000008dd,
};

/*
 * m329a_autobaud_uart0_noled_pr_ee_ce m329p_autobaud_uart0_noled_pr_ee_ce
 * m329pa_autobaud_uart0_noled_pr_ee_ce m3290_autobaud_uart0_noled_pr_ee_ce
 * m3290a_autobaud_uart0_noled_pr_ee_ce m3290p_autobaud_uart0_noled_pr_ee_ce
 * m3290pa_autobaud_uart0_noled_pr_ee_ce m325_autobaud_uart0_noled_pr_ee_ce
 * m325a_autobaud_uart0_noled_pr_ee_ce m325p_autobaud_uart0_noled_pr_ee_ce
 * m325pa_autobaud_uart0_noled_pr_ee_ce m3250_autobaud_uart0_noled_pr_ee_ce
 * m3250a_autobaud_uart0_noled_pr_ee_ce m3250p_autobaud_uart0_noled_pr_ee_ce
 * m3250pa_autobaud_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m329_autobaud_uart0_noled_pr_ee_ce[] = {
  0x12dddddddd4458e2, 0xeeeeeeeaaf1a0a67, 0x6d71b4537624760d, 0x4b42cb2ab4dd85ea, 0xe94e1ec1b8eb74ee,
  0x13e30120862dde4e, 0x416bfcf02cf8cdcc, 0x02e910e81102a7c2, 0x51c2bf5526be70e6, 0x1dff546fe4368ded,
  0xed0fbf3c0254ef02, 0x6563df309cee371a, 0x35afea3cafa894ed, 0x0a62b09fea3e0d98, 0x16588a459a75a114,
  0x576e9c4752135f46, 0x5e74ddb7b4782ce7, 0x39e461c6c6abc6c7, 0xc37b2d973170908a, 0xb3a254d2a3608991,
  0x9ce166fc0c4ad7b0, 0x79bc03ea0c077ad7, 0x02baa9cbca6c670b, 0x516961738c6f19d1, 0xcbe6d89218edec55,
  0x163ce2e4d5c6c25c, 0xe4fdd598f207e50d, 0x25138cb25c33d30a, 0xfdcd0ccb0e9296cb, 0x02b369f5e2029e4a,
};

/*
 * m329a_autobaud_uart0_noled_pr_ee_ce_u4 m329p_autobaud_uart0_noled_pr_ee_ce_u4
 * m329pa_autobaud_uart0_noled_pr_ee_ce_u4 m3290_autobaud_uart0_noled_pr_ee_ce_u4
 * m3290a_autobaud_uart0_noled_pr_ee_ce_u4 m3290p_autobaud_uart0_noled_pr_ee_ce_u4
 * m3290pa_autobaud_uart0_noled_pr_ee_ce_u4 m325_autobaud_uart0_noled_pr_ee_ce_u4
 * m325a_autobaud_uart0_noled_pr_ee_ce_u4 m325p_autobaud_uart0_noled_pr_ee_ce_u4
 * m325pa_autobaud_uart0_noled_pr_ee_ce_u4 m3250_autobaud_uart0_noled_pr_ee_ce_u4
 * m3250a_autobaud_uart0_noled_pr_ee_ce_u4 m3250p_autobaud_uart0_noled_pr_ee_ce_u4
 * m3250pa_autobaud_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_autobaud_uart0_noled_pr_ee_ce_u4[] = {
  0x2ddddddda2435f41, 0x7777775573c14671, 0x6ec48f4eb23a1bb7, 0x6277d3c3f006ead0, 0x3bb45fddb62ae264,
  0x304f8c048218b779, 0x253b7ff62bb3f5bf, 0x602e910e81102a7c, 0xd51c2bf5526be70e, 0x1b8bea8e43c368de,
  0xee24b1e79b680e1c, 0xfa8f84bf10d8488b, 0xf99e2ee373a3ea49, 0xa3cafa894ed6e6de, 0x09fea3e0d9835afe,
  0xa459a75a1140a62b, 0xc4752135f4616588, 0xdb7b4782ce7576e9, 0x1c6c6abc6c75e74d, 0xd973170908a39e46,
  0x4d2a3608991c37b2, 0x6fc0c4ad7b0b3a25, 0x3ea0c077ad79ce16, 0x9cbca6c670b79bc0, 0x1738c6f19d102baa,
  0x89218edec5551696, 0x7c371e6c25ccbe6d, 0x9d599bf83bb8d163, 0xfbc3def2861539fa, 0xe64ff03f8cbf313f,
  0xa3d17f81fbf619a1, 0x09c6592e19e985f1, 0xee6866587494b67c, 0x20886e41ba2cf257,
};

/*
 * m329a_autobaud_uart0_noled_ee_hw  m329p_autobaud_uart0_noled_ee_hw  m329pa_autobaud_uart0_noled_ee_hw
 * m3290_autobaud_uart0_noled_ee_hw  m3290a_autobaud_uart0_noled_ee_hw m3290p_autobaud_uart0_noled_ee_hw
 * m3290pa_autobaud_uart0_noled_ee_hw m325_autobaud_uart0_noled_ee_hw
 * m325a_autobaud_uart0_noled_ee_hw  m325p_autobaud_uart0_noled_ee_hw  m325pa_autobaud_uart0_noled_ee_hw
 * m3250_autobaud_uart0_noled_ee_hw  m3250a_autobaud_uart0_noled_ee_hw m3250p_autobaud_uart0_noled_ee_hw
 * m3250pa_autobaud_uart0_noled_ee_hw
 */
static const uint64_t ur_m329_autobaud_uart0_noled_ee_hw[] = {
  0x96eeeeeed121be4a, 0xbbbbbbaab8bf8d38, 0x1b67ec19e3bd23fb, 0x1eb9210646d6ef1f, 0x793ba528eb6abe08,
  0x9d304f8c048218b7, 0x53e1295dff4299fd, 0x3873017488740881, 0x46f6a8e15faa935f, 0x2b9126ab5a39c61b,
  0xbd47c1b30698fa8f, 0x59a75a1143be2bee, 0x4d2135f4616588a4, 0xc1673ab4bce2b8d6, 0xad743af3a6edbda3,
  0xc24228e791871b1a, 0x047eb70decb65cc5, 0x56bd801512a6951b, 0x3bd6bce70b37e062, 0x63385bcde01f5060,
  0x78ce8815d54e5e53, 0x6f62aa8b4b0b9c63, 0x9b09732f9b624915, 0x50c2a73f505d8dc7, 0xf197e627ff787bde,
  0x3f7ec3343cc9fe07, 0xc33d30be347a2ff0, 0x0e9296cf8138cb25, 0x93a29e4afdcd0ccb, 0x00000000002c4f7c,
};

/*
 * m329_autobaud_uart0_noled_ee_ce_u4_hw m329a_autobaud_uart0_noled_ee_ce_hw
 * m329a_autobaud_uart0_noled_ee_ce_u4_hw m329p_autobaud_uart0_noled_ee_ce_hw
 * m329p_autobaud_uart0_noled_ee_ce_u4_hw m329pa_autobaud_uart0_noled_ee_ce_hw
 * m329pa_autobaud_uart0_noled_ee_ce_u4_hw m3290_autobaud_uart0_noled_ee_ce_hw
 * m3290_autobaud_uart0_noled_ee_ce_u4_hw m3290a_autobaud_uart0_noled_ee_ce_hw
 * m3290a_autobaud_uart0_noled_ee_ce_u4_hw m3290p_autobaud_uart0_noled_ee_ce_hw
 * m3290p_autobaud_uart0_noled_ee_ce_u4_hw m3290pa_autobaud_uart0_noled_ee_ce_hw
 * m3290pa_autobaud_uart0_noled_ee_ce_u4_hw m325_autobaud_uart0_noled_ee_ce_hw
 * m325_autobaud_uart0_noled_ee_ce_u4_hw m325a_autobaud_uart0_noled_ee_ce_hw
 * m325a_autobaud_uart0_noled_ee_ce_u4_hw m325p_autobaud_uart0_noled_ee_ce_hw
 * m325p_autobaud_uart0_noled_ee_ce_u4_hw m325pa_autobaud_uart0_noled_ee_ce_hw
 * m325pa_autobaud_uart0_noled_ee_ce_u4_hw m3250_autobaud_uart0_noled_ee_ce_hw
 * m3250_autobaud_uart0_noled_ee_ce_u4_hw m3250a_autobaud_uart0_noled_ee_ce_hw
 * m3250a_autobaud_uart0_noled_ee_ce_u4_hw m3250p_autobaud_uart0_noled_ee_ce_hw
 * m3250p_autobaud_uart0_noled_ee_ce_u4_hw m3250pa_autobaud_uart0_noled_ee_ce_hw
 * m3250pa_autobaud_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_autobaud_uart0_noled_ee_ce_hw[] = {
  0x5bbbbbbb44864c7f, 0xeeeeeeaae7828ce2, 0xdd891e9d6474376e, 0xc4efa787e00dd5a0, 0x93bbd7773b6abcc8,
  0xf304f8c048218b77, 0xf84a76ffe8533f5b, 0x1cc05d221d022054, 0xbdaa3857eaa4d7ce, 0x383717d51c8786d1,
  0x17dc4963cf36d01c, 0x47f51f097e21b091, 0xdef99e2ee3712a2e, 0xfea3cafa894ed6e6, 0x2b09fea3e0d9835a,
  0x88a459a75a1140a6, 0xe9c4752135f46165, 0x4ddb7b4782ce7576, 0x461c6c6abc6c75e7, 0xb2d973170908a39e,
  0x254d2a3608991c37, 0x166fc0c4ad7b0b3a, 0xc03ea0c077ad79ce, 0xaa9cbca6c670b79b, 0x961738c6f19d102b,
  0x6d89218edec55516, 0x4176371e6c25ccbe, 0xfde1ef79430a9cfd, 0xf327f81fc65f989f, 0xd1e8bfc0fdfb0cd0,
  0x04e32c970cf4c2f8, 0xf734332c3a4a5b3e, 0x0025486e428a792b,
};

/*
 * m329a_autobaud_uart0_lednop       m329p_autobaud_uart0_lednop       m329pa_autobaud_uart0_lednop
 * m3290_autobaud_uart0_lednop       m3290a_autobaud_uart0_lednop      m3290p_autobaud_uart0_lednop
 * m3290pa_autobaud_uart0_lednop     m325_autobaud_uart0_lednop        m325a_autobaud_uart0_lednop
 * m325p_autobaud_uart0_lednop       m325pa_autobaud_uart0_lednop      m3250_autobaud_uart0_lednop
 * m3250a_autobaud_uart0_lednop      m3250p_autobaud_uart0_lednop      m3250pa_autobaud_uart0_lednop
 */
static const uint64_t ur_m329_autobaud_uart0_lednop[] = {
  0x44b777777759bb37, 0xfdddddddd55f85c6, 0x520da3afad3c4ef8, 0xd36200db69177777, 0x8218b7793bb63d90,
  0xf43cfc89304f8c04, 0xe81102a7c25a57fb, 0x5526be70e602e910, 0x921c368ded51c2bf, 0xfc19a4f51c9e3be5,
  0x02dee987ce9238e9, 0x2e766be4720a7316, 0x2b07dee39630475e, 0x013859bf0312b5ec, 0x9b228301deb5e781,
  0x6f529c94e8016f37, 0xe9c6378ce881df2a, 0xb9c8ab7b15545a6a, 0xcfec376c25ccbe6d, 0x38cb25c33d30ae4f,
  0xd0ccb0e9296cb251, 0x98bf5eb8f9e4afdc, 0x0000000000000035,
};

/*
 * m329_autobaud_uart0_lednop_pr_u4  m329a_autobaud_uart0_lednop_pr    m329a_autobaud_uart0_lednop_pr_u4
 * m329p_autobaud_uart0_lednop_pr    m329p_autobaud_uart0_lednop_pr_u4 m329pa_autobaud_uart0_lednop_pr
 * m329pa_autobaud_uart0_lednop_pr_u4 m3290_autobaud_uart0_lednop_pr
 * m3290_autobaud_uart0_lednop_pr_u4 m3290a_autobaud_uart0_lednop_pr
 * m3290a_autobaud_uart0_lednop_pr_u4 m3290p_autobaud_uart0_lednop_pr
 * m3290p_autobaud_uart0_lednop_pr_u4 m3290pa_autobaud_uart0_lednop_pr
 * m3290pa_autobaud_uart0_lednop_pr_u4 m325_autobaud_uart0_lednop_pr
 * m325_autobaud_uart0_lednop_pr_u4  m325a_autobaud_uart0_lednop_pr    m325a_autobaud_uart0_lednop_pr_u4
 * m325p_autobaud_uart0_lednop_pr    m325p_autobaud_uart0_lednop_pr_u4 m325pa_autobaud_uart0_lednop_pr
 * m325pa_autobaud_uart0_lednop_pr_u4 m3250_autobaud_uart0_lednop_pr
 * m3250_autobaud_uart0_lednop_pr_u4 m3250a_autobaud_uart0_lednop_pr
 * m3250a_autobaud_uart0_lednop_pr_u4 m3250p_autobaud_uart0_lednop_pr
 * m3250p_autobaud_uart0_lednop_pr_u4 m3250pa_autobaud_uart0_lednop_pr
 * m3250pa_autobaud_uart0_lednop_pr_u4
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_pr[] = {
  0xb77777768911259b, 0xdddddd55f85cb8c4, 0xedbf4a9171debd3d, 0xff1fe2f7776e270f, 0x4eecbbb120ce05c2,
  0xcc13e30120862dde, 0xf09775fe78167e3d, 0x3980ba443a0440a9, 0x7b5470afd549af9c, 0x47b58ef9610f0da3,
  0x241f8e3a7f0682fd, 0x1a43398b016594df, 0xfd9823af47cecb3d, 0x3cb3db416691500f, 0x66fc0c4ad7b20ad0,
  0x0c077ad79e0404e1, 0x7253a005bcde6c8a, 0xde33a2077ca9bd4a, 0xadec555169aba718, 0x79b09732f9b6e722,
  0xfca1a2c6f8b93570, 0x0c2a73f53ab31e40, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03,
  0xe9296cf8138cb25c, 0x2029e4afdcd0ccb0, 0x000000004618202e,
};

/*
 * m329a_autobaud_uart0_lednop_pr_ee m329p_autobaud_uart0_lednop_pr_ee m329pa_autobaud_uart0_lednop_pr_ee
 * m3290_autobaud_uart0_lednop_pr_ee m3290a_autobaud_uart0_lednop_pr_ee
 * m3290p_autobaud_uart0_lednop_pr_ee m3290pa_autobaud_uart0_lednop_pr_ee
 * m325_autobaud_uart0_lednop_pr_ee  m325a_autobaud_uart0_lednop_pr_ee m325p_autobaud_uart0_lednop_pr_ee
 * m325pa_autobaud_uart0_lednop_pr_ee m3250_autobaud_uart0_lednop_pr_ee
 * m3250a_autobaud_uart0_lednop_pr_ee m3250p_autobaud_uart0_lednop_pr_ee
 * m3250pa_autobaud_uart0_lednop_pr_ee
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_pr_ee[] = {
  0xddddddd0f5a22044, 0x7777755717fa0b12, 0x34cfda9bfa7a6277, 0xb210646d6ef1f1b6, 0x829395c1086d16a2,
  0xf8c048218b7793ba, 0x4dff9e059f1ad304, 0x5d221d022054f84b, 0x3857eaa4d7ce1cc0, 0xaad68e7186d1bdaa,
  0x6cc1a63ea3cacca9, 0x08a1df1587bf51f0, 0xfa30b2c4522cd3ad, 0x5a5cf55c6b26909a, 0xbce9bb4648c9a39d,
  0x09e46f6ac6ab5d0e, 0xc37b2d973170908a, 0x087d99e546c11fad, 0x13859bf0312b5ec0, 0xb228301deb5e7810,
  0xf529c94e8016f379, 0x9c6378ce881df2a6, 0x9c8ab7b15545a6ae, 0xd5c1e6c25ccbe6db, 0xc81f943459d3e2e4,
  0xfca1854e7ea75663, 0x0f327f8b9c65f989, 0x4c2b93f1cf7ff04d, 0xa5b3e04e32c970cf, 0xa792bf734332c3a4,
  0x0000004d4ee9e880,
};

/*
 * m329a_autobaud_uart0_lednop_pr_ee_u4 m329p_autobaud_uart0_lednop_pr_ee_u4
 * m329pa_autobaud_uart0_lednop_pr_ee_u4 m3290_autobaud_uart0_lednop_pr_ee_u4
 * m3290a_autobaud_uart0_lednop_pr_ee_u4 m3290p_autobaud_uart0_lednop_pr_ee_u4
 * m3290pa_autobaud_uart0_lednop_pr_ee_u4 m325_autobaud_uart0_lednop_pr_ee_u4
 * m325a_autobaud_uart0_lednop_pr_ee_u4 m325p_autobaud_uart0_lednop_pr_ee_u4
 * m325pa_autobaud_uart0_lednop_pr_ee_u4 m3250_autobaud_uart0_lednop_pr_ee_u4
 * m3250a_autobaud_uart0_lednop_pr_ee_u4 m3250p_autobaud_uart0_lednop_pr_ee_u4
 * m3250pa_autobaud_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_pr_ee_u4[] = {
  0x96eeeeeed1222582, 0xbbbbbbaab8bfb4b8, 0x537656da9b45d23f, 0x2f0a83236b74bdfa, 0xd3b410e5d96aa0b4,
  0x27c602410c5bbc9d, 0x595bfcf02cfe9b98, 0x02e910e81102a7c2, 0x51c2bf5526be70e6, 0xcd56b46be4368ded,
  0x0d983c8bea3cac27, 0xd08a1df15c89ea3e, 0xafa30b2c4522cd3a, 0x569797cb8a266909, 0x7aea6ec22a3e78e7,
  0x2bfa3d658d56ba1d, 0x0decb8723170908a, 0x0c4ad7b1703efeb7, 0x7ad79e0404e166fc, 0xa005bcde6c8a0c07,
  0xa2077ca9bd4a7253, 0x555169aba718de33, 0x9732f9b6e722adec, 0xa2c6f8b9357079b0, 0x73f53ab31e40fca1,
  0x627ff787bde50c2a, 0x3343cc9fe07f197e, 0x0be347a2ff03f7ec, 0x6cf8138cb25c33d3, 0xe4afdcd0ccb0e929,
  0x00004d4e48be2029,
};

/*
 * m329_autobaud_uart0_lednop_pr_ce_u4 m329a_autobaud_uart0_lednop_pr_ce
 * m329a_autobaud_uart0_lednop_pr_ce_u4 m329p_autobaud_uart0_lednop_pr_ce
 * m329p_autobaud_uart0_lednop_pr_ce_u4 m329pa_autobaud_uart0_lednop_pr_ce
 * m329pa_autobaud_uart0_lednop_pr_ce_u4 m3290_autobaud_uart0_lednop_pr_ce
 * m3290_autobaud_uart0_lednop_pr_ce_u4 m3290a_autobaud_uart0_lednop_pr_ce
 * m3290a_autobaud_uart0_lednop_pr_ce_u4 m3290p_autobaud_uart0_lednop_pr_ce
 * m3290p_autobaud_uart0_lednop_pr_ce_u4 m3290pa_autobaud_uart0_lednop_pr_ce
 * m3290pa_autobaud_uart0_lednop_pr_ce_u4 m325_autobaud_uart0_lednop_pr_ce
 * m325_autobaud_uart0_lednop_pr_ce_u4 m325a_autobaud_uart0_lednop_pr_ce
 * m325a_autobaud_uart0_lednop_pr_ce_u4 m325p_autobaud_uart0_lednop_pr_ce
 * m325p_autobaud_uart0_lednop_pr_ce_u4 m325pa_autobaud_uart0_lednop_pr_ce
 * m325pa_autobaud_uart0_lednop_pr_ce_u4 m3250_autobaud_uart0_lednop_pr_ce
 * m3250_autobaud_uart0_lednop_pr_ce_u4 m3250a_autobaud_uart0_lednop_pr_ce
 * m3250a_autobaud_uart0_lednop_pr_ce_u4 m3250p_autobaud_uart0_lednop_pr_ce
 * m3250p_autobaud_uart0_lednop_pr_ce_u4 m3250pa_autobaud_uart0_lednop_pr_ce
 * m3250pa_autobaud_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_pr_ce[] = {
  0x96eeeeeed1222044, 0x777777557a4fc338, 0x1c5e6c58fb23ad17, 0xeb8d3537bbbb4231, 0xf277505272e9c10d,
  0xea609f180904316e, 0x9f09604ff3c0b3f6, 0xc3980ba443a0440a, 0x37b5470afd549af9, 0xa7752ae2fae490da,
  0x1222fb892c79e012, 0x7e007ea3e12fc436, 0xb19fac99e2ee372b, 0x4fe0f59ea3f493dc, 0x19cc580a9888b1c7,
  0xcf1d7a3e7659e8d2, 0x6b720b348a807fec, 0xf81895af6415a079, 0x0ef5af3c0809c2cd, 0xa7400b79bcd91418,
  0x67440ef9537a94e4, 0xd8aaa2d3574e31bc, 0xc25ccbe6db9c31db, 0x868b1be2e4d5c1e6, 0xa9cfd4eacc7903f2,
  0xf989ffde1ef79430, 0xb0cd0f327f81fc65, 0x4c2f8d1e8bfc0fdf, 0xa5b3e04e32c970cf, 0xa792bf734332c3a4,
  0x0000008dd6aca880,
};

/*
 * m329a_autobaud_uart0_lednop_pr_ee_ce m329p_autobaud_uart0_lednop_pr_ee_ce
 * m329pa_autobaud_uart0_lednop_pr_ee_ce m3290_autobaud_uart0_lednop_pr_ee_ce
 * m3290a_autobaud_uart0_lednop_pr_ee_ce m3290p_autobaud_uart0_lednop_pr_ee_ce
 * m3290pa_autobaud_uart0_lednop_pr_ee_ce m325_autobaud_uart0_lednop_pr_ee_ce
 * m325a_autobaud_uart0_lednop_pr_ee_ce m325p_autobaud_uart0_lednop_pr_ee_ce
 * m325pa_autobaud_uart0_lednop_pr_ee_ce m3250_autobaud_uart0_lednop_pr_ee_ce
 * m3250a_autobaud_uart0_lednop_pr_ee_ce m3250p_autobaud_uart0_lednop_pr_ee_ce
 * m3250pa_autobaud_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_pr_ee_ce[] = {
  0x12dddddddd4477d6, 0xeeeeeeeaaf1a0583, 0x6e99ae36968cf51d, 0xbb080b2ab4dd85ea, 0x75eb4e2295f6848c,
  0x09f180904316ef27, 0x2b1fff3c0b3e1a26, 0x01748874088153e1, 0xa8e15faa935f3873, 0xceffaa37f21b46f6,
  0x49faff9e012a77be, 0x5958f7cc273b8dc1, 0x0d6bfa8f2beea53b, 0x0298af6ffa8f8366, 0x85962291669d6845,
  0xd5db8f51d484d7d1, 0xebce9bb4648c9a39, 0x413c8ded58d578d8, 0x386f65b2e62e1211, 0x2cc7d99e546c1132,
  0x013859bf0312b5ec, 0x9b228301deb5e781, 0x6f529c94e8016f37, 0xe9c6378ce881df2a, 0x73863b7b15545a6a,
  0x5c9ab8d84b997cdb, 0xb31e40fca1a2c79c, 0x964b867a615c9fba, 0x9961d252d964a271, 0x63fc4053c95fb9a1,
  0x0000000000002b37,
};

/*
 * m329a_autobaud_uart0_lednop_pr_ee_ce_u4 m329p_autobaud_uart0_lednop_pr_ee_ce_u4
 * m329pa_autobaud_uart0_lednop_pr_ee_ce_u4 m3290_autobaud_uart0_lednop_pr_ee_ce_u4
 * m3290a_autobaud_uart0_lednop_pr_ee_ce_u4 m3290p_autobaud_uart0_lednop_pr_ee_ce_u4
 * m3290pa_autobaud_uart0_lednop_pr_ee_ce_u4 m325_autobaud_uart0_lednop_pr_ee_ce_u4
 * m325a_autobaud_uart0_lednop_pr_ee_ce_u4 m325p_autobaud_uart0_lednop_pr_ee_ce_u4
 * m325pa_autobaud_uart0_lednop_pr_ee_ce_u4 m3250_autobaud_uart0_lednop_pr_ee_ce_u4
 * m3250a_autobaud_uart0_lednop_pr_ee_ce_u4 m3250p_autobaud_uart0_lednop_pr_ee_ce_u4
 * m3250pa_autobaud_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_pr_ee_ce_u4[] = {
  0x2ddddddda2436d3a, 0x7777775573c1c9d1, 0x6ed1989134ba52b7, 0xec4f91c3f006ead0, 0x776e76cd8f6c98cc,
  0x609f180904316ef2, 0x25883fec5767d0fa, 0x602e910e81102a7c, 0xd51c2bf5526be70e, 0xab8bea8e43c368de,
  0xee24b1e79b680e25, 0xfa8f84bf10d8488b, 0xf33c5dc6e0224c03, 0x4795f7529dadcdbd, 0xb7fd47c1b306b5fd,
  0x48b34eb422814c57, 0xa8ea426be8c2cb11, 0xda32464d1ceaedc7, 0xf6ac6abc6c75e74d, 0xd973170908a09e46,
  0xcf2a3608991c37b2, 0xdf81895af61663ec, 0x80ef5af3c0809c2c, 0x4a7400b79bcd9141, 0xc67440ef9537a94e,
  0xbd8aaa2d3574e31b, 0x6c25ccbe6db9c31d, 0xf83bb8d1637c371e, 0xf2861539fa9d599b, 0x3f8cbf313ffbc3de,
  0x81fbf619a1e64ff0, 0x2e19e985f1a3d17f, 0x587494b67c09c659, 0x95ba2cf257ee6866, 0x0000000000208996,
};

/*
 * m329a_autobaud_uart0_lednop_ee_hw m329p_autobaud_uart0_lednop_ee_hw m329pa_autobaud_uart0_lednop_ee_hw
 * m3290_autobaud_uart0_lednop_ee_hw m3290a_autobaud_uart0_lednop_ee_hw
 * m3290p_autobaud_uart0_lednop_ee_hw m3290pa_autobaud_uart0_lednop_ee_hw
 * m325_autobaud_uart0_lednop_ee_hw  m325a_autobaud_uart0_lednop_ee_hw m325p_autobaud_uart0_lednop_ee_hw
 * m325pa_autobaud_uart0_lednop_ee_hw m3250_autobaud_uart0_lednop_ee_hw
 * m3250a_autobaud_uart0_lednop_ee_hw m3250p_autobaud_uart0_lednop_ee_hw
 * m3250pa_autobaud_uart0_lednop_ee_hw
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_ee_hw[] = {
  0x96eeeeeed121af43, 0xbbbbbbaab8bfd058, 0x1b634cfda9bdfa7b, 0x6a2b210646d6ef1f, 0xf2775a77dadd94d1,
  0x5a609f180904316e, 0xa7c25a6ffe8533e3, 0x70e602e910e81102, 0x8ded51c2bf5526be, 0x56654d56b4738c36,
  0xfa8f83660d31f51e, 0x669d68450ef8ac3d, 0x3484d7d185962291, 0x4d1cead2e7aae359, 0x5ae875e74dda3246,
  0x8484504f237b5635, 0x08fd6e1bd96cb98b, 0x5af60043eccf2a36, 0xf3c0809c2cdf8189, 0xb79bcd914180ef5a,
  0xef9537a94e4a7400, 0x2d3574e31bc67440, 0x5f36dce455bd8aaa, 0x7ea0bb1b8f3612e6, 0x4ffef0f7bca1854e,
  0x687993fc0fe32fcc, 0x7c68f45fe07efd86, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x00002c4f00ad453c,
};

/*
 * m329_autobaud_uart0_lednop_ee_ce_u4_hw m329a_autobaud_uart0_lednop_ee_ce_hw
 * m329a_autobaud_uart0_lednop_ee_ce_u4_hw m329p_autobaud_uart0_lednop_ee_ce_hw
 * m329p_autobaud_uart0_lednop_ee_ce_u4_hw m329pa_autobaud_uart0_lednop_ee_ce_hw
 * m329pa_autobaud_uart0_lednop_ee_ce_u4_hw m3290_autobaud_uart0_lednop_ee_ce_hw
 * m3290_autobaud_uart0_lednop_ee_ce_u4_hw m3290a_autobaud_uart0_lednop_ee_ce_hw
 * m3290a_autobaud_uart0_lednop_ee_ce_u4_hw m3290p_autobaud_uart0_lednop_ee_ce_hw
 * m3290p_autobaud_uart0_lednop_ee_ce_u4_hw m3290pa_autobaud_uart0_lednop_ee_ce_hw
 * m3290pa_autobaud_uart0_lednop_ee_ce_u4_hw m325_autobaud_uart0_lednop_ee_ce_hw
 * m325_autobaud_uart0_lednop_ee_ce_u4_hw m325a_autobaud_uart0_lednop_ee_ce_hw
 * m325a_autobaud_uart0_lednop_ee_ce_u4_hw m325p_autobaud_uart0_lednop_ee_ce_hw
 * m325p_autobaud_uart0_lednop_ee_ce_u4_hw m325pa_autobaud_uart0_lednop_ee_ce_hw
 * m325pa_autobaud_uart0_lednop_ee_ce_u4_hw m3250_autobaud_uart0_lednop_ee_ce_hw
 * m3250_autobaud_uart0_lednop_ee_ce_u4_hw m3250a_autobaud_uart0_lednop_ee_ce_hw
 * m3250a_autobaud_uart0_lednop_ee_ce_u4_hw m3250p_autobaud_uart0_lednop_ee_ce_hw
 * m3250p_autobaud_uart0_lednop_ee_ce_u4_hw m3250pa_autobaud_uart0_lednop_ee_ce_hw
 * m3250pa_autobaud_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_autobaud_uart0_lednop_ee_ce_hw[] = {
  0x2ddddddda243173e, 0x7777775573c1c9d1, 0x6ed1989134ba52b7, 0xec4f91c3f006ead0, 0xc9ddcfb403a89ecc,
  0xe9827c602410c5bb, 0x3e12c41ff4299f43, 0x8730174887408815, 0x6f6a8e15faa935f3, 0x12d5c5f54721e1b4,
  0x45f71258f3cdb407, 0x72fd47c25f886c24, 0xb7be678bb8dca4a6, 0xbfa8f2beea53b5b9, 0x8af6ffa8f83660d6,
  0x62291669d6845029, 0xb8f51d484d7d1859, 0xe9bb4648c9a39d5d, 0xc8ded58d578d8ebc, 0xf65b2e62e1211413,
  0x7d99e546c1132386, 0x859bf0312b5ec2cc, 0x28301deb5e781013, 0x29c94e8016f379b2, 0x6378ce881df2a6f5,
  0x63b7b15545a6ae9c, 0xe3cd84b997cdb738, 0xef2861539fa82ec6, 0x03f8cbf313ffbc3d, 0xf81fbf619a1e64ff,
  0x92e19e985f1a3d17, 0x6587494b67c09c65, 0x32d2d14f257ee686, 0x00000000000004a9,
};

/*
 * m329_autobaud_uart0_dual_pr       m329_autobaud_uart0_dual_pr_u4    m329a_autobaud_uart0_dual
 * m329a_autobaud_uart0_dual_pr      m329a_autobaud_uart0_dual_pr_u4   m329p_autobaud_uart0_dual
 * m329p_autobaud_uart0_dual_pr      m329p_autobaud_uart0_dual_pr_u4   m329pa_autobaud_uart0_dual
 * m329pa_autobaud_uart0_dual_pr     m329pa_autobaud_uart0_dual_pr_u4  m3290_autobaud_uart0_dual
 * m3290_autobaud_uart0_dual_pr      m3290_autobaud_uart0_dual_pr_u4   m3290a_autobaud_uart0_dual
 * m3290a_autobaud_uart0_dual_pr     m3290a_autobaud_uart0_dual_pr_u4  m3290p_autobaud_uart0_dual
 * m3290p_autobaud_uart0_dual_pr     m3290p_autobaud_uart0_dual_pr_u4  m3290pa_autobaud_uart0_dual
 * m3290pa_autobaud_uart0_dual_pr    m3290pa_autobaud_uart0_dual_pr_u4 m325_autobaud_uart0_dual
 * m325_autobaud_uart0_dual_pr       m325_autobaud_uart0_dual_pr_u4    m325a_autobaud_uart0_dual
 * m325a_autobaud_uart0_dual_pr      m325a_autobaud_uart0_dual_pr_u4   m325p_autobaud_uart0_dual
 * m325p_autobaud_uart0_dual_pr      m325p_autobaud_uart0_dual_pr_u4   m325pa_autobaud_uart0_dual
 * m325pa_autobaud_uart0_dual_pr     m325pa_autobaud_uart0_dual_pr_u4  m3250_autobaud_uart0_dual
 * m3250_autobaud_uart0_dual_pr      m3250_autobaud_uart0_dual_pr_u4   m3250a_autobaud_uart0_dual
 * m3250a_autobaud_uart0_dual_pr     m3250a_autobaud_uart0_dual_pr_u4  m3250p_autobaud_uart0_dual
 * m3250p_autobaud_uart0_dual_pr     m3250p_autobaud_uart0_dual_pr_u4  m3250pa_autobaud_uart0_dual
 * m3250pa_autobaud_uart0_dual_pr    m3250pa_autobaud_uart0_dual_pr_u4
 */
static const uint64_t ur_m329_autobaud_uart0_dual[] = {
  0x5bbbbbbb4486dd9e, 0xeeeeeedf8d4fed1b, 0xa71d6414ccf59f6e, 0xd3924c765bbbab8f, 0x20770fcabdd17ae2,
  0x09f180904316ef24, 0xd6d0322525214926, 0xb881850c1b48c0dd, 0x5bafccae833ba7c4, 0x4760bb0c087095d3,
  0x508e489fc19c39bd, 0x3e144312bfcfdf04, 0xaeef77cdc7f800dc, 0xe8a8432d0d2910ca, 0x6ddd2ffd01cf09a6,
  0xf735e60b0de57909, 0x21d022054f849fcf, 0x7eaa4d7ce1cc05d2, 0xe589a86d1bdaa385, 0xd3f8310fea3e453b,
  0x580aa0f34e2f7c71, 0x78033b5ac8ebf9cc, 0x87486a807fecc11d, 0xe2a4aa4e81e59ed8, 0x0c4ad7b27f157cee,
  0x7ad79e0404e166fc, 0xa005bcde6c8a0c07, 0xa2077ca9bd4a7253, 0x555169aba718de33, 0x9732f9b6e722adec,
  0xeee3458df0dc79b0, 0x1854e7ea75666fe0, 0x32fcc4ffef0f7bca, 0xefd86687993fc0fe, 0x67a617c68f45fe07,
  0xd252d9f0271964b8, 0xe8b3c95fb9a19961, 0x00000000b82a0e36,
};

/*
 * m329a_autobaud_uart0_dual_pr_ee   m329p_autobaud_uart0_dual_pr_ee   m329pa_autobaud_uart0_dual_pr_ee
 * m3290_autobaud_uart0_dual_pr_ee   m3290a_autobaud_uart0_dual_pr_ee  m3290p_autobaud_uart0_dual_pr_ee
 * m3290pa_autobaud_uart0_dual_pr_ee m325_autobaud_uart0_dual_pr_ee    m325a_autobaud_uart0_dual_pr_ee
 * m325p_autobaud_uart0_dual_pr_ee   m325pa_autobaud_uart0_dual_pr_ee  m3250_autobaud_uart0_dual_pr_ee
 * m3250a_autobaud_uart0_dual_pr_ee  m3250p_autobaud_uart0_dual_pr_ee  m3250pa_autobaud_uart0_dual_pr_ee
 */
static const uint64_t ur_m329_autobaud_uart0_dual_pr_ee[] = {
  0xadddddddd41432db, 0x7777776fc3f75c4d, 0x5f05947d3ef5c2f7, 0xcd8eba9be9dbb619, 0x1c115658219d210e,
  0x0120862dde49ba77, 0xc8949481544c13e3, 0x14306d2303775b40, 0x32ba0cee9f12e206, 0xb0c40706bb990fbf,
  0x89fc18689bd477f9, 0x312bfcfdf04508e4, 0xf37011200dc3e144, 0x9686044432abbbdd, 0xfd01cf098bac5421,
  0x0b0de579096dffe7, 0x0a9f0913aff735e6, 0xf9c3980ba443a044, 0xda37b5470afd549a, 0xf2b5f7355ad1c890,
  0x2bd47c1b3060a7a8, 0x8b34eb422877c575, 0xb9a426be8c2cb114, 0xf7b39d5a5cca5c54, 0xab5d0ebd44bb4428,
  0xb84845022a3e7ac6, 0xc11fadc37b2fa598, 0xdc54940213fac546, 0x81895af64fe2af9d, 0xef5af3c0809c2cdf,
  0x7400b79bcd914180, 0x7440ef9537a94e4a, 0x8aaa2d3574e31bc6, 0x12e65f36dce455bd, 0xeee34596af1b8f36,
  0x1854e7ea75666fe0, 0x1f343cc9fe04e34a, 0x32c970cf4c2b93f0, 0x4332c3a4a5b3e04e, 0x90ad4dd16792bf73,
  0x000000000000014a,
};

/*
 * m329a_autobaud_uart0_dual_pr_ee_u4 m329p_autobaud_uart0_dual_pr_ee_u4
 * m329pa_autobaud_uart0_dual_pr_ee_u4 m3290_autobaud_uart0_dual_pr_ee_u4
 * m3290a_autobaud_uart0_dual_pr_ee_u4 m3290p_autobaud_uart0_dual_pr_ee_u4
 * m3290pa_autobaud_uart0_dual_pr_ee_u4 m325_autobaud_uart0_dual_pr_ee_u4
 * m325a_autobaud_uart0_dual_pr_ee_u4 m325p_autobaud_uart0_dual_pr_ee_u4
 * m325pa_autobaud_uart0_dual_pr_ee_u4 m3250_autobaud_uart0_dual_pr_ee_u4
 * m3250a_autobaud_uart0_dual_pr_ee_u4 m3250p_autobaud_uart0_dual_pr_ee_u4
 * m3250pa_autobaud_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m329_autobaud_uart0_dual_pr_ee_u4[] = {
  0x36b7777776890c86, 0xbbbbbbbb7e1fbdfb, 0xa520adb178d5b5df, 0x0b201a2f537d3b74, 0x25dddd8dd9683cc5,
  0x4f8c048218b77936, 0xda0644a4a4271f30, 0x1030a18369181bba, 0x41f995d06774f897, 0xe1a361a68e0ff26c,
  0x239227f0763f37a8, 0x8510c4aff3f7c114, 0x77bbe6e52500370f, 0xa8432d0296886557, 0xddaffa039e137ce8,
  0xd7982c3795e425b7, 0x022054f84babffdc, 0xa4d7ce1cc05d221d, 0x4a86d1bdaa3857ea, 0x3d4795c7b9aad68f,
  0x15c89ea3e0d983f9, 0xc4522cd3ad08a1df, 0x7082e6909afa30b2, 0x22a3e90e75697d29, 0xec6ab5d0ebdac4ec,
  0xc62e1211457f4752, 0xab81f7f5b86f65c7, 0xd7b27f157ceee2a4, 0x9e0404e166fc0c4a, 0x6f3796ea0c077ad7,
  0xdf2a6f529c94e801, 0xd1023a8a042d380b, 0x12e65f36d38c6f19, 0x1ddc68b1be1b8f36, 0x430a9cfd4eaccdfc,
  0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97, 0xdd16792bf734332c,
  0x00000000052a4814,
};

/*
 * m329a_autobaud_uart0_dual_pr_ce   m329p_autobaud_uart0_dual_pr_ce   m329pa_autobaud_uart0_dual_pr_ce
 * m3290_autobaud_uart0_dual_pr_ce   m3290a_autobaud_uart0_dual_pr_ce  m3290p_autobaud_uart0_dual_pr_ce
 * m3290pa_autobaud_uart0_dual_pr_ce m325_autobaud_uart0_dual_pr_ce    m325a_autobaud_uart0_dual_pr_ce
 * m325p_autobaud_uart0_dual_pr_ce   m325pa_autobaud_uart0_dual_pr_ce  m3250_autobaud_uart0_dual_pr_ce
 * m3250a_autobaud_uart0_dual_pr_ce  m3250p_autobaud_uart0_dual_pr_ce  m3250pa_autobaud_uart0_dual_pr_ce
 */
static const uint64_t ur_m329_autobaud_uart0_dual_pr_ce[] = {
  0x5bbbbbba1eb432db, 0x7777776fc361009b, 0xb15cea2f2d5b9337, 0xaeec2c9f7bbba539, 0x322ee3822ac69e33,
  0x827c602410c5bbc9, 0xd6d032252523d6a9, 0xb881850c1b48c0dd, 0xb5bfccae833ba7c4, 0x7ddad826d9c276e6,
  0x11c913f8331f9bd4, 0xc2886257f9fbe08a, 0xbbddf3719c801b87, 0x54219681754432ab, 0xc2d7fd01cf0992b4,
  0x35e60b0de579096d, 0xa0440a9f096ceff7, 0x549af9c3980ba443, 0xa010da37b5470afd, 0x79e6da038e96e2fa,
  0x2fc4361222fb892c, 0xee3731035dfea3e1, 0x6fcf72c67d4b99e2, 0xf238e9fc1d4bf51c, 0x591d7f398b014141,
  0x0ffd99e3af00676b, 0x740f2d6e10e90d50, 0x93f8abe777152552, 0x20270b37e06256bd, 0xf36450603bd6bcf0,
  0x4dea53929d002de6, 0x5d38c6f19d103be5, 0x6e70c76f62aa8b4d, 0x9f0dc79b09732f9b, 0x3ab337f07771a2ce,
  0x2fcc4fe50c2a73f5, 0xff82687993fc5ce3, 0x4b867a615c9f8e7b, 0x961d252d9f027196, 0xec6e8b3c95fb9a19,
  0x0000000000056bda,
};

/*
 * m329a_autobaud_uart0_dual_pr_ce_u4 m329p_autobaud_uart0_dual_pr_ce_u4
 * m329pa_autobaud_uart0_dual_pr_ce_u4 m3290_autobaud_uart0_dual_pr_ce_u4
 * m3290a_autobaud_uart0_dual_pr_ce_u4 m3290p_autobaud_uart0_dual_pr_ce_u4
 * m3290pa_autobaud_uart0_dual_pr_ce_u4 m325_autobaud_uart0_dual_pr_ce_u4
 * m325a_autobaud_uart0_dual_pr_ce_u4 m325p_autobaud_uart0_dual_pr_ce_u4
 * m325pa_autobaud_uart0_dual_pr_ce_u4 m3250_autobaud_uart0_dual_pr_ce_u4
 * m3250a_autobaud_uart0_dual_pr_ce_u4 m3250p_autobaud_uart0_dual_pr_ce_u4
 * m3250pa_autobaud_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m329_autobaud_uart0_dual_pr_ce_u4[] = {
  0xdaddddddda2432db, 0x77777776fc361d6c, 0x765bf762fb2b535f, 0x4a3f738b56eeed89, 0xb82ee3822ac07c67,
  0x827c602410c5bbc9, 0xeb6819129290b829, 0x5c40c2860da4606e, 0x8347e657419dd3e2, 0x8fd3fb0b1f387fc9,
  0x4239227f07d5f37a, 0xf8510c4aff3f7c11, 0x777bbe6e25400370, 0x8a8432d04ac88655, 0xb9c1ffa039e132fb,
  0xe6bcc161bcaf212d, 0x74088153e12cadfe, 0xaa935f3873017488, 0x55f21b46f6a8e15f, 0x8f3cdb4070a2dc5f,
  0x25f886c2445f7125, 0x5dc6e6206bbfd47c, 0xdc39ee58cf0e333c, 0xbdc71d3f830e3ea3, 0x4f237b4731602c43,
  0xfb8e58cf1d7916ec, 0xf157ceee2a4a3a13, 0x4e166fc0c4ad7b27, 0xc8a0c077ad79e040, 0xd4a7253a005bcde6,
  0x718de33a2077ca9b, 0xe18edec555169aba, 0x1b8f3612e65f36dc, 0xaccdfc1ddc68b1be, 0xe1ef79430a9cfd4e,
  0x27f81fc65f989ffd, 0xe8bfc0fdfb0cd0f3, 0xe32c970cf4c2f8d1, 0x34332c3a4a5b3e04, 0x6bd966dd16792bf7,
  0x0000000000000005,
};

/*
 * m329a_autobaud_uart0_dual_pr_ee_ce m329p_autobaud_uart0_dual_pr_ee_ce
 * m329pa_autobaud_uart0_dual_pr_ee_ce m3290_autobaud_uart0_dual_pr_ee_ce
 * m3290a_autobaud_uart0_dual_pr_ee_ce m3290p_autobaud_uart0_dual_pr_ee_ce
 * m3290pa_autobaud_uart0_dual_pr_ee_ce m325_autobaud_uart0_dual_pr_ee_ce
 * m325a_autobaud_uart0_dual_pr_ee_ce m325p_autobaud_uart0_dual_pr_ee_ce
 * m325pa_autobaud_uart0_dual_pr_ee_ce m3250_autobaud_uart0_dual_pr_ee_ce
 * m3250a_autobaud_uart0_dual_pr_ee_ce m3250p_autobaud_uart0_dual_pr_ee_ce
 * m3250pa_autobaud_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m329_autobaud_uart0_dual_pr_ee_ce[] = {
  0x1b5bbbbbbba86f97, 0xeeeeeeeedf98ec7e, 0x27dda083e44fdebd, 0x7d7aefa16ccf7539, 0xcf046752c8a75609,
  0xc048218b7792af9d, 0xc8949483927304f8, 0x14306d2303775b40, 0x32ba0cee9f12e206, 0x60cf870eb39990ff,
  0x4fe0ff5e6f51e61b, 0x895fe7ef82284724, 0x9b9e72006e1f0a21, 0xb412d221955ddeef, 0xe80e784d1ca2a10c,
  0x586f2bc84b6e293f, 0x54f84b4d7fb9af30, 0xce1cc05d221d0220, 0xd1bdaa3857eaa4d7, 0x1c1ac77fd51b9386,
  0x8dcbc3e5afcf36d0, 0x253b5959374c273b, 0xc1b306be7a8f2b7f, 0xb422814c5701bd47, 0x6be8c2cb1148b34e,
  0xbd9ceaedc650ea42, 0xbc6c75ea25da2147, 0x84845022a3e7ac6a, 0x08991c37b2fa598b, 0xe2a4a5989fd62a36,
  0x0c4ad7b27f157cee, 0x7ad79e0404e166fc, 0xa005bcde6c8a0c07, 0xa2077ca9bd4a7253, 0x555169aba718de33,
  0x2e65f36dce18edec, 0xbb8d163ce1b8f361, 0xd30ae4fdd599bf83, 0x296cf8138cb25c33, 0x59e4afdcd0ccb0e9,
  0x00000006221ce374,
};

/*
 * m329a_autobaud_uart0_dual_pr_ee_ce_u4 m329p_autobaud_uart0_dual_pr_ee_ce_u4
 * m329pa_autobaud_uart0_dual_pr_ee_ce_u4 m3290_autobaud_uart0_dual_pr_ee_ce_u4
 * m3290a_autobaud_uart0_dual_pr_ee_ce_u4 m3290p_autobaud_uart0_dual_pr_ee_ce_u4
 * m3290pa_autobaud_uart0_dual_pr_ee_ce_u4 m325_autobaud_uart0_dual_pr_ee_ce_u4
 * m325a_autobaud_uart0_dual_pr_ee_ce_u4 m325p_autobaud_uart0_dual_pr_ee_ce_u4
 * m325pa_autobaud_uart0_dual_pr_ee_ce_u4 m3250_autobaud_uart0_dual_pr_ee_ce_u4
 * m3250a_autobaud_uart0_dual_pr_ee_ce_u4 m3250p_autobaud_uart0_dual_pr_ee_ce_u4
 * m3250pa_autobaud_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_autobaud_uart0_dual_pr_ee_ce_u4[] = {
  0xbbbbbbb456ddb69f, 0xbbbbb7e15babd9b5, 0xf60987c705af05bb, 0xfa6d8b74abeabfea, 0xce8438dfc3793c89,
  0x792cf9dd202f9e5c, 0xd7304f8c048218b7, 0x6eeb681912929163, 0xe25c40c2860da460, 0x3737ff32d0729dd3,
  0x47672d8747ce0a49, 0xa11c913f836439bd, 0x7c2886257f9fbe08, 0xeef77cdcb92801b8, 0x2a10cb4136d10caa,
  0xf59ffd01cf09ac7e, 0xf0cc161bcaf212db, 0x0440a9f096377fe3, 0x49af9c3980ba443a, 0x3d0da37b5470afd5,
  0x6da4ec66ee2faa35, 0x4361222fb892c79e, 0x6a83c83fea3e12fc, 0xdadcdcdd33c5dc6e, 0x9835f3d4795bf929,
  0x140a62b80dea3e0d, 0x4616588a459a75a1, 0xe7576e328752135f, 0x63af512ed10a3dec, 0x2281151f3d6355e3,
  0xc8e1bd97d2cc5c24, 0x252cc4feb151b044, 0x56bd93f8abe77715, 0xbcf020270b37e062, 0x2de6f36450603bd6,
  0x3be54dea53929d00, 0x8b4d5d38c6f19d10, 0x2f9b6e70c76f62aa, 0x6f8b9357079b0973, 0x75666fe0fdbb1a2c,
  0xef0f7bca1854e7ea, 0x993fc0fe32fcc4ff, 0x8f45fe07efd86687, 0x271964b867a617c6, 0xb9a19961d252d9f0,
  0x56e5c17c8dd3c95f, 0x000000000000003f,
};

/*
 * m329a_autobaud_uart0_dual_ee_hw   m329p_autobaud_uart0_dual_ee_hw   m329pa_autobaud_uart0_dual_ee_hw
 * m3290_autobaud_uart0_dual_ee_hw   m3290a_autobaud_uart0_dual_ee_hw  m3290p_autobaud_uart0_dual_ee_hw
 * m3290pa_autobaud_uart0_dual_ee_hw m325_autobaud_uart0_dual_ee_hw    m325a_autobaud_uart0_dual_ee_hw
 * m325p_autobaud_uart0_dual_ee_hw   m325pa_autobaud_uart0_dual_ee_hw  m3250_autobaud_uart0_dual_ee_hw
 * m3250a_autobaud_uart0_dual_ee_hw  m3250p_autobaud_uart0_dual_ee_hw  m3250pa_autobaud_uart0_dual_ee_hw
 */
static const uint64_t ur_m329_autobaud_uart0_dual_ee_hw[] = {
  0x36b7777776890c86, 0xddddddddbf0fdd71, 0x657c1651f4fbd70b, 0x3b363aea6fa76ed8, 0xd3bbbb1bb3798a84,
  0x9f180904316ef24d, 0xda0644a4a40aa260, 0x1030a18369181bba, 0x7df995d06774f897, 0xbfcd86203835dcc8,
  0x47244fe0c344dea3, 0x0a21895fe7ef8228, 0xdeef9b8089006e1f, 0xa10cb4302221955d, 0xff3fe80e784c5d62,
  0x2330586f2bc84b6f, 0x0440a9f0913afff5, 0x49af9c3980ba443a, 0x890da37b5470afd5, 0x7a8f2b5f7355ad1c,
  0x5752bd47c1b3060a, 0x1148b34eb422877c, 0xc54b9a426be8c2cb, 0x428f7b39d5a5cca5, 0xac6ab5d0ebd44bb4,
  0x598b84845022a3e7, 0x546c11fadc37b2fa, 0xf9ddc54940213fac, 0xcdf81895af64fe2a, 0x180ef5af3c0809c2,
  0xe4a7400b79bcd914, 0xbc67440ef9537a94, 0x5bd8aaa2d3574e31, 0xf3612e65f36dce45, 0xca1854e7ea0bb1b8,
  0xfe32fcc4ffef0f7b, 0x07efd86687993fc0, 0xb867a617c68f45fe, 0x61d252d9f0271964, 0xad5453c95fb9a199,
  0x000000000002c1c8,
};

/*
 * m329a_autobaud_uart0_dual_ee_ce_hw m329p_autobaud_uart0_dual_ee_ce_hw
 * m329pa_autobaud_uart0_dual_ee_ce_hw m3290_autobaud_uart0_dual_ee_ce_hw
 * m3290a_autobaud_uart0_dual_ee_ce_hw m3290p_autobaud_uart0_dual_ee_ce_hw
 * m3290pa_autobaud_uart0_dual_ee_ce_hw m325_autobaud_uart0_dual_ee_ce_hw
 * m325a_autobaud_uart0_dual_ee_ce_hw m325p_autobaud_uart0_dual_ee_ce_hw
 * m325pa_autobaud_uart0_dual_ee_ce_hw m3250_autobaud_uart0_dual_ee_ce_hw
 * m3250a_autobaud_uart0_dual_ee_ce_hw m3250p_autobaud_uart0_dual_ee_ce_hw
 * m3250pa_autobaud_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m329_autobaud_uart0_dual_ee_ce_hw[] = {
  0xdadddddddd437089, 0x77777776fcc763f0, 0x3eed041f227ef5ef, 0xebd77d0b667ba9c9, 0x75e4f595b5b4b04b,
  0x30120862dde4abe7, 0x32252520e49cc13e, 0x850c1b48c0ddd6d0, 0xccae833ba7c4b881, 0xd833e1c3ace6643f,
  0x13f83fd79bd47986, 0x6257f9fbe08a11c9, 0xe6e79c801b87c288, 0x2d04b488655777bb, 0xfa039e134728a843,
  0x161bcaf212db8a4f, 0x2a7c25a6bffd48cc, 0xe70e602e910e8110, 0x68ded51c2bf5526b, 0x0e0d63bfea8dc9c3,
  0x71b9000527e79b68, 0xe4a76b2b26e984e7, 0xf83660d7cf51e56f, 0xd68450298ae037a8, 0x4d7d185962291669,
  0xf7b39d5db8ca1d48, 0x578d8ebd44bb4428, 0x70908a04547cf58d, 0xc1132386f65f4b31, 0xdc5494b313fac546,
  0x81895af64fe2af9d, 0xef5af3c0809c2cdf, 0x7400b79bcd914180, 0x7440ef9537a94e4a, 0x8aaa2d3574e31bc6,
  0x25ccbe6db9c31dbd, 0x30ae4fcfec371e6c, 0x96cf8138cb25c33d, 0x9e4afdcd0ccb0e92, 0x000000135f879ca2,
};

/*
 * m329a_autobaud_uart0_dual_ee_ce_u4_hw m329p_autobaud_uart0_dual_ee_ce_u4_hw
 * m329pa_autobaud_uart0_dual_ee_ce_u4_hw m3290_autobaud_uart0_dual_ee_ce_u4_hw
 * m3290a_autobaud_uart0_dual_ee_ce_u4_hw m3290p_autobaud_uart0_dual_ee_ce_u4_hw
 * m3290pa_autobaud_uart0_dual_ee_ce_u4_hw m325_autobaud_uart0_dual_ee_ce_u4_hw
 * m325a_autobaud_uart0_dual_ee_ce_u4_hw m325p_autobaud_uart0_dual_ee_ce_u4_hw
 * m325pa_autobaud_uart0_dual_ee_ce_u4_hw m3250_autobaud_uart0_dual_ee_ce_u4_hw
 * m3250a_autobaud_uart0_dual_ee_ce_u4_hw m3250p_autobaud_uart0_dual_ee_ce_u4_hw
 * m3250pa_autobaud_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_autobaud_uart0_dual_ee_ce_u4_hw[] = {
  0x6eeeeeed1468b202, 0xeeeeedf856eaf66d, 0xfabd8261f69c16ee, 0x227e9b62dd2afaaf, 0xe918ef0727f0de4f,
  0x218b7792cf9ddfd6, 0x29163d7304f8c048, 0xda4606eeb6819129, 0x69dd3e25c40c2860, 0xe0a493737ff32c4d,
  0x439bd47672d8747c, 0xfbe08a11c913f836, 0x801b87c2886257f9, 0x10caaeef77cdcb92, 0x9ac7e2a10cb4136d,
  0x212dbf59ffd01cf0, 0xeff67a1cc161bcaf, 0x48874088153e12c6, 0x15faa935f3873017, 0xf546a7a1b46f6a8e,
  0x8f3cafac0e0cddc5, 0x25f886c2445f7125, 0x771b8a49cdffd47c, 0xfe4a76b737374cf1, 0x8f83660d7cf51e56,
  0x9d68450298ae037a, 0x84d7d18596229166, 0x8f7b39d5db8ca1d4, 0xd578d8ebd44bb442, 0x170908a04547cf58,
  0x6c1132386f65f4b3, 0xddc5494b313fac54, 0xf81895af64fe2af9, 0x0ef5af3c0809c2cd, 0xa7400b79bcd91418,
  0x67440ef9537a94e4, 0xd8aaa2d3574e31bc, 0xc25ccbe6db9c31db, 0x30a9cfd4176371e6, 0x65f989ffde1ef794,
  0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970, 0x2fa792bf734332c3, 0x00000004269f3d0c,
};

/*
 * m329_u1x8_uart0_noled_pr          m329a_u1x8_uart0_noled            m329a_u1x8_uart0_noled_pr
 * m329p_u1x8_uart0_noled            m329p_u1x8_uart0_noled_pr         m329pa_u1x8_uart0_noled
 * m329pa_u1x8_uart0_noled_pr        m3290_u1x8_uart0_noled            m3290_u1x8_uart0_noled_pr
 * m3290a_u1x8_uart0_noled           m3290a_u1x8_uart0_noled_pr        m3290p_u1x8_uart0_noled
 * m3290p_u1x8_uart0_noled_pr        m3290pa_u1x8_uart0_noled          m3290pa_u1x8_uart0_noled_pr
 * m325_u1x8_uart0_noled             m325_u1x8_uart0_noled_pr          m325a_u1x8_uart0_noled
 * m325a_u1x8_uart0_noled_pr         m325p_u1x8_uart0_noled            m325p_u1x8_uart0_noled_pr
 * m325pa_u1x8_uart0_noled           m325pa_u1x8_uart0_noled_pr        m3250_u1x8_uart0_noled
 * m3250_u1x8_uart0_noled_pr         m3250a_u1x8_uart0_noled           m3250a_u1x8_uart0_noled_pr
 * m3250p_u1x8_uart0_noled           m3250p_u1x8_uart0_noled_pr        m3250pa_u1x8_uart0_noled
 * m3250pa_u1x8_uart0_noled_pr
 */
static const uint64_t ur_m329_u1x8_uart0_noled[] = {
  0x5bbbbbaeed66ef3a, 0xeeeeeeaaec385ee2, 0x656cfddf87f7d2ee, 0x38fd697e6eee9101, 0xdde4ee82f4133164,
  0xe0a4c13e30120862, 0x05bd817c9fefd0f3, 0x1df2c21ee737f688, 0x1c74fe0d05fa8fd0, 0x398b016594cf7dad,
  0x08ebd1f3b57f47ac, 0xf6c7d99e5403ff66, 0x0312b5ec1c7c0f2c, 0x8301deb5e73859bf, 0xf29b19c2de6f00fa,
  0xe31bc67440aeaa72, 0x48ab7b15545a585c, 0x386ed84b997cdb12, 0xd598f2068fe3458f, 0x8cb25c33d30ae4fd,
  0x0ccb0e9296cb2513, 0x00396b8f9e4afdcd, 0x00000000000000f9,
};

/*
 * m329a_u1x8_uart0_noled_pr_u4      m329p_u1x8_uart0_noled_pr_u4      m329pa_u1x8_uart0_noled_pr_u4
 * m3290_u1x8_uart0_noled_pr_u4      m3290a_u1x8_uart0_noled_pr_u4     m3290p_u1x8_uart0_noled_pr_u4
 * m3290pa_u1x8_uart0_noled_pr_u4    m325_u1x8_uart0_noled_pr_u4       m325a_u1x8_uart0_noled_pr_u4
 * m325p_u1x8_uart0_noled_pr_u4      m325pa_u1x8_uart0_noled_pr_u4     m3250_u1x8_uart0_noled_pr_u4
 * m3250a_u1x8_uart0_noled_pr_u4     m3250p_u1x8_uart0_noled_pr_u4     m3250pa_u1x8_uart0_noled_pr_u4
 */
static const uint64_t ur_m329_u1x8_uart0_noled_pr_u4[] = {
  0xdddddd7751222743, 0x7777755761c2f712, 0x5b3f77e1f19a4cf7, 0x3f5a5f9bbba44059, 0xc9dda8bc96c7ac1e,
  0x49827c602410c5bb, 0xbd817c9fe78167c1, 0xf2c21ee737f68805, 0x74fe0d05fa8fd01d, 0x8b016594cf7dad1c,
  0xebd1f3b57f47ac39, 0xc7d99e5403ff6608, 0x12b5ec1c7c0f2cf6, 0x01deb5e73859bf03, 0x9b19c2de6f00fa83,
  0x1bc67440aeaa72f2, 0xab7b15545a585ce3, 0x3cd84b997cdb1248, 0x7e50d1637c5c9ab8, 0x861539fa9d598f20,
  0x8cbf313ffbc3def2, 0xfbf619a1e64ff03f, 0x19e985f1a3d17f81, 0x7494b67c09c6592e, 0x1014f257ee686658,
  0x000000000f93cb4b,
};

/*
 * m329_u1x8_uart0_noled_pr_ee_u4    m329a_u1x8_uart0_noled_pr_ee      m329a_u1x8_uart0_noled_pr_ee_u4
 * m329p_u1x8_uart0_noled_pr_ee      m329p_u1x8_uart0_noled_pr_ee_u4   m329pa_u1x8_uart0_noled_pr_ee
 * m329pa_u1x8_uart0_noled_pr_ee_u4  m3290_u1x8_uart0_noled_pr_ee      m3290_u1x8_uart0_noled_pr_ee_u4
 * m3290a_u1x8_uart0_noled_pr_ee     m3290a_u1x8_uart0_noled_pr_ee_u4  m3290p_u1x8_uart0_noled_pr_ee
 * m3290p_u1x8_uart0_noled_pr_ee_u4  m3290pa_u1x8_uart0_noled_pr_ee    m3290pa_u1x8_uart0_noled_pr_ee_u4
 * m325_u1x8_uart0_noled_pr_ee       m325_u1x8_uart0_noled_pr_ee_u4    m325a_u1x8_uart0_noled_pr_ee
 * m325a_u1x8_uart0_noled_pr_ee_u4   m325p_u1x8_uart0_noled_pr_ee      m325p_u1x8_uart0_noled_pr_ee_u4
 * m325pa_u1x8_uart0_noled_pr_ee     m325pa_u1x8_uart0_noled_pr_ee_u4  m3250_u1x8_uart0_noled_pr_ee
 * m3250_u1x8_uart0_noled_pr_ee_u4   m3250a_u1x8_uart0_noled_pr_ee     m3250a_u1x8_uart0_noled_pr_ee_u4
 * m3250p_u1x8_uart0_noled_pr_ee     m3250p_u1x8_uart0_noled_pr_ee_u4  m3250pa_u1x8_uart0_noled_pr_ee
 * m3250pa_u1x8_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m329_u1x8_uart0_noled_pr_ee[] = {
  0xbbbbbaeea24458e2, 0xeeeeeaaeb9041225, 0x853d31b70cf5a5ee, 0x31382f85eeeeff17, 0x4e1ec694eb033363,
  0xe30120862dde4ee9, 0x4bfe78167ca5cc13, 0xdce6fed100b7b027, 0x51e57224d56b4738, 0x7dd7a8f83660d31f,
  0x148b34eb422877c5, 0x1ac9a426be8c2cb1, 0xb4782ce756979c57, 0x6355ae875e74ddb7, 0x98b848451cf230e3,
  0xa3608fd6e1bd96cb, 0x0c4ad7b002a254d2, 0x0c077ad79ce166fc, 0xca6c670b79bc03ea, 0x8c6f19d102baa9cb,
  0x22adec5551696173, 0xe0f3612e65f36c49, 0x81f943458df1726a, 0xca1854e7ea75663c, 0xfe32fcc4ffef0f7b,
  0x07efd86687993fc0, 0xb867a617c68f45fe, 0x61d252d9f0271964, 0xe44053c95fb9a199, 0x0000000000275c54,
};

/*
 * m329_u1x8_uart0_noled_pr_ce_u4    m329a_u1x8_uart0_noled_pr_ce      m329a_u1x8_uart0_noled_pr_ce_u4
 * m329p_u1x8_uart0_noled_pr_ce      m329p_u1x8_uart0_noled_pr_ce_u4   m329pa_u1x8_uart0_noled_pr_ce
 * m329pa_u1x8_uart0_noled_pr_ce_u4  m3290_u1x8_uart0_noled_pr_ce      m3290_u1x8_uart0_noled_pr_ce_u4
 * m3290a_u1x8_uart0_noled_pr_ce     m3290a_u1x8_uart0_noled_pr_ce_u4  m3290p_u1x8_uart0_noled_pr_ce
 * m3290p_u1x8_uart0_noled_pr_ce_u4  m3290pa_u1x8_uart0_noled_pr_ce    m3290pa_u1x8_uart0_noled_pr_ce_u4
 * m325_u1x8_uart0_noled_pr_ce       m325_u1x8_uart0_noled_pr_ce_u4    m325a_u1x8_uart0_noled_pr_ce
 * m325a_u1x8_uart0_noled_pr_ce_u4   m325p_u1x8_uart0_noled_pr_ce      m325p_u1x8_uart0_noled_pr_ce_u4
 * m325pa_u1x8_uart0_noled_pr_ce     m325pa_u1x8_uart0_noled_pr_ce_u4  m3250_u1x8_uart0_noled_pr_ce
 * m3250_u1x8_uart0_noled_pr_ce_u4   m3250a_u1x8_uart0_noled_pr_ce     m3250a_u1x8_uart0_noled_pr_ce_u4
 * m3250p_u1x8_uart0_noled_pr_ce     m3250p_u1x8_uart0_noled_pr_ce_u4  m3250pa_u1x8_uart0_noled_pr_ce
 * m3250pa_u1x8_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m329_u1x8_uart0_noled_pr_ce[] = {
  0x777775dd4488ba31, 0xddddd55f85ec9c4b, 0x5385ec44ade833dd, 0x1850dbdddd36922b, 0x2776c4d86080052d,
  0xa609f180904316ef, 0xd81145ff3c0b3ff3, 0xf5c92e737f68805b, 0x2c79e012a76fe5c5, 0xe12fc4361222fb89,
  0xf1771b8ff3107ea3, 0x51c9e9ee58cfd64c, 0x1f3a48e3a7f07acf, 0xced5fd1eb0e62c05, 0x79500ffd99e3af47,
  0xec1c7c0f2d6e1f66, 0xb5e73859bf0312b5, 0xc2de6f00fa8301de, 0x7440aeaa72f29b19, 0x15545a585ce31bc6,
  0x9732f9b624863b7b, 0xa2c6f8b9357079b0, 0x73f53ab31e40fca1, 0x627ff787bde50c2a, 0x3343cc9fe07f197e,
  0x0be347a2ff03f7ec, 0x6cf8138cb25c33d3, 0xe4afdcd0ccb0e929, 0x00001bae996a2029,
};

/*
 * m329a_u1x8_uart0_noled_pr_ee_ce   m329p_u1x8_uart0_noled_pr_ee_ce   m329pa_u1x8_uart0_noled_pr_ee_ce
 * m3290_u1x8_uart0_noled_pr_ee_ce   m3290a_u1x8_uart0_noled_pr_ee_ce  m3290p_u1x8_uart0_noled_pr_ee_ce
 * m3290pa_u1x8_uart0_noled_pr_ee_ce m325_u1x8_uart0_noled_pr_ee_ce    m325a_u1x8_uart0_noled_pr_ee_ce
 * m325p_u1x8_uart0_noled_pr_ee_ce   m325pa_u1x8_uart0_noled_pr_ee_ce  m3250_u1x8_uart0_noled_pr_ee_ce
 * m3250a_u1x8_uart0_noled_pr_ee_ce  m3250p_u1x8_uart0_noled_pr_ee_ce  m3250pa_u1x8_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m329_u1x8_uart0_noled_pr_ee_ce[] = {
  0xbbbbaeed414477d6, 0xdddd55ee0541625b, 0x33f6a6fe9e989ddd, 0x0910e0fbbe96a18d, 0xd38ae0fda68b5159,
  0x602410c5bbc9dd7a, 0xffcf02cf8d69827c, 0x9cdfda2016f605a6, 0xa9de043bfea8dfcb, 0xdc6e759b21fe7804,
  0x5129dacac7be6139, 0x7c1b306b5fd4795f, 0xeb422814c5613fd4, 0x26be8c2cb1148b34, 0xf059ceaedd388ea4,
  0x578d8ebce9bb6f68, 0xe1211473c8c38d8d, 0xc1132386f65b2e62, 0x95af616744a9a546, 0x0ef5af39c2cdf818,
  0xd8ce16f37807d418, 0xde33a20575539794, 0xdbd8aaa2d2c2e718, 0xcd84b997cdb12431, 0x2868b2d5e5c9ab83,
  0x0a9cfd4eacc7903f, 0xe687993fc09c6943, 0x592e19e985727e03, 0x66587494b67c09c6, 0x9d3d1014f257ee68,
  0x000000000000009f,
};

/*
 * m329a_u1x8_uart0_noled_pr_ee_ce_u4 m329p_u1x8_uart0_noled_pr_ee_ce_u4
 * m329pa_u1x8_uart0_noled_pr_ee_ce_u4 m3290_u1x8_uart0_noled_pr_ee_ce_u4
 * m3290a_u1x8_uart0_noled_pr_ee_ce_u4 m3290p_u1x8_uart0_noled_pr_ee_ce_u4
 * m3290pa_u1x8_uart0_noled_pr_ee_ce_u4 m325_u1x8_uart0_noled_pr_ee_ce_u4
 * m325a_u1x8_uart0_noled_pr_ee_ce_u4 m325p_u1x8_uart0_noled_pr_ee_ce_u4
 * m325pa_u1x8_uart0_noled_pr_ee_ce_u4 m3250_u1x8_uart0_noled_pr_ee_ce_u4
 * m3250a_u1x8_uart0_noled_pr_ee_ce_u4 m3250p_u1x8_uart0_noled_pr_ee_ce_u4
 * m3250pa_u1x8_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u1x8_uart0_noled_pr_ee_ce_u4[] = {
  0x777775dd44867f3e, 0xbbbbaabc68299c4b, 0x6b8da29bbd837bbb, 0x5a165955a6ec2f53, 0x8d545eccdd6fa772,
  0x7c602410c5bbc9dd, 0x5affb15d9f19b982, 0xee737f68805bd810, 0xb4070e0dc5f54721, 0x6c2445f71258f3cd,
  0xd1f524fd47c25f88, 0x6b736f7ccf1771b9, 0xc1ad7f51e57d44a7, 0xa0531584ff51f06c, 0x30b2c4522cd3ad08,
  0x3abb74e23a909afa, 0x3af3a6edbda3c167, 0x51cf230e36355e36, 0x8e1bd96cb98b8484, 0x859d12a6951b044c,
  0xbce70b37e06256bd, 0x5bcde01f50603bd6, 0x8815d54e5e536338, 0xaa8b4b0b9c6378ce, 0xe65f36c490c76f62,
  0xdc68b1be1b8f3612, 0x0a9cfd4eaccdfc1d, 0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd,
  0x4a5b3e04e32c970c, 0x16792bf734332c3a, 0x00000009f83f04dd,
};

/*
 * m329a_u1x8_uart0_noled_ee_hw      m329p_u1x8_uart0_noled_ee_hw      m329pa_u1x8_uart0_noled_ee_hw
 * m3290_u1x8_uart0_noled_ee_hw      m3290a_u1x8_uart0_noled_ee_hw     m3290p_u1x8_uart0_noled_ee_hw
 * m3290pa_u1x8_uart0_noled_ee_hw    m325_u1x8_uart0_noled_ee_hw       m325a_u1x8_uart0_noled_ee_hw
 * m325p_u1x8_uart0_noled_ee_hw      m325pa_u1x8_uart0_noled_ee_hw     m3250_u1x8_uart0_noled_ee_hw
 * m3250a_u1x8_uart0_noled_ee_hw     m3250p_u1x8_uart0_noled_ee_hw     m3250pa_u1x8_uart0_noled_ee_hw
 */
static const uint64_t ur_m329_u1x8_uart0_noled_ee_hw[] = {
  0x777775dd44862d7b, 0xddddd55d7208244b, 0x5e14f4c6dec33ddd, 0x8cc4e0be17bbbbfc, 0x7751d94ad7640ccd,
  0x609f180904316ef2, 0x604e97fe8533e52e, 0x8e71b9cdfda2016f, 0xa63ea3cae449aad6, 0xef8afbaf51f06cc1,
  0x5962291669d68450, 0x38ae3593484d7d18, 0xbb6f68f059cead2f, 0x61c6c6ab5d0ebce9, 0x2d973170908a39e4,
  0xa9a546c11fadc37b, 0xcdf81895af600544, 0x07d4180ef5af39c2, 0x539794d8ce16f378, 0xc2e718de33a20575,
  0xd892455bd8aaa2d2, 0x176371e6c25ccbe6, 0xde1ef79430a9cfd4, 0x327f81fc65f989ff, 0x1e8bfc0fdfb0cd0f,
  0x4e32c970cf4c2f8d, 0x734332c3a4a5b3e0, 0x00b7f8d0e8a792bf,
};

/*
 * m329_u1x8_uart0_noled_ee_ce_u4_hw m329a_u1x8_uart0_noled_ee_ce_hw   m329a_u1x8_uart0_noled_ee_ce_u4_hw
 * m329p_u1x8_uart0_noled_ee_ce_hw   m329p_u1x8_uart0_noled_ee_ce_u4_hw
 * m329pa_u1x8_uart0_noled_ee_ce_hw  m329pa_u1x8_uart0_noled_ee_ce_u4_hw
 * m3290_u1x8_uart0_noled_ee_ce_hw   m3290_u1x8_uart0_noled_ee_ce_u4_hw
 * m3290a_u1x8_uart0_noled_ee_ce_hw  m3290a_u1x8_uart0_noled_ee_ce_u4_hw
 * m3290p_u1x8_uart0_noled_ee_ce_hw  m3290p_u1x8_uart0_noled_ee_ce_u4_hw
 * m3290pa_u1x8_uart0_noled_ee_ce_hw m3290pa_u1x8_uart0_noled_ee_ce_u4_hw
 * m325_u1x8_uart0_noled_ee_ce_hw    m325_u1x8_uart0_noled_ee_ce_u4_hw m325a_u1x8_uart0_noled_ee_ce_hw
 * m325a_u1x8_uart0_noled_ee_ce_u4_hw m325p_u1x8_uart0_noled_ee_ce_hw
 * m325p_u1x8_uart0_noled_ee_ce_u4_hw m325pa_u1x8_uart0_noled_ee_ce_hw
 * m325pa_u1x8_uart0_noled_ee_ce_u4_hw m3250_u1x8_uart0_noled_ee_ce_hw
 * m3250_u1x8_uart0_noled_ee_ce_u4_hw m3250a_u1x8_uart0_noled_ee_ce_hw
 * m3250a_u1x8_uart0_noled_ee_ce_u4_hw m3250p_u1x8_uart0_noled_ee_ce_hw
 * m3250p_u1x8_uart0_noled_ee_ce_u4_hw m3250pa_u1x8_uart0_noled_ee_ce_hw
 * m3250pa_u1x8_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u1x8_uart0_noled_ee_ce_hw[] = {
  0x777775dd448624d6, 0xbbbbaabc68299c4b, 0x6b8da29bbd837bbb, 0x5a165955a6ec2f53, 0xbbf6baef53efa772,
  0x04f8c048218b7793, 0x0416bfe8533e3373, 0xc87b9cdfda2016f6, 0xf36d01c383717d51, 0xe21b09117dc4963c,
  0x3712a2e47f51f097, 0x94ed6e6def99e2ee, 0x0d9835afea3cafa8, 0xa1140a62b09fea3e, 0x5f4616588a459a75,
  0x2ce7576e9c475213, 0xc6c75e74ddb7b478, 0x908a39e461c6c6ab, 0x8991c37b2d973170, 0xd7b0b3a254d2a360,
  0x7ad79ce166fc0c4a, 0x670b79bc03ea0c07, 0x19d102baa9cbca6c, 0xec55516961738c6f, 0xc25ccbe6d89218ed,
  0x30a9cfd4176371e6, 0x65f989ffde1ef794, 0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970,
  0xa8a792bf734332c3, 0x00000000028087e0,
};

/*
 * m329_u1x8_uart0_lednop_pr         m329a_u1x8_uart0_lednop           m329a_u1x8_uart0_lednop_pr
 * m329p_u1x8_uart0_lednop           m329p_u1x8_uart0_lednop_pr        m329pa_u1x8_uart0_lednop
 * m329pa_u1x8_uart0_lednop_pr       m3290_u1x8_uart0_lednop           m3290_u1x8_uart0_lednop_pr
 * m3290a_u1x8_uart0_lednop          m3290a_u1x8_uart0_lednop_pr       m3290p_u1x8_uart0_lednop
 * m3290p_u1x8_uart0_lednop_pr       m3290pa_u1x8_uart0_lednop         m3290pa_u1x8_uart0_lednop_pr
 * m325_u1x8_uart0_lednop            m325_u1x8_uart0_lednop_pr         m325a_u1x8_uart0_lednop
 * m325a_u1x8_uart0_lednop_pr        m325p_u1x8_uart0_lednop           m325p_u1x8_uart0_lednop_pr
 * m325pa_u1x8_uart0_lednop          m325pa_u1x8_uart0_lednop_pr       m3250_u1x8_uart0_lednop
 * m3250_u1x8_uart0_lednop_pr        m3250a_u1x8_uart0_lednop          m3250a_u1x8_uart0_lednop_pr
 * m3250p_u1x8_uart0_lednop          m3250p_u1x8_uart0_lednop_pr       m3250pa_u1x8_uart0_lednop
 * m3250pa_u1x8_uart0_lednop_pr
 */
static const uint64_t ur_m329_u1x8_uart0_lednop[] = {
  0xb777775ddacdc49f, 0xeeeeeeaaec38f244, 0xb2e6fc1cd075d7ee, 0xad0bdbf6ddddcd60, 0x7793bb9892150d68,
  0xaf9304f8c048218b, 0x16f60498ffbf43cf, 0x77cb243b9cdfda20, 0x71d3f83349ea393c, 0xe62c05bdd30f9d24,
  0x8ebc5cecd7c8e414, 0x6bd8560fbdc72c60, 0xcf020270b37e0625, 0xde6f36450603bd6b, 0xbe54dea53929d002,
  0xb4d5d38c6f19d103, 0x7cdb739156f62aa8, 0xe3458f386ed84b99, 0x0ae4fdd598f2068f, 0xcb25138cb25c33d3,
  0x4afdcd0ccb0e9296, 0x00001f21ce6b8f9e,
};

/*
 * m329a_u1x8_uart0_lednop_pr_u4     m329p_u1x8_uart0_lednop_pr_u4     m329pa_u1x8_uart0_lednop_pr_u4
 * m3290_u1x8_uart0_lednop_pr_u4     m3290a_u1x8_uart0_lednop_pr_u4    m3290p_u1x8_uart0_lednop_pr_u4
 * m3290pa_u1x8_uart0_lednop_pr_u4   m325_u1x8_uart0_lednop_pr_u4      m325a_u1x8_uart0_lednop_pr_u4
 * m325p_u1x8_uart0_lednop_pr_u4     m325pa_u1x8_uart0_lednop_pr_u4    m3250_u1x8_uart0_lednop_pr_u4
 * m3250a_u1x8_uart0_lednop_pr_u4    m3250p_u1x8_uart0_lednop_pr_u4    m3250pa_u1x8_uart0_lednop_pr_u4
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_pr_u4[] = {
  0xdddddd77512233c3, 0x7777755761c1af12, 0x2f7b3dfb0dbd8037, 0x5d7f89dddd2202ca, 0x3ba47e5dbd38e3e9,
  0x304f8c048218b779, 0xb029bbfcf02cfa01, 0x5843dce6fed100b7, 0x9fc1a0bf51ed63be, 0xc0596537c907e38e,
  0xd1f3b2cf4690ce62, 0x59a45403ff6608eb, 0xb5ec82b40f2cf6d0, 0xe781013859bf0312, 0x6f379b228301deb5,
  0xdf2a6f529c94e801, 0x5a6ae9c6378ce881, 0xbe6db9c8ab7b1554, 0xbe2e4d5c1e6c25cc, 0x4eacc7903f2868b1,
  0xfde1ef79430a9cfd, 0xf327f81fc65f989f, 0xd1e8bfc0fdfb0cd0, 0x04e32c970cf4c2f8, 0xf734332c3a4a5b3e,
  0x07c9db90880a792b,
};

/*
 * m329_u1x8_uart0_lednop_pr_ee_u4   m329a_u1x8_uart0_lednop_pr_ee     m329a_u1x8_uart0_lednop_pr_ee_u4
 * m329p_u1x8_uart0_lednop_pr_ee     m329p_u1x8_uart0_lednop_pr_ee_u4  m329pa_u1x8_uart0_lednop_pr_ee
 * m329pa_u1x8_uart0_lednop_pr_ee_u4 m3290_u1x8_uart0_lednop_pr_ee     m3290_u1x8_uart0_lednop_pr_ee_u4
 * m3290a_u1x8_uart0_lednop_pr_ee    m3290a_u1x8_uart0_lednop_pr_ee_u4 m3290p_u1x8_uart0_lednop_pr_ee
 * m3290p_u1x8_uart0_lednop_pr_ee_u4 m3290pa_u1x8_uart0_lednop_pr_ee
 * m3290pa_u1x8_uart0_lednop_pr_ee_u4 m325_u1x8_uart0_lednop_pr_ee
 * m325_u1x8_uart0_lednop_pr_ee_u4   m325a_u1x8_uart0_lednop_pr_ee     m325a_u1x8_uart0_lednop_pr_ee_u4
 * m325p_u1x8_uart0_lednop_pr_ee     m325p_u1x8_uart0_lednop_pr_ee_u4  m325pa_u1x8_uart0_lednop_pr_ee
 * m325pa_u1x8_uart0_lednop_pr_ee_u4 m3250_u1x8_uart0_lednop_pr_ee     m3250_u1x8_uart0_lednop_pr_ee_u4
 * m3250a_u1x8_uart0_lednop_pr_ee    m3250a_u1x8_uart0_lednop_pr_ee_u4 m3250p_u1x8_uart0_lednop_pr_ee
 * m3250p_u1x8_uart0_lednop_pr_ee_u4 m3250pa_u1x8_uart0_lednop_pr_ee
 * m3250pa_u1x8_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_pr_ee[] = {
  0xbbbbbaeea24477d6, 0xddddd55d72056e25, 0x8261550e85ebd7dd, 0x8f382f85eeeeff16, 0x5a71189fb47ef17d,
  0x8c048218b7793baf, 0xaff9e059f53d304f, 0x739bfb4402dec08b, 0x4795995355ad1ce3, 0x0f7ea3e0d9834c7d,
  0xa459a75a1143be2b, 0xd64d2135f4616588, 0x9193473ab4b9eab8, 0x8d56ba1d79d3768c, 0x62e1211413c8ded5,
  0x8d823f5b86f65b2e, 0x6256bd8010fb33ca, 0xd6bcf020270b37e0, 0x002de6f36450603b, 0x103be54dea53929d,
  0xaa8b4d5d38c6f19d, 0xb997cdb739156f62, 0x1637c5c9ab83cd84, 0x9fa9d598f207e50d, 0x13ffbc3def286153,
  0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61, 0x67c09c6592e19e98, 0x257ee6866587494b, 0x00009d727171014f,
};

/*
 * m329_u1x8_uart0_lednop_pr_ce_u4   m329a_u1x8_uart0_lednop_pr_ce     m329a_u1x8_uart0_lednop_pr_ce_u4
 * m329p_u1x8_uart0_lednop_pr_ce     m329p_u1x8_uart0_lednop_pr_ce_u4  m329pa_u1x8_uart0_lednop_pr_ce
 * m329pa_u1x8_uart0_lednop_pr_ce_u4 m3290_u1x8_uart0_lednop_pr_ce     m3290_u1x8_uart0_lednop_pr_ce_u4
 * m3290a_u1x8_uart0_lednop_pr_ce    m3290a_u1x8_uart0_lednop_pr_ce_u4 m3290p_u1x8_uart0_lednop_pr_ce
 * m3290p_u1x8_uart0_lednop_pr_ce_u4 m3290pa_u1x8_uart0_lednop_pr_ce
 * m3290pa_u1x8_uart0_lednop_pr_ce_u4 m325_u1x8_uart0_lednop_pr_ce
 * m325_u1x8_uart0_lednop_pr_ce_u4   m325a_u1x8_uart0_lednop_pr_ce     m325a_u1x8_uart0_lednop_pr_ce_u4
 * m325p_u1x8_uart0_lednop_pr_ce     m325p_u1x8_uart0_lednop_pr_ce_u4  m325pa_u1x8_uart0_lednop_pr_ce
 * m325pa_u1x8_uart0_lednop_pr_ce_u4 m3250_u1x8_uart0_lednop_pr_ce     m3250_u1x8_uart0_lednop_pr_ce_u4
 * m3250a_u1x8_uart0_lednop_pr_ce    m3250a_u1x8_uart0_lednop_pr_ce_u4 m3250p_u1x8_uart0_lednop_pr_ce
 * m3250p_u1x8_uart0_lednop_pr_ce_u4 m3250pa_u1x8_uart0_lednop_pr_ce
 * m3250pa_u1x8_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_pr_ce[] = {
  0x777775dd4488a493, 0xeeeeeaafc2e4844b, 0xc9b532666ef4fdee, 0x8412a1eeee9b4916, 0x27743720a68a768d,
  0xe609f180904316ef, 0xd81256ff3c0b3e70, 0xf5c92e737f68805b, 0x58f3c0254eea55c5, 0xc25f886c2445f712,
  0xc5dc6e56fc00fd47, 0x47e927b9633f5933, 0x3111638e9fc1eb3d, 0xecb3d1a43398b015, 0x1500ffd99e3af47c,
  0xc82b40f2d6e41669, 0x1013859bf0312b5e, 0x79b228301deb5e78, 0xa6f529c94e8016f3, 0xae9c6378ce881df2,
  0xb73863b7b15545a6, 0xc9ab83cd84b997cd, 0x98f207e50d1637c5, 0x3def2861539fa9d5, 0xff03f8cbf313ffbc,
  0x17f81fbf619a1e64, 0x6592e19e985f1a3d, 0x866587494b67c09c, 0x7de0b1014f257ee6, 0x00000000000000dd,
};

/*
 * m329a_u1x8_uart0_lednop_pr_ee_ce  m329p_u1x8_uart0_lednop_pr_ee_ce  m329pa_u1x8_uart0_lednop_pr_ee_ce
 * m3290_u1x8_uart0_lednop_pr_ee_ce  m3290a_u1x8_uart0_lednop_pr_ee_ce m3290p_u1x8_uart0_lednop_pr_ee_ce
 * m3290pa_u1x8_uart0_lednop_pr_ee_ce m325_u1x8_uart0_lednop_pr_ee_ce
 * m325a_u1x8_uart0_lednop_pr_ee_ce  m325p_u1x8_uart0_lednop_pr_ee_ce  m325pa_u1x8_uart0_lednop_pr_ee_ce
 * m3250_u1x8_uart0_lednop_pr_ee_ce  m3250a_u1x8_uart0_lednop_pr_ee_ce m3250p_u1x8_uart0_lednop_pr_ee_ce
 * m3250pa_u1x8_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_pr_ee_ce[] = {
  0xbbbbaeed41445541, 0xdddd55ee0564625b, 0x28d35a3c8ef25ddd, 0x9c88707ddf4b50e8, 0x4932271ce5c647c1,
  0x602410c5bbc9dd01, 0x7f9e059feaf9827c, 0x39bfb4402dec0a39, 0x53bdf677fd51bf97, 0xb8dcb9124afcf009,
  0xea53b5958f7cc273, 0xf83660d6bfa8f2be, 0xd68450298af6ffa8, 0x4d7d185962291669, 0xc9a39d5db8f51d48,
  0x578d8ebce9bb4648, 0xe1211413c8ded58d, 0xc1132386f65b2e62, 0x2b5ec2cc7d99e546, 0x5e781013859bf031,
  0x16f379b228301deb, 0x1df2a6f529c94e80, 0x45a6ae9c6378ce88, 0x97cdb73863b7b155, 0xd5e5c9ab83cd84b9,
  0x4eacc7903f2868b2, 0x3fc09c69430a9cfd, 0xe985727e03e68799, 0x94b67c09c6592e19, 0x14f257ee68665874,
  0x000000004fc5d910,
};

/*
 * m329a_u1x8_uart0_lednop_pr_ee_ce_u4 m329p_u1x8_uart0_lednop_pr_ee_ce_u4
 * m329pa_u1x8_uart0_lednop_pr_ee_ce_u4 m3290_u1x8_uart0_lednop_pr_ee_ce_u4
 * m3290a_u1x8_uart0_lednop_pr_ee_ce_u4 m3290p_u1x8_uart0_lednop_pr_ee_ce_u4
 * m3290pa_u1x8_uart0_lednop_pr_ee_ce_u4 m325_u1x8_uart0_lednop_pr_ee_ce_u4
 * m325a_u1x8_uart0_lednop_pr_ee_ce_u4 m325p_u1x8_uart0_lednop_pr_ee_ce_u4
 * m325pa_u1x8_uart0_lednop_pr_ee_ce_u4 m3250_u1x8_uart0_lednop_pr_ee_ce_u4
 * m3250a_u1x8_uart0_lednop_pr_ee_ce_u4 m3250p_u1x8_uart0_lednop_pr_ee_ce_u4
 * m3250pa_u1x8_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_pr_ee_ce_u4[] = {
  0x777775dd44864c7f, 0xbbbbaabc68160c4b, 0x74cd71b4bd477bbb, 0xd8405955a6ec2f53, 0xf5ddce29d55e2465,
  0x3e30120862dde4ee, 0xc7ffec5767c344c1, 0xf739bfb4402dec0a, 0xda03896ae2faa390, 0x361222fb892c79e6,
  0x089300fea3e12fc4, 0x6b736f7ccf1771b8, 0xc1ad7f51e57dd4a7, 0xa05315edff51f06c, 0x30b2c4522cd3ad08,
  0x3abb71ea3a909afa, 0x1d79d3768c919347, 0x282791bdab1aaf1b, 0x470decb65cc5c242, 0x8598fb33ca8d8226,
  0x20270b37e06256bd, 0xf36450603bd6bcf0, 0x4dea53929d002de6, 0x5d38c6f19d103be5, 0x6e70c76f62aa8b4d,
  0xdf0dc79b09732f9b, 0xa75666fe0eee3458, 0xfef0f7bca1854e7e, 0x7993fc0fe32fcc4f, 0x68f45fe07efd8668,
  0x0271964b867a617c, 0xfb9a19961d252d9f, 0x027e25b46e8b3c95,
};

/*
 * m329a_u1x8_uart0_lednop_ee_hw     m329p_u1x8_uart0_lednop_ee_hw     m329pa_u1x8_uart0_lednop_ee_hw
 * m3290_u1x8_uart0_lednop_ee_hw     m3290a_u1x8_uart0_lednop_ee_hw    m3290p_u1x8_uart0_lednop_ee_hw
 * m3290pa_u1x8_uart0_lednop_ee_hw   m325_u1x8_uart0_lednop_ee_hw      m325a_u1x8_uart0_lednop_ee_hw
 * m325p_u1x8_uart0_lednop_ee_hw     m325pa_u1x8_uart0_lednop_ee_hw    m3250_u1x8_uart0_lednop_ee_hw
 * m3250a_u1x8_uart0_lednop_ee_hw    m3250p_u1x8_uart0_lednop_ee_hw    m3250pa_u1x8_uart0_lednop_ee_hw
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_ee_hw[] = {
  0xbbbbbaeea2435562, 0xddddd55d72056e25, 0x2d04c2aa1ed0bddd, 0xfb1e705f0bddddfe, 0xee99169db618fde2,
  0xc13e30120862dde4, 0xc08baffd0a67d4f4, 0x1ce3739bfb4402de, 0x4c7d4795995355ad, 0xbe2b0f7ea3e0d983,
  0x6588a459a75a1143, 0xeab8d64d2135f461, 0x768c9193473ab4b9, 0xded58d56ba1d79d3, 0x5b2e62e1211413c8,
  0x33ca8d823f5b86f6, 0x37e06256bd8010fb, 0x603bd6bcf020270b, 0x929d002de6f36450, 0xf19d103be54dea53,
  0x6f62aa8b4d5d38c6, 0xcd84b997cdb73915, 0x2861539fa82ec6e3, 0xf8cbf313ffbc3def, 0x1fbf619a1e64ff03,
  0xe19e985f1a3d17f8, 0x87494b67c09c6592, 0xadd14f257ee68665, 0x0000000000016f9f,
};

/*
 * m329_u1x8_uart0_lednop_ee_ce_u4_hw m329a_u1x8_uart0_lednop_ee_ce_hw
 * m329a_u1x8_uart0_lednop_ee_ce_u4_hw m329p_u1x8_uart0_lednop_ee_ce_hw
 * m329p_u1x8_uart0_lednop_ee_ce_u4_hw m329pa_u1x8_uart0_lednop_ee_ce_hw
 * m329pa_u1x8_uart0_lednop_ee_ce_u4_hw m3290_u1x8_uart0_lednop_ee_ce_hw
 * m3290_u1x8_uart0_lednop_ee_ce_u4_hw m3290a_u1x8_uart0_lednop_ee_ce_hw
 * m3290a_u1x8_uart0_lednop_ee_ce_u4_hw m3290p_u1x8_uart0_lednop_ee_ce_hw
 * m3290p_u1x8_uart0_lednop_ee_ce_u4_hw m3290pa_u1x8_uart0_lednop_ee_ce_hw
 * m3290pa_u1x8_uart0_lednop_ee_ce_u4_hw m325_u1x8_uart0_lednop_ee_ce_hw
 * m325_u1x8_uart0_lednop_ee_ce_u4_hw m325a_u1x8_uart0_lednop_ee_ce_hw
 * m325a_u1x8_uart0_lednop_ee_ce_u4_hw m325p_u1x8_uart0_lednop_ee_ce_hw
 * m325p_u1x8_uart0_lednop_ee_ce_u4_hw m325pa_u1x8_uart0_lednop_ee_ce_hw
 * m325pa_u1x8_uart0_lednop_ee_ce_u4_hw m3250_u1x8_uart0_lednop_ee_ce_hw
 * m3250_u1x8_uart0_lednop_ee_ce_u4_hw m3250a_u1x8_uart0_lednop_ee_ce_hw
 * m3250a_u1x8_uart0_lednop_ee_ce_u4_hw m3250p_u1x8_uart0_lednop_ee_ce_hw
 * m3250p_u1x8_uart0_lednop_ee_ce_u4_hw m3250pa_u1x8_uart0_lednop_ee_ce_hw
 * m3250pa_u1x8_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u1x8_uart0_lednop_ee_ce_hw[] = {
  0x777775dd4486a4d6, 0xbbbbaabc68160c4b, 0x74cd71b4bd477bbb, 0xd8405955a6ec2f53, 0xdd39d9f7a55e2465,
  0x827c602410c5bbc9, 0x02b1fffa14cf8689, 0xe43dce6fed100b7b, 0x79b680e25ab8bea8, 0xf10d8488bee24b1e,
  0x1b9494ce5fa8f84b, 0x4a76b736f7ccf177, 0x06cc1ad7f51e57dd, 0xd08a05315edff51f, 0xafa30b2c4522cd3a,
  0x3473abb71ea3a909, 0xf1b1d79d3768c919, 0x242282791bdab1aa, 0x226470decb65cc5c, 0x6bd8598fb33ca8d8,
  0xcf020270b37e0625, 0xde6f36450603bd6b, 0xbe54dea53929d002, 0xb4d5d38c6f19d103, 0xf9b6e70c76f62aa8,
  0xf505d8dc79b09732, 0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b,
  0xafdcd0ccb0e9296c, 0x000050125b4a29e4,
};

/*
 * m329a_u1x8_uart0_dual             m329p_u1x8_uart0_dual             m329pa_u1x8_uart0_dual
 * m3290_u1x8_uart0_dual             m3290a_u1x8_uart0_dual            m3290p_u1x8_uart0_dual
 * m3290pa_u1x8_uart0_dual           m325_u1x8_uart0_dual              m325a_u1x8_uart0_dual
 * m325p_u1x8_uart0_dual             m325pa_u1x8_uart0_dual            m3250_u1x8_uart0_dual
 * m3250a_u1x8_uart0_dual            m3250p_u1x8_uart0_dual            m3250pa_u1x8_uart0_dual
 */
static const uint64_t ur_m329_u1x8_uart0_dual[] = {
  0xb777777c4ea22a20, 0xddddddbf36da3336, 0xd7d123c95a76d86d, 0x14e0dd13b777717b, 0xe4ad0ee1ec5ab635,
  0x9cc13e30120862dd, 0x1bbada0644a4a475, 0xf8971030a1836918, 0x2cce4ff32b012774, 0x37a8efe6c17d9c0a,
  0xf04508e489fc1995, 0x0dc3e144312bfcfd, 0x0caaeef77cdc8e40, 0x9ad68a8432d08c91, 0x9096dcc7ffd01cf0,
  0xebfe901260b0de57, 0xee737f68805bd811, 0xd21fa8e229df2d5f, 0xe1cc98f491c74fe0, 0xb35f237b4731602f,
  0x7dee39630475e45b, 0x3f8abe77715252b0, 0x0270b37e06256bd9, 0xcb750603bd6bcf02, 0x37a94e4a7400b79b,
  0x1d4502169c05ef95, 0x2f9b69c6378ce881, 0xfd8b9357079b0973, 0x1964b867a615c9f9, 0xa19961d252d9f027,
  0xdf1c5c4053c95fb9, 0x0000000000000032,
};

/*
 * m329_u1x8_uart0_dual_pr_u4        m329a_u1x8_uart0_dual_pr          m329a_u1x8_uart0_dual_pr_u4
 * m329p_u1x8_uart0_dual_pr          m329p_u1x8_uart0_dual_pr_u4       m329pa_u1x8_uart0_dual_pr
 * m329pa_u1x8_uart0_dual_pr_u4      m3290_u1x8_uart0_dual_pr          m3290_u1x8_uart0_dual_pr_u4
 * m3290a_u1x8_uart0_dual_pr         m3290a_u1x8_uart0_dual_pr_u4      m3290p_u1x8_uart0_dual_pr
 * m3290p_u1x8_uart0_dual_pr_u4      m3290pa_u1x8_uart0_dual_pr        m3290pa_u1x8_uart0_dual_pr_u4
 * m325_u1x8_uart0_dual_pr           m325_u1x8_uart0_dual_pr_u4        m325a_u1x8_uart0_dual_pr
 * m325a_u1x8_uart0_dual_pr_u4       m325p_u1x8_uart0_dual_pr          m325p_u1x8_uart0_dual_pr_u4
 * m325pa_u1x8_uart0_dual_pr         m325pa_u1x8_uart0_dual_pr_u4      m3250_u1x8_uart0_dual_pr
 * m3250_u1x8_uart0_dual_pr_u4       m3250a_u1x8_uart0_dual_pr         m3250a_u1x8_uart0_dual_pr_u4
 * m3250p_u1x8_uart0_dual_pr         m3250p_u1x8_uart0_dual_pr_u4      m3250pa_u1x8_uart0_dual_pr
 * m3250pa_u1x8_uart0_dual_pr_u4
 */
static const uint64_t ur_m329_u1x8_uart0_dual_pr[] = {
  0x77777c4d1218022f, 0xddddbf36db4e36b7, 0x2941b848eabedddd, 0xa01513b777469b45, 0x6eec983f2350ce20,
  0x7c602410c5bbc906, 0xb40c894948eb3982, 0x20614306d2303775, 0x0ff32ba0cee9f12e, 0xff76c12b1c1d2cc7,
  0x239227f0701a6f51, 0x8510c4aff3f7c114, 0x77bbe6e74f80370f, 0x5421968262886557, 0xe63ffe80e784d194,
  0x9af30586f2bc84b6, 0xfda2016f6047affb, 0xa3e453be589ab9cd, 0xe2f7c71d3f8310fe, 0x8ebf9cc580aa0f34,
  0xfecc11d78033b5ac, 0x1e59ed887486a807, 0xf157ceee2a4aa4e8, 0x4e166fc0c4ad7b27, 0xc8a0c077ad79e040,
  0xd4a7253a005bcde6, 0x718de33a2077ca9b, 0x722adec555169aba, 0x0dc79b09732f9b6e, 0x5666fe0eee3458df,
  0xf0f7bca1854e7ea7, 0x93fc0fe32fcc4ffe, 0xf45fe07efd866879, 0x71964b867a617c68, 0x9a19961d252d9f02,
  0x93d65a6e8b3c95fb, 0x0000000000000014,
};

/*
 * m329_u1x8_uart0_dual_pr_ee_u4     m329a_u1x8_uart0_dual_pr_ee       m329a_u1x8_uart0_dual_pr_ee_u4
 * m329p_u1x8_uart0_dual_pr_ee       m329p_u1x8_uart0_dual_pr_ee_u4    m329pa_u1x8_uart0_dual_pr_ee
 * m329pa_u1x8_uart0_dual_pr_ee_u4   m3290_u1x8_uart0_dual_pr_ee       m3290_u1x8_uart0_dual_pr_ee_u4
 * m3290a_u1x8_uart0_dual_pr_ee      m3290a_u1x8_uart0_dual_pr_ee_u4   m3290p_u1x8_uart0_dual_pr_ee
 * m3290p_u1x8_uart0_dual_pr_ee_u4   m3290pa_u1x8_uart0_dual_pr_ee     m3290pa_u1x8_uart0_dual_pr_ee_u4
 * m325_u1x8_uart0_dual_pr_ee        m325_u1x8_uart0_dual_pr_ee_u4     m325a_u1x8_uart0_dual_pr_ee
 * m325a_u1x8_uart0_dual_pr_ee_u4    m325p_u1x8_uart0_dual_pr_ee       m325p_u1x8_uart0_dual_pr_ee_u4
 * m325pa_u1x8_uart0_dual_pr_ee      m325pa_u1x8_uart0_dual_pr_ee_u4   m3250_u1x8_uart0_dual_pr_ee
 * m3250_u1x8_uart0_dual_pr_ee_u4    m3250a_u1x8_uart0_dual_pr_ee      m3250a_u1x8_uart0_dual_pr_ee_u4
 * m3250p_u1x8_uart0_dual_pr_ee      m3250p_u1x8_uart0_dual_pr_ee_u4   m3250pa_u1x8_uart0_dual_pr_ee
 * m3250pa_u1x8_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m329_u1x8_uart0_dual_pr_ee[] = {
  0x6eeeeef89a2432db, 0xbbbbbb7e614eb66d, 0x2dfbb17d95a9afbb, 0x716aa86d1776c4bb, 0x7045580f8ce947ee,
  0x048218b7793705dc, 0x2252521705304f8c, 0x50c1b48c0ddd6d03, 0xcae833ba7c4b8818, 0x6163e70ff93068fc,
  0x4fe0fabe6f51fa7f, 0x895fe7ef82284724, 0xcdc4a8006e1f0a21, 0x5a095910caaeef77, 0xf4073c265f715086,
  0x2c3795e425b7383f, 0x16f60595bfdcd798, 0xad68e44b9cdfda20, 0x983053d4795afb9a, 0x143be2ba95ea3e0d,
  0x4616588a459a75a1, 0x2e652e2a5cd2135f, 0xa25da2147bd9cead, 0x151f3d6355ae875e, 0xbd97d2cc5c242281,
  0x09fd62a3608fd6e1, 0x27f157ceee2a4a01, 0x404e166fc0c4ad7b, 0xe6c8a0c077ad79e0, 0x9bd4a7253a005bcd,
  0xba718de33a2077ca, 0x6e722adec555169a, 0xdf0dc79b09732f9b, 0xa75666fe0eee3458, 0xfef0f7bca1854e7e,
  0x7993fc0fe32fcc4f, 0x68f45fe07efd8668, 0x0271964b867a617c, 0xfb9a19961d252d9f, 0x001590b36e8b3c95,
};

/*
 * m329_u1x8_uart0_dual_pr_ce_u4     m329a_u1x8_uart0_dual_pr_ce       m329a_u1x8_uart0_dual_pr_ce_u4
 * m329p_u1x8_uart0_dual_pr_ce       m329p_u1x8_uart0_dual_pr_ce_u4    m329pa_u1x8_uart0_dual_pr_ce
 * m329pa_u1x8_uart0_dual_pr_ce_u4   m3290_u1x8_uart0_dual_pr_ce       m3290_u1x8_uart0_dual_pr_ce_u4
 * m3290a_u1x8_uart0_dual_pr_ce      m3290a_u1x8_uart0_dual_pr_ce_u4   m3290p_u1x8_uart0_dual_pr_ce
 * m3290p_u1x8_uart0_dual_pr_ce_u4   m3290pa_u1x8_uart0_dual_pr_ce     m3290pa_u1x8_uart0_dual_pr_ce_u4
 * m325_u1x8_uart0_dual_pr_ce        m325_u1x8_uart0_dual_pr_ce_u4     m325a_u1x8_uart0_dual_pr_ce
 * m325a_u1x8_uart0_dual_pr_ce_u4    m325p_u1x8_uart0_dual_pr_ce       m325p_u1x8_uart0_dual_pr_ce_u4
 * m325pa_u1x8_uart0_dual_pr_ce      m325pa_u1x8_uart0_dual_pr_ce_u4   m3250_u1x8_uart0_dual_pr_ce
 * m3250_u1x8_uart0_dual_pr_ce_u4    m3250a_u1x8_uart0_dual_pr_ce      m3250a_u1x8_uart0_dual_pr_ce_u4
 * m3250p_u1x8_uart0_dual_pr_ce      m3250p_u1x8_uart0_dual_pr_ce_u4   m3250pa_u1x8_uart0_dual_pr_ce
 * m3250pa_u1x8_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m329_u1x8_uart0_dual_pr_ce[] = {
  0xeeeeef89a2435202, 0x77776fc6a79f66d6, 0xebb8d43db6abf777, 0xfbf7b2b777519b33, 0xce43ada6cdf9af45,
  0xc048218b7793d39d, 0x644a4a42baf304f8, 0x0a18369181bbada0, 0x995d06774f897103, 0x6c12d1c02d4c63ff,
  0x227f0715a6f51c9d, 0x0c4aff3f7c114239, 0xbe6e4c300370f851, 0x32d05f688655777b, 0xffa039e1307b8a84,
  0xc161bcaf212dbe9b, 0x00b7b02297fee6bc, 0x5b8bea805ce6fed1, 0xee24b1e79b680e3a, 0xfa8f84bf10d8488b,
  0x2e678bb8dc149faf, 0x2fd471bf3dcb19f5, 0x050507c8e3a7f075, 0x019dad6475fce62c, 0xa435403ff6678ebc,
  0x549549d03cb5b843, 0x895af64fe2af9ddc, 0x5af3c0809c2cdf81, 0x00b79bcd914180ef, 0x40ef9537a94e4a74,
  0xaa2d3574e31bc674, 0xccbe6db9c31dbd8a, 0xb8d1637c371e6c25, 0x1539fa9d599bf83b, 0xbf313ffbc3def286,
  0xf619a1e64ff03f8c, 0xe985f1a3d17f81fb, 0x94b67c09c6592e19, 0x2cf257ee68665874, 0x0000001a491f5dba,
};

/*
 * m329a_u1x8_uart0_dual_pr_ee_ce    m329p_u1x8_uart0_dual_pr_ee_ce    m329pa_u1x8_uart0_dual_pr_ee_ce
 * m3290_u1x8_uart0_dual_pr_ee_ce    m3290a_u1x8_uart0_dual_pr_ee_ce   m3290p_u1x8_uart0_dual_pr_ee_ce
 * m3290pa_u1x8_uart0_dual_pr_ee_ce  m325_u1x8_uart0_dual_pr_ee_ce     m325a_u1x8_uart0_dual_pr_ee_ce
 * m325p_u1x8_uart0_dual_pr_ee_ce    m325pa_u1x8_uart0_dual_pr_ee_ce   m3250_u1x8_uart0_dual_pr_ee_ce
 * m3250a_u1x8_uart0_dual_pr_ee_ce   m3250p_u1x8_uart0_dual_pr_ee_ce   m3250pa_u1x8_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m329_u1x8_uart0_dual_pr_ee_ce[] = {
  0xbbbbbbe275050c86, 0xeeeeedf836f261b5, 0x55710b157ee44eee, 0x4dd6990123ba82b6, 0xbbb1bb3eafcc507c,
  0x80904316ef25d93b, 0xc894948ee3e609f1, 0x14306d2303775b40, 0x32ba0cee9f12e206, 0xd8400380a49bf5ff,
  0x13f839db9bd47adf, 0x6257f9fbe08a11c9, 0xe6e2a4401b87c288, 0x2d0df688655777bb, 0xfa039e133058a843,
  0x2c3795e425b74dbf, 0x2dec0a87ffdcd798, 0xfaa3727739bfb440, 0x0ff9e6da038358ef, 0x4dd309cee3732a1a,
  0x9ea3cadfc94ed656, 0x15c06f51f06cc1af, 0xc4522cd3ad08a053, 0x71943a909afa30b2, 0x89768851ef673abb,
  0xa8f9eb1aaf1b1d7a, 0xecbe9662e1211408, 0x27f58a8d8226470d, 0x9fc55f3bb8a92966, 0x013859bf0312b5ec,
  0x9b228301deb5e781, 0x6f529c94e8016f37, 0xe9c6378ce881df2a, 0x73863b7b15545a6a, 0xbc6e3cd84b997cdb,
  0xd599bf83bb8d165a, 0xf8138d2861539fa9, 0x30ae4fc07cd0f327, 0x96cf8138cb25c33d, 0x9e4afdcd0ccb0e92,
  0x00000080039f3745,
};

/*
 * m329a_u1x8_uart0_dual_pr_ee_ce_u4 m329p_u1x8_uart0_dual_pr_ee_ce_u4 m329pa_u1x8_uart0_dual_pr_ee_ce_u4
 * m3290_u1x8_uart0_dual_pr_ee_ce_u4 m3290a_u1x8_uart0_dual_pr_ee_ce_u4
 * m3290p_u1x8_uart0_dual_pr_ee_ce_u4 m3290pa_u1x8_uart0_dual_pr_ee_ce_u4
 * m325_u1x8_uart0_dual_pr_ee_ce_u4  m325a_u1x8_uart0_dual_pr_ee_ce_u4 m325p_u1x8_uart0_dual_pr_ee_ce_u4
 * m325pa_u1x8_uart0_dual_pr_ee_ce_u4 m3250_u1x8_uart0_dual_pr_ee_ce_u4
 * m3250a_u1x8_uart0_dual_pr_ee_ce_u4 m3250p_u1x8_uart0_dual_pr_ee_ce_u4
 * m3250pa_u1x8_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u1x8_uart0_dual_pr_ee_ce_u4[] = {
  0xbbbbe268adbb2906, 0xeeedf98ec7e1b5bb, 0x7c89fd7bd2bdeeee, 0x2d99eea724fbb410, 0x0548c6c12faf5df4,
  0xef255f3b8af9016f, 0x24e609f180904316, 0x06eeb68191292907, 0x3e25c40c2860da46, 0x39990ff32d0729dd,
  0xf51e61b60cf870eb, 0x22847244fe0ff5e6, 0xe1f0a21895fe7ef8, 0x55ddeef9b9e72006, 0xca2a10cb412d2219,
  0xb6e293fe80e784d1, 0xf8fc330586f2bc84, 0x6fed100b7b02d35f, 0xb19bb8bea8d4f5ce, 0x88bee24b1e79b693,
  0x20ffa8f84bf10d84, 0x7374cf1771b9aa0f, 0xcf51e56fe4a76b73, 0x8ae037a8f83660d7, 0x62291669d6845029,
  0xb8ca1d484d7d1859, 0x44bb4428f7b39d5d, 0x547cf58d578d8ebd, 0xf65f4b3170908a04, 0x13fac546c1132386,
  0x4fe2af9ddc5494b3, 0x809c2cdf81895af6, 0xcd914180ef5af3c0, 0x37a94e4a7400b79b, 0x74e31bc67440ef95,
  0xb9c31dbd8aaa2d35, 0x4d5c1e6c25ccbe6d, 0xbf83f6ec68b1be2e, 0xef2861539fa9d599, 0x03f8cbf313ffbc3d,
  0xf81fbf619a1e64ff, 0x92e19e985f1a3d17, 0x6587494b67c09c65, 0x9ef2374f257ee686, 0x000000000004007d,
};

/*
 * m329a_u1x8_uart0_dual_ee_hw       m329p_u1x8_uart0_dual_ee_hw       m329pa_u1x8_uart0_dual_ee_hw
 * m3290_u1x8_uart0_dual_ee_hw       m3290a_u1x8_uart0_dual_ee_hw      m3290p_u1x8_uart0_dual_ee_hw
 * m3290pa_u1x8_uart0_dual_ee_hw     m325_u1x8_uart0_dual_ee_hw        m325a_u1x8_uart0_dual_ee_hw
 * m325p_u1x8_uart0_dual_ee_hw       m325pa_u1x8_uart0_dual_ee_hw      m3250_u1x8_uart0_dual_ee_hw
 * m3250a_u1x8_uart0_dual_ee_hw      m3250p_u1x8_uart0_dual_ee_hw      m3250pa_u1x8_uart0_dual_ee_hw
 */
static const uint64_t ur_m329_u1x8_uart0_dual_ee_hw[] = {
  0xeeeeef89a243573e, 0xbbbbb7e614eb66d6, 0xdfbb17d95a9afbbb, 0x16aa86d1776c4bb2, 0x5c5f766eb2947ee7,
  0x02410c5bbc9b82ee, 0x9129290b829827c6, 0x2860da4606eeb681, 0x657419dd3e25c40c, 0xb0b1f387fc98347e,
  0x27f07d5f37a8fd3f, 0xc4aff3f7c1142392, 0xe6e25400370f8510, 0x2d04ac88655777bb, 0xfa039e132fb8a843,
  0x161bcaf212db9c1f, 0x16f60595bffd48cc, 0xad68e44b9cdfda20, 0x983053d4795afb9a, 0x143be2ba95ea3e0d,
  0x4616588a459a75a1, 0x2e652e2a5cd2135f, 0xa25da2147bd9cead, 0x151f3d6355ae875e, 0xbd97d2cc5c242281,
  0x09fd62a3608fd6e1, 0x27f157ceee2a4a01, 0x404e166fc0c4ad7b, 0xe6c8a0c077ad79e0, 0x9bd4a7253a005bcd,
  0xba718de33a2077ca, 0x6e722adec555169a, 0x5d8dc79b09732f9b, 0x787bde50c2a73f50, 0xc9fe07f197e627ff,
  0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0x005768b3a29e4afd,
};

/*
 * m329a_u1x8_uart0_dual_ee_ce_hw    m329p_u1x8_uart0_dual_ee_ce_hw    m329pa_u1x8_uart0_dual_ee_ce_hw
 * m3290_u1x8_uart0_dual_ee_ce_hw    m3290a_u1x8_uart0_dual_ee_ce_hw   m3290p_u1x8_uart0_dual_ee_ce_hw
 * m3290pa_u1x8_uart0_dual_ee_ce_hw  m325_u1x8_uart0_dual_ee_ce_hw     m325a_u1x8_uart0_dual_ee_ce_hw
 * m325p_u1x8_uart0_dual_ee_ce_hw    m325pa_u1x8_uart0_dual_ee_ce_hw   m3250_u1x8_uart0_dual_ee_ce_hw
 * m3250a_u1x8_uart0_dual_ee_ce_hw   m3250p_u1x8_uart0_dual_ee_ce_hw   m3250pa_u1x8_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m329_u1x8_uart0_dual_ee_ce_hw[] = {
  0xeeeef89d41436f02, 0xbbbb7e0dbc986d6e, 0x5c42c55fb913bbbb, 0x75a64048eea0ad95, 0x3f87cd7d166c1f13,
  0x0120862dde4bb277, 0x9129291dc7cc13e3, 0x2860da4606eeb681, 0x657419dd3e25c40c, 0xb08007014937ebfe,
  0x27f073b737a8f5bf, 0xc4aff3f7c1142392, 0xcdc54880370f8510, 0x5a1bed10caaeef77, 0xf4073c2660b15086,
  0x586f2bc84b6e9b7f, 0xb7b02a1ffff52330, 0xea8dc9dce6fed100, 0x1fe79b680e0d63bf, 0x9ba6139dc6e759b2,
  0x3d4795bf929dacac, 0x2b80dea3e0d9835f, 0x88a459a75a1140a6, 0xe328752135f46165, 0x12ed10a3dece7576,
  0x51f3d6355e363af5, 0xd97d2cc5c2422811, 0x4feb151b044c8e1b, 0x3f8abe77715252cc, 0x0270b37e06256bd9,
  0x36450603bd6bcf02, 0xdea53929d002de6f, 0xd38c6f19d103be54, 0xe70c76f62aa8b4d5, 0xd8dc79b09732f9b6,
  0x271a50c2a73f5361, 0x5c9f80f9a1e64ff0, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x0000075d4e7d453c,
};

/*
 * m329a_u1x8_uart0_dual_ee_ce_u4_hw m329p_u1x8_uart0_dual_ee_ce_u4_hw m329pa_u1x8_uart0_dual_ee_ce_u4_hw
 * m3290_u1x8_uart0_dual_ee_ce_u4_hw m3290a_u1x8_uart0_dual_ee_ce_u4_hw
 * m3290p_u1x8_uart0_dual_ee_ce_u4_hw m3290pa_u1x8_uart0_dual_ee_ce_u4_hw
 * m325_u1x8_uart0_dual_ee_ce_u4_hw  m325a_u1x8_uart0_dual_ee_ce_u4_hw m325p_u1x8_uart0_dual_ee_ce_u4_hw
 * m325pa_u1x8_uart0_dual_ee_ce_u4_hw m3250_u1x8_uart0_dual_ee_ce_u4_hw
 * m3250a_u1x8_uart0_dual_ee_ce_u4_hw m3250p_u1x8_uart0_dual_ee_ce_u4_hw
 * m3250pa_u1x8_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u1x8_uart0_dual_ee_ce_u4_hw[] = {
  0x77777c4d1468a0ae, 0xddddbf31d8fc36b7, 0x4107c89fbd7bdddd, 0xdf42d99eea724fbb, 0xfeb7a1f5ec12faf5,
  0x4316ef255f3bbebe, 0x290724e609f18090, 0xda4606eeb6819129, 0x69dd3e25c40c2860, 0x70eb39990ff32c4d,
  0xf5e6f51e61b60cf8, 0x7ef822847244fe0f, 0x2006e1f0a21895fe, 0x221955ddeef9b9e7, 0x84d1ca2a10cb412d,
  0xbc84b6e293fe80e7, 0xa6bfd9e8730586f2, 0xeb9cdfda2016f605, 0xeb038337717d51a9, 0xb09117dc4963cf2b,
  0x92737ff51f097e21, 0xadcdcdd33c5dc6e2, 0x835f3d4795bf929d, 0x40a62b80dea3e0d9, 0x616588a459a75a11,
  0x7576e328752135f4, 0x3af512ed10a3dece, 0x281151f3d6355e36, 0x8e1bd97d2cc5c242, 0x52cc4feb151b044c,
  0x6bd93f8abe777152, 0xcf020270b37e0625, 0xde6f36450603bd6b, 0xbe54dea53929d002, 0xb4d5d38c6f19d103,
  0xf9b6e70c76f62aa8, 0xf505d8dc79b09732, 0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33,
  0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c, 0x0075d4e7930be9e4,
};

/*
 * m329_u1x12_uart0_noled_pr         m329a_u1x12_uart0_noled           m329a_u1x12_uart0_noled_pr
 * m329p_u1x12_uart0_noled           m329p_u1x12_uart0_noled_pr        m329pa_u1x12_uart0_noled
 * m329pa_u1x12_uart0_noled_pr       m3290_u1x12_uart0_noled           m3290_u1x12_uart0_noled_pr
 * m3290a_u1x12_uart0_noled          m3290a_u1x12_uart0_noled_pr       m3290p_u1x12_uart0_noled
 * m3290p_u1x12_uart0_noled_pr       m3290pa_u1x12_uart0_noled         m3290pa_u1x12_uart0_noled_pr
 * m325_u1x12_uart0_noled            m325_u1x12_uart0_noled_pr         m325a_u1x12_uart0_noled
 * m325a_u1x12_uart0_noled_pr        m325p_u1x12_uart0_noled           m325p_u1x12_uart0_noled_pr
 * m325pa_u1x12_uart0_noled          m325pa_u1x12_uart0_noled_pr       m3250_u1x12_uart0_noled
 * m3250_u1x12_uart0_noled_pr        m3250a_u1x12_uart0_noled          m3250a_u1x12_uart0_noled_pr
 * m3250p_u1x12_uart0_noled          m3250p_u1x12_uart0_noled_pr       m3250pa_u1x12_uart0_noled
 * m3250pa_u1x12_uart0_noled_pr
 */
static const uint64_t ur_m329_u1x12_uart0_noled[] = {
  0x776d0d783acdfebe, 0xddd55f67367c4b77, 0xbfc48716f1fddddd, 0xa114cdddd910889b, 0x3bbe3f0a2e24878b,
  0x304f8c048218b779, 0xc24f7ffbf43cfe49, 0xa3749feda9fddba7, 0x3d47e78ef964870d, 0xc37c9e8e3a7f0669,
  0x691e33398b016f74, 0xdc72c608ebc5cecf, 0x9bf0312b5ec2b289, 0x0fa8301deb5e7385, 0xa72f29b19c2de6f0,
  0x85ce31bc67440aea, 0xb1248ab7b15545a5, 0x58f386ed84b997cd, 0x4fdd598f2068fe34, 0x5138cb25c33d30ae,
  0xdcd0ccb0e9296cb2, 0x1f21d276b8f9e4af,
};

/*
 * m329a_u1x12_uart0_noled_pr_u4     m329p_u1x12_uart0_noled_pr_u4     m329pa_u1x12_uart0_noled_pr_u4
 * m3290_u1x12_uart0_noled_pr_u4     m3290a_u1x12_uart0_noled_pr_u4    m3290p_u1x12_uart0_noled_pr_u4
 * m3290pa_u1x12_uart0_noled_pr_u4   m325_u1x12_uart0_noled_pr_u4      m325a_u1x12_uart0_noled_pr_u4
 * m325p_u1x12_uart0_noled_pr_u4     m325pa_u1x12_uart0_noled_pr_u4    m3250_u1x12_uart0_noled_pr_u4
 * m3250a_u1x12_uart0_noled_pr_u4    m3250p_u1x12_uart0_noled_pr_u4    m3250pa_u1x12_uart0_noled_pr_u4
 */
static const uint64_t ur_m329_u1x12_uart0_noled_pr_u4[] = {
  0x76d0d7834488da91, 0xeeaafb395a44b777, 0x22a99b6f46deeeee, 0xb07dddd0b28e3a11, 0xd17a763b976c478f,
  0xf8c048218b7793ba, 0x5f3fcf02cfce3304, 0xa4ff6d4feedd3e12, 0x3f4077cb08786d1b, 0xf6b471d3f83417ea,
  0x1eb0e62c0596533d, 0xfd9823af47ced5fd, 0x3cb3db1f6679500f, 0x66fc0c4ad7b071f0, 0x03ea0c077ad79ce1,
  0xa9cbca6c670b79bc, 0x61738c6f19d102ba, 0x6c4922adec555169, 0x726ae0f3612e65f3, 0x663c81f943458df1,
  0x0f7bca1854e7ea75, 0x3fc0fe32fcc4ffef, 0x45fe07efd8668799, 0x1964b867a617c68f, 0xa19961d252d9f027,
  0x4c64e44053c95fb9, 0x000000000000003e,
};

/*
 * m329_u1x12_uart0_noled_pr_ee_u4   m329a_u1x12_uart0_noled_pr_ee     m329a_u1x12_uart0_noled_pr_ee_u4
 * m329p_u1x12_uart0_noled_pr_ee     m329p_u1x12_uart0_noled_pr_ee_u4  m329pa_u1x12_uart0_noled_pr_ee
 * m329pa_u1x12_uart0_noled_pr_ee_u4 m3290_u1x12_uart0_noled_pr_ee     m3290_u1x12_uart0_noled_pr_ee_u4
 * m3290a_u1x12_uart0_noled_pr_ee    m3290a_u1x12_uart0_noled_pr_ee_u4 m3290p_u1x12_uart0_noled_pr_ee
 * m3290p_u1x12_uart0_noled_pr_ee_u4 m3290pa_u1x12_uart0_noled_pr_ee
 * m3290pa_u1x12_uart0_noled_pr_ee_u4 m325_u1x12_uart0_noled_pr_ee
 * m325_u1x12_uart0_noled_pr_ee_u4   m325a_u1x12_uart0_noled_pr_ee     m325a_u1x12_uart0_noled_pr_ee_u4
 * m325p_u1x12_uart0_noled_pr_ee     m325p_u1x12_uart0_noled_pr_ee_u4  m325pa_u1x12_uart0_noled_pr_ee
 * m325pa_u1x12_uart0_noled_pr_ee_u4 m3250_u1x12_uart0_noled_pr_ee     m3250_u1x12_uart0_noled_pr_ee_u4
 * m3250a_u1x12_uart0_noled_pr_ee    m3250a_u1x12_uart0_noled_pr_ee_u4 m3250p_u1x12_uart0_noled_pr_ee
 * m3250p_u1x12_uart0_noled_pr_ee_u4 m3250pa_u1x12_uart0_noled_pr_ee
 * m3250pa_u1x12_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m329_u1x12_uart0_noled_pr_ee[] = {
  0xbb686bc1a2447768, 0x77557cd636225bbb, 0x4d9711a7b42f7777, 0xd4cd0775228d75a1, 0x7df4e711bb0660bf,
  0x120862dde4eebb25, 0xe78167d82cc13e30, 0x6d4feedd3e12387f, 0xad68e7186d1ba4ff, 0xcc1a63ea3cae449a,
  0x450ef8afbaf51f06, 0xd185962291669d68, 0xd2f38ae3593484d7, 0xce9bb6f68f059cea, 0x9e461c6c6ab5d0eb,
  0x37b2d973170908a3, 0x544a9a546c11fadc, 0x9c2cdf81895af600, 0x37807d4180ef5af3, 0x575539794d8ce16f,
  0x2d2c2e718de33a20, 0xbe6d892455bd8aaa, 0xbe2e4d5c1e6c25cc, 0x4eacc7903f2868b1, 0xfde1ef79430a9cfd,
  0xf327f81fc65f989f, 0xd1e8bfc0fdfb0cd0, 0x04e32c970cf4c2f8, 0xf734332c3a4a5b3e, 0x04ebe8e2880a792b,
};

/*
 * m329_u1x12_uart0_noled_pr_ce_u4   m329a_u1x12_uart0_noled_pr_ce     m329a_u1x12_uart0_noled_pr_ce_u4
 * m329p_u1x12_uart0_noled_pr_ce     m329p_u1x12_uart0_noled_pr_ce_u4  m329pa_u1x12_uart0_noled_pr_ce
 * m329pa_u1x12_uart0_noled_pr_ce_u4 m3290_u1x12_uart0_noled_pr_ce     m3290_u1x12_uart0_noled_pr_ce_u4
 * m3290a_u1x12_uart0_noled_pr_ce    m3290a_u1x12_uart0_noled_pr_ce_u4 m3290p_u1x12_uart0_noled_pr_ce
 * m3290p_u1x12_uart0_noled_pr_ce_u4 m3290pa_u1x12_uart0_noled_pr_ce
 * m3290pa_u1x12_uart0_noled_pr_ce_u4 m325_u1x12_uart0_noled_pr_ce
 * m325_u1x12_uart0_noled_pr_ce_u4   m325a_u1x12_uart0_noled_pr_ce     m325a_u1x12_uart0_noled_pr_ce_u4
 * m325p_u1x12_uart0_noled_pr_ce     m325p_u1x12_uart0_noled_pr_ce_u4  m325pa_u1x12_uart0_noled_pr_ce
 * m325pa_u1x12_uart0_noled_pr_ce_u4 m3250_u1x12_uart0_noled_pr_ce     m3250_u1x12_uart0_noled_pr_ce_u4
 * m3250a_u1x12_uart0_noled_pr_ce    m3250a_u1x12_uart0_noled_pr_ce_u4 m3250p_u1x12_uart0_noled_pr_ce
 * m3250p_u1x12_uart0_noled_pr_ce_u4 m3250pa_u1x12_uart0_noled_pr_ce
 * m3250pa_u1x12_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m329_u1x12_uart0_noled_pr_ce[] = {
  0x76d0d78344889202, 0xeeaae8778544b777, 0xd8f198bf4ddeeeee, 0xa0b8eeeef89791e9, 0x7599b62b22829905,
  0x09f180904316ef27, 0x9393ff3c0b3f21e6, 0xdd27fb6a7f76e9f0, 0x4edfcb8beb924368, 0x2445f71258f3c025,
  0xe620fd47c25f886c, 0xb19fac99e2ee371f, 0x4fe0f59ea393d3dc, 0x61cc580a3e7491c7, 0x33c75e8f9dabfa3d,
  0x5adc3eccf2a01ffb, 0x7e06256bd838f81e, 0xf50603bd6bce70b3, 0xe5e5363385bcde01, 0xb9c6378ce8815d54,
  0x490c76f62aa8b4b0, 0x6ae0f3612e65f36c, 0x3c81f943458df172, 0x7bca1854e7ea7566, 0xc0fe32fcc4ffef0f,
  0xfe07efd86687993f, 0x64b867a617c68f45, 0x9961d252d9f02719, 0x83944053c95fb9a1, 0x000000000000375c,
};

/*
 * m329a_u1x12_uart0_noled_pr_ee_ce  m329p_u1x12_uart0_noled_pr_ee_ce  m329pa_u1x12_uart0_noled_pr_ee_ce
 * m3290_u1x12_uart0_noled_pr_ee_ce  m3290a_u1x12_uart0_noled_pr_ee_ce m3290p_u1x12_uart0_noled_pr_ee_ce
 * m3290pa_u1x12_uart0_noled_pr_ee_ce m325_u1x12_uart0_noled_pr_ee_ce
 * m325a_u1x12_uart0_noled_pr_ee_ce  m325p_u1x12_uart0_noled_pr_ee_ce  m325pa_u1x12_uart0_noled_pr_ee_ce
 * m3250_u1x12_uart0_noled_pr_ee_ce  m3250a_u1x12_uart0_noled_pr_ee_ce m3250p_u1x12_uart0_noled_pr_ee_ce
 * m3250pa_u1x12_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m329_u1x12_uart0_noled_pr_ee_ce[] = {
  0xb686bc1d41447705, 0x557eb0551625bbbb, 0xc90a67be47777777, 0x1ddfba4cf317aed2, 0x23b498695a295b3c,
  0x8218b7793bb61b65, 0xe059f275304f8c04, 0x53fbb74f84a2b7f9, 0xaa37f21b46e93fdb, 0x7f9e012a77810eff,
  0xef984e771b9d66c8, 0xf51e57d44a76b2b1, 0x584ff51f06cc1ad7, 0x4522cd3ad08a0531, 0x4e23a909afa30b2c,
  0x6edbda3c1673abb7, 0x30e36355e363af3a, 0x96cb98b848451cf2, 0x2a6951b044c8e1bd, 0xb37e06256bd859d1,
  0x01f50603bd6bce70, 0x54e5e5363385bcde, 0xb0b9c6378ce8815d, 0x6c490c76f62aa8b4, 0x726ae0f3612e65f3,
  0x31e40fca1a2cb579, 0x271a50c2a73f53ab, 0x5c9f80f9a1e64ff0, 0x9f0271964b867a61, 0x95fb9a19961d252d,
  0x000013f318c4053c,
};

/*
 * m329a_u1x12_uart0_noled_pr_ee_ce_u4 m329p_u1x12_uart0_noled_pr_ee_ce_u4
 * m329pa_u1x12_uart0_noled_pr_ee_ce_u4 m3290_u1x12_uart0_noled_pr_ee_ce_u4
 * m3290a_u1x12_uart0_noled_pr_ee_ce_u4 m3290p_u1x12_uart0_noled_pr_ee_ce_u4
 * m3290pa_u1x12_uart0_noled_pr_ee_ce_u4 m325_u1x12_uart0_noled_pr_ee_ce_u4
 * m325a_u1x12_uart0_noled_pr_ee_ce_u4 m325p_u1x12_uart0_noled_pr_ee_ce_u4
 * m325pa_u1x12_uart0_noled_pr_ee_ce_u4 m3250_u1x12_uart0_noled_pr_ee_ce_u4
 * m3250a_u1x12_uart0_noled_pr_ee_ce_u4 m3250p_u1x12_uart0_noled_pr_ee_ce_u4
 * m3250pa_u1x12_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u1x12_uart0_noled_pr_ee_ce_u4[] = {
  0x76d0d78344863375, 0xdd55de4392c4b777, 0x269619ea33dddddd, 0x58e3e3fbb63c9031, 0x2ad1bab9d1c7a750,
  0x30120862dde4ee96, 0xffd8aecfeed4c13e, 0xfb6a7f76e9f0918f, 0x8bea8e43c368dd27, 0x24b1e79b680e1c1b,
  0x8f84bf10d8488bee, 0x9e2ee373a3ea49fa, 0xcafa894ed6e6def9, 0xfea3e0d9835afea3, 0x59a75a1140a62b09,
  0x752135f4616588a4, 0x7b4782ce7576e9c4, 0x6c6abc6c75e74ddb, 0x73170908a39e461c, 0x2a3608991c37b2d9,
  0xc0c4ad7b0b3a254d, 0xa0c077ad79ce166f, 0xbca6c670b79bc03e, 0x38c6f19d102baa9c, 0x218edec555169617,
  0x371e6c25ccbe6d89, 0x599bf83bb8d1637c, 0xc3def2861539fa9d, 0x4ff03f8cbf313ffb, 0xd17f81fbf619a1e6,
  0xc6592e19e985f1a3, 0x6866587494b67c09, 0xe7b13dba2cf257ee, 0x0000000000000027,
};

/*
 * m329a_u1x12_uart0_noled_ee_hw     m329p_u1x12_uart0_noled_ee_hw     m329pa_u1x12_uart0_noled_ee_hw
 * m3290_u1x12_uart0_noled_ee_hw     m3290a_u1x12_uart0_noled_ee_hw    m3290p_u1x12_uart0_noled_ee_hw
 * m3290pa_u1x12_uart0_noled_ee_hw   m325_u1x12_uart0_noled_ee_hw      m325a_u1x12_uart0_noled_ee_hw
 * m325p_u1x12_uart0_noled_ee_hw     m325pa_u1x12_uart0_noled_ee_hw    m3250_u1x12_uart0_noled_ee_hw
 * m3250a_u1x12_uart0_noled_ee_hw    m3250p_u1x12_uart0_noled_ee_hw    m3250pa_u1x12_uart0_noled_ee_hw
 */
static const uint64_t ur_m329_u1x12_uart0_noled_ee_hw[] = {
  0xbb686bc1a243280b, 0x77557cd636225bbb, 0x429b2e3a34f77777, 0x7fa99a0eea451aeb, 0x939eb6b4e3760cc1,
  0xf8c048218b7793bb, 0x387ff4299f60b304, 0xa4ff6d4feedd3e12, 0x449aad68e7186d1b, 0x1f06cc1a63ea3cae,
  0x9d68450ef8afbaf5, 0x84d7d18596229166, 0x9cead2f38ae35934, 0xd0ebce9bb6f68f05, 0x08a39e461c6c6ab5,
  0xfadc37b2d9731709, 0xf600544a9a546c11, 0x5af39c2cdf81895a, 0xe16f37807d4180ef, 0x3a20575539794d8c,
  0x8aaa2d2c2e718de3, 0x25ccbe6d892455bd, 0x0a9cfd4176371e6c, 0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6,
  0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c, 0x8a792bf734332c3a, 0x000000000b7f2ab2,
};

/*
 * m329_u1x12_uart0_noled_ee_ce_u4_hw m329a_u1x12_uart0_noled_ee_ce_hw
 * m329a_u1x12_uart0_noled_ee_ce_u4_hw m329p_u1x12_uart0_noled_ee_ce_hw
 * m329p_u1x12_uart0_noled_ee_ce_u4_hw m329pa_u1x12_uart0_noled_ee_ce_hw
 * m329pa_u1x12_uart0_noled_ee_ce_u4_hw m3290_u1x12_uart0_noled_ee_ce_hw
 * m3290_u1x12_uart0_noled_ee_ce_u4_hw m3290a_u1x12_uart0_noled_ee_ce_hw
 * m3290a_u1x12_uart0_noled_ee_ce_u4_hw m3290p_u1x12_uart0_noled_ee_ce_hw
 * m3290p_u1x12_uart0_noled_ee_ce_u4_hw m3290pa_u1x12_uart0_noled_ee_ce_hw
 * m3290pa_u1x12_uart0_noled_ee_ce_u4_hw m325_u1x12_uart0_noled_ee_ce_hw
 * m325_u1x12_uart0_noled_ee_ce_u4_hw m325a_u1x12_uart0_noled_ee_ce_hw
 * m325a_u1x12_uart0_noled_ee_ce_u4_hw m325p_u1x12_uart0_noled_ee_ce_hw
 * m325p_u1x12_uart0_noled_ee_ce_u4_hw m325pa_u1x12_uart0_noled_ee_ce_hw
 * m325pa_u1x12_uart0_noled_ee_ce_u4_hw m3250_u1x12_uart0_noled_ee_ce_hw
 * m3250_u1x12_uart0_noled_ee_ce_u4_hw m3250a_u1x12_uart0_noled_ee_ce_hw
 * m3250a_u1x12_uart0_noled_ee_ce_u4_hw m3250p_u1x12_uart0_noled_ee_ce_hw
 * m3250p_u1x12_uart0_noled_ee_ce_u4_hw m3250pa_u1x12_uart0_noled_ee_ce_hw
 * m3250pa_u1x12_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u1x12_uart0_noled_ee_ce_hw[] = {
  0x76d0d78344864aa4, 0xdd55de4392c4b777, 0x269619ea33dddddd, 0x58e3e3fbb63c9031, 0x9962fb9f71c7a750,
  0xc602410c5bbc9dd4, 0x3fff4299fdda9827, 0x9feda9fddba7c246, 0x6e2faa390f0da374, 0xb892c79e6da03870,
  0xea3e12fc4361222f, 0xf33c5dc6e2545c8f, 0x4795f5129dadcdbd, 0x13fd47c1b306b5fd, 0x48b34eb422814c56,
  0x88ea426be8c2cb11, 0xb6f68f059ceaedd3, 0x38d8d578d8ebce9b, 0xb2e62e1211473c8c, 0x9a546c1132386f65,
  0xdf81895af616744a, 0x7d4180ef5af39c2c, 0x39794d8ce16f3780, 0x2e718de33a205755, 0x12431dbd8aaa2d2c,
  0xec6e3cd84b997cdb, 0xc3def2861539fa82, 0x4ff03f8cbf313ffb, 0xd17f81fbf619a1e6, 0xc6592e19e985f1a3,
  0x6866587494b67c09, 0xa02f627d14f257ee,
};

/*
 * m329_u1x12_uart0_lednop_pr        m329a_u1x12_uart0_lednop          m329a_u1x12_uart0_lednop_pr
 * m329p_u1x12_uart0_lednop          m329p_u1x12_uart0_lednop_pr       m329pa_u1x12_uart0_lednop
 * m329pa_u1x12_uart0_lednop_pr      m3290_u1x12_uart0_lednop          m3290_u1x12_uart0_lednop_pr
 * m3290a_u1x12_uart0_lednop         m3290a_u1x12_uart0_lednop_pr      m3290p_u1x12_uart0_lednop
 * m3290p_u1x12_uart0_lednop_pr      m3290pa_u1x12_uart0_lednop        m3290pa_u1x12_uart0_lednop_pr
 * m325_u1x12_uart0_lednop           m325_u1x12_uart0_lednop_pr        m325a_u1x12_uart0_lednop
 * m325a_u1x12_uart0_lednop_pr       m325p_u1x12_uart0_lednop          m325p_u1x12_uart0_lednop_pr
 * m325pa_u1x12_uart0_lednop         m325pa_u1x12_uart0_lednop_pr      m3250_u1x12_uart0_lednop
 * m3250_u1x12_uart0_lednop_pr       m3250a_u1x12_uart0_lednop         m3250a_u1x12_uart0_lednop_pr
 * m3250p_u1x12_uart0_lednop         m3250p_u1x12_uart0_lednop_pr      m3250pa_u1x12_uart0_lednop
 * m3250pa_u1x12_uart0_lednop_pr
 */
static const uint64_t ur_m329_u1x12_uart0_lednop[] = {
  0xbbb686bc1d66ef3a, 0xeeeaafb385ee25bb, 0xcfddf87f7d2eeeee, 0xeb4bf37776442226, 0x277417a0998b21c7,
  0x2609f180904316ef, 0xf84be4ff7e879f05, 0xb46e93fdb53fbb74, 0x27a8e4f1df2c90e1, 0x4c3e7491c74fe0cd,
  0x5f23905398b016f7, 0xf71cb1823af173b3, 0xcdf81895af61583e, 0x180ef5af3c0809c2, 0xe4a7400b79bcd914,
  0xbc67440ef9537a94, 0x5bd8aaa2d3574e31, 0xbb612e65f36dce45, 0x63c81a3f8d163ce1, 0xc970cf4c2b93f756,
  0x2c3a4a5b2c944e32, 0xe5ae3e792bf73433, 0x000000000003e400,
};

/*
 * m329a_u1x12_uart0_lednop_pr_u4    m329p_u1x12_uart0_lednop_pr_u4    m329pa_u1x12_uart0_lednop_pr_u4
 * m3290_u1x12_uart0_lednop_pr_u4    m3290a_u1x12_uart0_lednop_pr_u4   m3290p_u1x12_uart0_lednop_pr_u4
 * m3290pa_u1x12_uart0_lednop_pr_u4  m325_u1x12_uart0_lednop_pr_u4     m325a_u1x12_uart0_lednop_pr_u4
 * m325p_u1x12_uart0_lednop_pr_u4    m325pa_u1x12_uart0_lednop_pr_u4   m3250_u1x12_uart0_lednop_pr_u4
 * m3250a_u1x12_uart0_lednop_pr_u4   m3250p_u1x12_uart0_lednop_pr_u4   m3250pa_u1x12_uart0_lednop_pr_u4
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_pr_u4[] = {
  0xbb686bc1a2447f82, 0xeeaafb38ebe25bbb, 0x425f85c76a1eeeee, 0x4c9eeee859471d69, 0x5c62454dc1b267e9,
  0x7c602410c5bbc9dd, 0x97dfe78167cf5982, 0xa4ff6d4feedd3e12, 0x3dac77cb08786d1b, 0x20fc71d3f83417ea,
  0xd219cc580b2ca6f9, 0xecc11d7a3e7659e8, 0xe59eda0b348a807f, 0x37e06256bd905681, 0x603bd6bcf020270b,
  0x929d002de6f36450, 0xf19d103be54dea53, 0x6f62aa8b4d5d38c6, 0xcd84b997cdb73915, 0xe50d1637c5c9ab83,
  0x61539fa9d598f207, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1,
  0x014f257ee6866587, 0x00000001f260f271,
};

/*
 * m329_u1x12_uart0_lednop_pr_ee_u4  m329a_u1x12_uart0_lednop_pr_ee    m329a_u1x12_uart0_lednop_pr_ee_u4
 * m329p_u1x12_uart0_lednop_pr_ee    m329p_u1x12_uart0_lednop_pr_ee_u4 m329pa_u1x12_uart0_lednop_pr_ee
 * m329pa_u1x12_uart0_lednop_pr_ee_u4 m3290_u1x12_uart0_lednop_pr_ee
 * m3290_u1x12_uart0_lednop_pr_ee_u4 m3290a_u1x12_uart0_lednop_pr_ee
 * m3290a_u1x12_uart0_lednop_pr_ee_u4 m3290p_u1x12_uart0_lednop_pr_ee
 * m3290p_u1x12_uart0_lednop_pr_ee_u4 m3290pa_u1x12_uart0_lednop_pr_ee
 * m3290pa_u1x12_uart0_lednop_pr_ee_u4 m325_u1x12_uart0_lednop_pr_ee
 * m325_u1x12_uart0_lednop_pr_ee_u4  m325a_u1x12_uart0_lednop_pr_ee    m325a_u1x12_uart0_lednop_pr_ee_u4
 * m325p_u1x12_uart0_lednop_pr_ee    m325p_u1x12_uart0_lednop_pr_ee_u4 m325pa_u1x12_uart0_lednop_pr_ee
 * m325pa_u1x12_uart0_lednop_pr_ee_u4 m3250_u1x12_uart0_lednop_pr_ee
 * m3250_u1x12_uart0_lednop_pr_ee_u4 m3250a_u1x12_uart0_lednop_pr_ee
 * m3250a_u1x12_uart0_lednop_pr_ee_u4 m3250p_u1x12_uart0_lednop_pr_ee
 * m3250p_u1x12_uart0_lednop_pr_ee_u4 m3250pa_u1x12_uart0_lednop_pr_ee
 * m3250pa_u1x12_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_pr_ee[] = {
  0xbb686bc1a2447705, 0xeeaaf9ad8be25bbb, 0x5a331a0ba106eeee, 0xf53341dd48a35cd8, 0x65791498d2cfde3b,
  0x048218b7793bb61b, 0xf9e059fcad304f8c, 0xdb53fbb74f848a1f, 0xab5a39c61b46e93f, 0xb30698fa8f2b32a6,
  0x22877c561efd47c1, 0xe8c2cb1148b34eb4, 0x6973d571ac9a426b, 0xf3a6ed1923268e75, 0x2791bdab1aad743a,
  0x0decb65cc5c24228, 0x21f667951b047eb7, 0x4e166fc0c4ad7b00, 0xc8a0c077ad79e040, 0xd4a7253a005bcde6,
  0x718de33a2077ca9b, 0x722adec555169aba, 0x57079b09732f9b6e, 0xe40fca1a2c6f8b93, 0xde50c2a73f53ab31,
  0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f, 0xcb0e9296cf8138cb, 0x36e2029e4afdcd0c,
  0x0000000000013aef,
};

/*
 * m329_u1x12_uart0_lednop_pr_ce_u4  m329a_u1x12_uart0_lednop_pr_ce    m329a_u1x12_uart0_lednop_pr_ce_u4
 * m329p_u1x12_uart0_lednop_pr_ce    m329p_u1x12_uart0_lednop_pr_ce_u4 m329pa_u1x12_uart0_lednop_pr_ce
 * m329pa_u1x12_uart0_lednop_pr_ce_u4 m3290_u1x12_uart0_lednop_pr_ce
 * m3290_u1x12_uart0_lednop_pr_ce_u4 m3290a_u1x12_uart0_lednop_pr_ce
 * m3290a_u1x12_uart0_lednop_pr_ce_u4 m3290p_u1x12_uart0_lednop_pr_ce
 * m3290p_u1x12_uart0_lednop_pr_ce_u4 m3290pa_u1x12_uart0_lednop_pr_ce
 * m3290pa_u1x12_uart0_lednop_pr_ce_u4 m325_u1x12_uart0_lednop_pr_ce
 * m325_u1x12_uart0_lednop_pr_ce_u4  m325a_u1x12_uart0_lednop_pr_ce    m325a_u1x12_uart0_lednop_pr_ce_u4
 * m325p_u1x12_uart0_lednop_pr_ce    m325p_u1x12_uart0_lednop_pr_ce_u4 m325pa_u1x12_uart0_lednop_pr_ce
 * m325pa_u1x12_uart0_lednop_pr_ce_u4 m3250_u1x12_uart0_lednop_pr_ce
 * m3250_u1x12_uart0_lednop_pr_ce_u4 m3250a_u1x12_uart0_lednop_pr_ce
 * m3250a_u1x12_uart0_lednop_pr_ce_u4 m3250p_u1x12_uart0_lednop_pr_ce
 * m3250p_u1x12_uart0_lednop_pr_ce_u4 m3250pa_u1x12_uart0_lednop_pr_ce
 * m3250pa_u1x12_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_pr_ce[] = {
  0xbb686bc1a24458e2, 0x7755743b41225bbb, 0xe98db867ad2f7777, 0xc663bbbbe25e4c29, 0xd29c3d8d29d60666,
  0x27c602410c5bbc9d, 0x4e97fcf02cf94b98, 0x749feda9fddba7c2, 0x7752ae2fae490da3, 0x222fb892c79e012a,
  0xe007ea3e12fc4361, 0x19fac99e2ee372b7, 0xfe0f59ea3f493dcb, 0x9cc580a9888b1c74, 0xf1d7a3e7659e8d21,
  0xb720b348a807fecc, 0x81895af6415a0796, 0xef5af3c0809c2cdf, 0x7400b79bcd914180, 0x7440ef9537a94e4a,
  0x8aaa2d3574e31bc6, 0x25ccbe6db9c31dbd, 0x68b1be2e4d5c1e6c, 0x9cfd4eacc7903f28, 0x989ffde1ef79430a,
  0x0cd0f327f81fc65f, 0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4, 0x792bf734332c3a4a, 0x000006eb8a9c880a,
};

/*
 * m329a_u1x12_uart0_lednop_pr_ee_ce m329p_u1x12_uart0_lednop_pr_ee_ce m329pa_u1x12_uart0_lednop_pr_ee_ce
 * m3290_u1x12_uart0_lednop_pr_ee_ce m3290a_u1x12_uart0_lednop_pr_ee_ce
 * m3290p_u1x12_uart0_lednop_pr_ee_ce m3290pa_u1x12_uart0_lednop_pr_ee_ce
 * m325_u1x12_uart0_lednop_pr_ee_ce  m325a_u1x12_uart0_lednop_pr_ee_ce m325p_u1x12_uart0_lednop_pr_ee_ce
 * m325pa_u1x12_uart0_lednop_pr_ee_ce m3250_u1x12_uart0_lednop_pr_ee_ce
 * m3250a_u1x12_uart0_lednop_pr_ee_ce m3250p_u1x12_uart0_lednop_pr_ee_ce
 * m3250pa_u1x12_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_pr_ee_ce[] = {
  0xdb435e0ea0a22044, 0xaabf58223f12dddd, 0xec82c1de9dbbbbbb, 0x0eefdd26798d457a, 0x8c8843312b8cdd9e,
  0x410c5bbc9dd4149c, 0xe059fa1f9827c602, 0x53fbb74f848e0ff9, 0xaa37f21b46e93fdb, 0x5f9e012a77beceff,
  0xef984e771b972249, 0xf51e57dd4a76b2b1, 0x5edff51f06cc1ad7, 0x4522cd3ad08a0531, 0x1ea3a909afa30b2c,
  0x3768c9193473abb7, 0x1bdab1aaf1b1d79d, 0xcb65cc5c24228279, 0xb33ca8d8226470de, 0xb37e06256bd8598f,
  0x0603bd6bcf020270, 0x3929d002de6f3645, 0x6f19d103be54dea5, 0x76f62aa8b4d5d38c, 0x79b09732f9b6e70c,
  0xe50d165abcb93570, 0x61539fa9d598f207, 0x7cd0f327f8138d28, 0xcb25c33d30ae4fc0, 0x0ccb0e9296cf8138,
  0xf30862029e4afdcd, 0x0000000000000013,
};

/*
 * m329a_u1x12_uart0_lednop_pr_ee_ce_u4 m329p_u1x12_uart0_lednop_pr_ee_ce_u4
 * m329pa_u1x12_uart0_lednop_pr_ee_ce_u4 m3290_u1x12_uart0_lednop_pr_ee_ce_u4
 * m3290a_u1x12_uart0_lednop_pr_ee_ce_u4 m3290p_u1x12_uart0_lednop_pr_ee_ce_u4
 * m3290pa_u1x12_uart0_lednop_pr_ee_ce_u4 m325_u1x12_uart0_lednop_pr_ee_ce_u4
 * m325a_u1x12_uart0_lednop_pr_ee_ce_u4 m325p_u1x12_uart0_lednop_pr_ee_ce_u4
 * m325pa_u1x12_uart0_lednop_pr_ee_ce_u4 m3250_u1x12_uart0_lednop_pr_ee_ce_u4
 * m3250a_u1x12_uart0_lednop_pr_ee_ce_u4 m3250p_u1x12_uart0_lednop_pr_ee_ce_u4
 * m3250pa_u1x12_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_pr_ee_ce_u4[] = {
  0xbb686bc1a243304a, 0xeeaaef212ee25bbb, 0x531342f7276eeeee, 0x8c71f1fddb1e4872, 0xd47dd9201b82246c,
  0x80904316ef2776c5, 0xff62bb3fa6a609f1, 0xf6d4feedd3e12ff9, 0x17d51c8786d1ba4f, 0x4963cf36d01c4b57,
  0x1f097e21b09117dc, 0x78bb8dc0449807f5, 0x2beea53b5b9b7be6, 0xfa8f83660d6bfa8f, 0x669d68450298af6f,
  0xd484d7d185962291, 0x648c9a39d5db8f51, 0x58d578d8ebce9bb4, 0xe62e1211413c8ded, 0x546c1132386f65b2,
  0x0312b5ec2cc7d99e, 0xdeb5e781013859bf, 0xe8016f379b228301, 0xe881df2a6f529c94, 0x15545a6ae9c6378c,
  0x4b997cdb73863b7b, 0x7771a2c6f86e3cd8, 0x0c2a73f53ab337f0, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f,
  0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0x7459e4afdcd0ccb0, 0x0000000027e4a6b3,
};

/*
 * m329a_u1x12_uart0_lednop_ee_hw    m329p_u1x12_uart0_lednop_ee_hw    m329pa_u1x12_uart0_lednop_ee_hw
 * m3290_u1x12_uart0_lednop_ee_hw    m3290a_u1x12_uart0_lednop_ee_hw   m3290p_u1x12_uart0_lednop_ee_hw
 * m3290pa_u1x12_uart0_lednop_ee_hw  m325_u1x12_uart0_lednop_ee_hw     m325a_u1x12_uart0_lednop_ee_hw
 * m325p_u1x12_uart0_lednop_ee_hw    m325pa_u1x12_uart0_lednop_ee_hw   m3250_u1x12_uart0_lednop_ee_hw
 * m3250a_u1x12_uart0_lednop_ee_hw   m3250p_u1x12_uart0_lednop_ee_hw   m3250pa_u1x12_uart0_lednop_ee_hw
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_ee_hw[] = {
  0xddb435e0d1218375, 0x77557cd6c5f12ddd, 0xb0b4663b41777777, 0x77ea6683ba9146b9, 0xc0b015ad89a59fbc,
  0x3e30120862dde4ee, 0x8a1ffd0a67f2b4c1, 0xe93fdb53fbb74f84, 0x32a6ab5a39c61b46, 0x47c1b30698fa8f2b,
  0x4eb422877c561efd, 0x426be8c2cb1148b3, 0x8e756973d571ac9a, 0x743af3a6ed192326, 0x42282791bdab1aad,
  0x7eb70decb65cc5c2, 0x7b0021f667951b04, 0xe0404e166fc0c4ad, 0xcde6c8a0c077ad79, 0xca9bd4a7253a005b,
  0x9aba718de33a2077, 0x9b6e722adec55516, 0x505d8dc79b09732f, 0xff787bde50c2a73f, 0x3cc9fe07f197e627,
  0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf, 0x0002df3072a29e4a,
};

/*
 * m329_u1x12_uart0_lednop_ee_ce_u4_hw m329a_u1x12_uart0_lednop_ee_ce_hw
 * m329a_u1x12_uart0_lednop_ee_ce_u4_hw m329p_u1x12_uart0_lednop_ee_ce_hw
 * m329p_u1x12_uart0_lednop_ee_ce_u4_hw m329pa_u1x12_uart0_lednop_ee_ce_hw
 * m329pa_u1x12_uart0_lednop_ee_ce_u4_hw m3290_u1x12_uart0_lednop_ee_ce_hw
 * m3290_u1x12_uart0_lednop_ee_ce_u4_hw m3290a_u1x12_uart0_lednop_ee_ce_hw
 * m3290a_u1x12_uart0_lednop_ee_ce_u4_hw m3290p_u1x12_uart0_lednop_ee_ce_hw
 * m3290p_u1x12_uart0_lednop_ee_ce_u4_hw m3290pa_u1x12_uart0_lednop_ee_ce_hw
 * m3290pa_u1x12_uart0_lednop_ee_ce_u4_hw m325_u1x12_uart0_lednop_ee_ce_hw
 * m325_u1x12_uart0_lednop_ee_ce_u4_hw m325a_u1x12_uart0_lednop_ee_ce_hw
 * m325a_u1x12_uart0_lednop_ee_ce_u4_hw m325p_u1x12_uart0_lednop_ee_ce_hw
 * m325p_u1x12_uart0_lednop_ee_ce_u4_hw m325pa_u1x12_uart0_lednop_ee_ce_hw
 * m325pa_u1x12_uart0_lednop_ee_ce_u4_hw m3250_u1x12_uart0_lednop_ee_ce_hw
 * m3250_u1x12_uart0_lednop_ee_ce_u4_hw m3250a_u1x12_uart0_lednop_ee_ce_hw
 * m3250a_u1x12_uart0_lednop_ee_ce_u4_hw m3250p_u1x12_uart0_lednop_ee_ce_hw
 * m3250p_u1x12_uart0_lednop_ee_ce_u4_hw m3250pa_u1x12_uart0_lednop_ee_ce_hw
 * m3250pa_u1x12_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u1x12_uart0_lednop_ee_ce_hw[] = {
  0x76d0d783448607e1, 0xdd55de425dc4b777, 0xa62685ee4edddddd, 0x18e3e3fbb63c90e4, 0x87bf7a3af70448d9,
  0xc602410c5bbc9dd0, 0xfcffa14cfe9a9827, 0x27fb6a7f76e9f097, 0xab8bea8e43c368dd, 0xee24b1e79b680e25,
  0xfa8f84bf10d8488b, 0x7ccf1771b9494ce5, 0x51e57dd4a76b736f, 0xedff51f06cc1ad7f, 0x522cd3ad08a05315,
  0xea3a909afa30b2c4, 0x768c9193473abb71, 0xbdab1aaf1b1d79d3, 0xb65cc5c242282791, 0x33ca8d8226470dec,
  0x37e06256bd8598fb, 0x603bd6bcf020270b, 0x929d002de6f36450, 0xf19d103be54dea53, 0x6f62aa8b4d5d38c6,
  0x9b09732f9b6e70c7, 0x50c2a73f505d8dc7, 0xf197e627ff787bde, 0x3f7ec3343cc9fe07, 0xc33d30be347a2ff0,
  0x0e9296cf8138cb25, 0xd6a29e4afdcd0ccb, 0x00000000000a0294,
};

/*
 * m329a_u1x12_uart0_dual            m329p_u1x12_uart0_dual            m329pa_u1x12_uart0_dual
 * m3290_u1x12_uart0_dual            m3290a_u1x12_uart0_dual           m3290p_u1x12_uart0_dual
 * m3290pa_u1x12_uart0_dual          m325_u1x12_uart0_dual             m325a_u1x12_uart0_dual
 * m325p_u1x12_uart0_dual            m325pa_u1x12_uart0_dual           m3250_u1x12_uart0_dual
 * m3250a_u1x12_uart0_dual           m3250p_u1x12_uart0_dual           m3250pa_u1x12_uart0_dual
 */
static const uint64_t ur_m329_u1x12_uart0_dual[] = {
  0x77774c9f37d44511, 0xeeeeedf90044e36b, 0x06dc1e9c02b5b16e, 0xec8a7191dddd3f61, 0x92c83b95f33ed2c4,
  0x7304f8c048218b77, 0x6eeb6819129290c8, 0xe25c40c2860da460, 0x737cefccac049dd3, 0xbd475f7b028a7072,
  0x04508e489fc1c7b9, 0xdc3e144312bfcfdf, 0xcaaeef77cdc38200, 0xb7b8a8432d01f110, 0x096de037fd01cf09,
  0xffe901260b0de579, 0xff6d4feedd3e1209, 0x8a77cb57f86d1ba4, 0x2471d3f83487ea38, 0xd1cc580bf873263d,
  0xc11d7916ecd7c8de, 0xdc5494ac1f7b8e58, 0x81895af64fe2af9d, 0xef5af3c0809c2cdf, 0x9d002de6f2dd4180,
  0xa7017be54dea5392, 0x8de33a2047514085, 0xc1e6c25ccbe6da71, 0xe985727e7f62e4d5, 0x94b67c09c6592e19,
  0x14f257ee68665874, 0x00000000cb7edd10,
};

/*
 * m329_u1x12_uart0_dual_pr_u4       m329a_u1x12_uart0_dual_pr         m329a_u1x12_uart0_dual_pr_u4
 * m329p_u1x12_uart0_dual_pr         m329p_u1x12_uart0_dual_pr_u4      m329pa_u1x12_uart0_dual_pr
 * m329pa_u1x12_uart0_dual_pr_u4     m3290_u1x12_uart0_dual_pr         m3290_u1x12_uart0_dual_pr_u4
 * m3290a_u1x12_uart0_dual_pr        m3290a_u1x12_uart0_dual_pr_u4     m3290p_u1x12_uart0_dual_pr
 * m3290p_u1x12_uart0_dual_pr_u4     m3290pa_u1x12_uart0_dual_pr       m3290pa_u1x12_uart0_dual_pr_u4
 * m325_u1x12_uart0_dual_pr          m325_u1x12_uart0_dual_pr_u4       m325a_u1x12_uart0_dual_pr
 * m325a_u1x12_uart0_dual_pr_u4      m325p_u1x12_uart0_dual_pr         m325p_u1x12_uart0_dual_pr_u4
 * m325pa_u1x12_uart0_dual_pr        m325pa_u1x12_uart0_dual_pr_u4     m3250_u1x12_uart0_dual_pr
 * m3250_u1x12_uart0_dual_pr_u4      m3250a_u1x12_uart0_dual_pr        m3250a_u1x12_uart0_dual_pr_u4
 * m3250p_u1x12_uart0_dual_pr        m3250p_u1x12_uart0_dual_pr_u4     m3250pa_u1x12_uart0_dual_pr
 * m3250pa_u1x12_uart0_dual_pr_u4
 */
static const uint64_t ur_m329_u1x12_uart0_dual_pr[] = {
  0xdd327cde890c365a, 0xbbb7e400028daddd, 0x58a75c1dfb5bbbbb, 0x828c8eeeebd734af, 0xb89bbeb9629b41ec,
  0x180904316ef24ddb, 0x03225252190e609f, 0x1850c1b48c0ddd6d, 0xfccae833ba7c4b88, 0xadb074a70387314b,
  0xe489fc1d4a9bd474, 0x44312bfcfdf04508, 0xeef9b963e00dc3e1, 0x0865a1f2221955dd, 0x06ffa039e130f915,
  0xbcc161bcaf212dbc, 0xfeedd3e1209ffee6, 0x589a86d1ba4ff6d4, 0x3f8310fea3e453be, 0x80aa0f34e2f7c71d,
  0x8033b5ac8ebf9cc5, 0x7486a807fecc11d7, 0x2a4aa4e81e59ed88, 0xc4ad7b27f157ceee, 0xad79e0404e166fc0,
  0x005bcde6c8a0c077, 0x2077ca9bd4a7253a, 0x55169aba718de33a, 0x732f9b6e722adec5, 0xee3458df0dc79b09,
  0x854e7ea75666fe0e, 0x2fcc4ffef0f7bca1, 0xfd86687993fc0fe3, 0x7a617c68f45fe07e, 0x252d9f0271964b86,
  0x8b3c95fb9a19961d, 0x0000001493080b6e,
};

/*
 * m329_u1x12_uart0_dual_pr_ee_u4    m329a_u1x12_uart0_dual_pr_ee      m329a_u1x12_uart0_dual_pr_ee_u4
 * m329p_u1x12_uart0_dual_pr_ee      m329p_u1x12_uart0_dual_pr_ee_u4   m329pa_u1x12_uart0_dual_pr_ee
 * m329pa_u1x12_uart0_dual_pr_ee_u4  m3290_u1x12_uart0_dual_pr_ee      m3290_u1x12_uart0_dual_pr_ee_u4
 * m3290a_u1x12_uart0_dual_pr_ee     m3290a_u1x12_uart0_dual_pr_ee_u4  m3290p_u1x12_uart0_dual_pr_ee
 * m3290p_u1x12_uart0_dual_pr_ee_u4  m3290pa_u1x12_uart0_dual_pr_ee    m3290pa_u1x12_uart0_dual_pr_ee_u4
 * m325_u1x12_uart0_dual_pr_ee       m325_u1x12_uart0_dual_pr_ee_u4    m325a_u1x12_uart0_dual_pr_ee
 * m325a_u1x12_uart0_dual_pr_ee_u4   m325p_u1x12_uart0_dual_pr_ee      m325p_u1x12_uart0_dual_pr_ee_u4
 * m325pa_u1x12_uart0_dual_pr_ee     m325pa_u1x12_uart0_dual_pr_ee_u4  m3250_u1x12_uart0_dual_pr_ee
 * m3250_u1x12_uart0_dual_pr_ee_u4   m3250a_u1x12_uart0_dual_pr_ee     m3250a_u1x12_uart0_dual_pr_ee_u4
 * m3250p_u1x12_uart0_dual_pr_ee     m3250p_u1x12_uart0_dual_pr_ee_u4  m3250pa_u1x12_uart0_dual_pr_ee
 * m3250pa_u1x12_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m329_u1x12_uart0_dual_pr_ee[] = {
  0xddd327cde890cf68, 0xbbbb7e2d1738dadd, 0x179579cedae3bbbb, 0xcfb3134bbaccda75, 0xf53af70dd889ea3e,
  0x8218b77928eddcd1, 0xa4a470ff304f8c04, 0x8369181bbada0644, 0xd06774f8971030a1, 0xff0e01a26d35f995,
  0xe0e87e6f51ec7f61, 0x5fe7ef822847244f, 0xcb91006e1f0a2189, 0x0e9510caaeef77cd, 0x073c2628b150865a,
  0x6f2bc84b6fd5fff4, 0xf84b7dffb9af3058, 0xb46e93fdb53fbb74, 0xe56bee6ab5a39121, 0x57a8f83660c14f51,
  0x1669d68450ef8aea, 0x73484d7d18596229, 0xef673ab4b994b8a9, 0x56ba1d7a89768851, 0x70908a04547cf58d,
  0x823f5b86f65f4b31, 0xb8a9280427f58a8d, 0x0312b5ec9fc55f3b, 0xdeb5e781013859bf, 0xe8016f379b228301,
  0xe881df2a6f529c94, 0x15545a6ae9c6378c, 0x25ccbe6db9c8ab7b, 0x3bb8d1637c371e6c, 0x861539fa9d599bf8,
  0x8cbf313ffbc3def2, 0xfbf619a1e64ff03f, 0x19e985f1a3d17f81, 0x7494b67c09c6592e, 0xba2cf257ee686658,
  0x0000000001593a79,
};

/*
 * m329_u1x12_uart0_dual_pr_ce_u4    m329a_u1x12_uart0_dual_pr_ce      m329a_u1x12_uart0_dual_pr_ce_u4
 * m329p_u1x12_uart0_dual_pr_ce      m329p_u1x12_uart0_dual_pr_ce_u4   m329pa_u1x12_uart0_dual_pr_ce
 * m329pa_u1x12_uart0_dual_pr_ce_u4  m3290_u1x12_uart0_dual_pr_ce      m3290_u1x12_uart0_dual_pr_ce_u4
 * m3290a_u1x12_uart0_dual_pr_ce     m3290a_u1x12_uart0_dual_pr_ce_u4  m3290p_u1x12_uart0_dual_pr_ce
 * m3290p_u1x12_uart0_dual_pr_ce_u4  m3290pa_u1x12_uart0_dual_pr_ce    m3290pa_u1x12_uart0_dual_pr_ce_u4
 * m325_u1x12_uart0_dual_pr_ce       m325_u1x12_uart0_dual_pr_ce_u4    m325a_u1x12_uart0_dual_pr_ce
 * m325a_u1x12_uart0_dual_pr_ce_u4   m325p_u1x12_uart0_dual_pr_ce      m325p_u1x12_uart0_dual_pr_ce_u4
 * m325pa_u1x12_uart0_dual_pr_ce     m325pa_u1x12_uart0_dual_pr_ce_u4  m3250_u1x12_uart0_dual_pr_ce
 * m3250_u1x12_uart0_dual_pr_ce_u4   m3250a_u1x12_uart0_dual_pr_ce     m3250a_u1x12_uart0_dual_pr_ce_u4
 * m3250p_u1x12_uart0_dual_pr_ce     m3250p_u1x12_uart0_dual_pr_ce_u4  m3250pa_u1x12_uart0_dual_pr_ce
 * m3250pa_u1x12_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m329_u1x12_uart0_dual_pr_ce[] = {
  0x774c9f37a2431f02, 0xbbb7e3d3dfb36b77, 0x5cb12bed403bbbbb, 0x179cedddd89c6eac, 0x5188b36842614ad5,
  0x02410c5bbc98e2ee, 0x22525206179827c6, 0x50c1b48c0ddd6d03, 0xcae833ba7c4b8818, 0xc02d1c0c7e619bfc,
  0x27f0635a6f51d2d6, 0xc4aff3f7c1142392, 0xe6e33e00370f8510, 0x2d028a88655777bb, 0xfa039e1318f8a843,
  0x161bcaf212dbc56f, 0xdd3e1260bfee6bcc, 0x086d1ba4ff6d4fee, 0xf36d01c74b717d50, 0xe21b09117dc4963c,
  0x1b8293f5ff51f097, 0xe7b9633ea5ccf177, 0x1c74fe0ea5fa8e37, 0x8ebf9cc580a0a0f9, 0xfeccf1d78033b5ac,
  0x0796b7087486a807, 0xfc55f3bb8a92a93a, 0x13859bf0312b5ec9, 0xb228301deb5e7810, 0xf529c94e8016f379,
  0x9c6378ce881df2a6, 0x3863b7b15545a6ae, 0x86e3cd84b997cdb7, 0xab337f07771a2c6f, 0x787bde50c2a73f53,
  0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0xa4956537459e4afd,
  0x0000000000000001,
};

/*
 * m329a_u1x12_uart0_dual_pr_ee_ce   m329p_u1x12_uart0_dual_pr_ee_ce   m329pa_u1x12_uart0_dual_pr_ee_ce
 * m3290_u1x12_uart0_dual_pr_ee_ce   m3290a_u1x12_uart0_dual_pr_ee_ce  m3290p_u1x12_uart0_dual_pr_ee_ce
 * m3290pa_u1x12_uart0_dual_pr_ee_ce m325_u1x12_uart0_dual_pr_ee_ce    m325a_u1x12_uart0_dual_pr_ee_ce
 * m325p_u1x12_uart0_dual_pr_ee_ce   m325pa_u1x12_uart0_dual_pr_ee_ce  m3250_u1x12_uart0_dual_pr_ee_ce
 * m3250a_u1x12_uart0_dual_pr_ee_ce  m3250p_u1x12_uart0_dual_pr_ee_ce  m3250pa_u1x12_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m329_u1x12_uart0_dual_pr_ee_ce[] = {
  0x7774c9f37d43573e, 0xeeeedf85c49b36b7, 0xd9beec75f47e6eee, 0xaaf2b7707747b1ce, 0xbeec2bdeb2bdc03e,
  0x8218b7792d39dcb8, 0xa4a43a75304f8c04, 0x8369181bbada0644, 0xd06774f8971030a1, 0xa4387ebcc6b7f995,
  0xc1dadcdea3c00d80, 0xbfcfdf04508e489f, 0x3bac00dc3e144312, 0x69b4432abbbddf37, 0x1cf09b0245421968,
  0xbcaf212dbcedffd0, 0xc25d3ffee6bcc161, 0xa3749feda9fddba7, 0x38358effaa37270d, 0x1b9787cb5f9e6da0,
  0x4a76b2b26e984e77, 0x83660d7cf51e56fe, 0x68450298ae037a8f, 0xd7d185962291669d, 0x7b39d5db8ca1d484,
  0x78d8ebd44bb4428f, 0x0908a04547cf58d5, 0x1132386f65f4b317, 0xc5494b313fac546c, 0x1895af64fe2af9dd,
  0xf5af3c0809c2cdf8, 0x400b79bcd914180e, 0x440ef9537a94e4a7, 0xaaa2d3574e31bc67, 0x5ccbe6db9c31dbd8,
  0x771a2c79c371e6c2, 0xa615c9fbab337f07, 0x52d9f0271964b867, 0xb3c95fb9a19961d2, 0x0000004c12c7f6e8,
};

/*
 * m329a_u1x12_uart0_dual_pr_ee_ce_u4 m329p_u1x12_uart0_dual_pr_ee_ce_u4
 * m329pa_u1x12_uart0_dual_pr_ee_ce_u4 m3290_u1x12_uart0_dual_pr_ee_ce_u4
 * m3290a_u1x12_uart0_dual_pr_ee_ce_u4 m3290p_u1x12_uart0_dual_pr_ee_ce_u4
 * m3290pa_u1x12_uart0_dual_pr_ee_ce_u4 m325_u1x12_uart0_dual_pr_ee_ce_u4
 * m325a_u1x12_uart0_dual_pr_ee_ce_u4 m325p_u1x12_uart0_dual_pr_ee_ce_u4
 * m325pa_u1x12_uart0_dual_pr_ee_ce_u4 m3250_u1x12_uart0_dual_pr_ee_ce_u4
 * m3250a_u1x12_uart0_dual_pr_ee_ce_u4 m3250p_u1x12_uart0_dual_pr_ee_ce_u4
 * m3250pa_u1x12_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u1x12_uart0_dual_pr_ee_ce_u4[] = {
  0xd327cde8adbba812, 0xdbf2c9df5cdadddd, 0x35eaf7ab8bdddddd, 0xbadd2d59f6d3dee1, 0xfda3337609932829,
  0xfda7707d7e0e5dd9, 0xc13e30120862dde4, 0xd6d032252523cf5c, 0xb881850c1b48c0dd, 0x257e65a0e53ba7c4,
  0xb3e6c3acce0c8735, 0x8e489fc19adcdea3, 0x144312bfcfdf0450, 0xbddf373a9c00dc3e, 0x42196805a4432abb,
  0xebffd01cf098e0c5, 0x0cc161bcaf212dbf, 0xfbb74f849fe7fe3f, 0x6a7a1b46e93fdb53, 0x3cdb49d8cddc5f54,
  0xf886c2445f71258f, 0xdcd507907fd47c25, 0x53b5b9b9ba678bb8, 0x1b306be7a8f2b7f2, 0x422814c5701bd47c,
  0xbe8c2cb1148b34eb, 0xd9ceaedc650ea426, 0xc6c75ea25da2147b, 0x4845022a3e7ac6ab, 0x8991c37b2fa598b8,
  0x2a4a5989fd62a360, 0xc4ad7b27f157ceee, 0xad79e0404e166fc0, 0x005bcde6c8a0c077, 0x2077ca9bd4a7253a,
  0x55169aba718de33a, 0xe65f36dce18edec5, 0x58df1726ae0f3612, 0xd4eaccdfc1fb7634, 0xffde1ef79430a9cf,
  0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3, 0x020032d2f91ba792,
};

/*
 * m329a_u1x12_uart0_dual_ee_hw      m329p_u1x12_uart0_dual_ee_hw      m329pa_u1x12_uart0_dual_ee_hw
 * m3290_u1x12_uart0_dual_ee_hw      m3290a_u1x12_uart0_dual_ee_hw     m3290p_u1x12_uart0_dual_ee_hw
 * m3290pa_u1x12_uart0_dual_ee_hw    m325_u1x12_uart0_dual_ee_hw       m325a_u1x12_uart0_dual_ee_hw
 * m325p_u1x12_uart0_dual_ee_hw      m325pa_u1x12_uart0_dual_ee_hw     m3250_u1x12_uart0_dual_ee_hw
 * m3250a_u1x12_uart0_dual_ee_hw     m3250p_u1x12_uart0_dual_ee_hw     m3250pa_u1x12_uart0_dual_ee_hw
 */
static const uint64_t ur_m329_u1x12_uart0_dual_ee_hw[] = {
  0x774c9f37a2435202, 0xeeedf8b45ce36b77, 0x5e55e73b6b8eeeee, 0x3ecc4d2eeb3369d4, 0x0eb69be6ba27a8fb,
  0x20862dde4a3b7739, 0x29291c3fcc13e301, 0x60da4606eeb68191, 0x7419dd3e25c40c28, 0x7fc380689b4d7e65,
  0xf83a1f9bd47b1fd8, 0x57f9fbe08a11c913, 0x72e4401b87c28862, 0x83a54432abbbddf3, 0x01cf098a2c542196,
  0x1bcaf212dbf57ffd, 0x7c25befffd48cc16, 0xda3749feda9fddba, 0xf2b5f7355ad1c890, 0x2bd47c1b3060a7a8,
  0x8b34eb422877c575, 0xb9a426be8c2cb114, 0xf7b39d5a5cca5c54, 0xab5d0ebd44bb4428, 0xb84845022a3e7ac6,
  0xc11fadc37b2fa598, 0xdc54940213fac546, 0x81895af64fe2af9d, 0xef5af3c0809c2cdf, 0x7400b79bcd914180,
  0x7440ef9537a94e4a, 0x8aaa2d3574e31bc6, 0x12e65f36dce455bd, 0x854e7ea0bb1b8f36, 0x2fcc4ffef0f7bca1,
  0xfd86687993fc0fe3, 0x7a617c68f45fe07e, 0x252d9f0271964b86, 0x453c95fb9a19961d, 0x0000000002bb5d3d,
};

/*
 * m329a_u1x12_uart0_dual_ee_ce_hw   m329p_u1x12_uart0_dual_ee_ce_hw   m329pa_u1x12_uart0_dual_ee_ce_hw
 * m3290_u1x12_uart0_dual_ee_ce_hw   m3290a_u1x12_uart0_dual_ee_ce_hw  m3290p_u1x12_uart0_dual_ee_ce_hw
 * m3290pa_u1x12_uart0_dual_ee_ce_hw m325_u1x12_uart0_dual_ee_ce_hw    m325a_u1x12_uart0_dual_ee_ce_hw
 * m325p_u1x12_uart0_dual_ee_ce_hw   m325pa_u1x12_uart0_dual_ee_ce_hw  m3250_u1x12_uart0_dual_ee_ce_hw
 * m3250a_u1x12_uart0_dual_ee_ce_hw  m3250p_u1x12_uart0_dual_ee_ce_hw  m3250pa_u1x12_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m329_u1x12_uart0_dual_ee_ce_hw[] = {
  0x74c9f37d4143359b, 0xeedf85c49b36b777, 0xbeec75f47e6eeeee, 0xf2b7707747b1ced9, 0x330a6b5d7dc03eaa,
  0x8218b7792d39dc3c, 0xa4a43a75304f8c04, 0x8369181bbada0644, 0xd06774f8971030a1, 0xa4387ebcc6b7f995,
  0xc1dadcdea3c00d80, 0xbfcfdf04508e489f, 0x3bac00dc3e144312, 0x69b4432abbbddf37, 0x1cf09b0245421968,
  0xbcaf212dbcedffd0, 0x84ba7fffd48cc161, 0x46e93fdb53fbb74f, 0x706b1dff546e4e1b, 0x373acd90ff3cdb40,
  0x94ed6564dd309cee, 0x06cc1af9ea3cadfc, 0xd08a05315c06f51f, 0xafa30b2c4522cd3a, 0xf673abb71943a909,
  0xf1b1d7a89768851e, 0x1211408a8f9eb1aa, 0x226470decbe9662e, 0x8a9296627f58a8d8, 0x312b5ec9fc55f3bb,
  0xeb5e781013859bf0, 0x8016f379b228301d, 0x881df2a6f529c94e, 0x5545a6ae9c6378ce, 0xb997cdb73863b7b1,
  0x39fa9b0ec6e3cd84, 0x0f327f8138d28615, 0x5c33d30ae4fc07cd, 0xb0e9296cf8138cb2, 0xc7fa29e4afdcd0cc,
  0x00000000000075d6,
};

/*
 * m329a_u1x12_uart0_dual_ee_ce_u4_hw m329p_u1x12_uart0_dual_ee_ce_u4_hw
 * m329pa_u1x12_uart0_dual_ee_ce_u4_hw m3290_u1x12_uart0_dual_ee_ce_u4_hw
 * m3290a_u1x12_uart0_dual_ee_ce_u4_hw m3290p_u1x12_uart0_dual_ee_ce_u4_hw
 * m3290pa_u1x12_uart0_dual_ee_ce_u4_hw m325_u1x12_uart0_dual_ee_ce_u4_hw
 * m325a_u1x12_uart0_dual_ee_ce_u4_hw m325p_u1x12_uart0_dual_ee_ce_u4_hw
 * m325pa_u1x12_uart0_dual_ee_ce_u4_hw m3250_u1x12_uart0_dual_ee_ce_u4_hw
 * m3250a_u1x12_uart0_dual_ee_ce_u4_hw m3250p_u1x12_uart0_dual_ee_ce_u4_hw
 * m3250pa_u1x12_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u1x12_uart0_dual_ee_ce_u4_hw[] = {
  0x74c9f37a28d1880b, 0x76fcb277d736b777, 0xdc26bed5ef777777, 0x05375ba5ab3eda7b, 0x5b669d666ec13265,
  0x2dde4fda77093fd3, 0x3cf5cc13e3012086, 0x8c0ddd6d03225252, 0xba7c4b881850c1b4, 0xc8735257e6589ad3,
  0xcdea3b3e6c3acce0, 0xf04508e489fc19ad, 0x0dc3e144312bfcfd, 0x32abbbddf373a9c0, 0x8e0c542196805a44,
  0x12dbfebffd01cf09, 0xff67a1cc161bcaf2, 0xfb6a7f76e9f093fc, 0x8bea8d4f4368dd27, 0x4b1e795f581c19bb,
  0xf84bf10d8488bee2, 0xe2ee3714939bffa8, 0xadfc94ed6e6e6e99, 0xf51f06cc1af9ea3c, 0xcd3ad08a05315c06,
  0xa909afa30b2c4522, 0x851ef673abb71943, 0xb1aaf1b1d7a89768, 0x662e1211408a8f9e, 0xa8d8226470decbe9,
  0xf3bb8a9296627f58, 0x9bf0312b5ec9fc55, 0x301deb5e78101385, 0xc94e8016f379b228, 0x78ce881df2a6f529,
  0xb7b15545a6ae9c63, 0xcd84b997cdb73863, 0x2861539fa82ec6e3, 0xf8cbf313ffbc3def, 0x1fbf619a1e64ff03,
  0xe19e985f1a3d17f8, 0x87494b67c09c6592, 0xb85f4f257ee68665, 0x00000000075d4590,
};

/*
 * m329_u2x8_uart0_noled_pr          m329a_u2x8_uart0_noled            m329a_u2x8_uart0_noled_pr
 * m329p_u2x8_uart0_noled            m329p_u2x8_uart0_noled_pr         m329pa_u2x8_uart0_noled
 * m329pa_u2x8_uart0_noled_pr        m3290_u2x8_uart0_noled            m3290_u2x8_uart0_noled_pr
 * m3290a_u2x8_uart0_noled           m3290a_u2x8_uart0_noled_pr        m3290p_u2x8_uart0_noled
 * m3290p_u2x8_uart0_noled_pr        m3290pa_u2x8_uart0_noled          m3290pa_u2x8_uart0_noled_pr
 * m325_u2x8_uart0_noled             m325_u2x8_uart0_noled_pr          m325a_u2x8_uart0_noled
 * m325a_u2x8_uart0_noled_pr         m325p_u2x8_uart0_noled            m325p_u2x8_uart0_noled_pr
 * m325pa_u2x8_uart0_noled           m325pa_u2x8_uart0_noled_pr        m3250_u2x8_uart0_noled
 * m3250_u2x8_uart0_noled_pr         m3250a_u2x8_uart0_noled           m3250a_u2x8_uart0_noled_pr
 * m3250p_u2x8_uart0_noled           m3250p_u2x8_uart0_noled_pr        m3250pa_u2x8_uart0_noled
 * m3250pa_u2x8_uart0_noled_pr
 */
static const uint64_t ur_m329_u2x8_uart0_noled[] = {
  0xbbbbbb687acdfebe, 0xeeeeeaafb39b3e25, 0x4ddfe2438b78feee, 0xc5d08a66eeec8844, 0xbc9ddf1f85171243,
  0x249827c602410c5b, 0xd3e127bffdfa1e7f, 0x386d1bdaa3949bed, 0x3349ea3f3c77cb24, 0x7ba61be4f471d3f8,
  0x767b48f199cc580b, 0x944ee39630475e2e, 0x9c2cdf81895af615, 0x37807d4180ef5af3, 0x575539794d8ce16f,
  0x2d2c2e718de33a20, 0xbe6d892455bd8aaa, 0xf1a2c79c376c25cc, 0x85727eeacc790347, 0x659289c6592e19e9,
  0x257ee6866587494b, 0x0000f90e93b5c7cf,
};

/*
 * m329a_u2x8_uart0_noled_pr_u4      m329p_u2x8_uart0_noled_pr_u4      m329pa_u2x8_uart0_noled_pr_u4
 * m3290_u2x8_uart0_noled_pr_u4      m3290a_u2x8_uart0_noled_pr_u4     m3290p_u2x8_uart0_noled_pr_u4
 * m3290pa_u2x8_uart0_noled_pr_u4    m325_u2x8_uart0_noled_pr_u4       m325a_u2x8_uart0_noled_pr_u4
 * m325p_u2x8_uart0_noled_pr_u4      m325pa_u2x8_uart0_noled_pr_u4     m3250_u2x8_uart0_noled_pr_u4
 * m3250a_u2x8_uart0_noled_pr_u4     m3250p_u2x8_uart0_noled_pr_u4     m3250pa_u2x8_uart0_noled_pr_u4
 */
static const uint64_t ur_m329_u2x8_uart0_noled_pr_u4[] = {
  0xbbbbb6874488da91, 0x7777557d9cad225b, 0x089154cdb7a36f77, 0xc7d83eeee859471d, 0xdd68bd3b1dcbb623,
  0x827c602410c5bbc9, 0x092f9fe78167e719, 0x68ded51ca4df6e9f, 0xbf51fa03be5843c3, 0x99efb5a38e9fc1a0,
  0xafe8f58731602cb2, 0x807fecc11d7a3e76, 0x8f81e59ed8fb33ca, 0xe70b37e06256bd83, 0xcde01f50603bd6bc,
  0x15d54e5e5363385b, 0x8b4b0b9c6378ce88, 0x2f9b6249156f62aa, 0x6f8b9357079b0973, 0x53ab31e40fca1a2c,
  0xff787bde50c2a73f, 0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf,
  0x01f2632722029e4a,
};

/*
 * m329_u2x8_uart0_noled_pr_ee_u4    m329a_u2x8_uart0_noled_pr_ee      m329a_u2x8_uart0_noled_pr_ee_u4
 * m329p_u2x8_uart0_noled_pr_ee      m329p_u2x8_uart0_noled_pr_ee_u4   m329pa_u2x8_uart0_noled_pr_ee
 * m329pa_u2x8_uart0_noled_pr_ee_u4  m3290_u2x8_uart0_noled_pr_ee      m3290_u2x8_uart0_noled_pr_ee_u4
 * m3290a_u2x8_uart0_noled_pr_ee     m3290a_u2x8_uart0_noled_pr_ee_u4  m3290p_u2x8_uart0_noled_pr_ee
 * m3290p_u2x8_uart0_noled_pr_ee_u4  m3290pa_u2x8_uart0_noled_pr_ee    m3290pa_u2x8_uart0_noled_pr_ee_u4
 * m325_u2x8_uart0_noled_pr_ee       m325_u2x8_uart0_noled_pr_ee_u4    m325a_u2x8_uart0_noled_pr_ee
 * m325a_u2x8_uart0_noled_pr_ee_u4   m325p_u2x8_uart0_noled_pr_ee      m325p_u2x8_uart0_noled_pr_ee_u4
 * m325pa_u2x8_uart0_noled_pr_ee     m325pa_u2x8_uart0_noled_pr_ee_u4  m3250_u2x8_uart0_noled_pr_ee
 * m3250_u2x8_uart0_noled_pr_ee_u4   m3250a_u2x8_uart0_noled_pr_ee     m3250a_u2x8_uart0_noled_pr_ee_u4
 * m3250p_u2x8_uart0_noled_pr_ee     m3250p_u2x8_uart0_noled_pr_ee_u4  m3250pa_u2x8_uart0_noled_pr_ee
 * m3250pa_u2x8_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m329_u2x8_uart0_noled_pr_ee[] = {
  0xdddddb43a2447768, 0xbbbbaabe6b1b112d, 0xd0a6cb88d3da17bb, 0x5fea6683ba9146ba, 0x92befa7388dd8330,
  0x180904316ef2775d, 0x3ff3c0b3ec16609f, 0xd51ca4df6e9f091c, 0x24d56b4738c368de, 0xf83660d31f51e572,
  0xeb422877c57dd7a8, 0x26be8c2cb1148b34, 0xe756979c571ac9a4, 0x875e74ddb7b4782c, 0x451cf230e36355ae,
  0xd6e1bd96cb98b848, 0xb002a254d2a3608f, 0xd79ce166fc0c4ad7, 0x0b79bc03ea0c077a, 0xd102baa9cbca6c67,
  0x55516961738c6f19, 0x2e65f36c4922adec, 0x458df1726ae0f361, 0xe7ea75663c81f943, 0xc4ffef0f7bca1854,
  0x6687993fc0fe32fc, 0x17c68f45fe07efd8, 0xd9f0271964b867a6, 0xc95fb9a19961d252, 0x0000275f47144053,
};

/*
 * m329_u2x8_uart0_noled_pr_ce_u4    m329a_u2x8_uart0_noled_pr_ce      m329a_u2x8_uart0_noled_pr_ce_u4
 * m329p_u2x8_uart0_noled_pr_ce      m329p_u2x8_uart0_noled_pr_ce_u4   m329pa_u2x8_uart0_noled_pr_ce
 * m329pa_u2x8_uart0_noled_pr_ce_u4  m3290_u2x8_uart0_noled_pr_ce      m3290_u2x8_uart0_noled_pr_ce_u4
 * m3290a_u2x8_uart0_noled_pr_ce     m3290a_u2x8_uart0_noled_pr_ce_u4  m3290p_u2x8_uart0_noled_pr_ce
 * m3290p_u2x8_uart0_noled_pr_ce_u4  m3290pa_u2x8_uart0_noled_pr_ce    m3290pa_u2x8_uart0_noled_pr_ce_u4
 * m325_u2x8_uart0_noled_pr_ce       m325_u2x8_uart0_noled_pr_ce_u4    m325a_u2x8_uart0_noled_pr_ce
 * m325a_u2x8_uart0_noled_pr_ce_u4   m325p_u2x8_uart0_noled_pr_ce      m325p_u2x8_uart0_noled_pr_ce_u4
 * m325pa_u2x8_uart0_noled_pr_ce     m325pa_u2x8_uart0_noled_pr_ce_u4  m3250_u2x8_uart0_noled_pr_ce
 * m3250_u2x8_uart0_noled_pr_ce_u4   m3250a_u2x8_uart0_noled_pr_ce     m3250a_u2x8_uart0_noled_pr_ce_u4
 * m3250p_u2x8_uart0_noled_pr_ce     m3250p_u2x8_uart0_noled_pr_ce_u4  m3250pa_u2x8_uart0_noled_pr_ce
 * m3250pa_u2x8_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m329_u2x8_uart0_noled_pr_ce[] = {
  0xbbbbb68744889202, 0x777755743bc2a25b, 0xf4ec78cc5fa6ef77, 0x82d05c77777c4bc8, 0x93baccdb1591414c,
  0xf304f8c048218b77, 0xf849c9ff9e059f90, 0x1b46f6a8e526fb74, 0x012a76fe5c5f5c92, 0x4361222fb892c79e,
  0xb8ff3107ea3e12fc, 0x9ee58cfd64cf1771, 0x8e3a7f07acf51c9e, 0xd1eb0e62c051f3a4, 0xffd99e3af47ced5f,
  0xc0f2d6e1f6679500, 0x859bf0312b5ec1c7, 0xf00fa8301deb5e73, 0xeaa72f29b19c2de6, 0xa585ce31bc67440a,
  0x9b624863b7b15545, 0x8b9357079b09732f, 0xab31e40fca1a2c6f, 0x787bde50c2a73f53, 0xc9fe07f197e627ff,
  0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0xbae41ca2029e4afd, 0x0000000000000001,
};

/*
 * m329a_u2x8_uart0_noled_pr_ee_ce   m329p_u2x8_uart0_noled_pr_ee_ce   m329pa_u2x8_uart0_noled_pr_ee_ce
 * m3290_u2x8_uart0_noled_pr_ee_ce   m3290a_u2x8_uart0_noled_pr_ee_ce  m3290p_u2x8_uart0_noled_pr_ee_ce
 * m3290pa_u2x8_uart0_noled_pr_ee_ce m325_u2x8_uart0_noled_pr_ee_ce    m325a_u2x8_uart0_noled_pr_ee_ce
 * m325p_u2x8_uart0_noled_pr_ee_ce   m325pa_u2x8_uart0_noled_pr_ee_ce  m3250_u2x8_uart0_noled_pr_ee_ce
 * m3250a_u2x8_uart0_noled_pr_ee_ce  m3250p_u2x8_uart0_noled_pr_ee_ce  m3250pa_u2x8_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m329_u2x8_uart0_noled_pr_ee_ce[] = {
  0xddddb43d41447705, 0xbbaabf582a8b12dd, 0x69648533df23bbbb, 0x9e0eefdd26798bd7, 0xb291da4c34ad14ad,
  0x02410c5bbc9ddb0d, 0xfcf02cf93a9827c6, 0x472937dba7c2515b, 0x77fd51bf90da37b5, 0x3643fcf00953bc08,
  0x958f7cc273b8dceb, 0xd6bfa8f2bea253b5, 0x298ac27fa8f83660, 0x5962291669d68450, 0x5dba711d484d7d18,
  0x79d376ded1e0b39d, 0xe791871b1aaf1b1d, 0x0decb65cc5c24228, 0xce89534a8d822647, 0x73859bf0312b5ec2,
  0xe6f00fa8301deb5e, 0x0aeaa72f29b19c2d, 0x45a585ce31bc6744, 0x2f9b624863b7b155, 0xabcb9357079b0973,
  0x9d598f207e50d165, 0x7f8138d2861539fa, 0xd30ae4fc07cd0f32, 0x296cf8138cb25c33, 0x29e4afdcd0ccb0e9,
  0x000000009f98c620,
};

/*
 * m329a_u2x8_uart0_noled_pr_ee_ce_u4 m329p_u2x8_uart0_noled_pr_ee_ce_u4
 * m329pa_u2x8_uart0_noled_pr_ee_ce_u4 m3290_u2x8_uart0_noled_pr_ee_ce_u4
 * m3290a_u2x8_uart0_noled_pr_ee_ce_u4 m3290p_u2x8_uart0_noled_pr_ee_ce_u4
 * m3290pa_u2x8_uart0_noled_pr_ee_ce_u4 m325_u2x8_uart0_noled_pr_ee_ce_u4
 * m325a_u2x8_uart0_noled_pr_ee_ce_u4 m325p_u2x8_uart0_noled_pr_ee_ce_u4
 * m325pa_u2x8_uart0_noled_pr_ee_ce_u4 m3250_u2x8_uart0_noled_pr_ee_ce_u4
 * m3250a_u2x8_uart0_noled_pr_ee_ce_u4 m3250p_u2x8_uart0_noled_pr_ee_ce_u4
 * m3250pa_u2x8_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u2x8_uart0_noled_pr_ee_ce_u4[] = {
  0xbbbbb68744863375, 0xeeeeaaef21c9625b, 0x18934b0cf519eeee, 0xa82c71f1fddb1e48, 0x4b1568dd5ce8e3d3,
  0x9f180904316ef277, 0xc7ffec5767f76a60, 0xf6a8e526fb74f848, 0xe0dc5f54721e1b46, 0x5f71258f3cdb4070,
  0x4fd47c25f886c244, 0xf7ccf1771b9d1f52, 0xf51e57d44a76b736, 0x584ff51f06cc1ad7, 0x4522cd3ad08a0531,
  0x4e23a909afa30b2c, 0x6edbda3c1673abb7, 0x30e36355e363af3a, 0x96cb98b848451cf2, 0x2a6951b044c8e1bd,
  0xb37e06256bd859d1, 0x01f50603bd6bce70, 0x54e5e5363385bcde, 0xb0b9c6378ce8815d, 0x6c490c76f62aa8b4,
  0x1be1b8f3612e65f3, 0xd4eaccdfc1ddc68b, 0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd,
  0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3, 0x013f3d89edd16792,
};

/*
 * m329a_u2x8_uart0_noled_ee_hw      m329p_u2x8_uart0_noled_ee_hw      m329pa_u2x8_uart0_noled_ee_hw
 * m3290_u2x8_uart0_noled_ee_hw      m3290a_u2x8_uart0_noled_ee_hw     m3290p_u2x8_uart0_noled_ee_hw
 * m3290pa_u2x8_uart0_noled_ee_hw    m325_u2x8_uart0_noled_ee_hw       m325a_u2x8_uart0_noled_ee_hw
 * m325p_u2x8_uart0_noled_ee_hw      m325pa_u2x8_uart0_noled_ee_hw     m3250_u2x8_uart0_noled_ee_hw
 * m3250a_u2x8_uart0_noled_ee_hw     m3250p_u2x8_uart0_noled_ee_hw     m3250pa_u2x8_uart0_noled_ee_hw
 */
static const uint64_t ur_m329_u2x8_uart0_noled_ee_hw[] = {
  0xdddddb43a243280b, 0xbbbbaabe6b1b112d, 0x75a14d971d1a7bbb, 0x60bfd4cd0775228d, 0xddc9cf5b5a71bb06,
  0x827c602410c5bbc9, 0x091c3ffa14cfb059, 0x68ded51ca4df6e9f, 0xe57224d56b4738c3, 0xd7a8f83660d31f51,
  0x8b34eb422877c57d, 0xc9a426be8c2cb114, 0x782ce756979c571a, 0x55ae875e74ddb7b4, 0xb848451cf230e363,
  0x608fd6e1bd96cb98, 0x4ad7b002a254d2a3, 0x077ad79ce166fc0c, 0x6c670b79bc03ea0c, 0x6f19d102baa9cbca,
  0xadec55516961738c, 0xf3612e65f36c4922, 0xca1854e7ea0bb1b8, 0xfe32fcc4ffef0f7b, 0x07efd86687993fc0,
  0xb867a617c68f45fe, 0x61d252d9f0271964, 0x559453c95fb9a199, 0x0000000000005bf9,
};

/*
 * m329_u2x8_uart0_noled_ee_ce_u4_hw m329a_u2x8_uart0_noled_ee_ce_hw   m329a_u2x8_uart0_noled_ee_ce_u4_hw
 * m329p_u2x8_uart0_noled_ee_ce_hw   m329p_u2x8_uart0_noled_ee_ce_u4_hw
 * m329pa_u2x8_uart0_noled_ee_ce_hw  m329pa_u2x8_uart0_noled_ee_ce_u4_hw
 * m3290_u2x8_uart0_noled_ee_ce_hw   m3290_u2x8_uart0_noled_ee_ce_u4_hw
 * m3290a_u2x8_uart0_noled_ee_ce_hw  m3290a_u2x8_uart0_noled_ee_ce_u4_hw
 * m3290p_u2x8_uart0_noled_ee_ce_hw  m3290p_u2x8_uart0_noled_ee_ce_u4_hw
 * m3290pa_u2x8_uart0_noled_ee_ce_hw m3290pa_u2x8_uart0_noled_ee_ce_u4_hw
 * m325_u2x8_uart0_noled_ee_ce_hw    m325_u2x8_uart0_noled_ee_ce_u4_hw m325a_u2x8_uart0_noled_ee_ce_hw
 * m325a_u2x8_uart0_noled_ee_ce_u4_hw m325p_u2x8_uart0_noled_ee_ce_hw
 * m325p_u2x8_uart0_noled_ee_ce_u4_hw m325pa_u2x8_uart0_noled_ee_ce_hw
 * m325pa_u2x8_uart0_noled_ee_ce_u4_hw m3250_u2x8_uart0_noled_ee_ce_hw
 * m3250_u2x8_uart0_noled_ee_ce_u4_hw m3250a_u2x8_uart0_noled_ee_ce_hw
 * m3250a_u2x8_uart0_noled_ee_ce_u4_hw m3250p_u2x8_uart0_noled_ee_ce_hw
 * m3250p_u2x8_uart0_noled_ee_ce_u4_hw m3250pa_u2x8_uart0_noled_ee_ce_hw
 * m3250pa_u2x8_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u2x8_uart0_noled_ee_ce_hw[] = {
  0xbbbbb68744864aa4, 0xeeeeaaef21c9625b, 0x18934b0cf519eeee, 0xa82c71f1fddb1e48, 0xea4cb17dcfb8e3d3,
  0x13e30120862dde4e, 0x231fffa14cfeed4c, 0x1bdaa3949bedd3e1, 0xc383717d51c8786d, 0x117dc4963cf36d01,
  0xe47f51f097e21b09, 0x6def99e2ee3712a2, 0xafea3cafa894ed6e, 0x62b09fea3e0d9835, 0x588a459a75a1140a,
  0x6e9c4752135f4616, 0x74ddb7b4782ce757, 0xe461c6c6abc6c75e, 0x7b2d973170908a39, 0xa254d2a3608991c3,
  0xe166fc0c4ad7b0b3, 0xbc03ea0c077ad79c, 0xbaa9cbca6c670b79, 0x6961738c6f19d102, 0xe6d89218edec5551,
  0xd4176371e6c25ccb, 0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f,
  0xbf734332c3a4a5b3, 0x0005017b13e8a792,
};

/*
 * m329_u2x8_uart0_lednop_pr         m329a_u2x8_uart0_lednop           m329a_u2x8_uart0_lednop_pr
 * m329p_u2x8_uart0_lednop           m329p_u2x8_uart0_lednop_pr        m329pa_u2x8_uart0_lednop
 * m329pa_u2x8_uart0_lednop_pr       m3290_u2x8_uart0_lednop           m3290_u2x8_uart0_lednop_pr
 * m3290a_u2x8_uart0_lednop          m3290a_u2x8_uart0_lednop_pr       m3290p_u2x8_uart0_lednop
 * m3290p_u2x8_uart0_lednop_pr       m3290pa_u2x8_uart0_lednop         m3290pa_u2x8_uart0_lednop_pr
 * m325_u2x8_uart0_lednop            m325_u2x8_uart0_lednop_pr         m325a_u2x8_uart0_lednop
 * m325a_u2x8_uart0_lednop_pr        m325p_u2x8_uart0_lednop           m325p_u2x8_uart0_lednop_pr
 * m325pa_u2x8_uart0_lednop          m325pa_u2x8_uart0_lednop_pr       m3250_u2x8_uart0_lednop
 * m3250_u2x8_uart0_lednop_pr        m3250a_u2x8_uart0_lednop          m3250a_u2x8_uart0_lednop_pr
 * m3250p_u2x8_uart0_lednop          m3250p_u2x8_uart0_lednop_pr       m3250pa_u2x8_uart0_lednop
 * m3250pa_u2x8_uart0_lednop_pr
 */
static const uint64_t ur_m329_u2x8_uart0_lednop[] = {
  0xddddddb43d66ef3a, 0x77777557d9c2f712, 0x1367eefc3fbe9777, 0xe3f5a5f9bbbb2211, 0x7793ba0bd04cc590,
  0x829304f8c048218b, 0xba7c25f27fbf43cf, 0x870da37b5472937d, 0x06693d47278ef964, 0xb7ba61f3a48e3a7f,
  0x9d9af91c829cc580, 0xc1f7b8e58c11d78b, 0x4e166fc0c4ad7b0a, 0xc8a0c077ad79e040, 0xd4a7253a005bcde6,
  0x718de33a2077ca9b, 0x722adec555169aba, 0xe70ddb09732f9b6e, 0xbab31e40d1fc68b1, 0x71964b867a615c9f,
  0xa19961d252d964a2, 0x20072d71f3c95fb9, 0x000000000000001f,
};

/*
 * m329a_u2x8_uart0_lednop_pr_u4     m329p_u2x8_uart0_lednop_pr_u4     m329pa_u2x8_uart0_lednop_pr_u4
 * m3290_u2x8_uart0_lednop_pr_u4     m3290a_u2x8_uart0_lednop_pr_u4    m3290p_u2x8_uart0_lednop_pr_u4
 * m3290pa_u2x8_uart0_lednop_pr_u4   m325_u2x8_uart0_lednop_pr_u4      m325a_u2x8_uart0_lednop_pr_u4
 * m325p_u2x8_uart0_lednop_pr_u4     m325pa_u2x8_uart0_lednop_pr_u4    m3250_u2x8_uart0_lednop_pr_u4
 * m3250a_u2x8_uart0_lednop_pr_u4    m3250p_u2x8_uart0_lednop_pr_u4    m3250pa_u2x8_uart0_lednop_pr_u4
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_pr_u4[] = {
  0xdddddb43a2447f82, 0x7777557d9c75f12d, 0xb4a12fc2e3b50f77, 0xf4a64f77742ca38e, 0xeeae3122a6e0d933,
  0xc13e30120862dde4, 0x094beff3c0b3e7ac, 0x68ded51ca4df6e9f, 0xbf51ed63be5843c3, 0x37c907e38e9fc1a0,
  0xcf4690ce62c05965, 0x03ff6608ebd1f3b2, 0xb40f2cf6d059a454, 0x3859bf0312b5ec82, 0x228301deb5e78101,
  0x529c94e8016f379b, 0xc6378ce881df2a6f, 0xc8ab7b15545a6ae9, 0x5c1e6c25ccbe6db9, 0x903f2868b1be2e4d,
  0x79430a9cfd4eacc7, 0x1fc65f989ffde1ef, 0xc0fdfb0cd0f327f8, 0x970cf4c2f8d1e8bf, 0x2c3a4a5b3e04e32c,
  0x93880a792bf73433, 0x00000000000f9307,
};

/*
 * m329_u2x8_uart0_lednop_pr_ee_u4   m329a_u2x8_uart0_lednop_pr_ee     m329a_u2x8_uart0_lednop_pr_ee_u4
 * m329p_u2x8_uart0_lednop_pr_ee     m329p_u2x8_uart0_lednop_pr_ee_u4  m329pa_u2x8_uart0_lednop_pr_ee
 * m329pa_u2x8_uart0_lednop_pr_ee_u4 m3290_u2x8_uart0_lednop_pr_ee     m3290_u2x8_uart0_lednop_pr_ee_u4
 * m3290a_u2x8_uart0_lednop_pr_ee    m3290a_u2x8_uart0_lednop_pr_ee_u4 m3290p_u2x8_uart0_lednop_pr_ee
 * m3290p_u2x8_uart0_lednop_pr_ee_u4 m3290pa_u2x8_uart0_lednop_pr_ee
 * m3290pa_u2x8_uart0_lednop_pr_ee_u4 m325_u2x8_uart0_lednop_pr_ee
 * m325_u2x8_uart0_lednop_pr_ee_u4   m325a_u2x8_uart0_lednop_pr_ee     m325a_u2x8_uart0_lednop_pr_ee_u4
 * m325p_u2x8_uart0_lednop_pr_ee     m325p_u2x8_uart0_lednop_pr_ee_u4  m325pa_u2x8_uart0_lednop_pr_ee
 * m325pa_u2x8_uart0_lednop_pr_ee_u4 m3250_u2x8_uart0_lednop_pr_ee     m3250_u2x8_uart0_lednop_pr_ee_u4
 * m3250a_u2x8_uart0_lednop_pr_ee    m3250a_u2x8_uart0_lednop_pr_ee_u4 m3250p_u2x8_uart0_lednop_pr_ee
 * m3250p_u2x8_uart0_lednop_pr_ee_u4 m3250pa_u2x8_uart0_lednop_pr_ee
 * m3250pa_u2x8_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_pr_ee[] = {
  0xdddddb43a2447705, 0x7777557cd6c5f12d, 0x6c2d198d05d08377, 0x1dfa99a0eea451ae, 0x0db2bc8a4c6967ef,
  0xc602410c5bbc9ddb, 0x0ffcf02cfe569827, 0xb5472937dba7c245, 0x95355ad1ce30da37, 0x3e0d9834c7d47959,
  0x75a1143be2b0f7ea, 0x135f4616588a459a, 0x73ab4b9eab8d64d2, 0xa1d79d3768c91934, 0x11413c8ded58d56b,
  0xf5b86f65b2e62e12, 0xd8010fb33ca8d823, 0x020270b37e06256b, 0x6f36450603bd6bcf, 0x54dea53929d002de,
  0xd5d38c6f19d103be, 0xdb739156f62aa8b4, 0x5c9ab83cd84b997c, 0x598f207e50d1637c, 0xc3def2861539fa9d,
  0x4ff03f8cbf313ffb, 0xd17f81fbf619a1e6, 0xc6592e19e985f1a3, 0x6866587494b67c09, 0xd779b71014f257ee,
  0x0000000000000009,
};

/*
 * m329_u2x8_uart0_lednop_pr_ce_u4   m329a_u2x8_uart0_lednop_pr_ce     m329a_u2x8_uart0_lednop_pr_ce_u4
 * m329p_u2x8_uart0_lednop_pr_ce     m329p_u2x8_uart0_lednop_pr_ce_u4  m329pa_u2x8_uart0_lednop_pr_ce
 * m329pa_u2x8_uart0_lednop_pr_ce_u4 m3290_u2x8_uart0_lednop_pr_ce     m3290_u2x8_uart0_lednop_pr_ce_u4
 * m3290a_u2x8_uart0_lednop_pr_ce    m3290a_u2x8_uart0_lednop_pr_ce_u4 m3290p_u2x8_uart0_lednop_pr_ce
 * m3290p_u2x8_uart0_lednop_pr_ce_u4 m3290pa_u2x8_uart0_lednop_pr_ce
 * m3290pa_u2x8_uart0_lednop_pr_ce_u4 m325_u2x8_uart0_lednop_pr_ce
 * m325_u2x8_uart0_lednop_pr_ce_u4   m325a_u2x8_uart0_lednop_pr_ce     m325a_u2x8_uart0_lednop_pr_ce_u4
 * m325p_u2x8_uart0_lednop_pr_ce     m325p_u2x8_uart0_lednop_pr_ce_u4  m325pa_u2x8_uart0_lednop_pr_ce
 * m325pa_u2x8_uart0_lednop_pr_ce_u4 m3250_u2x8_uart0_lednop_pr_ce     m3250_u2x8_uart0_lednop_pr_ce_u4
 * m3250a_u2x8_uart0_lednop_pr_ce    m3250a_u2x8_uart0_lednop_pr_ce_u4 m3250p_u2x8_uart0_lednop_pr_ce
 * m3250p_u2x8_uart0_lednop_pr_ce_u4 m3250pa_u2x8_uart0_lednop_pr_ce
 * m3250pa_u2x8_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_pr_ce[] = {
  0xdddddb43a24458e2, 0xbbbbaaba1da0912d, 0x14f4c6dc33d697bb, 0x336331ddddf12f26, 0x4ee94e1ec694eb03,
  0xcc13e30120862dde, 0xe1274bfe78167ca5, 0x6d1bdaa3949bedd3, 0x0953ba95717d7248, 0x1b09117dc4963cf0,
  0x95bf003f51f097e2, 0xee58cfd64cf1771b, 0xe3a7f07acf51fa49, 0x690ce62c054c4458, 0xf6678ebd1f3b2cf4,
  0x3cb5b9059a45403f, 0x66fc0c4ad7b20ad0, 0x0c077ad79e0404e1, 0x7253a005bcde6c8a, 0xde33a2077ca9bd4a,
  0xedec555169aba718, 0xf3612e65f36dce18, 0xf943458df1726ae0, 0x1854e7ea75663c81, 0x32fcc4ffef0f7bca,
  0xefd86687993fc0fe, 0x67a617c68f45fe07, 0xd252d9f0271964b8, 0x4053c95fb9a19961, 0x00000000375c54e4,
};

/*
 * m329a_u2x8_uart0_lednop_pr_ee_ce  m329p_u2x8_uart0_lednop_pr_ee_ce  m329pa_u2x8_uart0_lednop_pr_ee_ce
 * m3290_u2x8_uart0_lednop_pr_ee_ce  m3290a_u2x8_uart0_lednop_pr_ee_ce m3290p_u2x8_uart0_lednop_pr_ee_ce
 * m3290pa_u2x8_uart0_lednop_pr_ee_ce m325_u2x8_uart0_lednop_pr_ee_ce
 * m325a_u2x8_uart0_lednop_pr_ee_ce  m325p_u2x8_uart0_lednop_pr_ee_ce  m325pa_u2x8_uart0_lednop_pr_ee_ce
 * m3250_u2x8_uart0_lednop_pr_ee_ce  m3250a_u2x8_uart0_lednop_pr_ee_ce m3250p_u2x8_uart0_lednop_pr_ee_ce
 * m3250pa_u2x8_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_pr_ee_ce[] = {
  0xeeeeda1ea0a22044, 0xddd55fac111f896e, 0xbd764160ef4edddd, 0xcf0777ee933cc6a2, 0x4e4644219895c66e,
  0x0120862dde4eea0a, 0xfcf02cfd0fcc13e3, 0x472937dba7c24707, 0x77fd51bf90da37b5, 0x124afcf00953bdf6,
  0x958f7cc273b8dcb9, 0xd6bfa8f2beea53b5, 0x298af6ffa8f83660, 0x5962291669d68450, 0x5db8f51d484d7d18,
  0xbce9bb4648c9a39d, 0x13c8ded58d578d8e, 0x86f65b2e62e12114, 0xcc7d99e546c11323, 0x13859bf0312b5ec2,
  0xb228301deb5e7810, 0xf529c94e8016f379, 0x9c6378ce881df2a6, 0x3863b7b15545a6ae, 0xab83cd84b997cdb7,
  0x903f2868b2d5e5c9, 0x69430a9cfd4eacc7, 0x7e03e687993fc09c, 0x09c6592e19e98572, 0xee6866587494b67c,
  0x009f98431014f257,
};

/*
 * m329a_u2x8_uart0_lednop_pr_ee_ce_u4 m329p_u2x8_uart0_lednop_pr_ee_ce_u4
 * m329pa_u2x8_uart0_lednop_pr_ee_ce_u4 m3290_u2x8_uart0_lednop_pr_ee_ce_u4
 * m3290a_u2x8_uart0_lednop_pr_ee_ce_u4 m3290p_u2x8_uart0_lednop_pr_ee_ce_u4
 * m3290pa_u2x8_uart0_lednop_pr_ee_ce_u4 m325_u2x8_uart0_lednop_pr_ee_ce_u4
 * m325a_u2x8_uart0_lednop_pr_ee_ce_u4 m325p_u2x8_uart0_lednop_pr_ee_ce_u4
 * m325pa_u2x8_uart0_lednop_pr_ee_ce_u4 m3250_u2x8_uart0_lednop_pr_ee_ce_u4
 * m3250a_u2x8_uart0_lednop_pr_ee_ce_u4 m3250p_u2x8_uart0_lednop_pr_ee_ce_u4
 * m3250pa_u2x8_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_pr_ee_ce_u4[] = {
  0xdddddb43a243304a, 0x777755779097712d, 0x392989a17b93b777, 0x364638f8feed8f24, 0x62ea3eec900dc112,
  0xf8c048218b7793bb, 0xfcffb15d9fd35304, 0xed51ca4df6e9f097, 0x5ab8bea8e43c368d, 0xbee24b1e79b680e2,
  0x3fa8f84bf10d8488, 0xdf33c5dc6e0224c0, 0xd4795f7529dadcdb, 0x7b7fd47c1b306b5f, 0x148b34eb422814c5,
  0x7a8ea426be8c2cb1, 0xdda32464d1ceaedc, 0x6f6ac6abc6c75e74, 0x2d973170908a09e4, 0xccf2a3608991c37b,
  0xcdf81895af61663e, 0x180ef5af3c0809c2, 0xe4a7400b79bcd914, 0xbc67440ef9537a94, 0xdbd8aaa2d3574e31,
  0xe6c25ccbe6db9c31, 0xbf83bb8d1637c371, 0xef2861539fa9d599, 0x03f8cbf313ffbc3d, 0xf81fbf619a1e64ff,
  0x92e19e985f1a3d17, 0x6587494b67c09c65, 0x359ba2cf257ee686, 0x0000000000013f25,
};

/*
 * m329a_u2x8_uart0_lednop_ee_hw     m329p_u2x8_uart0_lednop_ee_hw     m329pa_u2x8_uart0_lednop_ee_hw
 * m3290_u2x8_uart0_lednop_ee_hw     m3290a_u2x8_uart0_lednop_ee_hw    m3290p_u2x8_uart0_lednop_ee_hw
 * m3290pa_u2x8_uart0_lednop_ee_hw   m325_u2x8_uart0_lednop_ee_hw      m325a_u2x8_uart0_lednop_ee_hw
 * m325p_u2x8_uart0_lednop_ee_hw     m325pa_u2x8_uart0_lednop_ee_hw    m3250_u2x8_uart0_lednop_ee_hw
 * m3250a_u2x8_uart0_lednop_ee_hw    m3250p_u2x8_uart0_lednop_ee_hw    m3250pa_u2x8_uart0_lednop_ee_hw
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_ee_hw[] = {
  0xeeeeeda1d1218375, 0xbbbbaabe6b62f896, 0x5cd85a331da0bbbb, 0xde3bf53341dd48a3, 0x7760580ad6c4d2cf,
  0x609f180904316ef2, 0xc2450ffe8533f95a, 0xda37b5472937dba7, 0x795995355ad1ce30, 0xf7ea3e0d9834c7d4,
  0x459a75a1143be2b0, 0x64d2135f4616588a, 0x193473ab4b9eab8d, 0xd56ba1d79d3768c9, 0x2e1211413c8ded58,
  0xd823f5b86f65b2e6, 0x256bd8010fb33ca8, 0x6bcf020270b37e06, 0x02de6f36450603bd, 0x03be54dea53929d0,
  0xa8b4d5d38c6f19d1, 0x997cdb739156f62a, 0x39fa82ec6e3cd84b, 0x313ffbc3def28615, 0x19a1e64ff03f8cbf,
  0x85f1a3d17f81fbf6, 0xb67c09c6592e19e9, 0xf257ee6866587494, 0x00000016f9839514,
};

/*
 * m329_u2x8_uart0_lednop_ee_ce_u4_hw m329a_u2x8_uart0_lednop_ee_ce_hw
 * m329a_u2x8_uart0_lednop_ee_ce_u4_hw m329p_u2x8_uart0_lednop_ee_ce_hw
 * m329p_u2x8_uart0_lednop_ee_ce_u4_hw m329pa_u2x8_uart0_lednop_ee_ce_hw
 * m329pa_u2x8_uart0_lednop_ee_ce_u4_hw m3290_u2x8_uart0_lednop_ee_ce_hw
 * m3290_u2x8_uart0_lednop_ee_ce_u4_hw m3290a_u2x8_uart0_lednop_ee_ce_hw
 * m3290a_u2x8_uart0_lednop_ee_ce_u4_hw m3290p_u2x8_uart0_lednop_ee_ce_hw
 * m3290p_u2x8_uart0_lednop_ee_ce_u4_hw m3290pa_u2x8_uart0_lednop_ee_ce_hw
 * m3290pa_u2x8_uart0_lednop_ee_ce_u4_hw m325_u2x8_uart0_lednop_ee_ce_hw
 * m325_u2x8_uart0_lednop_ee_ce_u4_hw m325a_u2x8_uart0_lednop_ee_ce_hw
 * m325a_u2x8_uart0_lednop_ee_ce_u4_hw m325p_u2x8_uart0_lednop_ee_ce_hw
 * m325p_u2x8_uart0_lednop_ee_ce_u4_hw m325pa_u2x8_uart0_lednop_ee_ce_hw
 * m325pa_u2x8_uart0_lednop_ee_ce_u4_hw m3250_u2x8_uart0_lednop_ee_ce_hw
 * m3250_u2x8_uart0_lednop_ee_ce_u4_hw m3250a_u2x8_uart0_lednop_ee_ce_hw
 * m3250a_u2x8_uart0_lednop_ee_ce_u4_hw m3250p_u2x8_uart0_lednop_ee_ce_hw
 * m3250p_u2x8_uart0_lednop_ee_ce_u4_hw m3250pa_u2x8_uart0_lednop_ee_ce_hw
 * m3250pa_u2x8_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u2x8_uart0_lednop_ee_ce_hw[] = {
  0xbbbbb687448607e1, 0xeeeeaaef212ee25b, 0x72531342f7276eee, 0x6c8c71f1fddb1e48, 0xe843dfbd1d7b8224,
  0x13e30120862dde4e, 0x4bfe7fd0a67f4d4c, 0x46f6a8e526fb74f8, 0x712d5c5f54721e1b, 0x445f71258f3cdb40,
  0x672fd47c25f886c2, 0x9b7be678bb8dca4a, 0x6bfa8f2beea53b5b, 0x98af6ffa8f83660d, 0x962291669d684502,
  0xdb8f51d484d7d185, 0xce9bb4648c9a39d5, 0x3c8ded58d578d8eb, 0x6f65b2e62e121141, 0xc7d99e546c113238,
  0x3859bf0312b5ec2c, 0x228301deb5e78101, 0x529c94e8016f379b, 0xc6378ce881df2a6f, 0x863b7b15545a6ae9,
  0x6e3cd84b997cdb73, 0xdef2861539fa82ec, 0xf03f8cbf313ffbc3, 0x7f81fbf619a1e64f, 0x592e19e985f1a3d1,
  0x66587494b67c09c6, 0x14a6b514f257ee68, 0x0000000000000050,
};

/*
 * m329a_u2x8_uart0_dual             m329p_u2x8_uart0_dual             m329pa_u2x8_uart0_dual
 * m3290_u2x8_uart0_dual             m3290a_u2x8_uart0_dual            m3290p_u2x8_uart0_dual
 * m3290pa_u2x8_uart0_dual           m325_u2x8_uart0_dual              m325a_u2x8_uart0_dual
 * m325p_u2x8_uart0_dual             m325pa_u2x8_uart0_dual            m3250_u2x8_uart0_dual
 * m3250a_u2x8_uart0_dual            m3250p_u2x8_uart0_dual            m3250pa_u2x8_uart0_dual
 */
static const uint64_t ur_m329_u2x8_uart0_dual[] = {
  0xd6eeeee993d44511, 0xdddddddbf20089c6, 0xc20db83d38056b62, 0x89d914e323bbba7e, 0xef2590772be67da5,
  0x90e609f180904316, 0xc0ddd6d032252521, 0xa7c4b881850c1b48, 0xe4e6f9df9958093b, 0x737a8ebef60514e0,
  0xbe08a11c913f838f, 0x01b87c2886257f9f, 0x21955ddeef9b8704, 0x136f7150865a03e2, 0xf212dbc06ffa039e,
  0x13ffd2024c161bca, 0x7b5472937dba7c24, 0x47114ef96aff0da3, 0xc7a48e3a7f0690fd, 0x1bda398b017f0e64,
  0xcb1823af22dd9af9, 0xf3bb8a929583ef71, 0x9bf0312b5ec9fc55, 0x301deb5e78101385, 0x7253a005bcde5ba8,
  0x10b4e02f7ca9bd4a, 0x4e31bc674408ea28, 0x9ab83cd84b997cdb, 0xc33d30ae4fcfec5c, 0x0e9296cf8138cb25,
  0xa2029e4afdcd0ccb, 0x0000000000196fdb,
};

/*
 * m329_u2x8_uart0_dual_pr_u4        m329a_u2x8_uart0_dual_pr          m329a_u2x8_uart0_dual_pr_u4
 * m329p_u2x8_uart0_dual_pr          m329p_u2x8_uart0_dual_pr_u4       m329pa_u2x8_uart0_dual_pr
 * m329pa_u2x8_uart0_dual_pr_u4      m3290_u2x8_uart0_dual_pr          m3290_u2x8_uart0_dual_pr_u4
 * m3290a_u2x8_uart0_dual_pr         m3290a_u2x8_uart0_dual_pr_u4      m3290p_u2x8_uart0_dual_pr
 * m3290p_u2x8_uart0_dual_pr_u4      m3290pa_u2x8_uart0_dual_pr        m3290pa_u2x8_uart0_dual_pr_u4
 * m325_u2x8_uart0_dual_pr           m325_u2x8_uart0_dual_pr_u4        m325a_u2x8_uart0_dual_pr
 * m325a_u2x8_uart0_dual_pr_u4       m325p_u2x8_uart0_dual_pr          m325p_u2x8_uart0_dual_pr_u4
 * m325pa_u2x8_uart0_dual_pr         m325pa_u2x8_uart0_dual_pr_u4      m3250_u2x8_uart0_dual_pr
 * m3250_u2x8_uart0_dual_pr_u4       m3250a_u2x8_uart0_dual_pr         m3250a_u2x8_uart0_dual_pr_u4
 * m3250p_u2x8_uart0_dual_pr         m3250p_u2x8_uart0_dual_pr_u4      m3250pa_u2x8_uart0_dual_pr
 * m3250pa_u2x8_uart0_dual_pr_u4
 */
static const uint64_t ur_m329_u2x8_uart0_dual_pr[] = {
  0xbbbba64e890c365a, 0x77776fc800051b5b, 0x5eb14eb83bf6b777, 0xd905191dddd7ae69, 0xb771377d72c53683,
  0x3e30120862dde49b, 0xda0644a4a4321cc1, 0x1030a18369181bba, 0x97f995d06774f897, 0xe95b60e94e070e62,
  0x11c913f83a9537a8, 0xc2886257f9fbe08a, 0xbbddf372c7c01b87, 0x2a10cb43e44432ab, 0x780dff4073c261f2,
  0xcd7982c3795e425b, 0x2937dba7c2413ffd, 0x77cb1350da37b547, 0xe3a7f0621fd47c8a, 0x98b01541e69c5ef8,
  0x3af00676b591d7f3, 0xb10e90d500ffd982, 0xddc549549d03cb3d, 0xf81895af64fe2af9, 0x0ef5af3c0809c2cd,
  0xa7400b79bcd91418, 0x67440ef9537a94e4, 0xd8aaa2d3574e31bc, 0x612e65f36dce455b, 0xc1ddc68b1be1b8f3,
  0x9430a9cfd4eaccdf, 0xfc65f989ffde1ef7, 0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc, 0xc3a4a5b3e04e32c9,
  0x6dd16792bf734332, 0x0000000002926101,
};

/*
 * m329_u2x8_uart0_dual_pr_ee_u4     m329a_u2x8_uart0_dual_pr_ee       m329a_u2x8_uart0_dual_pr_ee_u4
 * m329p_u2x8_uart0_dual_pr_ee       m329p_u2x8_uart0_dual_pr_ee_u4    m329pa_u2x8_uart0_dual_pr_ee
 * m329pa_u2x8_uart0_dual_pr_ee_u4   m3290_u2x8_uart0_dual_pr_ee       m3290_u2x8_uart0_dual_pr_ee_u4
 * m3290a_u2x8_uart0_dual_pr_ee      m3290a_u2x8_uart0_dual_pr_ee_u4   m3290p_u2x8_uart0_dual_pr_ee
 * m3290p_u2x8_uart0_dual_pr_ee_u4   m3290pa_u2x8_uart0_dual_pr_ee     m3290pa_u2x8_uart0_dual_pr_ee_u4
 * m325_u2x8_uart0_dual_pr_ee        m325_u2x8_uart0_dual_pr_ee_u4     m325a_u2x8_uart0_dual_pr_ee
 * m325a_u2x8_uart0_dual_pr_ee_u4    m325p_u2x8_uart0_dual_pr_ee       m325p_u2x8_uart0_dual_pr_ee_u4
 * m325pa_u2x8_uart0_dual_pr_ee      m325pa_u2x8_uart0_dual_pr_ee_u4   m3250_u2x8_uart0_dual_pr_ee
 * m3250_u2x8_uart0_dual_pr_ee_u4    m3250a_u2x8_uart0_dual_pr_ee      m3250a_u2x8_uart0_dual_pr_ee_u4
 * m3250p_u2x8_uart0_dual_pr_ee      m3250p_u2x8_uart0_dual_pr_ee_u4   m3250pa_u2x8_uart0_dual_pr_ee
 * m3250pa_u2x8_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m329_u2x8_uart0_dual_pr_ee[] = {
  0xbbbbba64e890cf68, 0x777776fc5a2e71b5, 0xea2f2af39db5c777, 0x7d9f6626977599b4, 0xa3ea75ee1bb113d4,
  0x0904316ef251dbb9, 0x894948e1fe609f18, 0x4306d2303775b40c, 0x2ba0cee9f12e2061, 0xc3fe1c0344da6bf3,
  0x9fc1d0fcdea3d8fe, 0x12bfcfdf04508e48, 0x9b972200dc3e1443, 0xb41d2a21955ddeef, 0xe80e784c5162a10c,
  0xb0de579096dfabff, 0xe9f096fbff735e60, 0x24368ded51ca4df6, 0xea3cad7dcd56b472, 0x5d4af51f06cc1829,
  0x4522cd3ad08a1df1, 0x152e6909afa30b2c, 0x0a3dece756973297, 0xb1aad743af512ed1, 0x662e1211408a8f9e,
  0x51b047eb70decbe9, 0xe77715250084feb1, 0x37e06256bd93f8ab, 0x603bd6bcf020270b, 0x929d002de6f36450,
  0xf19d103be54dea53, 0x6f62aa8b4d5d38c6, 0xcd84b997cdb73915, 0x7f07771a2c6f86e3, 0xde50c2a73f53ab33,
  0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f, 0xcb0e9296cf8138cb, 0x4f37459e4afdcd0c,
  0x0000000000002b27,
};

/*
 * m329_u2x8_uart0_dual_pr_ce_u4     m329a_u2x8_uart0_dual_pr_ce       m329a_u2x8_uart0_dual_pr_ce_u4
 * m329p_u2x8_uart0_dual_pr_ce       m329p_u2x8_uart0_dual_pr_ce_u4    m329pa_u2x8_uart0_dual_pr_ce
 * m329pa_u2x8_uart0_dual_pr_ce_u4   m3290_u2x8_uart0_dual_pr_ce       m3290_u2x8_uart0_dual_pr_ce_u4
 * m3290a_u2x8_uart0_dual_pr_ce      m3290a_u2x8_uart0_dual_pr_ce_u4   m3290p_u2x8_uart0_dual_pr_ce
 * m3290p_u2x8_uart0_dual_pr_ce_u4   m3290pa_u2x8_uart0_dual_pr_ce     m3290pa_u2x8_uart0_dual_pr_ce_u4
 * m325_u2x8_uart0_dual_pr_ce        m325_u2x8_uart0_dual_pr_ce_u4     m325a_u2x8_uart0_dual_pr_ce
 * m325a_u2x8_uart0_dual_pr_ce_u4    m325p_u2x8_uart0_dual_pr_ce       m325p_u2x8_uart0_dual_pr_ce_u4
 * m325pa_u2x8_uart0_dual_pr_ce      m325pa_u2x8_uart0_dual_pr_ce_u4   m3250_u2x8_uart0_dual_pr_ce
 * m3250_u2x8_uart0_dual_pr_ce_u4    m3250a_u2x8_uart0_dual_pr_ce      m3250a_u2x8_uart0_dual_pr_ce_u4
 * m3250p_u2x8_uart0_dual_pr_ce      m3250p_u2x8_uart0_dual_pr_ce_u4   m3250pa_u2x8_uart0_dual_pr_ce
 * m3250pa_u2x8_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m329_u2x8_uart0_dual_pr_ce[] = {
  0xeeeee993a2431f02, 0x77776fc7a7bf66d6, 0x58b96257da807777, 0xaa2f39dbbbb138dd, 0xdca31166d084c295,
  0x8c048218b77931c5, 0x0644a4a40c2f304f, 0x30a18369181bbada, 0xf995d06774f89710, 0xad805a3818fcc337,
  0x244fe0c6b4dea3a5, 0x21895fe7ef822847, 0x77cdc67c006e1f0a, 0x865a051510caaeef, 0xdff4073c2631f150,
  0x982c3795e425b78a, 0x7dba7c24c17fdcd7, 0xaa010da37b547293, 0xc79e6da038e96e2f, 0x12fc4361222fb892,
  0x2ee370527ebfea3e, 0xc6fcf72c67d4b99e, 0x1f238e9fc1d4bf51, 0xb591d7f398b01414, 0x00ffd99e3af00676,
  0x2740f2d6e10e90d5, 0xd93f8abe77715255, 0x020270b37e06256b, 0x6f36450603bd6bcf, 0x54dea53929d002de,
  0xd5d38c6f19d103be, 0xb6e70c76f62aa8b4, 0x8df0dc79b09732f9, 0xea75666fe0eee345, 0xffef0f7bca1854e7,
  0x87993fc0fe32fcc4, 0xc68f45fe07efd866, 0xf0271964b867a617, 0x5fb9a19961d252d9, 0x003492aca6e8b3c9,
};

/*
 * m329a_u2x8_uart0_dual_pr_ee_ce    m329p_u2x8_uart0_dual_pr_ee_ce    m329pa_u2x8_uart0_dual_pr_ee_ce
 * m3290_u2x8_uart0_dual_pr_ee_ce    m3290a_u2x8_uart0_dual_pr_ee_ce   m3290p_u2x8_uart0_dual_pr_ee_ce
 * m3290pa_u2x8_uart0_dual_pr_ee_ce  m325_u2x8_uart0_dual_pr_ee_ce     m325a_u2x8_uart0_dual_pr_ee_ce
 * m325p_u2x8_uart0_dual_pr_ee_ce    m325pa_u2x8_uart0_dual_pr_ee_ce   m3250_u2x8_uart0_dual_pr_ee_ce
 * m3250a_u2x8_uart0_dual_pr_ee_ce   m3250p_u2x8_uart0_dual_pr_ee_ce   m3250pa_u2x8_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m329_u2x8_uart0_dual_pr_ee_ce[] = {
  0x6eeeee993d43573e, 0xddddddbf0b89366d, 0x9db37dd8ebe8fcdd, 0x7d55e56ee0ee8f63, 0x717dd857bd657b80,
  0x0904316ef25a73b9, 0x89494874ea609f18, 0x4306d2303775b40c, 0x2ba0cee9f12e2061, 0x014870fd798d6ff3,
  0x3f83b5b9bd47801b, 0x257f9fbe08a11c91, 0x6e775801b87c2886, 0xd0d3688655777bbe, 0xa039e136048a8432,
  0xc3795e425b79dbff, 0x4f84ba7ffdcd7982, 0xe1b46f6a8e526fb7, 0xb40706b1dff546e4, 0xcee372f0f96bf3cd,
  0xdfc94ed6564dd309, 0x51f06cc1af9ea3ca, 0xd3ad08a05315c06f, 0x909afa30b2c4522c, 0x51ef673abb71943a,
  0x1aaf1b1d7a897688, 0x62e1211408a8f9eb, 0x8d8226470decbe96, 0x3bb8a9296627f58a, 0xbf0312b5ec9fc55f,
  0x01deb5e781013859, 0x94e8016f379b2283, 0x8ce881df2a6f529c, 0x7b15545a6ae9c637, 0xd84b997cdb73863b,
  0xe0eee3458f386e3c, 0x0cf4c2b93f75666f, 0x3a4a5b3e04e32c97, 0xdd16792bf734332c, 0x00000000098258fe,
};

/*
 * m329a_u2x8_uart0_dual_pr_ee_ce_u4 m329p_u2x8_uart0_dual_pr_ee_ce_u4 m329pa_u2x8_uart0_dual_pr_ee_ce_u4
 * m3290_u2x8_uart0_dual_pr_ee_ce_u4 m3290a_u2x8_uart0_dual_pr_ee_ce_u4
 * m3290p_u2x8_uart0_dual_pr_ee_ce_u4 m3290pa_u2x8_uart0_dual_pr_ee_ce_u4
 * m325_u2x8_uart0_dual_pr_ee_ce_u4  m325a_u2x8_uart0_dual_pr_ee_ce_u4 m325p_u2x8_uart0_dual_pr_ee_ce_u4
 * m325pa_u2x8_uart0_dual_pr_ee_ce_u4 m3250_u2x8_uart0_dual_pr_ee_ce_u4
 * m3250a_u2x8_uart0_dual_pr_ee_ce_u4 m3250p_u2x8_uart0_dual_pr_ee_ce_u4
 * m3250pa_u2x8_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u2x8_uart0_dual_pr_ee_ce_u4[] = {
  0xbbba64e8adbba812, 0xbbb7e593beb9b5bb, 0xc26bd5ef5717bbbb, 0x5375ba5ab3eda7bd, 0xb3fb4666ec132650,
  0xc9fb4ee0fafc1cbb, 0xb9827c602410c5bb, 0xbbada0644a4a479e, 0x8971030a18369181, 0x6a4afccb41ca774f,
  0x4767cd87599c190e, 0xa11c913f8335b9bd, 0x7c2886257f9fbe08, 0x777bbe6e753801b8, 0x8a8432d00b488655,
  0x7fd7ffa039e131c1, 0x7e1982c3795e425b, 0xa4df6e9f093fcffc, 0xea8d4f4368ded51c, 0xb1e79b693b19bb8b,
  0x84bf10d8488bee24, 0x771b9aa0f20ffa8f, 0xfe4a76b737374cf1, 0x8f83660d7cf51e56, 0x9d68450298ae037a,
  0x84d7d18596229166, 0x8f7b39d5db8ca1d4, 0xd578d8ebd44bb442, 0x170908a04547cf58, 0x6c1132386f65f4b3,
  0xddc5494b313fac54, 0xf81895af64fe2af9, 0x0ef5af3c0809c2cd, 0xa7400b79bcd91418, 0x67440ef9537a94e4,
  0xd8aaa2d3574e31bc, 0xc25ccbe6db9c31db, 0xc68b1be2e4d5c1e6, 0x39fa9d599bf83f6e, 0x313ffbc3def28615,
  0x19a1e64ff03f8cbf, 0x85f1a3d17f81fbf6, 0xb67c09c6592e19e9, 0xf257ee6866587494, 0x000040065a5f2374,
};

/*
 * m329a_u2x8_uart0_dual_ee_hw       m329p_u2x8_uart0_dual_ee_hw       m329pa_u2x8_uart0_dual_ee_hw
 * m3290_u2x8_uart0_dual_ee_hw       m3290a_u2x8_uart0_dual_ee_hw      m3290p_u2x8_uart0_dual_ee_hw
 * m3290pa_u2x8_uart0_dual_ee_hw     m325_u2x8_uart0_dual_ee_hw        m325a_u2x8_uart0_dual_ee_hw
 * m325p_u2x8_uart0_dual_ee_hw       m325pa_u2x8_uart0_dual_ee_hw      m3250_u2x8_uart0_dual_ee_hw
 * m3250a_u2x8_uart0_dual_ee_hw      m3250p_u2x8_uart0_dual_ee_hw      m3250pa_u2x8_uart0_dual_ee_hw
 */
static const uint64_t ur_m329_u2x8_uart0_dual_ee_hw[] = {
  0xeeeee993a2435202, 0xdddddbf168b9c6d6, 0xa8bcabce76d71ddd, 0xf67d989a5dd666d3, 0x721d6d37cd744f51,
  0x02410c5bbc9476ee, 0x225252387f9827c6, 0x50c1b48c0ddd6d03, 0xcae833ba7c4b8818, 0xb0ff8700d1369afc,
  0x27f0743f37a8f63f, 0xc4aff3f7c1142392, 0xe6e5c880370f8510, 0x2d074a88655777bb, 0xfa039e131458a843,
  0x2c3795e425b7eaff, 0x74f84b7dfffa9198, 0x121b46f6a8e526fb, 0xf51e56bee6ab5a39, 0xaea57a8f83660c14,
  0x2291669d68450ef8, 0x8a973484d7d18596, 0x851ef673ab4b994b, 0x58d56ba1d7a89768, 0xb3170908a04547cf,
  0xa8d823f5b86f65f4, 0xf3bb8a9280427f58, 0x9bf0312b5ec9fc55, 0x301deb5e78101385, 0xc94e8016f379b228,
  0x78ce881df2a6f529, 0xb7b15545a6ae9c63, 0xe6c25ccbe6db9c8a, 0x9430a9cfd4176371, 0xfc65f989ffde1ef7,
  0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc, 0xc3a4a5b3e04e32c9, 0xa7a8a792bf734332, 0x000000000000576b,
};

/*
 * m329a_u2x8_uart0_dual_ee_ce_hw    m329p_u2x8_uart0_dual_ee_ce_hw    m329pa_u2x8_uart0_dual_ee_ce_hw
 * m3290_u2x8_uart0_dual_ee_ce_hw    m3290a_u2x8_uart0_dual_ee_ce_hw   m3290p_u2x8_uart0_dual_ee_ce_hw
 * m3290pa_u2x8_uart0_dual_ee_ce_hw  m325_u2x8_uart0_dual_ee_ce_hw     m325a_u2x8_uart0_dual_ee_ce_hw
 * m325p_u2x8_uart0_dual_ee_ce_hw    m325pa_u2x8_uart0_dual_ee_ce_hw   m3250_u2x8_uart0_dual_ee_ce_hw
 * m3250a_u2x8_uart0_dual_ee_ce_hw   m3250p_u2x8_uart0_dual_ee_ce_hw   m3250pa_u2x8_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m329_u2x8_uart0_dual_ee_ce_hw[] = {
  0xeeee993d4143359b, 0xddddbf0b89366d6e, 0xb37dd8ebe8fcdddd, 0x55e56ee0ee8f639d, 0x786614d6bafb807d,
  0x0904316ef25a73b8, 0x89494874ea609f18, 0x4306d2303775b40c, 0x2ba0cee9f12e2061, 0x014870fd798d6ff3,
  0x3f83b5b9bd47801b, 0x257f9fbe08a11c91, 0x6e775801b87c2886, 0xd0d3688655777bbe, 0xa039e136048a8432,
  0xc3795e425b79dbff, 0x9f0974ffffa91982, 0xc368ded51ca4df6e, 0x680e0d63bfea8dc9, 0x9dc6e759b21fe79b,
  0xbf929dacac9ba613, 0xa3e0d9835f3d4795, 0xa75a1140a62b80de, 0x2135f4616588a459, 0xa3dece7576e32875,
  0x355e363af512ed10, 0xc5c242281151f3d6, 0x1b044c8e1bd97d2c, 0x77715252cc4feb15, 0x7e06256bd93f8abe,
  0x03bd6bcf020270b3, 0x29d002de6f364506, 0x19d103be54dea539, 0xf62aa8b4d5d38c6f, 0xb09732f9b6e70c76,
  0xc2a73f5361d8dc79, 0xf9a1e64ff0271a50, 0x964b867a615c9f80, 0x19961d252d9f0271, 0xbad8ff453c95fb9a,
  0x000000000000000e,
};

/*
 * m329a_u2x8_uart0_dual_ee_ce_u4_hw m329p_u2x8_uart0_dual_ee_ce_u4_hw m329pa_u2x8_uart0_dual_ee_ce_u4_hw
 * m3290_u2x8_uart0_dual_ee_ce_u4_hw m3290a_u2x8_uart0_dual_ee_ce_u4_hw
 * m3290p_u2x8_uart0_dual_ee_ce_u4_hw m3290pa_u2x8_uart0_dual_ee_ce_u4_hw
 * m325_u2x8_uart0_dual_ee_ce_u4_hw  m325a_u2x8_uart0_dual_ee_ce_u4_hw m325p_u2x8_uart0_dual_ee_ce_u4_hw
 * m325pa_u2x8_uart0_dual_ee_ce_u4_hw m3250_u2x8_uart0_dual_ee_ce_u4_hw
 * m3250a_u2x8_uart0_dual_ee_ce_u4_hw m3250p_u2x8_uart0_dual_ee_ce_u4_hw
 * m3250pa_u2x8_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u2x8_uart0_dual_ee_ce_u4_hw[] = {
  0xeeee993a28d1880b, 0xeeedf964efae6d6e, 0xf7b84d7dabdeeeee, 0xca0a6eb74b567db4, 0xa6b6cd3accdd8264,
  0x0c5bbc9fb4ee127f, 0xa479eb9827c60241, 0x69181bbada0644a4, 0xa774f8971030a183, 0xc190e6a4afccb135,
  0x5b9bd4767cd87599, 0xfbe08a11c913f833, 0x801b87c2886257f9, 0x88655777bbe6e753, 0x131c18a8432d00b4,
  0xe425b7fd7ffa039e, 0xf9fecf43982c3795, 0xdaa3949bedd3e127, 0x37717d51a9e86d1b, 0xdc4963cf2beb0383,
  0xf51f097e21b09117, 0xd33c5dc6e292737f, 0x4795bf929dadcdcd, 0x80dea3e0d9835f3d, 0xa459a75a1140a62b,
  0x28752135f4616588, 0xed10a3dece7576e3, 0xf3d6355e363af512, 0x7d2cc5c242281151, 0xeb151b044c8e1bd9,
  0x8abe77715252cc4f, 0x70b37e06256bd93f, 0x450603bd6bcf0202, 0xa53929d002de6f36, 0x8c6f19d103be54de,
  0x0c76f62aa8b4d5d3, 0xdc79b09732f9b6e7, 0xbde50c2a73f505d8, 0xe07f197e627ff787, 0xff03f7ec3343cc9f,
  0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0xb2170be9e4afdcd0, 0x000000000000eba8,
};

/*
 * m329_u2x12_uart0_noled_pr         m329a_u2x12_uart0_noled           m329a_u2x12_uart0_noled_pr
 * m329p_u2x12_uart0_noled           m329p_u2x12_uart0_noled_pr        m329pa_u2x12_uart0_noled
 * m329pa_u2x12_uart0_noled_pr       m3290_u2x12_uart0_noled           m3290_u2x12_uart0_noled_pr
 * m3290a_u2x12_uart0_noled          m3290a_u2x12_uart0_noled_pr       m3290p_u2x12_uart0_noled
 * m3290p_u2x12_uart0_noled_pr       m3290pa_u2x12_uart0_noled         m3290pa_u2x12_uart0_noled_pr
 * m325_u2x12_uart0_noled            m325_u2x12_uart0_noled_pr         m325a_u2x12_uart0_noled
 * m325a_u2x12_uart0_noled_pr        m325p_u2x12_uart0_noled           m325p_u2x12_uart0_noled_pr
 * m325pa_u2x12_uart0_noled          m325pa_u2x12_uart0_noled_pr       m3250_u2x12_uart0_noled
 * m3250_u2x12_uart0_noled_pr        m3250a_u2x12_uart0_noled          m3250a_u2x12_uart0_noled_pr
 * m3250p_u2x12_uart0_noled          m3250p_u2x12_uart0_noled_pr       m3250pa_u2x12_uart0_noled
 * m3250pa_u2x12_uart0_noled_pr
 */
static const uint64_t ur_m329_u2x12_uart0_noled[] = {
  0x776d0d783acdfc4f, 0xddd55ce0b4244b77, 0x8a64d0e6b11ddddd, 0xe2f56dddd3c19ee4, 0x77617ad1e3d041af,
  0x609f180904316ef2, 0x84a21ff7e879f9ba, 0x47293f9b53eab74f, 0x78ef964870da37b5, 0xe8e3a7f06693d47e,
  0x3398b016f74c37c9, 0x608ebc5cecf691e3, 0x12b5ec2b289dc72c, 0x01deb5e73859bf03, 0x9b19c2de6f00fa83,
  0x1bc67440aeaa72f2, 0xab7b15545a585ce3, 0x6ed84b997cdb1248, 0x98f2068fe3458f38, 0xb25c33d30ae4fdd5,
  0xcb0e9296cb25138c, 0xa76b8f9e4afdcd0c, 0x0000000000007c82,
};

/*
 * m329a_u2x12_uart0_noled_pr_u4     m329p_u2x12_uart0_noled_pr_u4     m329pa_u2x12_uart0_noled_pr_u4
 * m3290_u2x12_uart0_noled_pr_u4     m3290a_u2x12_uart0_noled_pr_u4    m3290p_u2x12_uart0_noled_pr_u4
 * m3290pa_u2x12_uart0_noled_pr_u4   m325_u2x12_uart0_noled_pr_u4      m325a_u2x12_uart0_noled_pr_u4
 * m325p_u2x12_uart0_noled_pr_u4     m325pa_u2x12_uart0_noled_pr_u4    m3250_u2x12_uart0_noled_pr_u4
 * m3250a_u2x12_uart0_noled_pr_u4    m3250p_u2x12_uart0_noled_pr_u4    m3250pa_u2x12_uart0_noled_pr_u4
 */
static const uint64_t ur_m329_u2x12_uart0_noled_pr_u4[] = {
  0x76d0d7834488a8ae, 0xbaab9c178fc4b777, 0xe4d5a00d2e3bbbbb, 0xf07dddd888913e2d, 0xa69638d931223188,
  0x4f8c048218b7793b, 0x2053fcf02cfe9530, 0xca4fe6d4faadd3e1, 0x3be5843c368ded51, 0x38e9fc1a0bf51fa0,
  0x731602cb299efb5a, 0x11d7a3e76afe8f58, 0xed8fb33ca807fecc, 0x06256bd838f81e59, 0x0603bd6bce70b37e,
  0xe5363385bcde01f5, 0xc6378ce8815d54e5, 0x9156f62aa8b4b0b9, 0x7079b09732f9b624, 0x40fca1a2c6f8b935,
  0xe50c2a73f53ab31e, 0x7f197e627ff787bd, 0x03f7ec3343cc9fe0, 0x5c33d30be347a2ff, 0xb0e9296cf8138cb2,
  0x3a2029e4afdcd0cc, 0x00000000003e4e35,
};

/*
 * m329_u2x12_uart0_noled_pr_ee_u4   m329a_u2x12_uart0_noled_pr_ee     m329a_u2x12_uart0_noled_pr_ee_u4
 * m329p_u2x12_uart0_noled_pr_ee     m329p_u2x12_uart0_noled_pr_ee_u4  m329pa_u2x12_uart0_noled_pr_ee
 * m329pa_u2x12_uart0_noled_pr_ee_u4 m3290_u2x12_uart0_noled_pr_ee     m3290_u2x12_uart0_noled_pr_ee_u4
 * m3290a_u2x12_uart0_noled_pr_ee    m3290a_u2x12_uart0_noled_pr_ee_u4 m3290p_u2x12_uart0_noled_pr_ee
 * m3290p_u2x12_uart0_noled_pr_ee_u4 m3290pa_u2x12_uart0_noled_pr_ee
 * m3290pa_u2x12_uart0_noled_pr_ee_u4 m325_u2x12_uart0_noled_pr_ee
 * m325_u2x12_uart0_noled_pr_ee_u4   m325a_u2x12_uart0_noled_pr_ee     m325a_u2x12_uart0_noled_pr_ee_u4
 * m325p_u2x12_uart0_noled_pr_ee     m325p_u2x12_uart0_noled_pr_ee_u4  m325pa_u2x12_uart0_noled_pr_ee
 * m325pa_u2x12_uart0_noled_pr_ee_u4 m3250_u2x12_uart0_noled_pr_ee     m3250_u2x12_uart0_noled_pr_ee_u4
 * m3250a_u2x12_uart0_noled_pr_ee    m3250a_u2x12_uart0_noled_pr_ee_u4 m3250p_u2x12_uart0_noled_pr_ee
 * m3250p_u2x12_uart0_noled_pr_ee_u4 m3250pa_u2x12_uart0_noled_pr_ee
 * m3250pa_u2x12_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m329_u2x12_uart0_noled_pr_ee[] = {
  0xbb686bc1a2446f43, 0xeeaaf2200ce25bbb, 0x90f1ef5f682eeeee, 0x984c3fbaf23af640, 0xed533d950ccddb53,
  0x048218b7793bad3b, 0xf9e059fc09304f8c, 0x9b53eab74f848a5f, 0xce30da37b547293f, 0xc7d4795c89355ad1,
  0xf15f75ea3e0d9834, 0x2c4522cd3ad08a1d, 0x15c6b26909afa30b, 0x6ded1e0b39d5a5e7, 0x38d8d56ba1d79d37,
  0xb2e62e1211473c8c, 0x34a8d823f5b86f65, 0xbf0312b5ec00a895, 0xfa8301deb5e73859, 0x72f29b19c2de6f00,
  0x5ce31bc67440aeaa, 0x1248ab7b15545a58, 0x9ab83cd84b997cdb, 0x8f207e50d1637c5c, 0xdef2861539fa9d59,
  0xf03f8cbf313ffbc3, 0x7f81fbf619a1e64f, 0x592e19e985f1a3d1, 0x66587494b67c09c6, 0xdaf71014f257ee68,
  0x00000000000009d7,
};

/*
 * m329_u2x12_uart0_noled_pr_ce_u4   m329a_u2x12_uart0_noled_pr_ce     m329a_u2x12_uart0_noled_pr_ce_u4
 * m329p_u2x12_uart0_noled_pr_ce     m329p_u2x12_uart0_noled_pr_ce_u4  m329pa_u2x12_uart0_noled_pr_ce
 * m329pa_u2x12_uart0_noled_pr_ce_u4 m3290_u2x12_uart0_noled_pr_ce     m3290_u2x12_uart0_noled_pr_ce_u4
 * m3290a_u2x12_uart0_noled_pr_ce    m3290a_u2x12_uart0_noled_pr_ce_u4 m3290p_u2x12_uart0_noled_pr_ce
 * m3290p_u2x12_uart0_noled_pr_ce_u4 m3290pa_u2x12_uart0_noled_pr_ce
 * m3290pa_u2x12_uart0_noled_pr_ce_u4 m325_u2x12_uart0_noled_pr_ce
 * m325_u2x12_uart0_noled_pr_ce_u4   m325a_u2x12_uart0_noled_pr_ce     m325a_u2x12_uart0_noled_pr_ce_u4
 * m325p_u2x12_uart0_noled_pr_ce     m325p_u2x12_uart0_noled_pr_ce_u4  m325pa_u2x12_uart0_noled_pr_ce
 * m325pa_u2x12_uart0_noled_pr_ce_u4 m3250_u2x12_uart0_noled_pr_ce     m3250_u2x12_uart0_noled_pr_ce_u4
 * m3250a_u2x12_uart0_noled_pr_ce    m3250a_u2x12_uart0_noled_pr_ce_u4 m3250p_u2x12_uart0_noled_pr_ce
 * m3250p_u2x12_uart0_noled_pr_ce_u4 m3250pa_u2x12_uart0_noled_pr_ce
 * m3250pa_u2x12_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m329_u2x12_uart0_noled_pr_ce[] = {
  0x76d0d78344889768, 0xeeaaf064b444b777, 0x3bdb67ef619eeeee, 0x78fdddd3265ed4de, 0x3747688f8f62b6c8,
  0x7c602410c5bbc9dd, 0xf3bfcf02cf975982, 0x49fcda9f55ba7c25, 0x17d72486d1bdaa39, 0x24b1e7804a9dbf97,
  0x8f84bf10d8488bee, 0x33c5dc6e3fcc41fa, 0x3d4727a7b9633f59, 0x147ce9238e9fc1eb, 0x1f3b57f47ac398b0,
  0x99e5403ff6678ebd, 0xd7b071f03cb5b87d, 0x7ad79ce166fc0c4a, 0x670b79bc03ea0c07, 0x19d102baa9cbca6c,
  0xec55516961738c6f, 0xc25ccbe6d89218ed, 0x868b1be2e4d5c1e6, 0xa9cfd4eacc7903f2, 0xf989ffde1ef79430,
  0xb0cd0f327f81fc65, 0x4c2f8d1e8bfc0fdf, 0xa5b3e04e32c970cf, 0xa792bf734332c3a4, 0x0000006ebbf02880,
};

/*
 * m329a_u2x12_uart0_noled_pr_ee_ce  m329p_u2x12_uart0_noled_pr_ee_ce  m329pa_u2x12_uart0_noled_pr_ee_ce
 * m3290_u2x12_uart0_noled_pr_ee_ce  m3290a_u2x12_uart0_noled_pr_ee_ce m3290p_u2x12_uart0_noled_pr_ee_ce
 * m3290pa_u2x12_uart0_noled_pr_ee_ce m325_u2x12_uart0_noled_pr_ee_ce
 * m325a_u2x12_uart0_noled_pr_ee_ce  m325p_u2x12_uart0_noled_pr_ee_ce  m325pa_u2x12_uart0_noled_pr_ee_ce
 * m3250_u2x12_uart0_noled_pr_ee_ce  m3250a_u2x12_uart0_noled_pr_ee_ce m3250p_u2x12_uart0_noled_pr_ee_ce
 * m3250pa_u2x12_uart0_noled_pr_ee_ce
 */
static const uint64_t ur_m329_u2x12_uart0_noled_pr_ee_ce[] = {
  0xb686bc1d41447032, 0xeaaf088d1625bbbb, 0x5a09c97560eeeeee, 0x82917746d82f0828, 0xec9c9cbe99a5c5ed,
  0x904316ef2775b11c, 0x3c0b3e96a609f180, 0x6a7d56e9f090d6ff, 0xf21b46f6a8e527f3, 0x012a77810effaa37,
  0x4e771b9d66c87f9e, 0x57d44a76b2b1ef98, 0xf51f06cc1ad7f51e, 0xcd3ad08a0531584f, 0xa909afa30b2c4522,
  0xda3c1673abb74e23, 0x6355e363af3a6edb, 0x98b848451cf230e3, 0x51b044c8e1bd96cb, 0x06256bd859d12a69,
  0x0603bd6bce70b37e, 0xe5363385bcde01f5, 0xc6378ce8815d54e5, 0x0c76f62aa8b4b0b9, 0xe0f3612e65f36c49,
  0x0fca1a2cb579726a, 0x50c2a73f53ab31e4, 0x80f9a1e64ff0271a, 0x71964b867a615c9f, 0x9a19961d252d9f02,
  0x04fc3244053c95fb,
};

/*
 * m329a_u2x12_uart0_noled_pr_ee_ce_u4 m329p_u2x12_uart0_noled_pr_ee_ce_u4
 * m329pa_u2x12_uart0_noled_pr_ee_ce_u4 m3290_u2x12_uart0_noled_pr_ee_ce_u4
 * m3290a_u2x12_uart0_noled_pr_ee_ce_u4 m3290p_u2x12_uart0_noled_pr_ee_ce_u4
 * m3290pa_u2x12_uart0_noled_pr_ee_ce_u4 m325_u2x12_uart0_noled_pr_ee_ce_u4
 * m325a_u2x12_uart0_noled_pr_ee_ce_u4 m325p_u2x12_uart0_noled_pr_ee_ce_u4
 * m325pa_u2x12_uart0_noled_pr_ee_ce_u4 m3250_u2x12_uart0_noled_pr_ee_ce_u4
 * m3250a_u2x12_uart0_noled_pr_ee_ce_u4 m3250p_u2x12_uart0_noled_pr_ee_ce_u4
 * m3250pa_u2x12_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u2x12_uart0_noled_pr_ee_ce_u4[] = {
  0x76d0d7834486cc7f, 0xbaabae43a744b777, 0x7e98d3d89dbbbbbb, 0xa912c47771da09e4, 0x55e52947e0dc71a8,
  0x048218b7793ba9f7, 0xf62bb3e9b7304f8c, 0xda9f55ba7c24337f, 0x8786d1bdaa3949fc, 0x36d01c383717d51c,
  0x21b09117dc4963cf, 0xe747d493f51f097e, 0x9dadcdbdf33c5dc6, 0xb306b5fd4795f512, 0x22814c5613fd47c1,
  0xe8c2cb1148b34eb4, 0x9ceaedd388ea426b, 0xd8ebce9bb6f68f05, 0x11473c8c38d8d578, 0x32386f65b2e62e12,
  0xf616744a9a546c11, 0x5af39c2cdf81895a, 0xe16f37807d4180ef, 0x3a20575539794d8c, 0x8aaa2d2c2e718de3,
  0x4b997cdb12431dbd, 0x7771a2c6f86e3cd8, 0x0c2a73f53ab337f0, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f,
  0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0x7459e4afdcd0ccb0, 0x000000004fcf3f0b,
};

/*
 * m329a_u2x12_uart0_noled_ee_hw     m329p_u2x12_uart0_noled_ee_hw     m329pa_u2x12_uart0_noled_ee_hw
 * m3290_u2x12_uart0_noled_ee_hw     m3290a_u2x12_uart0_noled_ee_hw    m3290p_u2x12_uart0_noled_ee_hw
 * m3290pa_u2x12_uart0_noled_ee_hw   m325_u2x12_uart0_noled_ee_hw      m325a_u2x12_uart0_noled_ee_hw
 * m325p_u2x12_uart0_noled_ee_hw     m325pa_u2x12_uart0_noled_ee_hw    m3250_u2x12_uart0_noled_ee_hw
 * m3250a_u2x12_uart0_noled_ee_hw    m3250p_u2x12_uart0_noled_ee_hw    m3250pa_u2x12_uart0_noled_ee_hw
 */
static const uint64_t ur_m329_u2x12_uart0_noled_ee_hw[] = {
  0xbb686bc1a2433a31, 0xeeaaf2200ce25bbb, 0x8121e3f5ebeeeeee, 0xa730987f75e475ec, 0xd89b0da02a199bb6,
  0x3e30120862dde4ee, 0x8a5ffd0a67f024c1, 0x293f9b53eab74f84, 0x5ad1ce30da37b547, 0x9834c7d4795c8935,
  0x8a1df15f75ea3e0d, 0xa30b2c4522cd3ad0, 0xa5e715c6b26909af, 0x9d376ded1e0b39d5, 0x3c8c38d8d56ba1d7,
  0x6f65b2e62e121147, 0xa89534a8d823f5b8, 0x3859bf0312b5ec00, 0x6f00fa8301deb5e7, 0xaeaa72f29b19c2de,
  0x5a585ce31bc67440, 0x7cdb1248ab7b1554, 0xfa82ec6e3cd84b99, 0x3ffbc3def2861539, 0xa1e64ff03f8cbf31,
  0xf1a3d17f81fbf619, 0x7c09c6592e19e985, 0x57ee6866587494b6, 0x00002df31c4d14f2,
};

/*
 * m329_u2x12_uart0_noled_ee_ce_u4_hw m329a_u2x12_uart0_noled_ee_ce_hw
 * m329a_u2x12_uart0_noled_ee_ce_u4_hw m329p_u2x12_uart0_noled_ee_ce_hw
 * m329p_u2x12_uart0_noled_ee_ce_u4_hw m329pa_u2x12_uart0_noled_ee_ce_hw
 * m329pa_u2x12_uart0_noled_ee_ce_u4_hw m3290_u2x12_uart0_noled_ee_ce_hw
 * m3290_u2x12_uart0_noled_ee_ce_u4_hw m3290a_u2x12_uart0_noled_ee_ce_hw
 * m3290a_u2x12_uart0_noled_ee_ce_u4_hw m3290p_u2x12_uart0_noled_ee_ce_hw
 * m3290p_u2x12_uart0_noled_ee_ce_u4_hw m3290pa_u2x12_uart0_noled_ee_ce_hw
 * m3290pa_u2x12_uart0_noled_ee_ce_u4_hw m325_u2x12_uart0_noled_ee_ce_hw
 * m325_u2x12_uart0_noled_ee_ce_u4_hw m325a_u2x12_uart0_noled_ee_ce_hw
 * m325a_u2x12_uart0_noled_ee_ce_u4_hw m325p_u2x12_uart0_noled_ee_ce_hw
 * m325p_u2x12_uart0_noled_ee_ce_u4_hw m325pa_u2x12_uart0_noled_ee_ce_hw
 * m325pa_u2x12_uart0_noled_ee_ce_u4_hw m3250_u2x12_uart0_noled_ee_ce_hw
 * m3250_u2x12_uart0_noled_ee_ce_u4_hw m3250a_u2x12_uart0_noled_ee_ce_hw
 * m3250a_u2x12_uart0_noled_ee_ce_u4_hw m3250p_u2x12_uart0_noled_ee_ce_hw
 * m3250p_u2x12_uart0_noled_ee_ce_u4_hw m3250pa_u2x12_uart0_noled_ee_ce_hw
 * m3250pa_u2x12_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u2x12_uart0_noled_ee_ce_hw[] = {
  0xeda1af06890c1107, 0x75575c874e896eee, 0xfd31a7b13b777777, 0x522588eee3b413c8, 0x9157eefdc1b8e351,
  0x180904316ef27753, 0xdffd0a67d36e609f, 0x7f36a7d56e9f090c, 0x4721e1b46f6a8e52, 0xf3cdb4070e0dc5f5,
  0x5f886c2445f71258, 0xb8dc4a8b91fd47c2, 0xa253b5b9b7be678b, 0xf83660d6bfa8f2be, 0xd68450298ac27fa8,
  0x4d7d185962291669, 0xe0b39d5dba711d48, 0xaf1b1d79d376ded1, 0xc24228e791871b1a, 0x8226470decb65cc5,
  0x2b5ec2ce89534a8d, 0x1deb5e73859bf031, 0xb19c2de6f00fa830, 0xbc67440aeaa72f29, 0xb7b15545a585ce31,
  0x9b09732f9b624863, 0x50c2a73f505d8dc7, 0xf197e627ff787bde, 0x3f7ec3343cc9fe07, 0xc33d30be347a2ff0,
  0x0e9296cf8138cb25, 0xe1a29e4afdcd0ccb, 0x00000000001405e7,
};

/*
 * m329_u2x12_uart0_lednop_pr        m329a_u2x12_uart0_lednop          m329a_u2x12_uart0_lednop_pr
 * m329p_u2x12_uart0_lednop          m329p_u2x12_uart0_lednop_pr       m329pa_u2x12_uart0_lednop
 * m329pa_u2x12_uart0_lednop_pr      m3290_u2x12_uart0_lednop          m3290_u2x12_uart0_lednop_pr
 * m3290a_u2x12_uart0_lednop         m3290a_u2x12_uart0_lednop_pr      m3290p_u2x12_uart0_lednop
 * m3290p_u2x12_uart0_lednop_pr      m3290pa_u2x12_uart0_lednop        m3290pa_u2x12_uart0_lednop_pr
 * m325_u2x12_uart0_lednop           m325_u2x12_uart0_lednop_pr        m325a_u2x12_uart0_lednop
 * m325a_u2x12_uart0_lednop_pr       m325p_u2x12_uart0_lednop          m325p_u2x12_uart0_lednop_pr
 * m325pa_u2x12_uart0_lednop         m325pa_u2x12_uart0_lednop_pr      m3250_u2x12_uart0_lednop
 * m3250_u2x12_uart0_lednop_pr       m3250a_u2x12_uart0_lednop         m3250a_u2x12_uart0_lednop_pr
 * m3250p_u2x12_uart0_lednop         m3250p_u2x12_uart0_lednop_pr      m3250pa_u2x12_uart0_lednop
 * m3250pa_u2x12_uart0_lednop_pr
 */
static const uint64_t ur_m329_u2x12_uart0_lednop[] = {
  0x776d0d783acdfc4f, 0xbbaab9c14c9c4b77, 0xdac1d4cd623bbbbb, 0xbf8be6fbbba7833d, 0xc9dd85eb478f4106,
  0xf9827c602410c5bb, 0x7c24807fbf43cf84, 0xaa3949fcda9f55ba, 0x93c77cb24386d1bd, 0xcf471d3f83349ea3,
  0x829cc580b7ba61bf, 0xc608ebc5cec1c51c, 0xc4ad7b0ac507dc72, 0xad79e0404e166fc0, 0x8016f3796ea0c077,
  0x80bdf2a6f529c94e, 0xf19d1023a8a042d3, 0xbb612e65f36d38c6, 0x63c81a3f8d163ce1, 0xc970cf4c2b93f756,
  0x2c3a4a5b2c944e32, 0x9dae3e792bf73433, 0x000000000001f20a,
};

/*
 * m329a_u2x12_uart0_lednop_pr_u4    m329p_u2x12_uart0_lednop_pr_u4    m329pa_u2x12_uart0_lednop_pr_u4
 * m3290_u2x12_uart0_lednop_pr_u4    m3290a_u2x12_uart0_lednop_pr_u4   m3290p_u2x12_uart0_lednop_pr_u4
 * m3290pa_u2x12_uart0_lednop_pr_u4  m325_u2x12_uart0_lednop_pr_u4     m325a_u2x12_uart0_lednop_pr_u4
 * m325p_u2x12_uart0_lednop_pr_u4    m325pa_u2x12_uart0_lednop_pr_u4   m3250_u2x12_uart0_lednop_pr_u4
 * m3250a_u2x12_uart0_lednop_pr_u4   m3250p_u2x12_uart0_lednop_pr_u4   m3250pa_u2x12_uart0_lednop_pr_u4
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_pr_u4[] = {
  0xbb686bc1a2446d4e, 0xdd55ce0be9625bbb, 0x8b60fe3f731ddddd, 0xe6fbbbb1112278ff, 0x626e09208cc6d933,
  0xf8c048218b7793ba, 0x807f9e059f09f304, 0x49fcda9f55ba7c24, 0x7cb08786d1bdaa39, 0x1d3f83417ea3dac7,
  0xc580b2ca6f920fc7, 0xd7a3e7659e8d219c, 0xa0b348a807fecc11, 0x256bd905681e59ed, 0x6bcf020270b37e06,
  0x02de6f36450603bd, 0x03be54dea53929d0, 0xa8b4d5d38c6f19d1, 0x997cdb739156f62a, 0x637c5c9ab83cd84b,
  0xfa9d598f207e50d1, 0x3ffbc3def2861539, 0xa1e64ff03f8cbf31, 0xf1a3d17f81fbf619, 0x7c09c6592e19e985,
  0x57ee6866587494b6, 0x001f2620d51014f2,
};

/*
 * m329_u2x12_uart0_lednop_pr_ee_u4  m329a_u2x12_uart0_lednop_pr_ee    m329a_u2x12_uart0_lednop_pr_ee_u4
 * m329p_u2x12_uart0_lednop_pr_ee    m329p_u2x12_uart0_lednop_pr_ee_u4 m329pa_u2x12_uart0_lednop_pr_ee
 * m329pa_u2x12_uart0_lednop_pr_ee_u4 m3290_u2x12_uart0_lednop_pr_ee
 * m3290_u2x12_uart0_lednop_pr_ee_u4 m3290a_u2x12_uart0_lednop_pr_ee
 * m3290a_u2x12_uart0_lednop_pr_ee_u4 m3290p_u2x12_uart0_lednop_pr_ee
 * m3290p_u2x12_uart0_lednop_pr_ee_u4 m3290pa_u2x12_uart0_lednop_pr_ee
 * m3290pa_u2x12_uart0_lednop_pr_ee_u4 m325_u2x12_uart0_lednop_pr_ee
 * m325_u2x12_uart0_lednop_pr_ee_u4  m325a_u2x12_uart0_lednop_pr_ee    m325a_u2x12_uart0_lednop_pr_ee_u4
 * m325p_u2x12_uart0_lednop_pr_ee    m325p_u2x12_uart0_lednop_pr_ee_u4 m325pa_u2x12_uart0_lednop_pr_ee
 * m325pa_u2x12_uart0_lednop_pr_ee_u4 m3250_u2x12_uart0_lednop_pr_ee
 * m3250_u2x12_uart0_lednop_pr_ee_u4 m3250a_u2x12_uart0_lednop_pr_ee
 * m3250a_u2x12_uart0_lednop_pr_ee_u4 m3250p_u2x12_uart0_lednop_pr_ee
 * m3250p_u2x12_uart0_lednop_pr_ee_u4 m3250pa_u2x12_uart0_lednop_pr_ee
 * m3250pa_u2x12_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_pr_ee[] = {
  0xbb686bc1a2447032, 0xeeaaf2207ee25bbb, 0x9005f5176c8eeeee, 0x30987f75e475e0cd, 0xce5829ca85b4bb27,
  0x0904316ef2775b11, 0xf3c0b3fbee609f18, 0x36a7d56e9f0929ef, 0x9c61b46f6a8e527f, 0x8fa8f2b32a6ab5a3,
  0xc561efd47c1b3069, 0xb1148b34eb422877, 0x571ac9a426be8c2c, 0xd1923268e756973d, 0xdab1aad743af3a6e,
  0x65cc5c242282791b, 0x7951b047eb70decb, 0xfc0c4ad7b0021f66, 0x077ad79e0404e166, 0x53a005bcde6c8a0c,
  0x33a2077ca9bd4a72, 0xec555169aba718de, 0xb09732f9b6e722ad, 0xa1a2c6f8b9357079, 0x2a73f53ab31e40fc,
  0x7e627ff787bde50c, 0xec3343cc9fe07f19, 0xd30be347a2ff03f7, 0x296cf8138cb25c33, 0x29e4afdcd0ccb0e9,
  0x00000013af756e20,
};

/*
 * m329_u2x12_uart0_lednop_pr_ce_u4  m329a_u2x12_uart0_lednop_pr_ce    m329a_u2x12_uart0_lednop_pr_ce_u4
 * m329p_u2x12_uart0_lednop_pr_ce    m329p_u2x12_uart0_lednop_pr_ce_u4 m329pa_u2x12_uart0_lednop_pr_ce
 * m329pa_u2x12_uart0_lednop_pr_ce_u4 m3290_u2x12_uart0_lednop_pr_ce
 * m3290_u2x12_uart0_lednop_pr_ce_u4 m3290a_u2x12_uart0_lednop_pr_ce
 * m3290a_u2x12_uart0_lednop_pr_ce_u4 m3290p_u2x12_uart0_lednop_pr_ce
 * m3290p_u2x12_uart0_lednop_pr_ce_u4 m3290pa_u2x12_uart0_lednop_pr_ce
 * m3290pa_u2x12_uart0_lednop_pr_ce_u4 m325_u2x12_uart0_lednop_pr_ce
 * m325_u2x12_uart0_lednop_pr_ce_u4  m325a_u2x12_uart0_lednop_pr_ce    m325a_u2x12_uart0_lednop_pr_ce_u4
 * m325p_u2x12_uart0_lednop_pr_ce    m325p_u2x12_uart0_lednop_pr_ce_u4 m325pa_u2x12_uart0_lednop_pr_ce
 * m325pa_u2x12_uart0_lednop_pr_ce_u4 m3250_u2x12_uart0_lednop_pr_ce
 * m3250_u2x12_uart0_lednop_pr_ce_u4 m3250a_u2x12_uart0_lednop_pr_ce
 * m3250a_u2x12_uart0_lednop_pr_ce_u4 m3250p_u2x12_uart0_lednop_pr_ce
 * m3250p_u2x12_uart0_lednop_pr_ce_u4 m3250pa_u2x12_uart0_lednop_pr_ce
 * m3250pa_u2x12_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_pr_ce[] = {
  0xbb686bc1a2447768, 0x7755783236225bbb, 0x4d9711a7b42f7777, 0x60bf7774c997b5a1, 0xbb257df4e711bb06,
  0x3e30120862dde4ee, 0x387fe78167d82cc1, 0xa4fe6d4faadd3e12, 0x8beb924368ded51c, 0x24b1e7804a9dd4ab,
  0x8f84bf10d8488bee, 0x678bb8dcadf801fa, 0x7a8fd24f72c67eb2, 0x2a6222c71d3f83d6, 0xf9d967a348673160,
  0xd22a01ffb33c75e8, 0xbd905681e5adc82c, 0xf020270b37e06256, 0xe6f36450603bd6bc, 0xe54dea53929d002d,
  0x4d5d38c6f19d103b, 0x9b6e70c76f62aa8b, 0x8b9357079b09732f, 0xab31e40fca1a2c6f, 0x787bde50c2a73f53,
  0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0xbafa38a2029e4afd,
  0x0000000000000001,
};

/*
 * m329a_u2x12_uart0_lednop_pr_ee_ce m329p_u2x12_uart0_lednop_pr_ee_ce m329pa_u2x12_uart0_lednop_pr_ee_ce
 * m3290_u2x12_uart0_lednop_pr_ee_ce m3290a_u2x12_uart0_lednop_pr_ee_ce
 * m3290p_u2x12_uart0_lednop_pr_ee_ce m3290pa_u2x12_uart0_lednop_pr_ee_ce
 * m325_u2x12_uart0_lednop_pr_ee_ce  m325a_u2x12_uart0_lednop_pr_ee_ce m325p_u2x12_uart0_lednop_pr_ee_ce
 * m325pa_u2x12_uart0_lednop_pr_ee_ce m3250_u2x12_uart0_lednop_pr_ee_ce
 * m3250a_u2x12_uart0_lednop_pr_ee_ce m3250p_u2x12_uart0_lednop_pr_ee_ce
 * m3250pa_u2x12_uart0_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_pr_ee_ce[] = {
  0xdb435e0ea0a22a20, 0x75578445c712dddd, 0x015b977b1c777777, 0x82917746d82f68a1, 0xa8171abc8989866d,
  0x904316ef27747b16, 0x78167fa7e609f180, 0xa9f55ba7c25d5ffe, 0xc86d1bdaa3949fcd, 0x04a9defb3bfea8df,
  0x39dc6e5c89257e78, 0x5f7529dacac7be61, 0xd47c1b306b5fd479, 0x34eb422814c57b7f, 0xa426be8c2cb1148b,
  0x2464d1ceaedc7a8e, 0xc6abc6c75e74dda3, 0x3170908a09e46f6a, 0xa3608991c37b2d97, 0x1895af61663eccf2,
  0xf5af3c0809c2cdf8, 0x400b79bcd914180e, 0x440ef9537a94e4a7, 0xaaa2d3574e31bc67, 0x5ccbe6db9c31dbd8,
  0x596af2e4d5c1e6c2, 0x7ea75663c81f9434, 0xcc9fe04e34a1854e, 0x0cf4c2b93f01f343, 0x3a4a5b3e04e32c97,
  0x880a792bf734332c, 0x00000000009f8f5b,
};

/*
 * m329a_u2x12_uart0_lednop_pr_ee_ce_u4 m329p_u2x12_uart0_lednop_pr_ee_ce_u4
 * m329pa_u2x12_uart0_lednop_pr_ee_ce_u4 m3290_u2x12_uart0_lednop_pr_ee_ce_u4
 * m3290a_u2x12_uart0_lednop_pr_ee_ce_u4 m3290p_u2x12_uart0_lednop_pr_ee_ce_u4
 * m3290pa_u2x12_uart0_lednop_pr_ee_ce_u4 m325_u2x12_uart0_lednop_pr_ee_ce_u4
 * m325a_u2x12_uart0_lednop_pr_ee_ce_u4 m325p_u2x12_uart0_lednop_pr_ee_ce_u4
 * m325pa_u2x12_uart0_lednop_pr_ee_ce_u4 m3250_u2x12_uart0_lednop_pr_ee_ce_u4
 * m3250a_u2x12_uart0_lednop_pr_ee_ce_u4 m3250p_u2x12_uart0_lednop_pr_ee_ce_u4
 * m3250pa_u2x12_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_pr_ee_ce_u4[] = {
  0xddb435e0d1219f68, 0xeeaaeb9012312ddd, 0xef234176c4eeeeee, 0xfa44b11ddc768274, 0xf44f69c164777048,
  0x602410c5bbc9dd2a, 0x7fd8aecfbfc9827c, 0xf9b53eab74f84834, 0x390f0da37b547293, 0x9e6da03896ae2faa,
  0xfc4361222fb892c7, 0x1b8089300fea3e12, 0x4a76b736f7ccf177, 0x06cc1ad7f51e57dd, 0xd08a05315edff51f,
  0xafa30b2c4522cd3a, 0x3473abb71ea3a909, 0xf1b1d79d3768c919, 0x242282791bdab1aa, 0x226470decb65cc5c,
  0x6bd8598fb33ca8d8, 0xcf020270b37e0625, 0xde6f36450603bd6b, 0xbe54dea53929d002, 0xb4d5d38c6f19d103,
  0xf9b6e70c76f62aa8, 0x458df0dc79b09732, 0xe7ea75666fe0eee3, 0xc4ffef0f7bca1854, 0x6687993fc0fe32fc,
  0x17c68f45fe07efd8, 0xd9f0271964b867a6, 0xc95fb9a19961d252, 0x00009f971076e8b3,
};

/*
 * m329a_u2x12_uart0_lednop_ee_hw    m329p_u2x12_uart0_lednop_ee_hw    m329pa_u2x12_uart0_lednop_ee_hw
 * m3290_u2x12_uart0_lednop_ee_hw    m3290a_u2x12_uart0_lednop_ee_hw   m3290p_u2x12_uart0_lednop_ee_hw
 * m3290pa_u2x12_uart0_lednop_ee_hw  m325_u2x12_uart0_lednop_ee_hw     m325a_u2x12_uart0_lednop_ee_hw
 * m325p_u2x12_uart0_lednop_ee_hw    m325pa_u2x12_uart0_lednop_ee_hw   m3250_u2x12_uart0_lednop_ee_hw
 * m3250a_u2x12_uart0_lednop_ee_hw   m3250p_u2x12_uart0_lednop_ee_hw   m3250pa_u2x12_uart0_lednop_ee_hw
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_ee_hw[] = {
  0xbb686bc1a2432493, 0xeeaaf2207ee25bbb, 0x9b200bf6a2eeeeee, 0x4e6130feebc8ebc1, 0x0dc82b4ed50b6976,
  0x7c602410c5bbc9dd, 0x29effa14cfefb982, 0x527f36a7d56e9f09, 0xb5a39c61b46f6a8e, 0x30698fa8f2b32a6a,
  0x2877c561efd47c1b, 0x8c2cb1148b34eb42, 0x973d571ac9a426be, 0x3a6ed1923268e756, 0x791bdab1aad743af,
  0xdecb65cc5c242282, 0x1f667951b047eb70, 0xe166fc0c4ad7b002, 0x8a0c077ad79e0404, 0x4a7253a005bcde6c,
  0x18de33a2077ca9bd, 0x22adec555169aba7, 0xdc79b09732f9b6e7, 0xbde50c2a73f505d8, 0xe07f197e627ff787,
  0xff03f7ec3343cc9f, 0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0xf3044a29e4afdcd0, 0x000000000000002d,
};

/*
 * m329_u2x12_uart0_lednop_ee_ce_u4_hw m329a_u2x12_uart0_lednop_ee_ce_hw
 * m329a_u2x12_uart0_lednop_ee_ce_u4_hw m329p_u2x12_uart0_lednop_ee_ce_hw
 * m329p_u2x12_uart0_lednop_ee_ce_u4_hw m329pa_u2x12_uart0_lednop_ee_ce_hw
 * m329pa_u2x12_uart0_lednop_ee_ce_u4_hw m3290_u2x12_uart0_lednop_ee_ce_hw
 * m3290_u2x12_uart0_lednop_ee_ce_u4_hw m3290a_u2x12_uart0_lednop_ee_ce_hw
 * m3290a_u2x12_uart0_lednop_ee_ce_u4_hw m3290p_u2x12_uart0_lednop_ee_ce_hw
 * m3290p_u2x12_uart0_lednop_ee_ce_u4_hw m3290pa_u2x12_uart0_lednop_ee_ce_hw
 * m3290pa_u2x12_uart0_lednop_ee_ce_u4_hw m325_u2x12_uart0_lednop_ee_ce_hw
 * m325_u2x12_uart0_lednop_ee_ce_u4_hw m325a_u2x12_uart0_lednop_ee_ce_hw
 * m325a_u2x12_uart0_lednop_ee_ce_u4_hw m325p_u2x12_uart0_lednop_ee_ce_hw
 * m325p_u2x12_uart0_lednop_ee_ce_u4_hw m325pa_u2x12_uart0_lednop_ee_ce_hw
 * m325pa_u2x12_uart0_lednop_ee_ce_u4_hw m3250_u2x12_uart0_lednop_ee_ce_hw
 * m3250_u2x12_uart0_lednop_ee_ce_u4_hw m3250a_u2x12_uart0_lednop_ee_ce_hw
 * m3250a_u2x12_uart0_lednop_ee_ce_u4_hw m3250p_u2x12_uart0_lednop_ee_ce_hw
 * m3250p_u2x12_uart0_lednop_ee_ce_u4_hw m3250pa_u2x12_uart0_lednop_ee_ce_hw
 * m3250pa_u2x12_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u2x12_uart0_lednop_ee_ce_hw[] = {
  0x76d0d78344867f3e, 0xbaabae4048c4b777, 0xbc8d05db13bbbbbb, 0xe912c47771da09d3, 0xaa8bf5d6d1ddc123,
  0x8c048218b7793bb1, 0xd1ff4299f7f9304f, 0x4fe6d4faadd3e120, 0xa8e43c368ded51ca, 0x1e79b680e25ab8be,
  0x4bf10d8488bee24b, 0x771b9494ce5fa8f8, 0xdd4a76b736f7ccf1, 0x1f06cc1ad7f51e57, 0x3ad08a05315edff5,
  0x09afa30b2c4522cd, 0x193473abb71ea3a9, 0xaaf1b1d79d3768c9, 0x5c242282791bdab1, 0xd8226470decb65cc,
  0x256bd8598fb33ca8, 0x6bcf020270b37e06, 0x02de6f36450603bd, 0x03be54dea53929d0, 0xa8b4d5d38c6f19d1,
  0x32f9b6e70c76f62a, 0x73f505d8dc79b097, 0x627ff787bde50c2a, 0x3343cc9fe07f197e, 0x0be347a2ff03f7ec,
  0x6cf8138cb25c33d3, 0xe4afdcd0ccb0e929, 0x0000014057107a29,
};

/*
 * m329a_u2x12_uart0_dual            m329p_u2x12_uart0_dual            m329pa_u2x12_uart0_dual
 * m3290_u2x12_uart0_dual            m3290a_u2x12_uart0_dual           m3290p_u2x12_uart0_dual
 * m3290pa_u2x12_uart0_dual          m325_u2x12_uart0_dual             m325a_u2x12_uart0_dual
 * m325p_u2x12_uart0_dual            m325pa_u2x12_uart0_dual           m3250_u2x12_uart0_dual
 * m3250a_u2x12_uart0_dual           m3250p_u2x12_uart0_dual           m3250pa_u2x12_uart0_dual
 */
static const uint64_t ur_m329_u2x12_uart0_dual[] = {
  0x77774c9f37d44511, 0xdddddbf2a1c4e36b, 0x1db83d38056b62dd, 0xb229c6477775a5d9, 0x92b6ee57ccfb4b13,
  0x9827c602410c5bbc, 0x775b40c894948643, 0x12e20614306d2303, 0x9a43fe656024ee9f, 0xea3945d8393387ce,
  0x114239227f06fe4d, 0x70f8510c4aff3f7c, 0x2abbbddf370e0803, 0x37e2a10cb41ef443, 0x4b6f01bfe80e784c,
  0xff480930586f2bc8, 0xf36a7d56e9f0904f, 0xd5fe1b46f6a8e527, 0xfc1a43f51ee19df2, 0x0bf8732d726a38e9,
  0x8b7613e8d059cc58, 0x561a4dc72c608ebc, 0x7b27f157ceee2a4a, 0xe0404e166fc0c4ad, 0x400b79bcc077ad79,
  0xa9f016a72452d5e7, 0xe33a2065fe2810b4, 0xe6c25ccbe6da718d, 0x85727e7f62e4d5c1, 0xb67c09c6592e19e9,
  0xf257ee6866587494, 0x000000cb7edd1014,
};

/*
 * m329_u2x12_uart0_dual_pr_u4       m329a_u2x12_uart0_dual_pr         m329a_u2x12_uart0_dual_pr_u4
 * m329p_u2x12_uart0_dual_pr         m329p_u2x12_uart0_dual_pr_u4      m329pa_u2x12_uart0_dual_pr
 * m329pa_u2x12_uart0_dual_pr_u4     m3290_u2x12_uart0_dual_pr         m3290_u2x12_uart0_dual_pr_u4
 * m3290a_u2x12_uart0_dual_pr        m3290a_u2x12_uart0_dual_pr_u4     m3290p_u2x12_uart0_dual_pr
 * m3290p_u2x12_uart0_dual_pr_u4     m3290pa_u2x12_uart0_dual_pr       m3290pa_u2x12_uart0_dual_pr_u4
 * m325_u2x12_uart0_dual_pr          m325_u2x12_uart0_dual_pr_u4       m325a_u2x12_uart0_dual_pr
 * m325a_u2x12_uart0_dual_pr_u4      m325p_u2x12_uart0_dual_pr         m325p_u2x12_uart0_dual_pr_u4
 * m325pa_u2x12_uart0_dual_pr        m325pa_u2x12_uart0_dual_pr_u4     m3250_u2x12_uart0_dual_pr
 * m3250_u2x12_uart0_dual_pr_u4      m3250a_u2x12_uart0_dual_pr        m3250a_u2x12_uart0_dual_pr_u4
 * m3250p_u2x12_uart0_dual_pr        m3250p_u2x12_uart0_dual_pr_u4     m3250pa_u2x12_uart0_dual_pr
 * m3250pa_u2x12_uart0_dual_pr_u4
 */
static const uint64_t ur_m329_u2x12_uart0_dual_pr[] = {
  0xdd327cde890c0668, 0x776fca86828daddd, 0x33b2477a93377777, 0x3da05eeee841f4ec, 0xe07d6089f7c7f57c,
  0x602410c5bbc9866e, 0x0c894948a4a9827c, 0x614306d2303775b4, 0xf32ba0cee9f12e20, 0x2ec0e19c0a5ccc17,
  0x9227f07fba6f51dd, 0x10c4aff3f7c11423, 0xddf373fe00370f85, 0x10cb417c4432abbb, 0x95ff4073c267be2a,
  0x7982c3795e425b7a, 0xfaadd3e12eebfdcd, 0x368ded51ca4fe6d4, 0x87f51f229df2c4d4, 0x79a717be38e9fc18,
  0xad6475fce62c0550, 0x403ff6608ebc019d, 0x2740f2cf6c43a435, 0xd93f8abe77715255, 0x020270b37e06256b,
  0x6f36450603bd6bcf, 0x54dea53929d002de, 0xd5d38c6f19d103be, 0xdb739156f62aa8b4, 0xc6f86e3cd84b997c,
  0xf53ab337f07771a2, 0x7ff787bde50c2a73, 0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b,
  0xafdcd0ccb0e9296c, 0x00a49aa6b37459e4,
};

/*
 * m329a_u2x12_uart0_dual_pr_ee      m329p_u2x12_uart0_dual_pr_ee      m329pa_u2x12_uart0_dual_pr_ee
 * m3290_u2x12_uart0_dual_pr_ee      m3290a_u2x12_uart0_dual_pr_ee     m3290p_u2x12_uart0_dual_pr_ee
 * m3290pa_u2x12_uart0_dual_pr_ee    m325_u2x12_uart0_dual_pr_ee       m325a_u2x12_uart0_dual_pr_ee
 * m325p_u2x12_uart0_dual_pr_ee      m325pa_u2x12_uart0_dual_pr_ee     m3250_u2x12_uart0_dual_pr_ee
 * m3250a_u2x12_uart0_dual_pr_ee     m3250p_u2x12_uart0_dual_pr_ee     m3250pa_u2x12_uart0_dual_pr_ee
 */
static const uint64_t ur_m329_u2x12_uart0_dual_pr_ee[] = {
  0x74c9f370f5a1a5fb, 0xddbf19051f36b777, 0x0eb843dd9bdddddd, 0xb05ff4f74dd00aad, 0x75c892ac4d744feb,
  0x18b7793939dd2c8d, 0xa447dd304f8c0482, 0x69181bbada0644a4, 0x6774f8971030a183, 0x0e1a6a67f9f995d0,
  0x7d3f37a8fff3601a, 0xf3f7c114239227f0, 0x2500370f8510c4af, 0x8688655777bbe6e1, 0x9e133938a8432d03,
  0x95e425b7a1fffa03, 0x25a6ffdcd7982c37, 0x3949fcda9f55ba7c, 0xaad68e4486d1bdaa, 0xd983053d4795afb9,
  0x1143be2ba95ea3e0, 0xf4616588a459a75a, 0xd2e652e2a5cd2135, 0xea25da2147bd9cea, 0x1151f3d6355ae875,
  0x1bd97d2cc5c24228, 0x109fd62a3608fd6e, 0xb27f157ceee2a4a0, 0x0404e166fc0c4ad7, 0xde6c8a0c077ad79e,
  0xa9bd4a7253a005bc, 0xaba718de33a2077c, 0xb6e722adec555169, 0xe9f0dc79b09732f9, 0x53ab337f07771a2c,
  0x32fcc4fe50c2a73f, 0xbff82687993fc5ce, 0x64b867a615c9f8e7, 0x9961d252d9f02719, 0x6316e8b3c95fb9a1,
  0x00000000000002b2,
};

/*
 * m329a_u2x12_uart0_dual_pr_ee_u4   m329p_u2x12_uart0_dual_pr_ee_u4   m329pa_u2x12_uart0_dual_pr_ee_u4
 * m3290_u2x12_uart0_dual_pr_ee_u4   m3290a_u2x12_uart0_dual_pr_ee_u4  m3290p_u2x12_uart0_dual_pr_ee_u4
 * m3290pa_u2x12_uart0_dual_pr_ee_u4 m325_u2x12_uart0_dual_pr_ee_u4    m325a_u2x12_uart0_dual_pr_ee_u4
 * m325p_u2x12_uart0_dual_pr_ee_u4   m325pa_u2x12_uart0_dual_pr_ee_u4  m3250_u2x12_uart0_dual_pr_ee_u4
 * m3250a_u2x12_uart0_dual_pr_ee_u4  m3250p_u2x12_uart0_dual_pr_ee_u4  m3250pa_u2x12_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m329_u2x12_uart0_dual_pr_ee_u4[] = {
  0x7774c9f37a2432db, 0xddddbf19075b36b7, 0xfdd8becad4d7dddd, 0xb502ffa7bb625d96, 0x22ac07c674a3f738,
  0x410c5bbc9b82ee38, 0x29290b829827c602, 0x60da4606eeb68191, 0x7419dd3e25c40c28, 0xb1f387fc98347e65,
  0xf07d5f37a8fd3fb0, 0xaff3f7c114239227, 0xe25400370f8510c4, 0x04ac88655777bbe6, 0x039e132fb8a8432d,
  0x1bcaf212db9c1ffa, 0x3e12cadfee6bcc16, 0xd51ca4fe6d4faadd, 0xdcd56b47a54368de, 0xf06cc1fc9ea3cae3,
  0xad08a1df1598ff51, 0x9afa30b2c4522cd3, 0xead2e13d7082e690, 0xd7b589d87c47d21c, 0x47408ea5d8d56ba1,
  0xb86f65c7c62e1211, 0x7ceee2a4ab813ff5, 0x66fc0c4ad7b27f15, 0x0c077ad79e0404e1, 0x7253a005bcde6c8a,
  0xde33a2077ca9bd4a, 0xadec555169aba718, 0x79b09732f9b6e722, 0x6fe0eee3458df0dc, 0x7bca1854e7ea7566,
  0xc0fe32fcc4ffef0f, 0xfe07efd86687993f, 0x64b867a617c68f45, 0x9961d252d9f02719, 0x0b36e8b3c95fb9a1,
  0x0000000000000159,
};

/*
 * m329_u2x12_uart0_dual_pr_ce_u4    m329a_u2x12_uart0_dual_pr_ce      m329a_u2x12_uart0_dual_pr_ce_u4
 * m329p_u2x12_uart0_dual_pr_ce      m329p_u2x12_uart0_dual_pr_ce_u4   m329pa_u2x12_uart0_dual_pr_ce
 * m329pa_u2x12_uart0_dual_pr_ce_u4  m3290_u2x12_uart0_dual_pr_ce      m3290_u2x12_uart0_dual_pr_ce_u4
 * m3290a_u2x12_uart0_dual_pr_ce     m3290a_u2x12_uart0_dual_pr_ce_u4  m3290p_u2x12_uart0_dual_pr_ce
 * m3290p_u2x12_uart0_dual_pr_ce_u4  m3290pa_u2x12_uart0_dual_pr_ce    m3290pa_u2x12_uart0_dual_pr_ce_u4
 * m325_u2x12_uart0_dual_pr_ce       m325_u2x12_uart0_dual_pr_ce_u4    m325a_u2x12_uart0_dual_pr_ce
 * m325a_u2x12_uart0_dual_pr_ce_u4   m325p_u2x12_uart0_dual_pr_ce      m325p_u2x12_uart0_dual_pr_ce_u4
 * m325pa_u2x12_uart0_dual_pr_ce     m325pa_u2x12_uart0_dual_pr_ce_u4  m3250_u2x12_uart0_dual_pr_ce
 * m3250_u2x12_uart0_dual_pr_ce_u4   m3250a_u2x12_uart0_dual_pr_ce     m3250a_u2x12_uart0_dual_pr_ce_u4
 * m3250p_u2x12_uart0_dual_pr_ce     m3250p_u2x12_uart0_dual_pr_ce_u4  m3250pa_u2x12_uart0_dual_pr_ce
 * m3250pa_u2x12_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m329_u2x12_uart0_dual_pr_ce[] = {
  0xbba64f9bd121a5fb, 0xdddbf14dd179b5bb, 0xaf4fbfb5a16ddddd, 0xeb410f7774c894a2, 0x74b235d70f8ab2ab,
  0x30120862dde4c1b7, 0x19129290eddcc13e, 0xc2860da4606eeb68, 0xe657419dd3e25c40, 0x6c0c7ce033736ed7,
  0x227f064ea6f51c2d, 0x0c4aff3f7c114239, 0xbe6e75980370f851, 0x32d072688655777b, 0xffa039e134068a84,
  0xc161bcaf212db8d6, 0xadd3e12c09fee6bc, 0x8ded51ca4fe6d4fa, 0x80e3a5b8bea80436, 0x8488bee24b1e79b6,
  0x49faffa8f84bf10d, 0xb19f52e678bb8dc1, 0x7f0752fd471bf3dc, 0xce62c050507c8e3a, 0x78ebc019dad6475f,
  0x5b843a435403ff66, 0xf9ddc549549d03cb, 0xcdf81895af64fe2a, 0x180ef5af3c0809c2, 0xe4a7400b79bcd914,
  0xbc67440ef9537a94, 0xdbd8aaa2d3574e31, 0xe6c25ccbe6db9c31, 0xbf83bb8d1637c371, 0xef2861539fa9d599,
  0x03f8cbf313ffbc3d, 0xf81fbf619a1e64ff, 0x92e19e985f1a3d17, 0x6587494b67c09c65, 0x681ba2cf257ee686,
  0x0000000000006922,
};

/*
 * m329a_u2x12_uart0_dual_pr_ee_ce   m329p_u2x12_uart0_dual_pr_ee_ce   m329pa_u2x12_uart0_dual_pr_ee_ce
 * m3290_u2x12_uart0_dual_pr_ee_ce   m3290a_u2x12_uart0_dual_pr_ee_ce  m3290p_u2x12_uart0_dual_pr_ee_ce
 * m3290pa_u2x12_uart0_dual_pr_ee_ce m325_u2x12_uart0_dual_pr_ee_ce    m325a_u2x12_uart0_dual_pr_ee_ce
 * m325p_u2x12_uart0_dual_pr_ee_ce   m325pa_u2x12_uart0_dual_pr_ee_ce  m3250_u2x12_uart0_dual_pr_ee_ce
 * m3250a_u2x12_uart0_dual_pr_ee_ce  m3250p_u2x12_uart0_dual_pr_ee_ce  m3250pa_u2x12_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m329_u2x12_uart0_dual_pr_ee_ce[] = {
  0x7774c9f37d435202, 0xddddbf3c783e36b7, 0x435deeb7b7d7dddd, 0x038bd1deeabe0868, 0x6d1717e6be44fb84,
  0x0c5bbc9014ee721d, 0x4831eb9827c60241, 0xd2303775b40c8949, 0xcee9f12e20614306, 0x7035b9a61bf32ba0,
  0x5bf37a8e29361fae, 0x3f7c114239227f07, 0x000370f8510c4aff, 0x910caaeef77cdc00, 0xc2695d150865a115,
  0xbc84b6f6b7ff4073, 0x58fffb9af30586f2, 0x527f36a7d56e9f09, 0xf546e4e1b46f6a8e, 0x6bf3cdb40706b1df,
  0x4dd309cee372f0f9, 0x9ea3cadfc94ed656, 0x15c06f51f06cc1af, 0xc4522cd3ad08a053, 0x71943a909afa30b2,
  0x89768851ef673abb, 0xa8f9eb1aaf1b1d7a, 0xecbe9662e1211408, 0x27f58a8d8226470d, 0x9fc55f3bb8a92966,
  0x013859bf0312b5ec, 0x9b228301deb5e781, 0x6f529c94e8016f37, 0xe9c6378ce881df2a, 0x73863b7b15545a6a,
  0x386e3cd84b997cdb, 0x75666fe0eee3458f, 0xe32c970cf4c2b93f, 0x34332c3a4a5b3e04, 0x820f2edd16792bf7,
  0x0000000000000009,
};

/*
 * m329a_u2x12_uart0_dual_pr_ee_ce_u4 m329p_u2x12_uart0_dual_pr_ee_ce_u4
 * m329pa_u2x12_uart0_dual_pr_ee_ce_u4 m3290_u2x12_uart0_dual_pr_ee_ce_u4
 * m3290a_u2x12_uart0_dual_pr_ee_ce_u4 m3290p_u2x12_uart0_dual_pr_ee_ce_u4
 * m3290pa_u2x12_uart0_dual_pr_ee_ce_u4 m325_u2x12_uart0_dual_pr_ee_ce_u4
 * m325a_u2x12_uart0_dual_pr_ee_ce_u4 m325p_u2x12_uart0_dual_pr_ee_ce_u4
 * m325pa_u2x12_uart0_dual_pr_ee_ce_u4 m3250_u2x12_uart0_dual_pr_ee_ce_u4
 * m3250a_u2x12_uart0_dual_pr_ee_ce_u4 m3250p_u2x12_uart0_dual_pr_ee_ce_u4
 * m3250pa_u2x12_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_u2x12_uart0_dual_pr_ee_ce_u4[] = {
  0xa64f9bd15b77ac4f, 0xedf9855821b5bbbb, 0xae3793d721eeeeee, 0xa56eb3edfb19cc89, 0xa0d5d7bccd937514,
  0x498ee9a75571f5b4, 0x827c602410c5bbc9, 0xada0644a4a465b49, 0x71030a18369181bb, 0x72fccb41ca774f89,
  0xeb3d83219c292a66, 0x1c913f839869bd47, 0x2886257f9fbe08a1, 0x7bbe6e2e0801b87c, 0x0865a063e8865577,
  0x6ffe80e784dd5f15, 0x660b0de579096dcd, 0x55ba7c25883ff1f8, 0xd1bdaa3949fcda9f, 0x76337717d51a9e86,
  0x9117dc4963cf36d2, 0xe41ff51f097e21b0, 0x6e6e99e2ee373541, 0xf9ea3cadfc94ed6e, 0x315c06f51f06cc1a,
  0x2c4522cd3ad08a05, 0xb71943a909afa30b, 0xa89768851ef673ab, 0x8a8f9eb1aaf1b1d7, 0xdecbe9662e121140,
  0x627f58a8d8226470, 0xc9fc55f3bb8a9296, 0x1013859bf0312b5e, 0x79b228301deb5e78, 0xa6f529c94e8016f3,
  0xae9c6378ce881df2, 0xb73863b7b15545a6, 0xc9ab83cd84b997cd, 0x37f07edd8d1637c5, 0xbde50c2a73f53ab3,
  0xe07f197e627ff787, 0xff03f7ec3343cc9f, 0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0x939e46e9e4afdcd0,
  0x0000000000008001,
};

/*
 * m329a_u2x12_uart0_dual_ee_hw      m329p_u2x12_uart0_dual_ee_hw      m329pa_u2x12_uart0_dual_ee_hw
 * m3290_u2x12_uart0_dual_ee_hw      m3290a_u2x12_uart0_dual_ee_hw     m3290p_u2x12_uart0_dual_ee_hw
 * m3290pa_u2x12_uart0_dual_ee_hw    m325_u2x12_uart0_dual_ee_hw       m325a_u2x12_uart0_dual_ee_hw
 * m325p_u2x12_uart0_dual_ee_hw      m325pa_u2x12_uart0_dual_ee_hw     m3250_u2x12_uart0_dual_ee_hw
 * m3250a_u2x12_uart0_dual_ee_hw     m3250p_u2x12_uart0_dual_ee_hw     m3250pa_u2x12_uart0_dual_ee_hw
 */
static const uint64_t ur_m329_u2x12_uart0_dual_ee_hw[] = {
  0x774c9f37a2431f02, 0xdddbf19051f36b77, 0xd0eb843dd9bddddd, 0xbb05ff4f74dd00aa, 0x88b37a6144d744fe,
  0x410c5bbc9c9cee51, 0x525223ee9827c602, 0xc1b48c0ddd6d0322, 0xe833ba7c4b881850, 0x0d070d3533fcfcca,
  0xf83e9f9bd47ff9b0, 0x57f9fbe08a11c913, 0x7092801b87c28862, 0x81c34432abbbddf3, 0x01cf099c9c542196,
  0x1bcaf212dbd0fffd, 0x7c25a6fffd48cc16, 0xaa3949fcda9f55ba, 0xb9aad68e4486d1bd, 0xe0d983053d4795af,
  0x5a1143be2ba95ea3, 0x35f4616588a459a7, 0xead2e652e2a5cd21, 0x75ea25da2147bd9c, 0x281151f3d6355ae8,
  0x6e1bd97d2cc5c242, 0xa0109fd62a3608fd, 0xd7b27f157ceee2a4, 0x9e0404e166fc0c4a, 0xbcde6c8a0c077ad7,
  0x7ca9bd4a7253a005, 0x69aba718de33a207, 0xf9b6e722adec5551, 0xf505d8dc79b09732, 0x7ff787bde50c2a73,
  0x43cc9fe07f197e62, 0xe347a2ff03f7ec33, 0xf8138cb25c33d30b, 0xafdcd0ccb0e9296c, 0x00000aed631a29e4,
};

/*
 * m329a_u2x12_uart0_dual_ee_ce_hw   m329p_u2x12_uart0_dual_ee_ce_hw   m329pa_u2x12_uart0_dual_ee_ce_hw
 * m3290_u2x12_uart0_dual_ee_ce_hw   m3290a_u2x12_uart0_dual_ee_ce_hw  m3290p_u2x12_uart0_dual_ee_ce_hw
 * m3290pa_u2x12_uart0_dual_ee_ce_hw m325_u2x12_uart0_dual_ee_ce_hw    m325a_u2x12_uart0_dual_ee_ce_hw
 * m325p_u2x12_uart0_dual_ee_ce_hw   m325pa_u2x12_uart0_dual_ee_ce_hw  m3250_u2x12_uart0_dual_ee_ce_hw
 * m3250a_u2x12_uart0_dual_ee_ce_hw  m3250p_u2x12_uart0_dual_ee_ce_hw  m3250pa_u2x12_uart0_dual_ee_ce_hw
 */
static const uint64_t ur_m329_u2x12_uart0_dual_ee_ce_hw[] = {
  0x774c9f37d41432db, 0xdddbf3c783e36b77, 0x35deeb7b7d7ddddd, 0x38bd1deeabe08684, 0x1156699d644fb840,
  0x20862dde480a771c, 0xa4a418f5cc13e301, 0x8369181bbada0644, 0xd06774f8971030a1, 0xd7381adcd30df995,
  0x83adf9bd47149b0f, 0x7f9fbe08a11c913f, 0x000001b87c288625, 0x8ac88655777bbe6e, 0x39e134ae8a8432d0,
  0x795e425b7b5bffa0, 0x0958ffffa91982c3, 0x8e527f36a7d56e9f, 0xdff546e4e1b46f6a, 0xd90ff3cdb40706b1,
  0x564dd309cee373ac, 0xaf9ea3cadfc94ed6, 0x5315c06f51f06cc1, 0xb2c4522cd3ad08a0, 0xbb71943a909afa30,
  0x7a89768851ef673a, 0x08a8f9eb1aaf1b1d, 0x0decbe9662e12114, 0x6627f58a8d822647, 0xec9fc55f3bb8a929,
  0x81013859bf0312b5, 0x379b228301deb5e7, 0x2a6f529c94e8016f, 0x6ae9c6378ce881df, 0xdb73863b7b15545a,
  0xb0ec6e3cd84b997c, 0xf8138d2861539fa9, 0x30ae4fc07cd0f327, 0x96cf8138cb25c33d, 0x9e4afdcd0ccb0e92,
  0x000000075d4797a2,
};

/*
 * m329a_u2x12_uart0_dual_ee_ce_u4_hw m329p_u2x12_uart0_dual_ee_ce_u4_hw
 * m329pa_u2x12_uart0_dual_ee_ce_u4_hw m3290_u2x12_uart0_dual_ee_ce_u4_hw
 * m3290a_u2x12_uart0_dual_ee_ce_u4_hw m3290p_u2x12_uart0_dual_ee_ce_u4_hw
 * m3290pa_u2x12_uart0_dual_ee_ce_u4_hw m325_u2x12_uart0_dual_ee_ce_u4_hw
 * m325a_u2x12_uart0_dual_ee_ce_u4_hw m325p_u2x12_uart0_dual_ee_ce_u4_hw
 * m325pa_u2x12_uart0_dual_ee_ce_u4_hw m3250_u2x12_uart0_dual_ee_ce_u4_hw
 * m3250a_u2x12_uart0_dual_ee_ce_u4_hw m3250p_u2x12_uart0_dual_ee_ce_u4_hw
 * m3250pa_u2x12_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_u2x12_uart0_dual_ee_ce_u4_hw[] = {
  0x74c9f37a28d08f43, 0xddbf30ab0436b777, 0xc89ae3b793dddddd, 0x514a56eb3edfb19c, 0x6ada9c7d7bccd937,
  0x8b7792931dde27ed, 0x8cb69304f8c04821, 0x2303775b40c89494, 0xee9f12e20614306d, 0x5254cce5f99626b4,
  0xd37a8fd67b064338, 0x7c114239227f0730, 0x0370f8510c4aff3f, 0x0caaeef77cdc5c10, 0xbabe2a10cb40c7d1,
  0x12db9adffd01cf09, 0xff67a1cc161bcaf2, 0xf36a7d56e9f09620, 0x6a7a1b46f6a8e527, 0xcafac0e0cddc5f54,
  0x886c2445f71258f3, 0xb8a49cdffd47c25f, 0xa76b737374cf1771, 0x3660d7cf51e56fe4, 0x8450298ae037a8f8,
  0x7d185962291669d6, 0xb39d5db8ca1d484d, 0x8d8ebd44bb4428f7, 0x908a04547cf58d57, 0x132386f65f4b3170,
  0x5494b313fac546c1, 0x895af64fe2af9ddc, 0x5af3c0809c2cdf81, 0x00b79bcd914180ef, 0x40ef9537a94e4a74,
  0xaa2d3574e31bc674, 0xccbe6db9c31dbd8a, 0x9cfd4176371e6c25, 0x989ffde1ef79430a, 0x0cd0f327f81fc65f,
  0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4, 0x792bf734332c3a4a, 0x00003aeb2c85c2fa,
};

/*
 * m329a_swio10_noled                m329p_swio10_noled                m329pa_swio10_noled
 * m3290_swio10_noled                m3290a_swio10_noled               m3290p_swio10_noled
 * m3290pa_swio10_noled              m325_swio10_noled                 m325a_swio10_noled
 * m325p_swio10_noled                m325pa_swio10_noled               m3250_swio10_noled
 * m3250a_swio10_noled               m3250p_swio10_noled               m3250pa_swio10_noled
 */
static const uint64_t ur_m329_swio10_noled[] = {
  0x511377777759bb37, 0x44f5bbb557228322, 0xc4ef8fdd0e28e318, 0x105fd0ef413afad3, 0x869b1006db48bbb1,
  0x2410c5bbc9ddb1ec, 0xdfa1e7e449827c60, 0x313be589a941d2bf, 0x9238e9fc1887f51d, 0x3c731602dee9ba8c,
  0xc608ebc5cec37d19, 0x7972ab52b09adc72, 0x4aa35dce3398a0ed, 0xce576a96fab39d45, 0x434aa5f7afa4439a,
  0xc5aeb9ed5688af2c, 0x83ba9b14a7869de7, 0x5a5b44e31bc67440, 0x7cdb2048ab7b1554, 0x5c9f9fd86ed84b99,
  0x64a271964b867a61, 0x5fb9a19961d252d9, 0x0000a93ebd71f3c9,
};

/*
 * m329_swio10_noled_pr_u4           m329a_swio10_noled_pr             m329a_swio10_noled_pr_u4
 * m329p_swio10_noled_pr             m329p_swio10_noled_pr_u4          m329pa_swio10_noled_pr
 * m329pa_swio10_noled_pr_u4         m3290_swio10_noled_pr             m3290_swio10_noled_pr_u4
 * m3290a_swio10_noled_pr            m3290a_swio10_noled_pr_u4         m3290p_swio10_noled_pr
 * m3290p_swio10_noled_pr_u4         m3290pa_swio10_noled_pr           m3290pa_swio10_noled_pr_u4
 * m325_swio10_noled_pr              m325_swio10_noled_pr_u4           m325a_swio10_noled_pr
 * m325a_swio10_noled_pr_u4          m325p_swio10_noled_pr             m325p_swio10_noled_pr_u4
 * m325pa_swio10_noled_pr            m325pa_swio10_noled_pr_u4         m3250_swio10_noled_pr
 * m3250_swio10_noled_pr_u4          m3250a_swio10_noled_pr            m3250a_swio10_noled_pr_u4
 * m3250p_swio10_noled_pr            m3250p_swio10_noled_pr_u4         m3250pa_swio10_noled_pr
 * m3250pa_swio10_noled_pr_u4
 */
static const uint64_t ur_m329_swio10_noled_pr[] = {
  0x8f7777768911259b, 0x1776aae450b8c4a3, 0x7af4f54c0e26c13c, 0x9ade17b6fd2a45c7, 0x0bfc7f8bdd8e3d05,
  0x793bb2eec4833817, 0xf7304f8c048218b7, 0x8b283dd7f9e059f8, 0xc193dea3cdc77cb0, 0x2cb298ca9c638e9f,
  0x3e767bd1dac73160, 0x59ea807fecc11d7a, 0xad556a81e59eddc3, 0x7738ce6283b5e5ca, 0xaa5beace75152a8d,
  0x97debe910e6b395d, 0xe7b55a22bcb10d2a, 0x6c529e1a779f16ba, 0x138c6f19d1020eea, 0x8122adec5551696d,
  0x6ae0f3612e65f36c, 0x3c81f943458df172, 0x7bca1854e7ea7566, 0xc0fe32fcc4ffef0f, 0xfe07efd86687993f,
  0x64b867a617c68f45, 0x9961d252d9f02719, 0x405c4053c95fb9a1, 0x0000000000007c98,
};

/*
 * m329a_swio10_noled_pr_ee          m329p_swio10_noled_pr_ee          m329pa_swio10_noled_pr_ee
 * m3290_swio10_noled_pr_ee          m3290a_swio10_noled_pr_ee         m3290p_swio10_noled_pr_ee
 * m3290pa_swio10_noled_pr_ee        m325_swio10_noled_pr_ee           m325a_swio10_noled_pr_ee
 * m325p_swio10_noled_pr_ee          m325pa_swio10_noled_pr_ee         m3250_swio10_noled_pr_ee
 * m3250a_swio10_noled_pr_ee         m3250p_swio10_noled_pr_ee         m3250pa_swio10_noled_pr_ee
 */
static const uint64_t ur_m329_swio10_noled_pr_ee[] = {
  0x7dddddd0f5a22044, 0xdddaabf0bd05890d, 0xa7a6274b88ce6e64, 0xd0daf4a34cfda9bf, 0x2d4564041b410d7a,
  0x277505272b8210da, 0xa609f180904316ef, 0xca0e9bff3c0b3e35, 0x47959c39aad68e3d, 0x2ebea3e0d9833d7d,
  0xa459a75a1143be2b, 0xd64d2135f4616588, 0x23884e75697fdcb8, 0x1aad743af3a6eda5, 0x62e121142628c45b,
  0x8d823f5b86f65b2e, 0x7972ab50089aafea, 0x4aa35dce3398a0ed, 0xce576a96fab39d45, 0x434aa5f7afa4439a,
  0xc5aeb9ed5688af2c, 0x83ba9b14a7869de7, 0x5a5b44e31bc67440, 0x7cdb2048ab7b1554, 0x7c5c9ab83cd84b99,
  0xeacc7903f2868b3a, 0xbf313f9430a9cfd4, 0xfe09a1e64ff1738c, 0x2e19e985727e39ef, 0x587494b67c09c659,
  0x3d1014f257ee6866, 0x0000000000013afd,
};

/*
 * m329a_swio10_noled_pr_ee_u4       m329p_swio10_noled_pr_ee_u4       m329pa_swio10_noled_pr_ee_u4
 * m3290_swio10_noled_pr_ee_u4       m3290a_swio10_noled_pr_ee_u4      m3290p_swio10_noled_pr_ee_u4
 * m3290pa_swio10_noled_pr_ee_u4     m325_swio10_noled_pr_ee_u4        m325a_swio10_noled_pr_ee_u4
 * m325p_swio10_noled_pr_ee_u4       m325pa_swio10_noled_pr_ee_u4      m3250_swio10_noled_pr_ee_u4
 * m3250a_swio10_noled_pr_ee_u4      m3250p_swio10_noled_pr_ee_u4      m3250pa_swio10_noled_pr_ee_u4
 */
static const uint64_t ur_m329_swio10_noled_pr_ee_u4[] = {
  0x426eeeeed1222582, 0xda776aafc2ed2e25, 0xd1748fe933e3fe24, 0xf229835cdd95b6a6, 0x82d0bc2841b41508,
  0xf2774ed0439765aa, 0x6e609f180904316e, 0xd4a0e56ff3c0b3fa, 0xea3cad2b4d56b47d, 0xbf9dea3e0d98397d,
  0x8a459a75a1143be2, 0x144cd2135f461658, 0x4463e1cead2f0197, 0x1aad743af5d4dd81, 0xc5c24228c8a8fa0b,
  0xe09afadc37b2e1c8, 0x19cc5076bcb955aa, 0x7d59cea2a551aee7, 0xd7d221cd672bb54b, 0xab44579621a552fb,
  0x53c34ef3e2d75cf6, 0x8de33a2041dd4d8a, 0x55bd8aaa2d2da271, 0x1e6c25ccbe6d9024, 0x3f2868b1be2e4d5c,
  0x430a9cfd4eacc790, 0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0, 0x3a4a5b3e04e32c97,
  0x880a792bf734332c, 0x000000000275d22f,
};

/*
 * m329_swio10_noled_pr_ce_u4        m329a_swio10_noled_pr_ce          m329a_swio10_noled_pr_ce_u4
 * m329p_swio10_noled_pr_ce          m329p_swio10_noled_pr_ce_u4       m329pa_swio10_noled_pr_ce
 * m329pa_swio10_noled_pr_ce_u4      m3290_swio10_noled_pr_ce          m3290_swio10_noled_pr_ce_u4
 * m3290a_swio10_noled_pr_ce         m3290a_swio10_noled_pr_ce_u4      m3290p_swio10_noled_pr_ce
 * m3290p_swio10_noled_pr_ce_u4      m3290pa_swio10_noled_pr_ce        m3290pa_swio10_noled_pr_ce_u4
 * m325_swio10_noled_pr_ce           m325_swio10_noled_pr_ce_u4        m325a_swio10_noled_pr_ce
 * m325a_swio10_noled_pr_ce_u4       m325p_swio10_noled_pr_ce          m325p_swio10_noled_pr_ce_u4
 * m325pa_swio10_noled_pr_ce         m325pa_swio10_noled_pr_ce_u4      m3250_swio10_noled_pr_ce
 * m3250_swio10_noled_pr_ce_u4       m3250a_swio10_noled_pr_ce         m3250a_swio10_noled_pr_ce_u4
 * m3250p_swio10_noled_pr_ce         m3250p_swio10_noled_pr_ce_u4      m3250pa_swio10_noled_pr_ce
 * m3250pa_swio10_noled_pr_ce_u4
 */
static const uint64_t ur_m329_swio10_noled_pr_ce[] = {
  0xf26eeeeed1222044, 0xfc776aaf0890ce24, 0xf6475a2e8c1aec1e, 0x9b3fd7d698bcd8b1, 0x70437ae34d4deebc,
  0x0c5bbc9dd4149cba, 0x2cfdba9827c60241, 0x2fac89283813fcf0, 0x92c79e012a7795ae, 0x3e12fc4361222fb8,
  0x3c5dc6e2545c8fea, 0xd47c927b9633f593, 0xee8148e3a7f0782f, 0xcecf7a3b58e62c05, 0x3d500ffd99e3af47,
  0x6aab540f2d6eb86b, 0xb9c673141daf2e55, 0x52df5673a8a9546b, 0xbef5f4887359caed, 0x3daad115e5886954,
  0x6294f0d3bcf8b5d7, 0x9c6378ce88107753, 0x10c76f62aa8b4b68, 0xae0f3612e65f36c8, 0xc81f943458df1726,
  0xbca1854e7ea75663, 0x0fe32fcc4ffef0f7, 0xe07efd86687993fc, 0x4b867a617c68f45f, 0x961d252d9f027196,
  0x6544053c95fb9a19, 0x000000000001baf5,
};

/*
 * m329a_swio10_noled_pr_ee_ce       m329p_swio10_noled_pr_ee_ce       m329pa_swio10_noled_pr_ee_ce
 * m3290_swio10_noled_pr_ee_ce       m3290a_swio10_noled_pr_ee_ce      m3290p_swio10_noled_pr_ee_ce
 * m3290pa_swio10_noled_pr_ee_ce     m325_swio10_noled_pr_ee_ce        m325a_swio10_noled_pr_ee_ce
 * m325p_swio10_noled_pr_ee_ce       m325pa_swio10_noled_pr_ee_ce      m3250_swio10_noled_pr_ee_ce
 * m3250a_swio10_noled_pr_ee_ce      m3250p_swio10_noled_pr_ee_ce      m3250pa_swio10_noled_pr_ee_ce
 */
static const uint64_t ur_m329_swio10_noled_pr_ee_ce[] = {
  0xb31ddddddd4477d6, 0xc45ddaabd85160c4, 0x5a33d477a4863b18, 0x1f1f5a353a66b8da, 0xa1232ec20832d5b3,
  0xbbc9dd7ad388a57d, 0x8689827c602410c5, 0x70e506c7ffcf02cf, 0x804a9dd8f9dff546, 0x139dc6e1256547e7,
  0x2b74b29dacac7be6, 0xfd47c1b306807a8f, 0xb34eb422814c5721, 0xea426be8c2cb1148, 0x948e2139d5dbbf70,
  0xd8d578d8ebce9bb6, 0x73170908a1314622, 0xaa3608991c37b2d9, 0xb5e5caad4b326abf, 0x152a8d7738ce6283,
  0x6b395daa5beace75, 0xb10d2a97debe910e, 0x9f16bae7b55a22bc, 0x020eea6c529e1a77, 0x51696d138c6f19d1,
  0xcbe6d90218edec55, 0x163ce2e4d5c6c25c, 0xe4fdd598f207e50d, 0x25138cb25c33d30a, 0xfdcd0ccb0e9296cb,
  0x014d3b1fe2029e4a,
};

/*
 * m329a_swio10_noled_pr_ee_ce_u4    m329p_swio10_noled_pr_ee_ce_u4    m329pa_swio10_noled_pr_ee_ce_u4
 * m3290_swio10_noled_pr_ee_ce_u4    m3290a_swio10_noled_pr_ee_ce_u4   m3290p_swio10_noled_pr_ee_ce_u4
 * m3290pa_swio10_noled_pr_ee_ce_u4  m325_swio10_noled_pr_ee_ce_u4     m325a_swio10_noled_pr_ee_ce_u4
 * m325p_swio10_noled_pr_ee_ce_u4    m325pa_swio10_noled_pr_ee_ce_u4   m3250_swio10_noled_pr_ee_ce_u4
 * m3250a_swio10_noled_pr_ee_ce_u4   m3250p_swio10_noled_pr_ee_ce_u4   m3250pa_swio10_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio10_noled_pr_ee_ce_u4[] = {
  0x90dddddda2436d3a, 0x62eed55fd4f27448, 0x2e94add86656c17e, 0x430a800d8466244d, 0xc667627c88596cf2,
  0x7793bb73b66c7b64, 0x87d304f8c048218b, 0xba941c41ff62bb3e, 0x36d01cc41717d51d, 0x21b09117dc4963cf,
  0xcea72e0bf51f097e, 0x3b5b9b7be678bb8d, 0x660d00f51e56e965, 0x450298ae43fa8f83, 0xd185962291669d68,
  0x73abb77ee1d484d7, 0xb1d79d376d291c42, 0x1142628c45b1aaf1, 0x32386f65b2e62e12, 0x5a9664d57f546c11,
  0xee719cc5076bcb95, 0x54b7d59cea2a551a, 0x2fbd7d221cd672bb, 0xcf6ab44579621a55, 0xd8a53c34ef3e2d75,
  0x2718de33a2041dd4, 0x0431dbd8aaa2d2da, 0x86e3cd84b997cdb2, 0xab337f07771a2c6f, 0x787bde50c2a73f53,
  0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0x3f32d2b7459e4afd,
  0x0000000000000001,
};

/*
 * m329a_swio10_noled_ee_hw          m329p_swio10_noled_ee_hw          m329pa_swio10_noled_ee_hw
 * m3290_swio10_noled_ee_hw          m3290a_swio10_noled_ee_hw         m3290p_swio10_noled_ee_hw
 * m3290pa_swio10_noled_ee_hw        m325_swio10_noled_ee_hw           m325a_swio10_noled_ee_hw
 * m325p_swio10_noled_ee_hw          m325pa_swio10_noled_ee_hw         m3250_swio10_noled_ee_hw
 * m3250a_swio10_noled_ee_hw         m3250p_swio10_noled_ee_hw         m3250pa_swio10_noled_ee_hw
 */
static const uint64_t ur_m329_swio10_noled_ee_hw[] = {
  0x6beeeeeed121af43, 0x26eed55f85e82c48, 0x9bdfa7ba5c467373, 0xd7ad0daf4a34cfda, 0x29a2d4564041b410,
  0x62dde4eeb4efb5bb, 0x67c6b4c13e301208, 0xb471ee5074dffd0a, 0x19ebea3cace1cd56, 0x1df15975f51f06cc,
  0x0b2c4522cd3ad08a, 0xfee5c6b26909afa3, 0x376d291c4273ab4b, 0x4622d8d56ba1d79d, 0xb2d973170908a131,
  0xd57f546c11fadc37, 0xc5076bcb955a8044, 0x9cea2a551aee719c, 0x221cd672bb54b7d5, 0x4579621a552fbd7d,
  0x34ef3e2d75cf6ab4, 0x33a2041dd4d8a53c, 0xd8aaa2d2da2718de, 0xc25ccbe6d902455b, 0x30a9cfd4176371e6,
  0x65f989ffde1ef794, 0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970, 0xa8a792bf734332c3,
  0x00000000005be015,
};

/*
 * m329_swio10_noled_ee_ce_u4_hw     m329a_swio10_noled_ee_ce_hw       m329a_swio10_noled_ee_ce_u4_hw
 * m329p_swio10_noled_ee_ce_hw       m329p_swio10_noled_ee_ce_u4_hw    m329pa_swio10_noled_ee_ce_hw
 * m329pa_swio10_noled_ee_ce_u4_hw   m3290_swio10_noled_ee_ce_hw       m3290_swio10_noled_ee_ce_u4_hw
 * m3290a_swio10_noled_ee_ce_hw      m3290a_swio10_noled_ee_ce_u4_hw   m3290p_swio10_noled_ee_ce_hw
 * m3290p_swio10_noled_ee_ce_u4_hw   m3290pa_swio10_noled_ee_ce_hw     m3290pa_swio10_noled_ee_ce_u4_hw
 * m325_swio10_noled_ee_ce_hw        m325_swio10_noled_ee_ce_u4_hw     m325a_swio10_noled_ee_ce_hw
 * m325a_swio10_noled_ee_ce_u4_hw    m325p_swio10_noled_ee_ce_hw       m325p_swio10_noled_ee_ce_u4_hw
 * m325pa_swio10_noled_ee_ce_hw      m325pa_swio10_noled_ee_ce_u4_hw   m3250_swio10_noled_ee_ce_hw
 * m3250_swio10_noled_ee_ce_u4_hw    m3250a_swio10_noled_ee_ce_hw      m3250a_swio10_noled_ee_ce_u4_hw
 * m3250p_swio10_noled_ee_ce_hw      m3250p_swio10_noled_ee_ce_u4_hw   m3250pa_swio10_noled_ee_ce_hw
 * m3250pa_swio10_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio10_noled_ee_ce_hw[] = {
  0x90dddddda243173e, 0x62eed55fd4f27448, 0x2e94add86656c17e, 0x430a800d8466244d, 0xf667627c88596cf2,
  0x2dde4eee7da01d44, 0xfa1f4c13e3012086, 0x8edd4a0e20ffa14c, 0xe79b680e620b8bea, 0xbf10d8488bee24b1,
  0x1b9aa0f20ffa8f84, 0xca76b736f7ccf177, 0x06cc1a01ea3cadd2, 0xd08a05315c87f51f, 0xafa30b2c4522cd3a,
  0x84e7576efdc3a909, 0xe363af3a6eda5238, 0x242284c5188b6355, 0x226470decb65cc5c, 0x2ab52cc9aafea8d8,
  0x35dce3398a0ed797, 0x76a96fab39d454aa, 0xaa5f7afa4439ace5, 0xeb9ed5688af2c434, 0xa9b14a7869de7c5a,
  0xb44e31bc6744083b, 0x640863b7b15545a5, 0x5d8dc79b09732f9b, 0x787bde50c2a73f50, 0xc9fe07f197e627ff,
  0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81, 0x050165a5a29e4afd,
};

/*
 * m329a_swio10_lednop               m329p_swio10_lednop               m329pa_swio10_lednop
 * m3290_swio10_lednop               m3290a_swio10_lednop              m3290p_swio10_lednop
 * m3290pa_swio10_lednop             m325_swio10_lednop                m325a_swio10_lednop
 * m325p_swio10_lednop               m325pa_swio10_lednop              m3250_swio10_lednop
 * m3250a_swio10_lednop              m3250p_swio10_lednop              m3250pa_swio10_lednop
 */
static const uint64_t ur_m329_swio10_lednop[] = {
  0x444ddddddd66ef3a, 0x3d6eed55c8a78b89, 0x3da87ba871224611, 0x4417f43bd05af219, 0x135901b64cc6beec,
  0x120862dde4ee82f4, 0xefd0f3efe4c13e30, 0xf21df2c4d4a0995f, 0xdf1c74fe0c43fa8f, 0xa0398b016f74c7ab,
  0xb1823af173b5ac8f, 0x5e5caad4ace7b71c, 0x52a8d7738ce6283b, 0x1395daa5beace751, 0xad5d2fe910e6b810,
  0xae7b55a22bcb10d2, 0x96165362ce80f3f5, 0x8ff14085a6ae757a, 0x7cdb4e31bc67440d, 0x5c9f9fd86ed84b99,
  0x64a271964b867a61, 0x5fb9a19961d252d9, 0x00005483ad71f3c9,
};

/*
 * m329_swio10_lednop_pr_u4          m329a_swio10_lednop_pr            m329a_swio10_lednop_pr_u4
 * m329p_swio10_lednop_pr            m329p_swio10_lednop_pr_u4         m329pa_swio10_lednop_pr
 * m329pa_swio10_lednop_pr_u4        m3290_swio10_lednop_pr            m3290_swio10_lednop_pr_u4
 * m3290a_swio10_lednop_pr           m3290a_swio10_lednop_pr_u4        m3290p_swio10_lednop_pr
 * m3290p_swio10_lednop_pr_u4        m3290pa_swio10_lednop_pr          m3290pa_swio10_lednop_pr_u4
 * m325_swio10_lednop_pr             m325_swio10_lednop_pr_u4          m325a_swio10_lednop_pr
 * m325a_swio10_lednop_pr_u4         m325p_swio10_lednop_pr            m325p_swio10_lednop_pr_u4
 * m325pa_swio10_lednop_pr           m325pa_swio10_lednop_pr_u4        m3250_swio10_lednop_pr
 * m3250_swio10_lednop_pr_u4         m3250a_swio10_lednop_pr           m3250a_swio10_lednop_pr_u4
 * m3250p_swio10_lednop_pr           m3250p_swio10_lednop_pr_u4        m3250pa_swio10_lednop_pr
 * m3250pa_swio10_lednop_pr_u4
 */
static const uint64_t ur_m329_swio10_lednop_pr[] = {
  0x8f77777689110cc5, 0x0bbb55722998c4a3, 0x6f70add590e3609e, 0x59ade165c76dd08a, 0x4d4c17f1fdd8e3d0,
  0x7793bb06c371fb37, 0x80d304f8c048218b, 0x1165043dff9e059f, 0xf8327bd479c4ef96, 0x0b2ca631e7ac71d3,
  0x1f3b7c88e0f9cc58, 0xfa05403ff6608ebd, 0x55ac0ad03cb3dbde, 0xaee719cc5076bcb9, 0xb54b7d59cea2a551,
  0x5fd221cd7020272b, 0xab44579621a55aba, 0xd7ce80f1cad75cf6, 0x78ce881085482e52, 0xb7b15545a4829c63,
  0xcd84b997cdb2ec8a, 0xe50d1637c5c9ab83, 0x61539fa9d598f207, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8,
  0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0x014f257ee6866587, 0x00000001f26fd511,
};

/*
 * m329a_swio10_lednop_pr_ee         m329p_swio10_lednop_pr_ee         m329pa_swio10_lednop_pr_ee
 * m3290_swio10_lednop_pr_ee         m3290a_swio10_lednop_pr_ee        m3290p_swio10_lednop_pr_ee
 * m3290pa_swio10_lednop_pr_ee       m325_swio10_lednop_pr_ee          m325a_swio10_lednop_pr_ee
 * m325p_swio10_lednop_pr_ee         m325pa_swio10_lednop_pr_ee        m3250_swio10_lednop_pr_ee
 * m3250a_swio10_lednop_pr_ee        m3250p_swio10_lednop_pr_ee        m3250pa_swio10_lednop_pr_ee
 */
static const uint64_t ur_m329_swio10_lednop_pr_ee[] = {
  0x7dddddd0f5a232a8, 0xdddaabf0bd91890d, 0x3bc977c7edbe6e64, 0x86d7a5a0a34d68f2, 0x91f06620da086bd6,
  0x774eb46a89ccf971, 0x609f180904316ef2, 0x418e5fe78167fabe, 0xf2b287355ad1c7b9, 0x17d47c1b3067afa8,
  0x8b34eb422877c56c, 0xc9a426be8c2cb114, 0x6be1cead2ff3971a, 0xab5d0ebce9bb04f4, 0x70908a3244637ec6,
  0xc11fadc37b2d9731, 0x72ab500ae1acf546, 0xa35dce3398a0ed79, 0x576a96fab39d454a, 0x74bfa4439ae0404e,
  0xed5688af2c434ab5, 0xa5af9d01e395aeb9, 0xc6f19d10210a905c, 0x156f62aa8b490538, 0x079b09732f9b65d9,
  0x7e50d1674f8b9357, 0x861539fa9d598f20, 0xc9fe2e7197e627f2, 0xae4fc73dffc1343c, 0xcf8138cb25c33d30,
  0x4afdcd0ccb0e9296, 0x000013aebb22029e,
};

/*
 * m329a_swio10_lednop_pr_ee_u4      m329p_swio10_lednop_pr_ee_u4      m329pa_swio10_lednop_pr_ee_u4
 * m3290_swio10_lednop_pr_ee_u4      m3290a_swio10_lednop_pr_ee_u4     m3290p_swio10_lednop_pr_ee_u4
 * m3290pa_swio10_lednop_pr_ee_u4    m325_swio10_lednop_pr_ee_u4       m325a_swio10_lednop_pr_ee_u4
 * m325p_swio10_lednop_pr_ee_u4      m325pa_swio10_lednop_pr_ee_u4     m3250_swio10_lednop_pr_ee_u4
 * m3250a_swio10_lednop_pr_ee_u4     m3250p_swio10_lednop_pr_ee_u4     m3250pa_swio10_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_swio10_lednop_pr_ee_u4[] = {
  0xa84dddddda244511, 0x9b4eed55f85debc4, 0xd71efd3d1b6c47c4, 0x1e45306bb4b37764, 0xac884082083682a1,
  0xef27755f33e83658, 0x1ca609f180904316, 0xdd4a0dbaff3c0b3f, 0xdea3cae43cd56b47, 0x2b387ea3e0d98397,
  0x88a459a75a1143be, 0x7144cd2135f46165, 0x0046989cead2e515, 0xb1aad743af5d4dd9, 0x462e121143de8ed6,
  0xae2e1fd6e1bd970e, 0x719cc5076bcb955a, 0xb7d59cea2a551aee, 0x221cd7020272bb54, 0x4579621a55aba5fd,
  0xe80f1cad75cf6ab4, 0xe881085482e52d7c, 0x15545a4829c6378c, 0x4b997cdb2ec8ab7b, 0xd1637c5c9ab83cd8,
  0x39fa9d598f207e50, 0x313ffbc3def28615, 0x19a1e64ff03f8cbf, 0x85f1a3d17f81fbf6, 0xb67c09c6592e19e9,
  0xf257ee6866587494, 0x00000275c2171014,
};

/*
 * m329_swio10_lednop_pr_ce_u4       m329a_swio10_lednop_pr_ce         m329a_swio10_lednop_pr_ce_u4
 * m329p_swio10_lednop_pr_ce         m329p_swio10_lednop_pr_ce_u4      m329pa_swio10_lednop_pr_ce
 * m329pa_swio10_lednop_pr_ce_u4     m3290_swio10_lednop_pr_ce         m3290_swio10_lednop_pr_ce_u4
 * m3290a_swio10_lednop_pr_ce        m3290a_swio10_lednop_pr_ce_u4     m3290p_swio10_lednop_pr_ce
 * m3290p_swio10_lednop_pr_ce_u4     m3290pa_swio10_lednop_pr_ce       m3290pa_swio10_lednop_pr_ce_u4
 * m325_swio10_lednop_pr_ce          m325_swio10_lednop_pr_ce_u4       m325a_swio10_lednop_pr_ce
 * m325a_swio10_lednop_pr_ce_u4      m325p_swio10_lednop_pr_ce         m325p_swio10_lednop_pr_ce_u4
 * m325pa_swio10_lednop_pr_ce        m325pa_swio10_lednop_pr_ce_u4     m3250_swio10_lednop_pr_ce
 * m3250_swio10_lednop_pr_ce_u4      m3250a_swio10_lednop_pr_ce        m3250a_swio10_lednop_pr_ce_u4
 * m3250p_swio10_lednop_pr_ce        m3250p_swio10_lednop_pr_ce_u4     m3250pa_swio10_lednop_pr_ce
 * m3250pa_swio10_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_swio10_lednop_pr_ce[] = {
  0xf26eeeeed12232a8, 0xfc776aaf08942e24, 0x697571eedb75ec1e, 0x67fafad219e2f7a6, 0xb3ea8b41568dd793,
  0xc5bbc9dd3ad1a848, 0xcfc569827c602410, 0xfac89283beffcf02, 0x2c79e012a776eae2, 0xe12fc4361222fb89,
  0xc5dc6e5253397ea3, 0x470527b9633f5933, 0xed008e3a7f0782fd, 0xb7c88e0f9cc580a1, 0x5403ff6678ebd1f3,
  0xb02b40f2d6edefa0, 0x9c673141daf2e556, 0x2df5673a8a9546bb, 0x488735c0809caed5, 0x115e5886956ae97f,
  0x3a03c72b5d73daad, 0x3a20421520b94b5f, 0xc55516920a718de3, 0x25ccbe6d97618ede, 0x68b1be2e4d5c1e6c,
  0x9cfd4eacc7903f28, 0x989ffde1ef79430a, 0x0cd0f327f81fc65f, 0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4,
  0x792bf734332c3a4a, 0x000000375cb3880a,
};

/*
 * m329a_swio10_lednop_pr_ee_ce      m329p_swio10_lednop_pr_ee_ce      m329pa_swio10_lednop_pr_ee_ce
 * m3290_swio10_lednop_pr_ee_ce      m3290a_swio10_lednop_pr_ee_ce     m3290p_swio10_lednop_pr_ee_ce
 * m3290pa_swio10_lednop_pr_ee_ce    m325_swio10_lednop_pr_ee_ce       m325a_swio10_lednop_pr_ee_ce
 * m325p_swio10_lednop_pr_ee_ce      m325pa_swio10_lednop_pr_ee_ce     m3250_swio10_lednop_pr_ee_ce
 * m3250a_swio10_lednop_pr_ee_ce     m3250p_swio10_lednop_pr_ee_ce     m3250pa_swio10_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_swio10_lednop_pr_ee_ce[] = {
  0xb31ddddddd445541, 0xc45ddaabd85238c4, 0xbe4ed323a8259318, 0x1f1f5a3535834cde, 0xc8ce0db45832d5b3,
  0x7793ba0292634e39, 0x3b7304f8c048218b, 0xc3941ddaff3c0b3f, 0x012a77bb477fd519, 0x9cee373a3ea49f9e,
  0x597594ed6563df30, 0xea3e0d983403d479, 0x9a75a1140a62b297, 0x52135f4616588a45, 0xf46be1ceaeddf387,
  0x8d578d8ebce9bb04, 0x62e121146488c6fd, 0x46c1132386f65b2e, 0x7972ab52cee1acf5, 0x4aa35dce3398a0ed,
  0x4e576a96fab39d45, 0xb574bfa4439ae040, 0xb9ed5688af2c434a, 0x5ca5af9d01e395ae, 0x38c6f19d10210a90,
  0xb0c76f62aa8b4905, 0x26ae3612e65f36cb, 0xc7903f2868b1e717, 0x92e19e985727eeac, 0x587494b659289c65,
  0x291014f257ee6866, 0x00000000000a699c,
};

/*
 * m329a_swio10_lednop_pr_ee_ce_u4   m329p_swio10_lednop_pr_ee_ce_u4   m329pa_swio10_lednop_pr_ee_ce_u4
 * m3290_swio10_lednop_pr_ee_ce_u4   m3290a_swio10_lednop_pr_ee_ce_u4  m3290p_swio10_lednop_pr_ee_ce_u4
 * m3290pa_swio10_lednop_pr_ee_ce_u4 m325_swio10_lednop_pr_ee_ce_u4    m325a_swio10_lednop_pr_ee_ce_u4
 * m325p_swio10_lednop_pr_ee_ce_u4   m325pa_swio10_lednop_pr_ee_ce_u4  m3250_swio10_lednop_pr_ee_ce_u4
 * m3250a_swio10_lednop_pr_ee_ce_u4  m3250p_swio10_lednop_pr_ee_ce_u4  m3250pa_swio10_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio10_lednop_pr_ee_ce_u4[] = {
  0x21bbbbbb44864541, 0xc5ddaabfa9c0b891, 0x9d69dba34f1782fc, 0x8615001b19391998, 0xc5383774e0b2d9e4,
  0x7793ba8049b9c587, 0xfaf304f8c048218b, 0xba941801ff62bb3f, 0x36d01c801717d51d, 0x21b09117dc4963cf,
  0x816467aff51f097e, 0x76b736f7ccf1771b, 0xcc1a01ea3cacbaca, 0x8a0531594bf51f06, 0xa30b2c4522cd3ad0,
  0xe7576ef9c3a909af, 0xc75e74dd827a35f0, 0x8a3244637ec6abc6, 0x91c37b2d97317090, 0xa96770d67aa36089,
  0xe719cc5076bcb955, 0x4b7d59cea2a551ae, 0xd221cd7020272bb5, 0x44579621a55aba5f, 0xce80f1cad75cf6ab,
  0xce881085482e52d7, 0xb15545a4829c6378, 0x09732f9b65d863b7, 0x0eee3458df0dc79b, 0xa1854e7ea75666fe,
  0xe32fcc4ffef0f7bc, 0x7efd86687993fc0f, 0x867a617c68f45fe0, 0x1d252d9f0271964b, 0x6e8b3c95fb9a1996,
  0x00000000027e5b90,
};

/*
 * m329a_swio10_lednop_ee_hw         m329p_swio10_lednop_ee_hw         m329pa_swio10_lednop_ee_hw
 * m3290_swio10_lednop_ee_hw         m3290a_swio10_lednop_ee_hw        m3290p_swio10_lednop_ee_hw
 * m3290pa_swio10_lednop_ee_hw       m325_swio10_lednop_ee_hw          m325a_swio10_lednop_ee_hw
 * m325p_swio10_lednop_ee_hw         m325pa_swio10_lednop_ee_hw        m3250_swio10_lednop_ee_hw
 * m3250a_swio10_lednop_ee_hw        m3250p_swio10_lednop_ee_hw        m3250pa_swio10_lednop_ee_hw
 */
static const uint64_t ur_m329_swio10_lednop_ee_hw[] = {
  0x6beeeeeed121b032, 0x26eed55f85ec8c48, 0x8df23bbe3f6df373, 0xbd686d7a5a0a34d6, 0x97191f06620da086,
  0x2dde4eeb6239da9c, 0xff57cc13e3012086, 0x8e3dca0c72ffa14c, 0x3d7d47959439aad6, 0xbe2b60bea3e0d983,
  0x6588a459a75a1143, 0x9cb8d64d2135f461, 0xd827a35f0e75697f, 0x1bf6355ae875e74d, 0x6cb98b8484519223,
  0x67aa3608fd6e1bd9, 0x076bcb955a80570d, 0xea2a551aee719cc5, 0x020272bb54b7d59c, 0x1a55aba5fd221cd7,
  0xad75cf6ab4457962, 0x5482e52d7ce80f1c, 0x4829c6378ce88108, 0xdb2ec8ab7b15545a, 0x82ec6e3cd84b997c,
  0xfbc3def2861539fa, 0xe64ff03f8cbf313f, 0xa3d17f81fbf619a1, 0x09c6592e19e985f1, 0xee6866587494b67c,
  0x0016f9ac1514f257,
};

/*
 * m329_swio10_lednop_ee_ce_u4_hw    m329a_swio10_lednop_ee_ce_hw      m329a_swio10_lednop_ee_ce_u4_hw
 * m329p_swio10_lednop_ee_ce_hw      m329p_swio10_lednop_ee_ce_u4_hw   m329pa_swio10_lednop_ee_ce_hw
 * m329pa_swio10_lednop_ee_ce_u4_hw  m3290_swio10_lednop_ee_ce_hw      m3290_swio10_lednop_ee_ce_u4_hw
 * m3290a_swio10_lednop_ee_ce_hw     m3290a_swio10_lednop_ee_ce_u4_hw  m3290p_swio10_lednop_ee_ce_hw
 * m3290p_swio10_lednop_ee_ce_u4_hw  m3290pa_swio10_lednop_ee_ce_hw    m3290pa_swio10_lednop_ee_ce_u4_hw
 * m325_swio10_lednop_ee_ce_hw       m325_swio10_lednop_ee_ce_u4_hw    m325a_swio10_lednop_ee_ce_hw
 * m325a_swio10_lednop_ee_ce_u4_hw   m325p_swio10_lednop_ee_ce_hw      m325p_swio10_lednop_ee_ce_u4_hw
 * m325pa_swio10_lednop_ee_ce_hw     m325pa_swio10_lednop_ee_ce_u4_hw  m3250_swio10_lednop_ee_ce_hw
 * m3250_swio10_lednop_ee_ce_u4_hw   m3250a_swio10_lednop_ee_ce_hw     m3250a_swio10_lednop_ee_ce_u4_hw
 * m3250p_swio10_lednop_ee_ce_hw     m3250p_swio10_lednop_ee_ce_u4_hw  m3250pa_swio10_lednop_ee_ce_hw
 * m3250pa_swio10_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio10_lednop_ee_ce_hw[] = {
  0x90dddddda2431bc1, 0x62eed55fd4e05c48, 0x4eb4edd1a78bc17e, 0x430a800d8c9c8ccc, 0xb29c1bba70596cf2,
  0x16ef277475d35f7b, 0x7ff5e609f1809043, 0x476ea506007fd0a6, 0xf3cdb4072005c5f5, 0x5f886c2445f71258,
  0xc6e0523e72fd47c2, 0xb29dadcdbdf33c5d, 0xc1b306807a8f2b2e, 0xb422814c5652fd47, 0x6be8c2cb1148b34e,
  0x7c39d5dbbe70ea42, 0xf1b1d79d37609e8d, 0x24228c9118dfb1aa, 0x226470decb65cc5c, 0x556a59dc359ea8d8,
  0x6bb9c673141daf2e, 0xed52df5673a8a954, 0x97f488735c0809ca, 0xaad115e5886956ae, 0xb5f3a03c72b5d73d,
  0xde33a20421520b94, 0xedec55516920a718, 0xe6c25ccbe6d97618, 0x9430a9cfd4176371, 0xfc65f989ffde1ef7,
  0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc, 0xc3a4a5b3e04e32c9, 0xe428a792bf734332, 0x0000000000014056,
};

/*
 * m329_swio10_dual_pr               m329_swio10_dual_pr_u4            m329a_swio10_dual
 * m329a_swio10_dual_pr              m329a_swio10_dual_pr_u4           m329p_swio10_dual
 * m329p_swio10_dual_pr              m329p_swio10_dual_pr_u4           m329pa_swio10_dual
 * m329pa_swio10_dual_pr             m329pa_swio10_dual_pr_u4          m3290_swio10_dual
 * m3290_swio10_dual_pr              m3290_swio10_dual_pr_u4           m3290a_swio10_dual
 * m3290a_swio10_dual_pr             m3290a_swio10_dual_pr_u4          m3290p_swio10_dual
 * m3290p_swio10_dual_pr             m3290p_swio10_dual_pr_u4          m3290pa_swio10_dual
 * m3290pa_swio10_dual_pr            m3290pa_swio10_dual_pr_u4         m325_swio10_dual
 * m325_swio10_dual_pr               m325_swio10_dual_pr_u4            m325a_swio10_dual
 * m325a_swio10_dual_pr              m325a_swio10_dual_pr_u4           m325p_swio10_dual
 * m325p_swio10_dual_pr              m325p_swio10_dual_pr_u4           m325pa_swio10_dual
 * m325pa_swio10_dual_pr             m325pa_swio10_dual_pr_u4          m3250_swio10_dual
 * m3250_swio10_dual_pr              m3250_swio10_dual_pr_u4           m3250a_swio10_dual
 * m3250a_swio10_dual_pr             m3250a_swio10_dual_pr_u4          m3250p_swio10_dual
 * m3250p_swio10_dual_pr             m3250p_swio10_dual_pr_u4          m3250pa_swio10_dual
 * m3250pa_swio10_dual_pr            m3250pa_swio10_dual_pr_u4
 */
static const uint64_t ur_m329_swio10_dual[] = {
  0xa34bbbbbbb4486f9, 0x697e276fc75e738d, 0x9da9f7bb06d60d0b, 0x291fc5f4cfed1d62, 0xe7f0c6a08761b74d,
  0xde4ad0ee9b4721dc, 0x00cc13e30120862d, 0x03775b40c8949483, 0x9f12e20614306d23, 0xa2cce4ff32ba0cee,
  0x537a8efe6c17d9c0, 0xdf04508e489fc199, 0x00dc3e144312bfcf, 0x21955ddeef9b95be, 0x135ad150865a1192,
  0xf212db975ffa039e, 0xa95fee6bcc161bca, 0xf51e443be587c941, 0xbf71951c74fe0c45, 0x8a37bce62c055079,
  0x1ffb30475e00ced3, 0x607967b6b5e0faa0, 0x7f157ceee2a4b7f8, 0x8ce6283b5e5caad6, 0xbeace75152a8d773,
  0x10e6b8101395daa5, 0x2bcb10d2ad5d2fe9, 0x4078e56bae7b55a2, 0x440842a417296be7, 0xaaa2d2414e31bc67,
  0x5ccbe6d976455bd8, 0xbb8d1637c371e6c2, 0x61539fa9d599bf83, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8,
  0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0xa2cf257ee6866587, 0x00000002926b4f9b,
};

/*
 * m329a_swio10_dual_pr_ee           m329p_swio10_dual_pr_ee           m329pa_swio10_dual_pr_ee
 * m3290_swio10_dual_pr_ee           m3290a_swio10_dual_pr_ee          m3290p_swio10_dual_pr_ee
 * m3290pa_swio10_dual_pr_ee         m325_swio10_dual_pr_ee            m325a_swio10_dual_pr_ee
 * m325p_swio10_dual_pr_ee           m325pa_swio10_dual_pr_ee          m3250_swio10_dual_pr_ee
 * m3250a_swio10_dual_pr_ee          m3250p_swio10_dual_pr_ee          m3250pa_swio10_dual_pr_ee
 */
static const uint64_t ur_m329_swio10_dual_pr_ee[] = {
  0xd3b7777775050c86, 0x47c4edf8d4f261b4, 0xf722775261d68166, 0x3d646682ab8858ab, 0x41f1375a266f5da7,
  0x9ceeeec6ecfabf31, 0x27c602410c5bbc9e, 0x6d032252523b8f98, 0x881850c1b48c0ddd, 0x1ffccae833ba7c4b,
  0xe4eb60968e016a63, 0x11c913f838ad37a8, 0xc2886257f9fbe08a, 0x77bbe6e2a4401b87, 0xa8432d05f6886557,
  0x4dbffa039e1307b8, 0xd7982c3795e425b7, 0x6b4651650687ffdc, 0xc1995ea3caf7dcd5, 0xa1df15dbaf51f06c,
  0x30b2c4522cd3ad08, 0xe50d7152e6909afa, 0x4bb47b47a51cead2, 0x234c6c6ab5d0ebd4, 0xb2fa598b84845080,
  0xcad6546c11fadc37, 0xfe2af9ddc5494028, 0x19cc5076bcb955ac, 0x7d59cea2a551aee7, 0x21cd7020272bb54b,
  0x579621a55aba5fd2, 0x80f1cad75cf6ab44, 0x881085482e52d7ce, 0x5545a4829c6378ce, 0xb997cdb2ec8ab7b1,
  0xb8d165abc6e3cd84, 0x1539fa9d599bf83b, 0xcd0f327f8138d286, 0xb25c33d30ae4fc07, 0xccb0e9296cf8138c,
  0x39f37459e4afdcd0, 0x0000000000000564,
};

/*
 * m329a_swio10_dual_pr_ee_u4        m329p_swio10_dual_pr_ee_u4        m329pa_swio10_dual_pr_ee_u4
 * m3290_swio10_dual_pr_ee_u4        m3290a_swio10_dual_pr_ee_u4       m3290p_swio10_dual_pr_ee_u4
 * m3290pa_swio10_dual_pr_ee_u4      m325_swio10_dual_pr_ee_u4         m325a_swio10_dual_pr_ee_u4
 * m325p_swio10_dual_pr_ee_u4        m325pa_swio10_dual_pr_ee_u4       m3250_swio10_dual_pr_ee_u4
 * m3250a_swio10_dual_pr_ee_u4       m3250p_swio10_dual_pr_ee_u4       m3250pa_swio10_dual_pr_ee_u4
 */
static const uint64_t ur_m329_swio10_dual_pr_ee_u4[] = {
  0xb7777768adbbbb90, 0xc4edf8d4f261b4d3, 0x5a7b5261d6816647, 0x6682ab8858abf227, 0x375a266f5da73d64,
  0xa912bcaf7fd6c1f1, 0x120862dde4f4e771, 0x129291dc7cc13e30, 0x860da4606eeb6819, 0xd0729dd3e25c40c2,
  0x25a3805a98c7ff32, 0xfe0e2b4dea393ad8, 0x95fe7ef822847244, 0xb8a91006e1f0a218, 0x417da21955ddeef9,
  0x80e784c1ee2a10cb, 0x0de579096dd36ffe, 0x650687fff1f8660b, 0xa3caf7dcd56b4651, 0xdbaf51f06cc1995e,
  0x522cd3ad08a1df15, 0x52e6909afa30b2c4, 0x47a51cead2e50d71, 0x6ab5d0ebd44bb47b, 0x8b84845080234c6c,
  0x6c11fadc37b2fa59, 0xddc5494028cad654, 0x76bcb955acfe2af9, 0xa2a551aee719cc50, 0x20272bb54b7d59ce,
  0xa55aba5fd221cd70, 0xd75cf6ab44579621, 0x482e52d7ce80f1ca, 0x829c6378ce881085, 0xb2ec8ab7b15545a4,
  0xc9ab83cd84b997cd, 0x37f07edd8d1637c5, 0xbde50c2a73f53ab3, 0xe07f197e627ff787, 0xff03f7ec3343cc9f,
  0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0x5bfe46e9e4afdcd0, 0x000000000000ac96,
};

/*
 * m329a_swio10_dual_pr_ce           m329p_swio10_dual_pr_ce           m329pa_swio10_dual_pr_ce
 * m3290_swio10_dual_pr_ce           m3290a_swio10_dual_pr_ce          m3290p_swio10_dual_pr_ce
 * m3290pa_swio10_dual_pr_ce         m325_swio10_dual_pr_ce            m325a_swio10_dual_pr_ce
 * m325p_swio10_dual_pr_ce           m325pa_swio10_dual_pr_ce          m3250_swio10_dual_pr_ce
 * m3250a_swio10_dual_pr_ce          m3250p_swio10_dual_pr_ce          m3250pa_swio10_dual_pr_ce
 */
static const uint64_t ur_m329_swio10_dual_pr_ce[] = {
  0xdd6eeeee87ad0c86, 0x1f13b7e78f4d7368, 0xdc3edd3ac0291ddc, 0x374bb7ac806e7162, 0xc5d9bae255fba6e8,
  0x4c4bbbbb1bb2fafc, 0x609f180904316ef2, 0x75b40c8949483afa, 0x2e20614306d23037, 0xbabff32ba0cee9f1,
  0xa3eced8472381c19, 0x2847244fe0e574de, 0x1f0a21895fe7ef82, 0x5ddeef9b8d07006e, 0xe2a10cb403da2195,
  0xdec7ffe80e784c13, 0x735e60b0de579096, 0x3717d4c7ca08d6ff, 0xdc4963cf36d01c38, 0xf51f097e21b09117,
  0xb99e2ee372e4492b, 0x1fa8fd44f72c67d4, 0x16a57751c74fe0ee, 0x033b4e28def398b0, 0x83ea807feccf1d78,
  0xa4b7f860796b72d7, 0x5caad67f157ceee2, 0xa8d7738ce6283b5e, 0x95daa5beace75152, 0x5d2fe910e6b81013,
  0x7b55a22bcb10d2ad, 0x296be74078e56bae, 0x31bc67440842a417, 0x31dbd8aaa2d2414e, 0xe3cd84b997cdb2ec,
  0x9bf83bb8d1674f86, 0x27f2861539fa9d59, 0x343cc9fe2e7197e6, 0x3d30ae4fc73dffc1, 0x9296cf8138cb25c3,
  0x459e4afdcd0ccb0e, 0x0000000034910237,
};

/*
 * m329a_swio10_dual_pr_ce_u4        m329p_swio10_dual_pr_ce_u4        m329pa_swio10_dual_pr_ce_u4
 * m3290_swio10_dual_pr_ce_u4        m3290a_swio10_dual_pr_ce_u4       m3290p_swio10_dual_pr_ce_u4
 * m3290pa_swio10_dual_pr_ce_u4      m325_swio10_dual_pr_ce_u4         m325a_swio10_dual_pr_ce_u4
 * m325p_swio10_dual_pr_ce_u4        m325pa_swio10_dual_pr_ce_u4       m3250_swio10_dual_pr_ce_u4
 * m3250a_swio10_dual_pr_ce_u4       m3250p_swio10_dual_pr_ce_u4       m3250pa_swio10_dual_pr_ce_u4
 */
static const uint64_t ur_m329_swio10_dual_pr_ce_u4[] = {
  0x4647777776890c86, 0xa7789dbf3c7d579b, 0x96d77ee80a2951c7, 0xe4ea661b9d6f7ed3, 0x798a1640258b74c8,
  0xf25a2bbbbb1bb2d0, 0xae609f180904316e, 0x3775b40c89494867, 0xf12e20614306d230, 0xdcd15bf32ba0cee9,
  0x6f51f2b6c37d9c34, 0xc114239227f0650e, 0x370f8510c4aff3f7, 0x655777bbe6e52500, 0xa718a8432d009e88,
  0x096dd2d7fd01cf09, 0xaff735e60b0de579, 0xe69bb8bebdd4a0db, 0x88bee24b1e79b680, 0x495fa8f84bf10d84,
  0x3c38ccf1771b9722, 0x0d67fa8f2fa7b963, 0x8b0163de951c74fe, 0xebc8b76c9118df39, 0xa928ea32dc72c678,
  0x972ab59fc55f3bb8, 0xaa35dce3398a0ed7, 0xe576a96fab39d454, 0x574bfa4439ae0404, 0x9ed5688af2c434ab,
  0xca5af9d01e395aeb, 0x8c6f19d10210a905, 0x0c76f62aa8b49053, 0xb8f3612e65f36cbb, 0xccdfc1ddc68b1be1,
  0x1ef79430a9cfd4ea, 0x7f81fc65f989ffde, 0x8bfc0fdfb0cd0f32, 0x32c970cf4c2f8d1e, 0x4332c3a4a5b3e04e,
  0x24814dd16792bf73, 0x000000000000000d,
};

/*
 * m329a_swio10_dual_pr_ee_ce        m329p_swio10_dual_pr_ee_ce        m329pa_swio10_dual_pr_ee_ce
 * m3290_swio10_dual_pr_ee_ce        m3290a_swio10_dual_pr_ee_ce       m3290p_swio10_dual_pr_ee_ce
 * m3290pa_swio10_dual_pr_ee_ce      m325_swio10_dual_pr_ee_ce         m325a_swio10_dual_pr_ee_ce
 * m325p_swio10_dual_pr_ee_ce        m325pa_swio10_dual_pr_ee_ce       m3250_swio10_dual_pr_ee_ce
 * m3250a_swio10_dual_pr_ee_ce       m3250p_swio10_dual_pr_ee_ce       m3250pa_swio10_dual_pr_ee_ce
 */
static const uint64_t ur_m329_swio10_dual_pr_ee_ce[] = {
  0xd4e2ddddddd432db, 0x7ade276fc622d3c6, 0x0efd5f753ecb5586, 0x95f1ba39dee30f90, 0x6d0672b8a9be4b38,
  0xe771c11560f0ccea, 0x3e30120862dde4e4, 0xd0322525213cbcc1, 0x81850c1b48c0ddd6, 0xcfccae833ba7c4b8,
  0xff9b00d070d3533f, 0x1c913f83e9f9bd47, 0x2886257f9fbe08a1, 0xf77cdc575c01b87c, 0x0865a070d10caaee,
  0x7dff4073c2672715, 0xf30586f2bc84b6e8, 0xa8ca5ca0a6dffb9a, 0xfcf36d01c4db3bfe, 0x3309cee371a0e089,
  0x479594394ed65644, 0x60bea3e0d9833d7d, 0xa459a75a1140a62b, 0x1c752135f4616588, 0xdbba460a1ceaedd2,
  0x45b1aaf1b1d7b589, 0x8f8c5c242289b91e, 0x49718c646470decb, 0xb955acfe2af9ddc5, 0x51aee719cc5076bc,
  0x2bb54b7d59cea2a5, 0xba5fd221cd702027, 0xf6ab44579621a55a, 0x52d7ce80f1cad75c, 0x6378ce881085482e,
  0x63b7b15545a4829c, 0xc79b09732f9b65d8, 0xcdfc1ddc68b1e70d, 0x92e19e985727eeac, 0x6587494b67c09c65,
  0x939ba2cf257ee686, 0x000000000001304e,
};

/*
 * m329a_swio10_dual_pr_ee_ce_u4     m329p_swio10_dual_pr_ee_ce_u4     m329pa_swio10_dual_pr_ee_ce_u4
 * m3290_swio10_dual_pr_ee_ce_u4     m3290a_swio10_dual_pr_ee_ce_u4    m3290p_swio10_dual_pr_ee_ce_u4
 * m3290pa_swio10_dual_pr_ee_ce_u4   m325_swio10_dual_pr_ee_ce_u4      m325a_swio10_dual_pr_ee_ce_u4
 * m325p_swio10_dual_pr_ee_ce_u4     m325pa_swio10_dual_pr_ee_ce_u4    m3250_swio10_dual_pr_ee_ce_u4
 * m3250a_swio10_dual_pr_ee_ce_u4    m3250p_swio10_dual_pr_ee_ce_u4    m3250pa_swio10_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio10_dual_pr_ee_ce_u4[] = {
  0xdddddda2b6ee022f, 0x4edf998b90cdacfb, 0xacad0b5ce08673bc, 0x8beaf7f57f71dd9b, 0xe1bb89d9f762f38a,
  0x7cc5b0009645188c, 0x7792d89ddfda3e3d, 0xe0b304f8c048218b, 0x06eeb6819129291a, 0x3e25c40c2860da46,
  0x39b96bf32d0729dd, 0xf51f1bb61d8270bc, 0x22847244fe0daee6, 0xe1f0a21895fe7ef8, 0xabbbddf372231006,
  0xdc54219684724432, 0xdbdc8ffd01cf09b7, 0xe3f0cc161bcaf212, 0x8bea8ce0ca09adff, 0x24b1e79b693b35bb,
  0x8f84bf10d8488bee, 0xf1771b9118a71ffa, 0xaf2b4a76b737374c, 0xf51f06cc1f75ea3c, 0xcd3ad08a05315cae,
  0xa909afa30b2c4522, 0xda3d28e7576e2863, 0xc6abc6c75ea25da3, 0x98b84845080234c6, 0xa3608991c37b2fa5,
  0xceee2a4a59c656b2, 0x83b5e5caad67f157, 0x75152a8d7738ce62, 0x8101395daa5beace, 0x0d2ad5d2fe910e6b,
  0x56bae7b55a22bcb1, 0x2a417296be74078e, 0x2414e31bc6744084, 0xdb2ec31dbd8aaa2d, 0x5c9ab83cd84b997c,
  0x337f07edd8d1637c, 0x7bde50c2a73f53ab, 0xfe07f197e627ff78, 0x2ff03f7ec3343cc9, 0xcb25c33d30be347a,
  0x0ccb0e9296cf8138, 0xacb5e46e9e4afdcd, 0x0000000000001001,
};

/*
 * m329a_swio10_dual_ee_hw           m329p_swio10_dual_ee_hw           m329pa_swio10_dual_ee_hw
 * m3290_swio10_dual_ee_hw           m3290a_swio10_dual_ee_hw          m3290p_swio10_dual_ee_hw
 * m3290pa_swio10_dual_ee_hw         m325_swio10_dual_ee_hw            m325a_swio10_dual_ee_hw
 * m325p_swio10_dual_ee_hw           m325pa_swio10_dual_ee_hw          m3250_swio10_dual_ee_hw
 * m3250a_swio10_dual_ee_hw          m3250p_swio10_dual_ee_hw          m3250pa_swio10_dual_ee_hw
 */
static const uint64_t ur_m329_swio10_dual_ee_hw[] = {
  0x3b7777743d686f97, 0x7c4edf8d4f261b4d, 0x722775261d681664, 0xd646682ab8858abf, 0x1f1375a266f5da73,
  0x7a73b9e08ceb54e8, 0x609f180904316ef2, 0x75b40c894948ee3e, 0x2e20614306d23037, 0x8c7ff32ba0cee9f1,
  0xa393ad825a3805a9, 0x2847244fe0e2b4de, 0x1f0a21895fe7ef82, 0x5ddeef9b8a91006e, 0xe2a10cb417da2195,
  0xdd36ffe80e784c1e, 0xea4660b0de579096, 0xab5a328b28343fff, 0x660ccaf51e57bee6, 0x450ef8aedd7a8f83,
  0xd185962291669d68, 0x97286b8a973484d7, 0xa25da3da3d28e756, 0x011a636355ae875e, 0xbd97d2cc5c242284,
  0x4656b2a3608fd6e1, 0x67f157ceee2a4a01, 0x38ce6283b5e5caad, 0x5beace75152a8d77, 0x910e6b8101395daa,
  0x22bcb10d2ad5d2fe, 0x74078e56bae7b55a, 0x7440842a417296be, 0x8aaa2d2414e31bc6, 0x25ccbe6d976455bd,
  0x54e7ea5eae371e6c, 0xf8b9c65f989fca18, 0x3f1cf7ff04d0f327, 0x04e32c970cf4c2b9, 0xf734332c3a4a5b3e,
  0x000aed1cfa8a792b,
};

/*
 * m329a_swio10_dual_ee_ce_hw        m329p_swio10_dual_ee_ce_hw        m329pa_swio10_dual_ee_ce_hw
 * m3290_swio10_dual_ee_ce_hw        m3290a_swio10_dual_ee_ce_hw       m3290p_swio10_dual_ee_ce_hw
 * m3290pa_swio10_dual_ee_ce_hw      m325_swio10_dual_ee_ce_hw         m325a_swio10_dual_ee_ce_hw
 * m325p_swio10_dual_ee_ce_hw        m325pa_swio10_dual_ee_ce_hw       m3250_swio10_dual_ee_ce_hw
 * m3250a_swio10_dual_ee_ce_hw       m3250p_swio10_dual_ee_ce_hw       m3250pa_swio10_dual_ee_ce_hw
 */
static const uint64_t ur_m329_swio10_dual_ee_ce_hw[] = {
  0x1ceddddddd431f02, 0xc5e276fc6233686d, 0xd5c5eeefdf5d9da6, 0x263d68d43f2d07bb, 0x7e3fa10a9be4a739,
  0xddca31166f4c29f5, 0xf8c048218b7792cc, 0x40c8949483e7d304, 0x0614306d2303775b, 0xff32ba0cee9f12e2,
  0x9ad83fc3862099ae, 0x7244fe0ffe4dea3e, 0xa21895fe7ef82284, 0xddf371dbb006e1f0, 0x219683054432abbb,
  0x0ffd01cf09a43c54, 0xcc161bcaf212dbf6, 0x47812506d6fffd48, 0xe79b680e5ad9dff5, 0x4c273b8dc672e8ff,
  0x1e5795a53b595937, 0x577a8f83660fbaf5, 0x91669d68450298ae, 0x31d484d7d1859622, 0xd1ed1e9473abb714,
  0x636355e363af512e, 0xd2cc5c242284011a, 0x5951b044c8e1bd97, 0xabe77715252ce32b, 0x3141daf2e556b3f8,
  0x673a8a9546bb9c67, 0x35c0809caed52df5, 0x5886956ae97f4887, 0xc72b5d73daad115e, 0x421520b94b5f3a03,
  0x16920a718de33a20, 0xbe6d97618edec555, 0x4fcfec371e6c25cc, 0x8138cb25c33d30ae, 0xfdcd0ccb0e9296cf,
  0x0002269924a29e4a,
};

/*
 * m329a_swio10_dual_ee_ce_u4_hw     m329p_swio10_dual_ee_ce_u4_hw     m329pa_swio10_dual_ee_ce_u4_hw
 * m3290_swio10_dual_ee_ce_u4_hw     m3290a_swio10_dual_ee_ce_u4_hw    m3290p_swio10_dual_ee_ce_u4_hw
 * m3290pa_swio10_dual_ee_ce_u4_hw   m325_swio10_dual_ee_ce_u4_hw      m325a_swio10_dual_ee_ce_u4_hw
 * m325p_swio10_dual_ee_ce_u4_hw     m325pa_swio10_dual_ee_ce_u4_hw    m3250_swio10_dual_ee_ce_u4_hw
 * m3250a_swio10_dual_ee_ce_u4_hw    m3250p_swio10_dual_ee_ce_u4_hw    m3250pa_swio10_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio10_dual_ee_ce_u4_hw[] = {
  0xbdddddda28d1ac4f, 0xc4edf998b90cdacf, 0xeecdd0b5ce08673b, 0x9c545f57bfabfb8d, 0xc4670ddc4ecfbb17,
  0x4eaae3f68354b228, 0x48218b7792d89dd3, 0x29291ae0b304f8c0, 0x60da4606eeb68191, 0x4d69dd3e25c40c28,
  0x8270bc39b96bf32c, 0x0daee6f51f1bb61d, 0xfe7ef822847244fe, 0x231006e1f0a21895, 0x724432abbbddf372,
  0xcf09b7dc54219684, 0xcaf212dbdc8ffd01, 0x135bff67a1cc161b, 0x386b7717d519c194, 0x117dc4963cf2beb0,
  0x1fff51f097e21b09, 0x7374cf1771b8b82e, 0x5ea3caf2b4a76b73, 0x15caef51f06cc1f7, 0xc4522cd3ad08a053,
  0xe2863a909afa30b2, 0x25da3da3d28e7576, 0x234c6c6abc6c75ea, 0xb2fa598b84845080, 0x656b2a3608991c37,
  0x7f157ceee2a4a59c, 0x8ce6283b5e5caad6, 0xbeace75152a8d773, 0x10e6b8101395daa5, 0x2bcb10d2ad5d2fe9,
  0x4078e56bae7b55a2, 0x440842a417296be7, 0xaaa2d2414e31bc67, 0xb997cdb2ec31dbd8, 0x539fa82ec6e3cd84,
  0xf313ffbc3def2861, 0x619a1e64ff03f8cb, 0x985f1a3d17f81fbf, 0x4b67c09c6592e19e, 0x4f257ee686658749,
  0x000001d751a3705f,
};

/*
 * m329_swio12_noled                 m329a_swio11_noled                m329a_swio12_noled
 * m329p_swio11_noled                m329p_swio12_noled                m329pa_swio11_noled
 * m329pa_swio12_noled               m3290_swio11_noled                m3290_swio12_noled
 * m3290a_swio11_noled               m3290a_swio12_noled               m3290p_swio11_noled
 * m3290p_swio12_noled               m3290pa_swio11_noled              m3290pa_swio12_noled
 * m325_swio11_noled                 m325_swio12_noled                 m325a_swio11_noled
 * m325a_swio12_noled                m325p_swio11_noled                m325p_swio12_noled
 * m325pa_swio11_noled               m325pa_swio12_noled               m3250_swio11_noled
 * m3250_swio12_noled                m3250a_swio11_noled               m3250a_swio12_noled
 * m3250p_swio11_noled               m3250p_swio12_noled               m3250pa_swio11_noled
 * m3250pa_swio12_noled
 */
static const uint64_t ur_m329_swio11_noled[] = {
  0x82ffbbbbbacdc49f, 0x6eed55c8a50912d4, 0x80374d06e246113d, 0x5fd0ee38f522f89d, 0x5a099fa5f17bba90,
  0x10c5bbc9ddcc490d, 0x43cfc7b9827c6024, 0x77cb741283dd7fbf, 0x71d3f83affea3a62, 0xe62c05bdd32003e4,
  0x08ebc5cedd223278, 0xe556a56087dc72c6, 0x46bb9c673141daf2, 0xed52df57673a8a95, 0x56c6f5f4887359ca,
  0xb5cf6ab44579621a, 0x75380b2953e9de7e, 0x8f2f14085a585cea, 0x97cdb4e31bc67440, 0x15c9f9fd86ed84b9,
  0x964a271964b867a6, 0x95fb9a19961d252d, 0x000005496ed71f3c,
};

/*
 * m329_swio11_noled_pr_u4           m329_swio12_noled_pr              m329_swio12_noled_pr_u4
 * m329a_swio11_noled_pr             m329a_swio11_noled_pr_u4          m329a_swio12_noled_pr
 * m329a_swio12_noled_pr_u4          m329p_swio11_noled_pr             m329p_swio11_noled_pr_u4
 * m329p_swio12_noled_pr             m329p_swio12_noled_pr_u4          m329pa_swio11_noled_pr
 * m329pa_swio11_noled_pr_u4         m329pa_swio12_noled_pr            m329pa_swio12_noled_pr_u4
 * m3290_swio11_noled_pr             m3290_swio11_noled_pr_u4          m3290_swio12_noled_pr
 * m3290_swio12_noled_pr_u4          m3290a_swio11_noled_pr            m3290a_swio11_noled_pr_u4
 * m3290a_swio12_noled_pr            m3290a_swio12_noled_pr_u4         m3290p_swio11_noled_pr
 * m3290p_swio11_noled_pr_u4         m3290p_swio12_noled_pr            m3290p_swio12_noled_pr_u4
 * m3290pa_swio11_noled_pr           m3290pa_swio11_noled_pr_u4        m3290pa_swio12_noled_pr
 * m3290pa_swio12_noled_pr_u4        m325_swio11_noled_pr              m325_swio11_noled_pr_u4
 * m325_swio12_noled_pr              m325_swio12_noled_pr_u4           m325a_swio11_noled_pr
 * m325a_swio11_noled_pr_u4          m325a_swio12_noled_pr             m325a_swio12_noled_pr_u4
 * m325p_swio11_noled_pr             m325p_swio11_noled_pr_u4          m325p_swio12_noled_pr
 * m325p_swio12_noled_pr_u4          m325pa_swio11_noled_pr            m325pa_swio11_noled_pr_u4
 * m325pa_swio12_noled_pr            m325pa_swio12_noled_pr_u4         m3250_swio11_noled_pr
 * m3250_swio11_noled_pr_u4          m3250_swio12_noled_pr             m3250_swio12_noled_pr_u4
 * m3250a_swio11_noled_pr            m3250a_swio11_noled_pr_u4         m3250a_swio12_noled_pr
 * m3250a_swio12_noled_pr_u4         m3250p_swio11_noled_pr            m3250p_swio11_noled_pr_u4
 * m3250p_swio12_noled_pr            m3250p_swio12_noled_pr_u4         m3250pa_swio11_noled_pr
 * m3250pa_swio11_noled_pr_u4        m3250pa_swio12_noled_pr           m3250pa_swio12_noled_pr_u4
 */
static const uint64_t ur_m329_swio11_noled_pr[] = {
  0xd05bbbbb4488af02, 0xddaab914a8712b89, 0xb27afd8d05b04f05, 0xd60e21b63367bd3d, 0x17e635a6edc4e82c,
  0xf277638c0bc5eccc, 0x3e609f180904316e, 0xdca0edfff3c0b3e6, 0x064d7a8e0a1df2db, 0x6594c1ed008e3a7f,
  0xf3b2628c45398b01, 0x9e5403ff6608ebd1, 0x5aa11303cb3dbb58, 0xee719cc5076bcb95, 0x4b7d5d9cea2a551a,
  0x1bd7d221cd672bb5, 0x3daad115e588695b, 0x6294f0d3bcf8b5d7, 0x9c6378ce88107753, 0x43156f62aa8b4b68,
  0xae0f3612e65f36d8, 0xc81f943458df1726, 0xbca1854e7ea75663, 0x0fe32fcc4ffef0f7, 0xe07efd86687993fc,
  0x4b867a617c68f45f, 0x961d252d9f027196, 0x82c4053c95fb9a19, 0x000000000007c9ab,
};

/*
 * m329_swio12_noled_pr_ee           m329a_swio11_noled_pr_ee          m329a_swio12_noled_pr_ee
 * m329p_swio11_noled_pr_ee          m329p_swio12_noled_pr_ee          m329pa_swio11_noled_pr_ee
 * m329pa_swio12_noled_pr_ee         m3290_swio11_noled_pr_ee          m3290_swio12_noled_pr_ee
 * m3290a_swio11_noled_pr_ee         m3290a_swio12_noled_pr_ee         m3290p_swio11_noled_pr_ee
 * m3290p_swio12_noled_pr_ee         m3290pa_swio11_noled_pr_ee        m3290pa_swio12_noled_pr_ee
 * m325_swio11_noled_pr_ee           m325_swio12_noled_pr_ee           m325a_swio11_noled_pr_ee
 * m325a_swio12_noled_pr_ee          m325p_swio11_noled_pr_ee          m325p_swio12_noled_pr_ee
 * m325pa_swio11_noled_pr_ee         m325pa_swio12_noled_pr_ee         m3250_swio11_noled_pr_ee
 * m3250_swio12_noled_pr_ee          m3250a_swio11_noled_pr_ee         m3250a_swio12_noled_pr_ee
 * m3250p_swio11_noled_pr_ee         m3250p_swio12_noled_pr_ee         m3250pa_swio11_noled_pr_ee
 * m3250pa_swio12_noled_pr_ee
 */
static const uint64_t ur_m329_swio11_noled_pr_ee[] = {
  0xb4ddddd0f5a22582, 0xbb557e1708225c7e, 0x699ed43267cdcc9b, 0x0da1942e19e14627, 0xd9136041b4171fad,
  0x774ed0434665a88f, 0x609f180904316ef2, 0xa0eceff3c0b3e706, 0x7959759aad68cc7c, 0x97ea3e0d983ea3d4,
  0x459a75a1143be2b2, 0x64d2135f4616588a, 0x3f90e75697726b8d, 0xaad743af3a6ec7aa, 0x2e121144428f7bb1,
  0xd823f5b86f65b2e6, 0xcb955a805d073ca8, 0x551aee719cc5076b, 0x2bb54b7d5d9cea2a, 0x695b1bd7d221cd67,
  0xb5d73daad115e588, 0x77536294f0d3bcf8, 0x4b689c6378ce8810, 0x36d843156f62aa8b, 0x1726ae0f3612e65f,
  0xb31e40fca1a2ce9f, 0xcc4fe50c2a73f53a, 0x82687993fc5ce32f, 0x867a615c9f8e7bff, 0x1d252d9f0271964b,
  0x44053c95fb9a1996, 0x0000000000275e05,
};

/*
 * m329_swio12_noled_pr_ee_u4        m329a_swio11_noled_pr_ee_u4       m329a_swio12_noled_pr_ee_u4
 * m329p_swio11_noled_pr_ee_u4       m329p_swio12_noled_pr_ee_u4       m329pa_swio11_noled_pr_ee_u4
 * m329pa_swio12_noled_pr_ee_u4      m3290_swio11_noled_pr_ee_u4       m3290_swio12_noled_pr_ee_u4
 * m3290a_swio11_noled_pr_ee_u4      m3290a_swio12_noled_pr_ee_u4      m3290p_swio11_noled_pr_ee_u4
 * m3290p_swio12_noled_pr_ee_u4      m3290pa_swio11_noled_pr_ee_u4     m3290pa_swio12_noled_pr_ee_u4
 * m325_swio11_noled_pr_ee_u4        m325_swio12_noled_pr_ee_u4        m325a_swio11_noled_pr_ee_u4
 * m325a_swio12_noled_pr_ee_u4       m325p_swio11_noled_pr_ee_u4       m325p_swio12_noled_pr_ee_u4
 * m325pa_swio11_noled_pr_ee_u4      m325pa_swio12_noled_pr_ee_u4      m3250_swio11_noled_pr_ee_u4
 * m3250_swio12_noled_pr_ee_u4       m3250a_swio11_noled_pr_ee_u4      m3250a_swio12_noled_pr_ee_u4
 * m3250p_swio11_noled_pr_ee_u4      m3250p_swio12_noled_pr_ee_u4      m3250pa_swio11_noled_pr_ee_u4
 * m3250pa_swio12_noled_pr_ee_u4
 */
static const uint64_t ur_m329_swio11_noled_pr_ee_u4[] = {
  0x6f26eeeed1222a20, 0x3bb557e171a7122f, 0xfa69776dbaff126d, 0x14ce3e7ec19e3b23, 0x3d724041b4117b79,
  0x3ba3d8b54718d410, 0x304f8c048218b779, 0x506577f9e059fd9d, 0x3cafe74d56b47b7e, 0xa5f51f06cc1ce3ea,
  0x22cd3ad08a1df15b, 0x266909afa30b2c45, 0x6b5ce756975f6b8a, 0x5ae875eba9bb4be4, 0xc242281f11f49635,
  0xa0fadc37b2e1c8c5, 0xcc5076bcb955aae3, 0xd9cea2a551aee719, 0x221cd672bb54b7d5, 0x115e588695b1bd7d,
  0x0d3bcf8b5d73daad, 0x8ce881077536294f, 0xf62aa8b4b689c637, 0x612e65f36d843156, 0x43458df1726ae0f3,
  0x54e7ea75663c81f9, 0xfcc4ffef0f7bca18, 0xd86687993fc0fe32, 0xa617c68f45fe07ef, 0x52d9f0271964b867,
  0x53c95fb9a19961d2, 0x00000009d74d0440,
};

/*
 * m329_swio11_noled_pr_ce_u4        m329_swio12_noled_pr_ce           m329_swio12_noled_pr_ce_u4
 * m329a_swio11_noled_pr_ce          m329a_swio11_noled_pr_ce_u4       m329a_swio12_noled_pr_ce
 * m329a_swio12_noled_pr_ce_u4       m329p_swio11_noled_pr_ce          m329p_swio11_noled_pr_ce_u4
 * m329p_swio12_noled_pr_ce          m329p_swio12_noled_pr_ce_u4       m329pa_swio11_noled_pr_ce
 * m329pa_swio11_noled_pr_ce_u4      m329pa_swio12_noled_pr_ce         m329pa_swio12_noled_pr_ce_u4
 * m3290_swio11_noled_pr_ce          m3290_swio11_noled_pr_ce_u4       m3290_swio12_noled_pr_ce
 * m3290_swio12_noled_pr_ce_u4       m3290a_swio11_noled_pr_ce         m3290a_swio11_noled_pr_ce_u4
 * m3290a_swio12_noled_pr_ce         m3290a_swio12_noled_pr_ce_u4      m3290p_swio11_noled_pr_ce
 * m3290p_swio11_noled_pr_ce_u4      m3290p_swio12_noled_pr_ce         m3290p_swio12_noled_pr_ce_u4
 * m3290pa_swio11_noled_pr_ce        m3290pa_swio11_noled_pr_ce_u4     m3290pa_swio12_noled_pr_ce
 * m3290pa_swio12_noled_pr_ce_u4     m325_swio11_noled_pr_ce           m325_swio11_noled_pr_ce_u4
 * m325_swio12_noled_pr_ce           m325_swio12_noled_pr_ce_u4        m325a_swio11_noled_pr_ce
 * m325a_swio11_noled_pr_ce_u4       m325a_swio12_noled_pr_ce          m325a_swio12_noled_pr_ce_u4
 * m325p_swio11_noled_pr_ce          m325p_swio11_noled_pr_ce_u4       m325p_swio12_noled_pr_ce
 * m325p_swio12_noled_pr_ce_u4       m325pa_swio11_noled_pr_ce         m325pa_swio11_noled_pr_ce_u4
 * m325pa_swio12_noled_pr_ce         m325pa_swio12_noled_pr_ce_u4      m3250_swio11_noled_pr_ce
 * m3250_swio11_noled_pr_ce_u4       m3250_swio12_noled_pr_ce          m3250_swio12_noled_pr_ce_u4
 * m3250a_swio11_noled_pr_ce         m3250a_swio11_noled_pr_ce_u4      m3250a_swio12_noled_pr_ce
 * m3250a_swio12_noled_pr_ce_u4      m3250p_swio11_noled_pr_ce         m3250p_swio11_noled_pr_ce_u4
 * m3250p_swio12_noled_pr_ce         m3250p_swio12_noled_pr_ce_u4      m3250pa_swio11_noled_pr_ce
 * m3250pa_swio11_noled_pr_ce_u4     m3250pa_swio12_noled_pr_ce        m3250pa_swio12_noled_pr_ce_u4
 */
static const uint64_t ur_m329_swio11_noled_pr_ce[] = {
  0x367eeeeed1222582, 0x3bb55784469712a1, 0xba47f499f1f60f7e, 0xfaf1ae6ecadb5368, 0xaa0b42f0adda1367,
  0xbbc9dd3b410e5d96, 0xe9b9827c602410c5, 0xf7528395bfcf02cf, 0x79e012a772bae2fa, 0x2fc4361222fb892c,
  0xdc6e321d257ea3e1, 0x5f27b9633f5933c5, 0xbe8e3a7f06b3fd47, 0x628c45398b0176fc, 0x03ff6678ebd1f3b2,
  0x44c0f2d6eb589e54, 0x673141daf2e556a8, 0x57673a8a9546bb9c, 0xf4887359caed52df, 0xb44579621a56c6f5,
  0x3c34ef3e2d75cf6a, 0xde33a2041dd4d8a5, 0xdbd8aaa2d2da2718, 0x9b09732f9b6c2131, 0xca1a2c6f8b935707,
  0xc2a73f53ab31e40f, 0x97e627ff787bde50, 0x7ec3343cc9fe07f1, 0x3d30be347a2ff03f, 0x9296cf8138cb25c3,
  0x029e4afdcd0ccb0e, 0x00000000dd748be2,
};

/*
 * m329_swio12_noled_pr_ee_ce        m329a_swio11_noled_pr_ee_ce       m329a_swio12_noled_pr_ee_ce
 * m329p_swio11_noled_pr_ee_ce       m329p_swio12_noled_pr_ee_ce       m329pa_swio11_noled_pr_ee_ce
 * m329pa_swio12_noled_pr_ee_ce      m3290_swio11_noled_pr_ee_ce       m3290_swio12_noled_pr_ee_ce
 * m3290a_swio11_noled_pr_ee_ce      m3290a_swio12_noled_pr_ee_ce      m3290p_swio11_noled_pr_ee_ce
 * m3290p_swio12_noled_pr_ee_ce      m3290pa_swio11_noled_pr_ee_ce     m3290pa_swio12_noled_pr_ee_ce
 * m325_swio11_noled_pr_ee_ce        m325_swio12_noled_pr_ee_ce        m325a_swio11_noled_pr_ee_ce
 * m325a_swio12_noled_pr_ee_ce       m325p_swio11_noled_pr_ee_ce       m325p_swio12_noled_pr_ee_ce
 * m325pa_swio11_noled_pr_ee_ce      m325pa_swio12_noled_pr_ee_ce      m3250_swio11_noled_pr_ee_ce
 * m3250_swio12_noled_pr_ee_ce       m3250a_swio11_noled_pr_ee_ce      m3250a_swio12_noled_pr_ee_ce
 * m3250p_swio11_noled_pr_ee_ce      m3250p_swio12_noled_pr_ee_ce      m3250pa_swio11_noled_pr_ee_ce
 * m3250pa_swio12_noled_pr_ee_ce
 */
static const uint64_t ur_m329_swio11_noled_pr_ee_ce[] = {
  0x7f8fdddddd446f43, 0x5ddaabd853a744a1, 0x3bd89dab43d318c4, 0x1f5a63bf23f4c69a, 0xdc71a8b065ab42ff,
  0x2775a77da765b2a0, 0xe609f180904316ef, 0x282337fe78167d36, 0x54ec66ceffaa32eb, 0xdc6e339747ff3c02,
  0x0f29dacac7be6139, 0x7c1b307a57a8f2b9, 0xeb422814c5670fd4, 0x26be8c2cb1148b34, 0xfe439d5db9c98ea4,
  0x578d8ebce9bb1ea8, 0x70908a22147bdd8d, 0x608991c37b2d9731, 0x2e556a59f41cf2a3, 0x546bb9c673141daf,
  0xaed52df57673a8a9, 0xa56c6f5f4887359c, 0xd75cf6ab44579621, 0xdd4d8a53c34ef3e2, 0x2da2718de33a2041,
  0xb6c2131dbd8aaa2d, 0x38b93571b09732f9, 0x75663c81f943458f, 0xe32c970cf4c2b93f, 0x4332c3a4a5b2c944,
  0x4c5fb880a792bf73, 0x0000000000000053,
};

/*
 * m329_swio12_noled_pr_ee_ce_u4     m329a_swio11_noled_pr_ee_ce_u4    m329a_swio12_noled_pr_ee_ce_u4
 * m329p_swio11_noled_pr_ee_ce_u4    m329p_swio12_noled_pr_ee_ce_u4    m329pa_swio11_noled_pr_ee_ce_u4
 * m329pa_swio12_noled_pr_ee_ce_u4   m3290_swio11_noled_pr_ee_ce_u4    m3290_swio12_noled_pr_ee_ce_u4
 * m3290a_swio11_noled_pr_ee_ce_u4   m3290a_swio12_noled_pr_ee_ce_u4   m3290p_swio11_noled_pr_ee_ce_u4
 * m3290p_swio12_noled_pr_ee_ce_u4   m3290pa_swio11_noled_pr_ee_ce_u4  m3290pa_swio12_noled_pr_ee_ce_u4
 * m325_swio11_noled_pr_ee_ce_u4     m325_swio12_noled_pr_ee_ce_u4     m325a_swio11_noled_pr_ee_ce_u4
 * m325a_swio12_noled_pr_ee_ce_u4    m325p_swio11_noled_pr_ee_ce_u4    m325p_swio12_noled_pr_ee_ce_u4
 * m325pa_swio11_noled_pr_ee_ce_u4   m325pa_swio12_noled_pr_ee_ce_u4   m3250_swio11_noled_pr_ee_ce_u4
 * m3250_swio12_noled_pr_ee_ce_u4    m3250a_swio11_noled_pr_ee_ce_u4   m3250a_swio12_noled_pr_ee_ce_u4
 * m3250p_swio11_noled_pr_ee_ce_u4   m3250p_swio12_noled_pr_ee_ce_u4   m3250pa_swio11_noled_pr_ee_ce_u4
 * m3250pa_swio12_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio11_noled_pr_ee_ce_u4[] = {
  0x30addddda243306a, 0xbbb557f53323125a, 0xaecb75a583305f98, 0x8540056d1dc1b5c7, 0x6e817c942cb67ad1,
  0x93bb55f930eb2108, 0x9304f8c048218b77, 0x941adfffb15d9f14, 0xa0395bf717d51e9b, 0x61222fb892c79e6d,
  0xbb0b27ea3e12fc43, 0x6e6def99e2ee371d, 0x3d2bd4795c8794ed, 0x0a62b387ea3e0d98, 0x16588a459a75a114,
  0xaedce4c752135f46, 0x5e74dd8f547f21ce, 0x110a3deec6abc6c7, 0xe1bd96cb98b84845, 0x2cfa0e7951b044c8,
  0xe3398a0ed7972ab5, 0xfabb39d454aa35dc, 0xafa4439ace576a96, 0x55a22bcb10d2b637, 0x29e1a779f16bae7b,
  0xc6f19d1020eea6c5, 0x8edec5551696d138, 0x3cd84b997cdb6109, 0x37f07771a2c6f86e, 0xbde50c2a73f53ab3,
  0xe07f197e627ff787, 0xff03f7ec3343cc9f, 0xb25c33d30be347a2, 0xccb0e9296cf8138c, 0x7abb7459e4afdcd0,
  0x00000000000013f0,
};

/*
 * m329_swio12_noled_ee_hw           m329a_swio11_noled_ee_hw          m329a_swio12_noled_ee_hw
 * m329p_swio11_noled_ee_hw          m329p_swio12_noled_ee_hw          m329pa_swio11_noled_ee_hw
 * m329pa_swio12_noled_ee_hw         m3290_swio11_noled_ee_hw          m3290_swio12_noled_ee_hw
 * m3290a_swio11_noled_ee_hw         m3290a_swio12_noled_ee_hw         m3290p_swio11_noled_ee_hw
 * m3290p_swio12_noled_ee_hw         m3290pa_swio11_noled_ee_hw        m3290pa_swio12_noled_ee_hw
 * m325_swio11_noled_ee_hw           m325_swio12_noled_ee_hw           m325a_swio11_noled_ee_hw
 * m325a_swio12_noled_ee_hw          m325p_swio11_noled_ee_hw          m325p_swio12_noled_ee_hw
 * m325pa_swio11_noled_ee_hw         m325pa_swio12_noled_ee_hw         m3250_swio11_noled_ee_hw
 * m3250_swio12_noled_ee_hw          m3250a_swio11_noled_ee_hw         m3250a_swio12_noled_ee_hw
 * m3250p_swio11_noled_ee_hw         m3250p_swio12_noled_ee_hw         m3250pa_swio11_noled_ee_hw
 * m3250pa_swio12_noled_ee_hw
 */
static const uint64_t ur_m329_swio11_noled_ee_hw[] = {
  0xf5a6eeeed121b705, 0xdddaabf0b84112e3, 0xa62776a1933e6e64, 0xfad0da1942e19e15, 0x08fd9136041b4171,
  0x2dde4eed86d95a93, 0x7ce0cc13e3012086, 0x4663e507677fd0a6, 0xf51ea3cacbacd56b, 0xdf1594bf51f06cc1,
  0xb2c4522cd3ad08a1, 0x935c6b26909afa30, 0x763d51fc873ab4bb, 0x7bdd8d56ba1d79d3, 0x2d973170908a2214,
  0x39e546c11fadc37b, 0x283b5e5caad402e8, 0xe75152a8d7738ce6, 0x0e6b395daa5beaec, 0xaf2c434ad8debe91,
  0x9de7c5aeb9ed5688, 0x744083ba9b14a786, 0x15545a5b44e31bc6, 0x9732f9b6c218ab7b, 0x2a73f505d8dc79b0,
  0x7e627ff787bde50c, 0xec3343cc9fe07f19, 0xd30be347a2ff03f7, 0x296cf8138cb25c33, 0x29e4afdcd0ccb0e9,
  0x000000002dffcd3a,
};

/*
 * m329_swio11_noled_ee_ce_u4_hw     m329_swio12_noled_ee_ce_hw        m329_swio12_noled_ee_ce_u4_hw
 * m329a_swio11_noled_ee_ce_hw       m329a_swio11_noled_ee_ce_u4_hw    m329a_swio12_noled_ee_ce_hw
 * m329a_swio12_noled_ee_ce_u4_hw    m329p_swio11_noled_ee_ce_hw       m329p_swio11_noled_ee_ce_u4_hw
 * m329p_swio12_noled_ee_ce_hw       m329p_swio12_noled_ee_ce_u4_hw    m329pa_swio11_noled_ee_ce_hw
 * m329pa_swio11_noled_ee_ce_u4_hw   m329pa_swio12_noled_ee_ce_hw      m329pa_swio12_noled_ee_ce_u4_hw
 * m3290_swio11_noled_ee_ce_hw       m3290_swio11_noled_ee_ce_u4_hw    m3290_swio12_noled_ee_ce_hw
 * m3290_swio12_noled_ee_ce_u4_hw    m3290a_swio11_noled_ee_ce_hw      m3290a_swio11_noled_ee_ce_u4_hw
 * m3290a_swio12_noled_ee_ce_hw      m3290a_swio12_noled_ee_ce_u4_hw   m3290p_swio11_noled_ee_ce_hw
 * m3290p_swio11_noled_ee_ce_u4_hw   m3290p_swio12_noled_ee_ce_hw      m3290p_swio12_noled_ee_ce_u4_hw
 * m3290pa_swio11_noled_ee_ce_hw     m3290pa_swio11_noled_ee_ce_u4_hw  m3290pa_swio12_noled_ee_ce_hw
 * m3290pa_swio12_noled_ee_ce_u4_hw  m325_swio11_noled_ee_ce_hw        m325_swio11_noled_ee_ce_u4_hw
 * m325_swio12_noled_ee_ce_hw        m325_swio12_noled_ee_ce_u4_hw     m325a_swio11_noled_ee_ce_hw
 * m325a_swio11_noled_ee_ce_u4_hw    m325a_swio12_noled_ee_ce_hw       m325a_swio12_noled_ee_ce_u4_hw
 * m325p_swio11_noled_ee_ce_hw       m325p_swio11_noled_ee_ce_u4_hw    m325p_swio12_noled_ee_ce_hw
 * m325p_swio12_noled_ee_ce_u4_hw    m325pa_swio11_noled_ee_ce_hw      m325pa_swio11_noled_ee_ce_u4_hw
 * m325pa_swio12_noled_ee_ce_hw      m325pa_swio12_noled_ee_ce_u4_hw   m3250_swio11_noled_ee_ce_hw
 * m3250_swio11_noled_ee_ce_u4_hw    m3250_swio12_noled_ee_ce_hw       m3250_swio12_noled_ee_ce_u4_hw
 * m3250a_swio11_noled_ee_ce_hw      m3250a_swio11_noled_ee_ce_u4_hw   m3250a_swio12_noled_ee_ce_hw
 * m3250a_swio12_noled_ee_ce_u4_hw   m3250p_swio11_noled_ee_ce_hw      m3250p_swio11_noled_ee_ce_u4_hw
 * m3250p_swio12_noled_ee_ce_hw      m3250p_swio12_noled_ee_ce_u4_hw   m3250pa_swio11_noled_ee_ce_hw
 * m3250pa_swio11_noled_ee_ce_u4_hw  m3250pa_swio12_noled_ee_ce_hw     m3250pa_swio12_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio11_noled_ee_ce_hw[] = {
  0x1856eeeed1219f68, 0x5ddaabfa9991892d, 0xd765bad2c1982fcc, 0xc2a002b68ee0dae3, 0x3740be4a165b3d68,
  0xdde4ee957a27e858, 0xc524c13e30120862, 0xf4dca0d6fffd0a67, 0xf36d01cadfb8bea8, 0xe21b09117dc4963c,
  0x70dbb0a47f51f097, 0x4ed6e6def99e2ee3, 0xd983d2bd4795c879, 0x1140a62b387ea3e0, 0xf4616588a459a75a,
  0x1ceaedce4c752135, 0x6c75e74dd8f547f2, 0x845110a3deec6abc, 0x4c8e1bd96cb98b84, 0xab52cfa0e7951b04,
  0x5dce3398a0ed7972, 0xa96fabb39d454aa3, 0x637afa4439ace576, 0xe7b55a22bcb10d2b, 0x6c529e1a779f16ba,
  0x138c6f19d1020eea, 0x1098edec5551696d, 0xc6e3cd84b997cdb6, 0x3def2861539fa82e, 0xff03f8cbf313ffbc,
  0x17f81fbf619a1e64, 0x6592e19e985f1a3d, 0x866587494b67c09c, 0x8087abd14f257ee6, 0x0000000000000002,
};

/*
 * m329_swio12_lednop                m329a_swio11_lednop               m329a_swio12_lednop
 * m329p_swio11_lednop               m329p_swio12_lednop               m329pa_swio11_lednop
 * m329pa_swio12_lednop              m3290_swio11_lednop               m3290_swio12_lednop
 * m3290a_swio11_lednop              m3290a_swio12_lednop              m3290p_swio11_lednop
 * m3290p_swio12_lednop              m3290pa_swio11_lednop             m3290pa_swio12_lednop
 * m325_swio11_lednop                m325_swio12_lednop                m325a_swio11_lednop
 * m325a_swio12_lednop               m325p_swio11_lednop               m325p_swio12_lednop
 * m325pa_swio11_lednop              m325pa_swio12_lednop              m3250_swio11_lednop
 * m3250_swio12_lednop               m3250a_swio11_lednop              m3250a_swio12_lednop
 * m3250p_swio11_lednop              m3250p_swio12_lednop              m3250pa_swio11_lednop
 * m3250pa_swio12_lednop
 */
static const uint64_t ur_m329_swio11_lednop[] = {
  0x905ff7777759bb37, 0xadddaab914ad225a, 0xbe3f770f8da0c227, 0x05fd0ee38f684ddf, 0x69b1006dbe3fbba9,
  0x410c5bbc9ddb1ec8, 0xf43cfc069827c602, 0x0ef96e825043dffb, 0x8e3a7f075ffd47c9, 0x1cc580b7ba6ea131,
  0xc11d78b9d84547d2, 0x5caad4acc17b8e58, 0xa8d7738ce6283b5e, 0x5daa5beaece75152, 0xd2fe910e6b810139,
  0xdaad115e588695cb, 0xb29b1674079fad73, 0x8a042d3573abd4b0, 0x6d38c6f19d1028be, 0x7e7f61bb612e65f3,
  0x89c6592e19e98572, 0xe6866587494b6592, 0x02a4faf5c7cf257e,
};

/*
 * m329_swio11_lednop_pr_u4          m329_swio12_lednop_pr             m329_swio12_lednop_pr_u4
 * m329a_swio11_lednop_pr            m329a_swio11_lednop_pr_u4         m329a_swio12_lednop_pr
 * m329a_swio12_lednop_pr_u4         m329p_swio11_lednop_pr            m329p_swio11_lednop_pr_u4
 * m329p_swio12_lednop_pr            m329p_swio12_lednop_pr_u4         m329pa_swio11_lednop_pr
 * m329pa_swio11_lednop_pr_u4        m329pa_swio12_lednop_pr           m329pa_swio12_lednop_pr_u4
 * m3290_swio11_lednop_pr            m3290_swio11_lednop_pr_u4         m3290_swio12_lednop_pr
 * m3290_swio12_lednop_pr_u4         m3290a_swio11_lednop_pr           m3290a_swio11_lednop_pr_u4
 * m3290a_swio12_lednop_pr           m3290a_swio12_lednop_pr_u4        m3290p_swio11_lednop_pr
 * m3290p_swio11_lednop_pr_u4        m3290p_swio12_lednop_pr           m3290p_swio12_lednop_pr_u4
 * m3290pa_swio11_lednop_pr          m3290pa_swio11_lednop_pr_u4       m3290pa_swio12_lednop_pr
 * m3290pa_swio12_lednop_pr_u4       m325_swio11_lednop_pr             m325_swio11_lednop_pr_u4
 * m325_swio12_lednop_pr             m325_swio12_lednop_pr_u4          m325a_swio11_lednop_pr
 * m325a_swio11_lednop_pr_u4         m325a_swio12_lednop_pr            m325a_swio12_lednop_pr_u4
 * m325p_swio11_lednop_pr            m325p_swio11_lednop_pr_u4         m325p_swio12_lednop_pr
 * m325p_swio12_lednop_pr_u4         m325pa_swio11_lednop_pr           m325pa_swio11_lednop_pr_u4
 * m325pa_swio12_lednop_pr           m325pa_swio12_lednop_pr_u4        m3250_swio11_lednop_pr
 * m3250_swio11_lednop_pr_u4         m3250_swio12_lednop_pr            m3250_swio12_lednop_pr_u4
 * m3250a_swio11_lednop_pr           m3250a_swio11_lednop_pr_u4        m3250a_swio12_lednop_pr
 * m3250a_swio12_lednop_pr_u4        m3250p_swio11_lednop_pr           m3250p_swio11_lednop_pr_u4
 * m3250p_swio12_lednop_pr           m3250p_swio12_lednop_pr_u4        m3250pa_swio11_lednop_pr
 * m3250pa_swio11_lednop_pr_u4       m3250pa_swio12_lednop_pr          m3250pa_swio12_lednop_pr_u4
 */
static const uint64_t ur_m329_swio11_lednop_pr[] = {
  0xa0b777768911fc3b, 0xbb5572290be25713, 0x490dbf30fb609e0b, 0xac1c550c6d97bc2b, 0xeec7bafddb89d059,
  0x93bb704dd43329d8, 0x7304f8c048218b77, 0xe5063dff9e059f5f, 0x326bd47400ef96de, 0x96533f9d4471d3f8,
  0x9db244637ce62c05, 0x22a01ffb30475e8f, 0xacbb503cb3db83fd, 0xe719cc5076bcb955, 0xb7d5d9cea2a551ae,
  0x221cd7020272bb54, 0x22bcb10d2b97a5fd, 0x74078e56bae7b55a, 0x7440842a417296be, 0x8aaa2d2414e31bc6,
  0x25ccbe6db18c55bd, 0x68b1be2e4d5c1e6c, 0x9cfd4eacc7903f28, 0x989ffde1ef79430a, 0x0cd0f327f81fc65f,
  0xc2f8d1e8bfc0fdfb, 0x5b3e04e32c970cf4, 0x792bf734332c3a4a, 0x00001f26721f880a,
};

/*
 * m329_swio12_lednop_pr_ee          m329a_swio11_lednop_pr_ee         m329a_swio12_lednop_pr_ee
 * m329p_swio11_lednop_pr_ee         m329p_swio12_lednop_pr_ee         m329pa_swio11_lednop_pr_ee
 * m329pa_swio12_lednop_pr_ee        m3290_swio11_lednop_pr_ee         m3290_swio12_lednop_pr_ee
 * m3290a_swio11_lednop_pr_ee        m3290a_swio12_lednop_pr_ee        m3290p_swio11_lednop_pr_ee
 * m3290p_swio12_lednop_pr_ee        m3290pa_swio11_lednop_pr_ee       m3290pa_swio12_lednop_pr_ee
 * m325_swio11_lednop_pr_ee          m325_swio12_lednop_pr_ee          m325a_swio11_lednop_pr_ee
 * m325a_swio12_lednop_pr_ee         m325p_swio11_lednop_pr_ee         m325p_swio12_lednop_pr_ee
 * m325pa_swio11_lednop_pr_ee        m325pa_swio12_lednop_pr_ee        m3250_swio11_lednop_pr_ee
 * m3250_swio12_lednop_pr_ee         m3250a_swio11_lednop_pr_ee        m3250a_swio12_lednop_pr_ee
 * m3250p_swio11_lednop_pr_ee        m3250p_swio12_lednop_pr_ee        m3250pa_swio11_lednop_pr_ee
 * m3250pa_swio12_lednop_pr_ee
 */
static const uint64_t ur_m329_swio11_lednop_pr_ee[] = {
  0xd69bbbba1eb44511, 0xeed55f85da2c4b8f, 0xeac1dcc46df37326, 0xd0da181050b41392, 0x334b8bc41b4171fa,
  0x4eeabe67d938b17d, 0x4c13e30120862dde, 0x9411adfe78167d2d, 0x8f2b60b355ad198f, 0xa7bd47c1b307d47a,
  0x48b34eb422877c56, 0xac9a426be8c2cb11, 0x47371cead2ee9571, 0x355ae875e74dda44, 0xc5c242285f11c656,
  0x1b047eb70decb65c, 0x7972ab500ad62795, 0x4aa35dce3398a0ed, 0xe576a96fabb39d45, 0x2f4bfa4439ae0404,
  0xcf6ab44579621a57, 0xe52d7ce80f1cad75, 0xc6378ce881085482, 0x18ab7b15545a4829, 0xb83cd84b997cdb63,
  0x03f2868b3a7c5c9a, 0x9430a9cfd4eacc79, 0xe64ff1738cbf313f, 0x85727e39effe09a1, 0xb67c09c6592e19e9,
  0xf257ee6866587494, 0x000000275cc91014,
};

/*
 * m329_swio12_lednop_pr_ee_u4       m329a_swio11_lednop_pr_ee_u4      m329a_swio12_lednop_pr_ee_u4
 * m329p_swio11_lednop_pr_ee_u4      m329p_swio12_lednop_pr_ee_u4      m329pa_swio11_lednop_pr_ee_u4
 * m329pa_swio12_lednop_pr_ee_u4     m3290_swio11_lednop_pr_ee_u4      m3290_swio12_lednop_pr_ee_u4
 * m3290a_swio11_lednop_pr_ee_u4     m3290a_swio12_lednop_pr_ee_u4     m3290p_swio11_lednop_pr_ee_u4
 * m3290p_swio12_lednop_pr_ee_u4     m3290pa_swio11_lednop_pr_ee_u4    m3290pa_swio12_lednop_pr_ee_u4
 * m325_swio11_lednop_pr_ee_u4       m325_swio12_lednop_pr_ee_u4       m325a_swio11_lednop_pr_ee_u4
 * m325a_swio12_lednop_pr_ee_u4      m325p_swio11_lednop_pr_ee_u4      m325p_swio12_lednop_pr_ee_u4
 * m325pa_swio11_lednop_pr_ee_u4     m325pa_swio12_lednop_pr_ee_u4     m3250_swio11_lednop_pr_ee_u4
 * m3250_swio12_lednop_pr_ee_u4      m3250a_swio11_lednop_pr_ee_u4     m3250a_swio12_lednop_pr_ee_u4
 * m3250p_swio11_lednop_pr_ee_u4     m3250p_swio12_lednop_pr_ee_u4     m3250pa_swio11_lednop_pr_ee_u4
 * m3250pa_swio12_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_swio11_lednop_pr_ee_u4[] = {
  0x6f26eeeed1222582, 0x3bb557e172b7122f, 0x5d23fb007a5f126d, 0xbc8a671fd412c9b4, 0x82d0bc5e20da08bd,
  0xf2774ed0439765aa, 0x6a609f180904316e, 0xfca08d6ff3c0b3e9, 0xd4795c879aad68f6, 0xbfddea3e0d9839c7,
  0x8a459a75a1143be2, 0x144cd2135f461658, 0x446989cead2f0197, 0x1aad743af5d4ddb2, 0xc5c2422883e8ed6b,
  0xc60bfadc37b2e1c8, 0x3398a0ed7972ab55, 0xabb39d454aa35dce, 0x39ae0404e576a96f, 0x79621a572f4bfa44,
  0xd01e7eb5cf6ab445, 0xd5ceaf52c2ca6c59, 0xc67440a2fa2810b4, 0xcd84b997cdb4e31b, 0xe50d1637c5c9ab83,
  0x61539fa9d598f207, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1,
  0x014f257ee6866587, 0x000000004eba45f1,
};

/*
 * m329_swio11_lednop_pr_ce_u4       m329_swio12_lednop_pr_ce          m329_swio12_lednop_pr_ce_u4
 * m329a_swio11_lednop_pr_ce         m329a_swio11_lednop_pr_ce_u4      m329a_swio12_lednop_pr_ce
 * m329a_swio12_lednop_pr_ce_u4      m329p_swio11_lednop_pr_ce         m329p_swio11_lednop_pr_ce_u4
 * m329p_swio12_lednop_pr_ce         m329p_swio12_lednop_pr_ce_u4      m329pa_swio11_lednop_pr_ce
 * m329pa_swio11_lednop_pr_ce_u4     m329pa_swio12_lednop_pr_ce        m329pa_swio12_lednop_pr_ce_u4
 * m3290_swio11_lednop_pr_ce         m3290_swio11_lednop_pr_ce_u4      m3290_swio12_lednop_pr_ce
 * m3290_swio12_lednop_pr_ce_u4      m3290a_swio11_lednop_pr_ce        m3290a_swio11_lednop_pr_ce_u4
 * m3290a_swio12_lednop_pr_ce        m3290a_swio12_lednop_pr_ce_u4     m3290p_swio11_lednop_pr_ce
 * m3290p_swio11_lednop_pr_ce_u4     m3290p_swio12_lednop_pr_ce        m3290p_swio12_lednop_pr_ce_u4
 * m3290pa_swio11_lednop_pr_ce       m3290pa_swio11_lednop_pr_ce_u4    m3290pa_swio12_lednop_pr_ce
 * m3290pa_swio12_lednop_pr_ce_u4    m325_swio11_lednop_pr_ce          m325_swio11_lednop_pr_ce_u4
 * m325_swio12_lednop_pr_ce          m325_swio12_lednop_pr_ce_u4       m325a_swio11_lednop_pr_ce
 * m325a_swio11_lednop_pr_ce_u4      m325a_swio12_lednop_pr_ce         m325a_swio12_lednop_pr_ce_u4
 * m325p_swio11_lednop_pr_ce         m325p_swio11_lednop_pr_ce_u4      m325p_swio12_lednop_pr_ce
 * m325p_swio12_lednop_pr_ce_u4      m325pa_swio11_lednop_pr_ce        m325pa_swio11_lednop_pr_ce_u4
 * m325pa_swio12_lednop_pr_ce        m325pa_swio12_lednop_pr_ce_u4     m3250_swio11_lednop_pr_ce
 * m3250_swio11_lednop_pr_ce_u4      m3250_swio12_lednop_pr_ce         m3250_swio12_lednop_pr_ce_u4
 * m3250a_swio11_lednop_pr_ce        m3250a_swio11_lednop_pr_ce_u4     m3250a_swio12_lednop_pr_ce
 * m3250a_swio12_lednop_pr_ce_u4     m3250p_swio11_lednop_pr_ce        m3250p_swio11_lednop_pr_ce_u4
 * m3250p_swio12_lednop_pr_ce        m3250p_swio12_lednop_pr_ce_u4     m3250pa_swio11_lednop_pr_ce
 * m3250pa_swio11_lednop_pr_ce_u4    m3250pa_swio12_lednop_pr_ce       m3250pa_swio12_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_swio11_lednop_pr_ce[] = {
  0x26cfddddda244511, 0xc776aaf088f5e254, 0x8f7e9e8db622c1ef, 0xff5e35da59bbb26b, 0x62b2210209bb426c,
  0x5bbc9dd57ccfa0d9, 0xfc729827c602410c, 0xaf752836ebfcf02c, 0xc79e012a77a6ee2f, 0x12fc4361222fb892,
  0x5dc6e1256547ea3e, 0xf2fa7b9633f5933c, 0xe951c74fe0d67fa8, 0xc9118df398b0163d, 0x807feccf1d7a3e76,
  0xbb503cb5ba0ff48a, 0x19cc5076bcb955ac, 0xd5d9cea2a551aee7, 0x1cd7020272bb54b7, 0xbcb10d2b97a5fd22,
  0x078e56bae7b55a22, 0x40842a417296be74, 0xaa2d2414e31bc674, 0x997cdb63131dbd8a, 0x637c5c9ab83cd84b,
  0xfa9d598f207e50d1, 0x3ffbc3def2861539, 0xa1e64ff03f8cbf31, 0xf1a3d17f81fbf619, 0x7c09c6592e19e985,
  0x57ee6866587494b6, 0x000375c2171014f2,
};

/*
 * m329_swio12_lednop_pr_ee_ce       m329a_swio11_lednop_pr_ee_ce      m329a_swio12_lednop_pr_ee_ce
 * m329p_swio11_lednop_pr_ee_ce      m329p_swio12_lednop_pr_ee_ce      m329pa_swio11_lednop_pr_ee_ce
 * m329pa_swio12_lednop_pr_ee_ce     m3290_swio11_lednop_pr_ee_ce      m3290_swio12_lednop_pr_ee_ce
 * m3290a_swio11_lednop_pr_ee_ce     m3290a_swio12_lednop_pr_ee_ce     m3290p_swio11_lednop_pr_ee_ce
 * m3290p_swio12_lednop_pr_ee_ce     m3290pa_swio11_lednop_pr_ee_ce    m3290pa_swio12_lednop_pr_ee_ce
 * m325_swio11_lednop_pr_ee_ce       m325_swio12_lednop_pr_ee_ce       m325a_swio11_lednop_pr_ee_ce
 * m325a_swio12_lednop_pr_ee_ce      m325p_swio11_lednop_pr_ee_ce      m325p_swio12_lednop_pr_ee_ce
 * m325pa_swio11_lednop_pr_ee_ce     m325pa_swio12_lednop_pr_ee_ce     m3250_swio11_lednop_pr_ee_ce
 * m3250_swio12_lednop_pr_ee_ce      m3250a_swio11_lednop_pr_ee_ce     m3250a_swio12_lednop_pr_ee_ce
 * m3250p_swio11_lednop_pr_ee_ce     m3250p_swio12_lednop_pr_ee_ce     m3250pa_swio11_lednop_pr_ee_ce
 * m3250pa_swio12_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_swio11_lednop_pr_ee_ce[] = {
  0x7f8fdddddd447032, 0x5ddaabd85048c4a1, 0x91db13ac829b18c4, 0x1f5a63be9de46829, 0xddc123f065ab42ff,
  0x2775b11ceb0c9c91, 0x2609f180904316ef, 0xca0868ff3c0b3eff, 0x4a9d8683bfea8cba, 0x771b8d07044fe780,
  0xa5ca76b2b1ef984e, 0x1f06cc1e95ea3cac, 0x3ad08a05315943f5, 0x09afa30b2c4522cd, 0x39b8e7576e74a3a9,
  0x55e363af3a6ed222, 0x5c242285f11c6563, 0xd8226470decb65cc, 0xcb955a9676b13ca8, 0x551aee719cc5076b,
  0x2bb54b7d5d9cea2a, 0x7a5fd221cd702027, 0x7b55a22bcb10d2b9, 0x296be74078e56bae, 0x31bc67440842a417,
  0x31dbd8aaa2d2414e, 0xab8d84b997cdb631, 0xe40fca1a2c79c5c9, 0xb867a615c9fbab31, 0x1d252d964a271964,
  0xc4053c95fb9a1996, 0x00000000029a6dc7,
};

/*
 * m329_swio12_lednop_pr_ee_ce_u4    m329a_swio11_lednop_pr_ee_ce_u4   m329a_swio12_lednop_pr_ee_ce_u4
 * m329p_swio11_lednop_pr_ee_ce_u4   m329p_swio12_lednop_pr_ee_ce_u4   m329pa_swio11_lednop_pr_ee_ce_u4
 * m329pa_swio12_lednop_pr_ee_ce_u4  m3290_swio11_lednop_pr_ee_ce_u4   m3290_swio12_lednop_pr_ee_ce_u4
 * m3290a_swio11_lednop_pr_ee_ce_u4  m3290a_swio12_lednop_pr_ee_ce_u4  m3290p_swio11_lednop_pr_ee_ce_u4
 * m3290p_swio12_lednop_pr_ee_ce_u4  m3290pa_swio11_lednop_pr_ee_ce_u4 m3290pa_swio12_lednop_pr_ee_ce_u4
 * m325_swio11_lednop_pr_ee_ce_u4    m325_swio12_lednop_pr_ee_ce_u4    m325a_swio11_lednop_pr_ee_ce_u4
 * m325a_swio12_lednop_pr_ee_ce_u4   m325p_swio11_lednop_pr_ee_ce_u4   m325p_swio12_lednop_pr_ee_ce_u4
 * m325pa_swio11_lednop_pr_ee_ce_u4  m325pa_swio12_lednop_pr_ee_ce_u4  m3250_swio11_lednop_pr_ee_ce_u4
 * m3250_swio12_lednop_pr_ee_ce_u4   m3250a_swio11_lednop_pr_ee_ce_u4  m3250a_swio12_lednop_pr_ee_ce_u4
 * m3250p_swio11_lednop_pr_ee_ce_u4  m3250p_swio12_lednop_pr_ee_ce_u4  m3250pa_swio11_lednop_pr_ee_ce_u4
 * m3250pa_swio12_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio11_lednop_pr_ee_ce_u4[] = {
  0x615bbbbb44867a31, 0x776aafea6cce24b4, 0x6c36ed0b3760bf31, 0x0a800ad9914774cf, 0x946ea5d8596cf5a3,
  0x277513f0fbed03e2, 0x6609f180904316ef, 0x5050fbfec5767fb0, 0x80e21f5c5f547a6e, 0x8488bee24b1e79b6,
  0xfc7ddfa8f84bf10d, 0x736f7ccf1771b9c3, 0xe95ea3caca5ca76b, 0x5315943f51f06cc1, 0xb2c4522cd3ad08a0,
  0x76e74a3a909afa30, 0xf3a6ed22239b8e75, 0x5f11c656355e363a, 0x0decb65cc5c24228, 0x676b13ca8d822647,
  0x19cc5076bcb955a9, 0xd5d9cea2a551aee7, 0x1cd7020272bb54b7, 0xbcb10d2b97a5fd22, 0x078e56bae7b55a22,
  0x40842a417296be74, 0xaa2d2414e31bc674, 0x997cdb63131dbd8a, 0x71a2c6f86e3cd84b, 0x2a73f53ab337f077,
  0x7e627ff787bde50c, 0xec3343cc9fe07f19, 0xd30be347a2ff03f7, 0x296cf8138cb25c33, 0x59e4afdcd0ccb0e9,
  0x00000027e46a7374,
};

/*
 * m329_swio12_lednop_ee_hw          m329a_swio11_lednop_ee_hw         m329a_swio12_lednop_ee_hw
 * m329p_swio11_lednop_ee_hw         m329p_swio12_lednop_ee_hw         m329pa_swio11_lednop_ee_hw
 * m329pa_swio12_lednop_ee_hw        m3290_swio11_lednop_ee_hw         m3290_swio12_lednop_ee_hw
 * m3290a_swio11_lednop_ee_hw        m3290a_swio12_lednop_ee_hw        m3290p_swio11_lednop_ee_hw
 * m3290p_swio12_lednop_ee_hw        m3290pa_swio11_lednop_ee_hw       m3290pa_swio12_lednop_ee_hw
 * m325_swio11_lednop_ee_hw          m325_swio12_lednop_ee_hw          m325a_swio11_lednop_ee_hw
 * m325a_swio12_lednop_ee_hw         m325p_swio11_lednop_ee_hw         m325p_swio12_lednop_ee_hw
 * m325pa_swio11_lednop_ee_hw        m325pa_swio12_lednop_ee_hw        m3250_swio11_lednop_ee_hw
 * m3250_swio12_lednop_ee_hw         m3250a_swio11_lednop_ee_hw        m3250a_swio12_lednop_ee_hw
 * m3250p_swio11_lednop_ee_hw        m3250p_swio12_lednop_ee_hw        m3250pa_swio11_lednop_ee_hw
 * m3250pa_swio12_lednop_ee_hw
 */
static const uint64_t ur_m329_swio11_lednop_ee_hw[] = {
  0xfad377776890c044, 0xdddaabf0bb458971, 0xde4bbb988dbe6e64, 0x7eb4368604142d04, 0x7f4cd2e2f106d05c,
  0x16ef277505272d08, 0x3e96a609f1809043, 0xa331f28235bfe853, 0xfa8f51e56c166ab5, 0xef8ad4f7a8f83660,
  0x5962291669d68450, 0xd2ae3593484d7d18, 0xbb4888e6e39d5a5d, 0x38cac6ab5d0ebce9, 0x96cb98b848450be2,
  0xc4f2a3608fd6e1bd, 0x141daf2e556a015a, 0x73a8a9546bb9c673, 0xc0809caed52df576, 0x434ae5e97f488735,
  0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021, 0x9b6c63156f62aa8b, 0x505d8dc79b09732f,
  0xff787bde50c2a73f, 0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf,
  0x0002df1a9ca29e4a,
};

/*
 * m329_swio11_lednop_ee_ce_u4_hw    m329_swio12_lednop_ee_ce_hw       m329_swio12_lednop_ee_ce_u4_hw
 * m329a_swio11_lednop_ee_ce_hw      m329a_swio11_lednop_ee_ce_u4_hw   m329a_swio12_lednop_ee_ce_hw
 * m329a_swio12_lednop_ee_ce_u4_hw   m329p_swio11_lednop_ee_ce_hw      m329p_swio11_lednop_ee_ce_u4_hw
 * m329p_swio12_lednop_ee_ce_hw      m329p_swio12_lednop_ee_ce_u4_hw   m329pa_swio11_lednop_ee_ce_hw
 * m329pa_swio11_lednop_ee_ce_u4_hw  m329pa_swio12_lednop_ee_ce_hw     m329pa_swio12_lednop_ee_ce_u4_hw
 * m3290_swio11_lednop_ee_ce_hw      m3290_swio11_lednop_ee_ce_u4_hw   m3290_swio12_lednop_ee_ce_hw
 * m3290_swio12_lednop_ee_ce_u4_hw   m3290a_swio11_lednop_ee_ce_hw     m3290a_swio11_lednop_ee_ce_u4_hw
 * m3290a_swio12_lednop_ee_ce_hw     m3290a_swio12_lednop_ee_ce_u4_hw  m3290p_swio11_lednop_ee_ce_hw
 * m3290p_swio11_lednop_ee_ce_u4_hw  m3290p_swio12_lednop_ee_ce_hw     m3290p_swio12_lednop_ee_ce_u4_hw
 * m3290pa_swio11_lednop_ee_ce_hw    m3290pa_swio11_lednop_ee_ce_u4_hw m3290pa_swio12_lednop_ee_ce_hw
 * m3290pa_swio12_lednop_ee_ce_u4_hw m325_swio11_lednop_ee_ce_hw       m325_swio11_lednop_ee_ce_u4_hw
 * m325_swio12_lednop_ee_ce_hw       m325_swio12_lednop_ee_ce_u4_hw    m325a_swio11_lednop_ee_ce_hw
 * m325a_swio11_lednop_ee_ce_u4_hw   m325a_swio12_lednop_ee_ce_hw      m325a_swio12_lednop_ee_ce_u4_hw
 * m325p_swio11_lednop_ee_ce_hw      m325p_swio11_lednop_ee_ce_u4_hw   m325p_swio12_lednop_ee_ce_hw
 * m325p_swio12_lednop_ee_ce_u4_hw   m325pa_swio11_lednop_ee_ce_hw     m325pa_swio11_lednop_ee_ce_u4_hw
 * m325pa_swio12_lednop_ee_ce_hw     m325pa_swio12_lednop_ee_ce_u4_hw  m3250_swio11_lednop_ee_ce_hw
 * m3250_swio11_lednop_ee_ce_u4_hw   m3250_swio12_lednop_ee_ce_hw      m3250_swio12_lednop_ee_ce_u4_hw
 * m3250a_swio11_lednop_ee_ce_hw     m3250a_swio11_lednop_ee_ce_u4_hw  m3250a_swio12_lednop_ee_ce_hw
 * m3250a_swio12_lednop_ee_ce_u4_hw  m3250p_swio11_lednop_ee_ce_hw     m3250p_swio11_lednop_ee_ce_u4_hw
 * m3250p_swio12_lednop_ee_ce_hw     m3250p_swio12_lednop_ee_ce_u4_hw  m3250pa_swio11_lednop_ee_ce_hw
 * m3250pa_swio11_lednop_ee_ce_u4_hw m3250pa_swio12_lednop_ee_ce_hw    m3250pa_swio12_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio11_lednop_ee_ce_hw[] = {
  0x30addddda2435f41, 0xbbb557f53667125a, 0xb61b76859bb05f98, 0x8540056cc8a3ba67, 0x4a3752ec2cb67ad1,
  0xbbc9dda2feef6b89, 0xec19827c602410c5, 0xd3728287dff4299f, 0xcdb40710fae2faa3, 0x886c2445f71258f3,
  0xc575c617fd47c25f, 0x3b5b9b7be678bb8d, 0x660f4af51e5652e5, 0x450298aca1fa8f83, 0xd185962291669d68,
  0x73abb73a51d484d7, 0xb1d79d3769111cdc, 0x1142f88e32b1aaf1, 0x32386f65b2e62e12, 0xad4b3b589e546c11,
  0x7738ce6283b5e5ca, 0xa5beaece75152a8d, 0xe910e6b8101395da, 0xd115e588695cbd2f, 0xf3a03c72b5d73daa,
  0x33a20421520b94b5, 0xec55516920a718de, 0xc25ccbe6db1898ed, 0x30a9cfd4176371e6, 0x65f989ffde1ef794,
  0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970, 0xa8a792bf734332c3, 0x000000000280a353,
};

/*
 * m329_swio11_dual_pr               m329_swio11_dual_pr_u4            m329_swio12_dual
 * m329_swio12_dual_pr               m329_swio12_dual_pr_u4            m329a_swio11_dual
 * m329a_swio11_dual_pr              m329a_swio11_dual_pr_u4           m329a_swio12_dual
 * m329a_swio12_dual_pr              m329a_swio12_dual_pr_u4           m329p_swio11_dual
 * m329p_swio11_dual_pr              m329p_swio11_dual_pr_u4           m329p_swio12_dual
 * m329p_swio12_dual_pr              m329p_swio12_dual_pr_u4           m329pa_swio11_dual
 * m329pa_swio11_dual_pr             m329pa_swio11_dual_pr_u4          m329pa_swio12_dual
 * m329pa_swio12_dual_pr             m329pa_swio12_dual_pr_u4          m3290_swio11_dual
 * m3290_swio11_dual_pr              m3290_swio11_dual_pr_u4           m3290_swio12_dual
 * m3290_swio12_dual_pr              m3290_swio12_dual_pr_u4           m3290a_swio11_dual
 * m3290a_swio11_dual_pr             m3290a_swio11_dual_pr_u4          m3290a_swio12_dual
 * m3290a_swio12_dual_pr             m3290a_swio12_dual_pr_u4          m3290p_swio11_dual
 * m3290p_swio11_dual_pr             m3290p_swio11_dual_pr_u4          m3290p_swio12_dual
 * m3290p_swio12_dual_pr             m3290p_swio12_dual_pr_u4          m3290pa_swio11_dual
 * m3290pa_swio11_dual_pr            m3290pa_swio11_dual_pr_u4         m3290pa_swio12_dual
 * m3290pa_swio12_dual_pr            m3290pa_swio12_dual_pr_u4         m325_swio11_dual
 * m325_swio11_dual_pr               m325_swio11_dual_pr_u4            m325_swio12_dual
 * m325_swio12_dual_pr               m325_swio12_dual_pr_u4            m325a_swio11_dual
 * m325a_swio11_dual_pr              m325a_swio11_dual_pr_u4           m325a_swio12_dual
 * m325a_swio12_dual_pr              m325a_swio12_dual_pr_u4           m325p_swio11_dual
 * m325p_swio11_dual_pr              m325p_swio11_dual_pr_u4           m325p_swio12_dual
 * m325p_swio12_dual_pr              m325p_swio12_dual_pr_u4           m325pa_swio11_dual
 * m325pa_swio11_dual_pr             m325pa_swio11_dual_pr_u4          m325pa_swio12_dual
 * m325pa_swio12_dual_pr             m325pa_swio12_dual_pr_u4          m3250_swio11_dual
 * m3250_swio11_dual_pr              m3250_swio11_dual_pr_u4           m3250_swio12_dual
 * m3250_swio12_dual_pr              m3250_swio12_dual_pr_u4           m3250a_swio11_dual
 * m3250a_swio11_dual_pr             m3250a_swio11_dual_pr_u4          m3250a_swio12_dual
 * m3250a_swio12_dual_pr             m3250a_swio12_dual_pr_u4          m3250p_swio11_dual
 * m3250p_swio11_dual_pr             m3250p_swio11_dual_pr_u4          m3250p_swio12_dual
 * m3250p_swio12_dual_pr             m3250p_swio12_dual_pr_u4          m3250pa_swio11_dual
 * m3250pa_swio11_dual_pr            m3250pa_swio11_dual_pr_u4         m3250pa_swio12_dual
 * m3250pa_swio12_dual_pr            m3250pa_swio12_dual_pr_u4
 */
static const uint64_t ur_m329_swio11_dual[] = {
  0x23fbbbbb4486c541, 0x13b7e3af4e46d2e3, 0x17ddb83d3a85b4bf, 0xe2ff23b295f14adb, 0x59f16a015bab8c8f,
  0xd0eeb047f0d57a8c, 0x13e30120862dde4a, 0x5b40c894948548cc, 0xe20614306d230377, 0xe4ff32ba0cee9f12,
  0x8efe6c17d9c0a2cc, 0x508e489fc199537a, 0x3e144312bfcfdf04, 0x5ddeef9b8d7600dc, 0xd150865a11922195,
  0xdb94bffa039e135a, 0xee6bcc161bcaf212, 0x7477cb2d794128bf, 0xee38e9fc1ef7ea3f, 0x1398b01541e67261,
  0xc11d78033b2008d3, 0xcf6def1bea807fec, 0x7ceee2a4af9d40f2, 0x283b5e5caad67f15, 0xe75152a8d7738ce6,
  0x8101395daa5beaec, 0x8695cbd2fe910e6b, 0x2b5d73daad115e58, 0x1520b94b5f3a03c7, 0x920a718de33a2042,
  0x36d8c62adec55516, 0xb1be1b8f3612e65f, 0xfd4eaccdfc1ddc68, 0x9ffde1ef79430a9c, 0xd0f327f81fc65f98,
  0xf8d1e8bfc0fdfb0c, 0x3e04e32c970cf4c2, 0x2bf734332c3a4a5b, 0x00149320e4dd1679,
};

/*
 * m329_swio12_dual_pr_ee            m329a_swio11_dual_pr_ee           m329a_swio12_dual_pr_ee
 * m329p_swio11_dual_pr_ee           m329p_swio12_dual_pr_ee           m329pa_swio11_dual_pr_ee
 * m329pa_swio12_dual_pr_ee          m3290_swio11_dual_pr_ee           m3290_swio12_dual_pr_ee
 * m3290a_swio11_dual_pr_ee          m3290a_swio12_dual_pr_ee          m3290p_swio11_dual_pr_ee
 * m3290p_swio12_dual_pr_ee          m3290pa_swio11_dual_pr_ee         m3290pa_swio12_dual_pr_ee
 * m325_swio11_dual_pr_ee            m325_swio12_dual_pr_ee            m325a_swio11_dual_pr_ee
 * m325a_swio12_dual_pr_ee           m325p_swio11_dual_pr_ee           m325p_swio12_dual_pr_ee
 * m325pa_swio11_dual_pr_ee          m325pa_swio12_dual_pr_ee          m3250_swio11_dual_pr_ee
 * m3250_swio12_dual_pr_ee           m3250a_swio11_dual_pr_ee          m3250a_swio12_dual_pr_ee
 * m3250p_swio11_dual_pr_ee          m3250p_swio12_dual_pr_ee          m3250pa_swio11_dual_pr_ee
 * m3250pa_swio12_dual_pr_ee
 */
static const uint64_t ur_m329_swio11_dual_pr_ee[] = {
  0x33d6dddddd435032, 0xf13b7e35342136ac, 0x69edd39cafa05991, 0x9199daaef4d7dfbd, 0x87d73899bd7b0cf5,
  0xabdb47faf7dd8e17, 0x02410c5bbc9e9cee, 0x22525217459827c6, 0x50c1b48c0ddd6d03, 0xcae833ba7c4b8818,
  0x60968e016a631ffc, 0x13f838ad37a8e4eb, 0x6257f9fbe08a11c9, 0xe6e5d0c01b87c288, 0x2d05f688655777bb,
  0xfa039e1307b8a843, 0x161bcaf212dbe9af, 0xfee9410b5fee6bcc, 0xdfa8f2bb75355ad1, 0x8af4dfa8f83660c3,
  0x62291669d68450ef, 0xb8a973484d7d1859, 0xc7a33d4e7569760a, 0x36355ae875ea25d8, 0x2cc5c24228d291c4,
  0xaa3608fd6e1bd97d, 0xf9ddc549402c8a22, 0x5076bcb955acfe2a, 0xcea2a551aee719cc, 0x020272bb54b7d5d9,
  0x0d2b97a5fd221cd7, 0x56bae7b55a22bcb1, 0x2a417296be74078e, 0x2414e31bc6744084, 0x6db18c55bd8aaa2d,
  0xc79c371e6c25ccbe, 0x9fbab337f07771a2, 0x0271964b867a615c, 0xfb9a19961d252d9f, 0x064288be6e8b3c95,
};

/*
 * m329_swio12_dual_pr_ee_u4         m329a_swio11_dual_pr_ee_u4        m329a_swio12_dual_pr_ee_u4
 * m329p_swio11_dual_pr_ee_u4        m329p_swio12_dual_pr_ee_u4        m329pa_swio11_dual_pr_ee_u4
 * m329pa_swio12_dual_pr_ee_u4       m3290_swio11_dual_pr_ee_u4        m3290_swio12_dual_pr_ee_u4
 * m3290a_swio11_dual_pr_ee_u4       m3290a_swio12_dual_pr_ee_u4       m3290p_swio11_dual_pr_ee_u4
 * m3290p_swio12_dual_pr_ee_u4       m3290pa_swio11_dual_pr_ee_u4      m3290pa_swio12_dual_pr_ee_u4
 * m325_swio11_dual_pr_ee_u4         m325_swio12_dual_pr_ee_u4         m325a_swio11_dual_pr_ee_u4
 * m325a_swio12_dual_pr_ee_u4        m325p_swio11_dual_pr_ee_u4        m325p_swio12_dual_pr_ee_u4
 * m325pa_swio11_dual_pr_ee_u4       m325pa_swio12_dual_pr_ee_u4       m3250_swio11_dual_pr_ee_u4
 * m3250_swio12_dual_pr_ee_u4        m3250a_swio11_dual_pr_ee_u4       m3250a_swio12_dual_pr_ee_u4
 * m3250p_swio11_dual_pr_ee_u4       m3250p_swio12_dual_pr_ee_u4       m3250pa_swio11_dual_pr_ee_u4
 * m3250pa_swio12_dual_pr_ee_u4
 */
static const uint64_t ur_m329_swio11_dual_pr_ee_u4[] = {
  0x5b777768adbba0ae, 0xedf8d4d084dab0cf, 0xf34e72be816647c4, 0xb55de9afbf6d3da3, 0x71337af619eb2333,
  0x6eaf61f5dc2f0fae, 0x2dde4f4e777d7dfd, 0x0ba2cc13e3012086, 0x4606eeb681912929, 0xdd3e25c40c2860da,
  0x05a98c7ff32d0729, 0xb4dea393ad825a38, 0xef822847244fe0e2, 0x006e1f0a21895fe7, 0x21955ddeef9b9743,
  0x4c1ee2a10cb417da, 0xc84b6fa6bfe80e78, 0xb5ff8fc330586f2b, 0xb75355ad1fee9410, 0x8f83660c3dfa8f2b,
  0x9d68450ef8af4dfa, 0x84d7d18596229166, 0xe7569760ab8a9734, 0x875ea25d8c7a33d4, 0x228d291c436355ae,
  0xd6e1bd97d2cc5c24, 0x9402c8a22aa3608f, 0x955acfe2af9ddc54, 0x1aee719cc5076bcb, 0xb54b7d5d9cea2a55,
  0x5fd221cd7020272b, 0x55a22bcb10d2b97a, 0x6be74078e56bae7b, 0xbc67440842a41729, 0x5bd8aaa2d2414e31,
  0xe6c25ccbe6db18c5, 0x6ec68b1be2e4d5c1, 0x1539fa9d599bf83f, 0xbf313ffbc3def286, 0xf619a1e64ff03f8c,
  0xe985f1a3d17f81fb, 0x94b67c09c6592e19, 0x74f257ee68665874, 0x000000ac9ec4ff23,
};

/*
 * m329_swio12_dual_pr_ce            m329a_swio11_dual_pr_ce           m329a_swio12_dual_pr_ce
 * m329p_swio11_dual_pr_ce           m329p_swio12_dual_pr_ce           m329pa_swio11_dual_pr_ce
 * m329pa_swio12_dual_pr_ce          m3290_swio11_dual_pr_ce           m3290_swio12_dual_pr_ce
 * m3290a_swio11_dual_pr_ce          m3290a_swio12_dual_pr_ce          m3290p_swio11_dual_pr_ce
 * m3290p_swio12_dual_pr_ce          m3290pa_swio11_dual_pr_ce         m3290pa_swio12_dual_pr_ce
 * m325_swio11_dual_pr_ce            m325_swio12_dual_pr_ce            m325a_swio11_dual_pr_ce
 * m325a_swio12_dual_pr_ce           m325p_swio11_dual_pr_ce           m325p_swio12_dual_pr_ce
 * m325pa_swio11_dual_pr_ce          m325pa_swio12_dual_pr_ce          m3250_swio11_dual_pr_ce
 * m3250_swio12_dual_pr_ce           m3250a_swio11_dual_pr_ce          m3250a_swio12_dual_pr_ce
 * m3250p_swio11_dual_pr_ce          m3250p_swio12_dual_pr_ce          m3250pa_swio11_dual_pr_ce
 * m3250pa_swio12_dual_pr_ce
 */
static const uint64_t ur_m329_swio11_dual_pr_ce[] = {
  0x6edddddec121a5fb, 0x4edf9e3fbb368a70, 0xfb755f362477707c, 0xbb69c89f55fd77a0, 0x995dfbf7ba538374,
  0x5dd2c8d759b42acc, 0xf8c048218b779262, 0xa0644a4a44463304, 0x030a18369181bbad, 0xff995d06774f8971,
  0x676c2391c0e0cdd5, 0x39227f072ba6f51f, 0x510c4aff3f7c1142, 0x7bbe6e29200370f8, 0x8432d00f68865577,
  0x9bffa039e1304f8a, 0x7982c3795e425b71, 0x2fabf9282707fdcd, 0x92c79e6da0384eae, 0x3e12fc4361222fb8,
  0x78bb8dc66fa547ea, 0x4709f3dcb19f52e6, 0x176fc71d3f83b5bd, 0xd90046989cc580a5, 0x5403ff6678ebc019,
  0x5f3a81e5adcf78df, 0x55acfe2af9ddc549, 0xaee719cc5076bcb9, 0x54b7d5d9cea2a551, 0xfd221cd7020272bb,
  0x5a22bcb10d2b97a5, 0xbe74078e56bae7b5, 0xc67440842a417296, 0xbd8aaa2d2414e31b, 0xd84b997cdb63131d,
  0x83bb8d165abc6e3c, 0x2861539fa9d599bf, 0xc07cd0f327f8138d, 0x38cb25c33d30ae4f, 0xcd0ccb0e9296cf81,
  0xd247adb7459e4afd,
};

/*
 * m329_swio12_dual_pr_ce_u4         m329a_swio11_dual_pr_ce_u4        m329a_swio12_dual_pr_ce_u4
 * m329p_swio11_dual_pr_ce_u4        m329p_swio12_dual_pr_ce_u4        m329pa_swio11_dual_pr_ce_u4
 * m329pa_swio12_dual_pr_ce_u4       m3290_swio11_dual_pr_ce_u4        m3290_swio12_dual_pr_ce_u4
 * m3290a_swio11_dual_pr_ce_u4       m3290a_swio12_dual_pr_ce_u4       m3290p_swio11_dual_pr_ce_u4
 * m3290p_swio12_dual_pr_ce_u4       m3290pa_swio11_dual_pr_ce_u4      m3290pa_swio12_dual_pr_ce_u4
 * m325_swio11_dual_pr_ce_u4         m325_swio12_dual_pr_ce_u4         m325a_swio11_dual_pr_ce_u4
 * m325a_swio12_dual_pr_ce_u4        m325p_swio11_dual_pr_ce_u4        m325p_swio12_dual_pr_ce_u4
 * m325pa_swio11_dual_pr_ce_u4       m325pa_swio12_dual_pr_ce_u4       m3250_swio11_dual_pr_ce_u4
 * m3250_swio12_dual_pr_ce_u4        m3250a_swio11_dual_pr_ce_u4       m3250a_swio12_dual_pr_ce_u4
 * m3250p_swio11_dual_pr_ce_u4       m3250p_swio12_dual_pr_ce_u4       m3250pa_swio11_dual_pr_ce_u4
 * m3250pa_swio12_dual_pr_ce_u4
 */
static const uint64_t ur_m329_swio11_dual_pr_ce_u4[] = {
  0x4e4eddddda2432db, 0xf13b7e78fb1736ac, 0x4d7dd6c4eca38f4e, 0xe4ea666eb4b1272d, 0x674a3f738abf76c4,
  0xc968aee3822ac07c, 0xe9827c602410c5bb, 0xddd6d032252520eb, 0xc4b881850c1b48c0, 0x73456fccae833ba7,
  0xbd47cadb0df670d3, 0x04508e489fc19439, 0xdc3e144312bfcfdf, 0x955ddeef9b895000, 0x9c62a10cb4027a21,
  0x4b6f63fff4073c26, 0x7fb9af30586f2bc8, 0x29eb8bebb7e5046b, 0x8bee24b1e79b680e, 0x87fa8f84bf10d848,
  0xc38ccf1771b9d66c, 0x64f7a8f2fa7b9633, 0x580bb7d7c8e3a7f0, 0x5e45bb0f88c6f9cc, 0x928eae1ee39633c7,
  0x72ab59fc55f3bb8a, 0xa35dce3398a0ed79, 0x76a96fabb39d454a, 0x4bfa4439ae0404e5, 0x6ab44579621a572f,
  0xca6c59d01e7eb5cf, 0x8c10b4d5ceaf52c2, 0x69c6378ce88145f1, 0xdf0dc79b09732f9b, 0xa75666fe0eee3458,
  0xfef0f7bca1854e7e, 0x7993fc0fe32fcc4f, 0x68f45fe07efd8668, 0x0271964b867a617c, 0xfb9a19961d252d9f,
  0x003490b36e8b3c95,
};

/*
 * m329_swio12_dual_pr_ee_ce         m329a_swio11_dual_pr_ee_ce        m329a_swio12_dual_pr_ee_ce
 * m329p_swio11_dual_pr_ee_ce        m329p_swio12_dual_pr_ee_ce        m329pa_swio11_dual_pr_ee_ce
 * m329pa_swio12_dual_pr_ee_ce       m3290_swio11_dual_pr_ee_ce        m3290_swio12_dual_pr_ee_ce
 * m3290a_swio11_dual_pr_ee_ce       m3290a_swio12_dual_pr_ee_ce       m3290p_swio11_dual_pr_ee_ce
 * m3290p_swio12_dual_pr_ee_ce       m3290pa_swio11_dual_pr_ee_ce      m3290pa_swio12_dual_pr_ee_ce
 * m325_swio11_dual_pr_ee_ce         m325_swio12_dual_pr_ee_ce         m325a_swio11_dual_pr_ee_ce
 * m325a_swio12_dual_pr_ee_ce        m325p_swio11_dual_pr_ee_ce        m325p_swio12_dual_pr_ee_ce
 * m325pa_swio11_dual_pr_ee_ce       m325pa_swio12_dual_pr_ee_ce       m3250_swio11_dual_pr_ee_ce
 * m3250_swio12_dual_pr_ee_ce        m3250a_swio11_dual_pr_ee_ce       m3250a_swio12_dual_pr_ee_ce
 * m3250p_swio11_dual_pr_ee_ce       m3250p_swio12_dual_pr_ee_ce       m3250pa_swio11_dual_pr_ee_ce
 * m3250pa_swio12_dual_pr_ee_ce
 */
static const uint64_t ur_m329_swio11_dual_pr_ee_ce[] = {
  0xda57dbbbbba86f97, 0x6f13b7e3111f86d7, 0x7af7bb62f1aac33d, 0xf1ba4e56820f913f, 0xbebd77a9be4bf695,
  0xe78233a96453ab04, 0x602410c5bbc9c9ce, 0x644a4a41c939827c, 0x0a18369181bbada0, 0x995d06774f897103,
  0x3601a0e1a6a67f9f, 0x227f07d3f37a8fff, 0x0c4aff3f7c114239, 0x7cdcf3900370f851, 0x65a070d10caaeef7,
  0xff4073c267271508, 0x82c3795e425b7149, 0x3287283a6bfdcd79, 0x9e6da039a68effaa, 0x309cee3714939bff,
  0x795b0594ed656443, 0x3dea3e0d983ea3d4, 0x459a75a1140a62b5, 0xc752135f4616588a, 0xdbe8e5f1ceaedc70,
  0x2c6abc6c75ed6276, 0xf18b8484500a231f, 0x5c63914c8e1bd971, 0x556b3f8abe777152, 0x6bb9c673141daf2e,
  0xd52df57673a8a954, 0x7f488735c0809cae, 0x5688af2c434ae5e9, 0xaf9d01e395aeb9ed, 0xf19d10210a905ca5,
  0x6f62aa8b490538c6, 0x3612e65f36d8c4c7, 0xf83bb8d163ce1b8f, 0xc33d30ae4fdd599b, 0x0e9296cf8138cb25,
  0x37459e4afdcd0ccb, 0x00000000002609ce,
};

/*
 * m329_swio12_dual_pr_ee_ce_u4      m329a_swio11_dual_pr_ee_ce_u4     m329a_swio12_dual_pr_ee_ce_u4
 * m329p_swio11_dual_pr_ee_ce_u4     m329p_swio12_dual_pr_ee_ce_u4     m329pa_swio11_dual_pr_ee_ce_u4
 * m329pa_swio12_dual_pr_ee_ce_u4    m3290_swio11_dual_pr_ee_ce_u4     m3290_swio12_dual_pr_ee_ce_u4
 * m3290a_swio11_dual_pr_ee_ce_u4    m3290a_swio12_dual_pr_ee_ce_u4    m3290p_swio11_dual_pr_ee_ce_u4
 * m3290p_swio12_dual_pr_ee_ce_u4    m3290pa_swio11_dual_pr_ee_ce_u4   m3290pa_swio12_dual_pr_ee_ce_u4
 * m325_swio11_dual_pr_ee_ce_u4      m325_swio12_dual_pr_ee_ce_u4      m325a_swio11_dual_pr_ee_ce_u4
 * m325a_swio12_dual_pr_ee_ce_u4     m325p_swio11_dual_pr_ee_ce_u4     m325p_swio12_dual_pr_ee_ce_u4
 * m325pa_swio11_dual_pr_ee_ce_u4    m325pa_swio12_dual_pr_ee_ce_u4    m3250_swio11_dual_pr_ee_ce_u4
 * m3250_swio12_dual_pr_ee_ce_u4     m3250a_swio11_dual_pr_ee_ce_u4    m3250a_swio12_dual_pr_ee_ce_u4
 * m3250p_swio11_dual_pr_ee_ce_u4    m3250p_swio12_dual_pr_ee_ce_u4    m3250pa_swio11_dual_pr_ee_ce_u4
 * m3250pa_swio12_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio11_dual_pr_ee_ce_u4[] = {
  0xbeeeeed15b770668, 0x6fccc5fc26d157d8, 0x6a6bd5784339de27, 0xe2faf7683acadada, 0x7138abec5e713ada,
  0x399a0e087877d737, 0x6c4eeab8fb000352, 0x827c602410c5bbc9, 0x5b40c894948659b9, 0xe20614306d230377,
  0xb5f9968394ee9f12, 0x8ddb0ec1385e1cdc, 0x39227f06d7737a8f, 0x510c4aff3f7c1142, 0xf77cdc15400370f8,
  0x0865a11c910caaee, 0x95ff4073c26df715, 0x330586f2bc84b6f4, 0xa3275283787ff8fc, 0x79e6da4eef0ee2fa,
  0x2fc4361222fb892c, 0xe370551649fea3e1, 0xe94ed6e6e6e99e2e, 0xc1b307b7fd4795ca, 0xb422814c57befd47,
  0x6be8c2cb1148b34e, 0xf539d5db9828ea42, 0xf1b1d7a897631e8c, 0x121146948e21b1aa, 0x226470decbe9662e,
  0x15252cf2288aa8d8, 0xf2e556b3f8abe777, 0x9546bb9c673141da, 0xcaed52df57673a8a, 0x5e97f488735c0809,
  0x9ed5688af2c434ae, 0xca5af9d01e395aeb, 0x8c6f19d10210a905, 0x4c76f62aa8b49053, 0xe0f3612e65f36d8c,
  0x1fb763458df1726a, 0x430a9cfd4eaccdfc, 0xc65f989ffde1ef79, 0xfdfb0cd0f327f81f, 0x0cf4c2f8d1e8bfc0,
  0x3a4a5b3e04e32c97, 0x91ba792bf734332c, 0x000000004004fc17,
};

/*
 * m329_swio12_dual_ee_hw            m329a_swio11_dual_ee_hw           m329a_swio12_dual_ee_hw
 * m329p_swio11_dual_ee_hw           m329p_swio12_dual_ee_hw           m329pa_swio11_dual_ee_hw
 * m329pa_swio12_dual_ee_hw          m3290_swio11_dual_ee_hw           m3290_swio12_dual_ee_hw
 * m3290a_swio11_dual_ee_hw          m3290a_swio12_dual_ee_hw          m3290p_swio11_dual_ee_hw
 * m3290p_swio12_dual_ee_hw          m3290pa_swio11_dual_ee_hw         m3290pa_swio12_dual_ee_hw
 * m325_swio11_dual_ee_hw            m325_swio12_dual_ee_hw            m325a_swio11_dual_ee_hw
 * m325a_swio12_dual_ee_hw           m325p_swio11_dual_ee_hw           m325p_swio12_dual_ee_hw
 * m325pa_swio11_dual_ee_hw          m325pa_swio12_dual_ee_hw          m3250_swio11_dual_ee_hw
 * m3250_swio12_dual_ee_hw           m3250a_swio11_dual_ee_hw          m3250a_swio12_dual_ee_hw
 * m3250p_swio11_dual_ee_hw          m3250p_swio12_dual_ee_hw          m3250pa_swio11_dual_ee_hw
 * m3250pa_swio12_dual_ee_hw
 */
static const uint64_t ur_m329_swio11_dual_ee_hw[] = {
  0xeb6eeee87ad0cf68, 0x9dbf1a9a109b5619, 0xf6e9ce57d02cc8f8, 0xcced577a6befdeb4, 0xeb9c4cdebd867ac8,
  0xcd1f53ad6ec70bc3, 0xc048218b7793d39d, 0x644a4a42e8b304f8, 0x0a18369181bbada0, 0x995d06774f897103,
  0x6c12d1c02d4c63ff, 0x227f0715a6f51c9d, 0x0c4aff3f7c114239, 0x7cdcba180370f851, 0x65a0bed10caaeef7,
  0xff4073c260f71508, 0x82c3795e425b7d35, 0x7fba5042d7ffa919, 0xf7ea3caedd4d56b4, 0xe2bd37ea3e0d9830,
  0x588a459a75a1143b, 0xae2a5cd2135f4616, 0x31e8cf539d5a5d82, 0x0d8d56ba1d7a8976, 0x4b3170908a34a471,
  0xaa8d823f5b86f65f, 0xbe777152500b2288, 0x141daf2e556b3f8a, 0x73a8a9546bb9c673, 0xc0809caed52df576,
  0x434ae5e97f488735, 0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021, 0x9b6c63156f62aa8b,
  0x97ab8dc79b09732f, 0x97e627f2861539fa, 0xffc1343cc9fe2e71, 0x25c33d30ae4fc73d, 0xcb0e9296cf8138cb,
  0x48bea29e4afdcd0c, 0x00000000000002bb,
};

/*
 * m329_swio12_dual_ee_ce_hw         m329a_swio11_dual_ee_ce_hw        m329a_swio12_dual_ee_ce_hw
 * m329p_swio11_dual_ee_ce_hw        m329p_swio12_dual_ee_ce_hw        m329pa_swio11_dual_ee_ce_hw
 * m329pa_swio12_dual_ee_ce_hw       m3290_swio11_dual_ee_ce_hw        m3290_swio12_dual_ee_ce_hw
 * m3290a_swio11_dual_ee_ce_hw       m3290a_swio12_dual_ee_ce_hw       m3290p_swio11_dual_ee_ce_hw
 * m3290p_swio12_dual_ee_ce_hw       m3290pa_swio11_dual_ee_ce_hw      m3290pa_swio12_dual_ee_ce_hw
 * m325_swio11_dual_ee_ce_hw         m325_swio12_dual_ee_ce_hw         m325a_swio11_dual_ee_ce_hw
 * m325a_swio12_dual_ee_ce_hw        m325p_swio11_dual_ee_ce_hw        m325p_swio12_dual_ee_ce_hw
 * m325pa_swio11_dual_ee_ce_hw       m325pa_swio12_dual_ee_ce_hw       m3250_swio11_dual_ee_ce_hw
 * m3250_swio12_dual_ee_ce_hw        m3250a_swio11_dual_ee_ce_hw       m3250a_swio12_dual_ee_ce_hw
 * m3250p_swio11_dual_ee_ce_hw       m3250p_swio12_dual_ee_ce_hw       m3250pa_swio11_dual_ee_ce_hw
 * m3250pa_swio12_dual_ee_ce_hw
 */
static const uint64_t ur_m329_swio11_dual_ee_ce_hw[] = {
  0x924cdddddd43359b, 0xf13b7e311b043693, 0xe4f7475d3eced362, 0x7accf8673226b8ed, 0x66c9b537c953924c,
  0x70f0cc29ad75ebde, 0x30120862dde4b337, 0x322525232da4c13e, 0x850c1b48c0ddd6d0, 0xccae833ba7c4b881,
  0xb60ff0e188266bbf, 0x913f83ff937a8fa6, 0x86257f9fbe08a11c, 0xbe6e2e0801b87c28, 0x32d060a88655777b,
  0xffa039e134878a84, 0x82c3795e425b735b, 0x795a507107ffa919, 0x3cdb4073101dff54, 0x6139dc6e654341ff,
  0xf2b95d29dacac9ba, 0xdfa8f83660f6ffa8, 0x1669d68450298af7, 0x1d484d7d18596229, 0x63d19ea73abb7305,
  0x36355e363af512ec, 0x2cc5c24228d291c4, 0x551b044c8e1bd97d, 0x7ceee2a4a59e4511, 0x283b5e5caad67f15,
  0xe75152a8d7738ce6, 0x8101395daa5beaec, 0x8695cbd2fe910e6b, 0x2b5d73daad115e58, 0x1520b94b5f3a03c7,
  0x920a718de33a2042, 0x6db1898edec55516, 0xcfec371e6c25ccbe, 0x38cb25c33d30ae4f, 0xcd0ccb0e9296cf81,
  0x01134c02a29e4afd,
};

/*
 * m329_swio12_dual_ee_ce_u4_hw      m329a_swio11_dual_ee_ce_u4_hw     m329a_swio12_dual_ee_ce_u4_hw
 * m329p_swio11_dual_ee_ce_u4_hw     m329p_swio12_dual_ee_ce_u4_hw     m329pa_swio11_dual_ee_ce_u4_hw
 * m329pa_swio12_dual_ee_ce_u4_hw    m3290_swio11_dual_ee_ce_u4_hw     m3290_swio12_dual_ee_ce_u4_hw
 * m3290a_swio11_dual_ee_ce_u4_hw    m3290a_swio12_dual_ee_ce_u4_hw    m3290p_swio11_dual_ee_ce_u4_hw
 * m3290p_swio12_dual_ee_ce_u4_hw    m3290pa_swio11_dual_ee_ce_u4_hw   m3290pa_swio12_dual_ee_ce_u4_hw
 * m325_swio11_dual_ee_ce_u4_hw      m325_swio12_dual_ee_ce_u4_hw      m325a_swio11_dual_ee_ce_u4_hw
 * m325a_swio12_dual_ee_ce_u4_hw     m325p_swio11_dual_ee_ce_u4_hw     m325p_swio12_dual_ee_ce_u4_hw
 * m325pa_swio11_dual_ee_ce_u4_hw    m325pa_swio12_dual_ee_ce_u4_hw    m3250_swio11_dual_ee_ce_u4_hw
 * m3250_swio12_dual_ee_ce_u4_hw     m3250a_swio11_dual_ee_ce_u4_hw    m3250a_swio12_dual_ee_ce_u4_hw
 * m3250p_swio11_dual_ee_ce_u4_hw    m3250p_swio12_dual_ee_ce_u4_hw    m3250pa_swio11_dual_ee_ce_u4_hw
 * m3250pa_swio12_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio11_dual_ee_ce_u4_hw[] = {
  0x17ddddda28d172df, 0xedf998bf84da2afb, 0xdd4d7aaf08673bc4, 0xadae2faf7683baca, 0x7377138abec5e713,
  0x0d5a1968e087877d, 0x62dde4b62776d6aa, 0x432cdcc13e301208, 0x9181bbada0644a4a, 0x774f8971030a1836,
  0x2f0e6e5afccb135a, 0xb9bd47c6ed87609c, 0xbe08a11c913f836b, 0x01b87c2886257f9f, 0x8655777bbe6e0aa0,
  0x36fb8a8432d08e48, 0x425b7a4affa039e1, 0x7fecf43982c3795e, 0x0ee2faa327528378, 0xb892c79e57d6072f,
  0xea3e12fc4361222f, 0x99e2ee3702c8cf5f, 0x795cae94ed6e6e6e, 0xefd47c1b307b7fd4, 0x8b34eb422814c57b,
  0x8ea426be8c2cb114, 0x31e8cf539d5db982, 0x1b1aaf1b1d7a8976, 0x9662e121146948e2, 0xaa8d8226470decbe,
  0xbe77715252cf2288, 0x141daf2e556b3f8a, 0x73a8a9546bb9c673, 0xc0809caed52df576, 0x434ae5e97f488735,
  0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021, 0x36d8c4c76f62aa8b, 0xa0bb1b8f3612e65f,
  0xfef0f7bca1854e7e, 0x7993fc0fe32fcc4f, 0x68f45fe07efd8668, 0x0271964b867a617c, 0xfb9a19961d252d9f,
  0x075d58cd017d3c95,
};

/*
 * m329a_swio13_noled                m329p_swio13_noled                m329pa_swio13_noled
 * m3290_swio13_noled                m3290a_swio13_noled               m3290p_swio13_noled
 * m3290pa_swio13_noled              m325_swio13_noled                 m325a_swio13_noled
 * m325p_swio13_noled                m325pa_swio13_noled               m3250_swio13_noled
 * m3250a_swio13_noled               m3250p_swio13_noled               m3250pa_swio13_noled
 */
static const uint64_t ur_m329_swio13_noled[] = {
  0x3ddbbbbbbacdfc4f, 0xf5bbb5572285ee25, 0xf4b8eea1c4891844, 0xe17f43bb89dd9fc1, 0xa3504db632b4dd9e,
  0x120862dde4eec2f5, 0xdfa1e7cc7cc13e30, 0x4277cb749283b7ff, 0x5e38e9fc1f3dea3c, 0x68e62c05bdd3694b,
  0x8c11d78b9dae1a32, 0xe5caad4acaffb8e5, 0x2a8d7738ce6283b5, 0x6a96faa9bece7515, 0x6af7afa4439ace57,
  0x73daad115e588695, 0x4e02ca54fa779fad, 0xfdc5021696173a9d, 0xf36d38c6f19d1022, 0x727e7f61bb612e65,
  0x9289c6592e19e985, 0x7ee6866587494b65, 0x0001522e35c7cf25,
};

/*
 * m329_swio13_noled_pr_u4           m329a_swio13_noled_pr             m329a_swio13_noled_pr_u4
 * m329p_swio13_noled_pr             m329p_swio13_noled_pr_u4          m329pa_swio13_noled_pr
 * m329pa_swio13_noled_pr_u4         m3290_swio13_noled_pr             m3290_swio13_noled_pr_u4
 * m3290a_swio13_noled_pr            m3290a_swio13_noled_pr_u4         m3290p_swio13_noled_pr
 * m3290p_swio13_noled_pr_u4         m3290pa_swio13_noled_pr           m3290pa_swio13_noled_pr_u4
 * m325_swio13_noled_pr              m325_swio13_noled_pr_u4           m325a_swio13_noled_pr
 * m325a_swio13_noled_pr_u4          m325p_swio13_noled_pr             m325p_swio13_noled_pr_u4
 * m325pa_swio13_noled_pr            m325pa_swio13_noled_pr_u4         m3250_swio13_noled_pr
 * m3250_swio13_noled_pr_u4          m3250a_swio13_noled_pr            m3250a_swio13_noled_pr_u4
 * m3250p_swio13_noled_pr            m3250p_swio13_noled_pr_u4         m3250pa_swio13_noled_pr
 * m3250pa_swio13_noled_pr_u4
 */
static const uint64_t ur_m329_swio13_noled_pr[] = {
  0x27777776891190e3, 0x1776aae453c7c492, 0x3d537bab21c6c13c, 0xb358d0600266f259, 0xac7c2f1afba913a0,
  0xef277448b333761b, 0x7f2609f180904316, 0x83f282657f9e059f, 0xf07d07a8f2f8ef96, 0x16594d1ef4a8e3a7,
  0x1f3b4428f7b398b0, 0x49a5403ff6608ebd, 0x55abeb703cb3db11, 0xaee719cc5076bcb9, 0xdf5537d9cea2a551,
  0xf5f4887359caed52, 0x55a22bcb10d2ad5e, 0x29e1a779f16bae7b, 0xc6f19d1020eea6c5, 0x2adec5551696d138,
  0x83cd84b997cdb192, 0x07e50d1637c5c9ab, 0x2861539fa9d598f2, 0xf8cbf313ffbc3def, 0x1fbf619a1e64ff03,
  0xe19e985f1a3d17f8, 0x87494b67c09c6592, 0xd1014f257ee68665, 0x0000000001f26a9a,
};

/*
 * m329a_swio13_noled_pr_ee          m329p_swio13_noled_pr_ee          m329pa_swio13_noled_pr_ee
 * m3290_swio13_noled_pr_ee          m3290a_swio13_noled_pr_ee         m3290p_swio13_noled_pr_ee
 * m3290pa_swio13_noled_pr_ee        m325_swio13_noled_pr_ee           m325a_swio13_noled_pr_ee
 * m325p_swio13_noled_pr_ee          m325pa_swio13_noled_pr_ee         m3250_swio13_noled_pr_ee
 * m3250a_swio13_noled_pr_ee         m3250p_swio13_noled_pr_ee         m3250pa_swio13_noled_pr_ee
 */
static const uint64_t ur_m329_swio13_noled_pr_ee[] = {
  0xfdddddd0f5a22a20, 0xdddaabf0bd45893a, 0x7be477c7edbe6e64, 0x86d1337aed2c90a6, 0xb452b620da09d7d6,
  0x7747b16a4771a8d2, 0x609f180904316ef2, 0xa0c56ff3c0b3e4ea, 0x3caca5cd56b46fe4, 0x87ea3e0d98309fea,
  0x459a75a1143be2b2, 0x64d2135f4616588a, 0x3c90e756974acb8d, 0xaad743af3a6edd42, 0x5c24228f911c1fb1,
  0xb047eb70decb65cc, 0x2e556a0174982d51, 0x546bb9c673141daf, 0x54b7d54df673a8a9, 0x57bd7d221cd672bb,
  0x9ed5688af2c434ab, 0xb14a7869de7c5aeb, 0x4e31bc6744083ba9, 0x648ab7b15545a5b4, 0x6ae0f3612e65f36c,
  0xe40fca1a2ce9f172, 0xfe50c2a73f53ab31, 0x87993fc5ce32fcc4, 0xa615c9f8e7bff826, 0x52d9f0271964b867,
  0x53c95fb9a19961d2, 0x0000000275f18c40,
};

/*
 * m329a_swio13_noled_pr_ee_u4       m329p_swio13_noled_pr_ee_u4       m329pa_swio13_noled_pr_ee_u4
 * m3290_swio13_noled_pr_ee_u4       m3290a_swio13_noled_pr_ee_u4      m3290p_swio13_noled_pr_ee_u4
 * m3290pa_swio13_noled_pr_ee_u4     m325_swio13_noled_pr_ee_u4        m325a_swio13_noled_pr_ee_u4
 * m325p_swio13_noled_pr_ee_u4       m325pa_swio13_noled_pr_ee_u4      m3250_swio13_noled_pr_ee_u4
 * m3250a_swio13_noled_pr_ee_u4      m3250p_swio13_noled_pr_ee_u4      m3250pa_swio13_noled_pr_ee_u4
 */
static const uint64_t ur_m329_swio13_noled_pr_ee_u4[] = {
  0xc5eeeeeed12232a8, 0xb4eed55f85e85c4b, 0xd2eae3d1b6c47c49, 0xe4531d7c33c5ef4c, 0x8b41568106d05e2d,
  0xc9dd3ad1a848b3ea, 0x69827c602410c5bb, 0x5283beffcf02cfc5, 0xa8f2b74b355ad199, 0x721fd47c1b306807,
  0x148b34eb422877c5, 0x2899a426be8c2cb1, 0x28def39d5a5ea52e, 0x355ae875eba9bb4e, 0x170908a16ba3b876,
  0x8e93eb70decb8723, 0x673141daf2e556ab, 0xdf673a8a9546bb9c, 0x21cd672bb54b7d54, 0xaf2c434ab57bd7d2,
  0x9de7c5aeb9ed5688, 0x744083ba9b14a786, 0x15545a5b44e31bc6, 0x12e65f36c648ab7b, 0x3458df1726ae0f36,
  0x4e7ea75663c81f94, 0xcc4ffef0f7bca185, 0x86687993fc0fe32f, 0x617c68f45fe07efd, 0x2d9f0271964b867a,
  0x3c95fb9a19961d25, 0x00000013ae59c405,
};

/*
 * m329_swio13_noled_pr_ce_u4        m329a_swio13_noled_pr_ce          m329a_swio13_noled_pr_ce_u4
 * m329p_swio13_noled_pr_ce          m329p_swio13_noled_pr_ce_u4       m329pa_swio13_noled_pr_ce
 * m329pa_swio13_noled_pr_ce_u4      m3290_swio13_noled_pr_ce          m3290_swio13_noled_pr_ce_u4
 * m3290a_swio13_noled_pr_ce         m3290a_swio13_noled_pr_ce_u4      m3290p_swio13_noled_pr_ce
 * m3290p_swio13_noled_pr_ce_u4      m3290pa_swio13_noled_pr_ce        m3290pa_swio13_noled_pr_ce_u4
 * m325_swio13_noled_pr_ce           m325_swio13_noled_pr_ce_u4        m325a_swio13_noled_pr_ce
 * m325a_swio13_noled_pr_ce_u4       m325p_swio13_noled_pr_ce          m325p_swio13_noled_pr_ce_u4
 * m325pa_swio13_noled_pr_ce         m325pa_swio13_noled_pr_ce_u4      m3250_swio13_noled_pr_ce
 * m3250_swio13_noled_pr_ce_u4       m3250a_swio13_noled_pr_ce         m3250a_swio13_noled_pr_ce_u4
 * m3250p_swio13_noled_pr_ce         m3250p_swio13_noled_pr_ce_u4      m3250pa_swio13_noled_pr_ce
 * m3250pa_swio13_noled_pr_ce_u4
 */
static const uint64_t ur_m329_swio13_noled_pr_ce[] = {
  0xbdeeeeeed1222a20, 0xf8eed55e11069c48, 0x8fe9a5ddb6ebd83d, 0x9febf8f9fb0678ec, 0x1a8207ae486e97bd,
  0x16ef27747b16a8e3, 0x3fb3a609f1809043, 0xd76fca0caeff3c0b, 0x63cf00953bdf7717, 0x097e21b09117dc49,
  0x2ee372e4492bf51f, 0x3cdd3dcb19fac99e, 0xa9c638e9fc193dea, 0xb4428f7b398b014c, 0x5403ff6678ebd1f3,
  0xafadc0f2d6e1149a, 0x9c673141daf2e556, 0x54df673a8a9546bb, 0xd221cd672bb54b7d, 0x88af2c434ab57bd7,
  0x869de7c5aeb9ed56, 0xc6744083ba9b14a7, 0x7b15545a5b44e31b, 0x6c25ccbe6d8c863b, 0x2868b1be2e4d5c1e,
  0x0a9cfd4eacc7903f, 0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c,
  0x0a792bf734332c3a, 0x00000001bae9a088,
};

/*
 * m329a_swio13_noled_pr_ee_ce       m329p_swio13_noled_pr_ee_ce       m329pa_swio13_noled_pr_ee_ce
 * m3290_swio13_noled_pr_ee_ce       m3290a_swio13_noled_pr_ee_ce      m3290p_swio13_noled_pr_ee_ce
 * m3290pa_swio13_noled_pr_ee_ce     m325_swio13_noled_pr_ee_ce        m325a_swio13_noled_pr_ee_ce
 * m325p_swio13_noled_pr_ee_ce       m325pa_swio13_noled_pr_ee_ce      m3250_swio13_noled_pr_ee_ce
 * m3250a_swio13_noled_pr_ee_ce      m3250p_swio13_noled_pr_ee_ce      m3250pa_swio13_noled_pr_ee_ce
 */
static const uint64_t ur_m329_swio13_noled_pr_ee_ce[] = {
  0x02fddddddd447705, 0x88bbb557b0a4bb89, 0xb89db93b504b2631, 0xfe3eb47a7c94c4d0, 0x5c11236460cb5605,
  0xde4eed86d94f5926, 0x4d4c13e30120862d, 0x4b941ff9fe78167f, 0x00953bff877fd519, 0x4e771b9950d07fcf,
  0xace1ca76b2b1ef98, 0xf51f06cc19ebea3c, 0xcd3ad08a05315975, 0xa909afa30b2c4522, 0x423c90e7576e4ac3,
  0x6355e363af3a6edd, 0x98b848451f22383f, 0x51b044c8e1bd96cb, 0xaf2e556a59f4982d, 0xa9546bb9c673141d,
  0xbb54b7d54df673a8, 0xab57bd7d221cd672, 0xeb9ed5688af2c434, 0xa9b14a7869de7c5a, 0xb44e31bc6744083b,
  0xd8c863b7b15545a5, 0xe2e4d5c6c25ccbe6, 0xd598f207e50d163c, 0x8cb25c33d30ae4fd, 0x0ccb0e9296cb2513,
  0x31e5e2029e4afdcd, 0x000000000000014d,
};

/*
 * m329a_swio13_noled_pr_ee_ce_u4    m329p_swio13_noled_pr_ee_ce_u4    m329pa_swio13_noled_pr_ee_ce_u4
 * m3290_swio13_noled_pr_ee_ce_u4    m3290a_swio13_noled_pr_ee_ce_u4   m3290p_swio13_noled_pr_ee_ce_u4
 * m3290pa_swio13_noled_pr_ee_ce_u4  m325_swio13_noled_pr_ee_ce_u4     m325a_swio13_noled_pr_ee_ce_u4
 * m325p_swio13_noled_pr_ee_ce_u4    m325pa_swio13_noled_pr_ee_ce_u4   m3250_swio13_noled_pr_ee_ce_u4
 * m3250a_swio13_noled_pr_ee_ce_u4   m3250p_swio13_noled_pr_ee_ce_u4   m3250pa_swio13_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio13_noled_pr_ee_ce_u4[] = {
  0x09bbbbbb448692df, 0xc5ddaabfa9d89892, 0x3d7adba34f1782fc, 0x4c2a0006713ae0fd, 0xcdd333582165b3d0,
  0xde4eea8fa10abe26, 0x374c13e30120862d, 0x74a0b5dffd8aecfe, 0x6d01c6bbb8bea8f6, 0x1b09117dc4963cf3,
  0xb82e1fff51f097e2, 0x6b736f7ccf1771b8, 0xc19ebea3cace1ca7, 0xa05315975f51f06c, 0x30b2c4522cd3ad08,
  0x7576e4ac3a909afa, 0x3af3a6edd423c90e, 0x51f22383f6355e36, 0x8e1bd96cb98b8484, 0xa59f4982d51b044c,
  0x9c673141daf2e556, 0x54df673a8a9546bb, 0xd221cd672bb54b7d, 0x88af2c434ab57bd7, 0x869de7c5aeb9ed56,
  0xc6744083ba9b14a7, 0x7b15545a5b44e31b, 0x6c25ccbe6d8c863b, 0xf83bb8d1637c371e, 0xf2861539fa9d599b,
  0x3f8cbf313ffbc3de, 0x81fbf619a1e64ff0, 0x2e19e985f1a3d17f, 0x587494b67c09c659, 0x71ba2cf257ee6866,
  0x000000000009f832,
};

/*
 * m329a_swio13_noled_ee_hw          m329p_swio13_noled_ee_hw          m329pa_swio13_noled_ee_hw
 * m3290_swio13_noled_ee_hw          m3290a_swio13_noled_ee_hw         m3290p_swio13_noled_ee_hw
 * m3290pa_swio13_noled_ee_hw        m325_swio13_noled_ee_hw           m325a_swio13_noled_ee_hw
 * m325p_swio13_noled_ee_hw          m325pa_swio13_noled_ee_hw         m3250_swio13_noled_ee_hw
 * m3250a_swio13_noled_ee_hw         m3250p_swio13_noled_ee_hw         m3250pa_swio13_noled_ee_hw
 */
static const uint64_t ur_m329_swio13_noled_ee_hw[] = {
  0xd7eeeeeed1219541, 0x26eed55f85ea2c49, 0x0da67bbe3f6df373, 0x7d686d1337aed2c9, 0x8d2b452b620da09d,
  0x2dde4ee80a499a73, 0x7c9d4c13e3012086, 0xa37f25062b7fd0a6, 0x84ff51e5652e6ab5, 0xdf15943f51f06cc1,
  0xb2c4522cd3ad08a1, 0x565c6b26909afa30, 0x76ea11e4873ab4ba, 0xe0fd8d56ba1d79d3, 0x5b2e62e121147c88,
  0xc16a8d823f5b86f6, 0xa0ed7972ab500ba4, 0x9d454aa35dce3398, 0xb395daa5beaa6fb3, 0x21a55abdebe910e6,
  0xe2d75cf6ab445796, 0x41dd4d8a53c34ef3, 0x2d2da2718de33a20, 0x2f9b632455bd8aaa, 0x3f505d8dc79b0973,
  0x27ff787bde50c2a7, 0x343cc9fe07f197e6, 0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30, 0x4afdcd0ccb0e9296,
  0x000002dffc93a29e,
};

/*
 * m329_swio13_noled_ee_ce_u4_hw     m329a_swio13_noled_ee_ce_hw       m329a_swio13_noled_ee_ce_u4_hw
 * m329p_swio13_noled_ee_ce_hw       m329p_swio13_noled_ee_ce_u4_hw    m329pa_swio13_noled_ee_ce_hw
 * m329pa_swio13_noled_ee_ce_u4_hw   m3290_swio13_noled_ee_ce_hw       m3290_swio13_noled_ee_ce_u4_hw
 * m3290a_swio13_noled_ee_ce_hw      m3290a_swio13_noled_ee_ce_u4_hw   m3290p_swio13_noled_ee_ce_hw
 * m3290p_swio13_noled_ee_ce_u4_hw   m3290pa_swio13_noled_ee_ce_hw     m3290pa_swio13_noled_ee_ce_u4_hw
 * m325_swio13_noled_ee_ce_hw        m325_swio13_noled_ee_ce_u4_hw     m325a_swio13_noled_ee_ce_hw
 * m325a_swio13_noled_ee_ce_u4_hw    m325p_swio13_noled_ee_ce_hw       m325p_swio13_noled_ee_ce_u4_hw
 * m325pa_swio13_noled_ee_ce_hw      m325pa_swio13_noled_ee_ce_u4_hw   m3250_swio13_noled_ee_ce_hw
 * m3250_swio13_noled_ee_ce_u4_hw    m3250a_swio13_noled_ee_ce_hw      m3250a_swio13_noled_ee_ce_u4_hw
 * m3250p_swio13_noled_ee_ce_hw      m3250p_swio13_noled_ee_ce_u4_hw   m3250pa_swio13_noled_ee_ce_hw
 * m3250pa_swio13_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio13_noled_ee_ce_hw[] = {
  0x04dddddda2436812, 0x62eed55fd4ec4c49, 0x9ebd6dd1a78bc17e, 0x26150003389d707e, 0xe6e999ac10b2d9e8,
  0x16ef27777ec2da9a, 0x7f1ba609f1809043, 0x8f674a0b5dffd0a6, 0xcf36d01c6bbb8bea, 0x7e21b09117dc4963,
  0x373907575ff51f09, 0x94ed6e6def99e2ee, 0x0d9833d7d47959c3, 0xa1140a62b2ebea3e, 0x5f4616588a459a75,
  0x21ceaedc95875213, 0xc6c75e74ddba8479, 0x908a3e44707ec6ab, 0x8991c37b2d973170, 0xaad4b3e9305aa360,
  0xd7738ce6283b5e5c, 0x6faa9bece75152a8, 0x7afa4439ace576a9, 0xaad115e5886956af, 0x94f0d3bcf8b5d73d,
  0x6378ce8810775362, 0xc76f62aa8b4b689c, 0xe3cd84b997cdb190, 0xef2861539fa82ec6, 0x03f8cbf313ffbc3d,
  0xf81fbf619a1e64ff, 0x92e19e985f1a3d17, 0x6587494b67c09c65, 0x864e514f257ee686, 0x0000000000000280,
};

/*
 * m329a_swio13_lednop               m329p_swio13_lednop               m329pa_swio13_lednop
 * m3290_swio13_lednop               m3290a_swio13_lednop              m3290p_swio13_lednop
 * m3290pa_swio13_lednop             m325_swio13_lednop                m325a_swio13_lednop
 * m325p_swio13_lednop               m325pa_swio13_lednop              m3250_swio13_lednop
 * m3250a_swio13_lednop              m3250p_swio13_lednop              m3250pa_swio13_lednop
 */
static const uint64_t ur_m329_swio13_lednop[] = {
  0xa7bb77777759bb37, 0x4f5bbb5572295a44, 0xbf7c7eefaff0b184, 0xf70bfa1ddc4ed09b, 0x21a6c401b6f8feec,
  0x0904316ef2776c7b, 0xefd0f3f01a609f18, 0x243be5ba49410f7f, 0x631c74fe0f9ef51f, 0xa4398b016f74dd42,
  0xb1823af173b08a8f, 0xbcb955a95982f71c, 0xa551aee719cc5076, 0xed52df5537d9cea2, 0x97f488735c0809ca,
  0x6ab44579621a5724, 0xb5e5380b9d01e5cf, 0xd14085a561130bd4, 0x6da718de33a20517, 0x4fcfec376c25ccbe,
  0x5138cb25c33d30ae, 0xdcd0ccb0e9296cb2, 0x00549f5eb8f9e4af,
};

/*
 * m329_swio13_lednop_pr_u4          m329a_swio13_lednop_pr            m329a_swio13_lednop_pr_u4
 * m329p_swio13_lednop_pr            m329p_swio13_lednop_pr_u4         m329pa_swio13_lednop_pr
 * m329pa_swio13_lednop_pr_u4        m3290_swio13_lednop_pr            m3290_swio13_lednop_pr_u4
 * m3290a_swio13_lednop_pr           m3290a_swio13_lednop_pr_u4        m3290p_swio13_lednop_pr
 * m3290p_swio13_lednop_pr_u4        m3290pa_swio13_lednop_pr          m3290pa_swio13_lednop_pr_u4
 * m325_swio13_lednop_pr             m325_swio13_lednop_pr_u4          m325a_swio13_lednop_pr
 * m325a_swio13_lednop_pr_u4         m325p_swio13_lednop_pr            m325p_swio13_lednop_pr_u4
 * m325pa_swio13_lednop_pr           m325pa_swio13_lednop_pr_u4        m3250_swio13_lednop_pr
 * m3250_swio13_lednop_pr_u4         m3250a_swio13_lednop_pr           m3250a_swio13_lednop_pr_u4
 * m3250p_swio13_lednop_pr           m3250p_swio13_lednop_pr_u4        m3250pa_swio13_lednop_pr
 * m3250pa_swio13_lednop_pr_u4
 */
static const uint64_t ur_m329_swio13_lednop_pr[] = {
  0x277777768911d38b, 0x1776aae45017c492, 0x86ad1a6d7af6c13c, 0x59ac683e3e00f164, 0x4f4da9b11dd489d0,
  0x7793ba8cca734b29, 0xa95304f8c048218b, 0x07e504c7ff9e059f, 0xf07d07a8fa51df2d, 0x2cb29a0304f8e3a7,
  0x3e765f11c6473160, 0xb86a807fecc11d7a, 0xad6e1c81e59ed8df, 0x7738ce6283b5e5ca, 0xfaa9bece75152a8d,
  0x439ae0404e576a96, 0x2bcb10d2b924bfa4, 0x4078e56bae7b55a2, 0x440842a417296be7, 0xaaa2d2414e31bc67,
  0x5ccbe6da05455bd8, 0x8b1be2e4d5c1e6c2, 0xcfd4eacc7903f286, 0x89ffde1ef79430a9, 0xcd0f327f81fc65f9,
  0x2f8d1e8bfc0fdfb0, 0xb3e04e32c970cf4c, 0x92bf734332c3a4a5, 0x0000f93fea8880a7,
};

/*
 * m329a_swio13_lednop_pr_ee         m329p_swio13_lednop_pr_ee         m329pa_swio13_lednop_pr_ee
 * m3290_swio13_lednop_pr_ee         m3290a_swio13_lednop_pr_ee        m3290p_swio13_lednop_pr_ee
 * m3290pa_swio13_lednop_pr_ee       m325_swio13_lednop_pr_ee          m325a_swio13_lednop_pr_ee
 * m325p_swio13_lednop_pr_ee         m325pa_swio13_lednop_pr_ee        m3250_swio13_lednop_pr_ee
 * m3250a_swio13_lednop_pr_ee        m3250p_swio13_lednop_pr_ee        m3250pa_swio13_lednop_pr_ee
 */
static const uint64_t ur_m329_swio13_lednop_pr_ee[] = {
  0x7eeeeeeea0a22044, 0x6eed55f85c8fc49d, 0x0ef4ed85f0073732, 0xa1b44cea2bd76416, 0x2b8cdd88368275f5,
  0x9dd4149c8c884331, 0x9827c602410c5bbc, 0x504e0ff9e059fa1f, 0x1e56a7a6ab5a37f2, 0x04f51f06cc184ff5,
  0x22cd3ad08a1df15e, 0xb26909afa30b2c45, 0x182873ab4bc875c6, 0xd56ba1d79d376ee9, 0x2e121144dc8f22d8,
  0xd823f5b86f65b2e6, 0xcb955a80422934a8, 0x551aee719cc5076b, 0xd52df5537d9cea2a, 0x7f488735c0809cae,
  0xab44579621a57249, 0xd7ce80f1cad75cf6, 0x78ce881085482e52, 0xb7b15545a4829c63, 0xcd84b997cdb40a8a,
  0x2868b2d5e5c9ab83, 0x0a9cfd4eacc7903f, 0xe687993fc09c6943, 0x592e19e985727e03, 0x66587494b67c09c6,
  0xf8431014f257ee68, 0x000000000000013a,
};

/*
 * m329a_swio13_lednop_pr_ee_u4      m329p_swio13_lednop_pr_ee_u4      m329pa_swio13_lednop_pr_ee_u4
 * m3290_swio13_lednop_pr_ee_u4      m3290a_swio13_lednop_pr_ee_u4     m3290p_swio13_lednop_pr_ee_u4
 * m3290pa_swio13_lednop_pr_ee_u4    m325_swio13_lednop_pr_ee_u4       m325a_swio13_lednop_pr_ee_u4
 * m325p_swio13_lednop_pr_ee_u4      m325pa_swio13_lednop_pr_ee_u4     m3250_swio13_lednop_pr_ee_u4
 * m3250a_swio13_lednop_pr_ee_u4     m3250p_swio13_lednop_pr_ee_u4     m3250pa_swio13_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_swio13_lednop_pr_ee_u4[] = {
  0xc5eeeeeed1222a20, 0xb4eed55f85c19c4b, 0xc8fe9a5d2e233c49, 0xe2de4531d7eb20a6, 0x6a081eb9bb106d05,
  0x5bbc9dd1ec5aa38c, 0xfa1f9827c602410c, 0x332a504e0ff9e059, 0x00f51e5670e6ab5a, 0xf8adc9fa8f83660d,
  0x962291669d68450e, 0xb5c5133484d7d185, 0x65f11c4273ab4baf, 0x16c6ab5d0ebd7537, 0x723170908a06fa31,
  0xd570b3feb70decb8, 0x738ce6283b5e5caa, 0xaa9bece75152a8d7, 0x39ae0404e576a96f, 0xbcb10d2b924bfa44,
  0xe80f3f5ae7b55a22, 0x6ae757a96165362c, 0xe33a204e7d14085a, 0xe6c25ccbe6da718d, 0xf2868b1be2e4d5c1,
  0x30a9cfd4eacc7903, 0x65f989ffde1ef794, 0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970,
  0x80a792bf734332c3, 0x0000000013ae9a08,
};

/*
 * m329a_swio13_lednop_pr_ce         m329p_swio13_lednop_pr_ce         m329pa_swio13_lednop_pr_ce
 * m3290_swio13_lednop_pr_ce         m3290a_swio13_lednop_pr_ce        m3290p_swio13_lednop_pr_ce
 * m3290pa_swio13_lednop_pr_ce       m325_swio13_lednop_pr_ce          m325a_swio13_lednop_pr_ce
 * m325p_swio13_lednop_pr_ce         m325pa_swio13_lednop_pr_ce        m3250_swio13_lednop_pr_ce
 * m3250a_swio13_lednop_pr_ce        m3250p_swio13_lednop_pr_ce        m3250pa_swio13_lednop_pr_ce
 */
static const uint64_t ur_m329_swio13_lednop_pr_ce[] = {
  0xbdddddd0f5a22044, 0x1ddaabc225058917, 0x9e989d803d2b07bf, 0xfebf8f8d33f6a6fe, 0x1b45a8ac86e97bd9,
  0xdde4eea0a4e57042, 0xc6b4c13e30120862, 0xedf941d37fe78167, 0x79e012a77b3ae2fa, 0x2fc4361222fb892c,
  0xdc6e2545c8fea3e1, 0x9c67b9633f5933c5, 0x7ac71d3f8327bd47, 0xbe238c8e62c0531e, 0x00ffd99e3af47cec,
  0x0e40f2d6e1bf70d5, 0x673141daf2e556b7, 0xdf673a8a9546bb9c, 0x7020272bb54b7d54, 0x88695c925fd221cd,
  0x72b5d73daad115e5, 0x21520b94b5f3a03c, 0x6920a718de33a204, 0xe6da0518edec5551, 0xe2e4d5c1e6c25ccb,
  0x5663c81f943459d3, 0xf989fca1854e7ea7, 0xf04d0f327f8b9c65, 0x70cf4c2b93f1cf7f, 0xc3a4a5b3e04e32c9,
  0xe880a792bf734332, 0x00000000000dd7e9,
};

/*
 * m329a_swio13_lednop_pr_ce_u4      m329p_swio13_lednop_pr_ce_u4      m329pa_swio13_lednop_pr_ce_u4
 * m3290_swio13_lednop_pr_ce_u4      m3290a_swio13_lednop_pr_ce_u4     m3290p_swio13_lednop_pr_ce_u4
 * m3290pa_swio13_lednop_pr_ce_u4    m325_swio13_lednop_pr_ce_u4       m325a_swio13_lednop_pr_ce_u4
 * m325p_swio13_lednop_pr_ce_u4      m325pa_swio13_lednop_pr_ce_u4     m3250_swio13_lednop_pr_ce_u4
 * m3250a_swio13_lednop_pr_ce_u4     m3250p_swio13_lednop_pr_ce_u4     m3250pa_swio13_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_swio13_lednop_pr_ce_u4[] = {
  0x9beeeeeed1222044, 0x3eeed55e11219c4b, 0x6475a2efa5ad14cc, 0x83f85d098bcd8b1f, 0x10deb8d3537bbcdf,
  0x16ef277505272e9c, 0x3f6ea609f1809043, 0xea7aca0e04ff3c0b, 0xb1e7804a9de56b8b, 0x84bf10d8488bee24,
  0x1771b8951723fa8f, 0x7c927b9633f19ccf, 0x8148e3a7f0621fd4, 0xcf7a3b58e62c05ee, 0x45dc72c678ebc5ce,
  0xcc5076bcb955a8e8, 0xd9cea2a551aee719, 0x0809caed52df5537, 0x1a572497f488735c, 0xad75cf6ab4457962,
  0x5482e52d7ce80f1c, 0x4829c6378ce88108, 0xb681463b7b15545a, 0xb9357079b09732f9, 0xb31e40fca1a2c6f8,
  0x87bde50c2a73f53a, 0x9fe07f197e627ff7, 0xa2ff03f7ec3343cc, 0x8cb25c33d30be347, 0xd0ccb0e9296cf813,
  0xd7ab2a2029e4afdc, 0x000000000000000d,
};

/*
 * m329a_swio13_lednop_pr_ee_ce      m329p_swio13_lednop_pr_ee_ce      m329pa_swio13_lednop_pr_ee_ce
 * m3290_swio13_lednop_pr_ee_ce      m3290a_swio13_lednop_pr_ee_ce     m3290p_swio13_lednop_pr_ee_ce
 * m3290pa_swio13_lednop_pr_ee_ce    m325_swio13_lednop_pr_ee_ce       m325a_swio13_lednop_pr_ee_ce
 * m325p_swio13_lednop_pr_ee_ce      m325pa_swio13_lednop_pr_ee_ce     m3250_swio13_lednop_pr_ee_ce
 * m3250a_swio13_lednop_pr_ee_ce     m3250p_swio13_lednop_pr_ee_ce     m3250pa_swio13_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_swio13_lednop_pr_ee_ce[] = {
  0x817eeeeeeea22044, 0xc45ddaabd8520dc4, 0x82c4ec0bd3630a18, 0xbfc7d68f4e5df250, 0x389c8ccd2c196ac0,
  0xbbc9dd4149c80504, 0xb5b9827c602410c5, 0xa5ca0a6dff9e059f, 0x00953b4db3bfea8c, 0x4e771b8a49cdffcf,
  0xaca1ca76b2b1ef98, 0xf51f06cc19ebea3c, 0xcd3ad08a05315b05, 0xa909afa30b2c4522, 0xd23050e7576e90e3,
  0x6355e363af3a6edd, 0x98b8484513723c8b, 0x51b044c8e1bd96cb, 0xd7972ab52cc45269, 0x54aa35dce3398a0e,
  0x5daa5beaa6fb39d4, 0x92fe910e6b810139, 0xed5688af2c434ae4, 0xa5af9d01e395aeb9, 0xc6f19d10210a905c,
  0xc76f62aa8b490538, 0xae3612e65f36d028, 0x903f2868b1e71726, 0xe19e985727eeacc7, 0x7494b659289c6592,
  0x1014f257ee686658, 0x0000000000a69e37,
};

/*
 * m329a_swio13_lednop_pr_ee_ce_u4   m329p_swio13_lednop_pr_ee_ce_u4   m329pa_swio13_lednop_pr_ee_ce_u4
 * m3290_swio13_lednop_pr_ee_ce_u4   m3290a_swio13_lednop_pr_ee_ce_u4  m3290p_swio13_lednop_pr_ee_ce_u4
 * m3290pa_swio13_lednop_pr_ee_ce_u4 m325_swio13_lednop_pr_ee_ce_u4    m325a_swio13_lednop_pr_ee_ce_u4
 * m325p_swio13_lednop_pr_ee_ce_u4   m325pa_swio13_lednop_pr_ee_ce_u4  m3250_swio13_lednop_pr_ee_ce_u4
 * m3250a_swio13_lednop_pr_ee_ce_u4  m3250p_swio13_lednop_pr_ee_ce_u4  m3250pa_swio13_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio13_lednop_pr_ee_ce_u4[] = {
  0x09bbbbbb448650e3, 0xc5ddaabfa986e892, 0x1d015baf5cfd82fc, 0x4c2a000676262779, 0xdd914e8e2165b3d0,
  0x7793ba1607db29c2, 0x6b7304f8c048218b, 0xce941149ff62bb3e, 0x36d01c149717d51e, 0x21b09117dc4963cf,
  0x19ebf5abf51f097e, 0xed6e6def99e2ee37, 0x9833d7d479594394, 0x140a62b60bea3e0d, 0x4616588a459a75a1,
  0xceaedd21c752135f, 0xc75e74ddbba460a1, 0x8a26e47916c6abc6, 0x91c37b2d97317090, 0x6a5988a4d2a36089,
  0xb9c673141daf2e55, 0xd54df673a8a9546b, 0x1cd7020272bb54b7, 0x5e588695c925fd22, 0x03c72b5d73daad11,
  0x20421520b94b5f3a, 0x5516920a718de33a, 0xccbe6da0518edec5, 0xb8d1637c371e6c25, 0x1539fa9d599bf83b,
  0xbf313ffbc3def286, 0xf619a1e64ff03f8c, 0xe985f1a3d17f81fb, 0x94b67c09c6592e19, 0x2cf257ee68665874,
  0x00000013f01e4dba,
};

/*
 * m329a_swio13_lednop_ee_hw         m329p_swio13_lednop_ee_hw         m329pa_swio13_lednop_ee_hw
 * m3290_swio13_lednop_ee_hw         m3290a_swio13_lednop_ee_hw        m3290p_swio13_lednop_ee_hw
 * m3290pa_swio13_lednop_ee_hw       m325_swio13_lednop_ee_hw          m325a_swio13_lednop_ee_hw
 * m325p_swio13_lednop_ee_hw         m325pa_swio13_lednop_ee_hw        m3250_swio13_lednop_ee_hw
 * m3250a_swio13_lednop_ee_hw        m3250p_swio13_lednop_ee_hw        m3250pa_swio13_lednop_ee_hw
 */
static const uint64_t ur_m329_swio13_lednop_ee_hw[] = {
  0xebf777776890c582, 0x93776aafc2e47e24, 0x43560eec2f8039b9, 0x5f5a1b44cea2bd76, 0xa312b8cdd8836827,
  0x8b7793ba76821e96, 0x3f43f304f8c04821, 0xd1bf9282707fe853, 0xc27fa8f2b53d355a, 0xef8af027a8f83660,
  0x5962291669d68450, 0x43ae3593484d7d18, 0xbb7748c1439d5a5e, 0x7916c6ab5d0ebce9, 0x2d973170908a26e4,
  0x49a546c11fadc37b, 0x283b5e5caad40211, 0xe75152a8d7738ce6, 0x04e576a96faa9bec, 0x2b924bfa4439ae04,
  0xbae7b55a22bcb10d, 0x417296be74078e56, 0x14e31bc67440842a, 0xa05455bd8aaa2d24, 0x76371e6c25ccbe6d,
  0xe1ef79430a9cfd41, 0x27f81fc65f989ffd, 0xe8bfc0fdfb0cd0f3, 0xe32c970cf4c2f8d1, 0x34332c3a4a5b3e04,
  0x0b7e6a728a792bf7,
};

/*
 * m329_swio13_lednop_ee_ce_u4_hw    m329a_swio13_lednop_ee_ce_hw      m329a_swio13_lednop_ee_ce_u4_hw
 * m329p_swio13_lednop_ee_ce_hw      m329p_swio13_lednop_ee_ce_u4_hw   m329pa_swio13_lednop_ee_ce_hw
 * m329pa_swio13_lednop_ee_ce_u4_hw  m3290_swio13_lednop_ee_ce_hw      m3290_swio13_lednop_ee_ce_u4_hw
 * m3290a_swio13_lednop_ee_ce_hw     m3290a_swio13_lednop_ee_ce_u4_hw  m3290p_swio13_lednop_ee_ce_hw
 * m3290p_swio13_lednop_ee_ce_u4_hw  m3290pa_swio13_lednop_ee_ce_hw    m3290pa_swio13_lednop_ee_ce_u4_hw
 * m325_swio13_lednop_ee_ce_hw       m325_swio13_lednop_ee_ce_u4_hw    m325a_swio13_lednop_ee_ce_hw
 * m325a_swio13_lednop_ee_ce_u4_hw   m325p_swio13_lednop_ee_ce_hw      m325p_swio13_lednop_ee_ce_u4_hw
 * m325pa_swio13_lednop_ee_ce_hw     m325pa_swio13_lednop_ee_ce_u4_hw  m3250_swio13_lednop_ee_ce_hw
 * m3250_swio13_lednop_ee_ce_u4_hw   m3250a_swio13_lednop_ee_ce_hw     m3250a_swio13_lednop_ee_ce_u4_hw
 * m3250p_swio13_lednop_ee_ce_hw     m3250p_swio13_lednop_ee_ce_u4_hw  m3250pa_swio13_lednop_ee_ce_hw
 * m3250pa_swio13_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio13_lednop_ee_ce_hw[] = {
  0x04dddddda243704a, 0x62eed55fd4c37449, 0x8e80add7ae7ec17e, 0x261500033b1313bc, 0xeec8a74710b2d9e8,
  0x5bbc9dd75bae3b5d, 0xf35b9827c602410c, 0x1ece941149ff4299, 0xcf36d01c149717d5, 0x7e21b09117dc4963,
  0x8dcf39753bf51f09, 0xe53b5b9b7be678bb, 0x83660cf5f51e5650, 0x68450298ad82fa8f, 0xd7d185962291669d,
  0x2873abb74871d484, 0xf1b1d79d376ee918, 0x242289b91e45b1aa, 0x226470decb65cc5c, 0x955a96622934a8d8,
  0x1aee719cc5076bcb, 0x2df5537d9cea2a55, 0x488735c0809caed5, 0x44579621a572497f, 0xce80f1cad75cf6ab,
  0xce881085482e52d7, 0xb15545a4829c6378, 0x09732f9b681463b7, 0xc2a73f505d8dc79b, 0x97e627ff787bde50,
  0x7ec3343cc9fe07f1, 0x3d30be347a2ff03f, 0x9296cf8138cb25c3, 0xa29e4afdcd0ccb0e, 0x000000000a020793,
};

/*
 * m329_swio13_dual_pr               m329_swio13_dual_pr_u4            m329a_swio13_dual
 * m329a_swio13_dual_pr              m329a_swio13_dual_pr_u4           m329p_swio13_dual
 * m329p_swio13_dual_pr              m329p_swio13_dual_pr_u4           m329pa_swio13_dual
 * m329pa_swio13_dual_pr             m329pa_swio13_dual_pr_u4          m3290_swio13_dual
 * m3290_swio13_dual_pr              m3290_swio13_dual_pr_u4           m3290a_swio13_dual
 * m3290a_swio13_dual_pr             m3290a_swio13_dual_pr_u4          m3290p_swio13_dual
 * m3290p_swio13_dual_pr             m3290p_swio13_dual_pr_u4          m3290pa_swio13_dual
 * m3290pa_swio13_dual_pr            m3290pa_swio13_dual_pr_u4         m325_swio13_dual
 * m325_swio13_dual_pr               m325_swio13_dual_pr_u4            m325a_swio13_dual
 * m325a_swio13_dual_pr              m325a_swio13_dual_pr_u4           m325p_swio13_dual
 * m325p_swio13_dual_pr              m325p_swio13_dual_pr_u4           m325pa_swio13_dual
 * m325pa_swio13_dual_pr             m325pa_swio13_dual_pr_u4          m3250_swio13_dual
 * m3250_swio13_dual_pr              m3250_swio13_dual_pr_u4           m3250a_swio13_dual
 * m3250a_swio13_dual_pr             m3250a_swio13_dual_pr_u4          m3250p_swio13_dual
 * m3250p_swio13_dual_pr             m3250p_swio13_dual_pr_u4          m3250pa_swio13_dual
 * m3250pa_swio13_dual_pr            m3250pa_swio13_dual_pr_u4
 */
static const uint64_t ur_m329_swio13_dual[] = {
  0xa7bbbbbb44869a4e, 0x7e276fc75e10cdaf, 0xb9f7ba8ce5dd0b69, 0x1fc5fc95264e2765, 0xe19628d4d8b77e99,
  0x2b43bb8fea3151f1, 0x304f8c048218b779, 0xdd6d032252522e87, 0x4b881850c1b48c0d, 0x3393fccae833ba7c,
  0xea3bf9b05f67028b, 0x114239227f06654d, 0x70f8510c4aff3f7c, 0x2abbbddf37200003, 0xb5a2a10cb4232443,
  0x25b7287ff4073c26, 0xbfdcd7982c3795e4, 0x7dbe77cb3df283fb, 0x47b8e3a7f0707fd4, 0x884e62c05507992b,
  0xb30475e00ceda523, 0xe59eda63192a01ff, 0x157ceee2a4b81281, 0xe6283b5e5caad67f, 0xece75152a8d7738c,
  0x0404e576a96faa9b, 0x0d2b924bfa4439ae, 0x56bae7b55a22bcb1, 0x2a417296be74078e, 0x2414e31bc6744084,
  0x6da05455bd8aaa2d, 0x637c371e6c25ccbe, 0xfa9d599bf83bb8d1, 0x3ffbc3def2861539, 0xa1e64ff03f8cbf31,
  0xf1a3d17f81fbf619, 0x7c09c6592e19e985, 0x57ee6866587494b6, 0x002927bc15ba2cf2,
};

/*
 * m329a_swio13_dual_pr_ee           m329p_swio13_dual_pr_ee           m329pa_swio13_dual_pr_ee
 * m3290_swio13_dual_pr_ee           m3290a_swio13_dual_pr_ee          m3290p_swio13_dual_pr_ee
 * m3290pa_swio13_dual_pr_ee         m325_swio13_dual_pr_ee            m325a_swio13_dual_pr_ee
 * m325p_swio13_dual_pr_ee           m325pa_swio13_dual_pr_ee          m3250_swio13_dual_pr_ee
 * m3250a_swio13_dual_pr_ee          m3250p_swio13_dual_pr_ee          m3250pa_swio13_dual_pr_ee
 */
static const uint64_t ur_m329_swio13_dual_pr_ee[] = {
  0x00addddddd43573e, 0xc8f89dbf1a99366d, 0x5f47e6ea729c502c, 0x4f59198f6d9beec7, 0xf700faabc99bd701,
  0xe772e2fbb0af7aca, 0x3e30120862dde4f4, 0x6819129290e9d4c1, 0x40c2860da4606eeb, 0xffe657419dd3e25c,
  0x275b04b4700b5318, 0x8e489fc1c569bd47, 0x144312bfcfdf0450, 0xbddf373bac00dc3e, 0x4219682fb4432abb,
  0xedffd01cf0983dc5, 0xbcc161bcaf212dbc, 0x5a3727283d3ffee6, 0x1c7bf51e57a6e6ab, 0x1df15ecef51f06cc,
  0x0b2c4522cd3ad08a, 0xa797152e6909afa3, 0x5d9fc47d41cead2e, 0x1fc96355ae875ea2, 0x97d2cc5c242283d5,
  0x9bdaa3608fd6e1bd, 0xf157ceee2a4a010f, 0xce6283b5e5caad67, 0xbece75152a8d7738, 0xe0404e576a96faa9,
  0x10d2b924bfa4439a, 0xe56bae7b55a22bcb, 0x42a417296be74078, 0xd2414e31bc674408, 0xe6da05455bd8aaa2,
  0x2c79c371e6c25ccb, 0xc9fbab337f07771a, 0xf0271964b867a615, 0x5fb9a19961d252d9, 0x00c852c7f6e8b3c9,
};

/*
 * m329a_swio13_dual_pr_ee_u4        m329p_swio13_dual_pr_ee_u4        m329pa_swio13_dual_pr_ee_u4
 * m3290_swio13_dual_pr_ee_u4        m3290a_swio13_dual_pr_ee_u4       m3290p_swio13_dual_pr_ee_u4
 * m3290pa_swio13_dual_pr_ee_u4      m325_swio13_dual_pr_ee_u4         m325a_swio13_dual_pr_ee_u4
 * m325p_swio13_dual_pr_ee_u4        m325pa_swio13_dual_pr_ee_u4       m3250_swio13_dual_pr_ee_u4
 * m3250a_swio13_dual_pr_ee_u4       m3250p_swio13_dual_pr_ee_u4       m3250pa_swio13_dual_pr_ee_u4
 */
static const uint64_t ur_m329_swio13_dual_pr_ee_u4[] = {
  0xb7777768adbb3202, 0xe276fc6a64d9b402, 0xa339a9ca7140b323, 0x663db66fbb1d71f9, 0xeaaf266f5c053d64,
  0x41f5d717d35bdc03, 0x10c5bbc9e9cee1a7, 0x2521d3a9827c6024, 0x1b48c0ddd6d03225, 0xe53ba7c4b881850c,
  0x4700b5318ffe65a0, 0x1c569bd47275b04b, 0xfcfdf04508e489fc, 0xbac00dc3e144312b, 0xfb4432abbbddf373,
  0xcf0983dc54219682, 0xcaf212dbcedffd01, 0x0f4fffe3f0cc161b, 0x95e9b9aad68dc9ca, 0xbd47c1b3071efd47,
  0xb34eb422877c57b3, 0x9a426be8c2cb1148, 0x5073ab4ba9e5c54b, 0x6ba1d7a89767f11f, 0x0908a0f547f258d5,
  0x23f5b86f65f4b317, 0x8a928043e6f6a8d8, 0x7972ab59fc55f3bb, 0x4aa35dce3398a0ed, 0xdaa5beaa6fb39d45,
  0x2fe910e6b8101395, 0xd5688af2c434ae49, 0x5af9d01e395aeb9e, 0x6f19d10210a905ca, 0x56f62aa8b490538c,
  0x79b09732f9b68151, 0xdbb1a2c6f8b93570, 0x854e7ea75666fe0f, 0x2fcc4ffef0f7bca1, 0xfd86687993fc0fe3,
  0x7a617c68f45fe07e, 0x252d9f0271964b86, 0xdd3c95fb9a19961d, 0x0000000ac896d3c8,
};

/*
 * m329a_swio13_dual_pr_ce           m329p_swio13_dual_pr_ce           m329pa_swio13_dual_pr_ce
 * m3290_swio13_dual_pr_ce           m3290a_swio13_dual_pr_ce          m3290p_swio13_dual_pr_ce
 * m3290pa_swio13_dual_pr_ce         m325_swio13_dual_pr_ce            m325a_swio13_dual_pr_ce
 * m325p_swio13_dual_pr_ce           m325pa_swio13_dual_pr_ce          m3250_swio13_dual_pr_ce
 * m3250a_swio13_dual_pr_ce          m3250p_swio13_dual_pr_ce          m3250pa_swio13_dual_pr_ce
 */
static const uint64_t ur_m329_swio13_dual_pr_ce[] = {
  0x95bbbbbbd82432db, 0x3e276fcf1f5c4da2, 0xae17bb3890523bb8, 0x6e9776182ca3e9f7, 0xe908766c75f74a50,
  0x4c4bb8e08ab2c10c, 0x609f180904316ef2, 0xbada0644a4a40aa2, 0x971030a18369181b, 0xdd5ff995d06774f8,
  0x51f676c2391c0e0c, 0x14239227f072ba6f, 0x0f8510c4aff3f7c1, 0xaeef77cdc0448037, 0xf150865a01ed10ca,
  0xb7ff9ff4073c2609, 0xdcd7982c3795e425, 0x7dc5f580d2824ebf, 0xee24b1e79b680e75, 0xfa8f84bf10d8488b,
  0x5ccf1771b9d66c87, 0x17d479127b9633ea, 0x05fdc65471d3f831, 0x00ceda523884e62c, 0x3192a01ffb33c75e,
  0x8a92e04a0796b726, 0x7972ab59fc55f3bb, 0x4aa35dce3398a0ed, 0xdaa5beaa6fb39d45, 0x2fe910e6b8101395,
  0xd5688af2c434ae49, 0x5af9d01e395aeb9e, 0x6f19d10210a905ca, 0x76f62aa8b490538c, 0xf3612e65f36d028c,
  0xfe0eee34596af1b8, 0x34a1854e7ea75666, 0x3f01f343cc9fe04e, 0x04e32c970cf4c2b9, 0xf734332c3a4a5b3e,
  0x03490ad4dd16792b,
};

/*
 * m329a_swio13_dual_pr_ce_u4        m329p_swio13_dual_pr_ce_u4        m329pa_swio13_dual_pr_ce_u4
 * m3290_swio13_dual_pr_ce_u4        m3290a_swio13_dual_pr_ce_u4       m3290p_swio13_dual_pr_ce_u4
 * m3290pa_swio13_dual_pr_ce_u4      m325_swio13_dual_pr_ce_u4         m325a_swio13_dual_pr_ce_u4
 * m325p_swio13_dual_pr_ce_u4        m325pa_swio13_dual_pr_ce_u4       m3250_swio13_dual_pr_ce_u4
 * m3250a_swio13_dual_pr_ce_u4       m3250p_swio13_dual_pr_ce_u4       m3250pa_swio13_dual_pr_ce_u4
 */
static const uint64_t ur_m329_swio13_dual_pr_ce_u4[] = {
  0x817bbbbbb4486f97, 0x3bc4edf9e3f3ecda, 0x3deef75053d68e3d, 0x0bc9d4cca76f5d84, 0x2d4e900d57efdeec,
  0xef25a2bb9e08ce9c, 0x8c6609f180904316, 0x03775b40c8949488, 0x9f12e20614306d23, 0x4dcd15bf32ba0cee,
  0xe6f51f2b6c37d9c3, 0x7c114239227f0650, 0x0370f8510c4aff3f, 0x8655777bbe6e3218, 0x9a718a8432d009e8,
  0x212db8cdffd01cf0, 0x83fee6bcc161bcaf, 0x1cc09717d4ca9413, 0x9117dc4963cf36d0, 0x2e47f51f097e21b0,
  0x6787199e2ee3712a, 0xf064d7a8f38cf72c, 0xe62c0532a6e8e3a7, 0xe3af22dd96ba38c8, 0xe2a4a3ab5b71cb19,
  0x5e5caad67f157cee, 0x52a8d7738ce6283b, 0x76a96faa9bece751, 0x4bfa4439ae0404e5, 0xb55a22bcb10d2b92,
  0x65362ce80f3f5ae7, 0xc6085a6ae757a961, 0xb4e31bc674409cf8, 0x6f86e3cd84b997cd, 0x53ab337f07771a2c,
  0xff787bde50c2a73f, 0x3cc9fe07f197e627, 0x347a2ff03f7ec334, 0x8138cb25c33d30be, 0xfdcd0ccb0e9296cf,
  0x00d24085b7459e4a,
};

/*
 * m329a_swio13_dual_pr_ee_ce        m329p_swio13_dual_pr_ee_ce        m329pa_swio13_dual_pr_ee_ce
 * m3290_swio13_dual_pr_ee_ce        m3290a_swio13_dual_pr_ee_ce       m3290p_swio13_dual_pr_ee_ce
 * m3290pa_swio13_dual_pr_ee_ce      m325_swio13_dual_pr_ee_ce         m325a_swio13_dual_pr_ee_ce
 * m325p_swio13_dual_pr_ee_ce        m325pa_swio13_dual_pr_ee_ce       m3250_swio13_dual_pr_ee_ce
 * m3250a_swio13_dual_pr_ee_ce       m3250p_swio13_dual_pr_ee_ce       m3250pa_swio13_dual_pr_ee_ce
 */
static const uint64_t ur_m329_swio13_dual_pr_ee_ce[] = {
  0x5b2b77777750cf68, 0xeb789dbf1888ce1b, 0xda57bddcfb67d619, 0x2be37410f225c2c2, 0x7f9b4d9b537c9765,
  0x3b9a3ea74704dd9c, 0xf180904316ef2727, 0x81912929047ae609, 0x0c2860da4606eeb6, 0x7e657419dd3e25c4,
  0xfcd80683869a99fe, 0xe489fc1f4fcdea3f, 0x44312bfcfdf04508, 0xbbe6e0c2e00dc3e1, 0x432d038688655777,
  0xeffa039e133938a8, 0x982c3795e425b7c6, 0x46c1650676ffdcd7, 0xe79b680e4ed9dff5, 0x984e771b8089300f,
  0x3cad4f4a76b2b221, 0x09ea3e0d98309fea, 0x459a75a1140a62bc, 0x4752135f4616588a, 0x8ca47389ceaedc5d,
  0x7b1aaf1b1d7b589d, 0xf18b8484512f91ad, 0x2e311f0c8e1bd971, 0x2ab59fc55f3bb8a9, 0x35dce3398a0ed797,
  0x5beaa6fb39d454aa, 0x910e6b8101395daa, 0x88af2c434ae492fe, 0x9d01e395aeb9ed56, 0x9d10210a905ca5af,
  0x62aa8b490538c6f1, 0x12e65f36d028c76f, 0x3bb8d163ce1b8f36, 0x3d30ae4fdd599bf8, 0x9296cf8138cb25c3,
  0x459e4afdcd0ccb0e, 0x000000009822a737,
};

/*
 * m329a_swio13_dual_pr_ee_ce_u4     m329p_swio13_dual_pr_ee_ce_u4     m329pa_swio13_dual_pr_ee_ce_u4
 * m3290_swio13_dual_pr_ee_ce_u4     m3290a_swio13_dual_pr_ee_ce_u4    m3290p_swio13_dual_pr_ee_ce_u4
 * m3290pa_swio13_dual_pr_ee_ce_u4   m325_swio13_dual_pr_ee_ce_u4      m325a_swio13_dual_pr_ee_ce_u4
 * m325p_swio13_dual_pr_ee_ce_u4     m325pa_swio13_dual_pr_ee_ce_u4    m3250_swio13_dual_pr_ee_ce_u4
 * m3250a_swio13_dual_pr_ee_ce_u4    m3250p_swio13_dual_pr_ee_ce_u4    m3250pa_swio13_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio13_dual_pr_ee_ce_u4[] = {
  0xeeeeeed15b77d8be, 0x276fccc54626d6fd, 0x9afbdda8f84339de, 0x6af2657bc89ada6f, 0x437713b7eec5e715,
  0x3ebeca9c7829649b, 0xbbc96c4eea0d599a, 0xea89827c602410c5, 0x81bbada0644a4a45, 0x4f8971030a183691,
  0x0e6e5afccb41ca77, 0xbd47c6ed87609c2f, 0x08a11c913f836bb9, 0xb87c2886257f9fbe, 0xaaeef77cdc4e3c01,
  0xf7150865a11c910c, 0xb6e495ff4073c26d, 0xf8fc330586f2bc84, 0xc5f547d5f28330df, 0x1258f3cdb49dcc35,
  0x47c25f886c2445f7, 0x78bb8dc4e3fb8ffd, 0x57bee53b5b9b9ba6, 0x7a8f83660ccaf51e, 0x669d68450298aedd,
  0xd484d7d185962291, 0xf11f5073abb729e1, 0xb1aaf1b1d7a89767, 0x662e121141ea8fe4, 0xa8d8226470decbe9,
  0xf3bb8a929663e6f6, 0xa0ed7972ab59fc55, 0x9d454aa35dce3398, 0x1395daa5beaa6fb3, 0xae492fe910e6b810,
  0xeb9ed5688af2c434, 0x05ca5af9d01e395a, 0x538c6f19d10210a9, 0x028c76f62aa8b490, 0x6ae0f3612e65f36d,
  0xfc1fb763458df172, 0x79430a9cfd4eaccd, 0x1fc65f989ffde1ef, 0xc0fdfb0cd0f327f8, 0x970cf4c2f8d1e8bf,
  0x2c3a4a5b3e04e32c, 0x5f91ba792bf73433, 0x0000000000400040,
};

/*
 * m329a_swio13_dual_ee_hw           m329p_swio13_dual_ee_hw           m329pa_swio13_dual_ee_hw
 * m3290_swio13_dual_ee_hw           m3290a_swio13_dual_ee_hw          m3290p_swio13_dual_ee_hw
 * m3290pa_swio13_dual_ee_hw         m325_swio13_dual_ee_hw            m325a_swio13_dual_ee_hw
 * m325p_swio13_dual_ee_hw           m325pa_swio13_dual_ee_hw          m3250_swio13_dual_ee_hw
 * m3250a_swio13_dual_ee_hw          m3250p_swio13_dual_ee_hw          m3250pa_swio13_dual_ee_hw
 */
static const uint64_t ur_m329_swio13_dual_ee_hw[] = {
  0x056eeeee87ad0c86, 0x47c4edf8d4c9b368, 0xfa3f375394e28166, 0x7ac8cc7b6cdf763a, 0xb807d55e4cdeb80a,
  0xe9ceeeec6ecde62f, 0x827c602410c5bbc9, 0xd6d032252521d3a9, 0xb881850c1b48c0dd, 0x31ffccae833ba7c4,
  0x8e4eb60968e016a6, 0xa11c913f838ad37a, 0x7c2886257f9fbe08, 0x777bbe6e775801b8, 0x8a8432d05f688655,
  0x79dbffa039e1307b, 0xa91982c3795e425b, 0xad68dc9ca0f4ffff, 0x3071efd4795e9b9a, 0x2877c57b3bd47c1b,
  0x8c2cb1148b34eb42, 0xba9e5c54b9a426be, 0x89767f11f5073ab4, 0x547f258d56ba1d7a, 0xf65f4b3170908a0f,
  0x3e6f6a8d823f5b86, 0x9fc55f3bb8a92804, 0xe3398a0ed7972ab5, 0xa6fb39d454aa35dc, 0x6b8101395daa5bea,
  0x2c434ae492fe910e, 0xe395aeb9ed5688af, 0x210a905ca5af9d01, 0x8b490538c6f19d10, 0x2f9b6815156f62aa,
  0xfa97ab8dc79b0973, 0x7197e627f2861539, 0x3dffc1343cc9fe2e, 0xcb25c33d30ae4fc7, 0x0ccb0e9296cf8138,
  0x76ac7fa29e4afdcd, 0x0000000000000005,
};

/*
 * m329a_swio13_dual_ee_ce_hw        m329p_swio13_dual_ee_ce_hw        m329pa_swio13_dual_ee_ce_hw
 * m3290_swio13_dual_ee_ce_hw        m3290a_swio13_dual_ee_ce_hw       m3290p_swio13_dual_ee_ce_hw
 * m3290pa_swio13_dual_ee_ce_hw      m325_swio13_dual_ee_ce_hw         m325a_swio13_dual_ee_ce_hw
 * m325p_swio13_dual_ee_ce_hw        m325pa_swio13_dual_ee_ce_hw       m3250_swio13_dual_ee_ce_hw
 * m3250a_swio13_dual_ee_ce_hw       m3250p_swio13_dual_ee_ce_hw       m3250pa_swio13_dual_ee_ce_hw
 */
static const uint64_t ur_m329_swio13_dual_ee_ce_hw[] = {
  0x821eeeeeeea1a5fb, 0xc5e276fc623c7f36, 0xd721eed17d8b9da6, 0x63d62c57d769eaef, 0xfabe1f29be4a10d2,
  0xbba591aeba55857b, 0xf180904316ef2599, 0x032252520f67a609, 0x1850c1b48c0ddd6d, 0xfccae833ba7c4b88,
  0x6b60ff0e188266bb, 0xc913f83ff937a8fa, 0x886257f9fbe08a11, 0xbbe6e059001b87c2, 0x432d060a88655777,
  0x3ffa039e134878a8, 0x982c3795e425b7bc, 0x8e574a0d6ffffa91, 0xcf36d01cadf3bfea, 0x984e771b9d1f524f,
  0x3caf7dca76b2b26e, 0xbaf51f06cc1995ea, 0x22cd3ad08a05315d, 0xc3a909afa30b2c45, 0xcfe23ea0e7576e53,
  0xc96355e363af512e, 0xd2cc5c242283d51f, 0xed51b044c8e1bd97, 0xabe77715252cc7cd, 0x3141daf2e556b3f8,
  0x673a8a9546bb9c67, 0x20272bb54b7d54df, 0x695c925fd221cd70, 0xb5d73daad115e588, 0x520b94b5f3a03c72,
  0x20a718de33a20421, 0xda0518edec555169, 0xfec371e6c25ccbe6, 0x8cb25c33d30ae4fc, 0xd0ccb0e9296cf813,
  0x89a638ba29e4afdc,
};

/*
 * m329a_swio13_dual_ee_ce_u4_hw     m329p_swio13_dual_ee_ce_u4_hw     m329pa_swio13_dual_ee_ce_u4_hw
 * m3290_swio13_dual_ee_ce_u4_hw     m3290a_swio13_dual_ee_ce_u4_hw    m3290p_swio13_dual_ee_ce_u4_hw
 * m3290pa_swio13_dual_ee_ce_u4_hw   m325_swio13_dual_ee_ce_u4_hw      m325a_swio13_dual_ee_ce_u4_hw
 * m325p_swio13_dual_ee_ce_u4_hw     m325pa_swio13_dual_ee_ce_u4_hw    m3250_swio13_dual_ee_ce_u4_hw
 * m3250a_swio13_dual_ee_ce_u4_hw    m3250p_swio13_dual_ee_ce_u4_hw    m3250pa_swio13_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio13_dual_ee_ce_u4_hw[] = {
  0xdeeeeeed14682541, 0xe276fccc54626d6f, 0xb69bbdda8f84339d, 0x9c55abc995ef2276, 0x926d0ddc4edfbb17,
  0x4e30cb5bb4f9e0a5, 0x120862dde4b62775, 0x252522f544c13e30, 0x0c1b48c0ddd6d032, 0x89ad3ba7c4b88185,
  0xb04e1787372d7e65, 0xc1b5dcdea3e376c3, 0xbfcfdf04508e489f, 0x271e00dc3e144312, 0x8e488655777bbe6e,
  0x39e136fb8a8432d0, 0x795e425b724affa0, 0x8330dfecf43982c3, 0x0e4c35c5f547d5f2, 0x445f71258f3cafac,
  0x3eefd47c25f886c2, 0xb9ba678bb8dce1fe, 0xaf51e57bee53b5b9, 0x8aedd7a8f83660cc, 0x62291669d6845029,
  0x729e1d484d7d1859, 0x89767f11f5073abb, 0xa8fe4b1aaf1b1d7a, 0xecbe9662e121141e, 0x3e6f6a8d8226470d,
  0x9fc55f3bb8a92966, 0xe3398a0ed7972ab5, 0xa6fb39d454aa35dc, 0x6b8101395daa5bea, 0x2c434ae492fe910e,
  0xe395aeb9ed5688af, 0x210a905ca5af9d01, 0x8b490538c6f19d10, 0x5f36d028c76f62aa, 0x7ea0bb1b8f3612e6,
  0x4ffef0f7bca1854e, 0x687993fc0fe32fcc, 0x7c68f45fe07efd86, 0x9f0271964b867a61, 0x95fb9a19961d252d,
  0x00075d668dc17d3c,
};

/*
 * m329a_swio14_noled                m329p_swio14_noled                m329pa_swio14_noled
 * m3290_swio14_noled                m3290a_swio14_noled               m3290p_swio14_noled
 * m3290pa_swio14_noled              m325_swio14_noled                 m325a_swio14_noled
 * m325p_swio14_noled                m325pa_swio14_noled               m3250_swio14_noled
 * m3250a_swio14_noled               m3250p_swio14_noled               m3250pa_swio14_noled
 */
static const uint64_t ur_m329_swio14_noled[] = {
  0x889bbbbbbacdc49f, 0x3d6eed55c8a50912, 0x9d80374d06e24611, 0x105fd0ee38f522f8, 0x0d5a099fa5f17bb1,
  0x2410c5bbc9ddcc49, 0xbf43cfc7b9827c60, 0x6277cb741283dd7f, 0xe471d3f83affea3a, 0x78e62c05bdd32003,
  0xc608ebc5cedd2232, 0xf2e556a56087dc72, 0x9546bb9c673141da, 0xdcaed52df5673a8a, 0x4ad8fdfd221cd674,
  0xd6b9ed5688af2c43, 0x4ea701652a7d3bcf, 0x11e5e2810b4b0b9d, 0x32f9b69c6378ce88, 0xc2b93f3fb0ddb097,
  0xb2c944e32c970cf4, 0x92bf734332c3a4a5, 0x000000a92ddae3e7,
};

/*
 * m329_swio14_noled_pr_u4           m329a_swio14_noled_pr             m329a_swio14_noled_pr_u4
 * m329p_swio14_noled_pr             m329p_swio14_noled_pr_u4          m329pa_swio14_noled_pr
 * m329pa_swio14_noled_pr_u4         m3290_swio14_noled_pr             m3290_swio14_noled_pr_u4
 * m3290a_swio14_noled_pr            m3290a_swio14_noled_pr_u4         m3290p_swio14_noled_pr
 * m3290p_swio14_noled_pr_u4         m3290pa_swio14_noled_pr           m3290pa_swio14_noled_pr_u4
 * m325_swio14_noled_pr              m325_swio14_noled_pr_u4           m325a_swio14_noled_pr
 * m325a_swio14_noled_pr_u4          m325p_swio14_noled_pr             m325p_swio14_noled_pr_u4
 * m325pa_swio14_noled_pr            m325pa_swio14_noled_pr_u4         m3250_swio14_noled_pr
 * m3250_swio14_noled_pr_u4          m3250a_swio14_noled_pr            m3250a_swio14_noled_pr_u4
 * m3250p_swio14_noled_pr            m3250p_swio14_noled_pr_u4         m3250pa_swio14_noled_pr
 * m3250pa_swio14_noled_pr_u4
 */
static const uint64_t ur_m329_swio14_noled_pr[] = {
  0xc7bbbbbb4488af02, 0x0bbb55722950e251, 0x7b64f5fb1a0b609e, 0x59ac1c436c66cf7a, 0x982fcc6b4dd8e3d0,
  0xdde4eec718178bd9, 0xcc7cc13e30120862, 0xb7b941dbffe78167, 0xfe0c9af51c143be5, 0x02cb2983da011c74,
  0xa3e764c5188a7316, 0xb13ca807fecc11d7, 0x2ab5422607967b76, 0x35dce3398a0ed797, 0x76a96fab39d454aa,
  0xc7efe910e6b3a6e5, 0xcf6ab44579621a56, 0xd8a53c34ef3e2d75, 0x2718de33a2041dd4, 0x10c55bd8aaa2d2da,
  0xab83cd84b997cdb6, 0xf207e50d1637c5c9, 0xef2861539fa9d598, 0x03f8cbf313ffbc3d, 0xf81fbf619a1e64ff,
  0x92e19e985f1a3d17, 0x6587494b67c09c65, 0xe0b1014f257ee686, 0x000000000001f26a,
};

/*
 * m329a_swio14_noled_pr_ee          m329p_swio14_noled_pr_ee          m329pa_swio14_noled_pr_ee
 * m3290_swio14_noled_pr_ee          m3290a_swio14_noled_pr_ee         m3290p_swio14_noled_pr_ee
 * m3290pa_swio14_noled_pr_ee        m325_swio14_noled_pr_ee           m325a_swio14_noled_pr_ee
 * m325p_swio14_noled_pr_ee          m325pa_swio14_noled_pr_ee         m3250_swio14_noled_pr_ee
 * m3250a_swio14_noled_pr_ee         m3250p_swio14_noled_pr_ee         m3250pa_swio14_noled_pr_ee
 */
static const uint64_t ur_m329_swio14_noled_pr_ee[] = {
  0x7dddddd0f5a22582, 0x6eed55f85c20890d, 0x9da67b50c99f3732, 0xb4368650b8678518, 0x3f644d8106d0435e,
  0xc9dd3b410d1996a2, 0x19827c602410c5bb, 0xf283b3bfcf02cf9c, 0x51e565d66ab5a331, 0xca5fa8f83660fa8f,
  0x291669d68450ef8a, 0x3593484d7d185962, 0xa8fe439d5a5dc9ae, 0xc6ab5d0ebce9bb1e, 0x98b84845110a3dee,
  0xa3608fd6e1bd96cb, 0xaf2e556a01741cf2, 0xa9546bb9c673141d, 0x4dcaed52df5673a8, 0x34ad8fdfd221cd67,
  0x5aeb9ed5688af2c4, 0x3ba9b14a7869de7c, 0xa5b44e31bc674408, 0x9b6c218ab7b15545, 0x8b9357079b09732f,
  0x598f207e50d1674f, 0xe627f2861539fa9d, 0xc1343cc9fe2e7197, 0xc33d30ae4fc73dff, 0x0e9296cf8138cb25,
  0xa2029e4afdcd0ccb, 0x000000000013af02,
};

/*
 * m329a_swio14_noled_pr_ee_u4       m329p_swio14_noled_pr_ee_u4       m329pa_swio14_noled_pr_ee_u4
 * m3290_swio14_noled_pr_ee_u4       m3290a_swio14_noled_pr_ee_u4      m3290p_swio14_noled_pr_ee_u4
 * m3290pa_swio14_noled_pr_ee_u4     m325_swio14_noled_pr_ee_u4        m325a_swio14_noled_pr_ee_u4
 * m325p_swio14_noled_pr_ee_u4       m325pa_swio14_noled_pr_ee_u4      m3250_swio14_noled_pr_ee_u4
 * m3250a_swio14_noled_pr_ee_u4      m3250p_swio14_noled_pr_ee_u4      m3250pa_swio14_noled_pr_ee_u4
 */
static const uint64_t ur_m329_swio14_noled_pr_ee_u4[] = {
  0x426eeeeed1222a20, 0xda776aafc2e34e25, 0x47f4d2eedb75fe24, 0xf2299c7cfd833c76, 0x103d724041b41508,
  0x793ba3d8b54718d4, 0x9d304f8c048218b7, 0x7e506577f9e059fd, 0xea3cafe74d56b47b, 0x5ba5f51f06cc1ce3,
  0x4522cd3ad08a1df1, 0x8a266909afa30b2c, 0xe46b5ce756975f6b, 0x355ae875eba9bb4b, 0xc5c242281f11f496,
  0xe3a0fadc37b2e1c8, 0x19cc5076bcb955aa, 0x7d59cea2a551aee7, 0x4887359d372bb54b, 0xa22bcb10d2b63f7f,
  0xe1a779f16bae7b55, 0xf19d1020eea6c529, 0xdec5551696d138c6, 0x6c25ccbe6db0862a, 0x2868b1be2e4d5c1e,
  0x0a9cfd4eacc7903f, 0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c,
  0x0a792bf734332c3a, 0x000000013ae9a088,
};

/*
 * m329_swio14_noled_pr_ce_u4        m329a_swio14_noled_pr_ce          m329a_swio14_noled_pr_ce_u4
 * m329p_swio14_noled_pr_ce          m329p_swio14_noled_pr_ce_u4       m329pa_swio14_noled_pr_ce
 * m329pa_swio14_noled_pr_ce_u4      m3290_swio14_noled_pr_ce          m3290_swio14_noled_pr_ce_u4
 * m3290a_swio14_noled_pr_ce         m3290a_swio14_noled_pr_ce_u4      m3290p_swio14_noled_pr_ce
 * m3290p_swio14_noled_pr_ce_u4      m3290pa_swio14_noled_pr_ce        m3290pa_swio14_noled_pr_ce_u4
 * m325_swio14_noled_pr_ce           m325_swio14_noled_pr_ce_u4        m325a_swio14_noled_pr_ce
 * m325a_swio14_noled_pr_ce_u4       m325p_swio14_noled_pr_ce          m325p_swio14_noled_pr_ce_u4
 * m325pa_swio14_noled_pr_ce         m325pa_swio14_noled_pr_ce_u4      m3250_swio14_noled_pr_ce
 * m3250_swio14_noled_pr_ce_u4       m3250a_swio14_noled_pr_ce         m3250a_swio14_noled_pr_ce_u4
 * m3250p_swio14_noled_pr_ce         m3250p_swio14_noled_pr_ce_u4      m3250pa_swio14_noled_pr_ce
 * m3250pa_swio14_noled_pr_ce_u4
 */
static const uint64_t ur_m329_swio14_noled_pr_ce[] = {
  0xf26eeeeed1222582, 0xfc776aaf088d2e24, 0xd1748fe933e3ec1e, 0xcff5e35cdd95b6a6, 0x2d541685e15baf26,
  0x8b7793ba76821cbb, 0x9fd37304f8c04821, 0xf5eea5072b7f9e05, 0x58f3c0254ee575c5, 0xc25f886c2445f712,
  0x8bb8dc643a4afd47, 0x8ebe4f72c67eb267, 0xf97d1c74fe0d67fa, 0x64c5188a731602ed, 0xa807feccf1d7a3e7,
  0x508981e5add6b13c, 0x38ce6283b5e5caad, 0x5beace75152a8d77, 0xfa4439ace9b95daa, 0xad115e588695b1fb,
  0x4f0d3bcf8b5d73da, 0x378ce88107753629, 0x76f62aa8b4b689c6, 0xe6c25ccbe6db084c, 0xf2868b1be2e4d5c1,
  0x30a9cfd4eacc7903, 0x65f989ffde1ef794, 0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970,
  0x80a792bf734332c3, 0x00000000375d22f8,
};

/*
 * m329a_swio14_noled_pr_ee_ce       m329p_swio14_noled_pr_ee_ce       m329pa_swio14_noled_pr_ee_ce
 * m3290_swio14_noled_pr_ee_ce       m3290a_swio14_noled_pr_ee_ce      m3290p_swio14_noled_pr_ee_ce
 * m3290pa_swio14_noled_pr_ee_ce     m325_swio14_noled_pr_ee_ce        m325a_swio14_noled_pr_ee_ce
 * m325p_swio14_noled_pr_ee_ce       m325pa_swio14_noled_pr_ee_ce      m3250_swio14_noled_pr_ee_ce
 * m3250a_swio14_noled_pr_ee_ce      m3250p_swio14_noled_pr_ee_ce      m3250pa_swio14_noled_pr_ee_ce
 */
static const uint64_t ur_m329_swio14_noled_pr_ee_ce[] = {
  0xb31ddddddd446f43, 0xc45ddaabd853a744, 0x9a3bd89dab43d318, 0x1f1f5a63bf23f4c6, 0x506e38d45832d5b3,
  0x7793bad3bed3b2d9, 0x9b7304f8c048218b, 0x7594119bff3c0b3e, 0x012a7633677fd519, 0x9cee3719cba3ff9e,
  0x5c8794ed6563df30, 0xea3e0d983d2bd479, 0x9a75a1140a62b387, 0x52135f4616588a45, 0x547f21ceaedce4c7,
  0xc6abc6c75e74dd8f, 0x98b84845110a3dee, 0x51b044c8e1bd96cb, 0xd7972ab52cfa0e79, 0x54aa35dce3398a0e,
  0xa6e576a96fab39d4, 0x1a56c7efe910e6b3, 0x2d75cf6ab4457962, 0x1dd4d8a53c34ef3e, 0xd2da2718de33a204,
  0x9b6c2131dbd8aaa2, 0xf38b93571b09732f, 0xf75663c81f943458, 0x4e32c970cf4c2b93, 0x34332c3a4a5b2c94,
  0x34c5fb880a792bf7, 0x0000000000000005,
};

/*
 * m329a_swio14_noled_pr_ee_ce_u4    m329p_swio14_noled_pr_ee_ce_u4    m329pa_swio14_noled_pr_ee_ce_u4
 * m3290_swio14_noled_pr_ee_ce_u4    m3290a_swio14_noled_pr_ee_ce_u4   m3290p_swio14_noled_pr_ee_ce_u4
 * m3290pa_swio14_noled_pr_ee_ce_u4  m325_swio14_noled_pr_ee_ce_u4     m325a_swio14_noled_pr_ee_ce_u4
 * m325p_swio14_noled_pr_ee_ce_u4    m325pa_swio14_noled_pr_ee_ce_u4   m3250_swio14_noled_pr_ee_ce_u4
 * m3250a_swio14_noled_pr_ee_ce_u4   m3250p_swio14_noled_pr_ee_ce_u4   m3250pa_swio14_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio14_noled_pr_ee_ce_u4[] = {
  0x90dddddda243306a, 0x62eed55fd4cc8c48, 0x1ebb2dd6960cc17e, 0x86150015b47706d7, 0x21ba05f250b2d9e4,
  0xde4eed57e4c3ac84, 0x524c13e30120862d, 0x6e506b7ffec5767c, 0xb680e56fdc5f547a, 0x0d8488bee24b1e79,
  0x76ec2c9fa8f84bf1, 0xb5b9b7be678bb8dc, 0x60f4af51e5721e53, 0x50298ace1fa8f836, 0x185962291669d684,
  0x3abb73931d484d7d, 0x1d79d3763d51fc87, 0x144428f7bb1aaf1b, 0x2386f65b2e62e121, 0xd4b3e839e546c113,
  0x738ce6283b5e5caa, 0xa5beace75152a8d7, 0xbfa4439ace9b95da, 0xaad115e588695b1f, 0x94f0d3bcf8b5d73d,
  0x6378ce8810775362, 0xc76f62aa8b4b689c, 0x1e6c25ccbe6db084, 0x9bf83bb8d1637c37, 0xdef2861539fa9d59,
  0xf03f8cbf313ffbc3, 0x7f81fbf619a1e64f, 0x592e19e985f1a3d1, 0x66587494b67c09c6, 0x3d5dba2cf257ee68,
  0x00000000000009f8,
};

/*
 * m329a_swio14_noled_ee_hw          m329p_swio14_noled_ee_hw          m329pa_swio14_noled_ee_hw
 * m3290_swio14_noled_ee_hw          m3290a_swio14_noled_ee_hw         m3290p_swio14_noled_ee_hw
 * m3290pa_swio14_noled_ee_hw        m325_swio14_noled_ee_hw           m325a_swio14_noled_ee_hw
 * m325p_swio14_noled_ee_hw          m325pa_swio14_noled_ee_hw         m3250_swio14_noled_ee_hw
 * m3250a_swio14_noled_ee_hw         m3250p_swio14_noled_ee_hw         m3250pa_swio14_noled_ee_hw
 */
static const uint64_t ur_m329_swio14_noled_ee_hw[] = {
  0x6beeeeeed121b705, 0x93776aafc2e10448, 0x56989dda864cf9b9, 0x35eb4368650b8678, 0x4c23f644d8106d04,
  0x18b7793bb61b656a, 0x99f383304f8c0482, 0xad198f941d9dff42, 0x07d47a8f2b2eb355, 0x877c5652fd47c1b3,
  0xc2cb1148b34eb422, 0xee4d71ac9a426be8, 0x4dd8f547f21cead2, 0x51ef76355ae875e7, 0xecb65cc5c2422888,
  0xa0e7951b047eb70d, 0x98a0ed7972ab500b, 0xb39d454aa35dce33, 0x0e6b3a6e576a96fa, 0x579621a56c7efe91,
  0x4ef3e2d75cf6ab44, 0x3a2041dd4d8a53c3, 0x8aaa2d2da2718de3, 0x4b997cdb610c55bd, 0x1539fa82ec6e3cd8,
  0xbf313ffbc3def286, 0xf619a1e64ff03f8c, 0xe985f1a3d17f81fb, 0x94b67c09c6592e19, 0x14f257ee68665874,
  0x0000000016ffe69d,
};

/*
 * m329_swio14_noled_ee_ce_u4_hw     m329a_swio14_noled_ee_ce_hw       m329a_swio14_noled_ee_ce_u4_hw
 * m329p_swio14_noled_ee_ce_hw       m329p_swio14_noled_ee_ce_u4_hw    m329pa_swio14_noled_ee_ce_hw
 * m329pa_swio14_noled_ee_ce_u4_hw   m3290_swio14_noled_ee_ce_hw       m3290_swio14_noled_ee_ce_u4_hw
 * m3290a_swio14_noled_ee_ce_hw      m3290a_swio14_noled_ee_ce_u4_hw   m3290p_swio14_noled_ee_ce_hw
 * m3290p_swio14_noled_ee_ce_u4_hw   m3290pa_swio14_noled_ee_ce_hw     m3290pa_swio14_noled_ee_ce_u4_hw
 * m325_swio14_noled_ee_ce_hw        m325_swio14_noled_ee_ce_u4_hw     m325a_swio14_noled_ee_ce_hw
 * m325a_swio14_noled_ee_ce_u4_hw    m325p_swio14_noled_ee_ce_hw       m325p_swio14_noled_ee_ce_u4_hw
 * m325pa_swio14_noled_ee_ce_hw      m325pa_swio14_noled_ee_ce_u4_hw   m3250_swio14_noled_ee_ce_hw
 * m3250_swio14_noled_ee_ce_u4_hw    m3250a_swio14_noled_ee_ce_hw      m3250a_swio14_noled_ee_ce_u4_hw
 * m3250p_swio14_noled_ee_ce_hw      m3250p_swio14_noled_ee_ce_u4_hw   m3250pa_swio14_noled_ee_ce_hw
 * m3250pa_swio14_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio14_noled_ee_ce_hw[] = {
  0x486eeeeed1219f68, 0x31776aafea664624, 0x8f5d96eb4b0660bf, 0x430a800ada3b836b, 0x60dd02f928596cf2,
  0x8b7793ba55e89fa1, 0x9f149304f8c04821, 0xa3d372835bfff429, 0xf3cdb4072b7ee2fa, 0x5f886c2445f71258,
  0x8dc36ec291fd47c2, 0xe53b5b9b7be678bb, 0x83660f4af51e5721, 0x68450298ace1fa8f, 0xd7d185962291669d,
  0xc873abb73931d484, 0xf1b1d79d3763d51f, 0x121144428f7bb1aa, 0x1132386f65b2e62e, 0xcaad4b3e839e546c,
  0x8d7738ce6283b5e5, 0x5daa5beace75152a, 0xb1fbfa4439ace9b9, 0x73daad115e588695, 0x36294f0d3bcf8b5d,
  0x89c6378ce8810775, 0x084c76f62aa8b4b6, 0x6371e6c25ccbe6db, 0x1ef79430a9cfd417, 0x7f81fc65f989ffde,
  0x8bfc0fdfb0cd0f32, 0x32c970cf4c2f8d1e, 0x4332c3a4a5b3e04e, 0x4043d5e8a792bf73, 0x0000000000000001,
};

/*
 * m329a_swio14_lednop               m329p_swio14_lednop               m329pa_swio14_lednop
 * m3290_swio14_lednop               m3290a_swio14_lednop              m3290p_swio14_lednop
 * m3290pa_swio14_lednop             m325_swio14_lednop                m325a_swio14_lednop
 * m325p_swio14_lednop               m325pa_swio14_lednop              m3250_swio14_lednop
 * m3250a_swio14_lednop              m3250p_swio14_lednop              m3250pa_swio14_lednop
 */
static const uint64_t ur_m329_swio14_lednop[] = {
  0x511377777759bb37, 0x27adddaab914ad22, 0xdfbe3f770f8da0c2, 0x1105fd0ee38f684d, 0xc869b1006dbe3fbb,
  0x02410c5bbc9ddb1e, 0xfbf43cfc069827c6, 0xc90ef96e825043df, 0x318e3a7f075ffd47, 0xd21cc580b7ba6ea1,
  0x58c11d78b9d84547, 0x5e5caad4acc17b8e, 0x52a8d7738ce6283b, 0x9b95daa5beace751, 0xbec7a4439ae0404e,
  0x3daad115e588695c, 0x0b29b1674079fad7, 0xe8a042d3573abd4b, 0x36d38c6f19d1028b, 0x27e7f61bb612e65f,
  0x289c6592e19e9857, 0xee6866587494b659, 0x002a4faf5c7cf257,
};

/*
 * m329_swio14_lednop_pr_u4          m329a_swio14_lednop_pr            m329a_swio14_lednop_pr_u4
 * m329p_swio14_lednop_pr            m329p_swio14_lednop_pr_u4         m329pa_swio14_lednop_pr
 * m329pa_swio14_lednop_pr_u4        m3290_swio14_lednop_pr            m3290_swio14_lednop_pr_u4
 * m3290a_swio14_lednop_pr           m3290a_swio14_lednop_pr_u4        m3290p_swio14_lednop_pr
 * m3290p_swio14_lednop_pr_u4        m3290pa_swio14_lednop_pr          m3290pa_swio14_lednop_pr_u4
 * m325_swio14_lednop_pr             m325_swio14_lednop_pr_u4          m325a_swio14_lednop_pr
 * m325a_swio14_lednop_pr_u4         m325p_swio14_lednop_pr            m325p_swio14_lednop_pr_u4
 * m325pa_swio14_lednop_pr           m325pa_swio14_lednop_pr_u4        m3250_swio14_lednop_pr
 * m3250_swio14_lednop_pr_u4         m3250a_swio14_lednop_pr           m3250a_swio14_lednop_pr_u4
 * m3250p_swio14_lednop_pr           m3250p_swio14_lednop_pr_u4        m3250pa_swio14_lednop_pr
 * m3250pa_swio14_lednop_pr_u4
 */
static const uint64_t ur_m329_swio14_lednop_pr[] = {
  0x8f7777768911fc3b, 0x1776aae45217c4a3, 0x56921b7e61f6c13c, 0xb35838aa18db2f78, 0xb1dd8f75fbb1c7a0,
  0xef2776e09ba86653, 0xbee609f180904316, 0xbdca0c7bff3c0b3e, 0xf064d7a8e801df2d, 0x0b2ca67f3a88e3a7,
  0x1f3b6488c6f9cc58, 0xfa45403ff6608ebd, 0xab5976a07967b707, 0x5dce3398a0ed7972, 0x6a96fab39d454aa3,
  0x910e6b81013a6e57, 0x44579621a572fb1e, 0xce80f1cad75cf6ab, 0xce881085482e52d7, 0xb15545a4829c6378,
  0x84b997cdb6318ab7, 0x0d1637c5c9ab83cd, 0x539fa9d598f207e5, 0xf313ffbc3def2861, 0x619a1e64ff03f8cb,
  0x985f1a3d17f81fbf, 0x4b67c09c6592e19e, 0x4f257ee686658749, 0x000003e4ce43f101,
};

/*
 * m329a_swio14_lednop_pr_ee         m329p_swio14_lednop_pr_ee         m329pa_swio14_lednop_pr_ee
 * m3290_swio14_lednop_pr_ee         m3290a_swio14_lednop_pr_ee        m3290p_swio14_lednop_pr_ee
 * m3290pa_swio14_lednop_pr_ee       m325_swio14_lednop_pr_ee          m325a_swio14_lednop_pr_ee
 * m325p_swio14_lednop_pr_ee         m325pa_swio14_lednop_pr_ee        m3250_swio14_lednop_pr_ee
 * m3250a_swio14_lednop_pr_ee        m3250p_swio14_lednop_pr_ee        m3250pa_swio14_lednop_pr_ee
 */
static const uint64_t ur_m329_swio14_lednop_pr_ee[] = {
  0xafbbbbba1eb44511, 0x9bbb557e1768b121, 0x4bab077311b7cdcc, 0xeb4368604142d04e, 0xf4cd2e2f106d0435,
  0x793baaf99f64e2c5, 0xb5304f8c048218b7, 0x3e5046b7f9e059f4, 0xea3cad82cd56b466, 0x5a9ef51f06cc1f51,
  0x4522cd3ad08a1df1, 0xc6b26909afa30b2c, 0x111cdc73ab4bba55, 0x58d56ba1d79d3769, 0x73170908a17c4719,
  0x546c11fadc37b2d9, 0xb5e5caad402b589e, 0x152a8d7738ce6283, 0xe9b95daa5beace75, 0xcbec7a4439ae0404,
  0x73daad115e588695, 0xb94b5f3a03c72b5d, 0x718de33a20421520, 0xc62adec55516920a, 0xae0f3612e65f36d8,
  0x40fca1a2ce9f1726, 0xe50c2a73f53ab31e, 0x7993fc5ce32fcc4f, 0x615c9f8e7bff8268, 0x2d9f0271964b867a,
  0x3c95fb9a19961d25, 0x00000009d7324405,
};

/*
 * m329a_swio14_lednop_pr_ee_u4      m329p_swio14_lednop_pr_ee_u4      m329pa_swio14_lednop_pr_ee_u4
 * m3290_swio14_lednop_pr_ee_u4      m3290a_swio14_lednop_pr_ee_u4     m3290p_swio14_lednop_pr_ee_u4
 * m3290pa_swio14_lednop_pr_ee_u4    m325_swio14_lednop_pr_ee_u4       m325a_swio14_lednop_pr_ee_u4
 * m325p_swio14_lednop_pr_ee_u4      m325pa_swio14_lednop_pr_ee_u4     m3250_swio14_lednop_pr_ee_u4
 * m3250a_swio14_lednop_pr_ee_u4     m3250p_swio14_lednop_pr_ee_u4     m3250pa_swio14_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_swio14_lednop_pr_ee_u4[] = {
  0x426eeeeed1222582, 0xda776aafc2e56e25, 0x68ba47f600f4be24, 0x847914ce3fa82593, 0xaa82d0bc5e20da0a,
  0x6ef2774ed0439765, 0xe96a609f18090431, 0xf6fca08d6ff3c0b3, 0xc7d4795c879aad68, 0xe2bfddea3e0d9839,
  0x588a459a75a1143b, 0x97144cd2135f4616, 0xb2446989cead2f01, 0x6b1aad743af5d4dd, 0xc8c5c2422883e8ed,
  0x55c60bfadc37b2e1, 0xce3398a0ed7972ab, 0x96fab39d454aa35d, 0x0e6b81013a6e576a, 0x579621a572fb1e91,
  0x9d01e7eb5cf6ab44, 0x4d5ceaf52c2ca6c5, 0xbc67440a2fa2810b, 0x3cd84b997cdb4e31, 0x7e50d1637c5c9ab8,
  0x861539fa9d598f20, 0x8cbf313ffbc3def2, 0xfbf619a1e64ff03f, 0x19e985f1a3d17f81, 0x7494b67c09c6592e,
  0x1014f257ee686658, 0x0000000004eba45f,
};

/*
 * m329_swio14_lednop_pr_ce_u4       m329a_swio14_lednop_pr_ce         m329a_swio14_lednop_pr_ce_u4
 * m329p_swio14_lednop_pr_ce         m329p_swio14_lednop_pr_ce_u4      m329pa_swio14_lednop_pr_ce
 * m329pa_swio14_lednop_pr_ce_u4     m3290_swio14_lednop_pr_ce         m3290_swio14_lednop_pr_ce_u4
 * m3290a_swio14_lednop_pr_ce        m3290a_swio14_lednop_pr_ce_u4     m3290p_swio14_lednop_pr_ce
 * m3290p_swio14_lednop_pr_ce_u4     m3290pa_swio14_lednop_pr_ce       m3290pa_swio14_lednop_pr_ce_u4
 * m325_swio14_lednop_pr_ce          m325_swio14_lednop_pr_ce_u4       m325a_swio14_lednop_pr_ce
 * m325a_swio14_lednop_pr_ce_u4      m325p_swio14_lednop_pr_ce         m325p_swio14_lednop_pr_ce_u4
 * m325pa_swio14_lednop_pr_ce        m325pa_swio14_lednop_pr_ce_u4     m3250_swio14_lednop_pr_ce
 * m3250_swio14_lednop_pr_ce_u4      m3250a_swio14_lednop_pr_ce        m3250a_swio14_lednop_pr_ce_u4
 * m3250p_swio14_lednop_pr_ce        m3250p_swio14_lednop_pr_ce_u4     m3250pa_swio14_lednop_pr_ce
 * m3250pa_swio14_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_swio14_lednop_pr_ce[] = {
  0x9e4dddddda244511, 0xdf8eed55e111ebc4, 0xd71efd3d1b6c4583, 0xd9febc6bb4b37764, 0xb2c56442041375e4,
  0x18b7793baaf99f41, 0x59f8e5304f8c0482, 0x5f5eea506dd7f9e0, 0x258f3c0254ef4ddc, 0x7c25f886c2445f71,
  0x78bb8dc24aca8fd4, 0x51e5f4f72c67eb26, 0x7bd2a38e9fc1acff, 0xed92231be731602c, 0x1500ffd99e3af47c,
  0x5976a0796b741fe9, 0xce3398a0ed7972ab, 0x96fab39d454aa35d, 0x0e6b81013a6e576a, 0x579621a572fb1e91,
  0x80f1cad75cf6ab44, 0x881085482e52d7ce, 0x5545a4829c6378ce, 0x732f9b6c6263b7b1, 0x2c6f8b9357079b09,
  0x3f53ab31e40fca1a, 0x27ff787bde50c2a7, 0x343cc9fe07f197e6, 0xbe347a2ff03f7ec3, 0xcf8138cb25c33d30,
  0x4afdcd0ccb0e9296, 0x00006eb842e2029e,
};

/*
 * m329a_swio14_lednop_pr_ee_ce      m329p_swio14_lednop_pr_ee_ce      m329pa_swio14_lednop_pr_ee_ce
 * m3290_swio14_lednop_pr_ee_ce      m3290a_swio14_lednop_pr_ee_ce     m3290p_swio14_lednop_pr_ee_ce
 * m3290pa_swio14_lednop_pr_ee_ce    m325_swio14_lednop_pr_ee_ce       m325a_swio14_lednop_pr_ee_ce
 * m325p_swio14_lednop_pr_ee_ce      m325pa_swio14_lednop_pr_ee_ce     m3250_swio14_lednop_pr_ee_ce
 * m3250a_swio14_lednop_pr_ee_ce     m3250p_swio14_lednop_pr_ee_ce     m3250pa_swio14_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_swio14_lednop_pr_ee_ce[] = {
  0xb31ddddddd447032, 0xc45ddaabd85048c4, 0x2991db13ac829b18, 0x1f1f5a63be9de468, 0x48eee091f832d5b3,
  0x7793bad88e75864e, 0x7f9304f8c048218b, 0x5d6504347f9e059f, 0xc0254ec341dff546, 0x273b8dc6838227f3,
  0x5652e53b5958f7cc, 0xfa8f83660f4af51e, 0x669d68450298aca1, 0xd484d7d185962291, 0x111cdc73abb73a51,
  0xb1aaf1b1d79d3769, 0xe62e121142f88e32, 0x546c1132386f65b2, 0xb5e5caad4b3b589e, 0x152a8d7738ce6283,
  0xe9b95daa5beace75, 0xcbec7a4439ae0404, 0x73daad115e588695, 0xb94b5f3a03c72b5d, 0x718de33a20421520,
  0x898edec55516920a, 0x4d5c6c25ccbe6db1, 0x8f207e50d163ce2e, 0x25c33d30ae4fdd59, 0xb0e9296cb25138cb,
  0x3e2029e4afdcd0cc, 0x000000000014d36e,
};

/*
 * m329a_swio14_lednop_pr_ee_ce_u4   m329p_swio14_lednop_pr_ee_ce_u4   m329pa_swio14_lednop_pr_ee_ce_u4
 * m3290_swio14_lednop_pr_ee_ce_u4   m3290a_swio14_lednop_pr_ee_ce_u4  m3290p_swio14_lednop_pr_ee_ce_u4
 * m3290pa_swio14_lednop_pr_ee_ce_u4 m325_swio14_lednop_pr_ee_ce_u4    m325a_swio14_lednop_pr_ee_ce_u4
 * m325p_swio14_lednop_pr_ee_ce_u4   m325pa_swio14_lednop_pr_ee_ce_u4  m3250_swio14_lednop_pr_ee_ce_u4
 * m3250a_swio14_lednop_pr_ee_ce_u4  m3250p_swio14_lednop_pr_ee_ce_u4  m3250pa_swio14_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio14_lednop_pr_ee_ce_u4[] = {
  0x21bbbbbb44867a31, 0xc5ddaabfa9b33891, 0x3db0dbb42cdd82fc, 0x0c2a002b66451dd3, 0x8a51ba976165b3c9,
  0xbc9dd44fc3efb40f, 0xc19827c602410c5b, 0xb94143effb15d9fe, 0xda03887d717d51e9, 0x361222fb892c79e6,
  0x0ff1f77ea3e12fc4, 0xadcdbdf33c5dc6e7, 0x07a57a8f2b29729d, 0x814c5650fd47c1b3, 0xc2cb1148b34eb422,
  0xd5db9d28ea426be8, 0xebce9bb4888e6e39, 0xa17c471958d578d8, 0x1c37b2d973170908, 0xa59dac4f2a360899,
  0x9c673141daf2e556, 0x2df5673a8a9546bb, 0x1cd7020274dcaed5, 0xaf2c434ae5f63d22, 0x01e395aeb9ed5688,
  0x10210a905ca5af9d, 0xaa8b490538c6f19d, 0xe65f36d8c4c76f62, 0xdc68b1be1b8f3612, 0x0a9cfd4eaccdfc1d,
  0x5f989ffde1ef7943, 0xfb0cd0f327f81fc6, 0xf4c2f8d1e8bfc0fd, 0x4a5b3e04e32c970c, 0x16792bf734332c3a,
  0x00000009f91a9cdd,
};

/*
 * m329a_swio14_lednop_ee_hw         m329p_swio14_lednop_ee_hw         m329pa_swio14_lednop_ee_hw
 * m3290_swio14_lednop_ee_hw         m3290a_swio14_lednop_ee_hw        m3290p_swio14_lednop_ee_hw
 * m3290pa_swio14_lednop_ee_hw       m325_swio14_lednop_ee_hw          m325a_swio14_lednop_ee_hw
 * m325p_swio14_lednop_ee_hw         m325pa_swio14_lednop_ee_hw        m3250_swio14_lednop_ee_hw
 * m3250a_swio14_lednop_ee_hw        m3250p_swio14_lednop_ee_hw        m3250pa_swio14_lednop_ee_hw
 */
static const uint64_t ur_m329_swio14_lednop_ee_hw[] = {
  0x35f777776890c044, 0x93776aafc2ed1624, 0x13792eee6236f9b9, 0x0d7ad0da181050b4, 0x21fd334b8bc41b41,
  0x0c5bbc9dd4149cb4, 0x4cfa5a9827c60241, 0xd68cc7ca08d6ffa1, 0x83ea3d4795b059aa, 0x43be2b53dea3e0d9,
  0x616588a459a75a11, 0x774ab8d64d2135f4, 0xa6ed22239b8e7569, 0x88e32b1aad743af3, 0xf65b2e62e121142f,
  0x6b13ca8d823f5b86, 0xcc5076bcb955a805, 0x59cea2a551aee719, 0xc0809d372bb54b7d, 0x10d2b97d8f488735,
  0xe56bae7b55a22bcb, 0x42a417296be74078, 0xd2414e31bc674408, 0xe6db18c55bd8aaa2, 0xd4176371e6c25ccb,
  0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3,
  0x0000b7c6a728a792,
};

/*
 * m329_swio14_lednop_ee_ce_u4_hw    m329a_swio14_lednop_ee_ce_hw      m329a_swio14_lednop_ee_ce_u4_hw
 * m329p_swio14_lednop_ee_ce_hw      m329p_swio14_lednop_ee_ce_u4_hw   m329pa_swio14_lednop_ee_ce_hw
 * m329pa_swio14_lednop_ee_ce_u4_hw  m3290_swio14_lednop_ee_ce_hw      m3290_swio14_lednop_ee_ce_u4_hw
 * m3290a_swio14_lednop_ee_ce_hw     m3290a_swio14_lednop_ee_ce_u4_hw  m3290p_swio14_lednop_ee_ce_hw
 * m3290p_swio14_lednop_ee_ce_u4_hw  m3290pa_swio14_lednop_ee_ce_hw    m3290pa_swio14_lednop_ee_ce_u4_hw
 * m325_swio14_lednop_ee_ce_hw       m325_swio14_lednop_ee_ce_u4_hw    m325a_swio14_lednop_ee_ce_hw
 * m325a_swio14_lednop_ee_ce_u4_hw   m325p_swio14_lednop_ee_ce_hw      m325p_swio14_lednop_ee_ce_u4_hw
 * m325pa_swio14_lednop_ee_ce_hw     m325pa_swio14_lednop_ee_ce_u4_hw  m3250_swio14_lednop_ee_ce_hw
 * m3250_swio14_lednop_ee_ce_u4_hw   m3250a_swio14_lednop_ee_ce_hw     m3250a_swio14_lednop_ee_ce_u4_hw
 * m3250p_swio14_lednop_ee_ce_hw     m3250p_swio14_lednop_ee_ce_u4_hw  m3250pa_swio14_lednop_ee_ce_hw
 * m3250pa_swio14_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio14_lednop_ee_ce_hw[] = {
  0x90dddddda2435f41, 0x62eed55fd4d99c48, 0x9ed86dda166ec17e, 0x86150015b3228ee9, 0x2528dd4bb0b2d9e4,
  0x16ef27768bfbbdae, 0x7fb06609f1809043, 0x8f4dca0a1f7fd0a6, 0xcf36d01c43eb8bea, 0x7e21b09117dc4963,
  0x3715d7185ff51f09, 0x94ed6e6def99e2ee, 0x0d983d2bd479594b, 0xa1140a62b287ea3e, 0x5f4616588a459a75,
  0x71ceaedce9475213, 0xc6c75e74dda44473, 0x48450be238cac6ab, 0x44c8e1bd96cb98b8, 0x2ab52ced627951b0,
  0x35dce3398a0ed797, 0x76a96fab39d454aa, 0xe910e6b81013a6e5, 0xb44579621a572fb1, 0x7ce80f1cad75cf6a,
  0x8ce881085482e52d, 0x7b15545a4829c637, 0xb09732f9b6c6263b, 0x0c2a73f505d8dc79, 0x197e627ff787bde5,
  0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c, 0xea29e4afdcd0ccb0, 0x0000000000a028d4,
};

/*
 * m329_swio14_dual_pr               m329_swio14_dual_pr_u4            m329a_swio14_dual
 * m329a_swio14_dual_pr              m329a_swio14_dual_pr_u4           m329p_swio14_dual
 * m329p_swio14_dual_pr              m329p_swio14_dual_pr_u4           m329pa_swio14_dual
 * m329pa_swio14_dual_pr             m329pa_swio14_dual_pr_u4          m3290_swio14_dual
 * m3290_swio14_dual_pr              m3290_swio14_dual_pr_u4           m3290a_swio14_dual
 * m3290a_swio14_dual_pr             m3290a_swio14_dual_pr_u4          m3290p_swio14_dual
 * m3290p_swio14_dual_pr             m3290p_swio14_dual_pr_u4          m3290pa_swio14_dual
 * m3290pa_swio14_dual_pr            m3290pa_swio14_dual_pr_u4         m325_swio14_dual
 * m325_swio14_dual_pr               m325_swio14_dual_pr_u4            m325a_swio14_dual
 * m325a_swio14_dual_pr              m325a_swio14_dual_pr_u4           m325p_swio14_dual
 * m325p_swio14_dual_pr              m325p_swio14_dual_pr_u4           m325pa_swio14_dual
 * m325pa_swio14_dual_pr             m325pa_swio14_dual_pr_u4          m3250_swio14_dual
 * m3250_swio14_dual_pr              m3250_swio14_dual_pr_u4           m3250a_swio14_dual
 * m3250a_swio14_dual_pr             m3250a_swio14_dual_pr_u4          m3250p_swio14_dual
 * m3250p_swio14_dual_pr             m3250p_swio14_dual_pr_u4          m3250pa_swio14_dual
 * m3250pa_swio14_dual_pr            m3250pa_swio14_dual_pr_u4
 */
static const uint64_t ur_m329_swio14_dual[] = {
  0x4bbbbbbb4486c541, 0x7e276fc75e9c8da3, 0xb62fbb707a750b69, 0x1fc5fe47652be295, 0x18b3e2d402b74d29,
  0x95a1dd608fe1aaf5, 0x9827c602410c5bbc, 0xeeb6819129290a91, 0x25c40c2860da4606, 0x99c9fe657419dd3e,
  0xf51dfcd82fb38145, 0x08a11c913f8332a6, 0xb87c2886257f9fbe, 0x2abbbddf371aec01, 0xb5a2a10cb4232443,
  0x25b7297ff4073c26, 0x7fdcd7982c3795e4, 0x7ee8ef965af28251, 0xc3dc71d3f83defd4, 0xa62731602a83cce4,
  0xd9823af006764011, 0xe59edbde37d500ff, 0x2af9ddc5495f3a81, 0xcc5076bcb955acfe, 0x59cea2a551aee719,
  0xc0809d372bb54b7d, 0x10d2b97d8f488735, 0xe56bae7b55a22bcb, 0x42a417296be74078, 0xd2414e31bc674408,
  0xe6db18c55bd8aaa2, 0x1637c371e6c25ccb, 0x9fa9d599bf83bb8d, 0x13ffbc3def286153, 0x9a1e64ff03f8cbf3,
  0x5f1a3d17f81fbf61, 0x67c09c6592e19e98, 0x257ee6866587494b, 0x000292641c9ba2cf,
};

/*
 * m329a_swio14_dual_pr_ee           m329p_swio14_dual_pr_ee           m329pa_swio14_dual_pr_ee
 * m3290_swio14_dual_pr_ee           m3290a_swio14_dual_pr_ee          m3290p_swio14_dual_pr_ee
 * m3290pa_swio14_dual_pr_ee         m325_swio14_dual_pr_ee            m325a_swio14_dual_pr_ee
 * m325p_swio14_dual_pr_ee           m325pa_swio14_dual_pr_ee          m3250_swio14_dual_pr_ee
 * m3250a_swio14_dual_pr_ee          m3250p_swio14_dual_pr_ee          m3250pa_swio14_dual_pr_ee
 */
static const uint64_t ur_m329_swio14_dual_pr_ee[] = {
  0x34eddddddd435032, 0x23e276fc6a68426d, 0x7ad3dba7395f40b3, 0xeb2333b55de9afbf, 0x2f0fae71337aed39,
  0xdd57b68ff5efbb1c, 0x8c048218b7793d39, 0x0644a4a42e8b304f, 0x30a18369181bbada, 0xf995d06774f89710,
  0xd6c12d1c02d4c63f, 0x9227f0715a6f51c9, 0x10c4aff3f7c11423, 0x77cdcba180370f85, 0x865a0bed10caaeef,
  0x5ff4073c260f7150, 0x982c3795e425b7d3, 0xa3fdd28216bfdcd7, 0x87bf51e576ea6ab5, 0xdf15e9bf51f06cc1,
  0xb2c4522cd3ad08a1, 0x157152e6909afa30, 0xb18f467a9cead2ec, 0x886c6ab5d0ebd44b, 0xfa598b848451a523,
  0x45546c11fadc37b2, 0x55f3bb8a92805914, 0x98a0ed7972ab59fc, 0xb39d454aa35dce33, 0x81013a6e576a96fa,
  0x21a572fb1e910e6b, 0xcad75cf6ab445796, 0x85482e52d7ce80f1, 0xa4829c6378ce8810, 0xcdb6318ab7b15545,
  0x58f386e3cd84b997, 0x93f75666fe0eee34, 0xe04e32c970cf4c2b, 0xbf734332c3a4a5b3, 0x00c85117cdd16792,
};

/*
 * m329a_swio14_dual_pr_ee_u4        m329p_swio14_dual_pr_ee_u4        m329pa_swio14_dual_pr_ee_u4
 * m3290_swio14_dual_pr_ee_u4        m3290a_swio14_dual_pr_ee_u4       m3290p_swio14_dual_pr_ee_u4
 * m3290pa_swio14_dual_pr_ee_u4      m325_swio14_dual_pr_ee_u4         m325a_swio14_dual_pr_ee_u4
 * m325p_swio14_dual_pr_ee_u4        m325pa_swio14_dual_pr_ee_u4       m3250_swio14_dual_pr_ee_u4
 * m3250a_swio14_dual_pr_ee_u4       m3250p_swio14_dual_pr_ee_u4       m3250pa_swio14_dual_pr_ee_u4
 */
static const uint64_t ur_m329_swio14_dual_pr_ee_u4[] = {
  0xb7777768adbba0ae, 0x89dbf1a9a109b4d3, 0x47e69ce57d02cc8f, 0x676abbd35f7eda7b, 0x5ce266f5da73d646,
  0xfadd5ec3ebb85e1f, 0x0c5bbc9e9ceefafb, 0x5217459827c60241, 0xb48c0ddd6d032252, 0x53ba7c4b881850c1,
  0x700b5318ffe65a0e, 0xc569bd47275b04b4, 0xcfdf04508e489fc1, 0x8600dc3e144312bf, 0xb4432abbbddf372e,
  0xf0983dc54219682f, 0x579096df4d7fd01c, 0x216bff1f8660b0de, 0x576ea6ab5a3fdd28, 0xf51f06cc187bf51e,
  0xcd3ad08a1df15e9b, 0x6909afa30b2c4522, 0xa9cead2ec157152e, 0x5d0ebd44bb18f467, 0x48451a523886c6ab,
  0x1fadc37b2fa598b8, 0xa9280591445546c1, 0x972ab59fc55f3bb8, 0xaa35dce3398a0ed7, 0xe576a96fab39d454,
  0xb1e910e6b81013a6, 0x6ab44579621a572f, 0x2d7ce80f1cad75cf, 0x378ce881085482e5, 0xab7b15545a4829c6,
  0x3cd84b997cdb6318, 0xedd8d1637c5c9ab8, 0xc2a73f53ab337f07, 0x97e627ff787bde50, 0x7ec3343cc9fe07f1,
  0x3d30be347a2ff03f, 0x9296cf8138cb25c3, 0x6e9e4afdcd0ccb0e, 0x0000001593d89fe4,
};

/*
 * m329a_swio14_dual_pr_ce           m329p_swio14_dual_pr_ce           m329pa_swio14_dual_pr_ce
 * m3290_swio14_dual_pr_ce           m3290a_swio14_dual_pr_ce          m3290p_swio14_dual_pr_ce
 * m3290pa_swio14_dual_pr_ce         m325_swio14_dual_pr_ce            m325a_swio14_dual_pr_ce
 * m325p_swio14_dual_pr_ce           m325pa_swio14_dual_pr_ce          m3250_swio14_dual_pr_ce
 * m3250a_swio14_dual_pr_ce          m3250p_swio14_dual_pr_ce          m3250pa_swio14_dual_pr_ce
 */
static const uint64_t ur_m329_swio14_dual_pr_ce[] = {
  0xaddddddec121a5fb, 0xf89dbf3c7f766d1b, 0x41f6eabe6c48eee0, 0xe976d3913eabfaef, 0x9932bbf7ef74dd06,
  0xc4bba591aeb36855, 0x09f180904316ef24, 0x5b40c89494888c66, 0xe20614306d230377, 0xabff32ba0cee9f12,
  0x3eced8472381c19b, 0x847244fe0e574dea, 0xf0a21895fe7ef822, 0xeef77cdc524006e1, 0x150865a01ed10caa,
  0xe337ff4073c2609f, 0x9af30586f2bc84b6, 0x5c5f57f2504e0ffb, 0x71258f3cdb40709d, 0xd47c25f886c2445f,
  0xccf1771b8cdf4a8f, 0x7a8e13e7b9633ea5, 0x4a2edf8e3a7f076b, 0x33b2008d31398b01, 0xbea807feccf1d780,
  0x92be7503cb5b9ef1, 0x72ab59fc55f3bb8a, 0xa35dce3398a0ed79, 0x576a96fab39d454a, 0x1e910e6b81013a6e,
  0xab44579621a572fb, 0xd7ce80f1cad75cf6, 0x78ce881085482e52, 0xb7b15545a4829c63, 0x9b09732f9b6c6263,
  0xf07771a2cb578dc7, 0xa50c2a73f53ab337, 0xf80f9a1e64ff0271, 0x271964b867a615c9, 0xb9a19961d252d9f0,
  0x1a48f5b6e8b3c95f,
};

/*
 * m329a_swio14_dual_pr_ce_u4        m329p_swio14_dual_pr_ce_u4        m329pa_swio14_dual_pr_ce_u4
 * m3290_swio14_dual_pr_ce_u4        m3290a_swio14_dual_pr_ce_u4       m3290p_swio14_dual_pr_ce_u4
 * m3290pa_swio14_dual_pr_ce_u4      m325_swio14_dual_pr_ce_u4         m325a_swio14_dual_pr_ce_u4
 * m325p_swio14_dual_pr_ce_u4        m325pa_swio14_dual_pr_ce_u4       m3250_swio14_dual_pr_ce_u4
 * m3250a_swio14_dual_pr_ce_u4       m3250p_swio14_dual_pr_ce_u4       m3250pa_swio14_dual_pr_ce_u4
 */
static const uint64_t ur_m329_swio14_dual_pr_ce_u4[] = {
  0x191dddddda2432db, 0x9de276fcf1f62e6d, 0x5a9afbad89d9471e, 0x91c9d4ccdd69624e, 0xf8ce947ee7157ee9,
  0x7792d15dc7045580, 0xd7d304f8c048218b, 0x81bbada0644a4a41, 0x4f8971030a183691, 0xa6e68adf995d0677,
  0x737a8f95b61bece1, 0xbe08a11c913f8328, 0x01b87c2886257f9f, 0x432abbbddf3712a0, 0x4d38c542196804f4,
  0x9096dec7ffe80e78, 0xd6ff735e60b0de57, 0x1c53d717d76fca08, 0x9117dc4963cf36d0, 0xd90ff51f097e21b0,
  0x6787199e2ee373ac, 0xe0c9ef51e5f4f72c, 0x98b0176faf91c74f, 0x8ebc8b761f118df3, 0x15251d5c3dc72c67,
  0xf2e556b3f8abe777, 0x9546bb9c673141da, 0xdcaed52df5673a8a, 0xf63d221cd7020274, 0xed5688af2c434ae5,
  0x594d8b3a03cfd6b9, 0x3182169ab9d5ea58, 0x6d38c6f19d1028be, 0x1be1b8f3612e65f3, 0xd4eaccdfc1ddc68b,
  0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3,
  0x000692166dd16792,
};

/*
 * m329a_swio14_dual_pr_ee_ce        m329p_swio14_dual_pr_ee_ce        m329pa_swio14_dual_pr_ee_ce
 * m3290_swio14_dual_pr_ee_ce        m3290a_swio14_dual_pr_ee_ce       m3290p_swio14_dual_pr_ee_ce
 * m3290pa_swio14_dual_pr_ee_ce      m325_swio14_dual_pr_ee_ce         m325a_swio14_dual_pr_ee_ce
 * m325p_swio14_dual_pr_ee_ce        m325pa_swio14_dual_pr_ee_ce       m3250_swio14_dual_pr_ee_ce
 * m3250a_swio14_dual_pr_ee_ce       m3250p_swio14_dual_pr_ee_ce       m3250pa_swio14_dual_pr_ee_ce
 */
static const uint64_t ur_m329_swio14_dual_pr_ee_ce[] = {
  0xa9c5bbbbbba86f97, 0x7ade276fc6223f0d, 0x7ef5ef76c5e35586, 0x2be3749cad041f22, 0x097d7aef537c9671,
  0x9dcf046752c8a756, 0xf8c048218b779393, 0x40c8949483927304, 0x0614306d2303775b, 0x3f32ba0cee9f12e2,
  0xfe6c0341c34d4cff, 0x7244fe0fa7e6f51f, 0xa21895fe7ef82284, 0xeef9b9e72006e1f0, 0x10cb40e1a21955dd,
  0x93fe80e784ce4e2a, 0xf30586f2bc84b6e2, 0x54650e5074d7fb9a, 0xff3cdb40734d1dff, 0x866139dc6e292737,
  0xa8f2b60b29dacac8, 0x6a7bd47c1b307d47, 0x148b34eb422814c5, 0xe18ea426be8c2cb1, 0xedb7d1cbe39d5db8,
  0x3e58d578d8ebdac4, 0xe3e3170908a01446, 0xa4b8c722991c37b2, 0x5caad67f157ceee2, 0xa8d7738ce6283b5e,
  0x95daa5beace75152, 0xc7a4439ae0404e9b, 0xaad115e588695cbe, 0xb5f3a03c72b5d73d, 0xde33a20421520b94,
  0xedec55516920a718, 0xe6c25ccbe6db1898, 0x7f07771a2c79c371, 0xb867a615c9fbab33, 0x61d252d9f0271964,
  0xc6e8b3c95fb9a199, 0x000000000004c139,
};

/*
 * m329a_swio14_dual_pr_ee_ce_u4     m329p_swio14_dual_pr_ee_ce_u4     m329pa_swio14_dual_pr_ee_ce_u4
 * m3290_swio14_dual_pr_ee_ce_u4     m3290a_swio14_dual_pr_ee_ce_u4    m3290p_swio14_dual_pr_ee_ce_u4
 * m3290pa_swio14_dual_pr_ee_ce_u4   m325_swio14_dual_pr_ee_ce_u4      m325a_swio14_dual_pr_ee_ce_u4
 * m325p_swio14_dual_pr_ee_ce_u4     m325pa_swio14_dual_pr_ee_ce_u4    m3250_swio14_dual_pr_ee_ce_u4
 * m3250a_swio14_dual_pr_ee_ce_u4    m3250p_swio14_dual_pr_ee_ce_u4    m3250pa_swio14_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio14_dual_pr_ee_ce_u4[] = {
  0xeeeeeed15b770668, 0x276fccc5fc26d67d, 0xda6a6bd5784339de, 0xdae2faf7683acada, 0x37713b3eec5e713a,
  0x52399a0e087877d7, 0xc96c4eeab8fb0003, 0xb9827c602410c5bb, 0x775b40c894948659, 0x12e20614306d2303,
  0xdcb5f9968394ee9f, 0x8f8ddb0ec1385e1c, 0x4239227f06d7737a, 0xf8510c4aff3f7c11, 0xeef77cdc15400370,
  0x150865a11c910caa, 0xf495ff4073c26df7, 0xfc330586f2bc84b6, 0xfaa3275283787ff8, 0x2c79e6da4eef0ee2,
  0xe12fc4361222fb89, 0x2ee370551649fea3, 0xcae94ed6e6e6e99e, 0x47c1b307b7fd4795, 0x4eb422814c57befd,
  0x426be8c2cb1148b3, 0x8cf539d5db9828ea, 0xaaf1b1d7a897631e, 0x2e121146948e21b1, 0xd8226470decbe966,
  0x7715252cf2288aa8, 0xdaf2e556b3f8abe7, 0x8a9546bb9c673141, 0x74dcaed52df5673a, 0xe5f63d221cd70202,
  0xb9ed5688af2c434a, 0x5ca5af9d01e395ae, 0x38c6f19d10210a90, 0xc4c76f62aa8b4905, 0xae0f3612e65f36d8,
  0xc1fb763458df1726, 0x9430a9cfd4eaccdf, 0xfc65f989ffde1ef7, 0x0fdfb0cd0f327f81, 0x70cf4c2f8d1e8bfc,
  0xc3a4a5b3e04e32c9, 0x791ba792bf734332, 0x0000000004004fc1,
};

/*
 * m329a_swio14_dual_ee_hw           m329p_swio14_dual_ee_hw           m329pa_swio14_dual_ee_hw
 * m3290_swio14_dual_ee_hw           m3290a_swio14_dual_ee_hw          m3290p_swio14_dual_ee_hw
 * m3290pa_swio14_dual_ee_hw         m325_swio14_dual_ee_hw            m325a_swio14_dual_ee_hw
 * m325p_swio14_dual_ee_hw           m325pa_swio14_dual_ee_hw          m3250_swio14_dual_ee_hw
 * m3250a_swio14_dual_ee_hw          m3250p_swio14_dual_ee_hw          m3250pa_swio14_dual_ee_hw
 */
static const uint64_t ur_m329_swio14_dual_ee_hw[] = {
  0x76eeeee87ad0cf68, 0xf13b7e353421369a, 0x69edd39cafa05991, 0x9199daaef4d7dfbd, 0x87d73899bd769cf5,
  0x3b9a3ea75add8e17, 0xf180904316ef27a7, 0x40c8949485d16609, 0x0614306d2303775b, 0xff32ba0cee9f12e2,
  0x3ad825a3805a98c7, 0x7244fe0e2b4dea39, 0xa21895fe7ef82284, 0xeef9b9743006e1f0, 0x10cb417da21955dd,
  0x6bfe80e784c1ee2a, 0x330586f2bc84b6fa, 0x68ff74a085afff52, 0x61efd4795dba9aad, 0x77c57a6fd47c1b30,
  0x2cb1148b34eb4228, 0x055c54b9a426be8c, 0xec63d19ea73ab4bb, 0xe21b1aad743af512, 0xbe9662e121146948,
  0x11551b047eb70dec, 0x157ceee2a4a01645, 0xe6283b5e5caad67f, 0xace75152a8d7738c, 0xe0404e9b95daa5be,
  0x88695cbec7a4439a, 0x72b5d73daad115e5, 0x21520b94b5f3a03c, 0x6920a718de33a204, 0xf36d8c62adec5551,
  0x52f571b8f3612e65, 0x32fcc4fe50c2a73f, 0xbff82687993fc5ce, 0x64b867a615c9f8e7, 0x9961d252d9f02719,
  0x6917d453c95fb9a1, 0x0000000000000057,
};

/*
 * m329a_swio14_dual_ee_ce_hw        m329p_swio14_dual_ee_ce_hw        m329pa_swio14_dual_ee_ce_hw
 * m3290_swio14_dual_ee_ce_hw        m3290a_swio14_dual_ee_ce_hw       m3290p_swio14_dual_ee_ce_hw
 * m3290pa_swio14_dual_ee_ce_hw      m325_swio14_dual_ee_ce_hw         m325a_swio14_dual_ee_ce_hw
 * m325p_swio14_dual_ee_ce_hw        m325pa_swio14_dual_ee_ce_hw       m3250_swio14_dual_ee_ce_hw
 * m3250a_swio14_dual_ee_ce_hw       m3250p_swio14_dual_ee_ce_hw       m3250pa_swio14_dual_ee_ce_hw
 */
static const uint64_t ur_m329_swio14_dual_ee_ce_hw[] = {
  0x1ceddddddd43359b, 0xc5e276fc6236086d, 0xdbc9ee8eba7d9da6, 0x98f599f0ce644d71, 0xbccd936a6f929ce4,
  0x6ee1e198535aebd7, 0x7c602410c5bbc966, 0xa0644a4a465b4982, 0x030a18369181bbad, 0x7f995d06774f8971,
  0x4d6c1fe1c3104cd7, 0x39227f07ff26f51f, 0x510c4aff3f7c1142, 0xf77cdc5c100370f8, 0x0865a0c1510caaee,
  0xb7ff4073c2690f15, 0x330586f2bc84b6e6, 0xa8f2b4a0e20fff52, 0xfe79b680e6203bfe, 0x74c273b8dcca8683,
  0x51e572ba53b59593, 0xefbf51f06cc1edff, 0x522cd3ad08a05315, 0x0a3a909afa30b2c4, 0xd8c7a33d4e7576e6,
  0x886c6abc6c75ea25, 0xfa598b848451a523, 0x22aa3608991c37b2, 0x2af9ddc5494b3c8a, 0xcc5076bcb955acfe,
  0x59cea2a551aee719, 0xc0809d372bb54b7d, 0x10d2b97d8f488735, 0xe56bae7b55a22bcb, 0x42a417296be74078,
  0xd2414e31bc674408, 0xcdb63131dbd8aaa2, 0xf9fd86e3cd84b997, 0x271964b867a615c9, 0xb9a19961d252d9f0,
  0x002269805453c95f,
};

/*
 * m329a_swio14_dual_ee_ce_u4_hw     m329p_swio14_dual_ee_ce_u4_hw     m329pa_swio14_dual_ee_ce_u4_hw
 * m3290_swio14_dual_ee_ce_u4_hw     m3290a_swio14_dual_ee_ce_u4_hw    m3290p_swio14_dual_ee_ce_u4_hw
 * m3290pa_swio14_dual_ee_ce_u4_hw   m325_swio14_dual_ee_ce_u4_hw      m325a_swio14_dual_ee_ce_u4_hw
 * m325p_swio14_dual_ee_ce_u4_hw     m325pa_swio14_dual_ee_ce_u4_hw    m3250_swio14_dual_ee_ce_u4_hw
 * m3250a_swio14_dual_ee_ce_u4_hw    m3250p_swio14_dual_ee_ce_u4_hw    m3250pa_swio14_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio14_dual_ee_ce_u4_hw[] = {
  0xbdddddda28d172df, 0xc4edf998bf84dacf, 0xcadd4d7aaf08673b, 0x13adae2faf7683ba, 0x7d737713b3eec5e7,
  0xaa0d5a1968e08787, 0x0862dde4b62776d6, 0x4a432cdcc13e3012, 0x369181bbada0644a, 0x5a774f8971030a18,
  0x9c2f0e6e5afccb13, 0x6bb9bd47c6ed8760, 0x9fbe08a11c913f83, 0xa001b87c2886257f, 0x488655777bbe6e0a,
  0xe136fb8a8432d08e, 0x5e425b7a4affa039, 0x787fecf43982c379, 0x2f0ee2faa3275283, 0x2fb892c79e57d607,
  0x5fea3e12fc436122, 0x6e99e2ee3702c8cf, 0xd4795cae94ed6e6e, 0x7befd47c1b307b7f, 0x148b34eb422814c5,
  0x828ea426be8c2cb1, 0x7631e8cf539d5db9, 0xe21b1aaf1b1d7a89, 0xbe9662e121146948, 0x88aa8d8226470dec,
  0x8abe77715252cf22, 0x73141daf2e556b3f, 0x5673a8a9546bb9c6, 0x7020274dcaed52df, 0xc434ae5f63d221cd,
  0x395aeb9ed5688af2, 0x10a905ca5af9d01e, 0xb490538c6f19d102, 0xf36d8c4c76f62aa8, 0xea0bb1b8f3612e65,
  0xffef0f7bca1854e7, 0x87993fc0fe32fcc4, 0xc68f45fe07efd866, 0xf0271964b867a617, 0x5fb9a19961d252d9,
  0x0075d58cd017d3c9,
};

/*
 * m329a_swio15_noled                m329p_swio15_noled                m329pa_swio15_noled
 * m3290_swio15_noled                m3290a_swio15_noled               m3290p_swio15_noled
 * m3290pa_swio15_noled              m325_swio15_noled                 m325a_swio15_noled
 * m325p_swio15_noled                m325pa_swio15_noled               m3250_swio15_noled
 * m3250a_swio15_noled               m3250p_swio15_noled               m3250pa_swio15_noled
 */
static const uint64_t ur_m329_swio15_noled[] = {
  0xd49bbbbbbacdfc4f, 0x7adddaab9142f712, 0xfa5c7750e2448c22, 0x20bfa1ddc4eecfe0, 0x68d4136d8cad3775,
  0x048218b7793bb0bd, 0xf7e879f31f304f8c, 0x109df2dd24a0edff, 0xd78e3a7f07cf7a8f, 0x9a398b016f74da52,
  0x630475e2e76b868c, 0x7972ab52b2bfee39, 0x4aa35dce3398a0ed, 0xe576a96fabb39d45, 0xad5fefe910e6b3a6,
  0xae7b55a22bcb10d2, 0xa9c0594a9f4ef3f5, 0x5fb8a042d2c2e753, 0xbe6da718de33a204, 0xae4fcfec376c25cc,
  0xb25138cb25c33d30, 0xafdcd0ccb0e9296c, 0x00002a45c6b8f9e4,
};

/*
 * m329_swio15_noled_pr_u4           m329a_swio15_noled_pr             m329a_swio15_noled_pr_u4
 * m329p_swio15_noled_pr             m329p_swio15_noled_pr_u4          m329pa_swio15_noled_pr
 * m329pa_swio15_noled_pr_u4         m3290_swio15_noled_pr             m3290_swio15_noled_pr_u4
 * m3290a_swio15_noled_pr            m3290a_swio15_noled_pr_u4         m3290p_swio15_noled_pr
 * m3290p_swio15_noled_pr_u4         m3290pa_swio15_noled_pr           m3290pa_swio15_noled_pr_u4
 * m325_swio15_noled_pr              m325_swio15_noled_pr_u4           m325a_swio15_noled_pr
 * m325a_swio15_noled_pr_u4          m325p_swio15_noled_pr             m325p_swio15_noled_pr_u4
 * m325pa_swio15_noled_pr            m325pa_swio15_noled_pr_u4         m3250_swio15_noled_pr
 * m3250_swio15_noled_pr_u4          m3250a_swio15_noled_pr            m3250a_swio15_noled_pr_u4
 * m3250p_swio15_noled_pr            m3250p_swio15_noled_pr_u4         m3250pa_swio15_noled_pr
 * m3250pa_swio15_noled_pr_u4
 */
static const uint64_t ur_m329_swio15_noled_pr[] = {
  0x27777776891190e3, 0x1776aae453c7c4ae, 0x3d537bab21c6c13c, 0xb358d0600266f259, 0xac7c2f1afbb713a0,
  0xef277448b333761b, 0x7f2609f180904316, 0x83f282657f9e059f, 0xf07d07a8f2f8ef96, 0x16594d1ef4a8e3a7,
  0x1f3b4428f7b398b0, 0x49a5403ff6608ebd, 0x55abeb703cb3db11, 0xaee719cc5076bcb9, 0x54b7d5d9cea2a551,
  0xf7f4887359d372bb, 0xaad115e5886956af, 0x94f0d3bcf8b5d73d, 0x6378ce8810775362, 0x156f62aa8b4b689c,
  0xc1e6c25ccbe6d8c9, 0x03f2868b1be2e4d5, 0x9430a9cfd4eacc79, 0xfc65f989ffde1ef7, 0x0fdfb0cd0f327f81,
  0x70cf4c2f8d1e8bfc, 0xc3a4a5b3e04e32c9, 0x6880a792bf734332, 0x0000000000f9354d,
};

/*
 * m329a_swio15_noled_pr_ee          m329p_swio15_noled_pr_ee          m329pa_swio15_noled_pr_ee
 * m3290_swio15_noled_pr_ee          m3290a_swio15_noled_pr_ee         m3290p_swio15_noled_pr_ee
 * m3290pa_swio15_noled_pr_ee        m325_swio15_noled_pr_ee           m325a_swio15_noled_pr_ee
 * m325p_swio15_noled_pr_ee          m325pa_swio15_noled_pr_ee         m3250_swio15_noled_pr_ee
 * m3250a_swio15_noled_pr_ee         m3250p_swio15_noled_pr_ee         m3250pa_swio15_noled_pr_ee
 */
static const uint64_t ur_m329_swio15_noled_pr_ee[] = {
  0xfdddddd0f5a22a20, 0xdddaabf0bd458971, 0x7be477c7edbe6e64, 0x86d1337aed2c90a6, 0xb452b620da0b8fd6,
  0x7747b16a4771a8d2, 0x609f180904316ef2, 0xa0c56ff3c0b3e4ea, 0x3caca5cd56b46fe4, 0x87ea3e0d98309fea,
  0x459a75a1143be2b2, 0x64d2135f4616588a, 0x3c90e756974acb8d, 0xaad743af3a6edd42, 0x5c24228f911c1fb1,
  0xb047eb70decb65cc, 0x2e556a0174982d51, 0x546bb9c673141daf, 0xaed52df57673a8a9, 0xabfdfd221cd674dc,
  0xcf6ab44579621a55, 0xd8a53c34ef3e2d75, 0x2718de33a2041dd4, 0x32455bd8aaa2d2da, 0x357079b09732f9b6,
  0xf207e50d1674f8b9, 0x7f2861539fa9d598, 0x43cc9fe2e7197e62, 0xd30ae4fc73dffc13, 0x296cf8138cb25c33,
  0x29e4afdcd0ccb0e9, 0x000000013af8c620,
};

/*
 * m329a_swio15_noled_pr_ee_u4       m329p_swio15_noled_pr_ee_u4       m329pa_swio15_noled_pr_ee_u4
 * m3290_swio15_noled_pr_ee_u4       m3290a_swio15_noled_pr_ee_u4      m3290p_swio15_noled_pr_ee_u4
 * m3290pa_swio15_noled_pr_ee_u4     m325_swio15_noled_pr_ee_u4        m325a_swio15_noled_pr_ee_u4
 * m325p_swio15_noled_pr_ee_u4       m325pa_swio15_noled_pr_ee_u4      m3250_swio15_noled_pr_ee_u4
 * m3250a_swio15_noled_pr_ee_u4      m3250p_swio15_noled_pr_ee_u4      m3250pa_swio15_noled_pr_ee_u4
 */
static const uint64_t ur_m329_swio15_noled_pr_ee_u4[] = {
  0xbdeeeeeed12232a8, 0xb4eed55f85e85c48, 0xd2eae3d1b6c47c49, 0xe4531d7c33c5ef4c, 0x8b41568106d045ed,
  0xc9dd3ad1a848b3ea, 0x69827c602410c5bb, 0x5283beffcf02cfc5, 0xa8f2b74b355ad199, 0x721fd47c1b306807,
  0x148b34eb422877c5, 0x2899a426be8c2cb1, 0x28def39d5a5ea52e, 0x355ae875eba9bb4e, 0x170908a16ba3b876,
  0x8e93eb70decb8723, 0x673141daf2e556ab, 0x57673a8a9546bb9c, 0x21cd674dcaed52df, 0x579621a55abfdfd2,
  0x4ef3e2d75cf6ab44, 0x3a2041dd4d8a53c3, 0x8aaa2d2da2718de3, 0x09732f9b632455bd, 0x1a2c6f8b9357079b,
  0xa73f53ab31e40fca, 0xe627ff787bde50c2, 0xc3343cc9fe07f197, 0x30be347a2ff03f7e, 0x96cf8138cb25c33d,
  0x9e4afdcd0ccb0e92, 0x00000009d72ce202,
};

/*
 * m329_swio15_noled_pr_ce_u4        m329a_swio15_noled_pr_ce          m329a_swio15_noled_pr_ce_u4
 * m329p_swio15_noled_pr_ce          m329p_swio15_noled_pr_ce_u4       m329pa_swio15_noled_pr_ce
 * m329pa_swio15_noled_pr_ce_u4      m3290_swio15_noled_pr_ce          m3290_swio15_noled_pr_ce_u4
 * m3290a_swio15_noled_pr_ce         m3290a_swio15_noled_pr_ce_u4      m3290p_swio15_noled_pr_ce
 * m3290p_swio15_noled_pr_ce_u4      m3290pa_swio15_noled_pr_ce        m3290pa_swio15_noled_pr_ce_u4
 * m325_swio15_noled_pr_ce           m325_swio15_noled_pr_ce_u4        m325a_swio15_noled_pr_ce
 * m325a_swio15_noled_pr_ce_u4       m325p_swio15_noled_pr_ce          m325p_swio15_noled_pr_ce_u4
 * m325pa_swio15_noled_pr_ce         m325pa_swio15_noled_pr_ce_u4      m3250_swio15_noled_pr_ce
 * m3250_swio15_noled_pr_ce_u4       m3250a_swio15_noled_pr_ce         m3250a_swio15_noled_pr_ce_u4
 * m3250p_swio15_noled_pr_ce         m3250p_swio15_noled_pr_ce_u4      m3250pa_swio15_noled_pr_ce
 * m3250pa_swio15_noled_pr_ce_u4
 */
static const uint64_t ur_m329_swio15_noled_pr_ce[] = {
  0x426eeeeed1222a20, 0xfc776aaf08834e25, 0x47f4d2eedb75ec1e, 0xcff5fc7cfd833c76, 0xc6a081eb921bb426,
  0xc5bbc9dd1ec5aa38, 0xcfece9827c602410, 0xf5dbf2832bbfcf02, 0x58f3c0254ef7ddc5, 0xc25f886c2445f712,
  0x8bb8dcb9124afd47, 0x8f374f72c67eb267, 0x2a718e3a7f064f7a, 0xed10a3dece62c053, 0x9500ffd99e3af47c,
  0xabeb703cb5b84526, 0xe719cc5076bcb955, 0xb7d5d9cea2a551ae, 0xf4887359d372bb54, 0xd115e5886956aff7,
  0xf0d3bcf8b5d73daa, 0x78ce881077536294, 0x6f62aa8b4b689c63, 0xcd84b997cdb190c7, 0xe50d1637c5c9ab83,
  0x61539fa9d598f207, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8, 0x9e985f1a3d17f81f, 0x494b67c09c6592e1,
  0x014f257ee6866587, 0x00000000375d3411,
};

/*
 * m329a_swio15_noled_pr_ee_ce       m329p_swio15_noled_pr_ee_ce       m329pa_swio15_noled_pr_ee_ce
 * m3290_swio15_noled_pr_ee_ce       m3290a_swio15_noled_pr_ee_ce      m3290p_swio15_noled_pr_ee_ce
 * m3290pa_swio15_noled_pr_ee_ce     m325_swio15_noled_pr_ee_ce        m325a_swio15_noled_pr_ee_ce
 * m325p_swio15_noled_pr_ee_ce       m325pa_swio15_noled_pr_ee_ce      m3250_swio15_noled_pr_ee_ce
 * m3250a_swio15_noled_pr_ee_ce      m3250p_swio15_noled_pr_ee_ce      m3250pa_swio15_noled_pr_ee_ce
 */
static const uint64_t ur_m329_swio15_noled_pr_ee_ce[] = {
  0x42fddddddd447705, 0x88bbb557b0a4bb89, 0xb89db93b504b2631, 0xfe3eb47a7c94c4d0, 0x5c11236460cb5685,
  0xde4eed86d94f5926, 0x4d4c13e30120862d, 0x4b941ff9fe78167f, 0x00953bff877fd519, 0x4e771b9950d07fcf,
  0xace1ca76b2b1ef98, 0xf51f06cc19ebea3c, 0xcd3ad08a05315975, 0xa909afa30b2c4522, 0x423c90e7576e4ac3,
  0x6355e363af3a6edd, 0x98b848451f22383f, 0x51b044c8e1bd96cb, 0xaf2e556a59f4982d, 0xa9546bb9c673141d,
  0xdcaed52df57673a8, 0x55abfdfd221cd674, 0x75cf6ab44579621a, 0xd4d8a53c34ef3e2d, 0xda2718de33a2041d,
  0x6c6431dbd8aaa2d2, 0x71726ae3612e65f3, 0xeacc7903f2868b1e, 0xc6592e19e985727e, 0x866587494b659289,
  0x98f2f1014f257ee6, 0x00000000000000a6,
};

/*
 * m329a_swio15_noled_pr_ee_ce_u4    m329p_swio15_noled_pr_ee_ce_u4    m329pa_swio15_noled_pr_ee_ce_u4
 * m3290_swio15_noled_pr_ee_ce_u4    m3290a_swio15_noled_pr_ee_ce_u4   m3290p_swio15_noled_pr_ee_ce_u4
 * m3290pa_swio15_noled_pr_ee_ce_u4  m325_swio15_noled_pr_ee_ce_u4     m325a_swio15_noled_pr_ee_ce_u4
 * m325p_swio15_noled_pr_ee_ce_u4    m325pa_swio15_noled_pr_ee_ce_u4   m3250_swio15_noled_pr_ee_ce_u4
 * m3250a_swio15_noled_pr_ee_ce_u4   m3250p_swio15_noled_pr_ee_ce_u4   m3250pa_swio15_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio15_noled_pr_ee_ce_u4[] = {
  0xd1bbbbbb448692df, 0xc5ddaabfa9d89892, 0x3d7adba34f1782fc, 0x8c2a0006713ae0fd, 0xcdd333582165b3d6,
  0xde4eea8fa10abe26, 0x374c13e30120862d, 0x74a0b5dffd8aecfe, 0x6d01c6bbb8bea8f6, 0x1b09117dc4963cf3,
  0xb82e1fff51f097e2, 0x6b736f7ccf1771b8, 0xc19ebea3cace1ca7, 0xa05315975f51f06c, 0x30b2c4522cd3ad08,
  0x7576e4ac3a909afa, 0x3af3a6edd423c90e, 0x51f22383f6355e36, 0x8e1bd96cb98b8484, 0xa59f4982d51b044c,
  0x9c673141daf2e556, 0xdf57673a8a9546bb, 0xd221cd674dcaed52, 0x44579621a55abfdf, 0xc34ef3e2d75cf6ab,
  0xe33a2041dd4d8a53, 0xbd8aaa2d2da2718d, 0x3612e65f36c6431d, 0xfc1ddc68b1be1b8f, 0x79430a9cfd4eaccd,
  0x1fc65f989ffde1ef, 0xc0fdfb0cd0f327f8, 0x970cf4c2f8d1e8bf, 0x2c3a4a5b3e04e32c, 0x38dd16792bf73433,
  0x000000000004fc19,
};

/*
 * m329a_swio15_noled_ee_hw          m329p_swio15_noled_ee_hw          m329pa_swio15_noled_ee_hw
 * m3290_swio15_noled_ee_hw          m3290a_swio15_noled_ee_hw         m3290p_swio15_noled_ee_hw
 * m3290pa_swio15_noled_ee_hw        m325_swio15_noled_ee_hw           m325a_swio15_noled_ee_hw
 * m325p_swio15_noled_ee_hw          m325pa_swio15_noled_ee_hw         m3250_swio15_noled_ee_hw
 * m3250a_swio15_noled_ee_hw         m3250p_swio15_noled_ee_hw         m3250pa_swio15_noled_ee_hw
 */
static const uint64_t ur_m329_swio15_noled_ee_hw[] = {
  0x8feeeeeed1219541, 0x26eed55f85ea2c4b, 0x0da67bbe3f6df373, 0xfd686d1337aed2c9, 0x8d2b452b620da0b8,
  0x2dde4ee80a499a73, 0x7c9d4c13e3012086, 0xa37f25062b7fd0a6, 0x84ff51e5652e6ab5, 0xdf15943f51f06cc1,
  0xb2c4522cd3ad08a1, 0x565c6b26909afa30, 0x76ea11e4873ab4ba, 0xe0fd8d56ba1d79d3, 0x5b2e62e121147c88,
  0xc16a8d823f5b86f6, 0xa0ed7972ab500ba4, 0x9d454aa35dce3398, 0xb3a6e576a96fabb3, 0x10d2ad5fefe910e6,
  0xf16bae7b55a22bcb, 0x20eea6c529e1a779, 0x1696d138c6f19d10, 0x97cdb1922adec555, 0x9fa82ec6e3cd84b9,
  0x13ffbc3def286153, 0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61, 0x67c09c6592e19e98, 0x257ee6866587494b,
  0x0000016ffe49d14f,
};

/*
 * m329_swio15_noled_ee_ce_u4_hw     m329a_swio15_noled_ee_ce_hw       m329a_swio15_noled_ee_ce_u4_hw
 * m329p_swio15_noled_ee_ce_hw       m329p_swio15_noled_ee_ce_u4_hw    m329pa_swio15_noled_ee_ce_hw
 * m329pa_swio15_noled_ee_ce_u4_hw   m3290_swio15_noled_ee_ce_hw       m3290_swio15_noled_ee_ce_u4_hw
 * m3290a_swio15_noled_ee_ce_hw      m3290a_swio15_noled_ee_ce_u4_hw   m3290p_swio15_noled_ee_ce_hw
 * m3290p_swio15_noled_ee_ce_u4_hw   m3290pa_swio15_noled_ee_ce_hw     m3290pa_swio15_noled_ee_ce_u4_hw
 * m325_swio15_noled_ee_ce_hw        m325_swio15_noled_ee_ce_u4_hw     m325a_swio15_noled_ee_ce_hw
 * m325a_swio15_noled_ee_ce_u4_hw    m325p_swio15_noled_ee_ce_hw       m325p_swio15_noled_ee_ce_u4_hw
 * m325pa_swio15_noled_ee_ce_hw      m325pa_swio15_noled_ee_ce_u4_hw   m3250_swio15_noled_ee_ce_hw
 * m3250_swio15_noled_ee_ce_u4_hw    m3250a_swio15_noled_ee_ce_hw      m3250a_swio15_noled_ee_ce_u4_hw
 * m3250p_swio15_noled_ee_ce_hw      m3250p_swio15_noled_ee_ce_u4_hw   m3250pa_swio15_noled_ee_ce_hw
 * m3250pa_swio15_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio15_noled_ee_ce_hw[] = {
  0x68dddddda2436812, 0x62eed55fd4ec4c49, 0x9ebd6dd1a78bc17e, 0x46150003389d707e, 0xe6e999ac10b2d9eb,
  0x16ef27777ec2da9a, 0x7f1ba609f1809043, 0x8f674a0b5dffd0a6, 0xcf36d01c6bbb8bea, 0x7e21b09117dc4963,
  0x373907575ff51f09, 0x94ed6e6def99e2ee, 0x0d9833d7d47959c3, 0xa1140a62b2ebea3e, 0x5f4616588a459a75,
  0x21ceaedc95875213, 0xc6c75e74ddba8479, 0x908a3e44707ec6ab, 0x8991c37b2d973170, 0xaad4b3e9305aa360,
  0xd7738ce6283b5e5c, 0xaa5beaece75152a8, 0xfbfa4439ace9b95d, 0xd5688af2c434ab57, 0x4a7869de7c5aeb9e,
  0x31bc6744083ba9b1, 0x63b7b15545a5b44e, 0x71e6c25ccbe6d8c8, 0xf79430a9cfd41763, 0x81fc65f989ffde1e,
  0xfc0fdfb0cd0f327f, 0xc970cf4c2f8d1e8b, 0x32c3a4a5b3e04e32, 0x432728a792bf7343, 0x0000000000000140,
};

/*
 * m329a_swio15_lednop               m329p_swio15_lednop               m329pa_swio15_lednop
 * m3290_swio15_lednop               m3290a_swio15_lednop              m3290p_swio15_lednop
 * m3290pa_swio15_lednop             m325_swio15_lednop                m325a_swio15_lednop
 * m325p_swio15_lednop               m325pa_swio15_lednop              m3250_swio15_lednop
 * m3250a_swio15_lednop              m3250p_swio15_lednop              m3250pa_swio15_lednop
 */
static const uint64_t ur_m329_swio15_lednop[] = {
  0x5a9377777759bb37, 0x27adddaab914ad22, 0xdfbe3f77d7f858c2, 0xa905fd0eee27684d, 0xc869b1006dbe3fbb,
  0x02410c5bbc9ddb1e, 0xfbf43cfc069827c6, 0xc90ef96e925043df, 0x98c71d3f83e7bd47, 0xe90e62c05bdd3750,
  0x2c608ebc5cec22a3, 0xaf2e556a5660bdc7, 0xa9546bb9c673141d, 0xdcaed52df57673a8, 0x563d221cd7020274,
  0xf6ab44579621a572, 0x4b5e5380b9d01e5c, 0x7d14085a561130bd, 0xe6da718de33a2051, 0xe4fcfec376c25ccb,
  0x25138cb25c33d30a, 0xfdcd0ccb0e9296cb, 0x000549f5eb8f9e4a,
};

/*
 * m329_swio15_lednop_pr_u4          m329a_swio15_lednop_pr            m329a_swio15_lednop_pr_u4
 * m329p_swio15_lednop_pr            m329p_swio15_lednop_pr_u4         m329pa_swio15_lednop_pr
 * m329pa_swio15_lednop_pr_u4        m3290_swio15_lednop_pr            m3290_swio15_lednop_pr_u4
 * m3290a_swio15_lednop_pr           m3290a_swio15_lednop_pr_u4        m3290p_swio15_lednop_pr
 * m3290p_swio15_lednop_pr_u4        m3290pa_swio15_lednop_pr          m3290pa_swio15_lednop_pr_u4
 * m325_swio15_lednop_pr             m325_swio15_lednop_pr_u4          m325a_swio15_lednop_pr
 * m325a_swio15_lednop_pr_u4         m325p_swio15_lednop_pr            m325p_swio15_lednop_pr_u4
 * m325pa_swio15_lednop_pr           m325pa_swio15_lednop_pr_u4        m3250_swio15_lednop_pr
 * m3250_swio15_lednop_pr_u4         m3250a_swio15_lednop_pr           m3250a_swio15_lednop_pr_u4
 * m3250p_swio15_lednop_pr           m3250p_swio15_lednop_pr_u4        m3250pa_swio15_lednop_pr
 * m3250pa_swio15_lednop_pr_u4
 */
static const uint64_t ur_m329_swio15_lednop_pr[] = {
  0x277777768911d38b, 0x1776aae45017c4ae, 0x86ad1a6d7af6c13c, 0x59ac683e3e00f164, 0x4f4da9b11ddb89d0,
  0x7793ba8cca734b29, 0xa95304f8c048218b, 0x07e504c7ff9e059f, 0xf07d07a8fa51df2d, 0x2cb29a0304f8e3a7,
  0x3e765f11c6473160, 0xb86a807fecc11d7a, 0xad6e1c81e59ed8df, 0x7738ce6283b5e5ca, 0xa5beaece75152a8d,
  0x439ae0404e9b95da, 0x8af2c434ae4ac7a4, 0xd01e395aeb9ed568, 0xd10210a905ca5af9, 0x2aa8b490538c6f19,
  0x9732f9b6815156f6, 0xa2c6f8b9357079b0, 0x73f53ab31e40fca1, 0x627ff787bde50c2a, 0x3343cc9fe07f197e,
  0x0be347a2ff03f7ec, 0x6cf8138cb25c33d3, 0xe4afdcd0ccb0e929, 0x00003e4ffaa22029,
};

/*
 * m329a_swio15_lednop_pr_ee         m329p_swio15_lednop_pr_ee         m329pa_swio15_lednop_pr_ee
 * m3290_swio15_lednop_pr_ee         m3290a_swio15_lednop_pr_ee        m3290p_swio15_lednop_pr_ee
 * m3290pa_swio15_lednop_pr_ee       m325_swio15_lednop_pr_ee          m325a_swio15_lednop_pr_ee
 * m325p_swio15_lednop_pr_ee         m325pa_swio15_lednop_pr_ee        m3250_swio15_lednop_pr_ee
 * m3250a_swio15_lednop_pr_ee        m3250p_swio15_lednop_pr_ee        m3250pa_swio15_lednop_pr_ee
 */
static const uint64_t ur_m329_swio15_lednop_pr_ee[] = {
  0xfeeeeeeea0a22044, 0x6eed55f85c8fc4b8, 0x0ef4ed85f0073732, 0xa1b44cea2bd76416, 0x2b8cdd883682e3f5,
  0x9dd4149c8c884331, 0x9827c602410c5bbc, 0x504e0ff9e059fa1f, 0x1e56a7a6ab5a37f2, 0x04f51f06cc184ff5,
  0x22cd3ad08a1df15e, 0xb26909afa30b2c45, 0x182873ab4bc875c6, 0xd56ba1d79d376ee9, 0x2e121144dc8f22d8,
  0xd823f5b86f65b2e6, 0xcb955a80422934a8, 0x551aee719cc5076b, 0x2bb54b7d5d9cea2a, 0x8f488735c0809d37,
  0xaad115e588695c95, 0xb5f3a03c72b5d73d, 0xde33a20421520b94, 0xadec55516920a718, 0xf3612e65f36d02a2,
  0xca1a2cb579726ae0, 0xc2a73f53ab31e40f, 0xf9a1e64ff0271a50, 0x964b867a615c9f80, 0x19961d252d9f0271,
  0xbe10c4053c95fb9a, 0x000000000000004e,
};

/*
 * m329a_swio15_lednop_pr_ee_u4      m329p_swio15_lednop_pr_ee_u4      m329pa_swio15_lednop_pr_ee_u4
 * m3290_swio15_lednop_pr_ee_u4      m3290a_swio15_lednop_pr_ee_u4     m3290p_swio15_lednop_pr_ee_u4
 * m3290pa_swio15_lednop_pr_ee_u4    m325_swio15_lednop_pr_ee_u4       m325a_swio15_lednop_pr_ee_u4
 * m325p_swio15_lednop_pr_ee_u4      m325pa_swio15_lednop_pr_ee_u4     m3250_swio15_lednop_pr_ee_u4
 * m3250a_swio15_lednop_pr_ee_u4     m3250p_swio15_lednop_pr_ee_u4     m3250pa_swio15_lednop_pr_ee_u4
 */
static const uint64_t ur_m329_swio15_lednop_pr_ee_u4[] = {
  0xbdeeeeeed1222a20, 0xb4eed55f85c19c48, 0xc8fe9a5d2e233c49, 0x5ede4531d7eb20a6, 0x6a081eb9bb106d04,
  0x5bbc9dd1ec5aa38c, 0xfa1f9827c602410c, 0x332a504e0ff9e059, 0x00f51e5670e6ab5a, 0xf8adc9fa8f83660d,
  0x962291669d68450e, 0xb5c5133484d7d185, 0x65f11c4273ab4baf, 0x16c6ab5d0ebd7537, 0x723170908a06fa31,
  0xd570b3feb70decb8, 0x738ce6283b5e5caa, 0x5beaece75152a8d7, 0x39ae0404e9b95daa, 0xaf2c434ae4ac7a44,
  0x3a03cfd6b9ed5688, 0x9ab9d5ea58594d8b, 0x78ce88139f450216, 0x79b09732f9b69c63, 0xfca1a2c6f8b93570,
  0x0c2a73f53ab31e40, 0x197e627ff787bde5, 0xf7ec3343cc9fe07f, 0x33d30be347a2ff03, 0xe9296cf8138cb25c,
  0x2029e4afdcd0ccb0, 0x0000000004eba682,
};

/*
 * m329a_swio15_lednop_pr_ce         m329p_swio15_lednop_pr_ce         m329pa_swio15_lednop_pr_ce
 * m3290_swio15_lednop_pr_ce         m3290a_swio15_lednop_pr_ce        m3290p_swio15_lednop_pr_ce
 * m3290pa_swio15_lednop_pr_ce       m325_swio15_lednop_pr_ce          m325a_swio15_lednop_pr_ce
 * m325p_swio15_lednop_pr_ce         m325pa_swio15_lednop_pr_ce        m3250_swio15_lednop_pr_ce
 * m3250a_swio15_lednop_pr_ce        m3250p_swio15_lednop_pr_ce        m3250pa_swio15_lednop_pr_ce
 */
static const uint64_t ur_m329_swio15_lednop_pr_ce[] = {
  0x4dddddd0f5a22044, 0x8eed55e11282c4a8, 0x4f4c4ec01e9583df, 0xff5fc7c699fb537f, 0x86d16a2b21bb426c,
  0xb7793ba829395c10, 0xf1ad304f8c048218, 0xbb7e5074dff9e059, 0x1e7804a9deceb8be, 0x4bf10d8488bee24b,
  0x771b8951723fa8f8, 0xe719ee58cfd64cf1, 0x9eb1c74fe0c9ef51, 0x2f88e32398b014c7, 0x403ff6678ebd1f3b,
  0xc3903cb5b86fdc35, 0x19cc5076bcb955ad, 0xd5d9cea2a551aee7, 0x5c0809d372bb54b7, 0x588695c958f48873,
  0xc72b5d73daad115e, 0x421520b94b5f3a03, 0x16920a718de33a20, 0xbe6da0518edec555, 0x3e2e4d5c1e6c25cc,
  0x75663c81f943459d, 0x5f989fca1854e7ea, 0xff04d0f327f8b9c6, 0x970cf4c2b93f1cf7, 0x2c3a4a5b3e04e32c,
  0x9e880a792bf73433, 0x000000000000dd7e,
};

/*
 * m329a_swio15_lednop_pr_ce_u4      m329p_swio15_lednop_pr_ce_u4      m329pa_swio15_lednop_pr_ce_u4
 * m3290_swio15_lednop_pr_ce_u4      m3290a_swio15_lednop_pr_ce_u4     m3290p_swio15_lednop_pr_ce_u4
 * m3290pa_swio15_lednop_pr_ce_u4    m325_swio15_lednop_pr_ce_u4       m325a_swio15_lednop_pr_ce_u4
 * m325p_swio15_lednop_pr_ce_u4      m325pa_swio15_lednop_pr_ce_u4     m3250_swio15_lednop_pr_ce_u4
 * m3250a_swio15_lednop_pr_ce_u4     m3250p_swio15_lednop_pr_ce_u4     m3250pa_swio15_lednop_pr_ce_u4
 */
static const uint64_t ur_m329_swio15_lednop_pr_ce_u4[] = {
  0x77eeeeeed1222044, 0x3eeed55e11219c4b, 0x6475a2efa5ad14cc, 0x83f85d098bcd8b1f, 0x10deb8d3537bbbbf,
  0x16ef277505272e9c, 0x3f6ea609f1809043, 0xea7aca0e04ff3c0b, 0xb1e7804a9de56b8b, 0x84bf10d8488bee24,
  0x1771b8951723fa8f, 0x7c927b9633f19ccf, 0x8148e3a7f0621fd4, 0xcf7a3b58e62c05ee, 0x45dc72c678ebc5ce,
  0xcc5076bcb955a8e8, 0xd9cea2a551aee719, 0x0809d372bb54b7d5, 0x8695c958f488735c, 0x2b5d73daad115e58,
  0x1520b94b5f3a03c7, 0x920a718de33a2042, 0x6da0518edec55516, 0x2e4d5c1e6c25ccbe, 0xacc7903f2868b1be,
  0xe1ef79430a9cfd4e, 0x27f81fc65f989ffd, 0xe8bfc0fdfb0cd0f3, 0xe32c970cf4c2f8d1, 0x34332c3a4a5b3e04,
  0x75eaca880a792bf7, 0x0000000000000003,
};

/*
 * m329a_swio15_lednop_pr_ee_ce      m329p_swio15_lednop_pr_ee_ce      m329pa_swio15_lednop_pr_ee_ce
 * m3290_swio15_lednop_pr_ee_ce      m3290a_swio15_lednop_pr_ee_ce     m3290p_swio15_lednop_pr_ee_ce
 * m3290pa_swio15_lednop_pr_ee_ce    m325_swio15_lednop_pr_ee_ce       m325a_swio15_lednop_pr_ee_ce
 * m325p_swio15_lednop_pr_ee_ce      m325pa_swio15_lednop_pr_ee_ce     m3250_swio15_lednop_pr_ee_ce
 * m3250a_swio15_lednop_pr_ee_ce     m3250p_swio15_lednop_pr_ee_ce     m3250pa_swio15_lednop_pr_ee_ce
 */
static const uint64_t ur_m329_swio15_lednop_pr_ee_ce[] = {
  0xa17eeeeeeea22044, 0xc45ddaabd8520dc4, 0x82c4ec0bd3630a18, 0xbfc7d68f4e5df250, 0x389c8ccd2c196ad0,
  0xbbc9dd4149c80504, 0xb5b9827c602410c5, 0xa5ca0a6dff9e059f, 0x00953b4db3bfea8c, 0x4e771b8a49cdffcf,
  0xaca1ca76b2b1ef98, 0xf51f06cc19ebea3c, 0xcd3ad08a05315b05, 0xa909afa30b2c4522, 0xd23050e7576e90e3,
  0x6355e363af3a6edd, 0x98b8484513723c8b, 0x51b044c8e1bd96cb, 0xd7972ab52cc45269, 0x54aa35dce3398a0e,
  0x6e576a96fabb39d4, 0x2b1e910e6b81013a, 0x7b55a22bcb10d2b9, 0x296be74078e56bae, 0x31bc67440842a417,
  0x31dbd8aaa2d2414e, 0xab8d84b997cdb40a, 0xe40fca1a2c79c5c9, 0xb867a615c9fbab31, 0x1d252d964a271964,
  0xc4053c95fb9a1996, 0x000000000029a78d,
};

/*
 * m329a_swio15_lednop_pr_ee_ce_u4   m329p_swio15_lednop_pr_ee_ce_u4   m329pa_swio15_lednop_pr_ee_ce_u4
 * m3290_swio15_lednop_pr_ee_ce_u4   m3290a_swio15_lednop_pr_ee_ce_u4  m3290p_swio15_lednop_pr_ee_ce_u4
 * m3290pa_swio15_lednop_pr_ee_ce_u4 m325_swio15_lednop_pr_ee_ce_u4    m325a_swio15_lednop_pr_ee_ce_u4
 * m325p_swio15_lednop_pr_ee_ce_u4   m325pa_swio15_lednop_pr_ee_ce_u4  m3250_swio15_lednop_pr_ee_ce_u4
 * m3250a_swio15_lednop_pr_ee_ce_u4  m3250p_swio15_lednop_pr_ee_ce_u4  m3250pa_swio15_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio15_lednop_pr_ee_ce_u4[] = {
  0xd1bbbbbb448650e3, 0xc5ddaabfa986e892, 0x1d015baf5cfd82fc, 0x8c2a000676262779, 0xdd914e8e2165b3d6,
  0x7793ba1607db29c2, 0x6b7304f8c048218b, 0xce941149ff62bb3e, 0x36d01c149717d51e, 0x21b09117dc4963cf,
  0x19ebf5abf51f097e, 0xed6e6def99e2ee37, 0x9833d7d479594394, 0x140a62b60bea3e0d, 0x4616588a459a75a1,
  0xceaedd21c752135f, 0xc75e74ddbba460a1, 0x8a26e47916c6abc6, 0x91c37b2d97317090, 0x6a5988a4d2a36089,
  0xb9c673141daf2e55, 0x2df57673a8a9546b, 0x1cd7020274dcaed5, 0x579621a572563d22, 0x80f1cad75cf6ab44,
  0x881085482e52d7ce, 0x5545a4829c6378ce, 0x732f9b681463b7b1, 0xee3458df0dc79b09, 0x854e7ea75666fe0e,
  0x2fcc4ffef0f7bca1, 0xfd86687993fc0fe3, 0x7a617c68f45fe07e, 0x252d9f0271964b86, 0x8b3c95fb9a19961d,
  0x00000004fc07936e,
};

/*
 * m329a_swio15_lednop_ee_hw         m329p_swio15_lednop_ee_hw         m329pa_swio15_lednop_ee_hw
 * m3290_swio15_lednop_ee_hw         m3290a_swio15_lednop_ee_hw        m3290p_swio15_lednop_ee_hw
 * m3290pa_swio15_lednop_ee_hw       m325_swio15_lednop_ee_hw          m325a_swio15_lednop_ee_hw
 * m325p_swio15_lednop_ee_hw         m325pa_swio15_lednop_ee_hw        m3250_swio15_lednop_ee_hw
 * m3250a_swio15_lednop_ee_hw        m3250p_swio15_lednop_ee_hw        m3250pa_swio15_lednop_ee_hw
 */
static const uint64_t ur_m329_swio15_lednop_ee_hw[] = {
  0xc7f777776890c582, 0x93776aafc2e47e25, 0x43560eec2f8039b9, 0x3f5a1b44cea2bd76, 0xa312b8cdd883682e,
  0x8b7793ba76821e96, 0x3f43f304f8c04821, 0xd1bf9282707fe853, 0xc27fa8f2b53d355a, 0xef8af027a8f83660,
  0x5962291669d68450, 0x43ae3593484d7d18, 0xbb7748c1439d5a5e, 0x7916c6ab5d0ebce9, 0x2d973170908a26e4,
  0x49a546c11fadc37b, 0x283b5e5caad40211, 0xe75152a8d7738ce6, 0x04e9b95daa5beaec, 0x4ae4ac7a4439ae04,
  0xaeb9ed5688af2c43, 0x905ca5af9d01e395, 0x0538c6f19d10210a, 0x6815156f62aa8b49, 0x5d8dc79b09732f9b,
  0x787bde50c2a73f50, 0xc9fe07f197e627ff, 0x7a2ff03f7ec3343c, 0x38cb25c33d30be34, 0xcd0ccb0e9296cf81,
  0x02df9a9ca29e4afd,
};

/*
 * m329_swio15_lednop_ee_ce_u4_hw    m329a_swio15_lednop_ee_ce_hw      m329a_swio15_lednop_ee_ce_u4_hw
 * m329p_swio15_lednop_ee_ce_hw      m329p_swio15_lednop_ee_ce_u4_hw   m329pa_swio15_lednop_ee_ce_hw
 * m329pa_swio15_lednop_ee_ce_u4_hw  m3290_swio15_lednop_ee_ce_hw      m3290_swio15_lednop_ee_ce_u4_hw
 * m3290a_swio15_lednop_ee_ce_hw     m3290a_swio15_lednop_ee_ce_u4_hw  m3290p_swio15_lednop_ee_ce_hw
 * m3290p_swio15_lednop_ee_ce_u4_hw  m3290pa_swio15_lednop_ee_ce_hw    m3290pa_swio15_lednop_ee_ce_u4_hw
 * m325_swio15_lednop_ee_ce_hw       m325_swio15_lednop_ee_ce_u4_hw    m325a_swio15_lednop_ee_ce_hw
 * m325a_swio15_lednop_ee_ce_u4_hw   m325p_swio15_lednop_ee_ce_hw      m325p_swio15_lednop_ee_ce_u4_hw
 * m325pa_swio15_lednop_ee_ce_hw     m325pa_swio15_lednop_ee_ce_u4_hw  m3250_swio15_lednop_ee_ce_hw
 * m3250_swio15_lednop_ee_ce_u4_hw   m3250a_swio15_lednop_ee_ce_hw     m3250a_swio15_lednop_ee_ce_u4_hw
 * m3250p_swio15_lednop_ee_ce_hw     m3250p_swio15_lednop_ee_ce_u4_hw  m3250pa_swio15_lednop_ee_ce_hw
 * m3250pa_swio15_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio15_lednop_ee_ce_hw[] = {
  0x68dddddda243704a, 0x62eed55fd4c37449, 0x8e80add7ae7ec17e, 0x461500033b1313bc, 0xeec8a74710b2d9eb,
  0x5bbc9dd75bae3b5d, 0xf35b9827c602410c, 0x1ece941149ff4299, 0xcf36d01c149717d5, 0x7e21b09117dc4963,
  0x8dcf39753bf51f09, 0xe53b5b9b7be678bb, 0x83660cf5f51e5650, 0x68450298ad82fa8f, 0xd7d185962291669d,
  0x2873abb74871d484, 0xf1b1d79d376ee918, 0x242289b91e45b1aa, 0x226470decb65cc5c, 0x955a96622934a8d8,
  0x1aee719cc5076bcb, 0xb54b7d5d9cea2a55, 0x488735c0809d372b, 0xd115e588695c958f, 0xf3a03c72b5d73daa,
  0x33a20421520b94b5, 0xec55516920a718de, 0xc25ccbe6da0518ed, 0x30a9cfd4176371e6, 0x65f989ffde1ef794,
  0xdfb0cd0f327f81fc, 0xcf4c2f8d1e8bfc0f, 0xa4a5b3e04e32c970, 0xe8a792bf734332c3, 0x00000000028081e4,
};

/*
 * m329_swio15_dual_pr               m329_swio15_dual_pr_u4            m329a_swio15_dual
 * m329a_swio15_dual_pr              m329a_swio15_dual_pr_u4           m329p_swio15_dual
 * m329p_swio15_dual_pr              m329p_swio15_dual_pr_u4           m329pa_swio15_dual
 * m329pa_swio15_dual_pr             m329pa_swio15_dual_pr_u4          m3290_swio15_dual
 * m3290_swio15_dual_pr              m3290_swio15_dual_pr_u4           m3290a_swio15_dual
 * m3290a_swio15_dual_pr             m3290a_swio15_dual_pr_u4          m3290p_swio15_dual
 * m3290p_swio15_dual_pr             m3290p_swio15_dual_pr_u4          m3290pa_swio15_dual
 * m3290pa_swio15_dual_pr            m3290pa_swio15_dual_pr_u4         m325_swio15_dual
 * m325_swio15_dual_pr               m325_swio15_dual_pr_u4            m325a_swio15_dual
 * m325a_swio15_dual_pr              m325a_swio15_dual_pr_u4           m325p_swio15_dual
 * m325p_swio15_dual_pr              m325p_swio15_dual_pr_u4           m325pa_swio15_dual
 * m325pa_swio15_dual_pr             m325pa_swio15_dual_pr_u4          m3250_swio15_dual
 * m3250_swio15_dual_pr              m3250_swio15_dual_pr_u4           m3250a_swio15_dual
 * m3250a_swio15_dual_pr             m3250a_swio15_dual_pr_u4          m3250p_swio15_dual
 * m3250p_swio15_dual_pr             m3250p_swio15_dual_pr_u4          m3250pa_swio15_dual
 * m3250pa_swio15_dual_pr            m3250pa_swio15_dual_pr_u4
 */
static const uint64_t ur_m329_swio15_dual[] = {
  0xc7bbbbbb44869a4e, 0x7e276fc75e10cda5, 0xb9f7ba8ce5dd0b69, 0x1fc5fc95264e2765, 0xe19628d4d8b75719,
  0x2b43bb8fea3151f1, 0x304f8c048218b779, 0xdd6d032252522e87, 0x4b881850c1b48c0d, 0x3393fccae833ba7c,
  0xea3bf9b05f67028b, 0x114239227f06654d, 0x70f8510c4aff3f7c, 0x2abbbddf37200003, 0xb5a2a10cb4232443,
  0x25b7287ff4073c26, 0xbfdcd7982c3795e4, 0x7dbe77cb3df283fb, 0x47b8e3a7f0707fd4, 0x884e62c05507992b,
  0xb30475e00ceda523, 0xe59eda63192a01ff, 0x157ceee2a4b81281, 0xe6283b5e5caad67f, 0xece75152a8d7738c,
  0x0404e9b95daa5bea, 0x434ae4ac7a4439ae, 0x95aeb9ed5688af2c, 0x0a905ca5af9d01e3, 0x490538c6f19d1021,
  0x9b6815156f62aa8b, 0x58df0dc79b09732f, 0x7ea75666fe0eee34, 0x4ffef0f7bca1854e, 0x687993fc0fe32fcc,
  0x7c68f45fe07efd86, 0x9f0271964b867a61, 0x95fb9a19961d252d, 0x000a49ef056e8b3c,
};

/*
 * m329a_swio15_dual_pr_ee           m329p_swio15_dual_pr_ee           m329pa_swio15_dual_pr_ee
 * m3290_swio15_dual_pr_ee           m3290a_swio15_dual_pr_ee          m3290p_swio15_dual_pr_ee
 * m3290pa_swio15_dual_pr_ee         m325_swio15_dual_pr_ee            m325a_swio15_dual_pr_ee
 * m325p_swio15_dual_pr_ee           m325pa_swio15_dual_pr_ee          m3250_swio15_dual_pr_ee
 * m3250a_swio15_dual_pr_ee          m3250p_swio15_dual_pr_ee          m3250pa_swio15_dual_pr_ee
 */
static const uint64_t ur_m329_swio15_dual_pr_ee[] = {
  0x586ddddddd43573e, 0xc8f89dbf1a99366d, 0x5f47e6ea729c502c, 0xcf59198f6d9beec7, 0xf700faabc99bd7b0,
  0xe772e2fbb0af7aca, 0x3e30120862dde4f4, 0x6819129290e9d4c1, 0x40c2860da4606eeb, 0xffe657419dd3e25c,
  0x275b04b4700b5318, 0x8e489fc1c569bd47, 0x144312bfcfdf0450, 0xbddf373bac00dc3e, 0x4219682fb4432abb,
  0xedffd01cf0983dc5, 0xbcc161bcaf212dbc, 0x5a3727283d3ffee6, 0x1c7bf51e57a6e6ab, 0x1df15ecef51f06cc,
  0x0b2c4522cd3ad08a, 0xa797152e6909afa3, 0x5d9fc47d41cead2e, 0x1fc96355ae875ea2, 0x97d2cc5c242283d5,
  0x9bdaa3608fd6e1bd, 0xf157ceee2a4a010f, 0xce6283b5e5caad67, 0xaece75152a8d7738, 0xe0404e9b95daa5be,
  0xc434ae4ac7a4439a, 0x395aeb9ed5688af2, 0x10a905ca5af9d01e, 0xb490538c6f19d102, 0xf9b6815156f62aa8,
  0x8b1e70dc79b09732, 0x727eeaccdfc1ddc6, 0x7c09c6592e19e985, 0x57ee6866587494b6, 0x003214b1fdba2cf2,
};

/*
 * m329a_swio15_dual_pr_ee_u4        m329p_swio15_dual_pr_ee_u4        m329pa_swio15_dual_pr_ee_u4
 * m3290_swio15_dual_pr_ee_u4        m3290a_swio15_dual_pr_ee_u4       m3290p_swio15_dual_pr_ee_u4
 * m3290pa_swio15_dual_pr_ee_u4      m325_swio15_dual_pr_ee_u4         m325a_swio15_dual_pr_ee_u4
 * m325p_swio15_dual_pr_ee_u4        m325pa_swio15_dual_pr_ee_u4       m3250_swio15_dual_pr_ee_u4
 * m3250a_swio15_dual_pr_ee_u4       m3250p_swio15_dual_pr_ee_u4       m3250pa_swio15_dual_pr_ee_u4
 */
static const uint64_t ur_m329_swio15_dual_pr_ee_u4[] = {
  0xb7777768adbb3202, 0xe276fc6a64d9b561, 0xa339a9ca7140b323, 0x663db66fbb1d71f9, 0xeaaf266f5ec33d64,
  0x41f5d717d35bdc03, 0x10c5bbc9e9cee1a7, 0x2521d3a9827c6024, 0x1b48c0ddd6d03225, 0xe53ba7c4b881850c,
  0x4700b5318ffe65a0, 0x1c569bd47275b04b, 0xfcfdf04508e489fc, 0xbac00dc3e144312b, 0xfb4432abbbddf373,
  0xcf0983dc54219682, 0xcaf212dbcedffd01, 0x0f4fffe3f0cc161b, 0x95e9b9aad68dc9ca, 0xbd47c1b3071efd47,
  0xb34eb422877c57b3, 0x9a426be8c2cb1148, 0x5073ab4ba9e5c54b, 0x6ba1d7a89767f11f, 0x0908a0f547f258d5,
  0x23f5b86f65f4b317, 0x8a928043e6f6a8d8, 0x7972ab59fc55f3bb, 0x4aa35dce3398a0ed, 0xe576a96fabb39d45,
  0xb1e910e6b81013a6, 0xb55a22bcb10d2b92, 0x96be74078e56bae7, 0x1bc67440842a4172, 0x55bd8aaa2d2414e3,
  0x1e6c25ccbe6da054, 0xf6ec68b1be2e4d5c, 0x61539fa9d599bf83, 0xcbf313ffbc3def28, 0xbf619a1e64ff03f8,
  0x9e985f1a3d17f81f, 0x494b67c09c6592e1, 0x374f257ee6866587, 0x00000002b225b4f2,
};

/*
 * m329a_swio15_dual_pr_ce           m329p_swio15_dual_pr_ce           m329pa_swio15_dual_pr_ce
 * m3290_swio15_dual_pr_ce           m3290a_swio15_dual_pr_ce          m3290p_swio15_dual_pr_ce
 * m3290pa_swio15_dual_pr_ce         m325_swio15_dual_pr_ce            m325a_swio15_dual_pr_ce
 * m325p_swio15_dual_pr_ce           m325pa_swio15_dual_pr_ce          m3250_swio15_dual_pr_ce
 * m3250a_swio15_dual_pr_ce          m3250p_swio15_dual_pr_ce          m3250pa_swio15_dual_pr_ce
 */
static const uint64_t ur_m329_swio15_dual_pr_ce[] = {
  0x9dbbbbbbd82432db, 0x3e276fcf1f5c4da2, 0xae17bb3890523bb8, 0x6e9776182ca3e9f7, 0xe908766c75f74a70,
  0x4c4bb8e08ab2c10c, 0x609f180904316ef2, 0xbada0644a4a40aa2, 0x971030a18369181b, 0xdd5ff995d06774f8,
  0x51f676c2391c0e0c, 0x14239227f072ba6f, 0x0f8510c4aff3f7c1, 0xaeef77cdc0448037, 0xf150865a01ed10ca,
  0xb7ff9ff4073c2609, 0xdcd7982c3795e425, 0x7dc5f580d2824ebf, 0xee24b1e79b680e75, 0xfa8f84bf10d8488b,
  0x5ccf1771b9d66c87, 0x17d479127b9633ea, 0x05fdc65471d3f831, 0x00ceda523884e62c, 0x3192a01ffb33c75e,
  0x8a92e04a0796b726, 0x7972ab59fc55f3bb, 0x4aa35dce3398a0ed, 0xe576a96fabb39d45, 0xb1e910e6b81013a6,
  0xb55a22bcb10d2b92, 0x96be74078e56bae7, 0x1bc67440842a4172, 0x1dbd8aaa2d2414e3, 0x3cd84b997cdb40a3,
  0xbf83bb8d165abc6e, 0x8d2861539fa9d599, 0x4fc07cd0f327f813, 0x8138cb25c33d30ae, 0xfdcd0ccb0e9296cf,
  0x00d242b537459e4a,
};

/*
 * m329a_swio15_dual_pr_ce_u4        m329p_swio15_dual_pr_ce_u4        m329pa_swio15_dual_pr_ce_u4
 * m3290_swio15_dual_pr_ce_u4        m3290a_swio15_dual_pr_ce_u4       m3290p_swio15_dual_pr_ce_u4
 * m3290pa_swio15_dual_pr_ce_u4      m325_swio15_dual_pr_ce_u4         m325a_swio15_dual_pr_ce_u4
 * m325p_swio15_dual_pr_ce_u4        m325pa_swio15_dual_pr_ce_u4       m3250_swio15_dual_pr_ce_u4
 * m3250a_swio15_dual_pr_ce_u4       m3250p_swio15_dual_pr_ce_u4       m3250pa_swio15_dual_pr_ce_u4
 */
static const uint64_t ur_m329_swio15_dual_pr_ce_u4[] = {
  0xb13bbbbbb4486f97, 0x3bc4edf9e3f3ecda, 0x3deef75053d68e3d, 0x89c9d4cca76f5d84, 0x2d4e900d57efdeed,
  0xef25a2bb9e08ce9c, 0x8c6609f180904316, 0x03775b40c8949488, 0x9f12e20614306d23, 0x4dcd15bf32ba0cee,
  0xe6f51f2b6c37d9c3, 0x7c114239227f0650, 0x0370f8510c4aff3f, 0x8655777bbe6e3218, 0x9a718a8432d009e8,
  0x212db8cdffd01cf0, 0x83fee6bcc161bcaf, 0x1cc09717d4ca9413, 0x9117dc4963cf36d0, 0x2e47f51f097e21b0,
  0x6787199e2ee3712a, 0xf064d7a8f38cf72c, 0xe62c0532a6e8e3a7, 0xe3af22dd96ba38c8, 0xe2a4a3ab5b71cb19,
  0x5e5caad67f157cee, 0x52a8d7738ce6283b, 0xb95daa5beaece751, 0xac7a4439ae0404e9, 0xed5688af2c434ae4,
  0x594d8b3a03cfd6b9, 0x3182169ab9d5ea58, 0x6d38c6f19d10273e, 0x1be1b8f3612e65f3, 0xd4eaccdfc1ddc68b,
  0xffde1ef79430a9cf, 0x0f327f81fc65f989, 0x8d1e8bfc0fdfb0cd, 0xe04e32c970cf4c2f, 0xbf734332c3a4a5b3,
  0x003490216dd16792,
};

/*
 * m329a_swio15_dual_pr_ee_ce        m329p_swio15_dual_pr_ee_ce        m329pa_swio15_dual_pr_ee_ce
 * m3290_swio15_dual_pr_ee_ce        m3290a_swio15_dual_pr_ee_ce       m3290p_swio15_dual_pr_ee_ce
 * m3290pa_swio15_dual_pr_ee_ce      m325_swio15_dual_pr_ee_ce         m325a_swio15_dual_pr_ee_ce
 * m325p_swio15_dual_pr_ee_ce        m325pa_swio15_dual_pr_ee_ce       m3250_swio15_dual_pr_ee_ce
 * m3250a_swio15_dual_pr_ee_ce       m3250p_swio15_dual_pr_ee_ce       m3250pa_swio15_dual_pr_ee_ce
 */
static const uint64_t ur_m329_swio15_dual_pr_ee_ce[] = {
  0x5f6b77777750cf68, 0xeb789dbf1888ce1b, 0xda57bddcfb67d619, 0x2be37410f225c2c2, 0x7f9b4d9b537c97ed,
  0x3b9a3ea74704dd9c, 0xf180904316ef2727, 0x81912929047ae609, 0x0c2860da4606eeb6, 0x7e657419dd3e25c4,
  0xfcd80683869a99fe, 0xe489fc1f4fcdea3f, 0x44312bfcfdf04508, 0xbbe6e0c2e00dc3e1, 0x432d038688655777,
  0xeffa039e133938a8, 0x982c3795e425b7c6, 0x46c1650676ffdcd7, 0xe79b680e4ed9dff5, 0x984e771b8089300f,
  0x3cad4f4a76b2b221, 0x09ea3e0d98309fea, 0x459a75a1140a62bc, 0x4752135f4616588a, 0x8ca47389ceaedc5d,
  0x7b1aaf1b1d7b589d, 0xf18b8484512f91ad, 0x2e311f0c8e1bd971, 0x2ab59fc55f3bb8a9, 0x35dce3398a0ed797,
  0x6a96fabb39d454aa, 0x910e6b81013a6e57, 0xa22bcb10d2b92b1e, 0xe74078e56bae7b55, 0x67440842a417296b,
  0xd8aaa2d2414e31bc, 0x84b997cdb40a31db, 0x0eee3458f386e3cd, 0xcf4c2b93f75666fe, 0xa4a5b3e04e32c970,
  0xd16792bf734332c3, 0x000000002608a9cd,
};

/*
 * m329a_swio15_dual_pr_ee_ce_u4     m329p_swio15_dual_pr_ee_ce_u4     m329pa_swio15_dual_pr_ee_ce_u4
 * m3290_swio15_dual_pr_ee_ce_u4     m3290a_swio15_dual_pr_ee_ce_u4    m3290p_swio15_dual_pr_ee_ce_u4
 * m3290pa_swio15_dual_pr_ee_ce_u4   m325_swio15_dual_pr_ee_ce_u4      m325a_swio15_dual_pr_ee_ce_u4
 * m325p_swio15_dual_pr_ee_ce_u4     m325pa_swio15_dual_pr_ee_ce_u4    m3250_swio15_dual_pr_ee_ce_u4
 * m3250a_swio15_dual_pr_ee_ce_u4    m3250p_swio15_dual_pr_ee_ce_u4    m3250pa_swio15_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m329_swio15_dual_pr_ee_ce_u4[] = {
  0xeeeeeed15b77d8be, 0x276fccc54626d157, 0x9afbdda8f84339de, 0x6af2657bc89ada6f, 0x4377138abec5e715,
  0x3ebeca9c7829649b, 0xbbc96c4eea0d599a, 0xea89827c602410c5, 0x81bbada0644a4a45, 0x4f8971030a183691,
  0x0e6e5afccb41ca77, 0xbd47c6ed87609c2f, 0x08a11c913f836bb9, 0xb87c2886257f9fbe, 0xaaeef77cdc4e3c01,
  0xf7150865a11c910c, 0xb6e495ff4073c26d, 0xf8fc330586f2bc84, 0xc5f547d5f28330df, 0x1258f3cdb49dcc35,
  0x47c25f886c2445f7, 0x78bb8dc4e3fb8ffd, 0x57bee53b5b9b9ba6, 0x7a8f83660ccaf51e, 0x669d68450298aedd,
  0xd484d7d185962291, 0xf11f5073abb729e1, 0xb1aaf1b1d7a89767, 0x662e121141ea8fe4, 0xa8d8226470decbe9,
  0xf3bb8a929663e6f6, 0xa0ed7972ab59fc55, 0x9d454aa35dce3398, 0x13a6e576a96fabb3, 0x2b92b1e910e6b810,
  0xbae7b55a22bcb10d, 0x417296be74078e56, 0x14e31bc67440842a, 0x40a31dbd8aaa2d24, 0x9ab83cd84b997cdb,
  0x7f07edd8d1637c5c, 0xde50c2a73f53ab33, 0x07f197e627ff787b, 0xf03f7ec3343cc9fe, 0x25c33d30be347a2f,
  0xcb0e9296cf8138cb, 0x17e46e9e4afdcd0c, 0x0000000000100010,
};

/*
 * m329a_swio15_dual_ee_hw           m329p_swio15_dual_ee_hw           m329pa_swio15_dual_ee_hw
 * m3290_swio15_dual_ee_hw           m3290a_swio15_dual_ee_hw          m3290p_swio15_dual_ee_hw
 * m3290pa_swio15_dual_ee_hw         m325_swio15_dual_ee_hw            m325a_swio15_dual_ee_hw
 * m325p_swio15_dual_ee_hw           m325pa_swio15_dual_ee_hw          m3250_swio15_dual_ee_hw
 * m3250a_swio15_dual_ee_hw          m3250p_swio15_dual_ee_hw          m3250pa_swio15_dual_ee_hw
 */
static const uint64_t ur_m329_swio15_dual_ee_hw[] = {
  0xc36eeeee87ad0c86, 0x47c4edf8d4c9b36a, 0xfa3f375394e28166, 0x7ac8cc7b6cdf763a, 0xb807d55e4cdebd86,
  0xe9ceeeec6ecde62f, 0x827c602410c5bbc9, 0xd6d032252521d3a9, 0xb881850c1b48c0dd, 0x31ffccae833ba7c4,
  0x8e4eb60968e016a6, 0xa11c913f838ad37a, 0x7c2886257f9fbe08, 0x777bbe6e775801b8, 0x8a8432d05f688655,
  0x79dbffa039e1307b, 0xa91982c3795e425b, 0xad68dc9ca0f4ffff, 0x3071efd4795e9b9a, 0x2877c57b3bd47c1b,
  0x8c2cb1148b34eb42, 0xba9e5c54b9a426be, 0x89767f11f5073ab4, 0x547f258d56ba1d7a, 0xf65f4b3170908a0f,
  0x3e6f6a8d823f5b86, 0x9fc55f3bb8a92804, 0xe3398a0ed7972ab5, 0xfabb39d454aa35dc, 0x6b81013a6e576a96,
  0xcb10d2b92b1e910e, 0x78e56bae7b55a22b, 0x0842a417296be740, 0xa2d2414e31bc6744, 0xcbe6da05455bd8aa,
  0x7ea5eae371e6c25c, 0x9c65f989fca1854e, 0xcf7ff04d0f327f8b, 0x32c970cf4c2b93f1, 0x4332c3a4a5b3e04e,
  0x5dab1fe8a792bf73, 0x0000000000000001,
};

/*
 * m329a_swio15_dual_ee_ce_hw        m329p_swio15_dual_ee_ce_hw        m329pa_swio15_dual_ee_ce_hw
 * m3290_swio15_dual_ee_ce_hw        m3290a_swio15_dual_ee_ce_hw       m3290p_swio15_dual_ee_ce_hw
 * m3290pa_swio15_dual_ee_ce_hw      m325_swio15_dual_ee_ce_hw         m325a_swio15_dual_ee_ce_hw
 * m325p_swio15_dual_ee_ce_hw        m325pa_swio15_dual_ee_ce_hw       m3250_swio15_dual_ee_ce_hw
 * m3250a_swio15_dual_ee_ce_hw       m3250p_swio15_dual_ee_ce_hw       m3250pa_swio15_dual_ee_ce_hw
 */
static const uint64_t ur_m329_swio15_dual_ee_ce_hw[] = {
  0x9396eeeeeea1a5fb, 0xc5e276fc623c7f36, 0xd721eed17d8b9da6, 0x63d62c57d769eaef, 0xfabe1f29be4a9c92,
  0xbba591aeba55857b, 0xf180904316ef2599, 0x032252520f67a609, 0x1850c1b48c0ddd6d, 0xfccae833ba7c4b88,
  0x6b60ff0e188266bb, 0xc913f83ff937a8fa, 0x886257f9fbe08a11, 0xbbe6e059001b87c2, 0x432d060a88655777,
  0x3ffa039e134878a8, 0x982c3795e425b7bc, 0x8e574a0d6ffffa91, 0xcf36d01cadf3bfea, 0x984e771b9d1f524f,
  0x3caf7dca76b2b26e, 0xbaf51f06cc1995ea, 0x22cd3ad08a05315d, 0xc3a909afa30b2c45, 0xcfe23ea0e7576e53,
  0xc96355e363af512e, 0xd2cc5c242283d51f, 0xed51b044c8e1bd97, 0xabe77715252cc7cd, 0x3141daf2e556b3f8,
  0x673a8a9546bb9c67, 0x20274dcaed52df57, 0x1a572563d221cd70, 0xad75cf6ab4457962, 0x5482e52d7ce80f1c,
  0x4829c6378ce88108, 0xb681463b7b15545a, 0x3fb0dc79b09732f9, 0xe32c970cf4c2b93f, 0x34332c3a4a5b3e04,
  0x22698e2e8a792bf7,
};

/*
 * m329a_swio15_dual_ee_ce_u4_hw     m329p_swio15_dual_ee_ce_u4_hw     m329pa_swio15_dual_ee_ce_u4_hw
 * m3290_swio15_dual_ee_ce_u4_hw     m3290a_swio15_dual_ee_ce_u4_hw    m3290p_swio15_dual_ee_ce_u4_hw
 * m3290pa_swio15_dual_ee_ce_u4_hw   m325_swio15_dual_ee_ce_u4_hw      m325a_swio15_dual_ee_ce_u4_hw
 * m325p_swio15_dual_ee_ce_u4_hw     m325pa_swio15_dual_ee_ce_u4_hw    m3250_swio15_dual_ee_ce_u4_hw
 * m3250a_swio15_dual_ee_ce_u4_hw    m3250p_swio15_dual_ee_ce_u4_hw    m3250pa_swio15_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m329_swio15_dual_ee_ce_u4_hw[] = {
  0x7eeeeeed14682541, 0xe276fccc54626d15, 0xb69bbdda8f84339d, 0x9c55abc995ef2276, 0x926d0ddc4e2afb17,
  0x4e30cb5bb4f9e0a5, 0x120862dde4b62775, 0x252522f544c13e30, 0x0c1b48c0ddd6d032, 0x89ad3ba7c4b88185,
  0xb04e1787372d7e65, 0xc1b5dcdea3e376c3, 0xbfcfdf04508e489f, 0x271e00dc3e144312, 0x8e488655777bbe6e,
  0x39e136fb8a8432d0, 0x795e425b724affa0, 0x8330dfecf43982c3, 0x0e4c35c5f547d5f2, 0x445f71258f3cafac,
  0x3eefd47c25f886c2, 0xb9ba678bb8dce1fe, 0xaf51e57bee53b5b9, 0x8aedd7a8f83660cc, 0x62291669d6845029,
  0x729e1d484d7d1859, 0x89767f11f5073abb, 0xa8fe4b1aaf1b1d7a, 0xecbe9662e121141e, 0x3e6f6a8d8226470d,
  0x9fc55f3bb8a92966, 0xe3398a0ed7972ab5, 0xfabb39d454aa35dc, 0x6b81013a6e576a96, 0xcb10d2b92b1e910e,
  0x78e56bae7b55a22b, 0x0842a417296be740, 0xa2d2414e31bc6744, 0x97cdb40a31dbd8aa, 0x9fa82ec6e3cd84b9,
  0x13ffbc3def286153, 0x9a1e64ff03f8cbf3, 0x5f1a3d17f81fbf61, 0x67c09c6592e19e98, 0x257ee6866587494b,
  0x0001d759a3705f4f,
};

/*
 * m649_autobaud_uart0_noled_pr      m649a_autobaud_uart0_noled        m649a_autobaud_uart0_noled_pr
 * m649p_autobaud_uart0_noled        m649p_autobaud_uart0_noled_pr     m6490_autobaud_uart0_noled
 * m6490_autobaud_uart0_noled_pr     m6490a_autobaud_uart0_noled       m6490a_autobaud_uart0_noled_pr
 * m6490p_autobaud_uart0_noled       m6490p_autobaud_uart0_noled_pr    m645_autobaud_uart0_noled
 * m645_autobaud_uart0_noled_pr      m645a_autobaud_uart0_noled        m645a_autobaud_uart0_noled_pr
 * m645p_autobaud_uart0_noled        m645p_autobaud_uart0_noled_pr     m6450_autobaud_uart0_noled
 * m6450_autobaud_uart0_noled_pr     m6450a_autobaud_uart0_noled       m6450a_autobaud_uart0_noled_pr
 * m6450p_autobaud_uart0_noled       m6450p_autobaud_uart0_noled_pr
 */
static const uint64_t ur_m649_autobaud_uart0_noled[] = {
  0xc4b777777759bb37, 0xdddddddd55f85d22, 0xeea41b4d3277e68c, 0x85e6c311e3ef26ee, 0x413057793bb63d90,
  0xf43cfedf9827c602, 0xe81102a7c25d47fb, 0x5526be70e602e910, 0x921c368ded51c2bf, 0x4819a4f51f9e3be5,
  0x5bdd308ad7d490e2, 0xe76905478cce62c0, 0x58e9ee39630475e2, 0x39c2cdf81895af61, 0xde6f2dd4180ef5af,
  0x7aaeaa72f29b19c2, 0xc67440b9b8a042d3, 0x1b94b52fcdb4e31b, 0x663c81a3f8d163ce, 0x2c970cf4c2b93f75,
  0xccb0e9296ce1c4e3, 0x00b022f9e4afdcd0, 0x0000000000007110,
};

/*
 * m649a_autobaud_uart0_noled_pr_u4  m649p_autobaud_uart0_noled_pr_u4  m6490_autobaud_uart0_noled_pr_u4
 * m6490a_autobaud_uart0_noled_pr_u4 m6490p_autobaud_uart0_noled_pr_u4 m645_autobaud_uart0_noled_pr_u4
 * m645a_autobaud_uart0_noled_pr_u4  m645p_autobaud_uart0_noled_pr_u4  m6450_autobaud_uart0_noled_pr_u4
 * m6450a_autobaud_uart0_noled_pr_u4 m6450p_autobaud_uart0_noled_pr_u4
 */
static const uint64_t ur_m649_autobaud_uart0_noled_pr_u4[] = {
  0x96eeeeeed121bf82, 0xbbbbbbaabf0bedb8, 0xe1ff4bc7cc9ee63b, 0x6ea1c00f26eeedc4, 0x57793bab8c48e150,
  0xfedf9827c6024130, 0x02a7c25d47fd8aec, 0xbe70e602e910e811, 0x368ded51c2bf5526, 0x0bf51fa03be5843c,
  0x4cf7dad490e2481a, 0x57f47ac398b01659, 0x403ff6608ebd1f3b, 0xc7c0f2cf6c7d99e5, 0x73859bf0312b5ec1,
  0xe6f00fa8301deb5e, 0x0aeaa72f29b19c2d, 0x45a585ce31bc6744, 0x2fcdb1248ab7b155, 0x7771a2c8931b94b5,
  0x0c2a73f53ab337f0, 0x197e627ff787bde5, 0x07efd8668fb61c7f, 0xb867a617c68f45fe, 0x87494b670e271964,
  0x35c7cf257ee68665, 0x0000000008c3269f,
};

/*
 * m649_autobaud_uart0_noled_pr_ee_u4 m649a_autobaud_uart0_noled_pr_ee
 * m649a_autobaud_uart0_noled_pr_ee_u4 m649p_autobaud_uart0_noled_pr_ee
 * m649p_autobaud_uart0_noled_pr_ee_u4 m6490_autobaud_uart0_noled_pr_ee
 * m6490_autobaud_uart0_noled_pr_ee_u4 m6490a_autobaud_uart0_noled_pr_ee
 * m6490a_autobaud_uart0_noled_pr_ee_u4 m6490p_autobaud_uart0_noled_pr_ee
 * m6490p_autobaud_uart0_noled_pr_ee_u4 m645_autobaud_uart0_noled_pr_ee
 * m645_autobaud_uart0_noled_pr_ee_u4 m645a_autobaud_uart0_noled_pr_ee
 * m645a_autobaud_uart0_noled_pr_ee_u4 m645p_autobaud_uart0_noled_pr_ee
 * m645p_autobaud_uart0_noled_pr_ee_u4 m6450_autobaud_uart0_noled_pr_ee
 * m6450_autobaud_uart0_noled_pr_ee_u4 m6450a_autobaud_uart0_noled_pr_ee
 * m6450a_autobaud_uart0_noled_pr_ee_u4 m6450p_autobaud_uart0_noled_pr_ee
 * m6450p_autobaud_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m649_autobaud_uart0_noled_pr_ee[] = {
  0x96eeeeeed121b705, 0xbbbbbbaab8bf8d38, 0x1b67ec19e3bdb23b, 0x1eb9210646d6ef1f, 0x9ddb0db2b92a4c08,
  0x4c13e30120982bbc, 0xc252bbfec5767f67, 0xe602e910e81102a7, 0xed51c2bf5526be70, 0x224d56b4738c368d,
  0x8f83660d31f51e57, 0x4eb422877c57dd7a, 0x426be8c2cb1148b3, 0xce756979c571ac9a, 0xe875e74ddb7b4782,
  0x8451cf230e36355a, 0xfd6e1bd96cb98b84, 0x7b002a254d2a3608, 0xad79ce166fc0c4ad, 0x70b79bc03ea0c077,
  0x9d102baa9cbca6c6, 0xc55516961738c6f1, 0x52d4bf36c4922ade, 0xdfc1ddc68b224c6e, 0xf79430a9cfd4eacc,
  0x71fc65f989ffde1e, 0x17f81fbf619a3ed8, 0x6592e19e985f1a3d, 0x19961d252d9c389c, 0x7c93d71f3c95fb9a,
  0x0000000000004d4e,
};

/*
 * m649_autobaud_uart0_noled_pr_ce_u4 m649a_autobaud_uart0_noled_pr_ce
 * m649a_autobaud_uart0_noled_pr_ce_u4 m649p_autobaud_uart0_noled_pr_ce
 * m649p_autobaud_uart0_noled_pr_ce_u4 m6490_autobaud_uart0_noled_pr_ce
 * m6490_autobaud_uart0_noled_pr_ce_u4 m6490a_autobaud_uart0_noled_pr_ce
 * m6490a_autobaud_uart0_noled_pr_ce_u4 m6490p_autobaud_uart0_noled_pr_ce
 * m6490p_autobaud_uart0_noled_pr_ce_u4 m645_autobaud_uart0_noled_pr_ce
 * m645_autobaud_uart0_noled_pr_ce_u4 m645a_autobaud_uart0_noled_pr_ce
 * m645a_autobaud_uart0_noled_pr_ce_u4 m645p_autobaud_uart0_noled_pr_ce
 * m645p_autobaud_uart0_noled_pr_ce_u4 m6450_autobaud_uart0_noled_pr_ce
 * m6450_autobaud_uart0_noled_pr_ce_u4 m6450a_autobaud_uart0_noled_pr_ce
 * m6450a_autobaud_uart0_noled_pr_ce_u4 m6450p_autobaud_uart0_noled_pr_ce
 * m6450p_autobaud_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m649_autobaud_uart0_noled_pr_ce[] = {
  0x2ddddddda2432493, 0x7777775571842b71, 0xf1f4130aa87ad2f7, 0xd1fbc5f63f777767, 0x5de4ee86e41447ce,
  0xea7a609f180904c1, 0x153e122ebff62bb3, 0xf387301748874088, 0xb46f6a8e15faa935, 0x373b8f718bf58861,
  0x10d8488bace1e78f, 0xc3ffc0d1fa8f84bf, 0x3d3dcb3abeb264c5, 0x4a4871240f59ea39, 0xfd1eb0e62c051f3a,
  0x0ffd99e3af47ced5, 0x7c0f2d6e1f667950, 0x3859bf0312b5ec1c, 0x6f00fa8301deb5e7, 0xaeaa72f29b19c2de,
  0x5a585ce31bc67440, 0xf9b624863b7b1554, 0xee345912637296a5, 0x854e7ea75666fe0e, 0x2fcc4ffef0f7bca1,
  0xfdfb0cd1f6c38fe3, 0x0cf4c2f8d1e8bfc0, 0xe9296ce1c4e32c97, 0xb8f9e4afdcd0ccb0, 0x000000011ba9fade,
};

/*
 * m649_autobaud_uart0_noled_pr_ee_ce_u4 m649a_autobaud_uart0_noled_pr_ee_ce
 * m649a_autobaud_uart0_noled_pr_ee_ce_u4 m649p_autobaud_uart0_noled_pr_ee_ce
 * m649p_autobaud_uart0_noled_pr_ee_ce_u4 m6490_autobaud_uart0_noled_pr_ee_ce
 * m6490_autobaud_uart0_noled_pr_ee_ce_u4 m6490a_autobaud_uart0_noled_pr_ee_ce
 * m6490a_autobaud_uart0_noled_pr_ee_ce_u4 m6490p_autobaud_uart0_noled_pr_ee_ce
 * m6490p_autobaud_uart0_noled_pr_ee_ce_u4 m645_autobaud_uart0_noled_pr_ee_ce
 * m645_autobaud_uart0_noled_pr_ee_ce_u4 m645a_autobaud_uart0_noled_pr_ee_ce
 * m645a_autobaud_uart0_noled_pr_ee_ce_u4 m645p_autobaud_uart0_noled_pr_ee_ce
 * m645p_autobaud_uart0_noled_pr_ee_ce_u4 m6450_autobaud_uart0_noled_pr_ee_ce
 * m6450_autobaud_uart0_noled_pr_ee_ce_u4 m6450a_autobaud_uart0_noled_pr_ee_ce
 * m6450a_autobaud_uart0_noled_pr_ee_ce_u4 m6450p_autobaud_uart0_noled_pr_ee_ce
 * m6450p_autobaud_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m649_autobaud_uart0_noled_pr_ee_ce[] = {
  0x2ddddddda243304a, 0x7777775579108371, 0x0672ef92841a6477, 0x23334a683b6f770a, 0xddb1751f7ac80627,
  0xc13e30120982bbc9, 0x926dffd8aecfdadc, 0x80ba443a0440a9f0, 0x5470afd549af9c39, 0x8c5faa3f9d0da37b,
  0x5d670f3c79b9dc72, 0x2fd47c25f886c244, 0x20f7cc98b87a4a67, 0xb5fd4795f5129dac, 0x4c5613fd47c1b306,
  0xcb1148b34eb42281, 0xedd388ea426be8c2, 0xce9bb6f68f059cea, 0x3c8c38d8d578d8eb, 0x6f65b2e62e121147,
  0x744a9a546c113238, 0x9c2cdf81895af616, 0x37807d4180ef5af3, 0x575539794d8ce16f, 0x2d2c2e718de33a20,
  0xfcdb12431dbd8aaa, 0x771a2c8931b94b52, 0xc2a73f53ab337f07, 0x97e627ff787bde50, 0x7efd8668fb61c7f1,
  0x867a617c68f45fe0, 0x7494b670e271964b, 0x5c7cf257ee686658, 0x00000000411262fb,
};

/*
 * m649a_autobaud_uart0_noled_ee_hw  m649p_autobaud_uart0_noled_ee_hw  m6490_autobaud_uart0_noled_ee_hw
 * m6490a_autobaud_uart0_noled_ee_hw m6490p_autobaud_uart0_noled_ee_hw m645_autobaud_uart0_noled_ee_hw
 * m645a_autobaud_uart0_noled_ee_hw  m645p_autobaud_uart0_noled_ee_hw  m6450_autobaud_uart0_noled_ee_hw
 * m6450a_autobaud_uart0_noled_ee_hw m6450p_autobaud_uart0_noled_ee_hw c64_autobaud_uart0_noled_ee_hw
 */
static const uint64_t ur_m649_autobaud_uart0_noled_ee_hw[] = {
  0xb77777768a342493, 0xdddddd55c5fc69c4, 0xdb3f60cf1ded91dd, 0xf5c9083236b778f8, 0xc9dd0dc82b4ed040,
  0x74c13e30120982bb, 0x9f094aeffeb267f6, 0xc3980ba443a0440a, 0x37b5470afd549af9, 0x5c89355ad1ce30da,
  0xea3e0d9834c7d479, 0xcd3ad08a1df15f75, 0x6909afa30b2c4522, 0x0b39d5a5e715c6b2, 0x6ba1d79d376ded1e,
  0x1211473c8c38d8d5, 0x23f5b86f65b2e62e, 0xb5ec00a89534a8d8, 0xdeb5e73859bf0312, 0x19c2de6f00fa8301,
  0xc67440aeaa72f29b, 0x7b15545a585ce31b, 0xb94b52fcdb1248ab, 0xef2861539fa84e31, 0xe3f8cbf313ffbc3d,
  0x2ff03f7ec3347db0, 0xcb25c33d30be347a, 0x332c3a4a5b387138, 0xfe176a8a792bf734, 0x00000000000002c4,
};

/*
 * m649_autobaud_uart0_noled_ee_ce_u4_hw m649a_autobaud_uart0_noled_ee_ce_hw
 * m649a_autobaud_uart0_noled_ee_ce_u4_hw m649p_autobaud_uart0_noled_ee_ce_hw
 * m649p_autobaud_uart0_noled_ee_ce_u4_hw m6490_autobaud_uart0_noled_ee_ce_hw
 * m6490_autobaud_uart0_noled_ee_ce_u4_hw m6490a_autobaud_uart0_noled_ee_ce_hw
 * m6490a_autobaud_uart0_noled_ee_ce_u4_hw m6490p_autobaud_uart0_noled_ee_ce_hw
 * m6490p_autobaud_uart0_noled_ee_ce_u4_hw m645_autobaud_uart0_noled_ee_ce_hw
 * m645_autobaud_uart0_noled_ee_ce_u4_hw m645a_autobaud_uart0_noled_ee_ce_hw
 * m645a_autobaud_uart0_noled_ee_ce_u4_hw m645p_autobaud_uart0_noled_ee_ce_hw
 * m645p_autobaud_uart0_noled_ee_ce_u4_hw m6450_autobaud_uart0_noled_ee_ce_hw
 * m6450_autobaud_uart0_noled_ee_ce_u4_hw m6450a_autobaud_uart0_noled_ee_ce_hw
 * m6450a_autobaud_uart0_noled_ee_ce_u4_hw m6450p_autobaud_uart0_noled_ee_ce_hw
 * m6450p_autobaud_uart0_noled_ee_ce_u4_hw c64_autobaud_uart0_noled_ee_ce_hw
 * c64_autobaud_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m649_autobaud_uart0_noled_ee_ce_hw[] = {
  0x6eeeeeed146807e1, 0xbbbbbaabc8841b89, 0x33977c9420d323bb, 0x199a5341db7bb850, 0x9dd087bf7a3af139,
  0xcc13e30120982bbc, 0xc249b7ffd64cfdad, 0xe602e910e81102a7, 0xed51c2bf5526be70, 0xca317ea8fe74368d,
  0x22eb3879e790e771, 0x6ffea3e12fc43612, 0xc20f7cc98b87e5a6, 0x6b5fd4795f5129da, 0x14c5613fd47c1b30,
  0x2cb1148b34eb4228, 0xaedd388ea426be8c, 0xbce9bb6f68f059ce, 0x73c8c38d8d578d8e, 0x86f65b2e62e12114,
  0x6744a9a546c11323, 0x39c2cdf81895af61, 0xf37807d4180ef5af, 0x0575539794d8ce16, 0xa2d2c2e718de33a2,
  0x2fcdb12431dbd8aa, 0x1539fa84e31b94b5, 0xbf313ffbc3def286, 0xf7ec3347db0e3f8c, 0x33d30be347a2ff03,
  0xa4a5b387138cb25c, 0xa8a792bf734332c3, 0x0000000009521392,
};

/*
 * m649a_autobaud_uart0_lednop       m649p_autobaud_uart0_lednop       m6490_autobaud_uart0_lednop
 * m6490a_autobaud_uart0_lednop      m6490p_autobaud_uart0_lednop      m645_autobaud_uart0_lednop
 * m645a_autobaud_uart0_lednop       m645p_autobaud_uart0_lednop       m6450_autobaud_uart0_lednop
 * m6450a_autobaud_uart0_lednop      m6450p_autobaud_uart0_lednop
 */
static const uint64_t ur_m649_autobaud_uart0_lednop[] = {
  0x12dddddddd66ef3a, 0xf7777777557e1719, 0x48368ebeb4f13b50, 0x5908036da45ddddd, 0x04c15de4ee82f413,
  0xe879f912609f1809, 0xd022054f84b4aff7, 0xaa4d7ce1cc05d221, 0x24386d1bdaa3857e, 0x903349ea393c77cb,
  0x2dee987ce92921c4, 0xe766be4720a73160, 0xb07dee39630475e2, 0x13859bf0312b5ec2, 0xb228301deb5e7810,
  0xf529c94e8016f379, 0x9c6378ce881df2a6, 0x9c8ab7b15545a6ae, 0xf3fb0dca5a97e6db, 0x4e32c970cf4c2b93,
  0xcd0ccb0e9296ce1c, 0xcc5faf022f9e4afd, 0x000000000000001a,
};

/*
 * m649_autobaud_uart0_lednop_pr_u4  m649a_autobaud_uart0_lednop_pr    m649a_autobaud_uart0_lednop_pr_u4
 * m649p_autobaud_uart0_lednop_pr    m649p_autobaud_uart0_lednop_pr_u4 m6490_autobaud_uart0_lednop_pr
 * m6490_autobaud_uart0_lednop_pr_u4 m6490a_autobaud_uart0_lednop_pr
 * m6490a_autobaud_uart0_lednop_pr_u4 m6490p_autobaud_uart0_lednop_pr
 * m6490p_autobaud_uart0_lednop_pr_u4 m645_autobaud_uart0_lednop_pr
 * m645_autobaud_uart0_lednop_pr_u4  m645a_autobaud_uart0_lednop_pr    m645a_autobaud_uart0_lednop_pr_u4
 * m645p_autobaud_uart0_lednop_pr    m645p_autobaud_uart0_lednop_pr_u4 m6450_autobaud_uart0_lednop_pr
 * m6450_autobaud_uart0_lednop_pr_u4 m6450a_autobaud_uart0_lednop_pr
 * m6450a_autobaud_uart0_lednop_pr_u4 m6450p_autobaud_uart0_lednop_pr
 * m6450p_autobaud_uart0_lednop_pr_u4
 */
static const uint64_t ur_m649_autobaud_uart0_lednop_pr[] = {
  0x12ddddddda243762, 0x7777777557e172e3, 0x387f6dfa548bb63f, 0xee17f8ff17bbbb71, 0x57793bb4cd19a088,
  0xfc7b9827c6024130, 0x02a7c25dd7fd8aec, 0xbe70e602e910e811, 0x368ded51c2bf5526, 0x0bf51ed63be5843c,
  0x9be483f490e2481a, 0x67a3486731602cb2, 0x01ffb30475e8f9d9, 0x5a07967b682cd22a, 0x9c2cdf81895af641,
  0x914180ef5af3c080, 0xa94e4a7400b79bcd, 0xe31bc67440ef9537, 0xe455bd8aaa2d3574, 0x224c6e52d4bf36dc,
  0xd4eaccdfc1ddc68b, 0xffde1ef79430a9cf, 0x9a3ed871fc65f989, 0x5f1a3d17f81fbf61, 0x9c389c6592e19e98,
  0x95fb9a19961d252d, 0x00230c959bd71f3c,
};

/*
 * m649_autobaud_uart0_lednop_pr_ee_u4 m649a_autobaud_uart0_lednop_pr_ee
 * m649a_autobaud_uart0_lednop_pr_ee_u4 m649p_autobaud_uart0_lednop_pr_ee
 * m649p_autobaud_uart0_lednop_pr_ee_u4 m6490_autobaud_uart0_lednop_pr_ee
 * m6490_autobaud_uart0_lednop_pr_ee_u4 m6490a_autobaud_uart0_lednop_pr_ee
 * m6490a_autobaud_uart0_lednop_pr_ee_u4 m6490p_autobaud_uart0_lednop_pr_ee
 * m6490p_autobaud_uart0_lednop_pr_ee_u4 m645_autobaud_uart0_lednop_pr_ee
 * m645_autobaud_uart0_lednop_pr_ee_u4 m645a_autobaud_uart0_lednop_pr_ee
 * m645a_autobaud_uart0_lednop_pr_ee_u4 m645p_autobaud_uart0_lednop_pr_ee
 * m645p_autobaud_uart0_lednop_pr_ee_u4 m6450_autobaud_uart0_lednop_pr_ee
 * m6450_autobaud_uart0_lednop_pr_ee_u4 m6450a_autobaud_uart0_lednop_pr_ee
 * m6450a_autobaud_uart0_lednop_pr_ee_u4 m6450p_autobaud_uart0_lednop_pr_ee
 * m6450p_autobaud_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m649_autobaud_uart0_lednop_pr_ee[] = {
  0x4b7777776890c044, 0xddddddd55c5fe82c, 0x8db1a67ed4de9a5d, 0xb5159083236b778f, 0x9dd4149ca5d84368,
  0x4c13e30120982bbc, 0xc25a6ffec5767c6b, 0xe602e910e81102a7, 0xed51c2bf5526be70, 0x654d56b4738c368d,
  0x8f83660d31f51e56, 0x9d68450ef8ac3dfa, 0x84d7d18596229166, 0x1cead2e7aae35934, 0xe875e74dda32464d,
  0x84504f237b56355a, 0xfd6e1bd96cb98b84, 0xf60043eccf2a3608, 0xc0809c2cdf81895a, 0x9bcd914180ef5af3,
  0x9537a94e4a7400b7, 0x3574e31bc67440ef, 0x36dce455bd8aaa2d, 0xc68b224c6e52d4bf, 0xa9cfd4eaccdfc1dd,
  0xf989ffde1ef79430, 0xbf619a3ed871fc65, 0x9e985f1a3d17f81f, 0x252d9c389c6592e1, 0x1f3c95fb9a19961d,
  0x00000026a70056d7,
};

/*
 * m649_autobaud_uart0_lednop_pr_ce_u4 m649a_autobaud_uart0_lednop_pr_ce
 * m649a_autobaud_uart0_lednop_pr_ce_u4 m649p_autobaud_uart0_lednop_pr_ce
 * m649p_autobaud_uart0_lednop_pr_ce_u4 m6490_autobaud_uart0_lednop_pr_ce
 * m6490_autobaud_uart0_lednop_pr_ce_u4 m6490a_autobaud_uart0_lednop_pr_ce
 * m6490a_autobaud_uart0_lednop_pr_ce_u4 m6490p_autobaud_uart0_lednop_pr_ce
 * m6490p_autobaud_uart0_lednop_pr_ce_u4 m645_autobaud_uart0_lednop_pr_ce
 * m645_autobaud_uart0_lednop_pr_ce_u4 m645a_autobaud_uart0_lednop_pr_ce
 * m645a_autobaud_uart0_lednop_pr_ce_u4 m645p_autobaud_uart0_lednop_pr_ce
 * m645p_autobaud_uart0_lednop_pr_ce_u4 m6450_autobaud_uart0_lednop_pr_ce
 * m6450_autobaud_uart0_lednop_pr_ce_u4 m6450a_autobaud_uart0_lednop_pr_ce
 * m6450a_autobaud_uart0_lednop_pr_ce_u4 m6450p_autobaud_uart0_lednop_pr_ce
 * m6450p_autobaud_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m649_autobaud_uart0_lednop_pr_ce[] = {
  0x96eeeeeed121be4a, 0xbbbbbbaab8c21bb8, 0xf1f2b68242fd7afb, 0xf0d3866f4f777767, 0x5de4ee94a3adf4d5,
  0xf2ba609f180904c1, 0x153e1260bff62bb3, 0xf387301748874088, 0xb46f6a8e15faa935, 0x373b80d18bf58861,
  0x10d8488bace1e78f, 0x0e9b73b7fa8f84bf, 0x24f72ceafac99317, 0x6921c4903d67a8fd, 0xd1a43398b0153111,
  0xffd99e3af47cecb3, 0x40f2d6e416691500, 0x859bf0312b5ec82b, 0x28301deb5e781013, 0x29c94e8016f379b2,
  0x6378ce881df2a6f5, 0x63b7b15545a6ae9c, 0x931b94b52fcdb738, 0x3ab337f07771a2c8, 0xf787bde50c2a73f5,
  0x8fb61c7f197e627f, 0xc68f45fe07efd866, 0x0e271964b867a617, 0x7ee6866587494b67, 0x08dd5be0b5c7cf25,
};

/*
 * m649_autobaud_uart0_lednop_pr_ee_ce_u4 m649a_autobaud_uart0_lednop_pr_ee_ce
 * m649a_autobaud_uart0_lednop_pr_ee_ce_u4 m649p_autobaud_uart0_lednop_pr_ee_ce
 * m649p_autobaud_uart0_lednop_pr_ee_ce_u4 m6490_autobaud_uart0_lednop_pr_ee_ce
 * m6490_autobaud_uart0_lednop_pr_ee_ce_u4 m6490a_autobaud_uart0_lednop_pr_ee_ce
 * m6490a_autobaud_uart0_lednop_pr_ee_ce_u4 m6490p_autobaud_uart0_lednop_pr_ee_ce
 * m6490p_autobaud_uart0_lednop_pr_ee_ce_u4 m645_autobaud_uart0_lednop_pr_ee_ce
 * m645_autobaud_uart0_lednop_pr_ee_ce_u4 m645a_autobaud_uart0_lednop_pr_ee_ce
 * m645a_autobaud_uart0_lednop_pr_ee_ce_u4 m645p_autobaud_uart0_lednop_pr_ee_ce
 * m645p_autobaud_uart0_lednop_pr_ee_ce_u4 m6450_autobaud_uart0_lednop_pr_ee_ce
 * m6450_autobaud_uart0_lednop_pr_ee_ce_u4 m6450a_autobaud_uart0_lednop_pr_ee_ce
 * m6450a_autobaud_uart0_lednop_pr_ee_ce_u4 m6450p_autobaud_uart0_lednop_pr_ee_ce
 * m6450p_autobaud_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m649_autobaud_uart0_lednop_pr_ee_ce[] = {
  0x2ddddddda2436812, 0x7777775579104771, 0x0ce0dcbb68baccf7, 0xc9c624d076deee14, 0xeeefd8580526bd89,
  0x609f180904c15de4, 0x24ff3fec5767daee, 0x602e910e81102a7c, 0xd51c2bf5526be70e, 0xa317ea8fe74368de,
  0x1759c3cf1e6e764e, 0x1ff51f097e21b091, 0x107be64c5c3e5434, 0x5afea3cafba94ed6, 0xa62bdbfea3e0d983,
  0x6588a459a75a1140, 0x76e3d4752135f461, 0xf3a6ed1923268e75, 0x4f237b56355e363a, 0x1bd96cb98b848450,
  0x31f667951b044c8e, 0x4e166fc0c4ad7b0b, 0xc8a0c077ad79e040, 0xd4a7253a005bcde6, 0x718de33a2077ca9b,
  0xe18edec555169aba, 0x224c6e52d4bf36dc, 0xd4eaccdfc1ddc68b, 0xffde1ef79430a9cf, 0x9a3ed871fc65f989,
  0x5f1a3d17f81fbf61, 0x9c389c6592e19e98, 0x95fb9a19961d252d, 0x0008227d9ed71f3c,
};

/*
 * m649a_autobaud_uart0_lednop_ee_hw m649p_autobaud_uart0_lednop_ee_hw m6490_autobaud_uart0_lednop_ee_hw
 * m6490a_autobaud_uart0_lednop_ee_hw m6490p_autobaud_uart0_lednop_ee_hw
 * m645_autobaud_uart0_lednop_ee_hw  m645a_autobaud_uart0_lednop_ee_hw m645p_autobaud_uart0_lednop_ee_hw
 * m6450_autobaud_uart0_lednop_ee_hw m6450a_autobaud_uart0_lednop_ee_hw
 * m6450p_autobaud_uart0_lednop_ee_hw c64_autobaud_uart0_lednop_ee_hw
 */
static const uint64_t ur_m649_autobaud_uart0_lednop_ee_hw[] = {
  0x5bbbbbbb451a3e4a, 0xeeeeeeaae2ff4162, 0x6d8d33f6a6f4d2ee, 0xa8ac84191b5bbc7c, 0xc9dd29475b55f345,
  0xb4c13e30120982bb, 0x9f0969bffeb267c6, 0xc3980ba443a0440a, 0x37b5470afd549af9, 0x5995355ad1ce30da,
  0xea3e0d9834c7d479, 0x9a75a1143be2b0f7, 0xd2135f4616588a45, 0x3473ab4b9eab8d64, 0x6ba1d79d3768c919,
  0x1211413c8ded58d5, 0x23f5b86f65b2e62e, 0x6bd8010fb33ca8d8, 0xcf020270b37e0625, 0xde6f36450603bd6b,
  0xbe54dea53929d002, 0xb4d5d38c6f19d103, 0xfcdb739156f62aa8, 0x539fa84e31b94b52, 0xf313ffbc3def2861,
  0x7ec3347db0e3f8cb, 0x3d30be347a2ff03f, 0x4a5b387138cb25c3, 0x8a792bf734332c3a, 0x00000001627cd35a,
};

/*
 * m649_autobaud_uart0_lednop_ee_ce_u4_hw m649a_autobaud_uart0_lednop_ee_ce_hw
 * m649a_autobaud_uart0_lednop_ee_ce_u4_hw m649p_autobaud_uart0_lednop_ee_ce_hw
 * m649p_autobaud_uart0_lednop_ee_ce_u4_hw m6490_autobaud_uart0_lednop_ee_ce_hw
 * m6490_autobaud_uart0_lednop_ee_ce_u4_hw m6490a_autobaud_uart0_lednop_ee_ce_hw
 * m6490a_autobaud_uart0_lednop_ee_ce_u4_hw m6490p_autobaud_uart0_lednop_ee_ce_hw
 * m6490p_autobaud_uart0_lednop_ee_ce_u4_hw m645_autobaud_uart0_lednop_ee_ce_hw
 * m645_autobaud_uart0_lednop_ee_ce_u4_hw m645a_autobaud_uart0_lednop_ee_ce_hw
 * m645a_autobaud_uart0_lednop_ee_ce_u4_hw m645p_autobaud_uart0_lednop_ee_ce_hw
 * m645p_autobaud_uart0_lednop_ee_ce_u4_hw m6450_autobaud_uart0_lednop_ee_ce_hw
 * m6450_autobaud_uart0_lednop_ee_ce_u4_hw m6450a_autobaud_uart0_lednop_ee_ce_hw
 * m6450a_autobaud_uart0_lednop_ee_ce_u4_hw m6450p_autobaud_uart0_lednop_ee_ce_hw
 * m6450p_autobaud_uart0_lednop_ee_ce_u4_hw c64_autobaud_uart0_lednop_ee_ce_hw
 * c64_autobaud_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m649_autobaud_uart0_lednop_ee_ce_hw[] = {
  0x6eeeeeed14683d5b, 0xbbbbbaabc8823b89, 0x6706e5db45d667bb, 0x4e312683b6f770a0, 0x27759f3aded6ac4e,
  0x7304f8c048260aef, 0xf849fe7ff5933ed7, 0x1cc05d221d022054, 0xbdaa3857eaa4d7ce, 0x9d462fd51fce86d1,
  0x445d670f3cf21cec, 0x643fd47c25f886c2, 0xac20f7cc98b87eb3, 0x06b5fd4795f7529d, 0x814c57b7fd47c1b3,
  0xc2cb1148b34eb422, 0xeaedc7a8ea426be8, 0x75e74dda32464d1c, 0xa09e46f6ac6abc6c, 0x1c37b2d973170908,
  0x1663eccf2a360899, 0x809c2cdf81895af6, 0xcd914180ef5af3c0, 0x37a94e4a7400b79b, 0x74e31bc67440ef95,
  0xb9c31dbd8aaa2d35, 0xd42718dca5a97e6d, 0xffde1ef79430a9cf, 0x9a3ed871fc65f989, 0x5f1a3d17f81fbf61,
  0x9c389c6592e19e98, 0x95fb9a19961d252d, 0x00004a927549453c,
};

/*
 * m649_autobaud_uart0_dual_pr       m649_autobaud_uart0_dual_pr_u4    m649a_autobaud_uart0_dual
 * m649a_autobaud_uart0_dual_pr      m649a_autobaud_uart0_dual_pr_u4   m649p_autobaud_uart0_dual
 * m649p_autobaud_uart0_dual_pr      m649p_autobaud_uart0_dual_pr_u4   m6490_autobaud_uart0_dual
 * m6490_autobaud_uart0_dual_pr      m6490_autobaud_uart0_dual_pr_u4   m6490a_autobaud_uart0_dual
 * m6490a_autobaud_uart0_dual_pr     m6490a_autobaud_uart0_dual_pr_u4  m6490p_autobaud_uart0_dual
 * m6490p_autobaud_uart0_dual_pr     m6490p_autobaud_uart0_dual_pr_u4  m645_autobaud_uart0_dual
 * m645_autobaud_uart0_dual_pr       m645_autobaud_uart0_dual_pr_u4    m645a_autobaud_uart0_dual
 * m645a_autobaud_uart0_dual_pr      m645a_autobaud_uart0_dual_pr_u4   m645p_autobaud_uart0_dual
 * m645p_autobaud_uart0_dual_pr      m645p_autobaud_uart0_dual_pr_u4   m6450_autobaud_uart0_dual
 * m6450_autobaud_uart0_dual_pr      m6450_autobaud_uart0_dual_pr_u4   m6450a_autobaud_uart0_dual
 * m6450a_autobaud_uart0_dual_pr     m6450a_autobaud_uart0_dual_pr_u4  m6450p_autobaud_uart0_dual
 * m6450p_autobaud_uart0_dual_pr     m6450p_autobaud_uart0_dual_pr_u4
 */
static const uint64_t ur_m649_autobaud_uart0_dual[] = {
  0x37777776890d7f41, 0xddddddd5ac7ce2bf, 0xc11ecd8a05e843dd, 0x9ced9452b7774d2a, 0x0aeef7199b2affab,
  0x13e30120982bbc9a, 0x5f64c8c1548683cc, 0xe20614306d230377, 0xbeff328094ee9f12, 0x1ca1ec14f1c32b4d,
  0x149120920721e6f5, 0xc2886257f9fbe08a, 0xce5e99c9db13eb87, 0xa2a10cb434a4432a, 0xb774bff4073c269b,
  0xeaa4982c3795e425, 0x1d022054f849fcff, 0xeaa4d7ce1cc05d22, 0x589a86d1bdaa3857, 0x490310fea3e453be,
  0x055079a717be921c, 0x019dad6475fce62c, 0xa435403ff6608ebc, 0x52552740f2cf6c43, 0x256bd93f8abe7771,
  0x6bcf020270b37e06, 0x02de6f36450603bd, 0x03be54dea53929d0, 0xa8b4d5d38c6f19d1, 0x52fcdb739156f62a,
  0x07771a2c8931b94b, 0x50c2a73f53ab337f, 0xf197e627ff787bde, 0xe07efd8668fb61c7, 0x4b867a617c68f45f,
  0x587494b670e27196, 0xab5c7cf257ee6866, 0x00000000002e0ab5,
};

/*
 * m649a_autobaud_uart0_dual_pr_ee   m649p_autobaud_uart0_dual_pr_ee   m6490_autobaud_uart0_dual_pr_ee
 * m6490a_autobaud_uart0_dual_pr_ee  m6490p_autobaud_uart0_dual_pr_ee  m645_autobaud_uart0_dual_pr_ee
 * m645a_autobaud_uart0_dual_pr_ee   m645p_autobaud_uart0_dual_pr_ee   m6450_autobaud_uart0_dual_pr_ee
 * m6450a_autobaud_uart0_dual_pr_ee  m6450p_autobaud_uart0_dual_pr_ee
 */
static const uint64_t ur_m649_autobaud_uart0_dual_pr_ee[] = {
  0x377777743d686f97, 0xeeeeeeeac6efbbbf, 0xac89f55fd77a4dee, 0xdfbf764d60eeb4e3, 0x78233a19c53ac995,
  0x0120982bbc90dcee, 0x9182a91118cc13e3, 0x2860da4606eebec9, 0x650129dd3e25c40c, 0x616b670adf9a007e,
  0x1240f76a6f51e76f, 0x4aff3f7c11429224, 0x38a4827d70f8510c, 0x2d0c08886559cbd3, 0xfa039e131758a843,
  0x161bcaf212dbffcf, 0x54f8489d7ff5524c, 0xce1cc05d221d0220, 0xd1bdaa3857eaa4d7, 0x95afb9aad68e4486,
  0x5ea3e0d983053d47, 0x59a75a1143be2ba9, 0xcd2135f4616588a4, 0xbd9cead2e652e2a5, 0x5ae875ea25da2147,
  0xc242281151f3d635, 0x08fd6e1bd97d2cc5, 0xe2a4a0109fd62a36, 0x0c4ad7b27f157cee, 0x7ad79e0404e166fc,
  0xa005bcde6c8a0c07, 0xa2077ca9bd4a7253, 0x555169aba718de33, 0x96a5f9b6e722adec, 0xf07771a2cf782372,
  0xe50c2a73f53ab337, 0xd1f6c3dce32fcc4f, 0xf4c2b93f1cf7ff04, 0x296ce1c4e32c970c, 0xf9e4afdcd0ccb0e9,
  0x00000052a47adeb8,
};

/*
 * m649a_autobaud_uart0_dual_pr_ee_u4 m649p_autobaud_uart0_dual_pr_ee_u4
 * m6490_autobaud_uart0_dual_pr_ee_u4 m6490a_autobaud_uart0_dual_pr_ee_u4
 * m6490p_autobaud_uart0_dual_pr_ee_u4 m645_autobaud_uart0_dual_pr_ee_u4
 * m645a_autobaud_uart0_dual_pr_ee_u4 m645p_autobaud_uart0_dual_pr_ee_u4
 * m6450_autobaud_uart0_dual_pr_ee_u4 m6450a_autobaud_uart0_dual_pr_ee_u4
 * m6450p_autobaud_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m649_autobaud_uart0_dual_pr_ee_u4[] = {
  0xf37777776890cf68, 0xdddddddd58dda01b, 0xd8ae751796adaefd, 0x8593eec9ac1dd29c, 0xb9a3ea75682dd9dd,
  0x8c048260aef24c8b, 0x26460aa47ad5304f, 0x30a18369181bbafb, 0xf99404a774f89710, 0x5b04db384edcd6b7,
  0x20920663f37a8fbb, 0x6257f9fbe08a1491, 0x99c67213eb87c288, 0x196814b4432ace5e, 0xffd01cf09be74542,
  0xc161bcaf212dbf4f, 0x054f84a2b7ff5524, 0x7ce1cc05d221d022, 0x6d1bdaa3857eaa4d, 0x795c7b9aad68f4a8,
  0x1fea3e0d983f93d4, 0x459a75a1143be2b3, 0x5cd2135f4616588a, 0xfa439d5a5c27ae10, 0xad743af6b13b0f88,
  0xc24228e811d4bb1a, 0x27feb70decb8f8c5, 0x4fe2af9ddc549570, 0x809c2cdf81895af6, 0xcd914180ef5af3c0,
  0x37a94e4a7400b79b, 0x74e31bc67440ef95, 0xdce455bd8aaa2d35, 0x8b224c6e52d4bf36, 0xcfd4eaccdfc1ddc6,
  0x89ffde1ef79430a9, 0x619a3ed871fc65f9, 0x985f1a3d17f81fbf, 0x2d9c389c6592e19e, 0x3c95fb9a19961d25,
  0x0000029522ecd71f,
};

/*
 * m649_autobaud_uart0_dual_pr_ce_u4 m649a_autobaud_uart0_dual_pr_ce   m649a_autobaud_uart0_dual_pr_ce_u4
 * m649p_autobaud_uart0_dual_pr_ce   m649p_autobaud_uart0_dual_pr_ce_u4
 * m6490_autobaud_uart0_dual_pr_ce   m6490_autobaud_uart0_dual_pr_ce_u4
 * m6490a_autobaud_uart0_dual_pr_ce  m6490a_autobaud_uart0_dual_pr_ce_u4
 * m6490p_autobaud_uart0_dual_pr_ce  m6490p_autobaud_uart0_dual_pr_ce_u4
 * m645_autobaud_uart0_dual_pr_ce    m645_autobaud_uart0_dual_pr_ce_u4 m645a_autobaud_uart0_dual_pr_ce
 * m645a_autobaud_uart0_dual_pr_ce_u4 m645p_autobaud_uart0_dual_pr_ce
 * m645p_autobaud_uart0_dual_pr_ce_u4 m6450_autobaud_uart0_dual_pr_ce
 * m6450_autobaud_uart0_dual_pr_ce_u4 m6450a_autobaud_uart0_dual_pr_ce
 * m6450a_autobaud_uart0_dual_pr_ce_u4 m6450p_autobaud_uart0_dual_pr_ce
 * m6450p_autobaud_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m649_autobaud_uart0_dual_pr_ce[] = {
  0xe6eeeeeed121a5fb, 0xdddddddd5968b9d7, 0xa75179579ced4d7d, 0x44f51f67dbbbaccd, 0x76ee9646ba83e2ac,
  0x13e30120982bbc94, 0xbec99182a91c3fcc, 0xc40c2860da4606ee, 0x4d7e650129dd3e25, 0x7b1fd87fc380689b,
  0xa48904903a1f9bd4, 0x144312bfcfdf0450, 0x72f4ce5c889f5c3e, 0x2a10cb4243a21956, 0xe96bfe80e784dfba,
  0x54930586f2bc84b6, 0x4088153e12b75ffd, 0xa935f38730174887, 0x2fa1b46f6a8e15fa, 0xcf1e6e7695a317eb,
  0x097e21b0911759c3, 0x93170f5bf003f51f, 0x471bf3dcb3abd4b9, 0x83e52438920752fd, 0xd6b23afe73160282,
  0xa01ffb33c75e00ce, 0xa4e81e5adc21d21a, 0x7b27f157ceee2a4a, 0xe0404e166fc0c4ad, 0xcde6c8a0c077ad79,
  0xca9bd4a7253a005b, 0x9aba718de33a2077, 0x36dce18edec55516, 0xc68b224c6e52d4bf, 0xa9cfd4eaccdfc1dd,
  0xf989ffde1ef79430, 0xbf619a3ed871fc65, 0x9e985f1a3d17f81f, 0x252d9c389c6592e1, 0x1f3c95fb9a19961d,
  0x0000000ad7be9ed7,
};

/*
 * m649a_autobaud_uart0_dual_pr_ee_ce m649p_autobaud_uart0_dual_pr_ee_ce
 * m6490_autobaud_uart0_dual_pr_ee_ce m6490a_autobaud_uart0_dual_pr_ee_ce
 * m6490p_autobaud_uart0_dual_pr_ee_ce m645_autobaud_uart0_dual_pr_ee_ce
 * m645a_autobaud_uart0_dual_pr_ee_ce m645p_autobaud_uart0_dual_pr_ee_ce
 * m6450_autobaud_uart0_dual_pr_ee_ce m6450a_autobaud_uart0_dual_pr_ee_ce
 * m6450p_autobaud_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m649_autobaud_uart0_dual_pr_ee_ce[] = {
  0xfcdddddddd431f02, 0xeeeeeeeead63f226, 0x2c4e164da8fed826, 0xc7e776d2ec4eea4c, 0x5188b36e4330a5f5,
  0x0120982bbc91ecee, 0x460aa41662cc13e3, 0xa18369181bbafb26, 0x9404a774f8971030, 0x09863833e4dd67f9,
  0x490314937a8e6b7b, 0x2bfcfdf0450a4890, 0x814889f5c3e14431, 0xa1d5e886559cbd33, 0x4073c268ad150865,
  0x86f2bc84b6e87dff, 0x7c249b7ffd549305, 0x0e602e910e81102a, 0xded51c2bf5526be7, 0xe3958fea8ff74368,
  0x0ffae6b7f9e3cdce, 0xf253b58166e99ceb, 0x7c1b306be7a8f2b7, 0xeb422814c5701bd4, 0x26be8c2cb1148b34,
  0x7bd9ceaedc650ea4, 0xabc6c75ea25da214, 0xb84845022a3e7ac6, 0x608991c37b2fa598, 0xee2a4a5989fd62a3,
  0xc0c4ad7b27f157ce, 0x77ad79e0404e166f, 0x3a005bcde6c8a0c0, 0x3a2077ca9bd4a725, 0xc555169aba718de3,
  0x52d4bf36dce18ede, 0x6fe0eee3458f386e, 0x970cf4c2b93f7566, 0xb0e9296ce1c4e32c, 0xe6b8f9e4afdcd0cc,
  0x00000000000c4434,
};

/*
 * m649a_autobaud_uart0_dual_pr_ee_ce_u4 m649p_autobaud_uart0_dual_pr_ee_ce_u4
 * m6490_autobaud_uart0_dual_pr_ee_ce_u4 m6490a_autobaud_uart0_dual_pr_ee_ce_u4
 * m6490p_autobaud_uart0_dual_pr_ee_ce_u4 m645_autobaud_uart0_dual_pr_ee_ce_u4
 * m645a_autobaud_uart0_dual_pr_ee_ce_u4 m645p_autobaud_uart0_dual_pr_ee_ce_u4
 * m6450_autobaud_uart0_dual_pr_ee_ce_u4 m6450a_autobaud_uart0_dual_pr_ee_ce_u4
 * m6450p_autobaud_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m649_autobaud_uart0_dual_pr_ee_ce_u4[] = {
  0x77777768a87fa812, 0xbbbbbab209f57bf3, 0x6083399335c87bbb, 0x8591f69dba9f6eb7, 0xe5acafed0b8b2bdb,
  0x15de48437707d7e0, 0x09e4e609f180904c, 0x181bbafb26460aa4, 0x74f8971030a18369, 0x9513341ff32b0127,
  0xcdea3dc8ec0928e1, 0x0450a4890490366f, 0x5c3e144312bfcfdf, 0x6559cbd338cf589f, 0xd3f150865a1bb488,
  0x96dd9f3fe80e784d, 0xf8c85e60b0de5790, 0x0e81102a7c2487df, 0xf5526be70e602e91, 0x8ca1c368ded51c2b,
  0x79f00cecc7e317ea, 0x4bf10d8488bace1e, 0xc5c39806e87fa8f8, 0xadfc94ed6109ba64, 0xf51f06cc1af9ea3c,
  0xcd3ad08a05315c06, 0xa909afa30b2c4522, 0x851ef673abb71943, 0xb1aaf1b1d7a89768, 0x662e1211408a8f9e,
  0xa8d8226470decbe9, 0xf3bb8a9296627f58, 0x9bf0312b5ec9fc55, 0x301deb5e78101385, 0xc94e8016f379b228,
  0x78ce881df2a6f529, 0xb7b15545a6ae9c63, 0x1b94b52fcdb73863, 0x99bf8347f1a2c893, 0x3def2861539fa9d5,
  0xb0e3f8cbf313ffbc, 0x7a2ff03f7ec3347d, 0x38cb25c33d30be34, 0x34332c3a4a5b3871, 0xb6c793880a792bf7,
  0x00000000000001fa,
};

/*
 * m649a_autobaud_uart0_dual_ee_hw   m649p_autobaud_uart0_dual_ee_hw   m6490_autobaud_uart0_dual_ee_hw
 * m6490a_autobaud_uart0_dual_ee_hw  m6490p_autobaud_uart0_dual_ee_hw  m645_autobaud_uart0_dual_ee_hw
 * m645a_autobaud_uart0_dual_ee_hw   m645p_autobaud_uart0_dual_ee_hw   m6450_autobaud_uart0_dual_ee_hw
 * m6450a_autobaud_uart0_dual_ee_hw  m6450p_autobaud_uart0_dual_ee_hw  c64_autobaud_uart0_dual_ee_hw
 */
static const uint64_t ur_m649_autobaud_uart0_dual_ee_hw[] = {
  0x9bbbbbbb451a25fb, 0x777777756377dddf, 0xd644faafebbd26f7, 0xefdfbb26b0775a71, 0xee9646bae95664ca,
  0xe30120982bbc90dc, 0xc99182a91118cc13, 0x0c2860da4606eebe, 0x7e657419dd3e25c4, 0x6f616b670adf9a00,
  0x241240f76a6f51e7, 0x0c4aff3f7c114292, 0xd338a4827d70f851, 0x432d0c08886559cb, 0xcffa039e131758a8,
  0xcc161bcaf212dbff, 0x102a7c244ebfcead, 0x6be70e602e910e81, 0x4368ded51c2bf552, 0xa3cad7dcd56b4722,
  0xd4af51f06cc1829e, 0x522cd3ad08a1df15, 0x52e6909afa30b2c4, 0xa3dece7569732971, 0x1aad743af512ed10,
  0x62e1211408a8f9eb, 0x1b047eb70decbe96, 0x77715250084feb15, 0x7e06256bd93f8abe, 0x03bd6bcf020270b3,
  0x29d002de6f364506, 0x19d103be54dea539, 0xf62aa8b4d5d38c6f, 0xb94b52fcdb739156, 0xef2861539fa84e31,
  0xe3f8cbf313ffbc3d, 0x2ff03f7ec3347db0, 0xcb25c33d30be347a, 0x332c3a4a5b387138, 0x2d9e4e8a792bf734,
  0x0000000000000b07,
};

/*
 * m649_autobaud_uart0_dual_ee_ce_u4_hw m649a_autobaud_uart0_dual_ee_ce_hw
 * m649a_autobaud_uart0_dual_ee_ce_u4_hw m649p_autobaud_uart0_dual_ee_ce_hw
 * m649p_autobaud_uart0_dual_ee_ce_u4_hw m6490_autobaud_uart0_dual_ee_ce_hw
 * m6490_autobaud_uart0_dual_ee_ce_u4_hw m6490a_autobaud_uart0_dual_ee_ce_hw
 * m6490a_autobaud_uart0_dual_ee_ce_u4_hw m6490p_autobaud_uart0_dual_ee_ce_hw
 * m6490p_autobaud_uart0_dual_ee_ce_u4_hw m645_autobaud_uart0_dual_ee_ce_hw
 * m645_autobaud_uart0_dual_ee_ce_u4_hw m645a_autobaud_uart0_dual_ee_ce_hw
 * m645a_autobaud_uart0_dual_ee_ce_u4_hw m645p_autobaud_uart0_dual_ee_ce_hw
 * m645p_autobaud_uart0_dual_ee_ce_u4_hw m6450_autobaud_uart0_dual_ee_ce_hw
 * m6450_autobaud_uart0_dual_ee_ce_u4_hw m6450a_autobaud_uart0_dual_ee_ce_hw
 * m6450a_autobaud_uart0_dual_ee_ce_u4_hw m6450p_autobaud_uart0_dual_ee_ce_hw
 * m6450p_autobaud_uart0_dual_ee_ce_u4_hw c64_autobaud_uart0_dual_ee_ce_hw
 * c64_autobaud_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m649_autobaud_uart0_dual_ee_ce_hw[] = {
  0xddddddda28d08f43, 0xeeeeeeac827d5efc, 0xd820ce64cd721eee, 0xe1647da76ea7dbad, 0xfb5ab6a71ae2caf6,
  0x04c15de484377789, 0xaa409e4e609f1809, 0x369181bbafb26460, 0x06774f8971030a18, 0x470ca899a0ff995d,
  0xb37e6f51ee476049, 0x7ef8228524482481, 0xc4fae1f0a21895fe, 0xa4432ace5e99c67a, 0xc26e9f8a8432d0dd,
  0xbc84b6ecf9ff4073, 0x43eff3ab730586f2, 0x1748874088153e12, 0x8e15faa935f38730, 0x8bf54650e1b46f6a,
  0xb3879e790e7663f1, 0xea3e12fc4361222e, 0x374c98b87672e8ff, 0x3d4795bf929dac21, 0x2b80dea3e0d9835f,
  0x88a459a75a1140a6, 0xe328752135f46165, 0x12ed10a3dece7576, 0x51f3d6355e363af5, 0xd97d2cc5c2422811,
  0x4feb151b044c8e1b, 0x3f8abe77715252cc, 0x0270b37e06256bd9, 0x36450603bd6bcf02, 0xdea53929d002de6f,
  0xd38c6f19d103be54, 0xe70c76f62aa8b4d5, 0x509c637296a5f9b6, 0xff787bde50c2a73f, 0x68fb61c7f197e627,
  0x7c68f45fe07efd86, 0x70e271964b867a61, 0x57ee6866587494b6, 0x00109a66dbad14f2,
};

/*
 * m649_u1x8_uart0_noled_pr          m649a_u1x8_uart0_noled            m649a_u1x8_uart0_noled_pr
 * m649p_u1x8_uart0_noled            m649p_u1x8_uart0_noled_pr         m6490_u1x8_uart0_noled
 * m6490_u1x8_uart0_noled_pr         m6490a_u1x8_uart0_noled           m6490a_u1x8_uart0_noled_pr
 * m6490p_u1x8_uart0_noled           m6490p_u1x8_uart0_noled_pr        m645_u1x8_uart0_noled
 * m645_u1x8_uart0_noled_pr          m645a_u1x8_uart0_noled            m645a_u1x8_uart0_noled_pr
 * m645p_u1x8_uart0_noled            m645p_u1x8_uart0_noled_pr         m6450_u1x8_uart0_noled
 * m6450_u1x8_uart0_noled_pr         m6450a_u1x8_uart0_noled           m6450a_u1x8_uart0_noled_pr
 * m6450p_u1x8_uart0_noled           m6450p_u1x8_uart0_noled_pr
 */
static const uint64_t ur_m649_u1x8_uart0_noled[] = {
  0xb777775ddacdfc4f, 0xdddddd55d870bdc4, 0xcad9fbbf0feb11dd, 0x71fad2fcdddd2202, 0x7793bb0bd68f1e82,
  0xc149827c60241305, 0x0b7b02f93fdfa1e7, 0x3be5843dce6fed10, 0x90e2481a0bf51fa0, 0x98b016594cf7dad4,
  0x8ebd1f3b57f47ac3, 0x6c7d99e5403ff660, 0x312b5ec1c7c0f2cf, 0x301deb5e73859bf0, 0x29b19c2de6f00fa8,
  0x31bc67440aeaa72f, 0x8ab7b15545a585ce, 0xce1b94b52fcdb124, 0x75663c81a3f8d163, 0xe32c970cf4c2b93f,
  0xd0ccb0e9296ce1c4, 0x801cb022f9e4afdc, 0x000000000000007c,
};

/*
 * m649a_u1x8_uart0_noled_pr_u4      m649p_u1x8_uart0_noled_pr_u4      m6490_u1x8_uart0_noled_pr_u4
 * m6490a_u1x8_uart0_noled_pr_u4     m6490p_u1x8_uart0_noled_pr_u4     m645_u1x8_uart0_noled_pr_u4
 * m645a_u1x8_uart0_noled_pr_u4      m645p_u1x8_uart0_noled_pr_u4      m6450_u1x8_uart0_noled_pr_u4
 * m6450a_u1x8_uart0_noled_pr_u4     m6450p_u1x8_uart0_noled_pr_u4
 */
static const uint64_t ur_m649_u1x8_uart0_noled_pr_u4[] = {
  0x777775dd4486bd3a, 0xddddd55d870bdc4b, 0xad9fbbf0feb11ddd, 0x1fad2fcdddd2202c, 0xe4ee8d35c7e3fe9f,
  0x52609f180904c15d, 0xdec0be4ffb15d9f0, 0xf9610f739bfb4402, 0x38920682fd47e80e, 0x2c0596533df6b524,
  0xaf47ced5fd1eb0e6, 0x1f6679500ffd9823, 0x4ad7b071f03cb3db, 0x077ad79ce166fc0c, 0x6c670b79bc03ea0c,
  0x6f19d102baa9cbca, 0xadec55516961738c, 0xc6e52d4bf36c4922, 0xaccdfc1ddc68b224, 0xe1ef79430a9cfd4e,
  0xed871fc65f989ffd, 0xa3d17f81fbf619a3, 0x89c6592e19e985f1, 0xb9a19961d252d9c3, 0xf274793d71f3c95f,
  0x0000000000000001,
};

/*
 * m649_u1x8_uart0_noled_pr_ee_u4    m649a_u1x8_uart0_noled_pr_ee      m649a_u1x8_uart0_noled_pr_ee_u4
 * m649p_u1x8_uart0_noled_pr_ee      m649p_u1x8_uart0_noled_pr_ee_u4   m6490_u1x8_uart0_noled_pr_ee
 * m6490_u1x8_uart0_noled_pr_ee_u4   m6490a_u1x8_uart0_noled_pr_ee     m6490a_u1x8_uart0_noled_pr_ee_u4
 * m6490p_u1x8_uart0_noled_pr_ee     m6490p_u1x8_uart0_noled_pr_ee_u4  m645_u1x8_uart0_noled_pr_ee
 * m645_u1x8_uart0_noled_pr_ee_u4    m645a_u1x8_uart0_noled_pr_ee      m645a_u1x8_uart0_noled_pr_ee_u4
 * m645p_u1x8_uart0_noled_pr_ee      m645p_u1x8_uart0_noled_pr_ee_u4   m6450_u1x8_uart0_noled_pr_ee
 * m6450_u1x8_uart0_noled_pr_ee_u4   m6450a_u1x8_uart0_noled_pr_ee     m6450a_u1x8_uart0_noled_pr_ee_u4
 * m6450p_u1x8_uart0_noled_pr_ee     m6450p_u1x8_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m649_u1x8_uart0_noled_pr_ee[] = {
  0xbbbbbaeea2433a31, 0xeeeeeaaeb9041225, 0x2f0a7a636f4ddeee, 0xc662705f0bddddfe, 0xdb1361aa280a0666,
  0x13e30120982bbc9d, 0x4e97fec5767ca5cc, 0x71b9cdfda2016f60, 0x3ea3cae449aad68e, 0x8afbaf51f06cc1a6,
  0x62291669d68450ef, 0xae3593484d7d1859, 0x6f68f059cead2f38, 0xc6c6ab5d0ebce9bb, 0x973170908a39e461,
  0xa546c11fadc37b2d, 0xf81895af600544a9, 0xd4180ef5af39c2cd, 0x9794d8ce16f37807, 0xe718de33a2057553,
  0x92455bd8aaa2d2c2, 0x64498dca5a97e6d8, 0xfa9d599bf83bb8d1, 0x3ffbc3def2861539, 0x3347db0e3f8cbf31,
  0x0be347a2ff03f7ec, 0xb387138cb25c33d3, 0x92bf734332c3a4a5, 0x00013afc687ae3e7,
};

/*
 * m649a_u1x8_uart0_noled_pr_ce      m649p_u1x8_uart0_noled_pr_ce      m6490_u1x8_uart0_noled_pr_ce
 * m6490a_u1x8_uart0_noled_pr_ce     m6490p_u1x8_uart0_noled_pr_ce     m645_u1x8_uart0_noled_pr_ce
 * m645a_u1x8_uart0_noled_pr_ce      m645p_u1x8_uart0_noled_pr_ce      m6450_u1x8_uart0_noled_pr_ce
 * m6450a_u1x8_uart0_noled_pr_ce     m6450p_u1x8_uart0_noled_pr_ce
 */
static const uint64_t ur_m649_u1x8_uart0_noled_pr_ce[] = {
  0x96eeeeebbb59bb37, 0xbbbbbbaab8832458, 0x5941c5a64efcd19b, 0x79b0c478fbc9bbba, 0x4c15de4eed8f6421,
  0x0f3fb7e609f18090, 0x68805bd81751fefd, 0xb1f2c7f5e82e737f, 0x0ee4fe77e79b8773, 0x2e7b965d63399ceb,
  0xa4871240f19fa8f5, 0x1a839cc580bd0243, 0x39633c75e2e76a25, 0xf0312b5ec1d7e1ee, 0x6f301deb5e73859b,
  0x306a6c4a7ef9c2de, 0x3a2042063042d392, 0xca5a97e6da718de3, 0x1e40d1fc68b1e70d, 0x4b867a615c9fbab3,
  0x587494b670e27196, 0x58117cf257ee6866, 0x000000000005ba80,
};

/*
 * m649a_u1x8_uart0_noled_pr_ce_u4   m649p_u1x8_uart0_noled_pr_ce_u4   m6490_u1x8_uart0_noled_pr_ce_u4
 * m6490a_u1x8_uart0_noled_pr_ce_u4  m6490p_u1x8_uart0_noled_pr_ce_u4  m645_u1x8_uart0_noled_pr_ce_u4
 * m645a_u1x8_uart0_noled_pr_ce_u4   m645p_u1x8_uart0_noled_pr_ce_u4   m6450_u1x8_uart0_noled_pr_ce_u4
 * m6450a_u1x8_uart0_noled_pr_ce_u4  m6450p_u1x8_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m649_u1x8_uart0_noled_pr_ce_u4[] = {
  0x777775dd44860cc5, 0xddddd55e6131dc4b, 0x782ff1fc7f568ddd, 0xc2ac9933ddddd5b7, 0xbc9dd8361ba199ba,
  0xc9cc13e30120982b, 0x6f604beffec5767d, 0x2fd621b9cdfda201, 0xb3879e3cdcee3dc6, 0xea3e12fc4361222e,
  0xfac993170fff0347, 0x3d67a8e4f4f72cea, 0xb0147ce92921c490, 0xbd1f3b57f47ac398, 0x7d99e5403ff6678e,
  0x4ad7b071f03cb5b8, 0x077ad79ce166fc0c, 0x6c670b79bc03ea0c, 0x6f19d102baa9cbca, 0xedec55516961738c,
  0x8dca5a97e6d89218, 0x599bf83bb8d16449, 0xc3def2861539fa9d, 0xdb0e3f8cbf313ffb, 0x47a2ff03f7ec3347,
  0x138cb25c33d30be3, 0x734332c3a4a5b387, 0x75c0bb5ae3e792bf, 0x0000000000000003,
};

/*
 * m649_u1x8_uart0_noled_pr_ee_ce_u4 m649a_u1x8_uart0_noled_pr_ee_ce   m649a_u1x8_uart0_noled_pr_ee_ce_u4
 * m649p_u1x8_uart0_noled_pr_ee_ce   m649p_u1x8_uart0_noled_pr_ee_ce_u4
 * m6490_u1x8_uart0_noled_pr_ee_ce   m6490_u1x8_uart0_noled_pr_ee_ce_u4
 * m6490a_u1x8_uart0_noled_pr_ee_ce  m6490a_u1x8_uart0_noled_pr_ee_ce_u4
 * m6490p_u1x8_uart0_noled_pr_ee_ce  m6490p_u1x8_uart0_noled_pr_ee_ce_u4
 * m645_u1x8_uart0_noled_pr_ee_ce    m645_u1x8_uart0_noled_pr_ee_ce_u4 m645a_u1x8_uart0_noled_pr_ee_ce
 * m645a_u1x8_uart0_noled_pr_ee_ce_u4 m645p_u1x8_uart0_noled_pr_ee_ce
 * m645p_u1x8_uart0_noled_pr_ee_ce_u4 m6450_u1x8_uart0_noled_pr_ee_ce
 * m6450_u1x8_uart0_noled_pr_ee_ce_u4 m6450a_u1x8_uart0_noled_pr_ee_ce
 * m6450a_u1x8_uart0_noled_pr_ee_ce_u4 m6450p_u1x8_uart0_noled_pr_ee_ce
 * m6450p_u1x8_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u1x8_uart0_noled_pr_ee_ce[] = {
  0x777775dd44864aa4, 0xbbbbaabce27e9c4b, 0x647ea2833de9dbbb, 0x3697a90bdeef8f7a, 0x49962f93b3ef92d3,
  0x3e30120982bbc9dd, 0x2d7fd8aecf98fcc1, 0xd739bfb4402dec09, 0x9b9dc728c5faa3f9, 0x886c2445d670f3c7,
  0x87a4a672fd47c25f, 0x5129dac20f7cc98b, 0x7c1b306b5fd4795f, 0xeb422814c5613fd4, 0x26be8c2cb1148b34,
  0xf059ceaedd388ea4, 0x578d8ebce9bb6f68, 0xe1211473c8c38d8d, 0xc1132386f65b2e62, 0x95af616744a9a546,
  0x0ef5af39c2cdf818, 0xd8ce16f37807d418, 0xde33a20575539794, 0xdbd8aaa2d2c2e718, 0x1b94b52fcdb12431,
  0xb337f07771a2c893, 0x87bde50c2a73f53a, 0xb61c7f197e627ff7, 0x8f45fe07efd8668f, 0x271964b867a617c6,
  0xe6866587494b670e, 0x7e2538f5c7cf257e, 0x0000000000000002,
};

/*
 * m649a_u1x8_uart0_noled_ee_hw      m649p_u1x8_uart0_noled_ee_hw      m6490_u1x8_uart0_noled_ee_hw
 * m6490a_u1x8_uart0_noled_ee_hw     m6490p_u1x8_uart0_noled_ee_hw     m645_u1x8_uart0_noled_ee_hw
 * m645a_u1x8_uart0_noled_ee_hw      m645p_u1x8_uart0_noled_ee_hw      m6450_u1x8_uart0_noled_ee_hw
 * m6450a_u1x8_uart0_noled_ee_hw     m6450p_u1x8_uart0_noled_ee_hw     c64_u1x8_uart0_noled_ee_hw
 */
static const uint64_t ur_m649_u1x8_uart0_noled_ee_hw[] = {
  0xddddd77514680cc5, 0x77775575c820912d, 0x7853d31b7a6ef777, 0x331382f85eeeeff1, 0xdd8361bb4dd03336,
  0xc13e30120982bbc9, 0x813a5ffeb267ca5c, 0x39c6e737f68805bd, 0x98fa8f2b9126ab5a, 0xbe2beebd47c1b306,
  0x6588a459a75a1143, 0xe2b8d64d2135f461, 0xedbda3c1673ab4bc, 0x871b1aad743af3a6, 0xb65cc5c24228e791,
  0xa6951b047eb70dec, 0x37e06256bd801512, 0x1f50603bd6bce70b, 0x4e5e5363385bcde0, 0x0b9c6378ce8815d5,
  0x6249156f62aa8b4b, 0xf509c637296a5f9b, 0x7ff787bde50c2a73, 0x668fb61c7f197e62, 0x17c68f45fe07efd8,
  0x670e271964b867a6, 0x257ee6866587494b, 0x000002df1a6b514f,
};

/*
 * m649_u1x8_uart0_noled_ee_ce_u4_hw m649a_u1x8_uart0_noled_ee_ce_hw   m649a_u1x8_uart0_noled_ee_ce_u4_hw
 * m649p_u1x8_uart0_noled_ee_ce_hw   m649p_u1x8_uart0_noled_ee_ce_u4_hw
 * m6490_u1x8_uart0_noled_ee_ce_hw   m6490_u1x8_uart0_noled_ee_ce_u4_hw
 * m6490a_u1x8_uart0_noled_ee_ce_hw  m6490a_u1x8_uart0_noled_ee_ce_u4_hw
 * m6490p_u1x8_uart0_noled_ee_ce_hw  m6490p_u1x8_uart0_noled_ee_ce_u4_hw
 * m645_u1x8_uart0_noled_ee_ce_hw    m645_u1x8_uart0_noled_ee_ce_u4_hw m645a_u1x8_uart0_noled_ee_ce_hw
 * m645a_u1x8_uart0_noled_ee_ce_u4_hw m645p_u1x8_uart0_noled_ee_ce_hw
 * m645p_u1x8_uart0_noled_ee_ce_u4_hw m6450_u1x8_uart0_noled_ee_ce_hw
 * m6450_u1x8_uart0_noled_ee_ce_u4_hw m6450a_u1x8_uart0_noled_ee_ce_hw
 * m6450a_u1x8_uart0_noled_ee_ce_u4_hw m6450p_u1x8_uart0_noled_ee_ce_hw
 * m6450p_u1x8_uart0_noled_ee_ce_u4_hw c64_u1x8_uart0_noled_ee_ce_hw
 * c64_u1x8_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u1x8_uart0_noled_ee_ce_hw[] = {
  0xbbbbbaeea28d0582, 0xddddd55e713f4e25, 0x323f51419ef4eddd, 0x9b4bd485ef77c7bd, 0x774ed043d2d5c969,
  0x304f8c048260aef2, 0xc092d7ff5933e63f, 0x3f9d739bfb4402de, 0x79e439dc728c5faa, 0x4bf10d8488bace1e,
  0x62e1f9699bffa8f8, 0x57d44a76b083df32, 0xf51f06cc1ad7f51e, 0xcd3ad08a0531584f, 0xa909afa30b2c4522,
  0xda3c1673abb74e23, 0x6355e363af3a6edb, 0x98b848451cf230e3, 0x51b044c8e1bd96cb, 0x06256bd859d12a69,
  0x0603bd6bce70b37e, 0xe5363385bcde01f5, 0xc6378ce8815d54e5, 0x0c76f62aa8b4b0b9, 0x38c6e52d4bf36c49,
  0xf0f7bca1854e7ea1, 0xf6c38fe32fcc4ffe, 0xd1e8bfc0fdfb0cd1, 0xc4e32c970cf4c2f8, 0xdcd0ccb0e9296ce1,
  0x0280a03eea29e4af,
};

/*
 * m649_u1x8_uart0_lednop_pr         m649a_u1x8_uart0_lednop           m649a_u1x8_uart0_lednop_pr
 * m649p_u1x8_uart0_lednop           m649p_u1x8_uart0_lednop_pr        m6490_u1x8_uart0_lednop
 * m6490_u1x8_uart0_lednop_pr        m6490a_u1x8_uart0_lednop          m6490a_u1x8_uart0_lednop_pr
 * m6490p_u1x8_uart0_lednop          m6490p_u1x8_uart0_lednop_pr       m645_u1x8_uart0_lednop
 * m645_u1x8_uart0_lednop_pr         m645a_u1x8_uart0_lednop           m645a_u1x8_uart0_lednop_pr
 * m645p_u1x8_uart0_lednop           m645p_u1x8_uart0_lednop_pr        m6450_u1x8_uart0_lednop
 * m6450_u1x8_uart0_lednop_pr        m6450a_u1x8_uart0_lednop          m6450a_u1x8_uart0_lednop_pr
 * m6450p_u1x8_uart0_lednop          m6450p_u1x8_uart0_lednop_pr
 */
static const uint64_t ur_m649_u1x8_uart0_lednop[] = {
  0xb777775ddacdfebe, 0xeeeeeeaaec38f244, 0xb2e6fc1cd0778fee, 0xad0bdbf6ddddcd60, 0xef2777c7e145c490,
  0xaf9304f8c048260a, 0x16f60498ffbf43cf, 0x77cb243b9cdfda20, 0x21c4903349ea393c, 0x31602dee987ce929,
  0x75e2e766be4720a7, 0x5ec2b07dee396304, 0x781013859bf0312b, 0xf379b228301deb5e, 0xf2a6f529c94e8016,
  0xa6ae9c6378ce881d, 0xe6db9c8ab7b15545, 0xfc68b1e70dca5a97, 0x615c9fbab31e40d1, 0xb670e271964b867a,
  0xf257ee6866587494, 0x000007c87398117c,
};

/*
 * m649a_u1x8_uart0_lednop_pr_u4     m649p_u1x8_uart0_lednop_pr_u4     m6490_u1x8_uart0_lednop_pr_u4
 * m6490a_u1x8_uart0_lednop_pr_u4    m6490p_u1x8_uart0_lednop_pr_u4    m645_u1x8_uart0_lednop_pr_u4
 * m645a_u1x8_uart0_lednop_pr_u4     m645p_u1x8_uart0_lednop_pr_u4     m6450_u1x8_uart0_lednop_pr_u4
 * m6450a_u1x8_uart0_lednop_pr_u4    m6450p_u1x8_uart0_lednop_pr_u4
 */
static const uint64_t ur_m649_u1x8_uart0_lednop_pr_u4[] = {
  0x777775dd44861c3b, 0xddddd55d8706bc4b, 0xa2f7b3dfb6933ddd, 0x95d7f89dddd2202c, 0x93bb4169982ff23e,
  0x09827c6024130577, 0x7b029bbfec5767d0, 0xe5843dce6fed100b, 0xe2481a0bf51ed63b, 0x602cb29be483f490,
  0xe8f9d967a3486731, 0x2cd22a01ffb30475, 0x5af6415a07967b68, 0xf3c0809c2cdf8189, 0xb79bcd914180ef5a,
  0xef9537a94e4a7400, 0x2d3574e31bc67440, 0xbf36dce455bd8aaa, 0xddc68b224c6e52d4, 0x30a9cfd4eaccdfc1,
  0x65f989ffde1ef794, 0x1fbf619a3ed871fc, 0xe19e985f1a3d17f8, 0x1d252d9c389c6592, 0xd71f3c95fb9a1996,
  0x000000001f26b8be,
};

/*
 * m649_u1x8_uart0_lednop_pr_ee_u4   m649a_u1x8_uart0_lednop_pr_ee     m649a_u1x8_uart0_lednop_pr_ee_u4
 * m649p_u1x8_uart0_lednop_pr_ee     m649p_u1x8_uart0_lednop_pr_ee_u4  m6490_u1x8_uart0_lednop_pr_ee
 * m6490_u1x8_uart0_lednop_pr_ee_u4  m6490a_u1x8_uart0_lednop_pr_ee    m6490a_u1x8_uart0_lednop_pr_ee_u4
 * m6490p_u1x8_uart0_lednop_pr_ee    m6490p_u1x8_uart0_lednop_pr_ee_u4 m645_u1x8_uart0_lednop_pr_ee
 * m645_u1x8_uart0_lednop_pr_ee_u4   m645a_u1x8_uart0_lednop_pr_ee     m645a_u1x8_uart0_lednop_pr_ee_u4
 * m645p_u1x8_uart0_lednop_pr_ee     m645p_u1x8_uart0_lednop_pr_ee_u4  m6450_u1x8_uart0_lednop_pr_ee
 * m6450_u1x8_uart0_lednop_pr_ee_u4  m6450a_u1x8_uart0_lednop_pr_ee    m6450a_u1x8_uart0_lednop_pr_ee_u4
 * m6450p_u1x8_uart0_lednop_pr_ee    m6450p_u1x8_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m649_u1x8_uart0_lednop_pr_ee[] = {
  0xbbbbbaeea2432493, 0xddddd55d72056e25, 0x2d04c2aa1eb4bddd, 0xfb1e705f0bddddfe, 0x43720a23e768fde2,
  0x4f8c048260aef277, 0x175ffb15d9f53d30, 0xc6e737f68805bd81, 0xfa8f2b32a6ab5a39, 0x561efd47c1b30698,
  0x1148b34eb422877c, 0x71ac9a426be8c2cb, 0x1923268e756973d5, 0xab1aad743af3a6ed, 0x5cc5c242282791bd,
  0x951b047eb70decb6, 0xc0c4ad7b0021f667, 0x77ad79e0404e166f, 0x3a005bcde6c8a0c0, 0x3a2077ca9bd4a725,
  0xc555169aba718de3, 0x296a5f9b6e722ade, 0x6fe0eee345912637, 0x7bca1854e7ea7566, 0x38fe32fcc4ffef0f,
  0x8bfc0fdfb0cd1f6c, 0x32c970cf4c2f8d1e, 0x0ccb0e9296ce1c4e, 0x9fadeb8f9e4afdcd, 0x00000000000004eb,
};

/*
 * m649_u1x8_uart0_lednop_pr_ce_u4   m649a_u1x8_uart0_lednop_pr_ce     m649a_u1x8_uart0_lednop_pr_ce_u4
 * m649p_u1x8_uart0_lednop_pr_ce     m649p_u1x8_uart0_lednop_pr_ce_u4  m6490_u1x8_uart0_lednop_pr_ce
 * m6490_u1x8_uart0_lednop_pr_ce_u4  m6490a_u1x8_uart0_lednop_pr_ce    m6490a_u1x8_uart0_lednop_pr_ce_u4
 * m6490p_u1x8_uart0_lednop_pr_ce    m6490p_u1x8_uart0_lednop_pr_ce_u4 m645_u1x8_uart0_lednop_pr_ce
 * m645_u1x8_uart0_lednop_pr_ce_u4   m645a_u1x8_uart0_lednop_pr_ce     m645a_u1x8_uart0_lednop_pr_ce_u4
 * m645p_u1x8_uart0_lednop_pr_ce     m645p_u1x8_uart0_lednop_pr_ce_u4  m6450_u1x8_uart0_lednop_pr_ce
 * m6450_u1x8_uart0_lednop_pr_ce_u4  m6450a_u1x8_uart0_lednop_pr_ce    m6450a_u1x8_uart0_lednop_pr_ce_u4
 * m6450p_u1x8_uart0_lednop_pr_ce    m6450p_u1x8_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m649_u1x8_uart0_lednop_pr_ce[] = {
  0x777775dd44862d7b, 0xddddd55e6114dc4b, 0x7e3b05fe974d8ddd, 0x90424200ddddd5b7, 0xef27751d94aa16ec,
  0x74b304f8c048260a, 0x5bd817eeffb15d9f, 0x8bf5886e737f6880, 0xace1e78f373b80d1, 0xfa8f84bf10d8488b,
  0xfac993170e9b73b7, 0x3d67a8fd24f72cea, 0xb01531116921c490, 0xf47cecb3d1a43398, 0x16691500ffd99e3a,
  0x2b5ec82b40f2d6e4, 0x5e781013859bf031, 0x16f379b228301deb, 0x1df2a6f529c94e80, 0x45a6ae9c6378ce88,
  0x2fcdb73863b7b155, 0x7771a2c8931b94b5, 0x0c2a73f53ab337f0, 0x197e627ff787bde5, 0x07efd8668fb61c7f,
  0xb867a617c68f45fe, 0x87494b670e271964, 0x35c7cf257ee68665, 0x000000000375c6a9,
};

/*
 * m649_u1x8_uart0_lednop_pr_ee_ce_u4 m649a_u1x8_uart0_lednop_pr_ee_ce
 * m649a_u1x8_uart0_lednop_pr_ee_ce_u4 m649p_u1x8_uart0_lednop_pr_ee_ce
 * m649p_u1x8_uart0_lednop_pr_ee_ce_u4 m6490_u1x8_uart0_lednop_pr_ee_ce
 * m6490_u1x8_uart0_lednop_pr_ee_ce_u4 m6490a_u1x8_uart0_lednop_pr_ee_ce
 * m6490a_u1x8_uart0_lednop_pr_ee_ce_u4 m6490p_u1x8_uart0_lednop_pr_ee_ce
 * m6490p_u1x8_uart0_lednop_pr_ee_ce_u4 m645_u1x8_uart0_lednop_pr_ee_ce
 * m645_u1x8_uart0_lednop_pr_ee_ce_u4 m645a_u1x8_uart0_lednop_pr_ee_ce
 * m645a_u1x8_uart0_lednop_pr_ee_ce_u4 m645p_u1x8_uart0_lednop_pr_ee_ce
 * m645p_u1x8_uart0_lednop_pr_ee_ce_u4 m6450_u1x8_uart0_lednop_pr_ee_ce
 * m6450_u1x8_uart0_lednop_pr_ee_ce_u4 m6450a_u1x8_uart0_lednop_pr_ee_ce
 * m6450a_u1x8_uart0_lednop_pr_ee_ce_u4 m6450p_u1x8_uart0_lednop_pr_ee_ce
 * m6450p_u1x8_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u1x8_uart0_lednop_pr_ee_ce[] = {
  0x777775dd448607e1, 0xbbbbaabce27c8c4b, 0x7f4c8f9fbd123bbb, 0x17afa90bdeef8f7a, 0x087bf702c75e5dac,
  0x3e30120982bbc9dd, 0xa7ffec5767ffe4c1, 0xd739bfb4402dec0b, 0x9b9d93a8c5faa3f9, 0x886c2445d670f3c7,
  0x0f950d07fd47c25f, 0xea53b5841ef99317, 0xf83660d6bfa8f2be, 0xd68450298af6ffa8, 0x4d7d185962291669,
  0xc9a39d5db8f51d48, 0x578d8ebce9bb4648, 0xe1211413c8ded58d, 0xc1132386f65b2e62, 0x2b5ec2cc7d99e546,
  0x5e781013859bf031, 0x16f379b228301deb, 0x1df2a6f529c94e80, 0x45a6ae9c6378ce88, 0x2fcdb73863b7b155,
  0x7771a2c8931b94b5, 0x0c2a73f53ab337f0, 0x197e627ff787bde5, 0x07efd8668fb61c7f, 0xb867a617c68f45fe,
  0x87494b670e271964, 0xf5c7cf257ee68665, 0x00000000013f2cb7,
};

/*
 * m649a_u1x8_uart0_lednop_ee_hw     m649p_u1x8_uart0_lednop_ee_hw     m6490_u1x8_uart0_lednop_ee_hw
 * m6490a_u1x8_uart0_lednop_ee_hw    m6490p_u1x8_uart0_lednop_ee_hw    m645_u1x8_uart0_lednop_ee_hw
 * m645a_u1x8_uart0_lednop_ee_hw     m645p_u1x8_uart0_lednop_ee_hw     m6450_u1x8_uart0_lednop_ee_hw
 * m6450a_u1x8_uart0_lednop_ee_hw    m6450p_u1x8_uart0_lednop_ee_hw    c64_u1x8_uart0_lednop_ee_hw
 */
static const uint64_t ur_m649_u1x8_uart0_lednop_ee_hw[] = {
  0xddddd77514682d7b, 0xeeeeaaeb902b712d, 0x68261550f5a5eeee, 0xd8f382f85eeeeff1, 0x751d94ad7647ef17,
  0x04f8c048260aef27, 0x045d7ffac99f53d3, 0xe71b9cdfda2016f6, 0x63ea3cacca9aad68, 0xf1587bf51f06cc1a,
  0x2c4522cd3ad08a1d, 0x55c6b26909afa30b, 0xb4648c9a39d5a5cf, 0xf6ac6ab5d0ebce9b, 0xd973170908a09e46,
  0x9e546c11fadc37b2, 0xbf0312b5ec0087d9, 0x01deb5e781013859, 0x94e8016f379b2283, 0x8ce881df2a6f529c,
  0x7b15545a6ae9c637, 0xdca5a97e6db9c8ab, 0xf79430a9cfd42718, 0x71fc65f989ffde1e, 0x17f81fbf619a3ed8,
  0x6592e19e985f1a3d, 0x19961d252d9c389c, 0x7eecb5453c95fb9a, 0x000000000000000b,
};

/*
 * m649_u1x8_uart0_lednop_ee_ce_u4_hw m649a_u1x8_uart0_lednop_ee_ce_hw
 * m649a_u1x8_uart0_lednop_ee_ce_u4_hw m649p_u1x8_uart0_lednop_ee_ce_hw
 * m649p_u1x8_uart0_lednop_ee_ce_u4_hw m6490_u1x8_uart0_lednop_ee_ce_hw
 * m6490_u1x8_uart0_lednop_ee_ce_u4_hw m6490a_u1x8_uart0_lednop_ee_ce_hw
 * m6490a_u1x8_uart0_lednop_ee_ce_u4_hw m6490p_u1x8_uart0_lednop_ee_ce_hw
 * m6490p_u1x8_uart0_lednop_ee_ce_u4_hw m645_u1x8_uart0_lednop_ee_ce_hw
 * m645_u1x8_uart0_lednop_ee_ce_u4_hw m645a_u1x8_uart0_lednop_ee_ce_hw
 * m645a_u1x8_uart0_lednop_ee_ce_u4_hw m645p_u1x8_uart0_lednop_ee_ce_hw
 * m645p_u1x8_uart0_lednop_ee_ce_u4_hw m6450_u1x8_uart0_lednop_ee_ce_hw
 * m6450_u1x8_uart0_lednop_ee_ce_u4_hw m6450a_u1x8_uart0_lednop_ee_ce_hw
 * m6450a_u1x8_uart0_lednop_ee_ce_u4_hw m6450p_u1x8_uart0_lednop_ee_ce_hw
 * m6450p_u1x8_uart0_lednop_ee_ce_u4_hw c64_u1x8_uart0_lednop_ee_ce_hw
 * c64_u1x8_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u1x8_uart0_lednop_ee_ce_hw[] = {
  0xb777775dd451a111, 0xbbbbbaabce27c8c4, 0xa7f4c8f9fbd123bb, 0xc17afa90bdeef8f7, 0x4eeabe67da58a5da,
  0x2609f180904c15de, 0xd8174ffff5933fff, 0x47f3ae737f68805b, 0xcf3c873b27518bf5, 0x097e21b0911759c3,
  0x262e1facd90ff51f, 0xe57dd4a76b083df3, 0xff51f06cc1ad7f51, 0x2cd3ad08a05315ed, 0x3a909afa30b2c452,
  0x8c9193473abb71ea, 0xab1aaf1b1d79d376, 0x5cc5c242282791bd, 0xca8d8226470decb6, 0xe06256bd8598fb33,
  0x3bd6bcf020270b37, 0x9d002de6f3645060, 0x9d103be54dea5392, 0x62aa8b4d5d38c6f1, 0x296a5f9b6e70c76f,
  0xe50c2a73f509c637, 0x7f197e627ff787bd, 0xfe07efd8668fb61c, 0x64b867a617c68f45, 0x6587494b670e2719,
  0x1d52514f257ee686, 0x0000000000000a02,
};

/*
 * m649_u1x8_uart0_dual_pr           m649_u1x8_uart0_dual_pr_u4        m649a_u1x8_uart0_dual
 * m649a_u1x8_uart0_dual_pr          m649a_u1x8_uart0_dual_pr_u4       m649p_u1x8_uart0_dual
 * m649p_u1x8_uart0_dual_pr          m649p_u1x8_uart0_dual_pr_u4       m6490_u1x8_uart0_dual
 * m6490_u1x8_uart0_dual_pr          m6490_u1x8_uart0_dual_pr_u4       m6490a_u1x8_uart0_dual
 * m6490a_u1x8_uart0_dual_pr         m6490a_u1x8_uart0_dual_pr_u4      m6490p_u1x8_uart0_dual
 * m6490p_u1x8_uart0_dual_pr         m6490p_u1x8_uart0_dual_pr_u4      m645_u1x8_uart0_dual
 * m645_u1x8_uart0_dual_pr           m645_u1x8_uart0_dual_pr_u4        m645a_u1x8_uart0_dual
 * m645a_u1x8_uart0_dual_pr          m645a_u1x8_uart0_dual_pr_u4       m645p_u1x8_uart0_dual
 * m645p_u1x8_uart0_dual_pr          m645p_u1x8_uart0_dual_pr_u4       m6450_u1x8_uart0_dual
 * m6450_u1x8_uart0_dual_pr          m6450_u1x8_uart0_dual_pr_u4       m6450a_u1x8_uart0_dual
 * m6450a_u1x8_uart0_dual_pr         m6450a_u1x8_uart0_dual_pr_u4      m6450p_u1x8_uart0_dual
 * m6450p_u1x8_uart0_dual_pr         m6450p_u1x8_uart0_dual_pr_u4
 */
static const uint64_t ur_m649_u1x8_uart0_dual[] = {
  0xddddd60f4486bd5b, 0x7777756266f5afcd, 0x4a73338e3a76b777, 0x8ac323bdddd69764, 0x6dddddfb84e5682d,
  0x27c6024130577925, 0xbec99182a90cdf98, 0xc40c2860da4606ee, 0x43fe650129dd3e25, 0x3945d8393387ce9a,
  0x1491209206fe4dea, 0xc2886257f9fbe08a, 0x672f4ce05a13eb87, 0x5150865a098a2195, 0xdb98fffa039e1346,
  0xf5524c161bcaf212, 0xdfda2016f6047aff, 0xea3e453be589ab9c, 0x717be921c490310f, 0x475fce62c055079a,
  0xff6608ebc019dad6, 0x0f2cf6c43a435403, 0xf8abe77715255274, 0x270b37e06256bd93, 0x6450603bd6bcf020,
  0xea53929d002de6f3, 0x38c6f19d103be54d, 0x39156f62aa8b4d5d, 0xc8931b94b52fcdb7, 0xf53ab337f07771a2,
  0x7ff787bde50c2a73, 0x668fb61c7f197e62, 0x17c68f45fe07efd8, 0x670e271964b867a6, 0x257ee6866587494b,
  0x000524efaa35c7cf,
};

/*
 * m649_u1x8_uart0_dual_pr_ee_u4     m649a_u1x8_uart0_dual_pr_ee       m649a_u1x8_uart0_dual_pr_ee_u4
 * m649p_u1x8_uart0_dual_pr_ee       m649p_u1x8_uart0_dual_pr_ee_u4    m6490_u1x8_uart0_dual_pr_ee
 * m6490_u1x8_uart0_dual_pr_ee_u4    m6490a_u1x8_uart0_dual_pr_ee      m6490a_u1x8_uart0_dual_pr_ee_u4
 * m6490p_u1x8_uart0_dual_pr_ee      m6490p_u1x8_uart0_dual_pr_ee_u4   m645_u1x8_uart0_dual_pr_ee
 * m645_u1x8_uart0_dual_pr_ee_u4     m645a_u1x8_uart0_dual_pr_ee       m645a_u1x8_uart0_dual_pr_ee_u4
 * m645p_u1x8_uart0_dual_pr_ee       m645p_u1x8_uart0_dual_pr_ee_u4    m6450_u1x8_uart0_dual_pr_ee
 * m6450_u1x8_uart0_dual_pr_ee_u4    m6450a_u1x8_uart0_dual_pr_ee      m6450a_u1x8_uart0_dual_pr_ee_u4
 * m6450p_u1x8_uart0_dual_pr_ee      m6450p_u1x8_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m649_u1x8_uart0_dual_pr_ee[] = {
  0xeeeeeb07a2436f02, 0x777775653745f7e6, 0x2af4fbfb5a807777, 0x0432e364774c894a, 0x1f35d08459baafad,
  0x41305779306ddcfe, 0x05521dbb9827c602, 0xc1b48c0ddd7d9323, 0x0253ba7c4b881850, 0x8f9c066e6ddafcca,
  0x40c9d4dea385ad81, 0xff3f7c1142922412, 0xd6627d70f8510c4a, 0x04ac886559cbd339, 0x039e132fb8a8432d,
  0x1bcaf212db9c1ffa, 0xec0b2b7ff5524c16, 0xd1c89739bfb4402d, 0x60a7a8f2b5f7355a, 0x77c5752bd47c1b30,
  0x2cb1148b34eb4228, 0xca5c54b9a426be8c, 0xbb4428f7b39d5a5c, 0x3e7ac6ab5d0ebd44, 0x2fa598b84845022a,
  0xfac546c11fadc37b, 0xe2af9ddc54940213, 0x9c2cdf81895af64f, 0x914180ef5af3c080, 0xa94e4a7400b79bcd,
  0xe31bc67440ef9537, 0xe455bd8aaa2d3574, 0x224c6e52d4bf36dc, 0xd4eaccdfc1ddc68b, 0xffde1ef79430a9cf,
  0x9a3ed871fc65f989, 0x5f1a3d17f81fbf61, 0x9c389c6592e19e98, 0x95fb9a19961d252d, 0x0000ac89a0d71f3c,
};

/*
 * m649_u1x8_uart0_dual_pr_ce_u4     m649a_u1x8_uart0_dual_pr_ce       m649a_u1x8_uart0_dual_pr_ce_u4
 * m649p_u1x8_uart0_dual_pr_ce       m649p_u1x8_uart0_dual_pr_ce_u4    m6490_u1x8_uart0_dual_pr_ce
 * m6490_u1x8_uart0_dual_pr_ce_u4    m6490a_u1x8_uart0_dual_pr_ce      m6490a_u1x8_uart0_dual_pr_ce_u4
 * m6490p_u1x8_uart0_dual_pr_ce      m6490p_u1x8_uart0_dual_pr_ce_u4   m645_u1x8_uart0_dual_pr_ce
 * m645_u1x8_uart0_dual_pr_ce_u4     m645a_u1x8_uart0_dual_pr_ce       m645a_u1x8_uart0_dual_pr_ce_u4
 * m645p_u1x8_uart0_dual_pr_ce       m645p_u1x8_uart0_dual_pr_ce_u4    m6450_u1x8_uart0_dual_pr_ce
 * m6450_u1x8_uart0_dual_pr_ce_u4    m6450a_u1x8_uart0_dual_pr_ce      m6450a_u1x8_uart0_dual_pr_ce_u4
 * m6450p_u1x8_uart0_dual_pr_ce      m6450p_u1x8_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m649_u1x8_uart0_dual_pr_ce[] = {
  0xddddd60f44860aac, 0xeeeeead0bfaeefcd, 0x8d49c9b168ebeeee, 0xf62eafb777448991, 0x777d5e5902c70455,
  0xf180904c15de4f91, 0x64c8c154836ee609, 0x0614306d2303775f, 0xff328094ee9f12e2, 0xe5b038270eaf9a87,
  0x4482481dba9bd478, 0x21895fe7ef822852, 0x7a673b044fae1f0a, 0x8432d07f110cab39, 0xfbffa039e136df8a,
  0x24c161bcaf212dbe, 0x4402dec08e1fff55, 0xad18bf597d739bfb, 0x88bace1e78f373b4, 0x801fa8f84bf10d84,
  0x9d5ea5cc98b87adf, 0x903a97ea38df9ee5, 0x98b014141f2921c4, 0x3af00676b591d7f3, 0xe10e90d500ffd99e,
  0x777152552740f2d6, 0x7e06256bd93f8abe, 0x03bd6bcf020270b3, 0x29d002de6f364506, 0x19d103be54dea539,
  0xf62aa8b4d5d38c6f, 0x7296a5f9b6e70c76, 0x66fe0eee34591263, 0xf7bca1854e7ea756, 0xc38fe32fcc4ffef0,
  0xe8bfc0fdfb0cd1f6, 0xe32c970cf4c2f8d1, 0xd0ccb0e9296ce1c4, 0x909c5eb8f9e4afdc, 0x0000000000000034,
};

/*
 * m649a_u1x8_uart0_dual_pr_ee_ce    m649p_u1x8_uart0_dual_pr_ee_ce    m6490_u1x8_uart0_dual_pr_ee_ce
 * m6490a_u1x8_uart0_dual_pr_ee_ce   m6490p_u1x8_uart0_dual_pr_ee_ce   m645_u1x8_uart0_dual_pr_ee_ce
 * m645a_u1x8_uart0_dual_pr_ee_ce    m645p_u1x8_uart0_dual_pr_ee_ce    m6450_u1x8_uart0_dual_pr_ee_ce
 * m6450a_u1x8_uart0_dual_pr_ee_ce   m6450p_u1x8_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m649_u1x8_uart0_dual_pr_ee_ce[] = {
  0xeeeeb07d4143359b, 0x7777562675df7e6e, 0xd740362fa0fb7777, 0x17ad12ef74054e24, 0xcc29368d7526f265,
  0x04c15de494e770f0, 0x15484e3e609f1809, 0x06d2303775f64c8c, 0x094ee9f12e206143, 0x6f9c2004c293f328,
  0x034db9bd47b5bd85, 0xfcfdf0450a489049, 0x6f89f5c3e144312b, 0x4ae4432ace5e99ce, 0x1cf098a1c5421968,
  0xde579096dc347fd0, 0x60496bffaa9260b0, 0x1feeb9cdfda2016f, 0xf3c79b9dc72b1fd5, 0xcdd339d61ee4492b,
  0xcf51e56fe4a76b02, 0x8ae037a8f83660d7, 0x62291669d6845029, 0xb8ca1d484d7d1859, 0x44bb4428f7b39d5d,
  0x547cf58d578d8ebd, 0xf65f4b3170908a04, 0x13fac546c1132386, 0x4fe2af9ddc5494b3, 0x809c2cdf81895af6,
  0xcd914180ef5af3c0, 0x37a94e4a7400b79b, 0x74e31bc67440ef95, 0xb9c31dbd8aaa2d35, 0x607a18dca5a97e6d,
  0xfa9d599bf83bb8d1, 0x3ed87138d2861539, 0xb867a615c9f80f9a, 0x87494b670e271964, 0x75c7cf257ee68665,
  0x00000000008001d1,
};

/*
 * m649a_u1x8_uart0_dual_pr_ee_ce_u4 m649p_u1x8_uart0_dual_pr_ee_ce_u4 m6490_u1x8_uart0_dual_pr_ee_ce_u4
 * m6490a_u1x8_uart0_dual_pr_ee_ce_u4 m6490p_u1x8_uart0_dual_pr_ee_ce_u4
 * m645_u1x8_uart0_dual_pr_ee_ce_u4  m645a_u1x8_uart0_dual_pr_ee_ce_u4 m645p_u1x8_uart0_dual_pr_ee_ce_u4
 * m6450_u1x8_uart0_dual_pr_ee_ce_u4 m6450a_u1x8_uart0_dual_pr_ee_ce_u4
 * m6450p_u1x8_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u1x8_uart0_dual_pr_ee_ce_u4[] = {
  0xbbbac1e8a87f3202, 0xdddd5817da0df9bb, 0xe421aafd9b4ddddd, 0xbc33323bbb299f03, 0xbde4fa6b0ce34f26,
  0x57792769dc34e83e, 0x9aa49827c6024130, 0x303775f64c8c1548, 0xe9f12e20614306d2, 0x96a666ffe656024e,
  0x9bd47ec1d85e19c3, 0x0450a4890490343e, 0x5c3e144312bfcfdf, 0x6559cbd339c8389f, 0x6ce8a8432d027488,
  0x12dbc00ffa039e13, 0xff190bcc161bcaf2, 0xcdfda2016f6041a3, 0xd98fc62fd51943b9, 0x0911759c3cf3e019,
  0x0dd0ff51f097e21b, 0xdac21374c98b8730, 0x9835f3d4795bf929, 0x140a62b80dea3e0d, 0x4616588a459a75a1,
  0xe7576e328752135f, 0x63af512ed10a3dec, 0x2281151f3d6355e3, 0xc8e1bd97d2cc5c24, 0x252cc4feb151b044,
  0x56bd93f8abe77715, 0xbcf020270b37e062, 0x2de6f36450603bd6, 0x3be54dea53929d00, 0x8b4d5d38c6f19d10,
  0x5f9b6e70c76f62aa, 0x8fe345912637296a, 0xc2a73f53ab337f06, 0x97e627ff787bde50, 0x7efd8668fb61c7f1,
  0x867a617c68f45fe0, 0x7494b670e271964b, 0x1014f257ee686658, 0x0000000020022ac5,
};

/*
 * m649a_u1x8_uart0_dual_ee_hw       m649p_u1x8_uart0_dual_ee_hw       m6490_u1x8_uart0_dual_ee_hw
 * m6490a_u1x8_uart0_dual_ee_hw      m6490p_u1x8_uart0_dual_ee_hw      m645_u1x8_uart0_dual_ee_hw
 * m645a_u1x8_uart0_dual_ee_hw       m645p_u1x8_uart0_dual_ee_hw       m6450_u1x8_uart0_dual_ee_hw
 * m6450a_u1x8_uart0_dual_ee_hw      m6450p_u1x8_uart0_dual_ee_hw      c64_u1x8_uart0_dual_ee_hw
 */
static const uint64_t ur_m649_u1x8_uart0_dual_ee_hw[] = {
  0x7777583d14680aac, 0xbbbbab29ba2fbf37, 0x57a7dfdad403bbbb, 0x21971b23ba644a51, 0xfabcb269c1557d68,
  0x0120982bbc9836ee, 0x9182a90eddcc13e3, 0x2860da4606eebec9, 0x657419dd3e25c40c, 0xc0c7ce033736ed7e,
  0x092064ea6f51c2d6, 0x257f9fbe08a14912, 0x9ceb313eb87c2886, 0x9682564432ace5e9, 0xfd01cf0997dc5421,
  0x0b0de579096dce0f, 0x0b7b02cadfe756e6, 0x56b47225ce6fed10, 0xcc1829ea3cad7dcd, 0x8a1df15d4af51f06,
  0xa30b2c4522cd3ad0, 0x973297152e6909af, 0x512ed10a3dece756, 0x8a8f9eb1aad743af, 0xdecbe9662e121140,
  0x84feb151b047eb70, 0x93f8abe777152500, 0x20270b37e06256bd, 0xf36450603bd6bcf0, 0x4dea53929d002de6,
  0x5d38c6f19d103be5, 0xb739156f62aa8b4d, 0xfa84e31b94b52fcd, 0x3ffbc3def2861539, 0x3347db0e3f8cbf31,
  0x0be347a2ff03f7ec, 0xb387138cb25c33d3, 0x92bf734332c3a4a5, 0x00002bb5c134e8a7,
};

/*
 * m649_u1x8_uart0_dual_ee_ce_u4_hw  m649a_u1x8_uart0_dual_ee_ce_hw    m649a_u1x8_uart0_dual_ee_ce_u4_hw
 * m649p_u1x8_uart0_dual_ee_ce_hw    m649p_u1x8_uart0_dual_ee_ce_u4_hw m6490_u1x8_uart0_dual_ee_ce_hw
 * m6490_u1x8_uart0_dual_ee_ce_u4_hw m6490a_u1x8_uart0_dual_ee_ce_hw
 * m6490a_u1x8_uart0_dual_ee_ce_u4_hw m6490p_u1x8_uart0_dual_ee_ce_hw
 * m6490p_u1x8_uart0_dual_ee_ce_u4_hw m645_u1x8_uart0_dual_ee_ce_hw
 * m645_u1x8_uart0_dual_ee_ce_u4_hw  m645a_u1x8_uart0_dual_ee_ce_hw    m645a_u1x8_uart0_dual_ee_ce_u4_hw
 * m645p_u1x8_uart0_dual_ee_ce_hw    m645p_u1x8_uart0_dual_ee_ce_u4_hw m6450_u1x8_uart0_dual_ee_ce_hw
 * m6450_u1x8_uart0_dual_ee_ce_u4_hw m6450a_u1x8_uart0_dual_ee_ce_hw
 * m6450a_u1x8_uart0_dual_ee_ce_u4_hw m6450p_u1x8_uart0_dual_ee_ce_hw
 * m6450p_u1x8_uart0_dual_ee_ce_u4_hw c64_u1x8_uart0_dual_ee_ce_hw
 * c64_u1x8_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u1x8_uart0_dual_ee_ce_hw[] = {
  0xbbbac1e8a3457c3b, 0xdddd5817da0df9bb, 0xe421aafd9b4ddddd, 0xbc33323bbb299f03, 0xe27eb7fb0ce34f26,
  0x13057792769dc559, 0x5489aa49827c6024, 0x6d2303775f64c8c1, 0x0cee9f12e2061430, 0xce1cb53337ff32ba,
  0xa1f4dea3f60ec2f0, 0x7ef8228524482481, 0xc4fae1f0a21895fe, 0xa4432ace5e99ce41, 0xf09b674542196813,
  0x579096de007fd01c, 0x20d1fe756e60b0de, 0xa1dce6fed100b7b0, 0xf21cecc7e317ea8c, 0xf886c2445d670f3c,
  0x70ece5d1ffd47c25, 0x7f253b58426e9931, 0x47c1b306be7a8f2b, 0x4eb422814c5701bd, 0x426be8c2cb1148b3,
  0x47bd9ceaedc650ea, 0x6abc6c75ea25da21, 0x8b84845022a3e7ac, 0x3608991c37b2fa59, 0xeee2a4a5989fd62a,
  0xfc0c4ad7b27f157c, 0x077ad79e0404e166, 0x53a005bcde6c8a0c, 0x33a2077ca9bd4a72, 0xec555169aba718de,
  0xe52d4bf36dce18ed, 0xbca1854e7ea138c6, 0x8fe32fcc4ffef0f7, 0xbfc0fdfb0cd1f6c3, 0x2c970cf4c2f8d1e8,
  0xccb0e9296ce1c4e3, 0xb4668a29e4afdcd0, 0x00000000000003ae,
};

/*
 * m649_u1x12_uart0_noled_pr         m649a_u1x12_uart0_noled           m649a_u1x12_uart0_noled_pr
 * m649p_u1x12_uart0_noled           m649p_u1x12_uart0_noled_pr        m6490_u1x12_uart0_noled
 * m6490_u1x12_uart0_noled_pr        m6490a_u1x12_uart0_noled          m6490a_u1x12_uart0_noled_pr
 * m6490p_u1x12_uart0_noled          m6490p_u1x12_uart0_noled_pr       m645_u1x12_uart0_noled
 * m645_u1x12_uart0_noled_pr         m645a_u1x12_uart0_noled           m645a_u1x12_uart0_noled_pr
 * m645p_u1x12_uart0_noled           m645p_u1x12_uart0_noled_pr        m6450_u1x12_uart0_noled
 * m6450_u1x12_uart0_noled_pr        m6450a_u1x12_uart0_noled          m6450a_u1x12_uart0_noled_pr
 * m6450p_u1x12_uart0_noled          m6450p_u1x12_uart0_noled_pr
 */
static const uint64_t ur_m649_u1x12_uart0_noled[] = {
  0xeeeda1af0759bb37, 0xdddd55f672b4896e, 0x8e8448aa668cdddd, 0x11e3ec1f77742ca3, 0x793bb63d9085e6c3,
  0x719827c602413057, 0xd3e125f3fdfa1e7e, 0x86d1ba4ff6d4feed, 0x417ea3f4077cb087, 0x299efb5a921c4903,
  0x6afe8f58731602cb, 0xa807fecc11d7a3e7, 0x38f81e59ed8fb33c, 0xce70b37e06256bd8, 0xbcde01f50603bd6b,
  0x815d54e5e5363385, 0xa8b4b0b9c6378ce8, 0xa5f9b6249156f62a, 0x347f1a2c79c37296, 0x9e985727eeacc790,
  0x252d9c389c6592e1, 0x5f3c95fb9a19961d, 0x00000001f2001604,
};

/*
 * m649a_u1x12_uart0_noled_pr_u4     m649p_u1x12_uart0_noled_pr_u4     m6490_u1x12_uart0_noled_pr_u4
 * m6490a_u1x12_uart0_noled_pr_u4    m6490p_u1x12_uart0_noled_pr_u4    m645_u1x12_uart0_noled_pr_u4
 * m645a_u1x12_uart0_noled_pr_u4     m645p_u1x12_uart0_noled_pr_u4     m6450_u1x12_uart0_noled_pr_u4
 * m6450a_u1x12_uart0_noled_pr_u4    m6450p_u1x12_uart0_noled_pr_u4
 */
static const uint64_t ur_m649_u1x12_uart0_noled_pr_u4[] = {
  0x76d0d7834486eff6, 0xeeaafb395a44b777, 0x42245533466eeeee, 0xf1f60fbbba1651c7, 0x775eb98985f4cd88,
  0x304f8c048260aef2, 0xc24be7fd8aecfce3, 0xa3749feda9fddba7, 0xfd47e80ef9610f0d, 0x3df6b52438920682,
  0xfd1eb0e62c059653, 0x0ffd9823af47ced5, 0xf03cb3db1f667950, 0xe166fc0c4ad7b071, 0xbc03ea0c077ad79c,
  0xbaa9cbca6c670b79, 0x6961738c6f19d102, 0xf36c4922adec5551, 0xdc68b224c6e52d4b, 0x0a9cfd4eaccdfc1d,
  0x5f989ffde1ef7943, 0xfbf619a3ed871fc6, 0x19e985f1a3d17f81, 0xd252d9c389c6592e, 0x71f3c95fb9a19961,
  0x00000001f274e4ad,
};

/*
 * m649_u1x12_uart0_noled_pr_ee_u4   m649a_u1x12_uart0_noled_pr_ee     m649a_u1x12_uart0_noled_pr_ee_u4
 * m649p_u1x12_uart0_noled_pr_ee     m649p_u1x12_uart0_noled_pr_ee_u4  m6490_u1x12_uart0_noled_pr_ee
 * m6490_u1x12_uart0_noled_pr_ee_u4  m6490a_u1x12_uart0_noled_pr_ee    m6490a_u1x12_uart0_noled_pr_ee_u4
 * m6490p_u1x12_uart0_noled_pr_ee    m6490p_u1x12_uart0_noled_pr_ee_u4 m645_u1x12_uart0_noled_pr_ee
 * m645_u1x12_uart0_noled_pr_ee_u4   m645a_u1x12_uart0_noled_pr_ee     m645a_u1x12_uart0_noled_pr_ee_u4
 * m645p_u1x12_uart0_noled_pr_ee     m645p_u1x12_uart0_noled_pr_ee_u4  m6450_u1x12_uart0_noled_pr_ee
 * m6450_u1x12_uart0_noled_pr_ee_u4  m6450a_u1x12_uart0_noled_pr_ee    m6450a_u1x12_uart0_noled_pr_ee_u4
 * m6450p_u1x12_uart0_noled_pr_ee    m6450p_u1x12_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m649_u1x12_uart0_noled_pr_ee[] = {
  0xbb686bc1a2431202, 0x77557cd636225bbb, 0x429b2e3b0cf77777, 0x7fa99a0eea451aeb, 0x6d89a2a0a3760cc1,
  0x30120982bbc9dd66, 0xffec5767d82cc13e, 0xfeda9fddba7c2470, 0x355ad1ce30da3749, 0x0d9834c7d4795c89,
  0xd08a1df15f75ea3e, 0xafa30b2c4522cd3a, 0xd5a5e715c6b26909, 0xd79d376ded1e0b39, 0x473c8c38d8d56ba1,
  0xb86f65b2e62e1211, 0x00a89534a8d823f5, 0xe73859bf0312b5ec, 0xde6f00fa8301deb5, 0x40aeaa72f29b19c2,
  0x545a585ce31bc674, 0x52fcdb1248ab7b15, 0x07771a2c8931b94b, 0x50c2a73f53ab337f, 0xf197e627ff787bde,
  0xe07efd8668fb61c7, 0x4b867a617c68f45f, 0x587494b670e27196, 0xb35c7cf257ee6866, 0x0000000000275f2a,
};

/*
 * m649_u1x12_uart0_noled_pr_ce_u4   m649a_u1x12_uart0_noled_pr_ce     m649a_u1x12_uart0_noled_pr_ce_u4
 * m649p_u1x12_uart0_noled_pr_ce     m649p_u1x12_uart0_noled_pr_ce_u4  m6490_u1x12_uart0_noled_pr_ce
 * m6490_u1x12_uart0_noled_pr_ce_u4  m6490a_u1x12_uart0_noled_pr_ce    m6490a_u1x12_uart0_noled_pr_ce_u4
 * m6490p_u1x12_uart0_noled_pr_ce    m6490p_u1x12_uart0_noled_pr_ce_u4 m645_u1x12_uart0_noled_pr_ce
 * m645_u1x12_uart0_noled_pr_ce_u4   m645a_u1x12_uart0_noled_pr_ce     m645a_u1x12_uart0_noled_pr_ce_u4
 * m645p_u1x12_uart0_noled_pr_ce     m645p_u1x12_uart0_noled_pr_ce_u4  m6450_u1x12_uart0_noled_pr_ce
 * m6450_u1x12_uart0_noled_pr_ce_u4  m6450a_u1x12_uart0_noled_pr_ce    m6450a_u1x12_uart0_noled_pr_ce_u4
 * m6450p_u1x12_uart0_noled_pr_ce    m6450p_u1x12_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m649_u1x12_uart0_noled_pr_ce[] = {
  0x76d0d7834486d38b, 0xdd55f85ec9c4b777, 0x385ec47590dddddd, 0x850dbdddd36922b5, 0xeea3329c34ca52d1,
  0x609f180904c15de4, 0x1228bff62bb3ff3a, 0x1ba4ff6d4feedd3e, 0xcee3dc62fd62186d, 0x361222eb3879e3cd,
  0xfff0347ea3e12fc4, 0x4f72ceafac993170, 0x921c4903d67a8e4f, 0x47ac398b0147ce92, 0xff6678ebd1f3b57f,
  0x03cb5b87d99e5403, 0x166fc0c4ad7b071f, 0xc03ea0c077ad79ce, 0xaa9cbca6c670b79b, 0x961738c6f19d102b,
  0x6d89218edec55516, 0x8d164498dca5a97e, 0x539fa9d599bf83bb, 0xf313ffbc3def2861, 0x7ec3347db0e3f8cb,
  0x3d30be347a2ff03f, 0x4a5b387138cb25c3, 0x3e792bf734332c3a, 0x000000375d843fae,
};

/*
 * m649_u1x12_uart0_noled_pr_ee_ce_u4 m649a_u1x12_uart0_noled_pr_ee_ce
 * m649a_u1x12_uart0_noled_pr_ee_ce_u4 m649p_u1x12_uart0_noled_pr_ee_ce
 * m649p_u1x12_uart0_noled_pr_ee_ce_u4 m6490_u1x12_uart0_noled_pr_ee_ce
 * m6490_u1x12_uart0_noled_pr_ee_ce_u4 m6490a_u1x12_uart0_noled_pr_ee_ce
 * m6490a_u1x12_uart0_noled_pr_ee_ce_u4 m6490p_u1x12_uart0_noled_pr_ee_ce
 * m6490p_u1x12_uart0_noled_pr_ee_ce_u4 m645_u1x12_uart0_noled_pr_ee_ce
 * m645_u1x12_uart0_noled_pr_ee_ce_u4 m645a_u1x12_uart0_noled_pr_ee_ce
 * m645a_u1x12_uart0_noled_pr_ee_ce_u4 m645p_u1x12_uart0_noled_pr_ee_ce
 * m645p_u1x12_uart0_noled_pr_ee_ce_u4 m6450_u1x12_uart0_noled_pr_ee_ce
 * m6450_u1x12_uart0_noled_pr_ee_ce_u4 m6450a_u1x12_uart0_noled_pr_ee_ce
 * m6450a_u1x12_uart0_noled_pr_ee_ce_u4 m6450p_u1x12_uart0_noled_pr_ee_ce
 * m6450p_u1x12_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u1x12_uart0_noled_pr_ee_ce[] = {
  0xeda1af06890c1107, 0x75578d0533896eee, 0xb45377b1c7777777, 0xcb2ab4dd85ea6d71, 0xabec4efdf4ee4b42,
  0x02413057793ba9c8, 0xfb15d9f19b9827c6, 0xb6a7f76e9f0905af, 0x7ea8fe74368dd27f, 0x9c3cf1e6e771ca31,
  0x51f097e21b091175, 0xdf3262e1e9299cbf, 0xf51e57d44a76b083, 0x584ff51f06cc1ad7, 0x4522cd3ad08a0531,
  0x4e23a909afa30b2c, 0x6edbda3c1673abb7, 0x30e36355e363af3a, 0x96cb98b848451cf2, 0x2a6951b044c8e1bd,
  0xb37e06256bd859d1, 0x01f50603bd6bce70, 0x54e5e5363385bcde, 0xb0b9c6378ce8815d, 0x6c490c76f62aa8b4,
  0x68b224c6e52d4bf3, 0x9cfd4eaccdfc1ddc, 0x989ffde1ef79430a, 0xf619a3ed871fc65f, 0xe985f1a3d17f81fb,
  0x52d9c389c6592e19, 0xf3c95fb9a19961d2, 0x0000004fc1f82d71,
};

/*
 * m649a_u1x12_uart0_noled_ee_hw     m649p_u1x12_uart0_noled_ee_hw     m6490_u1x12_uart0_noled_ee_hw
 * m6490a_u1x12_uart0_noled_ee_hw    m6490p_u1x12_uart0_noled_ee_hw    m645_u1x12_uart0_noled_ee_hw
 * m645a_u1x12_uart0_noled_ee_hw     m645p_u1x12_uart0_noled_ee_hw     m6450_u1x12_uart0_noled_ee_hw
 * m6450a_u1x12_uart0_noled_ee_hw    m6450p_u1x12_uart0_noled_ee_hw    c64_u1x12_uart0_noled_ee_hw
 */
static const uint64_t ur_m649_u1x12_uart0_noled_ee_hw[] = {
  0xdb435e0d1468d38b, 0xbaabe6b1b112dddd, 0x14d971d867bbbbbb, 0xfd4cd0775228d75a, 0x6653b4a51bb0660b,
  0xe30120982bbc9dd4, 0xc3ffeb267d82cc13, 0x27fb6a7f76e9f091, 0x24d56b4738c368dd, 0xf83660d31f51e572,
  0xeb422877c57dd7a8, 0x26be8c2cb1148b34, 0xe756979c571ac9a4, 0x875e74ddb7b4782c, 0x451cf230e36355ae,
  0xd6e1bd96cb98b848, 0xb002a254d2a3608f, 0xd79ce166fc0c4ad7, 0x0b79bc03ea0c077a, 0xd102baa9cbca6c67,
  0x55516961738c6f19, 0x2d4bf36c4922adec, 0xa1854e7ea138c6e5, 0xe32fcc4ffef0f7bc, 0xc0fdfb0cd1f6c38f,
  0x970cf4c2f8d1e8bf, 0xb0e9296ce1c4e32c, 0x22fa29e4afdcd0cc, 0x000000000000b7e8,
};

/*
 * m649_u1x12_uart0_noled_ee_ce_u4_hw m649a_u1x12_uart0_noled_ee_ce_hw
 * m649a_u1x12_uart0_noled_ee_ce_u4_hw m649p_u1x12_uart0_noled_ee_ce_hw
 * m649p_u1x12_uart0_noled_ee_ce_u4_hw m6490_u1x12_uart0_noled_ee_ce_hw
 * m6490_u1x12_uart0_noled_ee_ce_u4_hw m6490a_u1x12_uart0_noled_ee_ce_hw
 * m6490a_u1x12_uart0_noled_ee_ce_u4_hw m6490p_u1x12_uart0_noled_ee_ce_hw
 * m6490p_u1x12_uart0_noled_ee_ce_u4_hw m645_u1x12_uart0_noled_ee_ce_hw
 * m645_u1x12_uart0_noled_ee_ce_u4_hw m645a_u1x12_uart0_noled_ee_ce_hw
 * m645a_u1x12_uart0_noled_ee_ce_u4_hw m645p_u1x12_uart0_noled_ee_ce_hw
 * m645p_u1x12_uart0_noled_ee_ce_u4_hw m6450_u1x12_uart0_noled_ee_ce_hw
 * m6450_u1x12_uart0_noled_ee_ce_u4_hw m6450a_u1x12_uart0_noled_ee_ce_hw
 * m6450a_u1x12_uart0_noled_ee_ce_u4_hw m6450p_u1x12_uart0_noled_ee_ce_hw
 * m6450p_u1x12_uart0_noled_ee_ce_u4_hw c64_u1x12_uart0_noled_ee_ce_hw
 * c64_u1x12_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u1x12_uart0_noled_ee_ce_hw[] = {
  0xbb686bc1a28d12a8, 0xdd55e3414ce25bbb, 0x6d14ddec71dddddd, 0xb2caad37617a9b5c, 0xeb46ad67dd3b92d0,
  0xf8c048260aef2774, 0x2d7ff5933e337304, 0x93fdb53fbb74f848, 0x518bf547f3a1b46e, 0x1759c3cf3c873b8e,
  0x7ff51f097e21b091, 0x107be64c5c3f2d33, 0x5afea3cafa894ed6, 0xa62b09fea3e0d983, 0x6588a459a75a1140,
  0x76e9c4752135f461, 0xe74ddb7b4782ce75, 0x9e461c6c6abc6c75, 0x37b2d973170908a3, 0x3a254d2a3608991c,
  0xce166fc0c4ad7b0b, 0x9bc03ea0c077ad79, 0x2baa9cbca6c670b7, 0x16961738c6f19d10, 0x7e6d89218edec555,
  0xa9cfd42718dca5a9, 0xf989ffde1ef79430, 0xbf619a3ed871fc65, 0x9e985f1a3d17f81f, 0x252d9c389c6592e1,
  0x453c95fb9a19961d, 0x0000000050126001,
};

/*
 * m649_u1x12_uart0_lednop_pr        m649a_u1x12_uart0_lednop          m649a_u1x12_uart0_lednop_pr
 * m649p_u1x12_uart0_lednop          m649p_u1x12_uart0_lednop_pr       m6490_u1x12_uart0_lednop
 * m6490_u1x12_uart0_lednop_pr       m6490a_u1x12_uart0_lednop         m6490a_u1x12_uart0_lednop_pr
 * m6490p_u1x12_uart0_lednop         m6490p_u1x12_uart0_lednop_pr      m645_u1x12_uart0_lednop
 * m645_u1x12_uart0_lednop_pr        m645a_u1x12_uart0_lednop          m645a_u1x12_uart0_lednop_pr
 * m645p_u1x12_uart0_lednop          m645p_u1x12_uart0_lednop_pr       m6450_u1x12_uart0_lednop
 * m6450_u1x12_uart0_lednop_pr       m6450a_u1x12_uart0_lednop         m6450a_u1x12_uart0_lednop_pr
 * m6450p_u1x12_uart0_lednop         m6450p_u1x12_uart0_lednop_pr
 */
static const uint64_t ur_m649_u1x12_uart0_lednop[] = {
  0x776d0d783acdfc4f, 0xddd55f670bdc4b77, 0x9fbbf0feb11ddddd, 0xd697e6eeec88444d, 0x9dd85eb478f4138f,
  0x4c13e30120982bbc, 0xf097c9fefd0f3e0a, 0x68dd27fb6a7f76e9, 0x4f51c9e3be5921c3, 0xc3e749490e24819a,
  0xf23905398b016f74, 0x71cb1823af173b35, 0xdf81895af61583ef, 0x80ef5af3c0809c2c, 0x4a7400b79bcd9141,
  0xc67440ef9537a94e, 0xbd8aaa2d3574e31b, 0x6e52d4bf36dce455, 0x98f2068fe3458f38, 0xb25c33d30ae4fdd5,
  0x32c3a4a5b387138c, 0x72c08be792bf7343, 0x000000000001f200,
};

/*
 * m649a_u1x12_uart0_lednop_pr_u4    m649p_u1x12_uart0_lednop_pr_u4    m6490_u1x12_uart0_lednop_pr_u4
 * m6490a_u1x12_uart0_lednop_pr_u4   m6490p_u1x12_uart0_lednop_pr_u4   m645_u1x12_uart0_lednop_pr_u4
 * m645a_u1x12_uart0_lednop_pr_u4    m645p_u1x12_uart0_lednop_pr_u4    m6450_u1x12_uart0_lednop_pr_u4
 * m6450a_u1x12_uart0_lednop_pr_u4   m6450p_u1x12_uart0_lednop_pr_u4
 */
static const uint64_t ur_m649_u1x12_uart0_lednop_pr_u4[] = {
  0xeeda1af06890c743, 0xbbaabece3af896ee, 0xb4a12fcd1b7bbbbb, 0xf4a64f77742ca38e, 0xeed45e4ad4d60933,
  0x609f180904c15de4, 0x094beffb15d9f3d6, 0x8dd27fb6a7f76e9f, 0xf51ed63be5843c36, 0xe483f490e2481a0b,
  0xa3486731602cb29b, 0xffb30475e8f9d967, 0x07967b682cd22a01, 0x2cdf81895af6415a, 0x4180ef5af3c0809c,
  0x4e4a7400b79bcd91, 0x1bc67440ef9537a9, 0x55bd8aaa2d3574e3, 0x4c6e52d4bf36dce4, 0xeaccdfc1ddc68b22,
  0xde1ef79430a9cfd4, 0x3ed871fc65f989ff, 0x1a3d17f81fbf619a, 0x389c6592e19e985f, 0xfb9a19961d252d9c,
  0x1f26c793d71f3c95,
};

/*
 * m649_u1x12_uart0_lednop_pr_ee_u4  m649a_u1x12_uart0_lednop_pr_ee    m649a_u1x12_uart0_lednop_pr_ee_u4
 * m649p_u1x12_uart0_lednop_pr_ee    m649p_u1x12_uart0_lednop_pr_ee_u4 m6490_u1x12_uart0_lednop_pr_ee
 * m6490_u1x12_uart0_lednop_pr_ee_u4 m6490a_u1x12_uart0_lednop_pr_ee
 * m6490a_u1x12_uart0_lednop_pr_ee_u4 m6490p_u1x12_uart0_lednop_pr_ee
 * m6490p_u1x12_uart0_lednop_pr_ee_u4 m645_u1x12_uart0_lednop_pr_ee
 * m645_u1x12_uart0_lednop_pr_ee_u4  m645a_u1x12_uart0_lednop_pr_ee    m645a_u1x12_uart0_lednop_pr_ee_u4
 * m645p_u1x12_uart0_lednop_pr_ee    m645p_u1x12_uart0_lednop_pr_ee_u4 m6450_u1x12_uart0_lednop_pr_ee
 * m6450_u1x12_uart0_lednop_pr_ee_u4 m6450a_u1x12_uart0_lednop_pr_ee
 * m6450a_u1x12_uart0_lednop_pr_ee_u4 m6450p_u1x12_uart0_lednop_pr_ee
 * m6450p_u1x12_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m649_u1x12_uart0_lednop_pr_ee[] = {
  0xddb435e0d12198e2, 0x77557cd6c5f12ddd, 0xb0b4663b42f77777, 0x77ea6683ba9146b9, 0x70f65c6759a59fbc,
  0x8c048260aef2774a, 0x3ffb15d9fcad304f, 0x7fb6a7f76e9f0914, 0x4d56b4738c368dd2, 0x83660d31f51e5665,
  0x68450ef8ac3dfa8f, 0xd7d185962291669d, 0xead2e7aae3593484, 0x75e74dda32464d1c, 0x504f237b56355ae8,
  0x6e1bd96cb98b8484, 0x0043eccf2a3608fd, 0x809c2cdf81895af6, 0xcd914180ef5af3c0, 0x37a94e4a7400b79b,
  0x74e31bc67440ef95, 0xdce455bd8aaa2d35, 0x8b224c6e52d4bf36, 0xcfd4eaccdfc1ddc6, 0x89ffde1ef79430a9,
  0x619a3ed871fc65f9, 0x985f1a3d17f81fbf, 0x2d9c389c6592e19e, 0x3c95fb9a19961d25, 0x000009d73072d71f,
};

/*
 * m649_u1x12_uart0_lednop_pr_ce_u4  m649a_u1x12_uart0_lednop_pr_ce    m649a_u1x12_uart0_lednop_pr_ce_u4
 * m649p_u1x12_uart0_lednop_pr_ce    m649p_u1x12_uart0_lednop_pr_ce_u4 m6490_u1x12_uart0_lednop_pr_ce
 * m6490_u1x12_uart0_lednop_pr_ce_u4 m6490a_u1x12_uart0_lednop_pr_ce
 * m6490a_u1x12_uart0_lednop_pr_ce_u4 m6490p_u1x12_uart0_lednop_pr_ce
 * m6490p_u1x12_uart0_lednop_pr_ce_u4 m645_u1x12_uart0_lednop_pr_ce
 * m645_u1x12_uart0_lednop_pr_ce_u4  m645a_u1x12_uart0_lednop_pr_ce    m645a_u1x12_uart0_lednop_pr_ce_u4
 * m645p_u1x12_uart0_lednop_pr_ce    m645p_u1x12_uart0_lednop_pr_ce_u4 m6450_u1x12_uart0_lednop_pr_ce
 * m6450_u1x12_uart0_lednop_pr_ce_u4 m6450a_u1x12_uart0_lednop_pr_ce
 * m6450a_u1x12_uart0_lednop_pr_ce_u4 m6450p_u1x12_uart0_lednop_pr_ce
 * m6450p_u1x12_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m649_u1x12_uart0_lednop_pr_ce[] = {
  0xbb686bc1a243280b, 0x77557e1724225bbb, 0x9b53267a0cf77777, 0x412a1eeee9b4916c, 0x777273d6a0ad38d8,
  0x304f8c048260aef2, 0x09256ffb15d9f387, 0x8dd27fb6a7f76e9f, 0xe7701a317eb10c36, 0x1b0911759c3cf1e6,
  0xd36e76ff51f097e2, 0x9ee59d5f593262e1, 0x24389207acf51fa4, 0x3486731602a6222d, 0xfb33c75e8f9d967a,
  0x1e5adc82cd22a01f, 0xb37e06256bd90568, 0x0603bd6bcf020270, 0x3929d002de6f3645, 0x6f19d103be54dea5,
  0x76f62aa8b4d5d38c, 0x637296a5f9b6e70c, 0x5666fe0eee345912, 0xf0f7bca1854e7ea7, 0xf6c38fe32fcc4ffe,
  0xd1e8bfc0fdfb0cd1, 0xc4e32c970cf4c2f8, 0xdcd0ccb0e9296ce1, 0x6ebde49eb8f9e4af,
};

/*
 * m649_u1x12_uart0_lednop_pr_ee_ce_u4 m649a_u1x12_uart0_lednop_pr_ee_ce
 * m649a_u1x12_uart0_lednop_pr_ee_ce_u4 m649p_u1x12_uart0_lednop_pr_ee_ce
 * m649p_u1x12_uart0_lednop_pr_ee_ce_u4 m6490_u1x12_uart0_lednop_pr_ee_ce
 * m6490_u1x12_uart0_lednop_pr_ee_ce_u4 m6490a_u1x12_uart0_lednop_pr_ee_ce
 * m6490a_u1x12_uart0_lednop_pr_ee_ce_u4 m6490p_u1x12_uart0_lednop_pr_ee_ce
 * m6490p_u1x12_uart0_lednop_pr_ee_ce_u4 m645_u1x12_uart0_lednop_pr_ee_ce
 * m645_u1x12_uart0_lednop_pr_ee_ce_u4 m645a_u1x12_uart0_lednop_pr_ee_ce
 * m645a_u1x12_uart0_lednop_pr_ee_ce_u4 m645p_u1x12_uart0_lednop_pr_ee_ce
 * m645p_u1x12_uart0_lednop_pr_ee_ce_u4 m6450_u1x12_uart0_lednop_pr_ee_ce
 * m6450_u1x12_uart0_lednop_pr_ee_ce_u4 m6450a_u1x12_uart0_lednop_pr_ee_ce
 * m6450a_u1x12_uart0_lednop_pr_ee_ce_u4 m6450p_u1x12_uart0_lednop_pr_ee_ce
 * m6450p_u1x12_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u1x12_uart0_lednop_pr_ee_ce[] = {
  0x76d0d78344867f3e, 0xbaabc68160c4b777, 0xd71b4bdb83bbbbbb, 0x05955a6ec2f5374c, 0xa2f0dceb62465d84,
  0x80904c15de4eec6a, 0xff62bb3e1a2609f1, 0xeda9fddba7c2563f, 0x5faa3f9d0da3749f, 0x670f3c79b9d93a8c,
  0xd47c25f886c2445d, 0xef993170f950d07f, 0xfa8f2beea53b5841, 0xaf6ffa8f83660d6b, 0x2291669d68450298,
  0x8f51d484d7d18596, 0x9bb4648c9a39d5db, 0x8ded58d578d8ebce, 0x65b2e62e1211413c, 0xd99e546c1132386f,
  0x59bf0312b5ec2cc7, 0x8301deb5e7810138, 0x9c94e8016f379b22, 0x378ce881df2a6f52, 0x3b7b15545a6ae9c6,
  0x31b94b52fcdb7386, 0xab337f07771a2c89, 0x787bde50c2a73f53, 0xfb61c7f197e627ff, 0x68f45fe07efd8668,
  0xe271964b867a617c, 0xee6866587494b670, 0x09f896d35c7cf257,
};

/*
 * m649a_u1x12_uart0_lednop_ee_hw    m649p_u1x12_uart0_lednop_ee_hw    m6490_u1x12_uart0_lednop_ee_hw
 * m6490a_u1x12_uart0_lednop_ee_hw   m6490p_u1x12_uart0_lednop_ee_hw   m645_u1x12_uart0_lednop_ee_hw
 * m645a_u1x12_uart0_lednop_ee_hw    m645p_u1x12_uart0_lednop_ee_hw    m6450_u1x12_uart0_lednop_ee_hw
 * m6450a_u1x12_uart0_lednop_ee_hw   m6450p_u1x12_uart0_lednop_ee_hw   c64_u1x12_uart0_lednop_ee_hw
 */
static const uint64_t ur_m649_u1x12_uart0_lednop_ee_hw[] = {
  0xeda1af068a34280b, 0xbaabe6b62f896eee, 0x85a331da17bbbbbb, 0xbf53341dd48a35cd, 0x273d6d69cd2cfde3,
  0xf8c048260aef2777, 0x50fffac99fcad304, 0x49feda9fddba7c24, 0x95355ad1ce30da37, 0x3e0d9834c7d47959,
  0x75a1143be2b0f7ea, 0x135f4616588a459a, 0x73ab4b9eab8d64d2, 0xa1d79d3768c91934, 0x11413c8ded58d56b,
  0xf5b86f65b2e62e12, 0xd8010fb33ca8d823, 0x020270b37e06256b, 0x6f36450603bd6bcf, 0x54dea53929d002de,
  0xd5d38c6f19d103be, 0xdb739156f62aa8b4, 0x9fa84e31b94b52fc, 0x13ffbc3def286153, 0xc3347db0e3f8cbf3,
  0x30be347a2ff03f7e, 0x5b387138cb25c33d, 0x792bf734332c3a4a, 0x0000002df608be8a,
};

/*
 * m649_u1x12_uart0_lednop_ee_ce_u4_hw m649a_u1x12_uart0_lednop_ee_ce_hw
 * m649a_u1x12_uart0_lednop_ee_ce_u4_hw m649p_u1x12_uart0_lednop_ee_ce_hw
 * m649p_u1x12_uart0_lednop_ee_ce_u4_hw m6490_u1x12_uart0_lednop_ee_ce_hw
 * m6490_u1x12_uart0_lednop_ee_ce_u4_hw m6490a_u1x12_uart0_lednop_ee_ce_hw
 * m6490a_u1x12_uart0_lednop_ee_ce_u4_hw m6490p_u1x12_uart0_lednop_ee_ce_hw
 * m6490p_u1x12_uart0_lednop_ee_ce_u4_hw m645_u1x12_uart0_lednop_ee_ce_hw
 * m645_u1x12_uart0_lednop_ee_ce_u4_hw m645a_u1x12_uart0_lednop_ee_ce_hw
 * m645a_u1x12_uart0_lednop_ee_ce_u4_hw m645p_u1x12_uart0_lednop_ee_ce_hw
 * m645p_u1x12_uart0_lednop_ee_ce_u4_hw m6450_u1x12_uart0_lednop_ee_ce_hw
 * m6450_u1x12_uart0_lednop_ee_ce_u4_hw m6450a_u1x12_uart0_lednop_ee_ce_hw
 * m6450a_u1x12_uart0_lednop_ee_ce_u4_hw m6450p_u1x12_uart0_lednop_ee_ce_hw
 * m6450p_u1x12_uart0_lednop_ee_ce_u4_hw c64_u1x12_uart0_lednop_ee_ce_hw
 * c64_u1x12_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u1x12_uart0_lednop_ee_ce_hw[] = {
  0xdb435e0d146824d6, 0xeaaf1a058312dddd, 0x5c6d2f6e0eeeeeee, 0x165569bb0bd4dd33, 0xd75dea7d89197610,
  0x8c048260aef2777e, 0x7fffac99f0d1304f, 0x3fdb53fbb74f84ac, 0x18bf547f3a1b46e9, 0x759c3cf3c873b275,
  0xff51f097e21b0911, 0x83df3262e1facd90, 0xd7f51e57dd4a76b0, 0x315edff51f06cc1a, 0x2c4522cd3ad08a05,
  0xb71ea3a909afa30b, 0x9d3768c9193473ab, 0x791bdab1aaf1b1d7, 0xdecb65cc5c242282, 0x8fb33ca8d8226470,
  0x70b37e06256bd859, 0x450603bd6bcf0202, 0xa53929d002de6f36, 0x8c6f19d103be54de, 0x0c76f62aa8b4d5d3,
  0x9c637296a5f9b6e7, 0x787bde50c2a73f50, 0xfb61c7f197e627ff, 0x68f45fe07efd8668, 0xe271964b867a617c,
  0xee6866587494b670, 0x00a021c5f514f257,
};

/*
 * m649_u1x12_uart0_dual_pr          m649_u1x12_uart0_dual_pr_u4       m649a_u1x12_uart0_dual
 * m649a_u1x12_uart0_dual_pr         m649a_u1x12_uart0_dual_pr_u4      m649p_u1x12_uart0_dual
 * m649p_u1x12_uart0_dual_pr         m649p_u1x12_uart0_dual_pr_u4      m6490_u1x12_uart0_dual
 * m6490_u1x12_uart0_dual_pr         m6490_u1x12_uart0_dual_pr_u4      m6490a_u1x12_uart0_dual
 * m6490a_u1x12_uart0_dual_pr        m6490a_u1x12_uart0_dual_pr_u4     m6490p_u1x12_uart0_dual
 * m6490p_u1x12_uart0_dual_pr        m6490p_u1x12_uart0_dual_pr_u4     m645_u1x12_uart0_dual
 * m645_u1x12_uart0_dual_pr          m645_u1x12_uart0_dual_pr_u4       m645a_u1x12_uart0_dual
 * m645a_u1x12_uart0_dual_pr         m645a_u1x12_uart0_dual_pr_u4      m645p_u1x12_uart0_dual
 * m645p_u1x12_uart0_dual_pr         m645p_u1x12_uart0_dual_pr_u4      m6450_u1x12_uart0_dual
 * m6450_u1x12_uart0_dual_pr         m6450_u1x12_uart0_dual_pr_u4      m6450a_u1x12_uart0_dual
 * m6450a_u1x12_uart0_dual_pr        m6450a_u1x12_uart0_dual_pr_u4     m6450p_u1x12_uart0_dual
 * m6450p_u1x12_uart0_dual_pr        m6450p_u1x12_uart0_dual_pr_u4
 */
static const uint64_t ur_m649_u1x12_uart0_dual[] = {
  0x77783eefa24343ee, 0xdddd586dd86bf377, 0x646ea0de9d6ddddd, 0x6c593b77768591f7, 0xbabbf224b534f1da,
  0x8c048260aef2717b, 0xc99182a90951304f, 0x0c2860da4606eebe, 0xfe650129dd3e25c4, 0x93d87ce3848798ba,
  0x2241240d7dcdea3b, 0x10c4aff3f7c11429, 0xbd33863e27d70f85, 0x4219687c8886559c, 0x01bfe80e784c3e45,
  0x4930586f2bc84b6f, 0xfeedd3e1209fffd5, 0x589a86d1ba4ff6d4, 0x490310fea3e453be, 0x055079a717be921c,
  0x019dad6475fce62c, 0xa435403ff6608ebc, 0x52552740f2cf6c43, 0x256bd93f8abe7771, 0x6bcf020270b37e06,
  0x02de6f36450603bd, 0x03be54dea53929d0, 0xa8b4d5d38c6f19d1, 0x52fcdb739156f62a, 0x07771a2c8931b94b,
  0x50c2a73f53ab337f, 0xf197e627ff787bde, 0xe07efd8668fb61c7, 0x4b867a617c68f45f, 0x587494b670e27196,
  0x0b5c7cf257ee6866, 0x0000000000524e7e,
};

/*
 * m649_u1x12_uart0_dual_pr_ee_u4    m649a_u1x12_uart0_dual_pr_ee      m649a_u1x12_uart0_dual_pr_ee_u4
 * m649p_u1x12_uart0_dual_pr_ee      m649p_u1x12_uart0_dual_pr_ee_u4   m6490_u1x12_uart0_dual_pr_ee
 * m6490_u1x12_uart0_dual_pr_ee_u4   m6490a_u1x12_uart0_dual_pr_ee     m6490a_u1x12_uart0_dual_pr_ee_u4
 * m6490p_u1x12_uart0_dual_pr_ee     m6490p_u1x12_uart0_dual_pr_ee_u4  m645_u1x12_uart0_dual_pr_ee
 * m645_u1x12_uart0_dual_pr_ee_u4    m645a_u1x12_uart0_dual_pr_ee      m645a_u1x12_uart0_dual_pr_ee_u4
 * m645p_u1x12_uart0_dual_pr_ee      m645p_u1x12_uart0_dual_pr_ee_u4   m6450_u1x12_uart0_dual_pr_ee
 * m6450_u1x12_uart0_dual_pr_ee_u4   m6450a_u1x12_uart0_dual_pr_ee     m6450a_u1x12_uart0_dual_pr_ee_u4
 * m6450p_u1x12_uart0_dual_pr_ee     m6450p_u1x12_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m649_u1x12_uart0_dual_pr_ee[] = {
  0x77783eefa243359b, 0xbbbbab1215abf377, 0x3af9f693342dbbbb, 0x8d5e3c8feec0b7ac, 0x6614c3e6baa01aaf,
  0x8260aef2519bb878, 0x055202c9304f8c04, 0xc1b48c0ddd7d9323, 0x0253ba7c4b881850, 0xcd9c376a64dbfcca,
  0x81a5a9bd4731fd80, 0xfe7ef82285244824, 0x90c4fae1f0a21895, 0x0e9510cab397a671, 0x073c2628b150865a,
  0x6f2bc84b6fd5fff4, 0xe12df7ffd5493058, 0xd1ba4ff6d4feedd3, 0x95afb9aad68e4486, 0x5ea3e0d983053d47,
  0x59a75a1143be2ba9, 0xcd2135f4616588a4, 0xbd9cead2e652e2a5, 0x5ae875ea25da2147, 0xc242281151f3d635,
  0x08fd6e1bd97d2cc5, 0xe2a4a0109fd62a36, 0x0c4ad7b27f157cee, 0x7ad79e0404e166fc, 0xa005bcde6c8a0c07,
  0xa2077ca9bd4a7253, 0x555169aba718de33, 0x96a5f9b6e722adec, 0xfe0eee3459126372, 0xbca1854e7ea75666,
  0x8fe32fcc4ffef0f7, 0xbfc0fdfb0cd1f6c3, 0x2c970cf4c2f8d1e8, 0xccb0e9296ce1c4e3, 0x085eb8f9e4afdcd0,
  0x0000000000000564,
};

/*
 * m649_u1x12_uart0_dual_pr_ce_u4    m649a_u1x12_uart0_dual_pr_ce      m649a_u1x12_uart0_dual_pr_ce_u4
 * m649p_u1x12_uart0_dual_pr_ce      m649p_u1x12_uart0_dual_pr_ce_u4   m6490_u1x12_uart0_dual_pr_ce
 * m6490_u1x12_uart0_dual_pr_ce_u4   m6490a_u1x12_uart0_dual_pr_ce     m6490a_u1x12_uart0_dual_pr_ce_u4
 * m6490p_u1x12_uart0_dual_pr_ce     m6490p_u1x12_uart0_dual_pr_ce_u4  m645_u1x12_uart0_dual_pr_ce
 * m645_u1x12_uart0_dual_pr_ce_u4    m645a_u1x12_uart0_dual_pr_ce      m645a_u1x12_uart0_dual_pr_ce_u4
 * m645p_u1x12_uart0_dual_pr_ce      m645p_u1x12_uart0_dual_pr_ce_u4   m6450_u1x12_uart0_dual_pr_ce
 * m6450_u1x12_uart0_dual_pr_ce_u4   m6450a_u1x12_uart0_dual_pr_ce     m6450a_u1x12_uart0_dual_pr_ce_u4
 * m6450p_u1x12_uart0_dual_pr_ce     m6450p_u1x12_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m649_u1x12_uart0_dual_pr_ce[] = {
  0xeef07ddf448687e1, 0x77756b1f62f7e6ee, 0x22d476b5d6f77777, 0xaffb5bbbb7060596, 0x2bdbc1776d1f1d72,
  0x0120982bbc9582ee, 0x9182a90148cc13e3, 0x2860da4606eebec9, 0x650129dd3e25c40c, 0xc3abce143f374ffe,
  0x09207b3a6f51ce0e, 0x257f9fbe08a14912, 0x9cbc313eb87c2886, 0x9682fb4432ace5e9, 0xfd01cf0983dc5421,
  0x0b0de579096df4df, 0xba7c2452fffaa926, 0xd0da3749feda9fdd, 0x8f373b4ad18bf597, 0xbf10d8488bace1e7,
  0x8b87adf801fa8f84, 0x8df9ee59d5ea5cc9, 0xf2921c4903a97ea3, 0x591d7f398b014141, 0x0ffd99e3af00676b,
  0x740f2d6e10e90d50, 0x93f8abe777152552, 0x20270b37e06256bd, 0xf36450603bd6bcf0, 0x4dea53929d002de6,
  0x5d38c6f19d103be5, 0x6e70c76f62aa8b4d, 0x45912637296a5f9b, 0xe7ea75666fe0eee3, 0xc4ffef0f7bca1854,
  0xb0cd1f6c38fe32fc, 0x4c2f8d1e8bfc0fdf, 0x96ce1c4e32c970cf, 0x9e4afdcd0ccb0e92, 0x000003491e6deb8f,
};

/*
 * m649a_u1x12_uart0_dual_pr_ee_ce   m649p_u1x12_uart0_dual_pr_ee_ce   m6490_u1x12_uart0_dual_pr_ee_ce
 * m6490a_u1x12_uart0_dual_pr_ee_ce  m6490p_u1x12_uart0_dual_pr_ee_ce  m645_u1x12_uart0_dual_pr_ee_ce
 * m645a_u1x12_uart0_dual_pr_ee_ce   m645p_u1x12_uart0_dual_pr_ee_ce   m6450_u1x12_uart0_dual_pr_ee_ce
 * m6450a_u1x12_uart0_dual_pr_ee_ce  m6450p_u1x12_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m649_u1x12_uart0_dual_pr_ee_ce[] = {
  0x77783eefd41432db, 0xdddd586de4cbf377, 0x710b157efb8ddddd, 0xd6990123ba82b655, 0x04559c7f33a07c4d,
  0x2413057792ec9dc7, 0x305523b8f9827c60, 0x0c1b48c0ddd7d932, 0xa0253ba7c4b88185, 0x1000e02926fd7fcc,
  0x240e76e6f51eb7f6, 0xaff3f7c114292241, 0x152227d70f8510c4, 0xa16e910cab397a67, 0x4073c2653d150865,
  0xc3795e425b7d35ff, 0x9f0905affeaa4982, 0x368dd27fb6a7f76e, 0xdcee3958fea8ff74, 0xceb0f722495f9e3c,
  0x2b7f253b58166e99, 0xbd47c1b306be7a8f, 0xb34eb422814c5701, 0xea426be8c2cb1148, 0x2147bd9ceaedc650,
  0xac6abc6c75ea25da, 0x598b84845022a3e7, 0x2a3608991c37b2fa, 0x7ceee2a4a5989fd6, 0x66fc0c4ad7b27f15,
  0x0c077ad79e0404e1, 0x7253a005bcde6c8a, 0xde33a2077ca9bd4a, 0xedec555169aba718, 0xc6e52d4bf36dce18,
  0xccdfc1ddc68b03d0, 0x89c69430a9cfd4ea, 0x30ae4fc07cd1f6c3, 0x5b387138cb25c33d, 0x792bf734332c3a4a,
  0x000002000e7dae3e,
};

/*
 * m649a_u1x12_uart0_dual_pr_ee_ce_u4 m649p_u1x12_uart0_dual_pr_ee_ce_u4
 * m6490_u1x12_uart0_dual_pr_ee_ce_u4 m6490a_u1x12_uart0_dual_pr_ee_ce_u4
 * m6490p_u1x12_uart0_dual_pr_ee_ce_u4 m645_u1x12_uart0_dual_pr_ee_ce_u4
 * m645a_u1x12_uart0_dual_pr_ee_ce_u4 m645p_u1x12_uart0_dual_pr_ee_ce_u4
 * m6450_u1x12_uart0_dual_pr_ee_ce_u4 m6450a_u1x12_uart0_dual_pr_ee_ce_u4
 * m6450p_u1x12_uart0_dual_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u1x12_uart0_dual_pr_ee_ce_u4[] = {
  0xbc1f77d150ff9231, 0xdd59a9b4f5f9bbbb, 0x3e403bc7fddddddd, 0xa702f74e775dfb8c, 0xf876b54da0ce5711,
  0xf24eb3bbff8669d3, 0x2f304f8c048260ae, 0x3775f64c8c15484f, 0xf12e20614306d230, 0xf32547e656024ee9,
  0xd47bc3d872d1c19b, 0x50a48904903c6e9b, 0x3e144312bfcfdf04, 0x59cbd338aeb89f5c, 0x28a8432d04b48865,
  0xdb8a4ffa039e1347, 0x190bcc161bcaf212, 0xa9fddba7c25a6bff, 0xaa32870da3749fed, 0x79e7c033b31f8c5f,
  0xe12fc4361222eb38, 0x93170e601ba1fea3, 0xf2b7f253b58426e9, 0x1bd47c1b306be7a8, 0x8b34eb422814c570,
  0x0ea426be8c2cb114, 0xa2147bd9ceaedc65, 0x7ac6abc6c75ea25d, 0xa598b84845022a3e, 0x62a3608991c37b2f,
  0x57ceee2a4a5989fd, 0x166fc0c4ad7b27f1, 0xa0c077ad79e0404e, 0xa7253a005bcde6c8, 0x8de33a2077ca9bd4,
  0x8edec555169aba71, 0x4c6e52d4bf36dce1, 0x5666fe0d1fc68b22, 0xf0f7bca1854e7ea7, 0xf6c38fe32fcc4ffe,
  0xd1e8bfc0fdfb0cd1, 0xc4e32c970cf4c2f8, 0xdcd0ccb0e9296ce1, 0x400469f22029e4af,
};

/*
 * m649a_u1x12_uart0_dual_ee_hw      m649p_u1x12_uart0_dual_ee_hw      m6490_u1x12_uart0_dual_ee_hw
 * m6490a_u1x12_uart0_dual_ee_hw     m6490p_u1x12_uart0_dual_ee_hw     m645_u1x12_uart0_dual_ee_hw
 * m645a_u1x12_uart0_dual_ee_hw      m645p_u1x12_uart0_dual_ee_hw      m6450_u1x12_uart0_dual_ee_hw
 * m6450a_u1x12_uart0_dual_ee_hw     m6450p_u1x12_uart0_dual_ee_hw     c64_u1x12_uart0_dual_ee_hw
 */
static const uint64_t ur_m649_u1x12_uart0_dual_ee_hw[] = {
  0xbbc1f77d146887e1, 0xdddd5890ad5f9bbb, 0xd7cfb499a16ddddd, 0x6af1e47f7605bd61, 0xbdbc16b47d00d57c,
  0x120982bbc9466ee2, 0x8c15480b24c13e30, 0x4306d2303775f64c, 0x2ba0cee9f12e2061, 0x033670dda9936ff3,
  0x920696a6f51cc7f6, 0x57f9fbe08a149120, 0xc64313eb87c28862, 0x683a54432ace5e99, 0xd01cf098a2c54219,
  0x61bcaf212dbf57ff, 0xa7c25beffceadcc1, 0x0da3749feda9fddb, 0x8f2b5f7355ad1c89, 0x52bd47c1b3060a7a,
  0x48b34eb422877c57, 0x4b9a426be8c2cb11, 0x8f7b39d5a5cca5c5, 0x6ab5d0ebd44bb442, 0x8b84845022a3e7ac,
  0x6c11fadc37b2fa59, 0xddc54940213fac54, 0xf81895af64fe2af9, 0x0ef5af3c0809c2cd, 0xa7400b79bcd91418,
  0x67440ef9537a94e4, 0xd8aaa2d3574e31bc, 0xe52d4bf36dce455b, 0xbca1854e7ea138c6, 0x8fe32fcc4ffef0f7,
  0xbfc0fdfb0cd1f6c3, 0x2c970cf4c2f8d1e8, 0xccb0e9296ce1c4e3, 0x0880ba29e4afdcd0, 0x0000000000000aed,
};

/*
 * m649_u1x12_uart0_dual_ee_ce_u4_hw m649a_u1x12_uart0_dual_ee_ce_hw   m649a_u1x12_uart0_dual_ee_ce_u4_hw
 * m649p_u1x12_uart0_dual_ee_ce_hw   m649p_u1x12_uart0_dual_ee_ce_u4_hw
 * m6490_u1x12_uart0_dual_ee_ce_hw   m6490_u1x12_uart0_dual_ee_ce_u4_hw
 * m6490a_u1x12_uart0_dual_ee_ce_hw  m6490a_u1x12_uart0_dual_ee_ce_u4_hw
 * m6490p_u1x12_uart0_dual_ee_ce_hw  m6490p_u1x12_uart0_dual_ee_ce_u4_hw
 * m645_u1x12_uart0_dual_ee_ce_hw    m645_u1x12_uart0_dual_ee_ce_u4_hw m645a_u1x12_uart0_dual_ee_ce_hw
 * m645a_u1x12_uart0_dual_ee_ce_u4_hw m645p_u1x12_uart0_dual_ee_ce_hw
 * m645p_u1x12_uart0_dual_ee_ce_u4_hw m6450_u1x12_uart0_dual_ee_ce_hw
 * m6450_u1x12_uart0_dual_ee_ce_u4_hw m6450a_u1x12_uart0_dual_ee_ce_hw
 * m6450a_u1x12_uart0_dual_ee_ce_u4_hw m6450p_u1x12_uart0_dual_ee_ce_hw
 * m6450p_u1x12_uart0_dual_ee_ce_u4_hw c64_u1x12_uart0_dual_ee_ce_hw
 * c64_u1x12_uart0_dual_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u1x12_uart0_dual_ee_ce_hw[] = {
  0xde0fbbe8a343e907, 0xeeacd4da7afcdddd, 0x1f201de3feeeeeee, 0xd3817ba73baefdc6, 0xeb59f5e6d0672b88,
  0xc15de49d67729d3c, 0x909e5e609f180904, 0xa4606eebec99182a, 0x9dd3e25c40c2860d, 0xc19bf32547e65741,
  0x6e9bd47bc3d872d1, 0xdf0450a48904903c, 0x9f5c3e144312bfcf, 0x886559cbd338aeb8, 0x134728a8432d04b4,
  0xf212db8a4ffa039e, 0xa6bfceadcc161bca, 0x49feda9fddba7c25, 0xf8c5faa32870da37, 0x1759c3cf3c873b31,
  0x7ff51f097e21b091, 0x109ba64c5c3b3974, 0xaf9ea3cadfc94ed6, 0x5315c06f51f06cc1, 0xb2c4522cd3ad08a0,
  0xbb71943a909afa30, 0x7a89768851ef673a, 0x08a8f9eb1aaf1b1d, 0x0decbe9662e12114, 0x6627f58a8d822647,
  0xec9fc55f3bb8a929, 0x81013859bf0312b5, 0x379b228301deb5e7, 0x2a6f529c94e8016f, 0x6ae9c6378ce881df,
  0xdb73863b7b15545a, 0x9fa84e31b94b52fc, 0x13ffbc3def286153, 0xc3347db0e3f8cbf3, 0x30be347a2ff03f7e,
  0x5b387138cb25c33d, 0x792bf734332c3a4a, 0x000000ebaaea928a,
};

/*
 * m649_u2x8_uart0_noled_pr          m649a_u2x8_uart0_noled            m649a_u2x8_uart0_noled_pr
 * m649p_u2x8_uart0_noled            m649p_u2x8_uart0_noled_pr         m6490_u2x8_uart0_noled
 * m6490_u2x8_uart0_noled_pr         m6490a_u2x8_uart0_noled           m6490a_u2x8_uart0_noled_pr
 * m6490p_u2x8_uart0_noled           m6490p_u2x8_uart0_noled_pr        m645_u2x8_uart0_noled
 * m645_u2x8_uart0_noled_pr          m645a_u2x8_uart0_noled            m645a_u2x8_uart0_noled_pr
 * m645p_u2x8_uart0_noled            m645p_u2x8_uart0_noled_pr         m6450_u2x8_uart0_noled
 * m6450_u2x8_uart0_noled_pr         m6450a_u2x8_uart0_noled           m6450a_u2x8_uart0_noled_pr
 * m6450p_u2x8_uart0_noled           m6450p_u2x8_uart0_noled_pr
 */
static const uint64_t ur_m649_u2x8_uart0_noled[] = {
  0xb777776d0f59bb37, 0xeeeeeeaafb395a44, 0x51c742245533466e, 0x6188f1f60fbbba16, 0x2bbc9ddb1ec842f3,
  0x3f38cc13e3012098, 0xf6e9f092f9fefd0f, 0x843c368ded51ca4d, 0x481a0bf51fa03be5, 0x16594cf7dad490e2,
  0x1f3b57f47ac398b0, 0x99e5403ff6608ebd, 0x5ec1c7c0f2cf6c7d, 0xeb5e73859bf0312b, 0x9c2de6f00fa8301d,
  0x67440aeaa72f29b1, 0xb15545a585ce31bc, 0x94b52fcdb1248ab7, 0x3c81a3f8d163ce1b, 0x970cf4c2b93f7566,
  0xb0e9296ce1c4e32c, 0xb022f9e4afdcd0cc, 0x00000000000f9000,
};

/*
 * m649a_u2x8_uart0_noled_pr_u4      m649p_u2x8_uart0_noled_pr_u4      m6490_u2x8_uart0_noled_pr_u4
 * m6490a_u2x8_uart0_noled_pr_u4     m6490p_u2x8_uart0_noled_pr_u4     m645_u2x8_uart0_noled_pr_u4
 * m645a_u2x8_uart0_noled_pr_u4      m645p_u2x8_uart0_noled_pr_u4      m6450_u2x8_uart0_noled_pr_u4
 * m6450a_u2x8_uart0_noled_pr_u4     m6450p_u2x8_uart0_noled_pr_u4
 */
static const uint64_t ur_m649_u2x8_uart0_noled_pr_u4[] = {
  0xbbbbb6874486eff6, 0x7777557d9cad225b, 0xe3a1122a99a33777, 0xc478fb07dddd0b28, 0x793baf5cc4c2fa66,
  0x719827c602413057, 0xd3e125f3fec5767e, 0x786d1bdaa3949bed, 0x3417ea3f4077cb08, 0xb299efb5a921c490,
  0x76afe8f58731602c, 0xca807fecc11d7a3e, 0x838f81e59ed8fb33, 0xbce70b37e06256bd, 0x5bcde01f50603bd6,
  0x8815d54e5e536338, 0xaa8b4b0b9c6378ce, 0x6a5f9b6249156f62, 0xe0eee34591263729, 0xca1854e7ea75666f,
  0xfe32fcc4ffef0f7b, 0xfc0fdfb0cd1f6c38, 0xc970cf4c2f8d1e8b, 0xcb0e9296ce1c4e32, 0x256b8f9e4afdcd0c,
  0x00000000000f93a7,
};

/*
 * m649_u2x8_uart0_noled_pr_ee_u4    m649a_u2x8_uart0_noled_pr_ee      m649a_u2x8_uart0_noled_pr_ee_u4
 * m649p_u2x8_uart0_noled_pr_ee      m649p_u2x8_uart0_noled_pr_ee_u4   m6490_u2x8_uart0_noled_pr_ee
 * m6490_u2x8_uart0_noled_pr_ee_u4   m6490a_u2x8_uart0_noled_pr_ee     m6490a_u2x8_uart0_noled_pr_ee_u4
 * m6490p_u2x8_uart0_noled_pr_ee     m6490p_u2x8_uart0_noled_pr_ee_u4  m645_u2x8_uart0_noled_pr_ee
 * m645_u2x8_uart0_noled_pr_ee_u4    m645a_u2x8_uart0_noled_pr_ee      m645a_u2x8_uart0_noled_pr_ee_u4
 * m645p_u2x8_uart0_noled_pr_ee      m645p_u2x8_uart0_noled_pr_ee_u4   m6450_u2x8_uart0_noled_pr_ee
 * m6450_u2x8_uart0_noled_pr_ee_u4   m6450a_u2x8_uart0_noled_pr_ee     m6450a_u2x8_uart0_noled_pr_ee_u4
 * m6450p_u2x8_uart0_noled_pr_ee     m6450p_u2x8_uart0_noled_pr_ee_u4
 */
static const uint64_t ur_m649_u2x8_uart0_noled_pr_ee[] = {
  0xdddddb43a2431202, 0xbbbbaabe6b1b112d, 0x75a14d971d867bbb, 0x60bfd4cd0775228d, 0xb336c4d15051bb06,
  0x9f180904c15de4ee, 0x387ff62bb3ec1660, 0xbdaa3949bedd3e12, 0xe449aad68e7186d1, 0x51f06cc1a63ea3ca,
  0x69d68450ef8afbaf, 0x484d7d1859622916, 0x59cead2f38ae3593, 0x5d0ebce9bb6f68f0, 0x908a39e461c6c6ab,
  0x1fadc37b2d973170, 0xaf600544a9a546c1, 0xf5af39c2cdf81895, 0xce16f37807d4180e, 0x33a20575539794d8,
  0xd8aaa2d2c2e718de, 0xca5a97e6d892455b, 0x9bf83bb8d164498d, 0xdef2861539fa9d59, 0x0e3f8cbf313ffbc3,
  0xa2ff03f7ec3347db, 0x8cb25c33d30be347, 0x4332c3a4a5b38713, 0xf9559ae3e792bf73, 0x000000000000013a,
};

/*
 * m649_u2x8_uart0_noled_pr_ce_u4    m649a_u2x8_uart0_noled_pr_ce      m649a_u2x8_uart0_noled_pr_ce_u4
 * m649p_u2x8_uart0_noled_pr_ce      m649p_u2x8_uart0_noled_pr_ce_u4   m6490_u2x8_uart0_noled_pr_ce
 * m6490_u2x8_uart0_noled_pr_ce_u4   m6490a_u2x8_uart0_noled_pr_ce     m6490a_u2x8_uart0_noled_pr_ce_u4
 * m6490p_u2x8_uart0_noled_pr_ce     m6490p_u2x8_uart0_noled_pr_ce_u4  m645_u2x8_uart0_noled_pr_ce
 * m645_u2x8_uart0_noled_pr_ce_u4    m645a_u2x8_uart0_noled_pr_ce      m645a_u2x8_uart0_noled_pr_ce_u4
 * m645p_u2x8_uart0_noled_pr_ce      m645p_u2x8_uart0_noled_pr_ce_u4   m6450_u2x8_uart0_noled_pr_ce
 * m6450_u2x8_uart0_noled_pr_ce_u4   m6450a_u2x8_uart0_noled_pr_ce     m6450a_u2x8_uart0_noled_pr_ce_u4
 * m6450p_u2x8_uart0_noled_pr_ce     m6450p_u2x8_uart0_noled_pr_ce_u4
 */
static const uint64_t ur_m649_u2x8_uart0_noled_pr_ce[] = {
  0xbbbbb6874486d38b, 0xeeeeaafc2f64e25b, 0x5a9c2f623ac86eee, 0x68c286deeee9b491, 0xf27751994e1a6529,
  0x9d304f8c048260ae, 0x9f09145ffb15d9ff, 0xc368ded51ca4df6e, 0x1e6e771ee317eb10, 0x7e21b0911759c3cf,
  0x8b87ff81a3f51f09, 0x727a7b96757d64c9, 0x749490e2481eb3d4, 0xabfa3d61cc580a3e, 0xa01ffb33c75e8f9d,
  0x38f81e5adc3eccf2, 0xce70b37e06256bd8, 0xbcde01f50603bd6b, 0x815d54e5e5363385, 0xa8b4b0b9c6378ce8,
  0x4bf36c490c76f62a, 0x1ddc68b224c6e52d, 0x430a9cfd4eaccdfc, 0xc65f989ffde1ef79, 0x81fbf619a3ed871f,
  0x2e19e985f1a3d17f, 0x61d252d9c389c659, 0xfd71f3c95fb9a199, 0x0000000001baec21,
};

/*
 * m649_u2x8_uart0_noled_pr_ee_ce_u4 m649a_u2x8_uart0_noled_pr_ee_ce   m649a_u2x8_uart0_noled_pr_ee_ce_u4
 * m649p_u2x8_uart0_noled_pr_ee_ce   m649p_u2x8_uart0_noled_pr_ee_ce_u4
 * m6490_u2x8_uart0_noled_pr_ee_ce   m6490_u2x8_uart0_noled_pr_ee_ce_u4
 * m6490a_u2x8_uart0_noled_pr_ee_ce  m6490a_u2x8_uart0_noled_pr_ee_ce_u4
 * m6490p_u2x8_uart0_noled_pr_ee_ce  m6490p_u2x8_uart0_noled_pr_ee_ce_u4
 * m645_u2x8_uart0_noled_pr_ee_ce    m645_u2x8_uart0_noled_pr_ee_ce_u4 m645a_u2x8_uart0_noled_pr_ee_ce
 * m645a_u2x8_uart0_noled_pr_ee_ce_u4 m645p_u2x8_uart0_noled_pr_ee_ce
 * m645p_u2x8_uart0_noled_pr_ee_ce_u4 m6450_u2x8_uart0_noled_pr_ee_ce
 * m6450_u2x8_uart0_noled_pr_ee_ce_u4 m6450a_u2x8_uart0_noled_pr_ee_ce
 * m6450a_u2x8_uart0_noled_pr_ee_ce_u4 m6450p_u2x8_uart0_noled_pr_ee_ce
 * m6450p_u2x8_uart0_noled_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u2x8_uart0_noled_pr_ee_ce[] = {
  0x77776d0e890c1107, 0xbbbaabc68299c4b7, 0xb8da29bbd8e3bbbb, 0xa165955a6ec2f536, 0xe455f6277efa7725,
  0xe30120982bbc9dd4, 0xd7fd8aecf8cdcc13, 0x6a8e526fb74f8482, 0x518bf547f3a1b46f, 0x8bace1e78f373b8e,
  0xe5fa8f84bf10d848, 0x841ef993170f494c, 0xd6bfa8f2bea253b5, 0x298ac27fa8f83660, 0x5962291669d68450,
  0x5dba711d484d7d18, 0x79d376ded1e0b39d, 0xe791871b1aaf1b1d, 0x0decb65cc5c24228, 0xce89534a8d822647,
  0x73859bf0312b5ec2, 0xe6f00fa8301deb5e, 0x0aeaa72f29b19c2d, 0x45a585ce31bc6744, 0x5f9b624863b7b155,
  0xeee345912637296a, 0x1854e7ea75666fe0, 0x32fcc4ffef0f7bca, 0x0fdfb0cd1f6c38fe, 0x70cf4c2f8d1e8bfc,
  0x0e9296ce1c4e32c9, 0x6b8f9e4afdcd0ccb, 0x00000000027e0fc1,
};

/*
 * m649a_u2x8_uart0_noled_ee_hw      m649p_u2x8_uart0_noled_ee_hw      m6490_u2x8_uart0_noled_ee_hw
 * m6490a_u2x8_uart0_noled_ee_hw     m6490p_u2x8_uart0_noled_ee_hw     m645_u2x8_uart0_noled_ee_hw
 * m645a_u2x8_uart0_noled_ee_hw      m645p_u2x8_uart0_noled_ee_hw      m6450_u2x8_uart0_noled_ee_hw
 * m6450a_u2x8_uart0_noled_ee_hw     m6450p_u2x8_uart0_noled_ee_hw     c64_u2x8_uart0_noled_ee_hw
 */
static const uint64_t ur_m649_u2x8_uart0_noled_ee_hw[] = {
  0xeeeeda1d1468d38b, 0xdddd55f358d8896e, 0xad0a6cb8ec33dddd, 0x05fea6683ba9146b, 0xea3329da528dd833,
  0x09f180904c15de4e, 0x48e1fff5933ec166, 0x46f6a8e526fb74f8, 0x2b9126ab5a39c61b, 0xbd47c1b30698fa8f,
  0x59a75a1143be2bee, 0x4d2135f4616588a4, 0xc1673ab4bce2b8d6, 0xad743af3a6edbda3, 0xc24228e791871b1a,
  0x047eb70decb65cc5, 0x56bd801512a6951b, 0x3bd6bce70b37e062, 0x63385bcde01f5060, 0x78ce8815d54e5e53,
  0x6f62aa8b4b0b9c63, 0x37296a5f9b624915, 0xbde50c2a73f509c6, 0x1c7f197e627ff787, 0x45fe07efd8668fb6,
  0x1964b867a617c68f, 0x866587494b670e27, 0xbf4117d14f257ee6, 0x0000000000000005,
};

/*
 * m649_u2x8_uart0_noled_ee_ce_u4_hw m649a_u2x8_uart0_noled_ee_ce_hw   m649a_u2x8_uart0_noled_ee_ce_u4_hw
 * m649p_u2x8_uart0_noled_ee_ce_hw   m649p_u2x8_uart0_noled_ee_ce_u4_hw
 * m6490_u2x8_uart0_noled_ee_ce_hw   m6490_u2x8_uart0_noled_ee_ce_u4_hw
 * m6490a_u2x8_uart0_noled_ee_ce_hw  m6490a_u2x8_uart0_noled_ee_ce_u4_hw
 * m6490p_u2x8_uart0_noled_ee_ce_hw  m6490p_u2x8_uart0_noled_ee_ce_u4_hw
 * m645_u2x8_uart0_noled_ee_ce_hw    m645_u2x8_uart0_noled_ee_ce_u4_hw m645a_u2x8_uart0_noled_ee_ce_hw
 * m645a_u2x8_uart0_noled_ee_ce_u4_hw m645p_u2x8_uart0_noled_ee_ce_hw
 * m645p_u2x8_uart0_noled_ee_ce_u4_hw m6450_u2x8_uart0_noled_ee_ce_hw
 * m6450_u2x8_uart0_noled_ee_ce_u4_hw m6450a_u2x8_uart0_noled_ee_ce_hw
 * m6450a_u2x8_uart0_noled_ee_ce_u4_hw m6450p_u2x8_uart0_noled_ee_ce_hw
 * m6450p_u2x8_uart0_noled_ee_ce_u4_hw c64_u2x8_uart0_noled_ee_ce_hw
 * c64_u2x8_uart0_noled_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u2x8_uart0_noled_ee_ce_hw[] = {
  0xdddddb43a28d12a8, 0xeeeeaaf1a0a6712d, 0xae368a6ef638eeee, 0x685965569bb0bd4d, 0xba75a356b3ee9dc9,
  0x827c602413057793, 0x2416bffac99f19b9, 0xa37b5472937dba7c, 0xdc728c5faa3f9d0d, 0x8488bace1e79e439,
  0x699bffa8f84bf10d, 0x76b083df3262e1f9, 0xcc1ad7f51e57d44a, 0x8a0531584ff51f06, 0xa30b2c4522cd3ad0,
  0x73abb74e23a909af, 0x63af3a6edbda3c16, 0x451cf230e36355e3, 0xc8e1bd96cb98b848, 0xd859d12a6951b044,
  0x6bce70b37e06256b, 0x85bcde01f50603bd, 0xe8815d54e5e53633, 0x2aa8b4b0b9c6378c, 0x2d4bf36c490c76f6,
  0xa1854e7ea138c6e5, 0xe32fcc4ffef0f7bc, 0xc0fdfb0cd1f6c38f, 0x970cf4c2f8d1e8bf, 0xb0e9296ce1c4e32c,
  0x000a29e4afdcd0cc, 0x0000000000028093,
};

/*
 * m649_u2x8_uart0_lednop_pr         m649a_u2x8_uart0_lednop           m649a_u2x8_uart0_lednop_pr
 * m649p_u2x8_uart0_lednop           m649p_u2x8_uart0_lednop_pr        m6490_u2x8_uart0_lednop
 * m6490_u2x8_uart0_lednop_pr        m6490a_u2x8_uart0_lednop          m6490a_u2x8_uart0_lednop_pr
 * m6490p_u2x8_uart0_lednop          m6490p_u2x8_uart0_lednop_pr       m645_u2x8_uart0_lednop
 * m645_u2x8_uart0_lednop_pr         m645a_u2x8_uart0_lednop           m645a_u2x8_uart0_lednop_pr
 * m645p_u2x8_uart0_lednop           m645p_u2x8_uart0_lednop_pr        m6450_u2x8_uart0_lednop
 * m6450_u2x8_uart0_lednop_pr        m6450a_u2x8_uart0_lednop          m6450a_u2x8_uart0_lednop_pr
 * m6450p_u2x8_uart0_lednop          m6450p_u2x8_uart0_lednop_pr
 */
static const uint64_t ur_m649_u2x8_uart0_lednop[] = {
  0xbbbbbb687acdfc4f, 0xeeeeeaafb385ee25, 0x26cfddf87f588eee, 0xc7eb4bf377764422, 0xde4eec2f5a3c7a09,
  0x052609f180904c15, 0x74f84be4ff7e879f, 0x0e1b46f6a8e526fb, 0x0cd27a8e4f1df2c9, 0x7ba61f3a4a487124,
  0xd9af91c829cc580b, 0x1f7b8e58c11d78b9, 0xe166fc0c4ad7b0ac, 0x8a0c077ad79e0404, 0x4a7253a005bcde6c,
  0x18de33a2077ca9bd, 0x22adec555169aba7, 0x79c37296a5f9b6e7, 0xeeacc790347f1a2c, 0x9c6592e19e985727,
  0x9a19961d252d9c38, 0x900396045f3c95fb, 0x000000000000000f,
};

/*
 * m649a_u2x8_uart0_lednop_pr_u4     m649p_u2x8_uart0_lednop_pr_u4     m6490_u2x8_uart0_lednop_pr_u4
 * m6490a_u2x8_uart0_lednop_pr_u4    m6490p_u2x8_uart0_lednop_pr_u4    m645_u2x8_uart0_lednop_pr_u4
 * m645a_u2x8_uart0_lednop_pr_u4     m645p_u2x8_uart0_lednop_pr_u4     m6450_u2x8_uart0_lednop_pr_u4
 * m6450a_u2x8_uart0_lednop_pr_u4    m6450p_u2x8_uart0_lednop_pr_u4
 */
static const uint64_t ur_m649_u2x8_uart0_lednop_pr_u4[] = {
  0x777776d0e890c743, 0xddddd55f671d7c4b, 0xc75a5097e68dbddd, 0x99fa5327bbba1651, 0xf2776a2f256a6b04,
  0xeb304f8c048260ae, 0x4f84a5f7fd8aecf9, 0xe1b46f6a8e526fb7, 0xd05fa8f6b1df2c21, 0x94df241fa4871240,
  0xcb3d1a43398b0165, 0x500ffd9823af47ce, 0x0ad03cb3db416691, 0x04e166fc0c4ad7b2, 0x6c8a0c077ad79e04,
  0xbd4a7253a005bcde, 0xa718de33a2077ca9, 0xe722adec555169ab, 0x5912637296a5f9b6, 0x7ea75666fe0eee34,
  0x4ffef0f7bca1854e, 0x0cd1f6c38fe32fcc, 0xc2f8d1e8bfc0fdfb, 0x6ce1c4e32c970cf4, 0xe4afdcd0ccb0e929,
  0x0000f9363c9eb8f9,
};

/*
 * m649_u2x8_uart0_lednop_pr_ee_u4   m649a_u2x8_uart0_lednop_pr_ee     m649a_u2x8_uart0_lednop_pr_ee_u4
 * m649p_u2x8_uart0_lednop_pr_ee     m649p_u2x8_uart0_lednop_pr_ee_u4  m6490_u2x8_uart0_lednop_pr_ee
 * m6490_u2x8_uart0_lednop_pr_ee_u4  m6490a_u2x8_uart0_lednop_pr_ee    m6490a_u2x8_uart0_lednop_pr_ee_u4
 * m6490p_u2x8_uart0_lednop_pr_ee    m6490p_u2x8_uart0_lednop_pr_ee_u4 m645_u2x8_uart0_lednop_pr_ee
 * m645_u2x8_uart0_lednop_pr_ee_u4   m645a_u2x8_uart0_lednop_pr_ee     m645a_u2x8_uart0_lednop_pr_ee_u4
 * m645p_u2x8_uart0_lednop_pr_ee     m645p_u2x8_uart0_lednop_pr_ee_u4  m6450_u2x8_uart0_lednop_pr_ee
 * m6450_u2x8_uart0_lednop_pr_ee_u4  m6450a_u2x8_uart0_lednop_pr_ee    m6450a_u2x8_uart0_lednop_pr_ee_u4
 * m6450p_u2x8_uart0_lednop_pr_ee    m6450p_u2x8_uart0_lednop_pr_ee_u4
 */
static const uint64_t ur_m649_u2x8_uart0_lednop_pr_ee[] = {
  0xeeeeeda1d12198e2, 0xbbbbaabe6b62f896, 0x5cd85a331da17bbb, 0xde3bf53341dd48a3, 0xa5387b2e33acd2cf,
  0x27c602413057793b, 0x8a1ffd8aecfe5698, 0x6f6a8e526fb74f84, 0xb32a6ab5a39c61b4, 0xd47c1b30698fa8f2,
  0x34eb422877c561ef, 0xa426be8c2cb1148b, 0x68e756973d571ac9, 0xd743af3a6ed19232, 0x242282791bdab1aa,
  0x47eb70decb65cc5c, 0xd7b0021f667951b0, 0x9e0404e166fc0c4a, 0xbcde6c8a0c077ad7, 0x7ca9bd4a7253a005,
  0x69aba718de33a207, 0xf9b6e722adec5551, 0xee345912637296a5, 0x854e7ea75666fe0e, 0x2fcc4ffef0f7bca1,
  0xfdfb0cd1f6c38fe3, 0x0cf4c2f8d1e8bfc0, 0xe9296ce1c4e32c97, 0xb8f9e4afdcd0ccb0, 0x000000004eb98396,
};

/*
 * m649_u2x8_uart0_lednop_pr_ce_u4   m649a_u2x8_uart0_lednop_pr_ce     m649a_u2x8_uart0_lednop_pr_ce_u4
 * m649p_u2x8_uart0_lednop_pr_ce     m649p_u2x8_uart0_lednop_pr_ce_u4  m6490_u2x8_uart0_lednop_pr_ce
 * m6490_u2x8_uart0_lednop_pr_ce_u4  m6490a_u2x8_uart0_lednop_pr_ce    m6490a_u2x8_uart0_lednop_pr_ce_u4
 * m6490p_u2x8_uart0_lednop_pr_ce    m6490p_u2x8_uart0_lednop_pr_ce_u4 m645_u2x8_uart0_lednop_pr_ce
 * m645_u2x8_uart0_lednop_pr_ce_u4   m645a_u2x8_uart0_lednop_pr_ce     m645a_u2x8_uart0_lednop_pr_ce_u4
 * m645p_u2x8_uart0_lednop_pr_ce     m645p_u2x8_uart0_lednop_pr_ce_u4  m6450_u2x8_uart0_lednop_pr_ce
 * m6450_u2x8_uart0_lednop_pr_ce_u4  m6450a_u2x8_uart0_lednop_pr_ce    m6450a_u2x8_uart0_lednop_pr_ce_u4
 * m6450p_u2x8_uart0_lednop_pr_ce    m6450p_u2x8_uart0_lednop_pr_ce_u4
 */
static const uint64_t ur_m649_u2x8_uart0_lednop_pr_ce[] = {
  0xdddddb43a243280b, 0xbbbbaabf0b92112d, 0xb64da9933d067bbb, 0x6c20950f7774da48, 0x793bb939eb50569c,
  0xc39827c602413057, 0x4f8492b7fd8aecf9, 0x61b46f6a8e526fb7, 0x8f373b80d18bf588, 0xbf10d8488bace1e7,
  0x170e9b73b7fa8f84, 0xfd24f72ceafac993, 0x116921c4903d67a8, 0xb3d1a43398b01531, 0x00ffd99e3af47cec,
  0x2b40f2d6e4166915, 0x13859bf0312b5ec8, 0xb228301deb5e7810, 0xf529c94e8016f379, 0x9c6378ce881df2a6,
  0x3863b7b15545a6ae, 0xc8931b94b52fcdb7, 0xf53ab337f07771a2, 0x7ff787bde50c2a73, 0x668fb61c7f197e62,
  0x17c68f45fe07efd8, 0x670e271964b867a6, 0x257ee6866587494b, 0x000375ef24f5c7cf,
};

/*
 * m649_u2x8_uart0_lednop_pr_ee_ce_u4 m649a_u2x8_uart0_lednop_pr_ee_ce
 * m649a_u2x8_uart0_lednop_pr_ee_ce_u4 m649p_u2x8_uart0_lednop_pr_ee_ce
 * m649p_u2x8_uart0_lednop_pr_ee_ce_u4 m6490_u2x8_uart0_lednop_pr_ee_ce
 * m6490_u2x8_uart0_lednop_pr_ee_ce_u4 m6490a_u2x8_uart0_lednop_pr_ee_ce
 * m6490a_u2x8_uart0_lednop_pr_ee_ce_u4 m6490p_u2x8_uart0_lednop_pr_ee_ce
 * m6490p_u2x8_uart0_lednop_pr_ee_ce_u4 m645_u2x8_uart0_lednop_pr_ee_ce
 * m645_u2x8_uart0_lednop_pr_ee_ce_u4 m645a_u2x8_uart0_lednop_pr_ee_ce
 * m645a_u2x8_uart0_lednop_pr_ee_ce_u4 m645p_u2x8_uart0_lednop_pr_ee_ce
 * m645p_u2x8_uart0_lednop_pr_ee_ce_u4 m6450_u2x8_uart0_lednop_pr_ee_ce
 * m6450_u2x8_uart0_lednop_pr_ee_ce_u4 m6450a_u2x8_uart0_lednop_pr_ee_ce
 * m6450a_u2x8_uart0_lednop_pr_ee_ce_u4 m6450p_u2x8_uart0_lednop_pr_ee_ce
 * m6450p_u2x8_uart0_lednop_pr_ee_ce_u4
 */
static const uint64_t ur_m649_u2x8_uart0_lednop_pr_ee_ce[] = {
  0xbbbbb68744867f3e, 0xdddd55e340b0625b, 0xa66b8da5edc1dddd, 0xc202caad37617a9b, 0x3551786e75b1232e,
  0xf8c048260aef2776, 0x1fffb15d9f0d1304, 0xdaa3949bedd3e12b, 0xd462fd51fce86d1b, 0x22eb3879e3cdcec9,
  0x83fea3e12fc43612, 0xc20f7cc98b87ca86, 0x6b5fd4795f7529da, 0x14c57b7fd47c1b30, 0x2cb1148b34eb4228,
  0xaedc7a8ea426be8c, 0x5e74dda32464d1ce, 0x09e46f6ac6abc6c7, 0xc37b2d973170908a, 0x663eccf2a3608991,
  0x09c2cdf81895af61, 0xd914180ef5af3c08, 0x7a94e4a7400b79bc, 0x4e31bc67440ef953, 0x9c31dbd8aaa2d357,
  0x64498dca5a97e6db, 0xfa9d599bf83bb8d1, 0x3ffbc3def2861539, 0x3347db0e3f8cbf31, 0x0be347a2ff03f7ec,
  0xb387138cb25c33d3, 0x92bf734332c3a4a5, 0x00004fc4b69ae3e7,
};

/*
 * m649a_u2x8_uart0_lednop_ee_hw     m649p_u2x8_uart0_lednop_ee_hw     m6490_u2x8_uart0_lednop_ee_hw
 * m6490a_u2x8_uart0_lednop_ee_hw    m6490p_u2x8_uart0_lednop_ee_hw    m645_u2x8_uart0_lednop_ee_hw
 * m645a_u2x8_uart0_lednop_ee_hw     m645p_u2x8_uart0_lednop_ee_hw     m6450_u2x8_uart0_lednop_ee_hw
 * m6450a_u2x8_uart0_lednop_ee_hw    m6450p_u2x8_uart0_lednop_ee_hw    c64_u2x8_uart0_lednop_ee_hw
 */
static const uint64_t ur_m649_u2x8_uart0_lednop_ee_hw[] = {
  0x77776d0e8a34280b, 0xdddd55f35b17c4b7, 0xe6c2d198ed0bdddd, 0xf1dfa99a0eea451a, 0xbb939eb6b4e6967e,
  0x827c602413057793, 0x12287ffd64cfe569, 0xd1bdaa3949bedd3e, 0xcacca9aad68e7186, 0xbf51f06cc1a63ea3,
  0x2cd3ad08a1df1587, 0x26909afa30b2c452, 0xc9a39d5a5cf55c6b, 0xab5d0ebce9bb4648, 0x70908a09e46f6ac6,
  0xc11fadc37b2d9731, 0x2b5ec0087d99e546, 0x5e781013859bf031, 0x16f379b228301deb, 0x1df2a6f529c94e80,
  0x45a6ae9c6378ce88, 0x97e6db9c8ab7b155, 0x0a9cfd42718dca5a, 0x5f989ffde1ef7943, 0xfbf619a3ed871fc6,
  0x19e985f1a3d17f81, 0xd252d9c389c6592e, 0xf453c95fb9a19961, 0x00000000016fb045,
};

/*
 * m649_u2x8_uart0_lednop_ee_ce_u4_hw m649a_u2x8_uart0_lednop_ee_ce_hw
 * m649a_u2x8_uart0_lednop_ee_ce_u4_hw m649p_u2x8_uart0_lednop_ee_ce_hw
 * m649p_u2x8_uart0_lednop_ee_ce_u4_hw m6490_u2x8_uart0_lednop_ee_ce_hw
 * m6490_u2x8_uart0_lednop_ee_ce_u4_hw m6490a_u2x8_uart0_lednop_ee_ce_hw
 * m6490a_u2x8_uart0_lednop_ee_ce_u4_hw m6490p_u2x8_uart0_lednop_ee_ce_hw
 * m6490p_u2x8_uart0_lednop_ee_ce_u4_hw m645_u2x8_uart0_lednop_ee_ce_hw
 * m645_u2x8_uart0_lednop_ee_ce_u4_hw m645a_u2x8_uart0_lednop_ee_ce_hw
 * m645a_u2x8_uart0_lednop_ee_ce_u4_hw m645p_u2x8_uart0_lednop_ee_ce_hw
 * m645p_u2x8_uart0_lednop_ee_ce_u4_hw m6450_u2x8_uart0_lednop_ee_ce_hw
 * m6450_u2x8_uart0_lednop_ee_ce_u4_hw m6450a_u2x8_uart0_lednop_ee_ce_hw
 * m6450a_u2x8_uart0_lednop_ee_ce_u4_hw m6450p_u2x8_uart0_lednop_ee_ce_hw
 * m6450p_u2x8_uart0_lednop_ee_ce_u4_hw c64_u2x8_uart0_lednop_ee_ce_hw
 * c64_u2x8_uart0_lednop_ee_ce_u4_hw
 */
static const uint64_t ur_m649_u2x8_uart0_lednop_ee_ce_hw[] = {
  0xeeeeda1d146824d6, 0x7775578d02c1896e, 0x99ae3697b7077777, 0x080b2ab4dd85ea6e, 0xbf6baef53ec48cbb,
  0x27c602413057793b, 0x563fffd64cf86898, 0x37b5472937dba7c2, 0x93a8c5faa3f9d0da, 0x488bace1e79e439d,
  0x6c87fa8f84bf10d8, 0xb5841ef993170fd6, 0x60d6bfa8f2beea53, 0x50298af6ffa8f836, 0x185962291669d684,
  0x9d5db8f51d484d7d, 0x8ebce9bb4648c9a3, 0x1413c8ded58d578d, 0x2386f65b2e62e121, 0xc2cc7d99e546c113,
  0x1013859bf0312b5e, 0x79b228301deb5e78, 0xa6f529c94e8016f3, 0xae9c6378ce881df2, 0xb73863b7b15545a6,
  0xfa84e31b94b52fcd, 0x3ffbc3def2861539, 0x3347db0e3f8cbf31, 0x0be347a2ff03f7ec, 0xb387138cb25c33d3,
  0x92bf734332c3a4a5, 0x000005010e2fa8a7,
};

/*
 * m649_u2x8_uart0_dual_pr           m649_u2x8_uart0_dual_pr_u4        m649a_u2x8_uart0_dual
 * m649a_u2x8_uart0_dual_pr          m649a_u2x8_uart0_dual_pr_u4       m649p_u2x8_uart0_dual
 * m649p_u2x8_uart0_dual_pr          m649p_u2x8_uart0_dual_pr_u4       m6490_u2x8_uart0_dual
 * m6490_u2x8_uart0_dual_pr          m6490_u2x8_uart0_dual_pr_u4       m6490a_u2x8_uart0_dual
 * m6490a_u2x8_uart0_dual_pr         m6490a_u2x8_uart0_dual_pr_u4      m6490p_u2x8_uart0_dual
 * m6490p_u2x8_uart0_dual_pr         m6490p_u2x8_uart0_dual_pr_u4      m645_u2x8_uart0_dual
 * m645_u2x8_uart0_dual_pr           m645_u2x8_uart0_dual_pr_u4        m645a_u2x8_uart0_dual
 * m645a_u2x8_uart0_dual_pr          m645a_u2x8_uart0_dual_pr_u4       m645p_u2x8_uart0_dual
 * m645p_u2x8_uart0_dual_pr          m645p_u2x8_uart0_dual_pr_u4       m6450_u2x8_uart0_dual
 * m6450_u2x8_uart0_dual_pr          m6450_u2x8_uart0_dual_pr_u4       m6450a_u2x8_uart0_dual
 * m6450a_u2x8_uart0_dual_pr         m6450a_u2x8_uart0_dual_pr_u4      m6450p_u2x8_uart0_dual
 * m6450p_u2x8_uart0_dual_pr         m6450p_u2x8_uart0_dual_pr_u4
 */
static const uint64_t ur_m649_u2x8_uart0_dual[] = {
  0xeeeeef07a24343ee, 0xbbbbbab0dbb0d7e6, 0xeec8dd41bd3adbbb, 0xb4d8b276eeed0b23, 0xf77577e4496a69e3,
  0x9f180904c15de4e2, 0x7d9323055212a260, 0x881850c1b48c0ddd, 0x75fcca0253ba7c4b, 0x7727b0f9c7090f31,
  0x524482481afb9bd4, 0x0a21895fe7ef8228, 0x397a670c7c4fae1f, 0x8a8432d0f9110cab, 0xde037fd01cf0987c,
  0xaa9260b0de579096, 0x2937dba7c2413fff, 0x77cb1350da37b547, 0x438920621fd47c8a, 0xc580aa0f34e2f7d2,
  0xd78033b5ac8ebf9c, 0x887486a807fecc11, 0xee2a4aa4e81e59ed, 0xc0c4ad7b27f157ce, 0x77ad79e0404e166f,
  0x3a005bcde6c8a0c0, 0x3a2077ca9bd4a725, 0xc555169aba718de3, 0x296a5f9b6e722ade, 0x6fe0eee345912637,
  0x7bca1854e7ea7566, 0x38fe32fcc4ffef0f, 0x8bfc0fdfb0cd1f6c, 0x32c970cf4c2f8d1e, 0x0ccb0e9296ce1c4e,
  0xcfc16b8f9e4afdcd, 0x0000000000000a49,
};

/*
 * m649_u2x8_uart0_dual_pr_ee_u4     m649a_u2x8_uart0_dual_pr_ee       m649a_u2x8_uart0_dual_pr_ee_u4
 * m649p_u2x8_uart0_dual_pr_ee       m649p_u2x8_uart0_dual_pr_ee_u4    m6490_u2x8_uart0_dual_pr_ee
 * m6490_u2x8_uart0_dual_pr_ee_u4    m6490a_u2x8_uart0_dual_pr_ee      m6490a_u2x8_uart0_dual_pr_ee_u4
 * m6490p_u2x8_uart0_dual_pr_ee      m6490p_u2x8_uart0_dual_pr_ee_u4   m645_u2x8_uart0_dual_pr_ee
 * m645_u2x8_uart0_dual_pr_ee_u4     m645a_u2x8_uart0_dual_pr_ee       m645a_u2x8_uart0_dual_pr_ee_u4
 * m645p_u2x8_uart0_dual_pr_ee       m645p_u2x8_uart0_dual_pr_ee_u4    m6450_u2x8_uart0_dual_pr_ee
 * m6450_u2x8_uart0_dual_pr_ee_u4    m6450a_u2x8_uart0_dual_pr_ee      m6450a_u2x8_uart0_dual_pr_ee_u4
 * m6450p_u2x8_uart0_dual_pr_ee      m6450p_u2x8_uart0_dual_pr_ee_u4
 */
static const uint64_t ur_m649_u2x8_uart0_dual_pr_ee[] = {
  0xeeeeef07a243359b, 0x77777756242b57e6, 0x5875f3ed26685b77, 0x5f1abc791fdd816f, 0xf0cc2987cd754035,
  0x0904c15de4a33770, 0x460aa40592609f18, 0xa18369181bbafb26, 0x9404a774f8971030, 0x019b386ed4c9b7f9,
  0x49034b537a8e63fb, 0x2bfcfdf0450a4890, 0xe32189f5c3e14431, 0xb41d2a2195672f4c, 0xe80e784c5162a10c,
  0xb0de579096dfabff, 0xa7c25befffaa9260, 0x90da37b5472937db, 0xa8f2b5f7355ad1c8, 0x752bd47c1b3060a7,
  0x148b34eb422877c5, 0x54b9a426be8c2cb1, 0x28f7b39d5a5cca5c, 0xc6ab5d0ebd44bb44, 0x98b84845022a3e7a,
  0x46c11fadc37b2fa5, 0x9ddc54940213fac5, 0xdf81895af64fe2af, 0x80ef5af3c0809c2c, 0x4a7400b79bcd9141,
  0xc67440ef9537a94e, 0xbd8aaa2d3574e31b, 0x6e52d4bf36dce455, 0xccdfc1ddc68b224c, 0x1ef79430a9cfd4ea,
  0xd871fc65f989ffde, 0x3d17f81fbf619a3e, 0x9c6592e19e985f1a, 0x9a19961d252d9c38, 0xac810bd71f3c95fb,
  0x0000000000000000,
};

/*
 * m649_u2x8_uart0_dual_pr_ce_u4     m649a_u2x8_uart0_dual_pr_ce       m649a_u2x8_uart0_dual_pr_ce_u4
 * m649p_u2x8_uart0_dual_pr_ce       m649p_u2x8_uart0_dual_pr_ce_u4    m6490_u2x8_uart0_dual_pr_ce
 * m6490_u2x8_uart0_dual_pr_ce_u4    m6490a_u2x8_uart0_dual_pr_ce      m6490a_u2x8_uart0_dual_pr_ce_u4
 * m6490p_u2x8_uart0_dual_pr_ce      m6490p_u2x8_uart0_dual_pr_ce_u4   m645_u2x8_uart0_dual_pr_ce
 * m645_u2x8_uart0_dual_pr_ce_u4     m645a_u2x8_uart0_dual_pr_ce       m645a_u2x8_uart0_dual_pr_ce_u4
 * m645p_u2x8_uart0_dual_pr_ce       m645p_u2x8_uart0_dual_pr_ce_u4    m6450_u2x8_uart0_dual_pr_ce
 * m6450_u2x8_uart0_dual_pr_ce_u4    m6450a_u2x8_uart0_dual_pr_ce      m6450a_u2x8_uart0_dual_pr_ce_u4
 * m6450p_u2x8_uart0_dual_pr_ce      m6450p_u2x8_uart0_dual_pr_ce_u4
 */
static const uint64_t ur_m649_u2x8_uart0_dual_pr_ce[] = {
  0xddddde0f448687e1, 0xeeeeead63ec5efcd, 0x2c45a8ed6badeeee, 0xe55ff6b7776e0c0b, 0xdc57b782eeda3e3a,
  0xc602413057792b05, 0x9323055202919827, 0x1850c1b48c0ddd7d, 0xfcca0253ba7c4b88, 0x1d87579c287e6e9f,
  0x241240f674dea39c, 0x0c4aff3f7c114292, 0xd33978627d70f851, 0x432d05f6886559cb, 0xbffa039e1307b8a8,
  0x4c161bcaf212dbe9, 0xfb74f848a5fff552, 0xb2fa1b46f6a8e526, 0x3cf1e6e7695a317e, 0xf097e21b0911759c,
  0x993170f5bf003f51, 0xd471bf3dcb3abd4b, 0x283e52438920752f, 0xed6b23afe7316028, 0xaa01ffb33c75e00c,
  0xaa4e81e5adc21d21, 0xd7b27f157ceee2a4, 0x9e0404e166fc0c4a, 0xbcde6c8a0c077ad7, 0x7ca9bd4a7253a005,
  0x69aba718de33a207, 0xf36dce18edec5551, 0xdc68b224c6e52d4b, 0x0a9cfd4eaccdfc1d, 0x5f989ffde1ef7943,
  0xfbf619a3ed871fc6, 0x19e985f1a3d17f81, 0xd252d9c389c6592e, 0x71f3c95fb9a19961, 0x000000006923cdbd,
};

/*
 * m649a_u2x8_uart0_dual_pr_ee_ce    m649p_u2x8_uart0_dual_pr_ee_ce    m6490_u2x8_uart0_dual_pr_ee_ce
 * m6490a_u2x8_uart0_dual_pr_ee_ce   m6490p_u2x8_uart0_dual_pr_ee_ce   m645_u2x8_uart0_dual_pr_ee_ce
 * m645a_u2x8_uart0_dual_pr_ee_ce    m645p_u2x8_uart0_dual_pr_ee_ce    m6450_u2x8_uart0_dual_pr_ee_ce
 * m6450a_u2x8_uart0_dual_pr_ee_ce   m6450p_u2x8_uart0_dual_pr_ee_ce
 */
static const uint64_t ur_m649_u2x8_uart0_dual_pr_ee_ce[] = {
  0xeeeeef07d41432db, 0xbbbbbab0dbc997e6, 0xaae2162afdf71bbb, 0x9bad32024775056c, 0x8e08ab38fe6740f8,
  0xc048260aef25d93b, 0x6460aa4771f304f8, 0x0a18369181bbafb2, 0x99404a774f897103, 0xec2001c0524dfaff,
  0x82481cedcdea3d6f, 0x895fe7ef82285244, 0xce2a444fae1f0a21, 0xcb42dd22195672f4, 0xfe80e784ca7a2a10,
  0x0586f2bc84b6fa6b, 0xdd3e120b5ffd5493, 0xee86d1bdaa3949be, 0xc79b9dc72b1fd51f, 0xd339d61ee4492bf3,
  0x51e56fe4a76b02cd, 0xe037a8f83660d7cf, 0x291669d68450298a, 0xca1d484d7d185962, 0xbb4428f7b39d5db8,
  0x7cf58d578d8ebd44, 0x5f4b3170908a0454, 0xfac546c1132386f6, 0xe2af9ddc5494b313, 0x9c2cdf81895af64f,
  0x914180ef5af3c080, 0xa94e4a7400b79bcd, 0xe31bc